# Generated by Django 2.2.7 on 2020-08-23 18:15

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=32)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('expires', models.DateTimeField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=32, unique=True)),
                ('ldap_group', models.CharField(blank=True, max_length=32)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('description', models.CharField(blank=True, default='', max_length=1024)),
            ],
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=32)),
                ('units', models.CharField(max_length=32)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('charge_rate', models.FloatField(blank=True, default=0)),
                ('description', models.CharField(blank=True, default='', max_length=1024)),
            ],
        ),
        migrations.CreateModel(
            name='System',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=32, unique=True)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('description', models.CharField(blank=True, default='', max_length=1024)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=32, unique=True)),
                ('realname', models.CharField(blank=True, max_length=128)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('projects', models.ManyToManyField(blank=True, to='openacct.Project')),
            ],
        ),
        migrations.CreateModel(
            name='UserProjectEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('event_type', models.CharField(choices=[('ADDED', 'ADDED'), ('REMOVED', 'REMOVED')], max_length=16)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.User')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.Project')),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('active', models.BooleanField(blank=True, default=True)),
                ('amt_used', models.FloatField()),
                ('amt_charged', models.FloatField(blank=True, default=0.0)),
                ('tx_type', models.CharField(choices=[('AUDIT', 'AUDIT'), ('CREDIT', 'CREDIT'), ('DEBIT', 'DEBIT'), ('GRANT', 'GRANT'), ('REVOKE', 'REVOKE')], max_length=16)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.Account')),
                ('creator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.User')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.Service')),
            ],
        ),
        migrations.CreateModel(
            name='StorageCommitment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dir_type', models.CharField(choices=[('HOME', 'Home Directory'), ('PROJECT', 'Project Space'), ('SCRATCH', 'Scratch Space'), ('TEMP', 'Temporary Space')], max_length=16)),
                ('filesystem', models.CharField(max_length=64)),
                ('path', models.CharField(max_length=256)),
                ('commitment', models.BigIntegerField(blank=True, default=0, null=True)),
                ('registered', models.DateTimeField(auto_now_add=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('reclaimed', models.DateTimeField(blank=True, null=True)),
                ('uid', models.IntegerField(blank=True, default=0)),
                ('gid', models.IntegerField(blank=True, default=0)),
                ('pid', models.IntegerField(blank=True, default=0)),
                ('permissions', models.CharField(default='0700', max_length=8)),
                ('is_purged', models.BooleanField(blank=True, default=True)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.Project')),
                ('transactions', models.ManyToManyField(blank=True, to='openacct.Transaction')),
            ],
        ),        
        migrations.AddField(
            model_name='account',
            name='services',
            field=models.ManyToManyField(blank=True, to='openacct.Service'),
        ),
        migrations.AddField(
            model_name='service',
            name='system',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.System'),
        ),
        migrations.AddField(
            model_name='project',
            name='pi',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.User'),
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('queued', models.DateTimeField()),
                ('started', models.DateTimeField(blank=True, null=True)),
                ('completed', models.DateTimeField(blank=True, null=True)),
                ('jobid', models.CharField(max_length=32, unique=True)),
                ('name', models.CharField(blank=True, default='', max_length=64)),
                ('submit_host', models.CharField(blank=True, default='', max_length=64)),
                ('host_list', models.CharField(blank=True, default='', max_length=1024)),
                ('qos', models.CharField(blank=True, default='', max_length=64)),
                ('job_script', models.TextField(blank=True, default='')),
                ('wall_requested', models.IntegerField()),
                ('wall_duration', models.IntegerField(blank=True)),
                ('transactions', models.ManyToManyField(blank=True, to='openacct.Transaction')),
            ],
        ),
        migrations.AddField(
            model_name='account',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openacct.Project'),
        ),
    ]
