"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sqsQueueUrl = exports.stateMachineUrl = exports.s3ObjectUrl = exports.logGroupUrl = exports.lambdaSearchLogGroupUrl = exports.lambdaFunctionUrl = exports.ecsClusterUrl = exports.codeArtifactRepositoryUrl = void 0;
const core_1 = require("@aws-cdk/core");
function codeArtifactRepositoryUrl(repository) {
    return `/codesuite/codeartifact/d/${repository.attrDomainOwner}/${repository.attrDomainName}/r/${repository.attrName}`;
}
exports.codeArtifactRepositoryUrl = codeArtifactRepositoryUrl;
function ecsClusterUrl(cluster) {
    return `/ecs/home#/clusters/${cluster.clusterName}/tasks`;
}
exports.ecsClusterUrl = ecsClusterUrl;
function lambdaFunctionUrl(lambda) {
    return `/lambda/home#/functions/${lambda.functionName}`;
}
exports.lambdaFunctionUrl = lambdaFunctionUrl;
function lambdaSearchLogGroupUrl(lambda) {
    return `/cloudwatch/home#logsV2:log-groups/log-group/$252Faws$252flambda$252f${lambda.functionName}/log-events`;
}
exports.lambdaSearchLogGroupUrl = lambdaSearchLogGroupUrl;
function logGroupUrl(logGroup) {
    return `/cloudwatch/home#logsV2:log-groups/log-group/${core_1.Fn.join('%252', core_1.Fn.split('/', logGroup.logGroupName))}`;
}
exports.logGroupUrl = logGroupUrl;
function s3ObjectUrl(bucket, objectKey) {
    if (objectKey) {
        return `/s3/object/${bucket.bucketName}?prefix=${objectKey}`;
    }
    else {
        return `/s3/buckets/${bucket.bucketName}`;
    }
}
exports.s3ObjectUrl = s3ObjectUrl;
function stateMachineUrl(stateMachine) {
    return `/states/home#/statemachines/view/${stateMachine.stateMachineArn}`;
}
exports.stateMachineUrl = stateMachineUrl;
function sqsQueueUrl(queue) {
    const stack = core_1.Stack.of(queue);
    // We can't use the Queue URL as-is, because we can't "easily" URL-encode it in CFN...
    return `/sqs/v2/home#/queues/https%3A%2F%2Fsqs.${stack.region}.amazonaws.com%2F${stack.account}%2F${queue.queueName}`;
}
exports.sqsQueueUrl = sqsQueueUrl;
//# sourceMappingURL=data:application/json;base64,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