"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTagApplicable = void 0;
const package_tag_1 = require("../../package-tag");
/**
 * Extract value at nested key from JSON object
 */
function getNestedField(path, pkg) {
    return path === null || path === void 0 ? void 0 : path.reduce((accum, key) => (accum ? accum[key] : undefined), pkg);
}
/**
 * Create a function that combines conditions using && or || logic.
 */
const createBoolCombinator = (combine, initial) => (config, pkg) => { var _a, _b; return (_b = (_a = config === null || config === void 0 ? void 0 : config.children) === null || _a === void 0 ? void 0 : _a.reduce((accum, cond) => combine(accum, isTagApplicable(cond, pkg)), initial)) !== null && _b !== void 0 ? _b : true; };
/**
 * Create a function that checks nested value against predicate.
 */
const createFieldComparator = (compare) => (config, pkg) => compare(getNestedField(config === null || config === void 0 ? void 0 : config.key, pkg), config === null || config === void 0 ? void 0 : config.value);
/**
 * Negate and recurse for `not` functionality.
 */
const not = (config, pkg) => {
    var _a;
    const cond = (_a = config === null || config === void 0 ? void 0 : config.children) === null || _a === void 0 ? void 0 : _a[0];
    if (!cond) {
        throw new Error('NOT logical operator requires a single condition');
    }
    return !isTagApplicable(cond, pkg);
};
/**
 * Checks whether a tag's condition applies to a package by computing declared
 * logic and running against the package.json. Recursively constructs chains of
 * `&&` and `||` conditions to allow arbitrary combinations.
 */
function isTagApplicable(config, pkg) {
    var _a;
    const fnMap = {
        [package_tag_1.TagConditionLogicType.AND]: createBoolCombinator((field, val) => field && val, true),
        [package_tag_1.TagConditionLogicType.OR]: createBoolCombinator((field, val) => field || val, false),
        [package_tag_1.TagConditionLogicType.EQUALS]: createFieldComparator((field, val) => field === val),
        [package_tag_1.TagConditionLogicType.INCLUDES]: createFieldComparator((field, val) => field.includes(val)),
        [package_tag_1.TagConditionLogicType.STARTS_WITH]: createFieldComparator((field, val) => field.startsWith(val)),
        [package_tag_1.TagConditionLogicType.NOT]: not,
    };
    const fn = (_a = fnMap[config.type]) !== null && _a !== void 0 ? _a : (() => false);
    return fn(config, pkg);
}
exports.isTagApplicable = isTagApplicable;
//# sourceMappingURL=data:application/json;base64,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