import type { Context, SQSEvent } from 'aws-lambda';
export declare const handler: (event: SQSEvent, context: Context) => Promise<string[] | undefined>;
declare const enum ConstructFrameworkName {
    AWS_CDK = "aws-cdk",
    CDK8S = "cdk8s",
    CDKTF = "cdktf"
}
export interface ConstructFramework {
    /**
     * The name of the construct framework.
     */
    readonly name: ConstructFrameworkName;
    /**
     * The major version of the construct framework that is used, if it could be
     * identified.
     */
    readonly majorVersion?: number;
}
export {};
