
/******************************************************************************
 *                                                                            *
 * This file is part of the simulation tool PROPOSAL.                         *
 *                                                                            *
 * Copyright (C) 2017 TU Dortmund University, Department of Physics,          *
 *                    Chair Experimental Physics 5b                           *
 *                                                                            *
 * This software may be modified and distributed under the terms of a         *
 * modified GNU Lesser General Public Licence version 3 (LGPL),               *
 * copied verbatim in the file "LICENSE".                                     *
 *                                                                            *
 * Modifcations to the LGPL License:                                          *
 *                                                                            *
 *      1. The user shall acknowledge the use of PROPOSAL by citing the       *
 *         following reference:                                               *
 *                                                                            *
 *         J.H. Koehne et al.  Comput.Phys.Commun. 184 (2013) 2070-2090 DOI:  *
 *         10.1016/j.cpc.2013.04.001                                          *
 *                                                                            *
 *      2. The user should report any bugs/errors or improvments to the       *
 *         current maintainer of PROPOSAL or open an issue on the             *
 *         GitHub webpage                                                     *
 *                                                                            *
 *         "https://github.com/tudo-astroparticlephysics/PROPOSAL"            *
 *                                                                            *
 ******************************************************************************/


#pragma once

namespace PROPOSAL {

class Utility;
class UtilityDecorator;
struct InterpolationDef;

/**
 * \brief Class containing the functions to randomize the continuous energy losses
 *
 */
class ContinuousRandomizer
{
public:
    ContinuousRandomizer(const Utility&);
    ContinuousRandomizer(const Utility&, const InterpolationDef);

    // Copy constructors
    ContinuousRandomizer(const Utility&, const ContinuousRandomizer&);
    ContinuousRandomizer(const ContinuousRandomizer&);

    ~ContinuousRandomizer();

    bool operator==(const ContinuousRandomizer&) const;
    bool operator!=(const ContinuousRandomizer&) const;

    double Randomize(double ei, double ef, double rnd);

private:
    ContinuousRandomizer& operator=(const ContinuousRandomizer&); // Undefined & not allowed

    UtilityDecorator* DE2de;
};

} // namespace PROPOSAL
