
#include "PROPOSAL/crossection/parametrization/ParamTables.h"

// Weak interaction

const std::vector<double> PROPOSAL::energies = {
        4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9,
        5.0, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9,
        6.0, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9,
        7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9,
        8.0, 8.1, 8.2, 8.3, 8.4, 8.5, 8.6, 8.7, 8.8, 8.9,
        9.0, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9,
        10.0, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9,
        11.0, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9,
        12.0, 12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9,
        13.0, 13.1, 13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9,
        14.0, 14.1, 14.2, 14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9,
        15.0
};

const std::vector< std::vector<double> > PROPOSAL::y_nu_p = {
{0.05244  , 0.0540251, 0.0556581, 0.0573405, 0.0590737, 0.0608592,
 0.0626988, 0.064594 , 0.0665464, 0.0685579, 0.0706301, 0.072765 ,
 0.0749645, 0.0772304, 0.0795648, 0.0819697, 0.0844474, 0.0869999,
 0.0896296, 0.0923388, 0.0951299, 0.0980053, 0.100968 , 0.10402  ,
 0.107164 , 0.110403 , 0.11374  , 0.117178 , 0.12072  , 0.124369 ,
 0.128128 , 0.132001 , 0.135991 , 0.140101 , 0.144336 , 0.148699 ,
 0.153193 , 0.157824 , 0.162594 , 0.167509 , 0.172572 , 0.177788 ,
 0.183162 , 0.188699 , 0.194402 , 0.200279 , 0.206332 , 0.212569 ,
 0.218994 , 0.225614 , 0.232433 , 0.239459 , 0.246697 , 0.254153 ,
 0.261836 , 0.26975  , 0.277904 , 0.286304 , 0.294958 , 0.303873 ,
 0.313058 , 0.322521 , 0.332269 , 0.342313 , 0.35266  , 0.363319 ,
 0.374301 , 0.385615 , 0.397271 , 0.409279 , 0.42165  , 0.434395 ,
 0.447525 , 0.461052 , 0.474988 , 0.489345 , 0.504136 , 0.519375 ,
 0.535073 , 0.551247 , 0.567909 , 0.585075 , 0.60276  , 0.620979 ,
 0.639749 , 0.659086 , 0.679008 , 0.699532 , 0.720676 , 0.74246  ,
 0.764902 , 0.788022 , 0.811841 , 0.83638  , 0.861661 , 0.887706 ,
 0.914538 , 0.942182 , 0.97066  , 1.       }
,
{0.0421351, 0.0435047, 0.0449189, 0.046379 , 0.0478866, 0.0494432,
 0.0510504, 0.0527098, 0.0544232, 0.0561923, 0.0580188, 0.0599048,
 0.061852 , 0.0638626, 0.0659385, 0.0680818, 0.0702949, 0.0725799,
 0.0749392, 0.0773751, 0.0798902, 0.0824871, 0.0851684, 0.0879369,
 0.0907954, 0.0937467, 0.0967941, 0.0999404, 0.103189 , 0.106543 ,
 0.110007 , 0.113582 , 0.117274 , 0.121087 , 0.125023 , 0.129087 ,
 0.133283 , 0.137615 , 0.142088 , 0.146707 , 0.151476 , 0.1564   ,
 0.161484 , 0.166733 , 0.172153 , 0.177748 , 0.183526 , 0.189492 ,
 0.195652 , 0.202011 , 0.208578 , 0.215358 , 0.222358 , 0.229586 ,
 0.237049 , 0.244755 , 0.25271  , 0.260925 , 0.269407 , 0.278164 ,
 0.287206 , 0.296542 , 0.306181 , 0.316134 , 0.32641  , 0.33702  ,
 0.347975 , 0.359286 , 0.370965 , 0.383024 , 0.395474 , 0.408329 ,
 0.421602 , 0.435307 , 0.449457 , 0.464067 , 0.479152 , 0.494727 ,
 0.510808 , 0.527412 , 0.544556 , 0.562258 , 0.580534 , 0.599405 ,
 0.618889 , 0.639006 , 0.659778 , 0.681224 , 0.703368 , 0.726232 ,
 0.749838 , 0.774212 , 0.799379 , 0.825363 , 0.852192 , 0.879893 ,
 0.908495 , 0.938026 , 0.968518 , 1.       }
,
{0.0337935, 0.0349698, 0.0361871, 0.0374467, 0.0387502, 0.0400991,
 0.0414949, 0.0429393, 0.044434 , 0.0459807, 0.0475812, 0.0492375,
 0.0509514, 0.052725 , 0.0545603, 0.0564595, 0.0584248, 0.0604585,
 0.062563 , 0.0647408, 0.0669944, 0.0693264, 0.0717396, 0.0742368,
 0.0768209, 0.079495 , 0.0822621, 0.0851256, 0.0880888, 0.0911551,
 0.0943281, 0.0976116, 0.101009 , 0.104525 , 0.108164 , 0.111929 ,
 0.115825 , 0.119857 , 0.124029 , 0.128346 , 0.132814 , 0.137437 ,
 0.142221 , 0.147172 , 0.152295 , 0.157596 , 0.163082 , 0.168759 ,
 0.174633 , 0.180712 , 0.187002 , 0.193512 , 0.200247 , 0.207218 ,
 0.214431 , 0.221895 , 0.229619 , 0.237612 , 0.245883 , 0.254442 ,
 0.263299 , 0.272464 , 0.281949 , 0.291763 , 0.301919 , 0.312429 ,
 0.323304 , 0.334558 , 0.346204 , 0.358255 , 0.370725 , 0.38363  ,
 0.396984 , 0.410802 , 0.425102 , 0.439899 , 0.455212 , 0.471058 ,
 0.487455 , 0.504423 , 0.521981 , 0.540151 , 0.558953 , 0.57841  ,
 0.598544 , 0.619379 , 0.640939 , 0.663249 , 0.686336 , 0.710227 ,
 0.73495  , 0.760533 , 0.787006 , 0.814401 , 0.84275  , 0.872085 ,
 0.902442 , 0.933855 , 0.966362 , 1.       }
,
{0.0270634, 0.0280684, 0.0291106, 0.0301916, 0.0313127, 0.0324755,
 0.0336814, 0.0349321, 0.0362292, 0.0375745, 0.0389698, 0.0404168,
 0.0419176, 0.0434742, 0.0450885, 0.0467628, 0.0484992, 0.0503002,
 0.052168 , 0.0541051, 0.0561142, 0.0581979, 0.060359 , 0.0626003,
 0.0649249, 0.0673357, 0.0698361, 0.0724294, 0.0751189, 0.0779083,
 0.0808013, 0.0838017, 0.0869135, 0.0901409, 0.0934881, 0.0969596,
 0.10056  , 0.104294 , 0.108167 , 0.112183 , 0.116349 , 0.12067  ,
 0.12515  , 0.129798 , 0.134617 , 0.139616 , 0.144801 , 0.150178 ,
 0.155754 , 0.161538 , 0.167536 , 0.173757 , 0.180209 , 0.186901 ,
 0.193841 , 0.201039 , 0.208505 , 0.216247 , 0.224277 , 0.232605 ,
 0.241242 , 0.250201 , 0.259491 , 0.269127 , 0.279121 , 0.289485 ,
 0.300235 , 0.311383 , 0.322946 , 0.334938 , 0.347375 , 0.360274 ,
 0.373653 , 0.387527 , 0.401918 , 0.416842 , 0.432321 , 0.448374 ,
 0.465024 , 0.482292 , 0.500201 , 0.518775 , 0.538038 , 0.558017 ,
 0.578738 , 0.600229 , 0.622517 , 0.645633 , 0.669607 , 0.694472 ,
 0.72026  , 0.747006 , 0.774744 , 0.803513 , 0.83335  , 0.864295 ,
 0.896389 , 0.929675 , 0.964196 , 1.       }
,
{0.0216481, 0.0225026, 0.0233909, 0.0243142, 0.025274 , 0.0262717,
 0.0273088, 0.0283868, 0.0295074, 0.0306722, 0.0318829, 0.0331415,
 0.0344498, 0.0358097, 0.0372232, 0.0386926, 0.04022  , 0.0418077,
 0.043458 , 0.0451735, 0.0469567, 0.0488103, 0.0507371, 0.05274  ,
 0.0548218, 0.0569859, 0.0592354, 0.0615737, 0.0640043, 0.0665309,
 0.0691572, 0.0718872, 0.0747249, 0.0776746, 0.0807408, 0.083928 ,
 0.0872411, 0.0906849, 0.0942647, 0.0979858, 0.101854 , 0.105874 ,
 0.110054 , 0.114398 , 0.118914 , 0.123608 , 0.128487 , 0.133559 ,
 0.138832 , 0.144312 , 0.150009 , 0.15593  , 0.162086 , 0.168484 ,
 0.175135 , 0.182048 , 0.189234 , 0.196704 , 0.204469 , 0.212541 ,
 0.220931 , 0.229652 , 0.238717 , 0.248141 , 0.257936 , 0.268118 ,
 0.278702 , 0.289703 , 0.301139 , 0.313027 , 0.325383 , 0.338228 ,
 0.351579 , 0.365458 , 0.379884 , 0.39488  , 0.410468 , 0.426671 ,
 0.443514 , 0.461021 , 0.47922  , 0.498137 , 0.517801 , 0.538241 ,
 0.559488 , 0.581574 , 0.604531 , 0.628395 , 0.653201 , 0.678985 ,
 0.705788 , 0.733649 , 0.76261  , 0.792714 , 0.824006 , 0.856533 ,
 0.890345 , 0.925491 , 0.962024 , 1.       }
,
{0.0172999, 0.0180236, 0.0187775, 0.019563 , 0.0203814, 0.021234 ,
 0.0221222, 0.0230476, 0.0240117, 0.0250162, 0.0260627, 0.0271529,
 0.0282887, 0.0294721, 0.030705 , 0.0319894, 0.0333276, 0.0347217,
 0.0361742, 0.0376874, 0.039264 , 0.0409064, 0.0426176, 0.0444004,
 0.0462577, 0.0481928, 0.0502087, 0.0523091, 0.0544972, 0.0567769,
 0.059152 , 0.0616264, 0.0642044, 0.0668901, 0.0696883, 0.0726034,
 0.0756406, 0.0788047, 0.0821013, 0.0855357, 0.0891138, 0.0928416,
 0.0967253, 0.100771 , 0.104987 , 0.109379 , 0.113954 , 0.118721 ,
 0.123687 , 0.128861 , 0.134252 , 0.139868 , 0.145719 , 0.151814 ,
 0.158165 , 0.164781 , 0.171674 , 0.178856 , 0.186338 , 0.194133 ,
 0.202253 , 0.210714 , 0.219528 , 0.228712 , 0.238279 , 0.248247 ,
 0.258631 , 0.26945  , 0.280722 , 0.292465 , 0.304699 , 0.317445 ,
 0.330724 , 0.344559 , 0.358973 , 0.373989 , 0.389634 , 0.405933 ,
 0.422914 , 0.440605 , 0.459036 , 0.478238 , 0.498244 , 0.519086 ,
 0.5408   , 0.563423 , 0.586992 , 0.611546 , 0.637128 , 0.663781 ,
 0.691548 , 0.720476 , 0.750615 , 0.782014 , 0.814727 , 0.848809 ,
 0.884316 , 0.921308 , 0.959848 , 1.       }
,
{0.0138146, 0.0144252, 0.0150628, 0.0157286, 0.0164239, 0.0171498,
 0.0179079, 0.0186995, 0.019526 , 0.0203891, 0.0212903, 0.0222314,
 0.0232141, 0.0242402, 0.0253116, 0.0264305, 0.0275987, 0.0288187,
 0.0300925, 0.0314226, 0.0328116, 0.0342619, 0.0357764, 0.0373577,
 0.039009 , 0.0407333, 0.0425338, 0.0444139, 0.046377 , 0.048427 ,
 0.0505675, 0.0528027, 0.0551367, 0.0575738, 0.0601187, 0.0627761,
 0.0655509, 0.0684484, 0.0714739, 0.0746332, 0.0779321, 0.0813769,
 0.0849739, 0.0887299, 0.0926519, 0.0967473, 0.101024 , 0.105489 ,
 0.110152 , 0.115021 , 0.120105 , 0.125414 , 0.130957 , 0.136746 ,
 0.14279  , 0.149102 , 0.155693 , 0.162574 , 0.169761 , 0.177264 ,
 0.1851   , 0.193281 , 0.201825 , 0.210746 , 0.220061 , 0.229788 ,
 0.239946 , 0.250552 , 0.261626 , 0.273191 , 0.285266 , 0.297876 ,
 0.311042 , 0.324791 , 0.339147 , 0.354138 , 0.369792 , 0.386137 ,
 0.403205 , 0.421028 , 0.439638 , 0.459071 , 0.479363 , 0.500551 ,
 0.522677 , 0.54578  , 0.569904 , 0.595095 , 0.621399 , 0.648866 ,
 0.677548 , 0.707496 , 0.738769 , 0.771424 , 0.805522 , 0.841128 ,
 0.878308 , 0.91713  , 0.957669 , 1.       }
,
{0.0110248, 0.0115383, 0.0120758, 0.0126384, 0.0132271, 0.0138433,
 0.0144882, 0.0151631, 0.0158694, 0.0166087, 0.0173824, 0.0181921,
 0.0190396, 0.0199265, 0.0208548, 0.0218263, 0.022843 , 0.0239072,
 0.0250208, 0.0261864, 0.0274063, 0.028683 , 0.0300191, 0.0314175,
 0.0328811, 0.0344128, 0.0360159, 0.0376937, 0.0394496, 0.0412873,
 0.0432106, 0.0452235, 0.0473302, 0.0495351, 0.0518426, 0.0542576,
 0.0567852, 0.0594304, 0.0621989, 0.0650964, 0.0681288, 0.0713026,
 0.0746241, 0.0781004, 0.0817386, 0.0855463, 0.0895314, 0.0937021,
 0.0980671, 0.102635 , 0.107417 , 0.112421 , 0.117658 , 0.123138 ,
 0.128875 , 0.134878 , 0.141161 , 0.147737 , 0.154619 , 0.161822 ,
 0.16936  , 0.17725  , 0.185507 , 0.194149 , 0.203193 , 0.212658 ,
 0.222565 , 0.232933 , 0.243784 , 0.25514  , 0.267025 , 0.279464 ,
 0.292483 , 0.306108 , 0.320368 , 0.335292 , 0.350911 , 0.367258 ,
 0.384366 , 0.402271 , 0.421011 , 0.440623 , 0.461149 , 0.482631 ,
 0.505114 , 0.528644 , 0.55327  , 0.579044 , 0.606018 , 0.634249 ,
 0.663794 , 0.694716 , 0.727079 , 0.760949 , 0.796397 , 0.833497 ,
 0.872324 , 0.91296  , 0.95549  , 1.       }
,
{0.00879407, 0.00922477, 0.00967657, 0.0101505 , 0.0106476 , 0.0111691 ,
 0.0117161 , 0.01229   , 0.0128919 , 0.0135233 , 0.0141856 , 0.0148804 ,
 0.0156091 , 0.0163736 , 0.0171755 , 0.0180167 , 0.0188991 , 0.0198248 ,
 0.0207957 , 0.0218142 , 0.0228826 , 0.0240033 , 0.0251789 , 0.0264121 ,
 0.0277056 , 0.0290626 , 0.0304859 , 0.031979  , 0.0335453 , 0.0351882 ,
 0.0369116 , 0.0387194 , 0.0406157 , 0.0426049 , 0.0446916 , 0.0468804 ,
 0.0491764 , 0.0515849 , 0.0541114 , 0.0567616 , 0.0595416 , 0.0624577 ,
 0.0655167 , 0.0687254 , 0.0720914 , 0.0756221 , 0.0793259 , 0.083211  ,
 0.0872863 , 0.0915613 , 0.0960457 , 0.10075   , 0.105684  , 0.11086   ,
 0.11629   , 0.121985  , 0.127959  , 0.134226  , 0.1408    , 0.147696  ,
 0.15493   , 0.162518  , 0.170477  , 0.178827  , 0.187585  , 0.196772  ,
 0.20641   , 0.216519  , 0.227123  , 0.238247  , 0.249915  , 0.262155  ,
 0.274995  , 0.288463  , 0.302591  , 0.317411  , 0.332957  , 0.349264  ,
 0.366369  , 0.384313  , 0.403135  , 0.422879  , 0.44359   , 0.465316  ,
 0.488105  , 0.512011  , 0.537088  , 0.563392  , 0.590985  , 0.61993   ,
 0.650292  , 0.682141  , 0.71555   , 0.750595  , 0.787356  , 0.825918  ,
 0.866369  , 0.9088    , 0.95331   , 1.        }
,
{0.00701202, 0.00737229, 0.00775106, 0.0081493 , 0.008568  , 0.00900822,
 0.00947105, 0.00995766, 0.0104693 , 0.0110072 , 0.0115727 , 0.0121673 ,
 0.0127924 , 0.0134497 , 0.0141407 , 0.0148672 , 0.0156311 , 0.0164342 ,
 0.0172786 , 0.0181663 , 0.0190997 , 0.020081  , 0.0211127 , 0.0221975 ,
 0.023338  , 0.024537  , 0.0257977 , 0.0271232 , 0.0285167 , 0.0299819 ,
 0.0315223 , 0.0331419 , 0.0348447 , 0.0366349 , 0.0385172 , 0.0404961 ,
 0.0425768 , 0.0447643 , 0.0470642 , 0.0494823 , 0.0520247 , 0.0546976 ,
 0.0575079 , 0.0604626 , 0.0635691 , 0.0668352 , 0.0702691 , 0.0738794 ,
 0.0776753 , 0.0816661 , 0.085862  , 0.0902735 , 0.0949116 , 0.0997881 ,
 0.104915  , 0.110305  , 0.115973  , 0.121931  , 0.128196  , 0.134783  ,
 0.141707  , 0.148988  , 0.156643  , 0.164691  , 0.173153  , 0.182049  ,
 0.191403  , 0.201237  , 0.211576  , 0.222446  , 0.233875  , 0.245891  ,
 0.258525  , 0.271808  , 0.285773  , 0.300455  , 0.315892  , 0.332123  ,
 0.349187  , 0.367127  , 0.38599   , 0.405822  , 0.426672  , 0.448594  ,
 0.471642  , 0.495874  , 0.521352  , 0.548138  , 0.576301  , 0.60591   ,
 0.637041  , 0.669772  , 0.704184  , 0.740364  , 0.778402  , 0.818396  ,
 0.860444  , 0.904652  , 0.951132  , 1.        }
,
{0.00558937, 0.00589002, 0.00620684, 0.0065407 , 0.00689252, 0.00726327,
 0.00765396, 0.00806566, 0.00849951, 0.00895669, 0.00943847, 0.00994616,
 0.0104812 , 0.0110449 , 0.011639  , 0.0122651 , 0.0129248 , 0.0136201 ,
 0.0143527 , 0.0151247 , 0.0159383 , 0.0167956 , 0.017699  , 0.018651  ,
 0.0196542 , 0.0207114 , 0.0218255 , 0.0229995 , 0.0242366 , 0.0255403 ,
 0.0269141 , 0.0283618 , 0.0298874 , 0.031495  , 0.0331891 , 0.0349743 ,
 0.0368556 , 0.038838  , 0.0409271 , 0.0431286 , 0.0454484 , 0.0478931 ,
 0.0504693 , 0.053184  , 0.0560447 , 0.0590593 , 0.0622361 , 0.0655838 ,
 0.0691115 , 0.072829  , 0.0767464 , 0.0808746 , 0.0852248 , 0.089809  ,
 0.0946398 , 0.0997304 , 0.105095  , 0.110748  , 0.116705  , 0.122983  ,
 0.129598  , 0.136569  , 0.143915  , 0.151656  , 0.159813  , 0.16841   ,
 0.177468  , 0.187014  , 0.197074  , 0.207674  , 0.218845  , 0.230617  ,
 0.243021  , 0.256093  , 0.269868  , 0.284385  , 0.299682  , 0.315801  ,
 0.332788  , 0.350689  , 0.369552  , 0.38943   , 0.410377  , 0.432451  ,
 0.455713  , 0.480225  , 0.506057  , 0.533277  , 0.561962  , 0.59219   ,
 0.624043  , 0.65761   , 0.692983  , 0.730258  , 0.769539  , 0.810932  ,
 0.854552  , 0.900518  , 0.948956  , 1.        }
,
{0.00445426, 0.00470463, 0.00496907, 0.00524837, 0.00554338, 0.00585497,
 0.00618407, 0.00653166, 0.0068988 , 0.00728657, 0.00769614, 0.00812873,
 0.00858564, 0.00906822, 0.00957794, 0.0101163 , 0.0106849 , 0.0112855 ,
 0.0119199 , 0.0125899 , 0.0132975 , 0.0140449 , 0.0148344 , 0.0156682 ,
 0.0165489 , 0.0174791 , 0.0184616 , 0.0194993 , 0.0205953 , 0.0217529 ,
 0.0229757 , 0.0242671 , 0.0256311 , 0.0270718 , 0.0285935 , 0.0302007 ,
 0.0318982 , 0.0336912 , 0.0355849 , 0.0375851 , 0.0396977 , 0.041929  ,
 0.0442858 , 0.0467751 , 0.0494042 , 0.0521812 , 0.0551142 , 0.0582121 ,
 0.0614842 , 0.0649401 , 0.0685903 , 0.0724457 , 0.0765177 , 0.0808187 ,
 0.0853614 , 0.0901595 , 0.0952272 , 0.10058   , 0.106233  , 0.112205  ,
 0.118511  , 0.125173  , 0.132209  , 0.13964   , 0.147489  , 0.155779  ,
 0.164535  , 0.173783  , 0.183552  , 0.193869  , 0.204766  , 0.216275  ,
 0.228432  , 0.241272  , 0.254833  , 0.269157  , 0.284286  , 0.300266  ,
 0.317143  , 0.334969  , 0.353798  , 0.373684  , 0.394688  , 0.416873  ,
 0.440305  , 0.465054  , 0.491194  , 0.518804  , 0.547965  , 0.578765  ,
 0.611297  , 0.645657  , 0.681949  , 0.72028   , 0.760766  , 0.803528  ,
 0.848693  , 0.896397  , 0.946783  , 1.        }
,
{0.00354898, 0.00375708, 0.00397738, 0.00421059, 0.00445748, 0.00471885,
 0.00499554, 0.00528846, 0.00559855, 0.00592682, 0.00627434, 0.00664224,
 0.00703171, 0.00744402, 0.0078805 , 0.00834258, 0.00883175, 0.0093496 ,
 0.00989782, 0.0104782 , 0.0110926 , 0.011743  , 0.0124316 , 0.0131605 ,
 0.0139322 , 0.0147491 , 0.0156139 , 0.0165294 , 0.0174986 , 0.0185247 ,
 0.0196109 , 0.0207608 , 0.0219781 , 0.0232668 , 0.024631  , 0.0260753 ,
 0.0276042 , 0.0292228 , 0.0309363 , 0.0327502 , 0.0346706 , 0.0367035 ,
 0.0388556 , 0.0411339 , 0.0435458 , 0.0460992 , 0.0488022 , 0.0516638 ,
 0.0546931 , 0.0579    , 0.061295  , 0.0648891 , 0.0686939 , 0.0727218 ,
 0.0769859 , 0.0815    , 0.0862787 , 0.0913377 , 0.0966934 , 0.102363  ,
 0.108365  , 0.114719  , 0.121446  , 0.128567  , 0.136105  , 0.144086  ,
 0.152534  , 0.161478  , 0.170947  , 0.18097   , 0.191582  , 0.202815  ,
 0.214707  , 0.227297  , 0.240624  , 0.254733  , 0.26967   , 0.285482  ,
 0.302221  , 0.319942  , 0.338702  , 0.358562  , 0.379587  , 0.401844  ,
 0.425406  , 0.45035   , 0.476756  , 0.504711  , 0.534305  , 0.565634  ,
 0.598801  , 0.633911  , 0.671081  , 0.71043   , 0.752087  , 0.796186  ,
 0.84287   , 0.892292  , 0.944612  , 1.        }
,
{0.00282726, 0.00299991, 0.00318312, 0.00337751, 0.00358377, 0.00380263,
 0.00403485, 0.00428126, 0.00454271, 0.00482013, 0.0051145 , 0.00542684,
 0.00575825, 0.0061099 , 0.00648303, 0.00687895, 0.00729904, 0.00774479,
 0.00821776, 0.00871961, 0.00925211, 0.00981713, 0.0104167 , 0.0110528 ,
 0.0117278 , 0.012444  , 0.0132039 , 0.0140103 , 0.0148659 , 0.0157737 ,
 0.016737  , 0.0177592 , 0.0188437 , 0.0199945 , 0.0212155 , 0.0225111 ,
 0.0238859 , 0.0253446 , 0.0268924 , 0.0285347 , 0.0302773 , 0.0321263 ,
 0.0340882 , 0.03617   , 0.0383788 , 0.0407226 , 0.0432095 , 0.0458483 ,
 0.0486482 , 0.0516191 , 0.0547715 , 0.0581163 , 0.0616655 , 0.0654313 ,
 0.0694272 , 0.0736671 , 0.0781659 , 0.0829394 , 0.0880045 , 0.0933789 ,
 0.0990814 , 0.105132  , 0.111553  , 0.118365  , 0.125594  , 0.133264  ,
 0.141402  , 0.150037  , 0.1592    , 0.168922  , 0.179238  , 0.190184  ,
 0.201798  , 0.214122  , 0.227198  , 0.241073  , 0.255796  , 0.271417  ,
 0.287992  , 0.30558   , 0.324241  , 0.344042  , 0.365053  , 0.387346  ,
 0.411001  , 0.436101  , 0.462733  , 0.490992  , 0.520977  , 0.552792  ,
 0.586551  , 0.622372  , 0.660379  , 0.700708  , 0.7435    , 0.788905  ,
 0.837083  , 0.888203  , 0.942445  , 1.        }
,
{0.00225202, 0.00239505, 0.00254716, 0.00270893, 0.00288097, 0.00306395,
 0.00325854, 0.00346549, 0.00368558, 0.00391965, 0.00416859, 0.00443334,
 0.0047149 , 0.00501435, 0.00533281, 0.0056715 , 0.0060317 , 0.00641477,
 0.00682218, 0.00725546, 0.00771625, 0.00820631, 0.0087275 , 0.00928178,
 0.00987127, 0.0104982 , 0.0111649 , 0.011874  , 0.0126282 , 0.0134302 ,
 0.0142831 , 0.0151903 , 0.016155  , 0.017181  , 0.0182722 , 0.0194326 ,
 0.0206668 , 0.0219794 , 0.0233753 , 0.0248599 , 0.0264387 , 0.0281178 ,
 0.0299036 , 0.0318028 , 0.0338226 , 0.0359707 , 0.0382552 , 0.0406848 ,
 0.0432687 , 0.0460167 , 0.0489392 , 0.0520474 , 0.0553529 , 0.0588684 ,
 0.0626071 , 0.0665833 , 0.0708121 , 0.0753094 , 0.0800923 , 0.085179  ,
 0.0905887 , 0.096342  , 0.102461  , 0.108968  , 0.115889  , 0.123249  ,
 0.131076  , 0.139401  , 0.148254  , 0.15767   , 0.167684  , 0.178333  ,
 0.189659  , 0.201705  , 0.214515  , 0.228139  , 0.242628  , 0.258037  ,
 0.274426  , 0.291854  , 0.31039   , 0.330103  , 0.351068  , 0.373364  ,
 0.397077  , 0.422295  , 0.449115  , 0.477639  , 0.507974  , 0.540235  ,
 0.574546  , 0.611036  , 0.649843  , 0.691114  , 0.735007  , 0.781688  ,
 0.831333  , 0.884131  , 0.940282  , 1.        }
,
{0.00179365, 0.00191195, 0.00203806, 0.00217249, 0.00231578, 0.00246853,
 0.00263134, 0.0028049 , 0.00298991, 0.00318711, 0.00339733, 0.00362141,
 0.00386027, 0.00411489, 0.00438629, 0.00467561, 0.004984  , 0.00531273,
 0.00566315, 0.00603668, 0.00643484, 0.00685927, 0.00731169, 0.00779396,
 0.00830803, 0.00885601, 0.00944013, 0.0100628 , 0.0107265 , 0.011434  ,
 0.0121882 , 0.0129921 , 0.013849  , 0.0147624 , 0.0157361 , 0.0167741 ,
 0.0178804 , 0.0190598 , 0.0203169 , 0.021657  , 0.0230855 , 0.0246081 ,
 0.0262312 , 0.0279614 , 0.0298056 , 0.0317716 , 0.0338671 , 0.036101  ,
 0.0384821 , 0.0410203 , 0.0437259 , 0.04661   , 0.0496843 , 0.0529613 ,
 0.0564545 , 0.0601782 , 0.0641474 , 0.0683784 , 0.0728885 , 0.0776961 ,
 0.0828207 , 0.0882834 , 0.0941064 , 0.100313  , 0.10693   , 0.113983  ,
 0.121501  , 0.129515  , 0.138057  , 0.147163  , 0.15687   , 0.167217  ,
 0.178246  , 0.190003  , 0.202535  , 0.215893  , 0.230133  , 0.245312  ,
 0.261493  , 0.27874   , 0.297125  , 0.316723  , 0.337613  , 0.359882  ,
 0.383619  , 0.408921  , 0.435893  , 0.464643  , 0.49529   , 0.527958  ,
 0.562781  , 0.599901  , 0.639469  , 0.681647  , 0.726607  , 0.774533  ,
 0.825619  , 0.880076  , 0.938123  , 1.        }
,
{0.00142846, 0.00152618, 0.00163059, 0.00174215, 0.00186133, 0.00198867,
 0.00212471, 0.00227007, 0.00242537, 0.00259129, 0.00276857, 0.00295797,
 0.00316033, 0.00337654, 0.00360753, 0.00385433, 0.00411801, 0.00439973,
 0.00470073, 0.00502231, 0.0053659 , 0.00573299, 0.00612519, 0.00654423,
 0.00699193, 0.00747027, 0.00798132, 0.00852734, 0.00911071, 0.00973399,
 0.0103999 , 0.0111114 , 0.0118715 , 0.0126837 , 0.0135514 , 0.0144785 ,
 0.015469  , 0.0165272 , 0.0176579 , 0.0188659 , 0.0201566 , 0.0215355 ,
 0.0230088 , 0.0245829 , 0.0262646 , 0.0280614 , 0.0299812 , 0.0320323 ,
 0.0342236 , 0.0365649 , 0.0390664 , 0.041739  , 0.0445945 , 0.0476453 ,
 0.0509048 , 0.0543872 , 0.058108  , 0.0620833 , 0.0663305 , 0.0708683 ,
 0.0757165 , 0.0808964 , 0.0864307 , 0.0923436 , 0.098661  , 0.105411  ,
 0.112622  , 0.120327  , 0.128558  , 0.137353  , 0.14675   , 0.156789  ,
 0.167516  , 0.178976  , 0.19122   , 0.204301  , 0.218278  , 0.233211  ,
 0.249165  , 0.266211  , 0.284423  , 0.303881  , 0.32467   , 0.346881  ,
 0.370612  , 0.395966  , 0.423055  , 0.451997  , 0.482919  , 0.515956  ,
 0.551254  , 0.588966  , 0.629258  , 0.672307  , 0.718301  , 0.767441  ,
 0.819943  , 0.876037  , 0.935969  , 1.        }
,
{0.00113756, 0.00121818, 0.00130451, 0.00139696, 0.00149597, 0.00160199,
 0.00171553, 0.00183711, 0.00196731, 0.00210674, 0.00225605, 0.00241594,
 0.00258717, 0.00277052, 0.00296688, 0.00317715, 0.00340232, 0.00364345,
 0.00390167, 0.00417819, 0.0044743 , 0.00479141, 0.00513099, 0.00549463,
 0.00588405, 0.00630106, 0.00674763, 0.00722585, 0.00773797, 0.00828637,
 0.00887365, 0.00950254, 0.010176  , 0.0108972 , 0.0116695 , 0.0124966 ,
 0.0133822 , 0.0143306 , 0.0153463 , 0.0164339 , 0.0175986 , 0.0188459 ,
 0.0201815 , 0.0216118 , 0.0231435 , 0.0247837 , 0.0265402 , 0.0284212 ,
 0.0304355 , 0.0325925 , 0.0349024 , 0.037376  , 0.0400249 , 0.0428616 ,
 0.0458993 , 0.0491522 , 0.0526358 , 0.0563662 , 0.060361  , 0.0646389 ,
 0.06922   , 0.0741258 , 0.0793792 , 0.085005  , 0.0910295 , 0.097481  ,
 0.10439   , 0.111788  , 0.119711  , 0.128195  , 0.13728   , 0.14701   ,
 0.157429  , 0.168586  , 0.180534  , 0.193329  , 0.20703   , 0.221703  ,
 0.237416  , 0.254242  , 0.27226   , 0.291556  , 0.312219  , 0.334347  ,
 0.358043  , 0.383418  , 0.410592  , 0.439692  , 0.470854  , 0.504224  ,
 0.539959  , 0.578228  , 0.619208  , 0.663092  , 0.710087  , 0.760413  ,
 0.814305  , 0.872016  , 0.933818  , 1.        }
,
{9.05848e-04, 9.72282e-04, 1.04359e-03, 1.12012e-03, 1.20227e-03,
 1.29044e-03, 1.38508e-03, 1.48666e-03, 1.59569e-03, 1.71272e-03,
 1.83833e-03, 1.97315e-03, 2.11786e-03, 2.27318e-03, 2.43989e-03,
 2.61883e-03, 2.81089e-03, 3.01704e-03, 3.23831e-03, 3.47580e-03,
 3.73071e-03, 4.00432e-03, 4.29799e-03, 4.61320e-03, 4.95152e-03,
 5.31466e-03, 5.70443e-03, 6.12279e-03, 6.57183e-03, 7.05380e-03,
 7.57111e-03, 8.12637e-03, 8.72235e-03, 9.36203e-03, 1.00486e-02,
 1.07856e-02, 1.15766e-02, 1.24256e-02, 1.33369e-02, 1.43150e-02,
 1.53648e-02, 1.64917e-02, 1.77012e-02, 1.89993e-02, 2.03927e-02,
 2.18883e-02, 2.34936e-02, 2.52165e-02, 2.70659e-02, 2.90509e-02,
 3.11814e-02, 3.34682e-02, 3.59228e-02, 3.85573e-02, 4.13850e-02,
 4.44202e-02, 4.76779e-02, 5.11745e-02, 5.49276e-02, 5.89559e-02,
 6.32797e-02, 6.79205e-02, 7.29017e-02, 7.82483e-02, 8.39869e-02,
 9.01464e-02, 9.67576e-02, 1.03854e-01, 1.11470e-01, 1.19645e-01,
 1.28420e-01, 1.37838e-01, 1.47947e-01, 1.58797e-01, 1.70443e-01,
 1.82943e-01, 1.96360e-01, 2.10761e-01, 2.26218e-01, 2.42808e-01,
 2.60616e-01, 2.79729e-01, 3.00244e-01, 3.22263e-01, 3.45898e-01,
 3.71265e-01, 3.98494e-01, 4.27719e-01, 4.59087e-01, 4.92756e-01,
 5.28894e-01, 5.67682e-01, 6.09316e-01, 6.54002e-01, 7.01966e-01,
 7.53447e-01, 8.08704e-01, 8.68013e-01, 9.31672e-01, 1.00000e+00}
,
{7.21308e-04, 7.75992e-04, 8.34821e-04, 8.98110e-04, 9.66197e-04,
 1.03945e-03, 1.11825e-03, 1.20302e-03, 1.29423e-03, 1.39234e-03,
 1.49790e-03, 1.61146e-03, 1.73362e-03, 1.86505e-03, 2.00644e-03,
 2.15856e-03, 2.32220e-03, 2.49825e-03, 2.68764e-03, 2.89140e-03,
 3.11060e-03, 3.34642e-03, 3.60011e-03, 3.87304e-03, 4.16667e-03,
 4.48255e-03, 4.82237e-03, 5.18797e-03, 5.58127e-03, 6.00440e-03,
 6.45960e-03, 6.94931e-03, 7.47615e-03, 8.04292e-03, 8.65267e-03,
 9.30864e-03, 1.00143e-02, 1.07735e-02, 1.15903e-02, 1.24690e-02,
 1.34143e-02, 1.44312e-02, 1.55253e-02, 1.67023e-02, 1.79685e-02,
 1.93307e-02, 2.07962e-02, 2.23728e-02, 2.40689e-02, 2.58936e-02,
 2.78566e-02, 2.99685e-02, 3.22404e-02, 3.46846e-02, 3.73141e-02,
 4.01430e-02, 4.31862e-02, 4.64603e-02, 4.99825e-02, 5.37717e-02,
 5.78482e-02, 6.22338e-02, 6.69518e-02, 7.20275e-02, 7.74880e-02,
 8.33625e-02, 8.96824e-02, 9.64813e-02, 1.03796e-01, 1.11665e-01,
 1.20130e-01, 1.29237e-01, 1.39035e-01, 1.49575e-01, 1.60915e-01,
 1.73114e-01, 1.86238e-01, 2.00357e-01, 2.15546e-01, 2.31887e-01,
 2.49467e-01, 2.68379e-01, 2.88726e-01, 3.10614e-01, 3.34163e-01,
 3.59496e-01, 3.86750e-01, 4.16070e-01, 4.47613e-01, 4.81547e-01,
 5.18054e-01, 5.57328e-01, 5.99580e-01, 6.45035e-01, 6.93936e-01,
 7.46544e-01, 8.03141e-01, 8.64028e-01, 9.29531e-01, 1.00000e+00}
,
{5.74345e-04, 6.19311e-04, 6.67797e-04, 7.20079e-04, 7.76454e-04,
 8.37243e-04, 9.02790e-04, 9.73470e-04, 1.04968e-03, 1.13186e-03,
 1.22048e-03, 1.31603e-03, 1.41906e-03, 1.53016e-03, 1.64995e-03,
 1.77913e-03, 1.91842e-03, 2.06861e-03, 2.23056e-03, 2.40519e-03,
 2.59350e-03, 2.79654e-03, 3.01548e-03, 3.25157e-03, 3.50613e-03,
 3.78063e-03, 4.07661e-03, 4.39577e-03, 4.73992e-03, 5.11100e-03,
 5.51115e-03, 5.94261e-03, 6.40786e-03, 6.90953e-03, 7.45048e-03,
 8.03378e-03, 8.66275e-03, 9.34095e-03, 1.00723e-02, 1.08608e-02,
 1.17111e-02, 1.26280e-02, 1.36166e-02, 1.46827e-02, 1.58322e-02,
 1.70717e-02, 1.84082e-02, 1.98494e-02, 2.14034e-02, 2.30791e-02,
 2.48860e-02, 2.68343e-02, 2.89351e-02, 3.12005e-02, 3.36432e-02,
 3.62771e-02, 3.91172e-02, 4.21797e-02, 4.54820e-02, 4.90428e-02,
 5.28823e-02, 5.70225e-02, 6.14868e-02, 6.63006e-02, 7.14913e-02,
 7.70884e-02, 8.31236e-02, 8.96314e-02, 9.66486e-02, 1.04215e-01,
 1.12374e-01, 1.21172e-01, 1.30659e-01, 1.40888e-01, 1.51918e-01,
 1.63812e-01, 1.76637e-01, 1.90465e-01, 2.05377e-01, 2.21456e-01,
 2.38794e-01, 2.57489e-01, 2.77648e-01, 2.99385e-01, 3.22824e-01,
 3.48098e-01, 3.75350e-01, 4.04737e-01, 4.36424e-01, 4.70591e-01,
 5.07434e-01, 5.47161e-01, 5.89998e-01, 6.36189e-01, 6.85996e-01,
 7.39703e-01, 7.97615e-01, 8.60060e-01, 9.27394e-01, 1.00000e+00}
,
{4.57314e-04, 4.94254e-04, 5.34177e-04, 5.77325e-04, 6.23958e-04,
 6.74358e-04, 7.28829e-04, 7.87700e-04, 8.51327e-04, 9.20092e-04,
 9.94413e-04, 1.07474e-03, 1.16155e-03, 1.25537e-03, 1.35677e-03,
 1.46637e-03, 1.58481e-03, 1.71283e-03, 1.85118e-03, 2.00071e-03,
 2.16231e-03, 2.33697e-03, 2.52574e-03, 2.72976e-03, 2.95026e-03,
 3.18856e-03, 3.44612e-03, 3.72448e-03, 4.02532e-03, 4.35046e-03,
 4.70187e-03, 5.08166e-03, 5.49214e-03, 5.93576e-03, 6.41522e-03,
 6.93341e-03, 7.49345e-03, 8.09874e-03, 8.75291e-03, 9.45992e-03,
 1.02240e-02, 1.10499e-02, 1.19424e-02, 1.29071e-02, 1.39497e-02,
 1.50764e-02, 1.62942e-02, 1.76104e-02, 1.90329e-02, 2.05703e-02,
 2.22318e-02, 2.40276e-02, 2.59684e-02, 2.80660e-02, 3.03330e-02,
 3.27832e-02, 3.54312e-02, 3.82932e-02, 4.13863e-02, 4.47293e-02,
 4.83423e-02, 5.22471e-02, 5.64673e-02, 6.10285e-02, 6.59580e-02,
 7.12858e-02, 7.70439e-02, 8.32671e-02, 8.99930e-02, 9.72621e-02,
 1.05118e-01, 1.13609e-01, 1.22786e-01, 1.32704e-01, 1.43423e-01,
 1.55008e-01, 1.67529e-01, 1.81061e-01, 1.95686e-01, 2.11493e-01,
 2.28576e-01, 2.47039e-01, 2.66994e-01, 2.88560e-01, 3.11869e-01,
 3.37060e-01, 3.64286e-01, 3.93711e-01, 4.25513e-01, 4.59884e-01,
 4.97031e-01, 5.37178e-01, 5.80569e-01, 6.27464e-01, 6.78147e-01,
 7.32924e-01, 7.92126e-01, 8.56110e-01, 9.25262e-01, 1.00000e+00}
,
{3.64123e-04, 3.94441e-04, 4.27285e-04, 4.62863e-04, 5.01403e-04,
 5.43153e-04, 5.88379e-04, 6.37370e-04, 6.90441e-04, 7.47931e-04,
 8.10208e-04, 8.77670e-04, 9.50749e-04, 1.02991e-03, 1.11567e-03,
 1.20857e-03, 1.30920e-03, 1.41821e-03, 1.53630e-03, 1.66422e-03,
 1.80279e-03, 1.95290e-03, 2.11551e-03, 2.29166e-03, 2.48247e-03,
 2.68918e-03, 2.91309e-03, 3.15565e-03, 3.41841e-03, 3.70304e-03,
 4.01138e-03, 4.34539e-03, 4.70721e-03, 5.09916e-03, 5.52374e-03,
 5.98368e-03, 6.48191e-03, 7.02163e-03, 7.60629e-03, 8.23963e-03,
 8.92570e-03, 9.66891e-03, 1.04740e-02, 1.13461e-02, 1.22909e-02,
 1.33143e-02, 1.44229e-02, 1.56238e-02, 1.69247e-02, 1.83340e-02,
 1.98605e-02, 2.15142e-02, 2.33056e-02, 2.52462e-02, 2.73483e-02,
 2.96255e-02, 3.20923e-02, 3.47644e-02, 3.76591e-02, 4.07948e-02,
 4.41916e-02, 4.78713e-02, 5.18573e-02, 5.61752e-02, 6.08526e-02,
 6.59196e-02, 7.14084e-02, 7.73542e-02, 8.37952e-02, 9.07724e-02,
 9.83306e-02, 1.06518e-01, 1.15387e-01, 1.24995e-01, 1.35403e-01,
 1.46677e-01, 1.58890e-01, 1.72121e-01, 1.86452e-01, 2.01977e-01,
 2.18795e-01, 2.37013e-01, 2.56748e-01, 2.78126e-01, 3.01285e-01,
 3.26371e-01, 3.53547e-01, 3.82985e-01, 4.14874e-01, 4.49419e-01,
 4.86840e-01, 5.27377e-01, 5.71289e-01, 6.18858e-01, 6.70387e-01,
 7.26207e-01, 7.86675e-01, 8.52178e-01, 9.23135e-01, 1.00000e+00}
,
{2.89917e-04, 3.14781e-04, 3.41777e-04, 3.71089e-04, 4.02914e-04,
 4.37469e-04, 4.74987e-04, 5.15722e-04, 5.59952e-04, 6.07974e-04,
 6.60115e-04, 7.16728e-04, 7.78196e-04, 8.44936e-04, 9.17399e-04,
 9.96077e-04, 1.08150e-03, 1.17425e-03, 1.27496e-03, 1.38430e-03,
 1.50302e-03, 1.63193e-03, 1.77188e-03, 1.92384e-03, 2.08884e-03,
 2.26798e-03, 2.46248e-03, 2.67367e-03, 2.90297e-03, 3.15194e-03,
 3.42225e-03, 3.71575e-03, 4.03442e-03, 4.38042e-03, 4.75609e-03,
 5.16399e-03, 5.60686e-03, 6.08771e-03, 6.60981e-03, 7.17668e-03,
 7.79216e-03, 8.46044e-03, 9.18602e-03, 9.97383e-03, 1.08292e-02,
 1.17579e-02, 1.27663e-02, 1.38612e-02, 1.50499e-02, 1.63407e-02,
 1.77421e-02, 1.92637e-02, 2.09157e-02, 2.27095e-02, 2.46571e-02,
 2.67718e-02, 2.90678e-02, 3.15607e-02, 3.42674e-02, 3.72062e-02,
 4.03971e-02, 4.38616e-02, 4.76233e-02, 5.17076e-02, 5.61421e-02,
 6.09570e-02, 6.61847e-02, 7.18609e-02, 7.80238e-02, 8.47153e-02,
 9.19806e-02, 9.98691e-02, 1.08434e-01, 1.17734e-01, 1.27831e-01,
 1.38794e-01, 1.50697e-01, 1.63621e-01, 1.77653e-01, 1.92889e-01,
 2.09432e-01, 2.27393e-01, 2.46895e-01, 2.68069e-01, 2.91059e-01,
 3.16021e-01, 3.43123e-01, 3.72550e-01, 4.04501e-01, 4.39191e-01,
 4.76857e-01, 5.17754e-01, 5.62157e-01, 6.10369e-01, 6.62715e-01,
 7.19551e-01, 7.81261e-01, 8.48264e-01, 9.21012e-01, 1.00000e+00}
,
{2.30831e-04, 2.51205e-04, 2.73378e-04, 2.97507e-04, 3.23767e-04,
 3.52344e-04, 3.83443e-04, 4.17287e-04, 4.54119e-04, 4.94202e-04,
 5.37822e-04, 5.85292e-04, 6.36953e-04, 6.93173e-04, 7.54356e-04,
 8.20938e-04, 8.93398e-04, 9.72253e-04, 1.05807e-03, 1.15146e-03,
 1.25309e-03, 1.36369e-03, 1.48406e-03, 1.61505e-03, 1.75760e-03,
 1.91273e-03, 2.08156e-03, 2.26529e-03, 2.46523e-03, 2.68282e-03,
 2.91962e-03, 3.17732e-03, 3.45776e-03, 3.76296e-03, 4.09510e-03,
 4.45655e-03, 4.84990e-03, 5.27797e-03, 5.74383e-03, 6.25081e-03,
 6.80253e-03, 7.40295e-03, 8.05637e-03, 8.76746e-03, 9.54131e-03,
 1.03835e-02, 1.13000e-02, 1.22973e-02, 1.33828e-02, 1.45640e-02,
 1.58495e-02, 1.72484e-02, 1.87708e-02, 2.04276e-02, 2.22306e-02,
 2.41928e-02, 2.63282e-02, 2.86520e-02, 3.11810e-02, 3.39331e-02,
 3.69282e-02, 4.01877e-02, 4.37348e-02, 4.75950e-02, 5.17960e-02,
 5.63677e-02, 6.13430e-02, 6.67574e-02, 7.26497e-02, 7.90620e-02,
 8.60404e-02, 9.36347e-02, 1.01899e-01, 1.10893e-01, 1.20681e-01,
 1.31333e-01, 1.42925e-01, 1.55540e-01, 1.69269e-01, 1.84210e-01,
 2.00469e-01, 2.18163e-01, 2.37419e-01, 2.58374e-01, 2.81180e-01,
 3.05998e-01, 3.33007e-01, 3.62399e-01, 3.94386e-01, 4.29196e-01,
 4.67079e-01, 5.08306e-01, 5.53171e-01, 6.01996e-01, 6.55131e-01,
 7.12955e-01, 7.75884e-01, 8.44367e-01, 9.18894e-01, 1.00000e+00}
,
{1.83785e-04, 2.00468e-04, 2.18665e-04, 2.38514e-04, 2.60164e-04,
 2.83780e-04, 3.09540e-04, 3.37637e-04, 3.68286e-04, 4.01716e-04,
 4.38181e-04, 4.77956e-04, 5.21341e-04, 5.68664e-04, 6.20284e-04,
 6.76588e-04, 7.38004e-04, 8.04995e-04, 8.78066e-04, 9.57770e-04,
 1.04471e-03, 1.13954e-03, 1.24298e-03, 1.35581e-03, 1.47888e-03,
 1.61312e-03, 1.75955e-03, 1.91927e-03, 2.09348e-03, 2.28351e-03,
 2.49080e-03, 2.71689e-03, 2.96351e-03, 3.23252e-03, 3.52594e-03,
 3.84600e-03, 4.19511e-03, 4.57591e-03, 4.99128e-03, 5.44435e-03,
 5.93855e-03, 6.47761e-03, 7.06560e-03, 7.70696e-03, 8.40654e-03,
 9.16962e-03, 1.00020e-02, 1.09099e-02, 1.19002e-02, 1.29804e-02,
 1.41587e-02, 1.54439e-02, 1.68458e-02, 1.83749e-02, 2.00429e-02,
 2.18622e-02, 2.38467e-02, 2.60113e-02, 2.83724e-02, 3.09479e-02,
 3.37571e-02, 3.68213e-02, 4.01637e-02, 4.38094e-02, 4.77861e-02,
 5.21238e-02, 5.68552e-02, 6.20161e-02, 6.76455e-02, 7.37858e-02,
 8.04836e-02, 8.77893e-02, 9.57581e-02, 1.04450e-01, 1.13932e-01,
 1.24273e-01, 1.35554e-01, 1.47859e-01, 1.61280e-01, 1.75920e-01,
 1.91889e-01, 2.09307e-01, 2.28306e-01, 2.49030e-01, 2.71635e-01,
 2.96293e-01, 3.23188e-01, 3.52524e-01, 3.84524e-01, 4.19428e-01,
 4.57501e-01, 4.99029e-01, 5.44328e-01, 5.93738e-01, 6.47633e-01,
 7.06420e-01, 7.70544e-01, 8.40488e-01, 9.16781e-01, 1.00000e+00}
,
{1.46327e-04, 1.59977e-04, 1.74901e-04, 1.91217e-04, 2.09055e-04,
 2.28557e-04, 2.49878e-04, 2.73189e-04, 2.98674e-04, 3.26536e-04,
 3.56997e-04, 3.90301e-04, 4.26711e-04, 4.66517e-04, 5.10037e-04,
 5.57617e-04, 6.09635e-04, 6.66506e-04, 7.28682e-04, 7.96658e-04,
 8.70976e-04, 9.52226e-04, 1.04106e-03, 1.13817e-03, 1.24435e-03,
 1.36043e-03, 1.48734e-03, 1.62609e-03, 1.77778e-03, 1.94363e-03,
 2.12494e-03, 2.32317e-03, 2.53989e-03, 2.77683e-03, 3.03587e-03,
 3.31908e-03, 3.62871e-03, 3.96722e-03, 4.33730e-03, 4.74192e-03,
 5.18428e-03, 5.66790e-03, 6.19664e-03, 6.77471e-03, 7.40670e-03,
 8.09764e-03, 8.85305e-03, 9.67892e-03, 1.05818e-02, 1.15690e-02,
 1.26482e-02, 1.38281e-02, 1.51181e-02, 1.65284e-02, 1.80703e-02,
 1.97560e-02, 2.15990e-02, 2.36139e-02, 2.58168e-02, 2.82251e-02,
 3.08582e-02, 3.37368e-02, 3.68840e-02, 4.03248e-02, 4.40866e-02,
 4.81993e-02, 5.26956e-02, 5.76115e-02, 6.29858e-02, 6.88616e-02,
 7.52855e-02, 8.23086e-02, 8.99869e-02, 9.83815e-02, 1.07559e-01,
 1.17593e-01, 1.28563e-01, 1.40556e-01, 1.53668e-01, 1.68003e-01,
 1.83676e-01, 2.00810e-01, 2.19543e-01, 2.40024e-01, 2.62415e-01,
 2.86895e-01, 3.13658e-01, 3.42918e-01, 3.74908e-01, 4.09882e-01,
 4.48119e-01, 4.89922e-01, 5.35626e-01, 5.85592e-01, 6.40220e-01,
 6.99944e-01, 7.65240e-01, 8.36627e-01, 9.14673e-01, 1.00000e+00}
,
{1.16502e-04, 1.27664e-04, 1.39895e-04, 1.53298e-04, 1.67985e-04,
 1.84079e-04, 2.01715e-04, 2.21041e-04, 2.42218e-04, 2.65424e-04,
 2.90854e-04, 3.18719e-04, 3.49255e-04, 3.82716e-04, 4.19383e-04,
 4.59562e-04, 5.03592e-04, 5.51839e-04, 6.04709e-04, 6.62644e-04,
 7.26130e-04, 7.95698e-04, 8.71932e-04, 9.55469e-04, 1.04701e-03,
 1.14732e-03, 1.25724e-03, 1.37769e-03, 1.50969e-03, 1.65432e-03,
 1.81282e-03, 1.98650e-03, 2.17682e-03, 2.38537e-03, 2.61391e-03,
 2.86434e-03, 3.13876e-03, 3.43948e-03, 3.76900e-03, 4.13010e-03,
 4.52579e-03, 4.95939e-03, 5.43453e-03, 5.95520e-03, 6.52575e-03,
 7.15096e-03, 7.83607e-03, 8.58682e-03, 9.40949e-03, 1.03110e-02,
 1.12989e-02, 1.23814e-02, 1.35676e-02, 1.48674e-02, 1.62918e-02,
 1.78527e-02, 1.95631e-02, 2.14374e-02, 2.34913e-02, 2.57419e-02,
 2.82081e-02, 3.09107e-02, 3.38721e-02, 3.71173e-02, 4.06734e-02,
 4.45702e-02, 4.88403e-02, 5.35195e-02, 5.86471e-02, 6.42658e-02,
 7.04229e-02, 7.71699e-02, 8.45633e-02, 9.26651e-02, 1.01543e-01,
 1.11272e-01, 1.21932e-01, 1.33614e-01, 1.46415e-01, 1.60443e-01,
 1.75814e-01, 1.92658e-01, 2.11116e-01, 2.31343e-01, 2.53507e-01,
 2.77795e-01, 3.04409e-01, 3.33574e-01, 3.65533e-01, 4.00553e-01,
 4.38929e-01, 4.80981e-01, 5.27062e-01, 5.77559e-01, 6.32893e-01,
 6.93528e-01, 7.59973e-01, 8.32783e-01, 9.12570e-01, 1.00000e+00}
,
{9.27562e-05, 1.01877e-04, 1.11895e-04, 1.22898e-04, 1.34983e-04,
 1.48256e-04, 1.62834e-04, 1.78846e-04, 1.96433e-04, 2.15749e-04,
 2.36964e-04, 2.60265e-04, 2.85858e-04, 3.13967e-04, 3.44840e-04,
 3.78749e-04, 4.15992e-04, 4.56898e-04, 5.01826e-04, 5.51172e-04,
 6.05370e-04, 6.64898e-04, 7.30279e-04, 8.02089e-04, 8.80961e-04,
 9.67588e-04, 1.06273e-03, 1.16724e-03, 1.28201e-03, 1.40808e-03,
 1.54654e-03, 1.69861e-03, 1.86564e-03, 2.04909e-03, 2.25059e-03,
 2.47189e-03, 2.71496e-03, 2.98193e-03, 3.27515e-03, 3.59721e-03,
 3.95093e-03, 4.33944e-03, 4.76614e-03, 5.23481e-03, 5.74956e-03,
 6.31493e-03, 6.93590e-03, 7.61792e-03, 8.36702e-03, 9.18977e-03,
 1.00934e-02, 1.10859e-02, 1.21760e-02, 1.33733e-02, 1.46884e-02,
 1.61327e-02, 1.77191e-02, 1.94615e-02, 2.13752e-02, 2.34771e-02,
 2.57856e-02, 2.83212e-02, 3.11061e-02, 3.41648e-02, 3.75243e-02,
 4.12142e-02, 4.52669e-02, 4.97181e-02, 5.46071e-02, 5.99767e-02,
 6.58744e-02, 7.23520e-02, 7.94666e-02, 8.72807e-02, 9.58633e-02,
 1.05290e-01, 1.15643e-01, 1.27015e-01, 1.39504e-01, 1.53222e-01,
 1.68289e-01, 1.84837e-01, 2.03013e-01, 2.22976e-01, 2.44901e-01,
 2.68983e-01, 2.95433e-01, 3.24484e-01, 3.56391e-01, 3.91436e-01,
 4.29927e-01, 4.72203e-01, 5.18636e-01, 5.69635e-01, 6.25649e-01,
 6.87170e-01, 7.54742e-01, 8.28957e-01, 9.10471e-01, 1.00000e+00}
,
{7.38498e-05, 8.12986e-05, 8.94988e-05, 9.85260e-05, 1.08464e-04,
 1.19404e-04, 1.31448e-04, 1.44706e-04, 1.59302e-04, 1.75369e-04,
 1.93058e-04, 2.12531e-04, 2.33968e-04, 2.57567e-04, 2.83546e-04,
 3.12146e-04, 3.43630e-04, 3.78290e-04, 4.16446e-04, 4.58451e-04,
 5.04692e-04, 5.55597e-04, 6.11637e-04, 6.73330e-04, 7.41245e-04,
 8.16010e-04, 8.98317e-04, 9.88925e-04, 1.08867e-03, 1.19848e-03,
 1.31936e-03, 1.45244e-03, 1.59894e-03, 1.76022e-03, 1.93776e-03,
 2.13321e-03, 2.34838e-03, 2.58524e-03, 2.84600e-03, 3.13306e-03,
 3.44908e-03, 3.79697e-03, 4.17995e-03, 4.60156e-03, 5.06569e-03,
 5.57664e-03, 6.13912e-03, 6.75834e-03, 7.44002e-03, 8.19045e-03,
 9.01658e-03, 9.92603e-03, 1.09272e-02, 1.20294e-02, 1.32427e-02,
 1.45784e-02, 1.60489e-02, 1.76676e-02, 1.94497e-02, 2.14115e-02,
 2.35711e-02, 2.59486e-02, 2.85659e-02, 3.14472e-02, 3.46191e-02,
 3.81109e-02, 4.19549e-02, 4.61867e-02, 5.08453e-02, 5.59738e-02,
 6.16195e-02, 6.78348e-02, 7.46769e-02, 8.22091e-02, 9.05011e-02,
 9.96295e-02, 1.09679e-01, 1.20741e-01, 1.32920e-01, 1.46327e-01,
 1.61086e-01, 1.77334e-01, 1.95220e-01, 2.14911e-01, 2.36588e-01,
 2.60451e-01, 2.86721e-01, 3.15641e-01, 3.47478e-01, 3.82527e-01,
 4.21110e-01, 4.63585e-01, 5.10344e-01, 5.61820e-01, 6.18487e-01,
 6.80871e-01, 7.49546e-01, 8.25149e-01, 9.08377e-01, 1.00000e+00}
,
{5.87969e-05, 6.48767e-05, 7.15850e-05, 7.89871e-05, 8.71545e-05,
 9.61665e-05, 1.06110e-04, 1.17082e-04, 1.29189e-04, 1.42547e-04,
 1.57287e-04, 1.73551e-04, 1.91496e-04, 2.11297e-04, 2.33146e-04,
 2.57254e-04, 2.83854e-04, 3.13205e-04, 3.45591e-04, 3.81326e-04,
 4.20756e-04, 4.64263e-04, 5.12269e-04, 5.65239e-04, 6.23686e-04,
 6.88176e-04, 7.59335e-04, 8.37851e-04, 9.24487e-04, 1.02008e-03,
 1.12556e-03, 1.24194e-03, 1.37036e-03, 1.51206e-03, 1.66841e-03,
 1.84093e-03, 2.03129e-03, 2.24133e-03, 2.47308e-03, 2.72881e-03,
 3.01097e-03, 3.32231e-03, 3.66584e-03, 4.04490e-03, 4.46315e-03,
 4.92465e-03, 5.43387e-03, 5.99574e-03, 6.61571e-03, 7.29979e-03,
 8.05460e-03, 8.88747e-03, 9.80645e-03, 1.08205e-02, 1.19393e-02,
 1.31739e-02, 1.45361e-02, 1.60391e-02, 1.76976e-02, 1.95276e-02,
 2.15468e-02, 2.37747e-02, 2.62331e-02, 2.89457e-02, 3.19387e-02,
 3.52412e-02, 3.88852e-02, 4.29061e-02, 4.73426e-02, 5.22380e-02,
 5.76395e-02, 6.35995e-02, 7.01758e-02, 7.74322e-02, 8.54388e-02,
 9.42734e-02, 1.04021e-01, 1.14777e-01, 1.26646e-01, 1.39741e-01,
 1.54191e-01, 1.70134e-01, 1.87726e-01, 2.07138e-01, 2.28556e-01,
 2.52189e-01, 2.78266e-01, 3.07040e-01, 3.38788e-01, 3.73820e-01,
 4.12473e-01, 4.55124e-01, 5.02185e-01, 5.54112e-01, 6.11408e-01,
 6.74629e-01, 7.44387e-01, 8.21358e-01, 9.06288e-01, 1.00000e+00}
,
{4.68122e-05, 5.17717e-05, 5.72567e-05, 6.33228e-05, 7.00316e-05,
 7.74511e-05, 8.56567e-05, 9.47316e-05, 1.04768e-04, 1.15868e-04,
 1.28143e-04, 1.41720e-04, 1.56734e-04, 1.73340e-04, 1.91704e-04,
 2.12014e-04, 2.34476e-04, 2.59318e-04, 2.86792e-04, 3.17176e-04,
 3.50779e-04, 3.87943e-04, 4.29043e-04, 4.74499e-04, 5.24770e-04,
 5.80367e-04, 6.41854e-04, 7.09856e-04, 7.85062e-04, 8.68236e-04,
 9.60221e-04, 1.06195e-03, 1.17446e-03, 1.29889e-03, 1.43650e-03,
 1.58869e-03, 1.75701e-03, 1.94316e-03, 2.14902e-03, 2.37670e-03,
 2.62850e-03, 2.90698e-03, 3.21497e-03, 3.55558e-03, 3.93227e-03,
 4.34888e-03, 4.80963e-03, 5.31918e-03, 5.88273e-03, 6.50598e-03,
 7.19526e-03, 7.95756e-03, 8.80063e-03, 9.73302e-03, 1.07642e-02,
 1.19046e-02, 1.31658e-02, 1.45607e-02, 1.61034e-02, 1.78094e-02,
 1.96963e-02, 2.17830e-02, 2.40908e-02, 2.66431e-02, 2.94658e-02,
 3.25876e-02, 3.60401e-02, 3.98584e-02, 4.40812e-02, 4.87514e-02,
 5.39164e-02, 5.96287e-02, 6.59460e-02, 7.29327e-02, 8.06596e-02,
 8.92052e-02, 9.86561e-02, 1.09108e-01, 1.20668e-01, 1.33452e-01,
 1.47591e-01, 1.63227e-01, 1.80520e-01, 1.99646e-01, 2.20797e-01,
 2.44190e-01, 2.70061e-01, 2.98672e-01, 3.30315e-01, 3.65311e-01,
 4.04014e-01, 4.46817e-01, 4.94156e-01, 5.46509e-01, 6.04409e-01,
 6.68444e-01, 7.39263e-01, 8.17584e-01, 9.04204e-01, 1.00000e+00}
,
{3.72702e-05, 4.13139e-05, 4.57962e-05, 5.07649e-05, 5.62726e-05,
 6.23779e-05, 6.91456e-05, 7.66475e-05, 8.49634e-05, 9.41815e-05,
 1.04400e-04, 1.15727e-04, 1.28282e-04, 1.42200e-04, 1.57628e-04,
 1.74730e-04, 1.93687e-04, 2.14702e-04, 2.37996e-04, 2.63817e-04,
 2.92440e-04, 3.24168e-04, 3.59339e-04, 3.98325e-04, 4.41541e-04,
 4.89446e-04, 5.42549e-04, 6.01412e-04, 6.66663e-04, 7.38992e-04,
 8.19169e-04, 9.08045e-04, 1.00656e-03, 1.11577e-03, 1.23683e-03,
 1.37101e-03, 1.51976e-03, 1.68465e-03, 1.86743e-03, 2.07003e-03,
 2.29462e-03, 2.54357e-03, 2.81954e-03, 3.12545e-03, 3.46454e-03,
 3.84043e-03, 4.25709e-03, 4.71897e-03, 5.23095e-03, 5.79848e-03,
 6.42759e-03, 7.12495e-03, 7.89797e-03, 8.75486e-03, 9.70471e-03,
 1.07576e-02, 1.19248e-02, 1.32186e-02, 1.46527e-02, 1.62424e-02,
 1.80047e-02, 1.99581e-02, 2.21234e-02, 2.45237e-02, 2.71844e-02,
 3.01338e-02, 3.34031e-02, 3.70272e-02, 4.10445e-02, 4.54976e-02,
 5.04339e-02, 5.59057e-02, 6.19712e-02, 6.86947e-02, 7.61478e-02,
 8.44094e-02, 9.35674e-02, 1.03719e-01, 1.14972e-01, 1.27446e-01,
 1.41273e-01, 1.56600e-01, 1.73591e-01, 1.92425e-01, 2.13302e-01,
 2.36444e-01, 2.62097e-01, 2.90533e-01, 3.22054e-01, 3.56996e-01,
 3.95728e-01, 4.38662e-01, 4.86255e-01, 5.39011e-01, 5.97491e-01,
 6.62316e-01, 7.34174e-01, 8.13828e-01, 9.02124e-01, 1.00000e+00}
,
{2.96732e-05, 3.29684e-05, 3.66296e-05, 4.06973e-05, 4.52168e-05,
 5.02381e-05, 5.58170e-05, 6.20155e-05, 6.89024e-05, 7.65540e-05,
 8.50553e-05, 9.45008e-05, 1.04995e-04, 1.16655e-04, 1.29609e-04,
 1.44003e-04, 1.59994e-04, 1.77761e-04, 1.97502e-04, 2.19434e-04,
 2.43803e-04, 2.70877e-04, 3.00958e-04, 3.34379e-04, 3.71512e-04,
 4.12769e-04, 4.58607e-04, 5.09535e-04, 5.66119e-04, 6.28987e-04,
 6.98836e-04, 7.76442e-04, 8.62666e-04, 9.58465e-04, 1.06490e-03,
 1.18316e-03, 1.31455e-03, 1.46053e-03, 1.62273e-03, 1.80293e-03,
 2.00314e-03, 2.22559e-03, 2.47275e-03, 2.74735e-03, 3.05244e-03,
 3.39141e-03, 3.76803e-03, 4.18647e-03, 4.65138e-03, 5.16792e-03,
 5.74182e-03, 6.37944e-03, 7.08788e-03, 7.87499e-03, 8.74951e-03,
 9.72115e-03, 1.08007e-02, 1.20001e-02, 1.33327e-02, 1.48133e-02,
 1.64583e-02, 1.82860e-02, 2.03167e-02, 2.25729e-02, 2.50796e-02,
 2.78647e-02, 3.09591e-02, 3.43971e-02, 3.82169e-02, 4.24609e-02,
 4.71762e-02, 5.24151e-02, 5.82358e-02, 6.47029e-02, 7.18882e-02,
 7.98714e-02, 8.87412e-02, 9.85959e-02, 1.09545e-01, 1.21710e-01,
 1.35226e-01, 1.50243e-01, 1.66927e-01, 1.85465e-01, 2.06060e-01,
 2.28944e-01, 2.54368e-01, 2.82615e-01, 3.14000e-01, 3.48870e-01,
 3.87612e-01, 4.30656e-01, 4.78480e-01, 5.31616e-01, 5.90652e-01,
 6.56244e-01, 7.29120e-01, 8.10089e-01, 9.00049e-01, 1.00000e+00}
,
{2.36247e-05, 2.63088e-05, 2.92977e-05, 3.26263e-05, 3.63330e-05,
 4.04609e-05, 4.50577e-05, 5.01767e-05, 5.58774e-05, 6.22257e-05,
 6.92953e-05, 7.71680e-05, 8.59351e-05, 9.56984e-05, 1.06571e-04,
 1.18678e-04, 1.32162e-04, 1.47177e-04, 1.63898e-04, 1.82518e-04,
 2.03255e-04, 2.26347e-04, 2.52062e-04, 2.80699e-04, 3.12590e-04,
 3.48104e-04, 3.87652e-04, 4.31694e-04, 4.80739e-04, 5.35357e-04,
 5.96179e-04, 6.63912e-04, 7.39340e-04, 8.23337e-04, 9.16878e-04,
 1.02105e-03, 1.13705e-03, 1.26623e-03, 1.41009e-03, 1.57029e-03,
 1.74869e-03, 1.94736e-03, 2.16861e-03, 2.41499e-03, 2.68936e-03,
 2.99490e-03, 3.33515e-03, 3.71406e-03, 4.13602e-03, 4.60592e-03,
 5.12921e-03, 5.71194e-03, 6.36089e-03, 7.08355e-03, 7.88833e-03,
 8.78453e-03, 9.78255e-03, 1.08940e-02, 1.21316e-02, 1.35099e-02,
 1.50448e-02, 1.67541e-02, 1.86575e-02, 2.07772e-02, 2.31378e-02,
 2.57665e-02, 2.86939e-02, 3.19538e-02, 3.55841e-02, 3.96269e-02,
 4.41290e-02, 4.91425e-02, 5.47257e-02, 6.09431e-02, 6.78669e-02,
 7.55774e-02, 8.41639e-02, 9.37258e-02, 1.04374e-01, 1.16232e-01,
 1.29438e-01, 1.44143e-01, 1.60519e-01, 1.78756e-01, 1.99065e-01,
 2.21681e-01, 2.46867e-01, 2.74913e-01, 3.06147e-01, 3.40929e-01,
 3.79662e-01, 4.22796e-01, 4.70830e-01, 5.24322e-01, 5.83891e-01,
 6.50227e-01, 7.24101e-01, 8.06367e-01, 8.97979e-01, 1.00000e+00}
,
{1.88091e-05, 2.09943e-05, 2.34334e-05, 2.61559e-05, 2.91946e-05,
 3.25864e-05, 3.63723e-05, 4.05979e-05, 4.53145e-05, 5.05791e-05,
 5.64553e-05, 6.30142e-05, 7.03351e-05, 7.85066e-05, 8.76273e-05,
 9.78077e-05, 1.09171e-04, 1.21854e-04, 1.36011e-04, 1.51813e-04,
 1.69450e-04, 1.89136e-04, 2.11110e-04, 2.35636e-04, 2.63012e-04,
 2.93569e-04, 3.27675e-04, 3.65744e-04, 4.08235e-04, 4.55664e-04,
 5.08602e-04, 5.67691e-04, 6.33644e-04, 7.07260e-04, 7.89428e-04,
 8.81143e-04, 9.83513e-04, 1.09778e-03, 1.22531e-03, 1.36767e-03,
 1.52656e-03, 1.70392e-03, 1.90187e-03, 2.12283e-03, 2.36946e-03,
 2.64474e-03, 2.95200e-03, 3.29496e-03, 3.67776e-03, 4.10504e-03,
 4.58196e-03, 5.11428e-03, 5.70845e-03, 6.37165e-03, 7.11190e-03,
 7.93815e-03, 8.86039e-03, 9.88978e-03, 1.10388e-02, 1.23212e-02,
 1.37527e-02, 1.53505e-02, 1.71338e-02, 1.91244e-02, 2.13463e-02,
 2.38263e-02, 2.65944e-02, 2.96840e-02, 3.31327e-02, 3.69820e-02,
 4.12785e-02, 4.60742e-02, 5.14270e-02, 5.74017e-02, 6.40706e-02,
 7.15142e-02, 7.98226e-02, 8.90963e-02, 9.94474e-02, 1.11001e-01,
 1.23897e-01, 1.38291e-01, 1.54358e-01, 1.72291e-01, 1.92307e-01,
 2.14649e-01, 2.39587e-01, 2.67421e-01, 2.98490e-01, 3.33168e-01,
 3.71875e-01, 4.15079e-01, 4.63302e-01, 5.17128e-01, 5.77207e-01,
 6.44266e-01, 7.19116e-01, 8.02662e-01, 8.95914e-01, 1.00000e+00}
,
{1.49751e-05, 1.67534e-05, 1.87429e-05, 2.09687e-05, 2.34587e-05,
 2.62445e-05, 2.93611e-05, 3.28477e-05, 3.67484e-05, 4.11124e-05,
 4.59945e-05, 5.14564e-05, 5.75670e-05, 6.44031e-05, 7.20511e-05,
 8.06073e-05, 9.01795e-05, 1.00888e-04, 1.12869e-04, 1.26273e-04,
 1.41268e-04, 1.58043e-04, 1.76811e-04, 1.97808e-04, 2.21298e-04,
 2.47577e-04, 2.76977e-04, 3.09869e-04, 3.46666e-04, 3.87833e-04,
 4.33889e-04, 4.85414e-04, 5.43058e-04, 6.07547e-04, 6.79694e-04,
 7.60409e-04, 8.50708e-04, 9.51731e-04, 1.06475e-03, 1.19119e-03,
 1.33265e-03, 1.49090e-03, 1.66795e-03, 1.86602e-03, 2.08761e-03,
 2.33552e-03, 2.61287e-03, 2.92315e-03, 3.27028e-03, 3.65863e-03,
 4.09309e-03, 4.57915e-03, 5.12294e-03, 5.73129e-03, 6.41189e-03,
 7.17331e-03, 8.02516e-03, 8.97816e-03, 1.00443e-02, 1.12371e-02,
 1.25715e-02, 1.40644e-02, 1.57346e-02, 1.76031e-02, 1.96935e-02,
 2.20321e-02, 2.46485e-02, 2.75755e-02, 3.08501e-02, 3.45136e-02,
 3.86122e-02, 4.31975e-02, 4.83272e-02, 5.40661e-02, 6.04866e-02,
 6.76695e-02, 7.57053e-02, 8.46954e-02, 9.47531e-02, 1.06005e-01,
 1.18593e-01, 1.32677e-01, 1.48432e-01, 1.66059e-01, 1.85778e-01,
 2.07840e-01, 2.32521e-01, 2.60134e-01, 2.91025e-01, 3.25584e-01,
 3.64248e-01, 4.07503e-01, 4.55895e-01, 5.10033e-01, 5.70600e-01,
 6.38360e-01, 7.14166e-01, 7.98974e-01, 8.93854e-01, 1.00000e+00}
,
{1.19226e-05, 1.33692e-05, 1.49913e-05, 1.68102e-05, 1.88497e-05,
 2.11368e-05, 2.37013e-05, 2.65770e-05, 2.98016e-05, 3.34175e-05,
 3.74720e-05, 4.20185e-05, 4.71166e-05, 5.28333e-05, 5.92436e-05,
 6.64317e-05, 7.44919e-05, 8.35300e-05, 9.36647e-05, 1.05029e-04,
 1.17772e-04, 1.32062e-04, 1.48085e-04, 1.66052e-04, 1.86199e-04,
 2.08791e-04, 2.34124e-04, 2.62530e-04, 2.94383e-04, 3.30100e-04,
 3.70152e-04, 4.15062e-04, 4.65422e-04, 5.21892e-04, 5.85213e-04,
 6.56217e-04, 7.35837e-04, 8.25116e-04, 9.25228e-04, 1.03749e-03,
 1.16336e-03, 1.30452e-03, 1.46279e-03, 1.64028e-03, 1.83929e-03,
 2.06245e-03, 2.31269e-03, 2.59329e-03, 2.90794e-03, 3.26076e-03,
 3.65639e-03, 4.10002e-03, 4.59748e-03, 5.15529e-03, 5.78078e-03,
 6.48217e-03, 7.26865e-03, 8.15056e-03, 9.13947e-03, 1.02484e-02,
 1.14918e-02, 1.28861e-02, 1.44496e-02, 1.62028e-02, 1.81687e-02,
 2.03731e-02, 2.28450e-02, 2.56167e-02, 2.87248e-02, 3.22100e-02,
 3.61181e-02, 4.05003e-02, 4.54142e-02, 5.09244e-02, 5.71030e-02,
 6.40314e-02, 7.18003e-02, 8.05119e-02, 9.02805e-02, 1.01234e-01,
 1.13517e-01, 1.27290e-01, 1.42734e-01, 1.60052e-01, 1.79472e-01,
 2.01247e-01, 2.25664e-01, 2.53044e-01, 2.83746e-01, 3.18173e-01,
 3.56777e-01, 4.00065e-01, 4.48606e-01, 5.03035e-01, 5.64069e-01,
 6.32507e-01, 7.09250e-01, 7.95303e-01, 8.91798e-01, 1.00000e+00}
,
{9.49230e-06, 1.06685e-05, 1.19905e-05, 1.34764e-05, 1.51463e-05,
 1.70231e-05, 1.91326e-05, 2.15034e-05, 2.41680e-05, 2.71628e-05,
 3.05287e-05, 3.43116e-05, 3.85634e-05, 4.33420e-05, 4.87127e-05,
 5.47490e-05, 6.15332e-05, 6.91581e-05, 7.77279e-05, 8.73596e-05,
 9.81847e-05, 1.10351e-04, 1.24026e-04, 1.39394e-04, 1.56667e-04,
 1.76081e-04, 1.97900e-04, 2.22423e-04, 2.49984e-04, 2.80961e-04,
 3.15777e-04, 3.54906e-04, 3.98885e-04, 4.48313e-04, 5.03866e-04,
 5.66302e-04, 6.36476e-04, 7.15345e-04, 8.03987e-04, 9.03614e-04,
 1.01559e-03, 1.14143e-03, 1.28287e-03, 1.44184e-03, 1.62051e-03,
 1.82131e-03, 2.04700e-03, 2.30066e-03, 2.58574e-03, 2.90616e-03,
 3.26627e-03, 3.67102e-03, 4.12591e-03, 4.63718e-03, 5.21179e-03,
 5.85761e-03, 6.58346e-03, 7.39925e-03, 8.31614e-03, 9.34663e-03,
 1.05048e-02, 1.18065e-02, 1.32695e-02, 1.49138e-02, 1.67619e-02,
 1.88390e-02, 2.11734e-02, 2.37971e-02, 2.67459e-02, 3.00602e-02,
 3.37851e-02, 3.79716e-02, 4.26768e-02, 4.79652e-02, 5.39088e-02,
 6.05889e-02, 6.80968e-02, 7.65350e-02, 8.60189e-02, 9.66780e-02,
 1.08658e-01, 1.22122e-01, 1.37255e-01, 1.54263e-01, 1.73379e-01,
 1.94863e-01, 2.19009e-01, 2.46148e-01, 2.76650e-01, 3.10931e-01,
 3.49460e-01, 3.92763e-01, 4.41433e-01, 4.96133e-01, 5.57612e-01,
 6.26708e-01, 7.04367e-01, 7.91649e-01, 8.89747e-01, 1.00000e+00}
,
{7.55740e-06, 8.51346e-06, 9.59046e-06, 1.08037e-05, 1.21705e-05,
 1.37101e-05, 1.54445e-05, 1.73983e-05, 1.95993e-05, 2.20788e-05,
 2.48719e-05, 2.80183e-05, 3.15628e-05, 3.55557e-05, 4.00537e-05,
 4.51208e-05, 5.08288e-05, 5.72590e-05, 6.45026e-05, 7.26626e-05,
 8.18549e-05, 9.22100e-05, 1.03875e-04, 1.17016e-04, 1.31819e-04,
 1.48495e-04, 1.67281e-04, 1.88443e-04, 2.12282e-04, 2.39137e-04,
 2.69390e-04, 3.03469e-04, 3.41860e-04, 3.85107e-04, 4.33826e-04,
 4.88707e-04, 5.50532e-04, 6.20177e-04, 6.98634e-04, 7.87015e-04,
 8.86578e-04, 9.98735e-04, 1.12508e-03, 1.26741e-03, 1.42775e-03,
 1.60837e-03, 1.81183e-03, 2.04104e-03, 2.29925e-03, 2.59012e-03,
 2.91778e-03, 3.28690e-03, 3.70271e-03, 4.17113e-03, 4.69880e-03,
 5.29323e-03, 5.96286e-03, 6.71720e-03, 7.56697e-03, 8.52424e-03,
 9.60261e-03, 1.08174e-02, 1.21859e-02, 1.37275e-02, 1.54641e-02,
 1.74204e-02, 1.96241e-02, 2.21067e-02, 2.49034e-02, 2.80538e-02,
 3.16028e-02, 3.56007e-02, 4.01044e-02, 4.51779e-02, 5.08932e-02,
 5.73315e-02, 6.45843e-02, 7.27546e-02, 8.19585e-02, 9.23268e-02,
 1.04007e-01, 1.17164e-01, 1.31986e-01, 1.48683e-01, 1.67493e-01,
 1.88682e-01, 2.12551e-01, 2.39440e-01, 2.69731e-01, 3.03853e-01,
 3.42293e-01, 3.85595e-01, 4.34375e-01, 4.89326e-01, 5.51229e-01,
 6.20963e-01, 6.99518e-01, 7.88012e-01, 8.87700e-01, 1.00000e+00}
,
{6.01690e-06, 6.79370e-06, 7.67079e-06, 8.66111e-06, 9.77929e-06,
 1.10418e-05, 1.24674e-05, 1.40769e-05, 1.58943e-05, 1.79463e-05,
 2.02632e-05, 2.28793e-05, 2.58331e-05, 2.91682e-05, 3.29339e-05,
 3.71858e-05, 4.19866e-05, 4.74072e-05, 5.35276e-05, 6.04382e-05,
 6.82409e-05, 7.70511e-05, 8.69986e-05, 9.82304e-05, 1.10912e-04,
 1.25231e-04, 1.41399e-04, 1.59654e-04, 1.80266e-04, 2.03539e-04,
 2.29816e-04, 2.59486e-04, 2.92987e-04, 3.30812e-04, 3.73521e-04,
 4.21744e-04, 4.76193e-04, 5.37671e-04, 6.07086e-04, 6.85462e-04,
 7.73958e-04, 8.73878e-04, 9.86698e-04, 1.11408e-03, 1.25792e-03,
 1.42032e-03, 1.60368e-03, 1.81072e-03, 2.04449e-03, 2.30845e-03,
 2.60647e-03, 2.94298e-03, 3.32292e-03, 3.75192e-03, 4.23631e-03,
 4.78323e-03, 5.40076e-03, 6.09801e-03, 6.88529e-03, 7.77420e-03,
 8.77787e-03, 9.91112e-03, 1.11907e-02, 1.26354e-02, 1.42667e-02,
 1.61086e-02, 1.81883e-02, 2.05364e-02, 2.31877e-02, 2.61813e-02,
 2.95614e-02, 3.33779e-02, 3.76871e-02, 4.25526e-02, 4.80463e-02,
 5.42492e-02, 6.12530e-02, 6.91609e-02, 7.80898e-02, 8.81714e-02,
 9.95546e-02, 1.12407e-01, 1.26920e-01, 1.43305e-01, 1.61806e-01,
 1.82696e-01, 2.06283e-01, 2.32915e-01, 2.62985e-01, 2.96937e-01,
 3.35272e-01, 3.78557e-01, 4.27430e-01, 4.82612e-01, 5.44919e-01,
 6.15270e-01, 6.94703e-01, 7.84391e-01, 8.85659e-01, 1.00000e+00}
,
{4.79042e-06, 5.42134e-06, 6.13537e-06, 6.94343e-06, 7.85792e-06,
 8.89286e-06, 1.00641e-05, 1.13896e-05, 1.28897e-05, 1.45873e-05,
 1.65086e-05, 1.86828e-05, 2.11435e-05, 2.39282e-05, 2.70797e-05,
 3.06462e-05, 3.46825e-05, 3.92504e-05, 4.44200e-05, 5.02703e-05,
 5.68912e-05, 6.43841e-05, 7.28639e-05, 8.24605e-05, 9.33211e-05,
 1.05612e-04, 1.19522e-04, 1.35263e-04, 1.53078e-04, 1.73240e-04,
 1.96057e-04, 2.21878e-04, 2.51101e-04, 2.84173e-04, 3.21600e-04,
 3.63956e-04, 4.11892e-04, 4.66140e-04, 5.27534e-04, 5.97013e-04,
 6.75643e-04, 7.64629e-04, 8.65336e-04, 9.79305e-04, 1.10829e-03,
 1.25425e-03, 1.41945e-03, 1.60640e-03, 1.81797e-03, 2.05741e-03,
 2.32838e-03, 2.63504e-03, 2.98209e-03, 3.37485e-03, 3.81934e-03,
 4.32236e-03, 4.89165e-03, 5.53591e-03, 6.26502e-03, 7.09016e-03,
 8.02397e-03, 9.08078e-03, 1.02768e-02, 1.16303e-02, 1.31621e-02,
 1.48956e-02, 1.68574e-02, 1.90776e-02, 2.15903e-02, 2.44338e-02,
 2.76519e-02, 3.12939e-02, 3.54154e-02, 4.00799e-02, 4.53586e-02,
 5.13326e-02, 5.80934e-02, 6.57447e-02, 7.44037e-02, 8.42031e-02,
 9.52931e-02, 1.07844e-01, 1.22047e-01, 1.38122e-01, 1.56313e-01,
 1.76901e-01, 2.00200e-01, 2.26567e-01, 2.56407e-01, 2.90178e-01,
 3.28396e-01, 3.71647e-01, 4.20596e-01, 4.75991e-01, 5.38681e-01,
 6.09629e-01, 6.89921e-01, 7.80787e-01, 8.83622e-01, 1.00000e+00}
,
{3.81394e-06, 4.32621e-06, 4.90728e-06, 5.56640e-06, 6.31405e-06,
 7.16212e-06, 8.12410e-06, 9.21528e-06, 1.04530e-05, 1.18570e-05,
 1.34496e-05, 1.52561e-05, 1.73052e-05, 1.96296e-05, 2.22661e-05,
 2.52568e-05, 2.86491e-05, 3.24971e-05, 3.68620e-05, 4.18131e-05,
 4.74292e-05, 5.37996e-05, 6.10257e-05, 6.92224e-05, 7.85199e-05,
 8.90663e-05, 1.01029e-04, 1.14599e-04, 1.29991e-04, 1.47451e-04,
 1.67256e-04, 1.89721e-04, 2.15203e-04, 2.44108e-04, 2.76896e-04,
 3.14087e-04, 3.56273e-04, 4.04126e-04, 4.58406e-04, 5.19977e-04,
 5.89817e-04, 6.69039e-04, 7.58900e-04, 8.60832e-04, 9.76454e-04,
 1.10761e-03, 1.25637e-03, 1.42512e-03, 1.61654e-03, 1.83366e-03,
 2.07995e-03, 2.35932e-03, 2.67621e-03, 3.03567e-03, 3.44340e-03,
 3.90590e-03, 4.43052e-03, 5.02561e-03, 5.70062e-03, 6.46630e-03,
 7.33482e-03, 8.32000e-03, 9.43750e-03, 1.07051e-02, 1.21429e-02,
 1.37739e-02, 1.56240e-02, 1.77225e-02, 2.01029e-02, 2.28030e-02,
 2.58658e-02, 2.93399e-02, 3.32807e-02, 3.77508e-02, 4.28213e-02,
 4.85729e-02, 5.50969e-02, 6.24972e-02, 7.08915e-02, 8.04133e-02,
 9.12140e-02, 1.03465e-01, 1.17362e-01, 1.33126e-01, 1.51007e-01,
 1.71289e-01, 1.94296e-01, 2.20392e-01, 2.49994e-01, 2.83572e-01,
 3.21660e-01, 3.64864e-01, 4.13871e-01, 4.69460e-01, 5.32515e-01,
 6.04040e-01, 6.85171e-01, 7.77200e-01, 8.81589e-01, 1.00000e+00}
,
{3.03650e-06, 3.45229e-06, 3.92501e-06, 4.46246e-06, 5.07351e-06,
 5.76822e-06, 6.55806e-06, 7.45605e-06, 8.47701e-06, 9.63776e-06,
 1.09575e-05, 1.24579e-05, 1.41637e-05, 1.61031e-05, 1.83081e-05,
 2.08151e-05, 2.36653e-05, 2.69057e-05, 3.05899e-05, 3.47786e-05,
 3.95408e-05, 4.49551e-05, 5.11108e-05, 5.81094e-05, 6.60663e-05,
 7.51128e-05, 8.53979e-05, 9.70914e-05, 1.10386e-04, 1.25501e-04,
 1.42686e-04, 1.62224e-04, 1.84437e-04, 2.09692e-04, 2.38405e-04,
 2.71050e-04, 3.08165e-04, 3.50362e-04, 3.98337e-04, 4.52881e-04,
 5.14894e-04, 5.85398e-04, 6.65556e-04, 7.56691e-04, 8.60304e-04,
 9.78106e-04, 1.11204e-03, 1.26431e-03, 1.43743e-03, 1.63426e-03,
 1.85803e-03, 2.11245e-03, 2.40171e-03, 2.73058e-03, 3.10447e-03,
 3.52957e-03, 4.01287e-03, 4.56235e-03, 5.18707e-03, 5.89734e-03,
 6.70486e-03, 7.62295e-03, 8.66676e-03, 9.85350e-03, 1.12027e-02,
 1.27367e-02, 1.44808e-02, 1.64636e-02, 1.87180e-02, 2.12810e-02,
 2.41950e-02, 2.75080e-02, 3.12747e-02, 3.55571e-02, 4.04259e-02,
 4.59614e-02, 5.22549e-02, 5.94102e-02, 6.75452e-02, 7.67941e-02,
 8.73095e-02, 9.92648e-02, 1.12857e-01, 1.28311e-01, 1.45880e-01,
 1.65855e-01, 1.88566e-01, 2.14386e-01, 2.43742e-01, 2.77118e-01,
 3.15063e-01, 3.58205e-01, 4.07253e-01, 4.63019e-01, 5.26420e-01,
 5.98502e-01, 6.80455e-01, 7.73629e-01, 8.79562e-01, 1.00000e+00}
,
{2.41754e-06, 2.75491e-06, 3.13936e-06, 3.57746e-06, 4.07670e-06,
 4.64560e-06, 5.29390e-06, 6.03266e-06, 6.87453e-06, 7.83387e-06,
 8.92709e-06, 1.01729e-05, 1.15925e-05, 1.32102e-05, 1.50537e-05,
 1.71545e-05, 1.95484e-05, 2.22764e-05, 2.53851e-05, 2.89276e-05,
 3.29645e-05, 3.75647e-05, 4.28068e-05, 4.87806e-05, 5.55879e-05,
 6.33452e-05, 7.21851e-05, 8.22586e-05, 9.37378e-05, 1.06819e-04,
 1.21726e-04, 1.38712e-04, 1.58070e-04, 1.80129e-04, 2.05266e-04,
 2.33911e-04, 2.66553e-04, 3.03751e-04, 3.46139e-04, 3.94443e-04,
 4.49488e-04, 5.12214e-04, 5.83694e-04, 6.65149e-04, 7.57970e-04,
 8.63746e-04, 9.84282e-04, 1.12164e-03, 1.27816e-03, 1.45653e-03,
 1.65979e-03, 1.89142e-03, 2.15537e-03, 2.45615e-03, 2.79891e-03,
 3.18949e-03, 3.63459e-03, 4.14180e-03, 4.71979e-03, 5.37844e-03,
 6.12900e-03, 6.98431e-03, 7.95897e-03, 9.06965e-03, 1.03353e-02,
 1.17776e-02, 1.34212e-02, 1.52941e-02, 1.74284e-02, 1.98606e-02,
 2.26321e-02, 2.57905e-02, 2.93895e-02, 3.34909e-02, 3.81645e-02,
 4.34904e-02, 4.95595e-02, 5.64756e-02, 6.43568e-02, 7.33378e-02,
 8.35722e-02, 9.52347e-02, 1.08525e-01, 1.23669e-01, 1.40928e-01,
 1.60594e-01, 1.83005e-01, 2.08544e-01, 2.37646e-01, 2.70810e-01,
 3.08601e-01, 3.51667e-01, 4.00742e-01, 4.56666e-01, 5.20394e-01,
 5.93015e-01, 6.75770e-01, 7.70075e-01, 8.77539e-01, 1.00000e+00}
,
{1.92475e-06, 2.19841e-06, 2.51097e-06, 2.86797e-06, 3.27573e-06,
 3.74147e-06, 4.27342e-06, 4.88101e-06, 5.57498e-06, 6.36761e-06,
 7.27294e-06, 8.30699e-06, 9.48806e-06, 1.08370e-05, 1.23778e-05,
 1.41377e-05, 1.61477e-05, 1.84436e-05, 2.10658e-05, 2.40609e-05,
 2.74819e-05, 3.13892e-05, 3.58520e-05, 4.09493e-05, 4.67714e-05,
 5.34212e-05, 6.10165e-05, 6.96917e-05, 7.96003e-05, 9.09177e-05,
 1.03844e-04, 1.18608e-04, 1.35472e-04, 1.54733e-04, 1.76732e-04,
 2.01860e-04, 2.30560e-04, 2.63340e-04, 3.00781e-04, 3.43546e-04,
 3.92390e-04, 4.48179e-04, 5.11900e-04, 5.84681e-04, 6.67809e-04,
 7.62757e-04, 8.71203e-04, 9.95069e-04, 1.13655e-03, 1.29814e-03,
 1.48270e-03, 1.69351e-03, 1.93429e-03, 2.20930e-03, 2.52341e-03,
 2.88219e-03, 3.29197e-03, 3.76001e-03, 4.29460e-03, 4.90519e-03,
 5.60260e-03, 6.39917e-03, 7.30898e-03, 8.34816e-03, 9.53508e-03,
 1.08908e-02, 1.24392e-02, 1.42077e-02, 1.62278e-02, 1.85350e-02,
 2.11702e-02, 2.41802e-02, 2.76180e-02, 3.15447e-02, 3.60297e-02,
 4.11523e-02, 4.70032e-02, 5.36860e-02, 6.13189e-02, 7.00371e-02,
 7.99948e-02, 9.13683e-02, 1.04359e-01, 1.19196e-01, 1.36143e-01,
 1.55500e-01, 1.77608e-01, 2.02860e-01, 2.31702e-01, 2.64645e-01,
 3.02272e-01, 3.45248e-01, 3.94335e-01, 4.50400e-01, 5.14437e-01,
 5.87578e-01, 6.71119e-01, 7.66536e-01, 8.75521e-01, 1.00000e+00}
,
{1.53241e-06, 1.75432e-06, 2.00836e-06, 2.29919e-06, 2.63214e-06,
 3.01330e-06, 3.44966e-06, 3.94920e-06, 4.52109e-06, 5.17579e-06,
 5.92530e-06, 6.78334e-06, 7.76564e-06, 8.89019e-06, 1.01776e-05,
 1.16514e-05, 1.33386e-05, 1.52702e-05, 1.74815e-05, 2.00130e-05,
 2.29111e-05, 2.62289e-05, 3.00271e-05, 3.43753e-05, 3.93532e-05,
 4.50520e-05, 5.15760e-05, 5.90448e-05, 6.75951e-05, 7.73835e-05,
 8.85895e-05, 1.01418e-04, 1.16105e-04, 1.32918e-04, 1.52166e-04,
 1.74201e-04, 1.99427e-04, 2.28306e-04, 2.61367e-04, 2.99216e-04,
 3.42545e-04, 3.92149e-04, 4.48937e-04, 5.13948e-04, 5.88373e-04,
 6.73575e-04, 7.71116e-04, 8.82781e-04, 1.01062e-03, 1.15697e-03,
 1.32451e-03, 1.51631e-03, 1.73589e-03, 1.98726e-03, 2.27504e-03,
 2.60449e-03, 2.98164e-03, 3.41342e-03, 3.90771e-03, 4.47359e-03,
 5.12141e-03, 5.86305e-03, 6.71208e-03, 7.68406e-03, 8.79679e-03,
 1.00707e-02, 1.15290e-02, 1.31985e-02, 1.51098e-02, 1.72979e-02,
 1.98028e-02, 2.26704e-02, 2.59533e-02, 2.97116e-02, 3.40142e-02,
 3.89398e-02, 4.45787e-02, 5.10342e-02, 5.84244e-02, 6.68849e-02,
 7.65705e-02, 8.76588e-02, 1.00353e-01, 1.14885e-01, 1.31521e-01,
 1.50567e-01, 1.72371e-01, 1.97332e-01, 2.25907e-01, 2.58621e-01,
 2.96072e-01, 3.38947e-01, 3.88030e-01, 4.44220e-01, 5.08548e-01,
 5.82191e-01, 6.66499e-01, 7.63015e-01, 8.73507e-01, 1.00000e+00}
,
{1.22004e-06, 1.39994e-06, 1.60636e-06, 1.84321e-06, 2.11499e-06,
 2.42685e-06, 2.78468e-06, 3.19528e-06, 3.66643e-06, 4.20704e-06,
 4.82737e-06, 5.53916e-06, 6.35591e-06, 7.29308e-06, 8.36844e-06,
 9.60237e-06, 1.10182e-05, 1.26429e-05, 1.45070e-05, 1.66461e-05,
 1.91006e-05, 2.19169e-05, 2.51486e-05, 2.88567e-05, 3.31116e-05,
 3.79939e-05, 4.35961e-05, 5.00243e-05, 5.74004e-05, 6.58641e-05,
 7.55757e-05, 8.67193e-05, 9.95060e-05, 1.14178e-04, 1.31014e-04,
 1.50332e-04, 1.72498e-04, 1.97933e-04, 2.27118e-04, 2.60606e-04,
 2.99032e-04, 3.43124e-04, 3.93718e-04, 4.51772e-04, 5.18385e-04,
 5.94821e-04, 6.82527e-04, 7.83165e-04, 8.98642e-04, 1.03115e-03,
 1.18319e-03, 1.35765e-03, 1.55783e-03, 1.78754e-03, 2.05111e-03,
 2.35354e-03, 2.70057e-03, 3.09877e-03, 3.55568e-03, 4.07996e-03,
 4.68155e-03, 5.37185e-03, 6.16392e-03, 7.07279e-03, 8.11567e-03,
 9.31232e-03, 1.06854e-02, 1.22610e-02, 1.40689e-02, 1.61433e-02,
 1.85236e-02, 2.12549e-02, 2.43889e-02, 2.79851e-02, 3.21115e-02,
 3.68463e-02, 4.22793e-02, 4.85133e-02, 5.56666e-02, 6.38746e-02,
 7.32929e-02, 8.40999e-02, 9.65004e-02, 1.10729e-01, 1.27056e-01,
 1.45791e-01, 1.67287e-01, 1.91954e-01, 2.20257e-01, 2.52734e-01,
 2.90000e-01, 3.32760e-01, 3.81825e-01, 4.38125e-01, 5.02727e-01,
 5.76854e-01, 6.61910e-01, 7.59509e-01, 8.71498e-01, 1.00000e+00}
,
{9.71347e-07, 1.11714e-06, 1.28482e-06, 1.47766e-06, 1.69945e-06,
 1.95453e-06, 2.24790e-06, 2.58529e-06, 2.97333e-06, 3.41961e-06,
 3.93288e-06, 4.52318e-06, 5.20209e-06, 5.98289e-06, 6.88089e-06,
 7.91368e-06, 9.10148e-06, 1.04676e-05, 1.20387e-05, 1.38456e-05,
 1.59238e-05, 1.83139e-05, 2.10627e-05, 2.42241e-05, 2.78600e-05,
 3.20416e-05, 3.68509e-05, 4.23820e-05, 4.87433e-05, 5.60594e-05,
 6.44736e-05, 7.41508e-05, 8.52804e-05, 9.80806e-05, 1.12802e-04,
 1.29733e-04, 1.49205e-04, 1.71600e-04, 1.97356e-04, 2.26978e-04,
 2.61047e-04, 3.00228e-04, 3.45291e-04, 3.97117e-04, 4.56723e-04,
 5.25274e-04, 6.04115e-04, 6.94790e-04, 7.99074e-04, 9.19010e-04,
 1.05695e-03, 1.21559e-03, 1.39805e-03, 1.60788e-03, 1.84922e-03,
 2.12678e-03, 2.44600e-03, 2.81313e-03, 3.23536e-03, 3.72097e-03,
 4.27947e-03, 4.92180e-03, 5.66053e-03, 6.51015e-03, 7.48728e-03,
 8.61109e-03, 9.90356e-03, 1.13900e-02, 1.30996e-02, 1.50658e-02,
 1.73271e-02, 1.99278e-02, 2.29189e-02, 2.63589e-02, 3.03152e-02,
 3.48653e-02, 4.00984e-02, 4.61170e-02, 5.30389e-02, 6.09998e-02,
 7.01555e-02, 8.06855e-02, 9.27959e-02, 1.06724e-01, 1.22743e-01,
 1.41166e-01, 1.62354e-01, 1.86723e-01, 2.14749e-01, 2.46981e-01,
 2.84052e-01, 3.26687e-01, 3.75720e-01, 4.32114e-01, 4.96972e-01,
 5.71565e-01, 6.57354e-01, 7.56019e-01, 8.69494e-01, 1.00000e+00}
,
{7.73347e-07, 8.91473e-07, 1.02764e-06, 1.18461e-06, 1.36555e-06,
 1.57414e-06, 1.81458e-06, 2.09175e-06, 2.41126e-06, 2.77957e-06,
 3.20413e-06, 3.69355e-06, 4.25773e-06, 4.90808e-06, 5.65776e-06,
 6.52196e-06, 7.51817e-06, 8.66654e-06, 9.99032e-06, 1.15163e-05,
 1.32754e-05, 1.53031e-05, 1.76406e-05, 2.03351e-05, 2.34412e-05,
 2.70218e-05, 3.11493e-05, 3.59072e-05, 4.13919e-05, 4.77143e-05,
 5.50025e-05, 6.34039e-05, 7.30886e-05, 8.42525e-05, 9.71218e-05,
 1.11957e-04, 1.29058e-04, 1.48771e-04, 1.71495e-04, 1.97690e-04,
 2.27886e-04, 2.62695e-04, 3.02821e-04, 3.49075e-04, 4.02395e-04,
 4.63859e-04, 5.34712e-04, 6.16387e-04, 7.10537e-04, 8.19069e-04,
 9.44178e-04, 1.08840e-03, 1.25465e-03, 1.44629e-03, 1.66720e-03,
 1.92186e-03, 2.21542e-03, 2.55381e-03, 2.94390e-03, 3.39357e-03,
 3.91192e-03, 4.50945e-03, 5.19825e-03, 5.99226e-03, 6.90755e-03,
 7.96266e-03, 9.17892e-03, 1.05810e-02, 1.21972e-02, 1.40602e-02,
 1.62079e-02, 1.86836e-02, 2.15374e-02, 2.48271e-02, 2.86194e-02,
 3.29909e-02, 3.80301e-02, 4.38390e-02, 5.05353e-02, 5.82543e-02,
 6.71524e-02, 7.74097e-02, 8.92337e-02, 1.02864e-01, 1.18576e-01,
 1.36688e-01, 1.57566e-01, 1.81634e-01, 2.09378e-01, 2.41359e-01,
 2.78226e-01, 3.20724e-01, 3.69713e-01, 4.26185e-01, 4.91283e-01,
 5.66325e-01, 6.52829e-01, 7.52546e-01, 8.67494e-01, 1.00000e+00}
,
{6.15708e-07, 7.11391e-07, 8.21943e-07, 9.49676e-07, 1.09726e-06,
 1.26778e-06, 1.46479e-06, 1.69243e-06, 1.95543e-06, 2.25932e-06,
 2.61042e-06, 3.01609e-06, 3.48480e-06, 4.02635e-06, 4.65206e-06,
 5.37500e-06, 6.21029e-06, 7.17539e-06, 8.29047e-06, 9.57884e-06,
 1.10674e-05, 1.27873e-05, 1.47745e-05, 1.70705e-05, 1.97234e-05,
 2.27884e-05, 2.63298e-05, 3.04216e-05, 3.51492e-05, 4.06115e-05,
 4.69226e-05, 5.42146e-05, 6.26397e-05, 7.23741e-05, 8.36213e-05,
 9.66163e-05, 1.11631e-04, 1.28979e-04, 1.49022e-04, 1.72181e-04,
 1.98938e-04, 2.29854e-04, 2.65574e-04, 3.06845e-04, 3.54530e-04,
 4.09625e-04, 4.73282e-04, 5.46831e-04, 6.31811e-04, 7.29996e-04,
 8.43440e-04, 9.74513e-04, 1.12596e-03, 1.30093e-03, 1.50310e-03,
 1.73669e-03, 2.00658e-03, 2.31840e-03, 2.67869e-03, 3.09497e-03,
 3.57594e-03, 4.13165e-03, 4.77372e-03, 5.51557e-03, 6.37271e-03,
 7.36305e-03, 8.50730e-03, 9.82936e-03, 1.13569e-02, 1.31218e-02,
 1.51609e-02, 1.75170e-02, 2.02392e-02, 2.33844e-02, 2.70184e-02,
 3.12172e-02, 3.60684e-02, 4.16736e-02, 4.81498e-02, 5.56325e-02,
 6.42779e-02, 7.42669e-02, 8.58082e-02, 9.91431e-02, 1.14550e-01,
 1.32352e-01, 1.52920e-01, 1.76684e-01, 2.04141e-01, 2.35865e-01,
 2.72520e-01, 3.14870e-01, 3.63802e-01, 4.20338e-01, 4.85660e-01,
 5.61133e-01, 6.48335e-01, 7.49088e-01, 8.65499e-01, 1.00000e+00}
,
{4.90202e-07, 5.67686e-07, 6.57418e-07, 7.61334e-07, 8.81676e-07,
 1.02104e-06, 1.18243e-06, 1.36934e-06, 1.58578e-06, 1.83644e-06,
 2.12672e-06, 2.46289e-06, 2.85219e-06, 3.30302e-06, 3.82512e-06,
 4.42974e-06, 5.12994e-06, 5.94081e-06, 6.87985e-06, 7.96733e-06,
 9.22670e-06, 1.06851e-05, 1.23741e-05, 1.43300e-05, 1.65951e-05,
 1.92183e-05, 2.22560e-05, 2.57740e-05, 2.98480e-05, 3.45660e-05,
 4.00297e-05, 4.63571e-05, 5.36846e-05, 6.21703e-05, 7.19974e-05,
 8.33778e-05, 9.65570e-05, 1.11819e-04, 1.29494e-04, 1.49963e-04,
 1.73667e-04, 2.01118e-04, 2.32909e-04, 2.69724e-04, 3.12358e-04,
 3.61731e-04, 4.18909e-04, 4.85125e-04, 5.61807e-04, 6.50610e-04,
 7.53449e-04, 8.72545e-04, 1.01047e-03, 1.17019e-03, 1.35515e-03,
 1.56936e-03, 1.81742e-03, 2.10470e-03, 2.43738e-03, 2.82265e-03,
 3.26881e-03, 3.78550e-03, 4.38387e-03, 5.07681e-03, 5.87928e-03,
 6.80860e-03, 7.88482e-03, 9.13114e-03, 1.05745e-02, 1.22459e-02,
 1.41816e-02, 1.64233e-02, 1.90192e-02, 2.20255e-02, 2.55071e-02,
 2.95389e-02, 3.42080e-02, 3.96151e-02, 4.58770e-02, 5.31286e-02,
 6.15264e-02, 7.12517e-02, 8.25143e-02, 9.55570e-02, 1.10661e-01,
 1.28153e-01, 1.48410e-01, 1.71869e-01, 1.99035e-01, 2.30496e-01,
 2.66930e-01, 3.09123e-01, 3.57985e-01, 4.14571e-01, 4.80100e-01,
 5.55988e-01, 6.43872e-01, 7.45646e-01, 8.63508e-01, 1.00000e+00}
,
{3.90279e-07, 4.53011e-07, 5.25826e-07, 6.10345e-07, 7.08450e-07,
 8.22323e-07, 9.54501e-07, 1.10792e-06, 1.28601e-06, 1.49272e-06,
 1.73265e-06, 2.01115e-06, 2.33441e-06, 2.70964e-06, 3.14518e-06,
 3.65072e-06, 4.23752e-06, 4.91865e-06, 5.70925e-06, 6.62694e-06,
 7.69213e-06, 8.92853e-06, 1.03637e-05, 1.20295e-05, 1.39631e-05,
 1.62074e-05, 1.88126e-05, 2.18364e-05, 2.53463e-05, 2.94204e-05,
 3.41493e-05, 3.96384e-05, 4.60097e-05, 5.34051e-05, 6.19893e-05,
 7.19532e-05, 8.35187e-05, 9.69432e-05, 1.12526e-04, 1.30612e-04,
 1.51607e-04, 1.75975e-04, 2.04261e-04, 2.37093e-04, 2.75203e-04,
 3.19438e-04, 3.70783e-04, 4.30381e-04, 4.99559e-04, 5.79857e-04,
 6.73061e-04, 7.81246e-04, 9.06820e-04, 1.05258e-03, 1.22177e-03,
 1.41815e-03, 1.64610e-03, 1.91069e-03, 2.21780e-03, 2.57428e-03,
 2.98806e-03, 3.46836e-03, 4.02585e-03, 4.67295e-03, 5.42406e-03,
 6.29590e-03, 7.30788e-03, 8.48253e-03, 9.84598e-03, 1.14286e-02,
 1.32656e-02, 1.53978e-02, 1.78728e-02, 2.07456e-02, 2.40802e-02,
 2.79508e-02, 3.24435e-02, 3.76583e-02, 4.37114e-02, 5.07374e-02,
 5.88927e-02, 6.83590e-02, 7.93467e-02, 9.21006e-02, 1.06905e-01,
 1.24088e-01, 1.44033e-01, 1.67185e-01, 1.94058e-01, 2.25250e-01,
 2.61455e-01, 3.03481e-01, 3.52261e-01, 4.08882e-01, 4.74605e-01,
 5.50891e-01, 6.39439e-01, 7.42220e-01, 8.61522e-01, 1.00000e+00}
,
{3.10724e-07, 3.61500e-07, 4.20574e-07, 4.89300e-07, 5.69258e-07,
 6.62282e-07, 7.70506e-07, 8.96417e-07, 1.04290e-06, 1.21332e-06,
 1.41160e-06, 1.64227e-06, 1.91064e-06, 2.22286e-06, 2.58610e-06,
 3.00870e-06, 3.50036e-06, 4.07236e-06, 4.73783e-06, 5.51205e-06,
 6.41278e-06, 7.46071e-06, 8.67988e-06, 1.00983e-05, 1.17485e-05,
 1.36683e-05, 1.59019e-05, 1.85004e-05, 2.15236e-05, 2.50408e-05,
 2.91328e-05, 3.38935e-05, 3.94321e-05, 4.58757e-05, 5.33724e-05,
 6.20941e-05, 7.22410e-05, 8.40461e-05, 9.77802e-05, 1.13759e-04,
 1.32348e-04, 1.53976e-04, 1.79137e-04, 2.08410e-04, 2.42467e-04,
 2.82089e-04, 3.28186e-04, 3.81815e-04, 4.44209e-04, 5.16798e-04,
 6.01249e-04, 6.99500e-04, 8.13807e-04, 9.46793e-04, 1.10151e-03,
 1.28151e-03, 1.49092e-03, 1.73456e-03, 2.01801e-03, 2.34777e-03,
 2.73143e-03, 3.17778e-03, 3.69707e-03, 4.30121e-03, 5.00408e-03,
 5.82181e-03, 6.77316e-03, 7.87998e-03, 9.16767e-03, 1.06658e-02,
 1.24087e-02, 1.44364e-02, 1.67955e-02, 1.95401e-02, 2.27332e-02,
 2.64481e-02, 3.07700e-02, 3.57982e-02, 4.16480e-02, 4.84538e-02,
 5.63718e-02, 6.55836e-02, 7.63008e-02, 8.87693e-02, 1.03275e-01,
 1.20152e-01, 1.39786e-01, 1.62629e-01, 1.89204e-01, 2.20122e-01,
 2.56093e-01, 2.97942e-01, 3.46629e-01, 4.03272e-01, 4.69172e-01,
 5.45840e-01, 6.35037e-01, 7.38810e-01, 8.59541e-01, 1.00000e+00}
,
{2.47386e-07, 2.88475e-07, 3.36389e-07, 3.92261e-07, 4.57414e-07,
 5.33387e-07, 6.21980e-07, 7.25287e-07, 8.45753e-07, 9.86227e-07,
 1.15003e-06, 1.34105e-06, 1.56379e-06, 1.82352e-06, 2.12640e-06,
 2.47958e-06, 2.89143e-06, 3.37168e-06, 3.93169e-06, 4.58472e-06,
 5.34622e-06, 6.23419e-06, 7.26965e-06, 8.47710e-06, 9.88510e-06,
 1.15270e-05, 1.34415e-05, 1.56741e-05, 1.82774e-05, 2.13132e-05,
 2.48532e-05, 2.89812e-05, 3.37948e-05, 3.94079e-05, 4.59533e-05,
 5.35859e-05, 6.24862e-05, 7.28648e-05, 8.49672e-05, 9.90797e-05,
 1.15536e-04, 1.34726e-04, 1.57103e-04, 1.83197e-04, 2.13625e-04,
 2.49107e-04, 2.90482e-04, 3.38730e-04, 3.94991e-04, 4.60596e-04,
 5.37099e-04, 6.26308e-04, 7.30334e-04, 8.51638e-04, 9.93090e-04,
 1.15804e-03, 1.35038e-03, 1.57467e-03, 1.83621e-03, 2.14120e-03,
 2.49684e-03, 2.91155e-03, 3.39514e-03, 3.95905e-03, 4.61662e-03,
 5.38342e-03, 6.27757e-03, 7.32024e-03, 8.53609e-03, 9.95388e-03,
 1.16072e-02, 1.35350e-02, 1.57831e-02, 1.84046e-02, 2.14615e-02,
 2.50261e-02, 2.91828e-02, 3.40299e-02, 3.96821e-02, 4.62731e-02,
 5.39587e-02, 6.29210e-02, 7.33718e-02, 8.55584e-02, 9.97691e-02,
 1.16340e-01, 1.35664e-01, 1.58197e-01, 1.84472e-01, 2.15112e-01,
 2.50841e-01, 2.92504e-01, 3.41087e-01, 3.97739e-01, 4.63801e-01,
 5.40836e-01, 6.30666e-01, 7.35416e-01, 8.57564e-01, 1.00000e+00}
,
{1.96959e-07, 2.30202e-07, 2.69056e-07, 3.14467e-07, 3.67544e-07,
 4.29579e-07, 5.02084e-07, 5.86827e-07, 6.85873e-07, 8.01636e-07,
 9.36938e-07, 1.09508e-06, 1.27991e-06, 1.49593e-06, 1.74842e-06,
 2.04352e-06, 2.38843e-06, 2.79155e-06, 3.26272e-06, 3.81341e-06,
 4.45704e-06, 5.20931e-06, 6.08855e-06, 7.11619e-06, 8.31727e-06,
 9.72108e-06, 1.13618e-05, 1.32795e-05, 1.55208e-05, 1.81405e-05,
 2.12023e-05, 2.47808e-05, 2.89634e-05, 3.38519e-05, 3.95655e-05,
 4.62435e-05, 5.40485e-05, 6.31710e-05, 7.38331e-05, 8.62948e-05,
 1.00860e-04, 1.17883e-04, 1.37780e-04, 1.61035e-04, 1.88214e-04,
 2.19982e-04, 2.57111e-04, 3.00506e-04, 3.51226e-04, 4.10507e-04,
 4.79793e-04, 5.60774e-04, 6.55423e-04, 7.66046e-04, 8.95341e-04,
 1.04646e-03, 1.22308e-03, 1.42952e-03, 1.67079e-03, 1.95279e-03,
 2.28239e-03, 2.66762e-03, 3.11786e-03, 3.64410e-03, 4.25916e-03,
 4.97804e-03, 5.81824e-03, 6.80025e-03, 7.94802e-03, 9.28950e-03,
 1.08574e-02, 1.26899e-02, 1.48318e-02, 1.73351e-02, 2.02610e-02,
 2.36807e-02, 2.76775e-02, 3.23490e-02, 3.78090e-02, 4.41904e-02,
 5.16490e-02, 6.03664e-02, 7.05552e-02, 8.24637e-02, 9.63821e-02,
 1.12650e-01, 1.31663e-01, 1.53885e-01, 1.79858e-01, 2.10215e-01,
 2.45696e-01, 2.87165e-01, 3.35633e-01, 3.92282e-01, 4.58492e-01,
 5.35878e-01, 6.26324e-01, 7.32037e-01, 8.55591e-01, 1.00000e+00}
,
{1.56810e-07, 1.83700e-07, 2.15200e-07, 2.52102e-07, 2.95331e-07,
 3.45973e-07, 4.05300e-07, 4.74799e-07, 5.56216e-07, 6.51594e-07,
 7.63327e-07, 8.94220e-07, 1.04756e-06, 1.22719e-06, 1.43762e-06,
 1.68414e-06, 1.97293e-06, 2.31124e-06, 2.70757e-06, 3.17185e-06,
 3.71575e-06, 4.35291e-06, 5.09934e-06, 5.97375e-06, 6.99811e-06,
 8.19812e-06, 9.60391e-06, 1.12508e-05, 1.31800e-05, 1.54401e-05,
 1.80877e-05, 2.11893e-05, 2.48227e-05, 2.90792e-05, 3.40657e-05,
 3.99071e-05, 4.67503e-05, 5.47668e-05, 6.41580e-05, 7.51596e-05,
 8.80478e-05, 1.03146e-04, 1.20833e-04, 1.41553e-04, 1.65826e-04,
 1.94261e-04, 2.27573e-04, 2.66596e-04, 3.12311e-04, 3.65865e-04,
 4.28602e-04, 5.02097e-04, 5.88195e-04, 6.89057e-04, 8.07214e-04,
 9.45632e-04, 1.10779e-03, 1.29774e-03, 1.52028e-03, 1.78097e-03,
 2.08636e-03, 2.44413e-03, 2.86324e-03, 3.35421e-03, 3.92938e-03,
 4.60318e-03, 5.39252e-03, 6.31721e-03, 7.40046e-03, 8.66947e-03,
 1.01561e-02, 1.18976e-02, 1.39378e-02, 1.63278e-02, 1.91276e-02,
 2.24075e-02, 2.62499e-02, 3.07511e-02, 3.60242e-02, 4.22015e-02,
 4.94381e-02, 5.79156e-02, 6.78467e-02, 7.94809e-02, 9.31100e-02,
 1.09076e-01, 1.27780e-01, 1.49691e-01, 1.75360e-01, 2.05430e-01,
 2.40657e-01, 2.81924e-01, 3.30267e-01, 3.86900e-01, 4.53244e-01,
 5.30965e-01, 6.22013e-01, 7.28673e-01, 8.53624e-01, 1.00000e+00}
,
{1.24846e-07, 1.46591e-07, 1.72124e-07, 2.02104e-07, 2.37306e-07,
 2.78640e-07, 3.27172e-07, 3.84158e-07, 4.51070e-07, 5.29635e-07,
 6.21886e-07, 7.30204e-07, 8.57389e-07, 1.00673e-06, 1.18207e-06,
 1.38797e-06, 1.62972e-06, 1.91358e-06, 2.24688e-06, 2.63823e-06,
 3.09775e-06, 3.63731e-06, 4.27084e-06, 5.01473e-06, 5.88818e-06,
 6.91376e-06, 8.11798e-06, 9.53195e-06, 1.11922e-05, 1.31416e-05,
 1.54306e-05, 1.81182e-05, 2.12740e-05, 2.49795e-05, 2.93303e-05,
 3.44390e-05, 4.04375e-05, 4.74807e-05, 5.57508e-05, 6.54613e-05,
 7.68632e-05, 9.02510e-05, 1.05971e-04, 1.24428e-04, 1.46101e-04,
 1.71548e-04, 2.01428e-04, 2.36512e-04, 2.77707e-04, 3.26077e-04,
 3.82873e-04, 4.49560e-04, 5.27863e-04, 6.19805e-04, 7.27761e-04,
 8.54520e-04, 1.00336e-03, 1.17812e-03, 1.38332e-03, 1.62426e-03,
 1.90717e-03, 2.23936e-03, 2.62940e-03, 3.08739e-03, 3.62514e-03,
 4.25655e-03, 4.99795e-03, 5.86847e-03, 6.89063e-03, 8.09082e-03,
 9.50005e-03, 1.11547e-02, 1.30976e-02, 1.53790e-02, 1.80576e-02,
 2.12028e-02, 2.48959e-02, 2.92322e-02, 3.43237e-02, 4.03022e-02,
 4.73219e-02, 5.55642e-02, 6.52423e-02, 7.66060e-02, 8.99490e-02,
 1.05616e-01, 1.24012e-01, 1.45612e-01, 1.70974e-01, 2.00754e-01,
 2.35721e-01, 2.76778e-01, 3.24986e-01, 3.81591e-01, 4.48056e-01,
 5.26097e-01, 6.17731e-01, 7.25325e-01, 8.51660e-01, 1.00000e+00}
,
{9.93973e-08, 1.16979e-07, 1.37671e-07, 1.62023e-07, 1.90682e-07,
 2.24410e-07, 2.64105e-07, 3.10821e-07, 3.65800e-07, 4.30504e-07,
 5.06653e-07, 5.96272e-07, 7.01743e-07, 8.25870e-07, 9.71952e-07,
 1.14388e-06, 1.34621e-06, 1.58433e-06, 1.86457e-06, 2.19439e-06,
 2.58254e-06, 3.03935e-06, 3.57696e-06, 4.20966e-06, 4.95428e-06,
 5.83062e-06, 6.86196e-06, 8.07573e-06, 9.50419e-06, 1.11853e-05,
 1.31638e-05, 1.54923e-05, 1.82326e-05, 2.14577e-05, 2.52532e-05,
 2.97201e-05, 3.49771e-05, 4.11640e-05, 4.84452e-05, 5.70144e-05,
 6.70994e-05, 7.89681e-05, 9.29363e-05, 1.09375e-04, 1.28722e-04,
 1.51491e-04, 1.78287e-04, 2.09823e-04, 2.46937e-04, 2.90617e-04,
 3.42022e-04, 4.02520e-04, 4.73720e-04, 5.57513e-04, 6.56128e-04,
 7.72186e-04, 9.08774e-04, 1.06952e-03, 1.25870e-03, 1.48135e-03,
 1.74337e-03, 2.05175e-03, 2.41467e-03, 2.84178e-03, 3.34445e-03,
 3.93603e-03, 4.63225e-03, 5.45162e-03, 6.41592e-03, 7.55079e-03,
 8.88640e-03, 1.04583e-02, 1.23082e-02, 1.44853e-02, 1.70475e-02,
 2.00629e-02, 2.36117e-02, 2.77882e-02, 3.27035e-02, 3.84883e-02,
 4.52962e-02, 5.33084e-02, 6.27378e-02, 7.38351e-02, 8.68953e-02,
 1.02266e-01, 1.20355e-01, 1.41644e-01, 1.66698e-01, 1.96184e-01,
 2.30886e-01, 2.71726e-01, 3.19790e-01, 3.76356e-01, 4.42927e-01,
 5.21274e-01, 6.13478e-01, 7.21993e-01, 8.49702e-01, 1.00000e+00}
,
{7.91361e-08, 9.33487e-08, 1.10114e-07, 1.29890e-07, 1.53218e-07,
 1.80735e-07, 2.13195e-07, 2.51484e-07, 2.96649e-07, 3.49927e-07,
 4.12772e-07, 4.86905e-07, 5.74352e-07, 6.77503e-07, 7.99181e-07,
 9.42711e-07, 1.11202e-06, 1.31173e-06, 1.54732e-06, 1.82521e-06,
 2.15301e-06, 2.53969e-06, 2.99581e-06, 3.53384e-06, 4.16851e-06,
 4.91716e-06, 5.80027e-06, 6.84198e-06, 8.07078e-06, 9.52026e-06,
 1.12301e-05, 1.32470e-05, 1.56261e-05, 1.84325e-05, 2.17429e-05,
 2.56478e-05, 3.02541e-05, 3.56876e-05, 4.20970e-05, 4.96575e-05,
 5.85758e-05, 6.90958e-05, 8.15052e-05, 9.61433e-05, 1.13410e-04,
 1.33778e-04, 1.57805e-04, 1.86146e-04, 2.19577e-04, 2.59012e-04,
 3.05530e-04, 3.60402e-04, 4.25130e-04, 5.01482e-04, 5.91546e-04,
 6.97786e-04, 8.23106e-04, 9.70933e-04, 1.14531e-03, 1.35100e-03,
 1.59364e-03, 1.87985e-03, 2.21747e-03, 2.61572e-03, 3.08549e-03,
 3.63964e-03, 4.29330e-03, 5.06437e-03, 5.97391e-03, 7.04681e-03,
 8.31239e-03, 9.80527e-03, 1.15663e-02, 1.36435e-02, 1.60939e-02,
 1.89843e-02, 2.23938e-02, 2.64156e-02, 3.11598e-02, 3.67560e-02,
 4.33573e-02, 5.11441e-02, 6.03294e-02, 7.11644e-02, 8.39453e-02,
 9.90216e-02, 1.16806e-01, 1.37783e-01, 1.62529e-01, 1.91719e-01,
 2.26151e-01, 2.66767e-01, 3.14677e-01, 3.71192e-01, 4.37857e-01,
 5.16494e-01, 6.09255e-01, 7.18675e-01, 8.47747e-01, 1.00000e+00}
,
{6.30050e-08, 7.44918e-08, 8.80728e-08, 1.04130e-07, 1.23114e-07,
 1.45560e-07, 1.72098e-07, 2.03474e-07, 2.40571e-07, 2.84431e-07,
 3.36287e-07, 3.97598e-07, 4.70087e-07, 5.55791e-07, 6.57121e-07,
 7.76924e-07, 9.18570e-07, 1.08604e-06, 1.28404e-06, 1.51814e-06,
 1.79493e-06, 2.12217e-06, 2.50908e-06, 2.96652e-06, 3.50736e-06,
 4.14681e-06, 4.90284e-06, 5.79671e-06, 6.85354e-06, 8.10306e-06,
 9.58037e-06, 1.13270e-05, 1.33921e-05, 1.58337e-05, 1.87205e-05,
 2.21335e-05, 2.61688e-05, 3.09398e-05, 3.65806e-05, 4.32499e-05,
 5.11350e-05, 6.04577e-05, 7.14802e-05, 8.45121e-05, 9.99201e-05,
 1.18137e-04, 1.39675e-04, 1.65140e-04, 1.95248e-04, 2.30845e-04,
 2.72932e-04, 3.22692e-04, 3.81524e-04, 4.51081e-04, 5.33321e-04,
 6.30554e-04, 7.45514e-04, 8.81433e-04, 1.04213e-03, 1.23213e-03,
 1.45677e-03, 1.72236e-03, 2.03637e-03, 2.40764e-03, 2.84659e-03,
 3.36557e-03, 3.97916e-03, 4.70463e-03, 5.56236e-03, 6.57646e-03,
 7.77546e-03, 9.19305e-03, 1.08691e-02, 1.28507e-02, 1.51936e-02,
 1.79636e-02, 2.12387e-02, 2.51108e-02, 2.96889e-02, 3.51017e-02,
 4.15013e-02, 4.90677e-02, 5.80135e-02, 6.85903e-02, 8.10954e-02,
 9.58804e-02, 1.13361e-01, 1.34028e-01, 1.58464e-01, 1.87354e-01,
 2.21512e-01, 2.61897e-01, 3.09646e-01, 3.66099e-01, 4.32845e-01,
 5.11759e-01, 6.05061e-01, 7.15373e-01, 8.45798e-01, 1.00000e+00}
,
{5.01620e-08, 5.94441e-08, 7.04437e-08, 8.34787e-08, 9.89257e-08,
 1.17231e-07, 1.38924e-07, 1.64630e-07, 1.95094e-07, 2.31194e-07,
 2.73975e-07, 3.24672e-07, 3.84749e-07, 4.55944e-07, 5.40313e-07,
 6.40293e-07, 7.58774e-07, 8.99178e-07, 1.06556e-06, 1.26274e-06,
 1.49640e-06, 1.77329e-06, 2.10142e-06, 2.49028e-06, 2.95108e-06,
 3.49715e-06, 4.14427e-06, 4.91113e-06, 5.81990e-06, 6.89682e-06,
 8.17302e-06, 9.68537e-06, 1.14776e-05, 1.36014e-05, 1.61182e-05,
 1.91007e-05, 2.26352e-05, 2.68236e-05, 3.17871e-05, 3.76691e-05,
 4.46394e-05, 5.28995e-05, 6.26882e-05, 7.42881e-05, 8.80345e-05,
 1.04324e-04, 1.23629e-04, 1.46505e-04, 1.73615e-04, 2.05741e-04,
 2.43812e-04, 2.88927e-04, 3.42390e-04, 4.05747e-04, 4.80827e-04,
 5.69800e-04, 6.75236e-04, 8.00183e-04, 9.48250e-04, 1.12372e-03,
 1.33165e-03, 1.57806e-03, 1.87007e-03, 2.21611e-03, 2.62618e-03,
 3.11213e-03, 3.68801e-03, 4.37044e-03, 5.17915e-03, 6.13751e-03,
 7.27321e-03, 8.61905e-03, 1.02139e-02, 1.21039e-02, 1.43437e-02,
 1.69978e-02, 2.01432e-02, 2.38705e-02, 2.82875e-02, 3.35219e-02,
 3.97248e-02, 4.70756e-02, 5.57865e-02, 6.61093e-02, 7.83423e-02,
 9.28389e-02, 1.10018e-01, 1.30376e-01, 1.54501e-01, 1.83090e-01,
 2.16969e-01, 2.57117e-01, 3.04695e-01, 3.61076e-01, 4.27890e-01,
 5.07067e-01, 6.00896e-01, 7.12087e-01, 8.43852e-01, 1.00000e+00}
,
{3.99369e-08, 4.74360e-08, 5.63433e-08, 6.69230e-08, 7.94894e-08,
 9.44154e-08, 1.12144e-07, 1.33202e-07, 1.58213e-07, 1.87922e-07,
 2.23208e-07, 2.65121e-07, 3.14904e-07, 3.74034e-07, 4.44268e-07,
 5.27690e-07, 6.26776e-07, 7.44468e-07, 8.84259e-07, 1.05030e-06,
 1.24752e-06, 1.48177e-06, 1.76000e-06, 2.09049e-06, 2.48302e-06,
 2.94927e-06, 3.50306e-06, 4.16085e-06, 4.94214e-06, 5.87015e-06,
 6.97240e-06, 8.28163e-06, 9.83670e-06, 1.16838e-05, 1.38777e-05,
 1.64835e-05, 1.95787e-05, 2.32551e-05, 2.76217e-05, 3.28084e-05,
 3.89689e-05, 4.62862e-05, 5.49776e-05, 6.53009e-05, 7.75627e-05,
 9.21269e-05, 1.09426e-04, 1.29973e-04, 1.54379e-04, 1.83367e-04,
 2.17798e-04, 2.58695e-04, 3.07271e-04, 3.64968e-04, 4.33499e-04,
 5.14899e-04, 6.11583e-04, 7.26423e-04, 8.62825e-04, 1.02484e-03,
 1.21728e-03, 1.44585e-03, 1.71734e-03, 2.03982e-03, 2.42284e-03,
 2.87778e-03, 3.41815e-03, 4.05999e-03, 4.82235e-03, 5.72786e-03,
 6.80340e-03, 8.08090e-03, 9.59827e-03, 1.14006e-02, 1.35413e-02,
 1.60840e-02, 1.91041e-02, 2.26914e-02, 2.69522e-02, 3.20131e-02,
 3.80244e-02, 4.51643e-02, 5.36450e-02, 6.37181e-02, 7.56826e-02,
 8.98938e-02, 1.06773e-01, 1.26823e-01, 1.50637e-01, 1.78922e-01,
 2.12519e-01, 2.52424e-01, 2.99823e-01, 3.56122e-01, 4.22992e-01,
 5.02419e-01, 5.96759e-01, 7.08815e-01, 8.41911e-01, 1.00000e+00}
,
{3.17962e-08, 3.78537e-08, 4.50653e-08, 5.36507e-08, 6.38718e-08,
 7.60401e-08, 9.05266e-08, 1.07773e-07, 1.28305e-07, 1.52749e-07,
 1.81849e-07, 2.16493e-07, 2.57738e-07, 3.06840e-07, 3.65296e-07,
 4.34889e-07, 5.17741e-07, 6.16376e-07, 7.33803e-07, 8.73601e-07,
 1.04003e-06, 1.23817e-06, 1.47406e-06, 1.75488e-06, 2.08920e-06,
 2.48722e-06, 2.96107e-06, 3.52518e-06, 4.19677e-06, 4.99630e-06,
 5.94816e-06, 7.08135e-06, 8.43043e-06, 1.00365e-05, 1.19486e-05,
 1.42249e-05, 1.69350e-05, 2.01613e-05, 2.40022e-05, 2.85749e-05,
 3.40187e-05, 4.04997e-05, 4.82154e-05, 5.74010e-05, 6.83365e-05,
 8.13554e-05, 9.68545e-05, 1.15306e-04, 1.37274e-04, 1.63426e-04,
 1.94560e-04, 2.31626e-04, 2.75754e-04, 3.28288e-04, 3.90831e-04,
 4.65288e-04, 5.53931e-04, 6.59461e-04, 7.85096e-04, 9.34666e-04,
 1.11273e-03, 1.32472e-03, 1.57709e-03, 1.87755e-03, 2.23524e-03,
 2.66108e-03, 3.16805e-03, 3.77160e-03, 4.49013e-03, 5.34555e-03,
 6.36394e-03, 7.57634e-03, 9.01972e-03, 1.07381e-02, 1.27838e-02,
 1.52193e-02, 1.81187e-02, 2.15705e-02, 2.56800e-02, 3.05723e-02,
 3.63967e-02, 4.33307e-02, 5.15857e-02, 6.14133e-02, 7.31133e-02,
 8.70422e-02, 1.03625e-01, 1.23366e-01, 1.46869e-01, 1.74849e-01,
 2.08160e-01, 2.47817e-01, 2.95029e-01, 3.51236e-01, 4.18150e-01,
 4.97812e-01, 5.92651e-01, 7.05558e-01, 8.39975e-01, 1.00000e+00}
,
{2.53148e-08, 3.02071e-08, 3.60447e-08, 4.30106e-08, 5.13227e-08,
 6.12411e-08, 7.30763e-08, 8.71987e-08, 1.04050e-07, 1.24159e-07,
 1.48153e-07, 1.76785e-07, 2.10949e-07, 2.51716e-07, 3.00362e-07,
 3.58409e-07, 4.27673e-07, 5.10324e-07, 6.08947e-07, 7.26629e-07,
 8.67055e-07, 1.03462e-06, 1.23456e-06, 1.47315e-06, 1.75785e-06,
 2.09756e-06, 2.50293e-06, 2.98663e-06, 3.56382e-06, 4.25254e-06,
 5.07437e-06, 6.05503e-06, 7.22520e-06, 8.62151e-06, 1.02877e-05,
 1.22758e-05, 1.46482e-05, 1.74790e-05, 2.08570e-05, 2.48877e-05,
 2.96974e-05, 3.54366e-05, 4.22849e-05, 5.04567e-05, 6.02078e-05,
 7.18433e-05, 8.57274e-05, 1.02295e-04, 1.22064e-04, 1.45653e-04,
 1.73802e-04, 2.07390e-04, 2.47469e-04, 2.95294e-04, 3.52362e-04,
 4.20458e-04, 5.01713e-04, 5.98673e-04, 7.14370e-04, 8.52426e-04,
 1.01716e-03, 1.21373e-03, 1.44830e-03, 1.72819e-03, 2.06217e-03,
 2.46070e-03, 2.93624e-03, 3.50369e-03, 4.18079e-03, 4.98876e-03,
 5.95286e-03, 7.10329e-03, 8.47604e-03, 1.01141e-02, 1.20687e-02,
 1.44010e-02, 1.71841e-02, 2.05051e-02, 2.44678e-02, 2.91963e-02,
 3.48387e-02, 4.15715e-02, 4.96054e-02, 5.91919e-02, 7.06311e-02,
 8.42810e-02, 1.00569e-01, 1.20004e-01, 1.43196e-01, 1.70869e-01,
 2.03891e-01, 2.43294e-01, 2.90312e-01, 3.46416e-01, 4.13363e-01,
 4.93248e-01, 5.88572e-01, 7.02316e-01, 8.38043e-01, 1.00000e+00}
,
{2.01546e-08, 2.41051e-08, 2.88298e-08, 3.44807e-08, 4.12391e-08,
 4.93222e-08, 5.89897e-08, 7.05521e-08, 8.43808e-08, 1.00920e-07,
 1.20701e-07, 1.44359e-07, 1.72654e-07, 2.06496e-07, 2.46970e-07,
 2.95378e-07, 3.53274e-07, 4.22519e-07, 5.05335e-07, 6.04384e-07,
 7.22847e-07, 8.64530e-07, 1.03398e-06, 1.23665e-06, 1.47904e-06,
 1.76895e-06, 2.11567e-06, 2.53036e-06, 3.02632e-06, 3.61950e-06,
 4.32895e-06, 5.17745e-06, 6.19227e-06, 7.40599e-06, 8.85762e-06,
 1.05938e-05, 1.26702e-05, 1.51537e-05, 1.81239e-05, 2.16763e-05,
 2.59250e-05, 3.10064e-05, 3.70839e-05, 4.43526e-05, 5.30460e-05,
 6.34434e-05, 7.58787e-05, 9.07514e-05, 1.08539e-04, 1.29814e-04,
 1.55258e-04, 1.85690e-04, 2.22086e-04, 2.65616e-04, 3.17679e-04,
 3.79946e-04, 4.54418e-04, 5.43487e-04, 6.50014e-04, 7.77421e-04,
 9.29801e-04, 1.11205e-03, 1.33002e-03, 1.59071e-03, 1.90250e-03,
 2.27540e-03, 2.72140e-03, 3.25481e-03, 3.89277e-03, 4.65578e-03,
 5.56834e-03, 6.65977e-03, 7.96513e-03, 9.52635e-03, 1.13936e-02,
 1.36268e-02, 1.62977e-02, 1.94922e-02, 2.33128e-02, 2.78823e-02,
 3.33474e-02, 3.98837e-02, 4.77012e-02, 5.70509e-02, 6.82333e-02,
 8.16074e-02, 9.76030e-02, 1.16734e-01, 1.39615e-01, 1.66980e-01,
 1.99709e-01, 2.38853e-01, 2.85670e-01, 3.41663e-01, 4.08632e-01,
 4.88726e-01, 5.84520e-01, 6.99090e-01, 8.36116e-01, 1.00000e+00}
,
{1.60463e-08, 1.92357e-08, 2.30591e-08, 2.76424e-08, 3.31367e-08,
 3.97231e-08, 4.76186e-08, 5.70834e-08, 6.84295e-08, 8.20308e-08,
 9.83356e-08, 1.17881e-07, 1.41312e-07, 1.69399e-07, 2.03070e-07,
 2.43433e-07, 2.91818e-07, 3.49821e-07, 4.19353e-07, 5.02705e-07,
 6.02624e-07, 7.22404e-07, 8.65992e-07, 1.03812e-06, 1.24446e-06,
 1.49181e-06, 1.78833e-06, 2.14379e-06, 2.56989e-06, 3.08070e-06,
 3.69303e-06, 4.42707e-06, 5.30701e-06, 6.36185e-06, 7.62635e-06,
 9.14219e-06, 1.09593e-05, 1.31376e-05, 1.57489e-05, 1.88793e-05,
 2.26318e-05, 2.71301e-05, 3.25226e-05, 3.89869e-05, 4.67361e-05,
 5.60256e-05, 6.71614e-05, 8.05107e-05, 9.65133e-05, 1.15697e-04,
 1.38693e-04, 1.66260e-04, 1.99306e-04, 2.38921e-04, 2.86410e-04,
 3.43338e-04, 4.11581e-04, 4.93389e-04, 5.91457e-04, 7.09017e-04,
 8.49944e-04, 1.01888e-03, 1.22140e-03, 1.46417e-03, 1.75519e-03,
 2.10406e-03, 2.52227e-03, 3.02361e-03, 3.62459e-03, 4.34503e-03,
 5.20866e-03, 6.24395e-03, 7.48502e-03, 8.97277e-03, 1.07562e-02,
 1.28942e-02, 1.54571e-02, 1.85294e-02, 2.22124e-02, 2.66274e-02,
 3.19199e-02, 3.82644e-02, 4.58700e-02, 5.49873e-02, 6.59168e-02,
 7.90187e-02, 9.47247e-02, 1.13553e-01, 1.36123e-01, 1.63179e-01,
 1.95613e-01, 2.34494e-01, 2.81103e-01, 3.36976e-01, 4.03954e-01,
 4.84246e-01, 5.80496e-01, 6.95878e-01, 8.34193e-01, 1.00000e+00}
,
{1.27754e-08, 1.53500e-08, 1.84434e-08, 2.21603e-08, 2.66262e-08,
 3.19921e-08, 3.84394e-08, 4.61860e-08, 5.54937e-08, 6.66772e-08,
 8.01144e-08, 9.62597e-08, 1.15659e-07, 1.38967e-07, 1.66973e-07,
 2.00622e-07, 2.41053e-07, 2.89632e-07, 3.48000e-07, 4.18132e-07,
 5.02396e-07, 6.03643e-07, 7.25293e-07, 8.71460e-07, 1.04708e-06,
 1.25810e-06, 1.51164e-06, 1.81628e-06, 2.18230e-06, 2.62210e-06,
 3.15052e-06, 3.78544e-06, 4.54831e-06, 5.46491e-06, 6.56624e-06,
 7.88952e-06, 9.47947e-06, 1.13898e-05, 1.36852e-05, 1.64431e-05,
 1.97569e-05, 2.37384e-05, 2.85224e-05, 3.42704e-05, 4.11768e-05,
 4.94751e-05, 5.94456e-05, 7.14255e-05, 8.58197e-05, 1.03115e-04,
 1.23895e-04, 1.48863e-04, 1.78863e-04, 2.14909e-04, 2.58219e-04,
 3.10257e-04, 3.72783e-04, 4.47909e-04, 5.38174e-04, 6.46631e-04,
 7.76945e-04, 9.33520e-04, 1.12165e-03, 1.34769e-03, 1.61929e-03,
 1.94562e-03, 2.33772e-03, 2.80883e-03, 3.37488e-03, 4.05501e-03,
 4.87221e-03, 5.85409e-03, 7.03385e-03, 8.45136e-03, 1.01545e-02,
 1.22010e-02, 1.46598e-02, 1.76141e-02, 2.11638e-02, 2.54289e-02,
 3.05536e-02, 3.67109e-02, 4.41092e-02, 5.29984e-02, 6.36790e-02,
 7.65120e-02, 9.19313e-02, 1.10458e-01, 1.32718e-01, 1.59465e-01,
 1.91601e-01, 2.30214e-01, 2.76608e-01, 3.32352e-01, 3.99330e-01,
 4.79806e-01, 5.76500e-01, 6.92680e-01, 8.32274e-01, 1.00000e+00}
,
{1.01713e-08, 1.22492e-08, 1.47517e-08, 1.77654e-08, 2.13948e-08,
 2.57657e-08, 3.10296e-08, 3.73689e-08, 4.50032e-08, 5.41972e-08,
 6.52696e-08, 7.86039e-08, 9.46625e-08, 1.14002e-07, 1.37292e-07,
 1.65340e-07, 1.99119e-07, 2.39798e-07, 2.88788e-07, 3.47787e-07,
 4.18838e-07, 5.04406e-07, 6.07455e-07, 7.31556e-07, 8.81010e-07,
 1.06100e-06, 1.27776e-06, 1.53880e-06, 1.85317e-06, 2.23177e-06,
 2.68771e-06, 3.23680e-06, 3.89807e-06, 4.69443e-06, 5.65349e-06,
 6.80848e-06, 8.19944e-06, 9.87456e-06, 1.18919e-05, 1.43214e-05,
 1.72472e-05, 2.07707e-05, 2.50141e-05, 3.01244e-05, 3.62788e-05,
 4.36904e-05, 5.26162e-05, 6.33656e-05, 7.63110e-05, 9.19011e-05,
 1.10676e-04, 1.33287e-04, 1.60517e-04, 1.93310e-04, 2.32803e-04,
 2.80364e-04, 3.37641e-04, 4.06621e-04, 4.89692e-04, 5.89734e-04,
 7.10215e-04, 8.55310e-04, 1.03005e-03, 1.24048e-03, 1.49391e-03,
 1.79911e-03, 2.16666e-03, 2.60931e-03, 3.14238e-03, 3.78436e-03,
 4.55749e-03, 5.48857e-03, 6.60987e-03, 7.96025e-03, 9.58651e-03,
 1.15450e-02, 1.39036e-02, 1.67441e-02, 2.01648e-02, 2.42844e-02,
 2.92457e-02, 3.52205e-02, 4.24159e-02, 5.10814e-02, 6.15171e-02,
 7.40849e-02, 8.92202e-02, 1.07448e-01, 1.29399e-01, 1.55835e-01,
 1.87671e-01, 2.26012e-01, 2.72185e-01, 3.27792e-01, 3.94759e-01,
 4.75407e-01, 5.72531e-01, 6.89498e-01, 8.30360e-01, 1.00000e+00}
,
{8.09795e-09, 9.77481e-09, 1.17989e-08, 1.42422e-08, 1.71913e-08,
 2.07512e-08, 2.50482e-08, 3.02350e-08, 3.64959e-08, 4.40532e-08,
 5.31754e-08, 6.41866e-08, 7.74779e-08, 9.35215e-08, 1.12887e-07,
 1.36263e-07, 1.64480e-07, 1.98539e-07, 2.39651e-07, 2.89276e-07,
 3.49178e-07, 4.21483e-07, 5.08761e-07, 6.14112e-07, 7.41278e-07,
 8.94776e-07, 1.08006e-06, 1.30371e-06, 1.57368e-06, 1.89954e-06,
 2.29289e-06, 2.76768e-06, 3.34079e-06, 4.03258e-06, 4.86762e-06,
 5.87558e-06, 7.09225e-06, 8.56086e-06, 1.03336e-05, 1.24734e-05,
 1.50563e-05, 1.81741e-05, 2.19374e-05, 2.64801e-05, 3.19634e-05,
 3.85821e-05, 4.65715e-05, 5.62152e-05, 6.78558e-05, 8.19069e-05,
 9.88676e-05, 1.19340e-04, 1.44053e-04, 1.73882e-04, 2.09888e-04,
 2.53351e-04, 3.05813e-04, 3.69138e-04, 4.45577e-04, 5.37844e-04,
 6.49217e-04, 7.83653e-04, 9.45926e-04, 1.14180e-03, 1.37824e-03,
 1.66363e-03, 2.00813e-03, 2.42396e-03, 2.92590e-03, 3.53177e-03,
 4.26310e-03, 5.14588e-03, 6.21145e-03, 7.49768e-03, 9.05024e-03,
 1.09243e-02, 1.31864e-02, 1.59170e-02, 1.92130e-02, 2.31915e-02,
 2.79938e-02, 3.37906e-02, 4.07877e-02, 4.92337e-02, 5.94287e-02,
 7.17348e-02, 8.65891e-02, 1.04519e-01, 1.26163e-01, 1.52287e-01,
 1.83822e-01, 2.21887e-01, 2.67833e-01, 3.23295e-01, 3.90240e-01,
 4.71049e-01, 5.68590e-01, 6.86330e-01, 8.28450e-01, 1.00000e+00}
,
{6.44725e-09, 7.80025e-09, 9.43717e-09, 1.14176e-08, 1.38137e-08,
 1.67126e-08, 2.02198e-08, 2.44630e-08, 2.95967e-08, 3.58078e-08,
 4.33222e-08, 5.24136e-08, 6.34129e-08, 7.67205e-08, 9.28207e-08,
 1.12300e-07, 1.35866e-07, 1.64379e-07, 1.98875e-07, 2.40610e-07,
 2.91103e-07, 3.52193e-07, 4.26102e-07, 5.15522e-07, 6.23707e-07,
 7.54596e-07, 9.12952e-07, 1.10454e-06, 1.33633e-06, 1.61677e-06,
 1.95606e-06, 2.36655e-06, 2.86319e-06, 3.46404e-06, 4.19099e-06,
 5.07050e-06, 6.13457e-06, 7.42194e-06, 8.97948e-06, 1.08639e-05,
 1.31437e-05, 1.59020e-05, 1.92391e-05, 2.32766e-05, 2.81613e-05,
 3.40711e-05, 4.12211e-05, 4.98716e-05, 6.03375e-05, 7.29996e-05,
 8.83190e-05, 1.06853e-04, 1.29277e-04, 1.56407e-04, 1.89229e-04,
 2.28940e-04, 2.76985e-04, 3.35111e-04, 4.05437e-04, 4.90520e-04,
 5.93458e-04, 7.17999e-04, 8.68675e-04, 1.05097e-03, 1.27152e-03,
 1.53836e-03, 1.86119e-03, 2.25178e-03, 2.72432e-03, 3.29604e-03,
 3.98773e-03, 4.82458e-03, 5.83705e-03, 7.06198e-03, 8.54398e-03,
 1.03370e-02, 1.25063e-02, 1.51308e-02, 1.83061e-02, 2.21477e-02,
 2.67955e-02, 3.24187e-02, 3.92219e-02, 4.74529e-02, 5.74111e-02,
 6.94592e-02, 8.40356e-02, 1.01671e-01, 1.23007e-01, 1.48821e-01,
 1.80052e-01, 2.17837e-01, 2.63551e-01, 3.18859e-01, 3.85773e-01,
 4.66730e-01, 5.64676e-01, 6.83176e-01, 8.26545e-01, 1.00000e+00}
,
{5.13304e-09, 6.22456e-09, 7.54818e-09, 9.15326e-09, 1.10996e-08,
 1.34599e-08, 1.63221e-08, 1.97929e-08, 2.40018e-08, 2.91056e-08,
 3.52948e-08, 4.28001e-08, 5.19013e-08, 6.29378e-08, 7.63212e-08,
 9.25505e-08, 1.12231e-07, 1.36096e-07, 1.65036e-07, 2.00130e-07,
 2.42687e-07, 2.94293e-07, 3.56873e-07, 4.32760e-07, 5.24784e-07,
 6.36377e-07, 7.71699e-07, 9.35797e-07, 1.13479e-06, 1.37610e-06,
 1.66872e-06, 2.02356e-06, 2.45386e-06, 2.97566e-06, 3.60842e-06,
 4.37573e-06, 5.30620e-06, 6.43454e-06, 7.80281e-06, 9.46204e-06,
 1.14741e-05, 1.39140e-05, 1.68727e-05, 2.04606e-05, 2.48115e-05,
 3.00875e-05, 3.64855e-05, 4.42439e-05, 5.36521e-05, 6.50610e-05,
 7.88959e-05, 9.56726e-05, 1.16017e-04, 1.40687e-04, 1.70604e-04,
 2.06882e-04, 2.50874e-04, 3.04221e-04, 3.68912e-04, 4.47359e-04,
 5.42488e-04, 6.57845e-04, 7.97732e-04, 9.67366e-04, 1.17307e-03,
 1.42252e-03, 1.72501e-03, 2.09182e-03, 2.53664e-03, 3.07604e-03,
 3.73015e-03, 4.52334e-03, 5.48521e-03, 6.65161e-03, 8.06604e-03,
 9.78124e-03, 1.18612e-02, 1.43834e-02, 1.74419e-02, 2.11509e-02,
 2.56485e-02, 3.11025e-02, 3.77163e-02, 4.57365e-02, 5.54621e-02,
 6.72558e-02, 8.15574e-02, 9.89001e-02, 1.19931e-01, 1.45433e-01,
 1.76359e-01, 2.13861e-01, 2.59337e-01, 3.14484e-01, 3.81357e-01,
 4.62451e-01, 5.60789e-01, 6.80037e-01, 8.24644e-01, 1.00000e+00}
,
{4.08672e-09, 4.96716e-09, 6.03729e-09, 7.33796e-09, 8.91886e-09,
 1.08403e-08, 1.31758e-08, 1.60144e-08, 1.94645e-08, 2.36580e-08,
 2.87548e-08, 3.49498e-08, 4.24794e-08, 5.16311e-08, 6.27545e-08,
 7.62744e-08, 9.27069e-08, 1.12680e-07, 1.36955e-07, 1.66461e-07,
 2.02324e-07, 2.45912e-07, 2.98892e-07, 3.63285e-07, 4.41551e-07,
 5.36679e-07, 6.52301e-07, 7.92833e-07, 9.63641e-07, 1.17125e-06,
 1.42358e-06, 1.73028e-06, 2.10305e-06, 2.55613e-06, 3.10683e-06,
 3.77616e-06, 4.58970e-06, 5.57850e-06, 6.78034e-06, 8.24109e-06,
 1.00166e-05, 1.21745e-05, 1.47974e-05, 1.79854e-05, 2.18601e-05,
 2.65697e-05, 3.22939e-05, 3.92512e-05, 4.77075e-05, 5.79857e-05,
 7.04781e-05, 8.56619e-05, 1.04117e-04, 1.26548e-04, 1.53811e-04,
 1.86949e-04, 2.27225e-04, 2.76178e-04, 3.35678e-04, 4.07997e-04,
 4.95895e-04, 6.02731e-04, 7.32584e-04, 8.90412e-04, 1.08224e-03,
 1.31540e-03, 1.59879e-03, 1.94323e-03, 2.36189e-03, 2.87073e-03,
 3.48920e-03, 4.24091e-03, 5.15458e-03, 6.26508e-03, 7.61483e-03,
 9.25537e-03, 1.12494e-02, 1.36729e-02, 1.66186e-02, 2.01989e-02,
 2.45506e-02, 2.98398e-02, 3.62685e-02, 4.40821e-02, 5.35792e-02,
 6.51223e-02, 7.91523e-02, 9.62048e-02, 1.16931e-01, 1.42123e-01,
 1.72742e-01, 2.09957e-01, 2.55191e-01, 3.10169e-01, 3.76992e-01,
 4.58211e-01, 5.56928e-01, 6.76913e-01, 8.22747e-01, 1.00000e+00}
,
{3.25368e-09, 3.96377e-09, 4.82883e-09, 5.88268e-09, 7.16653e-09,
 8.73057e-09, 1.06360e-08, 1.29572e-08, 1.57850e-08, 1.92299e-08,
 2.34267e-08, 2.85394e-08, 3.47679e-08, 4.23557e-08, 5.15994e-08,
 6.28606e-08, 7.65794e-08, 9.32923e-08, 1.13653e-07, 1.38456e-07,
 1.68673e-07, 2.05485e-07, 2.50330e-07, 3.04963e-07, 3.71519e-07,
 4.52600e-07, 5.51376e-07, 6.71710e-07, 8.18305e-07, 9.96894e-07,
 1.21446e-06, 1.47950e-06, 1.80239e-06, 2.19575e-06, 2.67496e-06,
 3.25875e-06, 3.96994e-06, 4.83635e-06, 5.89184e-06, 7.17769e-06,
 8.74416e-06, 1.06525e-05, 1.29773e-05, 1.58095e-05, 1.92598e-05,
 2.34631e-05, 2.85838e-05, 3.48220e-05, 4.24216e-05, 5.16798e-05,
 6.29585e-05, 7.66987e-05, 9.34375e-05, 1.13830e-04, 1.38672e-04,
 1.68936e-04, 2.05805e-04, 2.50720e-04, 3.05438e-04, 3.72097e-04,
 4.53305e-04, 5.52235e-04, 6.72756e-04, 8.19579e-04, 9.98446e-04,
 1.21635e-03, 1.48181e-03, 1.80520e-03, 2.19917e-03, 2.67912e-03,
 3.26382e-03, 3.97612e-03, 4.84388e-03, 5.90102e-03, 7.18886e-03,
 8.75778e-03, 1.06691e-02, 1.29975e-02, 1.58341e-02, 1.92898e-02,
 2.34997e-02, 2.86283e-02, 3.48762e-02, 4.24876e-02, 5.17602e-02,
 6.30565e-02, 7.68181e-02, 9.35830e-02, 1.14007e-01, 1.38888e-01,
 1.69199e-01, 2.06125e-01, 2.51111e-01, 3.05913e-01, 3.72677e-01,
 4.54010e-01, 5.53094e-01, 6.73803e-01, 8.20855e-01, 1.00000e+00}
,
{2.59045e-09, 3.16307e-09, 3.86226e-09, 4.71602e-09, 5.75850e-09,
 7.03142e-09, 8.58571e-09, 1.04836e-08, 1.28010e-08, 1.56307e-08,
 1.90858e-08, 2.33047e-08, 2.84563e-08, 3.47465e-08, 4.24273e-08,
 5.18058e-08, 6.32575e-08, 7.72406e-08, 9.43147e-08, 1.15163e-07,
 1.40620e-07, 1.71704e-07, 2.09659e-07, 2.56004e-07, 3.12594e-07,
 3.81693e-07, 4.66067e-07, 5.69091e-07, 6.94889e-07, 8.48494e-07,
 1.03605e-06, 1.26507e-06, 1.54472e-06, 1.88618e-06, 2.30312e-06,
 2.81223e-06, 3.43387e-06, 4.19293e-06, 5.11978e-06, 6.25151e-06,
 7.63341e-06, 9.32077e-06, 1.13811e-05, 1.38969e-05, 1.69689e-05,
 2.07198e-05, 2.53000e-05, 3.08925e-05, 3.77213e-05, 4.60596e-05,
 5.62412e-05, 6.86733e-05, 8.38535e-05, 1.02389e-04, 1.25023e-04,
 1.52659e-04, 1.86404e-04, 2.27609e-04, 2.77922e-04, 3.39357e-04,
 4.14372e-04, 5.05969e-04, 6.17813e-04, 7.54381e-04, 9.21137e-04,
 1.12476e-03, 1.37338e-03, 1.67697e-03, 2.04766e-03, 2.50030e-03,
 3.05299e-03, 3.72786e-03, 4.55190e-03, 5.55810e-03, 6.78673e-03,
 8.28693e-03, 1.01188e-02, 1.23555e-02, 1.50867e-02, 1.84216e-02,
 2.24937e-02, 2.74660e-02, 3.35374e-02, 4.09508e-02, 5.00030e-02,
 6.10562e-02, 7.45527e-02, 9.10326e-02, 1.11155e-01, 1.35726e-01,
 1.65729e-01, 2.02363e-01, 2.47096e-01, 3.01716e-01, 3.68411e-01,
 4.49848e-01, 5.49287e-01, 6.70707e-01, 8.18967e-01, 1.00000e+00}
,
{2.06241e-09, 2.52411e-09, 3.08917e-09, 3.78073e-09, 4.62710e-09,
 5.66295e-09, 6.93069e-09, 8.48223e-09, 1.03811e-08, 1.27051e-08,
 1.55493e-08, 1.90302e-08, 2.32905e-08, 2.85044e-08, 3.48855e-08,
 4.26952e-08, 5.22531e-08, 6.39508e-08, 7.82671e-08, 9.57884e-08,
 1.17232e-07, 1.43476e-07, 1.75596e-07, 2.14905e-07, 2.63015e-07,
 3.21895e-07, 3.93956e-07, 4.82149e-07, 5.90086e-07, 7.22186e-07,
 8.83858e-07, 1.08172e-06, 1.32388e-06, 1.62025e-06, 1.98297e-06,
 2.42689e-06, 2.97019e-06, 3.63511e-06, 4.44888e-06, 5.44484e-06,
 6.66374e-06, 8.15552e-06, 9.98126e-06, 1.22157e-05, 1.49504e-05,
 1.82973e-05, 2.23934e-05, 2.74065e-05, 3.35419e-05, 4.10507e-05,
 5.02405e-05, 6.14876e-05, 7.52526e-05, 9.20990e-05, 1.12717e-04,
 1.37950e-04, 1.68832e-04, 2.06628e-04, 2.52885e-04, 3.09497e-04,
 3.78783e-04, 4.63579e-04, 5.67358e-04, 6.94370e-04, 8.49815e-04,
 1.04006e-03, 1.27289e-03, 1.55785e-03, 1.90660e-03, 2.33342e-03,
 2.85579e-03, 3.49510e-03, 4.27753e-03, 5.23512e-03, 6.40708e-03,
 7.84141e-03, 9.59682e-03, 1.17452e-02, 1.43746e-02, 1.75925e-02,
 2.15309e-02, 2.63509e-02, 3.22499e-02, 3.94696e-02, 4.83055e-02,
 5.91194e-02, 7.23541e-02, 8.85517e-02, 1.08375e-01, 1.32637e-01,
 1.62330e-01, 1.98670e-01, 2.43145e-01, 2.97576e-01, 3.64193e-01,
 4.45724e-01, 5.45506e-01, 6.67625e-01, 8.17083e-01, 1.00000e+00}
,
{1.64201e-09, 2.01423e-09, 2.47083e-09, 3.03093e-09, 3.71800e-09,
 4.56082e-09, 5.59469e-09, 6.86294e-09, 8.41867e-09, 1.03271e-08,
 1.26681e-08, 1.55398e-08, 1.90624e-08, 2.33836e-08, 2.86844e-08,
 3.51867e-08, 4.31631e-08, 5.29475e-08, 6.49500e-08, 7.96733e-08,
 9.77342e-08, 1.19889e-07, 1.47066e-07, 1.80404e-07, 2.21300e-07,
 2.71465e-07, 3.33003e-07, 4.08490e-07, 5.01089e-07, 6.14680e-07,
 7.54019e-07, 9.24945e-07, 1.13462e-06, 1.39182e-06, 1.70733e-06,
 2.09436e-06, 2.56912e-06, 3.15150e-06, 3.86590e-06, 4.74225e-06,
 5.81726e-06, 7.13595e-06, 8.75358e-06, 1.07379e-05, 1.31720e-05,
 1.61580e-05, 1.98207e-05, 2.43138e-05, 2.98255e-05, 3.65865e-05,
 4.48801e-05, 5.50539e-05, 6.75338e-05, 8.28428e-05, 1.01622e-04,
 1.24659e-04, 1.52917e-04, 1.87581e-04, 2.30103e-04, 2.82265e-04,
 3.46250e-04, 4.24740e-04, 5.21023e-04, 6.39132e-04, 7.84015e-04,
 9.61741e-04, 1.17975e-03, 1.44719e-03, 1.77525e-03, 2.17767e-03,
 2.67132e-03, 3.27687e-03, 4.01970e-03, 4.93091e-03, 6.04868e-03,
 7.41983e-03, 9.10180e-03, 1.11651e-02, 1.36960e-02, 1.68007e-02,
 2.06092e-02, 2.52811e-02, 3.10119e-02, 3.80419e-02, 4.66655e-02,
 5.72440e-02, 7.02204e-02, 8.61384e-02, 1.05665e-01, 1.29618e-01,
 1.59000e-01, 1.95043e-01, 2.39257e-01, 2.93493e-01, 3.60025e-01,
 4.41637e-01, 5.41750e-01, 6.64558e-01, 8.15204e-01, 1.00000e+00}
,
{1.30730e-09, 1.60734e-09, 1.97625e-09, 2.42983e-09, 2.98751e-09,
 3.67318e-09, 4.51623e-09, 5.55277e-09, 6.82721e-09, 8.39416e-09,
 1.03207e-08, 1.26895e-08, 1.56019e-08, 1.91828e-08, 2.35855e-08,
 2.89987e-08, 3.56543e-08, 4.38375e-08, 5.38988e-08, 6.62694e-08,
 8.14792e-08, 1.00180e-07, 1.23172e-07, 1.51442e-07, 1.86201e-07,
 2.28936e-07, 2.81480e-07, 3.46084e-07, 4.25515e-07, 5.23177e-07,
 6.43254e-07, 7.90890e-07, 9.72410e-07, 1.19559e-06, 1.47000e-06,
 1.80738e-06, 2.22220e-06, 2.73223e-06, 3.35932e-06, 4.13033e-06,
 5.07830e-06, 6.24384e-06, 7.67689e-06, 9.43885e-06, 1.16052e-05,
 1.42688e-05, 1.75436e-05, 2.15702e-05, 2.65208e-05, 3.26077e-05,
 4.00917e-05, 4.92933e-05, 6.06068e-05, 7.45169e-05, 9.16196e-05,
 1.12648e-04, 1.38502e-04, 1.70290e-04, 2.09374e-04, 2.57428e-04,
 3.16512e-04, 3.89156e-04, 4.78473e-04, 5.88289e-04, 7.23310e-04,
 8.89320e-04, 1.09343e-03, 1.34439e-03, 1.65295e-03, 2.03232e-03,
 2.49877e-03, 3.07227e-03, 3.77740e-03, 4.64437e-03, 5.71032e-03,
 7.02092e-03, 8.63232e-03, 1.06136e-02, 1.30495e-02, 1.60446e-02,
 1.97270e-02, 2.42547e-02, 2.98215e-02, 3.66659e-02, 4.50813e-02,
 5.54281e-02, 6.81496e-02, 8.37909e-02, 1.03022e-01, 1.26667e-01,
 1.55739e-01, 1.91483e-01, 2.35432e-01, 2.89467e-01, 3.55903e-01,
 4.37588e-01, 5.38021e-01, 6.61505e-01, 8.13329e-01, 1.00000e+00}
,
{1.04082e-09, 1.28265e-09, 1.58067e-09, 1.94794e-09, 2.40054e-09,
 2.95830e-09, 3.64566e-09, 4.49273e-09, 5.53660e-09, 6.82303e-09,
 8.40835e-09, 1.03620e-08, 1.27696e-08, 1.57366e-08, 1.93930e-08,
 2.38989e-08, 2.94518e-08, 3.62949e-08, 4.47280e-08, 5.51205e-08,
 6.79276e-08, 8.37105e-08, 1.03161e-07, 1.27130e-07, 1.56668e-07,
 1.93070e-07, 2.37929e-07, 2.93212e-07, 3.61339e-07, 4.45296e-07,
 5.48760e-07, 6.76264e-07, 8.33393e-07, 1.02703e-06, 1.26566e-06,
 1.55973e-06, 1.92214e-06, 2.36874e-06, 2.91911e-06, 3.59737e-06,
 4.43321e-06, 5.46326e-06, 6.73264e-06, 8.29696e-06, 1.02247e-05,
 1.26005e-05, 1.55282e-05, 1.91361e-05, 2.35823e-05, 2.90617e-05,
 3.58141e-05, 4.41355e-05, 5.43903e-05, 6.70278e-05, 8.26016e-05,
 1.01794e-04, 1.25446e-04, 1.54593e-04, 1.90512e-04, 2.34778e-04,
 2.89328e-04, 3.56553e-04, 4.39397e-04, 5.41491e-04, 6.67305e-04,
 8.22353e-04, 1.01342e-03, 1.24889e-03, 1.53907e-03, 1.89667e-03,
 2.33736e-03, 2.88044e-03, 3.54971e-03, 4.37448e-03, 5.39089e-03,
 6.64345e-03, 8.18705e-03, 1.00893e-02, 1.24335e-02, 1.53225e-02,
 1.88826e-02, 2.32699e-02, 2.86767e-02, 3.53397e-02, 4.35508e-02,
 5.36698e-02, 6.61399e-02, 8.15074e-02, 1.00446e-01, 1.23784e-01,
 1.52545e-01, 1.87989e-01, 2.31667e-01, 2.85495e-01, 3.51829e-01,
 4.33576e-01, 5.34317e-01, 6.58465e-01, 8.11459e-01, 1.00000e+00}
,
{8.28657e-10, 1.02355e-09, 1.26428e-09, 1.56162e-09, 1.92890e-09,
 2.38255e-09, 2.94291e-09, 3.63505e-09, 4.48997e-09, 5.54596e-09,
 6.85032e-09, 8.46144e-09, 1.04515e-08, 1.29096e-08, 1.59458e-08,
 1.96960e-08, 2.43283e-08, 3.00501e-08, 3.71176e-08, 4.58472e-08,
 5.66300e-08, 6.99488e-08, 8.64000e-08, 1.06720e-07, 1.31820e-07,
 1.62823e-07, 2.01117e-07, 2.48417e-07, 3.06842e-07, 3.79008e-07,
 4.68147e-07, 5.78251e-07, 7.14249e-07, 8.82233e-07, 1.08972e-06,
 1.34602e-06, 1.66259e-06, 2.05361e-06, 2.53660e-06, 3.13318e-06,
 3.87007e-06, 4.78026e-06, 5.90453e-06, 7.29322e-06, 9.00850e-06,
 1.11272e-05, 1.37442e-05, 1.69767e-05, 2.09694e-05, 2.59012e-05,
 3.19929e-05, 3.95173e-05, 4.88114e-05, 6.02913e-05, 7.44712e-05,
 9.19861e-05, 1.13620e-04, 1.40343e-04, 1.73350e-04, 2.14120e-04,
 2.64478e-04, 3.26681e-04, 4.03513e-04, 4.98415e-04, 6.15637e-04,
 7.60428e-04, 9.39273e-04, 1.16018e-03, 1.43304e-03, 1.77008e-03,
 2.18638e-03, 2.70060e-03, 3.33575e-03, 4.12028e-03, 5.08933e-03,
 6.28628e-03, 7.76475e-03, 9.59094e-03, 1.18466e-02, 1.46328e-02,
 1.80743e-02, 2.23252e-02, 2.75759e-02, 3.40614e-02, 4.20723e-02,
 5.19673e-02, 6.41894e-02, 7.92861e-02, 9.79333e-02, 1.20966e-01,
 1.49416e-01, 1.84557e-01, 2.27963e-01, 2.81578e-01, 3.47802e-01,
 4.29601e-01, 5.30639e-01, 6.55440e-01, 8.09592e-01, 1.00000e+00}
,
{6.59743e-10, 8.16786e-10, 1.01121e-09, 1.25192e-09, 1.54992e-09,
 1.91886e-09, 2.37562e-09, 2.94110e-09, 3.64119e-09, 4.50793e-09,
 5.58098e-09, 6.90946e-09, 8.55417e-09, 1.05904e-08, 1.31113e-08,
 1.62322e-08, 2.00961e-08, 2.48797e-08, 3.08020e-08, 3.81341e-08,
 4.72114e-08, 5.84494e-08, 7.23625e-08, 8.95875e-08, 1.10913e-07,
 1.37314e-07, 1.70000e-07, 2.10466e-07, 2.60565e-07, 3.22588e-07,
 3.99376e-07, 4.94443e-07, 6.12138e-07, 7.57850e-07, 9.38246e-07,
 1.16158e-06, 1.43808e-06, 1.78040e-06, 2.20420e-06, 2.72888e-06,
 3.37846e-06, 4.18265e-06, 5.17828e-06, 6.41090e-06, 7.93693e-06,
 9.82622e-06, 1.21652e-05, 1.50610e-05, 1.86461e-05, 2.30845e-05,
 2.85795e-05, 3.53824e-05, 4.38048e-05, 5.42319e-05, 6.71411e-05,
 8.31232e-05, 1.02910e-04, 1.27406e-04, 1.57733e-04, 1.95279e-04,
 2.41763e-04, 2.99312e-04, 3.70559e-04, 4.58766e-04, 5.67969e-04,
 7.03166e-04, 8.70546e-04, 1.07777e-03, 1.33432e-03, 1.65193e-03,
 2.04515e-03, 2.53198e-03, 3.13468e-03, 3.88085e-03, 4.80463e-03,
 5.94831e-03, 7.36423e-03, 9.11719e-03, 1.12874e-02, 1.39742e-02,
 1.73006e-02, 2.14188e-02, 2.65173e-02, 3.28294e-02, 4.06440e-02,
 5.03187e-02, 6.22965e-02, 7.71253e-02, 9.54840e-02, 1.18213e-01,
 1.46352e-01, 1.81189e-01, 2.24318e-01, 2.77714e-01, 3.43821e-01,
 4.25663e-01, 5.26986e-01, 6.52428e-01, 8.07730e-01, 1.00000e+00}
,
{5.25261e-10, 6.51791e-10, 8.08802e-10, 1.00363e-09, 1.24540e-09,
 1.54541e-09, 1.91768e-09, 2.37963e-09, 2.95286e-09, 3.66418e-09,
 4.54685e-09, 5.64215e-09, 7.00129e-09, 8.68783e-09, 1.07807e-08,
 1.33776e-08, 1.66002e-08, 2.05990e-08, 2.55611e-08, 3.17185e-08,
 3.93592e-08, 4.88405e-08, 6.06057e-08, 7.52051e-08, 9.33213e-08,
 1.15802e-07, 1.43697e-07, 1.78312e-07, 2.21266e-07, 2.74567e-07,
 3.40708e-07, 4.22782e-07, 5.24626e-07, 6.51003e-07, 8.07824e-07,
 1.00242e-06, 1.24390e-06, 1.54354e-06, 1.91536e-06, 2.37676e-06,
 2.94930e-06, 3.65975e-06, 4.54136e-06, 5.63533e-06, 6.99283e-06,
 8.67733e-06, 1.07676e-05, 1.33614e-05, 1.65801e-05, 2.05741e-05,
 2.55302e-05, 3.16802e-05, 3.93117e-05, 4.87815e-05, 6.05325e-05,
 7.51142e-05, 9.32085e-05, 1.15662e-04, 1.43523e-04, 1.78097e-04,
 2.20999e-04, 2.74235e-04, 3.40296e-04, 4.22271e-04, 5.23992e-04,
 6.50217e-04, 8.06848e-04, 1.00121e-03, 1.24239e-03, 1.54167e-03,
 1.91305e-03, 2.37388e-03, 2.94573e-03, 3.65533e-03, 4.53587e-03,
 5.62852e-03, 6.98437e-03, 8.66685e-03, 1.07546e-02, 1.33453e-02,
 1.65601e-02, 2.05492e-02, 2.54993e-02, 3.16419e-02, 3.92641e-02,
 4.87225e-02, 6.04593e-02, 7.50234e-02, 9.30959e-02, 1.15522e-01,
 1.43350e-01, 1.77882e-01, 2.20732e-01, 2.73904e-01, 3.39885e-01,
 4.21760e-01, 5.23358e-01, 6.49431e-01, 8.05873e-01, 1.00000e+00}
,
{4.18191e-10, 5.20126e-10, 6.46907e-10, 8.04592e-10, 1.00071e-09,
 1.24464e-09, 1.54802e-09, 1.92535e-09, 2.39466e-09, 2.97836e-09,
 3.70434e-09, 4.60728e-09, 5.73031e-09, 7.12708e-09, 8.86431e-09,
 1.10250e-08, 1.37124e-08, 1.70548e-08, 2.12119e-08, 2.63823e-08,
 3.28130e-08, 4.08113e-08, 5.07591e-08, 6.31317e-08, 7.85201e-08,
 9.76595e-08, 1.21464e-07, 1.51071e-07, 1.87895e-07, 2.33695e-07,
 2.90658e-07, 3.61506e-07, 4.49624e-07, 5.59221e-07, 6.95532e-07,
 8.65068e-07, 1.07593e-06, 1.33819e-06, 1.66437e-06, 2.07007e-06,
 2.57465e-06, 3.20223e-06, 3.98277e-06, 4.95358e-06, 6.16102e-06,
 7.66278e-06, 9.53059e-06, 1.18537e-05, 1.47430e-05, 1.83367e-05,
 2.28063e-05, 2.83653e-05, 3.52794e-05, 4.38788e-05, 5.45743e-05,
 6.78769e-05, 8.44220e-05, 1.05000e-04, 1.30594e-04, 1.62426e-04,
 2.02018e-04, 2.51260e-04, 3.12505e-04, 3.88679e-04, 4.83420e-04,
 6.01254e-04, 7.47811e-04, 9.30090e-04, 1.15680e-03, 1.43877e-03,
 1.78948e-03, 2.22566e-03, 2.76817e-03, 3.44292e-03, 4.28213e-03,
 5.32591e-03, 6.62411e-03, 8.23875e-03, 1.02470e-02, 1.27447e-02,
 1.58512e-02, 1.97149e-02, 2.45205e-02, 3.04974e-02, 3.79312e-02,
 4.71769e-02, 5.86764e-02, 7.29788e-02, 9.07675e-02, 1.12892e-01,
 1.40410e-01, 1.74635e-01, 2.17203e-01, 2.70146e-01, 3.35994e-01,
 4.17894e-01, 5.19756e-01, 6.46447e-01, 8.04019e-01, 1.00000e+00}
,
{3.32947e-10, 4.15058e-10, 5.17419e-10, 6.45024e-10, 8.04098e-10,
 1.00240e-09, 1.24962e-09, 1.55779e-09, 1.94197e-09, 2.42090e-09,
 3.01794e-09, 3.76222e-09, 4.69005e-09, 5.84671e-09, 7.28862e-09,
 9.08612e-09, 1.13269e-08, 1.41204e-08, 1.76027e-08, 2.19439e-08,
 2.73556e-08, 3.41020e-08, 4.25122e-08, 5.29965e-08, 6.60664e-08,
 8.23597e-08, 1.02671e-07, 1.27992e-07, 1.59557e-07, 1.98906e-07,
 2.47960e-07, 3.09112e-07, 3.85345e-07, 4.80378e-07, 5.98848e-07,
 7.46535e-07, 9.30645e-07, 1.16016e-06, 1.44628e-06, 1.80295e-06,
 2.24760e-06, 2.80190e-06, 3.49289e-06, 4.35431e-06, 5.42816e-06,
 6.76685e-06, 8.43568e-06, 1.05161e-05, 1.31095e-05, 1.63426e-05,
 2.03730e-05, 2.53973e-05, 3.16608e-05, 3.94689e-05, 4.92027e-05,
 6.13369e-05, 7.64638e-05, 9.53212e-05, 1.18829e-04, 1.48135e-04,
 1.84667e-04, 2.30210e-04, 2.86984e-04, 3.57759e-04, 4.45989e-04,
 5.55979e-04, 6.93093e-04, 8.64023e-04, 1.07711e-03, 1.34274e-03,
 1.67389e-03, 2.08670e-03, 2.60132e-03, 3.24285e-03, 4.04260e-03,
 5.03957e-03, 6.28243e-03, 7.83179e-03, 9.76326e-03, 1.21711e-02,
 1.51727e-02, 1.89145e-02, 2.35792e-02, 2.93943e-02, 3.66434e-02,
 4.56804e-02, 5.69460e-02, 7.09900e-02, 8.84974e-02, 1.10323e-01,
 1.37530e-01, 1.71448e-01, 2.13730e-01, 2.66439e-01, 3.32148e-01,
 4.14062e-01, 5.16178e-01, 6.43477e-01, 8.02170e-01, 1.00000e+00}
,
{2.65079e-10, 3.31214e-10, 4.13849e-10, 5.17101e-10, 6.46114e-10,
 8.07315e-10, 1.00873e-09, 1.26040e-09, 1.57487e-09, 1.96778e-09,
 2.45873e-09, 3.07216e-09, 3.83864e-09, 4.79636e-09, 5.99301e-09,
 7.48822e-09, 9.35647e-09, 1.16908e-08, 1.46076e-08, 1.82521e-08,
 2.28059e-08, 2.84958e-08, 3.56052e-08, 4.44885e-08, 5.55880e-08,
 6.94568e-08, 8.67857e-08, 1.08438e-07, 1.35493e-07, 1.69297e-07,
 2.11535e-07, 2.64311e-07, 3.30255e-07, 4.12651e-07, 5.15605e-07,
 6.44244e-07, 8.04978e-07, 1.00581e-06, 1.25676e-06, 1.57031e-06,
 1.96209e-06, 2.45161e-06, 3.06327e-06, 3.82753e-06, 4.78247e-06,
 5.97567e-06, 7.46655e-06, 9.32939e-06, 1.16570e-05, 1.45653e-05,
 1.81993e-05, 2.27399e-05, 2.84133e-05, 3.55022e-05, 4.43597e-05,
 5.54271e-05, 6.92557e-05, 8.65345e-05, 1.08124e-04, 1.35100e-04,
 1.68807e-04, 2.10923e-04, 2.63547e-04, 3.29299e-04, 4.11457e-04,
 5.14112e-04, 6.42379e-04, 8.02648e-04, 1.00290e-03, 1.25312e-03,
 1.56576e-03, 1.95641e-03, 2.44452e-03, 3.05441e-03, 3.81646e-03,
 4.76863e-03, 5.95837e-03, 7.44494e-03, 9.30239e-03, 1.16233e-02,
 1.45232e-02, 1.81466e-02, 2.26740e-02, 2.83310e-02, 3.53994e-02,
 4.42313e-02, 5.52667e-02, 6.90553e-02, 8.62841e-02, 1.07811e-01,
 1.34709e-01, 1.68318e-01, 2.10312e-01, 2.62784e-01, 3.28346e-01,
 4.10266e-01, 5.12624e-01, 6.40520e-01, 8.00325e-01, 1.00000e+00}
,
{2.11045e-10, 2.64307e-10, 3.31011e-10, 4.14549e-10, 5.19170e-10,
 6.50194e-10, 8.14285e-10, 1.01979e-09, 1.27715e-09, 1.59947e-09,
 2.00314e-09, 2.50867e-09, 3.14180e-09, 3.93470e-09, 4.92771e-09,
 6.17133e-09, 7.72880e-09, 9.67934e-09, 1.21221e-08, 1.51814e-08,
 1.90128e-08, 2.38111e-08, 2.98204e-08, 3.73463e-08, 4.67715e-08,
 5.85753e-08, 7.33581e-08, 9.18717e-08, 1.15058e-07, 1.44095e-07,
 1.80461e-07, 2.26004e-07, 2.83041e-07, 3.54473e-07, 4.43932e-07,
 5.55969e-07, 6.96280e-07, 8.72002e-07, 1.09207e-06, 1.36768e-06,
 1.71285e-06, 2.14512e-06, 2.68649e-06, 3.36449e-06, 4.21359e-06,
 5.27699e-06, 6.60876e-06, 8.27663e-06, 1.03654e-05, 1.29814e-05,
 1.62575e-05, 2.03605e-05, 2.54989e-05, 3.19341e-05, 3.99934e-05,
 5.00867e-05, 6.27272e-05, 7.85578e-05, 9.83836e-05, 1.23213e-04,
 1.54309e-04, 1.93252e-04, 2.42023e-04, 3.03103e-04, 3.79598e-04,
 4.75399e-04, 5.95376e-04, 7.45633e-04, 9.33811e-04, 1.16948e-03,
 1.46462e-03, 1.83425e-03, 2.29717e-03, 2.87691e-03, 3.60297e-03,
 4.51226e-03, 5.65103e-03, 7.07719e-03, 8.86328e-03, 1.11001e-02,
 1.39015e-02, 1.74099e-02, 2.18036e-02, 2.73063e-02, 3.41976e-02,
 4.28282e-02, 5.36369e-02, 6.71733e-02, 8.41261e-02, 1.05357e-01,
 1.31946e-01, 1.65246e-01, 2.06950e-01, 2.59178e-01, 3.24588e-01,
 4.06505e-01, 5.09095e-01, 6.37577e-01, 7.98484e-01, 1.00000e+00}
,
{1.68025e-10, 2.10915e-10, 2.64754e-10, 3.32335e-10, 4.17166e-10,
 5.23652e-10, 6.57319e-10, 8.25106e-10, 1.03572e-09, 1.30010e-09,
 1.63196e-09, 2.04854e-09, 2.57145e-09, 3.22784e-09, 4.05177e-09,
 5.08603e-09, 6.38428e-09, 8.01394e-09, 1.00596e-08, 1.26274e-08,
 1.58506e-08, 1.98967e-08, 2.49755e-08, 3.13507e-08, 3.93533e-08,
 4.93986e-08, 6.20081e-08, 7.78362e-08, 9.77047e-08, 1.22645e-07,
 1.53951e-07, 1.93248e-07, 2.42577e-07, 3.04497e-07, 3.82223e-07,
 4.79789e-07, 6.02260e-07, 7.55993e-07, 9.48967e-07, 1.19120e-06,
 1.49527e-06, 1.87695e-06, 2.35606e-06, 2.95746e-06, 3.71238e-06,
 4.66000e-06, 5.84951e-06, 7.34266e-06, 9.21695e-06, 1.15697e-05,
 1.45229e-05, 1.82300e-05, 2.28834e-05, 2.87247e-05, 3.60569e-05,
 4.52608e-05, 5.68140e-05, 7.13164e-05, 8.95206e-05, 1.12372e-04,
 1.41056e-04, 1.77061e-04, 2.22258e-04, 2.78991e-04, 3.50207e-04,
 4.39600e-04, 5.51813e-04, 6.92668e-04, 8.69478e-04, 1.09142e-03,
 1.37002e-03, 1.71973e-03, 2.15870e-03, 2.70973e-03, 3.40142e-03,
 4.26967e-03, 5.35954e-03, 6.72761e-03, 8.44490e-03, 1.06005e-02,
 1.33064e-02, 1.67030e-02, 2.09666e-02, 2.63186e-02, 3.30367e-02,
 4.14696e-02, 5.20551e-02, 6.53427e-02, 8.20220e-02, 1.02959e-01,
 1.29240e-01, 1.62230e-01, 2.03641e-01, 2.55622e-01, 3.20872e-01,
 4.02778e-01, 5.05591e-01, 6.34648e-01, 7.96648e-01, 1.00000e+00}
,
{1.33775e-10, 1.68309e-10, 2.11759e-10, 2.66425e-10, 3.35204e-10,
 4.21738e-10, 5.30611e-10, 6.67590e-10, 8.39931e-10, 1.05676e-09,
 1.32957e-09, 1.67280e-09, 2.10464e-09, 2.64796e-09, 3.33154e-09,
 4.19159e-09, 5.27366e-09, 6.63507e-09, 8.34794e-09, 1.05030e-08,
 1.32144e-08, 1.66257e-08, 2.09177e-08, 2.63177e-08, 3.31117e-08,
 4.16595e-08, 5.24141e-08, 6.59450e-08, 8.29689e-08, 1.04388e-07,
 1.31336e-07, 1.65240e-07, 2.07898e-07, 2.61567e-07, 3.29092e-07,
 4.14048e-07, 5.20936e-07, 6.55417e-07, 8.24615e-07, 1.03749e-06,
 1.30532e-06, 1.64230e-06, 2.06626e-06, 2.59968e-06, 3.27079e-06,
 4.11516e-06, 5.17750e-06, 6.51409e-06, 8.19572e-06, 1.03115e-05,
 1.29734e-05, 1.63225e-05, 2.05363e-05, 2.58378e-05, 3.25079e-05,
 4.08999e-05, 5.14583e-05, 6.47425e-05, 8.14560e-05, 1.02484e-04,
 1.28941e-04, 1.62227e-04, 2.04107e-04, 2.56798e-04, 3.23091e-04,
 4.06498e-04, 5.11436e-04, 6.43465e-04, 8.09578e-04, 1.01857e-03,
 1.28152e-03, 1.61235e-03, 2.02858e-03, 2.55227e-03, 3.21115e-03,
 4.04012e-03, 5.08309e-03, 6.39530e-03, 8.04627e-03, 1.01234e-02,
 1.27368e-02, 1.60249e-02, 2.01618e-02, 2.53666e-02, 3.19151e-02,
 4.01541e-02, 5.05200e-02, 6.35619e-02, 7.99706e-02, 1.00615e-01,
 1.26590e-01, 1.59269e-01, 2.00385e-01, 2.52115e-01, 3.17199e-01,
 3.99085e-01, 5.02110e-01, 6.31732e-01, 7.94816e-01, 1.00000e+00}
,
{1.06506e-10, 1.34310e-10, 1.69372e-10, 2.13587e-10, 2.69345e-10,
 3.39659e-10, 4.28328e-10, 5.40144e-10, 6.81151e-10, 8.58968e-10,
 1.08321e-09, 1.36598e-09, 1.72257e-09, 2.17226e-09, 2.73933e-09,
 3.45445e-09, 4.35624e-09, 5.49346e-09, 6.92755e-09, 8.73601e-09,
 1.10166e-08, 1.38925e-08, 1.75192e-08, 2.20926e-08, 2.78600e-08,
 3.51329e-08, 4.43045e-08, 5.58704e-08, 7.04556e-08, 8.88482e-08,
 1.12042e-07, 1.41292e-07, 1.78176e-07, 2.24690e-07, 2.83346e-07,
 3.57314e-07, 4.50593e-07, 5.68221e-07, 7.16558e-07, 9.03618e-07,
 1.13951e-06, 1.43698e-06, 1.81211e-06, 2.28517e-06, 2.88173e-06,
 3.63401e-06, 4.58268e-06, 5.77901e-06, 7.28764e-06, 9.19011e-06,
 1.15892e-05, 1.46146e-05, 1.84298e-05, 2.32410e-05, 2.93082e-05,
 3.69592e-05, 4.66075e-05, 5.87746e-05, 7.41179e-05, 9.34666e-05,
 1.17866e-04, 1.48636e-04, 1.87438e-04, 2.36369e-04, 2.98074e-04,
 3.75888e-04, 4.74014e-04, 5.97758e-04, 7.53805e-04, 9.50588e-04,
 1.19874e-03, 1.51168e-03, 1.90631e-03, 2.40396e-03, 3.03152e-03,
 3.82291e-03, 4.82089e-03, 6.07940e-03, 7.66646e-03, 9.66781e-03,
 1.21916e-02, 1.53743e-02, 1.93878e-02, 2.44491e-02, 3.08316e-02,
 3.88803e-02, 4.90302e-02, 6.18297e-02, 7.79705e-02, 9.83250e-02,
 1.23993e-01, 1.56362e-01, 1.97181e-01, 2.48656e-01, 3.13568e-01,
 3.95426e-01, 4.98654e-01, 6.28829e-01, 7.92988e-01, 1.00000e+00}
,
{8.47959e-11, 1.07179e-10, 1.35470e-10, 1.71228e-10, 2.16426e-10,
 2.73554e-10, 3.45761e-10, 4.37029e-10, 5.52387e-10, 6.98196e-10,
 8.82492e-10, 1.11544e-09, 1.40987e-09, 1.78202e-09, 2.25240e-09,
 2.84694e-09, 3.59842e-09, 4.54827e-09, 5.74883e-09, 7.26629e-09,
 9.18431e-09, 1.16086e-08, 1.46728e-08, 1.85459e-08, 2.34413e-08,
 2.96288e-08, 3.74497e-08, 4.73349e-08, 5.98295e-08, 7.56221e-08,
 9.55834e-08, 1.20814e-07, 1.52704e-07, 1.93012e-07, 2.43959e-07,
 3.08355e-07, 3.89748e-07, 4.92626e-07, 6.22660e-07, 7.87018e-07,
 9.94760e-07, 1.25734e-06, 1.58923e-06, 2.00872e-06, 2.53894e-06,
 3.20912e-06, 4.05620e-06, 5.12688e-06, 6.48018e-06, 8.19069e-06,
 1.03527e-05, 1.30854e-05, 1.65395e-05, 2.09052e-05, 2.64234e-05,
 3.33981e-05, 4.22139e-05, 5.33567e-05, 6.74408e-05, 8.52426e-05,
 1.07743e-04, 1.36183e-04, 1.72130e-04, 2.17566e-04, 2.74995e-04,
 3.47583e-04, 4.39331e-04, 5.55297e-04, 7.01873e-04, 8.87140e-04,
 1.12131e-03, 1.41729e-03, 1.79140e-03, 2.26426e-03, 2.86194e-03,
 3.61738e-03, 4.57222e-03, 5.77911e-03, 7.30457e-03, 9.23269e-03,
 1.16698e-02, 1.47501e-02, 1.86436e-02, 2.35647e-02, 2.97849e-02,
 3.76469e-02, 4.75843e-02, 6.01446e-02, 7.60205e-02, 9.60869e-02,
 1.21450e-01, 1.53508e-01, 1.94028e-01, 2.45244e-01, 3.09979e-01,
 3.91801e-01, 4.95221e-01, 6.25940e-01, 7.91164e-01, 1.00000e+00}
,
{6.75110e-11, 8.55280e-11, 1.08353e-10, 1.37270e-10, 1.73904e-10,
 2.20314e-10, 2.79111e-10, 3.53598e-10, 4.47964e-10, 5.67515e-10,
 7.18970e-10, 9.10845e-10, 1.15393e-09, 1.46188e-09, 1.85202e-09,
 2.34627e-09, 2.97243e-09, 3.76570e-09, 4.77067e-09, 6.04384e-09,
 7.65679e-09, 9.70019e-09, 1.22889e-08, 1.55685e-08, 1.97234e-08,
 2.49870e-08, 3.16554e-08, 4.01034e-08, 5.08060e-08, 6.43649e-08,
 8.15422e-08, 1.03304e-07, 1.30873e-07, 1.65800e-07, 2.10047e-07,
 2.66103e-07, 3.37120e-07, 4.27088e-07, 5.41067e-07, 6.85464e-07,
 8.68397e-07, 1.10015e-06, 1.39375e-06, 1.76571e-06, 2.23693e-06,
 2.83391e-06, 3.59021e-06, 4.54835e-06, 5.76218e-06, 7.29996e-06,
 9.24814e-06, 1.17162e-05, 1.48430e-05, 1.88042e-05, 2.38226e-05,
 3.01802e-05, 3.82345e-05, 4.84383e-05, 6.13653e-05, 7.77421e-05,
 9.84895e-05, 1.24774e-04, 1.58073e-04, 2.00258e-04, 2.53702e-04,
 3.21409e-04, 4.07185e-04, 5.15852e-04, 6.53520e-04, 8.27928e-04,
 1.04888e-03, 1.32880e-03, 1.68342e-03, 2.13269e-03, 2.70184e-03,
 3.42290e-03, 4.33638e-03, 5.49365e-03, 6.95977e-03, 8.81715e-03,
 1.11702e-02, 1.41513e-02, 1.79279e-02, 2.27124e-02, 2.87737e-02,
 3.64527e-02, 4.61810e-02, 5.85055e-02, 7.41192e-02, 9.38997e-02,
 1.18959e-01, 1.50706e-01, 1.90926e-01, 2.41879e-01, 3.06431e-01,
 3.88209e-01, 4.91812e-01, 6.23064e-01, 7.89344e-01, 1.00000e+00}
,
{5.37495e-11, 6.82509e-11, 8.66647e-11, 1.10046e-10, 1.39736e-10,
 1.77436e-10, 2.25308e-10, 2.86095e-10, 3.63282e-10, 4.61293e-10,
 5.85748e-10, 7.43780e-10, 9.44448e-10, 1.19925e-09, 1.52281e-09,
 1.93365e-09, 2.45534e-09, 3.11778e-09, 3.95894e-09, 5.02705e-09,
 6.38332e-09, 8.10551e-09, 1.02923e-08, 1.30692e-08, 1.65951e-08,
 2.10724e-08, 2.67577e-08, 3.39767e-08, 4.31435e-08, 5.47834e-08,
 6.95637e-08, 8.83316e-08, 1.12163e-07, 1.42424e-07, 1.80849e-07,
 2.29642e-07, 2.91598e-07, 3.70269e-07, 4.70166e-07, 5.97014e-07,
 7.58086e-07, 9.62613e-07, 1.22232e-06, 1.55210e-06, 1.97085e-06,
 2.50257e-06, 3.17775e-06, 4.03509e-06, 5.12374e-06, 6.50610e-06,
 8.26141e-06, 1.04903e-05, 1.33205e-05, 1.69143e-05, 2.14777e-05,
 2.72723e-05, 3.46303e-05, 4.39733e-05, 5.58371e-05, 7.09017e-05,
 9.00306e-05, 1.14320e-04, 1.45163e-04, 1.84328e-04, 2.34059e-04,
 2.97206e-04, 3.77391e-04, 4.79209e-04, 6.08497e-04, 7.72667e-04,
 9.81129e-04, 1.24583e-03, 1.58195e-03, 2.00875e-03, 2.55071e-03,
 3.23887e-03, 4.11270e-03, 5.22229e-03, 6.63124e-03, 8.42031e-03,
 1.06921e-02, 1.35767e-02, 1.72397e-02, 2.18908e-02, 2.77969e-02,
 3.52963e-02, 4.48191e-02, 5.69111e-02, 7.22654e-02, 9.17623e-02,
 1.16519e-01, 1.47956e-01, 1.87873e-01, 2.38560e-01, 3.02923e-01,
 3.84650e-01, 4.88427e-01, 6.20202e-01, 7.87529e-01, 1.00000e+00}
,
{4.27932e-11, 5.44639e-11, 6.93174e-11, 8.82217e-11, 1.12282e-10,
 1.42903e-10, 1.81876e-10, 2.31478e-10, 2.94607e-10, 3.74953e-10,
 4.77211e-10, 6.07357e-10, 7.72997e-10, 9.83811e-10, 1.25212e-09,
 1.59360e-09, 2.02821e-09, 2.58134e-09, 3.28533e-09, 4.18132e-09,
 5.32165e-09, 6.77299e-09, 8.62013e-09, 1.09710e-08, 1.39631e-08,
 1.77711e-08, 2.26177e-08, 2.87860e-08, 3.66366e-08, 4.66282e-08,
 5.93448e-08, 7.55294e-08, 9.61279e-08, 1.22344e-07, 1.55710e-07,
 1.98176e-07, 2.52223e-07, 3.21009e-07, 4.08556e-07, 5.19978e-07,
 6.61787e-07, 8.42271e-07, 1.07198e-06, 1.36433e-06, 1.73641e-06,
 2.20997e-06, 2.81268e-06, 3.57976e-06, 4.55603e-06, 5.79857e-06,
 7.37996e-06, 9.39264e-06, 1.19542e-05, 1.52144e-05, 1.93637e-05,
 2.46446e-05, 3.13658e-05, 3.99199e-05, 5.08069e-05, 6.46631e-05,
 8.22982e-05, 1.04743e-04, 1.33308e-04, 1.69664e-04, 2.15936e-04,
 2.74826e-04, 3.49777e-04, 4.45169e-04, 5.66577e-04, 7.21095e-04,
 9.17753e-04, 1.16804e-03, 1.48660e-03, 1.89202e-03, 2.40802e-03,
 3.06474e-03, 3.90056e-03, 4.96433e-03, 6.31822e-03, 8.04134e-03,
 1.02344e-02, 1.30255e-02, 1.65779e-02, 2.10990e-02, 2.68532e-02,
 3.41767e-02, 4.34974e-02, 5.53601e-02, 7.04580e-02, 8.96735e-02,
 1.14129e-01, 1.45255e-01, 1.84869e-01, 2.35287e-01, 2.99455e-01,
 3.81123e-01, 4.85064e-01, 6.17352e-01, 7.85717e-01, 1.00000e+00}
,
{3.40702e-11, 4.34619e-11, 5.54424e-11, 7.07254e-11, 9.02213e-11,
 1.15091e-10, 1.46817e-10, 1.87288e-10, 2.38915e-10, 3.04773e-10,
 3.88786e-10, 4.95957e-10, 6.32671e-10, 8.07070e-10, 1.02954e-09,
 1.31334e-09, 1.67538e-09, 2.13720e-09, 2.72634e-09, 3.47787e-09,
 4.43656e-09, 5.65953e-09, 7.21961e-09, 9.20974e-09, 1.17485e-08,
 1.49870e-08, 1.91182e-08, 2.43883e-08, 3.11111e-08, 3.96871e-08,
 5.06270e-08, 6.45827e-08, 8.23853e-08, 1.05095e-07, 1.34065e-07,
 1.71021e-07, 2.18164e-07, 2.78303e-07, 3.55019e-07, 4.52882e-07,
 5.77721e-07, 7.36974e-07, 9.40125e-07, 1.19928e-06, 1.52986e-06,
 1.95158e-06, 2.48954e-06, 3.17580e-06, 4.05123e-06, 5.16798e-06,
 6.59256e-06, 8.40984e-06, 1.07281e-05, 1.36853e-05, 1.74578e-05,
 2.22701e-05, 2.84090e-05, 3.62401e-05, 4.62299e-05, 5.89734e-05,
 7.52298e-05, 9.59674e-05, 1.22421e-04, 1.56168e-04, 1.99216e-04,
 2.54131e-04, 3.24184e-04, 4.13547e-04, 5.27544e-04, 6.72965e-04,
 8.58472e-04, 1.09511e-03, 1.39699e-03, 1.78208e-03, 2.27332e-03,
 2.89997e-03, 3.69937e-03, 4.71912e-03, 6.01997e-03, 7.67942e-03,
 9.79629e-03, 1.24967e-02, 1.59415e-02, 2.03359e-02, 2.59416e-02,
 3.30925e-02, 4.22147e-02, 5.38514e-02, 6.86959e-02, 8.76323e-02,
 1.11789e-01, 1.42604e-01, 1.81913e-01, 2.32059e-01, 2.96028e-01,
 3.77629e-01, 4.81725e-01, 6.14515e-01, 7.83910e-01, 1.00000e+00}
,
{2.71253e-11, 3.46823e-11, 4.43447e-11, 5.66990e-11, 7.24952e-11,
 9.26921e-11, 1.18516e-10, 1.51534e-10, 1.93751e-10, 2.47729e-10,
 3.16746e-10, 4.04990e-10, 5.17819e-10, 6.62082e-10, 8.46535e-10,
 1.08238e-09, 1.38392e-09, 1.76948e-09, 2.26245e-09, 2.89276e-09,
 3.69868e-09, 4.72912e-09, 6.04664e-09, 7.73121e-09, 9.88510e-09,
 1.26391e-08, 1.61603e-08, 2.06624e-08, 2.64189e-08, 3.37792e-08,
 4.31899e-08, 5.52225e-08, 7.06073e-08, 9.02783e-08, 1.15429e-07,
 1.47588e-07, 1.88705e-07, 2.41278e-07, 3.08497e-07, 3.94443e-07,
 5.04334e-07, 6.44840e-07, 8.24490e-07, 1.05419e-06, 1.34788e-06,
 1.72340e-06, 2.20353e-06, 2.81743e-06, 3.60236e-06, 4.60596e-06,
 5.88917e-06, 7.52988e-06, 9.62767e-06, 1.23099e-05, 1.57394e-05,
 2.01244e-05, 2.57309e-05, 3.28995e-05, 4.20652e-05, 5.37844e-05,
 6.87686e-05, 8.79273e-05, 1.12424e-04, 1.43744e-04, 1.83791e-04,
 2.34995e-04, 3.00463e-04, 3.84172e-04, 4.91200e-04, 6.28047e-04,
 8.03019e-04, 1.02674e-03, 1.31278e-03, 1.67852e-03, 2.14615e-03,
 2.74406e-03, 3.50855e-03, 4.48602e-03, 5.73581e-03, 7.33379e-03,
 9.37696e-03, 1.19893e-02, 1.53295e-02, 1.96003e-02, 2.50609e-02,
 3.20427e-02, 4.09698e-02, 5.23838e-02, 6.69777e-02, 8.56375e-02,
 1.09496e-01, 1.40001e-01, 1.79005e-01, 2.28875e-01, 2.92639e-01,
 3.74167e-01, 4.78409e-01, 6.11692e-01, 7.82107e-01, 1.00000e+00}
,
{2.15961e-11, 2.76763e-11, 3.54684e-11, 4.54544e-11, 5.82518e-11,
 7.46522e-11, 9.56701e-11, 1.22605e-10, 1.57124e-10, 2.01362e-10,
 2.58054e-10, 3.30708e-10, 4.23817e-10, 5.43140e-10, 6.96057e-10,
 8.92028e-10, 1.14317e-09, 1.46503e-09, 1.87750e-09, 2.40610e-09,
 3.08352e-09, 3.95167e-09, 5.06423e-09, 6.49004e-09, 8.31727e-09,
 1.06590e-08, 1.36599e-08, 1.75058e-08, 2.24344e-08, 2.87507e-08,
 3.68453e-08, 4.72189e-08, 6.05131e-08, 7.75503e-08, 9.93841e-08,
 1.27365e-07, 1.63224e-07, 2.09179e-07, 2.68072e-07, 3.43546e-07,
 4.40269e-07, 5.64224e-07, 7.23079e-07, 9.26657e-07, 1.18755e-06,
 1.52190e-06, 1.95038e-06, 2.49950e-06, 3.20322e-06, 4.10507e-06,
 5.26083e-06, 6.74199e-06, 8.64015e-06, 1.10727e-05, 1.41902e-05,
 1.81854e-05, 2.33054e-05, 2.98668e-05, 3.82757e-05, 4.90520e-05,
 6.28623e-05, 8.05608e-05, 1.03242e-04, 1.32309e-04, 1.69560e-04,
 2.17299e-04, 2.78478e-04, 3.56882e-04, 4.57361e-04, 5.86128e-04,
 7.51149e-04, 9.62630e-04, 1.23365e-03, 1.58098e-03, 2.02610e-03,
 2.59653e-03, 3.32757e-03, 4.26443e-03, 5.46506e-03, 7.00371e-03,
 8.97557e-03, 1.15026e-02, 1.47411e-02, 1.88913e-02, 2.42101e-02,
 3.10263e-02, 3.97616e-02, 5.09562e-02, 6.53026e-02, 8.36882e-02,
 1.07250e-01, 1.37446e-01, 1.76143e-01, 2.25735e-01, 2.89289e-01,
 3.70737e-01, 4.75116e-01, 6.08882e-01, 7.80309e-01, 1.00000e+00}
,
{1.71939e-11, 2.20856e-11, 2.83689e-11, 3.64398e-11, 4.68068e-11,
 6.01233e-11, 7.72283e-11, 9.91996e-11, 1.27422e-10, 1.63673e-10,
 2.10238e-10, 2.70050e-10, 3.46879e-10, 4.45565e-10, 5.72328e-10,
 7.35155e-10, 9.44305e-10, 1.21296e-09, 1.55804e-09, 2.00130e-09,
 2.57067e-09, 3.30202e-09, 4.24144e-09, 5.44813e-09, 6.99811e-09,
 8.98906e-09, 1.15464e-08, 1.48314e-08, 1.90509e-08, 2.44708e-08,
 3.14328e-08, 4.03753e-08, 5.18620e-08, 6.66167e-08, 8.55691e-08,
 1.09913e-07, 1.41184e-07, 1.81350e-07, 2.32944e-07, 2.99216e-07,
 3.84342e-07, 4.93687e-07, 6.34141e-07, 8.14553e-07, 1.04629e-06,
 1.34396e-06, 1.72631e-06, 2.21745e-06, 2.84831e-06, 3.65865e-06,
 4.69953e-06, 6.03654e-06, 7.75392e-06, 9.95990e-06, 1.27935e-05,
 1.64332e-05, 2.11084e-05, 2.71137e-05, 3.48275e-05, 4.47359e-05,
 5.74632e-05, 7.38114e-05, 9.48107e-05, 1.21784e-04, 1.56432e-04,
 2.00936e-04, 2.58102e-04, 3.31532e-04, 4.25852e-04, 5.47006e-04,
 7.02629e-04, 9.02526e-04, 1.15929e-03, 1.48911e-03, 1.91276e-03,
 2.45694e-03, 3.15593e-03, 4.05379e-03, 5.20708e-03, 6.68849e-03,
 8.59136e-03, 1.10356e-02, 1.41752e-02, 1.82080e-02, 2.33882e-02,
 3.00421e-02, 3.85890e-02, 4.95675e-02, 6.36694e-02, 8.17832e-02,
 1.05050e-01, 1.34937e-01, 1.73326e-01, 2.22638e-01, 2.85978e-01,
 3.67338e-01, 4.71845e-01, 6.06084e-01, 7.78514e-01, 1.00000e+00}
,
{1.36891e-11, 1.76242e-11, 2.26904e-11, 2.92130e-11, 3.76105e-11,
 4.84220e-11, 6.23414e-11, 8.02620e-11, 1.03334e-10, 1.33038e-10,
 1.71282e-10, 2.20518e-10, 2.83908e-10, 3.65520e-10, 4.70593e-10,
 6.05869e-10, 7.80032e-10, 1.00426e-09, 1.29294e-09, 1.66461e-09,
 2.14312e-09, 2.75918e-09, 3.55233e-09, 4.57349e-09, 5.88818e-09,
 7.58079e-09, 9.75996e-09, 1.25656e-08, 1.61776e-08, 2.08281e-08,
 2.68153e-08, 3.45236e-08, 4.44477e-08, 5.72247e-08, 7.36744e-08,
 9.48529e-08, 1.22119e-07, 1.57224e-07, 2.02419e-07, 2.60606e-07,
 3.35520e-07, 4.31968e-07, 5.56142e-07, 7.16010e-07, 9.21834e-07,
 1.18682e-06, 1.52799e-06, 1.96722e-06, 2.53272e-06, 3.26077e-06,
 4.19811e-06, 5.40490e-06, 6.95859e-06, 8.95891e-06, 1.15342e-05,
 1.48499e-05, 1.91186e-05, 2.46144e-05, 3.16900e-05, 4.07997e-05,
 5.25279e-05, 6.76276e-05, 8.70677e-05, 1.12096e-04, 1.44319e-04,
 1.85805e-04, 2.39217e-04, 3.07982e-04, 3.96514e-04, 5.10496e-04,
 6.57243e-04, 8.46174e-04, 1.08941e-03, 1.40258e-03, 1.80576e-03,
 2.32484e-03, 2.99314e-03, 3.85355e-03, 4.96129e-03, 6.38746e-03,
 8.22360e-03, 1.05875e-02, 1.36310e-02, 1.75494e-02, 2.25942e-02,
 2.90891e-02, 3.74510e-02, 4.82166e-02, 6.20770e-02, 7.99216e-02,
 1.02896e-01, 1.32474e-01, 1.70555e-01, 2.19583e-01, 2.82704e-01,
 3.63970e-01, 4.68597e-01, 6.03299e-01, 7.76723e-01, 1.00000e+00}
,
{1.08987e-11, 1.40640e-11, 1.81486e-11, 2.34194e-11, 3.02210e-11,
 3.89980e-11, 5.03241e-11, 6.49396e-11, 8.37999e-11, 1.08138e-10,
 1.39544e-10, 1.80071e-10, 2.32369e-10, 2.99855e-10, 3.86941e-10,
 4.99320e-10, 6.44336e-10, 8.31469e-10, 1.07295e-09, 1.38456e-09,
 1.78668e-09, 2.30558e-09, 2.97518e-09, 3.83926e-09, 4.95428e-09,
 6.39314e-09, 8.24989e-09, 1.06459e-08, 1.37377e-08, 1.77276e-08,
 2.28761e-08, 2.95200e-08, 3.80934e-08, 4.91568e-08, 6.34332e-08,
 8.18560e-08, 1.05629e-07, 1.36307e-07, 1.75894e-07, 2.26979e-07,
 2.92899e-07, 3.77965e-07, 4.87737e-07, 6.29389e-07, 8.12181e-07,
 1.04806e-06, 1.35245e-06, 1.74523e-06, 2.25210e-06, 2.90617e-06,
 3.75020e-06, 4.83936e-06, 6.24484e-06, 8.05851e-06, 1.03989e-05,
 1.34191e-05, 1.73163e-05, 2.23455e-05, 2.88352e-05, 3.72097e-05,
 4.80165e-05, 6.19617e-05, 7.99571e-05, 1.03179e-04, 1.33145e-04,
 1.71814e-04, 2.21713e-04, 2.86105e-04, 3.69198e-04, 4.76423e-04,
 6.14789e-04, 7.93340e-04, 1.02375e-03, 1.32107e-03, 1.70475e-03,
 2.19985e-03, 2.83875e-03, 3.66320e-03, 4.72710e-03, 6.09998e-03,
 7.87158e-03, 1.01577e-02, 1.31078e-02, 1.69146e-02, 2.18271e-02,
 2.81663e-02, 3.63466e-02, 4.69026e-02, 6.05244e-02, 7.81024e-02,
 1.00785e-01, 1.30056e-01, 1.67828e-01, 2.16570e-01, 2.79468e-01,
 3.60633e-01, 4.65371e-01, 6.00527e-01, 7.74937e-01, 1.00000e+00}
,
{8.67710e-12, 1.12230e-11, 1.45158e-11, 1.87748e-11, 2.42834e-11,
 3.14082e-11, 4.06234e-11, 5.25424e-11, 6.79585e-11, 8.78976e-11,
 1.13687e-10, 1.47043e-10, 1.90186e-10, 2.45987e-10, 3.18160e-10,
 4.11508e-10, 5.32246e-10, 6.88408e-10, 8.90388e-10, 1.15163e-09,
 1.48952e-09, 1.92655e-09, 2.49180e-09, 3.22290e-09, 4.16851e-09,
 5.39156e-09, 6.97346e-09, 9.01948e-09, 1.16658e-08, 1.50886e-08,
 1.95156e-08, 2.52416e-08, 3.26475e-08, 4.22263e-08, 5.46156e-08,
 7.06400e-08, 9.13659e-08, 1.18173e-07, 1.52845e-07, 1.97690e-07,
 2.55693e-07, 3.30713e-07, 4.27746e-07, 5.53247e-07, 7.15571e-07,
 9.25521e-07, 1.19707e-06, 1.54829e-06, 2.00257e-06, 2.59012e-06,
 3.35007e-06, 4.33299e-06, 5.60430e-06, 7.24861e-06, 9.37537e-06,
 1.21261e-05, 1.56840e-05, 2.02857e-05, 2.62375e-05, 3.39357e-05,
 4.38925e-05, 5.67706e-05, 7.34272e-05, 9.49710e-05, 1.22836e-04,
 1.58876e-04, 2.05490e-04, 2.65782e-04, 3.43763e-04, 4.44623e-04,
 5.75077e-04, 7.43806e-04, 9.62040e-04, 1.24430e-03, 1.60939e-03,
 2.08158e-03, 2.69233e-03, 3.48226e-03, 4.50396e-03, 5.82543e-03,
 7.53463e-03, 9.74530e-03, 1.26046e-02, 1.63028e-02, 2.10861e-02,
 2.72728e-02, 3.52747e-02, 4.56244e-02, 5.90107e-02, 7.63245e-02,
 9.87183e-02, 1.27682e-01, 1.65145e-01, 2.13599e-01, 2.76269e-01,
 3.57327e-01, 4.62167e-01, 5.97768e-01, 7.73155e-01, 1.00000e+00}
,
{6.90836e-12, 8.95588e-12, 1.16103e-11, 1.50514e-11, 1.95123e-11,
 2.52955e-11, 3.27926e-11, 4.25118e-11, 5.51117e-11, 7.14459e-11,
 9.26213e-11, 1.20073e-10, 1.55660e-10, 2.01795e-10, 2.61604e-10,
 3.39140e-10, 4.39655e-10, 5.69962e-10, 7.38889e-10, 9.57884e-10,
 1.24179e-09, 1.60983e-09, 2.08696e-09, 2.70550e-09, 3.50736e-09,
 4.54689e-09, 5.89452e-09, 7.64155e-09, 9.90639e-09, 1.28425e-08,
 1.66488e-08, 2.15832e-08, 2.79801e-08, 3.62730e-08, 4.70237e-08,
 6.09608e-08, 7.90285e-08, 1.02451e-07, 1.32816e-07, 1.72181e-07,
 2.23212e-07, 2.89369e-07, 3.75133e-07, 4.86317e-07, 6.30453e-07,
 8.17309e-07, 1.05955e-06, 1.37358e-06, 1.78068e-06, 2.30845e-06,
 2.99264e-06, 3.87961e-06, 5.02946e-06, 6.52011e-06, 8.45257e-06,
 1.09578e-05, 1.42055e-05, 1.84157e-05, 2.38739e-05, 3.09497e-05,
 4.01227e-05, 5.20144e-05, 6.74306e-05, 8.74160e-05, 1.13325e-04,
 1.46912e-04, 1.90455e-04, 2.46902e-04, 3.20080e-04, 4.14947e-04,
 5.37930e-04, 6.97364e-04, 9.04051e-04, 1.17200e-03, 1.51936e-03,
 1.96967e-03, 2.55345e-03, 3.31025e-03, 4.29136e-03, 5.56325e-03,
 7.21210e-03, 9.34965e-03, 1.21207e-02, 1.57131e-02, 2.03702e-02,
 2.64077e-02, 3.42345e-02, 4.43810e-02, 5.75348e-02, 7.45872e-02,
 9.66936e-02, 1.25352e-01, 1.62504e-01, 2.10668e-01, 2.73107e-01,
 3.54051e-01, 4.58986e-01, 5.95022e-01, 7.71377e-01, 1.00000e+00}
,
{5.50015e-12, 7.14675e-12, 9.28628e-12, 1.20663e-11, 1.56787e-11,
 2.03724e-11, 2.64714e-11, 3.43962e-11, 4.46934e-11, 5.80734e-11,
 7.54589e-11, 9.80493e-11, 1.27402e-10, 1.65543e-10, 2.15102e-10,
 2.79498e-10, 3.63172e-10, 4.71895e-10, 6.13168e-10, 7.96733e-10,
 1.03525e-09, 1.34518e-09, 1.74789e-09, 2.27116e-09, 2.95108e-09,
 3.83455e-09, 4.98251e-09, 6.47413e-09, 8.41231e-09, 1.09307e-08,
 1.42031e-08, 1.84551e-08, 2.39800e-08, 3.11590e-08, 4.04871e-08,
 5.26078e-08, 6.83572e-08, 8.88214e-08, 1.15412e-07, 1.49963e-07,
 1.94858e-07, 2.53193e-07, 3.28992e-07, 4.27483e-07, 5.55460e-07,
 7.21749e-07, 9.37821e-07, 1.21858e-06, 1.58339e-06, 2.05741e-06,
 2.67334e-06, 3.47366e-06, 4.51358e-06, 5.86482e-06, 7.62059e-06,
 9.90198e-06, 1.28664e-05, 1.67182e-05, 2.17232e-05, 2.82265e-05,
 3.66767e-05, 4.76567e-05, 6.19238e-05, 8.04620e-05, 1.04550e-04,
 1.35849e-04, 1.76519e-04, 2.29364e-04, 2.98029e-04, 3.87251e-04,
 5.03183e-04, 6.53822e-04, 8.49558e-04, 1.10389e-03, 1.43437e-03,
 1.86378e-03, 2.42174e-03, 3.14674e-03, 4.08879e-03, 5.31286e-03,
 6.90338e-03, 8.97006e-03, 1.16554e-02, 1.51448e-02, 1.96787e-02,
 2.55699e-02, 3.32249e-02, 4.31715e-02, 5.60958e-02, 7.28894e-02,
 9.47104e-02, 1.23064e-01, 1.59906e-01, 2.07777e-01, 2.69980e-01,
 3.50805e-01, 4.55826e-01, 5.92288e-01, 7.69602e-01, 1.00000e+00}
,
{4.37900e-12, 5.70307e-12, 7.42749e-12, 9.67332e-12, 1.25982e-11,
 1.64075e-11, 2.13686e-11, 2.78298e-11, 3.62446e-11, 4.72038e-11,
 6.14767e-11, 8.00653e-11, 1.04274e-10, 1.35804e-10, 1.76866e-10,
 2.30345e-10, 2.99994e-10, 3.90702e-10, 5.08838e-10, 6.62694e-10,
 8.63071e-10, 1.12404e-09, 1.46391e-09, 1.90655e-09, 2.48302e-09,
 3.23381e-09, 4.21161e-09, 5.48506e-09, 7.14357e-09, 9.30355e-09,
 1.21166e-08, 1.57803e-08, 2.05518e-08, 2.67660e-08, 3.48592e-08,
 4.53994e-08, 5.91267e-08, 7.70048e-08, 1.00289e-07, 1.30613e-07,
 1.70105e-07, 2.21540e-07, 2.88526e-07, 3.75767e-07, 4.89387e-07,
 6.37362e-07, 8.30080e-07, 1.08107e-06, 1.40795e-06, 1.83367e-06,
 2.38811e-06, 3.11020e-06, 4.05062e-06, 5.27539e-06, 6.87050e-06,
 8.94792e-06, 1.16535e-05, 1.51771e-05, 1.97662e-05, 2.57428e-05,
 3.35266e-05, 4.36640e-05, 5.68666e-05, 7.40612e-05, 9.64549e-05,
 1.25620e-04, 1.63603e-04, 2.13071e-04, 2.77497e-04, 3.61404e-04,
 4.70680e-04, 6.12999e-04, 7.98350e-04, 1.03974e-03, 1.35413e-03,
 1.76357e-03, 2.29682e-03, 2.99131e-03, 3.89578e-03, 5.07374e-03,
 6.60788e-03, 8.60588e-03, 1.12080e-02, 1.45970e-02, 1.90106e-02,
 2.47588e-02, 3.22451e-02, 4.19949e-02, 5.46928e-02, 7.12302e-02,
 9.27679e-02, 1.20818e-01, 1.57349e-01, 2.04927e-01, 2.66890e-01,
 3.47589e-01, 4.52688e-01, 5.89567e-01, 7.67832e-01, 1.00000e+00}
,
{3.48638e-12, 4.55102e-12, 5.94076e-12, 7.75489e-12, 1.01230e-11,
 1.32143e-11, 1.72495e-11, 2.25170e-11, 2.93930e-11, 3.83687e-11,
 5.00853e-11, 6.53799e-11, 8.53450e-11, 1.11407e-10, 1.45427e-10,
 1.89836e-10, 2.47806e-10, 3.23479e-10, 4.22259e-10, 5.51205e-10,
 7.19526e-10, 9.39248e-10, 1.22607e-09, 1.60047e-09, 2.08920e-09,
 2.72718e-09, 3.55998e-09, 4.64710e-09, 6.06618e-09, 7.91861e-09,
 1.03367e-08, 1.34932e-08, 1.76137e-08, 2.29923e-08, 3.00135e-08,
 3.91787e-08, 5.11427e-08, 6.67602e-08, 8.71467e-08, 1.13759e-07,
 1.48497e-07, 1.93844e-07, 2.53038e-07, 3.30308e-07, 4.31174e-07,
 5.62842e-07, 7.34717e-07, 9.59077e-07, 1.25195e-06, 1.63426e-06,
 2.13331e-06, 2.78476e-06, 3.63514e-06, 4.74520e-06, 6.19425e-06,
 8.08578e-06, 1.05549e-05, 1.37781e-05, 1.79855e-05, 2.34778e-05,
 3.06471e-05, 4.00059e-05, 5.22225e-05, 6.81696e-05, 8.89866e-05,
 1.16160e-04, 1.51632e-04, 1.97936e-04, 2.58380e-04, 3.37281e-04,
 4.40277e-04, 5.74724e-04, 7.50228e-04, 9.79325e-04, 1.27838e-03,
 1.66876e-03, 2.17835e-03, 2.84355e-03, 3.71189e-03, 4.84538e-03,
 6.32502e-03, 8.25649e-03, 1.07778e-02, 1.40690e-02, 1.83652e-02,
 2.39734e-02, 3.12942e-02, 4.08505e-02, 5.33250e-02, 6.96088e-02,
 9.08652e-02, 1.18613e-01, 1.54833e-01, 2.02115e-01, 2.63835e-01,
 3.44402e-01, 4.49572e-01, 5.86858e-01, 7.66066e-01, 1.00000e+00}
,
{2.77571e-12, 3.63169e-12, 4.75162e-12, 6.21692e-12, 8.13409e-12,
 1.06425e-11, 1.39244e-11, 1.82184e-11, 2.38366e-11, 3.11873e-11,
 4.08047e-11, 5.33881e-11, 6.98518e-11, 9.13927e-11, 1.19576e-10,
 1.56451e-10, 2.04697e-10, 2.67822e-10, 3.50412e-10, 4.58472e-10,
 5.99855e-10, 7.84838e-10, 1.02687e-09, 1.34353e-09, 1.75785e-09,
 2.29993e-09, 3.00918e-09, 3.93715e-09, 5.15128e-09, 6.73983e-09,
 8.81825e-09, 1.15376e-08, 1.50956e-08, 1.97507e-08, 2.58414e-08,
 3.38104e-08, 4.42368e-08, 5.78785e-08, 7.57271e-08, 9.90797e-08,
 1.29634e-07, 1.69610e-07, 2.21914e-07, 2.90348e-07, 3.79885e-07,
 4.97034e-07, 6.50309e-07, 8.50851e-07, 1.11324e-06, 1.45653e-06,
 1.90570e-06, 2.49338e-06, 3.26228e-06, 4.26830e-06, 5.58455e-06,
 7.30671e-06, 9.55995e-06, 1.25080e-05, 1.63653e-05, 2.14120e-05,
 2.80150e-05, 3.66542e-05, 4.79576e-05, 6.27467e-05, 8.20965e-05,
 1.07413e-04, 1.40537e-04, 1.83876e-04, 2.40580e-04, 3.14769e-04,
 4.11838e-04, 5.38840e-04, 7.05007e-04, 9.22416e-04, 1.20687e-03,
 1.57904e-03, 2.06599e-03, 2.70309e-03, 3.53667e-03, 4.62731e-03,
 6.05427e-03, 7.92128e-03, 1.03640e-02, 1.35601e-02, 1.77417e-02,
 2.32129e-02, 3.03713e-02, 3.97372e-02, 5.19913e-02, 6.80243e-02,
 8.90016e-02, 1.16448e-01, 1.52358e-01, 1.99342e-01, 2.60815e-01,
 3.41244e-01, 4.46477e-01, 5.84161e-01, 7.64304e-01, 1.00000e+00}
,
{2.20991e-12, 2.89807e-12, 3.80051e-12, 4.98397e-12, 6.53596e-12,
 8.57122e-12, 1.12403e-11, 1.47404e-11, 1.93305e-11, 2.53500e-11,
 3.32438e-11, 4.35958e-11, 5.71713e-11, 7.49741e-11, 9.83207e-11,
 1.28937e-10, 1.69088e-10, 2.21741e-10, 2.90790e-10, 3.81341e-10,
 5.00088e-10, 6.55813e-10, 8.60030e-10, 1.12784e-09, 1.47904e-09,
 1.93961e-09, 2.54360e-09, 3.33566e-09, 4.37437e-09, 5.73652e-09,
 7.52285e-09, 9.86543e-09, 1.29375e-08, 1.69661e-08, 2.22493e-08,
 2.91777e-08, 3.82634e-08, 5.01785e-08, 6.58038e-08, 8.62948e-08,
 1.13167e-07, 1.48406e-07, 1.94619e-07, 2.55223e-07, 3.34698e-07,
 4.38921e-07, 5.75599e-07, 7.54837e-07, 9.89890e-07, 1.29814e-06,
 1.70237e-06, 2.23248e-06, 2.92767e-06, 3.83933e-06, 5.03487e-06,
 6.60271e-06, 8.65876e-06, 1.13551e-05, 1.48910e-05, 1.95279e-05,
 2.56089e-05, 3.35833e-05, 4.40410e-05, 5.77552e-05, 7.57398e-05,
 9.93249e-05, 1.30254e-04, 1.70815e-04, 2.24006e-04, 2.93760e-04,
 3.85235e-04, 5.05196e-04, 6.62511e-04, 8.68814e-04, 1.13936e-03,
 1.49415e-03, 1.95942e-03, 2.56957e-03, 3.36973e-03, 4.41904e-03,
 5.79511e-03, 7.59968e-03, 9.96619e-03, 1.30696e-02, 1.71394e-02,
 2.24766e-02, 2.94756e-02, 3.86542e-02, 5.06910e-02, 6.64759e-02,
 8.71762e-02, 1.14322e-01, 1.49922e-01, 1.96607e-01, 2.57829e-01,
 3.38116e-01, 4.43404e-01, 5.81477e-01, 7.62547e-01, 1.00000e+00}
,
{1.75944e-12, 2.31264e-12, 3.03978e-12, 3.99554e-12, 5.25181e-12,
 6.90308e-12, 9.07353e-12, 1.19264e-11, 1.56763e-11, 2.06052e-11,
 2.70839e-11, 3.55995e-11, 4.67927e-11, 6.15051e-11, 8.08435e-11,
 1.06262e-10, 1.39673e-10, 1.83589e-10, 2.41312e-10, 3.17185e-10,
 4.16914e-10, 5.48000e-10, 7.20301e-10, 9.46776e-10, 1.24446e-09,
 1.63574e-09, 2.15005e-09, 2.82606e-09, 3.71463e-09, 4.88257e-09,
 6.41774e-09, 8.43560e-09, 1.10879e-08, 1.45741e-08, 1.91565e-08,
 2.51797e-08, 3.30966e-08, 4.35028e-08, 5.71809e-08, 7.51596e-08,
 9.87912e-08, 1.29853e-07, 1.70681e-07, 2.24346e-07, 2.94885e-07,
 3.87602e-07, 5.09471e-07, 6.69659e-07, 8.80211e-07, 1.15697e-06,
 1.52074e-06, 1.99888e-06, 2.62737e-06, 3.45346e-06, 4.53930e-06,
 5.96653e-06, 7.84252e-06, 1.03084e-05, 1.35495e-05, 1.78097e-05,
 2.34094e-05, 3.07697e-05, 4.04443e-05, 5.31607e-05, 6.98754e-05,
 9.18455e-05, 1.20723e-04, 1.58681e-04, 2.08573e-04, 2.74153e-04,
 3.60351e-04, 4.73652e-04, 6.22577e-04, 8.18327e-04, 1.07562e-03,
 1.41382e-03, 1.85835e-03, 2.44265e-03, 3.21066e-03, 4.22015e-03,
 5.54705e-03, 7.29114e-03, 9.58361e-03, 1.25969e-02, 1.65576e-02,
 2.17636e-02, 2.86064e-02, 3.76008e-02, 4.94232e-02, 6.49627e-02,
 8.53882e-02, 1.12236e-01, 1.47525e-01, 1.93909e-01, 2.54878e-01,
 3.35016e-01, 4.40351e-01, 5.78806e-01, 7.60793e-01, 1.00000e+00}
,
{1.40080e-12, 1.84548e-12, 2.43132e-12, 3.20314e-12, 4.21997e-12,
 5.55959e-12, 7.32447e-12, 9.64961e-12, 1.27129e-11, 1.67485e-11,
 2.20653e-11, 2.90700e-11, 3.82982e-11, 5.04558e-11, 6.64730e-11,
 8.75747e-11, 1.15375e-10, 1.52001e-10, 2.00253e-10, 2.63823e-10,
 3.47573e-10, 4.57910e-10, 6.03273e-10, 7.94781e-10, 1.04708e-09,
 1.37948e-09, 1.81739e-09, 2.39432e-09, 3.15439e-09, 4.15574e-09,
 5.47498e-09, 7.21300e-09, 9.50276e-09, 1.25194e-08, 1.64937e-08,
 2.17295e-08, 2.86275e-08, 3.77153e-08, 4.96880e-08, 6.54613e-08,
 8.62419e-08, 1.13619e-07, 1.49687e-07, 1.97206e-07, 2.59808e-07,
 3.42284e-07, 4.50941e-07, 5.94092e-07, 7.82685e-07, 1.03115e-06,
 1.35848e-06, 1.78973e-06, 2.35788e-06, 3.10638e-06, 4.09250e-06,
 5.39166e-06, 7.10323e-06, 9.35814e-06, 1.23289e-05, 1.62426e-05,
 2.13988e-05, 2.81919e-05, 3.71413e-05, 4.89318e-05, 6.44651e-05,
 8.49294e-05, 1.11890e-04, 1.47409e-04, 1.94204e-04, 2.55854e-04,
 3.37075e-04, 4.44078e-04, 5.85050e-04, 7.70773e-04, 1.01545e-03,
 1.33781e-03, 1.76249e-03, 2.32199e-03, 3.05911e-03, 4.03022e-03,
 5.30960e-03, 6.99512e-03, 9.21571e-03, 1.21412e-02, 1.59954e-02,
 2.10732e-02, 2.77628e-02, 3.65761e-02, 4.81871e-02, 6.34840e-02,
 8.36369e-02, 1.10187e-01, 1.45166e-01, 1.91249e-01, 2.51960e-01,
 3.31945e-01, 4.37320e-01, 5.76146e-01, 7.59043e-01, 1.00000e+00}
,
{1.11526e-12, 1.47268e-12, 1.94465e-12, 2.56789e-12, 3.39085e-12,
 4.47757e-12, 5.91257e-12, 7.80746e-12, 1.03096e-11, 1.36137e-11,
 1.79767e-11, 2.37380e-11, 3.13457e-11, 4.13915e-11, 5.46569e-11,
 7.21736e-11, 9.53042e-11, 1.25848e-10, 1.66180e-10, 2.19439e-10,
 2.89765e-10, 3.82631e-10, 5.05259e-10, 6.67187e-10, 8.81010e-10,
 1.16336e-09, 1.53620e-09, 2.02853e-09, 2.67865e-09, 3.53711e-09,
 4.67071e-09, 6.16760e-09, 8.14422e-09, 1.07543e-08, 1.42009e-08,
 1.87521e-08, 2.47619e-08, 3.26977e-08, 4.31769e-08, 5.70144e-08,
 7.52867e-08, 9.94150e-08, 1.31276e-07, 1.73348e-07, 2.28904e-07,
 3.02264e-07, 3.99135e-07, 5.27052e-07, 6.95964e-07, 9.19011e-07,
 1.21354e-06, 1.60246e-06, 2.11603e-06, 2.79418e-06, 3.68968e-06,
 4.87217e-06, 6.43362e-06, 8.49551e-06, 1.12182e-05, 1.48135e-05,
 1.95610e-05, 2.58300e-05, 3.41081e-05, 4.50392e-05, 5.94736e-05,
 7.85341e-05, 1.03703e-04, 1.36938e-04, 1.80825e-04, 2.38777e-04,
 3.15301e-04, 4.16351e-04, 5.49785e-04, 7.25983e-04, 9.58651e-04,
 1.26588e-03, 1.67158e-03, 2.20730e-03, 2.91471e-03, 3.84883e-03,
 5.08232e-03, 6.71113e-03, 8.86194e-03, 1.17021e-02, 1.54524e-02,
 2.04047e-02, 2.69441e-02, 3.55793e-02, 4.69819e-02, 6.20389e-02,
 8.19215e-02, 1.08176e-01, 1.42845e-01, 1.88625e-01, 2.49076e-01,
 3.28901e-01, 4.34309e-01, 5.73499e-01, 7.57297e-01, 1.00000e+00}
,
{8.87922e-13, 1.17519e-12, 1.55540e-12, 2.05862e-12, 2.72464e-12,
 3.60614e-12, 4.77283e-12, 6.31699e-12, 8.36072e-12, 1.10657e-11,
 1.46457e-11, 1.93840e-11, 2.56553e-11, 3.39556e-11, 4.49412e-11,
 5.94811e-11, 7.87249e-11, 1.04195e-10, 1.37905e-10, 1.82521e-10,
 2.41572e-10, 3.19728e-10, 4.23169e-10, 5.60076e-10, 7.41278e-10,
 9.81103e-10, 1.29852e-09, 1.71863e-09, 2.27465e-09, 3.01057e-09,
 3.98458e-09, 5.27371e-09, 6.97991e-09, 9.23811e-09, 1.22269e-08,
 1.61827e-08, 2.14182e-08, 2.83477e-08, 3.75190e-08, 4.96575e-08,
 6.57231e-08, 8.69865e-08, 1.15129e-07, 1.52377e-07, 2.01675e-07,
 2.66923e-07, 3.53281e-07, 4.67577e-07, 6.18852e-07, 8.19069e-07,
 1.08406e-06, 1.43479e-06, 1.89898e-06, 2.51336e-06, 3.32651e-06,
 4.40273e-06, 5.82714e-06, 7.71240e-06, 1.02076e-05, 1.35100e-05,
 1.78809e-05, 2.36659e-05, 3.13226e-05, 4.14563e-05, 5.48687e-05,
 7.26203e-05, 9.61151e-05, 1.27211e-04, 1.68368e-04, 2.22840e-04,
 2.94935e-04, 3.90355e-04, 5.16646e-04, 6.83796e-04, 9.05024e-04,
 1.19783e-03, 1.58536e-03, 2.09827e-03, 2.77712e-03, 3.67560e-03,
 4.86476e-03, 6.43866e-03, 8.52175e-03, 1.12788e-02, 1.49278e-02,
 1.97574e-02, 2.61495e-02, 3.46096e-02, 4.58069e-02, 6.06267e-02,
 8.02413e-02, 1.06202e-01, 1.40561e-01, 1.86037e-01, 2.46225e-01,
 3.25886e-01, 4.31320e-01, 5.70864e-01, 7.55556e-01, 1.00000e+00}
 ,
{7.06927e-13, 9.37796e-13, 1.24406e-12, 1.65035e-12, 2.18932e-12,
 2.90431e-12, 3.85280e-12, 5.11105e-12, 6.78022e-12, 8.99450e-12,
 1.19319e-11, 1.58287e-11, 2.09980e-11, 2.78555e-11, 3.69526e-11,
 4.90206e-11, 6.50298e-11, 8.62672e-11, 1.14440e-10, 1.51814e-10,
 2.01394e-10, 2.67165e-10, 3.54416e-10, 4.70162e-10, 6.23707e-10,
 8.27398e-10, 1.09761e-09, 1.45607e-09, 1.93159e-09, 2.56241e-09,
 3.39924e-09, 4.50937e-09, 5.98204e-09, 7.93566e-09, 1.05273e-08,
 1.39653e-08, 1.85261e-08, 2.45764e-08, 3.26025e-08, 4.32499e-08,
 5.73744e-08, 7.61118e-08, 1.00968e-07, 1.33943e-07, 1.77686e-07,
 2.35714e-07, 3.12694e-07, 4.14814e-07, 5.50284e-07, 7.29996e-07,
 9.68399e-07, 1.28466e-06, 1.70420e-06, 2.26076e-06, 2.99908e-06,
 3.97853e-06, 5.27783e-06, 7.00147e-06, 9.28802e-06, 1.23213e-05,
 1.63452e-05, 2.16832e-05, 2.87645e-05, 3.81585e-05, 5.06203e-05,
 6.71519e-05, 8.90823e-05, 1.18175e-04, 1.56768e-04, 2.07966e-04,
 2.75884e-04, 3.65982e-04, 4.85504e-04, 6.44061e-04, 8.54398e-04,
 1.13343e-03, 1.50358e-03, 1.99462e-03, 2.64603e-03, 3.51017e-03,
 4.65652e-03, 6.17725e-03, 8.19462e-03, 1.08708e-02, 1.44210e-02,
 1.91307e-02, 2.53783e-02, 3.36664e-02, 4.46612e-02, 5.92467e-02,
 7.85955e-02, 1.04263e-01, 1.38314e-01, 1.83484e-01, 2.43406e-01,
 3.22898e-01, 4.28350e-01, 5.68241e-01, 7.53818e-01, 1.00000e+00}
};

const std::vector< std::vector<double> > PROPOSAL::sigma_nu_p = {
{1.49873e-07, 1.53254e-06, 5.78771e-06, 1.52603e-05, 3.29075e-05,
 6.21520e-05, 1.06610e-04, 1.70088e-04, 2.56420e-04, 3.69192e-04,
 5.12205e-04, 6.88492e-04, 9.00235e-04, 1.14947e-03, 1.43817e-03,
 1.76764e-03, 2.13824e-03, 2.54983e-03, 3.00196e-03, 3.49399e-03,
 4.02512e-03, 4.59409e-03, 5.19918e-03, 5.83849e-03, 6.50982e-03,
 7.21100e-03, 7.93977e-03, 8.69370e-03, 9.47021e-03, 1.02667e-02,
 1.10806e-02, 1.19092e-02, 1.27501e-02, 1.36007e-02, 1.44586e-02,
 1.53216e-02, 1.61872e-02, 1.70532e-02, 1.79175e-02, 1.87782e-02,
 1.96335e-02, 2.04816e-02, 2.13207e-02, 2.21491e-02, 2.29656e-02,
 2.37689e-02, 2.45579e-02, 2.53312e-02, 2.60878e-02, 2.68267e-02,
 2.75472e-02, 2.82486e-02, 2.89304e-02, 2.95922e-02, 3.02329e-02,
 3.08526e-02, 3.14508e-02, 3.20276e-02, 3.25829e-02, 3.31161e-02,
 3.36277e-02, 3.41176e-02, 3.45862e-02, 3.50337e-02, 3.54602e-02,
 3.58660e-02, 3.62515e-02, 3.66170e-02, 3.69631e-02, 3.72899e-02,
 3.75980e-02, 3.78877e-02, 3.81596e-02, 3.84141e-02, 3.86515e-02,
 3.88722e-02, 3.90768e-02, 3.92660e-02, 3.94400e-02, 3.95994e-02,
 3.97444e-02, 3.98755e-02, 3.99934e-02, 4.00985e-02, 4.01912e-02,
 4.02722e-02, 4.03418e-02, 4.04005e-02, 4.04490e-02, 4.04878e-02,
 4.05176e-02, 4.05389e-02, 4.05525e-02, 4.05590e-02, 4.05591e-02,
 4.05539e-02, 4.05440e-02, 4.05305e-02, 4.05143e-02, 4.04966e-02}
,
{2.39602e-07, 2.40687e-06, 9.16870e-06, 2.43592e-05, 5.27598e-05,
 9.97793e-05, 1.71190e-04, 2.72951e-04, 4.10816e-04, 5.90474e-04,
 8.17276e-04, 1.09470e-03, 1.42602e-03, 1.81427e-03, 2.26153e-03,
 2.76830e-03, 3.33426e-03, 3.95869e-03, 4.64065e-03, 5.37870e-03,
 6.17050e-03, 7.01325e-03, 7.90377e-03, 8.83868e-03, 9.81458e-03,
 1.08278e-02, 1.18744e-02, 1.29503e-02, 1.40515e-02, 1.51741e-02,
 1.63141e-02, 1.74677e-02, 1.86314e-02, 1.98014e-02, 2.09741e-02,
 2.21463e-02, 2.33148e-02, 2.44770e-02, 2.56300e-02, 2.67709e-02,
 2.78974e-02, 2.90072e-02, 3.00985e-02, 3.11698e-02, 3.22185e-02,
 3.32434e-02, 3.42430e-02, 3.52165e-02, 3.61625e-02, 3.70807e-02,
 3.79695e-02, 3.88286e-02, 3.96576e-02, 4.04562e-02, 4.12243e-02,
 4.19614e-02, 4.26676e-02, 4.33434e-02, 4.39890e-02, 4.46047e-02,
 4.51907e-02, 4.57476e-02, 4.62758e-02, 4.67760e-02, 4.72487e-02,
 4.76945e-02, 4.81140e-02, 4.85077e-02, 4.88764e-02, 4.92205e-02,
 4.95405e-02, 4.98374e-02, 5.01119e-02, 5.03645e-02, 5.05955e-02,
 5.08055e-02, 5.09953e-02, 5.11655e-02, 5.13165e-02, 5.14490e-02,
 5.15635e-02, 5.16605e-02, 5.17407e-02, 5.18047e-02, 5.18532e-02,
 5.18868e-02, 5.19061e-02, 5.19118e-02, 5.19048e-02, 5.18859e-02,
 5.18560e-02, 5.18160e-02, 5.17669e-02, 5.17099e-02, 5.16461e-02,
 5.15768e-02, 5.15034e-02, 5.14273e-02, 5.13501e-02, 5.12735e-02}
,
{3.79464e-07, 3.75203e-06, 1.43904e-05, 3.84373e-05, 8.34974e-05,
 1.58090e-04, 2.71201e-04, 4.31883e-04, 6.48871e-04, 9.30684e-04,
 1.28393e-03, 1.71318e-03, 2.22360e-03, 2.81842e-03, 3.49871e-03,
 4.26395e-03, 5.11317e-03, 6.04479e-03, 7.05634e-03, 8.14398e-03,
 9.30335e-03, 1.05294e-02, 1.18170e-02, 1.31608e-02, 1.45549e-02,
 1.59931e-02, 1.74694e-02, 1.89775e-02, 2.05117e-02, 2.20660e-02,
 2.36350e-02, 2.52132e-02, 2.67949e-02, 2.83753e-02, 2.99500e-02,
 3.15147e-02, 3.30650e-02, 3.45970e-02, 3.61070e-02, 3.75923e-02,
 3.90503e-02, 4.04774e-02, 4.18715e-02, 4.32303e-02, 4.45526e-02,
 4.58364e-02, 4.70808e-02, 4.82839e-02, 4.94452e-02, 5.05640e-02,
 5.16403e-02, 5.26732e-02, 5.36628e-02, 5.46093e-02, 5.55134e-02,
 5.63755e-02, 5.71958e-02, 5.79752e-02, 5.87143e-02, 5.94142e-02,
 6.00754e-02, 6.06990e-02, 6.12858e-02, 6.18368e-02, 6.23527e-02,
 6.28342e-02, 6.32824e-02, 6.36986e-02, 6.40835e-02, 6.44376e-02,
 6.47616e-02, 6.50564e-02, 6.53228e-02, 6.55617e-02, 6.57737e-02,
 6.59593e-02, 6.61193e-02, 6.62543e-02, 6.63652e-02, 6.64526e-02,
 6.65171e-02, 6.65595e-02, 6.65805e-02, 6.65811e-02, 6.65620e-02,
 6.65242e-02, 6.64686e-02, 6.63964e-02, 6.63087e-02, 6.62066e-02,
 6.60916e-02, 6.59649e-02, 6.58281e-02, 6.56828e-02, 6.55308e-02,
 6.53739e-02, 6.52143e-02, 6.50543e-02, 6.48960e-02, 6.47422e-02}
,
{5.93379e-07, 5.79193e-06, 2.23500e-05, 5.99831e-05, 1.30630e-04,
 2.47478e-04, 4.24267e-04, 6.74476e-04, 1.01142e-03, 1.44661e-03,
 1.98794e-03, 2.64287e-03, 3.41743e-03, 4.31376e-03, 5.33137e-03,
 6.46883e-03, 7.72380e-03, 9.09229e-03, 1.05686e-02, 1.21458e-02,
 1.38162e-02, 1.55721e-02, 1.74048e-02, 1.93055e-02, 2.12647e-02,
 2.32734e-02, 2.53223e-02, 2.74028e-02, 2.95064e-02, 3.16247e-02,
 3.37494e-02, 3.58731e-02, 3.79890e-02, 4.00910e-02, 4.21721e-02,
 4.42266e-02, 4.62497e-02, 4.82371e-02, 5.01844e-02, 5.20871e-02,
 5.39420e-02, 5.57467e-02, 5.74983e-02, 5.91955e-02, 6.08354e-02,
 6.24170e-02, 6.39394e-02, 6.54025e-02, 6.68050e-02, 6.81471e-02,
 6.94293e-02, 7.06528e-02, 7.18176e-02, 7.29248e-02, 7.39754e-02,
 7.49708e-02, 7.59121e-02, 7.68006e-02, 7.76377e-02, 7.84247e-02,
 7.91628e-02, 7.98531e-02, 8.04972e-02, 8.10968e-02, 8.16531e-02,
 8.21665e-02, 8.26385e-02, 8.30700e-02, 8.34623e-02, 8.38164e-02,
 8.41330e-02, 8.44131e-02, 8.46573e-02, 8.48669e-02, 8.50424e-02,
 8.51846e-02, 8.52944e-02, 8.53726e-02, 8.54201e-02, 8.54378e-02,
 8.54267e-02, 8.53879e-02, 8.53223e-02, 8.52311e-02, 8.51155e-02,
 8.49769e-02, 8.48165e-02, 8.46358e-02, 8.44365e-02, 8.42202e-02,
 8.39887e-02, 8.37441e-02, 8.34886e-02, 8.32243e-02, 8.29539e-02,
 8.26803e-02, 8.24065e-02, 8.21358e-02, 8.18718e-02, 8.16186e-02}
,
{9.14909e-07, 8.83590e-06, 3.43479e-05, 9.26847e-05, 2.02225e-04,
 3.83083e-04, 6.55888e-04, 1.04078e-03, 1.55712e-03, 2.21907e-03,
 3.03776e-03, 4.02386e-03, 5.18179e-03, 6.51214e-03, 8.01250e-03,
 9.67988e-03, 1.15084e-02, 1.34894e-02, 1.56127e-02, 1.78665e-02,
 2.02391e-02, 2.27176e-02, 2.52883e-02, 2.79374e-02, 3.06509e-02,
 3.34157e-02, 3.62189e-02, 3.90479e-02, 4.18903e-02, 4.47345e-02,
 4.75704e-02, 5.03885e-02, 5.31786e-02, 5.59322e-02, 5.86421e-02,
 6.13020e-02, 6.39048e-02, 6.64449e-02, 6.89173e-02, 7.13187e-02,
 7.36454e-02, 7.58945e-02, 7.80631e-02, 8.01499e-02, 8.21543e-02,
 8.40750e-02, 8.59117e-02, 8.76654e-02, 8.93373e-02, 9.09280e-02,
 9.24389e-02, 9.38717e-02, 9.52284e-02, 9.65108e-02, 9.77208e-02,
 9.88605e-02, 9.99320e-02, 1.00937e-01, 1.01877e-01, 1.02755e-01,
 1.03572e-01, 1.04331e-01, 1.05033e-01, 1.05679e-01, 1.06270e-01,
 1.06809e-01, 1.07297e-01, 1.07734e-01, 1.08123e-01, 1.08463e-01,
 1.08756e-01, 1.09004e-01, 1.09206e-01, 1.09365e-01, 1.09481e-01,
 1.09555e-01, 1.09588e-01, 1.09582e-01, 1.09537e-01, 1.09455e-01,
 1.09338e-01, 1.09185e-01, 1.09000e-01, 1.08783e-01, 1.08536e-01,
 1.08260e-01, 1.07957e-01, 1.07630e-01, 1.07281e-01, 1.06911e-01,
 1.06524e-01, 1.06122e-01, 1.05707e-01, 1.05285e-01, 1.04857e-01,
 1.04429e-01, 1.04004e-01, 1.03588e-01, 1.03186e-01, 1.02804e-01}
,
{1.39118e-06, 1.33581e-05, 5.23893e-05, 1.41802e-04, 3.09762e-04,
 5.86612e-04, 1.00280e-03, 1.58826e-03, 2.36912e-03, 3.36304e-03,
 4.58690e-03, 6.05172e-03, 7.75921e-03, 9.70742e-03, 1.18918e-02,
 1.43047e-02, 1.69337e-02, 1.97634e-02, 2.27766e-02, 2.59559e-02,
 2.92819e-02, 3.27342e-02, 3.62921e-02, 3.99353e-02, 4.36444e-02,
 4.74007e-02, 5.11855e-02, 5.49808e-02, 5.87709e-02, 6.25414e-02,
 6.62775e-02, 6.99662e-02, 7.35960e-02, 7.71578e-02, 8.06412e-02,
 8.40376e-02, 8.73401e-02, 9.05434e-02, 9.36431e-02, 9.66335e-02,
 9.95122e-02, 1.02277e-01, 1.04927e-01, 1.07461e-01, 1.09880e-01,
 1.12184e-01, 1.14377e-01, 1.16458e-01, 1.18432e-01, 1.20300e-01,
 1.22065e-01, 1.23731e-01, 1.25300e-01, 1.26776e-01, 1.28161e-01,
 1.29458e-01, 1.30670e-01, 1.31802e-01, 1.32853e-01, 1.33828e-01,
 1.34727e-01, 1.35555e-01, 1.36311e-01, 1.36999e-01, 1.37620e-01,
 1.38176e-01, 1.38667e-01, 1.39096e-01, 1.39463e-01, 1.39771e-01,
 1.40020e-01, 1.40212e-01, 1.40348e-01, 1.40429e-01, 1.40457e-01,
 1.40433e-01, 1.40359e-01, 1.40236e-01, 1.40065e-01, 1.39847e-01,
 1.39586e-01, 1.39281e-01, 1.38935e-01, 1.38549e-01, 1.38126e-01,
 1.37668e-01, 1.37177e-01, 1.36655e-01, 1.36105e-01, 1.35531e-01,
 1.34936e-01, 1.34323e-01, 1.33697e-01, 1.33063e-01, 1.32425e-01,
 1.31790e-01, 1.31163e-01, 1.30553e-01, 1.29968e-01, 1.29416e-01}
,
{2.08794e-06, 2.00792e-05, 7.91418e-05, 2.15095e-04, 4.70160e-04,
 8.89446e-04, 1.51782e-03, 2.39863e-03, 3.56482e-03, 5.04112e-03,
 6.84961e-03, 8.99817e-03, 1.14854e-02, 1.43053e-02, 1.74489e-02,
 2.08984e-02, 2.46324e-02, 2.86255e-02, 3.28519e-02, 3.72832e-02,
 4.18891e-02, 4.66394e-02, 5.15043e-02, 5.64556e-02, 6.14657e-02,
 6.65072e-02, 7.15551e-02, 7.65871e-02, 8.15823e-02, 8.65197e-02,
 9.13814e-02, 9.61533e-02, 1.00821e-01, 1.05371e-01, 1.09792e-01,
 1.14077e-01, 1.18219e-01, 1.22211e-01, 1.26047e-01, 1.29727e-01,
 1.33248e-01, 1.36608e-01, 1.39809e-01, 1.42856e-01, 1.45747e-01,
 1.48489e-01, 1.51083e-01, 1.53535e-01, 1.55849e-01, 1.58030e-01,
 1.60082e-01, 1.62008e-01, 1.63814e-01, 1.65506e-01, 1.67086e-01,
 1.68559e-01, 1.69927e-01, 1.71194e-01, 1.72364e-01, 1.73440e-01,
 1.74424e-01, 1.75318e-01, 1.76126e-01, 1.76848e-01, 1.77487e-01,
 1.78046e-01, 1.78524e-01, 1.78926e-01, 1.79252e-01, 1.79504e-01,
 1.79684e-01, 1.79793e-01, 1.79834e-01, 1.79807e-01, 1.79715e-01,
 1.79559e-01, 1.79340e-01, 1.79060e-01, 1.78721e-01, 1.78325e-01,
 1.77873e-01, 1.77367e-01, 1.76808e-01, 1.76201e-01, 1.75545e-01,
 1.74845e-01, 1.74103e-01, 1.73322e-01, 1.72505e-01, 1.71657e-01,
 1.70783e-01, 1.69887e-01, 1.68975e-01, 1.68054e-01, 1.67132e-01,
 1.66217e-01, 1.65319e-01, 1.64448e-01, 1.63618e-01, 1.62841e-01}
,
{3.09637e-06, 2.99454e-05, 1.18735e-04, 3.23431e-04, 7.07252e-04,
 1.33644e-03, 2.27612e-03, 3.58685e-03, 5.30974e-03, 7.48096e-03,
 1.01230e-02, 1.32388e-02, 1.68223e-02, 2.08616e-02, 2.53354e-02,
 3.02126e-02, 3.54574e-02, 4.10320e-02, 4.68952e-02, 5.30028e-02,
 5.93108e-02, 6.57755e-02, 7.23562e-02, 7.90122e-02, 8.57041e-02,
 9.23965e-02, 9.90583e-02, 1.05658e-01, 1.12166e-01, 1.18561e-01,
 1.24822e-01, 1.30927e-01, 1.36860e-01, 1.42608e-01, 1.48161e-01,
 1.53508e-01, 1.58643e-01, 1.63562e-01, 1.68262e-01, 1.72742e-01,
 1.77003e-01, 1.81052e-01, 1.84890e-01, 1.88522e-01, 1.91955e-01,
 1.95195e-01, 1.98248e-01, 2.01123e-01, 2.03824e-01, 2.06358e-01,
 2.08734e-01, 2.10957e-01, 2.13033e-01, 2.14967e-01, 2.16764e-01,
 2.18431e-01, 2.19970e-01, 2.21385e-01, 2.22681e-01, 2.23862e-01,
 2.24929e-01, 2.25886e-01, 2.26736e-01, 2.27481e-01, 2.28125e-01,
 2.28669e-01, 2.29117e-01, 2.29470e-01, 2.29731e-01, 2.29902e-01,
 2.29985e-01, 2.29982e-01, 2.29894e-01, 2.29724e-01, 2.29473e-01,
 2.29143e-01, 2.28735e-01, 2.28251e-01, 2.27693e-01, 2.27062e-01,
 2.26360e-01, 2.25590e-01, 2.24752e-01, 2.23850e-01, 2.22887e-01,
 2.21864e-01, 2.20786e-01, 2.19656e-01, 2.18480e-01, 2.17263e-01,
 2.16011e-01, 2.14731e-01, 2.13432e-01, 2.12123e-01, 2.10817e-01,
 2.09524e-01, 2.08261e-01, 2.07042e-01, 2.05887e-01, 2.04816e-01}
,
{4.55220e-06, 4.42798e-05, 1.76824e-04, 4.82712e-04, 1.05510e-03,
 1.99082e-03, 3.38399e-03, 5.31398e-03, 7.83599e-03, 1.09979e-02,
 1.48171e-02, 1.92900e-02, 2.44033e-02, 3.01316e-02, 3.64338e-02,
 4.32594e-02, 5.05541e-02, 5.82588e-02, 6.63100e-02, 7.46433e-02,
 8.31955e-02, 9.19073e-02, 1.00720e-01, 1.09576e-01, 1.18426e-01,
 1.27224e-01, 1.35926e-01, 1.44492e-01, 1.52892e-01, 1.61094e-01,
 1.69070e-01, 1.76801e-01, 1.84268e-01, 1.91459e-01, 1.98360e-01,
 2.04965e-01, 2.11272e-01, 2.17275e-01, 2.22980e-01, 2.28391e-01,
 2.33514e-01, 2.38355e-01, 2.42926e-01, 2.47233e-01, 2.51289e-01,
 2.55102e-01, 2.58682e-01, 2.62039e-01, 2.65184e-01, 2.68127e-01,
 2.70874e-01, 2.73433e-01, 2.75813e-01, 2.78021e-01, 2.80061e-01,
 2.81941e-01, 2.83666e-01, 2.85240e-01, 2.86667e-01, 2.87952e-01,
 2.89100e-01, 2.90113e-01, 2.90997e-01, 2.91754e-01, 2.92388e-01,
 2.92902e-01, 2.93299e-01, 2.93581e-01, 2.93752e-01, 2.93814e-01,
 2.93768e-01, 2.93617e-01, 2.93363e-01, 2.93007e-01, 2.92550e-01,
 2.91994e-01, 2.91341e-01, 2.90592e-01, 2.89747e-01, 2.88809e-01,
 2.87779e-01, 2.86659e-01, 2.85450e-01, 2.84156e-01, 2.82779e-01,
 2.81324e-01, 2.79794e-01, 2.78196e-01, 2.76535e-01, 2.74819e-01,
 2.73058e-01, 2.71261e-01, 2.69441e-01, 2.67612e-01, 2.65790e-01,
 2.63992e-01, 2.62240e-01, 2.60557e-01, 2.58970e-01, 2.57511e-01}
,
{6.66640e-06, 6.51415e-05, 2.61404e-04, 7.14954e-04, 1.56239e-03,
 2.94223e-03, 4.98973e-03, 7.80540e-03, 1.14665e-02, 1.60270e-02,
 2.14953e-02, 2.78583e-02, 3.50895e-02, 4.31370e-02, 5.19320e-02,
 6.13980e-02, 7.14509e-02, 8.20006e-02, 9.29538e-02, 1.04219e-01,
 1.15710e-01, 1.27341e-01, 1.39032e-01, 1.50709e-01, 1.62310e-01,
 1.73767e-01, 1.85029e-01, 1.96052e-01, 2.06790e-01, 2.17207e-01,
 2.27278e-01, 2.36980e-01, 2.46292e-01, 2.55201e-01, 2.63704e-01,
 2.71792e-01, 2.79469e-01, 2.86743e-01, 2.93621e-01, 3.00114e-01,
 3.06235e-01, 3.11997e-01, 3.17416e-01, 3.22506e-01, 3.27280e-01,
 3.31753e-01, 3.35943e-01, 3.39861e-01, 3.43518e-01, 3.46926e-01,
 3.50097e-01, 3.53041e-01, 3.55765e-01, 3.58278e-01, 3.60589e-01,
 3.62704e-01, 3.64628e-01, 3.66370e-01, 3.67934e-01, 3.69327e-01,
 3.70554e-01, 3.71619e-01, 3.72529e-01, 3.73288e-01, 3.73898e-01,
 3.74365e-01, 3.74691e-01, 3.74879e-01, 3.74932e-01, 3.74852e-01,
 3.74642e-01, 3.74301e-01, 3.73833e-01, 3.73237e-01, 3.72515e-01,
 3.71667e-01, 3.70695e-01, 3.69597e-01, 3.68376e-01, 3.67031e-01,
 3.65565e-01, 3.63978e-01, 3.62274e-01, 3.60456e-01, 3.58526e-01,
 3.56491e-01, 3.54357e-01, 3.52131e-01, 3.49822e-01, 3.47440e-01,
 3.44997e-01, 3.42508e-01, 3.39990e-01, 3.37462e-01, 3.34946e-01,
 3.32469e-01, 3.30060e-01, 3.27753e-01, 3.25588e-01, 3.23610e-01}
,
{9.71212e-06, 9.53338e-05, 3.84281e-04, 1.05203e-03, 2.29646e-03,
 4.31727e-03, 7.30004e-03, 1.13747e-02, 1.66464e-02, 2.31655e-02,
 3.09282e-02, 3.99067e-02, 5.00454e-02, 6.12538e-02, 7.34243e-02,
 8.64421e-02, 1.00178e-01, 1.14500e-01, 1.29274e-01, 1.44377e-01,
 1.59685e-01, 1.75082e-01, 1.90463e-01, 2.05735e-01, 2.20806e-01,
 2.35602e-01, 2.50061e-01, 2.64118e-01, 2.77727e-01, 2.90851e-01,
 3.03461e-01, 3.15528e-01, 3.27042e-01, 3.37996e-01, 3.48385e-01,
 3.58218e-01, 3.67508e-01, 3.76267e-01, 3.84514e-01, 3.92269e-01,
 3.99553e-01, 4.06388e-01, 4.12792e-01, 4.18787e-01, 4.24400e-01,
 4.29645e-01, 4.34540e-01, 4.39103e-01, 4.43350e-01, 4.47295e-01,
 4.50950e-01, 4.54329e-01, 4.57441e-01, 4.60296e-01, 4.62905e-01,
 4.65277e-01, 4.67420e-01, 4.69343e-01, 4.71055e-01, 4.72562e-01,
 4.73872e-01, 4.74990e-01, 4.75922e-01, 4.76674e-01, 4.77250e-01,
 4.77652e-01, 4.77886e-01, 4.77954e-01, 4.77857e-01, 4.77597e-01,
 4.77175e-01, 4.76592e-01, 4.75847e-01, 4.74941e-01, 4.73872e-01,
 4.72641e-01, 4.71247e-01, 4.69688e-01, 4.67966e-01, 4.66082e-01,
 4.64035e-01, 4.61830e-01, 4.59467e-01, 4.56952e-01, 4.54290e-01,
 4.51487e-01, 4.48550e-01, 4.45489e-01, 4.42315e-01, 4.39042e-01,
 4.35687e-01, 4.32270e-01, 4.28812e-01, 4.25342e-01, 4.21890e-01,
 4.18493e-01, 4.15195e-01, 4.12044e-01, 4.09099e-01, 4.06424e-01}
,
{1.40655e-05, 1.38648e-04, 5.61168e-04, 1.53777e-03, 3.35343e-03,
 6.29159e-03, 1.06021e-02, 1.64561e-02, 2.39870e-02, 3.32305e-02,
 4.41654e-02, 5.67376e-02, 7.08402e-02, 8.63277e-02, 1.03040e-01,
 1.20802e-01, 1.39422e-01, 1.58712e-01, 1.78489e-01, 1.98579e-01,
 2.18812e-01, 2.39036e-01, 2.59120e-01, 2.78931e-01, 2.98363e-01,
 3.17328e-01, 3.35736e-01, 3.53524e-01, 3.70641e-01, 3.87046e-01,
 4.02706e-01, 4.17609e-01, 4.31741e-01, 4.45109e-01, 4.57730e-01,
 4.69617e-01, 4.80797e-01, 4.91298e-01, 5.01149e-01, 5.10380e-01,
 5.19022e-01, 5.27104e-01, 5.34663e-01, 5.41724e-01, 5.48310e-01,
 5.54448e-01, 5.60164e-01, 5.65475e-01, 5.70400e-01, 5.74959e-01,
 5.79166e-01, 5.83036e-01, 5.86583e-01, 5.89822e-01, 5.92765e-01,
 5.95425e-01, 5.97814e-01, 5.99942e-01, 6.01820e-01, 6.03456e-01,
 6.04858e-01, 6.06033e-01, 6.06988e-01, 6.07728e-01, 6.08258e-01,
 6.08581e-01, 6.08698e-01, 6.08613e-01, 6.08324e-01, 6.07833e-01,
 6.07138e-01, 6.06237e-01, 6.05131e-01, 6.03815e-01, 6.02288e-01,
 6.00549e-01, 5.98596e-01, 5.96429e-01, 5.94046e-01, 5.91449e-01,
 5.88639e-01, 5.85619e-01, 5.82390e-01, 5.78956e-01, 5.75325e-01,
 5.71502e-01, 5.67497e-01, 5.63324e-01, 5.58995e-01, 5.54529e-01,
 5.49948e-01, 5.45278e-01, 5.40552e-01, 5.35806e-01, 5.31087e-01,
 5.26446e-01, 5.21946e-01, 5.17658e-01, 5.13667e-01, 5.10068e-01}
,
{2.02436e-05, 2.00456e-04, 8.15226e-04, 2.23488e-03, 4.86593e-03,
 9.10964e-03, 1.52941e-02, 2.36479e-02, 3.43240e-02, 4.73347e-02,
 6.26312e-02, 8.01068e-02, 9.95789e-02, 1.20827e-01, 1.43612e-01,
 1.67669e-01, 1.92727e-01, 2.18523e-01, 2.44808e-01, 2.71336e-01,
 2.97888e-01, 3.24271e-01, 3.50299e-01, 3.75817e-01, 4.00700e-01,
 4.24821e-01, 4.48092e-01, 4.70445e-01, 4.91816e-01, 5.12171e-01,
 5.31492e-01, 5.49764e-01, 5.67004e-01, 5.83237e-01, 5.98486e-01,
 6.12794e-01, 6.26198e-01, 6.38745e-01, 6.50478e-01, 6.61436e-01,
 6.71672e-01, 6.81228e-01, 6.90136e-01, 6.98435e-01, 7.06160e-01,
 7.13340e-01, 7.20003e-01, 7.26177e-01, 7.31881e-01, 7.37140e-01,
 7.41974e-01, 7.46403e-01, 7.50447e-01, 7.54124e-01, 7.57451e-01,
 7.60445e-01, 7.63118e-01, 7.65485e-01, 7.67557e-01, 7.69345e-01,
 7.70857e-01, 7.72101e-01, 7.73085e-01, 7.73810e-01, 7.74283e-01,
 7.74502e-01, 7.74470e-01, 7.74186e-01, 7.73647e-01, 7.72851e-01,
 7.71795e-01, 7.70475e-01, 7.68887e-01, 7.67030e-01, 7.64899e-01,
 7.62492e-01, 7.59807e-01, 7.56842e-01, 7.53595e-01, 7.50067e-01,
 7.46255e-01, 7.42162e-01, 7.37789e-01, 7.33142e-01, 7.28225e-01,
 7.23048e-01, 7.17620e-01, 7.11957e-01, 7.06078e-01, 7.00008e-01,
 6.93776e-01, 6.87420e-01, 6.80984e-01, 6.74523e-01, 6.68101e-01,
 6.61792e-01, 6.55684e-01, 6.49881e-01, 6.44499e-01, 6.39678e-01}
,
{2.89548e-05, 2.88749e-04, 1.17816e-03, 3.22931e-03, 7.01992e-03,
 1.31107e-02, 2.19236e-02, 3.37687e-02, 4.87967e-02, 6.69878e-02,
 8.82465e-02, 1.12373e-01, 1.39077e-01, 1.68036e-01, 1.98890e-01,
 2.31255e-01, 2.64752e-01, 2.99024e-01, 3.33721e-01, 3.68519e-01,
 4.03141e-01, 4.37320e-01, 4.70830e-01, 5.03492e-01, 5.35126e-01,
 5.65607e-01, 5.94836e-01, 6.22728e-01, 6.49236e-01, 6.74339e-01,
 6.98019e-01, 7.20310e-01, 7.41240e-01, 7.60856e-01, 7.79215e-01,
 7.96377e-01, 8.12405e-01, 8.27357e-01, 8.41300e-01, 8.54304e-01,
 8.66417e-01, 8.77692e-01, 8.88181e-01, 8.97932e-01, 9.06980e-01,
 9.15369e-01, 9.23129e-01, 9.30292e-01, 9.36891e-01, 9.42954e-01,
 9.48510e-01, 9.53586e-01, 9.58207e-01, 9.62396e-01, 9.66175e-01,
 9.69562e-01, 9.72575e-01, 9.75229e-01, 9.77538e-01, 9.79513e-01,
 9.81163e-01, 9.82494e-01, 9.83511e-01, 9.84216e-01, 9.84610e-01,
 9.84692e-01, 9.84458e-01, 9.83906e-01, 9.83030e-01, 9.81826e-01,
 9.80288e-01, 9.78413e-01, 9.76194e-01, 9.73628e-01, 9.70709e-01,
 9.67433e-01, 9.63794e-01, 9.59788e-01, 9.55410e-01, 9.50658e-01,
 9.45529e-01, 9.40021e-01, 9.34136e-01, 9.27876e-01, 9.21248e-01,
 9.14261e-01, 9.06929e-01, 8.99274e-01, 8.91321e-01, 8.83104e-01,
 8.74667e-01, 8.66059e-01, 8.57344e-01, 8.48596e-01, 8.39902e-01,
 8.31367e-01, 8.23113e-01, 8.15283e-01, 8.08045e-01, 8.01593e-01}
,
{4.11654e-05, 4.14086e-04, 1.69349e-03, 4.64237e-03, 1.00739e-02,
 1.87590e-02, 3.12446e-02, 4.79355e-02, 6.89525e-02, 9.42326e-02,
 1.23593e-01, 1.56690e-01, 1.93090e-01, 2.32313e-01, 2.73831e-01,
 3.17102e-01, 3.61609e-01, 4.06857e-01, 4.52373e-01, 4.97750e-01,
 5.42609e-01, 5.86615e-01, 6.29509e-01, 6.71035e-01, 7.11010e-01,
 7.49295e-01, 7.85770e-01, 8.20368e-01, 8.53060e-01, 8.83831e-01,
 9.12727e-01, 9.39793e-01, 9.65099e-01, 9.88727e-01, 1.01076e+00,
 1.03130e+00, 1.05042e+00, 1.06821e+00, 1.08478e+00, 1.10018e+00,
 1.11450e+00, 1.12780e+00, 1.14014e+00, 1.15158e+00, 1.16217e+00,
 1.17195e+00, 1.18098e+00, 1.18929e+00, 1.19692e+00, 1.20392e+00,
 1.21032e+00, 1.21616e+00, 1.22146e+00, 1.22626e+00, 1.23058e+00,
 1.23445e+00, 1.23788e+00, 1.24088e+00, 1.24349e+00, 1.24570e+00,
 1.24751e+00, 1.24895e+00, 1.25000e+00, 1.25066e+00, 1.25094e+00,
 1.25083e+00, 1.25031e+00, 1.24939e+00, 1.24806e+00, 1.24632e+00,
 1.24415e+00, 1.24155e+00, 1.23851e+00, 1.23502e+00, 1.23108e+00,
 1.22667e+00, 1.22178e+00, 1.21641e+00, 1.21054e+00, 1.20418e+00,
 1.19730e+00, 1.18992e+00, 1.18202e+00, 1.17362e+00, 1.16471e+00,
 1.15532e+00, 1.14545e+00, 1.13515e+00, 1.12445e+00, 1.11339e+00,
 1.10203e+00, 1.09043e+00, 1.07868e+00, 1.06689e+00, 1.05516e+00,
 1.04364e+00, 1.03250e+00, 1.02194e+00, 1.01220e+00, 1.00354e+00}
,
{5.82706e-05, 5.90866e-04, 2.42414e-03, 6.64032e-03, 1.43815e-02,
 2.66933e-02, 4.42910e-02, 6.76640e-02, 9.68863e-02, 1.31821e-01,
 1.72132e-01, 2.17271e-01, 2.66604e-01, 3.19419e-01, 3.74962e-01,
 4.32483e-01, 4.91282e-01, 5.50672e-01, 6.10050e-01, 6.68880e-01,
 7.26663e-01, 7.83019e-01, 8.37585e-01, 8.90084e-01, 9.40319e-01,
 9.88118e-01, 1.03338e+00, 1.07607e+00, 1.11617e+00, 1.15374e+00,
 1.18884e+00, 1.22159e+00, 1.25210e+00, 1.28048e+00, 1.30688e+00,
 1.33140e+00, 1.35419e+00, 1.37535e+00, 1.39500e+00, 1.41323e+00,
 1.43015e+00, 1.44581e+00, 1.46032e+00, 1.47373e+00, 1.48610e+00,
 1.49751e+00, 1.50801e+00, 1.51766e+00, 1.52651e+00, 1.53461e+00,
 1.54201e+00, 1.54876e+00, 1.55488e+00, 1.56042e+00, 1.56540e+00,
 1.56985e+00, 1.57380e+00, 1.57724e+00, 1.58021e+00, 1.58270e+00,
 1.58471e+00, 1.58625e+00, 1.58732e+00, 1.58790e+00, 1.58800e+00,
 1.58760e+00, 1.58671e+00, 1.58530e+00, 1.58337e+00, 1.58092e+00,
 1.57792e+00, 1.57438e+00, 1.57027e+00, 1.56557e+00, 1.56028e+00,
 1.55438e+00, 1.54785e+00, 1.54068e+00, 1.53284e+00, 1.52434e+00,
 1.51515e+00, 1.50527e+00, 1.49471e+00, 1.48347e+00, 1.47155e+00,
 1.45899e+00, 1.44580e+00, 1.43201e+00, 1.41767e+00, 1.40285e+00,
 1.38760e+00, 1.37203e+00, 1.35623e+00, 1.34035e+00, 1.32454e+00,
 1.30900e+00, 1.29396e+00, 1.27970e+00, 1.26655e+00, 1.25489e+00}
,
{8.23012e-05, 8.39744e-04, 3.45384e-03, 9.45426e-03, 2.04364e-02,
 3.77930e-02, 6.24664e-02, 9.50102e-02, 1.35426e-01, 1.83445e-01,
 2.38485e-01, 2.99719e-01, 3.66219e-01, 4.36952e-01, 5.10856e-01,
 5.86920e-01, 6.64174e-01, 7.41716e-01, 8.18774e-01, 8.94622e-01,
 9.68680e-01, 1.04044e+00, 1.10949e+00, 1.17552e+00, 1.23830e+00,
 1.29766e+00, 1.35356e+00, 1.40596e+00, 1.45496e+00, 1.50064e+00,
 1.54316e+00, 1.58267e+00, 1.61936e+00, 1.65339e+00, 1.68495e+00,
 1.71422e+00, 1.74135e+00, 1.76650e+00, 1.78979e+00, 1.81136e+00,
 1.83131e+00, 1.84975e+00, 1.86678e+00, 1.88248e+00, 1.89694e+00,
 1.91024e+00, 1.92247e+00, 1.93370e+00, 1.94400e+00, 1.95342e+00,
 1.96203e+00, 1.96987e+00, 1.97700e+00, 1.98344e+00, 1.98924e+00,
 1.99442e+00, 1.99899e+00, 2.00297e+00, 2.00636e+00, 2.00918e+00,
 2.01140e+00, 2.01304e+00, 2.01408e+00, 2.01452e+00, 2.01435e+00,
 2.01356e+00, 2.01215e+00, 2.01009e+00, 2.00738e+00, 2.00400e+00,
 1.99992e+00, 1.99513e+00, 1.98961e+00, 1.98333e+00, 1.97626e+00,
 1.96838e+00, 1.95967e+00, 1.95010e+00, 1.93965e+00, 1.92831e+00,
 1.91607e+00, 1.90292e+00, 1.88887e+00, 1.87390e+00, 1.85805e+00,
 1.84131e+00, 1.82373e+00, 1.80534e+00, 1.78620e+00, 1.76637e+00,
 1.74595e+00, 1.72505e+00, 1.70382e+00, 1.68243e+00, 1.66111e+00,
 1.64012e+00, 1.61978e+00, 1.60049e+00, 1.58269e+00, 1.56694e+00}
,
{1.15908e-04, 1.18977e-03, 4.90057e-03, 1.34017e-02, 2.89053e-02,
 5.32503e-02, 8.76750e-02, 1.32755e-01, 1.88374e-01, 2.54044e-01,
 3.28811e-01, 4.11468e-01, 5.00655e-01, 5.94901e-01, 6.92751e-01,
 7.92832e-01, 8.93822e-01, 9.94581e-01, 1.09407e+00, 1.19138e+00,
 1.28582e+00, 1.37674e+00, 1.46368e+00, 1.54631e+00, 1.62437e+00,
 1.69777e+00, 1.76647e+00, 1.83057e+00, 1.89021e+00, 1.94559e+00,
 1.99695e+00, 2.04453e+00, 2.08857e+00, 2.12932e+00, 2.16704e+00,
 2.20194e+00, 2.23421e+00, 2.26406e+00, 2.29165e+00, 2.31714e+00,
 2.34066e+00, 2.36234e+00, 2.38231e+00, 2.40070e+00, 2.41761e+00,
 2.43316e+00, 2.44744e+00, 2.46056e+00, 2.47259e+00, 2.48361e+00,
 2.49368e+00, 2.50287e+00, 2.51123e+00, 2.51879e+00, 2.52559e+00,
 2.53164e+00, 2.53697e+00, 2.54158e+00, 2.54546e+00, 2.54862e+00,
 2.55105e+00, 2.55275e+00, 2.55371e+00, 2.55393e+00, 2.55338e+00,
 2.55207e+00, 2.54996e+00, 2.54704e+00, 2.54328e+00, 2.53866e+00,
 2.53315e+00, 2.52671e+00, 2.51930e+00, 2.51090e+00, 2.50146e+00,
 2.49095e+00, 2.47934e+00, 2.46661e+00, 2.45273e+00, 2.43769e+00,
 2.42146e+00, 2.40403e+00, 2.38540e+00, 2.36556e+00, 2.34452e+00,
 2.32229e+00, 2.29891e+00, 2.27441e+00, 2.24886e+00, 2.22235e+00,
 2.19499e+00, 2.16694e+00, 2.13838e+00, 2.10957e+00, 2.08079e+00,
 2.05243e+00, 2.02491e+00, 1.99878e+00, 1.97467e+00, 1.95333e+00}
,
{1.62695e-04, 1.67946e-03, 6.92790e-03, 1.89182e-02, 4.07111e-02,
 7.47011e-02, 1.22501e-01, 1.84643e-01, 2.60830e-01, 3.50211e-01,
 4.51297e-01, 5.62347e-01, 6.81392e-01, 8.06378e-01, 9.35335e-01,
 1.06639e+00, 1.19781e+00, 1.32812e+00, 1.45595e+00, 1.58027e+00,
 1.70010e+00, 1.81476e+00, 1.92374e+00, 2.02663e+00, 2.12329e+00,
 2.21362e+00, 2.29777e+00, 2.37590e+00, 2.44831e+00, 2.51530e+00,
 2.57722e+00, 2.63440e+00, 2.68720e+00, 2.73598e+00, 2.78101e+00,
 2.82258e+00, 2.86095e+00, 2.89636e+00, 2.92901e+00, 2.95909e+00,
 2.98679e+00, 3.01227e+00, 3.03571e+00, 3.05727e+00, 3.07709e+00,
 3.09532e+00, 3.11207e+00, 3.12746e+00, 3.14159e+00, 3.15455e+00,
 3.16643e+00, 3.17727e+00, 3.18713e+00, 3.19605e+00, 3.20405e+00,
 3.21115e+00, 3.21736e+00, 3.22268e+00, 3.22709e+00, 3.23062e+00,
 3.23325e+00, 3.23497e+00, 3.23577e+00, 3.23565e+00, 3.23458e+00,
 3.23253e+00, 3.22948e+00, 3.22539e+00, 3.22022e+00, 3.21393e+00,
 3.20647e+00, 3.19780e+00, 3.18786e+00, 3.17662e+00, 3.16403e+00,
 3.15005e+00, 3.13465e+00, 3.11779e+00, 3.09943e+00, 3.07955e+00,
 3.05810e+00, 3.03507e+00, 3.01043e+00, 2.98416e+00, 2.95627e+00,
 2.92675e+00, 2.89564e+00, 2.86299e+00, 2.82887e+00, 2.79339e+00,
 2.75672e+00, 2.71905e+00, 2.68064e+00, 2.64182e+00, 2.60299e+00,
 2.56466e+00, 2.52741e+00, 2.49197e+00, 2.45922e+00, 2.43019e+00}
,
{2.27558e-04, 2.36127e-03, 9.75446e-03, 2.66056e-02, 5.70966e-02,
 1.04363e-01, 1.70426e-01, 2.55700e-01, 3.59616e-01, 4.80714e-01,
 6.16791e-01, 7.65325e-01, 9.23516e-01, 1.08854e+00, 1.25775e+00,
 1.42860e+00, 1.59890e+00, 1.76666e+00, 1.93025e+00, 2.08831e+00,
 2.23972e+00, 2.38371e+00, 2.51967e+00, 2.64731e+00, 2.76647e+00,
 2.87729e+00, 2.98002e+00, 3.07501e+00, 3.16271e+00, 3.24359e+00,
 3.31811e+00, 3.38678e+00, 3.45007e+00, 3.50837e+00, 3.56209e+00,
 3.61159e+00, 3.65717e+00, 3.69913e+00, 3.73773e+00, 3.77321e+00,
 3.80582e+00, 3.83580e+00, 3.86335e+00, 3.88869e+00, 3.91199e+00,
 3.93344e+00, 3.95316e+00, 3.97132e+00, 3.98802e+00, 4.00336e+00,
 4.01743e+00, 4.03028e+00, 4.04197e+00, 4.05251e+00, 4.06194e+00,
 4.07025e+00, 4.07745e+00, 4.08356e+00, 4.08857e+00, 4.09247e+00,
 4.09526e+00, 4.09694e+00, 4.09747e+00, 4.09684e+00, 4.09500e+00,
 4.09193e+00, 4.08756e+00, 4.08185e+00, 4.07473e+00, 4.06615e+00,
 4.05605e+00, 4.04437e+00, 4.03106e+00, 4.01607e+00, 3.99935e+00,
 3.98083e+00, 3.96047e+00, 3.93822e+00, 3.91400e+00, 3.88777e+00,
 3.85946e+00, 3.82903e+00, 3.79643e+00, 3.76163e+00, 3.72461e+00,
 3.68536e+00, 3.64393e+00, 3.60036e+00, 3.55476e+00, 3.50728e+00,
 3.45812e+00, 3.40754e+00, 3.35589e+00, 3.30358e+00, 3.25117e+00,
 3.19930e+00, 3.14878e+00, 3.10060e+00, 3.05594e+00, 3.01622e+00}
,
{3.17121e-04, 3.31044e-03, 1.36898e-02, 3.72760e-02, 7.97673e-02,
 1.45228e-01, 2.36133e-01, 3.52677e-01, 4.93824e-01, 6.57200e-01,
 8.39629e-01, 1.03747e+00, 1.24680e+00, 1.46382e+00, 1.68491e+00,
 1.90676e+00, 2.12652e+00, 2.34162e+00, 2.55011e+00, 2.75023e+00,
 2.94077e+00, 3.12082e+00, 3.28980e+00, 3.44749e+00, 3.59393e+00,
 3.72946e+00, 3.85455e+00, 3.96979e+00, 4.07584e+00, 4.17332e+00,
 4.26294e+00, 4.34537e+00, 4.42113e+00, 4.49080e+00, 4.55485e+00,
 4.61373e+00, 4.66783e+00, 4.71750e+00, 4.76310e+00, 4.80496e+00,
 4.84339e+00, 4.87871e+00, 4.91117e+00, 4.94104e+00, 4.96854e+00,
 4.99387e+00, 5.01723e+00, 5.03877e+00, 5.05861e+00, 5.07685e+00,
 5.09358e+00, 5.10886e+00, 5.12271e+00, 5.13516e+00, 5.14622e+00,
 5.15592e+00, 5.16426e+00, 5.17124e+00, 5.17688e+00, 5.18116e+00,
 5.18406e+00, 5.18556e+00, 5.18562e+00, 5.18420e+00, 5.18124e+00,
 5.17667e+00, 5.17043e+00, 5.16244e+00, 5.15262e+00, 5.14092e+00,
 5.12727e+00, 5.11160e+00, 5.09385e+00, 5.07393e+00, 5.05179e+00,
 5.02733e+00, 5.00047e+00, 4.97111e+00, 4.93916e+00, 4.90452e+00,
 4.86711e+00, 4.82683e+00, 4.78362e+00, 4.73742e+00, 4.68819e+00,
 4.63594e+00, 4.58070e+00, 4.52255e+00, 4.46161e+00, 4.39805e+00,
 4.33213e+00, 4.26419e+00, 4.19466e+00, 4.12410e+00, 4.05321e+00,
 3.98288e+00, 3.91418e+00, 3.84845e+00, 3.78730e+00, 3.73269e+00}
,
{4.40328e-04, 4.62866e-03, 1.91497e-02, 5.20550e-02, 1.11019e-01,
 2.01356e-01, 3.25934e-01, 4.84606e-01, 6.75548e-01, 8.95111e-01,
 1.13872e+00, 1.40119e+00, 1.67713e+00, 1.96142e+00, 2.24918e+00,
 2.53617e+00, 2.81860e+00, 3.09342e+00, 3.35804e+00, 3.61047e+00,
 3.84933e+00, 4.07360e+00, 4.28286e+00, 4.47701e+00, 4.65647e+00,
 4.82180e+00, 4.97381e+00, 5.11338e+00, 5.24140e+00, 5.35881e+00,
 5.46655e+00, 5.56536e+00, 5.65603e+00, 5.73922e+00, 5.81553e+00,
 5.88551e+00, 5.94965e+00, 6.00843e+00, 6.06232e+00, 6.11175e+00,
 6.15712e+00, 6.19882e+00, 6.23718e+00, 6.27252e+00, 6.30511e+00,
 6.33519e+00, 6.36298e+00, 6.38864e+00, 6.41229e+00, 6.43404e+00,
 6.45396e+00, 6.47210e+00, 6.48848e+00, 6.50313e+00, 6.51610e+00,
 6.52738e+00, 6.53699e+00, 6.54495e+00, 6.55124e+00, 6.55583e+00,
 6.55869e+00, 6.55978e+00, 6.55904e+00, 6.55637e+00, 6.55171e+00,
 6.54496e+00, 6.53604e+00, 6.52488e+00, 6.51139e+00, 6.49550e+00,
 6.47713e+00, 6.45619e+00, 6.43258e+00, 6.40618e+00, 6.37689e+00,
 6.34456e+00, 6.30907e+00, 6.27027e+00, 6.22801e+00, 6.18215e+00,
 6.13255e+00, 6.07909e+00, 6.02168e+00, 5.96023e+00, 5.89471e+00,
 5.82509e+00, 5.75141e+00, 5.67373e+00, 5.59220e+00, 5.50703e+00,
 5.41853e+00, 5.32711e+00, 5.23334e+00, 5.13794e+00, 5.04186e+00,
 4.94625e+00, 4.85260e+00, 4.76270e+00, 4.67875e+00, 4.60342e+00}
,
{6.09723e-04, 6.45190e-03, 2.66969e-02, 7.24456e-02, 1.53982e-01,
 2.78180e-01, 4.48258e-01, 6.63503e-01, 9.20849e-01, 1.21484e+00,
 1.53895e+00, 1.88588e+00, 2.24831e+00, 2.61933e+00, 2.99252e+00,
 3.36241e+00, 3.72412e+00, 4.07392e+00, 4.40856e+00, 4.72585e+00,
 5.02414e+00, 5.30258e+00, 5.56081e+00, 5.79925e+00, 6.01859e+00,
 6.21987e+00, 6.40429e+00, 6.57308e+00, 6.72748e+00, 6.86886e+00,
 6.99822e+00, 7.11664e+00, 7.22508e+00, 7.32434e+00, 7.41518e+00,
 7.49828e+00, 7.57431e+00, 7.64389e+00, 7.70764e+00, 7.76610e+00,
 7.81978e+00, 7.86916e+00, 7.91465e+00, 7.95663e+00, 7.99542e+00,
 8.03131e+00, 8.06448e+00, 8.09513e+00, 8.12338e+00, 8.14932e+00,
 8.17301e+00, 8.19447e+00, 8.21381e+00, 8.23102e+00, 8.24615e+00,
 8.25923e+00, 8.27027e+00, 8.27923e+00, 8.28611e+00, 8.29085e+00,
 8.29339e+00, 8.29364e+00, 8.29151e+00, 8.28688e+00, 8.27968e+00,
 8.26980e+00, 8.25716e+00, 8.24167e+00, 8.22324e+00, 8.20176e+00,
 8.17712e+00, 8.14917e+00, 8.11776e+00, 8.08273e+00, 8.04389e+00,
 8.00104e+00, 7.95397e+00, 7.90248e+00, 7.84636e+00, 7.78542e+00,
 7.71947e+00, 7.64837e+00, 7.57196e+00, 7.49013e+00, 7.40280e+00,
 7.30991e+00, 7.21147e+00, 7.10753e+00, 6.99824e+00, 6.88386e+00,
 6.76474e+00, 6.64144e+00, 6.51469e+00, 6.38545e+00, 6.25496e+00,
 6.12482e+00, 5.99700e+00, 5.87392e+00, 5.75856e+00, 5.65453e+00}
,
{8.43035e-04, 8.96494e-03, 3.71173e-02, 1.00527e-01, 2.12862e-01,
 3.83033e-01, 6.14389e-01, 9.05387e-01, 1.25101e+00, 1.64329e+00,
 2.07300e+00, 2.52997e+00, 3.00437e+00, 3.48691e+00, 3.96929e+00,
 4.44432e+00, 4.90608e+00, 5.34969e+00, 5.77146e+00, 6.16887e+00,
 6.54017e+00, 6.88470e+00, 7.20255e+00, 7.49462e+00, 7.76218e+00,
 8.00682e+00, 8.23026e+00, 8.43414e+00, 8.62037e+00, 8.79038e+00,
 8.94565e+00, 9.08752e+00, 9.21710e+00, 9.33544e+00, 9.44348e+00,
 9.54214e+00, 9.63229e+00, 9.71475e+00, 9.79027e+00, 9.85957e+00,
 9.92327e+00, 9.98194e+00, 1.00361e+01, 1.00862e+01, 1.01325e+01,
 1.01754e+01, 1.02152e+01, 1.02518e+01, 1.02855e+01, 1.03164e+01,
 1.03444e+01, 1.03698e+01, 1.03926e+01, 1.04127e+01, 1.04304e+01,
 1.04454e+01, 1.04579e+01, 1.04679e+01, 1.04751e+01, 1.04797e+01,
 1.04813e+01, 1.04800e+01, 1.04756e+01, 1.04680e+01, 1.04571e+01,
 1.04429e+01, 1.04251e+01, 1.04038e+01, 1.03787e+01, 1.03497e+01,
 1.03166e+01, 1.02793e+01, 1.02374e+01, 1.01907e+01, 1.01389e+01,
 1.00818e+01, 1.00191e+01, 9.95046e+00, 9.87567e+00, 9.79446e+00,
 9.70658e+00, 9.61181e+00, 9.50992e+00, 9.40072e+00, 9.28404e+00,
 9.15978e+00, 9.02789e+00, 8.88841e+00, 8.74149e+00, 8.58744e+00,
 8.42673e+00, 8.26009e+00, 8.08848e+00, 7.91318e+00, 7.73588e+00,
 7.55867e+00, 7.38420e+00, 7.21572e+00, 7.05723e+00, 6.91358e+00}
,
{1.16346e-03, 1.24290e-02, 5.14542e-02, 1.39063e-01, 2.93357e-01,
 5.25713e-01, 8.39414e-01, 1.23152e+00, 1.69413e+00, 2.21589e+00,
 2.78369e+00, 3.38366e+00, 4.00260e+00, 4.62813e+00, 5.24962e+00,
 5.85775e+00, 6.44525e+00, 7.00603e+00, 7.53599e+00, 8.03207e+00,
 8.49288e+00, 8.91793e+00, 9.30825e+00, 9.66527e+00, 9.99111e+00,
 1.02881e+01, 1.05584e+01, 1.08047e+01, 1.10290e+01, 1.12334e+01,
 1.14197e+01, 1.15895e+01, 1.17443e+01, 1.18853e+01, 1.20137e+01,
 1.21309e+01, 1.22379e+01, 1.23357e+01, 1.24254e+01, 1.25078e+01,
 1.25836e+01, 1.26536e+01, 1.27183e+01, 1.27782e+01, 1.28338e+01,
 1.28852e+01, 1.29327e+01, 1.29765e+01, 1.30166e+01, 1.30533e+01,
 1.30865e+01, 1.31164e+01, 1.31431e+01, 1.31667e+01, 1.31870e+01,
 1.32042e+01, 1.32181e+01, 1.32287e+01, 1.32359e+01, 1.32395e+01,
 1.32394e+01, 1.32354e+01, 1.32275e+01, 1.32156e+01, 1.31996e+01,
 1.31793e+01, 1.31545e+01, 1.31252e+01, 1.30911e+01, 1.30519e+01,
 1.30073e+01, 1.29571e+01, 1.29008e+01, 1.28382e+01, 1.27688e+01,
 1.26923e+01, 1.26084e+01, 1.25166e+01, 1.24166e+01, 1.23081e+01,
 1.21907e+01, 1.20640e+01, 1.19277e+01, 1.17815e+01, 1.16250e+01,
 1.14582e+01, 1.12809e+01, 1.10931e+01, 1.08950e+01, 1.06871e+01,
 1.04699e+01, 1.02445e+01, 1.00120e+01, 9.77419e+00, 9.53331e+00,
 9.29214e+00, 9.05420e+00, 8.82384e+00, 8.60642e+00, 8.40845e+00}
,
{1.60224e-03, 1.71918e-02, 7.11280e-02, 1.91839e-01, 4.03104e-01,
 7.19348e-01, 1.14336e+00, 1.67007e+00, 2.28735e+00, 2.97915e+00,
 3.72708e+00, 4.51239e+00, 5.31738e+00, 6.12585e+00, 6.92407e+00,
 7.70029e+00, 8.44539e+00, 9.15216e+00, 9.81589e+00, 1.04334e+01,
 1.10036e+01, 1.15269e+01, 1.20051e+01, 1.24408e+01, 1.28371e+01,
 1.31971e+01, 1.35241e+01, 1.38214e+01, 1.40915e+01, 1.43371e+01,
 1.45605e+01, 1.47636e+01, 1.49482e+01, 1.51162e+01, 1.52690e+01,
 1.54082e+01, 1.55354e+01, 1.56518e+01, 1.57585e+01, 1.58567e+01,
 1.59473e+01, 1.60310e+01, 1.61086e+01, 1.61805e+01, 1.62471e+01,
 1.63087e+01, 1.63655e+01, 1.64176e+01, 1.64654e+01, 1.65088e+01,
 1.65480e+01, 1.65832e+01, 1.66144e+01, 1.66416e+01, 1.66649e+01,
 1.66840e+01, 1.66990e+01, 1.67097e+01, 1.67159e+01, 1.67174e+01,
 1.67142e+01, 1.67062e+01, 1.66932e+01, 1.66751e+01, 1.66519e+01,
 1.66232e+01, 1.65888e+01, 1.65484e+01, 1.65018e+01, 1.64485e+01,
 1.63880e+01, 1.63200e+01, 1.62440e+01, 1.61595e+01, 1.60661e+01,
 1.59632e+01, 1.58505e+01, 1.57273e+01, 1.55933e+01, 1.54477e+01,
 1.52902e+01, 1.51201e+01, 1.49369e+01, 1.47403e+01, 1.45296e+01,
 1.43048e+01, 1.40657e+01, 1.38122e+01, 1.35447e+01, 1.32637e+01,
 1.29700e+01, 1.26648e+01, 1.23499e+01, 1.20276e+01, 1.17006e+01,
 1.13729e+01, 1.10490e+01, 1.07349e+01, 1.04376e+01, 1.01660e+01}
,
{2.20142e-03, 2.37186e-02, 9.80890e-02, 2.63908e-01, 5.52388e-01,
 9.81473e-01, 1.55296e+00, 2.25832e+00, 3.07957e+00, 3.99408e+00,
 4.97639e+00, 6.00131e+00, 7.04518e+00, 8.08717e+00, 9.10928e+00,
 1.00973e+01, 1.10394e+01, 1.19277e+01, 1.27565e+01, 1.35231e+01,
 1.42268e+01, 1.48697e+01, 1.54546e+01, 1.59856e+01, 1.64671e+01,
 1.69032e+01, 1.72986e+01, 1.76571e+01, 1.79822e+01, 1.82772e+01,
 1.85449e+01, 1.87876e+01, 1.90079e+01, 1.92080e+01, 1.93899e+01,
 1.95556e+01, 1.97070e+01, 1.98458e+01, 1.99732e+01, 2.00906e+01,
 2.01992e+01, 2.02997e+01, 2.03929e+01, 2.04792e+01, 2.05590e+01,
 2.06327e+01, 2.07004e+01, 2.07624e+01, 2.08190e+01, 2.08703e+01,
 2.09165e+01, 2.09577e+01, 2.09938e+01, 2.10249e+01, 2.10509e+01,
 2.10716e+01, 2.10869e+01, 2.10965e+01, 2.11003e+01, 2.10983e+01,
 2.10902e+01, 2.10761e+01, 2.10558e+01, 2.10290e+01, 2.09955e+01,
 2.09549e+01, 2.09070e+01, 2.08512e+01, 2.07871e+01, 2.07140e+01,
 2.06314e+01, 2.05387e+01, 2.04355e+01, 2.03210e+01, 2.01946e+01,
 2.00558e+01, 1.99038e+01, 1.97378e+01, 1.95571e+01, 1.93610e+01,
 1.91486e+01, 1.89191e+01, 1.86718e+01, 1.84061e+01, 1.81216e+01,
 1.78177e+01, 1.74944e+01, 1.71518e+01, 1.67901e+01, 1.64101e+01,
 1.60129e+01, 1.56001e+01, 1.51740e+01, 1.47375e+01, 1.42947e+01,
 1.38506e+01, 1.34114e+01, 1.29850e+01, 1.25809e+01, 1.22107e+01}
,
{3.01740e-03, 3.26399e-02, 1.34919e-01, 3.62089e-01, 7.54935e-01,
 1.33541e+00, 2.10354e+00, 3.04546e+00, 4.13505e+00, 5.34058e+00,
 6.62711e+00, 7.96104e+00, 9.31097e+00, 1.06502e+01, 1.19555e+01,
 1.32093e+01, 1.43975e+01, 1.55107e+01, 1.65430e+01, 1.74921e+01,
 1.83591e+01, 1.91473e+01, 1.98617e+01, 2.05082e+01, 2.10923e+01,
 2.16207e+01, 2.20984e+01, 2.25306e+01, 2.29218e+01, 2.32759e+01,
 2.35963e+01, 2.38864e+01, 2.41492e+01, 2.43877e+01, 2.46045e+01,
 2.48021e+01, 2.49828e+01, 2.51486e+01, 2.53012e+01, 2.54422e+01,
 2.55726e+01, 2.56934e+01, 2.58053e+01, 2.59089e+01, 2.60044e+01,
 2.60923e+01, 2.61730e+01, 2.62466e+01, 2.63135e+01, 2.63740e+01,
 2.64280e+01, 2.64758e+01, 2.65171e+01, 2.65520e+01, 2.65801e+01,
 2.66013e+01, 2.66154e+01, 2.66223e+01, 2.66219e+01, 2.66141e+01,
 2.65987e+01, 2.65757e+01, 2.65446e+01, 2.65053e+01, 2.64572e+01,
 2.63998e+01, 2.63326e+01, 2.62549e+01, 2.61660e+01, 2.60651e+01,
 2.59517e+01, 2.58249e+01, 2.56840e+01, 2.55282e+01, 2.53567e+01,
 2.51684e+01, 2.49623e+01, 2.47374e+01, 2.44926e+01, 2.42268e+01,
 2.39388e+01, 2.36277e+01, 2.32925e+01, 2.29325e+01, 2.25470e+01,
 2.21356e+01, 2.16980e+01, 2.12345e+01, 2.07453e+01, 2.02315e+01,
 1.96947e+01, 1.91369e+01, 1.85614e+01, 1.79722e+01, 1.73747e+01,
 1.67755e+01, 1.61833e+01, 1.56084e+01, 1.50634e+01, 1.45637e+01}
,
{4.12575e-03, 4.48340e-02, 1.85141e-01, 4.95559e-01, 1.02915e+00,
 1.81228e+00, 2.84198e+00, 4.09636e+00, 5.53819e+00, 7.12305e+00,
 8.80362e+00, 1.05351e+01, 1.22763e+01, 1.39928e+01, 1.56558e+01,
 1.72426e+01, 1.87372e+01, 2.01286e+01, 2.14112e+01, 2.25837e+01,
 2.36497e+01, 2.46147e+01, 2.54863e+01, 2.62724e+01, 2.69811e+01,
 2.76206e+01, 2.81975e+01, 2.87184e+01, 2.91888e+01, 2.96136e+01,
 2.99971e+01, 3.03437e+01, 3.06574e+01, 3.09420e+01, 3.12008e+01,
 3.14370e+01, 3.16532e+01, 3.18519e+01, 3.20352e+01, 3.22047e+01,
 3.23616e+01, 3.25069e+01, 3.26413e+01, 3.27653e+01, 3.28794e+01,
 3.29842e+01, 3.30799e+01, 3.31672e+01, 3.32461e+01, 3.33169e+01,
 3.33796e+01, 3.34342e+01, 3.34805e+01, 3.35183e+01, 3.35472e+01,
 3.35672e+01, 3.35782e+01, 3.35800e+01, 3.35726e+01, 3.35559e+01,
 3.35296e+01, 3.34934e+01, 3.34468e+01, 3.33893e+01, 3.33201e+01,
 3.32385e+01, 3.31437e+01, 3.30347e+01, 3.29108e+01, 3.27711e+01,
 3.26147e+01, 3.24405e+01, 3.22475e+01, 3.20346e+01, 3.18003e+01,
 3.15435e+01, 3.12625e+01, 3.09559e+01, 3.06223e+01, 3.02601e+01,
 2.98680e+01, 2.94448e+01, 2.89892e+01, 2.85003e+01, 2.79772e+01,
 2.74195e+01, 2.68269e+01, 2.61996e+01, 2.55383e+01, 2.48444e+01,
 2.41201e+01, 2.33685e+01, 2.25940e+01, 2.18021e+01, 2.10002e+01,
 2.01972e+01, 1.94046e+01, 1.86360e+01, 1.79081e+01, 1.72411e+01}
,
{5.62972e-03, 6.14622e-02, 2.53529e-01, 6.76532e-01, 1.39952e+00,
 2.45328e+00, 3.83020e+00, 5.49647e+00, 7.39953e+00, 9.47779e+00,
 1.16676e+01, 1.39094e+01, 1.61500e+01, 1.83445e+01, 2.04575e+01,
 2.24610e+01, 2.43363e+01, 2.60712e+01, 2.76610e+01, 2.91070e+01,
 3.04154e+01, 3.15954e+01, 3.26577e+01, 3.36128e+01, 3.44725e+01,
 3.52460e+01, 3.59426e+01, 3.65701e+01, 3.71354e+01, 3.76446e+01,
 3.81036e+01, 3.85179e+01, 3.88928e+01, 3.92328e+01, 3.95424e+01,
 3.98252e+01, 4.00847e+01, 4.03236e+01, 4.05442e+01, 4.07483e+01,
 4.09371e+01, 4.11118e+01, 4.12729e+01, 4.14211e+01, 4.15572e+01,
 4.16817e+01, 4.17953e+01, 4.18982e+01, 4.19907e+01, 4.20729e+01,
 4.21447e+01, 4.22058e+01, 4.22560e+01, 4.22951e+01, 4.23228e+01,
 4.23391e+01, 4.23439e+01, 4.23373e+01, 4.23191e+01, 4.22888e+01,
 4.22461e+01, 4.21904e+01, 4.21209e+01, 4.20367e+01, 4.19368e+01,
 4.18202e+01, 4.16858e+01, 4.15326e+01, 4.13595e+01, 4.11653e+01,
 4.09488e+01, 4.07085e+01, 4.04428e+01, 4.01500e+01, 3.98283e+01,
 3.94757e+01, 3.90904e+01, 3.86702e+01, 3.82134e+01, 3.77182e+01,
 3.71827e+01, 3.66055e+01, 3.59851e+01, 3.53202e+01, 3.46099e+01,
 3.38536e+01, 3.30512e+01, 3.22030e+01, 3.13105e+01, 3.03757e+01,
 2.94018e+01, 2.83934e+01, 2.73565e+01, 2.62989e+01, 2.52302e+01,
 2.41628e+01, 2.31114e+01, 2.20942e+01, 2.11330e+01, 2.02537e+01}
,
{7.67348e-03, 8.40761e-02, 3.46397e-01, 9.21552e-01, 1.89876e+00,
 3.31327e+00, 5.14991e+00, 7.35795e+00, 9.86373e+00, 1.25824e+01,
 1.54291e+01, 1.83246e+01, 2.12008e+01, 2.40000e+01, 2.66784e+01,
 2.92020e+01, 3.15493e+01, 3.37079e+01, 3.56742e+01, 3.74544e+01,
 3.90583e+01, 4.04996e+01, 4.17930e+01, 4.29535e+01, 4.39953e+01,
 4.49309e+01, 4.57715e+01, 4.65271e+01, 4.72060e+01, 4.78164e+01,
 4.83659e+01, 4.88615e+01, 4.93100e+01, 4.97171e+01, 5.00881e+01,
 5.04277e+01, 5.07399e+01, 5.10277e+01, 5.12936e+01, 5.15395e+01,
 5.17667e+01, 5.19762e+01, 5.21689e+01, 5.23458e+01, 5.25078e+01,
 5.26557e+01, 5.27898e+01, 5.29105e+01, 5.30179e+01, 5.31120e+01,
 5.31924e+01, 5.32588e+01, 5.33110e+01, 5.33487e+01, 5.33720e+01,
 5.33810e+01, 5.33755e+01, 5.33554e+01, 5.33203e+01, 5.32694e+01,
 5.32022e+01, 5.31174e+01, 5.30140e+01, 5.28907e+01, 5.27462e+01,
 5.25792e+01, 5.23885e+01, 5.21727e+01, 5.19303e+01, 5.16596e+01,
 5.13587e+01, 5.10254e+01, 5.06575e+01, 5.02525e+01, 4.98081e+01,
 4.93216e+01, 4.87905e+01, 4.82125e+01, 4.75852e+01, 4.69064e+01,
 4.61738e+01, 4.53856e+01, 4.45398e+01, 4.36352e+01, 4.26706e+01,
 4.16457e+01, 4.05607e+01, 3.94167e+01, 3.82159e+01, 3.69617e+01,
 3.56589e+01, 3.43140e+01, 3.29354e+01, 3.15335e+01, 3.01215e+01,
 2.87157e+01, 2.73354e+01, 2.60043e+01, 2.47504e+01, 2.36071e+01}
,
{1.04456e-02, 1.14769e-01, 4.72341e-01, 1.25247e+00, 2.57024e+00,
 4.46458e+00, 6.90894e+00, 9.82820e+00, 1.31199e+01, 1.66682e+01,
 2.03602e+01, 2.40918e+01, 2.77753e+01, 3.13383e+01, 3.47251e+01,
 3.78970e+01, 4.08283e+01, 4.35079e+01, 4.59365e+01, 4.81244e+01,
 5.00883e+01, 5.18474e+01, 5.34212e+01, 5.48307e+01, 5.60928e+01,
 5.72240e+01, 5.82380e+01, 5.91471e+01, 5.99623e+01, 6.06940e+01,
 6.13521e+01, 6.19458e+01, 6.24831e+01, 6.29715e+01, 6.34173e+01,
 6.38262e+01, 6.42025e+01, 6.45496e+01, 6.48703e+01, 6.51664e+01,
 6.54392e+01, 6.56901e+01, 6.59204e+01, 6.61313e+01, 6.63237e+01,
 6.64985e+01, 6.66559e+01, 6.67963e+01, 6.69194e+01, 6.70249e+01,
 6.71124e+01, 6.71815e+01, 6.72324e+01, 6.72650e+01, 6.72794e+01,
 6.72757e+01, 6.72534e+01, 6.72121e+01, 6.71509e+01, 6.70688e+01,
 6.69645e+01, 6.68364e+01, 6.66830e+01, 6.65027e+01, 6.62939e+01,
 6.60551e+01, 6.57845e+01, 6.54801e+01, 6.51396e+01, 6.47606e+01,
 6.43402e+01, 6.38754e+01, 6.33632e+01, 6.28003e+01, 6.21835e+01,
 6.15097e+01, 6.07758e+01, 5.99789e+01, 5.91159e+01, 5.81841e+01,
 5.71809e+01, 5.61038e+01, 5.49509e+01, 5.37208e+01, 5.24127e+01,
 5.10269e+01, 4.95643e+01, 4.80274e+01, 4.64198e+01, 4.47467e+01,
 4.30153e+01, 4.12347e+01, 3.94164e+01, 3.75747e+01, 3.57272e+01,
 3.38949e+01, 3.21033e+01, 3.03825e+01, 2.87684e+01, 2.73031e+01}
,
{1.41980e-02, 1.56419e-01, 6.42885e-01, 1.69876e+00, 3.47182e+00,
 6.00329e+00, 9.24890e+00, 1.31001e+01, 1.74146e+01, 2.20357e+01,
 2.68135e+01, 3.16126e+01, 3.63194e+01, 4.08444e+01, 4.51184e+01,
 4.90959e+01, 5.27495e+01, 5.60695e+01, 5.90639e+01, 6.17500e+01,
 6.41523e+01, 6.62971e+01, 6.82122e+01, 6.99228e+01, 7.14515e+01,
 7.28185e+01, 7.40412e+01, 7.51346e+01, 7.61133e+01, 7.69909e+01,
 7.77799e+01, 7.84919e+01, 7.91369e+01, 7.97241e+01, 8.02610e+01,
 8.07543e+01, 8.12086e+01, 8.16276e+01, 8.20142e+01, 8.23702e+01,
 8.26972e+01, 8.29974e+01, 8.32721e+01, 8.35229e+01, 8.37506e+01,
 8.39560e+01, 8.41393e+01, 8.43003e+01, 8.44385e+01, 8.45536e+01,
 8.46451e+01, 8.47132e+01, 8.47580e+01, 8.47797e+01, 8.47784e+01,
 8.47535e+01, 8.47045e+01, 8.46302e+01, 8.45292e+01, 8.43998e+01,
 8.42399e+01, 8.40477e+01, 8.38213e+01, 8.35587e+01, 8.32578e+01,
 8.29166e+01, 8.25321e+01, 8.21016e+01, 8.16217e+01, 8.10886e+01,
 8.04986e+01, 7.98476e+01, 7.91315e+01, 7.83463e+01, 7.74882e+01,
 7.65533e+01, 7.55376e+01, 7.44375e+01, 7.32494e+01, 7.19699e+01,
 7.05959e+01, 6.91251e+01, 6.75556e+01, 6.58865e+01, 6.41180e+01,
 6.22514e+01, 6.02892e+01, 5.82358e+01, 5.60971e+01, 5.38810e+01,
 5.15978e+01, 4.92603e+01, 4.68842e+01, 4.44886e+01, 4.20966e+01,
 3.97356e+01, 3.74379e+01, 3.52417e+01, 3.31920e+01, 3.19265e+01}
,
{1.92671e-02, 2.12827e-01, 8.73274e-01, 2.29953e+00, 4.67983e+00,
 8.05571e+00, 1.23562e+01, 1.74261e+01, 2.30694e+01, 2.90752e+01,
 3.52451e+01, 4.14042e+01, 4.74067e+01, 5.31413e+01, 5.85236e+01,
 6.35012e+01, 6.80458e+01, 7.21530e+01, 7.58396e+01, 7.91337e+01,
 8.20700e+01, 8.46838e+01, 8.70131e+01, 8.90884e+01, 9.09396e+01,
 9.25910e+01, 9.40642e+01, 9.53792e+01, 9.65545e+01, 9.76078e+01,
 9.85549e+01, 9.94101e+01, 1.00186e+02, 1.00894e+02, 1.01542e+02,
 1.02138e+02, 1.02687e+02, 1.03192e+02, 1.03658e+02, 1.04085e+02,
 1.04477e+02, 1.04835e+02, 1.05162e+02, 1.05459e+02, 1.05727e+02,
 1.05967e+02, 1.06177e+02, 1.06359e+02, 1.06510e+02, 1.06631e+02,
 1.06721e+02, 1.06782e+02, 1.06814e+02, 1.06816e+02, 1.06788e+02,
 1.06730e+02, 1.06639e+02, 1.06514e+02, 1.06352e+02, 1.06151e+02,
 1.05909e+02, 1.05623e+02, 1.05291e+02, 1.04910e+02, 1.04478e+02,
 1.03990e+02, 1.03443e+02, 1.02832e+02, 1.02153e+02, 1.01401e+02,
 1.00570e+02, 9.96551e+01, 9.86519e+01, 9.75552e+01, 9.63602e+01,
 9.50618e+01, 9.36555e+01, 9.21367e+01, 9.05013e+01, 8.87456e+01,
 8.68666e+01, 8.48625e+01, 8.27322e+01, 8.04762e+01, 7.80962e+01,
 7.55955e+01, 7.29793e+01, 7.02547e+01, 6.74308e+01, 6.45195e+01,
 6.15351e+01, 5.84955e+01, 5.54217e+01, 5.23390e+01, 4.92769e+01,
 4.62704e+01, 4.33601e+01, 4.15199e+01, 3.88738e+01, 3.64947e+01}
,
{2.61016e-02, 2.89049e-01, 1.18415e+00, 3.10672e+00, 6.29593e+00,
 1.07889e+01, 1.64752e+01, 2.31363e+01, 3.05025e+01, 3.82925e+01,
 4.62445e+01, 5.41332e+01, 6.17737e+01, 6.90257e+01, 7.57912e+01,
 8.20078e+01, 8.76503e+01, 9.27240e+01, 9.72575e+01, 1.01293e+02,
 1.04879e+02, 1.08065e+02, 1.10896e+02, 1.13414e+02, 1.15654e+02,
 1.17648e+02, 1.19423e+02, 1.21004e+02, 1.22416e+02, 1.23682e+02,
 1.24820e+02, 1.25850e+02, 1.26785e+02, 1.27639e+02, 1.28423e+02,
 1.29144e+02, 1.29807e+02, 1.30416e+02, 1.30975e+02, 1.31488e+02,
 1.31956e+02, 1.32384e+02, 1.32772e+02, 1.33122e+02, 1.33435e+02,
 1.33711e+02, 1.33949e+02, 1.34147e+02, 1.34307e+02, 1.34428e+02,
 1.34511e+02, 1.34556e+02, 1.34563e+02, 1.34532e+02, 1.34461e+02,
 1.34349e+02, 1.34193e+02, 1.33990e+02, 1.33737e+02, 1.33430e+02,
 1.33068e+02, 1.32646e+02, 1.32162e+02, 1.31612e+02, 1.30990e+02,
 1.30292e+02, 1.29512e+02, 1.28644e+02, 1.27681e+02, 1.26616e+02,
 1.25444e+02, 1.24158e+02, 1.22752e+02, 1.21220e+02, 1.19556e+02,
 1.17753e+02, 1.15807e+02, 1.13712e+02, 1.11465e+02, 1.09061e+02,
 1.06499e+02, 1.03779e+02, 1.00901e+02, 9.78677e+01, 9.46841e+01,
 9.13566e+01, 8.78939e+01, 8.43072e+01, 8.06105e+01, 7.68206e+01,
 7.29577e+01, 6.90455e+01, 6.51119e+01, 6.11892e+01, 5.73148e+01,
 5.49499e+01, 5.12070e+01, 4.76600e+01, 4.43803e+01, 4.14513e+01}
,
{3.52987e-02, 3.91871e-01, 1.60304e+00, 4.18995e+00, 8.45384e+00,
 1.44222e+01, 2.19267e+01, 3.06613e+01, 4.02580e+01, 5.03430e+01,
 6.05724e+01, 7.06569e+01, 8.03638e+01, 8.95184e+01, 9.80052e+01,
 1.05756e+02, 1.12750e+02, 1.19009e+02, 1.24579e+02, 1.29520e+02,
 1.33897e+02, 1.37777e+02, 1.41218e+02, 1.44271e+02, 1.46982e+02,
 1.49388e+02, 1.51526e+02, 1.53428e+02, 1.55126e+02, 1.56649e+02,
 1.58019e+02, 1.59260e+02, 1.60390e+02, 1.61424e+02, 1.62372e+02,
 1.63244e+02, 1.64044e+02, 1.64778e+02, 1.65449e+02, 1.66063e+02,
 1.66622e+02, 1.67130e+02, 1.67589e+02, 1.67999e+02, 1.68360e+02,
 1.68672e+02, 1.68934e+02, 1.69145e+02, 1.69306e+02, 1.69418e+02,
 1.69482e+02, 1.69496e+02, 1.69462e+02, 1.69377e+02, 1.69238e+02,
 1.69043e+02, 1.68787e+02, 1.68467e+02, 1.68078e+02, 1.67617e+02,
 1.67080e+02, 1.66463e+02, 1.65760e+02, 1.64966e+02, 1.64072e+02,
 1.63073e+02, 1.61959e+02, 1.60722e+02, 1.59354e+02, 1.57848e+02,
 1.56195e+02, 1.54388e+02, 1.52419e+02, 1.50280e+02, 1.47965e+02,
 1.45466e+02, 1.42777e+02, 1.39895e+02, 1.36816e+02, 1.33538e+02,
 1.30061e+02, 1.26388e+02, 1.22523e+02, 1.18472e+02, 1.14245e+02,
 1.09851e+02, 1.05306e+02, 1.00627e+02, 9.58328e+01, 9.09479e+01,
 8.59993e+01, 8.10180e+01, 7.60396e+01, 7.31967e+01, 6.82315e+01,
 6.33973e+01, 5.87579e+01, 5.43874e+01, 5.03715e+01, 4.68100e+01}
,
{4.76584e-02, 5.30546e-01, 2.16627e+00, 5.64073e+00, 1.13311e+01,
 1.92447e+01, 2.91300e+01, 4.05624e+01, 5.30421e+01, 6.60742e+01,
 7.92104e+01, 9.20779e+01, 1.04387e+02, 1.15923e+02, 1.26550e+02,
 1.36197e+02, 1.44855e+02, 1.52566e+02, 1.59402e+02, 1.65447e+02,
 1.70789e+02, 1.75514e+02, 1.79694e+02, 1.83395e+02, 1.86673e+02,
 1.89577e+02, 1.92152e+02, 1.94442e+02, 1.96486e+02, 1.98320e+02,
 1.99973e+02, 2.01473e+02, 2.02840e+02, 2.04092e+02, 2.05240e+02,
 2.06293e+02, 2.07258e+02, 2.08140e+02, 2.08945e+02, 2.09679e+02,
 2.10345e+02, 2.10946e+02, 2.11484e+02, 2.11959e+02, 2.12370e+02,
 2.12716e+02, 2.12995e+02, 2.13210e+02, 2.13362e+02, 2.13451e+02,
 2.13477e+02, 2.13440e+02, 2.13337e+02, 2.13166e+02, 2.12922e+02,
 2.12599e+02, 2.12193e+02, 2.11698e+02, 2.11111e+02, 2.10427e+02,
 2.09638e+02, 2.08739e+02, 2.07721e+02, 2.06574e+02, 2.05290e+02,
 2.03858e+02, 2.02266e+02, 2.00506e+02, 1.98566e+02, 1.96437e+02,
 1.94109e+02, 1.91573e+02, 1.88820e+02, 1.85839e+02, 1.82625e+02,
 1.79169e+02, 1.75468e+02, 1.71518e+02, 1.67319e+02, 1.62873e+02,
 1.58183e+02, 1.53257e+02, 1.48103e+02, 1.42734e+02, 1.37166e+02,
 1.31415e+02, 1.25504e+02, 1.19457e+02, 1.13303e+02, 1.07072e+02,
 1.00799e+02, 9.75150e+01, 9.11535e+01, 8.48649e+01, 7.87073e+01,
 7.27472e+01, 6.70607e+01, 6.17355e+01, 5.68732e+01, 5.25918e+01}
,
{6.42865e-02, 7.17264e-01, 2.92274e+00, 7.58129e+00, 1.51610e+01,
 2.56353e+01, 3.86341e+01, 5.35709e+01, 6.97713e+01, 8.65817e+01,
 1.03421e+02, 1.19812e+02, 1.35393e+02, 1.49905e+02, 1.63188e+02,
 1.75176e+02, 1.85880e+02, 1.95372e+02, 2.03756e+02, 2.11147e+02,
 2.17665e+02, 2.23415e+02, 2.28493e+02, 2.32978e+02, 2.36941e+02,
 2.40444e+02, 2.43547e+02, 2.46306e+02, 2.48770e+02, 2.50982e+02,
 2.52980e+02, 2.54796e+02, 2.56453e+02, 2.57970e+02, 2.59359e+02,
 2.60631e+02, 2.61792e+02, 2.62851e+02, 2.63815e+02, 2.64691e+02,
 2.65481e+02, 2.66188e+02, 2.66814e+02, 2.67356e+02, 2.67813e+02,
 2.68185e+02, 2.68473e+02, 2.68678e+02, 2.68803e+02, 2.68846e+02,
 2.68808e+02, 2.68686e+02, 2.68474e+02, 2.68168e+02, 2.67761e+02,
 2.67246e+02, 2.66618e+02, 2.65870e+02, 2.64995e+02, 2.63987e+02,
 2.62835e+02, 2.61529e+02, 2.60056e+02, 2.58404e+02, 2.56560e+02,
 2.54509e+02, 2.52239e+02, 2.49737e+02, 2.46992e+02, 2.43989e+02,
 2.40718e+02, 2.37168e+02, 2.33326e+02, 2.29185e+02, 2.24738e+02,
 2.19979e+02, 2.14907e+02, 2.09524e+02, 2.03833e+02, 1.97841e+02,
 1.91559e+02, 1.85002e+02, 1.78185e+02, 1.71130e+02, 1.63861e+02,
 1.56405e+02, 1.48792e+02, 1.41057e+02, 1.33237e+02, 1.29528e+02,
 1.21531e+02, 1.13555e+02, 1.05656e+02, 9.78937e+01, 9.03379e+01,
 8.30666e+01, 7.61688e+01, 6.97471e+01, 6.39200e+01, 5.88255e+01}
,
{8.66334e-02, 9.68200e-01, 3.93735e+00, 1.01730e+01, 2.02517e+01,
 3.40918e+01, 5.11554e+01, 7.06374e+01, 9.16328e+01, 1.13280e+02,
 1.34831e+02, 1.55676e+02, 1.75365e+02, 1.93589e+02, 2.10168e+02,
 2.25041e+02, 2.38260e+02, 2.49933e+02, 2.60209e+02, 2.69243e+02,
 2.77193e+02, 2.84191e+02, 2.90356e+02, 2.95789e+02, 3.00578e+02,
 3.04805e+02, 3.08548e+02, 3.11875e+02, 3.14848e+02, 3.17522e+02,
 3.19941e+02, 3.22142e+02, 3.24152e+02, 3.25990e+02, 3.27670e+02,
 3.29203e+02, 3.30600e+02, 3.31870e+02, 3.33023e+02, 3.34063e+02,
 3.34996e+02, 3.35821e+02, 3.36539e+02, 3.37146e+02, 3.37642e+02,
 3.38028e+02, 3.38308e+02, 3.38482e+02, 3.38552e+02, 3.38517e+02,
 3.38372e+02, 3.38112e+02, 3.37731e+02, 3.37218e+02, 3.36566e+02,
 3.35768e+02, 3.34814e+02, 3.33698e+02, 3.32408e+02, 3.30932e+02,
 3.29256e+02, 3.27363e+02, 3.25238e+02, 3.22861e+02, 3.20217e+02,
 3.17288e+02, 3.14060e+02, 3.10515e+02, 3.06639e+02, 3.02416e+02,
 2.97833e+02, 2.92877e+02, 2.87538e+02, 2.81808e+02, 2.75684e+02,
 2.69166e+02, 2.62259e+02, 2.54969e+02, 2.47309e+02, 2.39296e+02,
 2.30949e+02, 2.22294e+02, 2.13357e+02, 2.04172e+02, 1.94773e+02,
 1.85200e+02, 1.75494e+02, 1.65701e+02, 1.61393e+02, 1.51411e+02,
 1.41459e+02, 1.31596e+02, 1.21886e+02, 1.12401e+02, 1.03220e+02,
 9.44352e+01, 8.61476e+01, 7.84757e+01, 7.15563e+01, 6.55487e+01}
,
{1.16621e-01, 1.30491e+00, 5.29569e+00, 1.36286e+01, 2.70090e+01,
 4.52659e+01, 6.76292e+01, 9.29975e+01, 1.20163e+02, 1.47995e+02,
 1.75529e+02, 2.01997e+02, 2.26837e+02, 2.49686e+02, 2.70345e+02,
 2.88779e+02, 3.05083e+02, 3.19429e+02, 3.32016e+02, 3.43058e+02,
 3.52749e+02, 3.61264e+02, 3.68747e+02, 3.75326e+02, 3.81113e+02,
 3.86216e+02, 3.90732e+02, 3.94749e+02, 3.98343e+02, 4.01580e+02,
 4.04514e+02, 4.07185e+02, 4.09624e+02, 4.11850e+02, 4.13879e+02,
 4.15726e+02, 4.17403e+02, 4.18925e+02, 4.20298e+02, 4.21530e+02,
 4.22623e+02, 4.23574e+02, 4.24383e+02, 4.25047e+02, 4.25568e+02,
 4.25950e+02, 4.26195e+02, 4.26305e+02, 4.26278e+02, 4.26110e+02,
 4.25795e+02, 4.25321e+02, 4.24678e+02, 4.23855e+02, 4.22842e+02,
 4.21629e+02, 4.20205e+02, 4.18556e+02, 4.16666e+02, 4.14516e+02,
 4.12084e+02, 4.09349e+02, 4.06288e+02, 4.02879e+02, 3.99101e+02,
 3.94934e+02, 3.90357e+02, 3.85351e+02, 3.79897e+02, 3.73979e+02,
 3.67581e+02, 3.60692e+02, 3.53307e+02, 3.45421e+02, 3.37040e+02,
 3.28171e+02, 3.18829e+02, 3.09032e+02, 2.98805e+02, 2.88177e+02,
 2.77182e+02, 2.65860e+02, 2.54253e+02, 2.42409e+02, 2.30377e+02,
 2.18209e+02, 2.13398e+02, 2.00980e+02, 1.88550e+02, 1.76171e+02,
 1.63907e+02, 1.51827e+02, 1.40004e+02, 1.28521e+02, 1.17469e+02,
 1.06948e+02, 9.70762e+01, 8.79868e+01, 7.98363e+01, 7.28074e+01}
,
{1.56801e-01, 1.75660e+00, 7.11212e+00, 1.82311e+01, 3.59652e+01,
 6.00106e+01, 8.92736e+01, 1.22255e+02, 1.57350e+02, 1.93077e+02,
 2.28201e+02, 2.61757e+02, 2.93048e+02, 3.21651e+02, 3.47358e+02,
 3.70178e+02, 3.90273e+02, 4.07889e+02, 4.23300e+02, 4.36792e+02,
 4.48605e+02, 4.58961e+02, 4.68042e+02, 4.76006e+02, 4.83001e+02,
 4.89164e+02, 4.94619e+02, 4.99475e+02, 5.03827e+02, 5.07753e+02,
 5.11315e+02, 5.14559e+02, 5.17516e+02, 5.20209e+02, 5.22657e+02,
 5.24879e+02, 5.26892e+02, 5.28710e+02, 5.30341e+02, 5.31790e+02,
 5.33056e+02, 5.34136e+02, 5.35029e+02, 5.35734e+02, 5.36258e+02,
 5.36603e+02, 5.36773e+02, 5.36767e+02, 5.36578e+02, 5.36198e+02,
 5.35614e+02, 5.34811e+02, 5.33776e+02, 5.32495e+02, 5.30956e+02,
 5.29143e+02, 5.27039e+02, 5.24621e+02, 5.21866e+02, 5.18745e+02,
 5.15229e+02, 5.11289e+02, 5.06897e+02, 5.02026e+02, 4.96649e+02,
 4.90741e+02, 4.84277e+02, 4.77235e+02, 4.69592e+02, 4.61332e+02,
 4.52444e+02, 4.42921e+02, 4.32765e+02, 4.21984e+02, 4.10593e+02,
 3.98615e+02, 3.86078e+02, 3.73019e+02, 3.59479e+02, 3.45508e+02,
 3.31158e+02, 3.16488e+02, 3.01560e+02, 2.86438e+02, 2.81032e+02,
 2.65607e+02, 2.50132e+02, 2.34676e+02, 2.19308e+02, 2.04101e+02,
 1.89127e+02, 1.74465e+02, 1.60197e+02, 1.46414e+02, 1.33216e+02,
 1.20717e+02, 1.09048e+02, 9.83576e+01, 8.88243e+01, 8.06557e+01}
,
{2.10560e-01, 2.36173e+00, 9.53832e+00, 2.43513e+01, 4.78222e+01,
 7.94417e+01, 1.17676e+02, 1.60489e+02, 2.05759e+02, 2.51558e+02,
 2.96296e+02, 3.38771e+02, 3.78135e+02, 4.13886e+02, 4.45833e+02,
 4.74052e+02, 4.98799e+02, 5.20421e+02, 5.39287e+02, 5.55763e+02,
 5.70161e+02, 5.82753e+02, 5.93767e+02, 6.03408e+02, 6.11865e+02,
 6.19314e+02, 6.25911e+02, 6.31790e+02, 6.37067e+02, 6.41836e+02,
 6.46164e+02, 6.50104e+02, 6.53688e+02, 6.56942e+02, 6.59893e+02,
 6.62564e+02, 6.64976e+02, 6.67140e+02, 6.69066e+02, 6.70754e+02,
 6.72202e+02, 6.73405e+02, 6.74364e+02, 6.75085e+02, 6.75574e+02,
 6.75834e+02, 6.75866e+02, 6.75662e+02, 6.75212e+02, 6.74498e+02,
 6.73503e+02, 6.72207e+02, 6.70593e+02, 6.68645e+02, 6.66343e+02,
 6.63664e+02, 6.60579e+02, 6.57055e+02, 6.53056e+02, 6.48543e+02,
 6.43479e+02, 6.37827e+02, 6.31552e+02, 6.24622e+02, 6.17002e+02,
 6.08661e+02, 5.99571e+02, 5.89706e+02, 5.79046e+02, 5.67579e+02,
 5.55302e+02, 5.42222e+02, 5.28352e+02, 5.13720e+02, 4.98357e+02,
 4.82309e+02, 4.65626e+02, 4.48370e+02, 4.30607e+02, 4.12412e+02,
 3.93862e+02, 3.75039e+02, 3.56027e+02, 3.49699e+02, 3.30427e+02,
 3.11145e+02, 2.91935e+02, 2.72877e+02, 2.54049e+02, 2.35531e+02,
 2.17406e+02, 1.99758e+02, 1.82676e+02, 1.66258e+02, 1.50616e+02,
 1.35871e+02, 1.22169e+02, 1.09677e+02, 9.85937e+01, 8.91547e+01}
,
{2.82380e-01, 3.17112e+00, 1.27737e+01, 3.24798e+01, 6.34971e+01,
 1.05015e+02, 1.54898e+02, 2.10395e+02, 2.68706e+02, 3.27328e+02,
 3.84235e+02, 4.37920e+02, 4.87365e+02, 5.31997e+02, 5.71650e+02,
 6.06512e+02, 6.36966e+02, 6.63489e+02, 6.86582e+02, 7.06698e+02,
 7.24241e+02, 7.39548e+02, 7.52904e+02, 7.64575e+02, 7.74806e+02,
 7.83817e+02, 7.91803e+02, 7.98932e+02, 8.05342e+02, 8.11139e+02,
 8.16403e+02, 8.21185e+02, 8.25524e+02, 8.29453e+02, 8.33006e+02,
 8.36213e+02, 8.39092e+02, 8.41658e+02, 8.43916e+02, 8.45860e+02,
 8.47487e+02, 8.48795e+02, 8.49791e+02, 8.50485e+02, 8.50881e+02,
 8.50980e+02, 8.50775e+02, 8.50252e+02, 8.49390e+02, 8.48165e+02,
 8.46552e+02, 8.44528e+02, 8.42072e+02, 8.39159e+02, 8.35757e+02,
 8.31830e+02, 8.27334e+02, 8.22221e+02, 8.16440e+02, 8.09943e+02,
 8.02683e+02, 7.94613e+02, 7.85692e+02, 7.75875e+02, 7.65124e+02,
 7.53402e+02, 7.40677e+02, 7.26929e+02, 7.12144e+02, 6.96323e+02,
 6.79480e+02, 6.61640e+02, 6.42843e+02, 6.23138e+02, 6.02590e+02,
 5.81272e+02, 5.59269e+02, 5.36674e+02, 5.13589e+02, 4.90118e+02,
 4.66370e+02, 4.59059e+02, 4.35011e+02, 4.10920e+02, 3.86885e+02,
 3.63005e+02, 3.39371e+02, 3.16074e+02, 2.93201e+02, 2.70837e+02,
 2.49069e+02, 2.27985e+02, 2.07682e+02, 1.88262e+02, 1.69842e+02,
 1.52557e+02, 1.36562e+02, 1.22045e+02, 1.09227e+02, 9.83722e+01}
,
{3.78197e-01, 4.25214e+00, 1.70834e+01, 4.32630e+01, 8.41961e+01,
 1.38635e+02, 2.03623e+02, 2.75460e+02, 3.50463e+02, 4.25398e+02,
 4.97687e+02, 5.65446e+02, 6.27464e+02, 6.83107e+02, 7.32278e+02,
 7.75310e+02, 8.12767e+02, 8.45289e+02, 8.73545e+02, 8.98104e+02,
 9.19472e+02, 9.38072e+02, 9.54268e+02, 9.68401e+02, 9.80784e+02,
 9.91696e+02, 1.00138e+03, 1.01003e+03, 1.01783e+03, 1.02489e+03,
 1.03128e+03, 1.03708e+03, 1.04233e+03, 1.04707e+03, 1.05135e+03,
 1.05519e+03, 1.05861e+03, 1.06164e+03, 1.06425e+03, 1.06646e+03,
 1.06825e+03, 1.06963e+03, 1.07062e+03, 1.07121e+03, 1.07143e+03,
 1.07124e+03, 1.07065e+03, 1.06963e+03, 1.06813e+03, 1.06614e+03,
 1.06362e+03, 1.06053e+03, 1.05686e+03, 1.05256e+03, 1.04757e+03,
 1.04185e+03, 1.03533e+03, 1.02795e+03, 1.01963e+03, 1.01032e+03,
 9.99965e+02, 9.88500e+02, 9.75874e+02, 9.62036e+02, 9.46938e+02,
 9.30544e+02, 9.12829e+02, 8.93780e+02, 8.73406e+02, 8.51729e+02,
 8.28790e+02, 8.04646e+02, 7.79373e+02, 7.53060e+02, 7.25812e+02,
 6.97746e+02, 6.68992e+02, 6.39685e+02, 6.09967e+02, 5.79981e+02,
 5.71241e+02, 5.41062e+02, 5.10918e+02, 4.80934e+02, 4.51227e+02,
 4.21905e+02, 3.93072e+02, 3.64824e+02, 3.37250e+02, 3.10440e+02,
 2.84483e+02, 2.59466e+02, 2.35488e+02, 2.12656e+02, 1.91091e+02,
 1.70937e+02, 1.52363e+02, 1.35573e+02, 1.20813e+02, 1.08381e+02}
,
{5.06076e-01, 5.69545e+00, 2.28189e+01, 5.75479e+01, 1.11495e+02,
 1.82778e+02, 2.67331e+02, 3.60197e+02, 4.56539e+02, 5.52196e+02,
 6.43899e+02, 7.29313e+02, 8.07001e+02, 8.76285e+02, 9.37198e+02,
 9.90278e+02, 1.03632e+03, 1.07620e+03, 1.11076e+03, 1.14073e+03,
 1.16676e+03, 1.18935e+03, 1.20899e+03, 1.22611e+03, 1.24111e+03,
 1.25434e+03, 1.26609e+03, 1.27662e+03, 1.28611e+03, 1.29470e+03,
 1.30247e+03, 1.30950e+03, 1.31584e+03, 1.32156e+03, 1.32669e+03,
 1.33128e+03, 1.33533e+03, 1.33887e+03, 1.34186e+03, 1.34432e+03,
 1.34624e+03, 1.34764e+03, 1.34853e+03, 1.34893e+03, 1.34881e+03,
 1.34817e+03, 1.34697e+03, 1.34517e+03, 1.34272e+03, 1.33960e+03,
 1.33575e+03, 1.33114e+03, 1.32571e+03, 1.31941e+03, 1.31216e+03,
 1.30387e+03, 1.29446e+03, 1.28384e+03, 1.27194e+03, 1.25867e+03,
 1.24397e+03, 1.22776e+03, 1.20998e+03, 1.19056e+03, 1.16947e+03,
 1.14667e+03, 1.12216e+03, 1.09594e+03, 1.06806e+03, 1.03858e+03,
 1.00758e+03, 9.75173e+02, 9.41478e+02, 9.06644e+02, 8.70835e+02,
 8.34224e+02, 7.96997e+02, 7.59341e+02, 7.48811e+02, 7.10907e+02,
 6.72992e+02, 6.35232e+02, 5.97782e+02, 5.60784e+02, 5.24368e+02,
 4.88654e+02, 4.53748e+02, 4.19747e+02, 3.86742e+02, 3.54818e+02,
 3.24060e+02, 2.94555e+02, 2.66399e+02, 2.39698e+02, 2.14579e+02,
 1.91192e+02, 1.69718e+02, 1.50379e+02, 1.33448e+02, 1.19259e+02}
,
{6.76705e-01, 7.62049e+00, 3.04412e+01, 7.64530e+01, 1.47457e+02,
 2.40675e+02, 3.50537e+02, 4.70432e+02, 5.94029e+02, 7.15978e+02,
 8.32161e+02, 9.39697e+02, 1.03689e+03, 1.12306e+03, 1.19845e+03,
 1.26389e+03, 1.32046e+03, 1.36934e+03, 1.41160e+03, 1.44818e+03,
 1.47986e+03, 1.50731e+03, 1.53112e+03, 1.55187e+03, 1.57006e+03,
 1.58612e+03, 1.60041e+03, 1.61323e+03, 1.62479e+03, 1.63524e+03,
 1.64468e+03, 1.65319e+03, 1.66085e+03, 1.66772e+03, 1.67387e+03,
 1.67933e+03, 1.68410e+03, 1.68818e+03, 1.69156e+03, 1.69423e+03,
 1.69623e+03, 1.69755e+03, 1.69823e+03, 1.69825e+03, 1.69760e+03,
 1.69622e+03, 1.69408e+03, 1.69111e+03, 1.68726e+03, 1.68248e+03,
 1.67673e+03, 1.66992e+03, 1.66198e+03, 1.65281e+03, 1.64231e+03,
 1.63036e+03, 1.61685e+03, 1.60167e+03, 1.58472e+03, 1.56591e+03,
 1.54515e+03, 1.52234e+03, 1.49742e+03, 1.47033e+03, 1.44103e+03,
 1.40952e+03, 1.37582e+03, 1.34000e+03, 1.30214e+03, 1.26236e+03,
 1.22081e+03, 1.17766e+03, 1.13313e+03, 1.08743e+03, 1.04079e+03,
 9.93476e+02, 9.45727e+02, 9.32778e+02, 8.84967e+02, 8.37273e+02,
 7.89908e+02, 7.43067e+02, 6.96923e+02, 6.51636e+02, 6.07341e+02,
 5.64160e+02, 5.22198e+02, 4.81547e+02, 4.42289e+02, 4.04502e+02,
 3.68262e+02, 3.33649e+02, 3.00752e+02, 2.69676e+02, 2.40546e+02,
 2.13519e+02, 1.88788e+02, 1.66594e+02, 1.47236e+02, 1.31088e+02}
,
{9.04117e-01, 1.01846e+01, 4.05592e+01, 1.01443e+02, 1.94781e+02,
 3.16528e+02, 4.59095e+02, 6.13692e+02, 7.72059e+02, 9.27334e+02,
 1.07434e+03, 1.20956e+03, 1.33102e+03, 1.43808e+03, 1.53132e+03,
 1.61193e+03, 1.68141e+03, 1.74132e+03, 1.79300e+03, 1.83762e+03,
 1.87618e+03, 1.90951e+03, 1.93840e+03, 1.96357e+03, 1.98565e+03,
 2.00517e+03, 2.02257e+03, 2.03819e+03, 2.05228e+03, 2.06499e+03,
 2.07643e+03, 2.08673e+03, 2.09597e+03, 2.10424e+03, 2.11158e+03,
 2.11803e+03, 2.12359e+03, 2.12824e+03, 2.13197e+03, 2.13481e+03,
 2.13677e+03, 2.13789e+03, 2.13815e+03, 2.13754e+03, 2.13602e+03,
 2.13351e+03, 2.12995e+03, 2.12525e+03, 2.11936e+03, 2.11220e+03,
 2.10370e+03, 2.09375e+03, 2.08221e+03, 2.06895e+03, 2.05383e+03,
 2.03668e+03, 2.01738e+03, 1.99579e+03, 1.97179e+03, 1.94526e+03,
 1.91607e+03, 1.88415e+03, 1.84941e+03, 1.81182e+03, 1.77138e+03,
 1.72812e+03, 1.68213e+03, 1.63355e+03, 1.58253e+03, 1.52928e+03,
 1.47406e+03, 1.41712e+03, 1.35878e+03, 1.29936e+03, 1.23918e+03,
 1.17859e+03, 1.16252e+03, 1.10214e+03, 1.04206e+03, 9.82566e+02,
 9.23887e+02, 8.66245e+02, 8.09830e+02, 7.54803e+02, 7.01303e+02,
 6.49443e+02, 5.99318e+02, 5.51005e+02, 5.04573e+02, 4.60084e+02,
 4.17599e+02, 3.77184e+02, 3.38919e+02, 3.02900e+02, 2.69252e+02,
 2.38133e+02, 2.09747e+02, 1.84355e+02, 1.62286e+02, 1.43955e+02}
,
{1.20686e+00, 1.35952e+01, 5.39815e+01, 1.34437e+02, 2.56985e+02,
 4.15801e+02, 6.00581e+02, 7.99686e+02, 1.00237e+03, 1.19984e+03,
 1.38562e+03, 1.55544e+03, 1.70704e+03, 1.83995e+03, 1.95517e+03,
 2.05445e+03, 2.13977e+03, 2.21316e+03, 2.27633e+03, 2.33077e+03,
 2.37768e+03, 2.41817e+03, 2.45323e+03, 2.48379e+03, 2.51061e+03,
 2.53436e+03, 2.55557e+03, 2.57462e+03, 2.59178e+03, 2.60723e+03,
 2.62111e+03, 2.63355e+03, 2.64469e+03, 2.65459e+03, 2.66333e+03,
 2.67091e+03, 2.67731e+03, 2.68252e+03, 2.68655e+03, 2.68944e+03,
 2.69121e+03, 2.69189e+03, 2.69144e+03, 2.68982e+03, 2.68694e+03,
 2.68272e+03, 2.67704e+03, 2.66983e+03, 2.66099e+03, 2.65043e+03,
 2.63800e+03, 2.62355e+03, 2.60688e+03, 2.58781e+03, 2.56613e+03,
 2.54167e+03, 2.51425e+03, 2.48371e+03, 2.44988e+03, 2.41263e+03,
 2.37183e+03, 2.32738e+03, 2.27923e+03, 2.22740e+03, 2.17195e+03,
 2.11299e+03, 2.05070e+03, 1.98532e+03, 1.91712e+03, 1.84644e+03,
 1.77366e+03, 1.69918e+03, 1.62344e+03, 1.54687e+03, 1.52631e+03,
 1.44978e+03, 1.37345e+03, 1.29768e+03, 1.22282e+03, 1.14920e+03,
 1.07706e+03, 1.00666e+03, 9.38170e+02, 8.71761e+02, 8.07554e+02,
 7.45645e+02, 6.86107e+02, 6.28996e+02, 5.74355e+02, 5.22222e+02,
 4.72636e+02, 4.25644e+02, 3.81308e+02, 3.39714e+02, 3.00979e+02,
 2.65263e+02, 2.32780e+02, 2.03810e+02, 1.78712e+02, 1.57948e+02}
,
{1.60943e+00, 1.81297e+01, 7.17655e+01, 1.77960e+02, 3.38668e+02,
 5.45594e+02, 7.84803e+02, 1.04093e+03, 1.30002e+03, 1.55088e+03,
 1.78539e+03, 1.99841e+03, 2.18743e+03, 2.35229e+03, 2.49459e+03,
 2.61678e+03, 2.72154e+03, 2.81143e+03, 2.88865e+03, 2.95502e+03,
 3.01210e+03, 3.06128e+03, 3.10387e+03, 3.14099e+03, 3.17362e+03,
 3.20256e+03, 3.22843e+03, 3.25168e+03, 3.27258e+03, 3.29134e+03,
 3.30815e+03, 3.32318e+03, 3.33657e+03, 3.34841e+03, 3.35874e+03,
 3.36756e+03, 3.37483e+03, 3.38055e+03, 3.38477e+03, 3.38754e+03,
 3.38887e+03, 3.38875e+03, 3.38714e+03, 3.38393e+03, 3.37899e+03,
 3.37220e+03, 3.36345e+03, 3.35262e+03, 3.33957e+03, 3.32413e+03,
 3.30610e+03, 3.28523e+03, 3.26128e+03, 3.23397e+03, 3.20308e+03,
 3.16837e+03, 3.12962e+03, 3.08662e+03, 3.03919e+03, 2.98716e+03,
 2.93040e+03, 2.86887e+03, 2.80256e+03, 2.73158e+03, 2.65608e+03,
 2.57631e+03, 2.49259e+03, 2.40529e+03, 2.31488e+03, 2.22186e+03,
 2.12677e+03, 2.03019e+03, 1.93271e+03, 1.90655e+03, 1.80948e+03,
 1.71286e+03, 1.61716e+03, 1.52285e+03, 1.43031e+03, 1.33988e+03,
 1.25184e+03, 1.16643e+03, 1.08382e+03, 1.00416e+03, 9.27548e+02,
 8.54042e+02, 7.83683e+02, 7.16492e+02, 6.52476e+02, 5.91641e+02,
 5.33994e+02, 4.79555e+02, 4.28362e+02, 3.80485e+02, 3.36031e+02,
 2.95158e+02, 2.58086e+02, 2.25114e+02, 1.96636e+02, 1.73161e+02}
,
{2.14413e+00, 2.41549e+01, 9.53008e+01, 2.35308e+02, 4.45820e+02,
 7.15121e+02, 1.02444e+03, 1.35354e+03, 1.68437e+03, 2.00269e+03,
 2.29838e+03, 2.56531e+03, 2.80074e+03, 3.00507e+03, 3.18072e+03,
 3.33105e+03, 3.45965e+03, 3.56974e+03, 3.66410e+03, 3.74502e+03,
 3.81446e+03, 3.87423e+03, 3.92598e+03, 3.97112e+03, 4.01086e+03,
 4.04618e+03, 4.07776e+03, 4.10611e+03, 4.13155e+03, 4.15431e+03,
 4.17466e+03, 4.19279e+03, 4.20885e+03, 4.22295e+03, 4.23508e+03,
 4.24521e+03, 4.25333e+03, 4.25947e+03, 4.26370e+03, 4.26605e+03,
 4.26654e+03, 4.26511e+03, 4.26165e+03, 4.25600e+03, 4.24799e+03,
 4.23747e+03, 4.22428e+03, 4.20825e+03, 4.18918e+03, 4.16680e+03,
 4.14080e+03, 4.11084e+03, 4.07658e+03, 4.03770e+03, 3.99391e+03,
 3.94490e+03, 3.89041e+03, 3.83018e+03, 3.76400e+03, 3.69170e+03,
 3.61322e+03, 3.52856e+03, 3.43784e+03, 3.34130e+03, 3.23926e+03,
 3.13215e+03, 3.02049e+03, 2.90489e+03, 2.78602e+03, 2.66461e+03,
 2.54145e+03, 2.41729e+03, 2.38377e+03, 2.26054e+03, 2.13809e+03,
 2.01708e+03, 1.89806e+03, 1.78155e+03, 1.66797e+03, 1.55766e+03,
 1.45091e+03, 1.34794e+03, 1.24889e+03, 1.15386e+03, 1.06291e+03,
 9.76055e+02, 8.93282e+02, 8.14565e+02, 7.39863e+02, 6.69137e+02,
 6.02352e+02, 5.39492e+02, 4.80566e+02, 4.25616e+02, 3.74738e+02,
 3.28082e+02, 2.85874e+02, 2.48431e+02, 2.16183e+02, 1.89692e+02}
,
{2.85353e+00, 3.21512e+01, 1.26429e+02, 3.10795e+02, 5.86239e+02,
 9.36339e+02, 1.33588e+03, 1.75828e+03, 2.18026e+03, 2.58374e+03,
 2.95618e+03, 3.29029e+03, 3.58327e+03, 3.83633e+03, 4.05304e+03,
 4.23795e+03, 4.39578e+03, 4.53059e+03, 4.64588e+03, 4.74450e+03,
 4.82898e+03, 4.90165e+03, 4.96458e+03, 5.01954e+03, 5.06801e+03,
 5.11112e+03, 5.14969e+03, 5.18426e+03, 5.21518e+03, 5.24280e+03,
 5.26740e+03, 5.28924e+03, 5.30846e+03, 5.32513e+03, 5.33924e+03,
 5.35073e+03, 5.35962e+03, 5.36599e+03, 5.36991e+03, 5.37141e+03,
 5.37046e+03, 5.36692e+03, 5.36061e+03, 5.35131e+03, 5.33879e+03,
 5.32287e+03, 5.30332e+03, 5.27990e+03, 5.25226e+03, 5.22000e+03,
 5.18270e+03, 5.13990e+03, 5.09117e+03, 5.03611e+03, 4.97434e+03,
 4.90549e+03, 4.82924e+03, 4.74528e+03, 4.65341e+03, 4.55352e+03,
 4.44564e+03, 4.32991e+03, 4.20665e+03, 4.07629e+03, 3.93940e+03,
 3.79669e+03, 3.64895e+03, 3.49709e+03, 3.34210e+03, 3.18500e+03,
 3.02681e+03, 2.98360e+03, 2.82701e+03, 2.67169e+03, 2.51845e+03,
 2.36805e+03, 2.22112e+03, 2.07819e+03, 1.93970e+03, 1.80601e+03,
 1.67734e+03, 1.55389e+03, 1.43574e+03, 1.32293e+03, 1.21546e+03,
 1.11326e+03, 1.01628e+03, 9.24402e+02, 8.37536e+02, 7.55582e+02,
 6.78449e+02, 6.06079e+02, 5.38437e+02, 4.75538e+02, 4.17451e+02,
 3.64319e+02, 3.16369e+02, 2.73937e+02, 2.37487e+02, 2.07642e+02}
,
{3.79412e+00, 4.27515e+01, 1.67559e+02, 4.10080e+02, 7.70093e+02,
 1.22474e+03, 1.74027e+03, 2.28185e+03, 2.81951e+03, 3.33041e+03,
 3.79904e+03, 4.21682e+03, 4.58111e+03, 4.89431e+03, 5.16157e+03,
 5.38896e+03, 5.58261e+03, 5.74766e+03, 5.88848e+03, 6.00866e+03,
 6.11147e+03, 6.19987e+03, 6.27647e+03, 6.34345e+03, 6.40262e+03,
 6.45530e+03, 6.50241e+03, 6.54453e+03, 6.58212e+03, 6.61558e+03,
 6.64530e+03, 6.67153e+03, 6.69443e+03, 6.71402e+03, 6.73023e+03,
 6.74305e+03, 6.75253e+03, 6.75881e+03, 6.76194e+03, 6.76192e+03,
 6.75861e+03, 6.75179e+03, 6.74119e+03, 6.72649e+03, 6.70745e+03,
 6.68380e+03, 6.65520e+03, 6.62126e+03, 6.58145e+03, 6.53522e+03,
 6.48198e+03, 6.42114e+03, 6.35218e+03, 6.27459e+03, 6.18789e+03,
 6.09164e+03, 5.98544e+03, 5.86900e+03, 5.74217e+03, 5.60498e+03,
 5.45762e+03, 5.30050e+03, 5.13418e+03, 4.95943e+03, 4.77717e+03,
 4.58848e+03, 4.39456e+03, 4.19672e+03, 3.99629e+03, 3.79466e+03,
 3.73871e+03, 3.53957e+03, 3.34233e+03, 3.14806e+03, 2.95772e+03,
 2.77211e+03, 2.59193e+03, 2.41772e+03, 2.24991e+03, 2.08878e+03,
 1.93454e+03, 1.78727e+03, 1.64700e+03, 1.51367e+03, 1.38719e+03,
 1.26741e+03, 1.15418e+03, 1.04731e+03, 9.46614e+02, 8.51929e+02,
 7.63097e+02, 6.79997e+02, 6.02546e+02, 5.30717e+02, 4.64551e+02,
 4.04173e+02, 3.49810e+02, 3.01815e+02, 2.60689e+02, 2.27118e+02}
,
{5.04177e+00, 5.67921e+01, 2.21843e+02, 5.40533e+02, 1.01059e+03,
 1.60040e+03, 2.26491e+03, 2.95860e+03, 3.64296e+03, 4.28917e+03,
 4.87823e+03, 5.40014e+03, 5.85275e+03, 6.24017e+03, 6.56963e+03,
 6.84925e+03, 7.08677e+03, 7.28882e+03, 7.46079e+03, 7.60725e+03,
 7.73239e+03, 7.84000e+03, 7.93331e+03, 8.01504e+03, 8.08735e+03,
 8.15175e+03, 8.20926e+03, 8.26055e+03, 8.30619e+03, 8.34671e+03,
 8.38256e+03, 8.41398e+03, 8.44112e+03, 8.46391e+03, 8.48230e+03,
 8.49631e+03, 8.50608e+03, 8.51175e+03, 8.51335e+03, 8.51075e+03,
 8.50374e+03, 8.49193e+03, 8.47495e+03, 8.45244e+03, 8.42405e+03,
 8.38939e+03, 8.34794e+03, 8.29908e+03, 8.24207e+03, 8.17613e+03,
 8.10051e+03, 8.01448e+03, 7.91738e+03, 7.80858e+03, 7.68746e+03,
 7.55351e+03, 7.40634e+03, 7.24571e+03, 7.07163e+03, 6.88436e+03,
 6.68441e+03, 6.47253e+03, 6.24971e+03, 6.01717e+03, 5.77635e+03,
 5.52882e+03, 5.27631e+03, 5.02061e+03, 4.76352e+03, 4.69075e+03,
 4.43734e+03, 4.18663e+03, 3.94004e+03, 3.69881e+03, 3.46398e+03,
 3.23644e+03, 3.01686e+03, 2.80577e+03, 2.60353e+03, 2.41035e+03,
 2.22633e+03, 2.05145e+03, 1.88562e+03, 1.72865e+03, 1.58035e+03,
 1.44044e+03, 1.30866e+03, 1.18471e+03, 1.06832e+03, 9.59219e+02,
 8.57172e+02, 7.61982e+02, 6.73502e+02, 5.91655e+02, 5.16444e+02,
 4.47969e+02, 3.86452e+02, 3.32261e+02, 2.85937e+02, 2.48229e+02}
,
{6.69541e+00, 7.53844e+01, 2.93435e+02, 7.11778e+02, 1.32489e+03,
 2.08928e+03, 2.94498e+03, 3.83262e+03, 4.70285e+03, 5.51943e+03,
 6.25913e+03, 6.91050e+03, 7.47245e+03, 7.95145e+03, 8.35742e+03,
 8.70119e+03, 8.99256e+03, 9.23984e+03, 9.44978e+03, 9.62827e+03,
 9.78066e+03, 9.91174e+03, 1.00255e+04, 1.01254e+04, 1.02138e+04,
 1.02925e+04, 1.03627e+04, 1.04251e+04, 1.04805e+04, 1.05295e+04,
 1.05727e+04, 1.06102e+04, 1.06421e+04, 1.06683e+04, 1.06889e+04,
 1.07038e+04, 1.07133e+04, 1.07176e+04, 1.07165e+04, 1.07098e+04,
 1.06970e+04, 1.06778e+04, 1.06515e+04, 1.06178e+04, 1.05761e+04,
 1.05258e+04, 1.04662e+04, 1.03962e+04, 1.03150e+04, 1.02214e+04,
 1.01145e+04, 9.99346e+03, 9.85739e+03, 9.70550e+03, 9.53708e+03,
 9.35158e+03, 9.14866e+03, 8.92831e+03, 8.69082e+03, 8.43683e+03,
 8.16732e+03, 7.88358e+03, 7.58720e+03, 7.28006e+03, 6.96425e+03,
 6.64206e+03, 6.31583e+03, 6.21748e+03, 5.89302e+03, 5.57029e+03,
 5.25134e+03, 4.93799e+03, 4.63186e+03, 4.33431e+03, 4.04645e+03,
 3.76915e+03, 3.50309e+03, 3.24867e+03, 3.00616e+03, 2.77562e+03,
 2.55702e+03, 2.35019e+03, 2.15487e+03, 1.97073e+03, 1.79740e+03,
 1.63448e+03, 1.48155e+03, 1.33819e+03, 1.20399e+03, 1.07859e+03,
 9.61632e+02, 8.52832e+02, 7.51968e+02, 6.58895e+02, 5.73567e+02,
 4.96054e+02, 4.26567e+02, 3.65484e+02, 3.13386e+02, 2.71095e+02}
,
{8.88519e+00, 9.99800e+01, 3.87782e+02, 9.36409e+02, 1.73533e+03,
 2.72500e+03, 3.82583e+03, 4.96059e+03, 6.06611e+03, 7.09697e+03,
 8.02493e+03, 8.83718e+03, 9.53444e+03, 1.01264e+04, 1.06265e+04,
 1.10491e+04, 1.14064e+04, 1.17090e+04, 1.19653e+04, 1.21828e+04,
 1.23685e+04, 1.25283e+04, 1.26672e+04, 1.27893e+04, 1.28974e+04,
 1.29937e+04, 1.30793e+04, 1.31552e+04, 1.32224e+04, 1.32816e+04,
 1.33334e+04, 1.33779e+04, 1.34151e+04, 1.34449e+04, 1.34674e+04,
 1.34827e+04, 1.34912e+04, 1.34928e+04, 1.34872e+04, 1.34741e+04,
 1.34529e+04, 1.34227e+04, 1.33830e+04, 1.33333e+04, 1.32727e+04,
 1.32004e+04, 1.31150e+04, 1.30154e+04, 1.29001e+04, 1.27679e+04,
 1.26176e+04, 1.24481e+04, 1.22583e+04, 1.20472e+04, 1.18141e+04,
 1.15585e+04, 1.12802e+04, 1.09797e+04, 1.06577e+04, 1.03155e+04,
 9.95464e+03, 9.57731e+03, 9.18592e+03, 8.78324e+03, 8.37226e+03,
 7.95607e+03, 7.82735e+03, 7.41366e+03, 7.00242e+03, 6.59630e+03,
 6.19770e+03, 5.80871e+03, 5.43111e+03, 5.06635e+03, 4.71554e+03,
 4.37948e+03, 4.05873e+03, 3.75356e+03, 3.46405e+03, 3.19009e+03,
 2.93142e+03, 2.68768e+03, 2.45839e+03, 2.24305e+03, 2.04107e+03,
 1.85187e+03, 1.67487e+03, 1.50946e+03, 1.35510e+03, 1.21128e+03,
 1.07751e+03, 9.53414e+02, 8.38657e+02, 7.33019e+02, 6.36392e+02,
 5.48803e+02, 4.70446e+02, 4.01705e+02, 3.43202e+02, 2.95836e+02}
,
{1.17823e+01, 1.32485e+02, 5.11993e+02, 1.23080e+03, 2.27084e+03,
 3.55098e+03, 4.96584e+03, 6.41516e+03, 7.81836e+03, 9.11845e+03,
 1.02815e+04, 1.12936e+04, 1.21582e+04, 1.28895e+04, 1.35055e+04,
 1.40248e+04, 1.44629e+04, 1.48331e+04, 1.51459e+04, 1.54112e+04,
 1.56375e+04, 1.58325e+04, 1.60022e+04, 1.61516e+04, 1.62840e+04,
 1.64016e+04, 1.65059e+04, 1.65982e+04, 1.66796e+04, 1.67510e+04,
 1.68129e+04, 1.68655e+04, 1.69084e+04, 1.69418e+04, 1.69657e+04,
 1.69807e+04, 1.69867e+04, 1.69837e+04, 1.69711e+04, 1.69483e+04,
 1.69144e+04, 1.68684e+04, 1.68097e+04, 1.67373e+04, 1.66500e+04,
 1.65465e+04, 1.64250e+04, 1.62837e+04, 1.61209e+04, 1.59351e+04,
 1.57248e+04, 1.54884e+04, 1.52247e+04, 1.49327e+04, 1.46116e+04,
 1.42612e+04, 1.38818e+04, 1.34745e+04, 1.30406e+04, 1.25824e+04,
 1.21026e+04, 1.16044e+04, 1.10913e+04, 1.05672e+04, 1.00363e+04,
 9.86765e+03, 9.34004e+03, 8.81572e+03, 8.29819e+03, 7.79062e+03,
 7.29576e+03, 6.81592e+03, 6.35296e+03, 5.90833e+03, 5.48306e+03,
 5.07782e+03, 4.69294e+03, 4.32847e+03, 3.98425e+03, 3.65989e+03,
 3.35488e+03, 3.06857e+03, 2.80024e+03, 2.54911e+03, 2.31437e+03,
 2.09521e+03, 1.89082e+03, 1.70041e+03, 1.52324e+03, 1.35863e+03,
 1.20595e+03, 1.06467e+03, 9.34343e+02, 8.14658e+02, 7.05424e+02,
 6.06615e+02, 5.18397e+02, 4.41159e+02, 3.75560e+02, 3.22583e+02}
,
{1.56117e+01, 1.75401e+02, 6.75375e+02, 1.61628e+03, 2.96899e+03,
 4.62332e+03, 6.44014e+03, 8.28955e+03, 1.00689e+04, 1.17072e+04,
 1.31637e+04, 1.44238e+04, 1.54953e+04, 1.63983e+04, 1.71570e+04,
 1.77949e+04, 1.83322e+04, 1.87850e+04, 1.91668e+04, 1.94903e+04,
 1.97664e+04, 2.00044e+04, 2.02121e+04, 2.03950e+04, 2.05571e+04,
 2.07008e+04, 2.08278e+04, 2.09399e+04, 2.10384e+04, 2.11243e+04,
 2.11980e+04, 2.12595e+04, 2.13085e+04, 2.13451e+04, 2.13698e+04,
 2.13829e+04, 2.13844e+04, 2.13740e+04, 2.13507e+04, 2.13134e+04,
 2.12610e+04, 2.11924e+04, 2.11066e+04, 2.10022e+04, 2.08774e+04,
 2.07300e+04, 2.05577e+04, 2.03583e+04, 2.01296e+04, 1.98696e+04,
 1.95765e+04, 1.92483e+04, 1.88837e+04, 1.84816e+04, 1.80415e+04,
 1.75638e+04, 1.70495e+04, 1.65006e+04, 1.59198e+04, 1.53105e+04,
 1.46768e+04, 1.40234e+04, 1.33556e+04, 1.26785e+04, 1.24573e+04,
 1.17842e+04, 1.11154e+04, 1.04554e+04, 9.80852e+03, 9.17824e+03,
 8.56764e+03, 7.97916e+03, 7.41466e+03, 6.87547e+03, 6.36242e+03,
 5.87593e+03, 5.41603e+03, 4.98245e+03, 4.57465e+03, 4.19192e+03,
 3.83338e+03, 3.49805e+03, 3.18488e+03, 2.89277e+03, 2.62063e+03,
 2.36734e+03, 2.13184e+03, 1.91310e+03, 1.71015e+03, 1.52211e+03,
 1.34816e+03, 1.18760e+03, 1.03986e+03, 9.04490e+02, 7.81207e+02,
 6.69919e+02, 5.70752e+02, 4.84095e+02, 4.10645e+02, 3.51471e+02}
,
{2.06690e+01, 2.32047e+02, 8.90153e+02, 2.12068e+03, 3.87848e+03,
 6.01445e+03, 8.34537e+03, 1.07033e+04, 1.29576e+04, 1.50203e+04,
 1.68427e+04, 1.84106e+04, 1.97378e+04, 2.08525e+04, 2.17867e+04,
 2.25705e+04, 2.32291e+04, 2.37827e+04, 2.42489e+04, 2.46436e+04,
 2.49806e+04, 2.52715e+04, 2.55257e+04, 2.57498e+04, 2.59482e+04,
 2.61236e+04, 2.62782e+04, 2.64142e+04, 2.65333e+04, 2.66363e+04,
 2.67236e+04, 2.67948e+04, 2.68499e+04, 2.68892e+04, 2.69133e+04,
 2.69224e+04, 2.69164e+04, 2.68943e+04, 2.68547e+04, 2.67962e+04,
 2.67173e+04, 2.66167e+04, 2.64927e+04, 2.63431e+04, 2.61654e+04,
 2.59566e+04, 2.57135e+04, 2.54334e+04, 2.51134e+04, 2.47512e+04,
 2.43443e+04, 2.38906e+04, 2.33886e+04, 2.28376e+04, 2.22375e+04,
 2.15899e+04, 2.08968e+04, 2.01618e+04, 1.93892e+04, 1.85842e+04,
 1.77531e+04, 1.69023e+04, 1.60391e+04, 1.51706e+04, 1.48902e+04,
 1.40367e+04, 1.31946e+04, 1.23693e+04, 1.15657e+04, 1.07877e+04,
 1.00385e+04, 9.32067e+03, 8.63580e+03, 7.98500e+03, 7.36877e+03,
 6.78712e+03, 6.23965e+03, 5.72563e+03, 5.24410e+03, 4.79385e+03,
 4.37359e+03, 3.98189e+03, 3.61729e+03, 3.27832e+03, 2.96350e+03,
 2.67138e+03, 2.40059e+03, 2.14979e+03, 1.91774e+03, 1.70332e+03,
 1.50548e+03, 1.32333e+03, 1.15612e+03, 1.00325e+03, 8.64327e+02,
 7.39174e+02, 6.27866e+02, 5.30781e+02, 4.48654e+02, 3.82646e+02}
,
{2.73417e+01, 3.06763e+02, 1.17225e+03, 2.78015e+03, 5.06235e+03,
 7.81782e+03, 1.08058e+04, 1.38093e+04, 1.66632e+04, 1.92579e+04,
 2.15362e+04, 2.34858e+04, 2.51291e+04, 2.65046e+04, 2.76548e+04,
 2.86178e+04, 2.94249e+04, 3.01019e+04, 3.06711e+04, 3.11528e+04,
 3.15645e+04, 3.19205e+04, 3.22319e+04, 3.25065e+04, 3.27492e+04,
 3.29631e+04, 3.31513e+04, 3.33163e+04, 3.34598e+04, 3.35829e+04,
 3.36854e+04, 3.37671e+04, 3.38279e+04, 3.38687e+04, 3.38900e+04,
 3.38919e+04, 3.38737e+04, 3.38337e+04, 3.37701e+04, 3.36809e+04,
 3.35643e+04, 3.34184e+04, 3.32406e+04, 3.30277e+04, 3.27759e+04,
 3.24812e+04, 3.21397e+04, 3.17479e+04, 3.13022e+04, 3.07996e+04,
 3.02372e+04, 2.96127e+04, 2.89247e+04, 2.81733e+04, 2.73596e+04,
 2.64865e+04, 2.55582e+04, 2.45800e+04, 2.35588e+04, 2.25024e+04,
 2.14196e+04, 2.03195e+04, 1.92116e+04, 1.88432e+04, 1.77536e+04,
 1.66784e+04, 1.56247e+04, 1.45991e+04, 1.36066e+04, 1.26516e+04,
 1.17372e+04, 1.08658e+04, 1.00387e+04, 9.25649e+03, 8.51924e+03,
 7.82635e+03, 7.17685e+03, 6.56942e+03, 6.00248e+03, 5.47427e+03,
 4.98290e+03, 4.52647e+03, 4.10296e+03, 3.71045e+03, 3.34701e+03,
 3.01078e+03, 2.69998e+03, 2.41294e+03, 2.14809e+03, 1.90399e+03,
 1.67936e+03, 1.47304e+03, 1.28408e+03, 1.11172e+03, 9.55413e+02,
 8.14874e+02, 6.90117e+02, 5.81501e+02, 4.89796e+02, 4.16257e+02}
,
{3.61459e+01, 4.05229e+02, 1.54245e+03, 3.64168e+03, 6.60228e+03,
 1.01539e+04, 1.39809e+04, 1.78038e+04, 2.14135e+04, 2.46748e+04,
 2.75210e+04, 2.99438e+04, 3.19777e+04, 3.36748e+04, 3.50907e+04,
 3.62734e+04, 3.72624e+04, 3.80902e+04, 3.87854e+04, 3.93737e+04,
 3.98770e+04, 4.03129e+04, 4.06947e+04, 4.10312e+04, 4.13279e+04,
 4.15888e+04, 4.18176e+04, 4.20174e+04, 4.21901e+04, 4.23364e+04,
 4.24558e+04, 4.25481e+04, 4.26139e+04, 4.26542e+04, 4.26694e+04,
 4.26591e+04, 4.26218e+04, 4.25552e+04, 4.24564e+04, 4.23233e+04,
 4.21534e+04, 4.19437e+04, 4.16904e+04, 4.13888e+04, 4.10335e+04,
 4.06195e+04, 4.01418e+04, 3.95960e+04, 3.89778e+04, 3.82832e+04,
 3.75090e+04, 3.66530e+04, 3.57147e+04, 3.46953e+04, 3.35980e+04,
 3.24279e+04, 3.11917e+04, 2.98980e+04, 2.85569e+04, 2.71797e+04,
 2.57784e+04, 2.43654e+04, 2.38814e+04, 2.24902e+04, 2.11166e+04,
 1.97705e+04, 1.84602e+04, 1.71927e+04, 1.59736e+04, 1.48072e+04,
 1.36965e+04, 1.26434e+04, 1.16486e+04, 1.07121e+04, 9.83319e+03,
 9.01052e+03, 8.24235e+03, 7.52656e+03, 6.86084e+03, 6.24269e+03,
 5.66957e+03, 5.13885e+03, 4.64797e+03, 4.19437e+03, 3.77560e+03,
 3.38929e+03, 3.03321e+03, 2.70525e+03, 2.40346e+03, 2.12603e+03,
 1.87136e+03, 1.63803e+03, 1.42482e+03, 1.23076e+03, 1.05514e+03,
 8.97548e+02, 7.57910e+02, 6.36558e+02, 5.34290e+02, 4.52467e+02}
,
{4.77611e+01, 5.34879e+02, 2.02793e+03, 4.76645e+03, 8.60393e+03,
 1.31781e+04, 1.80757e+04, 2.29376e+04, 2.74996e+04, 3.15956e+04,
 3.51485e+04, 3.81578e+04, 4.06742e+04, 4.27677e+04, 4.45103e+04,
 4.59627e+04, 4.71746e+04, 4.81866e+04, 4.90360e+04, 4.97550e+04,
 5.03708e+04, 5.09050e+04, 5.13732e+04, 5.17855e+04, 5.21480e+04,
 5.24660e+04, 5.27441e+04, 5.29856e+04, 5.31927e+04, 5.33654e+04,
 5.35031e+04, 5.36060e+04, 5.36751e+04, 5.37115e+04, 5.37155e+04,
 5.36856e+04, 5.36194e+04, 5.35133e+04, 5.33642e+04, 5.31688e+04,
 5.29239e+04, 5.26247e+04, 5.22657e+04, 5.18400e+04, 5.13408e+04,
 5.07616e+04, 5.00963e+04, 4.93391e+04, 4.84847e+04, 4.75285e+04,
 4.64672e+04, 4.52994e+04, 4.40259e+04, 4.26504e+04, 4.11788e+04,
 3.96195e+04, 3.79833e+04, 3.62830e+04, 3.45331e+04, 3.27493e+04,
 3.09477e+04, 3.03120e+04, 2.85353e+04, 2.67801e+04, 2.50592e+04,
 2.33838e+04, 2.17632e+04, 2.02051e+04, 1.87151e+04, 1.72972e+04,
 1.59539e+04, 1.46862e+04, 1.34942e+04, 1.23769e+04, 1.13325e+04,
 1.03586e+04, 9.45262e+03, 8.61134e+03, 7.83152e+03, 7.10980e+03,
 6.44273e+03, 5.82693e+03, 5.25903e+03, 4.73581e+03, 4.25414e+03,
 3.81106e+03, 3.40378e+03, 3.02967e+03, 2.68631e+03, 2.37149e+03,
 2.08320e+03, 1.81970e+03, 1.57947e+03, 1.36129e+03, 1.16424e+03,
 9.87766e+02, 8.31680e+02, 6.96274e+02, 5.82374e+02, 4.91444e+02}
,
{6.30738e+01, 7.05478e+02, 2.66421e+03, 6.23379e+03, 1.12039e+04,
 1.70902e+04, 2.33532e+04, 2.95317e+04, 3.52927e+04, 4.04329e+04,
 4.48651e+04, 4.86010e+04, 5.17133e+04, 5.42955e+04, 5.64398e+04,
 5.82234e+04, 5.97078e+04, 6.09454e+04, 6.19834e+04, 6.28626e+04,
 6.36167e+04, 6.42720e+04, 6.48464e+04, 6.53514e+04, 6.57942e+04,
 6.61815e+04, 6.65190e+04, 6.68104e+04, 6.70576e+04, 6.72600e+04,
 6.74170e+04, 6.75294e+04, 6.75989e+04, 6.76264e+04, 6.76113e+04,
 6.75511e+04, 6.74416e+04, 6.72784e+04, 6.70574e+04, 6.67743e+04,
 6.64241e+04, 6.59997e+04, 6.54929e+04, 6.48947e+04, 6.41962e+04,
 6.33893e+04, 6.24661e+04, 6.14196e+04, 6.02434e+04, 5.89323e+04,
 5.74837e+04, 5.58979e+04, 5.41784e+04, 5.23322e+04, 5.03695e+04,
 4.83037e+04, 4.61511e+04, 4.39302e+04, 4.16612e+04, 3.93655e+04,
 3.85310e+04, 3.62621e+04, 3.40184e+04, 3.18171e+04, 2.96732e+04,
 2.75993e+04, 2.56054e+04, 2.36993e+04, 2.18865e+04, 2.01701e+04,
 1.85518e+04, 1.70316e+04, 1.56081e+04, 1.42792e+04, 1.30417e+04,
 1.18921e+04, 1.08262e+04, 9.83974e+03, 8.92831e+03, 8.08741e+03,
 7.31256e+03, 6.59937e+03, 5.94358e+03, 5.34109e+03, 4.78801e+03,
 4.28064e+03, 3.81552e+03, 3.38942e+03, 2.99935e+03, 2.64260e+03,
 2.31673e+03, 2.01956e+03, 1.74926e+03, 1.50429e+03, 1.28350e+03,
 1.08614e+03, 9.11890e+02, 7.60995e+02, 6.34297e+02, 5.33368e+02}
,
{8.32465e+01, 9.29877e+02, 3.49744e+03, 8.14662e+03, 1.45787e+04,
 2.21480e+04, 3.01507e+04, 3.79965e+04, 4.52661e+04, 5.17118e+04,
 5.72375e+04, 6.18732e+04, 6.57213e+04, 6.89058e+04, 7.15444e+04,
 7.37341e+04, 7.55522e+04, 7.70658e+04, 7.83350e+04, 7.94109e+04,
 8.03352e+04, 8.11393e+04, 8.18440e+04, 8.24622e+04, 8.30028e+04,
 8.34742e+04, 8.38833e+04, 8.42341e+04, 8.45275e+04, 8.47627e+04,
 8.49393e+04, 8.50590e+04, 8.51241e+04, 8.51347e+04, 8.50891e+04,
 8.49828e+04, 8.48098e+04, 8.45647e+04, 8.42421e+04, 8.38361e+04,
 8.33384e+04, 8.27392e+04, 8.20268e+04, 8.11894e+04, 8.02159e+04,
 7.90960e+04, 7.78200e+04, 7.63790e+04, 7.47657e+04, 7.29755e+04,
 7.10071e+04, 6.88641e+04, 6.65541e+04, 6.40895e+04, 6.14866e+04,
 5.87658e+04, 5.59507e+04, 5.30675e+04, 5.01438e+04, 4.90494e+04,
 4.61522e+04, 4.32836e+04, 4.04666e+04, 3.77213e+04, 3.50647e+04,
 3.25105e+04, 3.00690e+04, 2.77477e+04, 2.55511e+04, 2.34815e+04,
 2.15389e+04, 1.97218e+04, 1.80271e+04, 1.64510e+04, 1.49887e+04,
 1.36348e+04, 1.23837e+04, 1.12296e+04, 1.01666e+04, 9.18872e+03,
 8.29033e+03, 7.46581e+03, 6.70981e+03, 6.01719e+03, 5.38311e+03,
 4.80302e+03, 4.27263e+03, 3.78801e+03, 3.34551e+03, 2.94182e+03,
 2.57395e+03, 2.23927e+03, 1.93553e+03, 1.66084e+03, 1.41376e+03,
 1.19331e+03, 9.99036e+02, 8.31088e+02, 6.90323e+02, 5.78429e+02}
,
{   109.802,   1224.82 ,   4587.77 ,  10638.7  ,  18956.5  ,  28682.6  ,
  38901.   ,  48856.6  ,  58022.8  ,  66100.1  ,  72984.8  ,  78734.5  ,
  83490.8  ,  87417.8  ,  90664.3  ,  93352.1  ,  95578.8  ,  97430.4  ,
  98983.1  , 100301.   , 101434.   , 102422.   , 103286.   , 104042.   ,
 104702.   , 105276.   , 105771.   , 106191.   , 106538.   , 106808.   ,
 107003.   , 107126.   , 107179.   , 107161.   , 107068.   , 106893.   ,
 106628.   , 106267.   , 105802.   , 105223.   , 104520.   , 103677.   ,
 102680.   , 101512.   , 100161.   ,  98612.2  ,  96854.8  ,  94877.8  ,
  92673.8  ,  90239.4  ,  87577.2  ,  84695.4  ,  81608.3  ,  78335.9  ,
  74903.2  ,  71340.4  ,  67680.9  ,  63960.6  ,  62526.9  ,  58828.3  ,
  55160.7  ,  51554.6  ,  48037.3  ,  44631.5  ,  41356.   ,  38224.8  ,
  35248.3  ,  32432.8  ,  29781.4  ,  27294.5  ,  24970.2  ,  22804.8  ,
  20792.9  ,  18928.5  ,  17204.6  ,  15613.9  ,  14148.5  ,  12800.9  ,
  11563.4  ,  10428.3  ,   9388.53 ,   8436.91 ,   7566.77 ,   6771.78 ,
   6045.93 ,   5383.65 ,   4779.71 ,   4229.3  ,   3727.99 ,   3271.77 ,
   2857.04 ,   2480.6  ,   2139.71 ,   1832.09 ,   1555.93 ,   1310.   ,
   1093.65 ,    906.943,    750.735,    626.828}
,
{   144.734,   1612.17 ,   6013.8  ,  13883.3  ,  24631.7  ,  37120.   ,
  50158.4  ,  62781.9  ,  74331.5  ,  84445.9  ,  93018.9  , 100148.   ,
 106026.   , 110868.   , 114861.   , 118160.   , 120887.   , 123153.   ,
 125053.   , 126668.   , 128060.   , 129272.   , 130332.   , 131257.   ,
 132062.   , 132759.   , 133357.   , 133859.   , 134265.   , 134572.   ,
 134783.   , 134903.   , 134932.   , 134868.   , 134703.   , 134427.   ,
 134031.   , 133506.   , 132841.   , 132022.   , 131032.   , 129852.   ,
 128460.   , 126838.   , 124968.   , 122835.   , 120423.   , 117721.   ,
 114721.   , 111426.   , 107842.   , 103986.   ,  99881.9  ,  95560.3  ,
  91058.8  ,  86420.3  ,  81691.   ,  76918.9  ,  75096.1  ,  70407.2  ,
  65790.2  ,  61281.5  ,  56912.3  ,  52707.8  ,  48687.6  ,  44866.   ,
  41251.7  ,  37849.4  ,  34660.1  ,  31681.4  ,  28908.6  ,  26335.   ,
  23952.6  ,  21752.4  ,  19724.7  ,  17859.4  ,  16146.5  ,  14576.   ,
  13137.8  ,  11822.6  ,  10621.1  ,   9524.45 ,   8524.48 ,   7613.31 ,
   6783.61 ,   6028.54 ,   5341.77 ,   4717.46 ,   4150.27 ,   3635.36 ,
   3168.37 ,   2745.48 ,   2363.37 ,   2019.27 ,   1710.98 ,   1436.94 ,
   1196.3  ,    988.98 ,    815.832,    678.777}
,
{   190.651,   2120.49 ,   7877.61 ,  18104.6  ,  31984.2  ,  48008.   ,
  64632.4  ,  80627.5  ,  95170.5  , 107827.   , 118497.   , 127333.   ,
 134596.   , 140565.   , 145477.   , 149525.   , 152866.   , 155639.   ,
 157966.   , 159947.   , 161656.   , 163145.   , 164445.   , 165575.   ,
 166556.   , 167402.   , 168123.   , 168719.   , 169190.   , 169534.   ,
 169757.   , 169862.   , 169850.   , 169713.   , 169440.   , 169019.   ,
 168437.   , 167682.   , 166738.   , 165585.   , 164198.   , 162549.   ,
 160615.   , 158370.   , 155793.   , 152864.   , 149565.   , 145885.   ,
 141821.   , 137380.   , 132578.   , 127445.   , 122016.   , 116340.   ,
 110470.   , 104465.   ,  98388.9  ,  95998.   ,  90005.1  ,  84093.4  ,
  78312.2  ,  72703.5  ,  67302.2  ,  62135.2  ,  57222.2  ,  52575.9  ,
  48203.2  ,  44105.9  ,  40281.5  ,  36724.   ,  33425.   ,  30374.1  ,
  27559.5  ,  24968.6  ,  22588.3  ,  20405.5  ,  18406.9  ,  16579.6  ,
  14911.2  ,  13389.5  ,  12003.3  ,  10741.5  ,   9593.96 ,   8551.1  ,
   7603.97 ,   6744.27 ,   5964.32 ,   5257.09 ,   4616.15 ,   4035.7  ,
   3510.51 ,   3036.   ,   2608.18 ,   2223.72 ,   1879.95 ,   1574.96 ,
   1307.59 ,   1077.64 ,    885.931,    734.499}
,
{   250.968,   2787.32 ,  10311.9  ,  23593.6  ,  41504.1  ,  62049.9  ,
  83232.3  , 103486.   , 121785.   , 137612.   , 150886.   , 161835.   ,
 170807.   , 178164.   , 184207.   , 189173.   , 193265.   , 196661.   ,
 199513.   , 201945.   , 204045.   , 205874.   , 207466.   , 208847.   ,
 210042.   , 211068.   , 211933.   , 212637.   , 213177.   , 213557.   ,
 213782.   , 213856.   , 213775.   , 213528.   , 213099.   , 212470.   ,
 211626.   , 210550.   , 209218.   , 207600.   , 205662.   , 203369.   ,
 200690.   , 197594.   , 194054.   , 190046.   , 185550.   , 180558.   ,
 175074.   , 169115.   , 162714.   , 155913.   , 148772.   , 141356.   ,
 133744.   , 126014.   , 122883.   , 115227.   , 107659.   , 100244.   ,
  93041.5  ,  86097.6  ,  79450.3  ,  73127.   ,  67146.1  ,  61517.8  ,
  56245.4  ,  51326.3  ,  46753.4  ,  42515.9  ,  38600.5  ,  34991.9  ,
  31673.6  ,  28628.8  ,  25840.   ,  23290.1  ,  20962.1  ,  18839.6  ,
  16907.   ,  15149.3  ,  13552.2  ,  12102.4  ,  10787.4  ,   9595.4  ,
   8515.63 ,   7538.03 ,   6653.36 ,   5853.17 ,   5129.76 ,   4476.18 ,
   3886.23 ,   3354.4  ,   2875.95 ,   2446.88 ,   2063.99 ,   1724.9  ,
   1428.18 ,   1173.41 ,    961.371,    794.234}
,
{   330.211,   3661.59 ,  13489.2  ,  30726.6  ,  53822.8  ,  80149.2  ,
 107121.   , 132749.   , 155759.   , 175541.   , 192047.   , 205609.   ,
 216693.   , 225760.   , 233190.   , 239283.   , 244297.   , 248457.   ,
 251955.   , 254941.   , 257523.   , 259768.   , 261718.   , 263405.   ,
 264860.   , 266100.   , 267134.   , 267960.   , 268574.   , 268983.   ,
 269195.   , 269211.   , 269023.   , 268612.   , 267956.   , 267033.   ,
 265823.   , 264300.   , 262429.   , 260167.   , 257469.   , 254291.   ,
 250593.   , 246338.   , 241491.   , 236024.   , 229919.   , 223175.   ,
 215807.   , 207850.   , 199355.   , 190392.   , 181045.   , 171410.   ,
 161592.   , 151697.   , 147725.   , 138038.   , 128529.   , 119276.   ,
 110344.   , 101785.   ,  93637.8  ,  85929.2  ,  78674.4  ,  71879.1  ,
  65541.1  ,  59652.1  ,  54198.4  ,  49163.1  ,  44526.5  ,  40267.1  ,
  36363.   ,  32791.3  ,  29529.7  ,  26555.8  ,  23848.5  ,  21387.   ,
  19151.7  ,  17124.1  ,  15286.8  ,  13623.2  ,  12118.2  ,  10757.5  ,
   9528.02 ,   8417.71 ,   7415.46 ,   6511.14 ,   5695.59 ,   4960.52 ,
   4298.53 ,   3703.12 ,   3168.63 ,   2690.3  ,   2264.29 ,   1887.71 ,
   1558.75 ,   1276.78 ,   1042.51 ,    858.23 }
,
{   434.285,   4807.07 ,  17634.4  ,  39990.3  ,  69754.1  , 103465.   ,
 137787.   , 170195.   , 199111.   , 223819.   , 244336.   , 261131.   ,
 274820.   , 285995.   , 295130.   , 302606.   , 308749.   , 313848.   ,
 318140.   , 321810.   , 324985.   , 327742.   , 330129.   , 332188.   ,
 333957.   , 335454.   , 336684.   , 337643.   , 338331.   , 338759.   ,
 338934.   , 338854.   , 338501.   , 337850.   , 336869.   , 335534.   ,
 333814.   , 331670.   , 329051.   , 325899.   , 322156.   , 317766.   ,
 312680.   , 306849.   , 300234.   , 292803.   , 284545.   , 275471.   ,
 265616.   , 255039.   , 243822.   , 232068.   , 219897.   , 207444.   ,
 194848.   , 189640.   , 177249.   , 165055.   , 153166.   , 141671.   ,
 130643.   , 120136.   , 110189.   , 100826.   ,  92054.2  ,  83874.7  ,
  76277.1  ,  69244.9  ,  62756.4  ,  56786.2  ,  51306.8  ,  46289.4  ,
  41704.   ,  37521.6  ,  33713.1  ,  30250.5  ,  27106.7  ,  24256.2  ,
  21674.5  ,  19338.9  ,  17227.8  ,  15321.4  ,  13601.1  ,  12049.7  ,
  10651.5  ,   9391.96 ,   8257.79 ,   7236.95 ,   6318.53 ,   5492.69 ,
   4750.69 ,   4084.8  ,   3488.34 ,   2955.65 ,   2482.15 ,   2064.36 ,
   1700.05 ,   1388.29 ,   1129.73 ,    926.752}
,
{   570.889,   6306.83 ,  23038.8  ,  52014.2  ,  90346.   , 133486.   ,
 177133.   , 218088.   , 254402.   , 285249.   , 310741.   , 331533.   ,
 348440.   , 362209.   , 373441.   , 382612.   , 390142.   , 396395.   ,
 401665.   , 406179.   , 410082.   , 413465.   , 416386.   , 418899.   ,
 421046.   , 422847.   , 424302.   , 425406.   , 426164.   , 426591.   ,
 426693.   , 426459.   , 425861.   , 424860.   , 423421.   , 421509.   ,
 419080.   , 416075.   , 412423.   , 408046.   , 402871.   , 396827.   ,
 389852.   , 381888.   , 372887.   , 362823.   , 351696.   , 339538.   ,
 326414.   , 312420.   , 297679.   , 282342.   , 266578.   , 250566.   ,
 243751.   , 227912.   , 212282.   , 197006.   , 182208.   , 167991.   ,
 154430.   , 141582.   , 129481.   , 118143.   , 107570.   ,  97751.2  ,
  88666.8  ,  80289.3  ,  72586.3  ,  65522.1  ,  59059.2  ,  53159.1  ,
  47783.1  ,  42893.4  ,  38453.3  ,  34427.4  ,  30782.2  ,  27485.6  ,
  24507.9  ,  21820.9  ,  19398.5  ,  17216.5  ,  15252.5  ,  13485.8  ,
  11897.5  ,  10470.2  ,   9188.19 ,   8037.06 ,   7003.89 ,   6077.06 ,
   5246.23 ,   4502.28 ,   3837.34 ,   3244.72 ,   2718.96 ,   2255.93 ,
   1852.86 ,   1508.53 ,   1223.42 ,   1000.08 }
,
{   750.084,   8269.22 ,  30080.4  ,  67612.6  , 116947.   , 172119.   ,
 227590.   , 279317.   , 324893.   , 363384.   , 395044.   , 420780.   ,
 441659.   , 458625.   , 472431.   , 483683.   , 492916.   , 500588.   ,
 507065.   , 512617.   , 517417.   , 521565.   , 525138.   , 528203.   ,
 530805.   , 532963.   , 534673.   , 535929.   , 536746.   , 537141.   ,
 537114.   , 536642.   , 535682.   , 534184.   , 532101.   , 529386.   ,
 525973.   , 521777.   , 516701.   , 510643.   , 503510.   , 495216.   ,
 485681.   , 474835.   , 462629.   , 449048.   , 434114.   , 417894.   ,
 400495.   , 382065.   , 362788.   , 342875.   , 322558.   , 313662.   ,
 293436.   , 273413.   , 253790.   , 234740.   , 216403.   , 198888.   ,
 182277.   , 166620.   , 151945.   , 138257.   , 125548.   , 113791.   ,
 102954.   ,  92995.7  ,  83869.4  ,  75526.4  ,  67917.   ,  60990.5  ,
  54697.4  ,  48989.6  ,  43820.7  ,  39146.6  ,  34925.5  ,  31118.3  ,
  27688.1  ,  24600.7  ,  21824.4  ,  19330.   ,  17090.3  ,  15080.7  ,
  13278.4  ,  11662.9  ,  10215.2  ,   8918.51 ,   7757.45 ,   6718.33 ,
   5788.96 ,   4958.64 ,   4218.09 ,   3559.43 ,   2976.23 ,   2463.56 ,
   2018.05 ,   1638.09 ,   1324.03 ,   1078.51 }
,
{   985.006,  10836.2  ,  39250.6  ,  87836.7  , 151293.   , 221809.   ,
 292266.   , 357557.   , 414726.   , 462730.   , 502040.   , 533891.   ,
 559671.   , 580573.   , 597541.   , 611347.   , 622673.   , 632091.   ,
 640055.   , 646888.   , 652789.   , 657875.   , 662243.   , 665976.   ,
 669123.   , 671699.   , 673692.   , 675104.   , 675958.   , 676271.   ,
 676032.   , 675202.   , 673716.   , 671512.   , 668531.   , 664702.   ,
 659928.   , 654090.   , 647055.   , 638696.   , 628897.   , 617548.   ,
 604551.   , 589827.   , 573332.   , 555073.   , 535110.   , 513562.   ,
 490599.   , 466440.   , 441351.   , 415624.   , 389570.   , 378251.   ,
 352622.   , 327428.   , 302904.   , 279248.   , 256616.   , 235121.   ,
 214843.   , 195825.   , 178081.   , 161602.   , 146362.   , 132318.   ,
 119418.   , 107604.   ,  96811.1  ,  86975.4  ,  78030.6  ,  69912.1  ,
  62556.5  ,  55903.2  ,  49894.2  ,  44474.8  ,  39593.4  ,  35201.8  ,
  31255.2  ,  27712.1  ,  24533.9  ,  21685.5  ,  19134.4  ,  16850.8  ,
  14808.   ,  12981.2  ,  11348.2  ,   9888.98 ,   8585.49 ,   7421.61 ,
   6383.03 ,   5457.19 ,   4633.21 ,   3901.86 ,   3255.56 ,   2688.45 ,
   2196.5  ,   1777.63 ,   1432.   ,   1162.35 }
,
{  1292.8 ,  14192.4 ,  51187.2 , 114044.  , 195617.  , 285692.  ,
 375131.  , 457492.  , 529163.  , 589002.  , 637797.  , 677211.  ,
 709038.  , 734787.  , 755640.  , 772582.  , 786479.  , 798048.  ,
 807847.  , 816258.  , 823510.  , 829743.  , 835082.  , 839624.  ,
 843420.  , 846477.  , 848780.  , 850341.  , 851194.  , 851349.  ,
 850778.  , 849416.  , 847177.  , 843983.  , 839752.  , 834380.  ,
 827728.  , 819628.  , 809910.  , 798414.  , 784992.  , 769508.  ,
 751843.  , 731917.  , 709703.  , 685249.  , 658674.  , 630169.  ,
 599996.  , 568476.  , 535978.  , 502900.  , 488112.  , 455345.  ,
 423021.  , 391462.  , 360944.  , 331686.  , 303856.  , 277569.  ,
 252895.  , 229861.  , 208465.  , 188676.  , 170444.  , 153703.  ,
 138378.  , 124387.  , 111646.  , 100069.  ,  89570.8 ,  80069.  ,
  71483.7 ,  63738.8 ,  56762.4 ,  50486.9 ,  44848.8 ,  39789.4 ,
  35254.  ,  31192.4 ,  27558.3 ,  24309.2 ,  21406.3 ,  18814.3 ,
  16501.1 ,  14437.5 ,  12597.3 ,  10956.8 ,   9494.82,   8192.44,
   7032.9 ,   6001.51,   5085.56,   4274.23,   3558.66,   2931.92,
   2389.18,   1927.83,   1547.81,   1251.94}
,
{   1695.83,   18577.4 ,   66715.8 ,  147987.  ,  252787.  ,  367780.  ,
  481251.  ,  585087.  ,  674884.  ,  749448.  ,  810000.  ,  858767.  ,
  898055.  ,  929770.  ,  955395.  ,  976190.  ,  993251.  , 1007470.  ,
 1019530.  , 1029890.  , 1038800.  , 1046430.  , 1052950.  , 1058470.  ,
 1063040.  , 1066640.  , 1069280.  , 1070970.  , 1071760.  , 1071640.  ,
 1070560.  , 1068420.  , 1065110.  , 1060540.  , 1054580.  , 1047070.  ,
 1037830.  , 1026630.  , 1013250.  ,  997481.  ,  979149.  ,  958082.  ,
  934145.  ,  907267.  ,  877460.  ,  844835.  ,  809600.  ,  772055.  ,
  732586.  ,  691649.  ,  649753.  ,  607426.  ,  588662.  ,  547231.  ,
  506643.  ,  467278.  ,  429451.  ,  393400.  ,  359298.  ,  327253.  ,
  297317.  ,  269498.  ,  243762.  ,  220052.  ,  198286.  ,  178369.  ,
  160195.  ,  143656.  ,  128639.  ,  115033.  ,  102730.  ,   91625.  ,
   81617.8 ,   72614.  ,   64524.7 ,   57266.5 ,   50762.2 ,   44940.1 ,
   39734.  ,   35083.2 ,   30932.2 ,   27229.9 ,   23930.2 ,   20991.  ,
   18374.2 ,   16045.5 ,   13973.7 ,   12131.1 ,   10492.9 ,    9036.81,
    7743.4 ,    6595.47,    5578.19,    4678.95,    3887.38,    3195.35,
    2597.11,    2089.44,    1671.98,    1347.61}
,
{   2223.28,   24303.5 ,   86905.4 ,  191928.  ,  326490.  ,  473212.  ,
  617095.  ,  747931.  ,  860374.  ,  953251.  , 1028370.  , 1088710.  ,
 1137200.  , 1176260.  , 1207750.  , 1233280.  , 1254230.  , 1271720.  ,
 1286570.  , 1299320.  , 1310260.  , 1319610.  , 1327570.  , 1334270.  ,
 1339730.  , 1343960.  , 1346940.  , 1348720.  , 1349340.  , 1348780.  ,
 1346940.  , 1343690.  , 1338880.  , 1332380.  , 1324020.  , 1313580.  ,
 1300790.  , 1285340.  , 1266960.  , 1245400.  , 1220430.  , 1191850.  ,
 1159510.  , 1123380.  , 1083530.  , 1040170.  ,  993650.  ,  944408.  ,
  893007.  ,  840084.  ,  786321.  ,  761784.  ,  708751.  ,  656594.  ,
  605843.  ,  556938.  ,  510225.  ,  465959.  ,  424306.  ,  385357.  ,
  349138.  ,  315620.  ,  284737.  ,  256388.  ,  230454.  ,  206801.  ,
  185287.  ,  165766.  ,  148093.  ,  132126.  ,  117727.  ,  104765.  ,
   93115.1 ,   82660.7 ,   73292.  ,   64907.2 ,   57412.1 ,   50719.7 ,
   44750.2 ,   39430.4 ,   34693.7 ,   30479.4 ,   26732.4 ,   23402.7 ,
   20445.4 ,   17819.7 ,   15489.4 ,   13421.7 ,   11587.6 ,    9961.24,
    8519.76,    7243.23,    6114.39,    5118.57,    4243.7 ,    3480.24,
    2821.4 ,    2263.24,    1805.03,    1449.74}
,
{2.91364e+03, 3.17768e+04, 1.13144e+05, 2.48782e+05, 4.21464e+05,
 6.08568e+05, 7.90909e+05, 9.55675e+05, 1.09641e+06, 1.21205e+06,
 1.30523e+06, 1.37986e+06, 1.43971e+06, 1.48781e+06, 1.52651e+06,
 1.55786e+06, 1.58360e+06, 1.60513e+06, 1.62343e+06, 1.63912e+06,
 1.65255e+06, 1.66399e+06, 1.67370e+06, 1.68180e+06, 1.68832e+06,
 1.69323e+06, 1.69655e+06, 1.69835e+06, 1.69865e+06, 1.69740e+06,
 1.69445e+06, 1.68961e+06, 1.68270e+06, 1.67354e+06, 1.66188e+06,
 1.64740e+06, 1.62973e+06, 1.60848e+06, 1.58332e+06, 1.55392e+06,
 1.52001e+06, 1.48134e+06, 1.43779e+06, 1.38938e+06, 1.33630e+06,
 1.27891e+06, 1.21772e+06, 1.15342e+06, 1.08678e+06, 1.01866e+06,
 9.86689e+05, 9.18919e+05, 8.51976e+05, 7.86591e+05, 7.23384e+05,
 6.62852e+05, 6.05368e+05, 5.51190e+05, 5.00465e+05, 4.53255e+05,
 4.09542e+05, 3.69252e+05, 3.32268e+05, 2.98440e+05, 2.67596e+05,
 2.39554e+05, 2.14124e+05, 1.91118e+05, 1.70349e+05, 1.51636e+05,
 1.34807e+05, 1.19696e+05, 1.06151e+05, 9.40267e+04, 8.31889e+04,
 7.35135e+04, 6.48860e+04, 5.72014e+04, 5.03636e+04, 4.42848e+04,
 3.88853e+04, 3.40928e+04, 2.98418e+04, 2.60733e+04, 2.27341e+04,
 1.97765e+04, 1.71577e+04, 1.48395e+04, 1.27879e+04, 1.09727e+04,
 9.36762e+03, 7.94928e+03, 6.69769e+03, 5.59586e+03, 4.62972e+03,
 3.78818e+03, 3.06321e+03, 2.45004e+03, 1.94755e+03, 1.55871e+03}
,
{3.81692e+03, 4.15283e+04, 1.47227e+05, 3.22307e+05, 5.43789e+05,
 7.82264e+05, 1.01321e+06, 1.22060e+06, 1.39665e+06, 1.54059e+06,
 1.65614e+06, 1.74845e+06, 1.82232e+06, 1.88154e+06, 1.92910e+06,
 1.96761e+06, 1.99926e+06, 2.02576e+06, 2.04831e+06, 2.06762e+06,
 2.08410e+06, 2.09811e+06, 2.10993e+06, 2.11970e+06, 2.12744e+06,
 2.13309e+06, 2.13672e+06, 2.13842e+06, 2.13818e+06, 2.13589e+06,
 2.13132e+06, 2.12423e+06, 2.11440e+06, 2.10156e+06, 2.08536e+06,
 2.06534e+06, 2.04100e+06, 2.01187e+06, 1.97751e+06, 1.93754e+06,
 1.89159e+06, 1.83942e+06, 1.78095e+06, 1.71632e+06, 1.64588e+06,
 1.57021e+06, 1.49009e+06, 1.40647e+06, 1.32044e+06, 1.23317e+06,
 1.19251e+06, 1.10672e+06, 1.02257e+06, 9.40928e+05, 8.62502e+05,
 7.87840e+05, 7.17332e+05, 6.51220e+05, 5.89618e+05, 5.32536e+05,
 4.79901e+05, 4.31574e+05, 3.87371e+05, 3.47076e+05, 3.10453e+05,
 2.77260e+05, 2.47247e+05, 2.20172e+05, 1.95797e+05, 1.73894e+05,
 1.54248e+05, 1.36654e+05, 1.20923e+05, 1.06878e+05, 9.43546e+04,
 8.32018e+04, 7.32814e+04, 6.44666e+04, 5.66419e+04, 4.97026e+04,
 4.35534e+04, 3.81085e+04, 3.32903e+04, 2.90290e+04, 2.52621e+04,
 2.19334e+04, 1.89929e+04, 1.63960e+04, 1.41030e+04, 1.20790e+04,
 1.02931e+04, 8.71845e+03, 7.33192e+03, 6.11378e+03, 5.04773e+03,
 4.12087e+03, 3.32378e+03, 2.65075e+03, 2.10013e+03, 1.67492e+03}
,
{4.99821e+03, 5.42458e+04, 1.91479e+05, 4.17351e+05, 7.01271e+05,
 1.00506e+06, 1.29742e+06, 1.55831e+06, 1.77845e+06, 1.95755e+06,
 2.10081e+06, 2.21498e+06, 2.30614e+06, 2.37905e+06, 2.43750e+06,
 2.48482e+06, 2.52376e+06, 2.55641e+06, 2.58420e+06, 2.60794e+06,
 2.62816e+06, 2.64530e+06, 2.65968e+06, 2.67144e+06, 2.68055e+06,
 2.68700e+06, 2.69088e+06, 2.69228e+06, 2.69116e+06, 2.68732e+06,
 2.68043e+06, 2.67020e+06, 2.65632e+06, 2.63843e+06, 2.61598e+06,
 2.58837e+06, 2.55494e+06, 2.51510e+06, 2.46832e+06, 2.41409e+06,
 2.35201e+06, 2.28184e+06, 2.20361e+06, 2.11763e+06, 2.02450e+06,
 1.92512e+06, 1.82062e+06, 1.71234e+06, 1.60177e+06, 1.54877e+06,
 1.43904e+06, 1.33088e+06, 1.22552e+06, 1.12396e+06, 1.02699e+06,
 9.35201e+05, 8.48977e+05, 7.68525e+05, 6.93902e+05, 6.25046e+05,
 5.61801e+05, 5.03946e+05, 4.51209e+05, 4.03291e+05, 3.59876e+05,
 3.20642e+05, 2.85270e+05, 2.53448e+05, 2.24877e+05, 1.99272e+05,
 1.76364e+05, 1.55903e+05, 1.37654e+05, 1.21401e+05, 1.06945e+05,
 9.41026e+04, 8.27068e+04, 7.26055e+04, 6.36604e+04, 5.57461e+04,
 4.87497e+04, 4.25692e+04, 3.71129e+04, 3.22986e+04, 2.80527e+04,
 2.43096e+04, 2.10107e+04, 1.81039e+04, 1.55433e+04, 1.32881e+04,
 1.13027e+04, 9.55598e+03, 8.02116e+03, 6.67549e+03, 5.50013e+03,
 4.48012e+03, 3.60444e+03, 2.86628e+03, 2.26341e+03, 1.79881e+03}
,
{6.54228e+03, 7.08227e+04, 2.48903e+05, 5.40153e+05, 9.03924e+05,
 1.29071e+06, 1.66063e+06, 1.98866e+06, 2.26381e+06, 2.48659e+06,
 2.66417e+06, 2.80537e+06, 2.91786e+06, 3.00761e+06, 3.07946e+06,
 3.13763e+06, 3.18555e+06, 3.22579e+06, 3.26004e+06, 3.28924e+06,
 3.31404e+06, 3.33498e+06, 3.35244e+06, 3.36654e+06, 3.37721e+06,
 3.38447e+06, 3.38848e+06, 3.38929e+06, 3.38680e+06, 3.38068e+06,
 3.37050e+06, 3.35590e+06, 3.33645e+06, 3.31159e+06, 3.28059e+06,
 3.24260e+06, 3.19682e+06, 3.14249e+06, 3.07895e+06, 3.00557e+06,
 2.92191e+06, 2.82782e+06, 2.72349e+06, 2.60951e+06, 2.48686e+06,
 2.35685e+06, 2.22111e+06, 2.08149e+06, 1.93998e+06, 1.87267e+06,
 1.73392e+06, 1.59811e+06, 1.46669e+06, 1.34078e+06, 1.22128e+06,
 1.10878e+06, 1.00364e+06, 9.05984e+05, 8.15798e+05, 7.32916e+05,
 6.57073e+05, 5.87935e+05, 5.25123e+05, 4.68228e+05, 4.16835e+05,
 3.70525e+05, 3.28890e+05, 2.91537e+05, 2.58088e+05, 2.28190e+05,
 2.01510e+05, 1.77740e+05, 1.56593e+05, 1.37805e+05, 1.21134e+05,
 1.06361e+05, 9.32833e+04, 8.17187e+04, 7.15020e+04, 6.24842e+04,
 5.45309e+04, 4.75215e+04, 4.13479e+04, 3.59135e+04, 3.11319e+04,
 2.69262e+04, 2.32281e+04, 1.99772e+04, 1.71199e+04, 1.46091e+04,
 1.24036e+04, 1.04675e+04, 8.76981e+03, 7.28442e+03, 5.98954e+03,
 4.86787e+03, 3.90660e+03, 3.09765e+03, 2.43808e+03, 1.93081e+03}
,
{8.55954e+03, 9.24185e+04, 3.23387e+05, 6.98744e+05, 1.16459e+06,
 1.65681e+06, 2.12463e+06, 2.53688e+06, 2.88063e+06, 3.15767e+06,
 3.37777e+06, 3.55237e+06, 3.69117e+06, 3.80164e+06, 3.88998e+06,
 3.96152e+06, 4.02052e+06, 4.07014e+06, 4.11235e+06, 4.14824e+06,
 4.17864e+06, 4.20422e+06, 4.22538e+06, 4.24220e+06, 4.25460e+06,
 4.26266e+06, 4.26657e+06, 4.26636e+06, 4.26179e+06, 4.25237e+06,
 4.23758e+06, 4.21692e+06, 4.18979e+06, 4.15538e+06, 4.11266e+06,
 4.06055e+06, 3.99801e+06, 3.92412e+06, 3.83801e+06, 3.73897e+06,
 3.62656e+06, 3.50078e+06, 3.36212e+06, 3.21158e+06, 3.05064e+06,
 2.88123e+06, 2.70562e+06, 2.52634e+06, 2.43858e+06, 2.26096e+06,
 2.08621e+06, 1.91632e+06, 1.75295e+06, 1.59740e+06, 1.45059e+06,
 1.31309e+06, 1.18519e+06, 1.06694e+06, 9.58186e+05, 8.58617e+05,
 7.67830e+05, 6.85348e+05, 6.10649e+05, 5.43195e+05, 4.82441e+05,
 4.27851e+05, 3.78906e+05, 3.35111e+05, 2.95997e+05, 2.61125e+05,
 2.30086e+05, 2.02500e+05, 1.78019e+05, 1.56322e+05, 1.37118e+05,
 1.20139e+05, 1.05145e+05, 9.19176e+04, 8.02592e+04, 6.99929e+04,
 6.09597e+04, 5.30171e+04, 4.60378e+04, 3.99083e+04, 3.45276e+04,
 2.98060e+04, 2.56638e+04, 2.20307e+04, 1.88448e+04, 1.60516e+04,
 1.36034e+04, 1.14590e+04, 9.58260e+03, 7.94420e+03, 6.51872e+03,
 5.28620e+03, 4.23177e+03, 3.34589e+03, 2.62484e+03, 2.07142e+03}
,
{1.11937e+04, 1.20541e+05, 4.19961e+05, 9.03466e+05, 1.49974e+06,
 2.12582e+06, 2.71714e+06, 3.23499e+06, 3.66428e+06, 4.00870e+06,
 4.28148e+06, 4.49736e+06, 4.66859e+06, 4.80458e+06, 4.91321e+06,
 5.00121e+06, 5.07391e+06, 5.13511e+06, 5.18712e+06, 5.23123e+06,
 5.26847e+06, 5.29968e+06, 5.32526e+06, 5.34524e+06, 5.35952e+06,
 5.36829e+06, 5.37176e+06, 5.36988e+06, 5.36222e+06, 5.34811e+06,
 5.32686e+06, 5.29784e+06, 5.26017e+06, 5.21268e+06, 5.15397e+06,
 5.08267e+06, 4.99747e+06, 4.89720e+06, 4.78079e+06, 4.64746e+06,
 4.49686e+06, 4.32925e+06, 4.14559e+06, 3.94746e+06, 3.73707e+06,
 3.51718e+06, 3.29092e+06, 3.06163e+06, 2.95028e+06, 2.72586e+06,
 2.50659e+06, 2.29481e+06, 2.09243e+06, 1.90084e+06, 1.72098e+06,
 1.55337e+06, 1.39818e+06, 1.25530e+06, 1.12440e+06, 1.00500e+06,
 8.96511e+05, 7.98262e+05, 7.09557e+05, 6.29693e+05, 5.57966e+05,
 4.93693e+05, 4.36223e+05, 3.84934e+05, 3.39245e+05, 2.98615e+05,
 2.62541e+05, 2.30560e+05, 2.02248e+05, 1.77216e+05, 1.55113e+05,
 1.35618e+05, 1.18443e+05, 1.03326e+05, 9.00341e+04, 7.83564e+04,
 6.81052e+04, 5.91125e+04, 5.12287e+04, 4.43209e+04, 3.82708e+04,
 3.29739e+04, 2.83378e+04, 2.42808e+04, 2.07311e+04, 1.76260e+04,
 1.49104e+04, 1.25370e+04, 1.04646e+04, 8.65876e+03, 7.09065e+03,
 5.73731e+03, 4.58153e+03, 3.61213e+03, 2.82444e+03, 2.22111e+03}
,
{1.46316e+04, 1.57153e+05, 5.45116e+05, 1.16763e+06, 1.93047e+06,
 2.72643e+06, 3.47351e+06, 4.12370e+06, 4.65960e+06, 5.08769e+06,
 5.42572e+06, 5.69262e+06, 5.90383e+06, 6.07123e+06, 6.20485e+06,
 6.31316e+06, 6.40277e+06, 6.47827e+06, 6.54234e+06, 6.59653e+06,
 6.64215e+06, 6.68017e+06, 6.71101e+06, 6.73459e+06, 6.75088e+06,
 6.76017e+06, 6.76267e+06, 6.75817e+06, 6.74599e+06, 6.72523e+06,
 6.69505e+06, 6.65452e+06, 6.60239e+06, 6.53701e+06, 6.45654e+06,
 6.35922e+06, 6.24343e+06, 6.10768e+06, 5.95071e+06, 5.77170e+06,
 5.57051e+06, 5.34789e+06, 5.10544e+06, 4.84561e+06, 4.57162e+06,
 4.28732e+06, 3.99694e+06, 3.85176e+06, 3.56431e+06, 3.28182e+06,
 3.00766e+06, 2.74456e+06, 2.49463e+06, 2.25934e+06, 2.03958e+06,
 1.83575e+06, 1.64785e+06, 1.47556e+06, 1.31831e+06, 1.17538e+06,
 1.04593e+06, 9.29065e+05, 8.23875e+05, 7.29439e+05, 6.44860e+05,
 5.69277e+05, 5.01871e+05, 4.41871e+05, 3.88559e+05, 3.41269e+05,
 2.99385e+05, 2.62344e+05, 2.29632e+05, 2.00780e+05, 1.75363e+05,
 1.52999e+05, 1.33342e+05, 1.16082e+05, 1.00940e+05, 8.76676e+04,
 7.60436e+04, 6.58701e+04, 5.69716e+04, 4.91925e+04, 4.23950e+04,
 3.64574e+04, 3.12722e+04, 2.67450e+04, 2.27929e+04, 1.93435e+04,
 1.63336e+04, 1.37085e+04, 1.14213e+04, 9.43227e+03, 7.70849e+03,
 6.22354e+03, 4.95759e+03, 3.89755e+03, 3.03769e+03, 2.38041e+03}
,
{1.91165e+04, 2.04796e+05, 7.07234e+05, 1.50834e+06, 2.48381e+06,
 3.49527e+06, 4.43872e+06, 5.25470e+06, 5.92342e+06, 6.45539e+06,
 6.87423e+06, 7.20419e+06, 7.46471e+06, 7.67077e+06, 7.83516e+06,
 7.96852e+06, 8.07904e+06, 8.17219e+06, 8.25109e+06, 8.31764e+06,
 8.37350e+06, 8.41976e+06, 8.45680e+06, 8.48446e+06, 8.50281e+06,
 8.51228e+06, 8.51299e+06, 8.50451e+06, 8.48582e+06, 8.45575e+06,
 8.41320e+06, 8.35687e+06, 8.28496e+06, 8.19518e+06, 8.08515e+06,
 7.95265e+06, 7.79565e+06, 7.61230e+06, 7.40114e+06, 7.16144e+06,
 6.89350e+06, 6.59876e+06, 6.27981e+06, 5.94029e+06, 5.58481e+06,
 5.21863e+06, 4.84740e+06, 4.66328e+06, 4.30023e+06, 3.94593e+06,
 3.60430e+06, 3.27848e+06, 2.97073e+06, 2.68254e+06, 2.41469e+06,
 2.16739e+06, 1.94036e+06, 1.73298e+06, 1.54440e+06, 1.37356e+06,
 1.21932e+06, 1.08051e+06, 9.55932e+05, 8.44400e+05, 7.44782e+05,
 6.55997e+05, 5.77022e+05, 5.06906e+05, 4.44761e+05, 3.89773e+05,
 3.41190e+05, 2.98329e+05, 2.60567e+05, 2.27341e+05, 1.98141e+05,
 1.72507e+05, 1.50029e+05, 1.30337e+05, 1.13101e+05, 9.80293e+04,
 8.48589e+04, 7.33585e+04, 6.33223e+04, 5.45687e+04, 4.69370e+04,
 4.02859e+04, 3.44908e+04, 2.94426e+04, 2.50456e+04, 2.12164e+04,
 1.78825e+04, 1.49811e+04, 1.24585e+04, 1.02692e+04, 8.37564e+03,
 6.74742e+03, 5.36175e+03, 4.20341e+03, 3.26541e+03, 2.54988e+03}
,
{2.49676e+04, 2.66765e+05, 9.17145e+05, 1.94759e+06, 3.19439e+06,
 4.47910e+06, 5.66999e+06, 6.69357e+06, 7.52776e+06, 8.18869e+06,
 8.70759e+06, 9.11548e+06, 9.43678e+06, 9.69045e+06, 9.89277e+06,
 1.00571e+07, 1.01934e+07, 1.03084e+07, 1.04055e+07, 1.04872e+07,
 1.05555e+07, 1.06117e+07, 1.06560e+07, 1.06882e+07, 1.07086e+07,
 1.07177e+07, 1.07154e+07, 1.07010e+07, 1.06730e+07, 1.06300e+07,
 1.05704e+07, 1.04924e+07, 1.03935e+07, 1.02705e+07, 1.01204e+07,
 9.94045e+06, 9.72805e+06, 9.48097e+06, 9.19761e+06, 8.87756e+06,
 8.52179e+06, 8.13285e+06, 7.71469e+06, 7.27264e+06, 6.81313e+06,
 6.34329e+06, 6.10335e+06, 5.63812e+06, 5.18126e+06, 4.73838e+06,
 4.31406e+06, 3.91175e+06, 3.53385e+06, 3.18176e+06, 2.85605e+06,
 2.55661e+06, 2.28282e+06, 2.03365e+06, 1.80784e+06, 1.60394e+06,
 1.42044e+06, 1.25577e+06, 1.10840e+06, 9.76827e+05, 8.59626e+05,
 7.55443e+05, 6.63011e+05, 5.81153e+05, 5.08783e+05, 4.44903e+05,
 3.88602e+05, 3.39051e+05, 2.95499e+05, 2.57269e+05, 2.23749e+05,
 1.94392e+05, 1.68708e+05, 1.46260e+05, 1.26658e+05, 1.09555e+05,
 9.46438e+04, 8.16530e+04, 7.03421e+04, 6.04990e+04, 5.19369e+04,
 4.44918e+04, 3.80196e+04, 3.23943e+04, 2.75056e+04, 2.32578e+04,
 1.95674e+04, 1.63628e+04, 1.35825e+04, 1.11745e+04, 9.09571e+03,
 7.31160e+03, 5.79592e+03, 4.53104e+03, 3.50850e+03, 2.73006e+03}
,
{3.25989e+04, 3.47326e+05, 1.18884e+06, 2.51367e+06, 4.10654e+06,
 5.73760e+06, 7.24013e+06, 8.52355e+06, 9.56384e+06, 1.03848e+07,
 1.10277e+07, 1.15318e+07, 1.19281e+07, 1.22404e+07, 1.24895e+07,
 1.26919e+07, 1.28602e+07, 1.30021e+07, 1.31216e+07, 1.32219e+07,
 1.33054e+07, 1.33735e+07, 1.34263e+07, 1.34635e+07, 1.34857e+07,
 1.34934e+07, 1.34864e+07, 1.34633e+07, 1.34222e+07, 1.33612e+07,
 1.32782e+07, 1.31707e+07, 1.30349e+07, 1.28668e+07, 1.26626e+07,
 1.24187e+07, 1.21320e+07, 1.17998e+07, 1.14205e+07, 1.09944e+07,
 1.05235e+07, 1.00119e+07, 9.46553e+06, 8.89204e+06, 8.30025e+06,
 7.69963e+06, 7.39531e+06, 6.80782e+06, 6.23486e+06, 5.68306e+06,
 5.15761e+06, 4.66226e+06, 4.19940e+06, 3.77024e+06, 3.37501e+06,
 3.01314e+06, 2.68353e+06, 2.38463e+06, 2.11465e+06, 1.87163e+06,
 1.65357e+06, 1.45847e+06, 1.28434e+06, 1.12930e+06, 9.91554e+05,
 8.69427e+05, 7.61350e+05, 6.65876e+05, 5.81676e+05, 5.07535e+05,
 4.42347e+05, 3.85112e+05, 3.34925e+05, 2.90973e+05, 2.52527e+05,
 2.18933e+05, 1.89610e+05, 1.64040e+05, 1.41762e+05, 1.22369e+05,
 1.05500e+05, 9.08365e+04, 7.80980e+04, 6.70376e+04, 5.74384e+04,
 4.91103e+04, 4.18869e+04, 3.56226e+04, 3.01910e+04, 2.54817e+04,
 2.13996e+04, 1.78624e+04, 1.48000e+04, 1.21531e+04, 9.87257e+03,
 7.91894e+03, 6.26215e+03, 4.88183e+03, 3.76786e+03, 2.92155e+03}
,
{4.25480e+04, 4.52017e+05, 1.54034e+06, 3.24290e+06, 5.27700e+06,
 7.34688e+06, 9.24177e+06, 1.08503e+07, 1.21472e+07, 1.31668e+07,
 1.39631e+07, 1.45863e+07, 1.50749e+07, 1.54595e+07, 1.57662e+07,
 1.60159e+07, 1.62237e+07, 1.63986e+07, 1.65457e+07, 1.66688e+07,
 1.67708e+07, 1.68531e+07, 1.69156e+07, 1.69582e+07, 1.69817e+07,
 1.69867e+07, 1.69724e+07, 1.69368e+07, 1.68772e+07, 1.67914e+07,
 1.66765e+07, 1.65285e+07, 1.63426e+07, 1.61134e+07, 1.58361e+07,
 1.55064e+07, 1.51202e+07, 1.46746e+07, 1.41683e+07, 1.36026e+07,
 1.29811e+07, 1.23104e+07, 1.15991e+07, 1.08577e+07, 1.00983e+07,
 9.70207e+06, 8.94911e+06, 8.20978e+06, 7.49357e+06, 6.80816e+06,
 6.15932e+06, 5.55101e+06, 4.98544e+06, 4.46348e+06, 3.98482e+06,
 3.54830e+06, 3.15213e+06, 2.79411e+06, 2.47175e+06, 2.18249e+06,
 1.92369e+06, 1.69278e+06, 1.48726e+06, 1.30475e+06, 1.14303e+06,
 1.00001e+06, 8.73760e+05, 7.62508e+05, 6.64632e+05, 5.78657e+05,
 5.03245e+05, 4.37190e+05, 3.79404e+05, 3.28915e+05, 2.84853e+05,
 2.46441e+05, 2.12989e+05, 1.83884e+05, 1.58584e+05, 1.36611e+05,
 1.17540e+05, 1.01000e+05, 8.66637e+04, 7.42440e+04, 6.34894e+04,
 5.41798e+04, 4.61232e+04, 3.91521e+04, 3.31210e+04, 2.79037e+04,
 2.33910e+04, 1.94892e+04, 1.61182e+04, 1.32106e+04, 1.07103e+04,
 8.57244e+03, 6.76257e+03, 5.25724e+03, 4.04446e+03, 3.12495e+03}
,
{5.55132e+04, 5.88030e+05, 1.99491e+06, 4.18195e+06, 6.77835e+06,
 9.40399e+06, 1.17927e+07, 1.38078e+07, 1.54243e+07, 1.66903e+07,
 1.76767e+07, 1.84469e+07, 1.90494e+07, 1.95230e+07, 1.99008e+07,
 2.02089e+07, 2.04655e+07, 2.06812e+07, 2.08622e+07, 2.10131e+07,
 2.11375e+07, 2.12367e+07, 2.13103e+07, 2.13586e+07, 2.13825e+07,
 2.13826e+07, 2.13574e+07, 2.13039e+07, 2.12187e+07, 2.10988e+07,
 2.09401e+07, 2.07371e+07, 2.04830e+07, 2.01713e+07, 1.97957e+07,
 1.93508e+07, 1.88318e+07, 1.82354e+07, 1.75614e+07, 1.68125e+07,
 1.59951e+07, 1.51186e+07, 1.41955e+07, 1.32405e+07, 1.22695e+07,
 1.17667e+07, 1.08157e+07, 9.88839e+06, 8.99589e+06, 8.14699e+06,
 7.34794e+06, 6.60269e+06, 5.91316e+06, 5.27960e+06, 4.70097e+06,
 4.17527e+06, 3.69983e+06, 3.27157e+06, 2.88720e+06, 2.54330e+06,
 2.23650e+06, 1.96351e+06, 1.72118e+06, 1.50657e+06, 1.31687e+06,
 1.14954e+06, 1.00220e+06, 8.72673e+05, 7.58999e+05, 6.59385e+05,
 5.72217e+05, 4.96044e+05, 4.29562e+05, 3.71609e+05, 3.21150e+05,
 2.77261e+05, 2.39126e+05, 2.06023e+05, 1.77312e+05, 1.52432e+05,
 1.30887e+05, 1.12243e+05, 9.61198e+04, 8.21832e+04, 7.01420e+04,
 5.97420e+04, 5.07619e+04, 4.30092e+04, 3.63167e+04, 3.05401e+04,
 2.55545e+04, 2.12532e+04, 1.75449e+04, 1.43528e+04, 1.16134e+04,
 9.27532e+03, 7.29946e+03, 5.65883e+03, 4.33929e+03, 3.34087e+03}
,
{7.24017e+04, 7.64664e+05, 2.58254e+06, 5.39069e+06, 8.70344e+06,
 1.20327e+07, 1.50426e+07, 1.75662e+07, 1.95803e+07, 2.11521e+07,
 2.23739e+07, 2.33257e+07, 2.40686e+07, 2.46519e+07, 2.51175e+07,
 2.54978e+07, 2.58147e+07, 2.60807e+07, 2.63032e+07, 2.64882e+07,
 2.66397e+07, 2.67589e+07, 2.68451e+07, 2.68989e+07, 2.69219e+07,
 2.69140e+07, 2.68727e+07, 2.67938e+07, 2.66732e+07, 2.65066e+07,
 2.62882e+07, 2.60103e+07, 2.56639e+07, 2.52407e+07, 2.47331e+07,
 2.41340e+07, 2.34380e+07, 2.26420e+07, 2.17470e+07, 2.07586e+07,
 1.96866e+07, 1.85450e+07, 1.73513e+07, 1.61253e+07, 1.54716e+07,
 1.42530e+07, 1.30558e+07, 1.18963e+07, 1.07874e+07, 9.73880e+06,
 8.75724e+06, 7.84633e+06, 7.00739e+06, 6.23982e+06, 5.54151e+06,
 4.90938e+06, 4.33962e+06, 3.82804e+06, 3.37026e+06, 2.96187e+06,
 2.59855e+06, 2.27615e+06, 1.99073e+06, 1.73858e+06, 1.51629e+06,
 1.32069e+06, 1.14888e+06, 9.98210e+05, 8.66298e+05, 7.50976e+05,
 6.50301e+05, 5.62528e+05, 4.86100e+05, 4.19631e+05, 3.61887e+05,
 3.11778e+05, 2.68336e+05, 2.30711e+05, 1.98152e+05, 1.70000e+05,
 1.45677e+05, 1.24676e+05, 1.06555e+05, 9.09260e+04, 7.74530e+04,
 6.58424e+04, 5.58392e+04, 4.72225e+04, 3.98008e+04, 3.34087e+04,
 2.79042e+04, 2.31653e+04, 1.90883e+04, 1.55861e+04, 1.25864e+04,
 1.00310e+04, 7.87519e+03, 6.08819e+03, 4.65337e+03, 3.56993e+03}
,
{9.43915e+04, 9.93952e+05, 3.34191e+06, 6.94604e+06, 1.11710e+07,
 1.53908e+07, 1.91818e+07, 2.23409e+07, 2.48499e+07, 2.68011e+07,
 2.83143e+07, 2.94905e+07, 3.04064e+07, 3.11251e+07, 3.16991e+07,
 3.21686e+07, 3.25601e+07, 3.28881e+07, 3.31616e+07, 3.33882e+07,
 3.35724e+07, 3.37149e+07, 3.38151e+07, 3.38742e+07, 3.38939e+07,
 3.38734e+07, 3.38087e+07, 3.36943e+07, 3.35248e+07, 3.32944e+07,
 3.29947e+07, 3.26150e+07, 3.21439e+07, 3.15707e+07, 3.08860e+07,
 3.00810e+07, 2.91496e+07, 2.80897e+07, 2.69047e+07, 2.56040e+07,
 2.42026e+07, 2.27205e+07, 2.11820e+07, 1.96136e+07, 1.87835e+07,
 1.72436e+07, 1.57414e+07, 1.42958e+07, 1.29219e+07, 1.16300e+07,
 1.04270e+07, 9.31600e+06, 8.29724e+06, 7.36891e+06, 6.52752e+06,
 5.76850e+06, 5.08660e+06, 4.47624e+06, 3.93166e+06, 3.44722e+06,
 3.01742e+06, 2.63704e+06, 2.30116e+06, 2.00521e+06, 1.74494e+06,
 1.51649e+06, 1.31632e+06, 1.14120e+06, 9.88250e+05, 8.54849e+05,
 7.38662e+05, 6.37600e+05, 5.49804e+05, 4.73622e+05, 4.07591e+05,
 3.50419e+05, 3.00967e+05, 2.58232e+05, 2.21334e+05, 1.89502e+05,
 1.62060e+05, 1.38419e+05, 1.18065e+05, 1.00550e+05, 8.54845e+04,
 7.25303e+04, 6.13944e+04, 5.18232e+04, 4.35976e+04, 3.65288e+04,
 3.04548e+04, 2.52369e+04, 2.07573e+04, 1.69171e+04, 1.36343e+04,
 1.08429e+04, 8.49228e+03, 6.54700e+03, 4.98776e+03, 3.81274e+03}
,
{1.23011e+05, 1.29146e+06, 4.32282e+06, 8.94665e+06, 1.43329e+07,
 1.96791e+07, 2.44519e+07, 2.84052e+07, 3.15300e+07, 3.39521e+07,
 3.58259e+07, 3.72792e+07, 3.84085e+07, 3.92942e+07, 4.00022e+07,
 4.05821e+07, 4.10657e+07, 4.14698e+07, 4.18061e+07, 4.20835e+07,
 4.23069e+07, 4.24767e+07, 4.25922e+07, 4.26555e+07, 4.26684e+07,
 4.26287e+07, 4.25305e+07, 4.23665e+07, 4.21300e+07, 4.18125e+07,
 4.14022e+07, 4.08846e+07, 4.02451e+07, 3.94705e+07, 3.85487e+07,
 3.74693e+07, 3.62258e+07, 3.48181e+07, 3.32535e+07, 3.15469e+07,
 2.97204e+07, 2.78026e+07, 2.58263e+07, 2.47490e+07, 2.27769e+07,
 2.08374e+07, 1.89580e+07, 1.71610e+07, 1.54630e+07, 1.38753e+07,
 1.24042e+07, 1.10517e+07, 9.81679e+06, 8.69584e+06, 7.68353e+06,
 6.77337e+06, 5.95832e+06, 5.23091e+06, 4.58379e+06, 4.00972e+06,
 3.50178e+06, 3.05342e+06, 2.65853e+06, 2.31146e+06, 2.00700e+06,
 1.74041e+06, 1.50738e+06, 1.30401e+06, 1.12680e+06, 9.72601e+05,
 8.38613e+05, 7.22336e+05, 6.21553e+05, 5.34301e+05, 4.58846e+05,
 3.93662e+05, 3.37406e+05, 2.88900e+05, 2.47112e+05, 2.11141e+05,
 1.80201e+05, 1.53605e+05, 1.30758e+05, 1.11140e+05, 9.43041e+04,
 7.98595e+04, 6.74699e+04, 5.68448e+04, 4.77336e+04, 3.99211e+04,
 3.32225e+04, 2.74805e+04, 2.25614e+04, 1.83529e+04, 1.47624e+04,
 1.17150e+04, 9.15332e+03, 7.03697e+03, 5.34351e+03, 4.06993e+03}
,
{1.60244e+05, 1.67733e+06, 5.58944e+06, 1.15191e+07, 1.83829e+07,
 2.51536e+07, 3.11602e+07, 3.61058e+07, 3.99964e+07, 4.30028e+07,
 4.53231e+07, 4.71186e+07, 4.85111e+07, 4.96027e+07, 5.04763e+07,
 5.11929e+07, 5.17902e+07, 5.22883e+07, 5.27013e+07, 5.30406e+07,
 5.33110e+07, 5.35122e+07, 5.36440e+07, 5.37097e+07, 5.37103e+07,
 5.36421e+07, 5.34963e+07, 5.32638e+07, 5.29355e+07, 5.24994e+07,
 5.19388e+07, 5.12347e+07, 5.03687e+07, 4.93239e+07, 4.80853e+07,
 4.66409e+07, 4.49847e+07, 4.31199e+07, 4.10598e+07, 3.88273e+07,
 3.64544e+07, 3.39807e+07, 3.14504e+07, 3.00808e+07, 2.75872e+07,
 2.51517e+07, 2.28073e+07, 2.05793e+07, 1.84862e+07, 1.65392e+07,
 1.47437e+07, 1.31004e+07, 1.16059e+07, 1.02545e+07, 9.03817e+06,
 7.94819e+06, 6.97504e+06, 6.10913e+06, 5.34095e+06, 4.66135e+06,
 4.06161e+06, 3.53360e+06, 3.06975e+06, 2.66307e+06, 2.30721e+06,
 1.99637e+06, 1.72530e+06, 1.48930e+06, 1.28414e+06, 1.10603e+06,
 9.51629e+05, 8.17942e+05, 7.02332e+05, 6.02470e+05, 5.16305e+05,
 4.42035e+05, 3.78081e+05, 3.23059e+05, 2.75764e+05, 2.35143e+05,
 2.00280e+05, 1.70378e+05, 1.44748e+05, 1.22789e+05, 1.03985e+05,
 8.78885e+04, 7.41121e+04, 6.23238e+04, 5.22375e+04, 4.36077e+04,
 3.62246e+04, 2.99093e+04, 2.45105e+04, 1.99010e+04, 1.59761e+04,
 1.26511e+04, 9.86101e+03, 7.55986e+03, 5.72167e+03, 4.34204e+03}
,
{2.08680e+05, 2.17770e+06, 7.22433e+06, 1.48255e+07, 2.35691e+07,
 3.21403e+07, 3.96968e+07, 4.58817e+07, 5.07249e+07, 5.44559e+07,
 5.73290e+07, 5.95471e+07, 6.12643e+07, 6.26102e+07, 6.36885e+07,
 6.45742e+07, 6.53119e+07, 6.59254e+07, 6.64328e+07, 6.68471e+07,
 6.71735e+07, 6.74106e+07, 6.75594e+07, 6.76241e+07, 6.76047e+07,
 6.74947e+07, 6.72820e+07, 6.69550e+07, 6.65014e+07, 6.59040e+07,
 6.51398e+07, 6.41840e+07, 6.30134e+07, 6.16070e+07, 5.99460e+07,
 5.80172e+07, 5.58165e+07, 5.33528e+07, 5.06479e+07, 4.77360e+07,
 4.46627e+07, 4.14822e+07, 3.82530e+07, 3.65190e+07, 3.33755e+07,
 3.03263e+07, 2.74097e+07, 2.46545e+07, 2.20801e+07, 1.96975e+07,
 1.75105e+07, 1.55171e+07, 1.37114e+07, 1.20842e+07, 1.06248e+07,
 9.32094e+06, 8.16039e+06, 7.13066e+06, 6.21967e+06, 5.41587e+06,
 4.70841e+06, 4.08714e+06, 3.54273e+06, 3.06661e+06, 2.65099e+06,
 2.28883e+06, 1.97376e+06, 1.70010e+06, 1.46275e+06, 1.25718e+06,
 1.07937e+06, 9.25771e+05, 7.93243e+05, 6.79025e+05, 5.80694e+05,
 4.96127e+05, 4.23468e+05, 3.61096e+05, 3.07601e+05, 2.61756e+05,
 2.22496e+05, 1.88898e+05, 1.60162e+05, 1.35598e+05, 1.14609e+05,
 9.66807e+04, 8.13711e+04, 6.82996e+04, 5.71400e+04, 4.76128e+04,
 3.94796e+04, 3.25376e+04, 2.66154e+04, 2.15695e+04, 1.72813e+04,
 1.36554e+04, 1.06181e+04, 8.11744e+03, 6.12327e+03, 4.62956e+03}
,
{2.71681e+05, 2.82628e+06, 9.33391e+06, 1.90741e+07, 3.02078e+07,
 4.10543e+07, 5.05569e+07, 5.82891e+07, 6.43171e+07, 6.89470e+07,
 7.25043e+07, 7.52443e+07, 7.73621e+07, 7.90220e+07, 8.03537e+07,
 8.14485e+07, 8.23594e+07, 8.31150e+07, 8.37379e+07, 8.42434e+07,
 8.46360e+07, 8.49138e+07, 8.50793e+07, 8.51376e+07, 8.50869e+07,
 8.49164e+07, 8.46102e+07, 8.41537e+07, 8.35294e+07, 8.27129e+07,
 8.16732e+07, 8.03784e+07, 7.87993e+07, 7.69095e+07, 7.46865e+07,
 7.21164e+07, 6.91995e+07, 6.59531e+07, 6.24114e+07, 5.86246e+07,
 5.46565e+07, 5.05801e+07, 4.83233e+07, 4.42852e+07, 4.03344e+07,
 3.65273e+07, 3.29082e+07, 2.95091e+07, 2.63498e+07, 2.34399e+07,
 2.07805e+07, 1.83665e+07, 1.61878e+07, 1.42313e+07, 1.24822e+07,
 1.09243e+07, 9.54165e+06, 8.31832e+06, 7.23898e+06, 6.28917e+06,
 5.45533e+06, 4.72495e+06, 4.08651e+06, 3.52953e+06, 3.04451e+06,
 2.62287e+06, 2.25693e+06, 1.93982e+06, 1.66542e+06, 1.42831e+06,
 1.22370e+06, 1.04734e+06, 8.95519e+05, 7.64966e+05, 6.52824e+05,
 5.56593e+05, 4.74094e+05, 4.03433e+05, 3.42963e+05, 2.91253e+05,
 2.47069e+05, 2.09339e+05, 1.77141e+05, 1.49677e+05, 1.26262e+05,
 1.06305e+05, 8.93012e+04, 7.48147e+04, 6.24742e+04, 5.19620e+04,
 4.30073e+04, 3.53804e+04, 2.88876e+04, 2.33667e+04, 1.86841e+04,
 1.47321e+04, 1.14276e+04, 8.71147e+03, 6.54923e+03, 4.93290e+03}
,
{3.53596e+05, 3.66668e+06, 1.20551e+07, 2.45313e+07, 3.87034e+07,
 5.24239e+07, 6.43693e+07, 7.40329e+07, 8.15343e+07, 8.72792e+07,
 9.16834e+07, 9.50680e+07, 9.76801e+07, 9.97277e+07, 1.01373e+08,
 1.02727e+08, 1.03851e+08, 1.04781e+08, 1.05546e+08, 1.06162e+08,
 1.06632e+08, 1.06955e+08, 1.07136e+08, 1.07180e+08, 1.07081e+08,
 1.06824e+08, 1.06389e+08, 1.05755e+08, 1.04898e+08, 1.03785e+08,
 1.02373e+08, 1.00623e+08, 9.84965e+07, 9.59619e+07, 9.29925e+07,
 8.95755e+07, 8.57188e+07, 8.14524e+07, 7.68282e+07, 7.19183e+07,
 6.68105e+07, 6.16021e+07, 5.87401e+07, 5.36444e+07, 4.86929e+07,
 4.39522e+07, 3.94726e+07, 3.52885e+07, 3.14191e+07, 2.78717e+07,
 2.46434e+07, 2.17242e+07, 1.90990e+07, 1.67495e+07, 1.46555e+07,
 1.27961e+07, 1.11505e+07, 9.69852e+06, 8.42088e+06, 7.29949e+06,
 6.31754e+06, 5.45957e+06, 4.71145e+06, 4.06038e+06, 3.49477e+06,
 3.00424e+06, 2.57952e+06, 2.21232e+06, 1.89532e+06, 1.62202e+06,
 1.38671e+06, 1.18435e+06, 1.01054e+06, 8.61410e+05, 7.33595e+05,
 6.24158e+05, 5.30546e+05, 4.50542e+05, 3.82226e+05, 3.23936e+05,
 2.74238e+05, 2.31893e+05, 1.95835e+05, 1.65146e+05, 1.39039e+05,
 1.16837e+05, 9.79612e+04, 8.19153e+04, 6.82762e+04, 5.66830e+04,
 4.68288e+04, 3.84538e+04, 3.13390e+04, 2.53015e+04, 2.01908e+04,
 1.58855e+04, 1.22921e+04, 9.34359e+03, 7.00039e+03, 5.25232e+03}
,
{4.60064e+05, 4.75517e+06, 1.55638e+07, 3.15389e+07, 4.95719e+07,
 6.69212e+07, 8.19322e+07, 9.40062e+07, 1.03339e+08, 1.10467e+08,
 1.15920e+08, 1.20100e+08, 1.23323e+08, 1.25849e+08, 1.27883e+08,
 1.29557e+08, 1.30945e+08, 1.32090e+08, 1.33027e+08, 1.33776e+08,
 1.34337e+08, 1.34711e+08, 1.34903e+08, 1.34919e+08, 1.34750e+08,
 1.34371e+08, 1.33756e+08, 1.32881e+08, 1.31709e+08, 1.30194e+08,
 1.28280e+08, 1.25918e+08, 1.23061e+08, 1.19668e+08, 1.15709e+08,
 1.11177e+08, 1.06090e+08, 1.00498e+08, 9.44774e+07, 8.81299e+07,
 8.15749e+07, 7.78616e+07, 7.13248e+07, 6.49130e+07, 5.87241e+07,
 5.28357e+07, 4.73039e+07, 4.21642e+07, 3.74343e+07, 3.31170e+07,
 2.92040e+07, 2.56789e+07, 2.25198e+07, 1.97015e+07, 1.71974e+07,
 1.49803e+07, 1.30236e+07, 1.13018e+07, 9.79072e+06, 8.46785e+06,
 7.31241e+06, 6.30535e+06, 5.42938e+06, 4.66887e+06, 4.00976e+06,
 3.43950e+06, 2.94689e+06, 2.52198e+06, 2.15600e+06, 1.84119e+06,
 1.57075e+06, 1.33871e+06, 1.13984e+06, 9.69600e+05, 8.24011e+05,
 6.99631e+05, 5.93469e+05, 5.02940e+05, 4.25806e+05, 3.60136e+05,
 3.04268e+05, 2.56769e+05, 2.16411e+05, 1.82138e+05, 1.53045e+05,
 1.28358e+05, 1.07415e+05, 8.96509e+04, 7.45843e+04, 6.18056e+04,
 5.09670e+04, 4.17750e+04, 3.39824e+04, 2.73831e+04, 2.18079e+04,
 1.71202e+04, 1.32146e+04, 1.00154e+04, 7.47743e+03, 5.58794e+03}
,
{5.98397e+05, 6.16448e+06, 2.00866e+07, 4.05342e+07, 6.34716e+07,
 8.54016e+07, 1.04259e+08, 1.19340e+08, 1.30950e+08, 1.39794e+08,
 1.46544e+08, 1.51707e+08, 1.55682e+08, 1.58802e+08, 1.61315e+08,
 1.63386e+08, 1.65098e+08, 1.66508e+08, 1.67656e+08, 1.68564e+08,
 1.69232e+08, 1.69659e+08, 1.69856e+08, 1.69827e+08, 1.69553e+08,
 1.69003e+08, 1.68143e+08, 1.66938e+08, 1.65339e+08, 1.63281e+08,
 1.60693e+08, 1.57511e+08, 1.53678e+08, 1.49144e+08, 1.43877e+08,
 1.37879e+08, 1.31187e+08, 1.23877e+08, 1.16060e+08, 1.07878e+08,
 9.94914e+07, 9.47737e+07, 8.65142e+07, 7.84685e+07, 7.07530e+07,
 6.34566e+07, 5.66402e+07, 5.03393e+07, 4.45676e+07, 3.93219e+07,
 3.45859e+07, 3.03346e+07, 2.65374e+07, 2.31605e+07, 2.01690e+07,
 1.75279e+07, 1.52034e+07, 1.31634e+07, 1.13777e+07, 9.81844e+06,
 8.45989e+06, 7.27872e+06, 6.25380e+06, 5.36609e+06, 4.59858e+06,
 3.93607e+06, 3.36510e+06, 2.87373e+06, 2.45148e+06, 2.08908e+06,
 1.77847e+06, 1.51255e+06, 1.28516e+06, 1.09093e+06, 9.25189e+05,
 7.83907e+05, 6.63585e+05, 5.61203e+05, 4.74161e+05, 4.00218e+05,
 3.37448e+05, 2.84198e+05, 2.39052e+05, 2.00795e+05, 1.68392e+05,
 1.40956e+05, 1.17731e+05, 9.80753e+04, 8.14401e+04, 6.73614e+04,
 5.54460e+04, 4.53620e+04, 3.68310e+04, 2.96213e+04, 2.35422e+04,
 1.84405e+04, 1.41975e+04, 1.07281e+04, 7.98079e+03, 5.93954e+03}
,
{7.78065e+05, 7.98870e+06, 2.59145e+07, 5.20774e+07, 8.12427e+07,
 1.08953e+08, 1.32633e+08, 1.51465e+08, 1.65907e+08, 1.76878e+08,
 1.85234e+08, 1.91611e+08, 1.96516e+08, 2.00368e+08, 2.03477e+08,
 2.06037e+08, 2.08150e+08, 2.09884e+08, 2.11290e+08, 2.12389e+08,
 2.13178e+08, 2.13661e+08, 2.13852e+08, 2.13750e+08, 2.13327e+08,
 2.12538e+08, 2.11342e+08, 2.09691e+08, 2.07513e+08, 2.04721e+08,
 2.01227e+08, 1.96950e+08, 1.91817e+08, 1.85769e+08, 1.78777e+08,
 1.70857e+08, 1.62075e+08, 1.52545e+08, 1.42425e+08, 1.31910e+08,
 1.21210e+08, 1.15238e+08, 1.04831e+08, 9.47616e+07, 8.51666e+07,
 7.61459e+07, 6.77638e+07, 6.00536e+07, 5.30225e+07, 4.66581e+07,
 4.09337e+07, 3.58129e+07, 3.12538e+07, 2.72118e+07, 2.36414e+07,
 2.04981e+07, 1.77391e+07, 1.53241e+07, 1.32156e+07, 1.13790e+07,
 9.78288e+06, 8.39851e+06, 7.20015e+06, 6.16470e+06, 5.27155e+06,
 4.50238e+06, 3.84101e+06, 3.27316e+06, 2.78628e+06, 2.36937e+06,
 2.01282e+06, 1.70827e+06, 1.44841e+06, 1.22694e+06, 1.03837e+06,
 8.77983e+05, 7.41687e+05, 6.25966e+05, 5.27798e+05, 4.44584e+05,
 3.74097e+05, 3.14431e+05, 2.63954e+05, 2.21274e+05, 1.85202e+05,
 1.54727e+05, 1.28985e+05, 1.07246e+05, 8.88879e+04, 7.33845e+04,
 6.02913e+04, 4.92339e+04, 3.98989e+04, 3.20258e+04, 2.54003e+04,
 1.98506e+04, 1.52434e+04, 1.14830e+04, 8.51057e+03, 6.30658e+03}
,
{1.01133e+06, 1.03493e+07, 3.34220e+07, 6.68858e+07, 1.03957e+08,
 1.38960e+08, 1.68686e+08, 1.92197e+08, 2.10156e+08, 2.23767e+08,
 2.34110e+08, 2.41985e+08, 2.48040e+08, 2.52798e+08, 2.56644e+08,
 2.59810e+08, 2.62417e+08, 2.64549e+08, 2.66267e+08, 2.67594e+08,
 2.68523e+08, 2.69062e+08, 2.69229e+08, 2.69014e+08, 2.68377e+08,
 2.67258e+08, 2.65604e+08, 2.63346e+08, 2.60386e+08, 2.56608e+08,
 2.51900e+08, 2.46159e+08, 2.39296e+08, 2.31245e+08, 2.21982e+08,
 2.11550e+08, 2.00055e+08, 1.87663e+08, 1.74598e+08, 1.61121e+08,
 1.53359e+08, 1.39978e+08, 1.26900e+08, 1.14330e+08, 1.02425e+08,
 9.12962e+07, 8.10089e+07, 7.15905e+07, 6.30385e+07, 5.53277e+07,
 4.84172e+07, 4.22562e+07, 3.67882e+07, 3.19548e+07, 2.76975e+07,
 2.39597e+07, 2.06876e+07, 1.78309e+07, 1.53431e+07, 1.31816e+07,
 1.13076e+07, 9.68626e+06, 8.28608e+06, 7.07910e+06, 6.04042e+06,
 5.14800e+06, 4.38241e+06, 3.72657e+06, 3.16551e+06, 2.68617e+06,
 2.27714e+06, 1.92853e+06, 1.63175e+06, 1.37936e+06, 1.16494e+06,
 9.82964e+05, 8.28657e+05, 6.97931e+05, 5.87273e+05, 4.93675e+05,
 4.14565e+05, 3.47744e+05, 2.91337e+05, 2.43745e+05, 2.03610e+05,
 1.69775e+05, 1.41257e+05, 1.17226e+05, 9.69756e+04, 7.99110e+04,
 6.55300e+04, 5.34108e+04, 4.32006e+04, 3.46067e+04, 2.73888e+04,
 2.13544e+04, 1.63543e+04, 1.22805e+04, 9.06633e+03, 6.68808e+03}
,
{1.31408e+06, 1.34028e+07, 4.30900e+07, 8.58773e+07, 1.32981e+08,
 1.77180e+08, 2.14483e+08, 2.43829e+08, 2.66161e+08, 2.83046e+08,
 2.95846e+08, 3.05573e+08, 3.13048e+08, 3.18928e+08, 3.23687e+08,
 3.27601e+08, 3.30815e+08, 3.33436e+08, 3.35535e+08, 3.37132e+08,
 3.38217e+08, 3.38808e+08, 3.38923e+08, 3.38542e+08, 3.37601e+08,
 3.36028e+08, 3.33751e+08, 3.30672e+08, 3.26656e+08, 3.21552e+08,
 3.15218e+08, 3.07527e+08, 2.98368e+08, 2.87669e+08, 2.75426e+08,
 2.61717e+08, 2.46707e+08, 2.30638e+08, 2.13818e+08, 1.96595e+08,
 1.86747e+08, 1.69860e+08, 1.53468e+08, 1.37814e+08, 1.23076e+08,
 1.09374e+08, 9.67712e+07, 8.52848e+07, 7.48980e+07, 6.55681e+07,
 5.72358e+07, 4.98312e+07, 4.32796e+07, 3.75051e+07, 3.24332e+07,
 2.79921e+07, 2.41147e+07, 2.07381e+07, 1.78050e+07, 1.52629e+07,
 1.30643e+07, 1.11666e+07, 9.53171e+06, 8.12570e+06, 6.91855e+06,
 5.88377e+06, 4.99808e+06, 4.24107e+06, 3.59493e+06, 3.04412e+06,
 2.57516e+06, 2.17636e+06, 1.83759e+06, 1.55012e+06, 1.30644e+06,
 1.10008e+06, 9.25473e+05, 7.77872e+05, 6.53200e+05, 5.47978e+05,
 4.59234e+05, 3.84438e+05, 3.21435e+05, 2.68394e+05, 2.23759e+05,
 1.86212e+05, 1.54634e+05, 1.28081e+05, 1.05754e+05, 8.69794e+04,
 7.11909e+04, 5.79136e+04, 4.67508e+04, 3.73739e+04, 2.95141e+04,
 2.29557e+04, 1.75316e+04, 1.31206e+04, 9.64713e+03, 7.08264e+03}
,
{1.70694e+06, 1.73514e+07, 5.55362e+07, 1.10226e+08, 1.70057e+08,
 2.25850e+08, 2.72646e+08, 3.09267e+08, 3.37034e+08, 3.57978e+08,
 3.73819e+08, 3.85834e+08, 3.95063e+08, 4.02332e+08, 4.08222e+08,
 4.13061e+08, 4.17024e+08, 4.20244e+08, 4.22804e+08, 4.24718e+08,
 4.25978e+08, 4.26610e+08, 4.26633e+08, 4.26005e+08, 4.24640e+08,
 4.22445e+08, 4.19322e+08, 4.15132e+08, 4.09693e+08, 4.02810e+08,
 3.94304e+08, 3.84017e+08, 3.71814e+08, 3.57626e+08, 3.41477e+08,
 3.23506e+08, 3.03957e+08, 2.83175e+08, 2.61579e+08, 2.48839e+08,
 2.27179e+08, 2.05922e+08, 1.85427e+08, 1.65977e+08, 1.47771e+08,
 1.30933e+08, 1.15519e+08, 1.01532e+08, 8.89334e+07, 7.76584e+07,
 6.76226e+07, 5.87326e+07, 5.08902e+07, 4.39977e+07, 3.79602e+07,
 3.26879e+07, 2.80965e+07, 2.41085e+07, 2.06528e+07, 1.76651e+07,
 1.50874e+07, 1.28678e+07, 1.09600e+07, 9.32321e+06, 7.92113e+06,
 6.72201e+06, 5.69798e+06, 4.82472e+06, 4.08101e+06, 3.44844e+06,
 2.91107e+06, 2.45509e+06, 2.06860e+06, 1.74137e+06, 1.46458e+06,
 1.23068e+06, 1.03321e+06, 8.66646e+05, 7.26258e+05, 6.08027e+05,
 5.08527e+05, 4.24845e+05, 3.54510e+05, 2.95423e+05, 2.45808e+05,
 2.04160e+05, 1.69210e+05, 1.39884e+05, 1.15277e+05, 9.46304e+04,
 7.73040e+04, 6.27638e+04, 5.05643e+04, 4.03373e+04, 3.17820e+04,
 2.46573e+04, 1.87760e+04, 1.40026e+04, 1.02514e+04, 7.48831e+03}
,
{2.21669e+06, 2.24556e+07, 7.15538e+07, 1.41435e+08, 2.17407e+08,
 2.87811e+08, 3.46499e+08, 3.92188e+08, 4.26711e+08, 4.52688e+08,
 4.72290e+08, 4.87131e+08, 4.98530e+08, 5.07520e+08, 5.14810e+08,
 5.20791e+08, 5.25675e+08, 5.29630e+08, 5.32747e+08, 5.35032e+08,
 5.36483e+08, 5.37137e+08, 5.37006e+08, 5.36022e+08, 5.34067e+08,
 5.31021e+08, 5.26751e+08, 5.21062e+08, 5.13708e+08, 5.04442e+08,
 4.93039e+08, 4.79301e+08, 4.63072e+08, 4.44294e+08, 4.23042e+08,
 3.99539e+08, 3.74143e+08, 3.47336e+08, 3.19683e+08, 3.03481e+08,
 2.76097e+08, 2.49408e+08, 2.23844e+08, 1.99729e+08, 1.77282e+08,
 1.56627e+08, 1.37805e+08, 1.20797e+08, 1.05537e+08, 9.19265e+07,
 7.98521e+07, 6.91886e+07, 5.98094e+07, 5.15892e+07, 4.44083e+07,
 3.81539e+07, 3.27212e+07, 2.80143e+07, 2.39458e+07, 2.04367e+07,
 1.74165e+07, 1.48220e+07, 1.25973e+07, 1.06929e+07, 9.06541e+06,
 7.67666e+06, 6.49338e+06, 5.48657e+06, 4.63105e+06, 3.90499e+06,
 3.28956e+06, 2.76849e+06, 2.32780e+06, 1.95548e+06, 1.64125e+06,
 1.37629e+06, 1.15308e+06, 9.65199e+05, 8.07192e+05, 6.74409e+05,
 5.62903e+05, 4.69326e+05, 3.90842e+05, 3.25052e+05, 2.69926e+05,
 2.23752e+05, 1.85086e+05, 1.52710e+05, 1.25604e+05, 1.02907e+05,
 8.39004e+04, 6.79832e+04, 5.46558e+04, 4.35060e+04, 3.41976e+04,
 2.64609e+04, 2.00871e+04, 1.49246e+04, 1.08768e+04, 7.90240e+03}
,
{2.87792e+06, 2.90517e+07, 9.21621e+07, 1.81424e+08, 2.77860e+08,
 3.66675e+08, 4.40252e+08, 4.97244e+08, 5.40162e+08, 5.72380e+08,
 5.96636e+08, 6.14969e+08, 6.29050e+08, 6.40172e+08, 6.49198e+08,
 6.56588e+08, 6.62607e+08, 6.67460e+08, 6.71247e+08, 6.73965e+08,
 6.75620e+08, 6.76263e+08, 6.75889e+08, 6.74396e+08, 6.71623e+08,
 6.67421e+08, 6.61599e+08, 6.53887e+08, 6.43961e+08, 6.31508e+08,
 6.16247e+08, 5.97929e+08, 5.76384e+08, 5.51583e+08, 5.23678e+08,
 4.93013e+08, 4.60105e+08, 4.25617e+08, 3.90305e+08, 3.69766e+08,
 3.35233e+08, 3.01806e+08, 2.69990e+08, 2.40154e+08, 2.12530e+08,
 1.87234e+08, 1.64286e+08, 1.43632e+08, 1.25168e+08, 1.08757e+08,
 9.42444e+07, 8.14657e+07, 7.02581e+07, 6.04625e+07, 5.19281e+07,
 4.45141e+07, 3.80905e+07, 3.25390e+07, 2.77521e+07, 2.36335e+07,
 2.00970e+07, 1.70662e+07, 1.44734e+07, 1.22591e+07, 1.03710e+07,
 8.76355e+06, 7.39702e+06, 6.23688e+06, 5.25327e+06, 4.42035e+06,
 3.71589e+06, 3.12076e+06, 2.61853e+06, 2.19514e+06, 1.83857e+06,
 1.53857e+06, 1.28638e+06, 1.07457e+06, 8.96825e+05, 7.47771e+05,
 6.22870e+05, 5.18276e+05, 4.30741e+05, 3.57520e+05, 2.96298e+05,
 2.45128e+05, 2.02369e+05, 1.66643e+05, 1.36794e+05, 1.11854e+05,
 9.10121e+04, 7.35940e+04, 5.90398e+04, 4.68887e+04, 3.67646e+04,
 2.83669e+04, 2.14632e+04, 1.58841e+04, 1.15199e+04, 8.32152e+03}
,
{3.73538e+06, 3.75739e+07, 1.18669e+08, 2.32650e+08, 3.55024e+08,
 4.67029e+08, 5.59246e+08, 6.30323e+08, 6.83674e+08, 7.23628e+08,
 7.53642e+08, 7.76291e+08, 7.93691e+08, 8.07454e+08, 8.18628e+08,
 8.27760e+08, 8.35175e+08, 8.41125e+08, 8.45717e+08, 8.48934e+08,
 8.50799e+08, 8.51375e+08, 8.50634e+08, 8.48418e+08, 8.44522e+08,
 8.38747e+08, 8.30828e+08, 8.20393e+08, 8.07018e+08, 7.90311e+08,
 7.69916e+08, 7.45533e+08, 7.16984e+08, 6.84294e+08, 6.47735e+08,
 6.07822e+08, 5.65286e+08, 5.21033e+08, 4.94455e+08, 4.50106e+08,
 4.06666e+08, 3.64895e+08, 3.25384e+08, 2.88540e+08, 2.54605e+08,
 2.23675e+08, 1.95735e+08, 1.70685e+08, 1.48371e+08, 1.28603e+08,
 1.11175e+08, 9.58751e+07, 8.24937e+07, 7.08298e+07, 6.06943e+07,
 5.19120e+07, 4.43221e+07, 3.77787e+07, 3.21503e+07, 2.73193e+07,
 2.31809e+07, 1.96425e+07, 1.66225e+07, 1.40492e+07, 1.18601e+07,
 1.00006e+07, 8.42329e+06, 7.08721e+06, 5.95693e+06, 5.00193e+06,
 4.19598e+06, 3.51660e+06, 2.94452e+06, 2.46329e+06, 2.05890e+06,
 1.71938e+06, 1.43460e+06, 1.19593e+06, 9.96061e+05, 8.28821e+05,
 6.88981e+05, 5.72128e+05, 4.74541e+05, 3.93086e+05, 3.25125e+05,
 2.68442e+05, 2.21177e+05, 1.81769e+05, 1.48913e+05, 1.21518e+05,
 9.86716e+04, 7.96177e+04, 6.37297e+04, 5.04920e+04, 3.94850e+04,
 3.03744e+04, 2.29014e+04, 1.68768e+04, 1.21764e+04, 8.74180e+03}
,
{4.84696e+06, 4.85809e+07, 1.52753e+08, 2.98252e+08, 4.53492e+08,
 5.94698e+08, 7.10244e+08, 7.98872e+08, 8.65184e+08, 9.14732e+08,
 9.51868e+08, 9.79852e+08, 1.00136e+09, 1.01840e+09, 1.03223e+09,
 1.04351e+09, 1.05264e+09, 1.05993e+09, 1.06549e+09, 1.06927e+09,
 1.07135e+09, 1.07177e+09, 1.07048e+09, 1.06725e+09, 1.06182e+09,
 1.05391e+09, 1.04316e+09, 1.02907e+09, 1.01107e+09, 9.88694e+08,
 9.61481e+08, 9.29078e+08, 8.91317e+08, 8.48320e+08, 8.00532e+08,
 7.48705e+08, 6.93864e+08, 6.37228e+08, 6.03443e+08, 5.47401e+08,
 4.92885e+08, 4.40805e+08, 3.91836e+08, 3.46424e+08, 3.04804e+08,
 2.67041e+08, 2.33067e+08, 2.02721e+08, 1.75782e+08, 1.51993e+08,
 1.31084e+08, 1.12781e+08, 9.68164e+07, 8.29382e+07, 7.09100e+07,
 6.05140e+07, 5.15519e+07, 4.38445e+07, 3.72308e+07, 3.15675e+07,
 2.67277e+07, 2.25991e+07, 1.90836e+07, 1.60949e+07, 1.35581e+07,
 1.14081e+07, 9.58849e+06, 8.05059e+06, 6.75244e+06, 5.65802e+06,
 4.73644e+06, 3.96126e+06, 3.30994e+06, 2.76325e+06, 2.30483e+06,
 1.92078e+06, 1.59934e+06, 1.33052e+06, 1.10590e+06, 9.18339e+05,
 7.61845e+05, 6.31354e+05, 5.22609e+05, 4.32033e+05, 3.56622e+05,
 2.93858e+05, 2.41632e+05, 1.98180e+05, 1.62028e+05, 1.31946e+05,
 1.06911e+05, 8.60755e+04, 6.87371e+04, 5.43204e+04, 4.23586e+04,
 3.24800e+04, 2.43968e+04, 1.78970e+04, 1.28411e+04, 9.15903e+03}
,
{6.28752e+06, 6.27930e+07, 1.96567e+08, 3.82243e+08, 5.79115e+08,
 7.57080e+08, 9.01818e+08, 1.01231e+09, 1.09473e+09, 1.15617e+09,
 1.20212e+09, 1.23670e+09, 1.26329e+09, 1.28438e+09, 1.30151e+09,
 1.31544e+09, 1.32669e+09, 1.33561e+09, 1.34230e+09, 1.34674e+09,
 1.34899e+09, 1.34914e+09, 1.34706e+09, 1.34241e+09, 1.33488e+09,
 1.32409e+09, 1.30953e+09, 1.29051e+09, 1.26635e+09, 1.23642e+09,
 1.20016e+09, 1.15717e+09, 1.10732e+09, 1.05089e+09, 9.88562e+08,
 9.21427e+08, 8.50897e+08, 7.78595e+08, 7.35782e+08, 6.65135e+08,
 5.96877e+08, 5.32080e+08, 4.71507e+08, 4.15631e+08, 3.64665e+08,
 3.18623e+08, 2.77363e+08, 2.40642e+08, 2.08152e+08, 1.79552e+08,
 1.54487e+08, 1.32608e+08, 1.13576e+08, 9.70751e+07, 8.28104e+07,
 7.05125e+07, 5.99370e+07, 5.08641e+07, 4.30973e+07, 3.64624e+07,
 3.08055e+07, 2.59911e+07, 2.19009e+07, 1.84316e+07, 1.54936e+07,
 1.30091e+07, 1.09110e+07, 9.14172e+06, 7.65154e+06, 6.39797e+06,
 5.34467e+06, 4.46064e+06, 3.71946e+06, 3.09869e+06, 2.57927e+06,
 2.14506e+06, 1.78240e+06, 1.47977e+06, 1.22743e+06, 1.01718e+06,
 8.42126e+05, 6.96468e+05, 5.75342e+05, 4.74665e+05, 3.91022e+05,
 3.21552e+05, 2.63868e+05, 2.15974e+05, 1.76208e+05, 1.43187e+05,
 1.15764e+05, 9.29863e+04, 7.40709e+04, 5.83760e+04, 4.53828e+04,
 3.46784e+04, 2.59420e+04, 1.89378e+04, 1.35080e+04, 9.56884e+03}
,
{8.15382e+06, 8.11376e+07, 2.52872e+08, 4.89747e+08, 7.39341e+08,
 9.63564e+08, 1.14483e+09, 1.28256e+09, 1.38498e+09, 1.46117e+09,
 1.51801e+09, 1.56075e+09, 1.59364e+09, 1.61977e+09, 1.64097e+09,
 1.65817e+09, 1.67201e+09, 1.68291e+09, 1.69096e+09, 1.69612e+09,
 1.69851e+09, 1.69820e+09, 1.69496e+09, 1.68835e+09, 1.67796e+09,
 1.66329e+09, 1.64359e+09, 1.61798e+09, 1.58558e+09, 1.54561e+09,
 1.49738e+09, 1.44044e+09, 1.37476e+09, 1.30085e+09, 1.21975e+09,
 1.13299e+09, 1.04251e+09, 9.87135e+08, 8.96345e+08, 8.07496e+08,
 7.22219e+08, 6.41761e+08, 5.66972e+08, 4.98332e+08, 4.36014e+08,
 3.79950e+08, 3.29899e+08, 2.85511e+08, 2.46363e+08, 2.12008e+08,
 1.81986e+08, 1.55852e+08, 1.33180e+08, 1.13574e+08, 9.66688e+07,
 8.21303e+07, 6.96587e+07, 5.89848e+07, 4.98694e+07, 4.21007e+07,
 3.54924e+07, 2.98814e+07, 2.51252e+07, 2.11002e+07, 1.76991e+07,
 1.48296e+07, 1.24117e+07, 1.03772e+07, 8.66740e+06, 7.23224e+06,
 6.02899e+06, 5.02129e+06, 4.17825e+06, 3.47369e+06, 2.88543e+06,
 2.39473e+06, 1.98576e+06, 1.64522e+06, 1.36187e+06, 1.12628e+06,
 9.30551e+05, 7.68034e+05, 6.33171e+05, 5.21314e+05, 4.28576e+05,
 3.51713e+05, 2.88023e+05, 2.35251e+05, 1.91525e+05, 1.55290e+05,
 1.25259e+05, 1.00366e+05, 7.97367e+04, 6.26575e+04, 4.85520e+04,
 3.69606e+04, 2.75279e+04, 1.99911e+04, 1.41710e+04, 9.96661e+03}
,
{1.05709e+07, 1.04809e+08, 3.25212e+08, 6.27313e+08, 9.43655e+08,
 1.22607e+09, 1.45302e+09, 1.62468e+09, 1.75196e+09, 1.84643e+09,
 1.91675e+09, 1.96958e+09, 2.01027e+09, 2.04264e+09, 2.06888e+09,
 2.09011e+09, 2.10714e+09, 2.12045e+09, 2.13009e+09, 2.13604e+09,
 2.13849e+09, 2.13744e+09, 2.13255e+09, 2.12325e+09, 2.10899e+09,
 2.08906e+09, 2.06247e+09, 2.02803e+09, 1.98466e+09, 1.93135e+09,
 1.86729e+09, 1.79201e+09, 1.70564e+09, 1.60904e+09, 1.50374e+09,
 1.39189e+09, 1.27610e+09, 1.20571e+09, 1.09100e+09, 9.79509e+08,
 8.73192e+08, 7.73480e+08, 6.81299e+08, 5.97110e+08, 5.21015e+08,
 4.52830e+08, 3.92184e+08, 3.38579e+08, 2.91453e+08, 2.50218e+08,
 2.14286e+08, 1.83093e+08, 1.56104e+08, 1.32824e+08, 1.12802e+08,
 9.56252e+07, 8.09263e+07, 6.83765e+07, 5.76843e+07, 4.85931e+07,
 4.08777e+07, 3.43417e+07, 2.88141e+07, 2.41467e+07, 2.02118e+07,
 1.68990e+07, 1.41140e+07, 1.17757e+07, 9.81488e+06, 8.17260e+06,
 6.79869e+06, 5.65056e+06, 4.69211e+06, 3.89281e+06, 3.22689e+06,
 2.67259e+06, 2.21161e+06, 1.82857e+06, 1.51053e+06, 1.24668e+06,
 1.02792e+06, 8.46663e+05, 6.96568e+05, 5.72335e+05, 4.69552e+05,
 3.84542e+05, 3.14244e+05, 2.56116e+05, 2.08050e+05, 1.68301e+05,
 1.35423e+05, 1.08226e+05, 8.57361e+04, 6.71597e+04, 5.18558e+04,
 3.93151e+04, 2.91437e+04, 2.10480e+04, 1.48234e+04, 1.03481e+04}
,
{1.37006e+07, 1.35348e+08, 4.18127e+08, 8.03299e+08, 1.20413e+09,
 1.55974e+09, 1.84381e+09, 2.05772e+09, 2.21588e+09, 2.33302e+09,
 2.42002e+09, 2.48533e+09, 2.53568e+09, 2.57579e+09, 2.60827e+09,
 2.63447e+09, 2.65541e+09, 2.67163e+09, 2.68312e+09, 2.68993e+09,
 2.69229e+09, 2.69012e+09, 2.68291e+09, 2.66991e+09, 2.65040e+09,
 2.62341e+09, 2.58755e+09, 2.54133e+09, 2.48334e+09, 2.41237e+09,
 2.32741e+09, 2.22805e+09, 2.11470e+09, 1.98872e+09, 1.85231e+09,
 1.70845e+09, 1.56062e+09, 1.47142e+09, 1.32680e+09, 1.18721e+09,
 1.05493e+09, 9.31580e+08, 8.18143e+08, 7.15034e+08, 6.22235e+08,
 5.39406e+08, 4.65995e+08, 4.01320e+08, 3.44638e+08, 2.95185e+08,
 2.52212e+08, 2.15006e+08, 1.82899e+08, 1.55276e+08, 1.31576e+08,
 1.11295e+08, 9.39817e+07, 7.92345e+07, 6.66998e+07, 5.60668e+07,
 4.70637e+07, 3.94542e+07, 3.30332e+07, 2.76238e+07, 2.30733e+07,
 1.92509e+07, 1.60445e+07, 1.33583e+07, 1.11106e+07, 9.23224e+06,
 7.66419e+06, 6.35665e+06, 5.26748e+06, 4.36112e+06, 3.60760e+06,
 2.98174e+06, 2.46236e+06, 2.03170e+06, 1.67489e+06, 1.37949e+06,
 1.13509e+06, 9.33022e+05, 7.66037e+05, 6.28114e+05, 5.14240e+05,
 4.20250e+05, 3.42684e+05, 2.78676e+05, 2.25856e+05, 1.82263e+05,
 1.46278e+05, 1.16574e+05, 9.20657e+04, 7.18716e+04, 5.52800e+04,
 4.17276e+04, 3.07772e+04, 2.20990e+04, 1.54585e+04, 1.07096e+04}
,
{1.77527e+07, 1.74735e+08, 5.37439e+08, 1.02838e+09, 1.53612e+09,
 1.98377e+09, 2.33925e+09, 2.60578e+09, 2.80231e+09, 2.94754e+09,
 3.05517e+09, 3.13593e+09, 3.19826e+09, 3.24796e+09, 3.28815e+09,
 3.32049e+09, 3.34622e+09, 3.36594e+09, 3.37960e+09, 3.38731e+09,
 3.38933e+09, 3.38550e+09, 3.37503e+09, 3.35698e+09, 3.33039e+09,
 3.29389e+09, 3.24562e+09, 3.18366e+09, 3.10626e+09, 3.01188e+09,
 2.89939e+09, 2.76849e+09, 2.62003e+09, 2.45607e+09, 2.27976e+09,
 2.09518e+09, 1.97999e+09, 1.79415e+09, 1.61225e+09, 1.43783e+09,
 1.27356e+09, 1.12123e+09, 9.81858e+08, 8.55750e+08, 7.42718e+08,
 6.42208e+08, 5.53432e+08, 4.75472e+08, 4.07349e+08, 3.48085e+08,
 2.96728e+08, 2.52381e+08, 2.14210e+08, 1.81453e+08, 1.53418e+08,
 1.29485e+08, 1.09104e+08, 9.17840e+07, 7.70973e+07, 6.46675e+07,
 5.41672e+07, 4.53124e+07, 3.78575e+07, 3.15910e+07, 2.63314e+07,
 2.19230e+07, 1.82332e+07, 1.51487e+07, 1.25735e+07, 1.04260e+07,
 8.63715e+06, 7.14873e+06, 5.91155e+06, 4.88423e+06, 4.03198e+06,
 3.32562e+06, 2.74068e+06, 2.25669e+06, 1.85654e+06, 1.52596e+06,
 1.25303e+06, 1.02784e+06, 8.42131e+05, 6.89063e+05, 5.62946e+05,
 4.59060e+05, 3.73501e+05, 3.03040e+05, 2.45012e+05, 1.97214e+05,
 1.57840e+05, 1.25409e+05, 9.87152e+04, 7.67765e+04, 5.88065e+04,
 4.41817e+04, 3.24148e+04, 2.31341e+04, 1.60706e+04, 1.10487e+04}
,
{2.29982e+07, 2.25522e+08, 6.90604e+08, 1.31619e+09, 1.95917e+09,
 2.52251e+09, 2.96727e+09, 3.29932e+09, 3.54351e+09, 3.72355e+09,
 3.85671e+09, 3.95659e+09, 4.03378e+09, 4.09537e+09, 4.14509e+09,
 4.18499e+09, 4.21659e+09, 4.24051e+09, 4.25668e+09, 4.26528e+09,
 4.26663e+09, 4.26035e+09, 4.24536e+09, 4.22044e+09, 4.18430e+09,
 4.13501e+09, 4.07012e+09, 3.98719e+09, 3.88403e+09, 3.75871e+09,
 3.61000e+09, 3.43786e+09, 3.24380e+09, 3.03087e+09, 2.80351e+09,
 2.56721e+09, 2.42074e+09, 2.18586e+09, 1.95756e+09, 1.74005e+09,
 1.53642e+09, 1.34863e+09, 1.17763e+09, 1.02359e+09, 8.86069e+08,
 7.64228e+08, 6.56971e+08, 5.63074e+08, 4.81266e+08, 4.10296e+08,
 3.48961e+08, 2.96137e+08, 2.50786e+08, 2.11964e+08, 1.78820e+08,
 1.50594e+08, 1.26614e+08, 1.06284e+08, 8.90849e+07, 7.45623e+07,
 6.23220e+07, 5.20233e+07, 4.33721e+07, 3.61163e+07, 3.00398e+07,
 2.49580e+07, 2.07138e+07, 1.71737e+07, 1.42245e+07, 1.17704e+07,
 9.73062e+06, 8.03704e+06, 6.63235e+06, 5.46842e+06, 4.50490e+06,
 3.70802e+06, 3.04951e+06, 2.50581e+06, 2.05725e+06, 1.68744e+06,
 1.38276e+06, 1.13189e+06, 9.25441e+05, 7.55626e+05, 6.15993e+05,
 5.01204e+05, 4.06857e+05, 3.29314e+05, 2.65578e+05, 2.13185e+05,
 1.70117e+05, 1.34726e+05, 1.05666e+05, 8.18521e+04, 6.24139e+04,
 4.66592e+04, 3.40424e+04, 2.41442e+04, 1.66550e+04, 1.13635e+04}
 ,
{2.97868e+07, 2.90988e+08, 8.87178e+08, 1.68410e+09, 2.49812e+09,
 3.20687e+09, 3.76319e+09, 4.17681e+09, 4.48022e+09, 4.70341e+09,
 4.86817e+09, 4.99172e+09, 5.08733e+09, 5.16367e+09, 5.22518e+09,
 5.27439e+09, 5.31316e+09, 5.34212e+09, 5.36114e+09, 5.37058e+09,
 5.37072e+09, 5.36091e+09, 5.33966e+09, 5.30543e+09, 5.25642e+09,
 5.18998e+09, 5.10289e+09, 4.99206e+09, 4.85472e+09, 4.68856e+09,
 4.49229e+09, 4.26633e+09, 4.01318e+09, 3.73725e+09, 3.44471e+09,
 3.14290e+09, 2.95715e+09, 2.66095e+09, 2.37500e+09, 2.10429e+09,
 1.85230e+09, 1.62113e+09, 1.41162e+09, 1.22369e+09, 1.05656e+09,
 9.09005e+08, 7.79530e+08, 6.66529e+08, 5.68361e+08, 4.83432e+08,
 4.10229e+08, 3.47347e+08, 2.93498e+08, 2.47514e+08, 2.08353e+08,
 1.75083e+08, 1.46883e+08, 1.23033e+08, 1.02902e+08, 8.59426e+07,
 7.16811e+07, 5.97086e+07, 4.96741e+07, 4.12768e+07, 3.42598e+07,
 2.84043e+07, 2.35247e+07, 1.94634e+07, 1.60873e+07, 1.32841e+07,
 1.09592e+07, 9.03300e+06, 7.43878e+06, 6.12064e+06, 5.03178e+06,
 4.13314e+06, 3.39212e+06, 2.78158e+06, 2.27893e+06, 1.86540e+06,
 1.52540e+06, 1.24604e+06, 1.01661e+06, 8.28273e+05, 6.73722e+05,
 5.46925e+05, 4.42915e+05, 3.57599e+05, 2.87612e+05, 2.30198e+05,
 1.83108e+05, 1.44503e+05, 1.12892e+05, 8.70712e+04, 6.60780e+04,
 4.91399e+04, 3.56461e+04, 2.51216e+04, 1.72082e+04, 1.16529e+04}
};

const std::vector< std::vector<double> > PROPOSAL::y_nubar_p = {
{0.05244  , 0.0540251, 0.0556581, 0.0573405, 0.0590737, 0.0608592,
 0.0626988, 0.064594 , 0.0665464, 0.0685579, 0.0706301, 0.072765 ,
 0.0749645, 0.0772304, 0.0795648, 0.0819697, 0.0844474, 0.0869999,
 0.0896296, 0.0923388, 0.0951299, 0.0980053, 0.100968 , 0.10402  ,
 0.107164 , 0.110403 , 0.11374  , 0.117178 , 0.12072  , 0.124369 ,
 0.128128 , 0.132001 , 0.135991 , 0.140101 , 0.144336 , 0.148699 ,
 0.153193 , 0.157824 , 0.162594 , 0.167509 , 0.172572 , 0.177788 ,
 0.183162 , 0.188699 , 0.194402 , 0.200279 , 0.206332 , 0.212569 ,
 0.218994 , 0.225614 , 0.232433 , 0.239459 , 0.246697 , 0.254153 ,
 0.261836 , 0.26975  , 0.277904 , 0.286304 , 0.294958 , 0.303873 ,
 0.313058 , 0.322521 , 0.332269 , 0.342313 , 0.35266  , 0.363319 ,
 0.374301 , 0.385615 , 0.397271 , 0.409279 , 0.42165  , 0.434395 ,
 0.447525 , 0.461052 , 0.474988 , 0.489345 , 0.504136 , 0.519375 ,
 0.535073 , 0.551247 , 0.567909 , 0.585075 , 0.60276  , 0.620979 ,
 0.639749 , 0.659086 , 0.679008 , 0.699532 , 0.720676 , 0.74246  ,
 0.764902 , 0.788022 , 0.811841 , 0.83638  , 0.861661 , 0.887706 ,
 0.914538 , 0.942182 , 0.97066  , 1.       }
,
{0.0421351, 0.0435047, 0.0449189, 0.046379 , 0.0478866, 0.0494432,
 0.0510504, 0.0527098, 0.0544232, 0.0561923, 0.0580188, 0.0599048,
 0.061852 , 0.0638626, 0.0659385, 0.0680818, 0.0702949, 0.0725799,
 0.0749392, 0.0773751, 0.0798902, 0.0824871, 0.0851684, 0.0879369,
 0.0907954, 0.0937467, 0.0967941, 0.0999404, 0.103189 , 0.106543 ,
 0.110007 , 0.113582 , 0.117274 , 0.121087 , 0.125023 , 0.129087 ,
 0.133283 , 0.137615 , 0.142088 , 0.146707 , 0.151476 , 0.1564   ,
 0.161484 , 0.166733 , 0.172153 , 0.177748 , 0.183526 , 0.189492 ,
 0.195652 , 0.202011 , 0.208578 , 0.215358 , 0.222358 , 0.229586 ,
 0.237049 , 0.244755 , 0.25271  , 0.260925 , 0.269407 , 0.278164 ,
 0.287206 , 0.296542 , 0.306181 , 0.316134 , 0.32641  , 0.33702  ,
 0.347975 , 0.359286 , 0.370965 , 0.383024 , 0.395474 , 0.408329 ,
 0.421602 , 0.435307 , 0.449457 , 0.464067 , 0.479152 , 0.494727 ,
 0.510808 , 0.527412 , 0.544556 , 0.562258 , 0.580534 , 0.599405 ,
 0.618889 , 0.639006 , 0.659778 , 0.681224 , 0.703368 , 0.726232 ,
 0.749838 , 0.774212 , 0.799379 , 0.825363 , 0.852192 , 0.879893 ,
 0.908495 , 0.938026 , 0.968518 , 1.       }
,
{0.0337935, 0.0349698, 0.0361871, 0.0374467, 0.0387502, 0.0400991,
 0.0414949, 0.0429393, 0.044434 , 0.0459807, 0.0475812, 0.0492375,
 0.0509514, 0.052725 , 0.0545603, 0.0564595, 0.0584248, 0.0604585,
 0.062563 , 0.0647408, 0.0669944, 0.0693264, 0.0717396, 0.0742368,
 0.0768209, 0.079495 , 0.0822621, 0.0851256, 0.0880888, 0.0911551,
 0.0943281, 0.0976116, 0.101009 , 0.104525 , 0.108164 , 0.111929 ,
 0.115825 , 0.119857 , 0.124029 , 0.128346 , 0.132814 , 0.137437 ,
 0.142221 , 0.147172 , 0.152295 , 0.157596 , 0.163082 , 0.168759 ,
 0.174633 , 0.180712 , 0.187002 , 0.193512 , 0.200247 , 0.207218 ,
 0.214431 , 0.221895 , 0.229619 , 0.237612 , 0.245883 , 0.254442 ,
 0.263299 , 0.272464 , 0.281949 , 0.291763 , 0.301919 , 0.312429 ,
 0.323304 , 0.334558 , 0.346204 , 0.358255 , 0.370725 , 0.38363  ,
 0.396984 , 0.410802 , 0.425102 , 0.439899 , 0.455212 , 0.471058 ,
 0.487455 , 0.504423 , 0.521981 , 0.540151 , 0.558953 , 0.57841  ,
 0.598544 , 0.619379 , 0.640939 , 0.663249 , 0.686336 , 0.710227 ,
 0.73495  , 0.760533 , 0.787006 , 0.814401 , 0.84275  , 0.872085 ,
 0.902442 , 0.933855 , 0.966362 , 1.       }
,
{0.0270634, 0.0280684, 0.0291106, 0.0301916, 0.0313127, 0.0324755,
 0.0336814, 0.0349321, 0.0362292, 0.0375745, 0.0389698, 0.0404168,
 0.0419176, 0.0434742, 0.0450885, 0.0467628, 0.0484992, 0.0503002,
 0.052168 , 0.0541051, 0.0561142, 0.0581979, 0.060359 , 0.0626003,
 0.0649249, 0.0673357, 0.0698361, 0.0724294, 0.0751189, 0.0779083,
 0.0808013, 0.0838017, 0.0869135, 0.0901409, 0.0934881, 0.0969596,
 0.10056  , 0.104294 , 0.108167 , 0.112183 , 0.116349 , 0.12067  ,
 0.12515  , 0.129798 , 0.134617 , 0.139616 , 0.144801 , 0.150178 ,
 0.155754 , 0.161538 , 0.167536 , 0.173757 , 0.180209 , 0.186901 ,
 0.193841 , 0.201039 , 0.208505 , 0.216247 , 0.224277 , 0.232605 ,
 0.241242 , 0.250201 , 0.259491 , 0.269127 , 0.279121 , 0.289485 ,
 0.300235 , 0.311383 , 0.322946 , 0.334938 , 0.347375 , 0.360274 ,
 0.373653 , 0.387527 , 0.401918 , 0.416842 , 0.432321 , 0.448374 ,
 0.465024 , 0.482292 , 0.500201 , 0.518775 , 0.538038 , 0.558017 ,
 0.578738 , 0.600229 , 0.622517 , 0.645633 , 0.669607 , 0.694472 ,
 0.72026  , 0.747006 , 0.774744 , 0.803513 , 0.83335  , 0.864295 ,
 0.896389 , 0.929675 , 0.964196 , 1.       }
,
{0.0216481, 0.0225026, 0.0233909, 0.0243142, 0.025274 , 0.0262717,
 0.0273088, 0.0283868, 0.0295074, 0.0306722, 0.0318829, 0.0331415,
 0.0344498, 0.0358097, 0.0372232, 0.0386926, 0.04022  , 0.0418077,
 0.043458 , 0.0451735, 0.0469567, 0.0488103, 0.0507371, 0.05274  ,
 0.0548218, 0.0569859, 0.0592354, 0.0615737, 0.0640043, 0.0665309,
 0.0691572, 0.0718872, 0.0747249, 0.0776746, 0.0807408, 0.083928 ,
 0.0872411, 0.0906849, 0.0942647, 0.0979858, 0.101854 , 0.105874 ,
 0.110054 , 0.114398 , 0.118914 , 0.123608 , 0.128487 , 0.133559 ,
 0.138832 , 0.144312 , 0.150009 , 0.15593  , 0.162086 , 0.168484 ,
 0.175135 , 0.182048 , 0.189234 , 0.196704 , 0.204469 , 0.212541 ,
 0.220931 , 0.229652 , 0.238717 , 0.248141 , 0.257936 , 0.268118 ,
 0.278702 , 0.289703 , 0.301139 , 0.313027 , 0.325383 , 0.338228 ,
 0.351579 , 0.365458 , 0.379884 , 0.39488  , 0.410468 , 0.426671 ,
 0.443514 , 0.461021 , 0.47922  , 0.498137 , 0.517801 , 0.538241 ,
 0.559488 , 0.581574 , 0.604531 , 0.628395 , 0.653201 , 0.678985 ,
 0.705788 , 0.733649 , 0.76261  , 0.792714 , 0.824006 , 0.856533 ,
 0.890345 , 0.925491 , 0.962024 , 1.       }
,
{0.0172999, 0.0180236, 0.0187775, 0.019563 , 0.0203814, 0.021234 ,
 0.0221222, 0.0230476, 0.0240117, 0.0250162, 0.0260627, 0.0271529,
 0.0282887, 0.0294721, 0.030705 , 0.0319894, 0.0333276, 0.0347217,
 0.0361742, 0.0376874, 0.039264 , 0.0409064, 0.0426176, 0.0444004,
 0.0462577, 0.0481928, 0.0502087, 0.0523091, 0.0544972, 0.0567769,
 0.059152 , 0.0616264, 0.0642044, 0.0668901, 0.0696883, 0.0726034,
 0.0756406, 0.0788047, 0.0821013, 0.0855357, 0.0891138, 0.0928416,
 0.0967253, 0.100771 , 0.104987 , 0.109379 , 0.113954 , 0.118721 ,
 0.123687 , 0.128861 , 0.134252 , 0.139868 , 0.145719 , 0.151814 ,
 0.158165 , 0.164781 , 0.171674 , 0.178856 , 0.186338 , 0.194133 ,
 0.202253 , 0.210714 , 0.219528 , 0.228712 , 0.238279 , 0.248247 ,
 0.258631 , 0.26945  , 0.280722 , 0.292465 , 0.304699 , 0.317445 ,
 0.330724 , 0.344559 , 0.358973 , 0.373989 , 0.389634 , 0.405933 ,
 0.422914 , 0.440605 , 0.459036 , 0.478238 , 0.498244 , 0.519086 ,
 0.5408   , 0.563423 , 0.586992 , 0.611546 , 0.637128 , 0.663781 ,
 0.691548 , 0.720476 , 0.750615 , 0.782014 , 0.814727 , 0.848809 ,
 0.884316 , 0.921308 , 0.959848 , 1.       }
,
{0.0138146, 0.0144252, 0.0150628, 0.0157286, 0.0164239, 0.0171498,
 0.0179079, 0.0186995, 0.019526 , 0.0203891, 0.0212903, 0.0222314,
 0.0232141, 0.0242402, 0.0253116, 0.0264305, 0.0275987, 0.0288187,
 0.0300925, 0.0314226, 0.0328116, 0.0342619, 0.0357764, 0.0373577,
 0.039009 , 0.0407333, 0.0425338, 0.0444139, 0.046377 , 0.048427 ,
 0.0505675, 0.0528027, 0.0551367, 0.0575738, 0.0601187, 0.0627761,
 0.0655509, 0.0684484, 0.0714739, 0.0746332, 0.0779321, 0.0813769,
 0.0849739, 0.0887299, 0.0926519, 0.0967473, 0.101024 , 0.105489 ,
 0.110152 , 0.115021 , 0.120105 , 0.125414 , 0.130957 , 0.136746 ,
 0.14279  , 0.149102 , 0.155693 , 0.162574 , 0.169761 , 0.177264 ,
 0.1851   , 0.193281 , 0.201825 , 0.210746 , 0.220061 , 0.229788 ,
 0.239946 , 0.250552 , 0.261626 , 0.273191 , 0.285266 , 0.297876 ,
 0.311042 , 0.324791 , 0.339147 , 0.354138 , 0.369792 , 0.386137 ,
 0.403205 , 0.421028 , 0.439638 , 0.459071 , 0.479363 , 0.500551 ,
 0.522677 , 0.54578  , 0.569904 , 0.595095 , 0.621399 , 0.648866 ,
 0.677548 , 0.707496 , 0.738769 , 0.771424 , 0.805522 , 0.841128 ,
 0.878308 , 0.91713  , 0.957669 , 1.       }
,
{0.0110248, 0.0115383, 0.0120758, 0.0126384, 0.0132271, 0.0138433,
 0.0144882, 0.0151631, 0.0158694, 0.0166087, 0.0173824, 0.0181921,
 0.0190396, 0.0199265, 0.0208548, 0.0218263, 0.022843 , 0.0239072,
 0.0250208, 0.0261864, 0.0274063, 0.028683 , 0.0300191, 0.0314175,
 0.0328811, 0.0344128, 0.0360159, 0.0376937, 0.0394496, 0.0412873,
 0.0432106, 0.0452235, 0.0473302, 0.0495351, 0.0518426, 0.0542576,
 0.0567852, 0.0594304, 0.0621989, 0.0650964, 0.0681288, 0.0713026,
 0.0746241, 0.0781004, 0.0817386, 0.0855463, 0.0895314, 0.0937021,
 0.0980671, 0.102635 , 0.107417 , 0.112421 , 0.117658 , 0.123138 ,
 0.128875 , 0.134878 , 0.141161 , 0.147737 , 0.154619 , 0.161822 ,
 0.16936  , 0.17725  , 0.185507 , 0.194149 , 0.203193 , 0.212658 ,
 0.222565 , 0.232933 , 0.243784 , 0.25514  , 0.267025 , 0.279464 ,
 0.292483 , 0.306108 , 0.320368 , 0.335292 , 0.350911 , 0.367258 ,
 0.384366 , 0.402271 , 0.421011 , 0.440623 , 0.461149 , 0.482631 ,
 0.505114 , 0.528644 , 0.55327  , 0.579044 , 0.606018 , 0.634249 ,
 0.663794 , 0.694716 , 0.727079 , 0.760949 , 0.796397 , 0.833497 ,
 0.872324 , 0.91296  , 0.95549  , 1.       }
,
{0.00879407, 0.00922477, 0.00967657, 0.0101505 , 0.0106476 , 0.0111691 ,
 0.0117161 , 0.01229   , 0.0128919 , 0.0135233 , 0.0141856 , 0.0148804 ,
 0.0156091 , 0.0163736 , 0.0171755 , 0.0180167 , 0.0188991 , 0.0198248 ,
 0.0207957 , 0.0218142 , 0.0228826 , 0.0240033 , 0.0251789 , 0.0264121 ,
 0.0277056 , 0.0290626 , 0.0304859 , 0.031979  , 0.0335453 , 0.0351882 ,
 0.0369116 , 0.0387194 , 0.0406157 , 0.0426049 , 0.0446916 , 0.0468804 ,
 0.0491764 , 0.0515849 , 0.0541114 , 0.0567616 , 0.0595416 , 0.0624577 ,
 0.0655167 , 0.0687254 , 0.0720914 , 0.0756221 , 0.0793259 , 0.083211  ,
 0.0872863 , 0.0915613 , 0.0960457 , 0.10075   , 0.105684  , 0.11086   ,
 0.11629   , 0.121985  , 0.127959  , 0.134226  , 0.1408    , 0.147696  ,
 0.15493   , 0.162518  , 0.170477  , 0.178827  , 0.187585  , 0.196772  ,
 0.20641   , 0.216519  , 0.227123  , 0.238247  , 0.249915  , 0.262155  ,
 0.274995  , 0.288463  , 0.302591  , 0.317411  , 0.332957  , 0.349264  ,
 0.366369  , 0.384313  , 0.403135  , 0.422879  , 0.44359   , 0.465316  ,
 0.488105  , 0.512011  , 0.537088  , 0.563392  , 0.590985  , 0.61993   ,
 0.650292  , 0.682141  , 0.71555   , 0.750595  , 0.787356  , 0.825918  ,
 0.866369  , 0.9088    , 0.95331   , 1.        }
,
{0.00701202, 0.00737229, 0.00775106, 0.0081493 , 0.008568  , 0.00900822,
 0.00947105, 0.00995766, 0.0104693 , 0.0110072 , 0.0115727 , 0.0121673 ,
 0.0127924 , 0.0134497 , 0.0141407 , 0.0148672 , 0.0156311 , 0.0164342 ,
 0.0172786 , 0.0181663 , 0.0190997 , 0.020081  , 0.0211127 , 0.0221975 ,
 0.023338  , 0.024537  , 0.0257977 , 0.0271232 , 0.0285167 , 0.0299819 ,
 0.0315223 , 0.0331419 , 0.0348447 , 0.0366349 , 0.0385172 , 0.0404961 ,
 0.0425768 , 0.0447643 , 0.0470642 , 0.0494823 , 0.0520247 , 0.0546976 ,
 0.0575079 , 0.0604626 , 0.0635691 , 0.0668352 , 0.0702691 , 0.0738794 ,
 0.0776753 , 0.0816661 , 0.085862  , 0.0902735 , 0.0949116 , 0.0997881 ,
 0.104915  , 0.110305  , 0.115973  , 0.121931  , 0.128196  , 0.134783  ,
 0.141707  , 0.148988  , 0.156643  , 0.164691  , 0.173153  , 0.182049  ,
 0.191403  , 0.201237  , 0.211576  , 0.222446  , 0.233875  , 0.245891  ,
 0.258525  , 0.271808  , 0.285773  , 0.300455  , 0.315892  , 0.332123  ,
 0.349187  , 0.367127  , 0.38599   , 0.405822  , 0.426672  , 0.448594  ,
 0.471642  , 0.495874  , 0.521352  , 0.548138  , 0.576301  , 0.60591   ,
 0.637041  , 0.669772  , 0.704184  , 0.740364  , 0.778402  , 0.818396  ,
 0.860444  , 0.904652  , 0.951132  , 1.        }
,
{0.00558937, 0.00589002, 0.00620684, 0.0065407 , 0.00689252, 0.00726327,
 0.00765396, 0.00806566, 0.00849951, 0.00895669, 0.00943847, 0.00994616,
 0.0104812 , 0.0110449 , 0.011639  , 0.0122651 , 0.0129248 , 0.0136201 ,
 0.0143527 , 0.0151247 , 0.0159383 , 0.0167956 , 0.017699  , 0.018651  ,
 0.0196542 , 0.0207114 , 0.0218255 , 0.0229995 , 0.0242366 , 0.0255403 ,
 0.0269141 , 0.0283618 , 0.0298874 , 0.031495  , 0.0331891 , 0.0349743 ,
 0.0368556 , 0.038838  , 0.0409271 , 0.0431286 , 0.0454484 , 0.0478931 ,
 0.0504693 , 0.053184  , 0.0560447 , 0.0590593 , 0.0622361 , 0.0655838 ,
 0.0691115 , 0.072829  , 0.0767464 , 0.0808746 , 0.0852248 , 0.089809  ,
 0.0946398 , 0.0997304 , 0.105095  , 0.110748  , 0.116705  , 0.122983  ,
 0.129598  , 0.136569  , 0.143915  , 0.151656  , 0.159813  , 0.16841   ,
 0.177468  , 0.187014  , 0.197074  , 0.207674  , 0.218845  , 0.230617  ,
 0.243021  , 0.256093  , 0.269868  , 0.284385  , 0.299682  , 0.315801  ,
 0.332788  , 0.350689  , 0.369552  , 0.38943   , 0.410377  , 0.432451  ,
 0.455713  , 0.480225  , 0.506057  , 0.533277  , 0.561962  , 0.59219   ,
 0.624043  , 0.65761   , 0.692983  , 0.730258  , 0.769539  , 0.810932  ,
 0.854552  , 0.900518  , 0.948956  , 1.        }
,
{0.00445426, 0.00470463, 0.00496907, 0.00524837, 0.00554338, 0.00585497,
 0.00618407, 0.00653166, 0.0068988 , 0.00728657, 0.00769614, 0.00812873,
 0.00858564, 0.00906822, 0.00957794, 0.0101163 , 0.0106849 , 0.0112855 ,
 0.0119199 , 0.0125899 , 0.0132975 , 0.0140449 , 0.0148344 , 0.0156682 ,
 0.0165489 , 0.0174791 , 0.0184616 , 0.0194993 , 0.0205953 , 0.0217529 ,
 0.0229757 , 0.0242671 , 0.0256311 , 0.0270718 , 0.0285935 , 0.0302007 ,
 0.0318982 , 0.0336912 , 0.0355849 , 0.0375851 , 0.0396977 , 0.041929  ,
 0.0442858 , 0.0467751 , 0.0494042 , 0.0521812 , 0.0551142 , 0.0582121 ,
 0.0614842 , 0.0649401 , 0.0685903 , 0.0724457 , 0.0765177 , 0.0808187 ,
 0.0853614 , 0.0901595 , 0.0952272 , 0.10058   , 0.106233  , 0.112205  ,
 0.118511  , 0.125173  , 0.132209  , 0.13964   , 0.147489  , 0.155779  ,
 0.164535  , 0.173783  , 0.183552  , 0.193869  , 0.204766  , 0.216275  ,
 0.228432  , 0.241272  , 0.254833  , 0.269157  , 0.284286  , 0.300266  ,
 0.317143  , 0.334969  , 0.353798  , 0.373684  , 0.394688  , 0.416873  ,
 0.440305  , 0.465054  , 0.491194  , 0.518804  , 0.547965  , 0.578765  ,
 0.611297  , 0.645657  , 0.681949  , 0.72028   , 0.760766  , 0.803528  ,
 0.848693  , 0.896397  , 0.946783  , 1.        }
,
{0.00354898, 0.00375708, 0.00397738, 0.00421059, 0.00445748, 0.00471885,
 0.00499554, 0.00528846, 0.00559855, 0.00592682, 0.00627434, 0.00664224,
 0.00703171, 0.00744402, 0.0078805 , 0.00834258, 0.00883175, 0.0093496 ,
 0.00989782, 0.0104782 , 0.0110926 , 0.011743  , 0.0124316 , 0.0131605 ,
 0.0139322 , 0.0147491 , 0.0156139 , 0.0165294 , 0.0174986 , 0.0185247 ,
 0.0196109 , 0.0207608 , 0.0219781 , 0.0232668 , 0.024631  , 0.0260753 ,
 0.0276042 , 0.0292228 , 0.0309363 , 0.0327502 , 0.0346706 , 0.0367035 ,
 0.0388556 , 0.0411339 , 0.0435458 , 0.0460992 , 0.0488022 , 0.0516638 ,
 0.0546931 , 0.0579    , 0.061295  , 0.0648891 , 0.0686939 , 0.0727218 ,
 0.0769859 , 0.0815    , 0.0862787 , 0.0913377 , 0.0966934 , 0.102363  ,
 0.108365  , 0.114719  , 0.121446  , 0.128567  , 0.136105  , 0.144086  ,
 0.152534  , 0.161478  , 0.170947  , 0.18097   , 0.191582  , 0.202815  ,
 0.214707  , 0.227297  , 0.240624  , 0.254733  , 0.26967   , 0.285482  ,
 0.302221  , 0.319942  , 0.338702  , 0.358562  , 0.379587  , 0.401844  ,
 0.425406  , 0.45035   , 0.476756  , 0.504711  , 0.534305  , 0.565634  ,
 0.598801  , 0.633911  , 0.671081  , 0.71043   , 0.752087  , 0.796186  ,
 0.84287   , 0.892292  , 0.944612  , 1.        }
,
{0.00282726, 0.00299991, 0.00318312, 0.00337751, 0.00358377, 0.00380263,
 0.00403485, 0.00428126, 0.00454271, 0.00482013, 0.0051145 , 0.00542684,
 0.00575825, 0.0061099 , 0.00648303, 0.00687895, 0.00729904, 0.00774479,
 0.00821776, 0.00871961, 0.00925211, 0.00981713, 0.0104167 , 0.0110528 ,
 0.0117278 , 0.012444  , 0.0132039 , 0.0140103 , 0.0148659 , 0.0157737 ,
 0.016737  , 0.0177592 , 0.0188437 , 0.0199945 , 0.0212155 , 0.0225111 ,
 0.0238859 , 0.0253446 , 0.0268924 , 0.0285347 , 0.0302773 , 0.0321263 ,
 0.0340882 , 0.03617   , 0.0383788 , 0.0407226 , 0.0432095 , 0.0458483 ,
 0.0486482 , 0.0516191 , 0.0547715 , 0.0581163 , 0.0616655 , 0.0654313 ,
 0.0694272 , 0.0736671 , 0.0781659 , 0.0829394 , 0.0880045 , 0.0933789 ,
 0.0990814 , 0.105132  , 0.111553  , 0.118365  , 0.125594  , 0.133264  ,
 0.141402  , 0.150037  , 0.1592    , 0.168922  , 0.179238  , 0.190184  ,
 0.201798  , 0.214122  , 0.227198  , 0.241073  , 0.255796  , 0.271417  ,
 0.287992  , 0.30558   , 0.324241  , 0.344042  , 0.365053  , 0.387346  ,
 0.411001  , 0.436101  , 0.462733  , 0.490992  , 0.520977  , 0.552792  ,
 0.586551  , 0.622372  , 0.660379  , 0.700708  , 0.7435    , 0.788905  ,
 0.837083  , 0.888203  , 0.942445  , 1.        }
,
{0.00225202, 0.00239505, 0.00254716, 0.00270893, 0.00288097, 0.00306395,
 0.00325854, 0.00346549, 0.00368558, 0.00391965, 0.00416859, 0.00443334,
 0.0047149 , 0.00501435, 0.00533281, 0.0056715 , 0.0060317 , 0.00641477,
 0.00682218, 0.00725546, 0.00771625, 0.00820631, 0.0087275 , 0.00928178,
 0.00987127, 0.0104982 , 0.0111649 , 0.011874  , 0.0126282 , 0.0134302 ,
 0.0142831 , 0.0151903 , 0.016155  , 0.017181  , 0.0182722 , 0.0194326 ,
 0.0206668 , 0.0219794 , 0.0233753 , 0.0248599 , 0.0264387 , 0.0281178 ,
 0.0299036 , 0.0318028 , 0.0338226 , 0.0359707 , 0.0382552 , 0.0406848 ,
 0.0432687 , 0.0460167 , 0.0489392 , 0.0520474 , 0.0553529 , 0.0588684 ,
 0.0626071 , 0.0665833 , 0.0708121 , 0.0753094 , 0.0800923 , 0.085179  ,
 0.0905887 , 0.096342  , 0.102461  , 0.108968  , 0.115889  , 0.123249  ,
 0.131076  , 0.139401  , 0.148254  , 0.15767   , 0.167684  , 0.178333  ,
 0.189659  , 0.201705  , 0.214515  , 0.228139  , 0.242628  , 0.258037  ,
 0.274426  , 0.291854  , 0.31039   , 0.330103  , 0.351068  , 0.373364  ,
 0.397077  , 0.422295  , 0.449115  , 0.477639  , 0.507974  , 0.540235  ,
 0.574546  , 0.611036  , 0.649843  , 0.691114  , 0.735007  , 0.781688  ,
 0.831333  , 0.884131  , 0.940282  , 1.        }
,
{0.00179365, 0.00191195, 0.00203806, 0.00217249, 0.00231578, 0.00246853,
 0.00263134, 0.0028049 , 0.00298991, 0.00318711, 0.00339733, 0.00362141,
 0.00386027, 0.00411489, 0.00438629, 0.00467561, 0.004984  , 0.00531273,
 0.00566315, 0.00603668, 0.00643484, 0.00685927, 0.00731169, 0.00779396,
 0.00830803, 0.00885601, 0.00944013, 0.0100628 , 0.0107265 , 0.011434  ,
 0.0121882 , 0.0129921 , 0.013849  , 0.0147624 , 0.0157361 , 0.0167741 ,
 0.0178804 , 0.0190598 , 0.0203169 , 0.021657  , 0.0230855 , 0.0246081 ,
 0.0262312 , 0.0279614 , 0.0298056 , 0.0317716 , 0.0338671 , 0.036101  ,
 0.0384821 , 0.0410203 , 0.0437259 , 0.04661   , 0.0496843 , 0.0529613 ,
 0.0564545 , 0.0601782 , 0.0641474 , 0.0683784 , 0.0728885 , 0.0776961 ,
 0.0828207 , 0.0882834 , 0.0941064 , 0.100313  , 0.10693   , 0.113983  ,
 0.121501  , 0.129515  , 0.138057  , 0.147163  , 0.15687   , 0.167217  ,
 0.178246  , 0.190003  , 0.202535  , 0.215893  , 0.230133  , 0.245312  ,
 0.261493  , 0.27874   , 0.297125  , 0.316723  , 0.337613  , 0.359882  ,
 0.383619  , 0.408921  , 0.435893  , 0.464643  , 0.49529   , 0.527958  ,
 0.562781  , 0.599901  , 0.639469  , 0.681647  , 0.726607  , 0.774533  ,
 0.825619  , 0.880076  , 0.938123  , 1.        }
,
{0.00142846, 0.00152618, 0.00163059, 0.00174215, 0.00186133, 0.00198867,
 0.00212471, 0.00227007, 0.00242537, 0.00259129, 0.00276857, 0.00295797,
 0.00316033, 0.00337654, 0.00360753, 0.00385433, 0.00411801, 0.00439973,
 0.00470073, 0.00502231, 0.0053659 , 0.00573299, 0.00612519, 0.00654423,
 0.00699193, 0.00747027, 0.00798132, 0.00852734, 0.00911071, 0.00973399,
 0.0103999 , 0.0111114 , 0.0118715 , 0.0126837 , 0.0135514 , 0.0144785 ,
 0.015469  , 0.0165272 , 0.0176579 , 0.0188659 , 0.0201566 , 0.0215355 ,
 0.0230088 , 0.0245829 , 0.0262646 , 0.0280614 , 0.0299812 , 0.0320323 ,
 0.0342236 , 0.0365649 , 0.0390664 , 0.041739  , 0.0445945 , 0.0476453 ,
 0.0509048 , 0.0543872 , 0.058108  , 0.0620833 , 0.0663305 , 0.0708683 ,
 0.0757165 , 0.0808964 , 0.0864307 , 0.0923436 , 0.098661  , 0.105411  ,
 0.112622  , 0.120327  , 0.128558  , 0.137353  , 0.14675   , 0.156789  ,
 0.167516  , 0.178976  , 0.19122   , 0.204301  , 0.218278  , 0.233211  ,
 0.249165  , 0.266211  , 0.284423  , 0.303881  , 0.32467   , 0.346881  ,
 0.370612  , 0.395966  , 0.423055  , 0.451997  , 0.482919  , 0.515956  ,
 0.551254  , 0.588966  , 0.629258  , 0.672307  , 0.718301  , 0.767441  ,
 0.819943  , 0.876037  , 0.935969  , 1.        }
,
{0.00113756, 0.00121818, 0.00130451, 0.00139696, 0.00149597, 0.00160199,
 0.00171553, 0.00183711, 0.00196731, 0.00210674, 0.00225605, 0.00241594,
 0.00258717, 0.00277052, 0.00296688, 0.00317715, 0.00340232, 0.00364345,
 0.00390167, 0.00417819, 0.0044743 , 0.00479141, 0.00513099, 0.00549463,
 0.00588405, 0.00630106, 0.00674763, 0.00722585, 0.00773797, 0.00828637,
 0.00887365, 0.00950254, 0.010176  , 0.0108972 , 0.0116695 , 0.0124966 ,
 0.0133822 , 0.0143306 , 0.0153463 , 0.0164339 , 0.0175986 , 0.0188459 ,
 0.0201815 , 0.0216118 , 0.0231435 , 0.0247837 , 0.0265402 , 0.0284212 ,
 0.0304355 , 0.0325925 , 0.0349024 , 0.037376  , 0.0400249 , 0.0428616 ,
 0.0458993 , 0.0491522 , 0.0526358 , 0.0563662 , 0.060361  , 0.0646389 ,
 0.06922   , 0.0741258 , 0.0793792 , 0.085005  , 0.0910295 , 0.097481  ,
 0.10439   , 0.111788  , 0.119711  , 0.128195  , 0.13728   , 0.14701   ,
 0.157429  , 0.168586  , 0.180534  , 0.193329  , 0.20703   , 0.221703  ,
 0.237416  , 0.254242  , 0.27226   , 0.291556  , 0.312219  , 0.334347  ,
 0.358043  , 0.383418  , 0.410592  , 0.439692  , 0.470854  , 0.504224  ,
 0.539959  , 0.578228  , 0.619208  , 0.663092  , 0.710087  , 0.760413  ,
 0.814305  , 0.872016  , 0.933818  , 1.        }
,
{9.05848e-04, 9.72282e-04, 1.04359e-03, 1.12012e-03, 1.20227e-03,
 1.29044e-03, 1.38508e-03, 1.48666e-03, 1.59569e-03, 1.71272e-03,
 1.83833e-03, 1.97315e-03, 2.11786e-03, 2.27318e-03, 2.43989e-03,
 2.61883e-03, 2.81089e-03, 3.01704e-03, 3.23831e-03, 3.47580e-03,
 3.73071e-03, 4.00432e-03, 4.29799e-03, 4.61320e-03, 4.95152e-03,
 5.31466e-03, 5.70443e-03, 6.12279e-03, 6.57183e-03, 7.05380e-03,
 7.57111e-03, 8.12637e-03, 8.72235e-03, 9.36203e-03, 1.00486e-02,
 1.07856e-02, 1.15766e-02, 1.24256e-02, 1.33369e-02, 1.43150e-02,
 1.53648e-02, 1.64917e-02, 1.77012e-02, 1.89993e-02, 2.03927e-02,
 2.18883e-02, 2.34936e-02, 2.52165e-02, 2.70659e-02, 2.90509e-02,
 3.11814e-02, 3.34682e-02, 3.59228e-02, 3.85573e-02, 4.13850e-02,
 4.44202e-02, 4.76779e-02, 5.11745e-02, 5.49276e-02, 5.89559e-02,
 6.32797e-02, 6.79205e-02, 7.29017e-02, 7.82483e-02, 8.39869e-02,
 9.01464e-02, 9.67576e-02, 1.03854e-01, 1.11470e-01, 1.19645e-01,
 1.28420e-01, 1.37838e-01, 1.47947e-01, 1.58797e-01, 1.70443e-01,
 1.82943e-01, 1.96360e-01, 2.10761e-01, 2.26218e-01, 2.42808e-01,
 2.60616e-01, 2.79729e-01, 3.00244e-01, 3.22263e-01, 3.45898e-01,
 3.71265e-01, 3.98494e-01, 4.27719e-01, 4.59087e-01, 4.92756e-01,
 5.28894e-01, 5.67682e-01, 6.09316e-01, 6.54002e-01, 7.01966e-01,
 7.53447e-01, 8.08704e-01, 8.68013e-01, 9.31672e-01, 1.00000e+00}
,
{7.21308e-04, 7.75992e-04, 8.34821e-04, 8.98110e-04, 9.66197e-04,
 1.03945e-03, 1.11825e-03, 1.20302e-03, 1.29423e-03, 1.39234e-03,
 1.49790e-03, 1.61146e-03, 1.73362e-03, 1.86505e-03, 2.00644e-03,
 2.15856e-03, 2.32220e-03, 2.49825e-03, 2.68764e-03, 2.89140e-03,
 3.11060e-03, 3.34642e-03, 3.60011e-03, 3.87304e-03, 4.16667e-03,
 4.48255e-03, 4.82237e-03, 5.18797e-03, 5.58127e-03, 6.00440e-03,
 6.45960e-03, 6.94931e-03, 7.47615e-03, 8.04292e-03, 8.65267e-03,
 9.30864e-03, 1.00143e-02, 1.07735e-02, 1.15903e-02, 1.24690e-02,
 1.34143e-02, 1.44312e-02, 1.55253e-02, 1.67023e-02, 1.79685e-02,
 1.93307e-02, 2.07962e-02, 2.23728e-02, 2.40689e-02, 2.58936e-02,
 2.78566e-02, 2.99685e-02, 3.22404e-02, 3.46846e-02, 3.73141e-02,
 4.01430e-02, 4.31862e-02, 4.64603e-02, 4.99825e-02, 5.37717e-02,
 5.78482e-02, 6.22338e-02, 6.69518e-02, 7.20275e-02, 7.74880e-02,
 8.33625e-02, 8.96824e-02, 9.64813e-02, 1.03796e-01, 1.11665e-01,
 1.20130e-01, 1.29237e-01, 1.39035e-01, 1.49575e-01, 1.60915e-01,
 1.73114e-01, 1.86238e-01, 2.00357e-01, 2.15546e-01, 2.31887e-01,
 2.49467e-01, 2.68379e-01, 2.88726e-01, 3.10614e-01, 3.34163e-01,
 3.59496e-01, 3.86750e-01, 4.16070e-01, 4.47613e-01, 4.81547e-01,
 5.18054e-01, 5.57328e-01, 5.99580e-01, 6.45035e-01, 6.93936e-01,
 7.46544e-01, 8.03141e-01, 8.64028e-01, 9.29531e-01, 1.00000e+00}
,
{5.74345e-04, 6.19311e-04, 6.67797e-04, 7.20079e-04, 7.76454e-04,
 8.37243e-04, 9.02790e-04, 9.73470e-04, 1.04968e-03, 1.13186e-03,
 1.22048e-03, 1.31603e-03, 1.41906e-03, 1.53016e-03, 1.64995e-03,
 1.77913e-03, 1.91842e-03, 2.06861e-03, 2.23056e-03, 2.40519e-03,
 2.59350e-03, 2.79654e-03, 3.01548e-03, 3.25157e-03, 3.50613e-03,
 3.78063e-03, 4.07661e-03, 4.39577e-03, 4.73992e-03, 5.11100e-03,
 5.51115e-03, 5.94261e-03, 6.40786e-03, 6.90953e-03, 7.45048e-03,
 8.03378e-03, 8.66275e-03, 9.34095e-03, 1.00723e-02, 1.08608e-02,
 1.17111e-02, 1.26280e-02, 1.36166e-02, 1.46827e-02, 1.58322e-02,
 1.70717e-02, 1.84082e-02, 1.98494e-02, 2.14034e-02, 2.30791e-02,
 2.48860e-02, 2.68343e-02, 2.89351e-02, 3.12005e-02, 3.36432e-02,
 3.62771e-02, 3.91172e-02, 4.21797e-02, 4.54820e-02, 4.90428e-02,
 5.28823e-02, 5.70225e-02, 6.14868e-02, 6.63006e-02, 7.14913e-02,
 7.70884e-02, 8.31236e-02, 8.96314e-02, 9.66486e-02, 1.04215e-01,
 1.12374e-01, 1.21172e-01, 1.30659e-01, 1.40888e-01, 1.51918e-01,
 1.63812e-01, 1.76637e-01, 1.90465e-01, 2.05377e-01, 2.21456e-01,
 2.38794e-01, 2.57489e-01, 2.77648e-01, 2.99385e-01, 3.22824e-01,
 3.48098e-01, 3.75350e-01, 4.04737e-01, 4.36424e-01, 4.70591e-01,
 5.07434e-01, 5.47161e-01, 5.89998e-01, 6.36189e-01, 6.85996e-01,
 7.39703e-01, 7.97615e-01, 8.60060e-01, 9.27394e-01, 1.00000e+00}
,
{4.57314e-04, 4.94254e-04, 5.34177e-04, 5.77325e-04, 6.23958e-04,
 6.74358e-04, 7.28829e-04, 7.87700e-04, 8.51327e-04, 9.20092e-04,
 9.94413e-04, 1.07474e-03, 1.16155e-03, 1.25537e-03, 1.35677e-03,
 1.46637e-03, 1.58481e-03, 1.71283e-03, 1.85118e-03, 2.00071e-03,
 2.16231e-03, 2.33697e-03, 2.52574e-03, 2.72976e-03, 2.95026e-03,
 3.18856e-03, 3.44612e-03, 3.72448e-03, 4.02532e-03, 4.35046e-03,
 4.70187e-03, 5.08166e-03, 5.49214e-03, 5.93576e-03, 6.41522e-03,
 6.93341e-03, 7.49345e-03, 8.09874e-03, 8.75291e-03, 9.45992e-03,
 1.02240e-02, 1.10499e-02, 1.19424e-02, 1.29071e-02, 1.39497e-02,
 1.50764e-02, 1.62942e-02, 1.76104e-02, 1.90329e-02, 2.05703e-02,
 2.22318e-02, 2.40276e-02, 2.59684e-02, 2.80660e-02, 3.03330e-02,
 3.27832e-02, 3.54312e-02, 3.82932e-02, 4.13863e-02, 4.47293e-02,
 4.83423e-02, 5.22471e-02, 5.64673e-02, 6.10285e-02, 6.59580e-02,
 7.12858e-02, 7.70439e-02, 8.32671e-02, 8.99930e-02, 9.72621e-02,
 1.05118e-01, 1.13609e-01, 1.22786e-01, 1.32704e-01, 1.43423e-01,
 1.55008e-01, 1.67529e-01, 1.81061e-01, 1.95686e-01, 2.11493e-01,
 2.28576e-01, 2.47039e-01, 2.66994e-01, 2.88560e-01, 3.11869e-01,
 3.37060e-01, 3.64286e-01, 3.93711e-01, 4.25513e-01, 4.59884e-01,
 4.97031e-01, 5.37178e-01, 5.80569e-01, 6.27464e-01, 6.78147e-01,
 7.32924e-01, 7.92126e-01, 8.56110e-01, 9.25262e-01, 1.00000e+00}
,
{3.64123e-04, 3.94441e-04, 4.27285e-04, 4.62863e-04, 5.01403e-04,
 5.43153e-04, 5.88379e-04, 6.37370e-04, 6.90441e-04, 7.47931e-04,
 8.10208e-04, 8.77670e-04, 9.50749e-04, 1.02991e-03, 1.11567e-03,
 1.20857e-03, 1.30920e-03, 1.41821e-03, 1.53630e-03, 1.66422e-03,
 1.80279e-03, 1.95290e-03, 2.11551e-03, 2.29166e-03, 2.48247e-03,
 2.68918e-03, 2.91309e-03, 3.15565e-03, 3.41841e-03, 3.70304e-03,
 4.01138e-03, 4.34539e-03, 4.70721e-03, 5.09916e-03, 5.52374e-03,
 5.98368e-03, 6.48191e-03, 7.02163e-03, 7.60629e-03, 8.23963e-03,
 8.92570e-03, 9.66891e-03, 1.04740e-02, 1.13461e-02, 1.22909e-02,
 1.33143e-02, 1.44229e-02, 1.56238e-02, 1.69247e-02, 1.83340e-02,
 1.98605e-02, 2.15142e-02, 2.33056e-02, 2.52462e-02, 2.73483e-02,
 2.96255e-02, 3.20923e-02, 3.47644e-02, 3.76591e-02, 4.07948e-02,
 4.41916e-02, 4.78713e-02, 5.18573e-02, 5.61752e-02, 6.08526e-02,
 6.59196e-02, 7.14084e-02, 7.73542e-02, 8.37952e-02, 9.07724e-02,
 9.83306e-02, 1.06518e-01, 1.15387e-01, 1.24995e-01, 1.35403e-01,
 1.46677e-01, 1.58890e-01, 1.72121e-01, 1.86452e-01, 2.01977e-01,
 2.18795e-01, 2.37013e-01, 2.56748e-01, 2.78126e-01, 3.01285e-01,
 3.26371e-01, 3.53547e-01, 3.82985e-01, 4.14874e-01, 4.49419e-01,
 4.86840e-01, 5.27377e-01, 5.71289e-01, 6.18858e-01, 6.70387e-01,
 7.26207e-01, 7.86675e-01, 8.52178e-01, 9.23135e-01, 1.00000e+00}
,
{2.89917e-04, 3.14781e-04, 3.41777e-04, 3.71089e-04, 4.02914e-04,
 4.37469e-04, 4.74987e-04, 5.15722e-04, 5.59952e-04, 6.07974e-04,
 6.60115e-04, 7.16728e-04, 7.78196e-04, 8.44936e-04, 9.17399e-04,
 9.96077e-04, 1.08150e-03, 1.17425e-03, 1.27496e-03, 1.38430e-03,
 1.50302e-03, 1.63193e-03, 1.77188e-03, 1.92384e-03, 2.08884e-03,
 2.26798e-03, 2.46248e-03, 2.67367e-03, 2.90297e-03, 3.15194e-03,
 3.42225e-03, 3.71575e-03, 4.03442e-03, 4.38042e-03, 4.75609e-03,
 5.16399e-03, 5.60686e-03, 6.08771e-03, 6.60981e-03, 7.17668e-03,
 7.79216e-03, 8.46044e-03, 9.18602e-03, 9.97383e-03, 1.08292e-02,
 1.17579e-02, 1.27663e-02, 1.38612e-02, 1.50499e-02, 1.63407e-02,
 1.77421e-02, 1.92637e-02, 2.09157e-02, 2.27095e-02, 2.46571e-02,
 2.67718e-02, 2.90678e-02, 3.15607e-02, 3.42674e-02, 3.72062e-02,
 4.03971e-02, 4.38616e-02, 4.76233e-02, 5.17076e-02, 5.61421e-02,
 6.09570e-02, 6.61847e-02, 7.18609e-02, 7.80238e-02, 8.47153e-02,
 9.19806e-02, 9.98691e-02, 1.08434e-01, 1.17734e-01, 1.27831e-01,
 1.38794e-01, 1.50697e-01, 1.63621e-01, 1.77653e-01, 1.92889e-01,
 2.09432e-01, 2.27393e-01, 2.46895e-01, 2.68069e-01, 2.91059e-01,
 3.16021e-01, 3.43123e-01, 3.72550e-01, 4.04501e-01, 4.39191e-01,
 4.76857e-01, 5.17754e-01, 5.62157e-01, 6.10369e-01, 6.62715e-01,
 7.19551e-01, 7.81261e-01, 8.48264e-01, 9.21012e-01, 1.00000e+00}
,
{2.30831e-04, 2.51205e-04, 2.73378e-04, 2.97507e-04, 3.23767e-04,
 3.52344e-04, 3.83443e-04, 4.17287e-04, 4.54119e-04, 4.94202e-04,
 5.37822e-04, 5.85292e-04, 6.36953e-04, 6.93173e-04, 7.54356e-04,
 8.20938e-04, 8.93398e-04, 9.72253e-04, 1.05807e-03, 1.15146e-03,
 1.25309e-03, 1.36369e-03, 1.48406e-03, 1.61505e-03, 1.75760e-03,
 1.91273e-03, 2.08156e-03, 2.26529e-03, 2.46523e-03, 2.68282e-03,
 2.91962e-03, 3.17732e-03, 3.45776e-03, 3.76296e-03, 4.09510e-03,
 4.45655e-03, 4.84990e-03, 5.27797e-03, 5.74383e-03, 6.25081e-03,
 6.80253e-03, 7.40295e-03, 8.05637e-03, 8.76746e-03, 9.54131e-03,
 1.03835e-02, 1.13000e-02, 1.22973e-02, 1.33828e-02, 1.45640e-02,
 1.58495e-02, 1.72484e-02, 1.87708e-02, 2.04276e-02, 2.22306e-02,
 2.41928e-02, 2.63282e-02, 2.86520e-02, 3.11810e-02, 3.39331e-02,
 3.69282e-02, 4.01877e-02, 4.37348e-02, 4.75950e-02, 5.17960e-02,
 5.63677e-02, 6.13430e-02, 6.67574e-02, 7.26497e-02, 7.90620e-02,
 8.60404e-02, 9.36347e-02, 1.01899e-01, 1.10893e-01, 1.20681e-01,
 1.31333e-01, 1.42925e-01, 1.55540e-01, 1.69269e-01, 1.84210e-01,
 2.00469e-01, 2.18163e-01, 2.37419e-01, 2.58374e-01, 2.81180e-01,
 3.05998e-01, 3.33007e-01, 3.62399e-01, 3.94386e-01, 4.29196e-01,
 4.67079e-01, 5.08306e-01, 5.53171e-01, 6.01996e-01, 6.55131e-01,
 7.12955e-01, 7.75884e-01, 8.44367e-01, 9.18894e-01, 1.00000e+00}
,
{1.83785e-04, 2.00468e-04, 2.18665e-04, 2.38514e-04, 2.60164e-04,
 2.83780e-04, 3.09540e-04, 3.37637e-04, 3.68286e-04, 4.01716e-04,
 4.38181e-04, 4.77956e-04, 5.21341e-04, 5.68664e-04, 6.20284e-04,
 6.76588e-04, 7.38004e-04, 8.04995e-04, 8.78066e-04, 9.57770e-04,
 1.04471e-03, 1.13954e-03, 1.24298e-03, 1.35581e-03, 1.47888e-03,
 1.61312e-03, 1.75955e-03, 1.91927e-03, 2.09348e-03, 2.28351e-03,
 2.49080e-03, 2.71689e-03, 2.96351e-03, 3.23252e-03, 3.52594e-03,
 3.84600e-03, 4.19511e-03, 4.57591e-03, 4.99128e-03, 5.44435e-03,
 5.93855e-03, 6.47761e-03, 7.06560e-03, 7.70696e-03, 8.40654e-03,
 9.16962e-03, 1.00020e-02, 1.09099e-02, 1.19002e-02, 1.29804e-02,
 1.41587e-02, 1.54439e-02, 1.68458e-02, 1.83749e-02, 2.00429e-02,
 2.18622e-02, 2.38467e-02, 2.60113e-02, 2.83724e-02, 3.09479e-02,
 3.37571e-02, 3.68213e-02, 4.01637e-02, 4.38094e-02, 4.77861e-02,
 5.21238e-02, 5.68552e-02, 6.20161e-02, 6.76455e-02, 7.37858e-02,
 8.04836e-02, 8.77893e-02, 9.57581e-02, 1.04450e-01, 1.13932e-01,
 1.24273e-01, 1.35554e-01, 1.47859e-01, 1.61280e-01, 1.75920e-01,
 1.91889e-01, 2.09307e-01, 2.28306e-01, 2.49030e-01, 2.71635e-01,
 2.96293e-01, 3.23188e-01, 3.52524e-01, 3.84524e-01, 4.19428e-01,
 4.57501e-01, 4.99029e-01, 5.44328e-01, 5.93738e-01, 6.47633e-01,
 7.06420e-01, 7.70544e-01, 8.40488e-01, 9.16781e-01, 1.00000e+00}
,
{1.46327e-04, 1.59977e-04, 1.74901e-04, 1.91217e-04, 2.09055e-04,
 2.28557e-04, 2.49878e-04, 2.73189e-04, 2.98674e-04, 3.26536e-04,
 3.56997e-04, 3.90301e-04, 4.26711e-04, 4.66517e-04, 5.10037e-04,
 5.57617e-04, 6.09635e-04, 6.66506e-04, 7.28682e-04, 7.96658e-04,
 8.70976e-04, 9.52226e-04, 1.04106e-03, 1.13817e-03, 1.24435e-03,
 1.36043e-03, 1.48734e-03, 1.62609e-03, 1.77778e-03, 1.94363e-03,
 2.12494e-03, 2.32317e-03, 2.53989e-03, 2.77683e-03, 3.03587e-03,
 3.31908e-03, 3.62871e-03, 3.96722e-03, 4.33730e-03, 4.74192e-03,
 5.18428e-03, 5.66790e-03, 6.19664e-03, 6.77471e-03, 7.40670e-03,
 8.09764e-03, 8.85305e-03, 9.67892e-03, 1.05818e-02, 1.15690e-02,
 1.26482e-02, 1.38281e-02, 1.51181e-02, 1.65284e-02, 1.80703e-02,
 1.97560e-02, 2.15990e-02, 2.36139e-02, 2.58168e-02, 2.82251e-02,
 3.08582e-02, 3.37368e-02, 3.68840e-02, 4.03248e-02, 4.40866e-02,
 4.81993e-02, 5.26956e-02, 5.76115e-02, 6.29858e-02, 6.88616e-02,
 7.52855e-02, 8.23086e-02, 8.99869e-02, 9.83815e-02, 1.07559e-01,
 1.17593e-01, 1.28563e-01, 1.40556e-01, 1.53668e-01, 1.68003e-01,
 1.83676e-01, 2.00810e-01, 2.19543e-01, 2.40024e-01, 2.62415e-01,
 2.86895e-01, 3.13658e-01, 3.42918e-01, 3.74908e-01, 4.09882e-01,
 4.48119e-01, 4.89922e-01, 5.35626e-01, 5.85592e-01, 6.40220e-01,
 6.99944e-01, 7.65240e-01, 8.36627e-01, 9.14673e-01, 1.00000e+00}
,
{1.16502e-04, 1.27664e-04, 1.39895e-04, 1.53298e-04, 1.67985e-04,
 1.84079e-04, 2.01715e-04, 2.21041e-04, 2.42218e-04, 2.65424e-04,
 2.90854e-04, 3.18719e-04, 3.49255e-04, 3.82716e-04, 4.19383e-04,
 4.59562e-04, 5.03592e-04, 5.51839e-04, 6.04709e-04, 6.62644e-04,
 7.26130e-04, 7.95698e-04, 8.71932e-04, 9.55469e-04, 1.04701e-03,
 1.14732e-03, 1.25724e-03, 1.37769e-03, 1.50969e-03, 1.65432e-03,
 1.81282e-03, 1.98650e-03, 2.17682e-03, 2.38537e-03, 2.61391e-03,
 2.86434e-03, 3.13876e-03, 3.43948e-03, 3.76900e-03, 4.13010e-03,
 4.52579e-03, 4.95939e-03, 5.43453e-03, 5.95520e-03, 6.52575e-03,
 7.15096e-03, 7.83607e-03, 8.58682e-03, 9.40949e-03, 1.03110e-02,
 1.12989e-02, 1.23814e-02, 1.35676e-02, 1.48674e-02, 1.62918e-02,
 1.78527e-02, 1.95631e-02, 2.14374e-02, 2.34913e-02, 2.57419e-02,
 2.82081e-02, 3.09107e-02, 3.38721e-02, 3.71173e-02, 4.06734e-02,
 4.45702e-02, 4.88403e-02, 5.35195e-02, 5.86471e-02, 6.42658e-02,
 7.04229e-02, 7.71699e-02, 8.45633e-02, 9.26651e-02, 1.01543e-01,
 1.11272e-01, 1.21932e-01, 1.33614e-01, 1.46415e-01, 1.60443e-01,
 1.75814e-01, 1.92658e-01, 2.11116e-01, 2.31343e-01, 2.53507e-01,
 2.77795e-01, 3.04409e-01, 3.33574e-01, 3.65533e-01, 4.00553e-01,
 4.38929e-01, 4.80981e-01, 5.27062e-01, 5.77559e-01, 6.32893e-01,
 6.93528e-01, 7.59973e-01, 8.32783e-01, 9.12570e-01, 1.00000e+00}
,
{9.27562e-05, 1.01877e-04, 1.11895e-04, 1.22898e-04, 1.34983e-04,
 1.48256e-04, 1.62834e-04, 1.78846e-04, 1.96433e-04, 2.15749e-04,
 2.36964e-04, 2.60265e-04, 2.85858e-04, 3.13967e-04, 3.44840e-04,
 3.78749e-04, 4.15992e-04, 4.56898e-04, 5.01826e-04, 5.51172e-04,
 6.05370e-04, 6.64898e-04, 7.30279e-04, 8.02089e-04, 8.80961e-04,
 9.67588e-04, 1.06273e-03, 1.16724e-03, 1.28201e-03, 1.40808e-03,
 1.54654e-03, 1.69861e-03, 1.86564e-03, 2.04909e-03, 2.25059e-03,
 2.47189e-03, 2.71496e-03, 2.98193e-03, 3.27515e-03, 3.59721e-03,
 3.95093e-03, 4.33944e-03, 4.76614e-03, 5.23481e-03, 5.74956e-03,
 6.31493e-03, 6.93590e-03, 7.61792e-03, 8.36702e-03, 9.18977e-03,
 1.00934e-02, 1.10859e-02, 1.21760e-02, 1.33733e-02, 1.46884e-02,
 1.61327e-02, 1.77191e-02, 1.94615e-02, 2.13752e-02, 2.34771e-02,
 2.57856e-02, 2.83212e-02, 3.11061e-02, 3.41648e-02, 3.75243e-02,
 4.12142e-02, 4.52669e-02, 4.97181e-02, 5.46071e-02, 5.99767e-02,
 6.58744e-02, 7.23520e-02, 7.94666e-02, 8.72807e-02, 9.58633e-02,
 1.05290e-01, 1.15643e-01, 1.27015e-01, 1.39504e-01, 1.53222e-01,
 1.68289e-01, 1.84837e-01, 2.03013e-01, 2.22976e-01, 2.44901e-01,
 2.68983e-01, 2.95433e-01, 3.24484e-01, 3.56391e-01, 3.91436e-01,
 4.29927e-01, 4.72203e-01, 5.18636e-01, 5.69635e-01, 6.25649e-01,
 6.87170e-01, 7.54742e-01, 8.28957e-01, 9.10471e-01, 1.00000e+00}
,
{7.38498e-05, 8.12986e-05, 8.94988e-05, 9.85260e-05, 1.08464e-04,
 1.19404e-04, 1.31448e-04, 1.44706e-04, 1.59302e-04, 1.75369e-04,
 1.93058e-04, 2.12531e-04, 2.33968e-04, 2.57567e-04, 2.83546e-04,
 3.12146e-04, 3.43630e-04, 3.78290e-04, 4.16446e-04, 4.58451e-04,
 5.04692e-04, 5.55597e-04, 6.11637e-04, 6.73330e-04, 7.41245e-04,
 8.16010e-04, 8.98317e-04, 9.88925e-04, 1.08867e-03, 1.19848e-03,
 1.31936e-03, 1.45244e-03, 1.59894e-03, 1.76022e-03, 1.93776e-03,
 2.13321e-03, 2.34838e-03, 2.58524e-03, 2.84600e-03, 3.13306e-03,
 3.44908e-03, 3.79697e-03, 4.17995e-03, 4.60156e-03, 5.06569e-03,
 5.57664e-03, 6.13912e-03, 6.75834e-03, 7.44002e-03, 8.19045e-03,
 9.01658e-03, 9.92603e-03, 1.09272e-02, 1.20294e-02, 1.32427e-02,
 1.45784e-02, 1.60489e-02, 1.76676e-02, 1.94497e-02, 2.14115e-02,
 2.35711e-02, 2.59486e-02, 2.85659e-02, 3.14472e-02, 3.46191e-02,
 3.81109e-02, 4.19549e-02, 4.61867e-02, 5.08453e-02, 5.59738e-02,
 6.16195e-02, 6.78348e-02, 7.46769e-02, 8.22091e-02, 9.05011e-02,
 9.96295e-02, 1.09679e-01, 1.20741e-01, 1.32920e-01, 1.46327e-01,
 1.61086e-01, 1.77334e-01, 1.95220e-01, 2.14911e-01, 2.36588e-01,
 2.60451e-01, 2.86721e-01, 3.15641e-01, 3.47478e-01, 3.82527e-01,
 4.21110e-01, 4.63585e-01, 5.10344e-01, 5.61820e-01, 6.18487e-01,
 6.80871e-01, 7.49546e-01, 8.25149e-01, 9.08377e-01, 1.00000e+00}
,
{5.87969e-05, 6.48767e-05, 7.15850e-05, 7.89871e-05, 8.71545e-05,
 9.61665e-05, 1.06110e-04, 1.17082e-04, 1.29189e-04, 1.42547e-04,
 1.57287e-04, 1.73551e-04, 1.91496e-04, 2.11297e-04, 2.33146e-04,
 2.57254e-04, 2.83854e-04, 3.13205e-04, 3.45591e-04, 3.81326e-04,
 4.20756e-04, 4.64263e-04, 5.12269e-04, 5.65239e-04, 6.23686e-04,
 6.88176e-04, 7.59335e-04, 8.37851e-04, 9.24487e-04, 1.02008e-03,
 1.12556e-03, 1.24194e-03, 1.37036e-03, 1.51206e-03, 1.66841e-03,
 1.84093e-03, 2.03129e-03, 2.24133e-03, 2.47308e-03, 2.72881e-03,
 3.01097e-03, 3.32231e-03, 3.66584e-03, 4.04490e-03, 4.46315e-03,
 4.92465e-03, 5.43387e-03, 5.99574e-03, 6.61571e-03, 7.29979e-03,
 8.05460e-03, 8.88747e-03, 9.80645e-03, 1.08205e-02, 1.19393e-02,
 1.31739e-02, 1.45361e-02, 1.60391e-02, 1.76976e-02, 1.95276e-02,
 2.15468e-02, 2.37747e-02, 2.62331e-02, 2.89457e-02, 3.19387e-02,
 3.52412e-02, 3.88852e-02, 4.29061e-02, 4.73426e-02, 5.22380e-02,
 5.76395e-02, 6.35995e-02, 7.01758e-02, 7.74322e-02, 8.54388e-02,
 9.42734e-02, 1.04021e-01, 1.14777e-01, 1.26646e-01, 1.39741e-01,
 1.54191e-01, 1.70134e-01, 1.87726e-01, 2.07138e-01, 2.28556e-01,
 2.52189e-01, 2.78266e-01, 3.07040e-01, 3.38788e-01, 3.73820e-01,
 4.12473e-01, 4.55124e-01, 5.02185e-01, 5.54112e-01, 6.11408e-01,
 6.74629e-01, 7.44387e-01, 8.21358e-01, 9.06288e-01, 1.00000e+00}
,
{4.68122e-05, 5.17717e-05, 5.72567e-05, 6.33228e-05, 7.00316e-05,
 7.74511e-05, 8.56567e-05, 9.47316e-05, 1.04768e-04, 1.15868e-04,
 1.28143e-04, 1.41720e-04, 1.56734e-04, 1.73340e-04, 1.91704e-04,
 2.12014e-04, 2.34476e-04, 2.59318e-04, 2.86792e-04, 3.17176e-04,
 3.50779e-04, 3.87943e-04, 4.29043e-04, 4.74499e-04, 5.24770e-04,
 5.80367e-04, 6.41854e-04, 7.09856e-04, 7.85062e-04, 8.68236e-04,
 9.60221e-04, 1.06195e-03, 1.17446e-03, 1.29889e-03, 1.43650e-03,
 1.58869e-03, 1.75701e-03, 1.94316e-03, 2.14902e-03, 2.37670e-03,
 2.62850e-03, 2.90698e-03, 3.21497e-03, 3.55558e-03, 3.93227e-03,
 4.34888e-03, 4.80963e-03, 5.31918e-03, 5.88273e-03, 6.50598e-03,
 7.19526e-03, 7.95756e-03, 8.80063e-03, 9.73302e-03, 1.07642e-02,
 1.19046e-02, 1.31658e-02, 1.45607e-02, 1.61034e-02, 1.78094e-02,
 1.96963e-02, 2.17830e-02, 2.40908e-02, 2.66431e-02, 2.94658e-02,
 3.25876e-02, 3.60401e-02, 3.98584e-02, 4.40812e-02, 4.87514e-02,
 5.39164e-02, 5.96287e-02, 6.59460e-02, 7.29327e-02, 8.06596e-02,
 8.92052e-02, 9.86561e-02, 1.09108e-01, 1.20668e-01, 1.33452e-01,
 1.47591e-01, 1.63227e-01, 1.80520e-01, 1.99646e-01, 2.20797e-01,
 2.44190e-01, 2.70061e-01, 2.98672e-01, 3.30315e-01, 3.65311e-01,
 4.04014e-01, 4.46817e-01, 4.94156e-01, 5.46509e-01, 6.04409e-01,
 6.68444e-01, 7.39263e-01, 8.17584e-01, 9.04204e-01, 1.00000e+00}
,
{3.72702e-05, 4.13139e-05, 4.57962e-05, 5.07649e-05, 5.62726e-05,
 6.23779e-05, 6.91456e-05, 7.66475e-05, 8.49634e-05, 9.41815e-05,
 1.04400e-04, 1.15727e-04, 1.28282e-04, 1.42200e-04, 1.57628e-04,
 1.74730e-04, 1.93687e-04, 2.14702e-04, 2.37996e-04, 2.63817e-04,
 2.92440e-04, 3.24168e-04, 3.59339e-04, 3.98325e-04, 4.41541e-04,
 4.89446e-04, 5.42549e-04, 6.01412e-04, 6.66663e-04, 7.38992e-04,
 8.19169e-04, 9.08045e-04, 1.00656e-03, 1.11577e-03, 1.23683e-03,
 1.37101e-03, 1.51976e-03, 1.68465e-03, 1.86743e-03, 2.07003e-03,
 2.29462e-03, 2.54357e-03, 2.81954e-03, 3.12545e-03, 3.46454e-03,
 3.84043e-03, 4.25709e-03, 4.71897e-03, 5.23095e-03, 5.79848e-03,
 6.42759e-03, 7.12495e-03, 7.89797e-03, 8.75486e-03, 9.70471e-03,
 1.07576e-02, 1.19248e-02, 1.32186e-02, 1.46527e-02, 1.62424e-02,
 1.80047e-02, 1.99581e-02, 2.21234e-02, 2.45237e-02, 2.71844e-02,
 3.01338e-02, 3.34031e-02, 3.70272e-02, 4.10445e-02, 4.54976e-02,
 5.04339e-02, 5.59057e-02, 6.19712e-02, 6.86947e-02, 7.61478e-02,
 8.44094e-02, 9.35674e-02, 1.03719e-01, 1.14972e-01, 1.27446e-01,
 1.41273e-01, 1.56600e-01, 1.73591e-01, 1.92425e-01, 2.13302e-01,
 2.36444e-01, 2.62097e-01, 2.90533e-01, 3.22054e-01, 3.56996e-01,
 3.95728e-01, 4.38662e-01, 4.86255e-01, 5.39011e-01, 5.97491e-01,
 6.62316e-01, 7.34174e-01, 8.13828e-01, 9.02124e-01, 1.00000e+00}
,
{2.96732e-05, 3.29684e-05, 3.66296e-05, 4.06973e-05, 4.52168e-05,
 5.02381e-05, 5.58170e-05, 6.20155e-05, 6.89024e-05, 7.65540e-05,
 8.50553e-05, 9.45008e-05, 1.04995e-04, 1.16655e-04, 1.29609e-04,
 1.44003e-04, 1.59994e-04, 1.77761e-04, 1.97502e-04, 2.19434e-04,
 2.43803e-04, 2.70877e-04, 3.00958e-04, 3.34379e-04, 3.71512e-04,
 4.12769e-04, 4.58607e-04, 5.09535e-04, 5.66119e-04, 6.28987e-04,
 6.98836e-04, 7.76442e-04, 8.62666e-04, 9.58465e-04, 1.06490e-03,
 1.18316e-03, 1.31455e-03, 1.46053e-03, 1.62273e-03, 1.80293e-03,
 2.00314e-03, 2.22559e-03, 2.47275e-03, 2.74735e-03, 3.05244e-03,
 3.39141e-03, 3.76803e-03, 4.18647e-03, 4.65138e-03, 5.16792e-03,
 5.74182e-03, 6.37944e-03, 7.08788e-03, 7.87499e-03, 8.74951e-03,
 9.72115e-03, 1.08007e-02, 1.20001e-02, 1.33327e-02, 1.48133e-02,
 1.64583e-02, 1.82860e-02, 2.03167e-02, 2.25729e-02, 2.50796e-02,
 2.78647e-02, 3.09591e-02, 3.43971e-02, 3.82169e-02, 4.24609e-02,
 4.71762e-02, 5.24151e-02, 5.82358e-02, 6.47029e-02, 7.18882e-02,
 7.98714e-02, 8.87412e-02, 9.85959e-02, 1.09545e-01, 1.21710e-01,
 1.35226e-01, 1.50243e-01, 1.66927e-01, 1.85465e-01, 2.06060e-01,
 2.28944e-01, 2.54368e-01, 2.82615e-01, 3.14000e-01, 3.48870e-01,
 3.87612e-01, 4.30656e-01, 4.78480e-01, 5.31616e-01, 5.90652e-01,
 6.56244e-01, 7.29120e-01, 8.10089e-01, 9.00049e-01, 1.00000e+00}
,
{2.36247e-05, 2.63088e-05, 2.92977e-05, 3.26263e-05, 3.63330e-05,
 4.04609e-05, 4.50577e-05, 5.01767e-05, 5.58774e-05, 6.22257e-05,
 6.92953e-05, 7.71680e-05, 8.59351e-05, 9.56984e-05, 1.06571e-04,
 1.18678e-04, 1.32162e-04, 1.47177e-04, 1.63898e-04, 1.82518e-04,
 2.03255e-04, 2.26347e-04, 2.52062e-04, 2.80699e-04, 3.12590e-04,
 3.48104e-04, 3.87652e-04, 4.31694e-04, 4.80739e-04, 5.35357e-04,
 5.96179e-04, 6.63912e-04, 7.39340e-04, 8.23337e-04, 9.16878e-04,
 1.02105e-03, 1.13705e-03, 1.26623e-03, 1.41009e-03, 1.57029e-03,
 1.74869e-03, 1.94736e-03, 2.16861e-03, 2.41499e-03, 2.68936e-03,
 2.99490e-03, 3.33515e-03, 3.71406e-03, 4.13602e-03, 4.60592e-03,
 5.12921e-03, 5.71194e-03, 6.36089e-03, 7.08355e-03, 7.88833e-03,
 8.78453e-03, 9.78255e-03, 1.08940e-02, 1.21316e-02, 1.35099e-02,
 1.50448e-02, 1.67541e-02, 1.86575e-02, 2.07772e-02, 2.31378e-02,
 2.57665e-02, 2.86939e-02, 3.19538e-02, 3.55841e-02, 3.96269e-02,
 4.41290e-02, 4.91425e-02, 5.47257e-02, 6.09431e-02, 6.78669e-02,
 7.55774e-02, 8.41639e-02, 9.37258e-02, 1.04374e-01, 1.16232e-01,
 1.29438e-01, 1.44143e-01, 1.60519e-01, 1.78756e-01, 1.99065e-01,
 2.21681e-01, 2.46867e-01, 2.74913e-01, 3.06147e-01, 3.40929e-01,
 3.79662e-01, 4.22796e-01, 4.70830e-01, 5.24322e-01, 5.83891e-01,
 6.50227e-01, 7.24101e-01, 8.06367e-01, 8.97979e-01, 1.00000e+00}
,
{1.88091e-05, 2.09943e-05, 2.34334e-05, 2.61559e-05, 2.91946e-05,
 3.25864e-05, 3.63723e-05, 4.05979e-05, 4.53145e-05, 5.05791e-05,
 5.64553e-05, 6.30142e-05, 7.03351e-05, 7.85066e-05, 8.76273e-05,
 9.78077e-05, 1.09171e-04, 1.21854e-04, 1.36011e-04, 1.51813e-04,
 1.69450e-04, 1.89136e-04, 2.11110e-04, 2.35636e-04, 2.63012e-04,
 2.93569e-04, 3.27675e-04, 3.65744e-04, 4.08235e-04, 4.55664e-04,
 5.08602e-04, 5.67691e-04, 6.33644e-04, 7.07260e-04, 7.89428e-04,
 8.81143e-04, 9.83513e-04, 1.09778e-03, 1.22531e-03, 1.36767e-03,
 1.52656e-03, 1.70392e-03, 1.90187e-03, 2.12283e-03, 2.36946e-03,
 2.64474e-03, 2.95200e-03, 3.29496e-03, 3.67776e-03, 4.10504e-03,
 4.58196e-03, 5.11428e-03, 5.70845e-03, 6.37165e-03, 7.11190e-03,
 7.93815e-03, 8.86039e-03, 9.88978e-03, 1.10388e-02, 1.23212e-02,
 1.37527e-02, 1.53505e-02, 1.71338e-02, 1.91244e-02, 2.13463e-02,
 2.38263e-02, 2.65944e-02, 2.96840e-02, 3.31327e-02, 3.69820e-02,
 4.12785e-02, 4.60742e-02, 5.14270e-02, 5.74017e-02, 6.40706e-02,
 7.15142e-02, 7.98226e-02, 8.90963e-02, 9.94474e-02, 1.11001e-01,
 1.23897e-01, 1.38291e-01, 1.54358e-01, 1.72291e-01, 1.92307e-01,
 2.14649e-01, 2.39587e-01, 2.67421e-01, 2.98490e-01, 3.33168e-01,
 3.71875e-01, 4.15079e-01, 4.63302e-01, 5.17128e-01, 5.77207e-01,
 6.44266e-01, 7.19116e-01, 8.02662e-01, 8.95914e-01, 1.00000e+00}
,
{1.49751e-05, 1.67534e-05, 1.87429e-05, 2.09687e-05, 2.34587e-05,
 2.62445e-05, 2.93611e-05, 3.28477e-05, 3.67484e-05, 4.11124e-05,
 4.59945e-05, 5.14564e-05, 5.75670e-05, 6.44031e-05, 7.20511e-05,
 8.06073e-05, 9.01795e-05, 1.00888e-04, 1.12869e-04, 1.26273e-04,
 1.41268e-04, 1.58043e-04, 1.76811e-04, 1.97808e-04, 2.21298e-04,
 2.47577e-04, 2.76977e-04, 3.09869e-04, 3.46666e-04, 3.87833e-04,
 4.33889e-04, 4.85414e-04, 5.43058e-04, 6.07547e-04, 6.79694e-04,
 7.60409e-04, 8.50708e-04, 9.51731e-04, 1.06475e-03, 1.19119e-03,
 1.33265e-03, 1.49090e-03, 1.66795e-03, 1.86602e-03, 2.08761e-03,
 2.33552e-03, 2.61287e-03, 2.92315e-03, 3.27028e-03, 3.65863e-03,
 4.09309e-03, 4.57915e-03, 5.12294e-03, 5.73129e-03, 6.41189e-03,
 7.17331e-03, 8.02516e-03, 8.97816e-03, 1.00443e-02, 1.12371e-02,
 1.25715e-02, 1.40644e-02, 1.57346e-02, 1.76031e-02, 1.96935e-02,
 2.20321e-02, 2.46485e-02, 2.75755e-02, 3.08501e-02, 3.45136e-02,
 3.86122e-02, 4.31975e-02, 4.83272e-02, 5.40661e-02, 6.04866e-02,
 6.76695e-02, 7.57053e-02, 8.46954e-02, 9.47531e-02, 1.06005e-01,
 1.18593e-01, 1.32677e-01, 1.48432e-01, 1.66059e-01, 1.85778e-01,
 2.07840e-01, 2.32521e-01, 2.60134e-01, 2.91025e-01, 3.25584e-01,
 3.64248e-01, 4.07503e-01, 4.55895e-01, 5.10033e-01, 5.70600e-01,
 6.38360e-01, 7.14166e-01, 7.98974e-01, 8.93854e-01, 1.00000e+00}
,
{1.19226e-05, 1.33692e-05, 1.49913e-05, 1.68102e-05, 1.88497e-05,
 2.11368e-05, 2.37013e-05, 2.65770e-05, 2.98016e-05, 3.34175e-05,
 3.74720e-05, 4.20185e-05, 4.71166e-05, 5.28333e-05, 5.92436e-05,
 6.64317e-05, 7.44919e-05, 8.35300e-05, 9.36647e-05, 1.05029e-04,
 1.17772e-04, 1.32062e-04, 1.48085e-04, 1.66052e-04, 1.86199e-04,
 2.08791e-04, 2.34124e-04, 2.62530e-04, 2.94383e-04, 3.30100e-04,
 3.70152e-04, 4.15062e-04, 4.65422e-04, 5.21892e-04, 5.85213e-04,
 6.56217e-04, 7.35837e-04, 8.25116e-04, 9.25228e-04, 1.03749e-03,
 1.16336e-03, 1.30452e-03, 1.46279e-03, 1.64028e-03, 1.83929e-03,
 2.06245e-03, 2.31269e-03, 2.59329e-03, 2.90794e-03, 3.26076e-03,
 3.65639e-03, 4.10002e-03, 4.59748e-03, 5.15529e-03, 5.78078e-03,
 6.48217e-03, 7.26865e-03, 8.15056e-03, 9.13947e-03, 1.02484e-02,
 1.14918e-02, 1.28861e-02, 1.44496e-02, 1.62028e-02, 1.81687e-02,
 2.03731e-02, 2.28450e-02, 2.56167e-02, 2.87248e-02, 3.22100e-02,
 3.61181e-02, 4.05003e-02, 4.54142e-02, 5.09244e-02, 5.71030e-02,
 6.40314e-02, 7.18003e-02, 8.05119e-02, 9.02805e-02, 1.01234e-01,
 1.13517e-01, 1.27290e-01, 1.42734e-01, 1.60052e-01, 1.79472e-01,
 2.01247e-01, 2.25664e-01, 2.53044e-01, 2.83746e-01, 3.18173e-01,
 3.56777e-01, 4.00065e-01, 4.48606e-01, 5.03035e-01, 5.64069e-01,
 6.32507e-01, 7.09250e-01, 7.95303e-01, 8.91798e-01, 1.00000e+00}
,
{9.49230e-06, 1.06685e-05, 1.19905e-05, 1.34764e-05, 1.51463e-05,
 1.70231e-05, 1.91326e-05, 2.15034e-05, 2.41680e-05, 2.71628e-05,
 3.05287e-05, 3.43116e-05, 3.85634e-05, 4.33420e-05, 4.87127e-05,
 5.47490e-05, 6.15332e-05, 6.91581e-05, 7.77279e-05, 8.73596e-05,
 9.81847e-05, 1.10351e-04, 1.24026e-04, 1.39394e-04, 1.56667e-04,
 1.76081e-04, 1.97900e-04, 2.22423e-04, 2.49984e-04, 2.80961e-04,
 3.15777e-04, 3.54906e-04, 3.98885e-04, 4.48313e-04, 5.03866e-04,
 5.66302e-04, 6.36476e-04, 7.15345e-04, 8.03987e-04, 9.03614e-04,
 1.01559e-03, 1.14143e-03, 1.28287e-03, 1.44184e-03, 1.62051e-03,
 1.82131e-03, 2.04700e-03, 2.30066e-03, 2.58574e-03, 2.90616e-03,
 3.26627e-03, 3.67102e-03, 4.12591e-03, 4.63718e-03, 5.21179e-03,
 5.85761e-03, 6.58346e-03, 7.39925e-03, 8.31614e-03, 9.34663e-03,
 1.05048e-02, 1.18065e-02, 1.32695e-02, 1.49138e-02, 1.67619e-02,
 1.88390e-02, 2.11734e-02, 2.37971e-02, 2.67459e-02, 3.00602e-02,
 3.37851e-02, 3.79716e-02, 4.26768e-02, 4.79652e-02, 5.39088e-02,
 6.05889e-02, 6.80968e-02, 7.65350e-02, 8.60189e-02, 9.66780e-02,
 1.08658e-01, 1.22122e-01, 1.37255e-01, 1.54263e-01, 1.73379e-01,
 1.94863e-01, 2.19009e-01, 2.46148e-01, 2.76650e-01, 3.10931e-01,
 3.49460e-01, 3.92763e-01, 4.41433e-01, 4.96133e-01, 5.57612e-01,
 6.26708e-01, 7.04367e-01, 7.91649e-01, 8.89747e-01, 1.00000e+00}
,
{7.55740e-06, 8.51346e-06, 9.59046e-06, 1.08037e-05, 1.21705e-05,
 1.37101e-05, 1.54445e-05, 1.73983e-05, 1.95993e-05, 2.20788e-05,
 2.48719e-05, 2.80183e-05, 3.15628e-05, 3.55557e-05, 4.00537e-05,
 4.51208e-05, 5.08288e-05, 5.72590e-05, 6.45026e-05, 7.26626e-05,
 8.18549e-05, 9.22100e-05, 1.03875e-04, 1.17016e-04, 1.31819e-04,
 1.48495e-04, 1.67281e-04, 1.88443e-04, 2.12282e-04, 2.39137e-04,
 2.69390e-04, 3.03469e-04, 3.41860e-04, 3.85107e-04, 4.33826e-04,
 4.88707e-04, 5.50532e-04, 6.20177e-04, 6.98634e-04, 7.87015e-04,
 8.86578e-04, 9.98735e-04, 1.12508e-03, 1.26741e-03, 1.42775e-03,
 1.60837e-03, 1.81183e-03, 2.04104e-03, 2.29925e-03, 2.59012e-03,
 2.91778e-03, 3.28690e-03, 3.70271e-03, 4.17113e-03, 4.69880e-03,
 5.29323e-03, 5.96286e-03, 6.71720e-03, 7.56697e-03, 8.52424e-03,
 9.60261e-03, 1.08174e-02, 1.21859e-02, 1.37275e-02, 1.54641e-02,
 1.74204e-02, 1.96241e-02, 2.21067e-02, 2.49034e-02, 2.80538e-02,
 3.16028e-02, 3.56007e-02, 4.01044e-02, 4.51779e-02, 5.08932e-02,
 5.73315e-02, 6.45843e-02, 7.27546e-02, 8.19585e-02, 9.23268e-02,
 1.04007e-01, 1.17164e-01, 1.31986e-01, 1.48683e-01, 1.67493e-01,
 1.88682e-01, 2.12551e-01, 2.39440e-01, 2.69731e-01, 3.03853e-01,
 3.42293e-01, 3.85595e-01, 4.34375e-01, 4.89326e-01, 5.51229e-01,
 6.20963e-01, 6.99518e-01, 7.88012e-01, 8.87700e-01, 1.00000e+00}
,
{6.01690e-06, 6.79370e-06, 7.67079e-06, 8.66111e-06, 9.77929e-06,
 1.10418e-05, 1.24674e-05, 1.40769e-05, 1.58943e-05, 1.79463e-05,
 2.02632e-05, 2.28793e-05, 2.58331e-05, 2.91682e-05, 3.29339e-05,
 3.71858e-05, 4.19866e-05, 4.74072e-05, 5.35276e-05, 6.04382e-05,
 6.82409e-05, 7.70511e-05, 8.69986e-05, 9.82304e-05, 1.10912e-04,
 1.25231e-04, 1.41399e-04, 1.59654e-04, 1.80266e-04, 2.03539e-04,
 2.29816e-04, 2.59486e-04, 2.92987e-04, 3.30812e-04, 3.73521e-04,
 4.21744e-04, 4.76193e-04, 5.37671e-04, 6.07086e-04, 6.85462e-04,
 7.73958e-04, 8.73878e-04, 9.86698e-04, 1.11408e-03, 1.25792e-03,
 1.42032e-03, 1.60368e-03, 1.81072e-03, 2.04449e-03, 2.30845e-03,
 2.60647e-03, 2.94298e-03, 3.32292e-03, 3.75192e-03, 4.23631e-03,
 4.78323e-03, 5.40076e-03, 6.09801e-03, 6.88529e-03, 7.77420e-03,
 8.77787e-03, 9.91112e-03, 1.11907e-02, 1.26354e-02, 1.42667e-02,
 1.61086e-02, 1.81883e-02, 2.05364e-02, 2.31877e-02, 2.61813e-02,
 2.95614e-02, 3.33779e-02, 3.76871e-02, 4.25526e-02, 4.80463e-02,
 5.42492e-02, 6.12530e-02, 6.91609e-02, 7.80898e-02, 8.81714e-02,
 9.95546e-02, 1.12407e-01, 1.26920e-01, 1.43305e-01, 1.61806e-01,
 1.82696e-01, 2.06283e-01, 2.32915e-01, 2.62985e-01, 2.96937e-01,
 3.35272e-01, 3.78557e-01, 4.27430e-01, 4.82612e-01, 5.44919e-01,
 6.15270e-01, 6.94703e-01, 7.84391e-01, 8.85659e-01, 1.00000e+00}
,
{4.79042e-06, 5.42134e-06, 6.13537e-06, 6.94343e-06, 7.85792e-06,
 8.89286e-06, 1.00641e-05, 1.13896e-05, 1.28897e-05, 1.45873e-05,
 1.65086e-05, 1.86828e-05, 2.11435e-05, 2.39282e-05, 2.70797e-05,
 3.06462e-05, 3.46825e-05, 3.92504e-05, 4.44200e-05, 5.02703e-05,
 5.68912e-05, 6.43841e-05, 7.28639e-05, 8.24605e-05, 9.33211e-05,
 1.05612e-04, 1.19522e-04, 1.35263e-04, 1.53078e-04, 1.73240e-04,
 1.96057e-04, 2.21878e-04, 2.51101e-04, 2.84173e-04, 3.21600e-04,
 3.63956e-04, 4.11892e-04, 4.66140e-04, 5.27534e-04, 5.97013e-04,
 6.75643e-04, 7.64629e-04, 8.65336e-04, 9.79305e-04, 1.10829e-03,
 1.25425e-03, 1.41945e-03, 1.60640e-03, 1.81797e-03, 2.05741e-03,
 2.32838e-03, 2.63504e-03, 2.98209e-03, 3.37485e-03, 3.81934e-03,
 4.32236e-03, 4.89165e-03, 5.53591e-03, 6.26502e-03, 7.09016e-03,
 8.02397e-03, 9.08078e-03, 1.02768e-02, 1.16303e-02, 1.31621e-02,
 1.48956e-02, 1.68574e-02, 1.90776e-02, 2.15903e-02, 2.44338e-02,
 2.76519e-02, 3.12939e-02, 3.54154e-02, 4.00799e-02, 4.53586e-02,
 5.13326e-02, 5.80934e-02, 6.57447e-02, 7.44037e-02, 8.42031e-02,
 9.52931e-02, 1.07844e-01, 1.22047e-01, 1.38122e-01, 1.56313e-01,
 1.76901e-01, 2.00200e-01, 2.26567e-01, 2.56407e-01, 2.90178e-01,
 3.28396e-01, 3.71647e-01, 4.20596e-01, 4.75991e-01, 5.38681e-01,
 6.09629e-01, 6.89921e-01, 7.80787e-01, 8.83622e-01, 1.00000e+00}
,
{3.81394e-06, 4.32621e-06, 4.90728e-06, 5.56640e-06, 6.31405e-06,
 7.16212e-06, 8.12410e-06, 9.21528e-06, 1.04530e-05, 1.18570e-05,
 1.34496e-05, 1.52561e-05, 1.73052e-05, 1.96296e-05, 2.22661e-05,
 2.52568e-05, 2.86491e-05, 3.24971e-05, 3.68620e-05, 4.18131e-05,
 4.74292e-05, 5.37996e-05, 6.10257e-05, 6.92224e-05, 7.85199e-05,
 8.90663e-05, 1.01029e-04, 1.14599e-04, 1.29991e-04, 1.47451e-04,
 1.67256e-04, 1.89721e-04, 2.15203e-04, 2.44108e-04, 2.76896e-04,
 3.14087e-04, 3.56273e-04, 4.04126e-04, 4.58406e-04, 5.19977e-04,
 5.89817e-04, 6.69039e-04, 7.58900e-04, 8.60832e-04, 9.76454e-04,
 1.10761e-03, 1.25637e-03, 1.42512e-03, 1.61654e-03, 1.83366e-03,
 2.07995e-03, 2.35932e-03, 2.67621e-03, 3.03567e-03, 3.44340e-03,
 3.90590e-03, 4.43052e-03, 5.02561e-03, 5.70062e-03, 6.46630e-03,
 7.33482e-03, 8.32000e-03, 9.43750e-03, 1.07051e-02, 1.21429e-02,
 1.37739e-02, 1.56240e-02, 1.77225e-02, 2.01029e-02, 2.28030e-02,
 2.58658e-02, 2.93399e-02, 3.32807e-02, 3.77508e-02, 4.28213e-02,
 4.85729e-02, 5.50969e-02, 6.24972e-02, 7.08915e-02, 8.04133e-02,
 9.12140e-02, 1.03465e-01, 1.17362e-01, 1.33126e-01, 1.51007e-01,
 1.71289e-01, 1.94296e-01, 2.20392e-01, 2.49994e-01, 2.83572e-01,
 3.21660e-01, 3.64864e-01, 4.13871e-01, 4.69460e-01, 5.32515e-01,
 6.04040e-01, 6.85171e-01, 7.77200e-01, 8.81589e-01, 1.00000e+00}
,
{3.03650e-06, 3.45229e-06, 3.92501e-06, 4.46246e-06, 5.07351e-06,
 5.76822e-06, 6.55806e-06, 7.45605e-06, 8.47701e-06, 9.63776e-06,
 1.09575e-05, 1.24579e-05, 1.41637e-05, 1.61031e-05, 1.83081e-05,
 2.08151e-05, 2.36653e-05, 2.69057e-05, 3.05899e-05, 3.47786e-05,
 3.95408e-05, 4.49551e-05, 5.11108e-05, 5.81094e-05, 6.60663e-05,
 7.51128e-05, 8.53979e-05, 9.70914e-05, 1.10386e-04, 1.25501e-04,
 1.42686e-04, 1.62224e-04, 1.84437e-04, 2.09692e-04, 2.38405e-04,
 2.71050e-04, 3.08165e-04, 3.50362e-04, 3.98337e-04, 4.52881e-04,
 5.14894e-04, 5.85398e-04, 6.65556e-04, 7.56691e-04, 8.60304e-04,
 9.78106e-04, 1.11204e-03, 1.26431e-03, 1.43743e-03, 1.63426e-03,
 1.85803e-03, 2.11245e-03, 2.40171e-03, 2.73058e-03, 3.10447e-03,
 3.52957e-03, 4.01287e-03, 4.56235e-03, 5.18707e-03, 5.89734e-03,
 6.70486e-03, 7.62295e-03, 8.66676e-03, 9.85350e-03, 1.12027e-02,
 1.27367e-02, 1.44808e-02, 1.64636e-02, 1.87180e-02, 2.12810e-02,
 2.41950e-02, 2.75080e-02, 3.12747e-02, 3.55571e-02, 4.04259e-02,
 4.59614e-02, 5.22549e-02, 5.94102e-02, 6.75452e-02, 7.67941e-02,
 8.73095e-02, 9.92648e-02, 1.12857e-01, 1.28311e-01, 1.45880e-01,
 1.65855e-01, 1.88566e-01, 2.14386e-01, 2.43742e-01, 2.77118e-01,
 3.15063e-01, 3.58205e-01, 4.07253e-01, 4.63019e-01, 5.26420e-01,
 5.98502e-01, 6.80455e-01, 7.73629e-01, 8.79562e-01, 1.00000e+00}
,
{2.41754e-06, 2.75491e-06, 3.13936e-06, 3.57746e-06, 4.07670e-06,
 4.64560e-06, 5.29390e-06, 6.03266e-06, 6.87453e-06, 7.83387e-06,
 8.92709e-06, 1.01729e-05, 1.15925e-05, 1.32102e-05, 1.50537e-05,
 1.71545e-05, 1.95484e-05, 2.22764e-05, 2.53851e-05, 2.89276e-05,
 3.29645e-05, 3.75647e-05, 4.28068e-05, 4.87806e-05, 5.55879e-05,
 6.33452e-05, 7.21851e-05, 8.22586e-05, 9.37378e-05, 1.06819e-04,
 1.21726e-04, 1.38712e-04, 1.58070e-04, 1.80129e-04, 2.05266e-04,
 2.33911e-04, 2.66553e-04, 3.03751e-04, 3.46139e-04, 3.94443e-04,
 4.49488e-04, 5.12214e-04, 5.83694e-04, 6.65149e-04, 7.57970e-04,
 8.63746e-04, 9.84282e-04, 1.12164e-03, 1.27816e-03, 1.45653e-03,
 1.65979e-03, 1.89142e-03, 2.15537e-03, 2.45615e-03, 2.79891e-03,
 3.18949e-03, 3.63459e-03, 4.14180e-03, 4.71979e-03, 5.37844e-03,
 6.12900e-03, 6.98431e-03, 7.95897e-03, 9.06965e-03, 1.03353e-02,
 1.17776e-02, 1.34212e-02, 1.52941e-02, 1.74284e-02, 1.98606e-02,
 2.26321e-02, 2.57905e-02, 2.93895e-02, 3.34909e-02, 3.81645e-02,
 4.34904e-02, 4.95595e-02, 5.64756e-02, 6.43568e-02, 7.33378e-02,
 8.35722e-02, 9.52347e-02, 1.08525e-01, 1.23669e-01, 1.40928e-01,
 1.60594e-01, 1.83005e-01, 2.08544e-01, 2.37646e-01, 2.70810e-01,
 3.08601e-01, 3.51667e-01, 4.00742e-01, 4.56666e-01, 5.20394e-01,
 5.93015e-01, 6.75770e-01, 7.70075e-01, 8.77539e-01, 1.00000e+00}
,
{1.92475e-06, 2.19841e-06, 2.51097e-06, 2.86797e-06, 3.27573e-06,
 3.74147e-06, 4.27342e-06, 4.88101e-06, 5.57498e-06, 6.36761e-06,
 7.27294e-06, 8.30699e-06, 9.48806e-06, 1.08370e-05, 1.23778e-05,
 1.41377e-05, 1.61477e-05, 1.84436e-05, 2.10658e-05, 2.40609e-05,
 2.74819e-05, 3.13892e-05, 3.58520e-05, 4.09493e-05, 4.67714e-05,
 5.34212e-05, 6.10165e-05, 6.96917e-05, 7.96003e-05, 9.09177e-05,
 1.03844e-04, 1.18608e-04, 1.35472e-04, 1.54733e-04, 1.76732e-04,
 2.01860e-04, 2.30560e-04, 2.63340e-04, 3.00781e-04, 3.43546e-04,
 3.92390e-04, 4.48179e-04, 5.11900e-04, 5.84681e-04, 6.67809e-04,
 7.62757e-04, 8.71203e-04, 9.95069e-04, 1.13655e-03, 1.29814e-03,
 1.48270e-03, 1.69351e-03, 1.93429e-03, 2.20930e-03, 2.52341e-03,
 2.88219e-03, 3.29197e-03, 3.76001e-03, 4.29460e-03, 4.90519e-03,
 5.60260e-03, 6.39917e-03, 7.30898e-03, 8.34816e-03, 9.53508e-03,
 1.08908e-02, 1.24392e-02, 1.42077e-02, 1.62278e-02, 1.85350e-02,
 2.11702e-02, 2.41802e-02, 2.76180e-02, 3.15447e-02, 3.60297e-02,
 4.11523e-02, 4.70032e-02, 5.36860e-02, 6.13189e-02, 7.00371e-02,
 7.99948e-02, 9.13683e-02, 1.04359e-01, 1.19196e-01, 1.36143e-01,
 1.55500e-01, 1.77608e-01, 2.02860e-01, 2.31702e-01, 2.64645e-01,
 3.02272e-01, 3.45248e-01, 3.94335e-01, 4.50400e-01, 5.14437e-01,
 5.87578e-01, 6.71119e-01, 7.66536e-01, 8.75521e-01, 1.00000e+00}
,
{1.53241e-06, 1.75432e-06, 2.00836e-06, 2.29919e-06, 2.63214e-06,
 3.01330e-06, 3.44966e-06, 3.94920e-06, 4.52109e-06, 5.17579e-06,
 5.92530e-06, 6.78334e-06, 7.76564e-06, 8.89019e-06, 1.01776e-05,
 1.16514e-05, 1.33386e-05, 1.52702e-05, 1.74815e-05, 2.00130e-05,
 2.29111e-05, 2.62289e-05, 3.00271e-05, 3.43753e-05, 3.93532e-05,
 4.50520e-05, 5.15760e-05, 5.90448e-05, 6.75951e-05, 7.73835e-05,
 8.85895e-05, 1.01418e-04, 1.16105e-04, 1.32918e-04, 1.52166e-04,
 1.74201e-04, 1.99427e-04, 2.28306e-04, 2.61367e-04, 2.99216e-04,
 3.42545e-04, 3.92149e-04, 4.48937e-04, 5.13948e-04, 5.88373e-04,
 6.73575e-04, 7.71116e-04, 8.82781e-04, 1.01062e-03, 1.15697e-03,
 1.32451e-03, 1.51631e-03, 1.73589e-03, 1.98726e-03, 2.27504e-03,
 2.60449e-03, 2.98164e-03, 3.41342e-03, 3.90771e-03, 4.47359e-03,
 5.12141e-03, 5.86305e-03, 6.71208e-03, 7.68406e-03, 8.79679e-03,
 1.00707e-02, 1.15290e-02, 1.31985e-02, 1.51098e-02, 1.72979e-02,
 1.98028e-02, 2.26704e-02, 2.59533e-02, 2.97116e-02, 3.40142e-02,
 3.89398e-02, 4.45787e-02, 5.10342e-02, 5.84244e-02, 6.68849e-02,
 7.65705e-02, 8.76588e-02, 1.00353e-01, 1.14885e-01, 1.31521e-01,
 1.50567e-01, 1.72371e-01, 1.97332e-01, 2.25907e-01, 2.58621e-01,
 2.96072e-01, 3.38947e-01, 3.88030e-01, 4.44220e-01, 5.08548e-01,
 5.82191e-01, 6.66499e-01, 7.63015e-01, 8.73507e-01, 1.00000e+00}
,
{1.22004e-06, 1.39994e-06, 1.60636e-06, 1.84321e-06, 2.11499e-06,
 2.42685e-06, 2.78468e-06, 3.19528e-06, 3.66643e-06, 4.20704e-06,
 4.82737e-06, 5.53916e-06, 6.35591e-06, 7.29308e-06, 8.36844e-06,
 9.60237e-06, 1.10182e-05, 1.26429e-05, 1.45070e-05, 1.66461e-05,
 1.91006e-05, 2.19169e-05, 2.51486e-05, 2.88567e-05, 3.31116e-05,
 3.79939e-05, 4.35961e-05, 5.00243e-05, 5.74004e-05, 6.58641e-05,
 7.55757e-05, 8.67193e-05, 9.95060e-05, 1.14178e-04, 1.31014e-04,
 1.50332e-04, 1.72498e-04, 1.97933e-04, 2.27118e-04, 2.60606e-04,
 2.99032e-04, 3.43124e-04, 3.93718e-04, 4.51772e-04, 5.18385e-04,
 5.94821e-04, 6.82527e-04, 7.83165e-04, 8.98642e-04, 1.03115e-03,
 1.18319e-03, 1.35765e-03, 1.55783e-03, 1.78754e-03, 2.05111e-03,
 2.35354e-03, 2.70057e-03, 3.09877e-03, 3.55568e-03, 4.07996e-03,
 4.68155e-03, 5.37185e-03, 6.16392e-03, 7.07279e-03, 8.11567e-03,
 9.31232e-03, 1.06854e-02, 1.22610e-02, 1.40689e-02, 1.61433e-02,
 1.85236e-02, 2.12549e-02, 2.43889e-02, 2.79851e-02, 3.21115e-02,
 3.68463e-02, 4.22793e-02, 4.85133e-02, 5.56666e-02, 6.38746e-02,
 7.32929e-02, 8.40999e-02, 9.65004e-02, 1.10729e-01, 1.27056e-01,
 1.45791e-01, 1.67287e-01, 1.91954e-01, 2.20257e-01, 2.52734e-01,
 2.90000e-01, 3.32760e-01, 3.81825e-01, 4.38125e-01, 5.02727e-01,
 5.76854e-01, 6.61910e-01, 7.59509e-01, 8.71498e-01, 1.00000e+00}
,
{9.71347e-07, 1.11714e-06, 1.28482e-06, 1.47766e-06, 1.69945e-06,
 1.95453e-06, 2.24790e-06, 2.58529e-06, 2.97333e-06, 3.41961e-06,
 3.93288e-06, 4.52318e-06, 5.20209e-06, 5.98289e-06, 6.88089e-06,
 7.91368e-06, 9.10148e-06, 1.04676e-05, 1.20387e-05, 1.38456e-05,
 1.59238e-05, 1.83139e-05, 2.10627e-05, 2.42241e-05, 2.78600e-05,
 3.20416e-05, 3.68509e-05, 4.23820e-05, 4.87433e-05, 5.60594e-05,
 6.44736e-05, 7.41508e-05, 8.52804e-05, 9.80806e-05, 1.12802e-04,
 1.29733e-04, 1.49205e-04, 1.71600e-04, 1.97356e-04, 2.26978e-04,
 2.61047e-04, 3.00228e-04, 3.45291e-04, 3.97117e-04, 4.56723e-04,
 5.25274e-04, 6.04115e-04, 6.94790e-04, 7.99074e-04, 9.19010e-04,
 1.05695e-03, 1.21559e-03, 1.39805e-03, 1.60788e-03, 1.84922e-03,
 2.12678e-03, 2.44600e-03, 2.81313e-03, 3.23536e-03, 3.72097e-03,
 4.27947e-03, 4.92180e-03, 5.66053e-03, 6.51015e-03, 7.48728e-03,
 8.61109e-03, 9.90356e-03, 1.13900e-02, 1.30996e-02, 1.50658e-02,
 1.73271e-02, 1.99278e-02, 2.29189e-02, 2.63589e-02, 3.03152e-02,
 3.48653e-02, 4.00984e-02, 4.61170e-02, 5.30389e-02, 6.09998e-02,
 7.01555e-02, 8.06855e-02, 9.27959e-02, 1.06724e-01, 1.22743e-01,
 1.41166e-01, 1.62354e-01, 1.86723e-01, 2.14749e-01, 2.46981e-01,
 2.84052e-01, 3.26687e-01, 3.75720e-01, 4.32114e-01, 4.96972e-01,
 5.71565e-01, 6.57354e-01, 7.56019e-01, 8.69494e-01, 1.00000e+00}
,
{7.73347e-07, 8.91473e-07, 1.02764e-06, 1.18461e-06, 1.36555e-06,
 1.57414e-06, 1.81458e-06, 2.09175e-06, 2.41126e-06, 2.77957e-06,
 3.20413e-06, 3.69355e-06, 4.25773e-06, 4.90808e-06, 5.65776e-06,
 6.52196e-06, 7.51817e-06, 8.66654e-06, 9.99032e-06, 1.15163e-05,
 1.32754e-05, 1.53031e-05, 1.76406e-05, 2.03351e-05, 2.34412e-05,
 2.70218e-05, 3.11493e-05, 3.59072e-05, 4.13919e-05, 4.77143e-05,
 5.50025e-05, 6.34039e-05, 7.30886e-05, 8.42525e-05, 9.71218e-05,
 1.11957e-04, 1.29058e-04, 1.48771e-04, 1.71495e-04, 1.97690e-04,
 2.27886e-04, 2.62695e-04, 3.02821e-04, 3.49075e-04, 4.02395e-04,
 4.63859e-04, 5.34712e-04, 6.16387e-04, 7.10537e-04, 8.19069e-04,
 9.44178e-04, 1.08840e-03, 1.25465e-03, 1.44629e-03, 1.66720e-03,
 1.92186e-03, 2.21542e-03, 2.55381e-03, 2.94390e-03, 3.39357e-03,
 3.91192e-03, 4.50945e-03, 5.19825e-03, 5.99226e-03, 6.90755e-03,
 7.96266e-03, 9.17892e-03, 1.05810e-02, 1.21972e-02, 1.40602e-02,
 1.62079e-02, 1.86836e-02, 2.15374e-02, 2.48271e-02, 2.86194e-02,
 3.29909e-02, 3.80301e-02, 4.38390e-02, 5.05353e-02, 5.82543e-02,
 6.71524e-02, 7.74097e-02, 8.92337e-02, 1.02864e-01, 1.18576e-01,
 1.36688e-01, 1.57566e-01, 1.81634e-01, 2.09378e-01, 2.41359e-01,
 2.78226e-01, 3.20724e-01, 3.69713e-01, 4.26185e-01, 4.91283e-01,
 5.66325e-01, 6.52829e-01, 7.52546e-01, 8.67494e-01, 1.00000e+00}
,
{6.15708e-07, 7.11391e-07, 8.21943e-07, 9.49676e-07, 1.09726e-06,
 1.26778e-06, 1.46479e-06, 1.69243e-06, 1.95543e-06, 2.25932e-06,
 2.61042e-06, 3.01609e-06, 3.48480e-06, 4.02635e-06, 4.65206e-06,
 5.37500e-06, 6.21029e-06, 7.17539e-06, 8.29047e-06, 9.57884e-06,
 1.10674e-05, 1.27873e-05, 1.47745e-05, 1.70705e-05, 1.97234e-05,
 2.27884e-05, 2.63298e-05, 3.04216e-05, 3.51492e-05, 4.06115e-05,
 4.69226e-05, 5.42146e-05, 6.26397e-05, 7.23741e-05, 8.36213e-05,
 9.66163e-05, 1.11631e-04, 1.28979e-04, 1.49022e-04, 1.72181e-04,
 1.98938e-04, 2.29854e-04, 2.65574e-04, 3.06845e-04, 3.54530e-04,
 4.09625e-04, 4.73282e-04, 5.46831e-04, 6.31811e-04, 7.29996e-04,
 8.43440e-04, 9.74513e-04, 1.12596e-03, 1.30093e-03, 1.50310e-03,
 1.73669e-03, 2.00658e-03, 2.31840e-03, 2.67869e-03, 3.09497e-03,
 3.57594e-03, 4.13165e-03, 4.77372e-03, 5.51557e-03, 6.37271e-03,
 7.36305e-03, 8.50730e-03, 9.82936e-03, 1.13569e-02, 1.31218e-02,
 1.51609e-02, 1.75170e-02, 2.02392e-02, 2.33844e-02, 2.70184e-02,
 3.12172e-02, 3.60684e-02, 4.16736e-02, 4.81498e-02, 5.56325e-02,
 6.42779e-02, 7.42669e-02, 8.58082e-02, 9.91431e-02, 1.14550e-01,
 1.32352e-01, 1.52920e-01, 1.76684e-01, 2.04141e-01, 2.35865e-01,
 2.72520e-01, 3.14870e-01, 3.63802e-01, 4.20338e-01, 4.85660e-01,
 5.61133e-01, 6.48335e-01, 7.49088e-01, 8.65499e-01, 1.00000e+00}
,
{4.90202e-07, 5.67686e-07, 6.57418e-07, 7.61334e-07, 8.81676e-07,
 1.02104e-06, 1.18243e-06, 1.36934e-06, 1.58578e-06, 1.83644e-06,
 2.12672e-06, 2.46289e-06, 2.85219e-06, 3.30302e-06, 3.82512e-06,
 4.42974e-06, 5.12994e-06, 5.94081e-06, 6.87985e-06, 7.96733e-06,
 9.22670e-06, 1.06851e-05, 1.23741e-05, 1.43300e-05, 1.65951e-05,
 1.92183e-05, 2.22560e-05, 2.57740e-05, 2.98480e-05, 3.45660e-05,
 4.00297e-05, 4.63571e-05, 5.36846e-05, 6.21703e-05, 7.19974e-05,
 8.33778e-05, 9.65570e-05, 1.11819e-04, 1.29494e-04, 1.49963e-04,
 1.73667e-04, 2.01118e-04, 2.32909e-04, 2.69724e-04, 3.12358e-04,
 3.61731e-04, 4.18909e-04, 4.85125e-04, 5.61807e-04, 6.50610e-04,
 7.53449e-04, 8.72545e-04, 1.01047e-03, 1.17019e-03, 1.35515e-03,
 1.56936e-03, 1.81742e-03, 2.10470e-03, 2.43738e-03, 2.82265e-03,
 3.26881e-03, 3.78550e-03, 4.38387e-03, 5.07681e-03, 5.87928e-03,
 6.80860e-03, 7.88482e-03, 9.13114e-03, 1.05745e-02, 1.22459e-02,
 1.41816e-02, 1.64233e-02, 1.90192e-02, 2.20255e-02, 2.55071e-02,
 2.95389e-02, 3.42080e-02, 3.96151e-02, 4.58770e-02, 5.31286e-02,
 6.15264e-02, 7.12517e-02, 8.25143e-02, 9.55570e-02, 1.10661e-01,
 1.28153e-01, 1.48410e-01, 1.71869e-01, 1.99035e-01, 2.30496e-01,
 2.66930e-01, 3.09123e-01, 3.57985e-01, 4.14571e-01, 4.80100e-01,
 5.55988e-01, 6.43872e-01, 7.45646e-01, 8.63508e-01, 1.00000e+00}
,
{3.90279e-07, 4.53011e-07, 5.25826e-07, 6.10345e-07, 7.08450e-07,
 8.22323e-07, 9.54501e-07, 1.10792e-06, 1.28601e-06, 1.49272e-06,
 1.73265e-06, 2.01115e-06, 2.33441e-06, 2.70964e-06, 3.14518e-06,
 3.65072e-06, 4.23752e-06, 4.91865e-06, 5.70925e-06, 6.62694e-06,
 7.69213e-06, 8.92853e-06, 1.03637e-05, 1.20295e-05, 1.39631e-05,
 1.62074e-05, 1.88126e-05, 2.18364e-05, 2.53463e-05, 2.94204e-05,
 3.41493e-05, 3.96384e-05, 4.60097e-05, 5.34051e-05, 6.19893e-05,
 7.19532e-05, 8.35187e-05, 9.69432e-05, 1.12526e-04, 1.30612e-04,
 1.51607e-04, 1.75975e-04, 2.04261e-04, 2.37093e-04, 2.75203e-04,
 3.19438e-04, 3.70783e-04, 4.30381e-04, 4.99559e-04, 5.79857e-04,
 6.73061e-04, 7.81246e-04, 9.06820e-04, 1.05258e-03, 1.22177e-03,
 1.41815e-03, 1.64610e-03, 1.91069e-03, 2.21780e-03, 2.57428e-03,
 2.98806e-03, 3.46836e-03, 4.02585e-03, 4.67295e-03, 5.42406e-03,
 6.29590e-03, 7.30788e-03, 8.48253e-03, 9.84598e-03, 1.14286e-02,
 1.32656e-02, 1.53978e-02, 1.78728e-02, 2.07456e-02, 2.40802e-02,
 2.79508e-02, 3.24435e-02, 3.76583e-02, 4.37114e-02, 5.07374e-02,
 5.88927e-02, 6.83590e-02, 7.93467e-02, 9.21006e-02, 1.06905e-01,
 1.24088e-01, 1.44033e-01, 1.67185e-01, 1.94058e-01, 2.25250e-01,
 2.61455e-01, 3.03481e-01, 3.52261e-01, 4.08882e-01, 4.74605e-01,
 5.50891e-01, 6.39439e-01, 7.42220e-01, 8.61522e-01, 1.00000e+00}
,
{3.10724e-07, 3.61500e-07, 4.20574e-07, 4.89300e-07, 5.69258e-07,
 6.62282e-07, 7.70506e-07, 8.96417e-07, 1.04290e-06, 1.21332e-06,
 1.41160e-06, 1.64227e-06, 1.91064e-06, 2.22286e-06, 2.58610e-06,
 3.00870e-06, 3.50036e-06, 4.07236e-06, 4.73783e-06, 5.51205e-06,
 6.41278e-06, 7.46071e-06, 8.67988e-06, 1.00983e-05, 1.17485e-05,
 1.36683e-05, 1.59019e-05, 1.85004e-05, 2.15236e-05, 2.50408e-05,
 2.91328e-05, 3.38935e-05, 3.94321e-05, 4.58757e-05, 5.33724e-05,
 6.20941e-05, 7.22410e-05, 8.40461e-05, 9.77802e-05, 1.13759e-04,
 1.32348e-04, 1.53976e-04, 1.79137e-04, 2.08410e-04, 2.42467e-04,
 2.82089e-04, 3.28186e-04, 3.81815e-04, 4.44209e-04, 5.16798e-04,
 6.01249e-04, 6.99500e-04, 8.13807e-04, 9.46793e-04, 1.10151e-03,
 1.28151e-03, 1.49092e-03, 1.73456e-03, 2.01801e-03, 2.34777e-03,
 2.73143e-03, 3.17778e-03, 3.69707e-03, 4.30121e-03, 5.00408e-03,
 5.82181e-03, 6.77316e-03, 7.87998e-03, 9.16767e-03, 1.06658e-02,
 1.24087e-02, 1.44364e-02, 1.67955e-02, 1.95401e-02, 2.27332e-02,
 2.64481e-02, 3.07700e-02, 3.57982e-02, 4.16480e-02, 4.84538e-02,
 5.63718e-02, 6.55836e-02, 7.63008e-02, 8.87693e-02, 1.03275e-01,
 1.20152e-01, 1.39786e-01, 1.62629e-01, 1.89204e-01, 2.20122e-01,
 2.56093e-01, 2.97942e-01, 3.46629e-01, 4.03272e-01, 4.69172e-01,
 5.45840e-01, 6.35037e-01, 7.38810e-01, 8.59541e-01, 1.00000e+00}
,
{2.47386e-07, 2.88475e-07, 3.36389e-07, 3.92261e-07, 4.57414e-07,
 5.33387e-07, 6.21980e-07, 7.25287e-07, 8.45753e-07, 9.86227e-07,
 1.15003e-06, 1.34105e-06, 1.56379e-06, 1.82352e-06, 2.12640e-06,
 2.47958e-06, 2.89143e-06, 3.37168e-06, 3.93169e-06, 4.58472e-06,
 5.34622e-06, 6.23419e-06, 7.26965e-06, 8.47710e-06, 9.88510e-06,
 1.15270e-05, 1.34415e-05, 1.56741e-05, 1.82774e-05, 2.13132e-05,
 2.48532e-05, 2.89812e-05, 3.37948e-05, 3.94079e-05, 4.59533e-05,
 5.35859e-05, 6.24862e-05, 7.28648e-05, 8.49672e-05, 9.90797e-05,
 1.15536e-04, 1.34726e-04, 1.57103e-04, 1.83197e-04, 2.13625e-04,
 2.49107e-04, 2.90482e-04, 3.38730e-04, 3.94991e-04, 4.60596e-04,
 5.37099e-04, 6.26308e-04, 7.30334e-04, 8.51638e-04, 9.93090e-04,
 1.15804e-03, 1.35038e-03, 1.57467e-03, 1.83621e-03, 2.14120e-03,
 2.49684e-03, 2.91155e-03, 3.39514e-03, 3.95905e-03, 4.61662e-03,
 5.38342e-03, 6.27757e-03, 7.32024e-03, 8.53609e-03, 9.95388e-03,
 1.16072e-02, 1.35350e-02, 1.57831e-02, 1.84046e-02, 2.14615e-02,
 2.50261e-02, 2.91828e-02, 3.40299e-02, 3.96821e-02, 4.62731e-02,
 5.39587e-02, 6.29210e-02, 7.33718e-02, 8.55584e-02, 9.97691e-02,
 1.16340e-01, 1.35664e-01, 1.58197e-01, 1.84472e-01, 2.15112e-01,
 2.50841e-01, 2.92504e-01, 3.41087e-01, 3.97739e-01, 4.63801e-01,
 5.40836e-01, 6.30666e-01, 7.35416e-01, 8.57564e-01, 1.00000e+00}
,
{1.96959e-07, 2.30202e-07, 2.69056e-07, 3.14467e-07, 3.67544e-07,
 4.29579e-07, 5.02084e-07, 5.86827e-07, 6.85873e-07, 8.01636e-07,
 9.36938e-07, 1.09508e-06, 1.27991e-06, 1.49593e-06, 1.74842e-06,
 2.04352e-06, 2.38843e-06, 2.79155e-06, 3.26272e-06, 3.81341e-06,
 4.45704e-06, 5.20931e-06, 6.08855e-06, 7.11619e-06, 8.31727e-06,
 9.72108e-06, 1.13618e-05, 1.32795e-05, 1.55208e-05, 1.81405e-05,
 2.12023e-05, 2.47808e-05, 2.89634e-05, 3.38519e-05, 3.95655e-05,
 4.62435e-05, 5.40485e-05, 6.31710e-05, 7.38331e-05, 8.62948e-05,
 1.00860e-04, 1.17883e-04, 1.37780e-04, 1.61035e-04, 1.88214e-04,
 2.19982e-04, 2.57111e-04, 3.00506e-04, 3.51226e-04, 4.10507e-04,
 4.79793e-04, 5.60774e-04, 6.55423e-04, 7.66046e-04, 8.95341e-04,
 1.04646e-03, 1.22308e-03, 1.42952e-03, 1.67079e-03, 1.95279e-03,
 2.28239e-03, 2.66762e-03, 3.11786e-03, 3.64410e-03, 4.25916e-03,
 4.97804e-03, 5.81824e-03, 6.80025e-03, 7.94802e-03, 9.28950e-03,
 1.08574e-02, 1.26899e-02, 1.48318e-02, 1.73351e-02, 2.02610e-02,
 2.36807e-02, 2.76775e-02, 3.23490e-02, 3.78090e-02, 4.41904e-02,
 5.16490e-02, 6.03664e-02, 7.05552e-02, 8.24637e-02, 9.63821e-02,
 1.12650e-01, 1.31663e-01, 1.53885e-01, 1.79858e-01, 2.10215e-01,
 2.45696e-01, 2.87165e-01, 3.35633e-01, 3.92282e-01, 4.58492e-01,
 5.35878e-01, 6.26324e-01, 7.32037e-01, 8.55591e-01, 1.00000e+00}
,
{1.56810e-07, 1.83700e-07, 2.15200e-07, 2.52102e-07, 2.95331e-07,
 3.45973e-07, 4.05300e-07, 4.74799e-07, 5.56216e-07, 6.51594e-07,
 7.63327e-07, 8.94220e-07, 1.04756e-06, 1.22719e-06, 1.43762e-06,
 1.68414e-06, 1.97293e-06, 2.31124e-06, 2.70757e-06, 3.17185e-06,
 3.71575e-06, 4.35291e-06, 5.09934e-06, 5.97375e-06, 6.99811e-06,
 8.19812e-06, 9.60391e-06, 1.12508e-05, 1.31800e-05, 1.54401e-05,
 1.80877e-05, 2.11893e-05, 2.48227e-05, 2.90792e-05, 3.40657e-05,
 3.99071e-05, 4.67503e-05, 5.47668e-05, 6.41580e-05, 7.51596e-05,
 8.80478e-05, 1.03146e-04, 1.20833e-04, 1.41553e-04, 1.65826e-04,
 1.94261e-04, 2.27573e-04, 2.66596e-04, 3.12311e-04, 3.65865e-04,
 4.28602e-04, 5.02097e-04, 5.88195e-04, 6.89057e-04, 8.07214e-04,
 9.45632e-04, 1.10779e-03, 1.29774e-03, 1.52028e-03, 1.78097e-03,
 2.08636e-03, 2.44413e-03, 2.86324e-03, 3.35421e-03, 3.92938e-03,
 4.60318e-03, 5.39252e-03, 6.31721e-03, 7.40046e-03, 8.66947e-03,
 1.01561e-02, 1.18976e-02, 1.39378e-02, 1.63278e-02, 1.91276e-02,
 2.24075e-02, 2.62499e-02, 3.07511e-02, 3.60242e-02, 4.22015e-02,
 4.94381e-02, 5.79156e-02, 6.78467e-02, 7.94809e-02, 9.31100e-02,
 1.09076e-01, 1.27780e-01, 1.49691e-01, 1.75360e-01, 2.05430e-01,
 2.40657e-01, 2.81924e-01, 3.30267e-01, 3.86900e-01, 4.53244e-01,
 5.30965e-01, 6.22013e-01, 7.28673e-01, 8.53624e-01, 1.00000e+00}
,
{1.24846e-07, 1.46591e-07, 1.72124e-07, 2.02104e-07, 2.37306e-07,
 2.78640e-07, 3.27172e-07, 3.84158e-07, 4.51070e-07, 5.29635e-07,
 6.21886e-07, 7.30204e-07, 8.57389e-07, 1.00673e-06, 1.18207e-06,
 1.38797e-06, 1.62972e-06, 1.91358e-06, 2.24688e-06, 2.63823e-06,
 3.09775e-06, 3.63731e-06, 4.27084e-06, 5.01473e-06, 5.88818e-06,
 6.91376e-06, 8.11798e-06, 9.53195e-06, 1.11922e-05, 1.31416e-05,
 1.54306e-05, 1.81182e-05, 2.12740e-05, 2.49795e-05, 2.93303e-05,
 3.44390e-05, 4.04375e-05, 4.74807e-05, 5.57508e-05, 6.54613e-05,
 7.68632e-05, 9.02510e-05, 1.05971e-04, 1.24428e-04, 1.46101e-04,
 1.71548e-04, 2.01428e-04, 2.36512e-04, 2.77707e-04, 3.26077e-04,
 3.82873e-04, 4.49560e-04, 5.27863e-04, 6.19805e-04, 7.27761e-04,
 8.54520e-04, 1.00336e-03, 1.17812e-03, 1.38332e-03, 1.62426e-03,
 1.90717e-03, 2.23936e-03, 2.62940e-03, 3.08739e-03, 3.62514e-03,
 4.25655e-03, 4.99795e-03, 5.86847e-03, 6.89063e-03, 8.09082e-03,
 9.50005e-03, 1.11547e-02, 1.30976e-02, 1.53790e-02, 1.80576e-02,
 2.12028e-02, 2.48959e-02, 2.92322e-02, 3.43237e-02, 4.03022e-02,
 4.73219e-02, 5.55642e-02, 6.52423e-02, 7.66060e-02, 8.99490e-02,
 1.05616e-01, 1.24012e-01, 1.45612e-01, 1.70974e-01, 2.00754e-01,
 2.35721e-01, 2.76778e-01, 3.24986e-01, 3.81591e-01, 4.48056e-01,
 5.26097e-01, 6.17731e-01, 7.25325e-01, 8.51660e-01, 1.00000e+00}
,
{9.93973e-08, 1.16979e-07, 1.37671e-07, 1.62023e-07, 1.90682e-07,
 2.24410e-07, 2.64105e-07, 3.10821e-07, 3.65800e-07, 4.30504e-07,
 5.06653e-07, 5.96272e-07, 7.01743e-07, 8.25870e-07, 9.71952e-07,
 1.14388e-06, 1.34621e-06, 1.58433e-06, 1.86457e-06, 2.19439e-06,
 2.58254e-06, 3.03935e-06, 3.57696e-06, 4.20966e-06, 4.95428e-06,
 5.83062e-06, 6.86196e-06, 8.07573e-06, 9.50419e-06, 1.11853e-05,
 1.31638e-05, 1.54923e-05, 1.82326e-05, 2.14577e-05, 2.52532e-05,
 2.97201e-05, 3.49771e-05, 4.11640e-05, 4.84452e-05, 5.70144e-05,
 6.70994e-05, 7.89681e-05, 9.29363e-05, 1.09375e-04, 1.28722e-04,
 1.51491e-04, 1.78287e-04, 2.09823e-04, 2.46937e-04, 2.90617e-04,
 3.42022e-04, 4.02520e-04, 4.73720e-04, 5.57513e-04, 6.56128e-04,
 7.72186e-04, 9.08774e-04, 1.06952e-03, 1.25870e-03, 1.48135e-03,
 1.74337e-03, 2.05175e-03, 2.41467e-03, 2.84178e-03, 3.34445e-03,
 3.93603e-03, 4.63225e-03, 5.45162e-03, 6.41592e-03, 7.55079e-03,
 8.88640e-03, 1.04583e-02, 1.23082e-02, 1.44853e-02, 1.70475e-02,
 2.00629e-02, 2.36117e-02, 2.77882e-02, 3.27035e-02, 3.84883e-02,
 4.52962e-02, 5.33084e-02, 6.27378e-02, 7.38351e-02, 8.68953e-02,
 1.02266e-01, 1.20355e-01, 1.41644e-01, 1.66698e-01, 1.96184e-01,
 2.30886e-01, 2.71726e-01, 3.19790e-01, 3.76356e-01, 4.42927e-01,
 5.21274e-01, 6.13478e-01, 7.21993e-01, 8.49702e-01, 1.00000e+00}
,
{7.91361e-08, 9.33487e-08, 1.10114e-07, 1.29890e-07, 1.53218e-07,
 1.80735e-07, 2.13195e-07, 2.51484e-07, 2.96649e-07, 3.49927e-07,
 4.12772e-07, 4.86905e-07, 5.74352e-07, 6.77503e-07, 7.99181e-07,
 9.42711e-07, 1.11202e-06, 1.31173e-06, 1.54732e-06, 1.82521e-06,
 2.15301e-06, 2.53969e-06, 2.99581e-06, 3.53384e-06, 4.16851e-06,
 4.91716e-06, 5.80027e-06, 6.84198e-06, 8.07078e-06, 9.52026e-06,
 1.12301e-05, 1.32470e-05, 1.56261e-05, 1.84325e-05, 2.17429e-05,
 2.56478e-05, 3.02541e-05, 3.56876e-05, 4.20970e-05, 4.96575e-05,
 5.85758e-05, 6.90958e-05, 8.15052e-05, 9.61433e-05, 1.13410e-04,
 1.33778e-04, 1.57805e-04, 1.86146e-04, 2.19577e-04, 2.59012e-04,
 3.05530e-04, 3.60402e-04, 4.25130e-04, 5.01482e-04, 5.91546e-04,
 6.97786e-04, 8.23106e-04, 9.70933e-04, 1.14531e-03, 1.35100e-03,
 1.59364e-03, 1.87985e-03, 2.21747e-03, 2.61572e-03, 3.08549e-03,
 3.63964e-03, 4.29330e-03, 5.06437e-03, 5.97391e-03, 7.04681e-03,
 8.31239e-03, 9.80527e-03, 1.15663e-02, 1.36435e-02, 1.60939e-02,
 1.89843e-02, 2.23938e-02, 2.64156e-02, 3.11598e-02, 3.67560e-02,
 4.33573e-02, 5.11441e-02, 6.03294e-02, 7.11644e-02, 8.39453e-02,
 9.90216e-02, 1.16806e-01, 1.37783e-01, 1.62529e-01, 1.91719e-01,
 2.26151e-01, 2.66767e-01, 3.14677e-01, 3.71192e-01, 4.37857e-01,
 5.16494e-01, 6.09255e-01, 7.18675e-01, 8.47747e-01, 1.00000e+00}
,
{6.30050e-08, 7.44918e-08, 8.80728e-08, 1.04130e-07, 1.23114e-07,
 1.45560e-07, 1.72098e-07, 2.03474e-07, 2.40571e-07, 2.84431e-07,
 3.36287e-07, 3.97598e-07, 4.70087e-07, 5.55791e-07, 6.57121e-07,
 7.76924e-07, 9.18570e-07, 1.08604e-06, 1.28404e-06, 1.51814e-06,
 1.79493e-06, 2.12217e-06, 2.50908e-06, 2.96652e-06, 3.50736e-06,
 4.14681e-06, 4.90284e-06, 5.79671e-06, 6.85354e-06, 8.10306e-06,
 9.58037e-06, 1.13270e-05, 1.33921e-05, 1.58337e-05, 1.87205e-05,
 2.21335e-05, 2.61688e-05, 3.09398e-05, 3.65806e-05, 4.32499e-05,
 5.11350e-05, 6.04577e-05, 7.14802e-05, 8.45121e-05, 9.99201e-05,
 1.18137e-04, 1.39675e-04, 1.65140e-04, 1.95248e-04, 2.30845e-04,
 2.72932e-04, 3.22692e-04, 3.81524e-04, 4.51081e-04, 5.33321e-04,
 6.30554e-04, 7.45514e-04, 8.81433e-04, 1.04213e-03, 1.23213e-03,
 1.45677e-03, 1.72236e-03, 2.03637e-03, 2.40764e-03, 2.84659e-03,
 3.36557e-03, 3.97916e-03, 4.70463e-03, 5.56236e-03, 6.57646e-03,
 7.77546e-03, 9.19305e-03, 1.08691e-02, 1.28507e-02, 1.51936e-02,
 1.79636e-02, 2.12387e-02, 2.51108e-02, 2.96889e-02, 3.51017e-02,
 4.15013e-02, 4.90677e-02, 5.80135e-02, 6.85903e-02, 8.10954e-02,
 9.58804e-02, 1.13361e-01, 1.34028e-01, 1.58464e-01, 1.87354e-01,
 2.21512e-01, 2.61897e-01, 3.09646e-01, 3.66099e-01, 4.32845e-01,
 5.11759e-01, 6.05061e-01, 7.15373e-01, 8.45798e-01, 1.00000e+00}
,
{5.01620e-08, 5.94441e-08, 7.04437e-08, 8.34787e-08, 9.89257e-08,
 1.17231e-07, 1.38924e-07, 1.64630e-07, 1.95094e-07, 2.31194e-07,
 2.73975e-07, 3.24672e-07, 3.84749e-07, 4.55944e-07, 5.40313e-07,
 6.40293e-07, 7.58774e-07, 8.99178e-07, 1.06556e-06, 1.26274e-06,
 1.49640e-06, 1.77329e-06, 2.10142e-06, 2.49028e-06, 2.95108e-06,
 3.49715e-06, 4.14427e-06, 4.91113e-06, 5.81990e-06, 6.89682e-06,
 8.17302e-06, 9.68537e-06, 1.14776e-05, 1.36014e-05, 1.61182e-05,
 1.91007e-05, 2.26352e-05, 2.68236e-05, 3.17871e-05, 3.76691e-05,
 4.46394e-05, 5.28995e-05, 6.26882e-05, 7.42881e-05, 8.80345e-05,
 1.04324e-04, 1.23629e-04, 1.46505e-04, 1.73615e-04, 2.05741e-04,
 2.43812e-04, 2.88927e-04, 3.42390e-04, 4.05747e-04, 4.80827e-04,
 5.69800e-04, 6.75236e-04, 8.00183e-04, 9.48250e-04, 1.12372e-03,
 1.33165e-03, 1.57806e-03, 1.87007e-03, 2.21611e-03, 2.62618e-03,
 3.11213e-03, 3.68801e-03, 4.37044e-03, 5.17915e-03, 6.13751e-03,
 7.27321e-03, 8.61905e-03, 1.02139e-02, 1.21039e-02, 1.43437e-02,
 1.69978e-02, 2.01432e-02, 2.38705e-02, 2.82875e-02, 3.35219e-02,
 3.97248e-02, 4.70756e-02, 5.57865e-02, 6.61093e-02, 7.83423e-02,
 9.28389e-02, 1.10018e-01, 1.30376e-01, 1.54501e-01, 1.83090e-01,
 2.16969e-01, 2.57117e-01, 3.04695e-01, 3.61076e-01, 4.27890e-01,
 5.07067e-01, 6.00896e-01, 7.12087e-01, 8.43852e-01, 1.00000e+00}
,
{3.99369e-08, 4.74360e-08, 5.63433e-08, 6.69230e-08, 7.94894e-08,
 9.44154e-08, 1.12144e-07, 1.33202e-07, 1.58213e-07, 1.87922e-07,
 2.23208e-07, 2.65121e-07, 3.14904e-07, 3.74034e-07, 4.44268e-07,
 5.27690e-07, 6.26776e-07, 7.44468e-07, 8.84259e-07, 1.05030e-06,
 1.24752e-06, 1.48177e-06, 1.76000e-06, 2.09049e-06, 2.48302e-06,
 2.94927e-06, 3.50306e-06, 4.16085e-06, 4.94214e-06, 5.87015e-06,
 6.97240e-06, 8.28163e-06, 9.83670e-06, 1.16838e-05, 1.38777e-05,
 1.64835e-05, 1.95787e-05, 2.32551e-05, 2.76217e-05, 3.28084e-05,
 3.89689e-05, 4.62862e-05, 5.49776e-05, 6.53009e-05, 7.75627e-05,
 9.21269e-05, 1.09426e-04, 1.29973e-04, 1.54379e-04, 1.83367e-04,
 2.17798e-04, 2.58695e-04, 3.07271e-04, 3.64968e-04, 4.33499e-04,
 5.14899e-04, 6.11583e-04, 7.26423e-04, 8.62825e-04, 1.02484e-03,
 1.21728e-03, 1.44585e-03, 1.71734e-03, 2.03982e-03, 2.42284e-03,
 2.87778e-03, 3.41815e-03, 4.05999e-03, 4.82235e-03, 5.72786e-03,
 6.80340e-03, 8.08090e-03, 9.59827e-03, 1.14006e-02, 1.35413e-02,
 1.60840e-02, 1.91041e-02, 2.26914e-02, 2.69522e-02, 3.20131e-02,
 3.80244e-02, 4.51643e-02, 5.36450e-02, 6.37181e-02, 7.56826e-02,
 8.98938e-02, 1.06773e-01, 1.26823e-01, 1.50637e-01, 1.78922e-01,
 2.12519e-01, 2.52424e-01, 2.99823e-01, 3.56122e-01, 4.22992e-01,
 5.02419e-01, 5.96759e-01, 7.08815e-01, 8.41911e-01, 1.00000e+00}
,
{3.17962e-08, 3.78537e-08, 4.50653e-08, 5.36507e-08, 6.38718e-08,
 7.60401e-08, 9.05266e-08, 1.07773e-07, 1.28305e-07, 1.52749e-07,
 1.81849e-07, 2.16493e-07, 2.57738e-07, 3.06840e-07, 3.65296e-07,
 4.34889e-07, 5.17741e-07, 6.16376e-07, 7.33803e-07, 8.73601e-07,
 1.04003e-06, 1.23817e-06, 1.47406e-06, 1.75488e-06, 2.08920e-06,
 2.48722e-06, 2.96107e-06, 3.52518e-06, 4.19677e-06, 4.99630e-06,
 5.94816e-06, 7.08135e-06, 8.43043e-06, 1.00365e-05, 1.19486e-05,
 1.42249e-05, 1.69350e-05, 2.01613e-05, 2.40022e-05, 2.85749e-05,
 3.40187e-05, 4.04997e-05, 4.82154e-05, 5.74010e-05, 6.83365e-05,
 8.13554e-05, 9.68545e-05, 1.15306e-04, 1.37274e-04, 1.63426e-04,
 1.94560e-04, 2.31626e-04, 2.75754e-04, 3.28288e-04, 3.90831e-04,
 4.65288e-04, 5.53931e-04, 6.59461e-04, 7.85096e-04, 9.34666e-04,
 1.11273e-03, 1.32472e-03, 1.57709e-03, 1.87755e-03, 2.23524e-03,
 2.66108e-03, 3.16805e-03, 3.77160e-03, 4.49013e-03, 5.34555e-03,
 6.36394e-03, 7.57634e-03, 9.01972e-03, 1.07381e-02, 1.27838e-02,
 1.52193e-02, 1.81187e-02, 2.15705e-02, 2.56800e-02, 3.05723e-02,
 3.63967e-02, 4.33307e-02, 5.15857e-02, 6.14133e-02, 7.31133e-02,
 8.70422e-02, 1.03625e-01, 1.23366e-01, 1.46869e-01, 1.74849e-01,
 2.08160e-01, 2.47817e-01, 2.95029e-01, 3.51236e-01, 4.18150e-01,
 4.97812e-01, 5.92651e-01, 7.05558e-01, 8.39975e-01, 1.00000e+00}
,
{2.53148e-08, 3.02071e-08, 3.60447e-08, 4.30106e-08, 5.13227e-08,
 6.12411e-08, 7.30763e-08, 8.71987e-08, 1.04050e-07, 1.24159e-07,
 1.48153e-07, 1.76785e-07, 2.10949e-07, 2.51716e-07, 3.00362e-07,
 3.58409e-07, 4.27673e-07, 5.10324e-07, 6.08947e-07, 7.26629e-07,
 8.67055e-07, 1.03462e-06, 1.23456e-06, 1.47315e-06, 1.75785e-06,
 2.09756e-06, 2.50293e-06, 2.98663e-06, 3.56382e-06, 4.25254e-06,
 5.07437e-06, 6.05503e-06, 7.22520e-06, 8.62151e-06, 1.02877e-05,
 1.22758e-05, 1.46482e-05, 1.74790e-05, 2.08570e-05, 2.48877e-05,
 2.96974e-05, 3.54366e-05, 4.22849e-05, 5.04567e-05, 6.02078e-05,
 7.18433e-05, 8.57274e-05, 1.02295e-04, 1.22064e-04, 1.45653e-04,
 1.73802e-04, 2.07390e-04, 2.47469e-04, 2.95294e-04, 3.52362e-04,
 4.20458e-04, 5.01713e-04, 5.98673e-04, 7.14370e-04, 8.52426e-04,
 1.01716e-03, 1.21373e-03, 1.44830e-03, 1.72819e-03, 2.06217e-03,
 2.46070e-03, 2.93624e-03, 3.50369e-03, 4.18079e-03, 4.98876e-03,
 5.95286e-03, 7.10329e-03, 8.47604e-03, 1.01141e-02, 1.20687e-02,
 1.44010e-02, 1.71841e-02, 2.05051e-02, 2.44678e-02, 2.91963e-02,
 3.48387e-02, 4.15715e-02, 4.96054e-02, 5.91919e-02, 7.06311e-02,
 8.42810e-02, 1.00569e-01, 1.20004e-01, 1.43196e-01, 1.70869e-01,
 2.03891e-01, 2.43294e-01, 2.90312e-01, 3.46416e-01, 4.13363e-01,
 4.93248e-01, 5.88572e-01, 7.02316e-01, 8.38043e-01, 1.00000e+00}
,
{2.01546e-08, 2.41051e-08, 2.88298e-08, 3.44807e-08, 4.12391e-08,
 4.93222e-08, 5.89897e-08, 7.05521e-08, 8.43808e-08, 1.00920e-07,
 1.20701e-07, 1.44359e-07, 1.72654e-07, 2.06496e-07, 2.46970e-07,
 2.95378e-07, 3.53274e-07, 4.22519e-07, 5.05335e-07, 6.04384e-07,
 7.22847e-07, 8.64530e-07, 1.03398e-06, 1.23665e-06, 1.47904e-06,
 1.76895e-06, 2.11567e-06, 2.53036e-06, 3.02632e-06, 3.61950e-06,
 4.32895e-06, 5.17745e-06, 6.19227e-06, 7.40599e-06, 8.85762e-06,
 1.05938e-05, 1.26702e-05, 1.51537e-05, 1.81239e-05, 2.16763e-05,
 2.59250e-05, 3.10064e-05, 3.70839e-05, 4.43526e-05, 5.30460e-05,
 6.34434e-05, 7.58787e-05, 9.07514e-05, 1.08539e-04, 1.29814e-04,
 1.55258e-04, 1.85690e-04, 2.22086e-04, 2.65616e-04, 3.17679e-04,
 3.79946e-04, 4.54418e-04, 5.43487e-04, 6.50014e-04, 7.77421e-04,
 9.29801e-04, 1.11205e-03, 1.33002e-03, 1.59071e-03, 1.90250e-03,
 2.27540e-03, 2.72140e-03, 3.25481e-03, 3.89277e-03, 4.65578e-03,
 5.56834e-03, 6.65977e-03, 7.96513e-03, 9.52635e-03, 1.13936e-02,
 1.36268e-02, 1.62977e-02, 1.94922e-02, 2.33128e-02, 2.78823e-02,
 3.33474e-02, 3.98837e-02, 4.77012e-02, 5.70509e-02, 6.82333e-02,
 8.16074e-02, 9.76030e-02, 1.16734e-01, 1.39615e-01, 1.66980e-01,
 1.99709e-01, 2.38853e-01, 2.85670e-01, 3.41663e-01, 4.08632e-01,
 4.88726e-01, 5.84520e-01, 6.99090e-01, 8.36116e-01, 1.00000e+00}
,
{1.60463e-08, 1.92357e-08, 2.30591e-08, 2.76424e-08, 3.31367e-08,
 3.97231e-08, 4.76186e-08, 5.70834e-08, 6.84295e-08, 8.20308e-08,
 9.83356e-08, 1.17881e-07, 1.41312e-07, 1.69399e-07, 2.03070e-07,
 2.43433e-07, 2.91818e-07, 3.49821e-07, 4.19353e-07, 5.02705e-07,
 6.02624e-07, 7.22404e-07, 8.65992e-07, 1.03812e-06, 1.24446e-06,
 1.49181e-06, 1.78833e-06, 2.14379e-06, 2.56989e-06, 3.08070e-06,
 3.69303e-06, 4.42707e-06, 5.30701e-06, 6.36185e-06, 7.62635e-06,
 9.14219e-06, 1.09593e-05, 1.31376e-05, 1.57489e-05, 1.88793e-05,
 2.26318e-05, 2.71301e-05, 3.25226e-05, 3.89869e-05, 4.67361e-05,
 5.60256e-05, 6.71614e-05, 8.05107e-05, 9.65133e-05, 1.15697e-04,
 1.38693e-04, 1.66260e-04, 1.99306e-04, 2.38921e-04, 2.86410e-04,
 3.43338e-04, 4.11581e-04, 4.93389e-04, 5.91457e-04, 7.09017e-04,
 8.49944e-04, 1.01888e-03, 1.22140e-03, 1.46417e-03, 1.75519e-03,
 2.10406e-03, 2.52227e-03, 3.02361e-03, 3.62459e-03, 4.34503e-03,
 5.20866e-03, 6.24395e-03, 7.48502e-03, 8.97277e-03, 1.07562e-02,
 1.28942e-02, 1.54571e-02, 1.85294e-02, 2.22124e-02, 2.66274e-02,
 3.19199e-02, 3.82644e-02, 4.58700e-02, 5.49873e-02, 6.59168e-02,
 7.90187e-02, 9.47247e-02, 1.13553e-01, 1.36123e-01, 1.63179e-01,
 1.95613e-01, 2.34494e-01, 2.81103e-01, 3.36976e-01, 4.03954e-01,
 4.84246e-01, 5.80496e-01, 6.95878e-01, 8.34193e-01, 1.00000e+00}
,
{1.27754e-08, 1.53500e-08, 1.84434e-08, 2.21603e-08, 2.66262e-08,
 3.19921e-08, 3.84394e-08, 4.61860e-08, 5.54937e-08, 6.66772e-08,
 8.01144e-08, 9.62597e-08, 1.15659e-07, 1.38967e-07, 1.66973e-07,
 2.00622e-07, 2.41053e-07, 2.89632e-07, 3.48000e-07, 4.18132e-07,
 5.02396e-07, 6.03643e-07, 7.25293e-07, 8.71460e-07, 1.04708e-06,
 1.25810e-06, 1.51164e-06, 1.81628e-06, 2.18230e-06, 2.62210e-06,
 3.15052e-06, 3.78544e-06, 4.54831e-06, 5.46491e-06, 6.56624e-06,
 7.88952e-06, 9.47947e-06, 1.13898e-05, 1.36852e-05, 1.64431e-05,
 1.97569e-05, 2.37384e-05, 2.85224e-05, 3.42704e-05, 4.11768e-05,
 4.94751e-05, 5.94456e-05, 7.14255e-05, 8.58197e-05, 1.03115e-04,
 1.23895e-04, 1.48863e-04, 1.78863e-04, 2.14909e-04, 2.58219e-04,
 3.10257e-04, 3.72783e-04, 4.47909e-04, 5.38174e-04, 6.46631e-04,
 7.76945e-04, 9.33520e-04, 1.12165e-03, 1.34769e-03, 1.61929e-03,
 1.94562e-03, 2.33772e-03, 2.80883e-03, 3.37488e-03, 4.05501e-03,
 4.87221e-03, 5.85409e-03, 7.03385e-03, 8.45136e-03, 1.01545e-02,
 1.22010e-02, 1.46598e-02, 1.76141e-02, 2.11638e-02, 2.54289e-02,
 3.05536e-02, 3.67109e-02, 4.41092e-02, 5.29984e-02, 6.36790e-02,
 7.65120e-02, 9.19313e-02, 1.10458e-01, 1.32718e-01, 1.59465e-01,
 1.91601e-01, 2.30214e-01, 2.76608e-01, 3.32352e-01, 3.99330e-01,
 4.79806e-01, 5.76500e-01, 6.92680e-01, 8.32274e-01, 1.00000e+00}
,
{1.01713e-08, 1.22492e-08, 1.47517e-08, 1.77654e-08, 2.13948e-08,
 2.57657e-08, 3.10296e-08, 3.73689e-08, 4.50032e-08, 5.41972e-08,
 6.52696e-08, 7.86039e-08, 9.46625e-08, 1.14002e-07, 1.37292e-07,
 1.65340e-07, 1.99119e-07, 2.39798e-07, 2.88788e-07, 3.47787e-07,
 4.18838e-07, 5.04406e-07, 6.07455e-07, 7.31556e-07, 8.81010e-07,
 1.06100e-06, 1.27776e-06, 1.53880e-06, 1.85317e-06, 2.23177e-06,
 2.68771e-06, 3.23680e-06, 3.89807e-06, 4.69443e-06, 5.65349e-06,
 6.80848e-06, 8.19944e-06, 9.87456e-06, 1.18919e-05, 1.43214e-05,
 1.72472e-05, 2.07707e-05, 2.50141e-05, 3.01244e-05, 3.62788e-05,
 4.36904e-05, 5.26162e-05, 6.33656e-05, 7.63110e-05, 9.19011e-05,
 1.10676e-04, 1.33287e-04, 1.60517e-04, 1.93310e-04, 2.32803e-04,
 2.80364e-04, 3.37641e-04, 4.06621e-04, 4.89692e-04, 5.89734e-04,
 7.10215e-04, 8.55310e-04, 1.03005e-03, 1.24048e-03, 1.49391e-03,
 1.79911e-03, 2.16666e-03, 2.60931e-03, 3.14238e-03, 3.78436e-03,
 4.55749e-03, 5.48857e-03, 6.60987e-03, 7.96025e-03, 9.58651e-03,
 1.15450e-02, 1.39036e-02, 1.67441e-02, 2.01648e-02, 2.42844e-02,
 2.92457e-02, 3.52205e-02, 4.24159e-02, 5.10814e-02, 6.15171e-02,
 7.40849e-02, 8.92202e-02, 1.07448e-01, 1.29399e-01, 1.55835e-01,
 1.87671e-01, 2.26012e-01, 2.72185e-01, 3.27792e-01, 3.94759e-01,
 4.75407e-01, 5.72531e-01, 6.89498e-01, 8.30360e-01, 1.00000e+00}
,
{8.09795e-09, 9.77481e-09, 1.17989e-08, 1.42422e-08, 1.71913e-08,
 2.07512e-08, 2.50482e-08, 3.02350e-08, 3.64959e-08, 4.40532e-08,
 5.31754e-08, 6.41866e-08, 7.74779e-08, 9.35215e-08, 1.12887e-07,
 1.36263e-07, 1.64480e-07, 1.98539e-07, 2.39651e-07, 2.89276e-07,
 3.49178e-07, 4.21483e-07, 5.08761e-07, 6.14112e-07, 7.41278e-07,
 8.94776e-07, 1.08006e-06, 1.30371e-06, 1.57368e-06, 1.89954e-06,
 2.29289e-06, 2.76768e-06, 3.34079e-06, 4.03258e-06, 4.86762e-06,
 5.87558e-06, 7.09225e-06, 8.56086e-06, 1.03336e-05, 1.24734e-05,
 1.50563e-05, 1.81741e-05, 2.19374e-05, 2.64801e-05, 3.19634e-05,
 3.85821e-05, 4.65715e-05, 5.62152e-05, 6.78558e-05, 8.19069e-05,
 9.88676e-05, 1.19340e-04, 1.44053e-04, 1.73882e-04, 2.09888e-04,
 2.53351e-04, 3.05813e-04, 3.69138e-04, 4.45577e-04, 5.37844e-04,
 6.49217e-04, 7.83653e-04, 9.45926e-04, 1.14180e-03, 1.37824e-03,
 1.66363e-03, 2.00813e-03, 2.42396e-03, 2.92590e-03, 3.53177e-03,
 4.26310e-03, 5.14588e-03, 6.21145e-03, 7.49768e-03, 9.05024e-03,
 1.09243e-02, 1.31864e-02, 1.59170e-02, 1.92130e-02, 2.31915e-02,
 2.79938e-02, 3.37906e-02, 4.07877e-02, 4.92337e-02, 5.94287e-02,
 7.17348e-02, 8.65891e-02, 1.04519e-01, 1.26163e-01, 1.52287e-01,
 1.83822e-01, 2.21887e-01, 2.67833e-01, 3.23295e-01, 3.90240e-01,
 4.71049e-01, 5.68590e-01, 6.86330e-01, 8.28450e-01, 1.00000e+00}
,
{6.44725e-09, 7.80025e-09, 9.43717e-09, 1.14176e-08, 1.38137e-08,
 1.67126e-08, 2.02198e-08, 2.44630e-08, 2.95967e-08, 3.58078e-08,
 4.33222e-08, 5.24136e-08, 6.34129e-08, 7.67205e-08, 9.28207e-08,
 1.12300e-07, 1.35866e-07, 1.64379e-07, 1.98875e-07, 2.40610e-07,
 2.91103e-07, 3.52193e-07, 4.26102e-07, 5.15522e-07, 6.23707e-07,
 7.54596e-07, 9.12952e-07, 1.10454e-06, 1.33633e-06, 1.61677e-06,
 1.95606e-06, 2.36655e-06, 2.86319e-06, 3.46404e-06, 4.19099e-06,
 5.07050e-06, 6.13457e-06, 7.42194e-06, 8.97948e-06, 1.08639e-05,
 1.31437e-05, 1.59020e-05, 1.92391e-05, 2.32766e-05, 2.81613e-05,
 3.40711e-05, 4.12211e-05, 4.98716e-05, 6.03375e-05, 7.29996e-05,
 8.83190e-05, 1.06853e-04, 1.29277e-04, 1.56407e-04, 1.89229e-04,
 2.28940e-04, 2.76985e-04, 3.35111e-04, 4.05437e-04, 4.90520e-04,
 5.93458e-04, 7.17999e-04, 8.68675e-04, 1.05097e-03, 1.27152e-03,
 1.53836e-03, 1.86119e-03, 2.25178e-03, 2.72432e-03, 3.29604e-03,
 3.98773e-03, 4.82458e-03, 5.83705e-03, 7.06198e-03, 8.54398e-03,
 1.03370e-02, 1.25063e-02, 1.51308e-02, 1.83061e-02, 2.21477e-02,
 2.67955e-02, 3.24187e-02, 3.92219e-02, 4.74529e-02, 5.74111e-02,
 6.94592e-02, 8.40356e-02, 1.01671e-01, 1.23007e-01, 1.48821e-01,
 1.80052e-01, 2.17837e-01, 2.63551e-01, 3.18859e-01, 3.85773e-01,
 4.66730e-01, 5.64676e-01, 6.83176e-01, 8.26545e-01, 1.00000e+00}
,
{5.13304e-09, 6.22456e-09, 7.54818e-09, 9.15326e-09, 1.10996e-08,
 1.34599e-08, 1.63221e-08, 1.97929e-08, 2.40018e-08, 2.91056e-08,
 3.52948e-08, 4.28001e-08, 5.19013e-08, 6.29378e-08, 7.63212e-08,
 9.25505e-08, 1.12231e-07, 1.36096e-07, 1.65036e-07, 2.00130e-07,
 2.42687e-07, 2.94293e-07, 3.56873e-07, 4.32760e-07, 5.24784e-07,
 6.36377e-07, 7.71699e-07, 9.35797e-07, 1.13479e-06, 1.37610e-06,
 1.66872e-06, 2.02356e-06, 2.45386e-06, 2.97566e-06, 3.60842e-06,
 4.37573e-06, 5.30620e-06, 6.43454e-06, 7.80281e-06, 9.46204e-06,
 1.14741e-05, 1.39140e-05, 1.68727e-05, 2.04606e-05, 2.48115e-05,
 3.00875e-05, 3.64855e-05, 4.42439e-05, 5.36521e-05, 6.50610e-05,
 7.88959e-05, 9.56726e-05, 1.16017e-04, 1.40687e-04, 1.70604e-04,
 2.06882e-04, 2.50874e-04, 3.04221e-04, 3.68912e-04, 4.47359e-04,
 5.42488e-04, 6.57845e-04, 7.97732e-04, 9.67366e-04, 1.17307e-03,
 1.42252e-03, 1.72501e-03, 2.09182e-03, 2.53664e-03, 3.07604e-03,
 3.73015e-03, 4.52334e-03, 5.48521e-03, 6.65161e-03, 8.06604e-03,
 9.78124e-03, 1.18612e-02, 1.43834e-02, 1.74419e-02, 2.11509e-02,
 2.56485e-02, 3.11025e-02, 3.77163e-02, 4.57365e-02, 5.54621e-02,
 6.72558e-02, 8.15574e-02, 9.89001e-02, 1.19931e-01, 1.45433e-01,
 1.76359e-01, 2.13861e-01, 2.59337e-01, 3.14484e-01, 3.81357e-01,
 4.62451e-01, 5.60789e-01, 6.80037e-01, 8.24644e-01, 1.00000e+00}
,
{4.08672e-09, 4.96716e-09, 6.03729e-09, 7.33796e-09, 8.91886e-09,
 1.08403e-08, 1.31758e-08, 1.60144e-08, 1.94645e-08, 2.36580e-08,
 2.87548e-08, 3.49498e-08, 4.24794e-08, 5.16311e-08, 6.27545e-08,
 7.62744e-08, 9.27069e-08, 1.12680e-07, 1.36955e-07, 1.66461e-07,
 2.02324e-07, 2.45912e-07, 2.98892e-07, 3.63285e-07, 4.41551e-07,
 5.36679e-07, 6.52301e-07, 7.92833e-07, 9.63641e-07, 1.17125e-06,
 1.42358e-06, 1.73028e-06, 2.10305e-06, 2.55613e-06, 3.10683e-06,
 3.77616e-06, 4.58970e-06, 5.57850e-06, 6.78034e-06, 8.24109e-06,
 1.00166e-05, 1.21745e-05, 1.47974e-05, 1.79854e-05, 2.18601e-05,
 2.65697e-05, 3.22939e-05, 3.92512e-05, 4.77075e-05, 5.79857e-05,
 7.04781e-05, 8.56619e-05, 1.04117e-04, 1.26548e-04, 1.53811e-04,
 1.86949e-04, 2.27225e-04, 2.76178e-04, 3.35678e-04, 4.07997e-04,
 4.95895e-04, 6.02731e-04, 7.32584e-04, 8.90412e-04, 1.08224e-03,
 1.31540e-03, 1.59879e-03, 1.94323e-03, 2.36189e-03, 2.87073e-03,
 3.48920e-03, 4.24091e-03, 5.15458e-03, 6.26508e-03, 7.61483e-03,
 9.25537e-03, 1.12494e-02, 1.36729e-02, 1.66186e-02, 2.01989e-02,
 2.45506e-02, 2.98398e-02, 3.62685e-02, 4.40821e-02, 5.35792e-02,
 6.51223e-02, 7.91523e-02, 9.62048e-02, 1.16931e-01, 1.42123e-01,
 1.72742e-01, 2.09957e-01, 2.55191e-01, 3.10169e-01, 3.76992e-01,
 4.58211e-01, 5.56928e-01, 6.76913e-01, 8.22747e-01, 1.00000e+00}
,
{3.25368e-09, 3.96377e-09, 4.82883e-09, 5.88268e-09, 7.16653e-09,
 8.73057e-09, 1.06360e-08, 1.29572e-08, 1.57850e-08, 1.92299e-08,
 2.34267e-08, 2.85394e-08, 3.47679e-08, 4.23557e-08, 5.15994e-08,
 6.28606e-08, 7.65794e-08, 9.32923e-08, 1.13653e-07, 1.38456e-07,
 1.68673e-07, 2.05485e-07, 2.50330e-07, 3.04963e-07, 3.71519e-07,
 4.52600e-07, 5.51376e-07, 6.71710e-07, 8.18305e-07, 9.96894e-07,
 1.21446e-06, 1.47950e-06, 1.80239e-06, 2.19575e-06, 2.67496e-06,
 3.25875e-06, 3.96994e-06, 4.83635e-06, 5.89184e-06, 7.17769e-06,
 8.74416e-06, 1.06525e-05, 1.29773e-05, 1.58095e-05, 1.92598e-05,
 2.34631e-05, 2.85838e-05, 3.48220e-05, 4.24216e-05, 5.16798e-05,
 6.29585e-05, 7.66987e-05, 9.34375e-05, 1.13830e-04, 1.38672e-04,
 1.68936e-04, 2.05805e-04, 2.50720e-04, 3.05438e-04, 3.72097e-04,
 4.53305e-04, 5.52235e-04, 6.72756e-04, 8.19579e-04, 9.98446e-04,
 1.21635e-03, 1.48181e-03, 1.80520e-03, 2.19917e-03, 2.67912e-03,
 3.26382e-03, 3.97612e-03, 4.84388e-03, 5.90102e-03, 7.18886e-03,
 8.75778e-03, 1.06691e-02, 1.29975e-02, 1.58341e-02, 1.92898e-02,
 2.34997e-02, 2.86283e-02, 3.48762e-02, 4.24876e-02, 5.17602e-02,
 6.30565e-02, 7.68181e-02, 9.35830e-02, 1.14007e-01, 1.38888e-01,
 1.69199e-01, 2.06125e-01, 2.51111e-01, 3.05913e-01, 3.72677e-01,
 4.54010e-01, 5.53094e-01, 6.73803e-01, 8.20855e-01, 1.00000e+00}
,
{2.59045e-09, 3.16307e-09, 3.86226e-09, 4.71602e-09, 5.75850e-09,
 7.03142e-09, 8.58571e-09, 1.04836e-08, 1.28010e-08, 1.56307e-08,
 1.90858e-08, 2.33047e-08, 2.84563e-08, 3.47465e-08, 4.24273e-08,
 5.18058e-08, 6.32575e-08, 7.72406e-08, 9.43147e-08, 1.15163e-07,
 1.40620e-07, 1.71704e-07, 2.09659e-07, 2.56004e-07, 3.12594e-07,
 3.81693e-07, 4.66067e-07, 5.69091e-07, 6.94889e-07, 8.48494e-07,
 1.03605e-06, 1.26507e-06, 1.54472e-06, 1.88618e-06, 2.30312e-06,
 2.81223e-06, 3.43387e-06, 4.19293e-06, 5.11978e-06, 6.25151e-06,
 7.63341e-06, 9.32077e-06, 1.13811e-05, 1.38969e-05, 1.69689e-05,
 2.07198e-05, 2.53000e-05, 3.08925e-05, 3.77213e-05, 4.60596e-05,
 5.62412e-05, 6.86733e-05, 8.38535e-05, 1.02389e-04, 1.25023e-04,
 1.52659e-04, 1.86404e-04, 2.27609e-04, 2.77922e-04, 3.39357e-04,
 4.14372e-04, 5.05969e-04, 6.17813e-04, 7.54381e-04, 9.21137e-04,
 1.12476e-03, 1.37338e-03, 1.67697e-03, 2.04766e-03, 2.50030e-03,
 3.05299e-03, 3.72786e-03, 4.55190e-03, 5.55810e-03, 6.78673e-03,
 8.28693e-03, 1.01188e-02, 1.23555e-02, 1.50867e-02, 1.84216e-02,
 2.24937e-02, 2.74660e-02, 3.35374e-02, 4.09508e-02, 5.00030e-02,
 6.10562e-02, 7.45527e-02, 9.10326e-02, 1.11155e-01, 1.35726e-01,
 1.65729e-01, 2.02363e-01, 2.47096e-01, 3.01716e-01, 3.68411e-01,
 4.49848e-01, 5.49287e-01, 6.70707e-01, 8.18967e-01, 1.00000e+00}
,
{2.06241e-09, 2.52411e-09, 3.08917e-09, 3.78073e-09, 4.62710e-09,
 5.66295e-09, 6.93069e-09, 8.48223e-09, 1.03811e-08, 1.27051e-08,
 1.55493e-08, 1.90302e-08, 2.32905e-08, 2.85044e-08, 3.48855e-08,
 4.26952e-08, 5.22531e-08, 6.39508e-08, 7.82671e-08, 9.57884e-08,
 1.17232e-07, 1.43476e-07, 1.75596e-07, 2.14905e-07, 2.63015e-07,
 3.21895e-07, 3.93956e-07, 4.82149e-07, 5.90086e-07, 7.22186e-07,
 8.83858e-07, 1.08172e-06, 1.32388e-06, 1.62025e-06, 1.98297e-06,
 2.42689e-06, 2.97019e-06, 3.63511e-06, 4.44888e-06, 5.44484e-06,
 6.66374e-06, 8.15552e-06, 9.98126e-06, 1.22157e-05, 1.49504e-05,
 1.82973e-05, 2.23934e-05, 2.74065e-05, 3.35419e-05, 4.10507e-05,
 5.02405e-05, 6.14876e-05, 7.52526e-05, 9.20990e-05, 1.12717e-04,
 1.37950e-04, 1.68832e-04, 2.06628e-04, 2.52885e-04, 3.09497e-04,
 3.78783e-04, 4.63579e-04, 5.67358e-04, 6.94370e-04, 8.49815e-04,
 1.04006e-03, 1.27289e-03, 1.55785e-03, 1.90660e-03, 2.33342e-03,
 2.85579e-03, 3.49510e-03, 4.27753e-03, 5.23512e-03, 6.40708e-03,
 7.84141e-03, 9.59682e-03, 1.17452e-02, 1.43746e-02, 1.75925e-02,
 2.15309e-02, 2.63509e-02, 3.22499e-02, 3.94696e-02, 4.83055e-02,
 5.91194e-02, 7.23541e-02, 8.85517e-02, 1.08375e-01, 1.32637e-01,
 1.62330e-01, 1.98670e-01, 2.43145e-01, 2.97576e-01, 3.64193e-01,
 4.45724e-01, 5.45506e-01, 6.67625e-01, 8.17083e-01, 1.00000e+00}
,
{1.64201e-09, 2.01423e-09, 2.47083e-09, 3.03093e-09, 3.71800e-09,
 4.56082e-09, 5.59469e-09, 6.86294e-09, 8.41867e-09, 1.03271e-08,
 1.26681e-08, 1.55398e-08, 1.90624e-08, 2.33836e-08, 2.86844e-08,
 3.51867e-08, 4.31631e-08, 5.29475e-08, 6.49500e-08, 7.96733e-08,
 9.77342e-08, 1.19889e-07, 1.47066e-07, 1.80404e-07, 2.21300e-07,
 2.71465e-07, 3.33003e-07, 4.08490e-07, 5.01089e-07, 6.14680e-07,
 7.54019e-07, 9.24945e-07, 1.13462e-06, 1.39182e-06, 1.70733e-06,
 2.09436e-06, 2.56912e-06, 3.15150e-06, 3.86590e-06, 4.74225e-06,
 5.81726e-06, 7.13595e-06, 8.75358e-06, 1.07379e-05, 1.31720e-05,
 1.61580e-05, 1.98207e-05, 2.43138e-05, 2.98255e-05, 3.65865e-05,
 4.48801e-05, 5.50539e-05, 6.75338e-05, 8.28428e-05, 1.01622e-04,
 1.24659e-04, 1.52917e-04, 1.87581e-04, 2.30103e-04, 2.82265e-04,
 3.46250e-04, 4.24740e-04, 5.21023e-04, 6.39132e-04, 7.84015e-04,
 9.61741e-04, 1.17975e-03, 1.44719e-03, 1.77525e-03, 2.17767e-03,
 2.67132e-03, 3.27687e-03, 4.01970e-03, 4.93091e-03, 6.04868e-03,
 7.41983e-03, 9.10180e-03, 1.11651e-02, 1.36960e-02, 1.68007e-02,
 2.06092e-02, 2.52811e-02, 3.10119e-02, 3.80419e-02, 4.66655e-02,
 5.72440e-02, 7.02204e-02, 8.61384e-02, 1.05665e-01, 1.29618e-01,
 1.59000e-01, 1.95043e-01, 2.39257e-01, 2.93493e-01, 3.60025e-01,
 4.41637e-01, 5.41750e-01, 6.64558e-01, 8.15204e-01, 1.00000e+00}
,
{1.30730e-09, 1.60734e-09, 1.97625e-09, 2.42983e-09, 2.98751e-09,
 3.67318e-09, 4.51623e-09, 5.55277e-09, 6.82721e-09, 8.39416e-09,
 1.03207e-08, 1.26895e-08, 1.56019e-08, 1.91828e-08, 2.35855e-08,
 2.89987e-08, 3.56543e-08, 4.38375e-08, 5.38988e-08, 6.62694e-08,
 8.14792e-08, 1.00180e-07, 1.23172e-07, 1.51442e-07, 1.86201e-07,
 2.28936e-07, 2.81480e-07, 3.46084e-07, 4.25515e-07, 5.23177e-07,
 6.43254e-07, 7.90890e-07, 9.72410e-07, 1.19559e-06, 1.47000e-06,
 1.80738e-06, 2.22220e-06, 2.73223e-06, 3.35932e-06, 4.13033e-06,
 5.07830e-06, 6.24384e-06, 7.67689e-06, 9.43885e-06, 1.16052e-05,
 1.42688e-05, 1.75436e-05, 2.15702e-05, 2.65208e-05, 3.26077e-05,
 4.00917e-05, 4.92933e-05, 6.06068e-05, 7.45169e-05, 9.16196e-05,
 1.12648e-04, 1.38502e-04, 1.70290e-04, 2.09374e-04, 2.57428e-04,
 3.16512e-04, 3.89156e-04, 4.78473e-04, 5.88289e-04, 7.23310e-04,
 8.89320e-04, 1.09343e-03, 1.34439e-03, 1.65295e-03, 2.03232e-03,
 2.49877e-03, 3.07227e-03, 3.77740e-03, 4.64437e-03, 5.71032e-03,
 7.02092e-03, 8.63232e-03, 1.06136e-02, 1.30495e-02, 1.60446e-02,
 1.97270e-02, 2.42547e-02, 2.98215e-02, 3.66659e-02, 4.50813e-02,
 5.54281e-02, 6.81496e-02, 8.37909e-02, 1.03022e-01, 1.26667e-01,
 1.55739e-01, 1.91483e-01, 2.35432e-01, 2.89467e-01, 3.55903e-01,
 4.37588e-01, 5.38021e-01, 6.61505e-01, 8.13329e-01, 1.00000e+00}
,
{1.04082e-09, 1.28265e-09, 1.58067e-09, 1.94794e-09, 2.40054e-09,
 2.95830e-09, 3.64566e-09, 4.49273e-09, 5.53660e-09, 6.82303e-09,
 8.40835e-09, 1.03620e-08, 1.27696e-08, 1.57366e-08, 1.93930e-08,
 2.38989e-08, 2.94518e-08, 3.62949e-08, 4.47280e-08, 5.51205e-08,
 6.79276e-08, 8.37105e-08, 1.03161e-07, 1.27130e-07, 1.56668e-07,
 1.93070e-07, 2.37929e-07, 2.93212e-07, 3.61339e-07, 4.45296e-07,
 5.48760e-07, 6.76264e-07, 8.33393e-07, 1.02703e-06, 1.26566e-06,
 1.55973e-06, 1.92214e-06, 2.36874e-06, 2.91911e-06, 3.59737e-06,
 4.43321e-06, 5.46326e-06, 6.73264e-06, 8.29696e-06, 1.02247e-05,
 1.26005e-05, 1.55282e-05, 1.91361e-05, 2.35823e-05, 2.90617e-05,
 3.58141e-05, 4.41355e-05, 5.43903e-05, 6.70278e-05, 8.26016e-05,
 1.01794e-04, 1.25446e-04, 1.54593e-04, 1.90512e-04, 2.34778e-04,
 2.89328e-04, 3.56553e-04, 4.39397e-04, 5.41491e-04, 6.67305e-04,
 8.22353e-04, 1.01342e-03, 1.24889e-03, 1.53907e-03, 1.89667e-03,
 2.33736e-03, 2.88044e-03, 3.54971e-03, 4.37448e-03, 5.39089e-03,
 6.64345e-03, 8.18705e-03, 1.00893e-02, 1.24335e-02, 1.53225e-02,
 1.88826e-02, 2.32699e-02, 2.86767e-02, 3.53397e-02, 4.35508e-02,
 5.36698e-02, 6.61399e-02, 8.15074e-02, 1.00446e-01, 1.23784e-01,
 1.52545e-01, 1.87989e-01, 2.31667e-01, 2.85495e-01, 3.51829e-01,
 4.33576e-01, 5.34317e-01, 6.58465e-01, 8.11459e-01, 1.00000e+00}
,
{8.28657e-10, 1.02355e-09, 1.26428e-09, 1.56162e-09, 1.92890e-09,
 2.38255e-09, 2.94291e-09, 3.63505e-09, 4.48997e-09, 5.54596e-09,
 6.85032e-09, 8.46144e-09, 1.04515e-08, 1.29096e-08, 1.59458e-08,
 1.96960e-08, 2.43283e-08, 3.00501e-08, 3.71176e-08, 4.58472e-08,
 5.66300e-08, 6.99488e-08, 8.64000e-08, 1.06720e-07, 1.31820e-07,
 1.62823e-07, 2.01117e-07, 2.48417e-07, 3.06842e-07, 3.79008e-07,
 4.68147e-07, 5.78251e-07, 7.14249e-07, 8.82233e-07, 1.08972e-06,
 1.34602e-06, 1.66259e-06, 2.05361e-06, 2.53660e-06, 3.13318e-06,
 3.87007e-06, 4.78026e-06, 5.90453e-06, 7.29322e-06, 9.00850e-06,
 1.11272e-05, 1.37442e-05, 1.69767e-05, 2.09694e-05, 2.59012e-05,
 3.19929e-05, 3.95173e-05, 4.88114e-05, 6.02913e-05, 7.44712e-05,
 9.19861e-05, 1.13620e-04, 1.40343e-04, 1.73350e-04, 2.14120e-04,
 2.64478e-04, 3.26681e-04, 4.03513e-04, 4.98415e-04, 6.15637e-04,
 7.60428e-04, 9.39273e-04, 1.16018e-03, 1.43304e-03, 1.77008e-03,
 2.18638e-03, 2.70060e-03, 3.33575e-03, 4.12028e-03, 5.08933e-03,
 6.28628e-03, 7.76475e-03, 9.59094e-03, 1.18466e-02, 1.46328e-02,
 1.80743e-02, 2.23252e-02, 2.75759e-02, 3.40614e-02, 4.20723e-02,
 5.19673e-02, 6.41894e-02, 7.92861e-02, 9.79333e-02, 1.20966e-01,
 1.49416e-01, 1.84557e-01, 2.27963e-01, 2.81578e-01, 3.47802e-01,
 4.29601e-01, 5.30639e-01, 6.55440e-01, 8.09592e-01, 1.00000e+00}
,
{6.59743e-10, 8.16786e-10, 1.01121e-09, 1.25192e-09, 1.54992e-09,
 1.91886e-09, 2.37562e-09, 2.94110e-09, 3.64119e-09, 4.50793e-09,
 5.58098e-09, 6.90946e-09, 8.55417e-09, 1.05904e-08, 1.31113e-08,
 1.62322e-08, 2.00961e-08, 2.48797e-08, 3.08020e-08, 3.81341e-08,
 4.72114e-08, 5.84494e-08, 7.23625e-08, 8.95875e-08, 1.10913e-07,
 1.37314e-07, 1.70000e-07, 2.10466e-07, 2.60565e-07, 3.22588e-07,
 3.99376e-07, 4.94443e-07, 6.12138e-07, 7.57850e-07, 9.38246e-07,
 1.16158e-06, 1.43808e-06, 1.78040e-06, 2.20420e-06, 2.72888e-06,
 3.37846e-06, 4.18265e-06, 5.17828e-06, 6.41090e-06, 7.93693e-06,
 9.82622e-06, 1.21652e-05, 1.50610e-05, 1.86461e-05, 2.30845e-05,
 2.85795e-05, 3.53824e-05, 4.38048e-05, 5.42319e-05, 6.71411e-05,
 8.31232e-05, 1.02910e-04, 1.27406e-04, 1.57733e-04, 1.95279e-04,
 2.41763e-04, 2.99312e-04, 3.70559e-04, 4.58766e-04, 5.67969e-04,
 7.03166e-04, 8.70546e-04, 1.07777e-03, 1.33432e-03, 1.65193e-03,
 2.04515e-03, 2.53198e-03, 3.13468e-03, 3.88085e-03, 4.80463e-03,
 5.94831e-03, 7.36423e-03, 9.11719e-03, 1.12874e-02, 1.39742e-02,
 1.73006e-02, 2.14188e-02, 2.65173e-02, 3.28294e-02, 4.06440e-02,
 5.03187e-02, 6.22965e-02, 7.71253e-02, 9.54840e-02, 1.18213e-01,
 1.46352e-01, 1.81189e-01, 2.24318e-01, 2.77714e-01, 3.43821e-01,
 4.25663e-01, 5.26986e-01, 6.52428e-01, 8.07730e-01, 1.00000e+00}
,
{5.25261e-10, 6.51791e-10, 8.08802e-10, 1.00363e-09, 1.24540e-09,
 1.54541e-09, 1.91768e-09, 2.37963e-09, 2.95286e-09, 3.66418e-09,
 4.54685e-09, 5.64215e-09, 7.00129e-09, 8.68783e-09, 1.07807e-08,
 1.33776e-08, 1.66002e-08, 2.05990e-08, 2.55611e-08, 3.17185e-08,
 3.93592e-08, 4.88405e-08, 6.06057e-08, 7.52051e-08, 9.33213e-08,
 1.15802e-07, 1.43697e-07, 1.78312e-07, 2.21266e-07, 2.74567e-07,
 3.40708e-07, 4.22782e-07, 5.24626e-07, 6.51003e-07, 8.07824e-07,
 1.00242e-06, 1.24390e-06, 1.54354e-06, 1.91536e-06, 2.37676e-06,
 2.94930e-06, 3.65975e-06, 4.54136e-06, 5.63533e-06, 6.99283e-06,
 8.67733e-06, 1.07676e-05, 1.33614e-05, 1.65801e-05, 2.05741e-05,
 2.55302e-05, 3.16802e-05, 3.93117e-05, 4.87815e-05, 6.05325e-05,
 7.51142e-05, 9.32085e-05, 1.15662e-04, 1.43523e-04, 1.78097e-04,
 2.20999e-04, 2.74235e-04, 3.40296e-04, 4.22271e-04, 5.23992e-04,
 6.50217e-04, 8.06848e-04, 1.00121e-03, 1.24239e-03, 1.54167e-03,
 1.91305e-03, 2.37388e-03, 2.94573e-03, 3.65533e-03, 4.53587e-03,
 5.62852e-03, 6.98437e-03, 8.66685e-03, 1.07546e-02, 1.33453e-02,
 1.65601e-02, 2.05492e-02, 2.54993e-02, 3.16419e-02, 3.92641e-02,
 4.87225e-02, 6.04593e-02, 7.50234e-02, 9.30959e-02, 1.15522e-01,
 1.43350e-01, 1.77882e-01, 2.20732e-01, 2.73904e-01, 3.39885e-01,
 4.21760e-01, 5.23358e-01, 6.49431e-01, 8.05873e-01, 1.00000e+00}
,
{4.18191e-10, 5.20126e-10, 6.46907e-10, 8.04592e-10, 1.00071e-09,
 1.24464e-09, 1.54802e-09, 1.92535e-09, 2.39466e-09, 2.97836e-09,
 3.70434e-09, 4.60728e-09, 5.73031e-09, 7.12708e-09, 8.86431e-09,
 1.10250e-08, 1.37124e-08, 1.70548e-08, 2.12119e-08, 2.63823e-08,
 3.28130e-08, 4.08113e-08, 5.07591e-08, 6.31317e-08, 7.85201e-08,
 9.76595e-08, 1.21464e-07, 1.51071e-07, 1.87895e-07, 2.33695e-07,
 2.90658e-07, 3.61506e-07, 4.49624e-07, 5.59221e-07, 6.95532e-07,
 8.65068e-07, 1.07593e-06, 1.33819e-06, 1.66437e-06, 2.07007e-06,
 2.57465e-06, 3.20223e-06, 3.98277e-06, 4.95358e-06, 6.16102e-06,
 7.66278e-06, 9.53059e-06, 1.18537e-05, 1.47430e-05, 1.83367e-05,
 2.28063e-05, 2.83653e-05, 3.52794e-05, 4.38788e-05, 5.45743e-05,
 6.78769e-05, 8.44220e-05, 1.05000e-04, 1.30594e-04, 1.62426e-04,
 2.02018e-04, 2.51260e-04, 3.12505e-04, 3.88679e-04, 4.83420e-04,
 6.01254e-04, 7.47811e-04, 9.30090e-04, 1.15680e-03, 1.43877e-03,
 1.78948e-03, 2.22566e-03, 2.76817e-03, 3.44292e-03, 4.28213e-03,
 5.32591e-03, 6.62411e-03, 8.23875e-03, 1.02470e-02, 1.27447e-02,
 1.58512e-02, 1.97149e-02, 2.45205e-02, 3.04974e-02, 3.79312e-02,
 4.71769e-02, 5.86764e-02, 7.29788e-02, 9.07675e-02, 1.12892e-01,
 1.40410e-01, 1.74635e-01, 2.17203e-01, 2.70146e-01, 3.35994e-01,
 4.17894e-01, 5.19756e-01, 6.46447e-01, 8.04019e-01, 1.00000e+00}
,
{3.32947e-10, 4.15058e-10, 5.17419e-10, 6.45024e-10, 8.04098e-10,
 1.00240e-09, 1.24962e-09, 1.55779e-09, 1.94197e-09, 2.42090e-09,
 3.01794e-09, 3.76222e-09, 4.69005e-09, 5.84671e-09, 7.28862e-09,
 9.08612e-09, 1.13269e-08, 1.41204e-08, 1.76027e-08, 2.19439e-08,
 2.73556e-08, 3.41020e-08, 4.25122e-08, 5.29965e-08, 6.60664e-08,
 8.23597e-08, 1.02671e-07, 1.27992e-07, 1.59557e-07, 1.98906e-07,
 2.47960e-07, 3.09112e-07, 3.85345e-07, 4.80378e-07, 5.98848e-07,
 7.46535e-07, 9.30645e-07, 1.16016e-06, 1.44628e-06, 1.80295e-06,
 2.24760e-06, 2.80190e-06, 3.49289e-06, 4.35431e-06, 5.42816e-06,
 6.76685e-06, 8.43568e-06, 1.05161e-05, 1.31095e-05, 1.63426e-05,
 2.03730e-05, 2.53973e-05, 3.16608e-05, 3.94689e-05, 4.92027e-05,
 6.13369e-05, 7.64638e-05, 9.53212e-05, 1.18829e-04, 1.48135e-04,
 1.84667e-04, 2.30210e-04, 2.86984e-04, 3.57759e-04, 4.45989e-04,
 5.55979e-04, 6.93093e-04, 8.64023e-04, 1.07711e-03, 1.34274e-03,
 1.67389e-03, 2.08670e-03, 2.60132e-03, 3.24285e-03, 4.04260e-03,
 5.03957e-03, 6.28243e-03, 7.83179e-03, 9.76326e-03, 1.21711e-02,
 1.51727e-02, 1.89145e-02, 2.35792e-02, 2.93943e-02, 3.66434e-02,
 4.56804e-02, 5.69460e-02, 7.09900e-02, 8.84974e-02, 1.10323e-01,
 1.37530e-01, 1.71448e-01, 2.13730e-01, 2.66439e-01, 3.32148e-01,
 4.14062e-01, 5.16178e-01, 6.43477e-01, 8.02170e-01, 1.00000e+00}
,
{2.65079e-10, 3.31214e-10, 4.13849e-10, 5.17101e-10, 6.46114e-10,
 8.07315e-10, 1.00873e-09, 1.26040e-09, 1.57487e-09, 1.96778e-09,
 2.45873e-09, 3.07216e-09, 3.83864e-09, 4.79636e-09, 5.99301e-09,
 7.48822e-09, 9.35647e-09, 1.16908e-08, 1.46076e-08, 1.82521e-08,
 2.28059e-08, 2.84958e-08, 3.56052e-08, 4.44885e-08, 5.55880e-08,
 6.94568e-08, 8.67857e-08, 1.08438e-07, 1.35493e-07, 1.69297e-07,
 2.11535e-07, 2.64311e-07, 3.30255e-07, 4.12651e-07, 5.15605e-07,
 6.44244e-07, 8.04978e-07, 1.00581e-06, 1.25676e-06, 1.57031e-06,
 1.96209e-06, 2.45161e-06, 3.06327e-06, 3.82753e-06, 4.78247e-06,
 5.97567e-06, 7.46655e-06, 9.32939e-06, 1.16570e-05, 1.45653e-05,
 1.81993e-05, 2.27399e-05, 2.84133e-05, 3.55022e-05, 4.43597e-05,
 5.54271e-05, 6.92557e-05, 8.65345e-05, 1.08124e-04, 1.35100e-04,
 1.68807e-04, 2.10923e-04, 2.63547e-04, 3.29299e-04, 4.11457e-04,
 5.14112e-04, 6.42379e-04, 8.02648e-04, 1.00290e-03, 1.25312e-03,
 1.56576e-03, 1.95641e-03, 2.44452e-03, 3.05441e-03, 3.81646e-03,
 4.76863e-03, 5.95837e-03, 7.44494e-03, 9.30239e-03, 1.16233e-02,
 1.45232e-02, 1.81466e-02, 2.26740e-02, 2.83310e-02, 3.53994e-02,
 4.42313e-02, 5.52667e-02, 6.90553e-02, 8.62841e-02, 1.07811e-01,
 1.34709e-01, 1.68318e-01, 2.10312e-01, 2.62784e-01, 3.28346e-01,
 4.10266e-01, 5.12624e-01, 6.40520e-01, 8.00325e-01, 1.00000e+00}
,
{2.11045e-10, 2.64307e-10, 3.31011e-10, 4.14549e-10, 5.19170e-10,
 6.50194e-10, 8.14285e-10, 1.01979e-09, 1.27715e-09, 1.59947e-09,
 2.00314e-09, 2.50867e-09, 3.14180e-09, 3.93470e-09, 4.92771e-09,
 6.17133e-09, 7.72880e-09, 9.67934e-09, 1.21221e-08, 1.51814e-08,
 1.90128e-08, 2.38111e-08, 2.98204e-08, 3.73463e-08, 4.67715e-08,
 5.85753e-08, 7.33581e-08, 9.18717e-08, 1.15058e-07, 1.44095e-07,
 1.80461e-07, 2.26004e-07, 2.83041e-07, 3.54473e-07, 4.43932e-07,
 5.55969e-07, 6.96280e-07, 8.72002e-07, 1.09207e-06, 1.36768e-06,
 1.71285e-06, 2.14512e-06, 2.68649e-06, 3.36449e-06, 4.21359e-06,
 5.27699e-06, 6.60876e-06, 8.27663e-06, 1.03654e-05, 1.29814e-05,
 1.62575e-05, 2.03605e-05, 2.54989e-05, 3.19341e-05, 3.99934e-05,
 5.00867e-05, 6.27272e-05, 7.85578e-05, 9.83836e-05, 1.23213e-04,
 1.54309e-04, 1.93252e-04, 2.42023e-04, 3.03103e-04, 3.79598e-04,
 4.75399e-04, 5.95376e-04, 7.45633e-04, 9.33811e-04, 1.16948e-03,
 1.46462e-03, 1.83425e-03, 2.29717e-03, 2.87691e-03, 3.60297e-03,
 4.51226e-03, 5.65103e-03, 7.07719e-03, 8.86328e-03, 1.11001e-02,
 1.39015e-02, 1.74099e-02, 2.18036e-02, 2.73063e-02, 3.41976e-02,
 4.28282e-02, 5.36369e-02, 6.71733e-02, 8.41261e-02, 1.05357e-01,
 1.31946e-01, 1.65246e-01, 2.06950e-01, 2.59178e-01, 3.24588e-01,
 4.06505e-01, 5.09095e-01, 6.37577e-01, 7.98484e-01, 1.00000e+00}
,
{1.68025e-10, 2.10915e-10, 2.64754e-10, 3.32335e-10, 4.17166e-10,
 5.23652e-10, 6.57319e-10, 8.25106e-10, 1.03572e-09, 1.30010e-09,
 1.63196e-09, 2.04854e-09, 2.57145e-09, 3.22784e-09, 4.05177e-09,
 5.08603e-09, 6.38428e-09, 8.01394e-09, 1.00596e-08, 1.26274e-08,
 1.58506e-08, 1.98967e-08, 2.49755e-08, 3.13507e-08, 3.93533e-08,
 4.93986e-08, 6.20081e-08, 7.78362e-08, 9.77047e-08, 1.22645e-07,
 1.53951e-07, 1.93248e-07, 2.42577e-07, 3.04497e-07, 3.82223e-07,
 4.79789e-07, 6.02260e-07, 7.55993e-07, 9.48967e-07, 1.19120e-06,
 1.49527e-06, 1.87695e-06, 2.35606e-06, 2.95746e-06, 3.71238e-06,
 4.66000e-06, 5.84951e-06, 7.34266e-06, 9.21695e-06, 1.15697e-05,
 1.45229e-05, 1.82300e-05, 2.28834e-05, 2.87247e-05, 3.60569e-05,
 4.52608e-05, 5.68140e-05, 7.13164e-05, 8.95206e-05, 1.12372e-04,
 1.41056e-04, 1.77061e-04, 2.22258e-04, 2.78991e-04, 3.50207e-04,
 4.39600e-04, 5.51813e-04, 6.92668e-04, 8.69478e-04, 1.09142e-03,
 1.37002e-03, 1.71973e-03, 2.15870e-03, 2.70973e-03, 3.40142e-03,
 4.26967e-03, 5.35954e-03, 6.72761e-03, 8.44490e-03, 1.06005e-02,
 1.33064e-02, 1.67030e-02, 2.09666e-02, 2.63186e-02, 3.30367e-02,
 4.14696e-02, 5.20551e-02, 6.53427e-02, 8.20220e-02, 1.02959e-01,
 1.29240e-01, 1.62230e-01, 2.03641e-01, 2.55622e-01, 3.20872e-01,
 4.02778e-01, 5.05591e-01, 6.34648e-01, 7.96648e-01, 1.00000e+00}
,
{1.33775e-10, 1.68309e-10, 2.11759e-10, 2.66425e-10, 3.35204e-10,
 4.21738e-10, 5.30611e-10, 6.67590e-10, 8.39931e-10, 1.05676e-09,
 1.32957e-09, 1.67280e-09, 2.10464e-09, 2.64796e-09, 3.33154e-09,
 4.19159e-09, 5.27366e-09, 6.63507e-09, 8.34794e-09, 1.05030e-08,
 1.32144e-08, 1.66257e-08, 2.09177e-08, 2.63177e-08, 3.31117e-08,
 4.16595e-08, 5.24141e-08, 6.59450e-08, 8.29689e-08, 1.04388e-07,
 1.31336e-07, 1.65240e-07, 2.07898e-07, 2.61567e-07, 3.29092e-07,
 4.14048e-07, 5.20936e-07, 6.55417e-07, 8.24615e-07, 1.03749e-06,
 1.30532e-06, 1.64230e-06, 2.06626e-06, 2.59968e-06, 3.27079e-06,
 4.11516e-06, 5.17750e-06, 6.51409e-06, 8.19572e-06, 1.03115e-05,
 1.29734e-05, 1.63225e-05, 2.05363e-05, 2.58378e-05, 3.25079e-05,
 4.08999e-05, 5.14583e-05, 6.47425e-05, 8.14560e-05, 1.02484e-04,
 1.28941e-04, 1.62227e-04, 2.04107e-04, 2.56798e-04, 3.23091e-04,
 4.06498e-04, 5.11436e-04, 6.43465e-04, 8.09578e-04, 1.01857e-03,
 1.28152e-03, 1.61235e-03, 2.02858e-03, 2.55227e-03, 3.21115e-03,
 4.04012e-03, 5.08309e-03, 6.39530e-03, 8.04627e-03, 1.01234e-02,
 1.27368e-02, 1.60249e-02, 2.01618e-02, 2.53666e-02, 3.19151e-02,
 4.01541e-02, 5.05200e-02, 6.35619e-02, 7.99706e-02, 1.00615e-01,
 1.26590e-01, 1.59269e-01, 2.00385e-01, 2.52115e-01, 3.17199e-01,
 3.99085e-01, 5.02110e-01, 6.31732e-01, 7.94816e-01, 1.00000e+00}
,
{1.06506e-10, 1.34310e-10, 1.69372e-10, 2.13587e-10, 2.69345e-10,
 3.39659e-10, 4.28328e-10, 5.40144e-10, 6.81151e-10, 8.58968e-10,
 1.08321e-09, 1.36598e-09, 1.72257e-09, 2.17226e-09, 2.73933e-09,
 3.45445e-09, 4.35624e-09, 5.49346e-09, 6.92755e-09, 8.73601e-09,
 1.10166e-08, 1.38925e-08, 1.75192e-08, 2.20926e-08, 2.78600e-08,
 3.51329e-08, 4.43045e-08, 5.58704e-08, 7.04556e-08, 8.88482e-08,
 1.12042e-07, 1.41292e-07, 1.78176e-07, 2.24690e-07, 2.83346e-07,
 3.57314e-07, 4.50593e-07, 5.68221e-07, 7.16558e-07, 9.03618e-07,
 1.13951e-06, 1.43698e-06, 1.81211e-06, 2.28517e-06, 2.88173e-06,
 3.63401e-06, 4.58268e-06, 5.77901e-06, 7.28764e-06, 9.19011e-06,
 1.15892e-05, 1.46146e-05, 1.84298e-05, 2.32410e-05, 2.93082e-05,
 3.69592e-05, 4.66075e-05, 5.87746e-05, 7.41179e-05, 9.34666e-05,
 1.17866e-04, 1.48636e-04, 1.87438e-04, 2.36369e-04, 2.98074e-04,
 3.75888e-04, 4.74014e-04, 5.97758e-04, 7.53805e-04, 9.50588e-04,
 1.19874e-03, 1.51168e-03, 1.90631e-03, 2.40396e-03, 3.03152e-03,
 3.82291e-03, 4.82089e-03, 6.07940e-03, 7.66646e-03, 9.66781e-03,
 1.21916e-02, 1.53743e-02, 1.93878e-02, 2.44491e-02, 3.08316e-02,
 3.88803e-02, 4.90302e-02, 6.18297e-02, 7.79705e-02, 9.83250e-02,
 1.23993e-01, 1.56362e-01, 1.97181e-01, 2.48656e-01, 3.13568e-01,
 3.95426e-01, 4.98654e-01, 6.28829e-01, 7.92988e-01, 1.00000e+00}
,
{8.47959e-11, 1.07179e-10, 1.35470e-10, 1.71228e-10, 2.16426e-10,
 2.73554e-10, 3.45761e-10, 4.37029e-10, 5.52387e-10, 6.98196e-10,
 8.82492e-10, 1.11544e-09, 1.40987e-09, 1.78202e-09, 2.25240e-09,
 2.84694e-09, 3.59842e-09, 4.54827e-09, 5.74883e-09, 7.26629e-09,
 9.18431e-09, 1.16086e-08, 1.46728e-08, 1.85459e-08, 2.34413e-08,
 2.96288e-08, 3.74497e-08, 4.73349e-08, 5.98295e-08, 7.56221e-08,
 9.55834e-08, 1.20814e-07, 1.52704e-07, 1.93012e-07, 2.43959e-07,
 3.08355e-07, 3.89748e-07, 4.92626e-07, 6.22660e-07, 7.87018e-07,
 9.94760e-07, 1.25734e-06, 1.58923e-06, 2.00872e-06, 2.53894e-06,
 3.20912e-06, 4.05620e-06, 5.12688e-06, 6.48018e-06, 8.19069e-06,
 1.03527e-05, 1.30854e-05, 1.65395e-05, 2.09052e-05, 2.64234e-05,
 3.33981e-05, 4.22139e-05, 5.33567e-05, 6.74408e-05, 8.52426e-05,
 1.07743e-04, 1.36183e-04, 1.72130e-04, 2.17566e-04, 2.74995e-04,
 3.47583e-04, 4.39331e-04, 5.55297e-04, 7.01873e-04, 8.87140e-04,
 1.12131e-03, 1.41729e-03, 1.79140e-03, 2.26426e-03, 2.86194e-03,
 3.61738e-03, 4.57222e-03, 5.77911e-03, 7.30457e-03, 9.23269e-03,
 1.16698e-02, 1.47501e-02, 1.86436e-02, 2.35647e-02, 2.97849e-02,
 3.76469e-02, 4.75843e-02, 6.01446e-02, 7.60205e-02, 9.60869e-02,
 1.21450e-01, 1.53508e-01, 1.94028e-01, 2.45244e-01, 3.09979e-01,
 3.91801e-01, 4.95221e-01, 6.25940e-01, 7.91164e-01, 1.00000e+00}
,
{6.75110e-11, 8.55280e-11, 1.08353e-10, 1.37270e-10, 1.73904e-10,
 2.20314e-10, 2.79111e-10, 3.53598e-10, 4.47964e-10, 5.67515e-10,
 7.18970e-10, 9.10845e-10, 1.15393e-09, 1.46188e-09, 1.85202e-09,
 2.34627e-09, 2.97243e-09, 3.76570e-09, 4.77067e-09, 6.04384e-09,
 7.65679e-09, 9.70019e-09, 1.22889e-08, 1.55685e-08, 1.97234e-08,
 2.49870e-08, 3.16554e-08, 4.01034e-08, 5.08060e-08, 6.43649e-08,
 8.15422e-08, 1.03304e-07, 1.30873e-07, 1.65800e-07, 2.10047e-07,
 2.66103e-07, 3.37120e-07, 4.27088e-07, 5.41067e-07, 6.85464e-07,
 8.68397e-07, 1.10015e-06, 1.39375e-06, 1.76571e-06, 2.23693e-06,
 2.83391e-06, 3.59021e-06, 4.54835e-06, 5.76218e-06, 7.29996e-06,
 9.24814e-06, 1.17162e-05, 1.48430e-05, 1.88042e-05, 2.38226e-05,
 3.01802e-05, 3.82345e-05, 4.84383e-05, 6.13653e-05, 7.77421e-05,
 9.84895e-05, 1.24774e-04, 1.58073e-04, 2.00258e-04, 2.53702e-04,
 3.21409e-04, 4.07185e-04, 5.15852e-04, 6.53520e-04, 8.27928e-04,
 1.04888e-03, 1.32880e-03, 1.68342e-03, 2.13269e-03, 2.70184e-03,
 3.42290e-03, 4.33638e-03, 5.49365e-03, 6.95977e-03, 8.81715e-03,
 1.11702e-02, 1.41513e-02, 1.79279e-02, 2.27124e-02, 2.87737e-02,
 3.64527e-02, 4.61810e-02, 5.85055e-02, 7.41192e-02, 9.38997e-02,
 1.18959e-01, 1.50706e-01, 1.90926e-01, 2.41879e-01, 3.06431e-01,
 3.88209e-01, 4.91812e-01, 6.23064e-01, 7.89344e-01, 1.00000e+00}
,
{5.37495e-11, 6.82509e-11, 8.66647e-11, 1.10046e-10, 1.39736e-10,
 1.77436e-10, 2.25308e-10, 2.86095e-10, 3.63282e-10, 4.61293e-10,
 5.85748e-10, 7.43780e-10, 9.44448e-10, 1.19925e-09, 1.52281e-09,
 1.93365e-09, 2.45534e-09, 3.11778e-09, 3.95894e-09, 5.02705e-09,
 6.38332e-09, 8.10551e-09, 1.02923e-08, 1.30692e-08, 1.65951e-08,
 2.10724e-08, 2.67577e-08, 3.39767e-08, 4.31435e-08, 5.47834e-08,
 6.95637e-08, 8.83316e-08, 1.12163e-07, 1.42424e-07, 1.80849e-07,
 2.29642e-07, 2.91598e-07, 3.70269e-07, 4.70166e-07, 5.97014e-07,
 7.58086e-07, 9.62613e-07, 1.22232e-06, 1.55210e-06, 1.97085e-06,
 2.50257e-06, 3.17775e-06, 4.03509e-06, 5.12374e-06, 6.50610e-06,
 8.26141e-06, 1.04903e-05, 1.33205e-05, 1.69143e-05, 2.14777e-05,
 2.72723e-05, 3.46303e-05, 4.39733e-05, 5.58371e-05, 7.09017e-05,
 9.00306e-05, 1.14320e-04, 1.45163e-04, 1.84328e-04, 2.34059e-04,
 2.97206e-04, 3.77391e-04, 4.79209e-04, 6.08497e-04, 7.72667e-04,
 9.81129e-04, 1.24583e-03, 1.58195e-03, 2.00875e-03, 2.55071e-03,
 3.23887e-03, 4.11270e-03, 5.22229e-03, 6.63124e-03, 8.42031e-03,
 1.06921e-02, 1.35767e-02, 1.72397e-02, 2.18908e-02, 2.77969e-02,
 3.52963e-02, 4.48191e-02, 5.69111e-02, 7.22654e-02, 9.17623e-02,
 1.16519e-01, 1.47956e-01, 1.87873e-01, 2.38560e-01, 3.02923e-01,
 3.84650e-01, 4.88427e-01, 6.20202e-01, 7.87529e-01, 1.00000e+00}
,
{4.27932e-11, 5.44639e-11, 6.93174e-11, 8.82217e-11, 1.12282e-10,
 1.42903e-10, 1.81876e-10, 2.31478e-10, 2.94607e-10, 3.74953e-10,
 4.77211e-10, 6.07357e-10, 7.72997e-10, 9.83811e-10, 1.25212e-09,
 1.59360e-09, 2.02821e-09, 2.58134e-09, 3.28533e-09, 4.18132e-09,
 5.32165e-09, 6.77299e-09, 8.62013e-09, 1.09710e-08, 1.39631e-08,
 1.77711e-08, 2.26177e-08, 2.87860e-08, 3.66366e-08, 4.66282e-08,
 5.93448e-08, 7.55294e-08, 9.61279e-08, 1.22344e-07, 1.55710e-07,
 1.98176e-07, 2.52223e-07, 3.21009e-07, 4.08556e-07, 5.19978e-07,
 6.61787e-07, 8.42271e-07, 1.07198e-06, 1.36433e-06, 1.73641e-06,
 2.20997e-06, 2.81268e-06, 3.57976e-06, 4.55603e-06, 5.79857e-06,
 7.37996e-06, 9.39264e-06, 1.19542e-05, 1.52144e-05, 1.93637e-05,
 2.46446e-05, 3.13658e-05, 3.99199e-05, 5.08069e-05, 6.46631e-05,
 8.22982e-05, 1.04743e-04, 1.33308e-04, 1.69664e-04, 2.15936e-04,
 2.74826e-04, 3.49777e-04, 4.45169e-04, 5.66577e-04, 7.21095e-04,
 9.17753e-04, 1.16804e-03, 1.48660e-03, 1.89202e-03, 2.40802e-03,
 3.06474e-03, 3.90056e-03, 4.96433e-03, 6.31822e-03, 8.04134e-03,
 1.02344e-02, 1.30255e-02, 1.65779e-02, 2.10990e-02, 2.68532e-02,
 3.41767e-02, 4.34974e-02, 5.53601e-02, 7.04580e-02, 8.96735e-02,
 1.14129e-01, 1.45255e-01, 1.84869e-01, 2.35287e-01, 2.99455e-01,
 3.81123e-01, 4.85064e-01, 6.17352e-01, 7.85717e-01, 1.00000e+00}
,
{3.40702e-11, 4.34619e-11, 5.54424e-11, 7.07254e-11, 9.02213e-11,
 1.15091e-10, 1.46817e-10, 1.87288e-10, 2.38915e-10, 3.04773e-10,
 3.88786e-10, 4.95957e-10, 6.32671e-10, 8.07070e-10, 1.02954e-09,
 1.31334e-09, 1.67538e-09, 2.13720e-09, 2.72634e-09, 3.47787e-09,
 4.43656e-09, 5.65953e-09, 7.21961e-09, 9.20974e-09, 1.17485e-08,
 1.49870e-08, 1.91182e-08, 2.43883e-08, 3.11111e-08, 3.96871e-08,
 5.06270e-08, 6.45827e-08, 8.23853e-08, 1.05095e-07, 1.34065e-07,
 1.71021e-07, 2.18164e-07, 2.78303e-07, 3.55019e-07, 4.52882e-07,
 5.77721e-07, 7.36974e-07, 9.40125e-07, 1.19928e-06, 1.52986e-06,
 1.95158e-06, 2.48954e-06, 3.17580e-06, 4.05123e-06, 5.16798e-06,
 6.59256e-06, 8.40984e-06, 1.07281e-05, 1.36853e-05, 1.74578e-05,
 2.22701e-05, 2.84090e-05, 3.62401e-05, 4.62299e-05, 5.89734e-05,
 7.52298e-05, 9.59674e-05, 1.22421e-04, 1.56168e-04, 1.99216e-04,
 2.54131e-04, 3.24184e-04, 4.13547e-04, 5.27544e-04, 6.72965e-04,
 8.58472e-04, 1.09511e-03, 1.39699e-03, 1.78208e-03, 2.27332e-03,
 2.89997e-03, 3.69937e-03, 4.71912e-03, 6.01997e-03, 7.67942e-03,
 9.79629e-03, 1.24967e-02, 1.59415e-02, 2.03359e-02, 2.59416e-02,
 3.30925e-02, 4.22147e-02, 5.38514e-02, 6.86959e-02, 8.76323e-02,
 1.11789e-01, 1.42604e-01, 1.81913e-01, 2.32059e-01, 2.96028e-01,
 3.77629e-01, 4.81725e-01, 6.14515e-01, 7.83910e-01, 1.00000e+00}
,
{2.71253e-11, 3.46823e-11, 4.43447e-11, 5.66990e-11, 7.24952e-11,
 9.26921e-11, 1.18516e-10, 1.51534e-10, 1.93751e-10, 2.47729e-10,
 3.16746e-10, 4.04990e-10, 5.17819e-10, 6.62082e-10, 8.46535e-10,
 1.08238e-09, 1.38392e-09, 1.76948e-09, 2.26245e-09, 2.89276e-09,
 3.69868e-09, 4.72912e-09, 6.04664e-09, 7.73121e-09, 9.88510e-09,
 1.26391e-08, 1.61603e-08, 2.06624e-08, 2.64189e-08, 3.37792e-08,
 4.31899e-08, 5.52225e-08, 7.06073e-08, 9.02783e-08, 1.15429e-07,
 1.47588e-07, 1.88705e-07, 2.41278e-07, 3.08497e-07, 3.94443e-07,
 5.04334e-07, 6.44840e-07, 8.24490e-07, 1.05419e-06, 1.34788e-06,
 1.72340e-06, 2.20353e-06, 2.81743e-06, 3.60236e-06, 4.60596e-06,
 5.88917e-06, 7.52988e-06, 9.62767e-06, 1.23099e-05, 1.57394e-05,
 2.01244e-05, 2.57309e-05, 3.28995e-05, 4.20652e-05, 5.37844e-05,
 6.87686e-05, 8.79273e-05, 1.12424e-04, 1.43744e-04, 1.83791e-04,
 2.34995e-04, 3.00463e-04, 3.84172e-04, 4.91200e-04, 6.28047e-04,
 8.03019e-04, 1.02674e-03, 1.31278e-03, 1.67852e-03, 2.14615e-03,
 2.74406e-03, 3.50855e-03, 4.48602e-03, 5.73581e-03, 7.33379e-03,
 9.37696e-03, 1.19893e-02, 1.53295e-02, 1.96003e-02, 2.50609e-02,
 3.20427e-02, 4.09698e-02, 5.23838e-02, 6.69777e-02, 8.56375e-02,
 1.09496e-01, 1.40001e-01, 1.79005e-01, 2.28875e-01, 2.92639e-01,
 3.74167e-01, 4.78409e-01, 6.11692e-01, 7.82107e-01, 1.00000e+00}
,
{2.15961e-11, 2.76763e-11, 3.54684e-11, 4.54544e-11, 5.82518e-11,
 7.46522e-11, 9.56701e-11, 1.22605e-10, 1.57124e-10, 2.01362e-10,
 2.58054e-10, 3.30708e-10, 4.23817e-10, 5.43140e-10, 6.96057e-10,
 8.92028e-10, 1.14317e-09, 1.46503e-09, 1.87750e-09, 2.40610e-09,
 3.08352e-09, 3.95167e-09, 5.06423e-09, 6.49004e-09, 8.31727e-09,
 1.06590e-08, 1.36599e-08, 1.75058e-08, 2.24344e-08, 2.87507e-08,
 3.68453e-08, 4.72189e-08, 6.05131e-08, 7.75503e-08, 9.93841e-08,
 1.27365e-07, 1.63224e-07, 2.09179e-07, 2.68072e-07, 3.43546e-07,
 4.40269e-07, 5.64224e-07, 7.23079e-07, 9.26657e-07, 1.18755e-06,
 1.52190e-06, 1.95038e-06, 2.49950e-06, 3.20322e-06, 4.10507e-06,
 5.26083e-06, 6.74199e-06, 8.64015e-06, 1.10727e-05, 1.41902e-05,
 1.81854e-05, 2.33054e-05, 2.98668e-05, 3.82757e-05, 4.90520e-05,
 6.28623e-05, 8.05608e-05, 1.03242e-04, 1.32309e-04, 1.69560e-04,
 2.17299e-04, 2.78478e-04, 3.56882e-04, 4.57361e-04, 5.86128e-04,
 7.51149e-04, 9.62630e-04, 1.23365e-03, 1.58098e-03, 2.02610e-03,
 2.59653e-03, 3.32757e-03, 4.26443e-03, 5.46506e-03, 7.00371e-03,
 8.97557e-03, 1.15026e-02, 1.47411e-02, 1.88913e-02, 2.42101e-02,
 3.10263e-02, 3.97616e-02, 5.09562e-02, 6.53026e-02, 8.36882e-02,
 1.07250e-01, 1.37446e-01, 1.76143e-01, 2.25735e-01, 2.89289e-01,
 3.70737e-01, 4.75116e-01, 6.08882e-01, 7.80309e-01, 1.00000e+00}
,
{1.71939e-11, 2.20856e-11, 2.83689e-11, 3.64398e-11, 4.68068e-11,
 6.01233e-11, 7.72283e-11, 9.91996e-11, 1.27422e-10, 1.63673e-10,
 2.10238e-10, 2.70050e-10, 3.46879e-10, 4.45565e-10, 5.72328e-10,
 7.35155e-10, 9.44305e-10, 1.21296e-09, 1.55804e-09, 2.00130e-09,
 2.57067e-09, 3.30202e-09, 4.24144e-09, 5.44813e-09, 6.99811e-09,
 8.98906e-09, 1.15464e-08, 1.48314e-08, 1.90509e-08, 2.44708e-08,
 3.14328e-08, 4.03753e-08, 5.18620e-08, 6.66167e-08, 8.55691e-08,
 1.09913e-07, 1.41184e-07, 1.81350e-07, 2.32944e-07, 2.99216e-07,
 3.84342e-07, 4.93687e-07, 6.34141e-07, 8.14553e-07, 1.04629e-06,
 1.34396e-06, 1.72631e-06, 2.21745e-06, 2.84831e-06, 3.65865e-06,
 4.69953e-06, 6.03654e-06, 7.75392e-06, 9.95990e-06, 1.27935e-05,
 1.64332e-05, 2.11084e-05, 2.71137e-05, 3.48275e-05, 4.47359e-05,
 5.74632e-05, 7.38114e-05, 9.48107e-05, 1.21784e-04, 1.56432e-04,
 2.00936e-04, 2.58102e-04, 3.31532e-04, 4.25852e-04, 5.47006e-04,
 7.02629e-04, 9.02526e-04, 1.15929e-03, 1.48911e-03, 1.91276e-03,
 2.45694e-03, 3.15593e-03, 4.05379e-03, 5.20708e-03, 6.68849e-03,
 8.59136e-03, 1.10356e-02, 1.41752e-02, 1.82080e-02, 2.33882e-02,
 3.00421e-02, 3.85890e-02, 4.95675e-02, 6.36694e-02, 8.17832e-02,
 1.05050e-01, 1.34937e-01, 1.73326e-01, 2.22638e-01, 2.85978e-01,
 3.67338e-01, 4.71845e-01, 6.06084e-01, 7.78514e-01, 1.00000e+00}
,
{1.36891e-11, 1.76242e-11, 2.26904e-11, 2.92130e-11, 3.76105e-11,
 4.84220e-11, 6.23414e-11, 8.02620e-11, 1.03334e-10, 1.33038e-10,
 1.71282e-10, 2.20518e-10, 2.83908e-10, 3.65520e-10, 4.70593e-10,
 6.05869e-10, 7.80032e-10, 1.00426e-09, 1.29294e-09, 1.66461e-09,
 2.14312e-09, 2.75918e-09, 3.55233e-09, 4.57349e-09, 5.88818e-09,
 7.58079e-09, 9.75996e-09, 1.25656e-08, 1.61776e-08, 2.08281e-08,
 2.68153e-08, 3.45236e-08, 4.44477e-08, 5.72247e-08, 7.36744e-08,
 9.48529e-08, 1.22119e-07, 1.57224e-07, 2.02419e-07, 2.60606e-07,
 3.35520e-07, 4.31968e-07, 5.56142e-07, 7.16010e-07, 9.21834e-07,
 1.18682e-06, 1.52799e-06, 1.96722e-06, 2.53272e-06, 3.26077e-06,
 4.19811e-06, 5.40490e-06, 6.95859e-06, 8.95891e-06, 1.15342e-05,
 1.48499e-05, 1.91186e-05, 2.46144e-05, 3.16900e-05, 4.07997e-05,
 5.25279e-05, 6.76276e-05, 8.70677e-05, 1.12096e-04, 1.44319e-04,
 1.85805e-04, 2.39217e-04, 3.07982e-04, 3.96514e-04, 5.10496e-04,
 6.57243e-04, 8.46174e-04, 1.08941e-03, 1.40258e-03, 1.80576e-03,
 2.32484e-03, 2.99314e-03, 3.85355e-03, 4.96129e-03, 6.38746e-03,
 8.22360e-03, 1.05875e-02, 1.36310e-02, 1.75494e-02, 2.25942e-02,
 2.90891e-02, 3.74510e-02, 4.82166e-02, 6.20770e-02, 7.99216e-02,
 1.02896e-01, 1.32474e-01, 1.70555e-01, 2.19583e-01, 2.82704e-01,
 3.63970e-01, 4.68597e-01, 6.03299e-01, 7.76723e-01, 1.00000e+00}
,
{1.08987e-11, 1.40640e-11, 1.81486e-11, 2.34194e-11, 3.02210e-11,
 3.89980e-11, 5.03241e-11, 6.49396e-11, 8.37999e-11, 1.08138e-10,
 1.39544e-10, 1.80071e-10, 2.32369e-10, 2.99855e-10, 3.86941e-10,
 4.99320e-10, 6.44336e-10, 8.31469e-10, 1.07295e-09, 1.38456e-09,
 1.78668e-09, 2.30558e-09, 2.97518e-09, 3.83926e-09, 4.95428e-09,
 6.39314e-09, 8.24989e-09, 1.06459e-08, 1.37377e-08, 1.77276e-08,
 2.28761e-08, 2.95200e-08, 3.80934e-08, 4.91568e-08, 6.34332e-08,
 8.18560e-08, 1.05629e-07, 1.36307e-07, 1.75894e-07, 2.26979e-07,
 2.92899e-07, 3.77965e-07, 4.87737e-07, 6.29389e-07, 8.12181e-07,
 1.04806e-06, 1.35245e-06, 1.74523e-06, 2.25210e-06, 2.90617e-06,
 3.75020e-06, 4.83936e-06, 6.24484e-06, 8.05851e-06, 1.03989e-05,
 1.34191e-05, 1.73163e-05, 2.23455e-05, 2.88352e-05, 3.72097e-05,
 4.80165e-05, 6.19617e-05, 7.99571e-05, 1.03179e-04, 1.33145e-04,
 1.71814e-04, 2.21713e-04, 2.86105e-04, 3.69198e-04, 4.76423e-04,
 6.14789e-04, 7.93340e-04, 1.02375e-03, 1.32107e-03, 1.70475e-03,
 2.19985e-03, 2.83875e-03, 3.66320e-03, 4.72710e-03, 6.09998e-03,
 7.87158e-03, 1.01577e-02, 1.31078e-02, 1.69146e-02, 2.18271e-02,
 2.81663e-02, 3.63466e-02, 4.69026e-02, 6.05244e-02, 7.81024e-02,
 1.00785e-01, 1.30056e-01, 1.67828e-01, 2.16570e-01, 2.79468e-01,
 3.60633e-01, 4.65371e-01, 6.00527e-01, 7.74937e-01, 1.00000e+00}
,
{8.67710e-12, 1.12230e-11, 1.45158e-11, 1.87748e-11, 2.42834e-11,
 3.14082e-11, 4.06234e-11, 5.25424e-11, 6.79585e-11, 8.78976e-11,
 1.13687e-10, 1.47043e-10, 1.90186e-10, 2.45987e-10, 3.18160e-10,
 4.11508e-10, 5.32246e-10, 6.88408e-10, 8.90388e-10, 1.15163e-09,
 1.48952e-09, 1.92655e-09, 2.49180e-09, 3.22290e-09, 4.16851e-09,
 5.39156e-09, 6.97346e-09, 9.01948e-09, 1.16658e-08, 1.50886e-08,
 1.95156e-08, 2.52416e-08, 3.26475e-08, 4.22263e-08, 5.46156e-08,
 7.06400e-08, 9.13659e-08, 1.18173e-07, 1.52845e-07, 1.97690e-07,
 2.55693e-07, 3.30713e-07, 4.27746e-07, 5.53247e-07, 7.15571e-07,
 9.25521e-07, 1.19707e-06, 1.54829e-06, 2.00257e-06, 2.59012e-06,
 3.35007e-06, 4.33299e-06, 5.60430e-06, 7.24861e-06, 9.37537e-06,
 1.21261e-05, 1.56840e-05, 2.02857e-05, 2.62375e-05, 3.39357e-05,
 4.38925e-05, 5.67706e-05, 7.34272e-05, 9.49710e-05, 1.22836e-04,
 1.58876e-04, 2.05490e-04, 2.65782e-04, 3.43763e-04, 4.44623e-04,
 5.75077e-04, 7.43806e-04, 9.62040e-04, 1.24430e-03, 1.60939e-03,
 2.08158e-03, 2.69233e-03, 3.48226e-03, 4.50396e-03, 5.82543e-03,
 7.53463e-03, 9.74530e-03, 1.26046e-02, 1.63028e-02, 2.10861e-02,
 2.72728e-02, 3.52747e-02, 4.56244e-02, 5.90107e-02, 7.63245e-02,
 9.87183e-02, 1.27682e-01, 1.65145e-01, 2.13599e-01, 2.76269e-01,
 3.57327e-01, 4.62167e-01, 5.97768e-01, 7.73155e-01, 1.00000e+00}
,
{6.90836e-12, 8.95588e-12, 1.16103e-11, 1.50514e-11, 1.95123e-11,
 2.52955e-11, 3.27926e-11, 4.25118e-11, 5.51117e-11, 7.14459e-11,
 9.26213e-11, 1.20073e-10, 1.55660e-10, 2.01795e-10, 2.61604e-10,
 3.39140e-10, 4.39655e-10, 5.69962e-10, 7.38889e-10, 9.57884e-10,
 1.24179e-09, 1.60983e-09, 2.08696e-09, 2.70550e-09, 3.50736e-09,
 4.54689e-09, 5.89452e-09, 7.64155e-09, 9.90639e-09, 1.28425e-08,
 1.66488e-08, 2.15832e-08, 2.79801e-08, 3.62730e-08, 4.70237e-08,
 6.09608e-08, 7.90285e-08, 1.02451e-07, 1.32816e-07, 1.72181e-07,
 2.23212e-07, 2.89369e-07, 3.75133e-07, 4.86317e-07, 6.30453e-07,
 8.17309e-07, 1.05955e-06, 1.37358e-06, 1.78068e-06, 2.30845e-06,
 2.99264e-06, 3.87961e-06, 5.02946e-06, 6.52011e-06, 8.45257e-06,
 1.09578e-05, 1.42055e-05, 1.84157e-05, 2.38739e-05, 3.09497e-05,
 4.01227e-05, 5.20144e-05, 6.74306e-05, 8.74160e-05, 1.13325e-04,
 1.46912e-04, 1.90455e-04, 2.46902e-04, 3.20080e-04, 4.14947e-04,
 5.37930e-04, 6.97364e-04, 9.04051e-04, 1.17200e-03, 1.51936e-03,
 1.96967e-03, 2.55345e-03, 3.31025e-03, 4.29136e-03, 5.56325e-03,
 7.21210e-03, 9.34965e-03, 1.21207e-02, 1.57131e-02, 2.03702e-02,
 2.64077e-02, 3.42345e-02, 4.43810e-02, 5.75348e-02, 7.45872e-02,
 9.66936e-02, 1.25352e-01, 1.62504e-01, 2.10668e-01, 2.73107e-01,
 3.54051e-01, 4.58986e-01, 5.95022e-01, 7.71377e-01, 1.00000e+00}
,
{5.50015e-12, 7.14675e-12, 9.28628e-12, 1.20663e-11, 1.56787e-11,
 2.03724e-11, 2.64714e-11, 3.43962e-11, 4.46934e-11, 5.80734e-11,
 7.54589e-11, 9.80493e-11, 1.27402e-10, 1.65543e-10, 2.15102e-10,
 2.79498e-10, 3.63172e-10, 4.71895e-10, 6.13168e-10, 7.96733e-10,
 1.03525e-09, 1.34518e-09, 1.74789e-09, 2.27116e-09, 2.95108e-09,
 3.83455e-09, 4.98251e-09, 6.47413e-09, 8.41231e-09, 1.09307e-08,
 1.42031e-08, 1.84551e-08, 2.39800e-08, 3.11590e-08, 4.04871e-08,
 5.26078e-08, 6.83572e-08, 8.88214e-08, 1.15412e-07, 1.49963e-07,
 1.94858e-07, 2.53193e-07, 3.28992e-07, 4.27483e-07, 5.55460e-07,
 7.21749e-07, 9.37821e-07, 1.21858e-06, 1.58339e-06, 2.05741e-06,
 2.67334e-06, 3.47366e-06, 4.51358e-06, 5.86482e-06, 7.62059e-06,
 9.90198e-06, 1.28664e-05, 1.67182e-05, 2.17232e-05, 2.82265e-05,
 3.66767e-05, 4.76567e-05, 6.19238e-05, 8.04620e-05, 1.04550e-04,
 1.35849e-04, 1.76519e-04, 2.29364e-04, 2.98029e-04, 3.87251e-04,
 5.03183e-04, 6.53822e-04, 8.49558e-04, 1.10389e-03, 1.43437e-03,
 1.86378e-03, 2.42174e-03, 3.14674e-03, 4.08879e-03, 5.31286e-03,
 6.90338e-03, 8.97006e-03, 1.16554e-02, 1.51448e-02, 1.96787e-02,
 2.55699e-02, 3.32249e-02, 4.31715e-02, 5.60958e-02, 7.28894e-02,
 9.47104e-02, 1.23064e-01, 1.59906e-01, 2.07777e-01, 2.69980e-01,
 3.50805e-01, 4.55826e-01, 5.92288e-01, 7.69602e-01, 1.00000e+00}
,
{4.37900e-12, 5.70307e-12, 7.42749e-12, 9.67332e-12, 1.25982e-11,
 1.64075e-11, 2.13686e-11, 2.78298e-11, 3.62446e-11, 4.72038e-11,
 6.14767e-11, 8.00653e-11, 1.04274e-10, 1.35804e-10, 1.76866e-10,
 2.30345e-10, 2.99994e-10, 3.90702e-10, 5.08838e-10, 6.62694e-10,
 8.63071e-10, 1.12404e-09, 1.46391e-09, 1.90655e-09, 2.48302e-09,
 3.23381e-09, 4.21161e-09, 5.48506e-09, 7.14357e-09, 9.30355e-09,
 1.21166e-08, 1.57803e-08, 2.05518e-08, 2.67660e-08, 3.48592e-08,
 4.53994e-08, 5.91267e-08, 7.70048e-08, 1.00289e-07, 1.30613e-07,
 1.70105e-07, 2.21540e-07, 2.88526e-07, 3.75767e-07, 4.89387e-07,
 6.37362e-07, 8.30080e-07, 1.08107e-06, 1.40795e-06, 1.83367e-06,
 2.38811e-06, 3.11020e-06, 4.05062e-06, 5.27539e-06, 6.87050e-06,
 8.94792e-06, 1.16535e-05, 1.51771e-05, 1.97662e-05, 2.57428e-05,
 3.35266e-05, 4.36640e-05, 5.68666e-05, 7.40612e-05, 9.64549e-05,
 1.25620e-04, 1.63603e-04, 2.13071e-04, 2.77497e-04, 3.61404e-04,
 4.70680e-04, 6.12999e-04, 7.98350e-04, 1.03974e-03, 1.35413e-03,
 1.76357e-03, 2.29682e-03, 2.99131e-03, 3.89578e-03, 5.07374e-03,
 6.60788e-03, 8.60588e-03, 1.12080e-02, 1.45970e-02, 1.90106e-02,
 2.47588e-02, 3.22451e-02, 4.19949e-02, 5.46928e-02, 7.12302e-02,
 9.27679e-02, 1.20818e-01, 1.57349e-01, 2.04927e-01, 2.66890e-01,
 3.47589e-01, 4.52688e-01, 5.89567e-01, 7.67832e-01, 1.00000e+00}
,
{3.48638e-12, 4.55102e-12, 5.94076e-12, 7.75489e-12, 1.01230e-11,
 1.32143e-11, 1.72495e-11, 2.25170e-11, 2.93930e-11, 3.83687e-11,
 5.00853e-11, 6.53799e-11, 8.53450e-11, 1.11407e-10, 1.45427e-10,
 1.89836e-10, 2.47806e-10, 3.23479e-10, 4.22259e-10, 5.51205e-10,
 7.19526e-10, 9.39248e-10, 1.22607e-09, 1.60047e-09, 2.08920e-09,
 2.72718e-09, 3.55998e-09, 4.64710e-09, 6.06618e-09, 7.91861e-09,
 1.03367e-08, 1.34932e-08, 1.76137e-08, 2.29923e-08, 3.00135e-08,
 3.91787e-08, 5.11427e-08, 6.67602e-08, 8.71467e-08, 1.13759e-07,
 1.48497e-07, 1.93844e-07, 2.53038e-07, 3.30308e-07, 4.31174e-07,
 5.62842e-07, 7.34717e-07, 9.59077e-07, 1.25195e-06, 1.63426e-06,
 2.13331e-06, 2.78476e-06, 3.63514e-06, 4.74520e-06, 6.19425e-06,
 8.08578e-06, 1.05549e-05, 1.37781e-05, 1.79855e-05, 2.34778e-05,
 3.06471e-05, 4.00059e-05, 5.22225e-05, 6.81696e-05, 8.89866e-05,
 1.16160e-04, 1.51632e-04, 1.97936e-04, 2.58380e-04, 3.37281e-04,
 4.40277e-04, 5.74724e-04, 7.50228e-04, 9.79325e-04, 1.27838e-03,
 1.66876e-03, 2.17835e-03, 2.84355e-03, 3.71189e-03, 4.84538e-03,
 6.32502e-03, 8.25649e-03, 1.07778e-02, 1.40690e-02, 1.83652e-02,
 2.39734e-02, 3.12942e-02, 4.08505e-02, 5.33250e-02, 6.96088e-02,
 9.08652e-02, 1.18613e-01, 1.54833e-01, 2.02115e-01, 2.63835e-01,
 3.44402e-01, 4.49572e-01, 5.86858e-01, 7.66066e-01, 1.00000e+00}
,
{2.77571e-12, 3.63169e-12, 4.75162e-12, 6.21692e-12, 8.13409e-12,
 1.06425e-11, 1.39244e-11, 1.82184e-11, 2.38366e-11, 3.11873e-11,
 4.08047e-11, 5.33881e-11, 6.98518e-11, 9.13927e-11, 1.19576e-10,
 1.56451e-10, 2.04697e-10, 2.67822e-10, 3.50412e-10, 4.58472e-10,
 5.99855e-10, 7.84838e-10, 1.02687e-09, 1.34353e-09, 1.75785e-09,
 2.29993e-09, 3.00918e-09, 3.93715e-09, 5.15128e-09, 6.73983e-09,
 8.81825e-09, 1.15376e-08, 1.50956e-08, 1.97507e-08, 2.58414e-08,
 3.38104e-08, 4.42368e-08, 5.78785e-08, 7.57271e-08, 9.90797e-08,
 1.29634e-07, 1.69610e-07, 2.21914e-07, 2.90348e-07, 3.79885e-07,
 4.97034e-07, 6.50309e-07, 8.50851e-07, 1.11324e-06, 1.45653e-06,
 1.90570e-06, 2.49338e-06, 3.26228e-06, 4.26830e-06, 5.58455e-06,
 7.30671e-06, 9.55995e-06, 1.25080e-05, 1.63653e-05, 2.14120e-05,
 2.80150e-05, 3.66542e-05, 4.79576e-05, 6.27467e-05, 8.20965e-05,
 1.07413e-04, 1.40537e-04, 1.83876e-04, 2.40580e-04, 3.14769e-04,
 4.11838e-04, 5.38840e-04, 7.05007e-04, 9.22416e-04, 1.20687e-03,
 1.57904e-03, 2.06599e-03, 2.70309e-03, 3.53667e-03, 4.62731e-03,
 6.05427e-03, 7.92128e-03, 1.03640e-02, 1.35601e-02, 1.77417e-02,
 2.32129e-02, 3.03713e-02, 3.97372e-02, 5.19913e-02, 6.80243e-02,
 8.90016e-02, 1.16448e-01, 1.52358e-01, 1.99342e-01, 2.60815e-01,
 3.41244e-01, 4.46477e-01, 5.84161e-01, 7.64304e-01, 1.00000e+00}
,
{2.20991e-12, 2.89807e-12, 3.80051e-12, 4.98397e-12, 6.53596e-12,
 8.57122e-12, 1.12403e-11, 1.47404e-11, 1.93305e-11, 2.53500e-11,
 3.32438e-11, 4.35958e-11, 5.71713e-11, 7.49741e-11, 9.83207e-11,
 1.28937e-10, 1.69088e-10, 2.21741e-10, 2.90790e-10, 3.81341e-10,
 5.00088e-10, 6.55813e-10, 8.60030e-10, 1.12784e-09, 1.47904e-09,
 1.93961e-09, 2.54360e-09, 3.33566e-09, 4.37437e-09, 5.73652e-09,
 7.52285e-09, 9.86543e-09, 1.29375e-08, 1.69661e-08, 2.22493e-08,
 2.91777e-08, 3.82634e-08, 5.01785e-08, 6.58038e-08, 8.62948e-08,
 1.13167e-07, 1.48406e-07, 1.94619e-07, 2.55223e-07, 3.34698e-07,
 4.38921e-07, 5.75599e-07, 7.54837e-07, 9.89890e-07, 1.29814e-06,
 1.70237e-06, 2.23248e-06, 2.92767e-06, 3.83933e-06, 5.03487e-06,
 6.60271e-06, 8.65876e-06, 1.13551e-05, 1.48910e-05, 1.95279e-05,
 2.56089e-05, 3.35833e-05, 4.40410e-05, 5.77552e-05, 7.57398e-05,
 9.93249e-05, 1.30254e-04, 1.70815e-04, 2.24006e-04, 2.93760e-04,
 3.85235e-04, 5.05196e-04, 6.62511e-04, 8.68814e-04, 1.13936e-03,
 1.49415e-03, 1.95942e-03, 2.56957e-03, 3.36973e-03, 4.41904e-03,
 5.79511e-03, 7.59968e-03, 9.96619e-03, 1.30696e-02, 1.71394e-02,
 2.24766e-02, 2.94756e-02, 3.86542e-02, 5.06910e-02, 6.64759e-02,
 8.71762e-02, 1.14322e-01, 1.49922e-01, 1.96607e-01, 2.57829e-01,
 3.38116e-01, 4.43404e-01, 5.81477e-01, 7.62547e-01, 1.00000e+00}
,
{1.75944e-12, 2.31264e-12, 3.03978e-12, 3.99554e-12, 5.25181e-12,
 6.90308e-12, 9.07353e-12, 1.19264e-11, 1.56763e-11, 2.06052e-11,
 2.70839e-11, 3.55995e-11, 4.67927e-11, 6.15051e-11, 8.08435e-11,
 1.06262e-10, 1.39673e-10, 1.83589e-10, 2.41312e-10, 3.17185e-10,
 4.16914e-10, 5.48000e-10, 7.20301e-10, 9.46776e-10, 1.24446e-09,
 1.63574e-09, 2.15005e-09, 2.82606e-09, 3.71463e-09, 4.88257e-09,
 6.41774e-09, 8.43560e-09, 1.10879e-08, 1.45741e-08, 1.91565e-08,
 2.51797e-08, 3.30966e-08, 4.35028e-08, 5.71809e-08, 7.51596e-08,
 9.87912e-08, 1.29853e-07, 1.70681e-07, 2.24346e-07, 2.94885e-07,
 3.87602e-07, 5.09471e-07, 6.69659e-07, 8.80211e-07, 1.15697e-06,
 1.52074e-06, 1.99888e-06, 2.62737e-06, 3.45346e-06, 4.53930e-06,
 5.96653e-06, 7.84252e-06, 1.03084e-05, 1.35495e-05, 1.78097e-05,
 2.34094e-05, 3.07697e-05, 4.04443e-05, 5.31607e-05, 6.98754e-05,
 9.18455e-05, 1.20723e-04, 1.58681e-04, 2.08573e-04, 2.74153e-04,
 3.60351e-04, 4.73652e-04, 6.22577e-04, 8.18327e-04, 1.07562e-03,
 1.41382e-03, 1.85835e-03, 2.44265e-03, 3.21066e-03, 4.22015e-03,
 5.54705e-03, 7.29114e-03, 9.58361e-03, 1.25969e-02, 1.65576e-02,
 2.17636e-02, 2.86064e-02, 3.76008e-02, 4.94232e-02, 6.49627e-02,
 8.53882e-02, 1.12236e-01, 1.47525e-01, 1.93909e-01, 2.54878e-01,
 3.35016e-01, 4.40351e-01, 5.78806e-01, 7.60793e-01, 1.00000e+00}
,
{1.40080e-12, 1.84548e-12, 2.43132e-12, 3.20314e-12, 4.21997e-12,
 5.55959e-12, 7.32447e-12, 9.64961e-12, 1.27129e-11, 1.67485e-11,
 2.20653e-11, 2.90700e-11, 3.82982e-11, 5.04558e-11, 6.64730e-11,
 8.75747e-11, 1.15375e-10, 1.52001e-10, 2.00253e-10, 2.63823e-10,
 3.47573e-10, 4.57910e-10, 6.03273e-10, 7.94781e-10, 1.04708e-09,
 1.37948e-09, 1.81739e-09, 2.39432e-09, 3.15439e-09, 4.15574e-09,
 5.47498e-09, 7.21300e-09, 9.50276e-09, 1.25194e-08, 1.64937e-08,
 2.17295e-08, 2.86275e-08, 3.77153e-08, 4.96880e-08, 6.54613e-08,
 8.62419e-08, 1.13619e-07, 1.49687e-07, 1.97206e-07, 2.59808e-07,
 3.42284e-07, 4.50941e-07, 5.94092e-07, 7.82685e-07, 1.03115e-06,
 1.35848e-06, 1.78973e-06, 2.35788e-06, 3.10638e-06, 4.09250e-06,
 5.39166e-06, 7.10323e-06, 9.35814e-06, 1.23289e-05, 1.62426e-05,
 2.13988e-05, 2.81919e-05, 3.71413e-05, 4.89318e-05, 6.44651e-05,
 8.49294e-05, 1.11890e-04, 1.47409e-04, 1.94204e-04, 2.55854e-04,
 3.37075e-04, 4.44078e-04, 5.85050e-04, 7.70773e-04, 1.01545e-03,
 1.33781e-03, 1.76249e-03, 2.32199e-03, 3.05911e-03, 4.03022e-03,
 5.30960e-03, 6.99512e-03, 9.21571e-03, 1.21412e-02, 1.59954e-02,
 2.10732e-02, 2.77628e-02, 3.65761e-02, 4.81871e-02, 6.34840e-02,
 8.36369e-02, 1.10187e-01, 1.45166e-01, 1.91249e-01, 2.51960e-01,
 3.31945e-01, 4.37320e-01, 5.76146e-01, 7.59043e-01, 1.00000e+00}
,
{1.11526e-12, 1.47268e-12, 1.94465e-12, 2.56789e-12, 3.39085e-12,
 4.47757e-12, 5.91257e-12, 7.80746e-12, 1.03096e-11, 1.36137e-11,
 1.79767e-11, 2.37380e-11, 3.13457e-11, 4.13915e-11, 5.46569e-11,
 7.21736e-11, 9.53042e-11, 1.25848e-10, 1.66180e-10, 2.19439e-10,
 2.89765e-10, 3.82631e-10, 5.05259e-10, 6.67187e-10, 8.81010e-10,
 1.16336e-09, 1.53620e-09, 2.02853e-09, 2.67865e-09, 3.53711e-09,
 4.67071e-09, 6.16760e-09, 8.14422e-09, 1.07543e-08, 1.42009e-08,
 1.87521e-08, 2.47619e-08, 3.26977e-08, 4.31769e-08, 5.70144e-08,
 7.52867e-08, 9.94150e-08, 1.31276e-07, 1.73348e-07, 2.28904e-07,
 3.02264e-07, 3.99135e-07, 5.27052e-07, 6.95964e-07, 9.19011e-07,
 1.21354e-06, 1.60246e-06, 2.11603e-06, 2.79418e-06, 3.68968e-06,
 4.87217e-06, 6.43362e-06, 8.49551e-06, 1.12182e-05, 1.48135e-05,
 1.95610e-05, 2.58300e-05, 3.41081e-05, 4.50392e-05, 5.94736e-05,
 7.85341e-05, 1.03703e-04, 1.36938e-04, 1.80825e-04, 2.38777e-04,
 3.15301e-04, 4.16351e-04, 5.49785e-04, 7.25983e-04, 9.58651e-04,
 1.26588e-03, 1.67158e-03, 2.20730e-03, 2.91471e-03, 3.84883e-03,
 5.08232e-03, 6.71113e-03, 8.86194e-03, 1.17021e-02, 1.54524e-02,
 2.04047e-02, 2.69441e-02, 3.55793e-02, 4.69819e-02, 6.20389e-02,
 8.19215e-02, 1.08176e-01, 1.42845e-01, 1.88625e-01, 2.49076e-01,
 3.28901e-01, 4.34309e-01, 5.73499e-01, 7.57297e-01, 1.00000e+00}
,
{8.87922e-13, 1.17519e-12, 1.55540e-12, 2.05862e-12, 2.72464e-12,
 3.60614e-12, 4.77283e-12, 6.31699e-12, 8.36072e-12, 1.10657e-11,
 1.46457e-11, 1.93840e-11, 2.56553e-11, 3.39556e-11, 4.49412e-11,
 5.94811e-11, 7.87249e-11, 1.04195e-10, 1.37905e-10, 1.82521e-10,
 2.41572e-10, 3.19728e-10, 4.23169e-10, 5.60076e-10, 7.41278e-10,
 9.81103e-10, 1.29852e-09, 1.71863e-09, 2.27465e-09, 3.01057e-09,
 3.98458e-09, 5.27371e-09, 6.97991e-09, 9.23811e-09, 1.22269e-08,
 1.61827e-08, 2.14182e-08, 2.83477e-08, 3.75190e-08, 4.96575e-08,
 6.57231e-08, 8.69865e-08, 1.15129e-07, 1.52377e-07, 2.01675e-07,
 2.66923e-07, 3.53281e-07, 4.67577e-07, 6.18852e-07, 8.19069e-07,
 1.08406e-06, 1.43479e-06, 1.89898e-06, 2.51336e-06, 3.32651e-06,
 4.40273e-06, 5.82714e-06, 7.71240e-06, 1.02076e-05, 1.35100e-05,
 1.78809e-05, 2.36659e-05, 3.13226e-05, 4.14563e-05, 5.48687e-05,
 7.26203e-05, 9.61151e-05, 1.27211e-04, 1.68368e-04, 2.22840e-04,
 2.94935e-04, 3.90355e-04, 5.16646e-04, 6.83796e-04, 9.05024e-04,
 1.19783e-03, 1.58536e-03, 2.09827e-03, 2.77712e-03, 3.67560e-03,
 4.86476e-03, 6.43866e-03, 8.52175e-03, 1.12788e-02, 1.49278e-02,
 1.97574e-02, 2.61495e-02, 3.46096e-02, 4.58069e-02, 6.06267e-02,
 8.02413e-02, 1.06202e-01, 1.40561e-01, 1.86037e-01, 2.46225e-01,
 3.25886e-01, 4.31320e-01, 5.70864e-01, 7.55556e-01, 1.00000e+00}
 ,
{7.06927e-13, 9.37796e-13, 1.24406e-12, 1.65035e-12, 2.18932e-12,
 2.90431e-12, 3.85280e-12, 5.11105e-12, 6.78022e-12, 8.99450e-12,
 1.19319e-11, 1.58287e-11, 2.09980e-11, 2.78555e-11, 3.69526e-11,
 4.90206e-11, 6.50298e-11, 8.62672e-11, 1.14440e-10, 1.51814e-10,
 2.01394e-10, 2.67165e-10, 3.54416e-10, 4.70162e-10, 6.23707e-10,
 8.27398e-10, 1.09761e-09, 1.45607e-09, 1.93159e-09, 2.56241e-09,
 3.39924e-09, 4.50937e-09, 5.98204e-09, 7.93566e-09, 1.05273e-08,
 1.39653e-08, 1.85261e-08, 2.45764e-08, 3.26025e-08, 4.32499e-08,
 5.73744e-08, 7.61118e-08, 1.00968e-07, 1.33943e-07, 1.77686e-07,
 2.35714e-07, 3.12694e-07, 4.14814e-07, 5.50284e-07, 7.29996e-07,
 9.68399e-07, 1.28466e-06, 1.70420e-06, 2.26076e-06, 2.99908e-06,
 3.97853e-06, 5.27783e-06, 7.00147e-06, 9.28802e-06, 1.23213e-05,
 1.63452e-05, 2.16832e-05, 2.87645e-05, 3.81585e-05, 5.06203e-05,
 6.71519e-05, 8.90823e-05, 1.18175e-04, 1.56768e-04, 2.07966e-04,
 2.75884e-04, 3.65982e-04, 4.85504e-04, 6.44061e-04, 8.54398e-04,
 1.13343e-03, 1.50358e-03, 1.99462e-03, 2.64603e-03, 3.51017e-03,
 4.65652e-03, 6.17725e-03, 8.19462e-03, 1.08708e-02, 1.44210e-02,
 1.91307e-02, 2.53783e-02, 3.36664e-02, 4.46612e-02, 5.92467e-02,
 7.85955e-02, 1.04263e-01, 1.38314e-01, 1.83484e-01, 2.43406e-01,
 3.22898e-01, 4.28350e-01, 5.68241e-01, 7.53818e-01, 1.00000e+00}
};

const std::vector< std::vector<double> > PROPOSAL::sigma_nubar_p = {
{5.61824e-07, 4.85030e-06, 1.81049e-05, 5.54042e-05, 1.36737e-04,
 2.83401e-04, 5.16502e-04, 8.54930e-04, 1.31452e-03, 1.90606e-03,
 2.63730e-03, 3.51002e-03, 4.52070e-03, 5.66286e-03, 6.92811e-03,
 8.30534e-03, 9.78045e-03, 1.13387e-02, 1.29654e-02, 1.46458e-02,
 1.63651e-02, 1.81094e-02, 1.98653e-02, 2.16206e-02, 2.33642e-02,
 2.50861e-02, 2.67772e-02, 2.84296e-02, 3.00363e-02, 3.15916e-02,
 3.30911e-02, 3.45302e-02, 3.59057e-02, 3.72152e-02, 3.84577e-02,
 3.96313e-02, 4.07345e-02, 4.17662e-02, 4.27256e-02, 4.36131e-02,
 4.44286e-02, 4.51722e-02, 4.58436e-02, 4.64431e-02, 4.69713e-02,
 4.74289e-02, 4.78167e-02, 4.81349e-02, 4.83843e-02, 4.85658e-02,
 4.86803e-02, 4.87289e-02, 4.87125e-02, 4.86323e-02, 4.84892e-02,
 4.82847e-02, 4.80199e-02, 4.76964e-02, 4.73159e-02, 4.68797e-02,
 4.63896e-02, 4.58476e-02, 4.52553e-02, 4.46146e-02, 4.39272e-02,
 4.31951e-02, 4.24199e-02, 4.16039e-02, 4.07488e-02, 3.98566e-02,
 3.89294e-02, 3.79694e-02, 3.69786e-02, 3.59595e-02, 3.49145e-02,
 3.38461e-02, 3.27572e-02, 3.16506e-02, 3.05294e-02, 2.93970e-02,
 2.82568e-02, 2.71125e-02, 2.59682e-02, 2.48282e-02, 2.36970e-02,
 2.25795e-02, 2.14808e-02, 2.04067e-02, 1.93629e-02, 1.83559e-02,
 1.73923e-02, 1.64795e-02, 1.56252e-02, 1.48375e-02, 1.41252e-02,
 1.34978e-02, 1.29653e-02, 1.25382e-02, 1.22281e-02, 1.20469e-02}
,
{9.23630e-07, 7.54140e-06, 2.99776e-05, 9.41643e-05, 2.32464e-04,
 4.78866e-04, 8.66175e-04, 1.42262e-03, 2.16948e-03, 3.12111e-03,
 4.28461e-03, 5.65632e-03, 7.22742e-03, 8.98544e-03, 1.09134e-02,
 1.29893e-02, 1.51904e-02, 1.74938e-02, 1.98763e-02, 2.23152e-02,
 2.47890e-02, 2.72776e-02, 2.97628e-02, 3.22281e-02, 3.46588e-02,
 3.70418e-02, 3.93659e-02, 4.16220e-02, 4.38030e-02, 4.59015e-02,
 4.79125e-02, 4.98331e-02, 5.16613e-02, 5.33938e-02, 5.50282e-02,
 5.65634e-02, 5.79988e-02, 5.93346e-02, 6.05708e-02, 6.17067e-02,
 6.27424e-02, 6.36788e-02, 6.45167e-02, 6.52573e-02, 6.59004e-02,
 6.64474e-02, 6.68992e-02, 6.72571e-02, 6.75224e-02, 6.76965e-02,
 6.77806e-02, 6.77761e-02, 6.76847e-02, 6.75084e-02, 6.72491e-02,
 6.69087e-02, 6.64896e-02, 6.59939e-02, 6.54239e-02, 6.47819e-02,
 6.40699e-02, 6.32900e-02, 6.24446e-02, 6.15357e-02, 6.05654e-02,
 5.95358e-02, 5.84490e-02, 5.73072e-02, 5.61127e-02, 5.48678e-02,
 5.35748e-02, 5.22366e-02, 5.08558e-02, 4.94353e-02, 4.79782e-02,
 4.64878e-02, 4.49678e-02, 4.34219e-02, 4.18543e-02, 4.02693e-02,
 3.86717e-02, 3.70666e-02, 3.54594e-02, 3.38561e-02, 3.22630e-02,
 3.06867e-02, 2.91347e-02, 2.76148e-02, 2.61353e-02, 2.47054e-02,
 2.33347e-02, 2.20336e-02, 2.08133e-02, 1.96858e-02, 1.86639e-02,
 1.77613e-02, 1.69929e-02, 1.63745e-02, 1.59232e-02, 1.56573e-02}
,
{1.47650e-06, 1.17430e-05, 4.93622e-05, 1.57243e-04, 3.86781e-04,
 7.91609e-04, 1.42062e-03, 2.31412e-03, 3.50008e-03, 4.99529e-03,
 6.80113e-03, 8.90547e-03, 1.12914e-02, 1.39341e-02, 1.68004e-02,
 1.98555e-02, 2.30640e-02, 2.63902e-02, 2.97997e-02, 3.32595e-02,
 3.67395e-02, 4.02125e-02, 4.36542e-02, 4.70431e-02, 5.03605e-02,
 5.35914e-02, 5.67238e-02, 5.97464e-02, 6.26508e-02, 6.54323e-02,
 6.80875e-02, 7.06116e-02, 7.30007e-02, 7.52532e-02, 7.73689e-02,
 7.93480e-02, 8.11892e-02, 8.28926e-02, 8.44584e-02, 8.58881e-02,
 8.71831e-02, 8.83435e-02, 8.93707e-02, 9.02660e-02, 9.10314e-02,
 9.16683e-02, 9.21787e-02, 9.25640e-02, 9.28266e-02, 9.29685e-02,
 9.29927e-02, 9.29015e-02, 9.26979e-02, 9.23853e-02, 9.19663e-02,
 9.14442e-02, 9.08213e-02, 9.01008e-02, 8.92851e-02, 8.83769e-02,
 8.73784e-02, 8.62921e-02, 8.51201e-02, 8.38648e-02, 8.25284e-02,
 8.11131e-02, 7.96215e-02, 7.80560e-02, 7.64193e-02, 7.47140e-02,
 7.29432e-02, 7.11100e-02, 6.92179e-02, 6.72704e-02, 6.52717e-02,
 6.32258e-02, 6.11375e-02, 5.90117e-02, 5.68539e-02, 5.46698e-02,
 5.24657e-02, 5.02485e-02, 4.80257e-02, 4.58052e-02, 4.35956e-02,
 4.14064e-02, 3.92476e-02, 3.71301e-02, 3.50654e-02, 3.30664e-02,
 3.11465e-02, 2.93205e-02, 2.76042e-02, 2.60149e-02, 2.45711e-02,
 2.32929e-02, 2.22021e-02, 2.13221e-02, 2.06784e-02, 2.02985e-02}
,
{2.30550e-06, 1.82236e-05, 8.04036e-05, 2.58024e-04, 6.31630e-04,
 1.28306e-03, 2.28372e-03, 3.68837e-03, 5.53306e-03, 7.83175e-03,
 1.05737e-02, 1.37356e-02, 1.72840e-02, 2.11706e-02, 2.53425e-02,
 2.97463e-02, 3.43275e-02, 3.90338e-02, 4.38151e-02, 4.86265e-02,
 5.34275e-02, 5.81823e-02, 6.28596e-02, 6.74330e-02, 7.18822e-02,
 7.61899e-02, 8.03408e-02, 8.43262e-02, 8.81410e-02, 9.17778e-02,
 9.52307e-02, 9.84968e-02, 1.01576e-01, 1.04468e-01, 1.07172e-01,
 1.09686e-01, 1.12013e-01, 1.14154e-01, 1.16112e-01, 1.17885e-01,
 1.19477e-01, 1.20889e-01, 1.22125e-01, 1.23187e-01, 1.24077e-01,
 1.24798e-01, 1.25353e-01, 1.25746e-01, 1.25981e-01, 1.26062e-01,
 1.25993e-01, 1.25779e-01, 1.25424e-01, 1.24932e-01, 1.24306e-01,
 1.23550e-01, 1.22667e-01, 1.21659e-01, 1.20530e-01, 1.19281e-01,
 1.17916e-01, 1.16436e-01, 1.14845e-01, 1.13144e-01, 1.11336e-01,
 1.09423e-01, 1.07409e-01, 1.05296e-01, 1.03087e-01, 1.00785e-01,
 9.83942e-02, 9.59184e-02, 9.33617e-02, 9.07288e-02, 8.80246e-02,
 8.52544e-02, 8.24244e-02, 7.95408e-02, 7.66106e-02, 7.36419e-02,
 7.06429e-02, 6.76227e-02, 6.45909e-02, 6.15583e-02, 5.85363e-02,
 5.55373e-02, 5.25747e-02, 4.96634e-02, 4.68192e-02, 4.40595e-02,
 4.14034e-02, 3.88715e-02, 3.64864e-02, 3.42727e-02, 3.22571e-02,
 3.04688e-02, 2.89396e-02, 2.77040e-02, 2.67996e-02, 2.62673e-02}
,
{3.52934e-06, 2.80386e-05, 1.29286e-04, 4.16785e-04, 1.01413e-03,
 2.04291e-03, 3.60486e-03, 5.77264e-03, 8.58821e-03, 1.20528e-02,
 1.61388e-02, 2.08028e-02, 2.59785e-02, 3.15872e-02, 3.75485e-02,
 4.37807e-02, 5.02045e-02, 5.67444e-02, 6.33331e-02, 6.99103e-02,
 7.64233e-02, 8.28259e-02, 8.90814e-02, 9.51614e-02, 1.01040e-01,
 1.06699e-01, 1.12130e-01, 1.17322e-01, 1.22266e-01, 1.26956e-01,
 1.31391e-01, 1.35571e-01, 1.39494e-01, 1.43159e-01, 1.46568e-01,
 1.49725e-01, 1.52630e-01, 1.55286e-01, 1.57695e-01, 1.59861e-01,
 1.61789e-01, 1.63481e-01, 1.64940e-01, 1.66172e-01, 1.67183e-01,
 1.67977e-01, 1.68561e-01, 1.68941e-01, 1.69124e-01, 1.69116e-01,
 1.68922e-01, 1.68548e-01, 1.67998e-01, 1.67277e-01, 1.66388e-01,
 1.65334e-01, 1.64119e-01, 1.62746e-01, 1.61216e-01, 1.59533e-01,
 1.57699e-01, 1.55716e-01, 1.53587e-01, 1.51315e-01, 1.48902e-01,
 1.46351e-01, 1.43666e-01, 1.40849e-01, 1.37904e-01, 1.34835e-01,
 1.31647e-01, 1.28344e-01, 1.24931e-01, 1.21415e-01, 1.17801e-01,
 1.14097e-01, 1.10310e-01, 1.06449e-01, 1.02522e-01, 9.85396e-02,
 9.45114e-02, 9.04489e-02, 8.63646e-02, 8.22720e-02, 7.81860e-02,
 7.41231e-02, 7.01012e-02, 6.61402e-02, 6.22618e-02, 5.84901e-02,
 5.48515e-02, 5.13748e-02, 4.80918e-02, 4.50376e-02, 4.22504e-02,
 3.97722e-02, 3.76491e-02, 3.59317e-02, 3.46749e-02, 3.39394e-02}
,
{5.31267e-06, 4.29622e-05, 2.06078e-04, 6.62857e-04, 1.60181e-03,
 3.19977e-03, 5.59730e-03, 8.88812e-03, 1.31111e-02, 1.82436e-02,
 2.42333e-02, 3.09958e-02, 3.84173e-02, 4.63787e-02, 5.47582e-02,
 6.34366e-02, 7.23007e-02, 8.12486e-02, 9.01908e-02, 9.90485e-02,
 1.07754e-01, 1.16256e-01, 1.24513e-01, 1.32488e-01, 1.40160e-01,
 1.47517e-01, 1.54543e-01, 1.61224e-01, 1.67559e-01, 1.73547e-01,
 1.79185e-01, 1.84473e-01, 1.89411e-01, 1.94006e-01, 1.98259e-01,
 2.02173e-01, 2.05753e-01, 2.09004e-01, 2.11932e-01, 2.14541e-01,
 2.16838e-01, 2.18829e-01, 2.20525e-01, 2.21932e-01, 2.23061e-01,
 2.23922e-01, 2.24524e-01, 2.24876e-01, 2.24985e-01, 2.24858e-01,
 2.24502e-01, 2.23923e-01, 2.23124e-01, 2.22111e-01, 2.20886e-01,
 2.19452e-01, 2.17814e-01, 2.15973e-01, 2.13932e-01, 2.11693e-01,
 2.09260e-01, 2.06635e-01, 2.03820e-01, 2.00819e-01, 1.97634e-01,
 1.94270e-01, 1.90728e-01, 1.87013e-01, 1.83130e-01, 1.79084e-01,
 1.74880e-01, 1.70524e-01, 1.66024e-01, 1.61385e-01, 1.56617e-01,
 1.51726e-01, 1.46721e-01, 1.41612e-01, 1.36411e-01, 1.31126e-01,
 1.25773e-01, 1.20364e-01, 1.14915e-01, 1.09444e-01, 1.03970e-01,
 9.85144e-02, 9.31017e-02, 8.77582e-02, 8.25134e-02, 7.74002e-02,
 7.24550e-02, 6.77179e-02, 6.32338e-02, 5.90518e-02, 5.52266e-02,
 5.18184e-02, 4.88935e-02, 4.65250e-02, 4.47934e-02, 4.37871e-02}
,
{7.88279e-06, 6.59090e-05, 3.24091e-04, 1.04036e-03, 2.49440e-03,
 4.93876e-03, 8.56396e-03, 1.34843e-02, 1.97182e-02, 2.72090e-02,
 3.58585e-02, 4.55129e-02, 5.59975e-02, 6.71339e-02, 7.87430e-02,
 9.06559e-02, 1.02718e-01, 1.14796e-01, 1.26771e-01, 1.38544e-01,
 1.50040e-01, 1.61198e-01, 1.71968e-01, 1.82323e-01, 1.92242e-01,
 2.01703e-01, 2.10694e-01, 2.19212e-01, 2.27258e-01, 2.34827e-01,
 2.41919e-01, 2.48542e-01, 2.54702e-01, 2.60400e-01, 2.65644e-01,
 2.70442e-01, 2.74802e-01, 2.78732e-01, 2.82241e-01, 2.85340e-01,
 2.88042e-01, 2.90360e-01, 2.92310e-01, 2.93907e-01, 2.95163e-01,
 2.96091e-01, 2.96703e-01, 2.97009e-01, 2.97017e-01, 2.96735e-01,
 2.96169e-01, 2.95323e-01, 2.94203e-01, 2.92813e-01, 2.91156e-01,
 2.89235e-01, 2.87054e-01, 2.84615e-01, 2.81921e-01, 2.78975e-01,
 2.75779e-01, 2.72337e-01, 2.68651e-01, 2.64725e-01, 2.60562e-01,
 2.56166e-01, 2.51543e-01, 2.46698e-01, 2.41637e-01, 2.36365e-01,
 2.30889e-01, 2.25216e-01, 2.19352e-01, 2.13304e-01, 2.07081e-01,
 2.00691e-01, 1.94144e-01, 1.87449e-01, 1.80620e-01, 1.73671e-01,
 1.66616e-01, 1.59473e-01, 1.52261e-01, 1.45004e-01, 1.37725e-01,
 1.30453e-01, 1.23220e-01, 1.16060e-01, 1.09015e-01, 1.02128e-01,
 9.54503e-02, 8.90372e-02, 8.29511e-02, 7.72615e-02, 7.20456e-02,
 6.73888e-02, 6.33860e-02, 6.01422e-02, 5.77734e-02, 5.64078e-02}
,
{1.15520e-05, 1.00588e-04, 5.04836e-04, 1.61164e-03, 3.83285e-03,
 7.52261e-03, 1.29304e-02, 2.01839e-02, 2.92589e-02, 4.00475e-02,
 5.23647e-02, 6.59622e-02, 8.05802e-02, 9.59553e-02, 1.11833e-01,
 1.27982e-01, 1.44198e-01, 1.60305e-01, 1.76156e-01, 1.91636e-01,
 2.06658e-01, 2.21149e-01, 2.35075e-01, 2.48402e-01, 2.61100e-01,
 2.73157e-01, 2.84574e-01, 2.95343e-01, 3.05464e-01, 3.14944e-01,
 3.23793e-01, 3.32012e-01, 3.39614e-01, 3.46608e-01, 3.53009e-01,
 3.58826e-01, 3.64073e-01, 3.68768e-01, 3.72928e-01, 3.76576e-01,
 3.79732e-01, 3.82420e-01, 3.84659e-01, 3.86468e-01, 3.87864e-01,
 3.88862e-01, 3.89473e-01, 3.89707e-01, 3.89575e-01, 3.89082e-01,
 3.88235e-01, 3.87040e-01, 3.85501e-01, 3.83622e-01, 3.81407e-01,
 3.78859e-01, 3.75983e-01, 3.72780e-01, 3.69256e-01, 3.65410e-01,
 3.61248e-01, 3.56773e-01, 3.51990e-01, 3.46903e-01, 3.41519e-01,
 3.35842e-01, 3.29880e-01, 3.23637e-01, 3.17119e-01, 3.10330e-01,
 3.03277e-01, 2.95965e-01, 2.88399e-01, 2.80587e-01, 2.72537e-01,
 2.64258e-01, 2.55760e-01, 2.47056e-01, 2.38158e-01, 2.29084e-01,
 2.19851e-01, 2.10481e-01, 2.00997e-01, 1.91428e-01, 1.81807e-01,
 1.72169e-01, 1.62557e-01, 1.53018e-01, 1.43607e-01, 1.34383e-01,
 1.25417e-01, 1.16784e-01, 1.08572e-01, 1.00877e-01, 9.38067e-02,
 8.74816e-02, 8.20361e-02, 7.76197e-02, 7.43986e-02, 7.25575e-02}
,
{1.67680e-05, 1.52270e-04, 7.77978e-04, 2.46877e-03, 5.81893e-03,
 1.13194e-02, 1.92898e-02, 2.98450e-02, 4.28958e-02, 5.82445e-02,
 7.55670e-02, 9.44906e-02, 1.14631e-01, 1.35613e-01, 1.57083e-01,
 1.78734e-01, 2.00301e-01, 2.21558e-01, 2.42334e-01, 2.62498e-01,
 2.81945e-01, 3.00622e-01, 3.18483e-01, 3.35485e-01, 3.51615e-01,
 3.66875e-01, 3.81254e-01, 3.94754e-01, 4.07390e-01, 4.19172e-01,
 4.30108e-01, 4.40216e-01, 4.49513e-01, 4.58018e-01, 4.65748e-01,
 4.72727e-01, 4.78983e-01, 4.84546e-01, 4.89450e-01, 4.93727e-01,
 4.97409e-01, 5.00523e-01, 5.03094e-01, 5.05145e-01, 5.06692e-01,
 5.07752e-01, 5.08336e-01, 5.08455e-01, 5.08119e-01, 5.07336e-01,
 5.06112e-01, 5.04452e-01, 5.02362e-01, 4.99847e-01, 4.96911e-01,
 4.93560e-01, 4.89795e-01, 4.85621e-01, 4.81043e-01, 4.76065e-01,
 4.70695e-01, 4.64938e-01, 4.58801e-01, 4.52292e-01, 4.45414e-01,
 4.38172e-01, 4.30571e-01, 4.22614e-01, 4.14303e-01, 4.05643e-01,
 3.96636e-01, 3.87288e-01, 3.77603e-01, 3.67588e-01, 3.57249e-01,
 3.46596e-01, 3.35639e-01, 3.24390e-01, 3.12865e-01, 3.01082e-01,
 2.89062e-01, 2.76832e-01, 2.64423e-01, 2.51869e-01, 2.39213e-01,
 2.26504e-01, 2.13795e-01, 2.01152e-01, 1.88647e-01, 1.76360e-01,
 1.64386e-01, 1.52829e-01, 1.41807e-01, 1.31454e-01, 1.21920e-01,
 1.13372e-01, 1.06001e-01, 1.00017e-01, 9.56578e-02, 9.31875e-02}
,
{2.41930e-05, 2.29994e-04, 1.18608e-03, 3.74001e-03, 8.73985e-03,
 1.68462e-02, 2.84607e-02, 4.36446e-02, 6.22103e-02, 8.37987e-02,
 1.07894e-01, 1.33948e-01, 1.61406e-01, 1.89742e-01, 2.18486e-01,
 2.47232e-01, 2.75643e-01, 3.03447e-01, 3.30451e-01, 3.56495e-01,
 3.81499e-01, 4.05395e-01, 4.28124e-01, 4.49668e-01, 4.70030e-01,
 4.89195e-01, 5.07172e-01, 5.23984e-01, 5.39639e-01, 5.54159e-01,
 5.67569e-01, 5.79896e-01, 5.91164e-01, 6.01406e-01, 6.10661e-01,
 6.18973e-01, 6.26387e-01, 6.32957e-01, 6.38726e-01, 6.43739e-01,
 6.48032e-01, 6.51639e-01, 6.54588e-01, 6.56901e-01, 6.58596e-01,
 6.59691e-01, 6.60200e-01, 6.60133e-01, 6.59501e-01, 6.58313e-01,
 6.56576e-01, 6.54298e-01, 6.51488e-01, 6.48147e-01, 6.44282e-01,
 6.39901e-01, 6.35010e-01, 6.29617e-01, 6.23732e-01, 6.17364e-01,
 6.10521e-01, 6.03210e-01, 5.95436e-01, 5.87202e-01, 5.78511e-01,
 5.69364e-01, 5.59761e-01, 5.49703e-01, 5.39190e-01, 5.28223e-01,
 5.16804e-01, 5.04933e-01, 4.92614e-01, 4.79849e-01, 4.66644e-01,
 4.53006e-01, 4.38945e-01, 4.24474e-01, 4.09610e-01, 3.94375e-01,
 3.78794e-01, 3.62902e-01, 3.46736e-01, 3.30343e-01, 3.13777e-01,
 2.97099e-01, 2.80382e-01, 2.63709e-01, 2.47175e-01, 2.30888e-01,
 2.14974e-01, 1.99574e-01, 1.84848e-01, 1.70982e-01, 1.58180e-01,
 1.46680e-01, 1.36744e-01, 1.28671e-01, 1.22795e-01, 1.19493e-01}
,
{3.46950e-05, 3.46093e-04, 1.79360e-03, 5.61166e-03, 1.29931e-02,
 2.48244e-02, 4.15689e-02, 6.31889e-02, 8.93364e-02, 1.19390e-01,
 1.52579e-01, 1.88104e-01, 2.25184e-01, 2.63103e-01, 3.01243e-01,
 3.39080e-01, 3.76199e-01, 4.12293e-01, 4.47121e-01, 4.80552e-01,
 5.12490e-01, 5.42847e-01, 5.71597e-01, 5.98742e-01, 6.24265e-01,
 6.48181e-01, 6.70523e-01, 6.91304e-01, 7.10558e-01, 7.28322e-01,
 7.44638e-01, 7.59543e-01, 7.73089e-01, 7.85337e-01, 7.96353e-01,
 8.06211e-01, 8.14982e-01, 8.22730e-01, 8.29514e-01, 8.35384e-01,
 8.40383e-01, 8.44547e-01, 8.47905e-01, 8.50481e-01, 8.52300e-01,
 8.53376e-01, 8.53726e-01, 8.53364e-01, 8.52302e-01, 8.50552e-01,
 8.48126e-01, 8.45028e-01, 8.41271e-01, 8.36864e-01, 8.31820e-01,
 8.26151e-01, 8.19872e-01, 8.12996e-01, 8.05534e-01, 7.97495e-01,
 7.88885e-01, 7.79704e-01, 7.69954e-01, 7.59635e-01, 7.48743e-01,
 7.37276e-01, 7.25231e-01, 7.12604e-01, 6.99390e-01, 6.85585e-01,
 6.71185e-01, 6.56186e-01, 6.40585e-01, 6.24382e-01, 6.07580e-01,
 5.90185e-01, 5.72205e-01, 5.53657e-01, 5.34561e-01, 5.14942e-01,
 4.94834e-01, 4.74276e-01, 4.53316e-01, 4.32010e-01, 4.10427e-01,
 3.88643e-01, 3.66751e-01, 3.44858e-01, 3.23088e-01, 3.01587e-01,
 2.80520e-01, 2.60079e-01, 2.40483e-01, 2.21983e-01, 2.04865e-01,
 1.89452e-01, 1.76113e-01, 1.65264e-01, 1.57375e-01, 1.52977e-01}
,
{4.94579e-05, 5.17237e-04, 2.68633e-03, 8.34110e-03, 1.91417e-02,
 3.62469e-02, 6.01551e-02, 9.06586e-02, 1.27142e-01, 1.68599e-01,
 2.13908e-01, 2.61927e-01, 3.11575e-01, 3.61905e-01, 4.12112e-01,
 4.61536e-01, 5.09698e-01, 5.56222e-01, 6.00883e-01, 6.43547e-01,
 6.84080e-01, 7.22435e-01, 7.58616e-01, 7.92599e-01, 8.24409e-01,
 8.54091e-01, 8.81666e-01, 9.07186e-01, 9.30708e-01, 9.52287e-01,
 9.71984e-01, 9.89881e-01, 1.00607e+00, 1.02065e+00, 1.03373e+00,
 1.04540e+00, 1.05577e+00, 1.06490e+00, 1.07286e+00, 1.07972e+00,
 1.08551e+00, 1.09028e+00, 1.09406e+00, 1.09687e+00, 1.09875e+00,
 1.09971e+00, 1.09977e+00, 1.09896e+00, 1.09728e+00, 1.09476e+00,
 1.09140e+00, 1.08723e+00, 1.08227e+00, 1.07652e+00, 1.07003e+00,
 1.06281e+00, 1.05487e+00, 1.04622e+00, 1.03688e+00, 1.02684e+00,
 1.01611e+00, 1.00468e+00, 9.92543e-01, 9.79701e-01, 9.66143e-01,
 9.51858e-01, 9.36836e-01, 9.21064e-01, 9.04529e-01, 8.87219e-01,
 8.69122e-01, 8.50228e-01, 8.30529e-01, 8.10023e-01, 7.88709e-01,
 7.66595e-01, 7.43690e-01, 7.20012e-01, 6.95583e-01, 6.70431e-01,
 6.44594e-01, 6.18117e-01, 5.91055e-01, 5.63477e-01, 5.35463e-01,
 5.07114e-01, 4.78547e-01, 4.49900e-01, 4.21338e-01, 3.93052e-01,
 3.65263e-01, 3.38230e-01, 3.12249e-01, 2.87661e-01, 2.64857e-01,
 2.44284e-01, 2.26448e-01, 2.11928e-01, 2.01378e-01, 1.95541e-01}
,
{7.00942e-05, 7.67756e-04, 3.99369e-03, 1.22972e-02, 2.79603e-02,
 5.24808e-02, 8.63196e-02, 1.29001e-01, 1.79466e-01, 2.36185e-01,
 2.97544e-01, 3.61940e-01, 4.27916e-01, 4.94231e-01, 5.59854e-01,
 6.23994e-01, 6.86086e-01, 7.45719e-01, 8.02699e-01, 8.56827e-01,
 9.08009e-01, 9.56249e-01, 1.00152e+00, 1.04384e+00, 1.08329e+00,
 1.11990e+00, 1.15373e+00, 1.18488e+00, 1.21342e+00, 1.23945e+00,
 1.26309e+00, 1.28447e+00, 1.30375e+00, 1.32107e+00, 1.33658e+00,
 1.35040e+00, 1.36263e+00, 1.37337e+00, 1.38269e+00, 1.39064e+00,
 1.39729e+00, 1.40269e+00, 1.40685e+00, 1.40984e+00, 1.41166e+00,
 1.41235e+00, 1.41195e+00, 1.41046e+00, 1.40793e+00, 1.40436e+00,
 1.39980e+00, 1.39427e+00, 1.38782e+00, 1.38047e+00, 1.37226e+00,
 1.36319e+00, 1.35327e+00, 1.34252e+00, 1.33093e+00, 1.31850e+00,
 1.30522e+00, 1.29108e+00, 1.27608e+00, 1.26018e+00, 1.24339e+00,
 1.22567e+00, 1.20700e+00, 1.18735e+00, 1.16671e+00, 1.14505e+00,
 1.12236e+00, 1.09862e+00, 1.07381e+00, 1.04794e+00, 1.02101e+00,
 9.93008e-01, 9.63950e-01, 9.33849e-01, 9.02724e-01, 8.70603e-01,
 8.37523e-01, 8.03536e-01, 7.68706e-01, 7.33116e-01, 6.96868e-01,
 6.60085e-01, 6.22920e-01, 5.85553e-01, 5.48198e-01, 5.11108e-01,
 4.74580e-01, 4.38958e-01, 4.04642e-01, 3.72091e-01, 3.41836e-01,
 3.14482e-01, 2.90727e-01, 2.71366e-01, 2.57306e-01, 2.49582e-01}
,
{9.87930e-05, 1.13590e-03, 5.89401e-03, 1.79872e-02, 4.05269e-02,
 7.53996e-02, 1.22909e-01, 1.82173e-01, 2.51433e-01, 3.28457e-01,
 4.10943e-01, 4.96689e-01, 5.83769e-01, 6.70571e-01, 7.55812e-01,
 8.38575e-01, 9.18182e-01, 9.94279e-01, 1.06659e+00, 1.13493e+00,
 1.19930e+00, 1.25965e+00, 1.31602e+00, 1.36850e+00, 1.41714e+00,
 1.46205e+00, 1.50333e+00, 1.54112e+00, 1.57554e+00, 1.60678e+00,
 1.63502e+00, 1.66050e+00, 1.68343e+00, 1.70399e+00, 1.72236e+00,
 1.73868e+00, 1.75308e+00, 1.76564e+00, 1.77647e+00, 1.78562e+00,
 1.79317e+00, 1.79915e+00, 1.80363e+00, 1.80665e+00, 1.80825e+00,
 1.80846e+00, 1.80732e+00, 1.80488e+00, 1.80118e+00, 1.79628e+00,
 1.79023e+00, 1.78308e+00, 1.77487e+00, 1.76562e+00, 1.75536e+00,
 1.74410e+00, 1.73183e+00, 1.71856e+00, 1.70428e+00, 1.68899e+00,
 1.67265e+00, 1.65526e+00, 1.63678e+00, 1.61718e+00, 1.59642e+00,
 1.57448e+00, 1.55131e+00, 1.52687e+00, 1.50115e+00, 1.47411e+00,
 1.44573e+00, 1.41599e+00, 1.38487e+00, 1.35237e+00, 1.31846e+00,
 1.28314e+00, 1.24640e+00, 1.20825e+00, 1.16871e+00, 1.12780e+00,
 1.08555e+00, 1.04203e+00, 9.97314e-01, 9.51499e-01, 9.04715e-01,
 8.57120e-01, 8.08909e-01, 7.60318e-01, 7.11627e-01, 6.63169e-01,
 6.15332e-01, 5.68571e-01, 5.23416e-01, 4.80483e-01, 4.40484e-01,
 4.04243e-01, 3.72710e-01, 3.46975e-01, 3.28292e-01, 3.18094e-01}
,
{1.38517e-04, 1.67180e-03, 8.63350e-03, 2.61252e-02, 5.83272e-02,
 1.07546e-01, 1.73775e-01, 2.55472e-01, 3.49861e-01, 4.53744e-01,
 5.63894e-01, 6.77344e-01, 7.91571e-01, 9.04519e-01, 1.01466e+00,
 1.12088e+00, 1.22252e+00, 1.31917e+00, 1.41052e+00, 1.49649e+00,
 1.57706e+00, 1.65224e+00, 1.72215e+00, 1.78688e+00, 1.84656e+00,
 1.90137e+00, 1.95146e+00, 1.99703e+00, 2.03835e+00, 2.07570e+00,
 2.10938e+00, 2.13971e+00, 2.16694e+00, 2.19132e+00, 2.21303e+00,
 2.23226e+00, 2.24911e+00, 2.26373e+00, 2.27619e+00, 2.28659e+00,
 2.29500e+00, 2.30149e+00, 2.30613e+00, 2.30897e+00, 2.31008e+00,
 2.30951e+00, 2.30733e+00, 2.30362e+00, 2.29847e+00, 2.29196e+00,
 2.28414e+00, 2.27506e+00, 2.26477e+00, 2.25327e+00, 2.24058e+00,
 2.22670e+00, 2.21164e+00, 2.19537e+00, 2.17788e+00, 2.15914e+00,
 2.13912e+00, 2.11777e+00, 2.09503e+00, 2.07088e+00, 2.04524e+00,
 2.01808e+00, 1.98936e+00, 1.95903e+00, 1.92705e+00, 1.89340e+00,
 1.85804e+00, 1.82093e+00, 1.78203e+00, 1.74131e+00, 1.69874e+00,
 1.65429e+00, 1.60795e+00, 1.55970e+00, 1.50956e+00, 1.45754e+00,
 1.40369e+00, 1.34808e+00, 1.29079e+00, 1.23196e+00, 1.17174e+00,
 1.11034e+00, 1.04801e+00, 9.85044e-01, 9.21804e-01, 8.58715e-01,
 7.96282e-01, 7.35103e-01, 6.75878e-01, 6.19428e-01, 5.66712e-01,
 5.18844e-01, 4.77113e-01, 4.43010e-01, 4.18251e-01, 4.04808e-01}
,
{1.93769e-04, 2.44450e-03, 1.25723e-02, 3.76914e-02, 8.33867e-02,
 1.52376e-01, 2.44106e-01, 3.55965e-01, 4.83781e-01, 6.23016e-01,
 7.69220e-01, 9.18457e-01, 1.06746e+00, 1.21367e+00, 1.35529e+00,
 1.49103e+00, 1.62028e+00, 1.74250e+00, 1.85748e+00, 1.96521e+00,
 2.06564e+00, 2.15895e+00, 2.24525e+00, 2.32473e+00, 2.39762e+00,
 2.46416e+00, 2.52463e+00, 2.57938e+00, 2.62881e+00, 2.67339e+00,
 2.71351e+00, 2.74957e+00, 2.78188e+00, 2.81072e+00, 2.83631e+00,
 2.85882e+00, 2.87843e+00, 2.89527e+00, 2.90944e+00, 2.92107e+00,
 2.93025e+00, 2.93707e+00, 2.94161e+00, 2.94398e+00, 2.94426e+00,
 2.94257e+00, 2.93903e+00, 2.93377e+00, 2.92688e+00, 2.91846e+00,
 2.90855e+00, 2.89719e+00, 2.88442e+00, 2.87024e+00, 2.85466e+00,
 2.83768e+00, 2.81928e+00, 2.79941e+00, 2.77805e+00, 2.75512e+00,
 2.73058e+00, 2.70436e+00, 2.67639e+00, 2.64661e+00, 2.61497e+00,
 2.58142e+00, 2.54591e+00, 2.50837e+00, 2.46877e+00, 2.42703e+00,
 2.38310e+00, 2.33690e+00, 2.28837e+00, 2.23745e+00, 2.18409e+00,
 2.12822e+00, 2.06983e+00, 2.00888e+00, 1.94538e+00, 1.87935e+00,
 1.81084e+00, 1.73992e+00, 1.66673e+00, 1.59141e+00, 1.51415e+00,
 1.43521e+00, 1.35488e+00, 1.27355e+00, 1.19165e+00, 1.10975e+00,
 1.02850e+00, 9.48677e-01, 8.71213e-01, 7.97203e-01, 7.27928e-01,
 6.64889e-01, 6.09829e-01, 5.64770e-01, 5.32048e-01, 5.14358e-01}
,
{2.71486e-04, 3.55599e-03, 1.81910e-02, 5.40434e-02, 1.18494e-01,
 2.14571e-01, 3.40847e-01, 4.93059e-01, 6.65125e-01, 8.50676e-01,
 1.04367e+00, 1.23896e+00, 1.43235e+00, 1.62077e+00, 1.80204e+00,
 1.97491e+00, 2.13861e+00, 2.29262e+00, 2.43688e+00, 2.57132e+00,
 2.69610e+00, 2.81142e+00, 2.91751e+00, 3.01470e+00, 3.10330e+00,
 3.18371e+00, 3.25642e+00, 3.32199e+00, 3.38105e+00, 3.43420e+00,
 3.48196e+00, 3.52477e+00, 3.56303e+00, 3.59702e+00, 3.62701e+00,
 3.65322e+00, 3.67582e+00, 3.69499e+00, 3.71088e+00, 3.72363e+00,
 3.73336e+00, 3.74021e+00, 3.74431e+00, 3.74583e+00, 3.74494e+00,
 3.74182e+00, 3.73663e+00, 3.72952e+00, 3.72058e+00, 3.70988e+00,
 3.69748e+00, 3.68341e+00, 3.66769e+00, 3.65033e+00, 3.63131e+00,
 3.61061e+00, 3.58816e+00, 3.56391e+00, 3.53778e+00, 3.50970e+00,
 3.47958e+00, 3.44735e+00, 3.41294e+00, 3.37630e+00, 3.33735e+00,
 3.29603e+00, 3.25226e+00, 3.20596e+00, 3.15702e+00, 3.10535e+00,
 3.05083e+00, 2.99337e+00, 2.93287e+00, 2.86922e+00, 2.80235e+00,
 2.73218e+00, 2.65866e+00, 2.58175e+00, 2.50147e+00, 2.41783e+00,
 2.33089e+00, 2.24075e+00, 2.14751e+00, 2.05136e+00, 1.95253e+00,
 1.85129e+00, 1.74804e+00, 1.64322e+00, 1.53742e+00, 1.43134e+00,
 1.32585e+00, 1.22196e+00, 1.12091e+00, 1.02415e+00, 9.33380e-01,
 8.50616e-01, 7.78197e-01, 7.18847e-01, 6.75725e-01, 6.52484e-01}
,
{3.80411e-04, 5.15279e-03, 2.61708e-02, 7.70446e-02, 1.67409e-01,
 3.00426e-01, 4.73280e-01, 6.79237e-01, 9.09618e-01, 1.15559e+00,
 1.40908e+00, 1.66340e+00, 1.91329e+00, 2.15509e+00, 2.38629e+00,
 2.60570e+00, 2.81228e+00, 3.00578e+00, 3.18611e+00, 3.35335e+00,
 3.50784e+00, 3.64982e+00, 3.77973e+00, 3.89806e+00, 4.00529e+00,
 4.10211e+00, 4.18929e+00, 4.26772e+00, 4.33823e+00, 4.40154e+00,
 4.45831e+00, 4.50904e+00, 4.55417e+00, 4.59404e+00, 4.62897e+00,
 4.65920e+00, 4.68498e+00, 4.70650e+00, 4.72399e+00, 4.73761e+00,
 4.74756e+00, 4.75404e+00, 4.75732e+00, 4.75764e+00, 4.75527e+00,
 4.75042e+00, 4.74327e+00, 4.73394e+00, 4.72254e+00, 4.70912e+00,
 4.69375e+00, 4.67645e+00, 4.65722e+00, 4.63604e+00, 4.61285e+00,
 4.58759e+00, 4.56017e+00, 4.53049e+00, 4.49846e+00, 4.46399e+00,
 4.42701e+00, 4.38745e+00, 4.34523e+00, 4.30027e+00, 4.25246e+00,
 4.20170e+00, 4.14786e+00, 4.09078e+00, 4.03033e+00, 3.96635e+00,
 3.89869e+00, 3.82720e+00, 3.75174e+00, 3.67218e+00, 3.58841e+00,
 3.50034e+00, 3.40791e+00, 3.31109e+00, 3.20985e+00, 3.10420e+00,
 2.99419e+00, 2.87987e+00, 2.76138e+00, 2.63891e+00, 2.51270e+00,
 2.38311e+00, 2.25061e+00, 2.11578e+00, 1.97937e+00, 1.84228e+00,
 1.70563e+00, 1.57076e+00, 1.43930e+00, 1.31316e+00, 1.19460e+00,
 1.08629e+00, 9.91343e-01, 9.13412e-01, 8.56737e-01, 8.26242e-01}
,
{5.32477e-04, 7.42926e-03, 3.74599e-02, 1.09241e-01, 2.35265e-01,
 4.18426e-01, 6.53768e-01, 9.31007e-01, 1.23793e+00, 1.56242e+00,
 1.89385e+00, 2.22360e+00, 2.54523e+00, 2.85435e+00, 3.14839e+00,
 3.42585e+00, 3.68581e+00, 3.92818e+00, 4.15289e+00, 4.36034e+00,
 4.55089e+00, 4.72508e+00, 4.88358e+00, 5.02704e+00, 5.15637e+00,
 5.27264e+00, 5.37705e+00, 5.47078e+00, 5.55487e+00, 5.63021e+00,
 5.69755e+00, 5.75745e+00, 5.81044e+00, 5.85693e+00, 5.89727e+00,
 5.93179e+00, 5.96081e+00, 5.98456e+00, 6.00336e+00, 6.01746e+00,
 6.02719e+00, 6.03291e+00, 6.03501e+00, 6.03382e+00, 6.02966e+00,
 6.02273e+00, 6.01320e+00, 6.00120e+00, 5.98684e+00, 5.97019e+00,
 5.95127e+00, 5.93008e+00, 5.90658e+00, 5.88070e+00, 5.85235e+00,
 5.82141e+00, 5.78777e+00, 5.75134e+00, 5.71203e+00, 5.66977e+00,
 5.62447e+00, 5.57604e+00, 5.52437e+00, 5.46931e+00, 5.41070e+00,
 5.34835e+00, 5.28207e+00, 5.21166e+00, 5.13690e+00, 5.05759e+00,
 4.97353e+00, 4.88451e+00, 4.79037e+00, 4.69096e+00, 4.58617e+00,
 4.47586e+00, 4.35995e+00, 4.23835e+00, 4.11097e+00, 3.97779e+00,
 3.83879e+00, 3.69404e+00, 3.54363e+00, 3.38780e+00, 3.22684e+00,
 3.06118e+00, 2.89141e+00, 2.71827e+00, 2.54271e+00, 2.36593e+00,
 2.18936e+00, 2.01477e+00, 1.84425e+00, 1.68031e+00, 1.52592e+00,
 1.38461e+00, 1.26052e+00, 1.15849e+00, 1.08419e+00, 1.04422e+00}
,
{7.43950e-04, 1.06527e-02, 5.33310e-02, 1.54132e-01, 3.28952e-01,
 5.79932e-01, 8.98737e-01, 1.27016e+00, 1.67715e+00, 2.10335e+00,
 2.53486e+00, 2.96073e+00, 3.37321e+00, 3.76715e+00, 4.14000e+00,
 4.48982e+00, 4.81613e+00, 5.11877e+00, 5.39803e+00, 5.65450e+00,
 5.88878e+00, 6.10177e+00, 6.29438e+00, 6.46775e+00, 6.62332e+00,
 6.76276e+00, 6.88770e+00, 6.99963e+00, 7.09982e+00, 7.18930e+00,
 7.26891e+00, 7.33936e+00, 7.40122e+00, 7.45499e+00, 7.50113e+00,
 7.54007e+00, 7.57221e+00, 7.59790e+00, 7.61757e+00, 7.63169e+00,
 7.64078e+00, 7.64539e+00, 7.64598e+00, 7.64295e+00, 7.63658e+00,
 7.62710e+00, 7.61468e+00, 7.59948e+00, 7.58157e+00, 7.56100e+00,
 7.53775e+00, 7.51177e+00, 7.48295e+00, 7.45117e+00, 7.41630e+00,
 7.37824e+00, 7.33689e+00, 7.29217e+00, 7.24402e+00, 7.19232e+00,
 7.13696e+00, 7.07777e+00, 7.01456e+00, 6.94709e+00, 6.87512e+00,
 6.79840e+00, 6.71665e+00, 6.62959e+00, 6.53696e+00, 6.43848e+00,
 6.33394e+00, 6.22312e+00, 6.10583e+00, 5.98188e+00, 5.85107e+00,
 5.71320e+00, 5.56810e+00, 5.41556e+00, 5.25545e+00, 5.08766e+00,
 4.91214e+00, 4.72891e+00, 4.53812e+00, 4.33998e+00, 4.13488e+00,
 3.92337e+00, 3.70617e+00, 3.48426e+00, 3.25884e+00, 3.03144e+00,
 2.80390e+00, 2.57847e+00, 2.35789e+00, 2.14542e+00, 1.94496e+00,
 1.76115e+00, 1.59944e+00, 1.46626e+00, 1.36912e+00, 1.31675e+00}
,
{1.03693e-03, 1.52163e-02, 7.55900e-02, 2.16434e-01, 4.57799e-01,
 8.00113e-01, 1.22996e+00, 1.72536e+00, 2.26274e+00, 2.82026e+00,
 3.37991e+00, 3.92798e+00, 4.45523e+00, 4.95598e+00, 5.42729e+00,
 5.86727e+00, 6.27577e+00, 6.65266e+00, 6.99879e+00, 7.31487e+00,
 7.60204e+00, 7.86155e+00, 8.09484e+00, 8.30382e+00, 8.49070e+00,
 8.65778e+00, 8.80719e+00, 8.94074e+00, 9.05991e+00, 9.16588e+00,
 9.25964e+00, 9.34202e+00, 9.41371e+00, 9.47535e+00, 9.52756e+00,
 9.57084e+00, 9.60576e+00, 9.63290e+00, 9.65294e+00, 9.66664e+00,
 9.67475e+00, 9.67790e+00, 9.67661e+00, 9.67125e+00, 9.66215e+00,
 9.64955e+00, 9.63364e+00, 9.61454e+00, 9.59229e+00, 9.56686e+00,
 9.53817e+00, 9.50610e+00, 9.47049e+00, 9.43122e+00, 9.38818e+00,
 9.34131e+00, 9.29054e+00, 9.23578e+00, 9.17691e+00, 9.11377e+00,
 9.04610e+00, 8.97366e+00, 8.89615e+00, 8.81324e+00, 8.72459e+00,
 8.62987e+00, 8.52872e+00, 8.42081e+00, 8.30585e+00, 8.18356e+00,
 8.05370e+00, 7.91598e+00, 7.77011e+00, 7.61579e+00, 7.45269e+00,
 7.28047e+00, 7.09882e+00, 6.90746e+00, 6.70614e+00, 6.49469e+00,
 6.27301e+00, 6.04112e+00, 5.79915e+00, 5.54740e+00, 5.28636e+00,
 5.01671e+00, 4.73937e+00, 4.45554e+00, 4.16673e+00, 3.87486e+00,
 3.58228e+00, 3.29190e+00, 3.00726e+00, 2.73262e+00, 2.47307e+00,
 2.23469e+00, 2.02464e+00, 1.85136e+00, 1.72472e+00, 1.65620e+00}
,
{1.44136e-03, 2.16555e-02, 1.06671e-01, 3.02622e-01, 6.34290e-01,
 1.09918e+00, 1.67624e+00, 2.33426e+00, 3.04100e+00, 3.76757e+00,
 4.49085e+00, 5.19400e+00, 5.86594e+00, 6.50087e+00, 7.09506e+00,
 7.64727e+00, 8.15723e+00, 8.62556e+00, 9.05330e+00, 9.44176e+00,
 9.79268e+00, 1.01078e+01, 1.03897e+01, 1.06412e+01, 1.08654e+01,
 1.10656e+01, 1.12441e+01, 1.14032e+01, 1.15446e+01, 1.16696e+01,
 1.17795e+01, 1.18752e+01, 1.19576e+01, 1.20276e+01, 1.20858e+01,
 1.21331e+01, 1.21703e+01, 1.21983e+01, 1.22183e+01, 1.22312e+01,
 1.22380e+01, 1.22392e+01, 1.22355e+01, 1.22272e+01, 1.22147e+01,
 1.21983e+01, 1.21781e+01, 1.21542e+01, 1.21264e+01, 1.20947e+01,
 1.20590e+01, 1.20191e+01, 1.19748e+01, 1.19262e+01, 1.18731e+01,
 1.18155e+01, 1.17532e+01, 1.16863e+01, 1.16143e+01, 1.15370e+01,
 1.14540e+01, 1.13650e+01, 1.12696e+01, 1.11672e+01, 1.10576e+01,
 1.09402e+01, 1.08148e+01, 1.06809e+01, 1.05383e+01, 1.03867e+01,
 1.02256e+01, 1.00547e+01, 9.87333e+00, 9.68115e+00, 9.47762e+00,
 9.26227e+00, 9.03462e+00, 8.79428e+00, 8.54090e+00, 8.27424e+00,
 7.99417e+00, 7.70071e+00, 7.39405e+00, 7.07455e+00, 6.74278e+00,
 6.39956e+00, 6.04598e+00, 5.68353e+00, 5.31410e+00, 4.94012e+00,
 4.56463e+00, 4.19138e+00, 3.82496e+00, 3.47090e+00, 3.13585e+00,
 2.82773e+00, 2.55587e+00, 2.33125e+00, 2.16671e+00, 2.07717e+00}
,
{2.00128e-03, 3.06895e-02, 1.49873e-01, 4.21348e-01, 8.75214e-01,
 1.50398e+00, 2.27555e+00, 3.14625e+00, 4.07229e+00, 5.01589e+00,
 5.94761e+00, 6.84707e+00, 7.70141e+00, 8.50437e+00, 9.25185e+00,
 9.94329e+00, 1.05785e+01, 1.11590e+01, 1.16862e+01, 1.21623e+01,
 1.25898e+01, 1.29716e+01, 1.33114e+01, 1.36138e+01, 1.38828e+01,
 1.41223e+01, 1.43354e+01, 1.45246e+01, 1.46918e+01, 1.48387e+01,
 1.49666e+01, 1.50769e+01, 1.51708e+01, 1.52491e+01, 1.53131e+01,
 1.53638e+01, 1.54027e+01, 1.54312e+01, 1.54507e+01, 1.54625e+01,
 1.54674e+01, 1.54661e+01, 1.54593e+01, 1.54474e+01, 1.54307e+01,
 1.54095e+01, 1.53838e+01, 1.53535e+01, 1.53186e+01, 1.52788e+01,
 1.52339e+01, 1.51839e+01, 1.51288e+01, 1.50686e+01, 1.50032e+01,
 1.49325e+01, 1.48563e+01, 1.47741e+01, 1.46858e+01, 1.45907e+01,
 1.44884e+01, 1.43784e+01, 1.42602e+01, 1.41332e+01, 1.39971e+01,
 1.38515e+01, 1.36960e+01, 1.35302e+01, 1.33536e+01, 1.31657e+01,
 1.29658e+01, 1.27533e+01, 1.25275e+01, 1.22877e+01, 1.20332e+01,
 1.17634e+01, 1.14775e+01, 1.11752e+01, 1.08559e+01, 1.05195e+01,
 1.01657e+01, 9.79456e+00, 9.40626e+00, 9.00115e+00, 8.57986e+00,
 8.14335e+00, 7.69298e+00, 7.23058e+00, 6.75858e+00, 6.28010e+00,
 5.79907e+00, 5.32033e+00, 4.84984e+00, 4.39478e+00, 3.96376e+00,
 3.56699e+00, 3.21653e+00, 2.92653e+00, 2.71352e+00, 2.59670e+00}
,
{2.78232e-03, 4.33044e-02, 2.09800e-01, 5.84429e-01, 1.20297e+00,
 2.05010e+00, 3.07792e+00, 4.22585e+00, 5.43512e+00, 6.65670e+00,
 7.85343e+00, 9.00087e+00, 1.00848e+01, 1.10978e+01, 1.20364e+01,
 1.29001e+01, 1.36897e+01, 1.44074e+01, 1.50556e+01, 1.56376e+01,
 1.61569e+01, 1.66184e+01, 1.70278e+01, 1.73911e+01, 1.77137e+01,
 1.80001e+01, 1.82540e+01, 1.84782e+01, 1.86752e+01, 1.88468e+01,
 1.89948e+01, 1.91208e+01, 1.92264e+01, 1.93130e+01, 1.93821e+01,
 1.94357e+01, 1.94758e+01, 1.95043e+01, 1.95230e+01, 1.95330e+01,
 1.95353e+01, 1.95307e+01, 1.95199e+01, 1.95034e+01, 1.94814e+01,
 1.94539e+01, 1.94209e+01, 1.93823e+01, 1.93377e+01, 1.92872e+01,
 1.92306e+01, 1.91681e+01, 1.90997e+01, 1.90253e+01, 1.89448e+01,
 1.88578e+01, 1.87639e+01, 1.86626e+01, 1.85534e+01, 1.84356e+01,
 1.83086e+01, 1.81718e+01, 1.80248e+01, 1.78670e+01, 1.76980e+01,
 1.75175e+01, 1.73248e+01, 1.71194e+01, 1.69004e+01, 1.66670e+01,
 1.64184e+01, 1.61535e+01, 1.58715e+01, 1.55713e+01, 1.52522e+01,
 1.49132e+01, 1.45536e+01, 1.41728e+01, 1.37704e+01, 1.33459e+01,
 1.28991e+01, 1.24298e+01, 1.19381e+01, 1.14244e+01, 1.08895e+01,
 1.03344e+01, 9.76094e+00, 9.17143e+00, 8.56903e+00, 7.95776e+00,
 7.34273e+00, 6.73023e+00, 6.12792e+00, 5.54504e+00, 4.99263e+00,
 4.48377e+00, 4.03391e+00, 3.66111e+00, 3.38645e+00, 3.23434e+00}
,
{3.86859e-03, 6.09216e-02, 2.92579e-01, 8.07604e-01, 1.64749e+00,
 2.78462e+00, 4.14899e+00, 5.65735e+00, 7.23155e+00, 8.80822e+00,
 1.03414e+01, 1.18017e+01, 1.31740e+01, 1.44494e+01, 1.56256e+01,
 1.67022e+01, 1.76818e+01, 1.85670e+01, 1.93621e+01, 2.00715e+01,
 2.07010e+01, 2.12581e+01, 2.17509e+01, 2.21873e+01, 2.25738e+01,
 2.29159e+01, 2.32176e+01, 2.34825e+01, 2.37134e+01, 2.39126e+01,
 2.40825e+01, 2.42250e+01, 2.43423e+01, 2.44365e+01, 2.45101e+01,
 2.45661e+01, 2.46070e+01, 2.46352e+01, 2.46523e+01, 2.46597e+01,
 2.46585e+01, 2.46496e+01, 2.46337e+01, 2.46111e+01, 2.45818e+01,
 2.45459e+01, 2.45030e+01, 2.44530e+01, 2.43958e+01, 2.43316e+01,
 2.42604e+01, 2.41824e+01, 2.40976e+01, 2.40055e+01, 2.39059e+01,
 2.37982e+01, 2.36818e+01, 2.35558e+01, 2.34197e+01, 2.32726e+01,
 2.31140e+01, 2.29433e+01, 2.27601e+01, 2.25639e+01, 2.23543e+01,
 2.21304e+01, 2.18913e+01, 2.16362e+01, 2.13637e+01, 2.10727e+01,
 2.07621e+01, 2.04306e+01, 2.00768e+01, 1.96998e+01, 1.92984e+01,
 1.88717e+01, 1.84188e+01, 1.79389e+01, 1.74314e+01, 1.68954e+01,
 1.63306e+01, 1.57366e+01, 1.51135e+01, 1.44616e+01, 1.37819e+01,
 1.30759e+01, 1.23458e+01, 1.15948e+01, 1.08269e+01, 1.00475e+01,
 9.26298e+00, 8.48155e+00, 7.71297e+00, 6.96905e+00, 6.26385e+00,
 5.61406e+00, 5.03926e+00, 4.56231e+00, 4.20975e+00, 4.01217e+00}
,
{5.37448e-03, 8.54388e-02, 4.06550e-01, 1.11216e+00, 2.24858e+00,
 3.76970e+00, 5.57491e+00, 7.55068e+00, 9.59389e+00, 1.16233e+01,
 1.35827e+01, 1.54375e+01, 1.71711e+01, 1.87740e+01, 2.02450e+01,
 2.15847e+01, 2.27972e+01, 2.38867e+01, 2.48595e+01, 2.57222e+01,
 2.64841e+01, 2.71560e+01, 2.77491e+01, 2.82730e+01, 2.87357e+01,
 2.91433e+01, 2.95009e+01, 2.98125e+01, 3.00815e+01, 3.03112e+01,
 3.05043e+01, 3.06637e+01, 3.07922e+01, 3.08933e+01, 3.09710e+01,
 3.10289e+01, 3.10702e+01, 3.10972e+01, 3.11118e+01, 3.11155e+01,
 3.11096e+01, 3.10950e+01, 3.10722e+01, 3.10412e+01, 3.10020e+01,
 3.09543e+01, 3.08979e+01, 3.08329e+01, 3.07596e+01, 3.06782e+01,
 3.05889e+01, 3.04916e+01, 3.03860e+01, 3.02714e+01, 3.01472e+01,
 3.00126e+01, 2.98667e+01, 2.97086e+01, 2.95376e+01, 2.93530e+01,
 2.91543e+01, 2.89412e+01, 2.87131e+01, 2.84692e+01, 2.82086e+01,
 2.79300e+01, 2.76321e+01, 2.73135e+01, 2.69727e+01, 2.66080e+01,
 2.62179e+01, 2.58008e+01, 2.53554e+01, 2.48805e+01, 2.43747e+01,
 2.38368e+01, 2.32656e+01, 2.26600e+01, 2.20186e+01, 2.13406e+01,
 2.06252e+01, 1.98719e+01, 1.90808e+01, 1.82525e+01, 1.73882e+01,
 1.64900e+01, 1.55610e+01, 1.46052e+01, 1.36280e+01, 1.26361e+01,
 1.16380e+01, 1.06440e+01, 9.66650e+00, 8.72064e+00, 7.82426e+00,
 6.99842e+00, 6.26773e+00, 5.66078e+00, 5.21051e+00, 4.95471e+00}
,
{7.45529e-03, 1.19410e-01, 5.63126e-01, 1.52648e+00, 3.05917e+00,
 5.08725e+00, 7.46840e+00, 1.00488e+01, 1.26935e+01, 1.52992e+01,
 1.77975e+01, 2.01491e+01, 2.23348e+01, 2.43462e+01, 2.61823e+01,
 2.78465e+01, 2.93439e+01, 3.06821e+01, 3.18694e+01, 3.29167e+01,
 3.38377e+01, 3.46479e+01, 3.53614e+01, 3.59899e+01, 3.65428e+01,
 3.70274e+01, 3.74496e+01, 3.78143e+01, 3.81259e+01, 3.83885e+01,
 3.86057e+01, 3.87816e+01, 3.89207e+01, 3.90284e+01, 3.91097e+01,
 3.91691e+01, 3.92098e+01, 3.92345e+01, 3.92453e+01, 3.92439e+01,
 3.92317e+01, 3.92091e+01, 3.91765e+01, 3.91337e+01, 3.90804e+01,
 3.90165e+01, 3.89423e+01, 3.88581e+01, 3.87645e+01, 3.86617e+01,
 3.85495e+01, 3.84274e+01, 3.82948e+01, 3.81507e+01, 3.79943e+01,
 3.78243e+01, 3.76397e+01, 3.74398e+01, 3.72241e+01, 3.69921e+01,
 3.67434e+01, 3.64772e+01, 3.61926e+01, 3.58883e+01, 3.55626e+01,
 3.52139e+01, 3.48403e+01, 3.44399e+01, 3.40107e+01, 3.35508e+01,
 3.30584e+01, 3.25319e+01, 3.19696e+01, 3.13699e+01, 3.07312e+01,
 3.00515e+01, 2.93291e+01, 2.85622e+01, 2.77492e+01, 2.68888e+01,
 2.59800e+01, 2.50225e+01, 2.40163e+01, 2.29625e+01, 2.18630e+01,
 2.07205e+01, 1.95392e+01, 1.83244e+01, 1.70829e+01, 1.58233e+01,
 1.45566e+01, 1.32960e+01, 1.20573e+01, 1.08598e+01, 9.72580e+00,
 8.68176e+00, 7.75824e+00, 6.99045e+00, 6.41870e+00, 6.08886e+00}
,
{1.03213e-02, 1.66319e-01, 7.77465e-01, 2.08854e+00, 4.14929e+00,
 6.84506e+00, 9.97680e+00, 1.33377e+01, 1.67521e+01, 2.00901e+01,
 2.32689e+01, 2.62453e+01, 2.89962e+01, 3.15158e+01, 3.38038e+01,
 3.58671e+01, 3.77131e+01, 3.93531e+01, 4.07993e+01, 4.20687e+01,
 4.31815e+01, 4.41581e+01, 4.50159e+01, 4.57691e+01, 4.64285e+01,
 4.70029e+01, 4.74992e+01, 4.79237e+01, 4.82821e+01, 4.85793e+01,
 4.88209e+01, 4.90128e+01, 4.91621e+01, 4.92759e+01, 4.93604e+01,
 4.94202e+01, 4.94590e+01, 4.94799e+01, 4.94853e+01, 4.94768e+01,
 4.94554e+01, 4.94214e+01, 4.93747e+01, 4.93150e+01, 4.92422e+01,
 4.91568e+01, 4.90597e+01, 4.89513e+01, 4.88320e+01, 4.87018e+01,
 4.85598e+01, 4.84052e+01, 4.82370e+01, 4.80538e+01, 4.78543e+01,
 4.76375e+01, 4.74026e+01, 4.71492e+01, 4.68769e+01, 4.65854e+01,
 4.62735e+01, 4.59400e+01, 4.55831e+01, 4.52007e+01, 4.47908e+01,
 4.43510e+01, 4.38788e+01, 4.33719e+01, 4.28281e+01, 4.22452e+01,
 4.16214e+01, 4.09547e+01, 4.02427e+01, 3.94831e+01, 3.86734e+01,
 3.78109e+01, 3.68932e+01, 3.59180e+01, 3.48833e+01, 3.37875e+01,
 3.26297e+01, 3.14096e+01, 3.01280e+01, 2.87864e+01, 2.73874e+01,
 2.59347e+01, 2.44337e+01, 2.28913e+01, 2.13165e+01, 1.97205e+01,
 1.81174e+01, 1.65241e+01, 1.49610e+01, 1.34519e+01, 1.20251e+01,
 1.07131e+01, 9.55327e+00, 8.58834e+00, 7.86684e+00, 7.44356e+00}
,
{1.42565e-02, 2.31072e-01, 1.07016e+00, 2.84907e+00, 5.61169e+00,
 9.18460e+00, 1.32923e+01, 1.76585e+01, 2.20561e+01, 2.63233e+01,
 3.03608e+01, 3.41209e+01, 3.75783e+01, 4.07290e+01, 4.35762e+01,
 4.61291e+01, 4.84006e+01, 5.04060e+01, 5.21647e+01, 5.37019e+01,
 5.50460e+01, 5.62228e+01, 5.72535e+01, 5.81546e+01, 5.89391e+01,
 5.96173e+01, 6.01979e+01, 6.06891e+01, 6.10975e+01, 6.14307e+01,
 6.16963e+01, 6.19037e+01, 6.20630e+01, 6.21825e+01, 6.22691e+01,
 6.23279e+01, 6.23632e+01, 6.23782e+01, 6.23756e+01, 6.23567e+01,
 6.23218e+01, 6.22710e+01, 6.22038e+01, 6.21205e+01, 6.20218e+01,
 6.19088e+01, 6.17824e+01, 6.16431e+01, 6.14907e+01, 6.13243e+01,
 6.11428e+01, 6.09448e+01, 6.07287e+01, 6.04930e+01, 6.02366e+01,
 5.99588e+01, 5.96594e+01, 5.93382e+01, 5.89945e+01, 5.86270e+01,
 5.82340e+01, 5.78131e+01, 5.73618e+01, 5.68774e+01, 5.63569e+01,
 5.57974e+01, 5.51961e+01, 5.45504e+01, 5.38582e+01, 5.31168e+01,
 5.23237e+01, 5.14759e+01, 5.05702e+01, 4.96030e+01, 4.85708e+01,
 4.74704e+01, 4.62986e+01, 4.50526e+01, 4.37302e+01, 4.23299e+01,
 4.08511e+01, 3.92940e+01, 3.76597e+01, 3.59505e+01, 3.41698e+01,
 3.23229e+01, 3.04167e+01, 2.84608e+01, 2.64668e+01, 2.44497e+01,
 2.24276e+01, 2.04221e+01, 1.84588e+01, 1.65677e+01, 1.47833e+01,
 1.31451e+01, 1.16984e+01, 1.04941e+01, 9.58973e+00, 9.04952e+00}
,
{1.96599e-02, 3.20177e-01, 1.46904e+00, 3.87541e+00, 7.56870e+00,
 1.22914e+01, 1.76651e+01, 2.33237e+01, 2.89751e+01, 3.44193e+01,
 3.95396e+01, 4.42817e+01, 4.86209e+01, 5.25546e+01, 5.60916e+01,
 5.92452e+01, 6.20348e+01, 6.44825e+01, 6.66183e+01, 6.84790e+01,
 7.01020e+01, 7.15193e+01, 7.27564e+01, 7.38323e+01, 7.47628e+01,
 7.55603e+01, 7.62358e+01, 7.67997e+01, 7.72612e+01, 7.76306e+01,
 7.79201e+01, 7.81431e+01, 7.83119e+01, 7.84361e+01, 7.85231e+01,
 7.85788e+01, 7.86081e+01, 7.86143e+01, 7.85997e+01, 7.85650e+01,
 7.85100e+01, 7.84344e+01, 7.83387e+01, 7.82238e+01, 7.80914e+01,
 7.79430e+01, 7.77790e+01, 7.75993e+01, 7.74028e+01, 7.71880e+01,
 7.69531e+01, 7.66963e+01, 7.64157e+01, 7.61102e+01, 7.57794e+01,
 7.54234e+01, 7.50421e+01, 7.46344e+01, 7.41987e+01, 7.37326e+01,
 7.32331e+01, 7.26970e+01, 7.21210e+01, 7.15013e+01, 7.08345e+01,
 7.01175e+01, 6.93473e+01, 6.85213e+01, 6.76365e+01, 6.66892e+01,
 6.56755e+01, 6.45911e+01, 6.34314e+01, 6.21917e+01, 6.08678e+01,
 5.94555e+01, 5.79511e+01, 5.63519e+01, 5.46558e+01, 5.28617e+01,
 5.09690e+01, 4.89784e+01, 4.68917e+01, 4.47121e+01, 4.24447e+01,
 4.00969e+01, 3.76785e+01, 3.52021e+01, 3.26836e+01, 3.01426e+01,
 2.76022e+01, 2.50898e+01, 2.26375e+01, 2.02817e+01, 1.80645e+01,
 1.60334e+01, 1.42418e+01, 1.27498e+01, 1.16241e+01, 1.09388e+01}
,
{2.71145e-02, 4.42373e-01, 2.01096e+00, 5.25746e+00, 1.01817e+01,
 1.64081e+01, 2.34211e+01, 3.07381e+01, 3.79858e+01, 4.49186e+01,
 5.14025e+01, 5.73740e+01, 6.28123e+01, 6.77166e+01, 7.21034e+01,
 7.59924e+01, 7.94119e+01, 8.23948e+01, 8.49863e+01, 8.72379e+01,
 8.91972e+01, 9.09030e+01, 9.23852e+01, 9.36670e+01, 9.47667e+01,
 9.57001e+01, 9.64814e+01, 9.71233e+01, 9.76395e+01, 9.80453e+01,
 9.83589e+01, 9.85973e+01, 9.87748e+01, 9.89019e+01, 9.89869e+01,
 9.90367e+01, 9.90564e+01, 9.90490e+01, 9.90159e+01, 9.89571e+01,
 9.88723e+01, 9.87619e+01, 9.86275e+01, 9.84715e+01, 9.82958e+01,
 9.81014e+01, 9.78879e+01, 9.76539e+01, 9.73978e+01, 9.71171e+01,
 9.68094e+01, 9.64728e+01, 9.61062e+01, 9.57097e+01, 9.52836e+01,
 9.48277e+01, 9.43408e+01, 9.38205e+01, 9.32638e+01, 9.26670e+01,
 9.20259e+01, 9.13362e+01, 9.05936e+01, 8.97939e+01, 8.89338e+01,
 8.80101e+01, 8.70194e+01, 8.59577e+01, 8.48203e+01, 8.36020e+01,
 8.22971e+01, 8.08996e+01, 7.94037e+01, 7.78038e+01, 7.60947e+01,
 7.42719e+01, 7.23319e+01, 7.02721e+01, 6.80905e+01, 6.57858e+01,
 6.33580e+01, 6.08085e+01, 5.81403e+01, 5.53586e+01, 5.24713e+01,
 4.94888e+01, 4.64250e+01, 4.32973e+01, 4.01267e+01, 3.69386e+01,
 3.37623e+01, 3.06321e+01, 2.75870e+01, 2.46715e+01, 2.19357e+01,
 1.94357e+01, 1.72338e+01, 1.53992e+01, 1.40082e+01, 1.31446e+01}
,
{3.73763e-02, 6.09502e-01, 2.74581e+00, 7.11399e+00, 1.36628e+01,
 2.18520e+01, 3.09833e+01, 4.04246e+01, 4.97019e+01, 5.85159e+01,
 6.67144e+01, 7.42241e+01, 8.10297e+01, 8.71367e+01, 9.25682e+01,
 9.73566e+01, 1.01540e+02, 1.05171e+02, 1.08314e+02, 1.11038e+02,
 1.13402e+02, 1.15453e+02, 1.17226e+02, 1.18748e+02, 1.20043e+02,
 1.21130e+02, 1.22026e+02, 1.22751e+02, 1.23323e+02, 1.23766e+02,
 1.24104e+02, 1.24357e+02, 1.24542e+02, 1.24669e+02, 1.24748e+02,
 1.24788e+02, 1.24792e+02, 1.24764e+02, 1.24702e+02, 1.24607e+02,
 1.24480e+02, 1.24322e+02, 1.24137e+02, 1.23928e+02, 1.23696e+02,
 1.23440e+02, 1.23160e+02, 1.22852e+02, 1.22514e+02, 1.22143e+02,
 1.21736e+02, 1.21293e+02, 1.20814e+02, 1.20301e+02, 1.19752e+02,
 1.19166e+02, 1.18541e+02, 1.17871e+02, 1.17152e+02, 1.16380e+02,
 1.15548e+02, 1.14652e+02, 1.13687e+02, 1.12649e+02, 1.11534e+02,
 1.10339e+02, 1.09057e+02, 1.07684e+02, 1.06211e+02, 1.04631e+02,
 1.02937e+02, 1.01122e+02, 9.91788e+01, 9.71004e+01, 9.48820e+01,
 9.25192e+01, 9.00084e+01, 8.73466e+01, 8.45318e+01, 8.15633e+01,
 7.84420e+01, 7.51711e+01, 7.17560e+01, 6.82054e+01, 6.45311e+01,
 6.07484e+01, 5.68768e+01, 5.29396e+01, 4.89644e+01, 4.49833e+01,
 4.10332e+01, 3.71562e+01, 3.33997e+01, 2.98165e+01, 2.64655e+01,
 2.34117e+01, 2.07265e+01, 1.84880e+01, 1.67817e+01, 1.57009e+01}
,
{5.14647e-02, 8.37945e-01, 3.74025e+00, 9.60290e+00, 1.82912e+01,
 2.90371e+01, 4.09011e+01, 5.30592e+01, 6.49137e+01, 7.61021e+01,
 8.64533e+01, 9.58869e+01, 1.04391e+02, 1.11985e+02, 1.18701e+02,
 1.24586e+02, 1.29698e+02, 1.34112e+02, 1.37923e+02, 1.41218e+02,
 1.44069e+02, 1.46531e+02, 1.48647e+02, 1.50449e+02, 1.51966e+02,
 1.53224e+02, 1.54245e+02, 1.55056e+02, 1.55685e+02, 1.56166e+02,
 1.56529e+02, 1.56795e+02, 1.56983e+02, 1.57106e+02, 1.57176e+02,
 1.57199e+02, 1.57179e+02, 1.57116e+02, 1.57011e+02, 1.56865e+02,
 1.56679e+02, 1.56459e+02, 1.56208e+02, 1.55929e+02, 1.55621e+02,
 1.55282e+02, 1.54910e+02, 1.54501e+02, 1.54050e+02, 1.53555e+02,
 1.53017e+02, 1.52435e+02, 1.51812e+02, 1.51146e+02, 1.50437e+02,
 1.49679e+02, 1.48867e+02, 1.47996e+02, 1.47059e+02, 1.46049e+02,
 1.44961e+02, 1.43788e+02, 1.42527e+02, 1.41173e+02, 1.39721e+02,
 1.38164e+02, 1.36494e+02, 1.34702e+02, 1.32778e+02, 1.30712e+02,
 1.28497e+02, 1.26122e+02, 1.23581e+02, 1.20867e+02, 1.17976e+02,
 1.14901e+02, 1.11640e+02, 1.08189e+02, 1.04546e+02, 1.00713e+02,
 9.66936e+01, 9.24930e+01, 8.81217e+01, 8.35935e+01, 7.89260e+01,
 7.41414e+01, 6.92659e+01, 6.43302e+01, 5.93699e+01, 5.44253e+01,
 4.95421e+01, 4.47713e+01, 4.01691e+01, 3.57975e+01, 3.17244e+01,
 2.80232e+01, 2.47739e+01, 2.20633e+01, 1.99854e+01, 1.92275e+01}
,
{7.07555e-02, 1.14939e+00, 5.08258e+00, 1.29328e+01, 2.44328e+01,
 3.85032e+01, 5.38857e+01, 6.95126e+01, 8.46350e+01, 9.88199e+01,
 1.11870e+02, 1.23706e+02, 1.34321e+02, 1.43750e+02, 1.52041e+02,
 1.59263e+02, 1.65500e+02, 1.70865e+02, 1.75485e+02, 1.79468e+02,
 1.82904e+02, 1.85855e+02, 1.88373e+02, 1.90499e+02, 1.92268e+02,
 1.93714e+02, 1.94867e+02, 1.95766e+02, 1.96455e+02, 1.96975e+02,
 1.97361e+02, 1.97638e+02, 1.97825e+02, 1.97939e+02, 1.97990e+02,
 1.97986e+02, 1.97927e+02, 1.97813e+02, 1.97644e+02, 1.97426e+02,
 1.97163e+02, 1.96861e+02, 1.96524e+02, 1.96151e+02, 1.95740e+02,
 1.95287e+02, 1.94788e+02, 1.94237e+02, 1.93633e+02, 1.92974e+02,
 1.92263e+02, 1.91501e+02, 1.90689e+02, 1.89824e+02, 1.88899e+02,
 1.87909e+02, 1.86846e+02, 1.85701e+02, 1.84466e+02, 1.83134e+02,
 1.81700e+02, 1.80158e+02, 1.78504e+02, 1.76729e+02, 1.74825e+02,
 1.72781e+02, 1.70585e+02, 1.68226e+02, 1.65691e+02, 1.62970e+02,
 1.60051e+02, 1.56927e+02, 1.53589e+02, 1.50032e+02, 1.46248e+02,
 1.42233e+02, 1.37982e+02, 1.33494e+02, 1.28769e+02, 1.23813e+02,
 1.18632e+02, 1.13239e+02, 1.07650e+02, 1.01887e+02, 9.59759e+01,
 8.99457e+01, 8.38320e+01, 7.76747e+01, 7.15188e+01, 6.54145e+01,
 5.94172e+01, 5.35874e+01, 4.79906e+01, 4.26979e+01, 3.77851e+01,
 3.33340e+01, 2.94322e+01, 2.71004e+01, 2.45090e+01, 2.27770e+01}
,
{9.71006e-02, 1.57281e+00, 6.89141e+00, 1.73789e+01, 3.25673e+01,
 5.09524e+01, 7.08591e+01, 9.09089e+01, 1.10170e+02, 1.28131e+02,
 1.44564e+02, 1.59396e+02, 1.72631e+02, 1.84321e+02, 1.94543e+02,
 2.03392e+02, 2.10994e+02, 2.17513e+02, 2.23111e+02, 2.27926e+02,
 2.32060e+02, 2.35590e+02, 2.38578e+02, 2.41075e+02, 2.43127e+02,
 2.44776e+02, 2.46068e+02, 2.47060e+02, 2.47810e+02, 2.48370e+02,
 2.48776e+02, 2.49057e+02, 2.49238e+02, 2.49333e+02, 2.49355e+02,
 2.49305e+02, 2.49185e+02, 2.48995e+02, 2.48738e+02, 2.48424e+02,
 2.48059e+02, 2.47650e+02, 2.47196e+02, 2.46695e+02, 2.46141e+02,
 2.45530e+02, 2.44855e+02, 2.44112e+02, 2.43302e+02, 2.42427e+02,
 2.41492e+02, 2.40495e+02, 2.39432e+02, 2.38298e+02, 2.37082e+02,
 2.35775e+02, 2.34368e+02, 2.32848e+02, 2.31210e+02, 2.29445e+02,
 2.27549e+02, 2.25514e+02, 2.23331e+02, 2.20987e+02, 2.18469e+02,
 2.15762e+02, 2.12850e+02, 2.09720e+02, 2.06356e+02, 2.02747e+02,
 1.98884e+02, 1.94756e+02, 1.90355e+02, 1.85674e+02, 1.80705e+02,
 1.75443e+02, 1.69888e+02, 1.64039e+02, 1.57904e+02, 1.51492e+02,
 1.44820e+02, 1.37908e+02, 1.30781e+02, 1.23471e+02, 1.16013e+02,
 1.08446e+02, 1.00819e+02, 9.31806e+01, 8.55881e+01, 7.81022e+01,
 7.07886e+01, 6.37173e+01, 5.69628e+01, 5.06039e+01, 4.47238e+01,
 4.08287e+01, 3.60752e+01, 3.20799e+01, 2.89556e+01, 2.68256e+01}
,
{1.32987e-01, 2.14721e+00, 9.32436e+00, 2.33051e+01, 4.33225e+01,
 6.72982e+01, 9.30118e+01, 1.18694e+02, 1.43191e+02, 1.65906e+02,
 1.86576e+02, 2.05141e+02, 2.21621e+02, 2.36098e+02, 2.48682e+02,
 2.59510e+02, 2.68770e+02, 2.76688e+02, 2.83472e+02, 2.89286e+02,
 2.94253e+02, 2.98466e+02, 3.02000e+02, 3.04920e+02, 3.07283e+02,
 3.09150e+02, 3.10588e+02, 3.11677e+02, 3.12492e+02, 3.13088e+02,
 3.13509e+02, 3.13789e+02, 3.13952e+02, 3.14016e+02, 3.13987e+02,
 3.13866e+02, 3.13654e+02, 3.13356e+02, 3.12980e+02, 3.12539e+02,
 3.12041e+02, 3.11487e+02, 3.10873e+02, 3.10195e+02, 3.09444e+02,
 3.08613e+02, 3.07696e+02, 3.06695e+02, 3.05615e+02, 3.04460e+02,
 3.03229e+02, 3.01918e+02, 3.00517e+02, 2.99016e+02, 2.97402e+02,
 2.95662e+02, 2.93782e+02, 2.91754e+02, 2.89571e+02, 2.87225e+02,
 2.84708e+02, 2.82006e+02, 2.79104e+02, 2.75983e+02, 2.72625e+02,
 2.69010e+02, 2.65121e+02, 2.60939e+02, 2.56452e+02, 2.51648e+02,
 2.46514e+02, 2.41041e+02, 2.35218e+02, 2.29036e+02, 2.22491e+02,
 2.15581e+02, 2.08309e+02, 2.00683e+02, 1.92720e+02, 1.84438e+02,
 1.75865e+02, 1.67032e+02, 1.57976e+02, 1.48742e+02, 1.39376e+02,
 1.29933e+02, 1.20473e+02, 1.11058e+02, 1.01758e+02, 9.26434e+01,
 8.37908e+01, 7.52787e+01, 6.71889e+01, 6.16986e+01, 5.45927e+01,
 4.81653e+01, 4.25187e+01, 3.77629e+01, 3.40179e+01, 3.14153e+01}
,
{1.81795e-01, 2.92595e+00, 1.25898e+01, 3.11896e+01, 5.75184e+01,
 8.87259e+01, 1.21884e+02, 1.54730e+02, 1.85845e+02, 2.14537e+02,
 2.40513e+02, 2.63720e+02, 2.84220e+02, 3.02124e+02, 3.17593e+02,
 3.30828e+02, 3.42104e+02, 3.51720e+02, 3.59937e+02, 3.66952e+02,
 3.72910e+02, 3.77924e+02, 3.82087e+02, 3.85483e+02, 3.88187e+02,
 3.90285e+02, 3.91877e+02, 3.93069e+02, 3.93948e+02, 3.94577e+02,
 3.95005e+02, 3.95272e+02, 3.95402e+02, 3.95411e+02, 3.95301e+02,
 3.95072e+02, 3.94728e+02, 3.94282e+02, 3.93749e+02, 3.93142e+02,
 3.92463e+02, 3.91711e+02, 3.90877e+02, 3.89952e+02, 3.88926e+02,
 3.87792e+02, 3.86551e+02, 3.85212e+02, 3.83779e+02, 3.82253e+02,
 3.80627e+02, 3.78891e+02, 3.77029e+02, 3.75025e+02, 3.72862e+02,
 3.70526e+02, 3.68004e+02, 3.65289e+02, 3.62373e+02, 3.59243e+02,
 3.55882e+02, 3.52269e+02, 3.48380e+02, 3.44192e+02, 3.39679e+02,
 3.34820e+02, 3.29594e+02, 3.23986e+02, 3.17980e+02, 3.11563e+02,
 3.04720e+02, 2.97440e+02, 2.89712e+02, 2.81530e+02, 2.72896e+02,
 2.63813e+02, 2.54297e+02, 2.44368e+02, 2.34053e+02, 2.23386e+02,
 2.12408e+02, 2.01166e+02, 1.89712e+02, 1.78106e+02, 1.66413e+02,
 1.54701e+02, 1.43045e+02, 1.31523e+02, 1.20213e+02, 1.09200e+02,
 9.85656e+01, 9.13853e+01, 8.16373e+01, 7.25117e+01, 6.41032e+01,
 5.65115e+01, 4.98434e+01, 4.42138e+01, 3.97488e+01, 3.65887e+01}
,
{2.48361e-01, 3.97950e+00, 1.69653e+01, 4.16617e+01, 7.62263e+01,
 1.16774e+02, 1.59461e+02, 2.01409e+02, 2.40882e+02, 2.77084e+02,
 3.09692e+02, 3.38676e+02, 3.64143e+02, 3.86260e+02, 4.05250e+02,
 4.21413e+02, 4.35139e+02, 4.46817e+02, 4.56764e+02, 4.65216e+02,
 4.72348e+02, 4.78297e+02, 4.83183e+02, 4.87108e+02, 4.90180e+02,
 4.92523e+02, 4.94279e+02, 4.95579e+02, 4.96518e+02, 4.97171e+02,
 4.97595e+02, 4.97832e+02, 4.97905e+02, 4.97823e+02, 4.97587e+02,
 4.97199e+02, 4.96673e+02, 4.96031e+02, 4.95291e+02, 4.94460e+02,
 4.93535e+02, 4.92508e+02, 4.91368e+02, 4.90099e+02, 4.88694e+02,
 4.87153e+02, 4.85487e+02, 4.83703e+02, 4.81804e+02, 4.79781e+02,
 4.77619e+02, 4.75301e+02, 4.72804e+02, 4.70107e+02, 4.67191e+02,
 4.64043e+02, 4.60654e+02, 4.57013e+02, 4.53103e+02, 4.48902e+02,
 4.44383e+02, 4.39514e+02, 4.34265e+02, 4.28606e+02, 4.22507e+02,
 4.15947e+02, 4.08904e+02, 4.01362e+02, 3.93303e+02, 3.84707e+02,
 3.75562e+02, 3.65855e+02, 3.55583e+02, 3.44746e+02, 3.33356e+02,
 3.21433e+02, 3.09006e+02, 2.96113e+02, 2.82799e+02, 2.69115e+02,
 2.55121e+02, 2.40885e+02, 2.26479e+02, 2.11982e+02, 1.97478e+02,
 1.83053e+02, 1.68797e+02, 1.54800e+02, 1.41153e+02, 1.32100e+02,
 1.19288e+02, 1.07068e+02, 9.55307e+01, 8.47689e+01, 7.48795e+01,
 6.59639e+01, 5.81312e+01, 5.15001e+01, 4.62029e+01, 4.23888e+01}
,
{3.39033e-01, 5.40164e+00, 2.28189e+01, 5.55478e+01, 1.00842e+02,
 1.53436e+02, 2.08307e+02, 2.61805e+02, 3.11828e+02, 3.57451e+02,
 3.98346e+02, 4.34510e+02, 4.66110e+02, 4.93395e+02, 5.16681e+02,
 5.36409e+02, 5.53115e+02, 5.67292e+02, 5.79325e+02, 5.89494e+02,
 5.98011e+02, 6.05047e+02, 6.10752e+02, 6.15262e+02, 6.18728e+02,
 6.21334e+02, 6.23264e+02, 6.24671e+02, 6.25665e+02, 6.26330e+02,
 6.26731e+02, 6.26911e+02, 6.26886e+02, 6.26660e+02, 6.26234e+02,
 6.25624e+02, 6.24855e+02, 6.23954e+02, 6.22936e+02, 6.21799e+02,
 6.20535e+02, 6.19127e+02, 6.17559e+02, 6.15816e+02, 6.13900e+02,
 6.11822e+02, 6.09597e+02, 6.07226e+02, 6.04701e+02, 6.02002e+02,
 5.99107e+02, 5.95986e+02, 5.92613e+02, 5.88963e+02, 5.85021e+02,
 5.80776e+02, 5.76214e+02, 5.71313e+02, 5.66043e+02, 5.60368e+02,
 5.54249e+02, 5.47646e+02, 5.40520e+02, 5.32837e+02, 5.24568e+02,
 5.15691e+02, 5.06181e+02, 4.96017e+02, 4.85176e+02, 4.73641e+02,
 4.61400e+02, 4.48450e+02, 4.34796e+02, 4.20458e+02, 4.05465e+02,
 3.89858e+02, 3.73687e+02, 3.57014e+02, 3.39906e+02, 3.22440e+02,
 3.04702e+02, 2.86784e+02, 2.68783e+02, 2.50801e+02, 2.32942e+02,
 2.15310e+02, 1.98007e+02, 1.81134e+02, 1.70314e+02, 1.54432e+02,
 1.39229e+02, 1.24798e+02, 1.11227e+02, 9.86109e+01, 8.70433e+01,
 7.66260e+01, 6.74682e+01, 5.96922e+01, 5.34361e+01, 4.88593e+01}
,
{4.62284e-01, 7.31759e+00, 3.06350e+01, 7.39314e+01, 1.33182e+02,
 2.01293e+02, 2.71718e+02, 3.39860e+02, 4.03186e+02, 4.60629e+02,
 5.11864e+02, 5.56942e+02, 5.96111e+02, 6.29730e+02, 6.58255e+02,
 6.82324e+02, 7.02654e+02, 7.19859e+02, 7.34401e+02, 7.46615e+02,
 7.56759e+02, 7.65050e+02, 7.71674e+02, 7.76823e+02, 7.80714e+02,
 7.83601e+02, 7.85715e+02, 7.87226e+02, 7.88261e+02, 7.88918e+02,
 7.89268e+02, 7.89346e+02, 7.89161e+02, 7.88716e+02, 7.88021e+02,
 7.87109e+02, 7.86018e+02, 7.84772e+02, 7.83375e+02, 7.81819e+02,
 7.80082e+02, 7.78144e+02, 7.75983e+02, 7.73599e+02, 7.71006e+02,
 7.68224e+02, 7.65259e+02, 7.62100e+02, 7.58724e+02, 7.55100e+02,
 7.51193e+02, 7.46965e+02, 7.42387e+02, 7.37439e+02, 7.32108e+02,
 7.26376e+02, 7.20215e+02, 7.13585e+02, 7.06439e+02, 6.98726e+02,
 6.90395e+02, 6.81395e+02, 6.71685e+02, 6.61231e+02, 6.50003e+02,
 6.37973e+02, 6.25112e+02, 6.11392e+02, 5.96793e+02, 5.81303e+02,
 5.64920e+02, 5.47659e+02, 5.29549e+02, 5.10633e+02, 4.90969e+02,
 4.70625e+02, 4.49682e+02, 4.28230e+02, 4.06371e+02, 3.84214e+02,
 3.61878e+02, 3.39483e+02, 3.17156e+02, 2.95022e+02, 2.73202e+02,
 2.51815e+02, 2.38412e+02, 2.18080e+02, 1.98457e+02, 1.79638e+02,
 1.61716e+02, 1.44776e+02, 1.28906e+02, 1.14193e+02, 1.00729e+02,
 8.86100e+01, 7.79469e+01, 6.88641e+01, 6.15064e+01, 5.60449e+01}
,
{6.29471e-01, 9.89706e+00, 4.10561e+01, 9.82329e+01, 1.75614e+02,
 2.63682e+02, 3.53945e+02, 4.40633e+02, 5.20724e+02, 5.92981e+02,
 6.57108e+02, 7.13242e+02, 7.61740e+02, 8.03113e+02, 8.38028e+02,
 8.67387e+02, 8.92124e+02, 9.12993e+02, 9.30545e+02, 9.45188e+02,
 9.57235e+02, 9.66962e+02, 9.74613e+02, 9.80454e+02, 9.84803e+02,
 9.87993e+02, 9.90293e+02, 9.91897e+02, 9.92954e+02, 9.93575e+02,
 9.93826e+02, 9.93733e+02, 9.93299e+02, 9.92533e+02, 9.91468e+02,
 9.90155e+02, 9.88635e+02, 9.86922e+02, 9.85007e+02, 9.82867e+02,
 9.80474e+02, 9.77799e+02, 9.74834e+02, 9.71598e+02, 9.68116e+02,
 9.64402e+02, 9.60446e+02, 9.56217e+02, 9.51675e+02, 9.46776e+02,
 9.41471e+02, 9.35721e+02, 9.29501e+02, 9.22794e+02, 9.15579e+02,
 9.07819e+02, 8.99460e+02, 8.90443e+02, 8.80700e+02, 8.70164e+02,
 8.58773e+02, 8.46473e+02, 8.33226e+02, 8.18991e+02, 8.03734e+02,
 7.87416e+02, 7.70004e+02, 7.51476e+02, 7.31819e+02, 7.11036e+02,
 6.89153e+02, 6.66214e+02, 6.42281e+02, 6.17434e+02, 5.91767e+02,
 5.65387e+02, 5.38416e+02, 5.10987e+02, 4.83243e+02, 4.55334e+02,
 4.27416e+02, 3.99643e+02, 3.72168e+02, 3.45136e+02, 3.28530e+02,
 3.02675e+02, 2.77592e+02, 2.53390e+02, 2.30165e+02, 2.08009e+02,
 1.87005e+02, 1.67232e+02, 1.48767e+02, 1.31688e+02, 1.16081e+02,
 1.02037e+02, 8.96656e+01, 7.90936e+01, 7.04741e+01, 6.39917e+01}
,
{8.55787e-01, 1.33640e+01, 5.49301e+01, 1.30310e+02, 2.31208e+02,
 3.44916e+02, 4.60450e+02, 5.70608e+02, 6.71802e+02, 7.62624e+02,
 8.42812e+02, 9.12642e+02, 9.72631e+02, 1.02349e+03, 1.06620e+03,
 1.10201e+03, 1.13210e+03, 1.15739e+03, 1.17855e+03, 1.19606e+03,
 1.21032e+03, 1.22168e+03, 1.23047e+03, 1.23706e+03, 1.24191e+03,
 1.24542e+03, 1.24790e+03, 1.24958e+03, 1.25063e+03, 1.25116e+03,
 1.25124e+03, 1.25087e+03, 1.25007e+03, 1.24885e+03, 1.24729e+03,
 1.24544e+03, 1.24335e+03, 1.24100e+03, 1.23836e+03, 1.23541e+03,
 1.23211e+03, 1.22843e+03, 1.22439e+03, 1.22003e+03, 1.21538e+03,
 1.21042e+03, 1.20512e+03, 1.19942e+03, 1.19328e+03, 1.18662e+03,
 1.17939e+03, 1.17156e+03, 1.16312e+03, 1.15402e+03, 1.14424e+03,
 1.13369e+03, 1.12229e+03, 1.10997e+03, 1.09663e+03, 1.08219e+03,
 1.06659e+03, 1.04977e+03, 1.03169e+03, 1.01230e+03, 9.91560e+02,
 9.69419e+02, 9.45854e+02, 9.20853e+02, 8.94431e+02, 8.66624e+02,
 8.37501e+02, 8.07149e+02, 7.75677e+02, 7.43214e+02, 7.09905e+02,
 6.75911e+02, 6.41408e+02, 6.06585e+02, 5.71635e+02, 5.36755e+02,
 5.02139e+02, 4.67974e+02, 4.34435e+02, 4.14474e+02, 3.82527e+02,
 3.51578e+02, 3.21743e+02, 2.93123e+02, 2.65808e+02, 2.39874e+02,
 2.15390e+02, 1.92422e+02, 1.71032e+02, 1.51286e+02, 1.33259e+02,
 1.17038e+02, 1.02729e+02, 9.04632e+01, 8.04021e+01, 7.27473e+01}
,
{1.16152e+00, 1.80150e+01, 7.33714e+01, 1.72592e+02, 3.03959e+02,
 4.50563e+02, 5.98260e+02, 7.38095e+02, 8.65835e+02, 9.79893e+02,
 1.08009e+03, 1.16687e+03, 1.24098e+03, 1.30345e+03, 1.35567e+03,
 1.39933e+03, 1.43593e+03, 1.46656e+03, 1.49203e+03, 1.51292e+03,
 1.52974e+03, 1.54294e+03, 1.55297e+03, 1.56038e+03, 1.56576e+03,
 1.56960e+03, 1.57226e+03, 1.57398e+03, 1.57497e+03, 1.57534e+03,
 1.57513e+03, 1.57434e+03, 1.57300e+03, 1.57117e+03, 1.56895e+03,
 1.56640e+03, 1.56352e+03, 1.56028e+03, 1.55666e+03, 1.55258e+03,
 1.54802e+03, 1.54300e+03, 1.53755e+03, 1.53171e+03, 1.52549e+03,
 1.51884e+03, 1.51170e+03, 1.50399e+03, 1.49563e+03, 1.48655e+03,
 1.47670e+03, 1.46606e+03, 1.45460e+03, 1.44225e+03, 1.42892e+03,
 1.41451e+03, 1.39891e+03, 1.38201e+03, 1.36369e+03, 1.34388e+03,
 1.32252e+03, 1.29953e+03, 1.27487e+03, 1.24846e+03, 1.22027e+03,
 1.19025e+03, 1.15841e+03, 1.12476e+03, 1.08936e+03, 1.05232e+03,
 1.01375e+03, 9.73812e+02, 9.32668e+02, 8.90518e+02, 8.47579e+02,
 8.04084e+02, 7.60279e+02, 7.16415e+02, 6.72744e+02, 6.29510e+02,
 5.86943e+02, 5.61863e+02, 5.21180e+02, 4.81654e+02, 4.43434e+02,
 4.06643e+02, 3.71387e+02, 3.37752e+02, 3.05806e+02, 2.75606e+02,
 2.47200e+02, 2.20632e+02, 1.95947e+02, 1.73194e+02, 1.52437e+02,
 1.33754e+02, 1.17251e+02, 1.03060e+02, 9.13568e+01, 8.23621e+01}
,
{1.57376e+00, 2.42437e+01, 9.78494e+01, 2.28252e+02, 3.99037e+02,
 5.87803e+02, 7.76396e+02, 9.53731e+02, 1.11483e+03, 1.25796e+03,
 1.38305e+03, 1.49079e+03, 1.58226e+03, 1.65891e+03, 1.72274e+03,
 1.77599e+03, 1.82047e+03, 1.85753e+03, 1.88812e+03, 1.91298e+03,
 1.93275e+03, 1.94800e+03, 1.95939e+03, 1.96769e+03, 1.97365e+03,
 1.97783e+03, 1.98062e+03, 1.98235e+03, 1.98321e+03, 1.98329e+03,
 1.98262e+03, 1.98121e+03, 1.97913e+03, 1.97648e+03, 1.97338e+03,
 1.96986e+03, 1.96591e+03, 1.96146e+03, 1.95645e+03, 1.95082e+03,
 1.94458e+03, 1.93777e+03, 1.93047e+03, 1.92267e+03, 1.91433e+03,
 1.90538e+03, 1.89571e+03, 1.88522e+03, 1.87381e+03, 1.86142e+03,
 1.84802e+03, 1.83357e+03, 1.81798e+03, 1.80115e+03, 1.78294e+03,
 1.76320e+03, 1.74177e+03, 1.71854e+03, 1.69338e+03, 1.66623e+03,
 1.63699e+03, 1.60559e+03, 1.57196e+03, 1.53602e+03, 1.49776e+03,
 1.45715e+03, 1.41425e+03, 1.36914e+03, 1.32196e+03, 1.27288e+03,
 1.22210e+03, 1.16987e+03, 1.11643e+03, 1.06209e+03, 1.00715e+03,
 9.51938e+02, 8.96774e+02, 8.41984e+02, 7.87874e+02, 7.34732e+02,
 7.04189e+02, 6.53656e+02, 6.04673e+02, 5.57407e+02, 5.11993e+02,
 4.68539e+02, 4.27126e+02, 3.87812e+02, 3.50637e+02, 3.15627e+02,
 2.82803e+02, 2.52182e+02, 2.23785e+02, 1.97642e+02, 1.73803e+02,
 1.52339e+02, 1.33350e+02, 1.16977e+02, 1.03409e+02, 9.28889e+01}
,
{2.13004e+00, 3.25788e+01, 1.30300e+02, 3.01427e+02, 5.23152e+02,
 7.65900e+02, 1.00644e+03, 1.23114e+03, 1.43413e+03, 1.61359e+03,
 1.76962e+03, 1.90327e+03, 2.01606e+03, 2.11005e+03, 2.18806e+03,
 2.25297e+03, 2.30702e+03, 2.35180e+03, 2.38847e+03, 2.41797e+03,
 2.44108e+03, 2.45862e+03, 2.47150e+03, 2.48077e+03, 2.48734e+03,
 2.49184e+03, 2.49474e+03, 2.49639e+03, 2.49698e+03, 2.49660e+03,
 2.49523e+03, 2.49293e+03, 2.48984e+03, 2.48612e+03, 2.48184e+03,
 2.47701e+03, 2.47156e+03, 2.46543e+03, 2.45851e+03, 2.45078e+03,
 2.44230e+03, 2.43316e+03, 2.42338e+03, 2.41294e+03, 2.40172e+03,
 2.38961e+03, 2.37646e+03, 2.36215e+03, 2.34659e+03, 2.32972e+03,
 2.31151e+03, 2.29185e+03, 2.27060e+03, 2.24759e+03, 2.22261e+03,
 2.19548e+03, 2.16601e+03, 2.13408e+03, 2.09957e+03, 2.06238e+03,
 2.02241e+03, 1.97956e+03, 1.93375e+03, 1.88494e+03, 1.83314e+03,
 1.77840e+03, 1.72087e+03, 1.66072e+03, 1.59819e+03, 1.53356e+03,
 1.46715e+03, 1.39931e+03, 1.33043e+03, 1.26091e+03, 1.19119e+03,
 1.12168e+03, 1.05280e+03, 9.84945e+02, 9.45829e+02, 8.81092e+02,
 8.18197e+02, 7.57377e+02, 6.98821e+02, 6.42679e+02, 5.89058e+02,
 5.38033e+02, 4.89646e+02, 4.43916e+02, 4.00842e+02, 3.60414e+02,
 3.22613e+02, 2.87426e+02, 2.54846e+02, 2.24881e+02, 1.97564e+02,
 1.72956e+02, 1.51157e+02, 1.32314e+02, 1.16633e+02, 1.04384e+02}
,
{2.88056e+00, 4.37179e+01, 1.73260e+02, 3.97512e+02, 6.84987e+02,
 9.96767e+02, 1.30325e+03, 1.58770e+03, 1.84330e+03, 2.06812e+03,
 2.26260e+03, 2.42823e+03, 2.56716e+03, 2.68236e+03, 2.77770e+03,
 2.85681e+03, 2.92243e+03, 2.97645e+03, 3.02032e+03, 3.05520e+03,
 3.08211e+03, 3.10217e+03, 3.11669e+03, 3.12702e+03, 3.13422e+03,
 3.13900e+03, 3.14194e+03, 3.14339e+03, 3.14353e+03, 3.14239e+03,
 3.14000e+03, 3.13649e+03, 3.13207e+03, 3.12689e+03, 3.12102e+03,
 3.11438e+03, 3.10689e+03, 3.09841e+03, 3.08889e+03, 3.07836e+03,
 3.06694e+03, 3.05471e+03, 3.04163e+03, 3.02759e+03, 3.01243e+03,
 2.99598e+03, 2.97805e+03, 2.95852e+03, 2.93732e+03, 2.91439e+03,
 2.88962e+03, 2.86282e+03, 2.83377e+03, 2.80220e+03, 2.76787e+03,
 2.73054e+03, 2.69003e+03, 2.64621e+03, 2.59893e+03, 2.54806e+03,
 2.49348e+03, 2.43510e+03, 2.37284e+03, 2.30675e+03, 2.23690e+03,
 2.16348e+03, 2.08675e+03, 2.00703e+03, 1.92470e+03, 1.84017e+03,
 1.75394e+03, 1.66650e+03, 1.57841e+03, 1.49022e+03, 1.40248e+03,
 1.31574e+03, 1.23047e+03, 1.18212e+03, 1.10118e+03, 1.02273e+03,
 9.47054e+02, 8.74368e+02, 8.04834e+02, 7.38560e+02, 6.75608e+02,
 6.16002e+02, 5.59729e+02, 5.06756e+02, 4.57031e+02, 4.10495e+02,
 3.67088e+02, 3.26755e+02, 2.89460e+02, 2.55184e+02, 2.23942e+02,
 1.95785e+02, 1.70812e+02, 1.49178e+02, 1.31109e+02, 1.16909e+02}
,
{3.89154e+00, 5.85811e+01, 2.30059e+02, 5.23530e+02, 8.95771e+02,
 1.29576e+03, 1.68585e+03, 2.04568e+03, 2.36726e+03, 2.64871e+03,
 2.89091e+03, 3.09600e+03, 3.26698e+03, 3.40812e+03, 3.52461e+03,
 3.62101e+03, 3.70059e+03, 3.76568e+03, 3.81801e+03, 3.85910e+03,
 3.89029e+03, 3.91313e+03, 3.92946e+03, 3.94093e+03, 3.94875e+03,
 3.95376e+03, 3.95662e+03, 3.95768e+03, 3.95706e+03, 3.95479e+03,
 3.95096e+03, 3.94582e+03, 3.93962e+03, 3.93250e+03, 3.92443e+03,
 3.91531e+03, 3.90498e+03, 3.89330e+03, 3.88028e+03, 3.86606e+03,
 3.85077e+03, 3.83441e+03, 3.81686e+03, 3.79792e+03, 3.77736e+03,
 3.75494e+03, 3.73047e+03, 3.70386e+03, 3.67504e+03, 3.64387e+03,
 3.61011e+03, 3.57349e+03, 3.53365e+03, 3.49027e+03, 3.44304e+03,
 3.39171e+03, 3.33611e+03, 3.27606e+03, 3.21139e+03, 3.14192e+03,
 3.06754e+03, 2.98818e+03, 2.90386e+03, 2.81473e+03, 2.72104e+03,
 2.62314e+03, 2.52146e+03, 2.41650e+03, 2.30883e+03, 2.19910e+03,
 2.08798e+03, 1.97620e+03, 1.86449e+03, 1.75357e+03, 1.64413e+03,
 1.53679e+03, 1.47673e+03, 1.37532e+03, 1.27726e+03, 1.18290e+03,
 1.09248e+03, 1.00618e+03, 9.24102e+02, 8.46299e+02, 7.72762e+02,
 7.03442e+02, 6.38259e+02, 5.77111e+02, 5.19884e+02, 4.66463e+02,
 4.16734e+02, 3.70601e+02, 3.27987e+02, 2.88849e+02, 2.53179e+02,
 2.21018e+02, 1.92464e+02, 1.67684e+02, 1.46925e+02, 1.30528e+02}
,
{   5.25114,   78.3834 ,  305.076  ,  688.619  , 1170.03   , 1682.61   ,
 2178.66   , 2633.46   , 3037.8    , 3389.87   , 3691.25   , 3944.96   ,
 4155.23   , 4328.11   , 4470.45   , 4587.85   , 4684.27   , 4762.54   ,
 4824.84   , 4873.04   , 4909.     , 4934.92   , 4953.24   , 4965.91   ,
 4974.31   , 4979.47   , 4982.06   , 4982.42   , 4980.62   , 4976.7    ,
 4970.89   , 4963.57   , 4955.     , 4945.24   , 4934.17   , 4921.62   ,
 4907.37   , 4891.36   , 4873.72   , 4854.65   , 4834.21   , 4812.29   ,
 4788.66   , 4763.01   , 4735.03   , 4704.45   , 4671.11   , 4634.94   ,
 4595.77   , 4553.33   , 4507.23   , 4457.04   , 4402.32   , 4342.66   ,
 4277.73   , 4207.29   , 4131.11   , 4048.97   , 3960.65   , 3865.97   ,
 3764.87   , 3657.39   , 3543.7    , 3424.17   , 3299.24   , 3169.52   ,
 3035.66   , 2898.44   , 2758.71   , 2617.37   , 2475.37   , 2333.68   ,
 2193.24   , 2054.93   , 1975.96   , 1844.62   , 1717.29   , 1594.46   ,
 1476.53   , 1363.79   , 1256.44   , 1154.58   , 1058.22   ,  967.323  ,
  881.79   ,  801.481  ,  726.23   ,  655.852  ,  590.161  ,  528.97   ,
  472.11   ,  419.433  ,  370.823  ,  326.2    ,  285.537  ,  248.864  ,
  216.278  ,  187.956  ,  164.173  ,  145.312  }
,
{   7.07665,  104.743  ,  404.03   ,  904.653  , 1526.52   , 2182.66   ,
 2812.88   , 3387.31   , 3895.36   , 4335.5    , 4710.2    , 5023.78   ,
 5282.21   , 5493.94   , 5667.81   , 5810.72   , 5927.42   , 6021.34   ,
 6095.26   , 6151.58   , 6192.86   , 6222.2    , 6242.69   , 6256.59   ,
 6265.52   , 6270.64   , 6272.68   , 6271.88   , 6268.28   , 6262.03   ,
 6253.58   , 6243.36   , 6231.6    , 6218.23   , 6203.04   , 6185.75   ,
 6166.17   , 6144.39   , 6120.67   , 6095.18   , 6067.84   , 6038.4    ,
 6006.46   , 5971.62   , 5933.48   , 5891.82   , 5846.52   , 5797.39   ,
 5744.11   , 5686.2    , 5623.09   , 5554.2    , 5478.98   , 5397.     ,
 5307.91   , 5211.43   , 5107.25   , 4995.1    , 4874.74   , 4746.09   ,
 4609.17   , 4464.27   , 4311.82   , 4152.46   , 3986.97   , 3816.23   ,
 3641.28   , 3463.24   , 3283.31   , 3102.76   , 2922.84   , 2744.78   ,
 2569.72   , 2470.34   , 2304.76   , 2144.57   , 1990.38   , 1842.67   ,
 1701.79   , 1567.95   , 1441.22   , 1321.61   , 1209.01   , 1103.25   ,
 1004.13   ,  911.389  ,  824.756  ,  743.952  ,  668.7    ,  598.738  ,
  533.83   ,  473.769  ,  418.392  ,  367.586  ,  321.3    ,  279.549  ,
  242.427  ,  210.128  ,  182.955  ,  161.337  }
,
{   9.52382,  139.798  ,  534.408  , 1187.06   , 1989.45   , 2828.54   ,
 3628.5    , 4353.52   , 4991.45   , 5541.31   , 6006.81   , 6394.06   ,
 6711.51   , 6970.79   , 7183.16   , 7356.98   , 7498.03   , 7610.5    ,
 7697.92   , 7763.45   , 7810.65   , 7843.8    , 7866.62   , 7881.74   ,
 7891.07   , 7895.91   , 7896.93   , 7894.3    , 7888.07   , 7878.64   ,
 7866.66   , 7852.58   , 7836.48   , 7818.16   , 7797.28   , 7773.51   ,
 7746.78   , 7717.39   , 7685.67   , 7651.62   , 7614.98   , 7575.28   ,
 7531.99   , 7484.56   , 7432.62   , 7376.01   , 7314.51   , 7247.76   ,
 7175.16   , 7095.97   , 7009.44   , 6914.82   , 6811.5    , 6699.05   ,
 6577.08   , 6445.19   , 6303.     , 6150.22   , 5986.69   , 5812.5    ,
 5627.96   , 5433.67   , 5230.49   , 5019.41   , 4801.65   , 4578.54   ,
 4351.59   , 4122.4    , 3892.62   , 3663.91   , 3437.87   , 3215.99   ,
 3090.45   , 2881.32   , 2679.39   , 2485.43   , 2300.03   , 2123.57   ,
 1956.29   , 1798.25   , 1649.41   , 1509.58   , 1378.53   , 1255.92   ,
 1141.4    , 1034.59   ,  935.079  ,  842.485  ,  756.428  ,  676.56   ,
  602.562  ,  534.17   ,  471.163  ,  413.394  ,  360.778  ,  313.315  ,
  271.103  ,  234.347  ,  203.38   ,  178.686  }
,
{  12.7993,  186.357 ,  706.02  , 1555.85  , 2590.04  , 3662.01  ,
 4676.68  , 5591.11  , 6391.62  , 7078.07  , 7655.98  , 8133.8   ,
 8523.61  , 8841.09  , 9100.4   , 9311.65  , 9481.86  , 9616.25  ,
 9719.28  , 9795.17  , 9848.99  , 9886.34  , 9911.64  , 9927.92  ,
 9937.43  , 9941.57  , 9940.88  , 9935.45  , 9925.52  , 9911.82  ,
 9895.15  , 9875.87  , 9853.85  , 9828.73  , 9800.04  , 9767.47  ,
 9731.27  , 9691.9   , 9649.56  , 9604.03  , 9554.76  , 9501.08  ,
 9442.25  , 9377.69  , 9307.12  , 9230.32  , 9146.86  , 9056.03  ,
 8956.9   , 8848.45  , 8729.71  , 8599.83  , 8458.2   , 8304.3   ,
 8137.64  , 7957.7   , 7764.07  , 7556.55  , 7335.21  , 7100.45  ,
 6853.08  , 6594.17  , 6325.08  , 6047.38  , 5762.86  , 5473.5   ,
 5181.4   , 4888.76  , 4597.76  , 4310.49  , 4028.87  , 3869.71  ,
 3605.12  , 3350.11  , 3105.62  , 2872.38  , 2650.85  , 2441.28  ,
 2243.72  , 2058.03  , 1883.96  , 1721.14  , 1569.12  , 1427.39  ,
 1295.42  , 1172.66  , 1058.58  ,  952.643 ,  854.365 ,  763.301 ,
  679.038 ,  601.246 ,  529.645 ,  464.035 ,  404.303 ,  350.431 ,
  302.512 ,  260.768 ,  225.565 ,  197.446 }
,
{   17.1796,   248.115 ,   931.665 ,  2036.97  ,  3368.52  ,  4736.77  ,
  6022.81  ,  7175.36  ,  8179.23  ,  9035.66  ,  9752.57  , 10341.8   ,
 10820.3   , 11209.    , 11525.5   , 11782.    , 11987.    , 12147.2   ,
 12268.2   , 12355.7   , 12416.9   , 12458.9   , 12486.7   , 12504.1   ,
 12513.4   , 12516.2   , 12512.7   , 12503.2   , 12488.2   , 12468.8   ,
 12445.9   , 12419.5   , 12389.4   , 12355.    , 12315.6   , 12271.3   ,
 12222.7   , 12170.1   , 12113.6   , 12052.6   , 11986.1   , 11913.3   ,
 11833.3   , 11745.6   , 11649.9   , 11545.8   , 11432.4   , 11308.6   ,
 11173.1   , 11024.4   , 10861.5   , 10683.6   , 10489.9   , 10279.7   ,
 10052.4   ,  9807.5   ,  9544.59  ,  9263.76  ,  8965.52  ,  8650.87  ,
  8321.24  ,  7978.38  ,  7624.38  ,  7261.58  ,  6892.59  ,  6520.2   ,
  6147.28  ,  5776.7   ,  5411.21  ,  5053.33  ,  4850.85  ,  4515.55  ,
  4192.9   ,  3884.11  ,  3590.06  ,  3311.32  ,  3048.15  ,  2800.56  ,
  2568.32  ,  2351.06  ,  2148.25  ,  1959.26  ,  1783.41  ,  1619.96  ,
  1468.2   ,  1327.36  ,  1196.77  ,  1075.72  ,   963.628 ,   859.907 ,
   764.062 ,   675.67  ,   594.387 ,   519.961 ,   452.239 ,   391.181 ,
   336.877 ,   289.561 ,   249.639 ,   217.715 }
,
{   23.0415,   329.947 ,  1228.04  ,  2664.05  ,  4376.75  ,  6121.62  ,
  7750.5   ,  9202.21  , 10460.4   , 11528.1   , 12416.8   , 13142.8   ,
 13730.1   , 14205.9   , 14592.1   , 14903.2   , 15149.8   , 15340.2   ,
 15481.6   , 15582.3   , 15651.7   , 15698.7   , 15729.1   , 15747.2   ,
 15755.8   , 15756.2   , 15748.6   , 15733.2   , 15711.4   , 15684.4   ,
 15653.1   , 15617.1   , 15576.    , 15528.7   , 15474.9   , 15415.2   ,
 15350.1   , 15280.1   , 15204.6   , 15122.5   , 15032.6   , 14933.8   ,
 14825.1   , 14706.2   , 14576.7   , 14435.5   , 14281.2   , 14112.1   ,
 13926.5   , 13722.9   , 13499.8   , 13256.5   , 12992.1   , 12705.7   ,
 12396.5   , 12064.1   , 11708.4   , 11330.    , 10930.3   , 10511.    ,
 10074.5   ,  9623.47  ,  9160.97  ,  8690.43  ,  8215.54  ,  7740.08  ,
  7267.82  ,  6802.37  ,  6347.01  ,  6088.63  ,  5663.04  ,  5254.09  ,
  4863.33  ,  4491.85  ,  4140.34  ,  3809.08  ,  3498.02  ,  3206.82  ,
  2934.94  ,  2681.63  ,  2446.06  ,  2227.29  ,  2024.34  ,  1836.23  ,
  1661.98  ,  1500.64  ,  1351.32  ,  1213.18  ,  1085.45  ,   967.423 ,
   858.503 ,   758.165 ,   665.988 ,   581.658 ,   504.976 ,   435.875 ,
   374.437 ,   320.911 ,   275.739 ,   239.594 }
,
{   30.8776,   438.305 ,  1616.95  ,  3480.61  ,  5681.44  ,  7904.71  ,
  9966.41  , 11793.9   , 13369.8   , 14700.1   , 15800.9   , 16695.    ,
 17415.7   , 17998.2   , 18468.9   , 18845.9   , 19141.9   , 19367.5   ,
 19532.2   , 19647.6   , 19726.3   , 19778.7   , 19811.5   , 19830.    ,
 19836.9   , 19833.3   , 19819.5   , 19796.1   , 19765.1   , 19728.1   ,
 19685.4   , 19636.4   , 19580.    , 19515.3   , 19442.4   , 19362.3   ,
 19275.7   , 19182.3   , 19081.    , 18970.3   , 18848.6   , 18714.4   ,
 18567.1   , 18406.3   , 18230.8   , 18039.    , 17828.8   , 17597.7   ,
 17343.7   , 17064.9   , 16760.2   , 16428.4   , 16068.2   , 15678.7   ,
 15259.2   , 14809.5   , 14330.4   , 13823.3   , 13290.6   , 12735.4   ,
 12161.    , 11571.6   , 10971.7   , 10366.    ,  9759.53  ,  9157.29  ,
  8564.    ,  8213.5   ,  7653.31  ,  7112.3   ,  6593.08  ,  6097.65  ,
  5627.4   ,  5183.14  ,  4765.21  ,  4373.45  ,  4007.4   ,  3666.26  ,
  3349.05  ,  3054.61  ,  2781.69  ,  2528.99  ,  2295.22  ,  2079.05  ,
  1879.27  ,  1694.65  ,  1524.1   ,  1366.58  ,  1221.16  ,  1086.98  ,
   963.309 ,   849.52  ,   745.098 ,   649.655 ,   562.939 ,   484.85  ,
   415.454 ,   355.014 ,   304.012 ,   263.194 }
,
{   41.3396,   581.631 ,  2126.78  ,  4542.97  ,  7368.39  , 10199.1   ,
 12806.8   , 15106.1   , 17078.8   , 18735.2   , 20097.6   , 21198.3   ,
 22082.7   , 22795.5   , 23369.1   , 23825.2   , 24179.8   , 24446.1   ,
 24637.3   , 24769.2   , 24858.2   , 24916.1   , 24951.3   , 24969.3   ,
 24973.1   , 24963.4   , 24940.6   , 24906.4   , 24863.4   , 24812.8   ,
 24754.7   , 24687.7   , 24610.6   , 24522.5   , 24424.4   , 24317.5   ,
 24202.2   , 24077.4   , 23941.3   , 23791.7   , 23626.6   , 23444.8   ,
 23245.7   , 23028.2   , 22790.3   , 22529.5   , 22242.6   , 21926.7   ,
 21579.3   , 21198.7   , 20783.3   , 20331.5   , 19842.    , 19313.8   ,
 18746.4   , 18140.7   , 17498.4   , 16822.6   , 16117.    , 15386.2   ,
 14635.5   , 13870.7   , 13098.2   , 12324.4   , 11556.    , 10799.1   ,
 10349.    ,  9635.23  ,  8946.49  ,  8286.19  ,  7656.91  ,  7060.42  ,
  6497.75  ,  5969.25  ,  5474.69  ,  5013.38  ,  4584.23  ,  4185.91  ,
  3816.87  ,  3475.45  ,  3159.93  ,  2868.59  ,  2599.7   ,  2351.62  ,
  2122.79  ,  1911.75  ,  1717.12  ,  1537.66  ,  1372.23  ,  1219.81  ,
  1079.51  ,   950.592 ,   832.42  ,   724.525 ,   626.588 ,   538.466 ,
   460.208 ,   392.083 ,   334.617 ,   288.634 }
,
{   55.29 ,   770.999,  2794.52 ,  5923.94 ,  9547.99 , 13149.1  ,
 16445.7  , 19336.9  , 21805.   , 23866.   , 25551.1  , 26905.5  ,
 27990.7  , 28862.8  , 29561.1  , 30112.1  , 30535.9  , 30849.4  ,
 31070.5  , 31221.1  , 31321.3  , 31385.   , 31421.9  , 31438.3  ,
 31436.8  , 31417.9  , 31382.6  , 31334.   , 31274.8  , 31206.1  ,
 31126.9  , 31035.4  , 30930.1  , 30810.9  , 30679.7  , 30537.6  ,
 30383.9  , 30216.8  , 30033.4  , 29830.9  , 29607.3  , 29361.5  ,
 29092.5  , 28798.3  , 28475.5  , 28120.2  , 27728.6  , 27297.   ,
 26822.9  , 26304.3  , 25739.1  , 25125.5  , 24461.9  , 23747.6  ,
 22983.3  , 22171.2  , 21315.   , 20419.5  , 19490.5  , 18535.   ,
 17560.4  , 16575.1  , 15587.6  , 14606.7  , 13640.4  , 13061.3  ,
 12150.7  , 11272.7  , 10431.6  ,  9630.93 ,  8872.85 ,  8158.7  ,
  7488.9  ,  6863.08 ,  6280.27 ,  5739.03 ,  5237.53 ,  4773.73 ,
  4345.43 ,  3950.34 ,  3586.19 ,  3250.75 ,  2941.84 ,  2657.44 ,
  2395.61 ,  2154.55 ,  1932.62 ,  1728.31 ,  1540.26 ,  1367.25 ,
  1208.24 ,  1062.31 ,   928.72 ,   806.889,   696.42 ,   597.117,
   509.001,   432.347,   367.724,   316.039}
,
{   73.8687,  1020.94  ,  3668.25  ,  7717.63  , 12362.    , 16939.8   ,
 21104.7   , 24738.3   , 27824.4   , 30387.4   , 32470.3   , 34136.5   ,
 35467.9   , 36534.5   , 37383.9   , 38048.6   , 38553.7   , 38921.4   ,
 39176.4   , 39348.    , 39460.3   , 39529.7   , 39567.5   , 39580.4   ,
 39570.5   , 39538.2   , 39485.9   , 39418.    , 39337.4   , 39244.    ,
 39136.1   , 39011.2   , 38868.1   , 38708.    , 38533.3   , 38344.3   ,
 38139.2   , 37914.8   , 37667.2   , 37393.1   , 37090.8   , 36759.1   ,
 36395.9   , 35997.4   , 35558.6   , 35074.5   , 34539.9   , 33951.2   ,
 33305.6   , 32600.5   , 31833.2   , 31001.6   , 30104.4   , 29142.2   ,
 28117.4   , 27034.4   , 25899.3   , 24719.7   , 23504.3   , 22263.    ,
 21006.6   , 19746.3   , 18493.6   , 17259.3   , 16512.8   , 15350.    ,
 14229.1   , 13156.2   , 12135.6   , 11170.3   , 10262.    ,  9411.26  ,
  8617.51  ,  7879.43  ,  7195.06  ,  6562.01  ,  5977.53  ,  5438.73  ,
  4942.61  ,  4486.14  ,  4066.47  ,  3680.7   ,  3326.2   ,  3000.43  ,
  2701.06  ,  2425.92  ,  2173.03  ,  1940.59  ,  1726.99  ,  1530.79  ,
  1350.71  ,  1185.69  ,  1034.83  ,   897.418 ,   772.972 ,   661.223 ,
   562.158 ,   476.053 ,   403.516 ,   345.543 }
,
{   98.5809,  1350.6   ,  4810.57  , 10045.4   , 15992.4   , 21808.    ,
 27066.8   , 31631.1   , 35487.9   , 38673.1   , 41246.2   , 43295.5   ,
 44928.8   , 46232.7   , 47264.9   , 48065.2   , 48665.7   , 49095.5   ,
 49389.    , 49584.1   , 49709.4   , 49784.    , 49821.3   , 49827.8   ,
 49804.8   , 49753.5   , 49678.5   , 49585.    , 49475.5   , 49348.6   ,
 49201.7   , 49031.5   , 48838.1   , 48624.4   , 48392.3   , 48140.9   ,
 47866.5   , 47564.4   , 47229.8   , 46859.3   , 46451.5   , 46004.3   ,
 45513.4   , 44973.    , 44376.1   , 43716.2   , 42987.5   , 42186.2   ,
 41308.9   , 40352.1   , 39312.6   , 38188.6   , 36980.    , 35689.3   ,
 34321.9   , 32885.4   , 31389.3   , 29844.8   , 28264.8   , 26663.3   ,
 25054.9   , 23454.7   , 21877.1   , 20335.1   , 19426.9   , 17994.3   ,
 16623.5   , 15320.4   , 14089.1   , 12931.6   , 11848.7   , 10839.6   ,
  9902.68  ,  9035.2   ,  8234.    ,  7495.48  ,  6815.8   ,  6191.04  ,
  5617.27  ,  5090.62  ,  4607.45  ,  4164.26  ,  3757.75  ,  3384.88  ,
  3042.83  ,  2728.99  ,  2441.03  ,  2176.78  ,  1934.35  ,  1712.    ,
  1508.26  ,  1321.83  ,  1151.64  ,   996.84  ,   856.824 ,   731.241 ,
   620.031 ,   523.464 ,   442.187 ,   377.29  }
,
{  131.412,  1785.04 ,  6302.75 , 13064.1  , 20673.1  , 28055.7  ,
 34692.4  , 40422.9  , 45240.4  , 49196.3  , 52373.2  , 54893.5  ,
 56896.9  , 58490.   , 59742.9  , 60705.1  , 61416.8  , 61917.4  ,
 62254.5  , 62475.7  , 62614.5  , 62693.8  , 62728.2  , 62723.8  ,
 62681.4  , 62604.   , 62498.6  , 62371.1  , 62222.6  , 62050.3  ,
 61850.1  , 61619.2  , 61359.6  , 61075.4  , 60767.3  , 60432.1  ,
 60064.1  , 59656.9  , 59204.8  , 58705.1  , 58155.8  , 57552.6  ,
 56888.5  , 56154.8  , 55342.6  , 54443.7  , 53452.3  , 52364.   ,
 51174.2  , 49878.5  , 48473.8  , 46959.4  , 45337.6  , 43614.5  ,
 41799.6  , 39904.7  , 37944.3  , 35934.8  , 33894.3  , 31842.   ,
 29797.7  , 27780.3  , 25807.3  , 24632.5  , 22799.2  , 21045.5  ,
 19379.2  , 17805.6  , 16327.7  , 14946.4  , 13660.8  , 12468.5  ,
 11366.2  , 10349.7  ,  9414.04 ,  8554.35 ,  7765.4  ,  7042.09 ,
  6379.32 ,  5772.37 ,  5216.64 ,  4707.86 ,  4242.05 ,  3815.55 ,
  3424.97 ,  3067.24 ,  2739.54 ,  2439.35 ,  2164.39 ,  1912.65 ,
  1682.33 ,  1471.92 ,  1280.13 ,  1105.94 ,   948.601,   807.66 ,
   682.996,   574.862,   483.944,   411.432}
,
{  175.029,  2357.03 ,  8250.32 , 16975.9  , 26703.6  , 36069.8  ,
 44440.8  , 51632.1  , 57646.3  , 62556.6  , 66476.9  , 69576.2  ,
 72033.3  , 73978.4  , 75497.4  , 76651.8  , 77492.9  , 78074.3  ,
 78460.8  , 78710.8  , 78863.5  , 78945.9  , 78973.7  , 78951.9  ,
 78881.6  , 78768.7  , 78623.   , 78450.1  , 78248.8  , 78014.7  ,
 77742.4  , 77430.7  , 77084.4  , 76707.4  , 76298.1  , 75850.2  ,
 75355.7  , 74806.3  , 74196.5  , 73523.8  , 72784.2  , 71970.   ,
 71070.4  , 70073.7  , 68968.5  , 67746.1  , 66400.3  , 64925.   ,
 63314.5  , 61563.9  , 59671.3  , 57638.3  , 55471.8  , 53183.   ,
 50787.   , 48301.8  , 45748.3  , 43150.2  , 40532.3  , 37920.5  ,
 35340.   , 32814.2  , 31292.2  , 28943.7  , 26697.1  , 24562.9  ,
 22548.5  , 20657.9  , 18892.3  , 17250.8  , 15730.3  , 14326.2  ,
 13033.1  , 11844.7  , 10754.4  ,  9755.46 ,  8841.04 ,  8004.64 ,
  7239.92 ,  6541.01 ,  5902.31 ,  5318.64 ,  4785.22 ,  4297.67 ,
  3851.96 ,  3444.44 ,  3071.79 ,  2731.01 ,  2419.41 ,  2134.61 ,
  1874.49 ,  1637.25 ,  1421.35 ,  1225.57 ,  1048.98 ,   891.008,
   751.456,   630.551,   529.01 ,   448.13 }
,
{  232.97 ,  3109.4  , 10790.3  , 22041.2  , 34468.4  , 46344.1  ,
 56897.3  , 65917.4  , 73421.6  , 79512.8  , 84348.8  , 88159.7  ,
 91172.4  , 93546.1  , 95385.1  , 96767.1  , 97758.1  , 98431.7  ,
 98874.1  , 99155.4  , 99321.7  , 99404.6  , 99420.1  , 99371.7  ,
 99262.1  , 99101.9  , 98902.8  , 98668.6  , 98396.   , 98077.8  ,
 97708.5  , 97290.4  , 96830.5  , 96330.8  , 95785.9  , 95186.3  ,
 94520.7  , 93779.7  , 92958.8  , 92054.3  , 91058.3  , 89958.   ,
 88738.4  , 87384.1  , 85882.1  , 84223.2  , 82399.6  , 80403.6  ,
 78228.2  , 75869.3  , 73327.7  , 70610.1  , 67729.8  , 64705.3  ,
 61559.3  , 58318.5  , 55013.   , 51675.2  , 48339.1  , 45037.8  ,
 41802.4  , 39828.3  , 36816.8  , 33935.2  , 31197.8  , 28614.8  ,
 26191.7  , 23930.6  , 21830.2  , 19886.5  , 18093.9  , 16445.   ,
 14931.8  , 13545.4  , 12277.   , 11117.8  , 10059.2  ,  9093.01 ,
  8211.45 ,  7407.25 ,  6673.67 ,  6004.5  ,  5394.02 ,  4837.01 ,
  4328.7  ,  3864.77 ,  3441.28 ,  3054.7  ,  2701.87 ,  2379.95 ,
  2086.45 ,  1819.23 ,  1576.45 ,  1356.64 ,  1158.69 ,   981.853,
   825.846,   690.852,   577.62 ,   487.556}
,
{   309.861,   4098.23 ,  14100.2  ,  28595.6  ,  44460.4  ,  59509.   ,
  72807.   ,  84115.7  ,  93474.3  , 101026.   , 106989.   , 111675.   ,
 115368.   , 118262.   , 120486.   , 122136.   , 123300.   , 124079.   ,
 124584.   , 124899.   , 125078.   , 125158.   , 125152.   , 125064.   ,
 124901.   , 124678.   , 124407.   , 124091.   , 123721.   , 123289.   ,
 122791.   , 122233.   , 121624.   , 120961.   , 120234.   , 119430.   ,
 118533.   , 117536.   , 116433.   , 115217.   , 113874.   , 112386.   ,
 110732.   , 108892.   , 106855.   , 104608.   , 102142.   ,  99446.3  ,
  96514.9  ,  93346.1  ,  89946.   ,  86329.7  ,  82519.5  ,  78543.7  ,
  74435.9  ,  70234.7  ,  65982.   ,  61721.8  ,  57498.3  ,  53352.8  ,
  50789.6  ,  46924.5  ,  43224.2  ,  39708.3  ,  36390.9  ,  33279.9  ,
  30378.5  ,  27685.2  ,  25195.3  ,  22901.3  ,  20793.6  ,  18861.8  ,
  17094.4  ,  15479.8  ,  14006.3  ,  12662.8  ,  11438.5  ,  10323.3  ,
   9307.76 ,   8383.   ,   7540.96 ,   6774.2  ,   6075.93 ,   5439.94 ,
   4860.59 ,   4332.78 ,   3851.86 ,   3413.67 ,   3014.47 ,   2650.91 ,
   2320.06 ,   2019.36 ,   1746.65 ,   1500.15 ,   1278.51 ,   1080.8  ,
    906.629,    756.112,    630.026,    529.889}
,
{   411.802,   5397.02 ,  18410.2  ,  37071.4  ,  57310.2  ,  76369.7  ,
  93118.4  , 107290.   , 118955.   , 128312.   , 135664.   , 141424.   ,
 145950.   , 149476.   , 152160.   , 154127.   , 155490.   , 156389.   ,
 156964.   , 157315.   , 157504.   , 157573.   , 157534.   , 157389.   ,
 157153.   , 156846.   , 156481.   , 156053.   , 155552.   , 154967.   ,
 154298.   , 153558.   , 152752.   , 151871.   , 150900.   , 149819.   ,
 148612.   , 147272.   , 145791.   , 144156.   , 142344.   , 140329.   ,
 138085.   , 135591.   , 132832.   , 129795.   , 126465.   , 122833.   ,
 118894.   , 114652.   , 110123.   , 105334.   , 100319.   ,  95120.1  ,
  89786.9  ,  84373.   ,  78935.9  ,  73533.3  ,  68220.8  ,  64890.1  ,
  59925.7  ,  55169.   ,  50647.5  ,  46380.5  ,  42379.5  ,  38649.4  ,
  35189.   ,  31992.4  ,  29050.   ,  26349.6  ,  23877.5  ,  21618.6  ,
  19557.8  ,  17679.9  ,  15970.1  ,  14414.5  ,  12999.8  ,  11713.5  ,
  10544.3  ,   9481.52 ,   8515.51 ,   7637.42 ,   6839.18 ,   6113.45 ,
   5453.56 ,   4853.48 ,   4307.75 ,   3811.45 ,   3360.16 ,   2949.94 ,
   2577.33 ,   2239.31 ,   1933.29 ,   1657.16 ,   1409.28 ,   1188.52 ,
    994.303,    826.7  ,    686.495,    575.323}
,
{   546.822,   7101.49 ,  24018.5  ,  48024.2  ,  73825.9  ,  97953.4  ,
 119039.   , 136790.   , 151322.   , 162909.   , 171972.   , 179053.   ,
 184596.   , 188888.   , 192124.   , 194460.   , 196052.   , 197088.   ,
 197742.   , 198128.   , 198325.   , 198372.   , 198281.   , 198057.   ,
 197724.   , 197306.   , 196813.   , 196235.   , 195556.   , 194766.   ,
 193874.   , 192894.   , 191826.   , 190654.   , 189354.   , 187901.   ,
 186279.   , 184480.   , 182493.   , 180292.   , 177845.   , 175117.   ,
 172076.   , 168700.   , 164971.   , 160871.   , 156386.   , 151504.   ,
 146227.   , 140571.   , 134565.   , 128253.   , 121685.   , 114925.   ,
 108041.   , 101106.   ,  94198.   ,  87389.7  ,  83059.5  ,  76679.2  ,
  70559.2  ,  64737.5  ,  59241.3  ,  54087.3  ,  49283.2  ,  44828.4  ,
  40715.8  ,  36933.4  ,  33465.6  ,  30294.3  ,  27400.1  ,  24763.1  ,
  22363.4  ,  20181.7  ,  18199.7  ,  16400.   ,  14766.3  ,  13283.6  ,
  11938.3  ,  10717.5  ,   9609.91 ,   8604.88 ,   7692.89 ,   6865.26 ,
   6114.13 ,   5432.37 ,   4813.55 ,   4251.87 ,   3742.13 ,   3279.69 ,
   2860.45 ,   2480.85 ,   2137.81 ,   1828.83 ,   1551.92 ,   1305.69 ,
   1089.4  ,    903.009,    747.31 ,    624.059}
,
{   725.477,   9336.52 ,  31311.   ,  62169.1  ,  95042.4  , 125569.   ,
 152103.   , 174328.   , 192422.   , 206764.   , 217934.   , 226638.   ,
 233424.   , 238642.   , 242536.   , 245305.   , 247159.   , 248352.   ,
 249092.   , 249515.   , 249710.   , 249720.   , 249553.   , 249220.   ,
 248757.   , 248192.   , 247527.   , 246745.   , 245826.   , 244766.   ,
 243582.   , 242287.   , 240871.   , 239307.   , 237563.   , 235611.   ,
 233435.   , 231025.   , 228356.   , 225391.   , 222083.   , 218389.   ,
 214274.   , 209713.   , 204682.   , 199160.   , 193130.   , 186587.   ,
 179543.   , 172033.   , 164106.   , 155826.   , 147271.   , 138528.   ,
 129693.   , 120864.   , 112141.   , 103613.   ,  98305.9  ,  90425.8  ,
  82922.2  ,  75833.4  ,  69184.   ,  62985.9  ,  57239.9  ,  51938.1  ,
  47065.3  ,  42601.7  ,  38523.9  ,  34806.6  ,  31423.8  ,  28349.5  ,
  25558.4  ,  23026.3  ,  20730.4  ,  18649.6  ,  16764.1  ,  15056.   ,
  13508.8  ,  12107.4  ,  10838.1  ,   9688.42 ,   8647.09 ,   7703.86 ,
   6849.45 ,   6075.46 ,   5374.3  ,   4739.15 ,   4163.89 ,   3643.04 ,
   3171.78 ,   2745.9  ,   2361.77 ,   2016.4  ,   1707.4  ,   1433.09 ,
   1192.49 ,    985.459,    812.773,    676.313}
,
{   961.643,  12264.9  ,  40787.   ,  80425.8  , 122282.   , 160888.   ,
 194263.   , 222077.   , 244597.   , 262341.   , 276104.   , 286802.   ,
 295106.   , 301443.   , 306120.   , 309392.   , 311549.   , 312919.   ,
 313751.   , 314209.   , 314393.   , 314342.   , 314063.   , 313582.   ,
 312948.   , 312187.   , 311290.   , 310233.   , 308993.   , 307576.   ,
 306010.   , 304298.   , 302417.   , 300328.   , 297988.   , 295368.   ,
 292454.   , 289224.   , 285638.   , 281640.   , 277168.   , 272171.   ,
 266612.   , 260460.   , 253685.   , 246260.   , 238174.   , 229432.   ,
 220067.   , 210139.   , 199725.   , 188919.   , 177834.   , 166590.   ,
 155317.   , 144144.   , 133194.   , 126270.   , 116118.   , 106437.   ,
  97283.6  ,  88692.5  ,  80682.6  ,  73257.8  ,  66409.1  ,  60118.3  ,
  54360.1  ,  49104.5  ,  44318.5  ,  39968.3  ,  36019.8  ,  32439.6  ,
  29196.   ,  26259.4  ,  23601.7  ,  21197.3  ,  19022.5  ,  17055.7  ,
  15277.3  ,  13669.3  ,  12215.5  ,  10901.1  ,   9712.86 ,   8638.6  ,
   7667.39 ,   6789.33 ,   5995.51 ,   5277.87 ,   4629.22 ,   4043.12 ,
   3513.89 ,   3036.56 ,   2606.85 ,   2221.2  ,   1876.77 ,   1571.51 ,
   1304.19 ,   1074.5  ,    883.204,    732.311}
,
{  1273.56 ,  16099.3  ,  53092.   , 103975.   , 157238.   , 206038.   ,
 248001.   , 282795.   , 310808.   , 332752.   , 349711.   , 362857.   ,
 373011.   , 380700.   , 386304.   , 390161.   , 392665.   , 394236.   ,
 395168.   , 395655.   , 395808.   , 395662.   , 395226.   , 394548.   ,
 393688.   , 392663.   , 391454.   , 390025.   , 388358.   , 386476.   ,
 384408.   , 382143.   , 379640.   , 376845.   , 373706.   , 370195.   ,
 366296.   , 361967.   , 357144.   , 351748.   , 345705.   , 338956.   ,
 331459.   , 323175.   , 314066.   , 304107.   , 293293.   , 281655.   ,
 269256.   , 256190.   , 242574.   , 228544.   , 214256.   , 199877.   ,
 185577.   , 171520.   , 162486.   , 149400.   , 136902.   , 125070.   ,
 113955.   , 103588.   ,  93976.8  ,  85113.   ,  76974.7  ,  69530.2  ,
  62741.   ,  56564.5  ,  50956.6  ,  45872.3  ,  41268.   ,  37102.6  ,
  33336.4  ,  29932.8  ,  26858.2  ,  24081.4  ,  21574.1  ,  19310.6  ,
  17267.4  ,  15423.4  ,  13759.2  ,  12257.5  ,  10902.4  ,   9679.74 ,
   8576.56 ,   7581.21 ,   6683.19 ,   5873.03 ,   5142.27 ,   4483.34 ,
   3889.56 ,   3355.08 ,   2874.85 ,   2444.67 ,   2061.16 ,   1721.83 ,
   1425.14 ,   1170.6  ,    958.944,    792.293}
,
{  1685.56 ,  21116.8  ,  69060.4  , 134333.   , 202074.   , 263731.   ,
 316472.   , 359978.   , 394808.   , 421936.   , 442832.   , 458982.   ,
 471392.   , 480706.   , 487410.   , 491944.   , 494847.   , 496642.   ,
 497679.   , 498186.   , 498281.   , 497991.   , 497339.   , 496399.   ,
 495237.   , 493858.   , 492228.   , 490301.   , 488070.   , 485580.   ,
 482851.   , 479850.   , 476514.   , 472770.   , 468563.   , 463868.   ,
 458652.   , 452845.   , 446351.   , 439070.   , 430910.   , 421810.   ,
 411717.   , 400581.   , 388358.   , 375031.   , 360617.   , 345183.   ,
 328837.   , 311720.   , 294002.   , 275878.   , 257563.   , 239278.   ,
 221242.   , 203655.   , 192587.   , 176442.   , 161133.   , 146737.   ,
 133299.   , 120837.   , 109344.   ,  98794.2  ,  89149.   ,  80359.   ,
  72369.4  ,  65122.6  ,  58559.6  ,  52624.   ,  47260.7  ,  42417.9  ,
  38047.5  ,  34105.1  ,  30549.8  ,  27344.5  ,  24455.4  ,  21851.7  ,
  19505.6  ,  17392.1  ,  15488.2  ,  13773.5  ,  12229.2  ,  10838.6  ,
   9586.44 ,   8459.   ,   7443.92 ,   6530.08 ,   5707.53 ,   4967.39 ,
   4301.8  ,   3703.9  ,   3167.74 ,   2688.38 ,   2261.78 ,   1884.97 ,
   1556.04 ,   1274.28 ,   1040.35 ,    856.511}
,
{  2229.51 ,  27677.4  ,  89769.5  , 173447.   , 259554.   , 337421.   ,
 403683.   , 458061.   , 501346.   , 534872.   , 560617.   , 580453.   ,
 595607.   , 606878.   , 614877.   , 620195.   , 623556.   , 625602.   ,
 626746.   , 627255.   , 627249.   , 626750.   , 625804.   , 624516.   ,
 622953.   , 621100.   , 618901.   , 616307.   , 613340.   , 610053.   ,
 606449.   , 602466.   , 598013.   , 592999.   , 587370.   , 581098.   ,
 574117.   , 566320.   , 557574.   , 547750.   , 536749.   , 524499.   ,
 510933.   , 495988.   , 479622.   , 461838.   , 442693.   , 422309.   ,
 400853.   , 378532.   , 355590.   , 332299.   , 308948.   , 285825.   ,
 263202.   , 248710.   , 227846.   , 208025.   , 189359.   , 171918.   ,
 155735.   , 140806.   , 127104.   , 114582.   , 103177.   ,  92817.9  ,
  83430.9  ,  74939.2  ,  67268.   ,  60344.4  ,  54101.2  ,  48474.6  ,
  43406.   ,  38841.7  ,  34732.7  ,  31034.6  ,  27707.1  ,  24713.6  ,
  22021.2  ,  19600.2  ,  17423.4  ,  15466.7  ,  13708.1  ,  12127.6  ,
  10707.4  ,   9431.36 ,   8284.89 ,   7254.97 ,   6329.9  ,   5499.27 ,
   4753.88 ,   4085.65 ,   3487.63 ,   2953.97 ,   2479.93 ,   2061.94 ,
   1697.64 ,   1386.07 ,   1127.81 ,    925.232}
,
{  2947.1  ,  36249.9  , 116610.   , 223816.   , 333208.   , 431509.   ,
 514724.   , 582665.   , 636431.   , 677856.   , 709573.   , 733926.   ,
 752418.   , 766037.   , 775559.   , 781784.   , 785670.   , 787991.   ,
 789240.   , 789723.   , 789556.   , 788758.   , 787417.   , 785670.   ,
 783571.   , 781079.   , 778115.   , 774639.   , 770707.   , 766375.   ,
 761612.   , 756316.   , 750365.   , 743654.   , 736136.   , 727759.   ,
 718411.   , 707933.   , 696151.   , 682909.   , 668100.   , 651637.   ,
 633431.   , 613412.   , 591554.   , 567897.   , 542566.   , 515754.   ,
 487712.   , 458741.   , 429183.   , 399408.   , 369797.   , 340715.   ,
 321749.   , 294782.   , 269105.   , 244882.   , 222220.   , 201173.   ,
 181750.   , 163921.   , 147630.   , 132800.   , 119339.   , 107152.   ,
  96138.   ,  86198.7  ,  77239.1  ,  69170.   ,  61907.3  ,  55373.7  ,
  49498.3  ,  44216.5  ,  39469.9  ,  35205.2  ,  31374.7  ,  27934.9  ,
  24846.9  ,  22075.2  ,  19588.1  ,  17356.8  ,  15355.3  ,  13560.4  ,
  11950.9  ,  10507.7  ,   9213.94 ,   8054.16 ,   7014.7  ,   6083.34 ,
   5249.32 ,   4503.19 ,   3836.79 ,   3243.26 ,   2717.01 ,   2253.78 ,
   1850.72 ,   1506.55 ,   1221.73 ,    998.738}
,
{  3893.01,  47443.3 , 151379.  , 288642.  , 427547.  , 551592.  ,
 656063.  , 740915.  , 807669.  , 858842.  , 897914.  , 927803.  ,
 950348.  , 966777.  , 978086.  , 985361.  , 989845.  , 992466.  ,
 993813.  , 994226.  , 993807.  , 992592.  , 990726.  , 988371.  ,
 985554.  , 982202.  , 978214.  , 973577.  , 968386.  , 962678.  ,
 956372.  , 949321.  , 941364.  , 932395.  , 922365.  , 911174.  ,
 898646.  , 884559.  , 868689.  , 850865.  , 830963.  , 808870.  ,
 784478.  , 757720.  , 728606.  , 697247.  , 663859.  , 628740.  ,
 592255.  , 554830.  , 516938.  , 479073.  , 441723.  , 416922.  ,
 382071.  , 348798.  , 317342.  , 287866.  , 260459.  , 235148.  ,
 211909.  , 190675.  , 171350.  , 153821.  , 137961.  , 123642.  ,
 110733.  ,  99109.9 ,  88654.6 ,  79256.1 ,  70812.2 ,  63229.1 ,
  56421.7 ,  50312.6 ,  44831.9 ,  39916.4 ,  35509.1 ,  31558.7 ,
  28018.8 ,  24847.7 ,  22007.8 ,  19465.1 ,  17189.  ,  15152.  ,
  13329.3 ,  11698.5 ,  10239.6 ,   8934.71,   7767.69,   6724.31,
   5791.95,   4959.58,   4217.67,   3558.17,   2974.52,   2461.65,
   2016.15,   1636.34,   1322.53,   1077.33}
,
{5.13890e+03, 6.20514e+04, 1.96389e+05, 3.72035e+05, 5.48326e+05,
 7.04798e+05, 8.35909e+05, 9.41838e+05, 1.02468e+06, 1.08789e+06,
 1.13601e+06, 1.17268e+06, 1.20014e+06, 1.21993e+06, 1.23333e+06,
 1.24182e+06, 1.24698e+06, 1.24993e+06, 1.25135e+06, 1.25162e+06,
 1.25083e+06, 1.24904e+06, 1.24648e+06, 1.24332e+06, 1.23954e+06,
 1.23503e+06, 1.22968e+06, 1.22352e+06, 1.21668e+06, 1.20916e+06,
 1.20080e+06, 1.19140e+06, 1.18076e+06, 1.16879e+06, 1.15542e+06,
 1.14046e+06, 1.12366e+06, 1.10471e+06, 1.08336e+06, 1.05940e+06,
 1.03270e+06, 1.00309e+06, 9.70472e+05, 9.34791e+05, 8.96132e+05,
 8.54715e+05, 8.10884e+05, 7.65078e+05, 7.17820e+05, 6.69707e+05,
 6.21375e+05, 5.73471e+05, 5.26600e+05, 4.96054e+05, 4.52936e+05,
 4.12070e+05, 3.73699e+05, 3.37969e+05, 3.04941e+05, 2.74598e+05,
 2.46869e+05, 2.21638e+05, 1.98760e+05, 1.78076e+05, 1.59415e+05,
 1.42610e+05, 1.27495e+05, 1.13913e+05, 1.01720e+05, 9.07791e+04,
 8.09666e+04, 7.21697e+04, 6.42860e+04, 5.72232e+04, 5.08979e+04,
 4.52351e+04, 4.01669e+04, 3.56326e+04, 3.15773e+04, 2.79515e+04,
 2.47109e+04, 2.18154e+04, 1.92288e+04, 1.69189e+04, 1.48563e+04,
 1.30150e+04, 1.13713e+04, 9.90430e+03, 8.59518e+03, 7.42729e+03,
 6.38590e+03, 5.45815e+03, 4.63291e+03, 3.90078e+03, 3.25405e+03,
 2.68677e+03, 2.19482e+03, 1.77608e+03, 1.43067e+03, 1.16131e+03}
,
{6.77863e+03, 8.11041e+04, 2.54624e+05, 4.79259e+05, 7.02890e+05,
 9.00195e+05, 1.06468e+06, 1.19687e+06, 1.29964e+06, 1.37769e+06,
 1.43697e+06, 1.48194e+06, 1.51535e+06, 1.53913e+06, 1.55498e+06,
 1.56487e+06, 1.57080e+06, 1.57409e+06, 1.57556e+06, 1.57558e+06,
 1.57425e+06, 1.57169e+06, 1.56821e+06, 1.56397e+06, 1.55890e+06,
 1.55284e+06, 1.54568e+06, 1.53754e+06, 1.52854e+06, 1.51860e+06,
 1.50750e+06, 1.49496e+06, 1.48076e+06, 1.46481e+06, 1.44698e+06,
 1.42697e+06, 1.40442e+06, 1.37895e+06, 1.35024e+06, 1.31809e+06,
 1.28231e+06, 1.24271e+06, 1.19917e+06, 1.15172e+06, 1.10056e+06,
 1.04606e+06, 9.88752e+05, 9.29262e+05, 8.68332e+05, 8.06776e+05,
 7.45437e+05, 6.85135e+05, 6.45070e+05, 5.89209e+05, 5.36106e+05,
 4.86127e+05, 4.39503e+05, 3.96348e+05, 3.56671e+05, 3.20397e+05,
 2.87390e+05, 2.57470e+05, 2.30433e+05, 2.06060e+05, 1.84129e+05,
 1.64425e+05, 1.46740e+05, 1.30881e+05, 1.16669e+05, 1.03939e+05,
 9.25412e+04, 8.23406e+04, 7.32147e+04, 6.50532e+04, 5.77568e+04,
 5.12363e+04, 4.54114e+04, 4.02099e+04, 3.55670e+04, 3.14241e+04,
 2.77288e+04, 2.44338e+04, 2.14967e+04, 1.88792e+04, 1.65470e+04,
 1.44695e+04, 1.26192e+04, 1.09713e+04, 9.50397e+03, 8.19782e+03,
 7.03565e+03, 6.00248e+03, 5.08536e+03, 4.27331e+03, 3.55734e+03,
 2.93043e+03, 2.38769e+03, 1.92646e+03, 1.54664e+03, 1.25102e+03}
,
{8.93499e+03, 1.05938e+05, 3.29930e+05, 6.17056e+05, 9.00610e+05,
 1.14932e+06, 1.35561e+06, 1.52050e+06, 1.64793e+06, 1.74432e+06,
 1.81731e+06, 1.87243e+06, 1.91304e+06, 1.94158e+06, 1.96027e+06,
 1.97178e+06, 1.97858e+06, 1.98222e+06, 1.98367e+06, 1.98330e+06,
 1.98119e+06, 1.97760e+06, 1.97290e+06, 1.96723e+06, 1.96043e+06,
 1.95229e+06, 1.94275e+06, 1.93202e+06, 1.92018e+06, 1.90704e+06,
 1.89228e+06, 1.87554e+06, 1.85661e+06, 1.83538e+06, 1.81159e+06,
 1.78481e+06, 1.75454e+06, 1.72031e+06, 1.68178e+06, 1.63871e+06,
 1.59083e+06, 1.53794e+06, 1.47996e+06, 1.41705e+06, 1.34958e+06,
 1.27815e+06, 1.20352e+06, 1.12659e+06, 1.04840e+06, 9.70021e+05,
 8.92559e+05, 8.17020e+05, 7.67755e+05, 6.98759e+05, 6.33636e+05,
 5.72751e+05, 5.16304e+05, 4.64348e+05, 4.16818e+05, 3.73559e+05,
 3.34352e+05, 2.98936e+05, 2.67029e+05, 2.38344e+05, 2.12596e+05,
 1.89510e+05, 1.68832e+05, 1.50324e+05, 1.33767e+05, 1.18962e+05,
 1.05729e+05, 9.39060e+04, 8.33468e+04, 7.39201e+04, 6.55078e+04,
 5.80039e+04, 5.13131e+04, 4.53500e+04, 4.00376e+04, 3.53071e+04,
 3.10962e+04, 2.73493e+04, 2.40165e+04, 2.10527e+04, 1.84178e+04,
 1.60757e+04, 1.39943e+04, 1.21447e+04, 1.05015e+04, 9.04190e+03,
 7.74603e+03, 6.59644e+03, 5.57807e+03, 4.67816e+03, 3.88622e+03,
 3.19404e+03, 2.59580e+03, 2.08823e+03, 1.67094e+03, 1.34680e+03}
,
{1.17689e+04, 1.38286e+05, 4.27259e+05, 7.94059e+05, 1.15344e+06,
 1.46683e+06, 1.72547e+06, 1.93106e+06, 2.08902e+06, 2.20804e+06,
 2.29792e+06, 2.36542e+06, 2.41473e+06, 2.44892e+06, 2.47092e+06,
 2.48430e+06, 2.49206e+06, 2.49605e+06, 2.49738e+06, 2.49640e+06,
 2.49322e+06, 2.48825e+06, 2.48194e+06, 2.47435e+06, 2.46523e+06,
 2.45432e+06, 2.44167e+06, 2.42756e+06, 2.41197e+06, 2.39458e+06,
 2.37493e+06, 2.35260e+06, 2.32741e+06, 2.29915e+06, 2.26739e+06,
 2.23152e+06, 2.19088e+06, 2.14493e+06, 2.09330e+06, 2.03566e+06,
 1.97169e+06, 1.90120e+06, 1.82420e+06, 1.74105e+06, 1.65240e+06,
 1.55913e+06, 1.46234e+06, 1.36331e+06, 1.26342e+06, 1.16411e+06,
 1.06675e+06, 1.00194e+06, 9.12332e+05, 8.27472e+05, 7.47925e+05,
 6.74026e+05, 6.05908e+05, 5.43537e+05, 4.86744e+05, 4.35265e+05,
 3.88776e+05, 3.46916e+05, 3.09310e+05, 2.75582e+05, 2.45376e+05,
 2.18349e+05, 1.94186e+05, 1.72596e+05, 1.53316e+05, 1.36105e+05,
 1.20748e+05, 1.07051e+05, 9.48387e+04, 8.39561e+04, 7.42622e+04,
 6.56314e+04, 5.79506e+04, 5.11185e+04, 4.50443e+04, 3.96463e+04,
 3.48513e+04, 3.05937e+04, 2.68146e+04, 2.34613e+04, 2.04866e+04,
 1.78483e+04, 1.55088e+04, 1.34345e+04, 1.15957e+04, 9.96603e+03,
 8.52226e+03, 7.24418e+03, 6.11434e+03, 5.11790e+03, 4.24268e+03,
 3.47909e+03, 2.82024e+03, 2.26217e+03, 1.80412e+03, 1.44903e+03}
,
{1.54932e+04, 1.80400e+05, 5.52986e+05, 1.02132e+06, 1.47662e+06,
 1.87140e+06, 2.19554e+06, 2.45179e+06, 2.64752e+06, 2.79447e+06,
 2.90511e+06, 2.98775e+06, 3.04755e+06, 3.08840e+06, 3.11427e+06,
 3.12980e+06, 3.13862e+06, 3.14294e+06, 3.14399e+06, 3.14209e+06,
 3.13744e+06, 3.13065e+06, 3.12221e+06, 3.11205e+06, 3.09982e+06,
 3.08524e+06, 3.06854e+06, 3.05000e+06, 3.02945e+06, 3.00639e+06,
 2.98022e+06, 2.95048e+06, 2.91698e+06, 2.87935e+06, 2.83692e+06,
 2.78885e+06, 2.73433e+06, 2.67274e+06, 2.60365e+06, 2.52662e+06,
 2.44130e+06, 2.34754e+06, 2.24557e+06, 2.13605e+06, 2.01998e+06,
 1.89867e+06, 1.77367e+06, 1.64674e+06, 1.51973e+06, 1.39448e+06,
 1.30939e+06, 1.19309e+06, 1.08254e+06, 9.78587e+05, 8.81777e+05,
 7.92380e+05, 7.10423e+05, 6.35740e+05, 5.68027e+05, 5.06881e+05,
 4.51844e+05, 4.02431e+05, 3.58152e+05, 3.18532e+05, 2.83119e+05,
 2.51495e+05, 2.23273e+05, 1.98101e+05, 1.75658e+05, 1.55659e+05,
 1.37844e+05, 1.21983e+05, 1.07866e+05, 9.53092e+04, 8.41448e+04,
 7.42235e+04, 6.54115e+04, 5.75888e+04, 5.06480e+04, 4.44926e+04,
 3.90363e+04, 3.42019e+04, 2.99200e+04, 2.61288e+04, 2.27731e+04,
 1.98034e+04, 1.71759e+04, 1.48515e+04, 1.27955e+04, 1.09773e+04,
 9.36999e+03, 7.95022e+03, 6.69770e+03, 5.59530e+03, 4.62884e+03,
 3.78717e+03, 3.06219e+03, 2.44910e+03, 1.94674e+03, 1.55809e+03}
,
{2.03852e+04, 2.35200e+05, 7.15311e+05, 1.31300e+06, 1.88957e+06,
 2.38670e+06, 2.79280e+06, 3.11207e+06, 3.35454e+06, 3.53596e+06,
 3.67213e+06, 3.77323e+06, 3.84565e+06, 3.89438e+06, 3.92474e+06,
 3.94274e+06, 3.95272e+06, 3.95730e+06, 3.95784e+06, 3.95461e+06,
 3.94797e+06, 3.93878e+06, 3.92750e+06, 3.91391e+06, 3.89752e+06,
 3.87811e+06, 3.85613e+06, 3.83177e+06, 3.80465e+06, 3.77404e+06,
 3.73917e+06, 3.69961e+06, 3.65509e+06, 3.60496e+06, 3.54825e+06,
 3.48383e+06, 3.41074e+06, 3.32831e+06, 3.23596e+06, 3.13317e+06,
 3.01958e+06, 2.89518e+06, 2.76056e+06, 2.61679e+06, 2.46539e+06,
 2.30824e+06, 2.14749e+06, 1.98552e+06, 1.82477e+06, 1.66753e+06,
 1.56253e+06, 1.41860e+06, 1.28276e+06, 1.15589e+06, 1.03847e+06,
 9.30652e+05, 8.32302e+05, 7.43081e+05, 6.62504e+05, 5.89993e+05,
 5.24924e+05, 4.66656e+05, 4.14566e+05, 3.68054e+05, 3.26564e+05,
 2.89581e+05, 2.56633e+05, 2.27294e+05, 2.01183e+05, 1.77953e+05,
 1.57296e+05, 1.38937e+05, 1.22627e+05, 1.08146e+05, 9.52948e+04,
 8.38969e+04, 7.37934e+04, 6.48423e+04, 5.69166e+04, 4.99024e+04,
 4.36981e+04, 3.82125e+04, 3.33646e+04, 2.90816e+04, 2.52988e+04,
 2.19587e+04, 1.90100e+04, 1.64072e+04, 1.41101e+04, 1.20832e+04,
 1.02953e+04, 8.71937e+03, 7.33197e+03, 6.11330e+03, 5.04696e+03,
 4.11998e+03, 3.32288e+03, 2.64992e+03, 2.09942e+03, 1.67437e+03}
,
{2.68071e+04, 3.06468e+05, 9.24788e+05, 1.68716e+06, 2.41705e+06,
 3.04287e+06, 3.55148e+06, 3.94911e+06, 4.24941e+06, 4.47338e+06,
 4.64092e+06, 4.76450e+06, 4.85210e+06, 4.91010e+06, 4.94569e+06,
 4.96651e+06, 4.97773e+06, 4.98248e+06, 4.98215e+06, 4.97702e+06,
 4.96772e+06, 4.95536e+06, 4.94030e+06, 4.92212e+06, 4.90017e+06,
 4.87446e+06, 4.84557e+06, 4.81355e+06, 4.77771e+06, 4.73703e+06,
 4.69063e+06, 4.63807e+06, 4.57890e+06, 4.51208e+06, 4.43623e+06,
 4.34993e+06, 4.25207e+06, 4.14188e+06, 4.01862e+06, 3.88167e+06,
 3.73073e+06, 3.56614e+06, 3.38897e+06, 3.20091e+06, 3.00416e+06,
 2.80138e+06, 2.59553e+06, 2.38978e+06, 2.18723e+06, 2.04904e+06,
 1.86183e+06, 1.68440e+06, 1.51812e+06, 1.36382e+06, 1.22184e+06,
 1.09215e+06, 9.74408e+05, 8.68032e+05, 7.72308e+05, 6.86437e+05,
 6.09592e+05, 5.40945e+05, 4.79712e+05, 4.25146e+05, 3.76561e+05,
 3.33328e+05, 2.94878e+05, 2.60699e+05, 2.30330e+05, 2.03359e+05,
 1.79419e+05, 1.58178e+05, 1.39344e+05, 1.22652e+05, 1.07868e+05,
 9.47819e+04, 8.32050e+04, 7.29695e+04, 6.39252e+04, 5.59380e+04,
 4.88880e+04, 4.26682e+04, 3.71833e+04, 3.23482e+04, 2.80874e+04,
 2.43334e+04, 2.10267e+04, 1.81145e+04, 1.55500e+04, 1.32921e+04,
 1.13048e+04, 9.55686e+03, 8.02125e+03, 6.67509e+03, 5.49947e+03,
 4.47934e+03, 3.60365e+03, 2.86555e+03, 2.26279e+03, 1.79833e+03}
,
{3.52317e+04, 3.99102e+05, 1.19499e+06, 2.16695e+06, 3.09060e+06,
 3.87815e+06, 4.51495e+06, 5.00999e+06, 5.38182e+06, 5.65831e+06,
 5.86438e+06, 6.01534e+06, 6.12113e+06, 6.19004e+06, 6.23171e+06,
 6.25574e+06, 6.26826e+06, 6.27298e+06, 6.27129e+06, 6.26348e+06,
 6.25065e+06, 6.23411e+06, 6.21401e+06, 6.18967e+06, 6.16037e+06,
 6.12643e+06, 6.08852e+06, 6.04639e+06, 5.99896e+06, 5.94488e+06,
 5.88319e+06, 5.81343e+06, 5.73476e+06, 5.64563e+06, 5.54416e+06,
 5.42862e+06, 5.29777e+06, 5.15067e+06, 4.98637e+06, 4.80421e+06,
 4.60412e+06, 4.38697e+06, 4.15457e+06, 3.90944e+06, 3.65473e+06,
 3.39413e+06, 3.13166e+06, 2.87144e+06, 2.61734e+06, 2.44689e+06,
 2.21534e+06, 1.99747e+06, 1.79463e+06, 1.60755e+06, 1.43636e+06,
 1.28075e+06, 1.14008e+06, 1.01347e+06, 8.99914e+05, 7.98342e+05,
 7.07675e+05, 6.26866e+05, 5.54929e+05, 4.90946e+05, 4.34077e+05,
 3.83560e+05, 3.38708e+05, 2.98905e+05, 2.63600e+05, 2.32300e+05,
 2.04565e+05, 1.80004e+05, 1.58266e+05, 1.39037e+05, 1.22040e+05,
 1.07024e+05, 9.37672e+04, 8.20707e+04, 7.17571e+04, 6.26682e+04,
 5.46629e+04, 4.76157e+04, 4.14147e+04, 3.59604e+04, 3.11644e+04,
 2.69485e+04, 2.32431e+04, 1.99870e+04, 1.71261e+04, 1.46128e+04,
 1.24056e+04, 1.04683e+04, 8.76993e+03, 7.28409e+03, 5.98896e+03,
 4.86719e+03, 3.90591e+03, 3.09700e+03, 2.43753e+03, 1.93039e+03}
,
{4.62766e+04, 5.19444e+05, 1.54334e+06, 2.78194e+06, 3.95034e+06,
 4.94114e+06, 5.73818e+06, 6.35427e+06, 6.81459e+06, 7.15589e+06,
 7.40927e+06, 7.59350e+06, 7.72108e+06, 7.80279e+06, 7.85154e+06,
 7.87917e+06, 7.89305e+06, 7.89741e+06, 7.89364e+06, 7.88217e+06,
 7.86466e+06, 7.84258e+06, 7.81576e+06, 7.78320e+06, 7.74421e+06,
 7.69954e+06, 7.64982e+06, 7.59432e+06, 7.53147e+06, 7.45958e+06,
 7.37767e+06, 7.28511e+06, 7.18047e+06, 7.06150e+06, 6.92578e+06,
 6.77125e+06, 6.59653e+06, 6.40038e+06, 6.18168e+06, 5.93984e+06,
 5.67527e+06, 5.38966e+06, 5.08582e+06, 4.76744e+06, 4.43896e+06,
 4.10542e+06, 3.77218e+06, 3.44447e+06, 3.21966e+06, 2.91785e+06,
 2.63256e+06, 2.36596e+06, 2.11933e+06, 1.89316e+06, 1.68726e+06,
 1.50095e+06, 1.33319e+06, 1.18273e+06, 1.04820e+06, 9.28174e+05,
 8.21286e+05, 7.26218e+05, 6.41754e+05, 5.66763e+05, 5.00226e+05,
 4.41220e+05, 3.88919e+05, 3.42585e+05, 3.01558e+05, 2.65250e+05,
 2.33136e+05, 2.04750e+05, 1.79673e+05, 1.57535e+05, 1.38004e+05,
 1.20785e+05, 1.05615e+05, 9.22576e+04, 8.05045e+04, 7.01691e+04,
 6.10856e+04, 5.31066e+04, 4.61010e+04, 3.99525e+04, 3.45583e+04,
 2.98269e+04, 2.56778e+04, 2.20399e+04, 1.88506e+04, 1.60550e+04,
 1.36053e+04, 1.14598e+04, 9.58274e+03, 7.94393e+03, 6.51822e+03,
 5.28560e+03, 4.23116e+03, 3.34533e+03, 2.62436e+03, 2.07105e+03}
,
{6.07473e+04, 6.75700e+05, 1.99224e+06, 3.56992e+06, 5.04742e+06,
 6.29355e+06, 7.29083e+06, 8.05730e+06, 8.62708e+06, 9.04835e+06,
 9.35977e+06, 9.58442e+06, 9.73802e+06, 9.83474e+06, 9.89170e+06,
 9.92338e+06, 9.93858e+06, 9.94212e+06, 9.93527e+06, 9.91882e+06,
 9.89515e+06, 9.86570e+06, 9.82992e+06, 9.78640e+06, 9.73471e+06,
 9.67606e+06, 9.61082e+06, 9.53762e+06, 9.45426e+06, 9.35874e+06,
 9.25012e+06, 9.12732e+06, 8.98804e+06, 8.82920e+06, 8.64771e+06,
 8.44129e+06, 8.20828e+06, 7.94707e+06, 7.65641e+06, 7.33602e+06,
 6.98714e+06, 6.61265e+06, 6.21676e+06, 5.80472e+06, 5.38273e+06,
 4.95760e+06, 4.53627e+06, 4.12529e+06, 3.84800e+06, 3.47484e+06,
 3.12460e+06, 2.79945e+06, 2.50046e+06, 2.22774e+06, 1.98066e+06,
 1.75802e+06, 1.55829e+06, 1.37971e+06, 1.22048e+06, 1.07877e+06,
 9.52850e+05, 8.41078e+05, 7.41949e+05, 6.54094e+05, 5.76274e+05,
 5.07380e+05, 4.46418e+05, 3.92503e+05, 3.44848e+05, 3.02749e+05,
 2.65583e+05, 2.32792e+05, 2.03881e+05, 1.78408e+05, 1.55980e+05,
 1.36247e+05, 1.18898e+05, 1.03654e+05, 9.02696e+04, 7.85249e+04,
 6.82251e+04, 5.91974e+04, 5.12884e+04, 4.43625e+04, 3.82996e+04,
 3.29935e+04, 2.83509e+04, 2.42893e+04, 2.07365e+04, 1.76292e+04,
 1.49122e+04, 1.25377e+04, 1.04648e+04, 8.65853e+03, 7.09021e+03,
 5.73678e+03, 4.58099e+03, 3.61164e+03, 2.82402e+03, 2.22079e+03}
,
{7.96946e+04, 8.78502e+05, 2.57045e+06, 4.57915e+06, 6.44693e+06,
 8.01370e+06, 9.26117e+06, 1.02144e+07, 1.09196e+07, 1.14395e+07,
 1.18221e+07, 1.20958e+07, 1.22804e+07, 1.23947e+07, 1.24612e+07,
 1.24973e+07, 1.25138e+07, 1.25157e+07, 1.25044e+07, 1.24813e+07,
 1.24495e+07, 1.24103e+07, 1.23625e+07, 1.23045e+07, 1.22362e+07,
 1.21593e+07, 1.20736e+07, 1.19769e+07, 1.18663e+07, 1.17396e+07,
 1.15956e+07, 1.14326e+07, 1.12471e+07, 1.10350e+07, 1.07926e+07,
 1.05172e+07, 1.02068e+07, 9.85937e+06, 9.47375e+06, 9.05029e+06,
 8.59155e+06, 8.10209e+06, 7.58800e+06, 7.05671e+06, 6.51671e+06,
 5.97702e+06, 5.44651e+06, 5.08010e+06, 4.59277e+06, 4.13306e+06,
 3.70452e+06, 3.30917e+06, 2.94769e+06, 2.61963e+06, 2.32371e+06,
 2.05810e+06, 1.82062e+06, 1.60893e+06, 1.42063e+06, 1.25345e+06,
 1.10518e+06, 9.73831e+05, 8.57543e+05, 7.54656e+05, 6.63675e+05,
 5.83264e+05, 5.12234e+05, 4.49525e+05, 3.94195e+05, 3.45406e+05,
 3.02414e+05, 2.64555e+05, 2.31242e+05, 2.01949e+05, 1.76210e+05,
 1.53611e+05, 1.33782e+05, 1.16398e+05, 1.01166e+05, 8.78286e+04,
 7.61577e+04, 6.59506e+04, 5.70280e+04, 4.92317e+04, 4.24220e+04,
 3.64757e+04, 3.12844e+04, 2.67530e+04, 2.27980e+04, 1.93465e+04,
 1.63352e+04, 1.37092e+04, 1.14215e+04, 9.43209e+03, 7.70812e+03,
 6.22308e+03, 4.95712e+03, 3.89712e+03, 3.03732e+03, 2.38014e+03}
,
{1.04489e+05, 1.14158e+06, 3.31493e+06, 5.87128e+06, 8.23167e+06,
 1.02010e+07, 1.17610e+07, 1.29460e+07, 1.38187e+07, 1.44603e+07,
 1.49301e+07, 1.52632e+07, 1.54847e+07, 1.56197e+07, 1.56971e+07,
 1.57382e+07, 1.57556e+07, 1.57549e+07, 1.57373e+07, 1.57053e+07,
 1.56628e+07, 1.56106e+07, 1.55468e+07, 1.54695e+07, 1.53796e+07,
 1.52789e+07, 1.51663e+07, 1.50385e+07, 1.48917e+07, 1.47237e+07,
 1.45330e+07, 1.43166e+07, 1.40694e+07, 1.37862e+07, 1.34626e+07,
 1.30956e+07, 1.26826e+07, 1.22212e+07, 1.17106e+07, 1.11523e+07,
 1.05510e+07, 9.91325e+06, 9.24797e+06, 8.56545e+06, 7.87713e+06,
 7.19477e+06, 6.52946e+06, 6.07733e+06, 5.47477e+06, 4.91037e+06,
 4.38767e+06, 3.90832e+06, 3.47234e+06, 3.07853e+06, 2.72476e+06,
 2.40836e+06, 2.12633e+06, 1.87560e+06, 1.65312e+06, 1.45600e+06,
 1.28153e+06, 1.12723e+06, 9.90861e+05, 8.70414e+05, 7.64084e+05,
 6.70268e+05, 5.87540e+05, 5.14633e+05, 4.50422e+05, 3.93907e+05,
 3.44202e+05, 3.00517e+05, 2.62153e+05, 2.28487e+05, 1.98967e+05,
 1.73101e+05, 1.50454e+05, 1.30641e+05, 1.13318e+05, 9.81829e+04,
 8.49674e+04, 7.34347e+04, 6.33755e+04, 5.46055e+04, 4.69623e+04,
 4.03030e+04, 3.45022e+04, 2.94500e+04, 2.50503e+04, 2.12192e+04,
 1.78840e+04, 1.49818e+04, 1.24587e+04, 1.02691e+04, 8.37532e+03,
 6.74702e+03, 5.36133e+03, 4.20303e+03, 3.26509e+03, 2.54963e+03}
,
{1.36933e+05, 1.48269e+06, 4.27304e+06, 7.52505e+06, 1.05070e+07,
 1.29817e+07, 1.49319e+07, 1.64046e+07, 1.74845e+07, 1.82762e+07,
 1.88528e+07, 1.92578e+07, 1.95230e+07, 1.96821e+07, 1.97722e+07,
 1.98188e+07, 1.98366e+07, 1.98317e+07, 1.98053e+07, 1.97614e+07,
 1.97048e+07, 1.96353e+07, 1.95503e+07, 1.94477e+07, 1.93296e+07,
 1.91977e+07, 1.90496e+07, 1.88804e+07, 1.86857e+07, 1.84632e+07,
 1.82107e+07, 1.79230e+07, 1.75936e+07, 1.72156e+07, 1.67842e+07,
 1.62958e+07, 1.57470e+07, 1.51352e+07, 1.44605e+07, 1.37265e+07,
 1.29404e+07, 1.21123e+07, 1.12544e+07, 1.03808e+07, 9.50686e+06,
 8.64752e+06, 8.04922e+06, 7.26095e+06, 6.51850e+06, 5.82778e+06,
 5.19208e+06, 4.61235e+06, 4.08770e+06, 3.61584e+06, 3.19356e+06,
 2.81713e+06, 2.48255e+06, 2.18583e+06, 1.92313e+06, 1.69083e+06,
 1.48561e+06, 1.30442e+06, 1.14457e+06, 1.00362e+06, 8.79396e+05,
 7.69982e+05, 6.73669e+05, 5.88943e+05, 5.14460e+05, 4.49029e+05,
 3.91593e+05, 3.41213e+05, 2.97059e+05, 2.58390e+05, 2.24554e+05,
 1.94968e+05, 1.69119e+05, 1.46553e+05, 1.26865e+05, 1.09701e+05,
 9.47467e+04, 8.17251e+04, 7.03922e+04, 6.05335e+04, 5.19605e+04,
 4.45077e+04, 3.80302e+04, 3.24011e+04, 2.75100e+04, 2.32603e+04,
 1.95688e+04, 1.63635e+04, 1.35826e+04, 1.11744e+04, 9.09544e+03,
 7.31126e+03, 5.79556e+03, 4.53071e+03, 3.50821e+03, 2.72985e+03}
,
{1.79371e+05, 1.92477e+06, 5.50558e+06, 9.64091e+06, 1.34068e+07,
 1.65158e+07, 1.89531e+07, 2.07829e+07, 2.21189e+07, 2.30957e+07,
 2.38030e+07, 2.42948e+07, 2.46120e+07, 2.47994e+07, 2.49040e+07,
 2.49563e+07, 2.49737e+07, 2.49623e+07, 2.49239e+07, 2.48645e+07,
 2.47891e+07, 2.46967e+07, 2.45833e+07, 2.44476e+07, 2.42929e+07,
 2.41201e+07, 2.39249e+07, 2.37008e+07, 2.34428e+07, 2.31485e+07,
 2.28138e+07, 2.24314e+07, 2.19923e+07, 2.14882e+07, 2.09139e+07,
 2.02646e+07, 1.95361e+07, 1.87262e+07, 1.78368e+07, 1.68745e+07,
 1.58502e+07, 1.47782e+07, 1.36758e+07, 1.25619e+07, 1.14565e+07,
 1.03784e+07, 9.63958e+06, 8.66462e+06, 7.75279e+06, 6.91001e+06,
 6.13892e+06, 5.43942e+06, 4.80930e+06, 4.24486e+06, 3.74150e+06,
 3.29415e+06, 2.89757e+06, 2.54669e+06, 2.23666e+06, 1.96303e+06,
 1.72172e+06, 1.50906e+06, 1.32174e+06, 1.15684e+06, 1.01177e+06,
 8.84217e+05, 7.72136e+05, 6.73719e+05, 5.87363e+05, 5.11647e+05,
 4.45314e+05, 3.87247e+05, 3.36457e+05, 2.92070e+05, 2.53310e+05,
 2.19491e+05, 1.90007e+05, 1.64321e+05, 1.41960e+05, 1.22509e+05,
 1.05598e+05, 9.09046e+04, 7.81452e+04, 6.70700e+04, 5.74605e+04,
 4.91252e+04, 4.18967e+04, 3.56290e+04, 3.01950e+04, 2.54841e+04,
 2.14009e+04, 1.78630e+04, 1.48001e+04, 1.21530e+04, 9.87234e+03,
 7.91863e+03, 6.26183e+03, 4.88153e+03, 3.76761e+03, 2.92136e+03}
,
{2.34851e+05, 2.49743e+06, 7.09052e+06, 1.23470e+07, 1.71017e+07,
 2.10065e+07, 2.40515e+07, 2.63243e+07, 2.79774e+07, 2.91821e+07,
 3.00492e+07, 3.06458e+07, 3.10245e+07, 3.12449e+07, 3.13660e+07,
 3.14243e+07, 3.14401e+07, 3.14192e+07, 3.13645e+07, 3.12846e+07,
 3.11844e+07, 3.10613e+07, 3.09103e+07, 3.07314e+07, 3.05291e+07,
 3.03024e+07, 3.00449e+07, 2.97481e+07, 2.94066e+07, 2.90173e+07,
 2.85737e+07, 2.80651e+07, 2.74797e+07, 2.68083e+07, 2.60444e+07,
 2.51821e+07, 2.42166e+07, 2.31467e+07, 2.19771e+07, 2.07190e+07,
 1.93884e+07, 1.80054e+07, 1.65937e+07, 1.51787e+07, 1.37859e+07,
 1.28072e+07, 1.15299e+07, 1.03280e+07, 9.21161e+06, 8.18613e+06,
 7.25309e+06, 6.41084e+06, 5.65537e+06, 4.98118e+06, 4.38188e+06,
 3.85074e+06, 3.38103e+06, 2.96632e+06, 2.60064e+06, 2.27847e+06,
 1.99484e+06, 1.74529e+06, 1.52587e+06, 1.33304e+06, 1.16368e+06,
 1.01503e+06, 8.84660e+05, 7.70393e+05, 6.70321e+05, 5.82751e+05,
 5.06184e+05, 4.39294e+05, 3.80907e+05, 3.29987e+05, 2.85615e+05,
 2.46981e+05, 2.13371e+05, 1.84153e+05, 1.58774e+05, 1.36743e+05,
 1.17632e+05, 1.01064e+05, 8.67080e+04, 7.42744e+04, 6.35100e+04,
 5.41936e+04, 4.61323e+04, 3.91580e+04, 3.31247e+04, 2.79059e+04,
 2.33922e+04, 1.94897e+04, 1.61184e+04, 1.32105e+04, 1.07101e+04,
 8.57218e+03, 6.76230e+03, 5.25699e+03, 4.04424e+03, 3.12478e+03}
,
{3.07343e+05, 3.23895e+06, 9.12782e+06, 1.58070e+07, 2.18083e+07,
 2.67114e+07, 3.05147e+07, 3.33368e+07, 3.53819e+07, 3.68675e+07,
 3.79300e+07, 3.86528e+07, 3.91040e+07, 3.93632e+07, 3.95030e+07,
 3.95674e+07, 3.95794e+07, 3.95447e+07, 3.94681e+07, 3.93612e+07,
 3.92282e+07, 3.90643e+07, 3.88637e+07, 3.86286e+07, 3.83640e+07,
 3.80665e+07, 3.77264e+07, 3.73334e+07, 3.68818e+07, 3.63671e+07,
 3.57787e+07, 3.51019e+07, 3.43221e+07, 3.34287e+07, 3.24139e+07,
 3.12700e+07, 2.99923e+07, 2.85818e+07, 2.70479e+07, 2.54078e+07,
 2.36846e+07, 2.19064e+07, 2.01051e+07, 1.83142e+07, 1.65657e+07,
 1.53557e+07, 1.37749e+07, 1.22980e+07, 1.09350e+07, 9.69034e+06,
 8.56383e+06, 7.55159e+06, 6.64726e+06, 5.84300e+06, 5.13021e+06,
 4.50008e+06, 3.94410e+06, 3.45425e+06, 3.02309e+06, 2.64391e+06,
 2.31065e+06, 2.01793e+06, 1.76098e+06, 1.53556e+06, 1.33793e+06,
 1.16478e+06, 1.01320e+06, 8.80592e+05, 7.64684e+05, 6.63456e+05,
 5.75125e+05, 4.98116e+05, 4.31035e+05, 3.72655e+05, 3.21889e+05,
 2.77783e+05, 2.39494e+05, 2.06281e+05, 1.77493e+05, 1.52558e+05,
 1.30975e+05, 1.12304e+05, 9.61615e+04, 8.22116e+04, 7.01612e+04,
 5.97549e+04, 5.07704e+04, 4.30146e+04, 3.63202e+04, 3.05421e+04,
 2.55557e+04, 2.12537e+04, 1.75451e+04, 1.43528e+04, 1.16132e+04,
 9.27509e+03, 7.29922e+03, 5.65860e+03, 4.33910e+03, 3.34073e+03}
,
{4.02012e+05, 4.19867e+06, 1.17456e+07, 2.02293e+07, 2.78019e+07,
 3.39571e+07, 3.87060e+07, 4.22094e+07, 4.47395e+07, 4.65711e+07,
 4.78719e+07, 4.87465e+07, 4.92835e+07, 4.95878e+07, 4.97488e+07,
 4.98190e+07, 4.98242e+07, 4.97697e+07, 4.96641e+07, 4.95216e+07,
 4.93450e+07, 4.91269e+07, 4.88612e+07, 4.85530e+07, 4.82069e+07,
 4.78159e+07, 4.73665e+07, 4.68464e+07, 4.62498e+07, 4.55690e+07,
 4.47881e+07, 4.38875e+07, 4.28495e+07, 4.16621e+07, 4.03152e+07,
 3.87998e+07, 3.71118e+07, 3.52566e+07, 3.32503e+07, 3.11184e+07,
 2.88937e+07, 2.66150e+07, 2.43249e+07, 2.20665e+07, 2.04628e+07,
 1.83894e+07, 1.64392e+07, 1.46296e+07, 1.29700e+07, 1.14629e+07,
 1.01055e+07, 8.89099e+06, 7.80996e+06, 6.85160e+06, 6.00455e+06,
 5.25753e+06, 4.59984e+06, 4.02146e+06, 3.51330e+06, 3.06716e+06,
 2.67572e+06, 2.33248e+06, 2.03169e+06, 1.76827e+06, 1.53774e+06,
 1.33613e+06, 1.15997e+06, 1.00615e+06, 8.71972e+05, 7.55020e+05,
 6.53175e+05, 5.64566e+05, 4.87543e+05, 4.20649e+05, 3.62605e+05,
 3.12282e+05, 2.68690e+05, 2.30958e+05, 1.98324e+05, 1.70120e+05,
 1.45760e+05, 1.24733e+05, 1.06594e+05, 9.09526e+04, 7.74709e+04,
 6.58543e+04, 5.58471e+04, 4.72276e+04, 3.98039e+04, 3.34106e+04,
 2.79052e+04, 2.31658e+04, 1.90885e+04, 1.55861e+04, 1.25863e+04,
 1.00308e+04, 7.87498e+03, 6.08800e+03, 4.65321e+03, 3.56980e+03}
,
{5.25580e+05, 5.44028e+06, 1.51079e+07, 2.58800e+07, 3.54326e+07,
 4.31579e+07, 4.90855e+07, 5.34339e+07, 5.65639e+07, 5.88213e+07,
 6.04129e+07, 6.14698e+07, 6.21079e+07, 6.24648e+07, 6.26494e+07,
 6.27246e+07, 6.27185e+07, 6.26365e+07, 6.24924e+07, 6.23031e+07,
 6.20686e+07, 6.17785e+07, 6.14274e+07, 6.10242e+07, 6.05714e+07,
 6.00570e+07, 5.94628e+07, 5.87752e+07, 5.79875e+07, 5.70865e+07,
 5.60497e+07, 5.48515e+07, 5.34711e+07, 5.18946e+07, 5.01089e+07,
 4.81040e+07, 4.58783e+07, 4.34439e+07, 4.08269e+07, 3.80639e+07,
 3.52009e+07, 3.22907e+07, 2.93894e+07, 2.65516e+07, 2.45660e+07,
 2.19977e+07, 1.95992e+07, 1.73881e+07, 1.53722e+07, 1.35511e+07,
 1.19185e+07, 1.04634e+07, 9.17273e+06, 8.03185e+06, 7.02601e+06,
 6.14098e+06, 5.36330e+06, 4.68068e+06, 4.08197e+06, 3.55723e+06,
 3.09760e+06, 2.69524e+06, 2.34326e+06, 2.03556e+06, 1.76676e+06,
 1.53212e+06, 1.32748e+06, 1.14916e+06, 9.93907e+05, 8.58861e+05,
 7.41500e+05, 6.39604e+05, 5.51215e+05, 4.74614e+05, 4.08287e+05,
 3.50906e+05, 3.01307e+05, 2.58469e+05, 2.21499e+05, 1.89616e+05,
 1.62139e+05, 1.38473e+05, 1.18102e+05, 1.00575e+05, 8.55012e+04,
 7.25414e+04, 6.14016e+04, 5.18278e+04, 4.36005e+04, 3.65306e+04,
 3.04558e+04, 2.52374e+04, 2.07575e+04, 1.69171e+04, 1.36342e+04,
 1.08428e+04, 8.49209e+03, 6.54683e+03, 4.98762e+03, 3.81264e+03}
,
{6.86782e+05, 7.04589e+06, 1.94250e+07, 3.30978e+07, 4.51451e+07,
 5.48386e+07, 6.22355e+07, 6.76315e+07, 7.15033e+07, 7.42850e+07,
 7.62307e+07, 7.75061e+07, 7.82634e+07, 7.86816e+07, 7.88924e+07,
 7.89709e+07, 7.89470e+07, 7.88273e+07, 7.86324e+07, 7.83812e+07,
 7.80699e+07, 7.76843e+07, 7.72219e+07, 7.66951e+07, 7.61023e+07,
 7.54247e+07, 7.46392e+07, 7.37310e+07, 7.26911e+07, 7.14983e+07,
 7.01213e+07, 6.85277e+07, 6.66939e+07, 6.46029e+07, 6.22381e+07,
 5.95896e+07, 5.66608e+07, 5.34746e+07, 5.00702e+07, 4.65000e+07,
 4.28274e+07, 3.91233e+07, 3.54606e+07, 3.28291e+07, 2.94579e+07,
 2.62865e+07, 2.33450e+07, 2.06502e+07, 1.82070e+07, 1.60108e+07,
 1.40501e+07, 1.23092e+07, 1.07698e+07, 9.41278e+06, 8.21924e+06,
 7.17117e+06, 6.25202e+06, 5.44665e+06, 4.74150e+06, 4.12450e+06,
 3.58497e+06, 3.11348e+06, 2.70175e+06, 2.34245e+06, 2.02916e+06,
 1.75621e+06, 1.51861e+06, 1.31198e+06, 1.13243e+06, 9.76577e+05,
 8.41413e+05, 7.24303e+05, 6.22932e+05, 5.35266e+05, 4.59520e+05,
 3.94131e+05, 3.37732e+05, 2.89126e+05, 2.47268e+05, 2.11249e+05,
 1.80275e+05, 1.53656e+05, 1.30792e+05, 1.11164e+05, 9.43196e+04,
 7.98698e+04, 6.74767e+04, 5.68491e+04, 4.77363e+04, 3.99227e+04,
 3.32234e+04, 2.74809e+04, 2.25615e+04, 1.83529e+04, 1.47623e+04,
 1.17149e+04, 9.15316e+03, 7.03682e+03, 5.34338e+03, 4.06983e+03}
,
{8.96975e+05, 9.12136e+06, 2.49660e+07, 4.23146e+07, 5.75046e+07,
 6.96645e+07, 7.88924e+07, 8.55873e+07, 9.03765e+07, 9.38028e+07,
 9.61799e+07, 9.77165e+07, 9.86144e+07, 9.91036e+07, 9.93432e+07,
 9.94220e+07, 9.93712e+07, 9.92001e+07, 9.89384e+07, 9.86055e+07,
 9.81922e+07, 9.76806e+07, 9.70734e+07, 9.63855e+07, 9.56085e+07,
 9.47153e+07, 9.36772e+07, 9.24789e+07, 9.11058e+07, 8.95259e+07,
 8.76967e+07, 8.55787e+07, 8.31453e+07, 8.03745e+07, 7.72466e+07,
 7.37535e+07, 6.99082e+07, 6.57486e+07, 6.13322e+07, 5.67327e+07,
 5.20367e+07, 4.73383e+07, 4.27300e+07, 3.94661e+07, 3.52856e+07,
 3.13809e+07, 2.77830e+07, 2.45065e+07, 2.15515e+07, 1.89074e+07,
 1.65562e+07, 1.44757e+07, 1.26413e+07, 1.10283e+07, 9.61277e+06,
 8.37226e+06, 7.28632e+06, 6.33645e+06, 5.50618e+06, 4.78093e+06,
 4.14781e+06, 3.59551e+06, 3.11406e+06, 2.69469e+06, 2.32970e+06,
 2.01232e+06, 1.73659e+06, 1.49726e+06, 1.28974e+06, 1.10997e+06,
 9.54389e+05, 8.19872e+05, 7.03679e+05, 6.03408e+05, 5.16957e+05,
 4.42487e+05, 3.78394e+05, 3.23275e+05, 2.75913e+05, 2.35245e+05,
 2.00350e+05, 1.70426e+05, 1.44780e+05, 1.22811e+05, 1.04000e+05,
 8.78980e+04, 7.41184e+04, 6.23278e+04, 5.22400e+04, 4.36092e+04,
 3.62254e+04, 2.99098e+04, 2.45106e+04, 1.99010e+04, 1.59760e+04,
 1.26510e+04, 9.86087e+03, 7.55973e+03, 5.72156e+03, 4.34196e+03}
,
{1.17101e+06, 1.18031e+07, 3.20754e+07, 5.40809e+07, 7.32287e+07,
 8.84789e+07, 9.99876e+07, 1.08293e+08, 1.14216e+08, 1.18435e+08,
 1.21337e+08, 1.23186e+08, 1.24249e+08, 1.24820e+08, 1.25091e+08,
 1.25165e+08, 1.25075e+08, 1.24835e+08, 1.24485e+08, 1.24044e+08,
 1.23496e+08, 1.22818e+08, 1.22023e+08, 1.21125e+08, 1.20105e+08,
 1.18927e+08, 1.17556e+08, 1.15976e+08, 1.14163e+08, 1.12069e+08,
 1.09639e+08, 1.06827e+08, 1.03601e+08, 9.99329e+07, 9.58010e+07,
 9.12024e+07, 8.61655e+07, 8.07491e+07, 7.50360e+07, 6.91284e+07,
 6.31435e+07, 5.72036e+07, 5.14248e+07, 4.73918e+07, 4.22232e+07,
 3.74288e+07, 3.30391e+07, 2.90639e+07, 2.54965e+07, 2.23180e+07,
 1.95021e+07, 1.70182e+07, 1.48340e+07, 1.29180e+07, 1.12400e+07,
 9.77233e+06, 8.48976e+06, 7.36981e+06, 6.39252e+06, 5.54029e+06,
 4.79761e+06, 4.15086e+06, 3.58810e+06, 3.09881e+06, 2.67379e+06,
 2.30492e+06, 1.98509e+06, 1.70805e+06, 1.46832e+06, 1.26107e+06,
 1.08209e+06, 9.27663e+05, 7.94557e+05, 6.79937e+05, 5.81325e+05,
 4.96563e+05, 4.23768e+05, 3.61302e+05, 3.07742e+05, 2.61853e+05,
 2.22562e+05, 1.88943e+05, 1.60192e+05, 1.35618e+05, 1.14622e+05,
 9.66895e+04, 8.13768e+04, 6.83033e+04, 5.71422e+04, 4.76141e+04,
 3.94803e+04, 3.25380e+04, 2.66156e+04, 2.15695e+04, 1.72812e+04,
 1.36553e+04, 1.06180e+04, 8.11733e+03, 6.12317e+03, 4.62949e+03}
,
{1.52816e+06, 1.52669e+07, 4.11940e+07, 6.90975e+07, 9.32286e+07,
 1.12350e+08, 1.26699e+08, 1.37001e+08, 1.44327e+08, 1.49520e+08,
 1.53059e+08, 1.55280e+08, 1.56538e+08, 1.57204e+08, 1.57507e+08,
 1.57570e+08, 1.57422e+08, 1.57090e+08, 1.56625e+08, 1.56041e+08,
 1.55312e+08, 1.54418e+08, 1.53378e+08, 1.52205e+08, 1.50866e+08,
 1.49312e+08, 1.47503e+08, 1.45420e+08, 1.43024e+08, 1.40248e+08,
 1.37022e+08, 1.33291e+08, 1.29019e+08, 1.24168e+08, 1.18718e+08,
 1.12676e+08, 1.06094e+08, 9.90595e+07, 9.16897e+07, 8.41253e+07,
 7.65221e+07, 6.90374e+07, 6.36654e+07, 5.68489e+07, 5.04768e+07,
 4.46054e+07, 3.92618e+07, 3.44485e+07, 3.01489e+07, 2.63334e+07,
 2.29646e+07, 2.00016e+07, 1.74028e+07, 1.51281e+07, 1.31399e+07,
 1.14040e+07, 9.88965e+06, 8.56956e+06, 7.41957e+06, 6.41845e+06,
 5.54753e+06, 4.79047e+06, 4.13292e+06, 3.56231e+06, 3.06759e+06,
 2.63908e+06, 2.26828e+06, 1.94775e+06, 1.67095e+06, 1.43216e+06,
 1.22637e+06, 1.04919e+06, 8.96800e+05, 7.65851e+05, 6.53433e+05,
 5.57012e+05, 4.74382e+05, 4.03630e+05, 3.43097e+05, 2.91345e+05,
 2.47131e+05, 2.09381e+05, 1.77169e+05, 1.49696e+05, 1.26274e+05,
 1.06314e+05, 8.93064e+04, 7.48181e+04, 6.24763e+04, 5.19632e+04,
 4.30079e+04, 3.53807e+04, 2.88877e+04, 2.33667e+04, 1.86840e+04,
 1.47320e+04, 1.14275e+04, 8.71137e+03, 6.54915e+03, 4.93284e+03}
,
{1.99344e+06, 1.97391e+07, 5.28856e+07, 8.82569e+07, 1.18662e+08,
 1.42631e+08, 1.60517e+08, 1.73293e+08, 1.82353e+08, 1.88742e+08,
 1.93054e+08, 1.95719e+08, 1.97207e+08, 1.97981e+08, 1.98318e+08,
 1.98357e+08, 1.98129e+08, 1.97674e+08, 1.97057e+08, 1.96284e+08,
 1.95318e+08, 1.94140e+08, 1.92783e+08, 1.91249e+08, 1.89489e+08,
 1.87438e+08, 1.85053e+08, 1.82308e+08, 1.79140e+08, 1.75460e+08,
 1.71179e+08, 1.66235e+08, 1.60581e+08, 1.54174e+08, 1.46996e+08,
 1.39074e+08, 1.30494e+08, 1.21382e+08, 1.11903e+08, 1.02247e+08,
 9.26187e+07, 8.32177e+07, 7.65652e+07, 6.81252e+07, 6.02906e+07,
 5.31176e+07, 4.66267e+07, 4.08091e+07, 3.56348e+07, 3.10601e+07,
 2.70339e+07, 2.35022e+07, 2.04118e+07, 1.77124e+07, 1.53575e+07,
 1.33051e+07, 1.15176e+07, 9.96212e+06, 8.60931e+06, 7.43365e+06,
 6.41272e+06, 5.52686e+06, 4.75887e+06, 4.09369e+06, 3.51811e+06,
 3.02056e+06, 2.59089e+06, 2.22023e+06, 1.90081e+06, 1.62582e+06,
 1.38934e+06, 1.18616e+06, 1.01179e+06, 8.62267e+05, 7.34183e+05,
 6.24561e+05, 5.30821e+05, 4.50729e+05, 3.82353e+05, 3.24022e+05,
 2.74296e+05, 2.31932e+05, 1.95861e+05, 1.65164e+05, 1.39051e+05,
 1.16845e+05, 9.79660e+04, 8.19184e+04, 6.82781e+04, 5.66841e+04,
 4.68295e+04, 3.84541e+04, 3.13391e+04, 2.53015e+04, 2.01907e+04,
 1.58855e+04, 1.22920e+04, 9.34351e+03, 7.00032e+03, 5.25227e+03}
,
{2.59933e+06, 2.55111e+07, 6.78715e+07, 1.12695e+08, 1.50997e+08,
 1.81036e+08, 2.03325e+08, 2.19169e+08, 2.30372e+08, 2.38228e+08,
 2.43478e+08, 2.46670e+08, 2.48428e+08, 2.49325e+08, 2.49695e+08,
 2.49695e+08, 2.49355e+08, 2.48738e+08, 2.47921e+08, 2.46897e+08,
 2.45616e+08, 2.44069e+08, 2.42300e+08, 2.40294e+08, 2.37978e+08,
 2.35272e+08, 2.32131e+08, 2.28512e+08, 2.24323e+08, 2.19443e+08,
 2.13766e+08, 2.07221e+08, 1.99746e+08, 1.91294e+08, 1.81855e+08,
 1.71492e+08, 1.60334e+08, 1.48564e+08, 1.36406e+08, 1.24117e+08,
 1.11964e+08, 1.03114e+08, 9.19834e+07, 8.15624e+07, 7.19539e+07,
 6.32104e+07, 5.53411e+07, 4.83211e+07, 4.21025e+07, 3.66235e+07,
 3.18155e+07, 2.76087e+07, 2.39358e+07, 2.07338e+07, 1.79455e+07,
 1.55196e+07, 1.34104e+07, 1.15780e+07, 9.98709e+06, 8.60693e+06,
 7.41055e+06, 6.37437e+06, 5.47777e+06, 4.70270e+06, 4.03336e+06,
 3.45591e+06, 2.95827e+06, 2.52986e+06, 2.16144e+06, 1.84494e+06,
 1.57333e+06, 1.34048e+06, 1.14106e+06, 9.70431e+05, 8.24579e+05,
 7.00017e+05, 5.93733e+05, 5.03119e+05, 4.25927e+05, 3.60218e+05,
 3.04322e+05, 2.56806e+05, 2.16436e+05, 1.82154e+05, 1.53056e+05,
 1.28365e+05, 1.07419e+05, 8.96537e+04, 7.45861e+04, 6.18066e+04,
 5.09676e+04, 4.17753e+04, 3.39825e+04, 2.73832e+04, 2.18079e+04,
 1.71202e+04, 1.32145e+04, 1.00153e+04, 7.47737e+03, 5.58789e+03}
,
{3.38794e+06, 3.29577e+07, 8.70740e+07, 1.43860e+08, 1.92099e+08,
 2.29735e+08, 2.57504e+08, 2.77150e+08, 2.91001e+08, 3.00659e+08,
 3.07042e+08, 3.10862e+08, 3.12937e+08, 3.13974e+08, 3.14374e+08,
 3.14309e+08, 3.13815e+08, 3.12986e+08, 3.11905e+08, 3.10550e+08,
 3.08854e+08, 3.06828e+08, 3.04521e+08, 3.01894e+08, 2.98846e+08,
 2.95278e+08, 2.91143e+08, 2.86372e+08, 2.80829e+08, 2.74359e+08,
 2.66838e+08, 2.58180e+08, 2.48309e+08, 2.37172e+08, 2.24786e+08,
 2.11260e+08, 1.96786e+08, 1.81621e+08, 1.66073e+08, 1.50483e+08,
 1.35189e+08, 1.24203e+08, 1.10399e+08, 9.75653e+07, 8.58092e+07,
 7.51736e+07, 6.56499e+07, 5.71915e+07, 4.97268e+07, 4.31710e+07,
 3.74338e+07, 3.24257e+07, 2.80624e+07, 2.42656e+07, 2.09652e+07,
 1.80985e+07, 1.56104e+07, 1.34524e+07, 1.15821e+07, 9.96243e+06,
 8.56097e+06, 7.34945e+06, 6.30314e+06, 5.40042e+06, 4.62240e+06,
 3.95256e+06, 3.37648e+06, 2.88158e+06, 2.45687e+06, 2.09278e+06,
 1.78100e+06, 1.51428e+06, 1.28634e+06, 1.09173e+06, 9.25736e+05,
 7.84278e+05, 6.63836e+05, 5.61373e+05, 4.74276e+05, 4.00295e+05,
 3.37499e+05, 2.84232e+05, 2.39074e+05, 2.00810e+05, 1.68402e+05,
 1.40962e+05, 1.17736e+05, 9.80779e+04, 8.14417e+04, 6.73623e+04,
 5.54465e+04, 4.53623e+04, 3.68311e+04, 2.96213e+04, 2.35422e+04,
 1.84404e+04, 1.41975e+04, 1.07281e+04, 7.98074e+03, 5.93950e+03}
,
{4.41396e+06, 4.25615e+07, 1.11672e+08, 1.83592e+08, 2.44332e+08,
 2.91478e+08, 3.26065e+08, 3.50425e+08, 3.67547e+08, 3.79412e+08,
 3.87167e+08, 3.91731e+08, 3.94179e+08, 3.95373e+08, 3.95796e+08,
 3.95633e+08, 3.94929e+08, 3.93820e+08, 3.92392e+08, 3.90597e+08,
 3.88357e+08, 3.85708e+08, 3.82700e+08, 3.79259e+08, 3.75244e+08,
 3.70544e+08, 3.65103e+08, 3.58809e+08, 3.51473e+08, 3.42899e+08,
 3.32944e+08, 3.21502e+08, 3.08478e+08, 2.93827e+08, 2.77604e+08,
 2.59990e+08, 2.41262e+08, 2.21777e+08, 2.01952e+08, 1.82233e+08,
 1.63046e+08, 1.49454e+08, 1.32379e+08, 1.16614e+08, 1.02262e+08,
 8.93500e+07, 7.78427e+07, 6.76645e+07, 5.87135e+07, 5.08759e+07,
 4.40342e+07, 3.80752e+07, 3.28936e+07, 2.83931e+07, 2.44876e+07,
 2.11012e+07, 1.81669e+07, 1.56262e+07, 1.34281e+07, 1.15280e+07,
 9.88689e+06, 8.47093e+06, 7.25042e+06, 6.19950e+06, 5.29557e+06,
 4.51893e+06, 3.85239e+06, 3.28096e+06, 2.79162e+06, 2.37302e+06,
 2.01531e+06, 1.70996e+06, 1.44956e+06, 1.22772e+06, 1.03890e+06,
 8.78339e+05, 7.41927e+05, 6.26128e+05, 5.27906e+05, 4.44656e+05,
 3.74146e+05, 3.14463e+05, 2.63976e+05, 2.21288e+05, 1.85212e+05,
 1.54733e+05, 1.28989e+05, 1.07249e+05, 8.88894e+04, 7.33854e+04,
 6.02917e+04, 4.92341e+04, 3.98990e+04, 3.20258e+04, 2.54003e+04,
 1.98505e+04, 1.52433e+04, 1.14829e+04, 8.51052e+03, 6.30654e+03}
,
{5.74825e+06, 5.49429e+07, 1.43171e+08, 2.34235e+08, 3.10698e+08,
 3.69744e+08, 4.12812e+08, 4.43015e+08, 4.64178e+08, 4.78748e+08,
 4.88158e+08, 4.93607e+08, 4.96489e+08, 4.97860e+08, 4.98291e+08,
 4.97982e+08, 4.96997e+08, 4.95520e+08, 4.93634e+08, 4.91257e+08,
 4.88304e+08, 4.84849e+08, 4.80926e+08, 4.76411e+08, 4.71123e+08,
 4.64937e+08, 4.57778e+08, 4.49471e+08, 4.39761e+08, 4.28406e+08,
 4.15241e+08, 4.00133e+08, 3.82969e+08, 3.63724e+08, 3.42521e+08,
 3.19637e+08, 2.95465e+08, 2.70498e+08, 2.45294e+08, 2.20427e+08,
 2.02275e+08, 1.79666e+08, 1.58600e+08, 1.39279e+08, 1.21795e+08,
 1.06145e+08, 9.22612e+07, 8.00279e+07, 6.93048e+07, 5.99412e+07,
 5.17872e+07, 4.46999e+07, 3.85489e+07, 3.32157e+07, 2.85956e+07,
 2.45962e+07, 2.11366e+07, 1.81463e+07, 1.55638e+07, 1.33355e+07,
 1.14146e+07, 9.76032e+06, 8.33724e+06, 7.11434e+06, 6.06463e+06,
 5.16460e+06, 4.39376e+06, 3.73432e+06, 3.17079e+06, 2.68976e+06,
 2.27958e+06, 1.93018e+06, 1.63287e+06, 1.38012e+06, 1.16545e+06,
 9.83306e+05, 8.28887e+05, 6.98084e+05, 5.87375e+05, 4.93743e+05,
 4.14610e+05, 3.47774e+05, 2.91356e+05, 2.43758e+05, 2.03618e+05,
 1.69780e+05, 1.41261e+05, 1.17228e+05, 9.69769e+04, 7.99118e+04,
 6.55305e+04, 5.34110e+04, 4.32007e+04, 3.46067e+04, 2.73888e+04,
 2.13544e+04, 1.63542e+04, 1.22804e+04, 9.06629e+03, 6.68805e+03}
,
{7.48269e+06, 7.08997e+07, 1.83494e+08, 2.98767e+08, 3.95005e+08,
 4.68938e+08, 5.22555e+08, 5.60001e+08, 5.86152e+08, 6.04033e+08,
 6.15440e+08, 6.21937e+08, 6.25328e+08, 6.26894e+08, 6.27312e+08,
 6.26790e+08, 6.25428e+08, 6.23470e+08, 6.20979e+08, 6.17832e+08,
 6.13951e+08, 6.09449e+08, 6.04327e+08, 5.98401e+08, 5.91436e+08,
 5.83302e+08, 5.73881e+08, 5.62912e+08, 5.50060e+08, 5.35033e+08,
 5.17640e+08, 4.97708e+08, 4.75117e+08, 4.49882e+08, 4.22229e+08,
 3.92567e+08, 3.61449e+08, 3.29546e+08, 2.97596e+08, 2.66330e+08,
 2.43809e+08, 2.15789e+08, 1.89863e+08, 1.66236e+08, 1.44975e+08,
 1.26038e+08, 1.09309e+08, 9.46213e+07, 8.17859e+07, 7.06064e+07,
 6.08927e+07, 5.24670e+07, 4.51674e+07, 3.88493e+07, 3.33852e+07,
 2.86631e+07, 2.45854e+07, 2.10671e+07, 1.80340e+07, 1.54217e+07,
 1.31741e+07, 1.12423e+07, 9.58373e+06, 8.16136e+06, 6.94294e+06,
 5.90041e+06, 5.00941e+06, 4.24877e+06, 3.60015e+06, 3.04765e+06,
 2.57755e+06, 2.17797e+06, 1.83867e+06, 1.55085e+06, 1.30693e+06,
 1.10040e+06, 9.25691e+05, 7.78018e+05, 6.53297e+05, 5.48042e+05,
 4.59277e+05, 3.84466e+05, 3.21454e+05, 2.68406e+05, 2.23767e+05,
 1.86217e+05, 1.54637e+05, 1.28083e+05, 1.05755e+05, 8.69801e+04,
 7.11913e+04, 5.79138e+04, 4.67509e+04, 3.73739e+04, 2.95141e+04,
 2.29556e+04, 1.75316e+04, 1.31206e+04, 9.64710e+03, 7.08262e+03}
,
{9.73665e+06, 9.14574e+07, 2.35102e+08, 3.80982e+08, 5.02084e+08,
 5.94636e+08, 6.61369e+08, 7.07794e+08, 7.40104e+08, 7.62036e+08,
 7.75846e+08, 7.83586e+08, 7.87570e+08, 7.89349e+08, 7.89719e+08,
 7.88893e+08, 7.87031e+08, 7.84440e+08, 7.81151e+08, 7.76988e+08,
 7.71900e+08, 7.66036e+08, 7.59347e+08, 7.51561e+08, 7.42394e+08,
 7.31704e+08, 7.19302e+08, 7.04814e+08, 6.87806e+08, 6.67938e+08,
 6.44976e+08, 6.18706e+08, 5.89009e+08, 5.55983e+08, 5.19995e+08,
 4.81639e+08, 4.41682e+08, 4.01030e+08, 3.60645e+08, 3.30653e+08,
 2.93593e+08, 2.58955e+08, 2.27122e+08, 1.98287e+08, 1.72478e+08,
 1.49598e+08, 1.29463e+08, 1.11845e+08, 9.64920e+07, 8.31517e+07,
 7.15855e+07, 6.15718e+07, 5.29117e+07, 4.54288e+07, 3.89682e+07,
 3.33944e+07, 2.85896e+07, 2.44512e+07, 2.08901e+07, 1.78289e+07,
 1.52001e+07, 1.29450e+07, 1.10129e+07, 9.35926e+06, 7.94567e+06,
 6.73867e+06, 5.70927e+06, 4.83235e+06, 4.08616e+06, 3.45192e+06,
 2.91340e+06, 2.45666e+06, 2.06965e+06, 1.74207e+06, 1.46505e+06,
 1.23099e+06, 1.03342e+06, 8.66784e+05, 7.26350e+05, 6.08088e+05,
 5.08567e+05, 4.24872e+05, 3.54527e+05, 2.95434e+05, 2.45815e+05,
 2.04165e+05, 1.69213e+05, 1.39886e+05, 1.15279e+05, 9.46310e+04,
 7.73044e+04, 6.27640e+04, 5.05643e+04, 4.03373e+04, 3.17820e+04,
 2.46572e+04, 1.87760e+04, 1.40025e+04, 1.02514e+04, 7.48829e+03}
,
{1.26652e+07, 1.17934e+08, 3.01132e+08, 4.85701e+08, 6.38056e+08,
 7.53894e+08, 8.36936e+08, 8.94489e+08, 9.34400e+08, 9.61283e+08,
 9.77983e+08, 9.87196e+08, 9.91868e+08, 9.93875e+08, 9.94144e+08,
 9.92892e+08, 9.90371e+08, 9.86948e+08, 9.82603e+08, 9.77104e+08,
 9.70448e+08, 9.62815e+08, 9.54069e+08, 9.43837e+08, 9.31779e+08,
 9.17734e+08, 9.01401e+08, 8.82261e+08, 8.59763e+08, 8.33517e+08,
 8.03228e+08, 7.68639e+08, 7.29661e+08, 6.86519e+08, 6.39789e+08,
 5.90308e+08, 5.39135e+08, 4.87477e+08, 4.36576e+08, 3.99256e+08,
 3.53225e+08, 3.10508e+08, 2.71506e+08, 2.36383e+08, 2.05104e+08,
 1.77494e+08, 1.53287e+08, 1.32170e+08, 1.13817e+08, 9.79071e+07,
 8.41400e+07, 7.22426e+07, 6.19712e+07, 5.31111e+07, 4.54742e+07,
 3.88970e+07, 3.32371e+07, 2.83710e+07, 2.41915e+07, 2.06055e+07,
 1.75320e+07, 1.49008e+07, 1.26509e+07, 1.07293e+07, 9.09008e+06,
 7.69334e+06, 6.50463e+06, 5.49414e+06, 4.63613e+06, 3.90840e+06,
 3.29184e+06, 2.77002e+06, 2.32882e+06, 1.95616e+06, 1.64170e+06,
 1.37659e+06, 1.15327e+06, 9.65330e+05, 8.07279e+05, 6.74466e+05,
 5.62941e+05, 4.69351e+05, 3.90858e+05, 3.25062e+05, 2.69933e+05,
 2.23756e+05, 1.85088e+05, 1.52712e+05, 1.25605e+05, 1.02907e+05,
 8.39008e+04, 6.79834e+04, 5.46559e+04, 4.35060e+04, 3.41976e+04,
 2.64608e+04, 2.00871e+04, 1.49246e+04, 1.08767e+04, 7.90238e+03}
,
{1.64689e+07, 1.52022e+08, 3.85590e+08, 6.19052e+08, 8.10689e+08,
 9.55640e+08, 1.05896e+09, 1.13030e+09, 1.17959e+09, 1.21252e+09,
 1.23269e+09, 1.24365e+09, 1.24912e+09, 1.25136e+09, 1.25145e+09,
 1.24961e+09, 1.24622e+09, 1.24171e+09, 1.23597e+09, 1.22871e+09,
 1.22002e+09, 1.21009e+09, 1.19864e+09, 1.18519e+09, 1.16934e+09,
 1.15089e+09, 1.12938e+09, 1.10408e+09, 1.07434e+09, 1.03970e+09,
 9.99780e+08, 9.54289e+08, 9.03208e+08, 8.46967e+08, 7.86420e+08,
 7.22743e+08, 6.57377e+08, 5.91915e+08, 5.27935e+08, 4.81640e+08,
 4.24610e+08, 3.72050e+08, 3.24362e+08, 2.81652e+08, 2.43799e+08,
 2.10520e+08, 1.81444e+08, 1.56154e+08, 1.34227e+08, 1.15259e+08,
 9.88778e+07, 8.47464e+07, 7.25672e+07, 6.20789e+07, 5.30541e+07,
 4.52948e+07, 3.86297e+07, 3.29098e+07, 2.80063e+07, 2.38072e+07,
 2.02153e+07, 1.71465e+07, 1.45278e+07, 1.22958e+07, 1.03958e+07,
 8.78022e+06, 7.40821e+06, 6.24439e+06, 5.25829e+06, 4.42370e+06,
 3.71813e+06, 3.12224e+06, 2.61951e+06, 2.19579e+06, 1.83901e+06,
 1.53886e+06, 1.28657e+06, 1.07470e+06, 8.96907e+05, 7.47825e+05,
 6.22905e+05, 5.18299e+05, 4.30756e+05, 3.57529e+05, 2.96304e+05,
 2.45132e+05, 2.02372e+05, 1.66645e+05, 1.36795e+05, 1.11854e+05,
 9.10124e+04, 7.35941e+04, 5.90399e+04, 4.68887e+04, 3.67646e+04,
 2.83669e+04, 2.14632e+04, 1.58840e+04, 1.15199e+04, 8.32151e+03}
,
{2.14074e+07, 1.95895e+08, 4.93588e+08, 7.88827e+08, 1.02983e+09,
 1.21117e+09, 1.33969e+09, 1.42813e+09, 1.48898e+09, 1.52930e+09,
 1.55362e+09, 1.56665e+09, 1.57304e+09, 1.57552e+09, 1.57531e+09,
 1.57267e+09, 1.56814e+09, 1.56218e+09, 1.55460e+09, 1.54505e+09,
 1.53373e+09, 1.52079e+09, 1.50580e+09, 1.48811e+09, 1.46730e+09,
 1.44307e+09, 1.41471e+09, 1.38129e+09, 1.34200e+09, 1.29631e+09,
 1.24374e+09, 1.18398e+09, 1.11716e+09, 1.04399e+09, 9.65715e+08,
 8.83969e+08, 8.00692e+08, 7.17965e+08, 6.56161e+08, 5.80505e+08,
 5.10015e+08, 4.45484e+08, 3.87285e+08, 3.35434e+08, 2.89684e+08,
 2.49616e+08, 2.14721e+08, 1.84449e+08, 1.58265e+08, 1.35661e+08,
 1.16176e+08, 9.93951e+07, 8.49572e+07, 7.25448e+07, 6.18825e+07,
 5.27316e+07, 4.48851e+07, 3.81640e+07, 3.24131e+07, 2.74979e+07,
 2.33020e+07, 1.97243e+07, 1.66777e+07, 1.40863e+07, 1.18850e+07,
 1.00173e+07, 8.43443e+06, 7.09464e+06, 5.96187e+06, 5.00522e+06,
 4.19816e+06, 3.51804e+06, 2.94547e+06, 2.46392e+06, 2.05931e+06,
 1.71966e+06, 1.43478e+06, 1.19604e+06, 9.96138e+05, 8.28872e+05,
 6.89014e+05, 5.72150e+05, 4.74555e+05, 3.93095e+05, 3.25131e+05,
 2.68446e+05, 2.21179e+05, 1.81770e+05, 1.48914e+05, 1.21518e+05,
 9.86719e+04, 7.96179e+04, 6.37298e+04, 5.04920e+04, 3.94850e+04,
 3.03743e+04, 2.29014e+04, 1.68767e+04, 1.21764e+04, 8.74179e+03}
,
{2.78167e+07, 2.52345e+08, 6.31654e+08, 1.00493e+09, 1.30795e+09,
 1.53478e+09, 1.69461e+09, 1.80424e+09, 1.87934e+09, 1.92866e+09,
 1.95798e+09, 1.97345e+09, 1.98089e+09, 1.98360e+09, 1.98294e+09,
 1.97919e+09, 1.97317e+09, 1.96533e+09, 1.95531e+09, 1.94277e+09,
 1.92803e+09, 1.91117e+09, 1.89153e+09, 1.86828e+09, 1.84097e+09,
 1.80912e+09, 1.77172e+09, 1.72758e+09, 1.67573e+09, 1.61551e+09,
 1.54635e+09, 1.46795e+09, 1.38068e+09, 1.28569e+09, 1.18473e+09,
 1.08004e+09, 9.74225e+08, 8.69959e+08, 7.93038e+08, 6.99073e+08,
 6.12143e+08, 5.33076e+08, 4.62173e+08, 3.99316e+08, 3.44088e+08,
 2.95891e+08, 2.54041e+08, 2.17829e+08, 1.86575e+08, 1.59647e+08,
 1.36474e+08, 1.16553e+08, 9.94417e+07, 8.47559e+07, 7.21625e+07,
 6.13734e+07, 5.21392e+07, 4.42443e+07, 3.75021e+07, 3.17511e+07,
 2.68515e+07, 2.26824e+07, 1.91394e+07, 1.61323e+07, 1.35831e+07,
 1.14247e+07, 9.59957e+06, 8.05794e+06, 6.75732e+06, 5.66125e+06,
 4.73857e+06, 3.96267e+06, 3.31087e+06, 2.76386e+06, 2.30523e+06,
 1.92105e+06, 1.59951e+06, 1.33064e+06, 1.10597e+06, 9.18387e+05,
 7.61876e+05, 6.31374e+05, 5.22622e+05, 4.32041e+05, 3.56627e+05,
 2.93861e+05, 2.41634e+05, 1.98181e+05, 1.62029e+05, 1.31947e+05,
 1.06912e+05, 8.60756e+04, 6.87372e+04, 5.43204e+04, 4.23586e+04,
 3.24800e+04, 2.43968e+04, 1.78970e+04, 1.28410e+04, 9.15902e+03}
,
{3.61320e+07, 3.24955e+08, 8.08113e+08, 1.27994e+09, 1.66088e+09,
 1.94454e+09, 2.14329e+09, 2.27917e+09, 2.37184e+09, 2.43213e+09,
 2.46741e+09, 2.48578e+09, 2.49443e+09, 2.49732e+09, 2.49596e+09,
 2.49075e+09, 2.48277e+09, 2.47243e+09, 2.45922e+09, 2.44277e+09,
 2.42361e+09, 2.40162e+09, 2.37586e+09, 2.34532e+09, 2.30950e+09,
 2.26763e+09, 2.21832e+09, 2.16003e+09, 2.09164e+09, 2.01235e+09,
 1.92144e+09, 1.81874e+09, 1.70499e+09, 1.58191e+09, 1.45198e+09,
 1.31825e+09, 1.18414e+09, 1.05308e+09, 9.57617e+08, 8.41187e+08,
 7.34215e+08, 6.37519e+08, 5.51279e+08, 4.75181e+08, 4.08583e+08,
 3.50657e+08, 3.00499e+08, 2.57201e+08, 2.19910e+08, 1.87839e+08,
 1.60289e+08, 1.36646e+08, 1.16371e+08, 9.89995e+07, 8.41295e+07,
 7.14129e+07, 6.05491e+07, 5.12787e+07, 4.33773e+07, 3.66509e+07,
 3.09320e+07, 2.60758e+07, 2.19575e+07, 1.84693e+07, 1.55186e+07,
 1.30257e+07, 1.09220e+07, 9.14900e+06, 7.65634e+06, 6.40113e+06,
 5.34675e+06, 4.46200e+06, 3.72035e+06, 3.09927e+06, 2.57965e+06,
 2.14531e+06, 1.78257e+06, 1.47988e+06, 1.22750e+06, 1.01722e+06,
 8.42154e+05, 6.96487e+05, 5.75353e+05, 4.74673e+05, 3.91027e+05,
 3.21555e+05, 2.63869e+05, 2.15975e+05, 1.76209e+05, 1.43188e+05,
 1.15764e+05, 9.29864e+04, 7.40709e+04, 5.83760e+04, 4.53828e+04,
 3.46784e+04, 2.59420e+04, 1.89378e+04, 1.35080e+04, 9.56883e+03}
,
{4.69159e+07, 4.18322e+08, 1.03358e+09, 1.62987e+09, 2.10866e+09,
 2.46331e+09, 2.71042e+09, 2.87884e+09, 2.99315e+09, 3.06678e+09,
 3.10920e+09, 3.13098e+09, 3.14100e+09, 3.14401e+09, 3.14164e+09,
 3.13447e+09, 3.12392e+09, 3.11031e+09, 3.09287e+09, 3.07136e+09,
 3.04645e+09, 3.01775e+09, 2.98397e+09, 2.94388e+09, 2.89689e+09,
 2.84183e+09, 2.77679e+09, 2.69986e+09, 2.60974e+09, 2.50541e+09,
 2.38605e+09, 2.25171e+09, 2.10372e+09, 1.94460e+09, 1.77776e+09,
 1.60735e+09, 1.43784e+09, 1.31021e+09, 1.15538e+09, 1.01143e+09,
 8.80065e+08, 7.62020e+08, 6.57280e+08, 5.65263e+08, 4.85032e+08,
 4.15466e+08, 3.55383e+08, 3.03636e+08, 2.59155e+08, 2.20970e+08,
 1.88225e+08, 1.60170e+08, 1.36152e+08, 1.15610e+08, 9.80566e+07,
 8.30727e+07, 7.02961e+07, 5.94145e+07, 5.01581e+07, 4.22941e+07,
 3.56216e+07, 2.99674e+07, 2.51824e+07, 2.11381e+07, 1.77242e+07,
 1.48461e+07, 1.24226e+07, 1.03844e+07, 8.67213e+06, 7.23534e+06,
 6.03102e+06, 5.02261e+06, 4.17912e+06, 3.47425e+06, 2.88580e+06,
 2.39496e+06, 1.98592e+06, 1.64532e+06, 1.36193e+06, 1.12633e+06,
 9.30578e+05, 7.68051e+05, 6.33182e+05, 5.21321e+05, 4.28580e+05,
 3.51716e+05, 2.88024e+05, 2.35252e+05, 1.91525e+05, 1.55290e+05,
 1.25259e+05, 1.00366e+05, 7.97367e+04, 6.26575e+04, 4.85520e+04,
 3.69606e+04, 2.75279e+04, 1.99911e+04, 1.41710e+04, 9.96660e+03}
,
{6.08962e+07, 5.38345e+08, 1.32160e+09, 2.07500e+09, 2.67670e+09,
 3.12000e+09, 3.42720e+09, 3.63593e+09, 3.77688e+09, 3.86675e+09,
 3.91770e+09, 3.94350e+09, 3.95507e+09, 3.95807e+09, 3.95424e+09,
 3.94447e+09, 3.93056e+09, 3.91263e+09, 3.88965e+09, 3.86158e+09,
 3.82919e+09, 3.79172e+09, 3.74738e+09, 3.69480e+09, 3.63317e+09,
 3.56075e+09, 3.47496e+09, 3.37349e+09, 3.25483e+09, 3.11765e+09,
 2.96112e+09, 2.78569e+09, 2.59352e+09, 2.38823e+09, 2.17451e+09,
 1.95790e+09, 1.74418e+09, 1.58522e+09, 1.39286e+09, 1.21529e+09,
 1.05426e+09, 9.10391e+08, 7.83356e+08, 6.72212e+08, 5.75640e+08,
 4.92148e+08, 4.20213e+08, 3.58393e+08, 3.05352e+08, 2.59899e+08,
 2.20988e+08, 1.87705e+08, 1.59261e+08, 1.34975e+08, 1.14261e+08,
 9.66107e+07, 8.15896e+07, 6.88213e+07, 5.79817e+07, 4.87914e+07,
 4.10095e+07, 3.44291e+07, 2.88719e+07, 2.41849e+07, 2.02369e+07,
 1.69156e+07, 1.41249e+07, 1.17828e+07, 9.81952e+06, 8.17563e+06,
 6.80067e+06, 5.65184e+06, 4.69294e+06, 3.89336e+06, 3.22724e+06,
 2.67281e+06, 2.21176e+06, 1.82866e+06, 1.51060e+06, 1.24672e+06,
 1.02794e+06, 8.46679e+05, 6.96578e+05, 5.72342e+05, 4.69556e+05,
 3.84544e+05, 3.14245e+05, 2.56117e+05, 2.08051e+05, 1.68301e+05,
 1.35423e+05, 1.08226e+05, 8.57361e+04, 6.71597e+04, 5.18558e+04,
 3.93151e+04, 2.91437e+04, 2.10480e+04, 1.48233e+04, 1.03481e+04}
,
{7.90141e+07, 6.92588e+08, 1.68944e+09, 2.64114e+09, 3.39716e+09,
 3.95116e+09, 4.33304e+09, 4.59171e+09, 4.76543e+09, 4.87502e+09,
 4.93616e+09, 4.96670e+09, 4.98000e+09, 4.98279e+09, 4.97691e+09,
 4.96371e+09, 4.94538e+09, 4.92176e+09, 4.89152e+09, 4.85495e+09,
 4.81285e+09, 4.76387e+09, 4.70569e+09, 4.63675e+09, 4.55592e+09,
 4.46062e+09, 4.34748e+09, 4.21376e+09, 4.05762e+09, 3.87741e+09,
 3.67239e+09, 3.44368e+09, 3.19465e+09, 2.93035e+09, 2.65722e+09,
 2.38257e+09, 2.11377e+09, 1.91634e+09, 1.67788e+09, 1.45927e+09,
 1.26225e+09, 1.08717e+09, 9.33282e+08, 7.99169e+08, 6.83016e+08,
 5.82866e+08, 4.96785e+08, 4.22953e+08, 3.59722e+08, 3.05631e+08,
 2.59402e+08, 2.19927e+08, 1.86250e+08, 1.57547e+08, 1.33108e+08,
 1.12325e+08, 9.46713e+07, 7.96947e+07, 6.70060e+07, 5.62699e+07,
 4.71981e+07, 3.95429e+07, 3.30916e+07, 2.76621e+07, 2.30985e+07,
 1.92674e+07, 1.60553e+07, 1.33653e+07, 1.11152e+07, 9.23521e+06,
 7.66612e+06, 6.35790e+06, 5.26829e+06, 4.36164e+06, 3.60794e+06,
 2.98196e+06, 2.46250e+06, 2.03179e+06, 1.67495e+06, 1.37953e+06,
 1.13512e+06, 9.33037e+05, 7.66047e+05, 6.28120e+05, 5.14244e+05,
 4.20252e+05, 3.42685e+05, 2.78677e+05, 2.25857e+05, 1.82263e+05,
 1.46278e+05, 1.16574e+05, 9.20657e+04, 7.18716e+04, 5.52800e+04,
 4.17276e+04, 3.07772e+04, 2.20990e+04, 1.54585e+04, 1.07096e+04}
,
{1.02491e+08, 8.90752e+08, 2.15908e+09, 3.36106e+09, 4.31083e+09,
 5.00303e+09, 5.47767e+09, 5.79820e+09, 6.01224e+09, 6.14577e+09,
 6.21906e+09, 6.25517e+09, 6.27038e+09, 6.27265e+09, 6.26391e+09,
 6.24620e+09, 6.22208e+09, 6.19097e+09, 6.15123e+09, 6.10366e+09,
 6.04891e+09, 5.98486e+09, 5.90852e+09, 5.81821e+09, 5.71216e+09,
 5.58671e+09, 5.43754e+09, 5.26145e+09, 5.05613e+09, 4.81963e+09,
 4.55145e+09, 4.25383e+09, 3.93172e+09, 3.59219e+09, 3.24394e+09,
 2.89655e+09, 2.63243e+09, 2.31476e+09, 2.01979e+09, 1.75117e+09,
 1.51052e+09, 1.29775e+09, 1.11155e+09, 9.49859e+08, 8.10254e+08,
 6.90185e+08, 5.87210e+08, 4.99060e+08, 4.23701e+08, 3.59345e+08,
 3.04435e+08, 2.57627e+08, 2.17763e+08, 1.83848e+08, 1.55026e+08,
 1.30561e+08, 1.09820e+08, 9.22598e+07, 7.74123e+07, 6.48755e+07,
 5.43042e+07, 4.54024e+07, 3.79165e+07, 3.16296e+07, 2.63565e+07,
 2.19394e+07, 1.82438e+07, 1.51556e+07, 1.25780e+07, 1.04289e+07,
 8.63903e+06, 7.14994e+06, 5.91234e+06, 4.88473e+06, 4.03231e+06,
 3.32582e+06, 2.74081e+06, 2.25677e+06, 1.85660e+06, 1.52599e+06,
 1.25305e+06, 1.02785e+06, 8.42140e+05, 6.89069e+05, 5.62949e+05,
 4.59062e+05, 3.73502e+05, 3.03041e+05, 2.45012e+05, 1.97214e+05,
 1.57840e+05, 1.25409e+05, 9.87152e+04, 7.67765e+04, 5.88065e+04,
 4.41817e+04, 3.24148e+04, 2.31341e+04, 1.60706e+04, 1.10487e+04}
,
{1.32903e+08, 1.14527e+09, 2.75859e+09, 4.27635e+09, 5.46932e+09,
 6.33402e+09, 6.92390e+09, 7.32104e+09, 7.58468e+09, 7.74721e+09,
 7.83500e+09, 7.87763e+09, 7.89494e+09, 7.89621e+09, 7.88355e+09,
 7.85992e+09, 7.82821e+09, 7.78722e+09, 7.73511e+09, 7.67330e+09,
 7.60205e+09, 7.51823e+09, 7.41812e+09, 7.29984e+09, 7.16067e+09,
 6.99550e+09, 6.79893e+09, 6.56721e+09, 6.29743e+09, 5.98734e+09,
 5.63707e+09, 5.25045e+09, 4.83466e+09, 4.39944e+09, 3.95645e+09,
 3.51812e+09, 3.18882e+09, 2.79388e+09, 2.42976e+09, 2.10029e+09,
 1.80679e+09, 1.54854e+09, 1.32347e+09, 1.12870e+09, 9.61004e+08,
 8.17123e+08, 6.93982e+08, 5.88765e+08, 4.98973e+08, 4.22420e+08,
 3.57214e+08, 3.01724e+08, 2.54550e+08, 2.14488e+08, 1.80506e+08,
 1.51716e+08, 1.27357e+08, 1.06776e+08, 8.94088e+07, 7.47751e+07,
 6.24615e+07, 5.21145e+07, 4.34316e+07, 3.61551e+07, 3.00650e+07,
 2.49743e+07, 2.07244e+07, 1.71805e+07, 1.42289e+07, 1.17732e+07,
 9.73244e+06, 8.03821e+06, 6.63310e+06, 5.46890e+06, 4.50521e+06,
 3.70821e+06, 3.04964e+06, 2.50589e+06, 2.05730e+06, 1.68747e+06,
 1.38278e+06, 1.13190e+06, 9.25449e+05, 7.55631e+05, 6.15996e+05,
 5.01206e+05, 4.06858e+05, 3.29315e+05, 2.65579e+05, 2.13186e+05,
 1.70117e+05, 1.34726e+05, 1.05666e+05, 8.18521e+04, 6.24139e+04,
 4.66592e+04, 3.40424e+04, 2.41442e+04, 1.66550e+04, 1.13635e+04}
 ,
{1.72288e+08, 1.47208e+09, 3.52371e+09, 5.43983e+09, 6.93802e+09,
 8.01800e+09, 8.75105e+09, 9.24306e+09, 9.56762e+09, 9.76529e+09,
 9.87037e+09, 9.92064e+09, 9.94018e+09, 9.93978e+09, 9.92176e+09,
 9.89038e+09, 9.84870e+09, 9.79471e+09, 9.72652e+09, 9.64626e+09,
 9.55348e+09, 9.44373e+09, 9.31254e+09, 9.15767e+09, 8.97495e+09,
 8.75748e+09, 8.49860e+09, 8.19388e+09, 7.83966e+09, 7.43354e+09,
 6.97675e+09, 6.47544e+09, 5.93979e+09, 5.38311e+09, 4.82093e+09,
 4.26919e+09, 3.85970e+09, 3.36973e+09, 2.92111e+09, 2.51770e+09,
 2.16026e+09, 1.84719e+09, 1.57539e+09, 1.34092e+09, 1.13959e+09,
 9.67248e+08, 8.20038e+08, 6.94481e+08, 5.87515e+08, 4.96474e+08,
 4.19058e+08, 3.53292e+08, 2.97482e+08, 2.50173e+08, 2.10119e+08,
 1.76252e+08, 1.47655e+08, 1.23540e+08, 1.03235e+08, 8.61603e+07,
 7.18231e+07, 5.98010e+07, 4.97341e+07, 4.13157e+07, 3.42849e+07,
 2.84206e+07, 2.35351e+07, 1.94701e+07, 1.60916e+07, 1.32869e+07,
 1.09610e+07, 9.03414e+06, 7.43951e+06, 6.12110e+06, 5.03207e+06,
 4.13332e+06, 3.39224e+06, 2.78166e+06, 2.27898e+06, 1.86543e+06,
 1.52542e+06, 1.24605e+06, 1.01662e+06, 8.28278e+05, 6.73725e+05,
 5.46927e+05, 4.42916e+05, 3.57600e+05, 2.87612e+05, 2.30199e+05,
 1.83108e+05, 1.44504e+05, 1.12892e+05, 8.70712e+04, 6.60780e+04,
 4.91399e+04, 3.56461e+04, 2.51216e+04, 1.72082e+04, 1.16529e+04}
};

const std::vector< std::vector<double> > PROPOSAL::y_nu_n = {
{0.0523654, 0.053949 , 0.0555805, 0.0572613, 0.0589929, 0.060777 ,
 0.0626149, 0.0645085, 0.0664593, 0.0684691, 0.0705397, 0.0726729,
 0.0748707, 0.0771348, 0.0794675, 0.0818707, 0.0843466, 0.0868973,
 0.0895252, 0.0922326, 0.0950218, 0.0978954, 0.100856 , 0.103906 ,
 0.107048 , 0.110285 , 0.113621 , 0.117057 , 0.120597 , 0.124244 ,
 0.128001 , 0.131872 , 0.13586  , 0.139968 , 0.144201 , 0.148562 ,
 0.153055 , 0.157683 , 0.162452 , 0.167364 , 0.172426 , 0.17764  ,
 0.183012 , 0.188547 , 0.194249 , 0.200123 , 0.206175 , 0.21241  ,
 0.218833 , 0.225451 , 0.232269 , 0.239293 , 0.24653  , 0.253985 ,
 0.261666 , 0.269579 , 0.277732 , 0.286131 , 0.294784 , 0.303698 ,
 0.312882 , 0.322344 , 0.332092 , 0.342135 , 0.352482 , 0.363141 ,
 0.374123 , 0.385437 , 0.397093 , 0.409102 , 0.421474 , 0.43422  ,
 0.447351 , 0.460879 , 0.474817 , 0.489176 , 0.503969 , 0.51921  ,
 0.534912 , 0.551088 , 0.567754 , 0.584923 , 0.602612 , 0.620836 ,
 0.639611 , 0.658953 , 0.678881 , 0.699411 , 0.720562 , 0.742353 ,
 0.764803 , 0.787931 , 0.811759 , 0.836308 , 0.861599 , 0.887655 ,
 0.914499 , 0.942154 , 0.970646 , 1.       }
,
{0.0420756, 0.0434439, 0.0448568, 0.0463155, 0.0478217, 0.0493769,
 0.0509827, 0.0526407, 0.0543526, 0.0561201, 0.0579452, 0.0598296,
 0.0617753, 0.0637842, 0.0658585, 0.0680003, 0.0702117, 0.072495 ,
 0.0748526, 0.0772868, 0.0798002, 0.0823954, 0.0850749, 0.0878416,
 0.0906982, 0.0936478, 0.0966933, 0.0998378, 0.103085 , 0.106437 ,
 0.109898 , 0.113472 , 0.117162 , 0.120973 , 0.124907 , 0.128969 ,
 0.133163 , 0.137493 , 0.141965 , 0.146581 , 0.151348 , 0.15627  ,
 0.161352 , 0.1666   , 0.172017 , 0.177612 , 0.183388 , 0.189351 ,
 0.195509 , 0.201867 , 0.208432 , 0.21521  , 0.222209 , 0.229436 ,
 0.236897 , 0.244601 , 0.252555 , 0.260769 , 0.269249 , 0.278005 ,
 0.287046 , 0.296381 , 0.306019 , 0.315971 , 0.326247 , 0.336856 ,
 0.347811 , 0.359122 , 0.370801 , 0.38286  , 0.39531  , 0.408166 ,
 0.42144  , 0.435145 , 0.449296 , 0.463908 , 0.478994 , 0.494571 ,
 0.510655 , 0.527262 , 0.544409 , 0.562113 , 0.580393 , 0.599268 ,
 0.618757 , 0.638879 , 0.659655 , 0.681108 , 0.703258 , 0.726128 ,
 0.749742 , 0.774124 , 0.799299 , 0.825293 , 0.852131 , 0.879843 ,
 0.908456 , 0.938    , 0.968504 , 1.       }
,
{0.0337461, 0.0349213, 0.0361374, 0.0373958, 0.0386981, 0.0400457,
 0.0414402, 0.0428833, 0.0443767, 0.0459221, 0.0475212, 0.0491761,
 0.0508886, 0.0526608, 0.0544946, 0.0563923, 0.0583561, 0.0603883,
 0.0624913, 0.0646674, 0.0669194, 0.0692498, 0.0716613, 0.0741569,
 0.0767393, 0.0794117, 0.0821771, 0.0850388, 0.0880002, 0.0910647,
 0.0942359, 0.0975176, 0.100913 , 0.104428 , 0.108064 , 0.111827 ,
 0.115722 , 0.119752 , 0.123922 , 0.128237 , 0.132703 , 0.137324 ,
 0.142106 , 0.147055 , 0.152176 , 0.157475 , 0.162959 , 0.168634 ,
 0.174507 , 0.180584 , 0.186872 , 0.19338  , 0.200114 , 0.207083 ,
 0.214294 , 0.221757 , 0.229479 , 0.237471 , 0.24574  , 0.254298 ,
 0.263154 , 0.272318 , 0.281801 , 0.291614 , 0.301769 , 0.312278 ,
 0.323153 , 0.334406 , 0.346051 , 0.358102 , 0.370573 , 0.383478 ,
 0.396832 , 0.410651 , 0.424951 , 0.43975  , 0.455064 , 0.470911 ,
 0.48731  , 0.50428  , 0.521841 , 0.540013 , 0.558818 , 0.578279 ,
 0.598417 , 0.619256 , 0.640821 , 0.663136 , 0.686229 , 0.710126 ,
 0.734856 , 0.760446 , 0.786928 , 0.814332 , 0.84269  , 0.872036 ,
 0.902403 , 0.933829 , 0.966348 , 1.       }
,
{0.0270257, 0.0280296, 0.0290709, 0.0301508, 0.0312708, 0.0324325,
 0.0336373, 0.0348868, 0.0361828, 0.0375269, 0.0389209, 0.0403667,
 0.0418663, 0.0434215, 0.0450345, 0.0467075, 0.0484425, 0.0502421,
 0.0521085, 0.0540442, 0.0560518, 0.058134 , 0.0602935, 0.0625333,
 0.0648563, 0.0672656, 0.0697643, 0.0723559, 0.0750438, 0.0778315,
 0.0807227, 0.0837214, 0.0868315, 0.0900571, 0.0934025, 0.0968722,
 0.100471 , 0.104203 , 0.108074 , 0.112089 , 0.116253 , 0.120571 ,
 0.12505  , 0.129695 , 0.134513 , 0.13951  , 0.144693 , 0.150068 ,
 0.155642 , 0.161424 , 0.167421 , 0.17364  , 0.18009  , 0.18678  ,
 0.193719 , 0.200915 , 0.208378 , 0.216119 , 0.224147 , 0.232474 ,
 0.24111  , 0.250067 , 0.259356 , 0.268991 , 0.278983 , 0.289347 ,
 0.300095 , 0.311243 , 0.322805 , 0.334796 , 0.347233 , 0.360132 ,
 0.37351  , 0.387386 , 0.401776 , 0.416701 , 0.432181 , 0.448235 ,
 0.464886 , 0.482156 , 0.500067 , 0.518643 , 0.537909 , 0.557892 ,
 0.578616 , 0.60011  , 0.622403 , 0.645524 , 0.669504 , 0.694374 ,
 0.720169 , 0.746921 , 0.774668 , 0.803445 , 0.833291 , 0.864246 ,
 0.896351 , 0.929648 , 0.964183 , 1.       }
,
{0.021618 , 0.0224717, 0.0233591, 0.0242815, 0.0252404, 0.0262371,
 0.0272732, 0.0283502, 0.0294697, 0.0306335, 0.0318432, 0.0331006,
 0.0344077, 0.0357665, 0.0371789, 0.0386471, 0.0401732, 0.0417596,
 0.0434087, 0.0451229, 0.0469047, 0.048757 , 0.0506823, 0.0526838,
 0.0547642, 0.0569268, 0.0591748, 0.0615116, 0.0639406, 0.0664656,
 0.0690903, 0.0718186, 0.0746547, 0.0776028, 0.0806672, 0.0838527,
 0.087164 , 0.0906061, 0.0941841, 0.0979033, 0.101769 , 0.105788 ,
 0.109966 , 0.114308 , 0.118822 , 0.123514 , 0.128392 , 0.133462 ,
 0.138732 , 0.144211 , 0.149906 , 0.155825 , 0.161979 , 0.168375 ,
 0.175024 , 0.181936 , 0.18912  , 0.196589 , 0.204352 , 0.212421 ,
 0.22081  , 0.229529 , 0.238593 , 0.248015 , 0.257809 , 0.26799  ,
 0.278573 , 0.289573 , 0.301008 , 0.312895 , 0.325251 , 0.338095 ,
 0.351446 , 0.365325 , 0.379751 , 0.394747 , 0.410335 , 0.426539 ,
 0.443383 , 0.460892 , 0.479092 , 0.498011 , 0.517677 , 0.53812  ,
 0.55937  , 0.581459 , 0.604421 , 0.628289 , 0.6531   , 0.67889  ,
 0.705699 , 0.733567 , 0.762535 , 0.792647 , 0.823948 , 0.856485 ,
 0.890307 , 0.925465 , 0.962011 , 1.       }
,
{0.017276 , 0.0179989, 0.0187521, 0.0195368, 0.0203543, 0.0212061,
 0.0220935, 0.023018 , 0.0239812, 0.0249847, 0.0260303, 0.0271195,
 0.0282544, 0.0294367, 0.0306685, 0.0319519, 0.0332889, 0.034682 ,
 0.0361333, 0.0376453, 0.0392206, 0.0408619, 0.0425718, 0.0443532,
 0.0462093, 0.0481429, 0.0501575, 0.0522564, 0.0544432, 0.0567214,
 0.059095 , 0.0615679, 0.0641443, 0.0668285, 0.069625 , 0.0725385,
 0.075574 , 0.0787365, 0.0820313, 0.085464 , 0.0890403, 0.0927663,
 0.0966483, 0.100693 , 0.104906 , 0.109296 , 0.11387  , 0.118635 ,
 0.123599 , 0.128771 , 0.13416  , 0.139774 , 0.145623 , 0.151717 ,
 0.158066 , 0.16468  , 0.171571 , 0.178751 , 0.186231 , 0.194024 ,
 0.202143 , 0.210602 , 0.219415 , 0.228597 , 0.238163 , 0.248129 ,
 0.258512 , 0.26933  , 0.2806   , 0.292342 , 0.304576 , 0.317321 ,
 0.3306   , 0.344434 , 0.358847 , 0.373864 , 0.389508 , 0.405808 ,
 0.422789 , 0.440482 , 0.458914 , 0.478118 , 0.498125 , 0.51897  ,
 0.540687 , 0.563313 , 0.586885 , 0.611444 , 0.637031 , 0.663688 ,
 0.691461 , 0.720396 , 0.750541 , 0.781949 , 0.81467  , 0.848761 ,
 0.884279 , 0.921282 , 0.959835 , 1.       }
,
{0.0137955, 0.0144055, 0.0150425, 0.0157076, 0.0164021, 0.0171274,
 0.0178847, 0.0186755, 0.0195013, 0.0203635, 0.0212639, 0.0222042,
 0.023186 , 0.0242112, 0.0252817, 0.0263995, 0.0275668, 0.0287857,
 0.0300585, 0.0313876, 0.0327755, 0.0342247, 0.035738 , 0.0373182,
 0.0389683, 0.0406913, 0.0424905, 0.0443693, 0.0463312, 0.0483798,
 0.0505189, 0.0527527, 0.0550852, 0.0575209, 0.0600643, 0.0627201,
 0.0654934, 0.0683893, 0.0714132, 0.0745708, 0.0778681, 0.0813111,
 0.0849064, 0.0886607, 0.0925809, 0.0966745, 0.100949 , 0.105413 ,
 0.110074 , 0.114941 , 0.120023 , 0.12533  , 0.130872 , 0.136658 ,
 0.142701 , 0.149011 , 0.155599 , 0.162479 , 0.169664 , 0.177166 ,
 0.184999 , 0.193179 , 0.201721 , 0.21064  , 0.219954 , 0.22968  ,
 0.239835 , 0.25044  , 0.261513 , 0.273077 , 0.285151 , 0.297759 ,
 0.310925 , 0.324673 , 0.339029 , 0.35402  , 0.369673 , 0.386019 ,
 0.403087 , 0.42091  , 0.439522 , 0.458956 , 0.479249 , 0.50044  ,
 0.522567 , 0.545673 , 0.569801 , 0.594996 , 0.621304 , 0.648776 ,
 0.677463 , 0.707418 , 0.738697 , 0.77136  , 0.805466 , 0.841081 ,
 0.878271 , 0.917105 , 0.957656 , 1.       }
,
{0.0110096, 0.0115226, 0.0120596, 0.0126215, 0.0132097, 0.0138252,
 0.0144694, 0.0151437, 0.0158494, 0.0165879, 0.0173609, 0.0181699,
 0.0190166, 0.0199027, 0.0208302, 0.0218008, 0.0228167, 0.0238799,
 0.0249927, 0.0261573, 0.0273762, 0.0286519, 0.029987 , 0.0313844,
 0.0328468, 0.0343774, 0.0359794, 0.037656 , 0.0394107, 0.0412471,
 0.0431692, 0.0451808, 0.0472862, 0.0494896, 0.0517958, 0.0542094,
 0.0567354, 0.0593792, 0.0621462, 0.0650421, 0.068073 , 0.0712451,
 0.074565 , 0.0780396, 0.0816761, 0.0854821, 0.0894654, 0.0936344,
 0.0979976, 0.102564 , 0.107343 , 0.112346 , 0.117581 , 0.12306  ,
 0.128794 , 0.134796 , 0.141077 , 0.147651 , 0.154531 , 0.161732 ,
 0.169269 , 0.177156 , 0.185412 , 0.194051 , 0.203094 , 0.212558 ,
 0.222463 , 0.232829 , 0.243679 , 0.255034 , 0.266918 , 0.279356 ,
 0.292373 , 0.305997 , 0.320256 , 0.33518  , 0.350799 , 0.367145 ,
 0.384254 , 0.402159 , 0.420899 , 0.440513 , 0.46104  , 0.482524 ,
 0.505008 , 0.528541 , 0.55317  , 0.578947 , 0.605925 , 0.63416  ,
 0.663711 , 0.694639 , 0.727008 , 0.760886 , 0.796342 , 0.83345  ,
 0.872288 , 0.912935 , 0.955476 , 1.       }
,
{0.008782  , 0.00921223, 0.00966355, 0.010137  , 0.0106336 , 0.0111546 ,
 0.011701  , 0.0122743 , 0.0128756 , 0.0135064 , 0.0141681 , 0.0148622 ,
 0.0155903 , 0.0163541 , 0.0171553 , 0.0179958 , 0.0188774 , 0.0198022 ,
 0.0207723 , 0.02179   , 0.0228575 , 0.0239773 , 0.025152  , 0.0263842 ,
 0.0276768 , 0.0290327 , 0.0304551 , 0.0319471 , 0.0335122 , 0.035154  ,
 0.0368763 , 0.0386829 , 0.040578  , 0.0425659 , 0.0446513 , 0.0468388 ,
 0.0491335 , 0.0515406 , 0.0540656 , 0.0567143 , 0.0594928 , 0.0624074 ,
 0.0654649 , 0.068672  , 0.0720364 , 0.0755655 , 0.0792675 , 0.0831509 ,
 0.0872246 , 0.0914978 , 0.0959804 , 0.100683  , 0.105615  , 0.110789  ,
 0.116217  , 0.121911  , 0.127883  , 0.134148  , 0.14072   , 0.147614  ,
 0.154846  , 0.162432  , 0.17039   , 0.178738  , 0.187494  , 0.19668   ,
 0.206315  , 0.216423  , 0.227026  , 0.238148  , 0.249815  , 0.262054  ,
 0.274892  , 0.288359  , 0.302486  , 0.317305  , 0.33285   , 0.349157  ,
 0.366263  , 0.384206  , 0.403029  , 0.422774  , 0.443486  , 0.465213  ,
 0.488004  , 0.511912  , 0.536991  , 0.563298  , 0.590895  , 0.619844  ,
 0.65021   , 0.682065  , 0.71548   , 0.750532  , 0.787301  , 0.825872  ,
 0.866333  , 0.908775  , 0.953297  , 1.        }
,
{0.00700241, 0.00736228, 0.00774065, 0.00813847, 0.00855673, 0.00899649,
 0.00945885, 0.00994497, 0.0104561 , 0.0109934 , 0.0115584 , 0.0121525 ,
 0.012777  , 0.0134337 , 0.0141241 , 0.0148499 , 0.0156131 , 0.0164155 ,
 0.0172592 , 0.0181462 , 0.0190788 , 0.0200593 , 0.0210902 , 0.0221741 ,
 0.0233137 , 0.0245119 , 0.0257716 , 0.0270961 , 0.0284887 , 0.0299528 ,
 0.0314922 , 0.0331107 , 0.0348123 , 0.0366014 , 0.0384825 , 0.0404602 ,
 0.0425396 , 0.0447259 , 0.0470245 , 0.0494412 , 0.0519822 , 0.0546537 ,
 0.0574625 , 0.0604157 , 0.0635207 , 0.0667852 , 0.0702175 , 0.0738262 ,
 0.0776204 , 0.0816096 , 0.0858037 , 0.0902135 , 0.0948498 , 0.0997245 ,
 0.10485   , 0.110238  , 0.115904  , 0.12186   , 0.128123  , 0.134708  ,
 0.141631  , 0.14891   , 0.156563  , 0.164609  , 0.173069  , 0.181963  ,
 0.191315  , 0.201147  , 0.211485  , 0.222354  , 0.233781  , 0.245796  ,
 0.258428  , 0.27171   , 0.285674  , 0.300356  , 0.315792  , 0.332021  ,
 0.349085  , 0.367026  , 0.385888  , 0.40572   , 0.426572  , 0.448495  ,
 0.471544  , 0.495778  , 0.521258  , 0.548047  , 0.576213  , 0.605826  ,
 0.636962  , 0.669697  , 0.704115  , 0.740302  , 0.778349  , 0.81835   ,
 0.860408  , 0.904627  , 0.951119  , 1.        }
,
{0.00558171, 0.00588203, 0.00619851, 0.00653202, 0.00688347, 0.00725383,
 0.00764411, 0.0080554 , 0.00848881, 0.00894554, 0.00942685, 0.00993406,
 0.0104686 , 0.0110318 , 0.0116254 , 0.0122509 , 0.01291   , 0.0136046 ,
 0.0143366 , 0.015108  , 0.0159208 , 0.0167774 , 0.0176801 , 0.0186314 ,
 0.0196339 , 0.0206902 , 0.0218035 , 0.0229766 , 0.0242128 , 0.0255156 ,
 0.0268884 , 0.0283351 , 0.0298597 , 0.0314662 , 0.0331593 , 0.0349434 ,
 0.0368235 , 0.0388047 , 0.0408926 , 0.0430928 , 0.0454114 , 0.0478547 ,
 0.0504295 , 0.0531428 , 0.0560021 , 0.0590152 , 0.0621905 , 0.0655366 ,
 0.0690627 , 0.0727786 , 0.0766944 , 0.0808209 , 0.0851694 , 0.0897519 ,
 0.0945809 , 0.0996697 , 0.105032  , 0.110684  , 0.116639  , 0.122914  ,
 0.129528  , 0.136497  , 0.143841  , 0.15158   , 0.159736  , 0.16833   ,
 0.177387  , 0.186931  , 0.196989  , 0.207588  , 0.218757  , 0.230527  ,
 0.24293   , 0.256001  , 0.269775  , 0.28429   , 0.299586  , 0.315705  ,
 0.332691  , 0.350592  , 0.369455  , 0.389333  , 0.410281  , 0.432356  ,
 0.455618  , 0.480132  , 0.505966  , 0.533189  , 0.561876  , 0.592108  ,
 0.623966  , 0.657538  , 0.692916  , 0.730198  , 0.769485  , 0.810887  ,
 0.854516  , 0.900493  , 0.948943  , 1.        }
,
{0.00444817, 0.00469826, 0.00496241, 0.00524141, 0.0055361 , 0.00584736,
 0.00617612, 0.00652336, 0.00689013, 0.00727751, 0.00768668, 0.00811885,
 0.00857532, 0.00905745, 0.00956669, 0.0101046 , 0.0106727 , 0.0112727 ,
 0.0119065 , 0.0125759 , 0.013283  , 0.0140298 , 0.0148186 , 0.0156518 ,
 0.0165318 , 0.0174612 , 0.018443  , 0.0194799 , 0.0205751 , 0.0217319 ,
 0.0229537 , 0.0242443 , 0.0256074 , 0.0270471 , 0.0285678 , 0.030174  ,
 0.0318704 , 0.0336623 , 0.0355549 , 0.0375539 , 0.0396653 , 0.0418954 ,
 0.0442509 , 0.0467389 , 0.0493667 , 0.0521422 , 0.0550739 , 0.0581703 ,
 0.0614408 , 0.0648952 , 0.0685438 , 0.0723976 , 0.076468  , 0.0807673 ,
 0.0853083 , 0.0901046 , 0.0951706 , 0.100521  , 0.106173  , 0.112142  ,
 0.118448  , 0.125107  , 0.132141  , 0.13957   , 0.147417  , 0.155706  ,
 0.16446   , 0.173707  , 0.183473  , 0.193788  , 0.204684  , 0.216192  ,
 0.228347  , 0.241185  , 0.254745  , 0.269068  , 0.284196  , 0.300174  ,
 0.317051  , 0.334877  , 0.353705  , 0.373591  , 0.394596  , 0.416781  ,
 0.440214  , 0.464964  , 0.491106  , 0.518718  , 0.547882  , 0.578685  ,
 0.611221  , 0.645586  , 0.681883  , 0.720221  , 0.760714  , 0.803484  ,
 0.848658  , 0.896372  , 0.946769  , 1.        }
,
{0.00354413, 0.003752  , 0.00397205, 0.00420501, 0.00445164, 0.00471273,
 0.00498913, 0.00528174, 0.00559151, 0.00591946, 0.00626663, 0.00663417,
 0.00702327, 0.00743518, 0.00787125, 0.0083329 , 0.00882163, 0.00933902,
 0.00988675, 0.0104666 , 0.0110805 , 0.0117303 , 0.0124183 , 0.0131467 ,
 0.0139177 , 0.014734  , 0.0155981 , 0.016513  , 0.0174815 , 0.0185068 ,
 0.0195922 , 0.0207413 , 0.0219577 , 0.0232456 , 0.0246089 , 0.0260522 ,
 0.0275802 , 0.0291978 , 0.0309102 , 0.0327231 , 0.0346423 , 0.0366741 ,
 0.038825  , 0.0411021 , 0.0435128 , 0.0460648 , 0.0487665 , 0.0516267 ,
 0.0546546 , 0.0578601 , 0.0612535 , 0.0648461 , 0.0686493 , 0.0726756 ,
 0.076938  , 0.0814504 , 0.0862275 , 0.0912847 , 0.0966386 , 0.102306  ,
 0.108307  , 0.114659  , 0.121384  , 0.128503  , 0.13604   , 0.144018  ,
 0.152465  , 0.161407  , 0.170874  , 0.180895  , 0.191505  , 0.202737  ,
 0.214627  , 0.227215  , 0.240541  , 0.254649  , 0.269584  , 0.285395  ,
 0.302134  , 0.319854  , 0.338613  , 0.358473  , 0.379497  , 0.401755  ,
 0.425318  , 0.450263  , 0.476671  , 0.504627  , 0.534224  , 0.565556  ,
 0.598726  , 0.633841  , 0.671016  , 0.710371  , 0.752035  , 0.796142  ,
 0.842835  , 0.892268  , 0.944599  , 1.        }
,
{0.00282339, 0.00299586, 0.00317886, 0.00337303, 0.00357907, 0.0037977 ,
 0.00402968, 0.00427583, 0.00453701, 0.00481415, 0.00510822, 0.00542025,
 0.00575134, 0.00610265, 0.00647543, 0.00687097, 0.00729068, 0.00773602,
 0.00820857, 0.00870998, 0.00924202, 0.00980656, 0.0104056 , 0.0110412 ,
 0.0117156 , 0.0124313 , 0.0131906 , 0.0139964 , 0.0148513 , 0.0157585 ,
 0.0167211 , 0.0177425 , 0.0188263 , 0.0199763 , 0.0211965 , 0.0224913 ,
 0.0238651 , 0.0253229 , 0.0268697 , 0.028511  , 0.0302526 , 0.0321006 ,
 0.0340614 , 0.036142  , 0.0383497 , 0.0406922 , 0.0431779 , 0.0458154 ,
 0.048614  , 0.0515835 , 0.0547344 , 0.0580778 , 0.0616255 , 0.0653898 ,
 0.0693841 , 0.0736223 , 0.0781195 , 0.0828913 , 0.0879547 , 0.0933273 ,
 0.0990281 , 0.105077  , 0.111496  , 0.118306  , 0.125533  , 0.133201  ,
 0.141337  , 0.149971  , 0.159132  , 0.168852  , 0.179166  , 0.19011   ,
 0.201723  , 0.214045  , 0.22712   , 0.240993  , 0.255714  , 0.271334  ,
 0.287909  , 0.305495  , 0.324156  , 0.343957  , 0.364967  , 0.387261  ,
 0.410916  , 0.436017  , 0.46265   , 0.490911  , 0.520898  , 0.552716  ,
 0.586478  , 0.622303  , 0.660316  , 0.70065   , 0.743449  , 0.788862  ,
 0.837049  , 0.888179  , 0.942432  , 1.        }
,
{0.00224895, 0.00239181, 0.00254375, 0.00270534, 0.0028772 , 0.00305997,
 0.00325436, 0.00346109, 0.00368096, 0.00391479, 0.00416348, 0.00442796,
 0.00470925, 0.0050084 , 0.00532656, 0.00566493, 0.00602479, 0.00640752,
 0.00681456, 0.00724745, 0.00770784, 0.00819748, 0.00871823, 0.00927205,
 0.00986106, 0.0104875 , 0.0111537 , 0.0118622 , 0.0126158 , 0.0134172 ,
 0.0142695 , 0.015176  , 0.0161401 , 0.0171654 , 0.0182558 , 0.0194155 ,
 0.0206488 , 0.0219606 , 0.0233556 , 0.0248393 , 0.0264172 , 0.0280953 ,
 0.0298801 , 0.0317782 , 0.0337969 , 0.0359439 , 0.0382272 , 0.0406556 ,
 0.0432382 , 0.045985  , 0.0489061 , 0.0520129 , 0.055317  , 0.058831  ,
 0.0625683 , 0.0665429 , 0.0707701 , 0.0752657 , 0.080047  , 0.085132  ,
 0.09054   , 0.0962915 , 0.102408  , 0.108914  , 0.115833  , 0.123191  ,
 0.131017  , 0.139339  , 0.148191  , 0.157605  , 0.167617  , 0.178264  ,
 0.189589  , 0.201632  , 0.214441  , 0.228063  , 0.242551  , 0.257959  ,
 0.274346  , 0.291774  , 0.310309  , 0.330021  , 0.350986  , 0.373282  ,
 0.396995  , 0.422214  , 0.449035  , 0.47756   , 0.507897  , 0.540161  ,
 0.574475  , 0.610968  , 0.64978   , 0.691057  , 0.734956  , 0.781644  ,
 0.831298  , 0.884107  , 0.940269  , 1.        }
,
{0.0017912 , 0.00190937, 0.00203534, 0.00216961, 0.00231275, 0.00246533,
 0.00262797, 0.00280134, 0.00298616, 0.00318316, 0.00339316, 0.00361702,
 0.00385564, 0.00411001, 0.00438115, 0.00467019, 0.00497829, 0.00530673,
 0.00565682, 0.00603002, 0.00642783, 0.00685189, 0.00730393, 0.00778579,
 0.00829944, 0.00884697, 0.00943063, 0.0100528 , 0.010716  , 0.011423  ,
 0.0121766 , 0.0129799 , 0.0138362 , 0.014749  , 0.015722  , 0.0167593 ,
 0.0178649 , 0.0190435 , 0.0202999 , 0.0216391 , 0.0230667 , 0.0245884 ,
 0.0262106 , 0.0279398 , 0.029783  , 0.0317479 , 0.0338424 , 0.0360751 ,
 0.038455  , 0.040992  , 0.0436964 , 0.0465791 , 0.0496521 , 0.0529277 ,
 0.0564195 , 0.0601416 , 0.0641093 , 0.0683388 , 0.0728473 , 0.0776532 ,
 0.0827762 , 0.0882371 , 0.0940584 , 0.100264  , 0.106878  , 0.113929  ,
 0.121446  , 0.129458  , 0.137998  , 0.147102  , 0.156807  , 0.167152  ,
 0.178179  , 0.189934  , 0.202465  , 0.215822  , 0.23006   , 0.245238  ,
 0.261417  , 0.278663  , 0.297047  , 0.316644  , 0.337534  , 0.359802  ,
 0.383539  , 0.408842  , 0.435815  , 0.464566  , 0.495215  , 0.527886  ,
 0.562712  , 0.599835  , 0.639408  , 0.681591  , 0.726557  , 0.77449   ,
 0.825585  , 0.880051  , 0.93811   , 1.        }
,
{0.00142651, 0.00152412, 0.00162841, 0.00173984, 0.00185889, 0.00198609,
 0.00212199, 0.00226719, 0.00242233, 0.00258808, 0.00276517, 0.00295439,
 0.00315654, 0.00337254, 0.00360331, 0.00384987, 0.0041133 , 0.00439476,
 0.00469548, 0.00501678, 0.00536006, 0.00572683, 0.00611869, 0.00653738,
 0.00698471, 0.00746265, 0.00797329, 0.00851887, 0.00910179, 0.0097246 ,
 0.01039   , 0.011101  , 0.0118606 , 0.0126722 , 0.0135393 , 0.0144657 ,
 0.0154555 , 0.0165131 , 0.0176431 , 0.0188503 , 0.0201402 , 0.0215183 ,
 0.0229907 , 0.0245639 , 0.0262447 , 0.0280406 , 0.0299593 , 0.0320093 ,
 0.0341996 , 0.0365397 , 0.03904   , 0.0417114 , 0.0445656 , 0.047615  ,
 0.0508732 , 0.0543543 , 0.0580735 , 0.0620473 , 0.066293  , 0.0708292 ,
 0.0756758 , 0.080854  , 0.0863866 , 0.0922977 , 0.0986134 , 0.105361  ,
 0.112571  , 0.120273  , 0.128503  , 0.137296  , 0.146691  , 0.156729  ,
 0.167453  , 0.178911  , 0.191154  , 0.204234  , 0.218209  , 0.23314   ,
 0.249093  , 0.266138  , 0.284348  , 0.303805  , 0.324594  , 0.346805  ,
 0.370535  , 0.39589   , 0.422979  , 0.451922  , 0.482846  , 0.515885  ,
 0.551185  , 0.588901  , 0.629198  , 0.672252  , 0.718251  , 0.767399  ,
 0.81991   , 0.876013  , 0.935956  , 1.        }
,
{0.001136  , 0.00121653, 0.00130277, 0.00139512, 0.00149401, 0.00159992,
 0.00171333, 0.00183479, 0.00196485, 0.00210413, 0.00225329, 0.00241301,
 0.00258406, 0.00276724, 0.0029634 , 0.00317347, 0.00339843, 0.00363933,
 0.00389731, 0.00417358, 0.00446943, 0.00478626, 0.00512554, 0.00548888,
 0.00587797, 0.00629464, 0.00674085, 0.00721868, 0.00773039, 0.00827838,
 0.00886521, 0.00949364, 0.0101666 , 0.0108873 , 0.0116591 , 0.0124855 ,
 0.0133706 , 0.0143184 , 0.0153334 , 0.0164203 , 0.0175843 , 0.0188308 ,
 0.0201657 , 0.0215952 , 0.023126  , 0.0247653 , 0.0265208 , 0.0284008 ,
 0.0304141 , 0.03257   , 0.0348788 , 0.0373513 , 0.039999  , 0.0428344 ,
 0.0458708 , 0.0491224 , 0.0526046 , 0.0563336 , 0.0603269 , 0.0646033 ,
 0.0691828 , 0.074087  , 0.0793388 , 0.0849628 , 0.0909856 , 0.0974353 ,
 0.104342  , 0.111739  , 0.11966   , 0.128142  , 0.137225  , 0.146953  ,
 0.15737   , 0.168525  , 0.180472  , 0.193265  , 0.206965  , 0.221636  ,
 0.237347  , 0.254172  , 0.272189  , 0.291484  , 0.312146  , 0.334273  ,
 0.357969  , 0.383344  , 0.410518  , 0.439619  , 0.470782  , 0.504154  ,
 0.539892  , 0.578164  , 0.619148  , 0.663038  , 0.710038  , 0.760371  ,
 0.814271  , 0.871992  , 0.933805  , 1.        }
,
{9.04612e-04, 9.70969e-04, 1.04219e-03, 1.11864e-03, 1.20070e-03,
 1.28877e-03, 1.38331e-03, 1.48478e-03, 1.59369e-03, 1.71060e-03,
 1.83608e-03, 1.97076e-03, 2.11532e-03, 2.27049e-03, 2.43704e-03,
 2.61580e-03, 2.80768e-03, 3.01363e-03, 3.23469e-03, 3.47197e-03,
 3.72665e-03, 4.00001e-03, 4.29343e-03, 4.60837e-03, 4.94641e-03,
 5.30924e-03, 5.69870e-03, 6.11671e-03, 6.56540e-03, 7.04699e-03,
 7.56392e-03, 8.11876e-03, 8.71429e-03, 9.35352e-03, 1.00396e-02,
 1.07761e-02, 1.15665e-02, 1.24150e-02, 1.33257e-02, 1.43032e-02,
 1.53523e-02, 1.64785e-02, 1.76872e-02, 1.89847e-02, 2.03773e-02,
 2.18720e-02, 2.34764e-02, 2.51985e-02, 2.70469e-02, 2.90309e-02,
 3.11604e-02, 3.34461e-02, 3.58995e-02, 3.85328e-02, 4.13594e-02,
 4.43932e-02, 4.76496e-02, 5.11449e-02, 5.48966e-02, 5.89234e-02,
 6.32457e-02, 6.78850e-02, 7.28646e-02, 7.82094e-02, 8.39464e-02,
 9.01041e-02, 9.67136e-02, 1.03808e-01, 1.11423e-01, 1.19596e-01,
 1.28369e-01, 1.37785e-01, 1.47892e-01, 1.58740e-01, 1.70384e-01,
 1.82883e-01, 1.96298e-01, 2.10697e-01, 2.26152e-01, 2.42741e-01,
 2.60547e-01, 2.79659e-01, 3.00174e-01, 3.22192e-01, 3.45826e-01,
 3.71194e-01, 3.98422e-01, 4.27648e-01, 4.59017e-01, 4.92688e-01,
 5.28828e-01, 5.67620e-01, 6.09257e-01, 6.53948e-01, 7.01917e-01,
 7.53406e-01, 8.08670e-01, 8.67989e-01, 9.31659e-01, 1.00000e+00}
,
{7.20325e-04, 7.74944e-04, 8.33705e-04, 8.96922e-04, 9.64932e-04,
 1.03810e-03, 1.11681e-03, 1.20150e-03, 1.29260e-03, 1.39062e-03,
 1.49606e-03, 1.60950e-03, 1.73155e-03, 1.86284e-03, 2.00409e-03,
 2.15606e-03, 2.31954e-03, 2.49543e-03, 2.68464e-03, 2.88821e-03,
 3.10721e-03, 3.34282e-03, 3.59630e-03, 3.86899e-03, 4.16236e-03,
 4.47798e-03, 4.81752e-03, 5.18282e-03, 5.57581e-03, 5.99861e-03,
 6.45346e-03, 6.94280e-03, 7.46925e-03, 8.03561e-03, 8.64492e-03,
 9.30043e-03, 1.00057e-02, 1.07643e-02, 1.15806e-02, 1.24587e-02,
 1.34034e-02, 1.44197e-02, 1.55131e-02, 1.66894e-02, 1.79549e-02,
 1.93163e-02, 2.07810e-02, 2.23568e-02, 2.40520e-02, 2.58758e-02,
 2.78378e-02, 2.99487e-02, 3.22196e-02, 3.46626e-02, 3.72910e-02,
 4.01186e-02, 4.31607e-02, 4.64334e-02, 4.99542e-02, 5.37421e-02,
 5.78171e-02, 6.22012e-02, 6.69177e-02, 7.19918e-02, 7.74507e-02,
 8.33235e-02, 8.96416e-02, 9.64388e-02, 1.03751e-01, 1.11618e-01,
 1.20082e-01, 1.29187e-01, 1.38983e-01, 1.49522e-01, 1.60859e-01,
 1.73057e-01, 1.86179e-01, 2.00296e-01, 2.15484e-01, 2.31823e-01,
 2.49402e-01, 2.68313e-01, 2.88658e-01, 3.10546e-01, 3.34093e-01,
 3.59426e-01, 3.86680e-01, 4.16001e-01, 4.47545e-01, 4.81480e-01,
 5.17989e-01, 5.57266e-01, 5.99522e-01, 6.44981e-01, 6.93888e-01,
 7.46503e-01, 8.03107e-01, 8.64004e-01, 9.29518e-01, 1.00000e+00}
,
{5.73562e-04, 6.18475e-04, 6.66905e-04, 7.19127e-04, 7.75438e-04,
 8.36159e-04, 9.01634e-04, 9.72236e-04, 1.04837e-03, 1.13046e-03,
 1.21898e-03, 1.31443e-03, 1.41736e-03, 1.52835e-03, 1.64802e-03,
 1.77707e-03, 1.91622e-03, 2.06627e-03, 2.22807e-03, 2.40254e-03,
 2.59067e-03, 2.79354e-03, 3.01229e-03, 3.24816e-03, 3.50251e-03,
 3.77677e-03, 4.07251e-03, 4.39141e-03, 4.73528e-03, 5.10608e-03,
 5.50591e-03, 5.93705e-03, 6.40195e-03, 6.90325e-03, 7.44381e-03,
 8.02670e-03, 8.65523e-03, 9.33298e-03, 1.00638e-02, 1.08518e-02,
 1.17016e-02, 1.26179e-02, 1.36059e-02, 1.46713e-02, 1.58202e-02,
 1.70590e-02, 1.83948e-02, 1.98352e-02, 2.13884e-02, 2.30632e-02,
 2.48692e-02, 2.68165e-02, 2.89164e-02, 3.11807e-02, 3.36223e-02,
 3.62551e-02, 3.90941e-02, 4.21553e-02, 4.54563e-02, 4.90157e-02,
 5.28539e-02, 5.69926e-02, 6.14555e-02, 6.62677e-02, 7.14568e-02,
 7.70522e-02, 8.30858e-02, 8.95918e-02, 9.66073e-02, 1.04172e-01,
 1.12329e-01, 1.21125e-01, 1.30610e-01, 1.40837e-01, 1.51866e-01,
 1.63758e-01, 1.76581e-01, 1.90408e-01, 2.05318e-01, 2.21395e-01,
 2.38731e-01, 2.57425e-01, 2.77583e-01, 2.99319e-01, 3.22757e-01,
 3.48031e-01, 3.75283e-01, 4.04670e-01, 4.36357e-01, 4.70526e-01,
 5.07371e-01, 5.47101e-01, 5.89941e-01, 6.36137e-01, 6.85949e-01,
 7.39662e-01, 7.97582e-01, 8.60036e-01, 9.27381e-01, 1.00000e+00}
,
{4.56691e-04, 4.93587e-04, 5.33463e-04, 5.76562e-04, 6.23142e-04,
 6.73485e-04, 7.27896e-04, 7.86702e-04, 8.50260e-04, 9.18952e-04,
 9.93194e-04, 1.07343e-03, 1.16016e-03, 1.25388e-03, 1.35519e-03,
 1.46467e-03, 1.58300e-03, 1.71089e-03, 1.84911e-03, 1.99850e-03,
 2.15996e-03, 2.33446e-03, 2.52306e-03, 2.72690e-03, 2.94721e-03,
 3.18531e-03, 3.44265e-03, 3.72078e-03, 4.02138e-03, 4.34627e-03,
 4.69740e-03, 5.07691e-03, 5.48707e-03, 5.93037e-03, 6.40948e-03,
 6.92730e-03, 7.48695e-03, 8.09182e-03, 8.74556e-03, 9.45211e-03,
 1.02157e-02, 1.10411e-02, 1.19331e-02, 1.28971e-02, 1.39391e-02,
 1.50652e-02, 1.62823e-02, 1.75978e-02, 1.90195e-02, 2.05561e-02,
 2.22168e-02, 2.40117e-02, 2.59516e-02, 2.80482e-02, 3.03142e-02,
 3.27633e-02, 3.54102e-02, 3.82710e-02, 4.13629e-02, 4.47046e-02,
 4.83163e-02, 5.22197e-02, 5.64386e-02, 6.09982e-02, 6.59262e-02,
 7.12524e-02, 7.70089e-02, 8.32304e-02, 8.99545e-02, 9.72219e-02,
 1.05076e-01, 1.13566e-01, 1.22740e-01, 1.32657e-01, 1.43374e-01,
 1.54957e-01, 1.67476e-01, 1.81006e-01, 1.95630e-01, 2.11435e-01,
 2.28516e-01, 2.46978e-01, 2.66931e-01, 2.88497e-01, 3.11804e-01,
 3.36995e-01, 3.64221e-01, 3.93646e-01, 4.25448e-01, 4.59820e-01,
 4.96969e-01, 5.37119e-01, 5.80513e-01, 6.27412e-01, 6.78100e-01,
 7.32884e-01, 7.92093e-01, 8.56086e-01, 9.25249e-01, 1.00000e+00}
,
{3.63626e-04, 3.93909e-04, 4.26714e-04, 4.62251e-04, 5.00747e-04,
 5.42450e-04, 5.87625e-04, 6.36563e-04, 6.89576e-04, 7.47004e-04,
 8.09215e-04, 8.76606e-04, 9.49610e-04, 1.02869e-03, 1.11436e-03,
 1.20717e-03, 1.30770e-03, 1.41661e-03, 1.53458e-03, 1.66238e-03,
 1.80083e-03, 1.95080e-03, 2.11327e-03, 2.28926e-03, 2.47991e-03,
 2.68644e-03, 2.91016e-03, 3.15252e-03, 3.41507e-03, 3.69947e-03,
 4.00757e-03, 4.34132e-03, 4.70287e-03, 5.09452e-03, 5.51880e-03,
 5.97840e-03, 6.47629e-03, 7.01563e-03, 7.59990e-03, 8.23282e-03,
 8.91845e-03, 9.66118e-03, 1.04658e-02, 1.13374e-02, 1.22815e-02,
 1.33044e-02, 1.44123e-02, 1.56126e-02, 1.69128e-02, 1.83213e-02,
 1.98471e-02, 2.15000e-02, 2.32905e-02, 2.52302e-02, 2.73314e-02,
 2.96075e-02, 3.20733e-02, 3.47443e-02, 3.76379e-02, 4.07723e-02,
 4.41679e-02, 4.78462e-02, 5.18308e-02, 5.61473e-02, 6.08233e-02,
 6.58887e-02, 7.13759e-02, 7.73201e-02, 8.37594e-02, 9.07349e-02,
 9.82913e-02, 1.06477e-01, 1.15344e-01, 1.24950e-01, 1.35356e-01,
 1.46629e-01, 1.58840e-01, 1.72068e-01, 1.86398e-01, 2.01922e-01,
 2.18738e-01, 2.36954e-01, 2.56688e-01, 2.78065e-01, 3.01222e-01,
 3.26308e-01, 3.53483e-01, 3.82921e-01, 4.14811e-01, 4.49357e-01,
 4.86780e-01, 5.27319e-01, 5.71234e-01, 6.18806e-01, 6.70341e-01,
 7.26167e-01, 7.86643e-01, 8.52154e-01, 9.23122e-01, 1.00000e+00}
,
{2.89522e-04, 3.14356e-04, 3.41321e-04, 3.70598e-04, 4.02387e-04,
 4.36902e-04, 4.74378e-04, 5.15069e-04, 5.59250e-04, 6.07221e-04,
 6.59306e-04, 7.15860e-04, 7.77264e-04, 8.43935e-04, 9.16325e-04,
 9.94925e-04, 1.08027e-03, 1.17293e-03, 1.27354e-03, 1.38278e-03,
 1.50139e-03, 1.63017e-03, 1.77000e-03, 1.92183e-03, 2.08668e-03,
 2.26567e-03, 2.46001e-03, 2.67102e-03, 2.90013e-03, 3.14890e-03,
 3.41900e-03, 3.71227e-03, 4.03070e-03, 4.37644e-03, 4.75184e-03,
 5.15943e-03, 5.60199e-03, 6.08252e-03, 6.60426e-03, 7.17075e-03,
 7.78583e-03, 8.45368e-03, 9.17881e-03, 9.96614e-03, 1.08210e-02,
 1.17492e-02, 1.27570e-02, 1.38513e-02, 1.50394e-02, 1.63294e-02,
 1.77301e-02, 1.92509e-02, 2.09022e-02, 2.26951e-02, 2.46419e-02,
 2.67556e-02, 2.90506e-02, 3.15424e-02, 3.42480e-02, 3.71857e-02,
 4.03754e-02, 4.38387e-02, 4.75990e-02, 5.16819e-02, 5.61150e-02,
 6.09284e-02, 6.61547e-02, 7.18292e-02, 7.79905e-02, 8.46803e-02,
 9.19439e-02, 9.98305e-02, 1.08394e-01, 1.17691e-01, 1.27787e-01,
 1.38748e-01, 1.50649e-01, 1.63571e-01, 1.77602e-01, 1.92836e-01,
 2.09377e-01, 2.27337e-01, 2.46837e-01, 2.68010e-01, 2.90999e-01,
 3.15960e-01, 3.43062e-01, 3.72489e-01, 4.04439e-01, 4.39131e-01,
 4.76798e-01, 5.17697e-01, 5.62103e-01, 6.10318e-01, 6.62670e-01,
 7.19511e-01, 7.81229e-01, 8.48240e-01, 9.21000e-01, 1.00000e+00}
,
{2.30517e-04, 2.50866e-04, 2.73013e-04, 2.97114e-04, 3.23343e-04,
 3.51888e-04, 3.82952e-04, 4.16759e-04, 4.53550e-04, 4.93589e-04,
 5.37163e-04, 5.84583e-04, 6.36190e-04, 6.92352e-04, 7.53473e-04,
 8.19989e-04, 8.92377e-04, 9.71155e-04, 1.05689e-03, 1.15019e-03,
 1.25173e-03, 1.36223e-03, 1.48249e-03, 1.61336e-03, 1.75579e-03,
 1.91078e-03, 2.07947e-03, 2.26304e-03, 2.46282e-03, 2.68024e-03,
 2.91685e-03, 3.17434e-03, 3.45457e-03, 3.75954e-03, 4.09143e-03,
 4.45262e-03, 4.84569e-03, 5.27347e-03, 5.73901e-03, 6.24564e-03,
 6.79700e-03, 7.39704e-03, 8.05004e-03, 8.76070e-03, 9.53408e-03,
 1.03757e-02, 1.12917e-02, 1.22885e-02, 1.33734e-02, 1.45540e-02,
 1.58388e-02, 1.72370e-02, 1.87587e-02, 2.04147e-02, 2.22169e-02,
 2.41782e-02, 2.63126e-02, 2.86354e-02, 3.11634e-02, 3.39144e-02,
 3.69084e-02, 4.01666e-02, 4.37125e-02, 4.75714e-02, 5.17710e-02,
 5.63413e-02, 6.13151e-02, 6.67279e-02, 7.26186e-02, 7.90294e-02,
 8.60060e-02, 9.35986e-02, 1.01861e-01, 1.10854e-01, 1.20640e-01,
 1.31290e-01, 1.42880e-01, 1.55493e-01, 1.69220e-01, 1.84159e-01,
 2.00416e-01, 2.18109e-01, 2.37363e-01, 2.58318e-01, 2.81122e-01,
 3.05939e-01, 3.32947e-01, 3.62339e-01, 3.94326e-01, 4.29137e-01,
 4.67021e-01, 5.08249e-01, 5.53117e-01, 6.01946e-01, 6.55086e-01,
 7.12916e-01, 7.75852e-01, 8.44344e-01, 9.18882e-01, 1.00000e+00}
,
{1.83535e-04, 2.00198e-04, 2.18373e-04, 2.38199e-04, 2.59824e-04,
 2.83413e-04, 3.09143e-04, 3.37210e-04, 3.67824e-04, 4.01218e-04,
 4.37644e-04, 4.77377e-04, 5.20716e-04, 5.67991e-04, 6.19558e-04,
 6.75806e-04, 7.37161e-04, 8.04086e-04, 8.77087e-04, 9.56715e-04,
 1.04357e-03, 1.13832e-03, 1.24166e-03, 1.35439e-03, 1.47735e-03,
 1.61148e-03, 1.75778e-03, 1.91736e-03, 2.09144e-03, 2.28131e-03,
 2.48843e-03, 2.71435e-03, 2.96078e-03, 3.22958e-03, 3.52278e-03,
 3.84261e-03, 4.19147e-03, 4.57200e-03, 4.98709e-03, 5.43985e-03,
 5.93372e-03, 6.47243e-03, 7.06005e-03, 7.70101e-03, 8.40017e-03,
 9.16280e-03, 9.99467e-03, 1.09021e-02, 1.18918e-02, 1.29715e-02,
 1.41491e-02, 1.54337e-02, 1.68349e-02, 1.83633e-02, 2.00304e-02,
 2.18489e-02, 2.38326e-02, 2.59963e-02, 2.83564e-02, 3.09308e-02,
 3.37390e-02, 3.68020e-02, 4.01432e-02, 4.37877e-02, 4.77631e-02,
 5.20994e-02, 5.68294e-02, 6.19888e-02, 6.76166e-02, 7.37554e-02,
 8.04514e-02, 8.77554e-02, 9.57225e-02, 1.04413e-01, 1.13892e-01,
 1.24232e-01, 1.35511e-01, 1.47814e-01, 1.61234e-01, 1.75872e-01,
 1.91839e-01, 2.09255e-01, 2.28253e-01, 2.48975e-01, 2.71579e-01,
 2.96235e-01, 3.23130e-01, 3.52466e-01, 3.84466e-01, 4.19370e-01,
 4.57444e-01, 4.98974e-01, 5.44275e-01, 5.93689e-01, 6.47588e-01,
 7.06381e-01, 7.70512e-01, 8.40465e-01, 9.16769e-01, 1.00000e+00}
,
{1.46127e-04, 1.59761e-04, 1.74667e-04, 1.90964e-04, 2.08782e-04,
 2.28261e-04, 2.49558e-04, 2.72843e-04, 2.98299e-04, 3.26131e-04,
 3.56560e-04, 3.89828e-04, 4.26199e-04, 4.65965e-04, 5.09440e-04,
 5.56972e-04, 6.08938e-04, 6.65753e-04, 7.27869e-04, 7.95781e-04,
 8.70029e-04, 9.51204e-04, 1.03995e-03, 1.13698e-03, 1.24306e-03,
 1.35905e-03, 1.48585e-03, 1.62448e-03, 1.77605e-03, 1.94175e-03,
 2.12292e-03, 2.32100e-03, 2.53755e-03, 2.77431e-03, 3.03316e-03,
 3.31615e-03, 3.62556e-03, 3.96383e-03, 4.33366e-03, 4.73800e-03,
 5.18006e-03, 5.66337e-03, 6.19178e-03, 6.76948e-03, 7.40109e-03,
 8.09162e-03, 8.84658e-03, 9.67199e-03, 1.05744e-02, 1.15610e-02,
 1.26397e-02, 1.38190e-02, 1.51083e-02, 1.65180e-02, 1.80591e-02,
 1.97441e-02, 2.15862e-02, 2.36002e-02, 2.58022e-02, 2.82096e-02,
 3.08416e-02, 3.37192e-02, 3.68652e-02, 4.03048e-02, 4.40653e-02,
 4.81767e-02, 5.26717e-02, 5.75861e-02, 6.29589e-02, 6.88331e-02,
 7.52554e-02, 8.22769e-02, 8.99534e-02, 9.83463e-02, 1.07522e-01,
 1.17554e-01, 1.28522e-01, 1.40514e-01, 1.53624e-01, 1.67957e-01,
 1.83628e-01, 2.00761e-01, 2.19492e-01, 2.39971e-01, 2.62361e-01,
 2.86839e-01, 3.13602e-01, 3.42862e-01, 3.74851e-01, 4.09826e-01,
 4.48063e-01, 4.89868e-01, 5.35574e-01, 5.85544e-01, 6.40176e-01,
 6.99906e-01, 7.65208e-01, 8.36604e-01, 9.14660e-01, 1.00000e+00}
,
{1.16344e-04, 1.27492e-04, 1.39708e-04, 1.53095e-04, 1.67765e-04,
 1.83841e-04, 2.01457e-04, 2.20761e-04, 2.41915e-04, 2.65095e-04,
 2.90497e-04, 3.18333e-04, 3.48837e-04, 3.82263e-04, 4.18892e-04,
 4.59031e-04, 5.03016e-04, 5.51216e-04, 6.04035e-04, 6.61914e-04,
 7.25340e-04, 7.94844e-04, 8.71007e-04, 9.54469e-04, 1.04593e-03,
 1.14615e-03, 1.25598e-03, 1.37633e-03, 1.50821e-03, 1.65273e-03,
 1.81110e-03, 1.98464e-03, 2.17481e-03, 2.38321e-03, 2.61157e-03,
 2.86181e-03, 3.13604e-03, 3.43654e-03, 3.76584e-03, 4.12669e-03,
 4.52211e-03, 4.95543e-03, 5.43027e-03, 5.95061e-03, 6.52081e-03,
 7.14564e-03, 7.83035e-03, 8.58067e-03, 9.40289e-03, 1.03039e-02,
 1.12912e-02, 1.23732e-02, 1.35588e-02, 1.48580e-02, 1.62817e-02,
 1.78419e-02, 1.95515e-02, 2.14250e-02, 2.34780e-02, 2.57277e-02,
 2.81930e-02, 3.08945e-02, 3.38548e-02, 3.70989e-02, 4.06538e-02,
 4.45493e-02, 4.88181e-02, 5.34959e-02, 5.86220e-02, 6.42393e-02,
 7.03948e-02, 7.71402e-02, 8.45319e-02, 9.26319e-02, 1.01508e-01,
 1.11235e-01, 1.21893e-01, 1.33574e-01, 1.46373e-01, 1.60399e-01,
 1.75768e-01, 1.92611e-01, 2.11067e-01, 2.31292e-01, 2.53455e-01,
 2.77741e-01, 3.04355e-01, 3.33519e-01, 3.65477e-01, 4.00498e-01,
 4.38874e-01, 4.80928e-01, 5.27012e-01, 5.77511e-01, 6.32849e-01,
 6.93490e-01, 7.59941e-01, 8.32760e-01, 9.12557e-01, 1.00000e+00}
,
{9.26298e-05, 1.01740e-04, 1.11746e-04, 1.22736e-04, 1.34806e-04,
 1.48064e-04, 1.62626e-04, 1.78620e-04, 1.96187e-04, 2.15481e-04,
 2.36673e-04, 2.59950e-04, 2.85515e-04, 3.13595e-04, 3.44436e-04,
 3.78311e-04, 4.15517e-04, 4.56382e-04, 5.01266e-04, 5.50565e-04,
 6.04712e-04, 6.64184e-04, 7.29505e-04, 8.01250e-04, 8.80051e-04,
 9.66602e-04, 1.06167e-03, 1.16608e-03, 1.28076e-03, 1.40672e-03,
 1.54507e-03, 1.69702e-03, 1.86392e-03, 2.04723e-03, 2.24857e-03,
 2.46971e-03, 2.71261e-03, 2.97938e-03, 3.27240e-03, 3.59423e-03,
 3.94772e-03, 4.33597e-03, 4.76240e-03, 5.23077e-03, 5.74521e-03,
 6.31024e-03, 6.93084e-03, 7.61247e-03, 8.36114e-03, 9.18344e-03,
 1.00866e-02, 1.10786e-02, 1.21682e-02, 1.33649e-02, 1.46793e-02,
 1.61230e-02, 1.77086e-02, 1.94502e-02, 2.13631e-02, 2.34641e-02,
 2.57718e-02, 2.83064e-02, 3.10902e-02, 3.41479e-02, 3.75063e-02,
 4.11949e-02, 4.52463e-02, 4.96962e-02, 5.45837e-02, 5.99519e-02,
 6.58481e-02, 7.23241e-02, 7.94370e-02, 8.72495e-02, 9.58303e-02,
 1.05255e-01, 1.15607e-01, 1.26976e-01, 1.39464e-01, 1.53180e-01,
 1.68245e-01, 1.84791e-01, 2.02965e-01, 2.22927e-01, 2.44851e-01,
 2.68931e-01, 2.95380e-01, 3.24430e-01, 3.56337e-01, 3.91382e-01,
 4.29874e-01, 4.72151e-01, 5.18586e-01, 5.69588e-01, 6.25605e-01,
 6.87132e-01, 7.54710e-01, 8.28934e-01, 9.10458e-01, 1.00000e+00}
,
{7.37492e-05, 8.11890e-05, 8.93793e-05, 9.83958e-05, 1.08322e-04,
 1.19249e-04, 1.31279e-04, 1.44523e-04, 1.59102e-04, 1.75152e-04,
 1.92821e-04, 2.12273e-04, 2.33687e-04, 2.57262e-04, 2.83214e-04,
 3.11785e-04, 3.43237e-04, 3.77863e-04, 4.15982e-04, 4.57946e-04,
 5.04143e-04, 5.55001e-04, 6.10989e-04, 6.72625e-04, 7.40479e-04,
 8.15179e-04, 8.97414e-04, 9.87944e-04, 1.08761e-03, 1.19733e-03,
 1.31811e-03, 1.45108e-03, 1.59747e-03, 1.75862e-03, 1.93603e-03,
 2.13133e-03, 2.34634e-03, 2.58304e-03, 2.84361e-03, 3.13048e-03,
 3.44628e-03, 3.79394e-03, 4.17667e-03, 4.59801e-03, 5.06185e-03,
 5.57249e-03, 6.13464e-03, 6.75350e-03, 7.43479e-03, 8.18481e-03,
 9.01049e-03, 9.91947e-03, 1.09201e-02, 1.20218e-02, 1.32345e-02,
 1.45696e-02, 1.60394e-02, 1.76574e-02, 1.94387e-02, 2.13997e-02,
 2.35585e-02, 2.59350e-02, 2.85513e-02, 3.14316e-02, 3.46024e-02,
 3.80931e-02, 4.19359e-02, 4.61664e-02, 5.08236e-02, 5.59507e-02,
 6.15949e-02, 6.78086e-02, 7.46491e-02, 8.21797e-02, 9.04699e-02,
 9.95965e-02, 1.09644e-01, 1.20705e-01, 1.32881e-01, 1.46286e-01,
 1.61044e-01, 1.77290e-01, 1.95174e-01, 2.14864e-01, 2.36539e-01,
 2.60401e-01, 2.86670e-01, 3.15589e-01, 3.47426e-01, 3.82474e-01,
 4.21058e-01, 4.63534e-01, 5.10295e-01, 5.61773e-01, 6.18445e-01,
 6.80833e-01, 7.49515e-01, 8.25126e-01, 9.08365e-01, 1.00000e+00}
,
{5.87168e-05, 6.47891e-05, 7.14894e-05, 7.88827e-05, 8.70405e-05,
 9.60420e-05, 1.05974e-04, 1.16934e-04, 1.29027e-04, 1.42371e-04,
 1.57094e-04, 1.73340e-04, 1.91267e-04, 2.11047e-04, 2.32873e-04,
 2.56956e-04, 2.83530e-04, 3.12852e-04, 3.45206e-04, 3.80906e-04,
 4.20299e-04, 4.63765e-04, 5.11726e-04, 5.64647e-04, 6.23041e-04,
 6.87475e-04, 7.58571e-04, 8.37021e-04, 9.23583e-04, 1.01910e-03,
 1.12449e-03, 1.24078e-03, 1.36910e-03, 1.51069e-03, 1.66692e-03,
 1.83931e-03, 2.02952e-03, 2.23941e-03, 2.47101e-03, 2.72655e-03,
 3.00852e-03, 3.31966e-03, 3.66297e-03, 4.04178e-03, 4.45977e-03,
 4.92099e-03, 5.42990e-03, 5.99145e-03, 6.61107e-03, 7.29477e-03,
 8.04917e-03, 8.88159e-03, 9.80010e-03, 1.08136e-02, 1.19319e-02,
 1.31659e-02, 1.45275e-02, 1.60299e-02, 1.76876e-02, 1.95168e-02,
 2.15352e-02, 2.37623e-02, 2.62197e-02, 2.89313e-02, 3.19233e-02,
 3.52247e-02, 3.88676e-02, 4.28872e-02, 4.73224e-02, 5.22164e-02,
 5.76165e-02, 6.35750e-02, 7.01497e-02, 7.74044e-02, 8.54094e-02,
 9.42422e-02, 1.03988e-01, 1.14743e-01, 1.26609e-01, 1.39703e-01,
 1.54150e-01, 1.70092e-01, 1.87683e-01, 2.07092e-01, 2.28509e-01,
 2.52141e-01, 2.78217e-01, 3.06989e-01, 3.38737e-01, 3.73768e-01,
 4.12422e-01, 4.55074e-01, 5.02136e-01, 5.54066e-01, 6.11366e-01,
 6.74592e-01, 7.44356e-01, 8.21335e-01, 9.06275e-01, 1.00000e+00}
,
{4.67484e-05, 5.17019e-05, 5.71802e-05, 6.32391e-05, 6.99400e-05,
 7.73509e-05, 8.55470e-05, 9.46117e-05, 1.04637e-04, 1.15724e-04,
 1.27986e-04, 1.41548e-04, 1.56546e-04, 1.73134e-04, 1.91480e-04,
 2.11769e-04, 2.34208e-04, 2.59025e-04, 2.86472e-04, 3.16826e-04,
 3.50398e-04, 3.87526e-04, 4.28589e-04, 4.74002e-04, 5.24228e-04,
 5.79775e-04, 6.41209e-04, 7.09152e-04, 7.84294e-04, 8.67399e-04,
 9.59309e-04, 1.06096e-03, 1.17338e-03, 1.29771e-03, 1.43522e-03,
 1.58729e-03, 1.75548e-03, 1.94150e-03, 2.14722e-03, 2.37474e-03,
 2.62637e-03, 2.90466e-03, 3.21244e-03, 3.55283e-03, 3.92930e-03,
 4.34565e-03, 4.80612e-03, 5.31538e-03, 5.87860e-03, 6.50150e-03,
 7.19040e-03, 7.95230e-03, 8.79493e-03, 9.72685e-03, 1.07575e-02,
 1.18974e-02, 1.31580e-02, 1.45523e-02, 1.60943e-02, 1.77996e-02,
 1.96857e-02, 2.17716e-02, 2.40785e-02, 2.66299e-02, 2.94516e-02,
 3.25724e-02, 3.60237e-02, 3.98408e-02, 4.40624e-02, 4.87313e-02,
 5.38949e-02, 5.96057e-02, 6.59215e-02, 7.29066e-02, 8.06319e-02,
 8.91757e-02, 9.86248e-02, 1.09075e-01, 1.20633e-01, 1.33415e-01,
 1.47552e-01, 1.63187e-01, 1.80478e-01, 1.99602e-01, 2.20752e-01,
 2.44143e-01, 2.70012e-01, 2.98623e-01, 3.30265e-01, 3.65260e-01,
 4.03964e-01, 4.46768e-01, 4.94108e-01, 5.46464e-01, 6.04368e-01,
 6.68407e-01, 7.39232e-01, 8.17562e-01, 9.04191e-01, 1.00000e+00}
,
{3.72194e-05, 4.12581e-05, 4.57351e-05, 5.06978e-05, 5.61990e-05,
 6.22972e-05, 6.90571e-05, 7.65504e-05, 8.48570e-05, 9.40648e-05,
 1.04272e-04, 1.15586e-04, 1.28129e-04, 1.42032e-04, 1.57444e-04,
 1.74528e-04, 1.93466e-04, 2.14459e-04, 2.37730e-04, 2.63526e-04,
 2.92122e-04, 3.23820e-04, 3.58958e-04, 3.97908e-04, 4.41085e-04,
 4.88948e-04, 5.42003e-04, 6.00816e-04, 6.66011e-04, 7.38280e-04,
 8.18391e-04, 9.07195e-04, 1.00563e-03, 1.11476e-03, 1.23572e-03,
 1.36981e-03, 1.51844e-03, 1.68321e-03, 1.86586e-03, 2.06832e-03,
 2.29276e-03, 2.54154e-03, 2.81733e-03, 3.12304e-03, 3.46192e-03,
 3.83757e-03, 4.25399e-03, 4.71559e-03, 5.22728e-03, 5.79449e-03,
 6.42325e-03, 7.12024e-03, 7.89286e-03, 8.74931e-03, 9.69870e-03,
 1.07511e-02, 1.19177e-02, 1.32109e-02, 1.46444e-02, 1.62335e-02,
 1.79950e-02, 1.99476e-02, 2.21122e-02, 2.45116e-02, 2.71713e-02,
 3.01197e-02, 3.33880e-02, 3.70109e-02, 4.10270e-02, 4.54788e-02,
 5.04137e-02, 5.58841e-02, 6.19481e-02, 6.86701e-02, 7.61215e-02,
 8.43815e-02, 9.35378e-02, 1.03688e-01, 1.14939e-01, 1.27411e-01,
 1.41236e-01, 1.56562e-01, 1.73550e-01, 1.92382e-01, 2.13258e-01,
 2.36398e-01, 2.62050e-01, 2.90485e-01, 3.22006e-01, 3.56946e-01,
 3.95679e-01, 4.38614e-01, 4.86208e-01, 5.38967e-01, 5.97450e-01,
 6.62279e-01, 7.34143e-01, 8.13805e-01, 9.02112e-01, 1.00000e+00}
,
{2.96328e-05, 3.29240e-05, 3.65807e-05, 4.06435e-05, 4.51576e-05,
 5.01731e-05, 5.57456e-05, 6.19370e-05, 6.88161e-05, 7.64592e-05,
 8.49511e-05, 9.43863e-05, 1.04869e-04, 1.16517e-04, 1.29458e-04,
 1.43836e-04, 1.59811e-04, 1.77561e-04, 1.97282e-04, 2.19193e-04,
 2.43538e-04, 2.70586e-04, 3.00639e-04, 3.34030e-04, 3.71129e-04,
 4.12348e-04, 4.58146e-04, 5.09030e-04, 5.65566e-04, 6.28381e-04,
 6.98172e-04, 7.75715e-04, 8.61870e-04, 9.57594e-04, 1.06395e-03,
 1.18212e-03, 1.31341e-03, 1.45929e-03, 1.62136e-03, 1.80144e-03,
 2.00152e-03, 2.22382e-03, 2.47081e-03, 2.74523e-03, 3.05013e-03,
 3.38889e-03, 3.76528e-03, 4.18347e-03, 4.64811e-03, 5.16436e-03,
 5.73794e-03, 6.37523e-03, 7.08330e-03, 7.87001e-03, 8.74409e-03,
 9.71526e-03, 1.07943e-02, 1.19932e-02, 1.33252e-02, 1.48052e-02,
 1.64495e-02, 1.82765e-02, 2.03064e-02, 2.25617e-02, 2.50675e-02,
 2.78517e-02, 3.09450e-02, 3.43819e-02, 3.82006e-02, 4.24434e-02,
 4.71574e-02, 5.23949e-02, 5.82142e-02, 6.46798e-02, 7.18635e-02,
 7.98450e-02, 8.87131e-02, 9.85660e-02, 1.09513e-01, 1.21676e-01,
 1.35191e-01, 1.50206e-01, 1.66888e-01, 1.85424e-01, 2.06018e-01,
 2.28899e-01, 2.54322e-01, 2.82569e-01, 3.13952e-01, 3.48822e-01,
 3.87564e-01, 4.30609e-01, 4.78434e-01, 5.31572e-01, 5.90611e-01,
 6.56208e-01, 7.29090e-01, 8.10066e-01, 9.00037e-01, 1.00000e+00}
,
{2.35925e-05, 2.62733e-05, 2.92586e-05, 3.25832e-05, 3.62855e-05,
 4.04085e-05, 4.50000e-05, 5.01132e-05, 5.58074e-05, 6.21486e-05,
 6.92104e-05, 7.70745e-05, 8.58322e-05, 9.55851e-05, 1.06446e-04,
 1.18541e-04, 1.32011e-04, 1.47011e-04, 1.63715e-04, 1.82317e-04,
 2.03033e-04, 2.26103e-04, 2.51795e-04, 2.80405e-04, 3.12267e-04,
 3.47749e-04, 3.87263e-04, 4.31266e-04, 4.80269e-04, 5.34841e-04,
 5.95613e-04, 6.63290e-04, 7.38658e-04, 8.22589e-04, 9.16057e-04,
 1.02015e-03, 1.13606e-03, 1.26515e-03, 1.40890e-03, 1.56899e-03,
 1.74727e-03, 1.94581e-03, 2.16691e-03, 2.41312e-03, 2.68732e-03,
 2.99267e-03, 3.33272e-03, 3.71140e-03, 4.13312e-03, 4.60275e-03,
 5.12575e-03, 5.70817e-03, 6.35677e-03, 7.07907e-03, 7.88344e-03,
 8.77921e-03, 9.77676e-03, 1.08877e-02, 1.21248e-02, 1.35025e-02,
 1.50367e-02, 1.67453e-02, 1.86480e-02, 2.07669e-02, 2.31266e-02,
 2.57544e-02, 2.86808e-02, 3.19397e-02, 3.55689e-02, 3.96105e-02,
 4.41113e-02, 4.91236e-02, 5.47053e-02, 6.09213e-02, 6.78436e-02,
 7.55524e-02, 8.41372e-02, 9.36974e-02, 1.04344e-01, 1.16200e-01,
 1.29404e-01, 1.44107e-01, 1.60482e-01, 1.78717e-01, 1.99024e-01,
 2.21638e-01, 2.46822e-01, 2.74868e-01, 3.06100e-01, 3.40882e-01,
 3.79615e-01, 4.22749e-01, 4.70785e-01, 5.24279e-01, 5.83851e-01,
 6.50192e-01, 7.24071e-01, 8.06345e-01, 8.97967e-01, 1.00000e+00}
,
{1.87835e-05, 2.09660e-05, 2.34021e-05, 2.61213e-05, 2.91565e-05,
 3.25443e-05, 3.63257e-05, 4.05465e-05, 4.52578e-05, 5.05165e-05,
 5.63862e-05, 6.29379e-05, 7.02509e-05, 7.84136e-05, 8.75248e-05,
 9.76946e-05, 1.09046e-04, 1.21717e-04, 1.35859e-04, 1.51645e-04,
 1.69266e-04, 1.88933e-04, 2.10886e-04, 2.35390e-04, 2.62741e-04,
 2.93270e-04, 3.27346e-04, 3.65381e-04, 4.07836e-04, 4.55224e-04,
 5.08119e-04, 5.67159e-04, 6.33059e-04, 7.06617e-04, 7.88722e-04,
 8.80366e-04, 9.82659e-04, 1.09684e-03, 1.22428e-03, 1.36654e-03,
 1.52532e-03, 1.70256e-03, 1.90038e-03, 2.12119e-03, 2.36766e-03,
 2.64277e-03, 2.94985e-03, 3.29260e-03, 3.67518e-03, 4.10221e-03,
 4.57887e-03, 5.11090e-03, 5.70476e-03, 6.36762e-03, 7.10749e-03,
 7.93334e-03, 8.85515e-03, 9.88406e-03, 1.10325e-02, 1.23144e-02,
 1.37453e-02, 1.53424e-02, 1.71251e-02, 1.91149e-02, 2.13360e-02,
 2.38151e-02, 2.65823e-02, 2.96710e-02, 3.31186e-02, 3.69667e-02,
 4.12620e-02, 4.60564e-02, 5.14079e-02, 5.73812e-02, 6.40485e-02,
 7.14906e-02, 7.97973e-02, 8.90693e-02, 9.94186e-02, 1.10970e-01,
 1.23865e-01, 1.38257e-01, 1.54321e-01, 1.72253e-01, 1.92267e-01,
 2.14608e-01, 2.39544e-01, 2.67377e-01, 2.98445e-01, 3.33122e-01,
 3.71829e-01, 4.15033e-01, 4.63258e-01, 5.17085e-01, 5.77167e-01,
 6.44231e-01, 7.19086e-01, 8.02640e-01, 8.95902e-01, 1.00000e+00}
,
{1.49547e-05, 1.67308e-05, 1.87179e-05, 2.09409e-05, 2.34280e-05,
 2.62105e-05, 2.93235e-05, 3.28061e-05, 3.67024e-05, 4.10614e-05,
 4.59382e-05, 5.13941e-05, 5.74980e-05, 6.43269e-05, 7.19668e-05,
 8.05141e-05, 9.00765e-05, 1.00775e-04, 1.12743e-04, 1.26133e-04,
 1.41114e-04, 1.57874e-04, 1.76624e-04, 1.97601e-04, 2.21069e-04,
 2.47325e-04, 2.76699e-04, 3.09562e-04, 3.46327e-04, 3.87460e-04,
 4.33477e-04, 4.84960e-04, 5.42557e-04, 6.06995e-04, 6.79086e-04,
 7.59739e-04, 8.49971e-04, 9.50919e-04, 1.06386e-03, 1.19021e-03,
 1.33156e-03, 1.48971e-03, 1.66664e-03, 1.86458e-03, 2.08603e-03,
 2.33378e-03, 2.61096e-03, 2.92105e-03, 3.26798e-03, 3.65611e-03,
 4.09033e-03, 4.57613e-03, 5.11962e-03, 5.72766e-03, 6.40792e-03,
 7.16897e-03, 8.02040e-03, 8.97296e-03, 1.00387e-02, 1.12309e-02,
 1.25648e-02, 1.40571e-02, 1.57266e-02, 1.75944e-02, 1.96840e-02,
 2.20218e-02, 2.46373e-02, 2.75634e-02, 3.08370e-02, 3.44994e-02,
 3.85968e-02, 4.31808e-02, 4.83092e-02, 5.40468e-02, 6.04658e-02,
 6.76471e-02, 7.56813e-02, 8.46698e-02, 9.47257e-02, 1.05976e-01,
 1.18562e-01, 1.32644e-01, 1.48397e-01, 1.66022e-01, 1.85740e-01,
 2.07800e-01, 2.32480e-01, 2.60091e-01, 2.90981e-01, 3.25540e-01,
 3.64203e-01, 4.07458e-01, 4.55851e-01, 5.09991e-01, 5.70561e-01,
 6.38325e-01, 7.14136e-01, 7.98952e-01, 8.93841e-01, 1.00000e+00}
,
{1.19063e-05, 1.33511e-05, 1.49712e-05, 1.67879e-05, 1.88251e-05,
 2.11094e-05, 2.36710e-05, 2.65434e-05, 2.97643e-05, 3.33761e-05,
 3.74261e-05, 4.19676e-05, 4.70602e-05, 5.27708e-05, 5.91743e-05,
 6.63549e-05, 7.44067e-05, 8.34357e-05, 9.35603e-05, 1.04913e-04,
 1.17644e-04, 1.31920e-04, 1.47928e-04, 1.65878e-04, 1.86007e-04,
 2.08578e-04, 2.33888e-04, 2.62270e-04, 2.94095e-04, 3.29782e-04,
 3.69800e-04, 4.14674e-04, 4.64993e-04, 5.21418e-04, 5.84690e-04,
 6.55639e-04, 7.35198e-04, 8.24412e-04, 9.24451e-04, 1.03663e-03,
 1.16242e-03, 1.30347e-03, 1.46165e-03, 1.63901e-03, 1.83790e-03,
 2.06092e-03, 2.31100e-03, 2.59143e-03, 2.90589e-03, 3.25851e-03,
 3.65392e-03, 4.09731e-03, 4.59450e-03, 5.15202e-03, 5.77720e-03,
 6.47824e-03, 7.26435e-03, 8.14585e-03, 9.13431e-03, 1.02427e-02,
 1.14856e-02, 1.28794e-02, 1.44422e-02, 1.61947e-02, 1.81599e-02,
 2.03635e-02, 2.28346e-02, 2.56055e-02, 2.87126e-02, 3.21967e-02,
 3.61037e-02, 4.04847e-02, 4.53974e-02, 5.09061e-02, 5.70834e-02,
 6.40102e-02, 7.17776e-02, 8.04875e-02, 9.02544e-02, 1.01206e-01,
 1.13487e-01, 1.27259e-01, 1.42701e-01, 1.60017e-01, 1.79434e-01,
 2.01208e-01, 2.25624e-01, 2.53002e-01, 2.83703e-01, 3.18129e-01,
 3.56733e-01, 4.00021e-01, 4.48562e-01, 5.02993e-01, 5.64030e-01,
 6.32472e-01, 7.09220e-01, 7.95281e-01, 8.91785e-01, 1.00000e+00}
,
{9.47937e-06, 1.06542e-05, 1.19745e-05, 1.34585e-05, 1.51265e-05,
 1.70011e-05, 1.91081e-05, 2.14762e-05, 2.41377e-05, 2.71291e-05,
 3.04913e-05, 3.42701e-05, 3.85172e-05, 4.32907e-05, 4.86557e-05,
 5.46857e-05, 6.14629e-05, 6.90800e-05, 7.76412e-05, 8.72633e-05,
 9.80780e-05, 1.10233e-04, 1.23894e-04, 1.39248e-04, 1.56506e-04,
 1.75901e-04, 1.97701e-04, 2.22202e-04, 2.49740e-04, 2.80691e-04,
 3.15477e-04, 3.54574e-04, 3.98517e-04, 4.47905e-04, 5.03415e-04,
 5.65803e-04, 6.35924e-04, 7.14734e-04, 8.03312e-04, 9.02867e-04,
 1.01476e-03, 1.14052e-03, 1.28187e-03, 1.44073e-03, 1.61928e-03,
 1.81996e-03, 2.04551e-03, 2.29901e-03, 2.58393e-03, 2.90416e-03,
 3.26407e-03, 3.66859e-03, 4.12324e-03, 4.63424e-03, 5.20856e-03,
 5.85406e-03, 6.57956e-03, 7.39497e-03, 8.31144e-03, 9.34148e-03,
 1.04992e-02, 1.18004e-02, 1.32628e-02, 1.49065e-02, 1.67538e-02,
 1.88301e-02, 2.11638e-02, 2.37866e-02, 2.67345e-02, 3.00477e-02,
 3.37716e-02, 3.79569e-02, 4.26610e-02, 4.79480e-02, 5.38902e-02,
 6.05689e-02, 6.80752e-02, 7.65119e-02, 8.59940e-02, 9.66514e-02,
 1.08629e-01, 1.22092e-01, 1.37223e-01, 1.54229e-01, 1.73343e-01,
 1.94825e-01, 2.18970e-01, 2.46107e-01, 2.76608e-01, 3.10888e-01,
 3.49417e-01, 3.92720e-01, 4.41390e-01, 4.96092e-01, 5.57573e-01,
 6.26674e-01, 7.04338e-01, 7.91627e-01, 8.89734e-01, 1.00000e+00}
,
{7.54710e-06, 8.50197e-06, 9.57766e-06, 1.07894e-05, 1.21545e-05,
 1.36924e-05, 1.54247e-05, 1.73763e-05, 1.95748e-05, 2.20514e-05,
 2.48414e-05, 2.79844e-05, 3.15250e-05, 3.55136e-05, 4.00069e-05,
 4.50686e-05, 5.07707e-05, 5.71944e-05, 6.44307e-05, 7.25826e-05,
 8.17658e-05, 9.21110e-05, 1.03765e-04, 1.16894e-04, 1.31683e-04,
 1.48344e-04, 1.67113e-04, 1.88256e-04, 2.12075e-04, 2.38907e-04,
 2.69134e-04, 3.03185e-04, 3.41544e-04, 3.84757e-04, 4.33437e-04,
 4.88277e-04, 5.50054e-04, 6.19648e-04, 6.98047e-04, 7.86365e-04,
 8.85857e-04, 9.97938e-04, 1.12420e-03, 1.26643e-03, 1.42667e-03,
 1.60717e-03, 1.81051e-03, 2.03958e-03, 2.29763e-03, 2.58833e-03,
 2.91581e-03, 3.28473e-03, 3.70032e-03, 4.16849e-03, 4.69589e-03,
 5.29003e-03, 5.95933e-03, 6.71331e-03, 7.56269e-03, 8.51954e-03,
 9.59745e-03, 1.08117e-02, 1.21797e-02, 1.37206e-02, 1.54566e-02,
 1.74122e-02, 1.96152e-02, 2.20970e-02, 2.48927e-02, 2.80422e-02,
 3.15902e-02, 3.55870e-02, 4.00895e-02, 4.51617e-02, 5.08757e-02,
 5.73125e-02, 6.45638e-02, 7.27326e-02, 8.19348e-02, 9.23014e-02,
 1.03979e-01, 1.17135e-01, 1.31955e-01, 1.48651e-01, 1.67458e-01,
 1.88645e-01, 2.12513e-01, 2.39400e-01, 2.69690e-01, 3.03811e-01,
 3.42250e-01, 3.85552e-01, 4.34333e-01, 4.89286e-01, 5.51191e-01,
 6.20929e-01, 6.99490e-01, 7.87990e-01, 8.87688e-01, 1.00000e+00}
,
{6.00870e-06, 6.78454e-06, 7.66055e-06, 8.64967e-06, 9.76650e-06,
 1.10275e-05, 1.24514e-05, 1.40591e-05, 1.58744e-05, 1.79241e-05,
 2.02384e-05, 2.28516e-05, 2.58021e-05, 2.91337e-05, 3.28954e-05,
 3.71428e-05, 4.19386e-05, 4.73537e-05, 5.34679e-05, 6.03716e-05,
 6.81667e-05, 7.69683e-05, 8.69064e-05, 9.81276e-05, 1.10798e-04,
 1.25104e-04, 1.41257e-04, 1.59496e-04, 1.80090e-04, 2.03343e-04,
 2.29598e-04, 2.59243e-04, 2.92717e-04, 3.30512e-04, 3.73187e-04,
 4.21373e-04, 4.75780e-04, 5.37212e-04, 6.06576e-04, 6.84896e-04,
 7.73329e-04, 8.73180e-04, 9.85924e-04, 1.11322e-03, 1.25696e-03,
 1.41926e-03, 1.60251e-03, 1.80943e-03, 2.04306e-03, 2.30686e-03,
 2.60471e-03, 2.94103e-03, 3.32077e-03, 3.74955e-03, 4.23368e-03,
 4.78033e-03, 5.39756e-03, 6.09449e-03, 6.88140e-03, 7.76992e-03,
 8.77316e-03, 9.90594e-03, 1.11850e-02, 1.26292e-02, 1.42598e-02,
 1.61010e-02, 1.81800e-02, 2.05274e-02, 2.31778e-02, 2.61705e-02,
 2.95496e-02, 3.33650e-02, 3.76731e-02, 4.25374e-02, 4.80297e-02,
 5.42313e-02, 6.12335e-02, 6.91399e-02, 7.80672e-02, 8.81471e-02,
 9.95286e-02, 1.12380e-01, 1.26890e-01, 1.43274e-01, 1.61773e-01,
 1.82661e-01, 2.06246e-01, 2.32876e-01, 2.62945e-01, 2.96896e-01,
 3.35231e-01, 3.78515e-01, 4.27389e-01, 4.82572e-01, 5.44881e-01,
 6.15236e-01, 6.94674e-01, 7.84370e-01, 8.85646e-01, 1.00000e+00}
,
{4.78389e-06, 5.41403e-06, 6.12717e-06, 6.93425e-06, 7.84764e-06,
 8.88135e-06, 1.00512e-05, 1.13752e-05, 1.28735e-05, 1.45693e-05,
 1.64883e-05, 1.86602e-05, 2.11182e-05, 2.38999e-05, 2.70480e-05,
 3.06108e-05, 3.46429e-05, 3.92061e-05, 4.43704e-05, 5.02150e-05,
 5.68294e-05, 6.43150e-05, 7.27867e-05, 8.23742e-05, 9.32247e-05,
 1.05504e-04, 1.19402e-04, 1.35129e-04, 1.52929e-04, 1.73073e-04,
 1.95870e-04, 2.21671e-04, 2.50869e-04, 2.83914e-04, 3.21312e-04,
 3.63636e-04, 4.11534e-04, 4.65742e-04, 5.27091e-04, 5.96520e-04,
 6.75094e-04, 7.64019e-04, 8.64656e-04, 9.78550e-04, 1.10745e-03,
 1.25332e-03, 1.41841e-03, 1.60525e-03, 1.81669e-03, 2.05599e-03,
 2.32681e-03, 2.63330e-03, 2.98016e-03, 3.37271e-03, 3.81697e-03,
 4.31975e-03, 4.88875e-03, 5.53270e-03, 6.26148e-03, 7.08625e-03,
 8.01966e-03, 9.07603e-03, 1.02715e-02, 1.16245e-02, 1.31557e-02,
 1.48886e-02, 1.68498e-02, 1.90692e-02, 2.15811e-02, 2.44238e-02,
 2.76409e-02, 3.12818e-02, 3.54023e-02, 4.00655e-02, 4.53430e-02,
 5.13157e-02, 5.80750e-02, 6.57248e-02, 7.43821e-02, 8.41799e-02,
 9.52682e-02, 1.07817e-01, 1.22019e-01, 1.38091e-01, 1.56281e-01,
 1.76867e-01, 2.00164e-01, 2.26530e-01, 2.56368e-01, 2.90138e-01,
 3.28355e-01, 3.71607e-01, 4.20555e-01, 4.75951e-01, 5.38644e-01,
 6.09595e-01, 6.89892e-01, 7.80766e-01, 8.83610e-01, 1.00000e+00}
,
{3.80874e-06, 4.32037e-06, 4.90073e-06, 5.55904e-06, 6.30579e-06,
 7.15285e-06, 8.11370e-06, 9.20361e-06, 1.04399e-05, 1.18423e-05,
 1.34331e-05, 1.52376e-05, 1.72845e-05, 1.96063e-05, 2.22400e-05,
 2.52275e-05, 2.86164e-05, 3.24604e-05, 3.68208e-05, 4.17670e-05,
 4.73776e-05, 5.37418e-05, 6.09610e-05, 6.91499e-05, 7.84389e-05,
 8.89756e-05, 1.00928e-04, 1.14485e-04, 1.29864e-04, 1.47309e-04,
 1.67097e-04, 1.89543e-04, 2.15005e-04, 2.43886e-04, 2.76648e-04,
 3.13810e-04, 3.55964e-04, 4.03781e-04, 4.58021e-04, 5.19547e-04,
 5.89338e-04, 6.68504e-04, 7.58305e-04, 8.60168e-04, 9.75715e-04,
 1.10678e-03, 1.25546e-03, 1.42410e-03, 1.61540e-03, 1.83240e-03,
 2.07855e-03, 2.35776e-03, 2.67448e-03, 3.03375e-03, 3.44127e-03,
 3.90354e-03, 4.42790e-03, 5.02270e-03, 5.69741e-03, 6.46274e-03,
 7.33088e-03, 8.31564e-03, 9.43269e-03, 1.06998e-02, 1.21371e-02,
 1.37675e-02, 1.56169e-02, 1.77147e-02, 2.00943e-02, 2.27936e-02,
 2.58554e-02, 2.93286e-02, 3.32684e-02, 3.77373e-02, 4.28066e-02,
 4.85568e-02, 5.50795e-02, 6.24783e-02, 7.08710e-02, 8.03912e-02,
 9.11901e-02, 1.03440e-01, 1.17335e-01, 1.33097e-01, 1.50975e-01,
 1.71256e-01, 1.94261e-01, 2.20356e-01, 2.49957e-01, 2.83533e-01,
 3.21621e-01, 3.64824e-01, 4.13831e-01, 4.69421e-01, 5.32479e-01,
 6.04007e-01, 6.85143e-01, 7.77179e-01, 8.81577e-01, 1.00000e+00}
,
{3.03237e-06, 3.44763e-06, 3.91977e-06, 4.45657e-06, 5.06687e-06,
 5.76076e-06, 6.54966e-06, 7.44661e-06, 8.46639e-06, 9.62582e-06,
 1.09440e-05, 1.24428e-05, 1.41467e-05, 1.60841e-05, 1.82867e-05,
 2.07910e-05, 2.36382e-05, 2.68754e-05, 3.05558e-05, 3.47403e-05,
 3.94978e-05, 4.49069e-05, 5.10567e-05, 5.80486e-05, 6.59981e-05,
 7.50362e-05, 8.53121e-05, 9.69952e-05, 1.10278e-04, 1.25380e-04,
 1.42551e-04, 1.62072e-04, 1.84267e-04, 2.09502e-04, 2.38192e-04,
 2.70811e-04, 3.07898e-04, 3.50063e-04, 3.98002e-04, 4.52507e-04,
 5.14476e-04, 5.84931e-04, 6.65034e-04, 7.56107e-04, 8.59653e-04,
 9.77378e-04, 1.11123e-03, 1.26340e-03, 1.43642e-03, 1.63313e-03,
 1.85678e-03, 2.11106e-03, 2.40016e-03, 2.72885e-03, 3.10255e-03,
 3.52743e-03, 4.01050e-03, 4.55971e-03, 5.18415e-03, 5.89409e-03,
 6.70126e-03, 7.61896e-03, 8.66235e-03, 9.84861e-03, 1.11973e-02,
 1.27308e-02, 1.44742e-02, 1.64563e-02, 1.87100e-02, 2.12722e-02,
 2.41853e-02, 2.74974e-02, 3.12630e-02, 3.55444e-02, 4.04120e-02,
 4.59463e-02, 5.22384e-02, 5.93922e-02, 6.75257e-02, 7.67730e-02,
 8.72867e-02, 9.92402e-02, 1.12831e-01, 1.28282e-01, 1.45850e-01,
 1.65823e-01, 1.88532e-01, 2.14351e-01, 2.43705e-01, 2.77079e-01,
 3.15024e-01, 3.58165e-01, 4.07214e-01, 4.62980e-01, 5.26383e-01,
 5.98469e-01, 6.80427e-01, 7.73608e-01, 8.79550e-01, 1.00000e+00}
,
{2.41425e-06, 2.75119e-06, 3.13517e-06, 3.57273e-06, 4.07137e-06,
 4.63959e-06, 5.28712e-06, 6.02502e-06, 6.86591e-06, 7.82416e-06,
 8.91615e-06, 1.01605e-05, 1.15786e-05, 1.31946e-05, 1.50361e-05,
 1.71347e-05, 1.95261e-05, 2.22513e-05, 2.53568e-05, 2.88957e-05,
 3.29286e-05, 3.75243e-05, 4.27615e-05, 4.87295e-05, 5.55305e-05,
 6.32807e-05, 7.21125e-05, 8.21770e-05, 9.36462e-05, 1.06716e-04,
 1.21610e-04, 1.38583e-04, 1.57924e-04, 1.79965e-04, 2.05082e-04,
 2.33704e-04, 2.66322e-04, 3.03491e-04, 3.45848e-04, 3.94117e-04,
 4.49123e-04, 5.11805e-04, 5.83236e-04, 6.64636e-04, 7.57396e-04,
 8.63103e-04, 9.83563e-04, 1.12084e-03, 1.27727e-03, 1.45553e-03,
 1.65867e-03, 1.89017e-03, 2.15397e-03, 2.45459e-03, 2.79717e-03,
 3.18756e-03, 3.63244e-03, 4.13940e-03, 4.71712e-03, 5.37548e-03,
 6.12571e-03, 6.98065e-03, 7.95492e-03, 9.06515e-03, 1.03303e-02,
 1.17721e-02, 1.34151e-02, 1.52874e-02, 1.74210e-02, 1.98524e-02,
 2.26231e-02, 2.57805e-02, 2.93786e-02, 3.34789e-02, 3.81514e-02,
 4.34761e-02, 4.95438e-02, 5.64585e-02, 6.43382e-02, 7.33176e-02,
 8.35503e-02, 9.52111e-02, 1.08499e-01, 1.23642e-01, 1.40898e-01,
 1.60563e-01, 1.82972e-01, 2.08509e-01, 2.37610e-01, 2.70772e-01,
 3.08563e-01, 3.51628e-01, 4.00703e-01, 4.56628e-01, 5.20358e-01,
 5.92982e-01, 6.75743e-01, 7.70053e-01, 8.77527e-01, 1.00000e+00}
,
{1.92213e-06, 2.19544e-06, 2.50762e-06, 2.86418e-06, 3.27145e-06,
 3.73663e-06, 4.26795e-06, 4.87482e-06, 5.56799e-06, 6.35972e-06,
 7.26403e-06, 8.29693e-06, 9.47669e-06, 1.08242e-05, 1.23633e-05,
 1.41213e-05, 1.61293e-05, 1.84228e-05, 2.10424e-05, 2.40344e-05,
 2.74520e-05, 3.13555e-05, 3.58140e-05, 4.09065e-05, 4.67231e-05,
 5.33668e-05, 6.09552e-05, 6.96226e-05, 7.95225e-05, 9.08301e-05,
 1.03745e-04, 1.18497e-04, 1.35347e-04, 1.54592e-04, 1.76574e-04,
 2.01682e-04, 2.30360e-04, 2.63115e-04, 3.00529e-04, 3.43262e-04,
 3.92071e-04, 4.47821e-04, 5.11498e-04, 5.84230e-04, 6.67303e-04,
 7.62189e-04, 8.70568e-04, 9.94356e-04, 1.13575e-03, 1.29724e-03,
 1.48170e-03, 1.69239e-03, 1.93304e-03, 2.20790e-03, 2.52185e-03,
 2.88044e-03, 3.29002e-03, 3.75784e-03, 4.29217e-03, 4.90249e-03,
 5.59959e-03, 6.39582e-03, 7.30526e-03, 8.34402e-03, 9.53048e-03,
 1.08857e-02, 1.24335e-02, 1.42015e-02, 1.62208e-02, 1.85273e-02,
 2.11618e-02, 2.41708e-02, 2.76078e-02, 3.15334e-02, 3.60173e-02,
 4.11387e-02, 4.69883e-02, 5.36697e-02, 6.13012e-02, 7.00178e-02,
 7.99739e-02, 9.13456e-02, 1.04334e-01, 1.19170e-01, 1.36115e-01,
 1.55470e-01, 1.77577e-01, 2.02827e-01, 2.31667e-01, 2.64609e-01,
 3.02234e-01, 3.45210e-01, 3.94297e-01, 4.50363e-01, 5.14401e-01,
 5.87546e-01, 6.71091e-01, 7.66515e-01, 8.75509e-01, 1.00000e+00}
,
{1.53032e-06, 1.75195e-06, 2.00568e-06, 2.29615e-06, 2.62870e-06,
 3.00940e-06, 3.44524e-06, 3.94420e-06, 4.51543e-06, 5.16938e-06,
 5.91804e-06, 6.77513e-06, 7.75634e-06, 8.87966e-06, 1.01657e-05,
 1.16379e-05, 1.33234e-05, 1.52530e-05, 1.74620e-05, 1.99910e-05,
 2.28862e-05, 2.62007e-05, 2.99953e-05, 3.43394e-05, 3.93126e-05,
 4.50061e-05, 5.15242e-05, 5.89862e-05, 6.75290e-05, 7.73089e-05,
 8.85053e-05, 1.01323e-04, 1.15997e-04, 1.32797e-04, 1.52029e-04,
 1.74047e-04, 1.99254e-04, 2.28111e-04, 2.61148e-04, 2.98969e-04,
 3.42267e-04, 3.91836e-04, 4.48584e-04, 5.13551e-04, 5.87927e-04,
 6.73074e-04, 7.70553e-04, 8.82149e-04, 1.00991e-03, 1.15617e-03,
 1.32361e-03, 1.51531e-03, 1.73476e-03, 1.98600e-03, 2.27363e-03,
 2.60291e-03, 2.97988e-03, 3.41144e-03, 3.90551e-03, 4.47113e-03,
 5.11866e-03, 5.85998e-03, 6.70866e-03, 7.68025e-03, 8.79255e-03,
 1.00659e-02, 1.15238e-02, 1.31927e-02, 1.51033e-02, 1.72907e-02,
 1.97949e-02, 2.26617e-02, 2.59437e-02, 2.97010e-02, 3.40025e-02,
 3.89269e-02, 4.45646e-02, 5.10187e-02, 5.84075e-02, 6.68665e-02,
 7.65505e-02, 8.76370e-02, 1.00329e-01, 1.14859e-01, 1.31494e-01,
 1.50538e-01, 1.72340e-01, 1.97299e-01, 2.25873e-01, 2.58586e-01,
 2.96036e-01, 3.38909e-01, 3.87992e-01, 4.44184e-01, 5.08513e-01,
 5.82159e-01, 6.66471e-01, 7.62994e-01, 8.73495e-01, 1.00000e+00}
,
{1.21838e-06, 1.39805e-06, 1.60421e-06, 1.84078e-06, 2.11223e-06,
 2.42371e-06, 2.78112e-06, 3.19124e-06, 3.66184e-06, 4.20183e-06,
 4.82145e-06, 5.53245e-06, 6.34829e-06, 7.28445e-06, 8.35865e-06,
 9.59126e-06, 1.10056e-05, 1.26286e-05, 1.44909e-05, 1.66278e-05,
 1.90798e-05, 2.18934e-05, 2.51219e-05, 2.88265e-05, 3.30774e-05,
 3.79552e-05, 4.35523e-05, 4.99748e-05, 5.73443e-05, 6.58006e-05,
 7.55039e-05, 8.66381e-05, 9.94142e-05, 1.14074e-04, 1.30896e-04,
 1.50199e-04, 1.72348e-04, 1.97764e-04, 2.26927e-04, 2.60391e-04,
 2.98789e-04, 3.42850e-04, 3.93409e-04, 4.51423e-04, 5.17992e-04,
 5.94378e-04, 6.82029e-04, 7.82604e-04, 8.98011e-04, 1.03044e-03,
 1.18239e-03, 1.35675e-03, 1.55683e-03, 1.78640e-03, 2.04984e-03,
 2.35212e-03, 2.69897e-03, 3.09698e-03, 3.55367e-03, 4.07772e-03,
 4.67904e-03, 5.36903e-03, 6.16078e-03, 7.06928e-03, 8.11176e-03,
 9.30796e-03, 1.06806e-02, 1.22556e-02, 1.40628e-02, 1.61366e-02,
 1.85162e-02, 2.12467e-02, 2.43799e-02, 2.79751e-02, 3.21004e-02,
 3.68341e-02, 4.22659e-02, 4.84986e-02, 5.56505e-02, 6.38570e-02,
 7.32737e-02, 8.40790e-02, 9.64778e-02, 1.10705e-01, 1.27030e-01,
 1.45763e-01, 1.67257e-01, 1.91922e-01, 2.20224e-01, 2.52699e-01,
 2.89964e-01, 3.32723e-01, 3.81789e-01, 4.38089e-01, 5.02692e-01,
 5.76822e-01, 6.61883e-01, 7.59488e-01, 8.71486e-01, 1.00000e+00}
,
{9.70024e-07, 1.11563e-06, 1.28310e-06, 1.47571e-06, 1.69723e-06,
 1.95200e-06, 2.24502e-06, 2.58202e-06, 2.96961e-06, 3.41538e-06,
 3.92806e-06, 4.51770e-06, 5.19586e-06, 5.97581e-06, 6.87284e-06,
 7.90453e-06, 9.09108e-06, 1.04557e-05, 1.20253e-05, 1.38304e-05,
 1.59065e-05, 1.82942e-05, 2.10403e-05, 2.41987e-05, 2.78312e-05,
 3.20090e-05, 3.68138e-05, 4.23400e-05, 4.86957e-05, 5.60054e-05,
 6.44124e-05, 7.40814e-05, 8.52018e-05, 9.79914e-05, 1.12701e-04,
 1.29619e-04, 1.49076e-04, 1.71454e-04, 1.97191e-04, 2.26791e-04,
 2.60835e-04, 2.99989e-04, 3.45020e-04, 3.96811e-04, 4.56377e-04,
 5.24884e-04, 6.03674e-04, 6.94292e-04, 7.98513e-04, 9.18378e-04,
 1.05624e-03, 1.21479e-03, 1.39714e-03, 1.60687e-03, 1.84807e-03,
 2.12549e-03, 2.44455e-03, 2.81150e-03, 3.23353e-03, 3.71892e-03,
 4.27717e-03, 4.91922e-03, 5.65765e-03, 6.50692e-03, 7.48368e-03,
 8.60705e-03, 9.89906e-03, 1.13850e-02, 1.30940e-02, 1.50596e-02,
 1.73202e-02, 1.99201e-02, 2.29103e-02, 2.63494e-02, 3.03047e-02,
 3.48538e-02, 4.00857e-02, 4.61030e-02, 5.30236e-02, 6.09830e-02,
 7.01371e-02, 8.06655e-02, 9.27742e-02, 1.06701e-01, 1.22717e-01,
 1.41139e-01, 1.62325e-01, 1.86692e-01, 2.14716e-01, 2.46947e-01,
 2.84017e-01, 3.26651e-01, 3.75684e-01, 4.32078e-01, 4.96938e-01,
 5.71534e-01, 6.57327e-01, 7.55998e-01, 8.69482e-01, 1.00000e+00}
,
{7.72293e-07, 8.90270e-07, 1.02627e-06, 1.18304e-06, 1.36377e-06,
 1.57210e-06, 1.81226e-06, 2.08910e-06, 2.40824e-06, 2.77612e-06,
 3.20021e-06, 3.68908e-06, 4.25263e-06, 4.90226e-06, 5.65114e-06,
 6.51442e-06, 7.50958e-06, 8.65675e-06, 9.97917e-06, 1.15036e-05,
 1.32609e-05, 1.52867e-05, 1.76219e-05, 2.03139e-05, 2.34170e-05,
 2.69943e-05, 3.11180e-05, 3.58716e-05, 4.13514e-05, 4.76683e-05,
 5.49502e-05, 6.33445e-05, 7.30211e-05, 8.41760e-05, 9.70349e-05,
 1.11858e-04, 1.28946e-04, 1.48644e-04, 1.71351e-04, 1.97527e-04,
 2.27701e-04, 2.62485e-04, 3.02583e-04, 3.48806e-04, 4.02090e-04,
 4.63514e-04, 5.34322e-04, 6.15945e-04, 7.10038e-04, 8.18505e-04,
 9.43541e-04, 1.08768e-03, 1.25383e-03, 1.44537e-03, 1.66617e-03,
 1.92070e-03, 2.21411e-03, 2.55234e-03, 2.94224e-03, 3.39170e-03,
 3.90982e-03, 4.50709e-03, 5.19560e-03, 5.98929e-03, 6.90423e-03,
 7.95893e-03, 9.17475e-03, 1.05763e-02, 1.21920e-02, 1.40544e-02,
 1.62014e-02, 1.86763e-02, 2.15294e-02, 2.48182e-02, 2.86095e-02,
 3.29800e-02, 3.80180e-02, 4.38258e-02, 5.05207e-02, 5.82383e-02,
 6.71349e-02, 7.73905e-02, 8.92128e-02, 1.02841e-01, 1.18551e-01,
 1.36661e-01, 1.57538e-01, 1.81604e-01, 2.09346e-01, 2.41326e-01,
 2.78191e-01, 3.20689e-01, 3.69677e-01, 4.26150e-01, 4.91250e-01,
 5.66294e-01, 6.52802e-01, 7.52525e-01, 8.67482e-01, 1.00000e+00}
,
{6.14869e-07, 7.10431e-07, 8.20846e-07, 9.48421e-07, 1.09582e-06,
 1.26614e-06, 1.46292e-06, 1.69028e-06, 1.95299e-06, 2.25652e-06,
 2.60722e-06, 3.01243e-06, 3.48063e-06, 4.02158e-06, 4.64661e-06,
 5.36878e-06, 6.20320e-06, 7.16729e-06, 8.28123e-06, 9.56829e-06,
 1.10554e-05, 1.27736e-05, 1.47589e-05, 1.70527e-05, 1.97030e-05,
 2.27652e-05, 2.63034e-05, 3.03914e-05, 3.51148e-05, 4.05723e-05,
 4.68781e-05, 5.41638e-05, 6.25819e-05, 7.23083e-05, 8.35464e-05,
 9.65311e-05, 1.11534e-04, 1.28868e-04, 1.48897e-04, 1.72039e-04,
 1.98777e-04, 2.29670e-04, 2.65365e-04, 3.06608e-04, 3.54261e-04,
 4.09320e-04, 4.72936e-04, 5.46440e-04, 6.31367e-04, 7.29493e-04,
 8.42871e-04, 9.73869e-04, 1.12523e-03, 1.30011e-03, 1.50217e-03,
 1.73564e-03, 2.00539e-03, 2.31706e-03, 2.67718e-03, 3.09326e-03,
 3.57402e-03, 4.12949e-03, 4.77129e-03, 5.51284e-03, 6.36964e-03,
 7.35961e-03, 8.50343e-03, 9.82503e-03, 1.13520e-02, 1.31163e-02,
 1.51549e-02, 1.75102e-02, 2.02317e-02, 2.33761e-02, 2.70091e-02,
 3.12069e-02, 3.60570e-02, 4.16610e-02, 4.81359e-02, 5.56171e-02,
 6.42611e-02, 7.42485e-02, 8.57881e-02, 9.91213e-02, 1.14527e-01,
 1.32326e-01, 1.52892e-01, 1.76655e-01, 2.04110e-01, 2.35833e-01,
 2.72486e-01, 3.14835e-01, 3.63767e-01, 4.20303e-01, 4.85626e-01,
 5.61102e-01, 6.48308e-01, 7.49067e-01, 8.65487e-01, 1.00000e+00}
,
{4.89534e-07, 5.66920e-07, 6.56541e-07, 7.60328e-07, 8.80523e-07,
 1.01972e-06, 1.18092e-06, 1.36760e-06, 1.58380e-06, 1.83417e-06,
 2.12412e-06, 2.45990e-06, 2.84877e-06, 3.29911e-06, 3.82064e-06,
 4.42462e-06, 5.12408e-06, 5.93410e-06, 6.87218e-06, 7.95856e-06,
 9.21667e-06, 1.06737e-05, 1.23610e-05, 1.43150e-05, 1.65780e-05,
 1.91987e-05, 2.22337e-05, 2.57484e-05, 2.98188e-05, 3.45327e-05,
 3.99917e-05, 4.63137e-05, 5.36351e-05, 6.21138e-05, 7.19329e-05,
 8.33043e-05, 9.64733e-05, 1.11724e-04, 1.29386e-04, 1.49839e-04,
 1.73526e-04, 2.00958e-04, 2.32726e-04, 2.69516e-04, 3.12121e-04,
 3.61462e-04, 4.18603e-04, 4.84777e-04, 5.61412e-04, 6.50162e-04,
 7.52941e-04, 8.71968e-04, 1.00981e-03, 1.16944e-03, 1.35431e-03,
 1.56841e-03, 1.81635e-03, 2.10348e-03, 2.43600e-03, 2.82109e-03,
 3.26706e-03, 3.78352e-03, 4.38163e-03, 5.07429e-03, 5.87645e-03,
 6.80541e-03, 7.88123e-03, 9.12712e-03, 1.05700e-02, 1.22409e-02,
 1.41760e-02, 1.64169e-02, 1.90122e-02, 2.20177e-02, 2.54983e-02,
 2.95291e-02, 3.41971e-02, 3.96031e-02, 4.58637e-02, 5.31139e-02,
 6.15103e-02, 7.12341e-02, 8.24949e-02, 9.55360e-02, 1.10639e-01,
 1.28129e-01, 1.48383e-01, 1.71840e-01, 1.99005e-01, 2.30465e-01,
 2.66897e-01, 3.09089e-01, 3.57951e-01, 4.14536e-01, 4.80067e-01,
 5.55958e-01, 6.43845e-01, 7.45626e-01, 8.63496e-01, 1.00000e+00}
,
{3.89747e-07, 4.52399e-07, 5.25124e-07, 6.09539e-07, 7.07523e-07,
 8.21259e-07, 9.53279e-07, 1.10652e-06, 1.28440e-06, 1.49087e-06,
 1.73053e-06, 2.00871e-06, 2.33162e-06, 2.70643e-06, 3.14150e-06,
 3.64650e-06, 4.23268e-06, 4.91310e-06, 5.70289e-06, 6.61964e-06,
 7.68376e-06, 8.91894e-06, 1.03527e-05, 1.20169e-05, 1.39486e-05,
 1.61909e-05, 1.87937e-05, 2.18148e-05, 2.53216e-05, 2.93921e-05,
 3.41169e-05, 3.96013e-05, 4.59673e-05, 5.33566e-05, 6.19338e-05,
 7.18898e-05, 8.34463e-05, 9.68605e-05, 1.12431e-04, 1.30505e-04,
 1.51483e-04, 1.75835e-04, 2.04101e-04, 2.36910e-04, 2.74994e-04,
 3.19200e-04, 3.70512e-04, 4.30073e-04, 4.99208e-04, 5.79457e-04,
 6.72606e-04, 7.80729e-04, 9.06234e-04, 1.05191e-03, 1.22101e-03,
 1.41729e-03, 1.64512e-03, 1.90958e-03, 2.21655e-03, 2.57287e-03,
 2.98646e-03, 3.46654e-03, 4.02380e-03, 4.67063e-03, 5.42144e-03,
 6.29295e-03, 7.30456e-03, 8.47879e-03, 9.84177e-03, 1.14239e-02,
 1.32603e-02, 1.53919e-02, 1.78662e-02, 2.07382e-02, 2.40719e-02,
 2.79415e-02, 3.24332e-02, 3.76469e-02, 4.36987e-02, 5.07234e-02,
 5.88773e-02, 6.83420e-02, 7.93281e-02, 9.20803e-02, 1.06882e-01,
 1.24064e-01, 1.44008e-01, 1.67157e-01, 1.94028e-01, 2.25219e-01,
 2.61423e-01, 3.03447e-01, 3.52227e-01, 4.08849e-01, 4.74572e-01,
 5.50861e-01, 6.39413e-01, 7.42200e-01, 8.61510e-01, 1.00000e+00}
,
{3.10301e-07, 3.61012e-07, 4.20012e-07, 4.88654e-07, 5.68513e-07,
 6.61425e-07, 7.69520e-07, 8.95281e-07, 1.04160e-06, 1.21182e-06,
 1.40987e-06, 1.64028e-06, 1.90835e-06, 2.22022e-06, 2.58307e-06,
 3.00522e-06, 3.49636e-06, 4.06776e-06, 4.73255e-06, 5.50598e-06,
 6.40581e-06, 7.45270e-06, 8.67068e-06, 1.00877e-05, 1.17363e-05,
 1.36544e-05, 1.58859e-05, 1.84821e-05, 2.15026e-05, 2.50167e-05,
 2.91051e-05, 3.38617e-05, 3.93957e-05, 4.58341e-05, 5.33246e-05,
 6.20394e-05, 7.21784e-05, 8.39743e-05, 9.76981e-05, 1.13665e-04,
 1.32241e-04, 1.53853e-04, 1.78996e-04, 2.08250e-04, 2.42283e-04,
 2.81879e-04, 3.27946e-04, 3.81542e-04, 4.43897e-04, 5.16442e-04,
 6.00843e-04, 6.99038e-04, 8.13280e-04, 9.46193e-04, 1.10083e-03,
 1.28073e-03, 1.49004e-03, 1.73356e-03, 2.01687e-03, 2.34648e-03,
 2.72996e-03, 3.17612e-03, 3.69518e-03, 4.29908e-03, 5.00167e-03,
 5.81908e-03, 6.77009e-03, 7.87651e-03, 9.16375e-03, 1.06614e-02,
 1.24037e-02, 1.44309e-02, 1.67893e-02, 1.95331e-02, 2.27254e-02,
 2.64393e-02, 3.07603e-02, 3.57873e-02, 4.16360e-02, 4.84405e-02,
 5.63570e-02, 6.55674e-02, 7.62829e-02, 8.87497e-02, 1.03254e-01,
 1.20128e-01, 1.39761e-01, 1.62602e-01, 1.89175e-01, 2.20092e-01,
 2.56061e-01, 2.97909e-01, 3.46596e-01, 4.03239e-01, 4.69140e-01,
 5.45810e-01, 6.35011e-01, 7.38790e-01, 8.59529e-01, 1.00000e+00}
,
{2.47049e-07, 2.88086e-07, 3.35940e-07, 3.91743e-07, 4.56815e-07,
 5.32697e-07, 6.21184e-07, 7.24368e-07, 8.44693e-07, 9.85005e-07,
 1.14862e-06, 1.33942e-06, 1.56191e-06, 1.82136e-06, 2.12391e-06,
 2.47672e-06, 2.88812e-06, 3.36787e-06, 3.92731e-06, 4.57967e-06,
 5.34040e-06, 6.22750e-06, 7.26195e-06, 8.46823e-06, 9.87489e-06,
 1.15152e-05, 1.34280e-05, 1.56585e-05, 1.82596e-05, 2.12927e-05,
 2.48296e-05, 2.89540e-05, 3.37636e-05, 3.93721e-05, 4.59122e-05,
 5.35387e-05, 6.24320e-05, 7.28026e-05, 8.48958e-05, 9.89978e-05,
 1.15442e-04, 1.34619e-04, 1.56980e-04, 1.83056e-04, 2.13463e-04,
 2.48922e-04, 2.90270e-04, 3.38487e-04, 3.94713e-04, 4.60279e-04,
 5.36736e-04, 6.25894e-04, 7.29861e-04, 8.51098e-04, 9.92474e-04,
 1.15733e-03, 1.34958e-03, 1.57376e-03, 1.83518e-03, 2.14002e-03,
 2.49550e-03, 2.91002e-03, 3.39341e-03, 3.95709e-03, 4.61440e-03,
 5.38090e-03, 6.27472e-03, 7.31701e-03, 8.53244e-03, 9.94977e-03,
 1.16025e-02, 1.35298e-02, 1.57773e-02, 1.83980e-02, 2.14541e-02,
 2.50179e-02, 2.91736e-02, 3.40196e-02, 3.96706e-02, 4.62603e-02,
 5.39446e-02, 6.29054e-02, 7.33546e-02, 8.55395e-02, 9.97485e-02,
 1.16318e-01, 1.35639e-01, 1.58170e-01, 1.84444e-01, 2.15082e-01,
 2.50809e-01, 2.92471e-01, 3.41054e-01, 3.97706e-01, 4.63769e-01,
 5.40806e-01, 6.30640e-01, 7.35395e-01, 8.57552e-01, 1.00000e+00}
,
{1.96690e-07, 2.29891e-07, 2.68696e-07, 3.14052e-07, 3.67063e-07,
 4.29023e-07, 5.01441e-07, 5.86084e-07, 6.85013e-07, 8.00643e-07,
 9.35790e-07, 1.09375e-06, 1.27837e-06, 1.49416e-06, 1.74637e-06,
 2.04116e-06, 2.38570e-06, 2.78840e-06, 3.25908e-06, 3.80921e-06,
 4.45219e-06, 5.20371e-06, 6.08209e-06, 7.10874e-06, 8.30868e-06,
 9.71118e-06, 1.13504e-05, 1.32663e-05, 1.55057e-05, 1.81230e-05,
 2.11821e-05, 2.47576e-05, 2.89367e-05, 3.38211e-05, 3.95301e-05,
 4.62027e-05, 5.40017e-05, 6.31170e-05, 7.37711e-05, 8.62235e-05,
 1.00778e-04, 1.17789e-04, 1.37672e-04, 1.60910e-04, 1.88072e-04,
 2.19818e-04, 2.56923e-04, 3.00291e-04, 3.50980e-04, 4.10224e-04,
 4.79470e-04, 5.60403e-04, 6.54998e-04, 7.65561e-04, 8.94786e-04,
 1.04582e-03, 1.22236e-03, 1.42869e-03, 1.66985e-03, 1.95172e-03,
 2.28117e-03, 2.66622e-03, 3.11628e-03, 3.64230e-03, 4.25711e-03,
 4.97570e-03, 5.81560e-03, 6.79726e-03, 7.94462e-03, 9.28566e-03,
 1.08531e-02, 1.26850e-02, 1.48263e-02, 1.73289e-02, 2.02540e-02,
 2.36728e-02, 2.76688e-02, 3.23392e-02, 3.77980e-02, 4.41783e-02,
 5.16355e-02, 6.03515e-02, 7.05387e-02, 8.24455e-02, 9.63621e-02,
 1.12628e-01, 1.31639e-01, 1.53860e-01, 1.79831e-01, 2.10186e-01,
 2.45665e-01, 2.87133e-01, 3.35601e-01, 3.92250e-01, 4.58461e-01,
 5.35848e-01, 6.26298e-01, 7.32016e-01, 8.55580e-01, 1.00000e+00}
,
{1.56597e-07, 1.83452e-07, 2.14912e-07, 2.51768e-07, 2.94945e-07,
 3.45526e-07, 4.04781e-07, 4.74198e-07, 5.55519e-07, 6.50787e-07,
 7.62392e-07, 8.93136e-07, 1.04630e-06, 1.22574e-06, 1.43594e-06,
 1.68219e-06, 1.97068e-06, 2.30863e-06, 2.70455e-06, 3.16836e-06,
 3.71171e-06, 4.34824e-06, 5.09393e-06, 5.96750e-06, 6.99089e-06,
 8.18977e-06, 9.59426e-06, 1.12396e-05, 1.31671e-05, 1.54252e-05,
 1.80705e-05, 2.11694e-05, 2.47998e-05, 2.90528e-05, 3.40352e-05,
 3.98720e-05, 4.67097e-05, 5.47201e-05, 6.41042e-05, 7.50976e-05,
 8.79762e-05, 1.03064e-04, 1.20738e-04, 1.41444e-04, 1.65700e-04,
 1.94117e-04, 2.27406e-04, 2.66405e-04, 3.12091e-04, 3.65613e-04,
 4.28313e-04, 5.01765e-04, 5.87814e-04, 6.88620e-04, 8.06714e-04,
 9.45059e-04, 1.10713e-03, 1.29699e-03, 1.51942e-03, 1.77999e-03,
 2.08524e-03, 2.44285e-03, 2.86178e-03, 3.35255e-03, 3.92749e-03,
 4.60103e-03, 5.39007e-03, 6.31442e-03, 7.39730e-03, 8.66588e-03,
 1.01520e-02, 1.18930e-02, 1.39326e-02, 1.63219e-02, 1.91210e-02,
 2.24001e-02, 2.62416e-02, 3.07418e-02, 3.60138e-02, 4.21899e-02,
 4.94252e-02, 5.79012e-02, 6.78309e-02, 7.94634e-02, 9.30907e-02,
 1.09055e-01, 1.27757e-01, 1.49667e-01, 1.75333e-01, 2.05402e-01,
 2.40627e-01, 2.81892e-01, 3.30235e-01, 3.86868e-01, 4.53213e-01,
 5.30935e-01, 6.21987e-01, 7.28653e-01, 8.53612e-01, 1.00000e+00}
,
{1.24676e-07, 1.46394e-07, 1.71894e-07, 2.01837e-07, 2.36996e-07,
 2.78279e-07, 3.26753e-07, 3.83671e-07, 4.50504e-07, 5.28979e-07,
 6.21124e-07, 7.29319e-07, 8.56362e-07, 1.00553e-06, 1.18069e-06,
 1.38636e-06, 1.62785e-06, 1.91142e-06, 2.24437e-06, 2.63533e-06,
 3.09438e-06, 3.63340e-06, 4.26632e-06, 5.00948e-06, 5.88210e-06,
 6.90672e-06, 8.10982e-06, 9.52250e-06, 1.11813e-05, 1.31290e-05,
 1.54159e-05, 1.81013e-05, 2.12544e-05, 2.49568e-05, 2.93041e-05,
 3.44086e-05, 4.04024e-05, 4.74402e-05, 5.57040e-05, 6.54072e-05,
 7.68007e-05, 9.01789e-05, 1.05887e-04, 1.24332e-04, 1.45990e-04,
 1.71421e-04, 2.01281e-04, 2.36343e-04, 2.77512e-04, 3.25853e-04,
 3.82614e-04, 4.49263e-04, 5.27522e-04, 6.19412e-04, 7.27310e-04,
 8.54002e-04, 1.00276e-03, 1.17744e-03, 1.38254e-03, 1.62337e-03,
 1.90615e-03, 2.23819e-03, 2.62806e-03, 3.08585e-03, 3.62339e-03,
 4.25456e-03, 4.99568e-03, 5.86589e-03, 6.88769e-03, 8.08747e-03,
 9.49626e-03, 1.11504e-02, 1.30928e-02, 1.53734e-02, 1.80514e-02,
 2.11958e-02, 2.48880e-02, 2.92233e-02, 3.43138e-02, 4.02911e-02,
 4.73095e-02, 5.55505e-02, 6.52270e-02, 7.65891e-02, 8.99304e-02,
 1.05596e-01, 1.23990e-01, 1.45588e-01, 1.70948e-01, 2.00726e-01,
 2.35691e-01, 2.76747e-01, 3.24955e-01, 3.81560e-01, 4.48025e-01,
 5.26068e-01, 6.17705e-01, 7.25305e-01, 8.51649e-01, 1.00000e+00}
,
{9.92619e-08, 1.16821e-07, 1.37487e-07, 1.61808e-07, 1.90432e-07,
 2.24120e-07, 2.63767e-07, 3.10427e-07, 3.65342e-07, 4.29971e-07,
 5.06032e-07, 5.95549e-07, 7.00902e-07, 8.24892e-07, 9.70815e-07,
 1.14255e-06, 1.34467e-06, 1.58254e-06, 1.86249e-06, 2.19197e-06,
 2.57973e-06, 3.03608e-06, 3.57317e-06, 4.20526e-06, 4.94917e-06,
 5.82468e-06, 6.85506e-06, 8.06772e-06, 9.49490e-06, 1.11746e-05,
 1.31513e-05, 1.54778e-05, 1.82158e-05, 2.14382e-05, 2.52306e-05,
 2.96939e-05, 3.49468e-05, 4.11289e-05, 4.84046e-05, 5.69673e-05,
 6.70448e-05, 7.89051e-05, 9.28634e-05, 1.09291e-04, 1.28624e-04,
 1.51378e-04, 1.78157e-04, 2.09673e-04, 2.46764e-04, 2.90417e-04,
 3.41791e-04, 4.02254e-04, 4.73413e-04, 5.57160e-04, 6.55721e-04,
 7.71719e-04, 9.08236e-04, 1.06890e-03, 1.25799e-03, 1.48053e-03,
 1.74244e-03, 2.05067e-03, 2.41344e-03, 2.84037e-03, 3.34284e-03,
 3.93418e-03, 4.63014e-03, 5.44921e-03, 6.41318e-03, 7.54767e-03,
 8.88285e-03, 1.04542e-02, 1.23036e-02, 1.44801e-02, 1.70416e-02,
 2.00563e-02, 2.36042e-02, 2.77798e-02, 3.26941e-02, 3.84777e-02,
 4.52844e-02, 5.32952e-02, 6.27231e-02, 7.38188e-02, 8.68773e-02,
 1.02246e-01, 1.20333e-01, 1.41620e-01, 1.66673e-01, 1.96157e-01,
 2.30857e-01, 2.71696e-01, 3.19759e-01, 3.76325e-01, 4.42896e-01,
 5.21245e-01, 6.13453e-01, 7.21973e-01, 8.49690e-01, 1.00000e+00}
,
{7.90283e-08, 9.32228e-08, 1.09967e-07, 1.29718e-07, 1.53017e-07,
 1.80501e-07, 2.12922e-07, 2.51165e-07, 2.96278e-07, 3.49493e-07,
 4.12267e-07, 4.86315e-07, 5.73664e-07, 6.76701e-07, 7.98246e-07,
 9.41621e-07, 1.11075e-06, 1.31025e-06, 1.54559e-06, 1.82320e-06,
 2.15067e-06, 2.53696e-06, 2.99263e-06, 3.53015e-06, 4.16421e-06,
 4.91215e-06, 5.79444e-06, 6.83520e-06, 8.06289e-06, 9.51109e-06,
 1.12194e-05, 1.32346e-05, 1.56116e-05, 1.84157e-05, 2.17234e-05,
 2.56252e-05, 3.02278e-05, 3.56572e-05, 4.20616e-05, 4.96165e-05,
 5.85282e-05, 6.90407e-05, 8.14413e-05, 9.60692e-05, 1.13324e-04,
 1.33679e-04, 1.57690e-04, 1.86013e-04, 2.19423e-04, 2.58834e-04,
 3.05324e-04, 3.60164e-04, 4.24854e-04, 5.01164e-04, 5.91179e-04,
 6.97363e-04, 8.22619e-04, 9.70372e-04, 1.14466e-03, 1.35026e-03,
 1.59278e-03, 1.87887e-03, 2.21634e-03, 2.61442e-03, 3.08400e-03,
 3.63793e-03, 4.29135e-03, 5.06214e-03, 5.97136e-03, 7.04390e-03,
 8.30907e-03, 9.80149e-03, 1.15620e-02, 1.36386e-02, 1.60883e-02,
 1.89780e-02, 2.23867e-02, 2.64076e-02, 3.11508e-02, 3.67459e-02,
 4.33459e-02, 5.11314e-02, 6.03153e-02, 7.11487e-02, 8.39279e-02,
 9.90025e-02, 1.16785e-01, 1.37761e-01, 1.62504e-01, 1.91692e-01,
 2.26123e-01, 2.66737e-01, 3.14647e-01, 3.71161e-01, 4.37827e-01,
 5.16466e-01, 6.09230e-01, 7.18656e-01, 8.47736e-01, 1.00000e+00}
,
{6.29191e-08, 7.43913e-08, 8.79552e-08, 1.03992e-07, 1.22953e-07,
 1.45372e-07, 1.71878e-07, 2.03217e-07, 2.40270e-07, 2.84079e-07,
 3.35875e-07, 3.97116e-07, 4.69524e-07, 5.55133e-07, 6.56352e-07,
 7.76026e-07, 9.17520e-07, 1.08481e-06, 1.28261e-06, 1.51647e-06,
 1.79297e-06, 2.11989e-06, 2.50642e-06, 2.96342e-06, 3.50374e-06,
 4.14259e-06, 4.89792e-06, 5.79097e-06, 6.84685e-06, 8.09525e-06,
 9.57127e-06, 1.13164e-05, 1.33798e-05, 1.58193e-05, 1.87037e-05,
 2.21140e-05, 2.61461e-05, 3.09134e-05, 3.65499e-05, 4.32141e-05,
 5.10935e-05, 6.04095e-05, 7.14241e-05, 8.44470e-05, 9.98444e-05,
 1.18049e-04, 1.39573e-04, 1.65022e-04, 1.95111e-04, 2.30686e-04,
 2.72748e-04, 3.22478e-04, 3.81277e-04, 4.50796e-04, 5.32990e-04,
 6.30172e-04, 7.45072e-04, 8.80923e-04, 1.04154e-03, 1.23145e-03,
 1.45598e-03, 1.72146e-03, 2.03534e-03, 2.40644e-03, 2.84521e-03,
 3.36399e-03, 3.97735e-03, 4.70255e-03, 5.55998e-03, 6.57375e-03,
 7.77235e-03, 9.18950e-03, 1.08650e-02, 1.28461e-02, 1.51884e-02,
 1.79577e-02, 2.12320e-02, 2.51032e-02, 2.96804e-02, 3.50920e-02,
 4.14905e-02, 4.90555e-02, 5.79999e-02, 6.85752e-02, 8.10786e-02,
 9.58619e-02, 1.13341e-01, 1.34006e-01, 1.58440e-01, 1.87329e-01,
 2.21485e-01, 2.61869e-01, 3.09616e-01, 3.66069e-01, 4.32815e-01,
 5.11731e-01, 6.05036e-01, 7.15354e-01, 8.45786e-01, 1.00000e+00}
,
{5.00936e-08, 5.93639e-08, 7.03496e-08, 8.33684e-08, 9.87963e-08,
 1.17079e-07, 1.38746e-07, 1.64422e-07, 1.94849e-07, 2.30908e-07,
 2.73639e-07, 3.24278e-07, 3.84289e-07, 4.55404e-07, 5.39680e-07,
 6.39552e-07, 7.57907e-07, 8.98163e-07, 1.06438e-06, 1.26135e-06,
 1.49477e-06, 1.77139e-06, 2.09920e-06, 2.48767e-06, 2.94803e-06,
 3.49359e-06, 4.14011e-06, 4.90626e-06, 5.81421e-06, 6.89017e-06,
 8.16525e-06, 9.67630e-06, 1.14670e-05, 1.35890e-05, 1.61038e-05,
 1.90839e-05, 2.26155e-05, 2.68007e-05, 3.17604e-05, 3.76379e-05,
 4.46031e-05, 5.28573e-05, 6.26390e-05, 7.42308e-05, 8.79678e-05,
 1.04247e-04, 1.23539e-04, 1.46400e-04, 1.73493e-04, 2.05599e-04,
 2.43647e-04, 2.88736e-04, 3.42169e-04, 4.05490e-04, 4.80529e-04,
 5.69454e-04, 6.74836e-04, 7.99720e-04, 9.47715e-04, 1.12310e-03,
 1.33093e-03, 1.57723e-03, 1.86911e-03, 2.21501e-03, 2.62491e-03,
 3.11067e-03, 3.68633e-03, 4.36851e-03, 5.17694e-03, 6.13498e-03,
 7.27030e-03, 8.61573e-03, 1.02101e-02, 1.20996e-02, 1.43387e-02,
 1.69922e-02, 2.01368e-02, 2.38632e-02, 2.82793e-02, 3.35126e-02,
 3.97144e-02, 4.70639e-02, 5.57734e-02, 6.60947e-02, 7.83261e-02,
 9.28210e-02, 1.09998e-01, 1.30354e-01, 1.54477e-01, 1.83065e-01,
 2.16942e-01, 2.57089e-01, 3.04665e-01, 3.61046e-01, 4.27860e-01,
 5.07039e-01, 6.00871e-01, 7.12067e-01, 8.43841e-01, 1.00000e+00}
,
{3.98825e-08, 4.73720e-08, 5.62680e-08, 6.68346e-08, 7.93854e-08,
 9.42932e-08, 1.12001e-07, 1.33033e-07, 1.58015e-07, 1.87689e-07,
 2.22935e-07, 2.64800e-07, 3.14527e-07, 3.73591e-07, 4.43748e-07,
 5.27079e-07, 6.26060e-07, 7.43627e-07, 8.83273e-07, 1.04914e-06,
 1.24616e-06, 1.48018e-06, 1.75814e-06, 2.08830e-06, 2.48046e-06,
 2.94627e-06, 3.49954e-06, 4.15672e-06, 4.93731e-06, 5.86449e-06,
 6.96578e-06, 8.27388e-06, 9.82763e-06, 1.16732e-05, 1.38653e-05,
 1.64690e-05, 1.95617e-05, 2.32352e-05, 2.75985e-05, 3.27813e-05,
 3.89373e-05, 4.62493e-05, 5.49344e-05, 6.52505e-05, 7.75039e-05,
 9.20584e-05, 1.09346e-04, 1.29880e-04, 1.54270e-04, 1.83241e-04,
 2.17651e-04, 2.58524e-04, 3.07072e-04, 3.64737e-04, 4.33231e-04,
 5.14587e-04, 6.11221e-04, 7.26002e-04, 8.62338e-04, 1.02428e-03,
 1.21663e-03, 1.44509e-03, 1.71647e-03, 2.03880e-03, 2.42167e-03,
 2.87644e-03, 3.41660e-03, 4.05820e-03, 4.82029e-03, 5.72549e-03,
 6.80068e-03, 8.07778e-03, 9.59470e-03, 1.13965e-02, 1.35366e-02,
 1.60787e-02, 1.90981e-02, 2.26845e-02, 2.69444e-02, 3.20043e-02,
 3.80144e-02, 4.51531e-02, 5.36324e-02, 6.37040e-02, 7.56670e-02,
 8.98765e-02, 1.06754e-01, 1.26802e-01, 1.50614e-01, 1.78898e-01,
 2.12493e-01, 2.52397e-01, 2.99794e-01, 3.56092e-01, 4.22963e-01,
 5.02391e-01, 5.96735e-01, 7.08795e-01, 8.41900e-01, 1.00000e+00}
,
{3.17528e-08, 3.78026e-08, 4.50051e-08, 5.35798e-08, 6.37883e-08,
 7.59417e-08, 9.04107e-08, 1.07636e-07, 1.28144e-07, 1.52559e-07,
 1.81626e-07, 2.16231e-07, 2.57429e-07, 3.06476e-07, 3.64869e-07,
 4.34386e-07, 5.17149e-07, 6.15680e-07, 7.32985e-07, 8.72639e-07,
 1.03890e-06, 1.23684e-06, 1.47249e-06, 1.75304e-06, 2.08705e-06,
 2.48469e-06, 2.95809e-06, 3.52169e-06, 4.19267e-06, 4.99149e-06,
 5.94251e-06, 7.07472e-06, 8.42265e-06, 1.00274e-05, 1.19379e-05,
 1.42124e-05, 1.69203e-05, 2.01440e-05, 2.39820e-05, 2.85513e-05,
 3.39911e-05, 4.04674e-05, 4.81775e-05, 5.73567e-05, 6.82847e-05,
 8.12949e-05, 9.67838e-05, 1.15224e-04, 1.37177e-04, 1.63313e-04,
 1.94429e-04, 2.31473e-04, 2.75575e-04, 3.28080e-04, 3.90588e-04,
 4.65006e-04, 5.53603e-04, 6.59080e-04, 7.84653e-04, 9.34151e-04,
 1.11213e-03, 1.32403e-03, 1.57629e-03, 1.87662e-03, 2.23416e-03,
 2.65983e-03, 3.16661e-03, 3.76993e-03, 4.48821e-03, 5.34334e-03,
 6.36140e-03, 7.57342e-03, 9.01637e-03, 1.07342e-02, 1.27794e-02,
 1.52142e-02, 1.81130e-02, 2.15640e-02, 2.56726e-02, 3.05639e-02,
 3.63872e-02, 4.33199e-02, 5.15736e-02, 6.13998e-02, 7.30982e-02,
 8.70254e-02, 1.03606e-01, 1.23346e-01, 1.46847e-01, 1.74825e-01,
 2.08134e-01, 2.47790e-01, 2.95001e-01, 3.51207e-01, 4.18121e-01,
 4.97785e-01, 5.92627e-01, 7.05539e-01, 8.39964e-01, 1.00000e+00}
,
{2.52803e-08, 3.01663e-08, 3.59966e-08, 4.29538e-08, 5.12555e-08,
 6.11618e-08, 7.29827e-08, 8.70883e-08, 1.03920e-07, 1.24005e-07,
 1.47972e-07, 1.76570e-07, 2.10697e-07, 2.51418e-07, 3.00011e-07,
 3.57994e-07, 4.27185e-07, 5.09748e-07, 6.08268e-07, 7.25829e-07,
 8.66112e-07, 1.03351e-06, 1.23326e-06, 1.47161e-06, 1.75603e-06,
 2.09542e-06, 2.50041e-06, 2.98367e-06, 3.56033e-06, 4.24845e-06,
 5.06955e-06, 6.04936e-06, 7.21853e-06, 8.61367e-06, 1.02785e-05,
 1.22650e-05, 1.46355e-05, 1.74641e-05, 2.08394e-05, 2.48671e-05,
 2.96733e-05, 3.54083e-05, 4.22517e-05, 5.04178e-05, 6.01622e-05,
 7.17899e-05, 8.56649e-05, 1.02222e-04, 1.21978e-04, 1.45553e-04,
 1.73685e-04, 2.07253e-04, 2.47309e-04, 2.95107e-04, 3.52143e-04,
 4.20203e-04, 5.01416e-04, 5.98326e-04, 7.13966e-04, 8.51956e-04,
 1.01662e-03, 1.21310e-03, 1.44756e-03, 1.72733e-03, 2.06118e-03,
 2.45954e-03, 2.93491e-03, 3.50214e-03, 4.17901e-03, 4.98670e-03,
 5.95049e-03, 7.10055e-03, 8.47289e-03, 1.01105e-02, 1.20645e-02,
 1.43963e-02, 1.71787e-02, 2.04988e-02, 2.44607e-02, 2.91883e-02,
 3.48296e-02, 4.15612e-02, 4.95938e-02, 5.91789e-02, 7.06165e-02,
 8.42648e-02, 1.00551e-01, 1.19985e-01, 1.43174e-01, 1.70846e-01,
 2.03866e-01, 2.43267e-01, 2.90284e-01, 3.46388e-01, 4.13335e-01,
 4.93221e-01, 5.88547e-01, 7.02297e-01, 8.38032e-01, 1.00000e+00}
,
{2.01272e-08, 2.40726e-08, 2.87913e-08, 3.44351e-08, 4.11852e-08,
 4.92584e-08, 5.89142e-08, 7.04627e-08, 8.42751e-08, 1.00795e-07,
 1.20553e-07, 1.44184e-07, 1.72448e-07, 2.06251e-07, 2.46681e-07,
 2.95037e-07, 3.52871e-07, 4.22042e-07, 5.04772e-07, 6.03718e-07,
 7.22061e-07, 8.63602e-07, 1.03289e-06, 1.23536e-06, 1.47752e-06,
 1.76714e-06, 2.11354e-06, 2.52785e-06, 3.02336e-06, 3.61601e-06,
 4.32484e-06, 5.17260e-06, 6.18655e-06, 7.39926e-06, 8.84969e-06,
 1.05844e-05, 1.26592e-05, 1.51407e-05, 1.81087e-05, 2.16584e-05,
 2.59039e-05, 3.09817e-05, 3.70548e-05, 4.43184e-05, 5.30058e-05,
 6.33962e-05, 7.58233e-05, 9.06864e-05, 1.08463e-04, 1.29724e-04,
 1.55153e-04, 1.85567e-04, 2.21942e-04, 2.65448e-04, 3.17482e-04,
 3.79716e-04, 4.54149e-04, 5.43173e-04, 6.49647e-04, 7.76993e-04,
 9.29302e-04, 1.11147e-03, 1.32934e-03, 1.58992e-03, 1.90158e-03,
 2.27434e-03, 2.72016e-03, 3.25337e-03, 3.89111e-03, 4.65386e-03,
 5.56612e-03, 6.65721e-03, 7.96217e-03, 9.52294e-03, 1.13897e-02,
 1.36223e-02, 1.62926e-02, 1.94863e-02, 2.33061e-02, 2.78746e-02,
 3.33387e-02, 3.98738e-02, 4.76900e-02, 5.70383e-02, 6.82192e-02,
 8.15917e-02, 9.75856e-02, 1.16715e-01, 1.39593e-01, 1.66957e-01,
 1.99684e-01, 2.38827e-01, 2.85643e-01, 3.41635e-01, 4.08604e-01,
 4.88699e-01, 5.84496e-01, 6.99070e-01, 8.36104e-01, 1.00000e+00}
,
{1.60244e-08, 1.92098e-08, 2.30283e-08, 2.76059e-08, 3.30934e-08,
 3.96717e-08, 4.75576e-08, 5.70111e-08, 6.83438e-08, 8.19292e-08,
 9.82151e-08, 1.17738e-07, 1.41142e-07, 1.69199e-07, 2.02832e-07,
 2.43151e-07, 2.91485e-07, 3.49426e-07, 4.18885e-07, 5.02151e-07,
 6.01969e-07, 7.21628e-07, 8.65074e-07, 1.03703e-06, 1.24317e-06,
 1.49029e-06, 1.78653e-06, 2.14166e-06, 2.56738e-06, 3.07773e-06,
 3.68952e-06, 4.42292e-06, 5.30211e-06, 6.35607e-06, 7.61953e-06,
 9.13414e-06, 1.09498e-05, 1.31264e-05, 1.57357e-05, 1.88637e-05,
 2.26134e-05, 2.71085e-05, 3.24971e-05, 3.89569e-05, 4.67007e-05,
 5.59839e-05, 6.71124e-05, 8.04530e-05, 9.64455e-05, 1.15617e-04,
 1.38599e-04, 1.66150e-04, 1.99177e-04, 2.38770e-04, 2.86233e-04,
 3.43130e-04, 4.11338e-04, 4.93103e-04, 5.91123e-04, 7.08626e-04,
 8.49487e-04, 1.01835e-03, 1.22078e-03, 1.46344e-03, 1.75435e-03,
 2.10307e-03, 2.52112e-03, 3.02227e-03, 3.62304e-03, 4.34323e-03,
 5.20658e-03, 6.24154e-03, 7.48224e-03, 8.96956e-03, 1.07525e-02,
 1.28899e-02, 1.54522e-02, 1.85238e-02, 2.22059e-02, 2.66200e-02,
 3.19116e-02, 3.82550e-02, 4.58593e-02, 5.49752e-02, 6.59032e-02,
 7.90034e-02, 9.47078e-02, 1.13534e-01, 1.36102e-01, 1.63156e-01,
 1.95589e-01, 2.34468e-01, 2.81076e-01, 3.36948e-01, 4.03926e-01,
 4.84219e-01, 5.80472e-01, 6.95858e-01, 8.34181e-01, 1.00000e+00}
,
{1.27580e-08, 1.53293e-08, 1.84188e-08, 2.21310e-08, 2.65914e-08,
 3.19507e-08, 3.83902e-08, 4.61275e-08, 5.54242e-08, 6.65946e-08,
 8.00163e-08, 9.61430e-08, 1.15520e-07, 1.38802e-07, 1.66777e-07,
 2.00390e-07, 2.40777e-07, 2.89305e-07, 3.47612e-07, 4.17671e-07,
 5.01850e-07, 6.02995e-07, 7.24525e-07, 8.70548e-07, 1.04600e-06,
 1.25682e-06, 1.51012e-06, 1.81447e-06, 2.18017e-06, 2.61957e-06,
 3.14753e-06, 3.78189e-06, 4.54411e-06, 5.45995e-06, 6.56036e-06,
 7.88256e-06, 9.47125e-06, 1.13801e-05, 1.36737e-05, 1.64296e-05,
 1.97408e-05, 2.37195e-05, 2.85000e-05, 3.42440e-05, 4.11456e-05,
 4.94383e-05, 5.94022e-05, 7.13744e-05, 8.57594e-05, 1.03044e-04,
 1.23812e-04, 1.48765e-04, 1.78748e-04, 2.14773e-04, 2.58059e-04,
 3.10069e-04, 3.72562e-04, 4.47649e-04, 5.37870e-04, 6.46275e-04,
 7.76527e-04, 9.33032e-04, 1.12108e-03, 1.34702e-03, 1.61851e-03,
 1.94471e-03, 2.33665e-03, 2.80759e-03, 3.37344e-03, 4.05334e-03,
 4.87026e-03, 5.85183e-03, 7.03123e-03, 8.44834e-03, 1.01510e-02,
 1.21969e-02, 1.46551e-02, 1.76088e-02, 2.11577e-02, 2.54219e-02,
 3.05456e-02, 3.67018e-02, 4.40989e-02, 5.29867e-02, 6.36658e-02,
 7.64973e-02, 9.19148e-02, 1.10440e-01, 1.32698e-01, 1.59443e-01,
 1.91577e-01, 2.30188e-01, 2.76581e-01, 3.32325e-01, 3.99303e-01,
 4.79780e-01, 5.76476e-01, 6.92661e-01, 8.32263e-01, 1.00000e+00}
,
{1.01574e-08, 1.22327e-08, 1.47320e-08, 1.77419e-08, 2.13669e-08,
 2.57324e-08, 3.09899e-08, 3.73215e-08, 4.49468e-08, 5.41301e-08,
 6.51896e-08, 7.85087e-08, 9.45491e-08, 1.13867e-07, 1.37131e-07,
 1.65149e-07, 1.98891e-07, 2.39527e-07, 2.88466e-07, 3.47404e-07,
 4.18383e-07, 5.03864e-07, 6.06811e-07, 7.30790e-07, 8.80100e-07,
 1.05992e-06, 1.27647e-06, 1.53727e-06, 1.85136e-06, 2.22962e-06,
 2.68516e-06, 3.23377e-06, 3.89447e-06, 4.69017e-06, 5.64843e-06,
 6.80248e-06, 8.19232e-06, 9.86613e-06, 1.18819e-05, 1.43095e-05,
 1.72332e-05, 2.07541e-05, 2.49945e-05, 3.01012e-05, 3.62513e-05,
 4.36579e-05, 5.25778e-05, 6.33202e-05, 7.62574e-05, 9.18378e-05,
 1.10602e-04, 1.33199e-04, 1.60413e-04, 1.93188e-04, 2.32659e-04,
 2.80194e-04, 3.37442e-04, 4.06385e-04, 4.89415e-04, 5.89410e-04,
 7.09834e-04, 8.54863e-04, 1.02952e-03, 1.23987e-03, 1.49319e-03,
 1.79827e-03, 2.16568e-03, 2.60816e-03, 3.14104e-03, 3.78280e-03,
 4.55567e-03, 5.48646e-03, 6.60742e-03, 7.95740e-03, 9.58320e-03,
 1.15412e-02, 1.38992e-02, 1.67390e-02, 2.01590e-02, 2.42778e-02,
 2.92380e-02, 3.52118e-02, 4.24060e-02, 5.10701e-02, 6.15044e-02,
 7.40706e-02, 8.92043e-02, 1.07430e-01, 1.29379e-01, 1.55813e-01,
 1.87648e-01, 2.25987e-01, 2.72159e-01, 3.27765e-01, 3.94732e-01,
 4.75381e-01, 5.72508e-01, 6.89479e-01, 8.30349e-01, 1.00000e+00}
,
{8.08691e-09, 9.76163e-09, 1.17832e-08, 1.42233e-08, 1.71688e-08,
 2.07243e-08, 2.50161e-08, 3.01967e-08, 3.64501e-08, 4.39986e-08,
 5.31102e-08, 6.41088e-08, 7.73851e-08, 9.34108e-08, 1.12755e-07,
 1.36106e-07, 1.64292e-07, 1.98315e-07, 2.39384e-07, 2.88958e-07,
 3.48798e-07, 4.21030e-07, 5.08222e-07, 6.13469e-07, 7.40512e-07,
 8.93865e-07, 1.07898e-06, 1.30242e-06, 1.57214e-06, 1.89771e-06,
 2.29071e-06, 2.76509e-06, 3.33771e-06, 4.02892e-06, 4.86327e-06,
 5.87040e-06, 7.08610e-06, 8.55356e-06, 1.03249e-05, 1.24631e-05,
 1.50441e-05, 1.81595e-05, 2.19202e-05, 2.64596e-05, 3.19392e-05,
 3.85534e-05, 4.65375e-05, 5.61749e-05, 6.78082e-05, 8.18505e-05,
 9.88009e-05, 1.19262e-04, 1.43959e-04, 1.73772e-04, 2.09758e-04,
 2.53197e-04, 3.05632e-04, 3.68925e-04, 4.45326e-04, 5.37548e-04,
 6.48869e-04, 7.83243e-04, 9.45444e-04, 1.14124e-03, 1.37757e-03,
 1.66286e-03, 2.00722e-03, 2.42289e-03, 2.92465e-03, 3.53031e-03,
 4.26140e-03, 5.14389e-03, 6.20914e-03, 7.49499e-03, 9.04713e-03,
 1.09207e-02, 1.31823e-02, 1.59122e-02, 1.92074e-02, 2.31851e-02,
 2.79865e-02, 3.37822e-02, 4.07781e-02, 4.92229e-02, 5.94164e-02,
 7.17209e-02, 8.65736e-02, 1.04502e-01, 1.26143e-01, 1.52266e-01,
 1.83799e-01, 2.21862e-01, 2.67808e-01, 3.23268e-01, 3.90213e-01,
 4.71023e-01, 5.68567e-01, 6.86311e-01, 8.28439e-01, 1.00000e+00}
,
{6.43847e-09, 7.78973e-09, 9.42457e-09, 1.14025e-08, 1.37956e-08,
 1.66909e-08, 2.01939e-08, 2.44320e-08, 2.95596e-08, 3.57634e-08,
 4.32691e-08, 5.23501e-08, 6.33370e-08, 7.66297e-08, 9.27121e-08,
 1.12170e-07, 1.35711e-07, 1.64193e-07, 1.98653e-07, 2.40345e-07,
 2.90786e-07, 3.51814e-07, 4.25650e-07, 5.14983e-07, 6.23063e-07,
 7.53827e-07, 9.12035e-07, 1.10345e-06, 1.33503e-06, 1.61521e-06,
 1.95420e-06, 2.36434e-06, 2.86055e-06, 3.46089e-06, 4.18724e-06,
 5.06603e-06, 6.12925e-06, 7.41561e-06, 8.97194e-06, 1.08549e-05,
 1.31330e-05, 1.58893e-05, 1.92240e-05, 2.32586e-05, 2.81400e-05,
 3.40458e-05, 4.11910e-05, 4.98359e-05, 6.02951e-05, 7.29494e-05,
 8.82594e-05, 1.06783e-04, 1.29193e-04, 1.56307e-04, 1.89112e-04,
 2.28802e-04, 2.76821e-04, 3.34918e-04, 4.05208e-04, 4.90250e-04,
 5.93139e-04, 7.17623e-04, 8.68232e-04, 1.05045e-03, 1.27091e-03,
 1.53764e-03, 1.86035e-03, 2.25078e-03, 2.72316e-03, 3.29468e-03,
 3.98614e-03, 4.82272e-03, 5.83488e-03, 7.05946e-03, 8.54104e-03,
 1.03336e-02, 1.25023e-02, 1.51262e-02, 1.83008e-02, 2.21416e-02,
 2.67885e-02, 3.24107e-02, 3.92128e-02, 4.74424e-02, 5.73993e-02,
 6.94458e-02, 8.40206e-02, 1.01654e-01, 1.22989e-01, 1.48800e-01,
 1.80030e-01, 2.17813e-01, 2.63526e-01, 3.18832e-01, 3.85747e-01,
 4.66704e-01, 5.64653e-01, 6.83158e-01, 8.26533e-01, 1.00000e+00}
,
{5.12605e-09, 6.21616e-09, 7.53810e-09, 9.14116e-09, 1.10851e-08,
 1.34425e-08, 1.63012e-08, 1.97679e-08, 2.39717e-08, 2.90696e-08,
 3.52516e-08, 4.27482e-08, 5.18391e-08, 6.28633e-08, 7.62319e-08,
 9.24434e-08, 1.12103e-07, 1.35943e-07, 1.64852e-07, 1.99910e-07,
 2.42423e-07, 2.93977e-07, 3.56495e-07, 4.32307e-07, 5.24243e-07,
 6.35729e-07, 7.70924e-07, 9.34869e-07, 1.13368e-06, 1.37477e-06,
 1.66713e-06, 2.02167e-06, 2.45160e-06, 2.97296e-06, 3.60519e-06,
 4.37187e-06, 5.30160e-06, 6.42905e-06, 7.79626e-06, 9.45422e-06,
 1.14648e-05, 1.39029e-05, 1.68595e-05, 2.04449e-05, 2.47927e-05,
 3.00651e-05, 3.64588e-05, 4.42122e-05, 5.36145e-05, 6.50162e-05,
 7.88426e-05, 9.56094e-05, 1.15942e-04, 1.40598e-04, 1.70498e-04,
 2.06756e-04, 2.50725e-04, 3.04045e-04, 3.68704e-04, 4.47113e-04,
 5.42197e-04, 6.57501e-04, 7.97326e-04, 9.66886e-04, 1.17251e-03,
 1.42185e-03, 1.72423e-03, 2.09090e-03, 2.53556e-03, 3.07477e-03,
 3.72866e-03, 4.52160e-03, 5.48317e-03, 6.64923e-03, 8.06326e-03,
 9.77801e-03, 1.18574e-02, 1.43790e-02, 1.74369e-02, 2.11450e-02,
 2.56418e-02, 3.10948e-02, 3.77075e-02, 4.57264e-02, 5.54506e-02,
 6.72428e-02, 8.15428e-02, 9.88838e-02, 1.19913e-01, 1.45413e-01,
 1.76337e-01, 2.13837e-01, 2.59312e-01, 3.14458e-01, 3.81331e-01,
 4.62425e-01, 5.60766e-01, 6.80019e-01, 8.24632e-01, 1.00000e+00}
,
{4.08115e-09, 4.96046e-09, 6.02923e-09, 7.32827e-09, 8.90719e-09,
 1.08263e-08, 1.31589e-08, 1.59941e-08, 1.94401e-08, 2.36286e-08,
 2.87196e-08, 3.49074e-08, 4.24285e-08, 5.15700e-08, 6.26811e-08,
 7.61862e-08, 9.26010e-08, 1.12553e-07, 1.36803e-07, 1.66278e-07,
 2.02104e-07, 2.45648e-07, 2.98575e-07, 3.62905e-07, 4.41095e-07,
 5.36132e-07, 6.51645e-07, 7.92047e-07, 9.62699e-07, 1.17012e-06,
 1.42223e-06, 1.72866e-06, 2.10111e-06, 2.55381e-06, 3.10404e-06,
 3.77283e-06, 4.58572e-06, 5.57374e-06, 6.77464e-06, 8.23428e-06,
 1.00084e-05, 1.21648e-05, 1.47858e-05, 1.79715e-05, 2.18436e-05,
 2.65499e-05, 3.22703e-05, 3.92231e-05, 4.76740e-05, 5.79457e-05,
 7.04305e-05, 8.56053e-05, 1.04050e-04, 1.26468e-04, 1.53716e-04,
 1.86835e-04, 2.27090e-04, 2.76018e-04, 3.35488e-04, 4.07772e-04,
 4.95629e-04, 6.02416e-04, 7.32210e-04, 8.89970e-04, 1.08172e-03,
 1.31478e-03, 1.59806e-03, 1.94238e-03, 2.36088e-03, 2.86954e-03,
 3.48781e-03, 4.23928e-03, 5.15266e-03, 6.26284e-03, 7.61221e-03,
 9.25231e-03, 1.12458e-02, 1.36688e-02, 1.66138e-02, 2.01934e-02,
 2.45442e-02, 2.98324e-02, 3.62600e-02, 4.40724e-02, 5.35681e-02,
 6.51097e-02, 7.91381e-02, 9.61889e-02, 1.16914e-01, 1.42103e-01,
 1.72720e-01, 2.09934e-01, 2.55166e-01, 3.10143e-01, 3.76966e-01,
 4.58186e-01, 5.56905e-01, 6.76894e-01, 8.22736e-01, 1.00000e+00}
,
{3.24925e-09, 3.95842e-09, 4.82238e-09, 5.87491e-09, 7.15716e-09,
 8.71928e-09, 1.06223e-08, 1.29408e-08, 1.57652e-08, 1.92061e-08,
 2.33980e-08, 2.85048e-08, 3.47262e-08, 4.23055e-08, 5.15391e-08,
 6.27879e-08, 7.64919e-08, 9.31870e-08, 1.13526e-07, 1.38304e-07,
 1.68490e-07, 2.05264e-07, 2.50065e-07, 3.04644e-07, 3.71135e-07,
 4.52139e-07, 5.50822e-07, 6.71044e-07, 8.17505e-07, 9.95933e-07,
 1.21330e-06, 1.47812e-06, 1.80073e-06, 2.19376e-06, 2.67256e-06,
 3.25587e-06, 3.96650e-06, 4.83222e-06, 5.88689e-06, 7.17176e-06,
 8.73706e-06, 1.06440e-05, 1.29671e-05, 1.57973e-05, 1.92453e-05,
 2.34457e-05, 2.85629e-05, 3.47970e-05, 4.23918e-05, 5.16442e-05,
 6.29160e-05, 7.66480e-05, 9.33771e-05, 1.13757e-04, 1.38586e-04,
 1.68834e-04, 2.05683e-04, 2.50575e-04, 3.05265e-04, 3.71892e-04,
 4.53061e-04, 5.51946e-04, 6.72413e-04, 8.19173e-04, 9.97964e-04,
 1.21578e-03, 1.48113e-03, 1.80440e-03, 2.19823e-03, 2.67801e-03,
 3.26251e-03, 3.97459e-03, 4.84208e-03, 5.89890e-03, 7.18639e-03,
 8.75488e-03, 1.06657e-02, 1.29936e-02, 1.58296e-02, 1.92845e-02,
 2.34935e-02, 2.86212e-02, 3.48680e-02, 4.24783e-02, 5.17495e-02,
 6.30443e-02, 7.68043e-02, 9.35675e-02, 1.13989e-01, 1.38869e-01,
 1.69178e-01, 2.06103e-01, 2.51086e-01, 3.05888e-01, 3.72651e-01,
 4.53985e-01, 5.53072e-01, 6.73784e-01, 8.20844e-01, 1.00000e+00}
,
{2.58692e-09, 3.15880e-09, 3.85711e-09, 4.70979e-09, 5.75097e-09,
 7.02232e-09, 8.57472e-09, 1.04703e-08, 1.27850e-08, 1.56113e-08,
 1.90624e-08, 2.32765e-08, 2.84222e-08, 3.47054e-08, 4.23776e-08,
 5.17459e-08, 6.31852e-08, 7.71534e-08, 9.42095e-08, 1.15036e-07,
 1.40467e-07, 1.71520e-07, 2.09437e-07, 2.55736e-07, 3.12271e-07,
 3.81304e-07, 4.65598e-07, 5.68527e-07, 6.94209e-07, 8.47676e-07,
 1.03507e-06, 1.26389e-06, 1.54329e-06, 1.88447e-06, 2.30106e-06,
 2.80975e-06, 3.43089e-06, 4.18935e-06, 5.11548e-06, 6.24634e-06,
 7.62720e-06, 9.31333e-06, 1.13722e-05, 1.38862e-05, 1.69560e-05,
 2.07044e-05, 2.52815e-05, 3.08704e-05, 3.76948e-05, 4.60279e-05,
 5.62032e-05, 6.86279e-05, 8.37993e-05, 1.02325e-04, 1.24945e-04,
 1.52566e-04, 1.86294e-04, 2.27477e-04, 2.77765e-04, 3.39170e-04,
 4.14149e-04, 5.05704e-04, 6.17499e-04, 7.54007e-04, 9.20693e-04,
 1.12423e-03, 1.37276e-03, 1.67623e-03, 2.04679e-03, 2.49927e-03,
 3.05177e-03, 3.72642e-03, 4.55021e-03, 5.55611e-03, 6.78439e-03,
 8.28420e-03, 1.01156e-02, 1.23518e-02, 1.50824e-02, 1.84166e-02,
 2.24879e-02, 2.74592e-02, 3.35295e-02, 4.09418e-02, 4.99927e-02,
 6.10444e-02, 7.45393e-02, 9.10176e-02, 1.11139e-01, 1.35708e-01,
 1.65708e-01, 2.02341e-01, 2.47072e-01, 3.01691e-01, 3.68385e-01,
 4.49823e-01, 5.49264e-01, 6.70689e-01, 8.18956e-01, 1.00000e+00}
,
{2.05960e-09, 2.52071e-09, 3.08505e-09, 3.77573e-09, 4.62105e-09,
 5.65562e-09, 6.92182e-09, 8.47149e-09, 1.03681e-08, 1.26893e-08,
 1.55302e-08, 1.90072e-08, 2.32626e-08, 2.84706e-08, 3.48447e-08,
 4.26458e-08, 5.21934e-08, 6.38786e-08, 7.81799e-08, 9.56829e-08,
 1.17105e-07, 1.43322e-07, 1.75410e-07, 2.14681e-07, 2.62744e-07,
 3.21567e-07, 3.93560e-07, 4.81672e-07, 5.89509e-07, 7.21490e-07,
 8.83018e-07, 1.08071e-06, 1.32266e-06, 1.61878e-06, 1.98120e-06,
 2.42475e-06, 2.96761e-06, 3.63201e-06, 4.44515e-06, 5.44034e-06,
 6.65833e-06, 8.14901e-06, 9.97343e-06, 1.22063e-05, 1.49391e-05,
 1.82837e-05, 2.23770e-05, 2.73869e-05, 3.35183e-05, 4.10224e-05,
 5.02066e-05, 6.14470e-05, 7.52039e-05, 9.20407e-05, 1.12647e-04,
 1.37867e-04, 1.68732e-04, 2.06509e-04, 2.52742e-04, 3.09327e-04,
 3.78579e-04, 4.63336e-04, 5.67069e-04, 6.94026e-04, 8.49405e-04,
 1.03957e-03, 1.27231e-03, 1.55716e-03, 1.90578e-03, 2.33245e-03,
 2.85465e-03, 3.49375e-03, 4.27594e-03, 5.23325e-03, 6.40488e-03,
 7.83881e-03, 9.59378e-03, 1.17417e-02, 1.43704e-02, 1.75877e-02,
 2.15252e-02, 2.63444e-02, 3.22424e-02, 3.94609e-02, 4.82955e-02,
 5.91080e-02, 7.23412e-02, 8.85371e-02, 1.08359e-01, 1.32619e-01,
 1.62309e-01, 1.98648e-01, 2.43121e-01, 2.97552e-01, 3.64168e-01,
 4.45699e-01, 5.45483e-01, 6.67607e-01, 8.17072e-01, 1.00000e+00}
,
{1.63977e-09, 2.01151e-09, 2.46753e-09, 3.02692e-09, 3.71314e-09,
 4.55492e-09, 5.58753e-09, 6.85424e-09, 8.40812e-09, 1.03143e-08,
 1.26526e-08, 1.55209e-08, 1.90396e-08, 2.33559e-08, 2.86508e-08,
 3.51460e-08, 4.31137e-08, 5.28878e-08, 6.48776e-08, 7.95856e-08,
 9.76279e-08, 1.19760e-07, 1.46911e-07, 1.80216e-07, 2.21071e-07,
 2.71189e-07, 3.32668e-07, 4.08085e-07, 5.00600e-07, 6.14087e-07,
 7.53303e-07, 9.24079e-07, 1.13357e-06, 1.39056e-06, 1.70580e-06,
 2.09251e-06, 2.56689e-06, 3.14881e-06, 3.86266e-06, 4.73834e-06,
 5.81253e-06, 7.13025e-06, 8.74671e-06, 1.07296e-05, 1.31621e-05,
 1.61459e-05, 1.98063e-05, 2.42964e-05, 2.98045e-05, 3.65613e-05,
 4.48499e-05, 5.50175e-05, 6.74901e-05, 8.27904e-05, 1.01559e-04,
 1.24583e-04, 1.52826e-04, 1.87473e-04, 2.29973e-04, 2.82109e-04,
 3.46064e-04, 4.24518e-04, 5.20758e-04, 6.38816e-04, 7.83637e-04,
 9.61290e-04, 1.17922e-03, 1.44655e-03, 1.77449e-03, 2.17677e-03,
 2.67025e-03, 3.27561e-03, 4.01820e-03, 4.92914e-03, 6.04659e-03,
 7.41738e-03, 9.09892e-03, 1.11617e-02, 1.36921e-02, 1.67961e-02,
 2.06038e-02, 2.52748e-02, 3.10047e-02, 3.80336e-02, 4.66559e-02,
 5.72329e-02, 7.02078e-02, 8.61242e-02, 1.05649e-01, 1.29600e-01,
 1.58981e-01, 1.95022e-01, 2.39234e-01, 2.93469e-01, 3.60000e-01,
 4.41613e-01, 5.41728e-01, 6.64540e-01, 8.15193e-01, 1.00000e+00}
,
{1.30552e-09, 1.60517e-09, 1.97361e-09, 2.42662e-09, 2.98360e-09,
 3.66843e-09, 4.51045e-09, 5.54574e-09, 6.81866e-09, 8.38376e-09,
 1.03081e-08, 1.26741e-08, 1.55832e-08, 1.91601e-08, 2.35579e-08,
 2.89652e-08, 3.56136e-08, 4.37880e-08, 5.38387e-08, 6.61964e-08,
 8.13905e-08, 1.00072e-07, 1.23042e-07, 1.51284e-07, 1.86008e-07,
 2.28703e-07, 2.81197e-07, 3.45741e-07, 4.25099e-07, 5.22673e-07,
 6.42643e-07, 7.90149e-07, 9.71513e-07, 1.19451e-06, 1.46868e-06,
 1.80579e-06, 2.22028e-06, 2.72990e-06, 3.35650e-06, 4.12692e-06,
 5.07417e-06, 6.23886e-06, 7.67087e-06, 9.43157e-06, 1.15964e-05,
 1.42582e-05, 1.75308e-05, 2.15547e-05, 2.65022e-05, 3.25853e-05,
 4.00646e-05, 4.92607e-05, 6.05676e-05, 7.44697e-05, 9.15629e-05,
 1.12579e-04, 1.38420e-04, 1.70192e-04, 2.09256e-04, 2.57287e-04,
 3.16342e-04, 3.88952e-04, 4.78229e-04, 5.87998e-04, 7.22961e-04,
 8.88904e-04, 1.09293e-03, 1.34380e-03, 1.65224e-03, 2.03148e-03,
 2.49777e-03, 3.07109e-03, 3.77600e-03, 4.64271e-03, 5.70835e-03,
 7.01860e-03, 8.62958e-03, 1.06103e-02, 1.30457e-02, 1.60402e-02,
 1.97219e-02, 2.42487e-02, 2.98145e-02, 3.66578e-02, 4.50720e-02,
 5.54174e-02, 6.81374e-02, 8.37771e-02, 1.03007e-01, 1.26650e-01,
 1.55720e-01, 1.91462e-01, 2.35409e-01, 2.89443e-01, 3.55879e-01,
 4.37564e-01, 5.37999e-01, 6.61486e-01, 8.13318e-01, 1.00000e+00}
,
{1.03940e-09, 1.28092e-09, 1.57856e-09, 1.94537e-09, 2.39740e-09,
 2.95448e-09, 3.64099e-09, 4.48704e-09, 5.52967e-09, 6.81457e-09,
 8.39805e-09, 1.03495e-08, 1.27543e-08, 1.57180e-08, 1.93703e-08,
 2.38713e-08, 2.94182e-08, 3.62539e-08, 4.46781e-08, 5.50598e-08,
 6.78538e-08, 8.36207e-08, 1.03051e-07, 1.26997e-07, 1.56506e-07,
 1.92873e-07, 2.37690e-07, 2.92921e-07, 3.60986e-07, 4.44867e-07,
 5.48239e-07, 6.75631e-07, 8.32624e-07, 1.02610e-06, 1.26453e-06,
 1.55836e-06, 1.92047e-06, 2.36672e-06, 2.91666e-06, 3.59440e-06,
 4.42961e-06, 5.45890e-06, 6.72736e-06, 8.29056e-06, 1.02170e-05,
 1.25911e-05, 1.55168e-05, 1.91224e-05, 2.35658e-05, 2.90417e-05,
 3.57899e-05, 4.41063e-05, 5.43551e-05, 6.69853e-05, 8.25504e-05,
 1.01732e-04, 1.25371e-04, 1.54503e-04, 1.90405e-04, 2.34648e-04,
 2.89172e-04, 3.56366e-04, 4.39173e-04, 5.41222e-04, 6.66983e-04,
 8.21967e-04, 1.01296e-03, 1.24834e-03, 1.53841e-03, 1.89589e-03,
 2.33643e-03, 2.87933e-03, 3.54839e-03, 4.37292e-03, 5.38903e-03,
 6.64126e-03, 8.18446e-03, 1.00862e-02, 1.24299e-02, 1.53182e-02,
 1.88777e-02, 2.32642e-02, 2.86700e-02, 3.53319e-02, 4.35418e-02,
 5.36594e-02, 6.61280e-02, 8.14939e-02, 1.00430e-01, 1.23767e-01,
 1.52526e-01, 1.87968e-01, 2.31645e-01, 2.85471e-01, 3.51805e-01,
 4.33553e-01, 5.34295e-01, 6.58447e-01, 8.11448e-01, 1.00000e+00}
,
{8.27528e-10, 1.02217e-09, 1.26259e-09, 1.55956e-09, 1.92638e-09,
 2.37947e-09, 2.93914e-09, 3.63044e-09, 4.48435e-09, 5.53909e-09,
 6.84192e-09, 8.45119e-09, 1.04390e-08, 1.28943e-08, 1.59271e-08,
 1.96733e-08, 2.43005e-08, 3.00162e-08, 3.70762e-08, 4.57967e-08,
 5.65684e-08, 6.98737e-08, 8.63084e-08, 1.06609e-07, 1.31684e-07,
 1.62657e-07, 2.00915e-07, 2.48171e-07, 3.06542e-07, 3.78643e-07,
 4.67702e-07, 5.77709e-07, 7.13590e-07, 8.81431e-07, 1.08875e-06,
 1.34483e-06, 1.66114e-06, 2.05186e-06, 2.53446e-06, 3.13059e-06,
 3.86692e-06, 4.77645e-06, 5.89990e-06, 7.28759e-06, 9.00168e-06,
 1.11189e-05, 1.37342e-05, 1.69646e-05, 2.09547e-05, 2.58834e-05,
 3.19714e-05, 3.94912e-05, 4.87798e-05, 6.02532e-05, 7.44251e-05,
 9.19304e-05, 1.13553e-04, 1.40261e-04, 1.73252e-04, 2.14002e-04,
 2.64336e-04, 3.26510e-04, 4.03307e-04, 4.98168e-04, 6.15340e-04,
 7.60072e-04, 9.38846e-04, 1.15967e-03, 1.43243e-03, 1.76935e-03,
 2.18551e-03, 2.69955e-03, 3.33451e-03, 4.11880e-03, 5.08757e-03,
 6.28420e-03, 7.76229e-03, 9.58803e-03, 1.18432e-02, 1.46288e-02,
 1.80696e-02, 2.23197e-02, 2.75694e-02, 3.40539e-02, 4.20636e-02,
 5.19572e-02, 6.41779e-02, 7.92730e-02, 9.79185e-02, 1.20950e-01,
 1.49398e-01, 1.84537e-01, 2.27941e-01, 2.81555e-01, 3.47778e-01,
 4.29578e-01, 5.30617e-01, 6.55422e-01, 8.09581e-01, 1.00000e+00}
,
{6.58844e-10, 8.15684e-10, 1.00986e-09, 1.25026e-09, 1.54789e-09,
 1.91637e-09, 2.37258e-09, 2.93738e-09, 3.63663e-09, 4.50234e-09,
 5.57415e-09, 6.90109e-09, 8.54392e-09, 1.05778e-08, 1.30959e-08,
 1.62135e-08, 2.00732e-08, 2.48517e-08, 3.07677e-08, 3.80921e-08,
 4.71600e-08, 5.83866e-08, 7.22858e-08, 8.94937e-08, 1.10798e-07,
 1.37174e-07, 1.69829e-07, 2.10257e-07, 2.60310e-07, 3.22278e-07,
 3.98997e-07, 4.93980e-07, 6.11574e-07, 7.57161e-07, 9.37406e-07,
 1.16056e-06, 1.43684e-06, 1.77888e-06, 2.20235e-06, 2.72663e-06,
 3.37571e-06, 4.17931e-06, 5.17422e-06, 6.40596e-06, 7.93092e-06,
 9.81891e-06, 1.21563e-05, 1.50502e-05, 1.86330e-05, 2.30686e-05,
 2.85602e-05, 3.53591e-05, 4.37764e-05, 5.41976e-05, 6.70995e-05,
 8.30728e-05, 1.02849e-04, 1.27332e-04, 1.57644e-04, 1.95172e-04,
 2.41633e-04, 2.99155e-04, 3.70370e-04, 4.58538e-04, 5.67695e-04,
 7.02837e-04, 8.70150e-04, 1.07729e-03, 1.33375e-03, 1.65125e-03,
 2.04434e-03, 2.53100e-03, 3.13351e-03, 3.87946e-03, 4.80298e-03,
 5.94635e-03, 7.36190e-03, 9.11443e-03, 1.12842e-02, 1.39704e-02,
 1.72961e-02, 2.14135e-02, 2.65111e-02, 3.28221e-02, 4.06356e-02,
 5.03090e-02, 6.22853e-02, 7.71126e-02, 9.54695e-02, 1.18196e-01,
 1.46334e-01, 1.81169e-01, 2.24297e-01, 2.77691e-01, 3.43797e-01,
 4.25639e-01, 5.26964e-01, 6.52410e-01, 8.07719e-01, 1.00000e+00}
,
{5.24545e-10, 6.50912e-10, 8.07722e-10, 1.00231e-09, 1.24377e-09,
 1.54341e-09, 1.91523e-09, 2.37662e-09, 2.94917e-09, 3.65964e-09,
 4.54128e-09, 5.63531e-09, 6.99290e-09, 8.67755e-09, 1.07680e-08,
 1.33621e-08, 1.65812e-08, 2.05757e-08, 2.55326e-08, 3.16836e-08,
 3.93164e-08, 4.87881e-08, 6.05415e-08, 7.51264e-08, 9.32250e-08,
 1.15684e-07, 1.43553e-07, 1.78136e-07, 2.21050e-07, 2.74303e-07,
 3.40384e-07, 4.22386e-07, 5.24142e-07, 6.50412e-07, 8.07101e-07,
 1.00154e-06, 1.24282e-06, 1.54222e-06, 1.91375e-06, 2.37479e-06,
 2.94690e-06, 3.65683e-06, 4.53779e-06, 5.63098e-06, 6.98753e-06,
 8.67088e-06, 1.07598e-05, 1.33519e-05, 1.65685e-05, 2.05599e-05,
 2.55130e-05, 3.16593e-05, 3.92862e-05, 4.87506e-05, 6.04950e-05,
 7.50687e-05, 9.31534e-05, 1.15595e-04, 1.43442e-04, 1.77999e-04,
 2.20880e-04, 2.74092e-04, 3.40123e-04, 4.22061e-04, 5.23739e-04,
 6.49912e-04, 8.06481e-04, 1.00077e-03, 1.24186e-03, 1.54104e-03,
 1.91228e-03, 2.37297e-03, 2.94464e-03, 3.65402e-03, 4.53431e-03,
 5.62666e-03, 6.98216e-03, 8.66422e-03, 1.07515e-02, 1.33416e-02,
 1.65557e-02, 2.05441e-02, 2.54934e-02, 3.16349e-02, 3.92560e-02,
 4.87131e-02, 6.04485e-02, 7.50110e-02, 9.30818e-02, 1.15506e-01,
 1.43332e-01, 1.77862e-01, 2.20711e-01, 2.73881e-01, 3.39862e-01,
 4.21737e-01, 5.23337e-01, 6.49413e-01, 8.05862e-01, 1.00000e+00}
,
{4.17621e-10, 5.19424e-10, 6.46043e-10, 8.03529e-10, 9.99403e-10,
 1.24303e-09, 1.54604e-09, 1.92291e-09, 2.39166e-09, 2.97467e-09,
 3.69980e-09, 4.60170e-09, 5.72344e-09, 7.11864e-09, 8.85394e-09,
 1.10123e-08, 1.36967e-08, 1.70355e-08, 2.11882e-08, 2.63533e-08,
 3.27774e-08, 4.07675e-08, 5.07053e-08, 6.30656e-08, 7.84390e-08,
 9.75600e-08, 1.21342e-07, 1.50921e-07, 1.87711e-07, 2.33469e-07,
 2.90382e-07, 3.61168e-07, 4.49209e-07, 5.58713e-07, 6.94909e-07,
 8.64306e-07, 1.07500e-06, 1.33705e-06, 1.66298e-06, 2.06836e-06,
 2.57256e-06, 3.19967e-06, 3.97965e-06, 4.94976e-06, 6.15636e-06,
 7.65708e-06, 9.52364e-06, 1.18452e-05, 1.47327e-05, 1.83241e-05,
 2.27909e-05, 2.83466e-05, 3.52566e-05, 4.38510e-05, 5.45405e-05,
 6.78358e-05, 8.43720e-05, 1.04939e-04, 1.30520e-04, 1.62337e-04,
 2.01910e-04, 2.51129e-04, 3.12346e-04, 3.88486e-04, 4.83187e-04,
 6.00973e-04, 7.47471e-04, 9.29681e-04, 1.15631e-03, 1.43818e-03,
 1.78876e-03, 2.22481e-03, 2.76714e-03, 3.44169e-03, 4.28066e-03,
 5.32415e-03, 6.62201e-03, 8.23625e-03, 1.02440e-02, 1.27411e-02,
 1.58470e-02, 1.97101e-02, 2.45147e-02, 3.04907e-02, 3.79233e-02,
 4.71678e-02, 5.86659e-02, 7.29668e-02, 9.07538e-02, 1.12877e-01,
 1.40392e-01, 1.74616e-01, 2.17182e-01, 2.70124e-01, 3.35971e-01,
 4.17871e-01, 5.19734e-01, 6.46429e-01, 8.04008e-01, 1.00000e+00}
,
{3.32493e-10, 4.14498e-10, 5.16728e-10, 6.44171e-10, 8.03047e-10,
 1.00111e-09, 1.24802e-09, 1.55582e-09, 1.93954e-09, 2.41790e-09,
 3.01424e-09, 3.75766e-09, 4.68444e-09, 5.83979e-09, 7.28009e-09,
 9.07562e-09, 1.13140e-08, 1.41044e-08, 1.75831e-08, 2.19197e-08,
 2.73259e-08, 3.40654e-08, 4.24672e-08, 5.29411e-08, 6.59982e-08,
 8.22757e-08, 1.02568e-07, 1.27865e-07, 1.59401e-07, 1.98715e-07,
 2.47725e-07, 3.08823e-07, 3.84989e-07, 4.79942e-07, 5.98312e-07,
 7.45878e-07, 9.29838e-07, 1.15917e-06, 1.44506e-06, 1.80146e-06,
 2.24577e-06, 2.79966e-06, 3.49015e-06, 4.35095e-06, 5.42405e-06,
 6.76181e-06, 8.42952e-06, 1.05085e-05, 1.31003e-05, 1.63313e-05,
 2.03592e-05, 2.53805e-05, 3.16403e-05, 3.94439e-05, 4.91722e-05,
 6.12998e-05, 7.64185e-05, 9.52660e-05, 1.18762e-04, 1.48053e-04,
 1.84568e-04, 2.30089e-04, 2.86837e-04, 3.57582e-04, 4.45774e-04,
 5.55718e-04, 6.92778e-04, 8.63642e-04, 1.07665e-03, 1.34219e-03,
 1.67322e-03, 2.08589e-03, 2.60035e-03, 3.24169e-03, 4.04120e-03,
 5.03791e-03, 6.28044e-03, 7.82942e-03, 9.76043e-03, 1.21677e-02,
 1.51687e-02, 1.89098e-02, 2.35737e-02, 2.93878e-02, 3.66359e-02,
 4.56716e-02, 5.69358e-02, 7.09782e-02, 8.84840e-02, 1.10307e-01,
 1.37513e-01, 1.71429e-01, 2.13709e-01, 2.66417e-01, 3.32125e-01,
 4.14039e-01, 5.16156e-01, 6.43459e-01, 8.02159e-01, 1.00000e+00}
,
{2.64717e-10, 3.30767e-10, 4.13296e-10, 5.16418e-10, 6.45269e-10,
 8.06270e-10, 1.00744e-09, 1.25881e-09, 1.57289e-09, 1.96534e-09,
 2.45572e-09, 3.06844e-09, 3.83405e-09, 4.79068e-09, 5.98600e-09,
 7.47956e-09, 9.34578e-09, 1.16776e-08, 1.45913e-08, 1.82320e-08,
 2.27811e-08, 2.84652e-08, 3.55675e-08, 4.44419e-08, 5.55306e-08,
 6.93860e-08, 8.66985e-08, 1.08331e-07, 1.35360e-07, 1.69134e-07,
 2.11334e-07, 2.64064e-07, 3.29951e-07, 4.12276e-07, 5.15143e-07,
 6.43676e-07, 8.04280e-07, 1.00496e-06, 1.25570e-06, 1.56901e-06,
 1.96049e-06, 2.44966e-06, 3.06087e-06, 3.82458e-06, 4.77885e-06,
 5.97122e-06, 7.46110e-06, 9.32271e-06, 1.16488e-05, 1.45553e-05,
 1.81870e-05, 2.27248e-05, 2.83949e-05, 3.54797e-05, 4.43322e-05,
 5.53935e-05, 6.92147e-05, 8.64845e-05, 1.08063e-04, 1.35026e-04,
 1.68716e-04, 2.10812e-04, 2.63412e-04, 3.29136e-04, 4.11259e-04,
 5.13872e-04, 6.42087e-04, 8.02294e-04, 1.00247e-03, 1.25260e-03,
 1.56514e-03, 1.95565e-03, 2.44361e-03, 3.05331e-03, 3.81514e-03,
 4.76706e-03, 5.95648e-03, 7.44268e-03, 9.29970e-03, 1.16201e-02,
 1.45194e-02, 1.81421e-02, 2.26687e-02, 2.83248e-02, 3.53921e-02,
 4.42228e-02, 5.52568e-02, 6.90439e-02, 8.62710e-02, 1.07796e-01,
 1.34693e-01, 1.68300e-01, 2.10292e-01, 2.62762e-01, 3.28324e-01,
 4.10244e-01, 5.12603e-01, 6.40503e-01, 8.00314e-01, 1.00000e+00}
,
{2.10757e-10, 2.63950e-10, 3.30569e-10, 4.14001e-10, 5.18491e-10,
 6.49352e-10, 8.13242e-10, 1.01850e-09, 1.27555e-09, 1.59749e-09,
 2.00068e-09, 2.50564e-09, 3.13803e-09, 3.93004e-09, 4.92194e-09,
 6.16419e-09, 7.71997e-09, 9.66841e-09, 1.21086e-08, 1.51647e-08,
 1.89921e-08, 2.37856e-08, 2.97888e-08, 3.73072e-08, 4.67232e-08,
 5.85156e-08, 7.32844e-08, 9.17806e-08, 1.14945e-07, 1.43956e-07,
 1.80289e-07, 2.25792e-07, 2.82780e-07, 3.54151e-07, 4.43535e-07,
 5.55479e-07, 6.95676e-07, 8.71258e-07, 1.09115e-06, 1.36655e-06,
 1.71145e-06, 2.14341e-06, 2.68438e-06, 3.36189e-06, 4.21040e-06,
 5.27307e-06, 6.60394e-06, 8.27070e-06, 1.03581e-05, 1.29724e-05,
 1.62465e-05, 2.03470e-05, 2.54824e-05, 3.19139e-05, 3.99686e-05,
 5.00563e-05, 6.26900e-05, 7.85124e-05, 9.83281e-05, 1.23145e-04,
 1.54226e-04, 1.93151e-04, 2.41900e-04, 3.02953e-04, 3.79415e-04,
 4.75176e-04, 5.95106e-04, 7.45305e-04, 9.33412e-04, 1.16900e-03,
 1.46404e-03, 1.83355e-03, 2.29632e-03, 2.87588e-03, 3.60173e-03,
 4.51077e-03, 5.64924e-03, 7.07505e-03, 8.86072e-03, 1.10971e-02,
 1.38979e-02, 1.74055e-02, 2.17985e-02, 2.73003e-02, 3.41906e-02,
 4.28199e-02, 5.36273e-02, 6.71622e-02, 8.41133e-02, 1.05343e-01,
 1.31930e-01, 1.65228e-01, 2.06930e-01, 2.59157e-01, 3.24565e-01,
 4.06482e-01, 5.09074e-01, 6.37560e-01, 7.98473e-01, 1.00000e+00}
,
{1.67796e-10, 2.10631e-10, 2.64400e-10, 3.31895e-10, 4.16621e-10,
 5.22974e-10, 6.56478e-10, 8.24061e-10, 1.03443e-09, 1.29849e-09,
 1.62997e-09, 2.04606e-09, 2.56837e-09, 3.22401e-09, 4.04703e-09,
 5.08015e-09, 6.37699e-09, 8.00489e-09, 1.00484e-08, 1.26135e-08,
 1.58334e-08, 1.98753e-08, 2.49490e-08, 3.13179e-08, 3.93126e-08,
 4.93483e-08, 6.19457e-08, 7.77591e-08, 9.76092e-08, 1.22527e-07,
 1.53805e-07, 1.93068e-07, 2.42353e-07, 3.04220e-07, 3.81881e-07,
 4.79366e-07, 6.01738e-07, 7.55347e-07, 9.48170e-07, 1.19022e-06,
 1.49405e-06, 1.87545e-06, 2.35421e-06, 2.95518e-06, 3.70957e-06,
 4.65654e-06, 5.84525e-06, 7.33740e-06, 9.21047e-06, 1.15617e-05,
 1.45131e-05, 1.82180e-05, 2.28686e-05, 2.87065e-05, 3.60346e-05,
 4.52334e-05, 5.67804e-05, 7.12751e-05, 8.94700e-05, 1.12310e-04,
 1.40980e-04, 1.76969e-04, 2.22145e-04, 2.78853e-04, 3.50038e-04,
 4.39395e-04, 5.51562e-04, 6.92363e-04, 8.69107e-04, 1.09097e-03,
 1.36947e-03, 1.71906e-03, 2.15790e-03, 2.70876e-03, 3.40025e-03,
 4.26825e-03, 5.35784e-03, 6.72558e-03, 8.44246e-03, 1.05976e-02,
 1.33030e-02, 1.66989e-02, 2.09617e-02, 2.63128e-02, 3.30298e-02,
 4.14616e-02, 5.20458e-02, 6.53319e-02, 8.20096e-02, 1.02945e-01,
 1.29224e-01, 1.62212e-01, 2.03621e-01, 2.55601e-01, 3.20850e-01,
 4.02756e-01, 5.05570e-01, 6.34630e-01, 7.96637e-01, 1.00000e+00}
,
{1.33593e-10, 1.68082e-10, 2.11476e-10, 2.66073e-10, 3.34766e-10,
 4.21192e-10, 5.29932e-10, 6.66745e-10, 8.38879e-10, 1.05545e-09,
 1.32794e-09, 1.67077e-09, 2.10212e-09, 2.64483e-09, 3.32764e-09,
 4.18674e-09, 5.26764e-09, 6.62758e-09, 8.33863e-09, 1.04914e-08,
 1.32000e-08, 1.66079e-08, 2.08955e-08, 2.62901e-08, 3.30775e-08,
 4.16171e-08, 5.23614e-08, 6.58796e-08, 8.28878e-08, 1.04287e-07,
 1.31211e-07, 1.65086e-07, 2.07706e-07, 2.61329e-07, 3.28797e-07,
 4.13683e-07, 5.20484e-07, 6.54857e-07, 8.23922e-07, 1.03663e-06,
 1.30426e-06, 1.64099e-06, 2.06464e-06, 2.59767e-06, 3.26831e-06,
 4.11210e-06, 5.17372e-06, 6.50942e-06, 8.18996e-06, 1.03044e-05,
 1.29647e-05, 1.63118e-05, 2.05230e-05, 2.58214e-05, 3.24877e-05,
 4.08751e-05, 5.14279e-05, 6.47050e-05, 8.14100e-05, 1.02428e-04,
 1.28871e-04, 1.62142e-04, 2.04003e-04, 2.56670e-04, 3.22935e-04,
 4.06307e-04, 5.11204e-04, 6.43182e-04, 8.09233e-04, 1.01815e-03,
 1.28101e-03, 1.61173e-03, 2.02783e-03, 2.55136e-03, 3.21004e-03,
 4.03878e-03, 5.08148e-03, 6.39336e-03, 8.04394e-03, 1.01207e-02,
 1.27335e-02, 1.60209e-02, 2.01571e-02, 2.53610e-02, 3.19085e-02,
 4.01463e-02, 5.05110e-02, 6.35514e-02, 7.99585e-02, 1.00601e-01,
 1.26574e-01, 1.59251e-01, 2.00366e-01, 2.52094e-01, 3.17177e-01,
 3.99063e-01, 5.02090e-01, 6.31715e-01, 7.94805e-01, 1.00000e+00}
,
{1.06361e-10, 1.34129e-10, 1.69146e-10, 2.13305e-10, 2.68993e-10,
 3.39219e-10, 4.27780e-10, 5.39460e-10, 6.80298e-10, 8.57904e-10,
 1.08188e-09, 1.36433e-09, 1.72051e-09, 2.16969e-09, 2.73613e-09,
 3.45045e-09, 4.35127e-09, 5.48726e-09, 6.91982e-09, 8.72639e-09,
 1.10046e-08, 1.38776e-08, 1.75006e-08, 2.20695e-08, 2.78312e-08,
 3.50971e-08, 4.42600e-08, 5.58150e-08, 7.03867e-08, 8.87626e-08,
 1.11936e-07, 1.41159e-07, 1.78012e-07, 2.24486e-07, 2.83092e-07,
 3.56999e-07, 4.50202e-07, 5.67736e-07, 7.15956e-07, 9.02871e-07,
 1.13858e-06, 1.43584e-06, 1.81069e-06, 2.28341e-06, 2.87954e-06,
 3.63131e-06, 4.57934e-06, 5.77487e-06, 7.28252e-06, 9.18378e-06,
 1.15814e-05, 1.46050e-05, 1.84179e-05, 2.32263e-05, 2.92900e-05,
 3.69368e-05, 4.65799e-05, 5.87406e-05, 7.40760e-05, 9.34151e-05,
 1.17803e-04, 1.48558e-04, 1.87342e-04, 2.36252e-04, 2.97931e-04,
 3.75712e-04, 4.73799e-04, 5.97494e-04, 7.53483e-04, 9.50195e-04,
 1.19826e-03, 1.51110e-03, 1.90560e-03, 2.40310e-03, 3.03048e-03,
 3.82164e-03, 4.81937e-03, 6.07756e-03, 7.66424e-03, 9.66515e-03,
 1.21884e-02, 1.53705e-02, 1.93833e-02, 2.44437e-02, 3.08252e-02,
 3.88728e-02, 4.90214e-02, 6.18195e-02, 7.79587e-02, 9.83115e-02,
 1.23978e-01, 1.56345e-01, 1.97162e-01, 2.48635e-01, 3.13547e-01,
 3.95405e-01, 4.98633e-01, 6.28812e-01, 7.92977e-01, 1.00000e+00}
,
{8.46803e-11, 1.07034e-10, 1.35289e-10, 1.71002e-10, 2.16143e-10,
 2.73200e-10, 3.45319e-10, 4.36475e-10, 5.51695e-10, 6.97331e-10,
 8.81411e-10, 1.11408e-09, 1.40818e-09, 1.77991e-09, 2.24976e-09,
 2.84365e-09, 3.59431e-09, 4.54313e-09, 5.74242e-09, 7.25829e-09,
 9.17432e-09, 1.15961e-08, 1.46573e-08, 1.85265e-08, 2.34171e-08,
 2.95986e-08, 3.74120e-08, 4.72880e-08, 5.97710e-08, 7.55492e-08,
 9.54926e-08, 1.20701e-07, 1.52563e-07, 1.92836e-07, 2.43741e-07,
 3.08083e-07, 3.89410e-07, 4.92206e-07, 6.22137e-07, 7.86368e-07,
 9.93952e-07, 1.25633e-06, 1.58798e-06, 2.00717e-06, 2.53702e-06,
 3.20674e-06, 4.05324e-06, 5.12321e-06, 6.47563e-06, 8.18505e-06,
 1.03457e-05, 1.30768e-05, 1.65288e-05, 2.08920e-05, 2.64070e-05,
 3.33779e-05, 4.21889e-05, 5.33259e-05, 6.74028e-05, 8.51956e-05,
 1.07685e-04, 1.36112e-04, 1.72043e-04, 2.17458e-04, 2.74862e-04,
 3.47420e-04, 4.39131e-04, 5.55052e-04, 7.01574e-04, 8.86774e-04,
 1.12086e-03, 1.41675e-03, 1.79074e-03, 2.26345e-03, 2.86095e-03,
 3.61618e-03, 4.57078e-03, 5.77736e-03, 7.30246e-03, 9.23015e-03,
 1.16667e-02, 1.47465e-02, 1.86392e-02, 2.35595e-02, 2.97787e-02,
 3.76397e-02, 4.75757e-02, 6.01347e-02, 7.60089e-02, 9.60737e-02,
 1.21435e-01, 1.53491e-01, 1.94010e-01, 2.45224e-01, 3.09958e-01,
 3.91780e-01, 4.95201e-01, 6.25923e-01, 7.91153e-01, 1.00000e+00}
,
{6.74190e-11, 8.54126e-11, 1.08209e-10, 1.37089e-10, 1.73676e-10,
 2.20029e-10, 2.78753e-10, 3.53150e-10, 4.47403e-10, 5.66812e-10,
 7.18089e-10, 9.09741e-10, 1.15254e-09, 1.46015e-09, 1.84985e-09,
 2.34356e-09, 2.96904e-09, 3.76145e-09, 4.76535e-09, 6.03718e-09,
 7.64846e-09, 9.68977e-09, 1.22759e-08, 1.55522e-08, 1.97030e-08,
 2.49616e-08, 3.16236e-08, 4.00637e-08, 5.07564e-08, 6.43028e-08,
 8.14647e-08, 1.03207e-07, 1.30752e-07, 1.65649e-07, 2.09859e-07,
 2.65869e-07, 3.36827e-07, 4.26724e-07, 5.40613e-07, 6.84898e-07,
 8.67692e-07, 1.09927e-06, 1.39266e-06, 1.76435e-06, 2.23524e-06,
 2.83180e-06, 3.58759e-06, 4.54509e-06, 5.75814e-06, 7.29494e-06,
 9.24190e-06, 1.17085e-05, 1.48334e-05, 1.87923e-05, 2.38078e-05,
 3.01619e-05, 3.82119e-05, 4.84103e-05, 6.13307e-05, 7.76993e-05,
 9.84366e-05, 1.24709e-04, 1.57992e-04, 2.00159e-04, 2.53580e-04,
 3.21258e-04, 4.07000e-04, 5.15625e-04, 6.53241e-04, 8.27586e-04,
 1.04846e-03, 1.32829e-03, 1.68280e-03, 2.13192e-03, 2.70091e-03,
 3.42177e-03, 4.33501e-03, 5.49199e-03, 6.95775e-03, 8.81472e-03,
 1.11673e-02, 1.41478e-02, 1.79237e-02, 2.27074e-02, 2.87678e-02,
 3.64457e-02, 4.61727e-02, 5.84959e-02, 7.41079e-02, 9.38867e-02,
 1.18944e-01, 1.50690e-01, 1.90908e-01, 2.41859e-01, 3.06409e-01,
 3.88188e-01, 4.91792e-01, 6.23047e-01, 7.89333e-01, 1.00000e+00}
,
{5.36763e-11, 6.81588e-11, 8.65489e-11, 1.09901e-10, 1.39554e-10,
 1.77207e-10, 2.25019e-10, 2.85732e-10, 3.62827e-10, 4.60722e-10,
 5.85030e-10, 7.42879e-10, 9.43316e-10, 1.19783e-09, 1.52103e-09,
 1.93142e-09, 2.45254e-09, 3.11426e-09, 3.95453e-09, 5.02151e-09,
 6.37638e-09, 8.09680e-09, 1.02814e-08, 1.30555e-08, 1.65780e-08,
 2.10510e-08, 2.67308e-08, 3.39431e-08, 4.31013e-08, 5.47306e-08,
 6.94976e-08, 8.82489e-08, 1.12060e-07, 1.42295e-07, 1.80687e-07,
 2.29439e-07, 2.91345e-07, 3.69953e-07, 4.69771e-07, 5.96521e-07,
 7.57470e-07, 9.61845e-07, 1.22136e-06, 1.55090e-06, 1.96935e-06,
 2.50071e-06, 3.17543e-06, 4.03220e-06, 5.12014e-06, 6.50162e-06,
 8.25584e-06, 1.04834e-05, 1.33119e-05, 1.69036e-05, 2.14644e-05,
 2.72558e-05, 3.46098e-05, 4.39479e-05, 5.58056e-05, 7.08626e-05,
 8.99822e-05, 1.14261e-04, 1.45089e-04, 1.84236e-04, 2.33946e-04,
 2.97067e-04, 3.77220e-04, 4.78998e-04, 6.08238e-04, 7.72348e-04,
 9.80737e-04, 1.24535e-03, 1.58136e-03, 2.00803e-03, 2.54983e-03,
 3.23780e-03, 4.11140e-03, 5.22071e-03, 6.62932e-03, 8.41799e-03,
 1.06893e-02, 1.35734e-02, 1.72356e-02, 2.18860e-02, 2.77911e-02,
 3.52895e-02, 4.48111e-02, 5.69017e-02, 7.22545e-02, 9.17496e-02,
 1.16505e-01, 1.47939e-01, 1.87855e-01, 2.38541e-01, 3.02902e-01,
 3.84629e-01, 4.88406e-01, 6.20184e-01, 7.87518e-01, 1.00000e+00}
,
{4.27349e-11, 5.43904e-11, 6.92248e-11, 8.81051e-11, 1.12135e-10,
 1.42719e-10, 1.81644e-10, 2.31185e-10, 2.94238e-10, 3.74489e-10,
 4.76627e-10, 6.06622e-10, 7.72071e-10, 9.82646e-10, 1.25065e-09,
 1.59175e-09, 2.02589e-09, 2.57843e-09, 3.28167e-09, 4.17671e-09,
 5.31587e-09, 6.76571e-09, 8.61099e-09, 1.09595e-08, 1.39487e-08,
 1.77530e-08, 2.25950e-08, 2.87575e-08, 3.66008e-08, 4.65833e-08,
 5.92884e-08, 7.54587e-08, 9.60393e-08, 1.22233e-07, 1.55571e-07,
 1.98001e-07, 2.52004e-07, 3.20735e-07, 4.08212e-07, 5.19548e-07,
 6.61250e-07, 8.41598e-07, 1.07114e-06, 1.36328e-06, 1.73510e-06,
 2.20833e-06, 2.81062e-06, 3.57719e-06, 4.55284e-06, 5.79457e-06,
 7.37498e-06, 9.38643e-06, 1.19465e-05, 1.52048e-05, 1.93517e-05,
 2.46297e-05, 3.13472e-05, 3.98968e-05, 5.07782e-05, 6.46275e-05,
 8.22540e-05, 1.04688e-04, 1.33240e-04, 1.69580e-04, 2.15832e-04,
 2.74697e-04, 3.49618e-04, 4.44973e-04, 5.66335e-04, 7.20797e-04,
 9.17387e-04, 1.16759e-03, 1.48604e-03, 1.89135e-03, 2.40719e-03,
 3.06373e-03, 3.89933e-03, 4.96283e-03, 6.31639e-03, 8.03912e-03,
 1.02317e-02, 1.30223e-02, 1.65740e-02, 2.10944e-02, 2.68477e-02,
 3.41701e-02, 4.34896e-02, 5.53510e-02, 7.04474e-02, 8.96611e-02,
 1.14115e-01, 1.45239e-01, 1.84852e-01, 2.35268e-01, 2.99435e-01,
 3.81102e-01, 4.85044e-01, 6.17335e-01, 7.85707e-01, 1.00000e+00}
,
{3.40238e-11, 4.34032e-11, 5.53684e-11, 7.06320e-11, 9.01033e-11,
 1.14942e-10, 1.46629e-10, 1.87051e-10, 2.38616e-10, 3.04396e-10,
 3.88310e-10, 4.95356e-10, 6.31913e-10, 8.06115e-10, 1.02834e-09,
 1.31183e-09, 1.67346e-09, 2.13479e-09, 2.72330e-09, 3.47404e-09,
 4.43174e-09, 5.65345e-09, 7.21196e-09, 9.20010e-09, 1.17363e-08,
 1.49717e-08, 1.90990e-08, 2.43641e-08, 3.10807e-08, 3.96488e-08,
 5.05789e-08, 6.45222e-08, 8.23093e-08, 1.05000e-07, 1.33945e-07,
 1.70871e-07, 2.17975e-07, 2.78065e-07, 3.54720e-07, 4.52508e-07,
 5.77252e-07, 7.36385e-07, 9.39387e-07, 1.19835e-06, 1.52870e-06,
 1.95013e-06, 2.48773e-06, 3.17353e-06, 4.04839e-06, 5.16442e-06,
 6.58811e-06, 8.40428e-06, 1.07211e-05, 1.36767e-05, 1.74469e-05,
 2.22566e-05, 2.83922e-05, 3.62191e-05, 4.62038e-05, 5.89410e-05,
 7.51894e-05, 9.59172e-05, 1.22359e-04, 1.56090e-04, 1.99120e-04,
 2.54012e-04, 3.24037e-04, 4.13365e-04, 5.27319e-04, 6.72687e-04,
 8.58129e-04, 1.09469e-03, 1.39647e-03, 1.78144e-03, 2.27254e-03,
 2.89901e-03, 3.69820e-03, 4.71769e-03, 6.01823e-03, 7.67730e-03,
 9.79373e-03, 1.24936e-02, 1.59378e-02, 2.03314e-02, 2.59362e-02,
 3.30861e-02, 4.22071e-02, 5.38425e-02, 6.86854e-02, 8.76202e-02,
 1.11775e-01, 1.42588e-01, 1.81896e-01, 2.32040e-01, 2.96007e-01,
 3.77608e-01, 4.81705e-01, 6.14499e-01, 7.83900e-01, 1.00000e+00}
,
{2.70884e-11, 3.46356e-11, 4.42855e-11, 5.66241e-11, 7.24004e-11,
 9.25722e-11, 1.18364e-10, 1.51342e-10, 1.93508e-10, 2.47422e-10,
 3.16358e-10, 4.04499e-10, 5.17199e-10, 6.61298e-10, 8.45545e-10,
 1.08113e-09, 1.38234e-09, 1.76748e-09, 2.25993e-09, 2.88958e-09,
 3.69466e-09, 4.72404e-09, 6.04023e-09, 7.72312e-09, 9.87489e-09,
 1.26262e-08, 1.61440e-08, 2.06420e-08, 2.63931e-08, 3.37466e-08,
 4.31489e-08, 5.51708e-08, 7.05422e-08, 9.01962e-08, 1.15326e-07,
 1.47458e-07, 1.88542e-07, 2.41072e-07, 3.08238e-07, 3.94118e-07,
 5.03924e-07, 6.44325e-07, 8.23843e-07, 1.05338e-06, 1.34686e-06,
 1.72212e-06, 2.20193e-06, 2.81541e-06, 3.59983e-06, 4.60279e-06,
 5.88520e-06, 7.52490e-06, 9.62144e-06, 1.23021e-05, 1.57297e-05,
 2.01122e-05, 2.57157e-05, 3.28805e-05, 4.20414e-05, 5.37548e-05,
 6.87317e-05, 8.78813e-05, 1.12366e-04, 1.43673e-04, 1.83702e-04,
 2.34885e-04, 3.00327e-04, 3.84002e-04, 4.90991e-04, 6.27788e-04,
 8.02699e-04, 1.02634e-03, 1.31230e-03, 1.67792e-03, 2.14541e-03,
 2.74315e-03, 3.50744e-03, 4.48466e-03, 5.73415e-03, 7.33177e-03,
 9.37450e-03, 1.19864e-02, 1.53259e-02, 1.95960e-02, 2.50557e-02,
 3.20366e-02, 4.09624e-02, 5.23751e-02, 6.69676e-02, 8.56257e-02,
 1.09482e-01, 1.39986e-01, 1.78988e-01, 2.28856e-01, 2.92619e-01,
 3.74147e-01, 4.78389e-01, 6.11675e-01, 7.82097e-01, 1.00000e+00}
,
{2.15666e-11, 2.76390e-11, 3.54211e-11, 4.53943e-11, 5.81756e-11,
 7.45556e-11, 9.55476e-11, 1.22450e-10, 1.56928e-10, 2.01112e-10,
 2.57738e-10, 3.30307e-10, 4.23309e-10, 5.42497e-10, 6.95243e-10,
 8.90997e-10, 1.14187e-09, 1.46337e-09, 1.87540e-09, 2.40345e-09,
 3.08016e-09, 3.94742e-09, 5.05887e-09, 6.48325e-09, 8.30868e-09,
 1.06481e-08, 1.36462e-08, 1.74884e-08, 2.24125e-08, 2.87230e-08,
 3.68103e-08, 4.71747e-08, 6.04573e-08, 7.74798e-08, 9.92951e-08,
 1.27253e-07, 1.63082e-07, 2.09000e-07, 2.67847e-07, 3.43262e-07,
 4.39912e-07, 5.63774e-07, 7.22511e-07, 9.25943e-07, 1.18665e-06,
 1.52077e-06, 1.94896e-06, 2.49771e-06, 3.20097e-06, 4.10224e-06,
 5.25728e-06, 6.73753e-06, 8.63456e-06, 1.10657e-05, 1.41814e-05,
 1.81744e-05, 2.32916e-05, 2.98496e-05, 3.82541e-05, 4.90250e-05,
 6.28285e-05, 8.05186e-05, 1.03190e-04, 1.32244e-04, 1.69479e-04,
 2.17197e-04, 2.78352e-04, 3.56725e-04, 4.57165e-04, 5.85886e-04,
 7.50849e-04, 9.62259e-04, 1.23319e-03, 1.58042e-03, 2.02540e-03,
 2.59568e-03, 3.32652e-03, 4.26314e-03, 5.46348e-03, 7.00178e-03,
 8.97322e-03, 1.14997e-02, 1.47376e-02, 1.88872e-02, 2.42051e-02,
 3.10203e-02, 3.97544e-02, 5.09478e-02, 6.52927e-02, 8.36767e-02,
 1.07237e-01, 1.37431e-01, 1.76126e-01, 2.25716e-01, 2.89269e-01,
 3.70716e-01, 4.75096e-01, 6.08865e-01, 7.80298e-01, 1.00000e+00}
,
{1.71705e-11, 2.20558e-11, 2.83310e-11, 3.63916e-11, 4.67456e-11,
 6.00455e-11, 7.71294e-11, 9.90740e-11, 1.27262e-10, 1.63470e-10,
 2.09980e-10, 2.69723e-10, 3.46463e-10, 4.45038e-10, 5.71658e-10,
 7.34304e-10, 9.43226e-10, 1.21159e-09, 1.55631e-09, 1.99910e-09,
 2.56788e-09, 3.29848e-09, 4.23695e-09, 5.44243e-09, 6.99089e-09,
 8.97991e-09, 1.15348e-08, 1.48167e-08, 1.90323e-08, 2.44473e-08,
 3.14029e-08, 4.03375e-08, 5.18142e-08, 6.65562e-08, 8.54925e-08,
 1.09816e-07, 1.41061e-07, 1.81195e-07, 2.32748e-07, 2.98969e-07,
 3.84030e-07, 4.93293e-07, 6.33643e-07, 8.13924e-07, 1.04550e-06,
 1.34296e-06, 1.72505e-06, 2.21586e-06, 2.84631e-06, 3.65613e-06,
 4.69636e-06, 6.03255e-06, 7.74890e-06, 9.95359e-06, 1.27855e-05,
 1.64232e-05, 2.10959e-05, 2.70981e-05, 3.48079e-05, 4.47113e-05,
 5.74324e-05, 7.37728e-05, 9.47624e-05, 1.21724e-04, 1.56356e-04,
 2.00842e-04, 2.57985e-04, 3.31386e-04, 4.25670e-04, 5.46780e-04,
 7.02348e-04, 9.02178e-04, 1.15886e-03, 1.48858e-03, 1.91210e-03,
 2.45612e-03, 3.15493e-03, 4.05256e-03, 5.20558e-03, 6.68665e-03,
 8.58911e-03, 1.10329e-02, 1.41719e-02, 1.82040e-02, 2.33833e-02,
 3.00363e-02, 3.85821e-02, 4.95593e-02, 6.36597e-02, 8.17719e-02,
 1.05037e-01, 1.34922e-01, 1.73310e-01, 2.22619e-01, 2.85958e-01,
 3.67318e-01, 4.71825e-01, 6.06067e-01, 7.78503e-01, 1.00000e+00}
,
{1.36704e-11, 1.76004e-11, 2.26601e-11, 2.91744e-11, 3.75613e-11,
 4.83593e-11, 6.22616e-11, 8.01603e-11, 1.03205e-10, 1.32874e-10,
 1.71072e-10, 2.20251e-10, 2.83568e-10, 3.65088e-10, 4.70042e-10,
 6.05168e-10, 7.79140e-10, 1.00313e-09, 1.29150e-09, 1.66278e-09,
 2.14079e-09, 2.75622e-09, 3.54857e-09, 4.56870e-09, 5.88210e-09,
 7.57307e-09, 9.75015e-09, 1.25531e-08, 1.61618e-08, 2.08080e-08,
 2.67898e-08, 3.44913e-08, 4.44067e-08, 5.71727e-08, 7.36085e-08,
 9.47693e-08, 1.22013e-07, 1.57089e-07, 2.02249e-07, 2.60391e-07,
 3.35247e-07, 4.31623e-07, 5.55705e-07, 7.15458e-07, 9.21136e-07,
 1.18594e-06, 1.52687e-06, 1.96581e-06, 2.53094e-06, 3.25853e-06,
 4.19528e-06, 5.40133e-06, 6.95409e-06, 8.95323e-06, 1.15271e-05,
 1.48409e-05, 1.91073e-05, 2.46002e-05, 3.16722e-05, 4.07772e-05,
 5.24997e-05, 6.75922e-05, 8.70234e-05, 1.12041e-04, 1.44250e-04,
 1.85718e-04, 2.39108e-04, 3.07846e-04, 3.96345e-04, 5.10285e-04,
 6.56980e-04, 8.45847e-04, 1.08901e-03, 1.40207e-03, 1.80514e-03,
 2.32408e-03, 2.99220e-03, 3.85238e-03, 4.95986e-03, 6.38570e-03,
 8.22145e-03, 1.05849e-02, 1.36278e-02, 1.75455e-02, 2.25895e-02,
 2.90835e-02, 3.74443e-02, 4.82087e-02, 6.20676e-02, 7.99106e-02,
 1.02883e-01, 1.32460e-01, 1.70539e-01, 2.19565e-01, 2.82685e-01,
 3.63950e-01, 4.68577e-01, 6.03283e-01, 7.76713e-01, 1.00000e+00}
,
{1.08839e-11, 1.40450e-11, 1.81243e-11, 2.33884e-11, 3.01815e-11,
 3.89476e-11, 5.02597e-11, 6.48574e-11, 8.36949e-11, 1.08004e-10,
 1.39373e-10, 1.79853e-10, 2.32091e-10, 2.99500e-10, 3.86488e-10,
 4.98742e-10, 6.43600e-10, 8.30530e-10, 1.07175e-09, 1.38304e-09,
 1.78474e-09, 2.30310e-09, 2.97203e-09, 3.83524e-09, 4.94917e-09,
 6.38663e-09, 8.24160e-09, 1.06353e-08, 1.37243e-08, 1.77105e-08,
 2.28544e-08, 2.94923e-08, 3.80583e-08, 4.91121e-08, 6.33765e-08,
 8.17838e-08, 1.05538e-07, 1.36190e-07, 1.75746e-07, 2.26791e-07,
 2.92661e-07, 3.77663e-07, 4.87354e-07, 6.28904e-07, 8.11566e-07,
 1.04728e-06, 1.35146e-06, 1.74398e-06, 2.25052e-06, 2.90417e-06,
 3.74767e-06, 4.83616e-06, 6.24080e-06, 8.05341e-06, 1.03925e-05,
 1.34109e-05, 1.73061e-05, 2.23325e-05, 2.88189e-05, 3.71892e-05,
 4.79907e-05, 6.19293e-05, 7.99164e-05, 1.03128e-04, 1.33081e-04,
 1.71733e-04, 2.21612e-04, 2.85979e-04, 3.69040e-04, 4.76226e-04,
 6.14543e-04, 7.93034e-04, 1.02337e-03, 1.32060e-03, 1.70416e-03,
 2.19913e-03, 2.83785e-03, 3.66209e-03, 4.72573e-03, 6.09830e-03,
 7.86952e-03, 1.01552e-02, 1.31047e-02, 1.69109e-02, 2.18226e-02,
 2.81609e-02, 3.63401e-02, 4.68949e-02, 6.05152e-02, 7.80916e-02,
 1.00773e-01, 1.30042e-01, 1.67812e-01, 2.16552e-01, 2.79449e-01,
 3.60613e-01, 4.65352e-01, 6.00511e-01, 7.74926e-01, 1.00000e+00}
,
{8.66528e-12, 1.12078e-11, 1.44965e-11, 1.87500e-11, 2.42516e-11,
 3.13675e-11, 4.05714e-11, 5.24759e-11, 6.78733e-11, 8.77887e-11,
 1.13548e-10, 1.46865e-10, 1.89958e-10, 2.45695e-10, 3.17787e-10,
 4.11032e-10, 5.31638e-10, 6.87631e-10, 8.89395e-10, 1.15036e-09,
 1.48790e-09, 1.92448e-09, 2.48916e-09, 3.21953e-09, 4.16421e-09,
 5.38607e-09, 6.96645e-09, 9.01054e-09, 1.16544e-08, 1.50741e-08,
 1.94971e-08, 2.52179e-08, 3.26174e-08, 4.21879e-08, 5.45667e-08,
 7.05777e-08, 9.12866e-08, 1.18072e-07, 1.52717e-07, 1.97527e-07,
 2.55485e-07, 3.30449e-07, 4.27410e-07, 5.52820e-07, 7.15029e-07,
 9.24833e-07, 1.19620e-06, 1.54719e-06, 2.00116e-06, 2.58834e-06,
 3.34781e-06, 4.33013e-06, 5.60067e-06, 7.24402e-06, 9.36956e-06,
 1.21188e-05, 1.56747e-05, 2.02739e-05, 2.62227e-05, 3.39170e-05,
 4.38689e-05, 5.67409e-05, 7.33898e-05, 9.49239e-05, 1.22776e-04,
 1.58802e-04, 2.05397e-04, 2.65665e-04, 3.43616e-04, 4.44440e-04,
 5.74847e-04, 7.43519e-04, 9.61682e-04, 1.24386e-03, 1.60883e-03,
 2.08090e-03, 2.69147e-03, 3.48120e-03, 4.50266e-03, 5.82383e-03,
 7.53266e-03, 9.74289e-03, 1.26016e-02, 1.62992e-02, 2.10817e-02,
 2.72675e-02, 3.52684e-02, 4.56168e-02, 5.90017e-02, 7.63140e-02,
 9.87061e-02, 1.27668e-01, 1.65129e-01, 2.13581e-01, 2.76250e-01,
 3.57307e-01, 4.62148e-01, 5.97752e-01, 7.73144e-01, 1.00000e+00}
,
{6.89894e-12, 8.94380e-12, 1.15948e-11, 1.50315e-11, 1.94868e-11,
 2.52627e-11, 3.27507e-11, 4.24580e-11, 5.50426e-11, 7.13573e-11,
 9.25078e-11, 1.19927e-10, 1.55474e-10, 2.01557e-10, 2.61298e-10,
 3.38748e-10, 4.39153e-10, 5.69318e-10, 7.38065e-10, 9.56829e-10,
 1.24043e-09, 1.60810e-09, 2.08475e-09, 2.70267e-09, 3.50374e-09,
 4.54226e-09, 5.88859e-09, 7.63398e-09, 9.89670e-09, 1.28301e-08,
 1.66330e-08, 2.15630e-08, 2.79543e-08, 3.62400e-08, 4.69816e-08,
 6.09070e-08, 7.89600e-08, 1.02364e-07, 1.32705e-07, 1.72039e-07,
 2.23031e-07, 2.89138e-07, 3.74839e-07, 4.85942e-07, 6.29975e-07,
 8.16701e-07, 1.05877e-06, 1.37259e-06, 1.77943e-06, 2.30686e-06,
 2.99062e-06, 3.87704e-06, 5.02621e-06, 6.51598e-06, 8.44733e-06,
 1.09511e-05, 1.41971e-05, 1.84051e-05, 2.38604e-05, 3.09327e-05,
 4.01011e-05, 5.19872e-05, 6.73963e-05, 8.73726e-05, 1.13270e-04,
 1.46843e-04, 1.90368e-04, 2.46794e-04, 3.19944e-04, 4.14775e-04,
 5.37715e-04, 6.97095e-04, 9.03715e-04, 1.17158e-03, 1.51884e-03,
 1.96902e-03, 2.55264e-03, 3.30925e-03, 4.29012e-03, 5.56171e-03,
 7.21021e-03, 9.34733e-03, 1.21179e-02, 1.57097e-02, 2.03660e-02,
 2.64026e-02, 3.42283e-02, 4.43737e-02, 5.75261e-02, 7.45769e-02,
 9.66816e-02, 1.25338e-01, 1.62489e-01, 2.10651e-01, 2.73088e-01,
 3.54031e-01, 4.58967e-01, 5.95005e-01, 7.71366e-01, 1.00000e+00}
,
{5.49266e-12, 7.13711e-12, 9.27389e-12, 1.20504e-11, 1.56582e-11,
 2.03461e-11, 2.64375e-11, 3.43526e-11, 4.46374e-11, 5.80014e-11,
 7.53665e-11, 9.79305e-11, 1.27250e-10, 1.65347e-10, 2.14851e-10,
 2.79175e-10, 3.62757e-10, 4.71363e-10, 6.12484e-10, 7.95856e-10,
 1.03413e-09, 1.34373e-09, 1.74604e-09, 2.26878e-09, 2.94803e-09,
 3.83064e-09, 4.97750e-09, 6.46772e-09, 8.40409e-09, 1.09202e-08,
 1.41896e-08, 1.84378e-08, 2.39579e-08, 3.11307e-08, 4.04509e-08,
 5.25615e-08, 6.82979e-08, 8.87456e-08, 1.15315e-07, 1.49839e-07,
 1.94700e-07, 2.52991e-07, 3.28734e-07, 4.27154e-07, 5.55039e-07,
 7.21212e-07, 9.37136e-07, 1.21771e-06, 1.58227e-06, 2.05599e-06,
 2.67154e-06, 3.47137e-06, 4.51066e-06, 5.86111e-06, 7.61587e-06,
 9.89598e-06, 1.28587e-05, 1.67085e-05, 2.17109e-05, 2.82109e-05,
 3.66570e-05, 4.76317e-05, 6.18922e-05, 8.04221e-05, 1.04500e-04,
 1.35786e-04, 1.76439e-04, 2.29263e-04, 2.97902e-04, 3.87091e-04,
 5.02982e-04, 6.53570e-04, 8.49242e-04, 1.10350e-03, 1.43387e-03,
 1.86316e-03, 2.42097e-03, 3.14579e-03, 4.08761e-03, 5.31140e-03,
 6.90157e-03, 8.96784e-03, 1.16527e-02, 1.51414e-02, 1.96746e-02,
 2.55650e-02, 3.32189e-02, 4.31643e-02, 5.60873e-02, 7.28793e-02,
 9.46987e-02, 1.23051e-01, 1.59891e-01, 2.07760e-01, 2.69962e-01,
 3.50786e-01, 4.55807e-01, 5.92272e-01, 7.69592e-01, 1.00000e+00}
,
{4.37303e-12, 5.69537e-12, 7.41757e-12, 9.66054e-12, 1.25817e-11,
 1.63863e-11, 2.13413e-11, 2.77945e-11, 3.61992e-11, 4.71453e-11,
 6.14014e-11, 7.99683e-11, 1.04150e-10, 1.35643e-10, 1.76659e-10,
 2.30079e-10, 2.99651e-10, 3.90261e-10, 5.08270e-10, 6.61964e-10,
 8.62132e-10, 1.12283e-09, 1.46236e-09, 1.90455e-09, 2.48046e-09,
 3.23052e-09, 4.20738e-09, 5.47963e-09, 7.13659e-09, 9.29459e-09,
 1.21051e-08, 1.57656e-08, 2.05328e-08, 2.67417e-08, 3.48280e-08,
 4.53594e-08, 5.90755e-08, 7.69390e-08, 1.00204e-07, 1.30505e-07,
 1.69967e-07, 2.21363e-07, 2.88300e-07, 3.75478e-07, 4.89017e-07,
 6.36888e-07, 8.29474e-07, 1.08030e-06, 1.40696e-06, 1.83241e-06,
 2.38650e-06, 3.10814e-06, 4.04800e-06, 5.27205e-06, 6.86625e-06,
 8.94250e-06, 1.16466e-05, 1.51683e-05, 1.97550e-05, 2.57287e-05,
 3.35086e-05, 4.36412e-05, 5.68376e-05, 7.40245e-05, 9.64084e-05,
 1.25561e-04, 1.63529e-04, 2.12978e-04, 2.77379e-04, 3.61254e-04,
 4.70492e-04, 6.12762e-04, 7.98053e-04, 1.03937e-03, 1.35366e-03,
 1.76299e-03, 2.29610e-03, 2.99040e-03, 3.89466e-03, 5.07234e-03,
 6.60615e-03, 8.60375e-03, 1.12054e-02, 1.45937e-02, 1.90067e-02,
 2.47540e-02, 3.22393e-02, 4.19880e-02, 5.46846e-02, 7.12204e-02,
 9.27564e-02, 1.20805e-01, 1.57334e-01, 2.04910e-01, 2.66871e-01,
 3.47570e-01, 4.52670e-01, 5.89550e-01, 7.67822e-01, 1.00000e+00}
,
{3.48163e-12, 4.54488e-12, 5.93283e-12, 7.74464e-12, 1.01098e-11,
 1.31972e-11, 1.72274e-11, 2.24885e-11, 2.93562e-11, 3.83212e-11,
 5.00240e-11, 6.53007e-11, 8.52427e-11, 1.11275e-10, 1.45257e-10,
 1.89617e-10, 2.47523e-10, 3.23114e-10, 4.21789e-10, 5.50598e-10,
 7.18744e-10, 9.38239e-10, 1.22477e-09, 1.59879e-09, 2.08705e-09,
 2.72441e-09, 3.55641e-09, 4.64249e-09, 6.06025e-09, 7.91098e-09,
 1.03269e-08, 1.34806e-08, 1.75974e-08, 2.29714e-08, 2.99867e-08,
 3.91442e-08, 5.10984e-08, 6.67032e-08, 8.70735e-08, 1.13665e-07,
 1.48377e-07, 1.93689e-07, 2.52839e-07, 3.30053e-07, 4.30848e-07,
 5.62423e-07, 7.34180e-07, 9.58390e-07, 1.25107e-06, 1.63313e-06,
 2.13187e-06, 2.78292e-06, 3.63279e-06, 4.74220e-06, 6.19041e-06,
 8.08088e-06, 1.05487e-05, 1.37701e-05, 1.79754e-05, 2.34648e-05,
 3.06307e-05, 3.99849e-05, 5.21958e-05, 6.81358e-05, 8.89437e-05,
 1.16106e-04, 1.51563e-04, 1.97849e-04, 2.58270e-04, 3.37142e-04,
 4.40101e-04, 5.74503e-04, 7.49949e-04, 9.78974e-04, 1.27794e-03,
 1.66821e-03, 2.17766e-03, 2.84269e-03, 3.71081e-03, 4.84405e-03,
 6.32336e-03, 8.25444e-03, 1.07752e-02, 1.40659e-02, 1.83614e-02,
 2.39688e-02, 3.12886e-02, 4.08437e-02, 5.33169e-02, 6.95992e-02,
 9.08540e-02, 1.18600e-01, 1.54819e-01, 2.02098e-01, 2.63817e-01,
 3.44383e-01, 4.49553e-01, 5.86842e-01, 7.66056e-01, 1.00000e+00}
,
{2.77193e-12, 3.62679e-12, 4.74528e-12, 6.20871e-12, 8.12346e-12,
 1.06287e-11, 1.39066e-11, 1.81953e-11, 2.38067e-11, 3.11486e-11,
 4.07548e-11, 5.33234e-11, 6.97682e-11, 9.12845e-11, 1.19436e-10,
 1.56270e-10, 2.04463e-10, 2.67519e-10, 3.50022e-10, 4.57967e-10,
 5.99203e-10, 7.83995e-10, 1.02578e-09, 1.34212e-09, 1.75603e-09,
 2.29759e-09, 3.00616e-09, 3.93324e-09, 5.14625e-09, 6.73333e-09,
 8.80987e-09, 1.15268e-08, 1.50816e-08, 1.97328e-08, 2.58183e-08,
 3.37806e-08, 4.41985e-08, 5.78291e-08, 7.56635e-08, 9.89979e-08,
 1.29529e-07, 1.69475e-07, 2.21740e-07, 2.90124e-07, 3.79598e-07,
 4.96665e-07, 6.49835e-07, 8.50242e-07, 1.11245e-06, 1.45553e-06,
 1.90441e-06, 2.49173e-06, 3.26017e-06, 4.26560e-06, 5.58109e-06,
 7.30229e-06, 9.55429e-06, 1.25008e-05, 1.63560e-05, 2.14002e-05,
 2.79999e-05, 3.66350e-05, 4.79331e-05, 6.27156e-05, 8.20569e-05,
 1.07363e-04, 1.40473e-04, 1.83795e-04, 2.40477e-04, 3.14639e-04,
 4.11673e-04, 5.38632e-04, 7.04744e-04, 9.22085e-04, 1.20645e-03,
 1.57852e-03, 2.06533e-03, 2.70227e-03, 3.53565e-03, 4.62603e-03,
 6.05269e-03, 7.91932e-03, 1.03616e-02, 1.35571e-02, 1.77381e-02,
 2.32084e-02, 3.03659e-02, 3.97306e-02, 5.19834e-02, 6.80149e-02,
 8.89905e-02, 1.16435e-01, 1.52343e-01, 1.99325e-01, 2.60797e-01,
 3.41226e-01, 4.46459e-01, 5.84145e-01, 7.64294e-01, 1.00000e+00}
,
{2.20690e-12, 2.89416e-12, 3.79544e-12, 4.97739e-12, 6.52741e-12,
 8.56013e-12, 1.12259e-11, 1.47218e-11, 1.93063e-11, 2.53185e-11,
 3.32031e-11, 4.35430e-11, 5.71028e-11, 7.48854e-11, 9.82057e-11,
 1.28788e-10, 1.68895e-10, 2.21491e-10, 2.90466e-10, 3.80921e-10,
 4.99544e-10, 6.55109e-10, 8.59119e-10, 1.12666e-09, 1.47752e-09,
 1.93763e-09, 2.54104e-09, 3.33235e-09, 4.37009e-09, 5.73100e-09,
 7.51570e-09, 9.85619e-09, 1.29255e-08, 1.69507e-08, 2.22294e-08,
 2.91519e-08, 3.82302e-08, 5.01357e-08, 6.57486e-08, 8.62235e-08,
 1.13075e-07, 1.48288e-07, 1.94466e-07, 2.55026e-07, 3.34444e-07,
 4.38595e-07, 5.75179e-07, 7.54297e-07, 9.89195e-07, 1.29724e-06,
 1.70122e-06, 2.23101e-06, 2.92577e-06, 3.83689e-06, 5.03175e-06,
 6.59871e-06, 8.65363e-06, 1.13485e-05, 1.48826e-05, 1.95172e-05,
 2.55951e-05, 3.35657e-05, 4.40186e-05, 5.77265e-05, 7.57033e-05,
 9.92784e-05, 1.30195e-04, 1.70739e-04, 2.23910e-04, 2.93638e-04,
 3.85081e-04, 5.05001e-04, 6.62265e-04, 8.68503e-04, 1.13897e-03,
 1.49366e-03, 1.95880e-03, 2.56880e-03, 3.36875e-03, 4.41783e-03,
 5.79360e-03, 7.59780e-03, 9.96385e-03, 1.30667e-02, 1.71359e-02,
 2.24722e-02, 2.94704e-02, 3.86478e-02, 5.06833e-02, 6.64667e-02,
 8.71653e-02, 1.14310e-01, 1.49907e-01, 1.96591e-01, 2.57811e-01,
 3.38097e-01, 4.43385e-01, 5.81461e-01, 7.62536e-01, 1.00000e+00}
,
{1.75704e-12, 2.30952e-12, 3.03572e-12, 3.99026e-12, 5.24494e-12,
 6.89415e-12, 9.06192e-12, 1.19113e-11, 1.56567e-11, 2.05797e-11,
 2.70507e-11, 3.55564e-11, 4.67366e-11, 6.14323e-11, 8.07489e-11,
 1.06139e-10, 1.39513e-10, 1.83381e-10, 2.41043e-10, 3.16836e-10,
 4.16461e-10, 5.47411e-10, 7.19537e-10, 9.45786e-10, 1.24317e-09,
 1.63407e-09, 2.14789e-09, 2.82326e-09, 3.71100e-09, 4.87787e-09,
 6.41165e-09, 8.42770e-09, 1.10777e-08, 1.45609e-08, 1.91394e-08,
 2.51575e-08, 3.30679e-08, 4.34657e-08, 5.71329e-08, 7.50976e-08,
 9.87110e-08, 1.29749e-07, 1.70547e-07, 2.24173e-07, 2.94662e-07,
 3.87314e-07, 5.09100e-07, 6.69179e-07, 8.79593e-07, 1.15617e-06,
 1.51971e-06, 1.99756e-06, 2.62567e-06, 3.45128e-06, 4.53648e-06,
 5.96292e-06, 7.83788e-06, 1.03024e-05, 1.35418e-05, 1.77999e-05,
 2.33968e-05, 3.07536e-05, 4.04237e-05, 5.31344e-05, 6.98417e-05,
 9.18025e-05, 1.20669e-04, 1.58611e-04, 2.08484e-04, 2.74039e-04,
 3.60207e-04, 4.73470e-04, 6.22346e-04, 8.18034e-04, 1.07525e-03,
 1.41335e-03, 1.85776e-03, 2.44191e-03, 3.20973e-03, 4.21899e-03,
 5.54560e-03, 7.28933e-03, 9.58136e-03, 1.25941e-02, 1.65541e-02,
 2.17594e-02, 2.86013e-02, 3.75946e-02, 4.94157e-02, 6.49538e-02,
 8.53776e-02, 1.12223e-01, 1.47511e-01, 1.93893e-01, 2.54860e-01,
 3.34998e-01, 4.40333e-01, 5.78790e-01, 7.60782e-01, 1.00000e+00}
,
{1.39889e-12, 1.84299e-12, 2.42807e-12, 3.19890e-12, 4.21445e-12,
 5.55240e-12, 7.31510e-12, 9.63739e-12, 1.26969e-11, 1.67278e-11,
 2.20383e-11, 2.90347e-11, 3.82523e-11, 5.03961e-11, 6.63952e-11,
 8.74734e-11, 1.15243e-10, 1.51829e-10, 2.00030e-10, 2.63533e-10,
 3.47195e-10, 4.57418e-10, 6.02633e-10, 7.93949e-10, 1.04600e-09,
 1.37807e-09, 1.81556e-09, 2.39194e-09, 3.15131e-09, 4.15174e-09,
 5.46978e-09, 7.20625e-09, 9.49399e-09, 1.25080e-08, 1.64789e-08,
 2.17104e-08, 2.86027e-08, 3.76831e-08, 4.96462e-08, 6.54072e-08,
 8.61718e-08, 1.13529e-07, 1.49570e-07, 1.97053e-07, 2.59611e-07,
 3.42029e-07, 4.50612e-07, 5.93666e-07, 7.82135e-07, 1.03044e-06,
 1.35757e-06, 1.78855e-06, 2.35635e-06, 3.10442e-06, 4.08996e-06,
 5.38839e-06, 7.09902e-06, 9.35272e-06, 1.23219e-05, 1.62337e-05,
 2.13873e-05, 2.81771e-05, 3.71224e-05, 4.89075e-05, 6.44340e-05,
 8.48896e-05, 1.11839e-04, 1.47344e-04, 1.94121e-04, 2.55748e-04,
 3.36940e-04, 4.43907e-04, 5.84833e-04, 7.70497e-04, 1.01510e-03,
 1.33737e-03, 1.76194e-03, 2.32129e-03, 3.05822e-03, 4.02911e-03,
 5.30821e-03, 6.99339e-03, 9.21356e-03, 1.21386e-02, 1.59921e-02,
 2.10691e-02, 2.77578e-02, 3.65700e-02, 4.81798e-02, 6.34752e-02,
 8.36265e-02, 1.10175e-01, 1.45152e-01, 1.91233e-01, 2.51943e-01,
 3.31926e-01, 4.37302e-01, 5.76130e-01, 7.59033e-01, 1.00000e+00}
,
{1.11374e-12, 1.47069e-12, 1.94206e-12, 2.56449e-12, 3.38642e-12,
 4.47178e-12, 5.90500e-12, 7.79758e-12, 1.02967e-11, 1.35969e-11,
 1.79547e-11, 2.37093e-11, 3.13082e-11, 4.13425e-11, 5.45929e-11,
 7.20902e-11, 9.51953e-11, 1.25706e-10, 1.65995e-10, 2.19197e-10,
 2.89450e-10, 3.82220e-10, 5.04723e-10, 6.66489e-10, 8.80100e-10,
 1.16218e-09, 1.53466e-09, 2.02652e-09, 2.67603e-09, 3.53370e-09,
 4.66627e-09, 6.16182e-09, 8.13671e-09, 1.07446e-08, 1.41882e-08,
 1.87356e-08, 2.47404e-08, 3.26698e-08, 4.31406e-08, 5.69673e-08,
 7.52256e-08, 9.93356e-08, 1.31173e-07, 1.73214e-07, 2.28730e-07,
 3.02039e-07, 3.98844e-07, 5.26675e-07, 6.95476e-07, 9.18378e-07,
 1.21272e-06, 1.60140e-06, 2.11466e-06, 2.79241e-06, 3.68739e-06,
 4.86921e-06, 6.42982e-06, 8.49059e-06, 1.12119e-05, 1.48053e-05,
 1.95505e-05, 2.58164e-05, 3.40907e-05, 4.50169e-05, 5.94450e-05,
 7.84973e-05, 1.03656e-04, 1.36878e-04, 1.80748e-04, 2.38678e-04,
 3.15176e-04, 4.16190e-04, 5.49581e-04, 7.25723e-04, 9.58320e-04,
 1.26547e-03, 1.67105e-03, 2.20663e-03, 2.91386e-03, 3.84777e-03,
 5.08099e-03, 6.70946e-03, 8.85987e-03, 1.16995e-02, 1.54492e-02,
 2.04007e-02, 2.69393e-02, 3.55734e-02, 4.69748e-02, 6.20304e-02,
 8.19113e-02, 1.08164e-01, 1.42831e-01, 1.88609e-01, 2.49059e-01,
 3.28883e-01, 4.34291e-01, 5.73483e-01, 7.57287e-01, 1.00000e+00}
,
{8.86712e-13, 1.17361e-12, 1.55332e-12, 2.05590e-12, 2.72108e-12,
 3.60148e-12, 4.76672e-12, 6.30899e-12, 8.35024e-12, 1.10519e-11,
 1.46278e-11, 1.93606e-11, 2.56246e-11, 3.39154e-11, 4.48887e-11,
 5.94123e-11, 7.86350e-11, 1.04077e-10, 1.37751e-10, 1.82320e-10,
 2.41309e-10, 3.19384e-10, 4.22720e-10, 5.59490e-10, 7.40512e-10,
 9.80103e-10, 1.29721e-09, 1.71692e-09, 2.27243e-09, 3.00767e-09,
 3.98079e-09, 5.26877e-09, 6.97347e-09, 9.22972e-09, 1.22160e-08,
 1.61684e-08, 2.13997e-08, 2.83235e-08, 3.74875e-08, 4.96165e-08,
 6.56698e-08, 8.69170e-08, 1.15039e-07, 1.52259e-07, 2.01523e-07,
 2.66725e-07, 3.53023e-07, 4.67243e-07, 6.18418e-07, 8.18505e-07,
 1.08333e-06, 1.43384e-06, 1.89776e-06, 2.51177e-06, 3.32445e-06,
 4.40006e-06, 5.82369e-06, 7.70794e-06, 1.02018e-05, 1.35026e-05,
 1.78713e-05, 2.36536e-05, 3.13066e-05, 4.14358e-05, 5.48422e-05,
 7.25863e-05, 9.60714e-05, 1.27155e-04, 1.68296e-04, 2.22748e-04,
 2.94817e-04, 3.90204e-04, 5.16454e-04, 6.83551e-04, 9.04713e-04,
 1.19743e-03, 1.58486e-03, 2.09763e-03, 2.77632e-03, 3.67459e-03,
 4.86349e-03, 6.43706e-03, 8.51976e-03, 1.12763e-02, 1.49247e-02,
 1.97536e-02, 2.61448e-02, 3.46039e-02, 4.57999e-02, 6.06184e-02,
 8.02313e-02, 1.06190e-01, 1.40547e-01, 1.86021e-01, 2.46208e-01,
 3.25868e-01, 4.31302e-01, 5.70848e-01, 7.55545e-01, 1.00000e+00}
 ,
{7.05964e-13, 9.36531e-13, 1.24240e-12, 1.64817e-12, 2.18646e-12,
 2.90055e-12, 3.84787e-12, 5.10457e-12, 6.77172e-12, 8.98336e-12,
 1.19173e-11, 1.58095e-11, 2.09728e-11, 2.78226e-11, 3.69094e-11,
 4.89639e-11, 6.49555e-11, 8.61698e-11, 1.14313e-10, 1.51647e-10,
 2.01175e-10, 2.66878e-10, 3.54041e-10, 4.69670e-10, 6.23063e-10,
 8.26555e-10, 1.09651e-09, 1.45462e-09, 1.92970e-09, 2.55994e-09,
 3.39602e-09, 4.50515e-09, 5.97653e-09, 7.92845e-09, 1.05179e-08,
 1.39530e-08, 1.85100e-08, 2.45554e-08, 3.25751e-08, 4.32141e-08,
 5.73278e-08, 7.60510e-08, 1.00889e-07, 1.33839e-07, 1.77551e-07,
 2.35539e-07, 3.12466e-07, 4.14517e-07, 5.49898e-07, 7.29494e-07,
 9.67745e-07, 1.28381e-06, 1.70310e-06, 2.25933e-06, 2.99723e-06,
 3.97611e-06, 5.27471e-06, 6.99742e-06, 9.28277e-06, 1.23145e-05,
 1.63364e-05, 2.16719e-05, 2.87499e-05, 3.81395e-05, 5.05959e-05,
 6.71204e-05, 8.90419e-05, 1.18123e-04, 1.56702e-04, 2.07880e-04,
 2.75773e-04, 3.65841e-04, 4.85324e-04, 6.43830e-04, 8.54104e-04,
 1.13305e-03, 1.50311e-03, 1.99402e-03, 2.64526e-03, 3.50920e-03,
 4.65531e-03, 6.17572e-03, 8.19270e-03, 1.08684e-02, 1.44180e-02,
 1.91270e-02, 2.53738e-02, 3.36609e-02, 4.46544e-02, 5.92385e-02,
 7.85858e-02, 1.04252e-01, 1.38300e-01, 1.83469e-01, 2.43390e-01,
 3.22880e-01, 4.28333e-01, 5.68226e-01, 7.53807e-01, 1.00000e+00}
};

const std::vector< std::vector<double> > PROPOSAL::sigma_nu_n = {
{5.79350e-07, 5.00519e-06, 1.87559e-05, 5.79158e-05, 1.44069e-04,
 3.00542e-04, 5.50844e-04, 9.16468e-04, 1.41599e-03, 2.06284e-03,
 2.86738e-03, 3.83370e-03, 4.96021e-03, 6.24208e-03, 7.67241e-03,
 9.24118e-03, 1.09350e-02, 1.27395e-02, 1.46404e-02, 1.66230e-02,
 1.86728e-02, 2.07758e-02, 2.29187e-02, 2.50892e-02, 2.72765e-02,
 2.94704e-02, 3.16621e-02, 3.38434e-02, 3.60074e-02, 3.81482e-02,
 4.02613e-02, 4.23413e-02, 4.43848e-02, 4.63889e-02, 4.83522e-02,
 5.02719e-02, 5.21461e-02, 5.39724e-02, 5.57496e-02, 5.74774e-02,
 5.91551e-02, 6.07821e-02, 6.23572e-02, 6.38800e-02, 6.53506e-02,
 6.67692e-02, 6.81362e-02, 6.94509e-02, 7.07138e-02, 7.19251e-02,
 7.30853e-02, 7.41952e-02, 7.52552e-02, 7.62661e-02, 7.72282e-02,
 7.81426e-02, 7.90102e-02, 7.98321e-02, 8.06095e-02, 8.13435e-02,
 8.20357e-02, 8.26878e-02, 8.33011e-02, 8.38773e-02, 8.44175e-02,
 8.49233e-02, 8.53960e-02, 8.58368e-02, 8.62469e-02, 8.66274e-02,
 8.69793e-02, 8.73036e-02, 8.76011e-02, 8.78726e-02, 8.81190e-02,
 8.83408e-02, 8.85390e-02, 8.87141e-02, 8.88669e-02, 8.89980e-02,
 8.91080e-02, 8.91975e-02, 8.92673e-02, 8.93181e-02, 8.93507e-02,
 8.93653e-02, 8.93631e-02, 8.93448e-02, 8.93112e-02, 8.92632e-02,
 8.92016e-02, 8.91275e-02, 8.90418e-02, 8.89457e-02, 8.88404e-02,
 8.87271e-02, 8.86074e-02, 8.84828e-02, 8.83549e-02, 8.82254e-02}
,
{9.43042e-07, 7.69699e-06, 3.07252e-05, 9.71460e-05, 2.41154e-04,
 4.99100e-04, 9.06596e-04, 1.49493e-03, 2.28854e-03, 3.30490e-03,
 4.55408e-03, 6.03491e-03, 7.74080e-03, 9.66127e-03, 1.17809e-02,
 1.40787e-02, 1.65327e-02, 1.91208e-02, 2.18201e-02, 2.46086e-02,
 2.74650e-02, 3.03696e-02, 3.33049e-02, 3.62549e-02, 3.92052e-02,
 4.21432e-02, 4.50579e-02, 4.79403e-02, 5.07831e-02, 5.35786e-02,
 5.63212e-02, 5.90076e-02, 6.16350e-02, 6.41995e-02, 6.66973e-02,
 6.91263e-02, 7.14852e-02, 7.37733e-02, 7.59897e-02, 7.81324e-02,
 8.02010e-02, 8.21954e-02, 8.41159e-02, 8.59630e-02, 8.77358e-02,
 8.94351e-02, 9.10612e-02, 9.26153e-02, 9.40980e-02, 9.55106e-02,
 9.68534e-02, 9.81280e-02, 9.93357e-02, 1.00478e-01, 1.01557e-01,
 1.02575e-01, 1.03533e-01, 1.04435e-01, 1.05282e-01, 1.06076e-01,
 1.06820e-01, 1.07516e-01, 1.08165e-01, 1.08770e-01, 1.09332e-01,
 1.09853e-01, 1.10334e-01, 1.10776e-01, 1.11180e-01, 1.11548e-01,
 1.11880e-01, 1.12178e-01, 1.12442e-01, 1.12674e-01, 1.12873e-01,
 1.13042e-01, 1.13179e-01, 1.13288e-01, 1.13368e-01, 1.13420e-01,
 1.13444e-01, 1.13443e-01, 1.13416e-01, 1.13365e-01, 1.13291e-01,
 1.13194e-01, 1.13076e-01, 1.12938e-01, 1.12782e-01, 1.12608e-01,
 1.12419e-01, 1.12215e-01, 1.12000e-01, 1.11775e-01, 1.11542e-01,
 1.11303e-01, 1.11060e-01, 1.10815e-01, 1.10572e-01, 1.10331e-01}
,
{1.49424e-06, 1.18850e-05, 5.01325e-05, 1.60376e-04, 3.95939e-04,
 8.13052e-04, 1.46371e-03, 2.39165e-03, 3.62843e-03, 5.19441e-03,
 7.09425e-03, 9.31870e-03, 1.18536e-02, 1.46761e-02, 1.77551e-02,
 2.10568e-02, 2.45473e-02, 2.81918e-02, 3.19570e-02, 3.58110e-02,
 3.97248e-02, 4.36727e-02, 4.76314e-02, 5.15806e-02, 5.55025e-02,
 5.93825e-02, 6.32090e-02, 6.69704e-02, 7.06579e-02, 7.42660e-02,
 7.77907e-02, 8.12258e-02, 8.45659e-02, 8.78082e-02, 9.09512e-02,
 9.39939e-02, 9.69335e-02, 9.97689e-02, 1.02499e-01, 1.05125e-01,
 1.07647e-01, 1.10064e-01, 1.12377e-01, 1.14587e-01, 1.16695e-01,
 1.18703e-01, 1.20611e-01, 1.22421e-01, 1.24136e-01, 1.25757e-01,
 1.27286e-01, 1.28728e-01, 1.30085e-01, 1.31360e-01, 1.32557e-01,
 1.33680e-01, 1.34732e-01, 1.35715e-01, 1.36632e-01, 1.37488e-01,
 1.38282e-01, 1.39019e-01, 1.39700e-01, 1.40326e-01, 1.40900e-01,
 1.41423e-01, 1.41895e-01, 1.42320e-01, 1.42697e-01, 1.43028e-01,
 1.43315e-01, 1.43557e-01, 1.43756e-01, 1.43913e-01, 1.44030e-01,
 1.44106e-01, 1.44144e-01, 1.44143e-01, 1.44106e-01, 1.44034e-01,
 1.43927e-01, 1.43787e-01, 1.43616e-01, 1.43414e-01, 1.43185e-01,
 1.42929e-01, 1.42648e-01, 1.42346e-01, 1.42024e-01, 1.41684e-01,
 1.41328e-01, 1.40960e-01, 1.40581e-01, 1.40194e-01, 1.39801e-01,
 1.39405e-01, 1.39009e-01, 1.38616e-01, 1.38230e-01, 1.37854e-01}
,
{2.31603e-06, 1.83207e-05, 8.10034e-05, 2.60565e-04, 6.39335e-04,
 1.30172e-03, 2.32235e-03, 3.75970e-03, 5.65384e-03, 8.02271e-03,
 1.08593e-02, 1.41440e-02, 1.78463e-02, 2.19207e-02, 2.63165e-02,
 3.09823e-02, 3.58657e-02, 4.09165e-02, 4.60869e-02, 5.13341e-02,
 5.66203e-02, 6.19121e-02, 6.71801e-02, 7.23995e-02, 7.75511e-02,
 8.26177e-02, 8.75839e-02, 9.24402e-02, 9.71805e-02, 1.01796e-01,
 1.06278e-01, 1.10623e-01, 1.14828e-01, 1.18891e-01, 1.22809e-01,
 1.26580e-01, 1.30204e-01, 1.33680e-01, 1.37011e-01, 1.40194e-01,
 1.43232e-01, 1.46126e-01, 1.48878e-01, 1.51490e-01, 1.53964e-01,
 1.56304e-01, 1.58511e-01, 1.60592e-01, 1.62549e-01, 1.64388e-01,
 1.66114e-01, 1.67732e-01, 1.69248e-01, 1.70666e-01, 1.71990e-01,
 1.73225e-01, 1.74375e-01, 1.75443e-01, 1.76431e-01, 1.77344e-01,
 1.78182e-01, 1.78949e-01, 1.79647e-01, 1.80277e-01, 1.80841e-01,
 1.81340e-01, 1.81777e-01, 1.82152e-01, 1.82467e-01, 1.82723e-01,
 1.82923e-01, 1.83066e-01, 1.83154e-01, 1.83189e-01, 1.83172e-01,
 1.83105e-01, 1.82988e-01, 1.82825e-01, 1.82616e-01, 1.82364e-01,
 1.82071e-01, 1.81739e-01, 1.81372e-01, 1.80972e-01, 1.80540e-01,
 1.80080e-01, 1.79594e-01, 1.79085e-01, 1.78555e-01, 1.78006e-01,
 1.77442e-01, 1.76864e-01, 1.76278e-01, 1.75684e-01, 1.75088e-01,
 1.74493e-01, 1.73903e-01, 1.73323e-01, 1.72756e-01, 1.72209e-01}
,
{3.52435e-06, 2.80340e-05, 1.29345e-04, 4.17350e-04, 1.01683e-03,
 2.05151e-03, 3.62624e-03, 5.81756e-03, 8.67185e-03, 1.21950e-02,
 1.63638e-02, 2.11395e-02, 2.64596e-02, 3.22490e-02, 3.84308e-02,
 4.49266e-02, 5.16609e-02, 5.85622e-02, 6.55672e-02, 7.26202e-02,
 7.96725e-02, 8.66816e-02, 9.36129e-02, 1.00440e-01, 1.07137e-01,
 1.13686e-01, 1.20076e-01, 1.26296e-01, 1.32332e-01, 1.38177e-01,
 1.43827e-01, 1.49279e-01, 1.54527e-01, 1.59569e-01, 1.64405e-01,
 1.69036e-01, 1.73462e-01, 1.77682e-01, 1.81699e-01, 1.85515e-01,
 1.89135e-01, 1.92561e-01, 1.95795e-01, 1.98845e-01, 2.01714e-01,
 2.04410e-01, 2.06940e-01, 2.09311e-01, 2.11532e-01, 2.13610e-01,
 2.15552e-01, 2.17365e-01, 2.19056e-01, 2.20628e-01, 2.22089e-01,
 2.23441e-01, 2.24689e-01, 2.25837e-01, 2.26886e-01, 2.27842e-01,
 2.28705e-01, 2.29479e-01, 2.30165e-01, 2.30766e-01, 2.31283e-01,
 2.31719e-01, 2.32076e-01, 2.32354e-01, 2.32557e-01, 2.32685e-01,
 2.32741e-01, 2.32727e-01, 2.32644e-01, 2.32495e-01, 2.32283e-01,
 2.32011e-01, 2.31681e-01, 2.31297e-01, 2.30862e-01, 2.30378e-01,
 2.29849e-01, 2.29277e-01, 2.28665e-01, 2.28016e-01, 2.27332e-01,
 2.26615e-01, 2.25869e-01, 2.25096e-01, 2.24300e-01, 2.23484e-01,
 2.22651e-01, 2.21806e-01, 2.20951e-01, 2.20092e-01, 2.19233e-01,
 2.18380e-01, 2.17537e-01, 2.16712e-01, 2.15909e-01, 2.15138e-01}
,
{5.28011e-06, 4.27633e-05, 2.04923e-04, 6.59008e-04, 1.59341e-03,
 3.18610e-03, 5.58025e-03, 8.87353e-03, 1.31097e-02, 1.82720e-02,
 2.43137e-02, 3.11563e-02, 3.86912e-02, 4.68049e-02, 5.53810e-02,
 6.43066e-02, 7.34747e-02, 8.27907e-02, 9.21723e-02, 1.01547e-01,
 1.10854e-01, 1.20045e-01, 1.29081e-01, 1.37925e-01, 1.46557e-01,
 1.54961e-01, 1.63118e-01, 1.71011e-01, 1.78634e-01, 1.85982e-01,
 1.93048e-01, 1.99828e-01, 2.06319e-01, 2.12525e-01, 2.18444e-01,
 2.24077e-01, 2.29427e-01, 2.34499e-01, 2.39297e-01, 2.43826e-01,
 2.48091e-01, 2.52101e-01, 2.55865e-01, 2.59392e-01, 2.62695e-01,
 2.65784e-01, 2.68672e-01, 2.71369e-01, 2.73885e-01, 2.76231e-01,
 2.78413e-01, 2.80440e-01, 2.82317e-01, 2.84052e-01, 2.85649e-01,
 2.87112e-01, 2.88447e-01, 2.89656e-01, 2.90743e-01, 2.91711e-01,
 2.92564e-01, 2.93303e-01, 2.93934e-01, 2.94455e-01, 2.94872e-01,
 2.95187e-01, 2.95402e-01, 2.95520e-01, 2.95543e-01, 2.95476e-01,
 2.95321e-01, 2.95082e-01, 2.94764e-01, 2.94371e-01, 2.93907e-01,
 2.93375e-01, 2.92778e-01, 2.92121e-01, 2.91405e-01, 2.90634e-01,
 2.89810e-01, 2.88936e-01, 2.88014e-01, 2.87049e-01, 2.86042e-01,
 2.84997e-01, 2.83917e-01, 2.82805e-01, 2.81666e-01, 2.80502e-01,
 2.79319e-01, 2.78121e-01, 2.76912e-01, 2.75699e-01, 2.74488e-01,
 2.73286e-01, 2.72100e-01, 2.70941e-01, 2.69818e-01, 2.68743e-01}
,
{7.80549e-06, 6.53499e-05, 3.20590e-04, 1.02810e-03, 2.46503e-03,
 4.88328e-03, 8.47507e-03, 1.33586e-02, 1.95584e-02, 2.70248e-02,
 3.56677e-02, 4.53411e-02, 5.58783e-02, 6.71096e-02, 7.88653e-02,
 9.09867e-02, 1.03331e-01, 1.15775e-01, 1.28212e-01, 1.40552e-01,
 1.52725e-01, 1.64675e-01, 1.76352e-01, 1.87728e-01, 1.98779e-01,
 2.09477e-01, 2.19803e-01, 2.29751e-01, 2.39312e-01, 2.48477e-01,
 2.57242e-01, 2.65608e-01, 2.73577e-01, 2.81148e-01, 2.88326e-01,
 2.95117e-01, 3.01527e-01, 3.07564e-01, 3.13237e-01, 3.18558e-01,
 3.23540e-01, 3.28199e-01, 3.32551e-01, 3.36615e-01, 3.40407e-01,
 3.43942e-01, 3.47236e-01, 3.50300e-01, 3.53147e-01, 3.55787e-01,
 3.58229e-01, 3.60480e-01, 3.62547e-01, 3.64438e-01, 3.66157e-01,
 3.67709e-01, 3.69100e-01, 3.70334e-01, 3.71415e-01, 3.72348e-01,
 3.73134e-01, 3.73780e-01, 3.74288e-01, 3.74663e-01, 3.74907e-01,
 3.75026e-01, 3.75025e-01, 3.74908e-01, 3.74683e-01, 3.74354e-01,
 3.73926e-01, 3.73406e-01, 3.72797e-01, 3.72104e-01, 3.71329e-01,
 3.70476e-01, 3.69549e-01, 3.68549e-01, 3.67481e-01, 3.66346e-01,
 3.65148e-01, 3.63890e-01, 3.62574e-01, 3.61203e-01, 3.59780e-01,
 3.58309e-01, 3.56793e-01, 3.55235e-01, 3.53639e-01, 3.52010e-01,
 3.50354e-01, 3.48676e-01, 3.46984e-01, 3.45287e-01, 3.43594e-01,
 3.41916e-01, 3.40267e-01, 3.38660e-01, 3.37112e-01, 3.35641e-01}
,
{1.14058e-05, 9.93959e-05, 4.97147e-04, 1.58461e-03, 3.76712e-03,
 7.39523e-03, 1.27187e-02, 1.98695e-02, 2.88311e-02, 3.95053e-02,
 5.17182e-02, 6.52332e-02, 7.98030e-02, 9.51783e-02, 1.11120e-01,
 1.27414e-01, 1.43874e-01, 1.60342e-01, 1.76683e-01, 1.92795e-01,
 2.08595e-01, 2.24011e-01, 2.39007e-01, 2.53544e-01, 2.67585e-01,
 2.81106e-01, 2.94101e-01, 3.06554e-01, 3.18454e-01, 3.29802e-01,
 3.40600e-01, 3.50846e-01, 3.60546e-01, 3.69707e-01, 3.78341e-01,
 3.86457e-01, 3.94067e-01, 4.01190e-01, 4.07845e-01, 4.14054e-01,
 4.19843e-01, 4.25238e-01, 4.30263e-01, 4.34940e-01, 4.39291e-01,
 4.43332e-01, 4.47082e-01, 4.50554e-01, 4.53760e-01, 4.56711e-01,
 4.59417e-01, 4.61887e-01, 4.64129e-01, 4.66150e-01, 4.67956e-01,
 4.69554e-01, 4.70951e-01, 4.72151e-01, 4.73160e-01, 4.73985e-01,
 4.74629e-01, 4.75100e-01, 4.75405e-01, 4.75549e-01, 4.75543e-01,
 4.75393e-01, 4.75108e-01, 4.74696e-01, 4.74162e-01, 4.73514e-01,
 4.72755e-01, 4.71889e-01, 4.70922e-01, 4.69855e-01, 4.68693e-01,
 4.67438e-01, 4.66094e-01, 4.64664e-01, 4.63149e-01, 4.61552e-01,
 4.59875e-01, 4.58120e-01, 4.56290e-01, 4.54387e-01, 4.52413e-01,
 4.50372e-01, 4.48267e-01, 4.46103e-01, 4.43886e-01, 4.41624e-01,
 4.39325e-01, 4.36999e-01, 4.34658e-01, 4.32315e-01, 4.29985e-01,
 4.27684e-01, 4.25430e-01, 4.23246e-01, 4.21152e-01, 4.19175e-01}
,
{1.65194e-05, 1.50023e-04, 7.63188e-04, 2.41712e-03, 5.69337e-03,
 1.10749e-02, 1.88799e-02, 2.92280e-02, 4.20412e-02, 5.71352e-02,
 7.42024e-02, 9.28877e-02, 1.12828e-01, 1.33668e-01, 1.55083e-01,
 1.76791e-01, 1.98553e-01, 2.20168e-01, 2.41479e-01, 2.62366e-01,
 2.82726e-01, 3.02503e-01, 3.21641e-01, 3.40088e-01, 3.57816e-01,
 3.74814e-01, 3.91057e-01, 4.06536e-01, 4.21255e-01, 4.35215e-01,
 4.48416e-01, 4.60869e-01, 4.72588e-01, 4.83589e-01, 4.93887e-01,
 5.03507e-01, 5.12477e-01, 5.20827e-01, 5.28598e-01, 5.35824e-01,
 5.42542e-01, 5.48784e-01, 5.54581e-01, 5.59959e-01, 5.64941e-01,
 5.69548e-01, 5.73796e-01, 5.77701e-01, 5.81279e-01, 5.84541e-01,
 5.87497e-01, 5.90158e-01, 5.92534e-01, 5.94635e-01, 5.96470e-01,
 5.98045e-01, 5.99369e-01, 6.00451e-01, 6.01300e-01, 6.01925e-01,
 6.02337e-01, 6.02548e-01, 6.02571e-01, 6.02416e-01, 6.02094e-01,
 6.01616e-01, 6.00987e-01, 6.00215e-01, 5.99306e-01, 5.98264e-01,
 5.97094e-01, 5.95799e-01, 5.94384e-01, 5.92851e-01, 5.91203e-01,
 5.89441e-01, 5.87569e-01, 5.85586e-01, 5.83493e-01, 5.81292e-01,
 5.78983e-01, 5.76567e-01, 5.74047e-01, 5.71425e-01, 5.68705e-01,
 5.65893e-01, 5.62996e-01, 5.60021e-01, 5.56978e-01, 5.53879e-01,
 5.50737e-01, 5.47564e-01, 5.44377e-01, 5.41193e-01, 5.38032e-01,
 5.34916e-01, 5.31870e-01, 5.28922e-01, 5.26105e-01, 5.23455e-01}
,
{2.37950e-05, 2.26010e-04, 1.15976e-03, 3.64885e-03, 8.51943e-03,
 1.64181e-02, 2.77425e-02, 4.25614e-02, 6.07026e-02, 8.18274e-02,
 1.05445e-01, 1.31034e-01, 1.58073e-01, 1.86071e-01, 2.14600e-01,
 2.43292e-01, 2.71847e-01, 3.00020e-01, 3.27633e-01, 3.54533e-01,
 3.80633e-01, 4.05856e-01, 4.30125e-01, 4.53404e-01, 4.75673e-01,
 4.96902e-01, 5.17079e-01, 5.36214e-01, 5.54301e-01, 5.71350e-01,
 5.87380e-01, 6.02412e-01, 6.16465e-01, 6.29572e-01, 6.41772e-01,
 6.53106e-01, 6.63629e-01, 6.73394e-01, 6.82454e-01, 6.90857e-01,
 6.98647e-01, 7.05862e-01, 7.12537e-01, 7.18702e-01, 7.24380e-01,
 7.29596e-01, 7.34369e-01, 7.38717e-01, 7.42655e-01, 7.46198e-01,
 7.49362e-01, 7.52161e-01, 7.54602e-01, 7.56703e-01, 7.58475e-01,
 7.59929e-01, 7.61079e-01, 7.61942e-01, 7.62535e-01, 7.62875e-01,
 7.62980e-01, 7.62864e-01, 7.62542e-01, 7.62026e-01, 7.61323e-01,
 7.60443e-01, 7.59392e-01, 7.58175e-01, 7.56800e-01, 7.55269e-01,
 7.53588e-01, 7.51757e-01, 7.49779e-01, 7.47654e-01, 7.45383e-01,
 7.42965e-01, 7.40400e-01, 7.37685e-01, 7.34821e-01, 7.31809e-01,
 7.28649e-01, 7.25346e-01, 7.21902e-01, 7.18325e-01, 7.14622e-01,
 7.10800e-01, 7.06871e-01, 7.02844e-01, 6.98731e-01, 6.94546e-01,
 6.90304e-01, 6.86020e-01, 6.81716e-01, 6.77414e-01, 6.73141e-01,
 6.68927e-01, 6.64806e-01, 6.60821e-01, 6.57016e-01, 6.53446e-01}
,
{3.40821e-05, 3.39297e-04, 1.74893e-03, 5.45883e-03, 1.26265e-02,
 2.41160e-02, 4.03848e-02, 6.14070e-02, 8.68577e-02, 1.16147e-01,
 1.48541e-01, 1.83284e-01, 2.19646e-01, 2.56969e-01, 2.94693e-01,
 3.32350e-01, 3.69570e-01, 4.06074e-01, 4.41632e-01, 4.76108e-01,
 5.09390e-01, 5.41369e-01, 5.71990e-01, 6.01224e-01, 6.29029e-01,
 6.55393e-01, 6.80328e-01, 7.03829e-01, 7.25912e-01, 7.46606e-01,
 7.65944e-01, 7.83958e-01, 8.00698e-01, 8.16224e-01, 8.30606e-01,
 8.43921e-01, 8.56249e-01, 8.67657e-01, 8.78213e-01, 8.87974e-01,
 8.96992e-01, 9.05310e-01, 9.12964e-01, 9.19987e-01, 9.26411e-01,
 9.32259e-01, 9.37554e-01, 9.42320e-01, 9.46576e-01, 9.50345e-01,
 9.53639e-01, 9.56479e-01, 9.58885e-01, 9.60874e-01, 9.62468e-01,
 9.63691e-01, 9.64569e-01, 9.65129e-01, 9.65392e-01, 9.65381e-01,
 9.65113e-01, 9.64602e-01, 9.63861e-01, 9.62899e-01, 9.61726e-01,
 9.60349e-01, 9.58775e-01, 9.57008e-01, 9.55053e-01, 9.52910e-01,
 9.50580e-01, 9.48062e-01, 9.45353e-01, 9.42452e-01, 9.39354e-01,
 9.36058e-01, 9.32563e-01, 9.28868e-01, 9.24975e-01, 9.20888e-01,
 9.16612e-01, 9.12153e-01, 9.07516e-01, 9.02709e-01, 8.97741e-01,
 8.92619e-01, 8.87352e-01, 8.81952e-01, 8.76432e-01, 8.70806e-01,
 8.65094e-01, 8.59318e-01, 8.53503e-01, 8.47682e-01, 8.41891e-01,
 8.36173e-01, 8.30579e-01, 8.25171e-01, 8.20018e-01, 8.15203e-01}
,
{4.85400e-05, 5.06022e-04, 2.61328e-03, 8.09409e-03, 1.85544e-02,
 3.51199e-02, 5.82819e-02, 8.78528e-02, 1.23251e-01, 1.63520e-01,
 2.07595e-01, 2.54402e-01, 3.02939e-01, 3.52345e-01, 4.01900e-01,
 4.51015e-01, 4.99263e-01, 5.46287e-01, 5.91865e-01, 6.35840e-01,
 6.78048e-01, 7.18403e-01, 7.56866e-01, 7.93373e-01, 8.27912e-01,
 8.60497e-01, 8.91122e-01, 9.19817e-01, 9.46624e-01, 9.71588e-01,
 9.94762e-01, 1.01623e+00, 1.03607e+00, 1.05439e+00, 1.07132e+00,
 1.08694e+00, 1.10137e+00, 1.11469e+00, 1.12697e+00, 1.13828e+00,
 1.14869e+00, 1.15822e+00, 1.16694e+00, 1.17487e+00, 1.18206e+00,
 1.18853e+00, 1.19431e+00, 1.19943e+00, 1.20393e+00, 1.20781e+00,
 1.21112e+00, 1.21388e+00, 1.21611e+00, 1.21787e+00, 1.21919e+00,
 1.22010e+00, 1.22063e+00, 1.22082e+00, 1.22068e+00, 1.22024e+00,
 1.21951e+00, 1.21852e+00, 1.21725e+00, 1.21574e+00, 1.21399e+00,
 1.21199e+00, 1.20977e+00, 1.20730e+00, 1.20460e+00, 1.20167e+00,
 1.19848e+00, 1.19505e+00, 1.19136e+00, 1.18742e+00, 1.18321e+00,
 1.17875e+00, 1.17404e+00, 1.16907e+00, 1.16385e+00, 1.15839e+00,
 1.15269e+00, 1.14675e+00, 1.14058e+00, 1.13418e+00, 1.12757e+00,
 1.12073e+00, 1.11369e+00, 1.10646e+00, 1.09904e+00, 1.09147e+00,
 1.08377e+00, 1.07596e+00, 1.06808e+00, 1.06019e+00, 1.05233e+00,
 1.04458e+00, 1.03701e+00, 1.02971e+00, 1.02279e+00, 1.01635e+00}
,
{6.87480e-05, 7.49742e-04, 3.87737e-03, 1.19088e-02, 2.70457e-02,
 5.07391e-02, 8.34449e-02, 1.24719e-01, 1.73557e-01, 2.28504e-01,
 2.88033e-01, 3.50647e-01, 4.15010e-01, 4.80005e-01, 5.44715e-01,
 6.08435e-01, 6.70646e-01, 7.30946e-01, 7.89121e-01, 8.44928e-01,
 8.98220e-01, 9.48938e-01, 9.96997e-01, 1.04237e+00, 1.08508e+00,
 1.12513e+00, 1.16254e+00, 1.19739e+00, 1.22974e+00, 1.25967e+00,
 1.28731e+00, 1.31277e+00, 1.33622e+00, 1.35783e+00, 1.37772e+00,
 1.39605e+00, 1.41292e+00, 1.42844e+00, 1.44269e+00, 1.45574e+00,
 1.46767e+00, 1.47853e+00, 1.48836e+00, 1.49721e+00, 1.50514e+00,
 1.51217e+00, 1.51836e+00, 1.52372e+00, 1.52832e+00, 1.53218e+00,
 1.53536e+00, 1.53790e+00, 1.53987e+00, 1.54130e+00, 1.54226e+00,
 1.54278e+00, 1.54289e+00, 1.54262e+00, 1.54199e+00, 1.54102e+00,
 1.53973e+00, 1.53812e+00, 1.53622e+00, 1.53402e+00, 1.53153e+00,
 1.52875e+00, 1.52567e+00, 1.52229e+00, 1.51859e+00, 1.51459e+00,
 1.51025e+00, 1.50560e+00, 1.50061e+00, 1.49530e+00, 1.48967e+00,
 1.48372e+00, 1.47745e+00, 1.47087e+00, 1.46396e+00, 1.45674e+00,
 1.44920e+00, 1.44134e+00, 1.43316e+00, 1.42465e+00, 1.41583e+00,
 1.40670e+00, 1.39727e+00, 1.38756e+00, 1.37758e+00, 1.36737e+00,
 1.35697e+00, 1.34643e+00, 1.33579e+00, 1.32515e+00, 1.31457e+00,
 1.30415e+00, 1.29399e+00, 1.28422e+00, 1.27498e+00, 1.26642e+00}
,
{9.68504e-05, 1.10742e-03, 5.71263e-03, 1.73894e-02, 3.91334e-02,
 7.27679e-02, 1.18598e-01, 1.75794e-01, 2.42681e-01, 3.17139e-01,
 3.97003e-01, 4.80232e-01, 5.65075e-01, 6.50098e-01, 7.34159e-01,
 8.16433e-01, 8.96274e-01, 9.73312e-01, 1.04722e+00, 1.11774e+00,
 1.18478e+00, 1.24821e+00, 1.30800e+00, 1.36416e+00, 1.41670e+00,
 1.46566e+00, 1.51115e+00, 1.55324e+00, 1.59206e+00, 1.62779e+00,
 1.66062e+00, 1.69077e+00, 1.71847e+00, 1.74392e+00, 1.76729e+00,
 1.78876e+00, 1.80844e+00, 1.82646e+00, 1.84291e+00, 1.85789e+00,
 1.87145e+00, 1.88368e+00, 1.89463e+00, 1.90438e+00, 1.91296e+00,
 1.92044e+00, 1.92688e+00, 1.93233e+00, 1.93687e+00, 1.94056e+00,
 1.94349e+00, 1.94572e+00, 1.94733e+00, 1.94838e+00, 1.94889e+00,
 1.94893e+00, 1.94851e+00, 1.94766e+00, 1.94641e+00, 1.94478e+00,
 1.94278e+00, 1.94041e+00, 1.93769e+00, 1.93460e+00, 1.93114e+00,
 1.92730e+00, 1.92307e+00, 1.91844e+00, 1.91341e+00, 1.90798e+00,
 1.90214e+00, 1.89590e+00, 1.88926e+00, 1.88223e+00, 1.87480e+00,
 1.86696e+00, 1.85871e+00, 1.85005e+00, 1.84095e+00, 1.83142e+00,
 1.82145e+00, 1.81102e+00, 1.80014e+00, 1.78881e+00, 1.77702e+00,
 1.76479e+00, 1.75214e+00, 1.73910e+00, 1.72571e+00, 1.71201e+00,
 1.69806e+00, 1.68393e+00, 1.66970e+00, 1.65546e+00, 1.64130e+00,
 1.62735e+00, 1.61375e+00, 1.60067e+00, 1.58828e+00, 1.57683e+00}
,
{1.35750e-04, 1.62749e-03, 8.35580e-03, 2.52211e-02, 5.62411e-02,
 1.03641e-01, 1.67429e-01, 2.46146e-01, 3.37147e-01, 4.37403e-01,
 5.43896e-01, 6.53897e-01, 7.65139e-01, 8.75800e-01, 9.84513e-01,
 1.09026e+00, 1.19236e+00, 1.29038e+00, 1.38388e+00, 1.47269e+00,
 1.55665e+00, 1.63566e+00, 1.70976e+00, 1.77893e+00, 1.84326e+00,
 1.90286e+00, 1.95786e+00, 2.00845e+00, 2.05486e+00, 2.09737e+00,
 2.13631e+00, 2.17199e+00, 2.20467e+00, 2.23462e+00, 2.26204e+00,
 2.28712e+00, 2.31000e+00, 2.33082e+00, 2.34969e+00, 2.36671e+00,
 2.38197e+00, 2.39558e+00, 2.40760e+00, 2.41812e+00, 2.42722e+00,
 2.43497e+00, 2.44148e+00, 2.44684e+00, 2.45118e+00, 2.45460e+00,
 2.45719e+00, 2.45903e+00, 2.46019e+00, 2.46073e+00, 2.46069e+00,
 2.46011e+00, 2.45902e+00, 2.45746e+00, 2.45544e+00, 2.45296e+00,
 2.45004e+00, 2.44667e+00, 2.44284e+00, 2.43853e+00, 2.43374e+00,
 2.42846e+00, 2.42269e+00, 2.41641e+00, 2.40965e+00, 2.40240e+00,
 2.39466e+00, 2.38643e+00, 2.37771e+00, 2.36849e+00, 2.35874e+00,
 2.34846e+00, 2.33762e+00, 2.32620e+00, 2.31419e+00, 2.30158e+00,
 2.28834e+00, 2.27447e+00, 2.25996e+00, 2.24482e+00, 2.22908e+00,
 2.21275e+00, 2.19588e+00, 2.17850e+00, 2.16066e+00, 2.14242e+00,
 2.12385e+00, 2.10502e+00, 2.08602e+00, 2.06697e+00, 2.04800e+00,
 2.02926e+00, 2.01096e+00, 1.99331e+00, 1.97658e+00, 1.96110e+00}
,
{1.89858e-04, 2.37659e-03, 1.21529e-02, 3.63436e-02, 8.03090e-02,
 1.46667e-01, 2.34904e-01, 3.42539e-01, 4.65602e-01, 5.99809e-01,
 7.41022e-01, 8.85659e-01, 1.03081e+00, 1.17420e+00, 1.31420e+00,
 1.44960e+00, 1.57973e+00, 1.70393e+00, 1.82183e+00, 1.93325e+00,
 2.03798e+00, 2.13606e+00, 2.22747e+00, 2.31231e+00, 2.39073e+00,
 2.46293e+00, 2.52914e+00, 2.58971e+00, 2.64503e+00, 2.69556e+00,
 2.74172e+00, 2.78389e+00, 2.82243e+00, 2.85762e+00, 2.88971e+00,
 2.91888e+00, 2.94534e+00, 2.96922e+00, 2.99067e+00, 3.00982e+00,
 3.02678e+00, 3.04169e+00, 3.05464e+00, 3.06575e+00, 3.07514e+00,
 3.08297e+00, 3.08938e+00, 3.09454e+00, 3.09859e+00, 3.10164e+00,
 3.10379e+00, 3.10512e+00, 3.10570e+00, 3.10558e+00, 3.10483e+00,
 3.10347e+00, 3.10154e+00, 3.09905e+00, 3.09600e+00, 3.09240e+00,
 3.08822e+00, 3.08346e+00, 3.07810e+00, 3.07213e+00, 3.06556e+00,
 3.05838e+00, 3.05062e+00, 3.04226e+00, 3.03332e+00, 3.02378e+00,
 3.01364e+00, 3.00288e+00, 2.99146e+00, 2.97936e+00, 2.96656e+00,
 2.95302e+00, 2.93872e+00, 2.92361e+00, 2.90769e+00, 2.89092e+00,
 2.87331e+00, 2.85486e+00, 2.83558e+00, 2.81549e+00, 2.79462e+00,
 2.77300e+00, 2.75066e+00, 2.72763e+00, 2.70396e+00, 2.67972e+00,
 2.65497e+00, 2.62981e+00, 2.60436e+00, 2.57876e+00, 2.55320e+00,
 2.52788e+00, 2.50308e+00, 2.47911e+00, 2.45636e+00, 2.43528e+00}
,
{2.65942e-04, 3.45326e-03, 1.75656e-02, 5.20589e-02, 1.14008e-01,
 2.06327e-01, 3.27669e-01, 4.73976e-01, 6.39470e-01, 8.18164e-01,
 1.00448e+00, 1.19377e+00, 1.38233e+00, 1.56741e+00, 1.74700e+00,
 1.91986e+00, 2.08507e+00, 2.24192e+00, 2.39012e+00, 2.52936e+00,
 2.65959e+00, 2.78083e+00, 2.89315e+00, 2.99678e+00, 3.09197e+00,
 3.17905e+00, 3.25848e+00, 3.33081e+00, 3.39669e+00, 3.45669e+00,
 3.51137e+00, 3.56119e+00, 3.60655e+00, 3.64778e+00, 3.68516e+00,
 3.71894e+00, 3.74931e+00, 3.77647e+00, 3.80060e+00, 3.82188e+00,
 3.84044e+00, 3.85646e+00, 3.87010e+00, 3.88156e+00, 3.89106e+00,
 3.89881e+00, 3.90502e+00, 3.90987e+00, 3.91351e+00, 3.91606e+00,
 3.91762e+00, 3.91827e+00, 3.91809e+00, 3.91715e+00, 3.91548e+00,
 3.91311e+00, 3.91005e+00, 3.90629e+00, 3.90182e+00, 3.89663e+00,
 3.89070e+00, 3.88402e+00, 3.87660e+00, 3.86846e+00, 3.85960e+00,
 3.85003e+00, 3.83976e+00, 3.82878e+00, 3.81707e+00, 3.80459e+00,
 3.79131e+00, 3.77719e+00, 3.76219e+00, 3.74626e+00, 3.72935e+00,
 3.71143e+00, 3.69246e+00, 3.67241e+00, 3.65128e+00, 3.62906e+00,
 3.60577e+00, 3.58140e+00, 3.55598e+00, 3.52951e+00, 3.50199e+00,
 3.47344e+00, 3.44388e+00, 3.41333e+00, 3.38186e+00, 3.34951e+00,
 3.31639e+00, 3.28261e+00, 3.24833e+00, 3.21375e+00, 3.17912e+00,
 3.14476e+00, 3.11104e+00, 3.07844e+00, 3.04747e+00, 3.01879e+00}
,
{3.72544e-04, 4.99872e-03, 2.52483e-02, 7.41528e-02, 1.60940e-01,
 2.88648e-01, 4.54608e-01, 6.52405e-01, 8.73812e-01, 1.11057e+00,
 1.35528e+00, 1.60196e+00, 1.84594e+00, 2.08395e+00, 2.31360e+00,
 2.53358e+00, 2.74263e+00, 2.94016e+00, 3.12578e+00, 3.29923e+00,
 3.46058e+00, 3.60988e+00, 3.74739e+00, 3.87347e+00, 3.98853e+00,
 4.09321e+00, 4.18826e+00, 4.27456e+00, 4.35294e+00, 4.42416e+00,
 4.48887e+00, 4.54762e+00, 4.60086e+00, 4.64897e+00, 4.69230e+00,
 4.73111e+00, 4.76568e+00, 4.79627e+00, 4.82307e+00, 4.84633e+00,
 4.86628e+00, 4.88315e+00, 4.89724e+00, 4.90886e+00, 4.91832e+00,
 4.92587e+00, 4.93177e+00, 4.93617e+00, 4.93924e+00, 4.94110e+00,
 4.94187e+00, 4.94164e+00, 4.94048e+00, 4.93843e+00, 4.93552e+00,
 4.93173e+00, 4.92707e+00, 4.92150e+00, 4.91502e+00, 4.90762e+00,
 4.89932e+00, 4.89013e+00, 4.88008e+00, 4.86918e+00, 4.85745e+00,
 4.84486e+00, 4.83139e+00, 4.81699e+00, 4.80163e+00, 4.78523e+00,
 4.76775e+00, 4.74912e+00, 4.72927e+00, 4.70816e+00, 4.68573e+00,
 4.66196e+00, 4.63683e+00, 4.61035e+00, 4.58251e+00, 4.55329e+00,
 4.52269e+00, 4.49069e+00, 4.45726e+00, 4.42239e+00, 4.38604e+00,
 4.34823e+00, 4.30896e+00, 4.26825e+00, 4.22617e+00, 4.18278e+00,
 4.13823e+00, 4.09267e+00, 4.04635e+00, 3.99955e+00, 3.95263e+00,
 3.90602e+00, 3.86025e+00, 3.81591e+00, 3.77373e+00, 3.73457e+00}
,
{5.21320e-04, 7.20039e-03, 3.61112e-02, 1.05066e-01, 2.26019e-01,
 4.01752e-01, 6.27552e-01, 8.93628e-01, 1.18843e+00, 1.50070e+00,
 1.82077e+00, 2.14098e+00, 2.45561e+00, 2.76064e+00, 3.05353e+00,
 3.33253e+00, 3.59630e+00, 3.84432e+00, 4.07604e+00, 4.29149e+00,
 4.49067e+00, 4.67389e+00, 4.84162e+00, 4.99439e+00, 5.13304e+00,
 5.25857e+00, 5.37220e+00, 5.47508e+00, 5.56829e+00, 5.65274e+00,
 5.72920e+00, 5.79828e+00, 5.86053e+00, 5.91639e+00, 5.96626e+00,
 6.01050e+00, 6.04945e+00, 6.08345e+00, 6.11278e+00, 6.13778e+00,
 6.15880e+00, 6.17627e+00, 6.19063e+00, 6.20227e+00, 6.21156e+00,
 6.21878e+00, 6.22417e+00, 6.22791e+00, 6.23018e+00, 6.23112e+00,
 6.23085e+00, 6.22944e+00, 6.22692e+00, 6.22331e+00, 6.21860e+00,
 6.21277e+00, 6.20580e+00, 6.19769e+00, 6.18846e+00, 6.17816e+00,
 6.16681e+00, 6.15444e+00, 6.14107e+00, 6.12668e+00, 6.11123e+00,
 6.09468e+00, 6.07695e+00, 6.05798e+00, 6.03769e+00, 6.01598e+00,
 5.99279e+00, 5.96804e+00, 5.94167e+00, 5.91366e+00, 5.88400e+00,
 5.85266e+00, 5.81965e+00, 5.78492e+00, 5.74843e+00, 5.71013e+00,
 5.66996e+00, 5.62785e+00, 5.58374e+00, 5.53758e+00, 5.48933e+00,
 5.43897e+00, 5.38650e+00, 5.33196e+00, 5.27543e+00, 5.21705e+00,
 5.15702e+00, 5.09558e+00, 5.03304e+00, 4.96978e+00, 4.90625e+00,
 4.84301e+00, 4.78074e+00, 4.72022e+00, 4.66243e+00, 4.60854e+00}
,
{7.28154e-04, 1.03160e-02, 5.13761e-02, 1.48152e-01, 3.15844e-01,
 5.56511e-01, 8.62222e-01, 1.21850e+00, 1.60930e+00, 2.01948e+00,
 2.43652e+00, 2.85070e+00, 3.25513e+00, 3.64496e+00, 4.01746e+00,
 4.37027e+00, 4.70228e+00, 5.01268e+00, 5.30118e+00, 5.56788e+00,
 5.81297e+00, 6.03707e+00, 6.24089e+00, 6.42544e+00, 6.59209e+00,
 6.74245e+00, 6.87819e+00, 7.00079e+00, 7.11155e+00, 7.21154e+00,
 7.30163e+00, 7.38257e+00, 7.45498e+00, 7.51940e+00, 7.57635e+00,
 7.62631e+00, 7.66967e+00, 7.70690e+00, 7.73846e+00, 7.76486e+00,
 7.78670e+00, 7.80460e+00, 7.81908e+00, 7.83061e+00, 7.83954e+00,
 7.84619e+00, 7.85081e+00, 7.85363e+00, 7.85481e+00, 7.85450e+00,
 7.85277e+00, 7.84965e+00, 7.84515e+00, 7.83924e+00, 7.83190e+00,
 7.82314e+00, 7.81298e+00, 7.80149e+00, 7.78871e+00, 7.77470e+00,
 7.75949e+00, 7.74307e+00, 7.72538e+00, 7.70637e+00, 7.68596e+00,
 7.66405e+00, 7.64054e+00, 7.61533e+00, 7.58830e+00, 7.55937e+00,
 7.52849e+00, 7.49562e+00, 7.46075e+00, 7.42386e+00, 7.38492e+00,
 7.34388e+00, 7.30066e+00, 7.25516e+00, 7.20728e+00, 7.15688e+00,
 7.10387e+00, 7.04813e+00, 6.98956e+00, 6.92808e+00, 6.86364e+00,
 6.79621e+00, 6.72584e+00, 6.65261e+00, 6.57666e+00, 6.49817e+00,
 6.41737e+00, 6.33455e+00, 6.25008e+00, 6.16442e+00, 6.07814e+00,
 5.99196e+00, 5.90677e+00, 5.82364e+00, 5.74389e+00, 5.66911e+00}
,
{1.01462e-03, 1.47244e-02, 7.27764e-02, 2.07930e-01, 4.39344e-01,
 7.67447e-01, 1.17946e+00, 1.65448e+00, 2.17041e+00, 2.70719e+00,
 3.24867e+00, 3.78273e+00, 4.30103e+00, 4.79804e+00, 5.27039e+00,
 5.71546e+00, 6.13218e+00, 6.51961e+00, 6.87781e+00, 7.20689e+00,
 7.50755e+00, 7.78071e+00, 8.02761e+00, 8.24999e+00, 8.45002e+00,
 8.63004e+00, 8.79211e+00, 8.93810e+00, 9.06952e+00, 9.18762e+00,
 9.29341e+00, 9.38780e+00, 9.47150e+00, 9.54525e+00, 9.60970e+00,
 9.66540e+00, 9.71301e+00, 9.75315e+00, 9.78658e+00, 9.81414e+00,
 9.83663e+00, 9.85480e+00, 9.86923e+00, 9.88039e+00, 9.88869e+00,
 9.89445e+00, 9.89798e+00, 9.89950e+00, 9.89915e+00, 9.89701e+00,
 9.89311e+00, 9.88743e+00, 9.87996e+00, 9.87069e+00, 9.85965e+00,
 9.84693e+00, 9.83261e+00, 9.81677e+00, 9.79948e+00, 9.78074e+00,
 9.76049e+00, 9.73866e+00, 9.71517e+00, 9.68988e+00, 9.66267e+00,
 9.63341e+00, 9.60195e+00, 9.56819e+00, 9.53208e+00, 9.49357e+00,
 9.45267e+00, 9.40936e+00, 9.36358e+00, 9.31526e+00, 9.26428e+00,
 9.21048e+00, 9.15372e+00, 9.09380e+00, 9.03054e+00, 8.96377e+00,
 8.89332e+00, 8.81903e+00, 8.74078e+00, 8.65850e+00, 8.57216e+00,
 8.48178e+00, 8.38743e+00, 8.28919e+00, 8.18718e+00, 8.08158e+00,
 7.97263e+00, 7.86066e+00, 7.74612e+00, 7.62957e+00, 7.51177e+00,
 7.39368e+00, 7.27649e+00, 7.16168e+00, 7.05107e+00, 6.94689e+00}
,
{1.40995e-03, 2.09412e-02, 1.02647e-01, 2.90602e-01, 6.08476e-01,
 1.05390e+00, 1.60682e+00, 2.23763e+00, 2.91621e+00, 3.61619e+00,
 4.31702e+00, 5.00373e+00, 5.66614e+00, 6.29830e+00, 6.89569e+00,
 7.45592e+00, 7.97749e+00, 8.45991e+00, 8.90328e+00, 9.30820e+00,
 9.67588e+00, 1.00078e+01, 1.03061e+01, 1.05737e+01, 1.08136e+01,
 1.10290e+01, 1.12224e+01, 1.13960e+01, 1.15516e+01, 1.16907e+01,
 1.18144e+01, 1.19238e+01, 1.20199e+01, 1.21036e+01, 1.21756e+01,
 1.22370e+01, 1.22885e+01, 1.23311e+01, 1.23662e+01, 1.23947e+01,
 1.24177e+01, 1.24359e+01, 1.24500e+01, 1.24604e+01, 1.24677e+01,
 1.24722e+01, 1.24742e+01, 1.24738e+01, 1.24711e+01, 1.24662e+01,
 1.24590e+01, 1.24495e+01, 1.24377e+01, 1.24238e+01, 1.24078e+01,
 1.23900e+01, 1.23703e+01, 1.23489e+01, 1.23257e+01, 1.23007e+01,
 1.22736e+01, 1.22444e+01, 1.22129e+01, 1.21789e+01, 1.21423e+01,
 1.21029e+01, 1.20607e+01, 1.20156e+01, 1.19676e+01, 1.19168e+01,
 1.18630e+01, 1.18062e+01, 1.17462e+01, 1.16828e+01, 1.16157e+01,
 1.15447e+01, 1.14696e+01, 1.13901e+01, 1.13058e+01, 1.12167e+01,
 1.11225e+01, 1.10230e+01, 1.09183e+01, 1.08081e+01, 1.06924e+01,
 1.05713e+01, 1.04447e+01, 1.03127e+01, 1.01753e+01, 1.00326e+01,
 9.88502e+00, 9.73287e+00, 9.57673e+00, 9.41738e+00, 9.25583e+00,
 9.09341e+00, 8.93177e+00, 8.77298e+00, 8.61953e+00, 8.47445e+00}
,
{1.95712e-03, 2.96589e-02, 1.44155e-01, 4.04459e-01, 8.39307e-01,
 1.44157e+00, 2.18066e+00, 3.01524e+00, 3.90462e+00, 4.81455e+00,
 5.71891e+00, 6.59955e+00, 7.44430e+00, 8.24631e+00, 9.00017e+00,
 9.70363e+00, 1.03549e+01, 1.09540e+01, 1.15013e+01, 1.19982e+01,
 1.24464e+01, 1.28487e+01, 1.32085e+01, 1.35301e+01, 1.38179e+01,
 1.40754e+01, 1.43060e+01, 1.45121e+01, 1.46958e+01, 1.48589e+01,
 1.50027e+01, 1.51287e+01, 1.52381e+01, 1.53321e+01, 1.54117e+01,
 1.54783e+01, 1.55332e+01, 1.55782e+01, 1.56147e+01, 1.56441e+01,
 1.56673e+01, 1.56851e+01, 1.56984e+01, 1.57077e+01, 1.57134e+01,
 1.57159e+01, 1.57155e+01, 1.57121e+01, 1.57059e+01, 1.56967e+01,
 1.56846e+01, 1.56696e+01, 1.56520e+01, 1.56320e+01, 1.56098e+01,
 1.55853e+01, 1.55587e+01, 1.55299e+01, 1.54986e+01, 1.54649e+01,
 1.54284e+01, 1.53889e+01, 1.53463e+01, 1.53003e+01, 1.52508e+01,
 1.51979e+01, 1.51416e+01, 1.50819e+01, 1.50187e+01, 1.49518e+01,
 1.48812e+01, 1.48064e+01, 1.47273e+01, 1.46434e+01, 1.45544e+01,
 1.44599e+01, 1.43597e+01, 1.42533e+01, 1.41405e+01, 1.40210e+01,
 1.38948e+01, 1.37616e+01, 1.36212e+01, 1.34736e+01, 1.33184e+01,
 1.31556e+01, 1.29851e+01, 1.28067e+01, 1.26206e+01, 1.24269e+01,
 1.22259e+01, 1.20182e+01, 1.18046e+01, 1.15861e+01, 1.13643e+01,
 1.11409e+01, 1.09182e+01, 1.06988e+01, 1.04863e+01, 1.02846e+01}
,
{2.71997e-03, 4.18270e-02, 2.01713e-01, 5.60817e-01, 1.15328e+00,
 1.96450e+00, 2.94886e+00, 4.04918e+00, 5.21110e+00, 6.39048e+00,
 7.55442e+00, 8.68088e+00, 9.75598e+00, 1.07711e+01, 1.17205e+01,
 1.26016e+01, 1.34131e+01, 1.41551e+01, 1.48290e+01, 1.54370e+01,
 1.59820e+01, 1.64685e+01, 1.69020e+01, 1.72885e+01, 1.76334e+01,
 1.79412e+01, 1.82156e+01, 1.84596e+01, 1.86758e+01, 1.88660e+01,
 1.90323e+01, 1.91763e+01, 1.92996e+01, 1.94038e+01, 1.94906e+01,
 1.95621e+01, 1.96203e+01, 1.96674e+01, 1.97052e+01, 1.97350e+01,
 1.97579e+01, 1.97749e+01, 1.97868e+01, 1.97942e+01, 1.97976e+01,
 1.97971e+01, 1.97928e+01, 1.97848e+01, 1.97730e+01, 1.97575e+01,
 1.97385e+01, 1.97163e+01, 1.96912e+01, 1.96633e+01, 1.96328e+01,
 1.95996e+01, 1.95635e+01, 1.95244e+01, 1.94820e+01, 1.94361e+01,
 1.93864e+01, 1.93326e+01, 1.92746e+01, 1.92125e+01, 1.91462e+01,
 1.90758e+01, 1.90013e+01, 1.89225e+01, 1.88392e+01, 1.87510e+01,
 1.86575e+01, 1.85584e+01, 1.84530e+01, 1.83410e+01, 1.82219e+01,
 1.80952e+01, 1.79606e+01, 1.78177e+01, 1.76663e+01, 1.75062e+01,
 1.73369e+01, 1.71583e+01, 1.69698e+01, 1.67711e+01, 1.65619e+01,
 1.63419e+01, 1.61108e+01, 1.58685e+01, 1.56151e+01, 1.53509e+01,
 1.50764e+01, 1.47923e+01, 1.44999e+01, 1.42006e+01, 1.38963e+01,
 1.35895e+01, 1.32831e+01, 1.29807e+01, 1.26869e+01, 1.24070e+01}
,
{3.78037e-03, 5.88133e-02, 2.81200e-01, 7.74754e-01, 1.57905e+00,
 2.66776e+00, 3.97426e+00, 5.42024e+00, 6.93376e+00, 8.45814e+00,
 9.95268e+00, 1.13903e+01, 1.27558e+01, 1.40378e+01, 1.52311e+01,
 1.63323e+01, 1.73410e+01, 1.82579e+01, 1.90856e+01, 1.98275e+01,
 2.04887e+01, 2.10763e+01, 2.15984e+01, 2.20626e+01, 2.24757e+01,
 2.28430e+01, 2.31689e+01, 2.34570e+01, 2.37101e+01, 2.39309e+01,
 2.41217e+01, 2.42848e+01, 2.44223e+01, 2.45365e+01, 2.46301e+01,
 2.47062e+01, 2.47675e+01, 2.48166e+01, 2.48551e+01, 2.48848e+01,
 2.49068e+01, 2.49222e+01, 2.49319e+01, 2.49364e+01, 2.49359e+01,
 2.49305e+01, 2.49202e+01, 2.49051e+01, 2.48853e+01, 2.48612e+01,
 2.48331e+01, 2.48014e+01, 2.47664e+01, 2.47281e+01, 2.46864e+01,
 2.46411e+01, 2.45919e+01, 2.45384e+01, 2.44804e+01, 2.44174e+01,
 2.43493e+01, 2.42761e+01, 2.41979e+01, 2.41147e+01, 2.40266e+01,
 2.39334e+01, 2.38348e+01, 2.37305e+01, 2.36199e+01, 2.35026e+01,
 2.33778e+01, 2.32449e+01, 2.31034e+01, 2.29527e+01, 2.27922e+01,
 2.26216e+01, 2.24405e+01, 2.22486e+01, 2.20453e+01, 2.18301e+01,
 2.16024e+01, 2.13616e+01, 2.11070e+01, 2.08381e+01, 2.05542e+01,
 2.02550e+01, 1.99402e+01, 1.96097e+01, 1.92638e+01, 1.89029e+01,
 1.85278e+01, 1.81397e+01, 1.77398e+01, 1.73303e+01, 1.69136e+01,
 1.64930e+01, 1.60723e+01, 1.56565e+01, 1.52518e+01, 1.48656e+01}
,
{5.24965e-03, 8.24432e-02, 3.90614e-01, 1.06665e+00, 2.15472e+00,
 3.61083e+00, 5.33937e+00, 7.23386e+00, 9.19993e+00, 1.11653e+01,
 1.30799e+01, 1.49114e+01, 1.66418e+01, 1.82580e+01, 1.97546e+01,
 2.11282e+01, 2.23792e+01, 2.35095e+01, 2.45235e+01, 2.54267e+01,
 2.62276e+01, 2.69368e+01, 2.75652e+01, 2.81225e+01, 2.86168e+01,
 2.90545e+01, 2.94405e+01, 2.97792e+01, 3.00741e+01, 3.03288e+01,
 3.05459e+01, 3.07287e+01, 3.08802e+01, 3.10040e+01, 3.11043e+01,
 3.11849e+01, 3.12492e+01, 3.12996e+01, 3.13383e+01, 3.13670e+01,
 3.13873e+01, 3.14000e+01, 3.14060e+01, 3.14056e+01, 3.13989e+01,
 3.13858e+01, 3.13664e+01, 3.13411e+01, 3.13104e+01, 3.12748e+01,
 3.12349e+01, 3.11908e+01, 3.11426e+01, 3.10900e+01, 3.10327e+01,
 3.09704e+01, 3.09026e+01, 3.08289e+01, 3.07488e+01, 3.06625e+01,
 3.05698e+01, 3.04712e+01, 3.03665e+01, 3.02559e+01, 3.01389e+01,
 3.00151e+01, 2.98840e+01, 2.97447e+01, 2.95966e+01, 2.94388e+01,
 2.92705e+01, 2.90910e+01, 2.88997e+01, 2.86961e+01, 2.84796e+01,
 2.82498e+01, 2.80060e+01, 2.77474e+01, 2.74733e+01, 2.71825e+01,
 2.68742e+01, 2.65475e+01, 2.62013e+01, 2.58350e+01, 2.54478e+01,
 2.50394e+01, 2.46095e+01, 2.41582e+01, 2.36860e+01, 2.31935e+01,
 2.26815e+01, 2.21516e+01, 2.16056e+01, 2.10462e+01, 2.04769e+01,
 1.99018e+01, 1.93267e+01, 1.87581e+01, 1.82045e+01, 1.76760e+01}
,
{7.27890e-03, 1.15173e-01, 5.40896e-01, 1.46370e+00, 2.93094e+00,
 4.87212e+00, 7.15212e+00, 9.62723e+00, 1.21746e+01, 1.47028e+01,
 1.71502e+01, 1.94794e+01, 2.16679e+01, 2.37021e+01, 2.55751e+01,
 2.72851e+01, 2.88331e+01, 3.02235e+01, 3.14626e+01, 3.25601e+01,
 3.35291e+01, 3.43846e+01, 3.51408e+01, 3.58095e+01, 3.64002e+01,
 3.69203e+01, 3.73761e+01, 3.77725e+01, 3.81142e+01, 3.84056e+01,
 3.86505e+01, 3.88532e+01, 3.90184e+01, 3.91518e+01, 3.92586e+01,
 3.93436e+01, 3.94101e+01, 3.94611e+01, 3.94990e+01, 3.95258e+01,
 3.95428e+01, 3.95511e+01, 3.95509e+01, 3.95426e+01, 3.95259e+01,
 3.95012e+01, 3.94689e+01, 3.94299e+01, 3.93848e+01, 3.93343e+01,
 3.92786e+01, 3.92176e+01, 3.91510e+01, 3.90783e+01, 3.89992e+01,
 3.89128e+01, 3.88188e+01, 3.87168e+01, 3.86070e+01, 3.84897e+01,
 3.83650e+01, 3.82330e+01, 3.80936e+01, 3.79462e+01, 3.77900e+01,
 3.76243e+01, 3.74480e+01, 3.72602e+01, 3.70597e+01, 3.68458e+01,
 3.66174e+01, 3.63740e+01, 3.61150e+01, 3.58397e+01, 3.55473e+01,
 3.52369e+01, 3.49071e+01, 3.45568e+01, 3.41846e+01, 3.37890e+01,
 3.33688e+01, 3.29227e+01, 3.24496e+01, 3.19487e+01, 3.14193e+01,
 3.08612e+01, 3.02742e+01, 2.96584e+01, 2.90142e+01, 2.83425e+01,
 2.76445e+01, 2.69222e+01, 2.61784e+01, 2.54167e+01, 2.46420e+01,
 2.38604e+01, 2.30794e+01, 2.23085e+01, 2.15590e+01, 2.08444e+01}
,
{1.00726e-02, 1.60354e-01, 7.46577e-01, 2.00225e+00, 3.97475e+00,
 6.55477e+00, 9.55364e+00, 1.27789e+01, 1.60717e+01, 1.93168e+01,
 2.24395e+01, 2.53964e+01, 2.81593e+01, 3.07147e+01, 3.30546e+01,
 3.51791e+01, 3.70907e+01, 3.87970e+01, 4.03082e+01, 4.16398e+01,
 4.28115e+01, 4.38433e+01, 4.47528e+01, 4.55543e+01, 4.62588e+01,
 4.68753e+01, 4.74111e+01, 4.78727e+01, 4.82662e+01, 4.85967e+01,
 4.88701e+01, 4.90926e+01, 4.92716e+01, 4.94145e+01, 4.95278e+01,
 4.96164e+01, 4.96843e+01, 4.97348e+01, 4.97705e+01, 4.97935e+01,
 4.98050e+01, 4.98056e+01, 4.97954e+01, 4.97745e+01, 4.97431e+01,
 4.97020e+01, 4.96523e+01, 4.95952e+01, 4.95311e+01, 4.94606e+01,
 4.93832e+01, 4.92986e+01, 4.92062e+01, 4.91052e+01, 4.89949e+01,
 4.88747e+01, 4.87446e+01, 4.86048e+01, 4.84558e+01, 4.82979e+01,
 4.81310e+01, 4.79547e+01, 4.77681e+01, 4.75702e+01, 4.73598e+01,
 4.71356e+01, 4.68964e+01, 4.66408e+01, 4.63677e+01, 4.60763e+01,
 4.57660e+01, 4.54358e+01, 4.50848e+01, 4.47118e+01, 4.43152e+01,
 4.38933e+01, 4.34443e+01, 4.29662e+01, 4.24573e+01, 4.19158e+01,
 4.13400e+01, 4.07286e+01, 4.00806e+01, 3.93951e+01, 3.86714e+01,
 3.79091e+01, 3.71080e+01, 3.62682e+01, 3.53903e+01, 3.44755e+01,
 3.35261e+01, 3.25448e+01, 3.15358e+01, 3.05045e+01, 2.94578e+01,
 2.84042e+01, 2.73544e+01, 2.63208e+01, 2.53186e+01, 2.43657e+01}
,
{1.39070e-02, 2.22702e-01, 1.02740e+00, 2.73089e+00, 5.37490e+00,
 8.79418e+00, 1.27280e+01, 1.69205e+01, 2.11672e+01, 2.53248e+01,
 2.93020e+01, 3.30490e+01, 3.65318e+01, 3.97361e+01, 4.26545e+01,
 4.52883e+01, 4.76443e+01, 4.97337e+01, 5.15735e+01, 5.31877e+01,
 5.46039e+01, 5.58479e+01, 5.69411e+01, 5.79003e+01, 5.87385e+01,
 5.94667e+01, 6.00939e+01, 6.06283e+01, 6.10777e+01, 6.14494e+01,
 6.17516e+01, 6.19941e+01, 6.21871e+01, 6.23396e+01, 6.24587e+01,
 6.25499e+01, 6.26178e+01, 6.26661e+01, 6.26975e+01, 6.27139e+01,
 6.27159e+01, 6.27038e+01, 6.26777e+01, 6.26380e+01, 6.25859e+01,
 6.25229e+01, 6.24503e+01, 6.23691e+01, 6.22795e+01, 6.21812e+01,
 6.20735e+01, 6.19556e+01, 6.18265e+01, 6.16853e+01, 6.15314e+01,
 6.13651e+01, 6.11869e+01, 6.09975e+01, 6.07970e+01, 6.05853e+01,
 6.03615e+01, 6.01244e+01, 5.98725e+01, 5.96043e+01, 5.93181e+01,
 5.90122e+01, 5.86852e+01, 5.83357e+01, 5.79631e+01, 5.75664e+01,
 5.71444e+01, 5.66956e+01, 5.62181e+01, 5.57097e+01, 5.51680e+01,
 5.45905e+01, 5.39748e+01, 5.33184e+01, 5.26190e+01, 5.18749e+01,
 5.10843e+01, 5.02458e+01, 4.93583e+01, 4.84205e+01, 4.74317e+01,
 4.63911e+01, 4.52987e+01, 4.41549e+01, 4.29612e+01, 4.17196e+01,
 4.04337e+01, 3.91080e+01, 3.77489e+01, 3.63642e+01, 3.49635e+01,
 3.35586e+01, 3.21636e+01, 3.07953e+01, 2.94737e+01, 2.82223e+01}
,
{1.91699e-02, 3.08472e-01, 1.41003e+00, 3.71407e+00, 7.24848e+00,
 1.17679e+01, 1.69152e+01, 2.23525e+01, 2.78183e+01, 3.31349e+01,
 3.81932e+01, 4.29329e+01, 4.73167e+01, 5.13274e+01, 5.49609e+01,
 5.82204e+01, 6.11181e+01, 6.36716e+01, 6.59084e+01, 6.78641e+01,
 6.95755e+01, 7.10746e+01, 7.23872e+01, 7.35327e+01, 7.45275e+01,
 7.53842e+01, 7.61147e+01, 7.67294e+01, 7.72384e+01, 7.76523e+01,
 7.79838e+01, 7.82469e+01, 7.84541e+01, 7.86157e+01, 7.87394e+01,
 7.88316e+01, 7.88975e+01, 7.89409e+01, 7.89645e+01, 7.89692e+01,
 7.89555e+01, 7.89234e+01, 7.88736e+01, 7.88078e+01, 7.87279e+01,
 7.86359e+01, 7.85329e+01, 7.84190e+01, 7.82939e+01, 7.81566e+01,
 7.80060e+01, 7.78407e+01, 7.76597e+01, 7.74625e+01, 7.72498e+01,
 7.70224e+01, 7.67811e+01, 7.65261e+01, 7.62567e+01, 7.59717e+01,
 7.56694e+01, 7.53477e+01, 7.50047e+01, 7.46380e+01, 7.42457e+01,
 7.38260e+01, 7.33779e+01, 7.29004e+01, 7.23920e+01, 7.18512e+01,
 7.12754e+01, 7.06621e+01, 7.00082e+01, 6.93104e+01, 6.85655e+01,
 6.77703e+01, 6.69217e+01, 6.60170e+01, 6.50542e+01, 6.40310e+01,
 6.29456e+01, 6.17962e+01, 6.05811e+01, 5.92989e+01, 5.79487e+01,
 5.65302e+01, 5.50439e+01, 5.34914e+01, 5.18752e+01, 5.01996e+01,
 4.84701e+01, 4.66940e+01, 4.48802e+01, 4.30399e+01, 4.11862e+01,
 3.93350e+01, 3.75052e+01, 3.57189e+01, 3.40021e+01, 3.23854e+01}
,
{2.64269e-02, 4.26062e-01, 1.92981e+00, 5.03789e+00, 9.74990e+00,
 1.57083e+01, 2.24276e+01, 2.94643e+01, 3.64857e+01, 4.32725e+01,
 4.96962e+01, 5.56823e+01, 6.11916e+01, 6.62042e+01, 7.07198e+01,
 7.47461e+01, 7.83031e+01, 8.14190e+01, 8.41359e+01, 8.65045e+01,
 8.85719e+01, 9.03772e+01, 9.19507e+01, 9.33161e+01, 9.44925e+01,
 9.54962e+01, 9.63422e+01, 9.70438e+01, 9.76152e+01, 9.80725e+01,
 9.84343e+01, 9.87186e+01, 9.89399e+01, 9.91092e+01, 9.92356e+01,
 9.93264e+01, 9.93872e+01, 9.94215e+01, 9.94311e+01, 9.94164e+01,
 9.93777e+01, 9.93159e+01, 9.92331e+01, 9.91322e+01, 9.90156e+01,
 9.88849e+01, 9.87402e+01, 9.85808e+01, 9.84057e+01, 9.82131e+01,
 9.80014e+01, 9.77693e+01, 9.75167e+01, 9.72445e+01, 9.69541e+01,
 9.66463e+01, 9.63212e+01, 9.59776e+01, 9.56137e+01, 9.52271e+01,
 9.48151e+01, 9.43751e+01, 9.39040e+01, 9.33996e+01, 9.28603e+01,
 9.22846e+01, 9.16713e+01, 9.10184e+01, 9.03232e+01, 8.95825e+01,
 8.87923e+01, 8.79487e+01, 8.70473e+01, 8.60838e+01, 8.50543e+01,
 8.39552e+01, 8.27834e+01, 8.15361e+01, 8.02108e+01, 7.88047e+01,
 7.73154e+01, 7.57406e+01, 7.40784e+01, 7.23277e+01, 7.04883e+01,
 6.85608e+01, 6.65474e+01, 6.44517e+01, 6.22788e+01, 6.00355e+01,
 5.77306e+01, 5.53743e+01, 5.29796e+01, 5.05616e+01, 4.81382e+01,
 4.57307e+01, 4.33639e+01, 4.10665e+01, 3.88720e+01, 3.68190e+01}
,
{3.64115e-02, 5.86853e-01, 2.63452e+00, 6.81602e+00, 1.30823e+01,
 2.09192e+01, 2.96707e+01, 3.87592e+01, 4.77631e+01, 5.64132e+01,
 6.45588e+01, 7.21087e+01, 7.90213e+01, 8.52771e+01, 9.08787e+01,
 9.58439e+01, 1.00202e+02, 1.03999e+02, 1.07297e+02, 1.10165e+02,
 1.12662e+02, 1.14833e+02, 1.16716e+02, 1.18339e+02, 1.19726e+02,
 1.20896e+02, 1.21869e+02, 1.22663e+02, 1.23299e+02, 1.23802e+02,
 1.24195e+02, 1.24501e+02, 1.24735e+02, 1.24910e+02, 1.25037e+02,
 1.25122e+02, 1.25173e+02, 1.25191e+02, 1.25177e+02, 1.25131e+02,
 1.25055e+02, 1.24952e+02, 1.24825e+02, 1.24677e+02, 1.24511e+02,
 1.24328e+02, 1.24125e+02, 1.23902e+02, 1.23655e+02, 1.23384e+02,
 1.23087e+02, 1.22763e+02, 1.22415e+02, 1.22044e+02, 1.21651e+02,
 1.21236e+02, 1.20796e+02, 1.20331e+02, 1.19835e+02, 1.19307e+02,
 1.18741e+02, 1.18135e+02, 1.17485e+02, 1.16791e+02, 1.16050e+02,
 1.15261e+02, 1.14421e+02, 1.13525e+02, 1.12570e+02, 1.11549e+02,
 1.10458e+02, 1.09291e+02, 1.08042e+02, 1.06707e+02, 1.05281e+02,
 1.03761e+02, 1.02144e+02, 1.00426e+02, 9.86026e+01, 9.66716e+01,
 9.46299e+01, 9.24753e+01, 9.02067e+01, 8.78240e+01, 8.53288e+01,
 8.27243e+01, 8.00154e+01, 7.72089e+01, 7.43133e+01, 7.13389e+01,
 6.82984e+01, 6.52069e+01, 6.20819e+01, 5.89442e+01, 5.58179e+01,
 5.27307e+01, 4.97145e+01, 4.68060e+01, 4.40472e+01, 4.14859e+01}
,
{5.01127e-02, 8.06580e-01, 3.58805e+00, 9.19965e+00, 1.75126e+01,
 2.77967e+01, 3.91719e+01, 5.08883e+01, 6.24157e+01, 7.34246e+01,
 8.37383e+01, 9.32486e+01, 1.01908e+02, 1.09704e+02, 1.16642e+02,
 1.22753e+02, 1.28085e+02, 1.32707e+02, 1.36710e+02, 1.40182e+02,
 1.43194e+02, 1.45803e+02, 1.48052e+02, 1.49975e+02, 1.51602e+02,
 1.52958e+02, 1.54070e+02, 1.54962e+02, 1.55666e+02, 1.56216e+02,
 1.56642e+02, 1.56969e+02, 1.57213e+02, 1.57391e+02, 1.57513e+02,
 1.57587e+02, 1.57619e+02, 1.57608e+02, 1.57557e+02, 1.57465e+02,
 1.57337e+02, 1.57177e+02, 1.56991e+02, 1.56781e+02, 1.56548e+02,
 1.56290e+02, 1.56006e+02, 1.55692e+02, 1.55345e+02, 1.54964e+02,
 1.54550e+02, 1.54104e+02, 1.53629e+02, 1.53127e+02, 1.52596e+02,
 1.52035e+02, 1.51438e+02, 1.50802e+02, 1.50123e+02, 1.49394e+02,
 1.48613e+02, 1.47776e+02, 1.46882e+02, 1.45928e+02, 1.44911e+02,
 1.43828e+02, 1.42671e+02, 1.41436e+02, 1.40115e+02, 1.38701e+02,
 1.37186e+02, 1.35565e+02, 1.33831e+02, 1.31980e+02, 1.30008e+02,
 1.27909e+02, 1.25679e+02, 1.23313e+02, 1.20808e+02, 1.18160e+02,
 1.15367e+02, 1.12429e+02, 1.09346e+02, 1.06120e+02, 1.02758e+02,
 9.92663e+01, 9.56532e+01, 9.19299e+01, 8.81096e+01, 8.42076e+01,
 8.02421e+01, 7.62341e+01, 7.22078e+01, 6.81906e+01, 6.42139e+01,
 6.03130e+01, 5.65282e+01, 5.29044e+01, 4.94930e+01, 4.69383e+01}
,
{6.88647e-02, 1.10607e+00, 4.87499e+00, 1.23884e+01, 2.33912e+01,
 3.68581e+01, 5.16137e+01, 6.66914e+01, 8.14265e+01, 9.54202e+01,
 1.08460e+02, 1.20424e+02, 1.31258e+02, 1.40956e+02, 1.49536e+02,
 1.57047e+02, 1.63560e+02, 1.69183e+02, 1.74041e+02, 1.78241e+02,
 1.81874e+02, 1.85003e+02, 1.87682e+02, 1.89953e+02, 1.91853e+02,
 1.93415e+02, 1.94675e+02, 1.95670e+02, 1.96445e+02, 1.97045e+02,
 1.97504e+02, 1.97849e+02, 1.98101e+02, 1.98276e+02, 1.98387e+02,
 1.98440e+02, 1.98439e+02, 1.98383e+02, 1.98274e+02, 1.98117e+02,
 1.97918e+02, 1.97684e+02, 1.97419e+02, 1.97124e+02, 1.96796e+02,
 1.96435e+02, 1.96034e+02, 1.95591e+02, 1.95104e+02, 1.94574e+02,
 1.94004e+02, 1.93397e+02, 1.92755e+02, 1.92076e+02, 1.91357e+02,
 1.90592e+02, 1.89775e+02, 1.88901e+02, 1.87963e+02, 1.86956e+02,
 1.85877e+02, 1.84725e+02, 1.83495e+02, 1.82183e+02, 1.80784e+02,
 1.79289e+02, 1.77690e+02, 1.75978e+02, 1.74142e+02, 1.72175e+02,
 1.70068e+02, 1.67815e+02, 1.65410e+02, 1.62848e+02, 1.60121e+02,
 1.57225e+02, 1.54154e+02, 1.50903e+02, 1.47468e+02, 1.43849e+02,
 1.40044e+02, 1.36058e+02, 1.31895e+02, 1.27562e+02, 1.23070e+02,
 1.18431e+02, 1.13659e+02, 1.08770e+02, 1.03785e+02, 9.87250e+01,
 9.36162e+01, 8.84867e+01, 8.33685e+01, 7.82971e+01, 7.33117e+01,
 6.84559e+01, 6.37782e+01, 6.02607e+01, 5.60301e+01, 5.21653e+01}
,
{9.44630e-02, 1.51315e+00, 6.60898e+00, 1.66458e+01, 3.11772e+01,
 4.87756e+01, 6.78816e+01, 8.72525e+01, 1.06061e+02, 1.23826e+02,
 1.40291e+02, 1.55322e+02, 1.68860e+02, 1.80906e+02, 1.91501e+02,
 2.00715e+02, 2.08663e+02, 2.15503e+02, 2.21395e+02, 2.26476e+02,
 2.30850e+02, 2.34596e+02, 2.37778e+02, 2.40449e+02, 2.42656e+02,
 2.44444e+02, 2.45861e+02, 2.46965e+02, 2.47817e+02, 2.48469e+02,
 2.48959e+02, 2.49319e+02, 2.49572e+02, 2.49737e+02, 2.49825e+02,
 2.49841e+02, 2.49785e+02, 2.49659e+02, 2.49469e+02, 2.49223e+02,
 2.48930e+02, 2.48596e+02, 2.48223e+02, 2.47809e+02, 2.47349e+02,
 2.46840e+02, 2.46276e+02, 2.45654e+02, 2.44977e+02, 2.44248e+02,
 2.43473e+02, 2.42652e+02, 2.41783e+02, 2.40862e+02, 2.39881e+02,
 2.38832e+02, 2.37708e+02, 2.36499e+02, 2.35202e+02, 2.33811e+02,
 2.32325e+02, 2.30739e+02, 2.29046e+02, 2.27238e+02, 2.25304e+02,
 2.23232e+02, 2.21010e+02, 2.18626e+02, 2.16069e+02, 2.13330e+02,
 2.10401e+02, 2.07275e+02, 2.03945e+02, 2.00401e+02, 1.96639e+02,
 1.92649e+02, 1.88429e+02, 1.83974e+02, 1.79284e+02, 1.74362e+02,
 1.69212e+02, 1.63845e+02, 1.58270e+02, 1.52502e+02, 1.46558e+02,
 1.40456e+02, 1.34219e+02, 1.27872e+02, 1.21443e+02, 1.14963e+02,
 1.08466e+02, 1.01990e+02, 9.55733e+01, 8.92611e+01, 8.31002e+01,
 7.85625e+01, 7.27627e+01, 6.72827e+01, 6.21979e+01, 5.75942e+01}
,
{1.29319e-01, 2.06528e+00, 8.94100e+00, 2.23202e+01, 4.14712e+01,
 6.44244e+01, 8.91196e+01, 1.13968e+02, 1.37942e+02, 1.60469e+02,
 1.81235e+02, 2.00094e+02, 2.16988e+02, 2.31931e+02, 2.44992e+02,
 2.56281e+02, 2.65974e+02, 2.74290e+02, 2.81436e+02, 2.87576e+02,
 2.92836e+02, 2.97311e+02, 3.01078e+02, 3.04207e+02, 3.06755e+02,
 3.08786e+02, 3.10372e+02, 3.11592e+02, 3.12525e+02, 3.13228e+02,
 3.13746e+02, 3.14115e+02, 3.14361e+02, 3.14503e+02, 3.14549e+02,
 3.14501e+02, 3.14361e+02, 3.14134e+02, 3.13833e+02, 3.13468e+02,
 3.13049e+02, 3.12579e+02, 3.12056e+02, 3.11475e+02, 3.10829e+02,
 3.10112e+02, 3.09320e+02, 3.08456e+02, 3.07526e+02, 3.06535e+02,
 3.05486e+02, 3.04376e+02, 3.03196e+02, 3.01938e+02, 3.00592e+02,
 2.99146e+02, 2.97590e+02, 2.95919e+02, 2.94127e+02, 2.92212e+02,
 2.90166e+02, 2.87981e+02, 2.85644e+02, 2.83140e+02, 2.80455e+02,
 2.77571e+02, 2.74474e+02, 2.71151e+02, 2.67590e+02, 2.63783e+02,
 2.59719e+02, 2.55389e+02, 2.50784e+02, 2.45894e+02, 2.40712e+02,
 2.35234e+02, 2.29456e+02, 2.23382e+02, 2.17016e+02, 2.10370e+02,
 2.03456e+02, 1.96291e+02, 1.88895e+02, 1.81291e+02, 1.73506e+02,
 1.65568e+02, 1.57510e+02, 1.49369e+02, 1.41182e+02, 1.32990e+02,
 1.24838e+02, 1.16770e+02, 1.08836e+02, 1.03183e+02, 9.55530e+01,
 8.82114e+01, 8.12264e+01, 7.46747e+01, 6.86434e+01, 6.32316e+01}
,
{1.76706e-01, 2.81368e+00, 1.20706e+01, 2.98691e+01, 5.50582e+01,
 8.49403e+01, 1.16809e+02, 1.48637e+02, 1.79157e+02, 2.07687e+02,
 2.33850e+02, 2.57481e+02, 2.78535e+02, 2.97046e+02, 3.13123e+02,
 3.26940e+02, 3.38755e+02, 3.48864e+02, 3.57526e+02, 3.64940e+02,
 3.71254e+02, 3.76586e+02, 3.81030e+02, 3.84676e+02, 3.87601e+02,
 3.89893e+02, 3.91659e+02, 3.93005e+02, 3.94021e+02, 3.94773e+02,
 3.95313e+02, 3.95681e+02, 3.95907e+02, 3.96003e+02, 3.95977e+02,
 3.95829e+02, 3.95566e+02, 3.95200e+02, 3.94749e+02, 3.94226e+02,
 3.93636e+02, 3.92978e+02, 3.92245e+02, 3.91428e+02, 3.90519e+02,
 3.89513e+02, 3.88413e+02, 3.87227e+02, 3.85963e+02, 3.84624e+02,
 3.83204e+02, 3.81695e+02, 3.80084e+02, 3.78357e+02, 3.76500e+02,
 3.74499e+02, 3.72348e+02, 3.70041e+02, 3.67574e+02, 3.64937e+02,
 3.62117e+02, 3.59097e+02, 3.55857e+02, 3.52376e+02, 3.48635e+02,
 3.44613e+02, 3.40295e+02, 3.35668e+02, 3.30720e+02, 3.25438e+02,
 3.19811e+02, 3.13826e+02, 3.07472e+02, 3.00743e+02, 2.93633e+02,
 2.86143e+02, 2.78280e+02, 2.70054e+02, 2.61481e+02, 2.52583e+02,
 2.43384e+02, 2.33911e+02, 2.24197e+02, 2.14278e+02, 2.04194e+02,
 1.93987e+02, 1.83703e+02, 1.73390e+02, 1.63098e+02, 1.52879e+02,
 1.42783e+02, 1.35860e+02, 1.26047e+02, 1.16507e+02, 1.07305e+02,
 9.85093e+01, 9.01986e+01, 8.24590e+01, 7.53888e+01, 6.91012e+01}
,
{2.41309e-01, 3.82599e+00, 1.62638e+01, 3.98950e+01, 7.29635e+01,
 1.11798e+02, 1.52858e+02, 1.93574e+02, 2.32382e+02, 2.68472e+02,
 3.01397e+02, 3.30975e+02, 3.57178e+02, 3.80079e+02, 3.99842e+02,
 4.16735e+02, 4.31132e+02, 4.43419e+02, 4.53913e+02, 4.62853e+02,
 4.70419e+02, 4.76753e+02, 4.81977e+02, 4.86201e+02, 4.89537e+02,
 4.92111e+02, 4.94071e+02, 4.95550e+02, 4.96650e+02, 4.97445e+02,
 4.97997e+02, 4.98350e+02, 4.98530e+02, 4.98548e+02, 4.98405e+02,
 4.98108e+02, 4.97672e+02, 4.97119e+02, 4.96469e+02, 4.95732e+02,
 4.94906e+02, 4.93984e+02, 4.92955e+02, 4.91807e+02, 4.90533e+02,
 4.89136e+02, 4.87626e+02, 4.86016e+02, 4.84307e+02, 4.82495e+02,
 4.80567e+02, 4.78505e+02, 4.76293e+02, 4.73910e+02, 4.71342e+02,
 4.68577e+02, 4.65610e+02, 4.62435e+02, 4.59038e+02, 4.55401e+02,
 4.51501e+02, 4.47310e+02, 4.42803e+02, 4.37953e+02, 4.32734e+02,
 4.27128e+02, 4.21120e+02, 4.14693e+02, 4.07832e+02, 4.00522e+02,
 3.92746e+02, 3.84495e+02, 3.75759e+02, 3.66537e+02, 3.56833e+02,
 3.46660e+02, 3.36037e+02, 3.24988e+02, 3.13545e+02, 3.01743e+02,
 2.89621e+02, 2.77225e+02, 2.64603e+02, 2.51810e+02, 2.38902e+02,
 2.25936e+02, 2.12974e+02, 2.00076e+02, 1.87303e+02, 1.78877e+02,
 1.66401e+02, 1.54203e+02, 1.42347e+02, 1.30897e+02, 1.19925e+02,
 1.09506e+02, 9.97254e+01, 9.06784e+01, 8.24749e+01, 7.52424e+01}
,
{3.29270e-01, 5.19222e+00, 2.18729e+01, 5.31888e+01, 9.65226e+01,
 1.46909e+02, 1.99735e+02, 2.51753e+02, 3.01049e+02, 3.46647e+02,
 3.88040e+02, 4.25020e+02, 4.57590e+02, 4.85882e+02, 5.10147e+02,
 5.30787e+02, 5.48327e+02, 5.63256e+02, 5.75961e+02, 5.86726e+02,
 5.95771e+02, 6.03271e+02, 6.09383e+02, 6.14252e+02, 6.18031e+02,
 6.20911e+02, 6.23081e+02, 6.24699e+02, 6.25878e+02, 6.26707e+02,
 6.27256e+02, 6.27568e+02, 6.27664e+02, 6.27550e+02, 6.27230e+02,
 6.26721e+02, 6.26052e+02, 6.25250e+02, 6.24333e+02, 6.23300e+02,
 6.22145e+02, 6.20853e+02, 6.19409e+02, 6.17801e+02, 6.16031e+02,
 6.14113e+02, 6.12064e+02, 6.09887e+02, 6.07577e+02, 6.05116e+02,
 6.02484e+02, 5.99654e+02, 5.96603e+02, 5.93310e+02, 5.89762e+02,
 5.85952e+02, 5.81871e+02, 5.77500e+02, 5.72815e+02, 5.67783e+02,
 5.62370e+02, 5.56540e+02, 5.50258e+02, 5.43494e+02, 5.36225e+02,
 5.28430e+02, 5.20091e+02, 5.11186e+02, 5.01696e+02, 4.91602e+02,
 4.80892e+02, 4.69560e+02, 4.57606e+02, 4.45043e+02, 4.31891e+02,
 4.18182e+02, 4.03953e+02, 3.89248e+02, 3.74116e+02, 3.58616e+02,
 3.42809e+02, 3.26763e+02, 3.10549e+02, 2.94242e+02, 2.77918e+02,
 2.61651e+02, 2.45516e+02, 2.29585e+02, 2.19460e+02, 2.03983e+02,
 1.88876e+02, 1.74206e+02, 1.60039e+02, 1.46445e+02, 1.33498e+02,
 1.21278e+02, 1.09876e+02, 9.93962e+01, 8.99598e+01, 8.17094e+01}
,
{4.48788e-01, 7.03256e+00, 2.93619e+01, 7.07874e+01, 1.27476e+02,
 1.92747e+02, 2.60615e+02, 3.26992e+02, 3.89546e+02, 4.47102e+02,
 4.99079e+02, 5.45265e+02, 5.85699e+02, 6.20606e+02, 6.50365e+02,
 6.75575e+02, 6.96940e+02, 7.15072e+02, 7.30438e+02, 7.43381e+02,
 7.54165e+02, 7.63016e+02, 7.70133e+02, 7.75709e+02, 7.79972e+02,
 7.83184e+02, 7.85580e+02, 7.87337e+02, 7.88587e+02, 7.89435e+02,
 7.89954e+02, 7.90182e+02, 7.90135e+02, 7.89815e+02, 7.89239e+02,
 7.88440e+02, 7.87459e+02, 7.86323e+02, 7.85039e+02, 7.83597e+02,
 7.81982e+02, 7.80172e+02, 7.78149e+02, 7.75914e+02, 7.73484e+02,
 7.70881e+02, 7.68113e+02, 7.65172e+02, 7.62038e+02, 7.58681e+02,
 7.55070e+02, 7.51171e+02, 7.46956e+02, 7.42412e+02, 7.37527e+02,
 7.32289e+02, 7.26674e+02, 7.20647e+02, 7.14165e+02, 7.07182e+02,
 6.99651e+02, 6.91528e+02, 6.82774e+02, 6.73361e+02, 6.63263e+02,
 6.52454e+02, 6.40908e+02, 6.28601e+02, 6.15510e+02, 6.01622e+02,
 5.86934e+02, 5.71453e+02, 5.55201e+02, 5.38214e+02, 5.20536e+02,
 5.02222e+02, 4.83335e+02, 4.63948e+02, 4.44139e+02, 4.23995e+02,
 4.03608e+02, 3.83074e+02, 3.62489e+02, 3.41952e+02, 3.21557e+02,
 3.01394e+02, 2.88997e+02, 2.69405e+02, 2.50241e+02, 2.31577e+02,
 2.13481e+02, 1.96020e+02, 1.79262e+02, 1.63276e+02, 1.48136e+02,
 1.33926e+02, 1.20742e+02, 1.08694e+02, 9.79169e+01, 8.85687e+01}
,
{6.10848e-01, 9.50983e+00, 3.93460e+01, 9.40502e+01, 1.68088e+02,
 2.52515e+02, 3.39595e+02, 4.24198e+02, 5.03500e+02, 5.76075e+02,
 6.41274e+02, 6.98892e+02, 7.49033e+02, 7.92047e+02, 8.28512e+02,
 8.59295e+02, 8.85313e+02, 9.07324e+02, 9.25886e+02, 9.41417e+02,
 9.54241e+02, 9.64647e+02, 9.72888e+02, 9.79240e+02, 9.84031e+02,
 9.87604e+02, 9.90237e+02, 9.92129e+02, 9.93436e+02, 9.94276e+02,
 9.94720e+02, 9.94800e+02, 9.94521e+02, 9.93896e+02, 9.92964e+02,
 9.91777e+02, 9.90379e+02, 9.88789e+02, 9.86997e+02, 9.84985e+02,
 9.82725e+02, 9.80192e+02, 9.77379e+02, 9.74309e+02, 9.71009e+02,
 9.67495e+02, 9.63758e+02, 9.59773e+02, 9.55503e+02, 9.50903e+02,
 9.45932e+02, 9.40551e+02, 9.34741e+02, 9.28490e+02, 9.21779e+02,
 9.14578e+02, 9.06838e+02, 8.98502e+02, 8.89511e+02, 8.79800e+02,
 8.69314e+02, 8.58004e+02, 8.45834e+02, 8.32771e+02, 8.18782e+02,
 8.03832e+02, 7.87890e+02, 7.70932e+02, 7.52944e+02, 7.33926e+02,
 7.13897e+02, 6.92894e+02, 6.70970e+02, 6.48191e+02, 6.24636e+02,
 6.00394e+02, 5.75566e+02, 5.50263e+02, 5.24603e+02, 4.98711e+02,
 4.72714e+02, 4.46741e+02, 4.20915e+02, 3.95354e+02, 3.80030e+02,
 3.55210e+02, 3.30906e+02, 3.07202e+02, 2.84176e+02, 2.61897e+02,
 2.40432e+02, 2.19843e+02, 2.00193e+02, 1.81549e+02, 1.63983e+02,
 1.47579e+02, 1.32435e+02, 1.18672e+02, 1.06433e+02, 9.58969e+01}
,
{8.30148e-01, 1.28389e+01, 5.26373e+01, 1.24755e+02, 2.21299e+02,
 3.30351e+02, 4.41941e+02, 5.49658e+02, 6.50094e+02, 7.41531e+02,
 8.23230e+02, 8.95031e+02, 9.57138e+02, 1.01008e+03, 1.05473e+03,
 1.09231e+03, 1.12399e+03, 1.15069e+03, 1.17308e+03, 1.19168e+03,
 1.20688e+03, 1.21906e+03, 1.22855e+03, 1.23576e+03, 1.24113e+03,
 1.24509e+03, 1.24796e+03, 1.24998e+03, 1.25132e+03, 1.25211e+03,
 1.25241e+03, 1.25224e+03, 1.25160e+03, 1.25055e+03, 1.24913e+03,
 1.24743e+03, 1.24547e+03, 1.24325e+03, 1.24076e+03, 1.23795e+03,
 1.23479e+03, 1.23126e+03, 1.22739e+03, 1.22322e+03, 1.21877e+03,
 1.21403e+03, 1.20897e+03, 1.20355e+03, 1.19771e+03, 1.19138e+03,
 1.18453e+03, 1.17712e+03, 1.16914e+03, 1.16056e+03, 1.15134e+03,
 1.14142e+03, 1.13072e+03, 1.11917e+03, 1.10667e+03, 1.09316e+03,
 1.07858e+03, 1.06287e+03, 1.04600e+03, 1.02792e+03, 1.00860e+03,
 9.87976e+02, 9.66037e+02, 9.42767e+02, 9.18173e+02, 8.92290e+02,
 8.65174e+02, 8.36903e+02, 8.07574e+02, 7.77296e+02, 7.46197e+02,
 7.14417e+02, 6.82108e+02, 6.49431e+02, 6.16555e+02, 5.83648e+02,
 5.50877e+02, 5.18401e+02, 4.86368e+02, 4.67723e+02, 4.36838e+02,
 4.06694e+02, 3.77385e+02, 3.48994e+02, 3.21591e+02, 2.95240e+02,
 2.69997e+02, 2.45916e+02, 2.23051e+02, 2.01460e+02, 1.81211e+02,
 1.62387e+02, 1.45088e+02, 1.29442e+02, 1.15606e+02, 1.03779e+02}
,
{1.12631e+00, 1.73043e+01, 7.03027e+01, 1.65227e+02, 2.90934e+02,
 4.31601e+02, 5.74434e+02, 7.11444e+02, 8.38525e+02, 9.53617e+02,
 1.05590e+03, 1.14527e+03, 1.22211e+03, 1.28721e+03, 1.34186e+03,
 1.38773e+03, 1.42628e+03, 1.45865e+03, 1.48562e+03, 1.50783e+03,
 1.52580e+03, 1.53999e+03, 1.55086e+03, 1.55900e+03, 1.56501e+03,
 1.56939e+03, 1.57250e+03, 1.57461e+03, 1.57594e+03, 1.57661e+03,
 1.57665e+03, 1.57608e+03, 1.57494e+03, 1.57329e+03, 1.57123e+03,
 1.56883e+03, 1.56610e+03, 1.56302e+03, 1.55954e+03, 1.55562e+03,
 1.55123e+03, 1.54637e+03, 1.54111e+03, 1.53548e+03, 1.52948e+03,
 1.52308e+03, 1.51621e+03, 1.50880e+03, 1.50078e+03, 1.49207e+03,
 1.48264e+03, 1.47247e+03, 1.46152e+03, 1.44975e+03, 1.43706e+03,
 1.42336e+03, 1.40855e+03, 1.39250e+03, 1.37514e+03, 1.35637e+03,
 1.33614e+03, 1.31440e+03, 1.29108e+03, 1.26613e+03, 1.23950e+03,
 1.21116e+03, 1.18110e+03, 1.14934e+03, 1.11593e+03, 1.08096e+03,
 1.04454e+03, 1.00680e+03, 9.67911e+02, 9.28036e+02, 8.87372e+02,
 8.46127e+02, 8.04521e+02, 7.62778e+02, 7.21122e+02, 6.79768e+02,
 6.38919e+02, 6.15394e+02, 5.76027e+02, 5.37579e+02, 5.00177e+02,
 4.63926e+02, 4.28914e+02, 3.95213e+02, 3.62880e+02, 3.31962e+02,
 3.02499e+02, 2.74529e+02, 2.48092e+02, 2.23235e+02, 2.00020e+02,
 1.78524e+02, 1.58850e+02, 1.41132e+02, 1.25544e+02, 1.12305e+02}
,
{1.52550e+00, 2.32836e+01, 9.37493e+01, 2.18502e+02, 3.81944e+02,
 5.63161e+02, 7.45784e+02, 9.19892e+02, 1.08053e+03, 1.22528e+03,
 1.35321e+03, 1.46434e+03, 1.55930e+03, 1.63927e+03, 1.70614e+03,
 1.76212e+03, 1.80902e+03, 1.84820e+03, 1.88064e+03, 1.90710e+03,
 1.92825e+03, 1.94470e+03, 1.95710e+03, 1.96627e+03, 1.97298e+03,
 1.97778e+03, 1.98112e+03, 1.98330e+03, 1.98455e+03, 1.98497e+03,
 1.98459e+03, 1.98343e+03, 1.98157e+03, 1.97913e+03, 1.97621e+03,
 1.97287e+03, 1.96908e+03, 1.96479e+03, 1.95995e+03, 1.95449e+03,
 1.94842e+03, 1.94181e+03, 1.93470e+03, 1.92713e+03, 1.91904e+03,
 1.91036e+03, 1.90100e+03, 1.89084e+03, 1.87981e+03, 1.86784e+03,
 1.85491e+03, 1.84097e+03, 1.82597e+03, 1.80978e+03, 1.79228e+03,
 1.77333e+03, 1.75278e+03, 1.73051e+03, 1.70641e+03, 1.68042e+03,
 1.65245e+03, 1.62242e+03, 1.59028e+03, 1.55595e+03, 1.51940e+03,
 1.48063e+03, 1.43966e+03, 1.39659e+03, 1.35154e+03, 1.30466e+03,
 1.25615e+03, 1.20623e+03, 1.15512e+03, 1.10311e+03, 1.05047e+03,
 9.97496e+02, 9.44491e+02, 8.91746e+02, 8.39542e+02, 7.88137e+02,
 7.59170e+02, 7.09960e+02, 6.62059e+02, 6.15613e+02, 5.70741e+02,
 5.27536e+02, 4.86066e+02, 4.46381e+02, 4.08514e+02, 3.72487e+02,
 3.38316e+02, 3.06018e+02, 2.75614e+02, 2.47136e+02, 2.20635e+02,
 1.96182e+02, 1.73882e+02, 1.53878e+02, 1.36358e+02, 1.21569e+02}
,
{2.06402e+00, 3.12840e+01, 1.24831e+02, 2.88541e+02, 5.00754e+02,
 7.33930e+02, 9.67183e+02, 1.18825e+03, 1.39113e+03, 1.57299e+03,
 1.73287e+03, 1.87091e+03, 1.98814e+03, 2.08630e+03, 2.16811e+03,
 2.23641e+03, 2.29343e+03, 2.34081e+03, 2.37975e+03, 2.41119e+03,
 2.43599e+03, 2.45495e+03, 2.46905e+03, 2.47936e+03, 2.48681e+03,
 2.49205e+03, 2.49558e+03, 2.49777e+03, 2.49882e+03, 2.49881e+03,
 2.49778e+03, 2.49577e+03, 2.49293e+03, 2.48943e+03, 2.48536e+03,
 2.48072e+03, 2.47546e+03, 2.46950e+03, 2.46276e+03, 2.45522e+03,
 2.44693e+03, 2.43800e+03, 2.42845e+03, 2.41825e+03, 2.40731e+03,
 2.39550e+03, 2.38269e+03, 2.36874e+03, 2.35359e+03, 2.33719e+03,
 2.31950e+03, 2.30042e+03, 2.27982e+03, 2.25752e+03, 2.23334e+03,
 2.20709e+03, 2.17859e+03, 2.14773e+03, 2.11440e+03, 2.07849e+03,
 2.03992e+03, 1.99859e+03, 1.95441e+03, 1.90736e+03, 1.85742e+03,
 1.80466e+03, 1.74921e+03, 1.69124e+03, 1.63096e+03, 1.56865e+03,
 1.50459e+03, 1.43913e+03, 1.37262e+03, 1.30544e+03, 1.23799e+03,
 1.17067e+03, 1.10386e+03, 1.03792e+03, 1.00060e+03, 9.37404e+02,
 8.75831e+02, 8.16086e+02, 7.58343e+02, 7.02734e+02, 6.49355e+02,
 5.98270e+02, 5.49516e+02, 5.03107e+02, 4.59040e+02, 4.17304e+02,
 3.77884e+02, 3.40769e+02, 3.05954e+02, 2.73454e+02, 2.43304e+02,
 2.15572e+02, 1.90362e+02, 1.67825e+02, 1.48169e+02, 1.31668e+02}
,
{2.79034e+00, 4.19743e+01, 1.65975e+02, 3.80505e+02, 6.55684e+02,
 9.55363e+02, 1.25300e+03, 1.53343e+03, 1.78945e+03, 2.01777e+03,
 2.21737e+03, 2.38869e+03, 2.53324e+03, 2.65368e+03, 2.75375e+03,
 2.83705e+03, 2.90633e+03, 2.96355e+03, 3.01017e+03, 3.04742e+03,
 3.07636e+03, 3.09814e+03, 3.11412e+03, 3.12569e+03, 3.13393e+03,
 3.13959e+03, 3.14326e+03, 3.14533e+03, 3.14600e+03, 3.14531e+03,
 3.14329e+03, 3.14011e+03, 3.13597e+03, 3.13105e+03, 3.12540e+03,
 3.11898e+03, 3.11168e+03, 3.10340e+03, 3.09408e+03, 3.08375e+03,
 3.07254e+03, 3.06054e+03, 3.04770e+03, 3.03394e+03, 3.01908e+03,
 3.00296e+03, 2.98539e+03, 2.96627e+03, 2.94553e+03, 2.92311e+03,
 2.89892e+03, 2.87276e+03, 2.84442e+03, 2.81365e+03, 2.78020e+03,
 2.74385e+03, 2.70441e+03, 2.66177e+03, 2.61579e+03, 2.56633e+03,
 2.51329e+03, 2.45656e+03, 2.39608e+03, 2.33188e+03, 2.26404e+03,
 2.19274e+03, 2.11822e+03, 2.04079e+03, 1.96081e+03, 1.87868e+03,
 1.79486e+03, 1.70982e+03, 1.62410e+03, 1.53821e+03, 1.45268e+03,
 1.36801e+03, 1.28467e+03, 1.23812e+03, 1.15872e+03, 1.08158e+03,
 1.00697e+03, 9.35077e+02, 8.66057e+02, 8.00007e+02, 7.36982e+02,
 6.77000e+02, 6.20049e+02, 5.66094e+02, 5.15087e+02, 4.66973e+02,
 4.21696e+02, 3.79210e+02, 3.39484e+02, 3.02507e+02, 2.68300e+02,
 2.36921e+02, 2.08477e+02, 1.83126e+02, 1.61099e+02, 1.42703e+02}
,
{3.76841e+00, 5.62371e+01, 2.20370e+02, 5.01115e+02, 8.57489e+02,
 1.24222e+03, 1.62163e+03, 1.97712e+03, 2.29994e+03, 2.58632e+03,
 2.83529e+03, 3.04769e+03, 3.22580e+03, 3.37349e+03, 3.49587e+03,
 3.59745e+03, 3.68155e+03, 3.75055e+03, 3.80625e+03, 3.85021e+03,
 3.88385e+03, 3.90876e+03, 3.92683e+03, 3.93978e+03, 3.94882e+03,
 3.95487e+03, 3.95859e+03, 3.96038e+03, 3.96037e+03, 3.95861e+03,
 3.95521e+03, 3.95043e+03, 3.94455e+03, 3.93772e+03, 3.92991e+03,
 3.92102e+03, 3.91090e+03, 3.89944e+03, 3.88663e+03, 3.87263e+03,
 3.85757e+03, 3.84146e+03, 3.82418e+03, 3.80553e+03, 3.78530e+03,
 3.76324e+03, 3.73917e+03, 3.71301e+03, 3.68469e+03, 3.65408e+03,
 3.62096e+03, 3.58504e+03, 3.54600e+03, 3.50349e+03, 3.45723e+03,
 3.40697e+03, 3.35255e+03, 3.29380e+03, 3.23054e+03, 3.16261e+03,
 3.08990e+03, 3.01233e+03, 2.92992e+03, 2.84282e+03, 2.75127e+03,
 2.65560e+03, 2.55624e+03, 2.45365e+03, 2.34841e+03, 2.24111e+03,
 2.13242e+03, 2.02303e+03, 1.91364e+03, 1.80493e+03, 1.69757e+03,
 1.59215e+03, 1.53390e+03, 1.43401e+03, 1.33724e+03, 1.24392e+03,
 1.15426e+03, 1.06845e+03, 9.86573e+02, 9.08673e+02, 8.34742e+02,
 7.64732e+02, 6.98566e+02, 6.36147e+02, 5.77368e+02, 5.22120e+02,
 4.70300e+02, 4.21820e+02, 3.76614e+02, 3.34643e+02, 2.95914e+02,
 2.60472e+02, 2.28423e+02, 1.99940e+02, 1.75275e+02, 1.54772e+02}
,
{   5.08336,   75.2372 ,  292.208  ,  659.117  , 1120.09   , 1613.5    ,
 2096.72   , 2546.99   , 2953.76   , 3312.66   , 3622.92   , 3886.01   ,
 4105.27   , 4286.36   , 4436.     , 4559.8    , 4661.78   , 4744.83   ,
 4811.23   , 4862.92   , 4901.83   , 4930.24   , 4950.65   , 4965.07   ,
 4974.93   , 4981.3    , 4984.9    , 4986.11   , 4985.     , 4981.67   ,
 4976.35   , 4969.45   , 4961.24   , 4951.79   , 4941.01   , 4928.71   ,
 4914.7    , 4898.92   , 4881.51   , 4862.68   , 4842.49   , 4820.84   ,
 4797.5    , 4772.17   , 4744.54   , 4714.35   , 4681.45   , 4645.77   ,
 4607.15   , 4565.33   , 4519.92   , 4470.5    , 4416.64   , 4357.94   ,
 4294.07   , 4224.79   , 4149.9    , 4069.17   , 3982.38   , 3889.37   ,
 3790.06   , 3684.49   , 3572.84   , 3455.45   , 3332.77   , 3205.38   ,
 3073.91   , 2939.13   , 2801.84   , 2662.93   , 2523.33   , 2383.96   ,
 2245.74   , 2109.5    , 2032.52   , 1902.9    , 1777.07   , 1655.5    ,
 1538.58   , 1426.58   , 1319.67   , 1217.97   , 1121.48   , 1030.16   ,
  943.918  ,  862.614  ,  786.09   ,  714.172  ,  646.682  ,  583.445  ,
  524.303  ,  469.12   ,  417.785  ,  370.238  ,  326.457  ,  286.479  ,
  250.409  ,  218.432  ,  190.826  ,  167.977  }
,
{   6.84842,  100.526  ,  386.965  ,  865.875  , 1461.46   , 2093.59   ,
 2708.51   , 3278.41   , 3790.56   , 4240.04   , 4626.34   , 4951.88   ,
 5221.63   , 5443.61   , 5626.55   , 5777.36   , 5900.89   , 6000.66   ,
 6079.57   , 6140.12   , 6184.96   , 6217.29   , 6240.27   , 6256.25   ,
 6266.9    , 6273.46   , 6276.68   , 6276.86   , 6274.07   , 6268.49   ,
 6260.59   , 6250.85   , 6239.5    , 6226.47   , 6211.59   , 6194.58   ,
 6175.26   , 6153.73   , 6130.26   , 6105.02   , 6077.96   , 6048.8    ,
 6017.17   , 5982.67   , 5944.91   , 5903.67   , 5858.84   , 5810.25   ,
 5757.56   , 5700.32   , 5637.96   , 5569.91   , 5495.63   , 5414.67   ,
 5326.73   , 5231.51   , 5128.73   , 5018.09   , 4899.38   , 4772.5    ,
 4637.49   , 4494.6    , 4344.29   , 4187.18   , 4024.01   , 3855.66   ,
 3683.14   , 3507.54   , 3330.05   , 3151.88   , 2974.26   , 2798.4    ,
 2625.41   , 2528.03   , 2364.13   , 2205.41   , 2052.44   , 1905.7    ,
 1765.51   , 1632.07   , 1505.46   , 1385.67   , 1272.61   , 1166.12   ,
 1065.97   ,  971.947  ,  883.772  ,  801.182  ,  723.914  ,  651.717  ,
  584.37   ,  521.673  ,  463.482  ,  409.693  ,  360.262  ,  315.213  ,
  274.651  ,  238.773  ,  207.886  ,  182.423  }
,
{   9.21393,  134.154  ,  511.806  , 1136.15   , 1904.81   , 2713.9    ,
 3495.77   , 4216.55   , 4860.93   , 5423.4    , 5903.97   , 6306.44   ,
 6638.12   , 6910.18   , 7133.79   , 7317.36   , 7466.78   , 7586.41   ,
 7679.9    , 7750.54   , 7802.04   , 7838.77   , 7864.57   , 7882.16   ,
 7893.53   , 7900.05   , 7902.45   , 7900.95   , 7895.66   , 7887.     ,
 7875.65   , 7862.11   , 7846.46   , 7828.53   , 7807.99   , 7784.51   ,
 7758.06   , 7728.95   , 7697.49   , 7663.72   , 7627.36   , 7587.97   ,
 7545.     , 7497.94   , 7446.4    , 7390.24   , 7329.25   , 7263.07   ,
 7191.11   , 7112.64   , 7026.91   , 6933.19   , 6830.87   , 6719.53   ,
 6598.78   , 6468.24   , 6327.53   , 6176.36   , 6014.58   , 5842.25   ,
 5659.71   , 5467.54   , 5266.56   , 5057.79   , 4842.39   , 4621.69   ,
 4397.17   , 4170.39   , 3942.97   , 3716.54   , 3492.67   , 3272.82   ,
 3149.27   , 2941.79   , 2741.29   , 2548.5    , 2364.01   , 2188.19   ,
 2021.26   , 1863.29   , 1714.22   , 1573.89   , 1442.05   , 1318.39   ,
 1202.56   , 1094.19   ,  992.898  ,  898.304  ,  810.041  ,  727.777  ,
  651.216  ,  580.097  ,  514.219  ,  453.438  ,  397.682  ,  346.961  ,
  301.377  ,  261.141  ,  226.591  ,  198.213  }
,
{  12.3792,  178.813 ,  676.122 , 1489.1   , 2480.08  , 3514.71  ,
 4508.13  , 5419.07  , 6229.25  , 6932.58  , 7529.94  , 8027.09  ,
 8434.75  , 8768.14  , 9041.37  , 9264.63  , 9445.13  , 9588.28  ,
 9698.67  , 9780.74  , 9839.74  , 9881.38  , 9910.23  , 9929.44  ,
 9941.36  , 9947.47  , 9948.39  , 9944.28  , 9935.42  , 9922.6   ,
 9906.65  , 9887.98  , 9866.47  , 9841.78  , 9813.45  , 9781.21  ,
 9745.31  , 9706.22  , 9664.17  , 9618.92  , 9569.96  , 9516.59  ,
 9458.1   , 9393.92  , 9323.78  , 9247.46  , 9164.54  , 9074.31  ,
 8975.85  , 8868.17  , 8750.27  , 8621.34  , 8480.77  , 8328.05  ,
 8162.68  , 7984.16  , 7792.09  , 7586.26  , 7366.73  , 7133.92  ,
 6888.6   , 6631.85  , 6365.01  , 6089.63  , 5807.48  , 5520.5   ,
 5230.77  , 4940.45  , 4651.69  , 4366.54  , 4086.91  , 3929.72  ,
 3666.73  , 3413.08  , 3169.71  , 2937.32  , 2716.37  , 2507.09  ,
 2309.53  , 2123.57  , 1948.93  , 1785.28  , 1632.16  , 1489.08  ,
 1355.53  , 1230.98  , 1114.89  , 1006.77  ,  906.135 ,  812.548 ,
  725.632 ,  645.053 ,  570.549 ,  501.93  ,  439.091 ,  382.023 ,
  330.824 ,  285.721 ,  247.084 ,  215.456 }
,
{   16.6113,   238.044 ,   892.164 ,  1949.56  ,  3225.84  ,  4547.76  ,
  5809.07  ,  6959.56  ,  7977.46  ,  8856.28  ,  9598.22  , 10211.8   ,
 10712.7   , 11121.2   , 11454.9   , 11726.3   , 11943.9   , 12114.8   ,
 12244.7   , 12339.7   , 12407.2   , 12454.3   , 12486.3   , 12507.1   ,
 12519.3   , 12524.4   , 12522.8   , 12514.8   , 12501.1   , 12482.7   ,
 12460.6   , 12434.9   , 12405.4   , 12371.4   , 12332.4   , 12288.5   ,
 12240.1   , 12187.9   , 12131.7   , 12070.9   , 12004.8   , 11932.3   ,
 11852.7   , 11765.4   , 11670.1   , 11566.5   , 11453.7   , 11330.5   ,
 11195.6   , 11047.8   , 10885.8   , 10708.8   , 10516.2   , 10307.3   ,
 10081.3   ,  9837.88  ,  9576.58  ,  9297.48  ,  9001.1   ,  8688.43  ,
  8360.88  ,  8020.2   ,  7668.43  ,  7307.93  ,  6941.25  ,  6571.15  ,
  6200.49  ,  5832.09  ,  5468.66  ,  5112.69  ,  4912.16  ,  4578.39  ,
  4257.03  ,  3949.29  ,  3656.02  ,  3377.78  ,  3114.83  ,  2867.17  ,
  2634.58  ,  2416.69  ,  2212.98  ,  2022.85  ,  1845.6   ,  1680.54  ,
  1526.95  ,  1384.11  ,  1251.32  ,  1127.94  ,  1013.36  ,   907.027 ,
   808.463 ,   717.254 ,   633.066 ,   555.659 ,   484.886 ,   420.717 ,
   363.244 ,   312.706 ,   269.51  ,   234.261 }
,
{   22.2734,   316.521 ,  1175.92  ,  2549.7   ,  4191.85  ,  5879.43  ,
  7479.81  ,  8931.83  , 10209.9   , 11307.1   , 12227.9   , 12984.7   ,
 13600.    , 14100.5   , 14507.9   , 14837.3   , 15099.3   , 15302.7   ,
 15455.    , 15564.7   , 15641.7   , 15694.8   , 15730.3   , 15752.5   ,
 15764.4   , 15767.5   , 15762.    , 15748.5   , 15728.    , 15702.3   ,
 15671.8   , 15636.7   , 15596.1   , 15549.3   , 15496.    , 15436.6   ,
 15371.9   , 15302.2   , 15227.    , 15145.2   , 15055.6   , 14957.1   ,
 14848.8   , 14730.3   , 14601.2   , 14460.5   , 14306.8   , 14138.4   ,
 13953.5   , 13750.6   , 13528.5   , 13286.2   , 13022.9   , 12737.7   ,
 12429.9   , 12098.9   , 11744.9   , 11368.3   , 10970.4   , 10553.1   ,
 10118.6   ,  9669.72  ,  9209.4   ,  8741.07  ,  8268.37  ,  7795.06  ,
  7324.88  ,  6861.4   ,  6589.96  ,  6151.4   ,  5727.26  ,  5319.51  ,
  4929.71  ,  4558.92  ,  4207.82  ,  3876.69  ,  3565.48  ,  3273.85  ,
  3001.26  ,  2746.99  ,  2510.21  ,  2289.98  ,  2085.37  ,  1895.41  ,
  1719.11  ,  1555.57  ,  1403.91  ,  1263.3   ,  1132.99  ,  1012.3   ,
   900.624 ,   797.465 ,   702.408 ,   615.147 ,   535.491 ,   463.381 ,
   398.899 ,   342.298 ,   294.022 ,   254.743 }
,
{   29.8405,   420.428 ,  1548.24  ,  3331.21  ,  5442.12  ,  7594.8   ,
  9624.07  , 11455.5   , 13059.1   , 14428.1   , 15569.8   , 16502.8   ,
 17258.5   , 17871.6   , 18368.6   , 18768.    , 19082.9   , 19324.3   ,
 19502.3   , 19628.5   , 19716.3   , 19776.    , 19814.8   , 19838.1   ,
 19849.    , 19848.6   , 19837.3   , 19816.    , 19786.7   , 19751.    ,
 19709.3   , 19661.1   , 19605.4   , 19541.3   , 19468.9   , 19389.1   ,
 19302.8   , 19209.8   , 19108.8   , 18998.4   , 18877.    , 18743.1   ,
 18596.2   , 18435.7   , 18260.7   , 18069.4   , 17859.7   , 17629.3   ,
 17375.9   , 17098.    , 16794.1   , 16463.3   , 16104.2   , 15716.    ,
 15297.8   , 14849.5   , 14372.    , 13866.6   , 13335.7   , 12782.4   ,
 12210.    , 11622.6   , 11024.7   , 10421.1   ,  9816.66  ,  9216.36  ,
  8624.91  ,  8276.45  ,  7717.78  ,  7178.1   ,  6659.98  ,  6165.4   ,
  5695.73  ,  5251.78  ,  4833.87  ,  4441.87  ,  4075.29  ,  3733.36  ,
  3415.09  ,  3119.35  ,  2844.92  ,  2590.5   ,  2354.81  ,  2136.57  ,
  1934.55  ,  1747.58  ,  1574.57  ,  1414.49  ,  1266.42  ,  1129.53  ,
  1003.1   ,   886.513 ,   779.256 ,   680.953 ,   591.357 ,   510.373 ,
   438.069 ,   374.71  ,   320.779 ,   277.021 }
,
{   39.941,   557.853,  2036.32 ,  4347.97 ,  7059.01 ,  9803.   ,
 12374.4  , 14683.1  , 16693.8  , 18400.5  , 19815.2  , 20964.8  ,
 21892.8  , 22643.6  , 23249.6  , 23733.2  , 24110.9  , 24396.6  ,
 24603.8  , 24748.9  , 24848.6  , 24915.4  , 24957.7  , 24981.4  ,
 24989.9  , 24983.9  , 24964.1  , 24932.2  , 24891.1  , 24842.1  ,
 24785.   , 24719.   , 24642.6  , 24555.2  , 24457.5  , 24351.1  ,
 24236.1  , 24111.7  , 23975.8  , 23826.5  , 23661.7  , 23480.2  ,
 23281.4  , 23064.2  , 22826.8  , 22566.4  , 22280.   , 21964.7  ,
 21617.9  , 21238.   , 20823.4  , 20372.6  , 19884.2  , 19357.1  ,
 18791.   , 18186.6  , 17545.8  , 16871.6  , 16167.7  , 15438.7  ,
 14689.8  , 13926.8  , 13156.1  , 12384.2  , 11617.5  , 10862.3  ,
 10414.2  ,  9701.75 ,  9014.18 ,  8354.83 ,  7726.26 ,  7130.22 ,
  6567.73 ,  6039.13 ,  5544.21 ,  5082.25 ,  4652.21 ,  4252.74 ,
  3882.32 ,  3539.3  ,  3221.98 ,  2928.66 ,  2657.63 ,  2407.29 ,
  2176.07 ,  1962.55 ,  1765.36 ,  1583.26 ,  1415.15 ,  1260.01 ,
  1116.97 ,   985.288,   864.345,   753.675,   652.965,   562.073,
   481.05 ,   410.167,   349.949,   301.216}
,
{   53.4063,   739.41  ,  2675.54  ,  5669.71  ,  9148.55  , 12643.6   ,
 15900.1   , 18808.6   , 21328.2   , 23454.6   , 25206.1   , 26622.    ,
 27761.5   , 28680.6   , 29419.    , 30003.8   , 30455.8   , 30792.8   ,
 31033.3   , 31199.8   , 31312.9   , 31387.1   , 31432.5   , 31455.7   ,
 31459.7   , 31445.2   , 31413.3   , 31367.4   , 31310.4   , 31243.4   ,
 31165.5   , 31075.1   , 30970.6   , 30852.1   , 30721.3   , 30579.6   ,
 30426.3   , 30259.5   , 30076.4   , 29874.1   , 29650.7   , 29405.1   ,
 29136.5   , 28842.5   , 28520.    , 28165.1   , 27773.9   , 27342.8   ,
 26869.2   , 26351.2   , 25786.8   , 25173.9   , 24511.2   , 23797.9   ,
 23034.8   , 22223.9   , 21369.    , 20474.8   , 19547.3   , 18593.3   ,
 17620.3   , 16636.6   , 15650.7   , 14671.2   , 13706.4   , 13129.2   ,
 12219.8   , 11342.7   , 10502.4   ,  9702.22  ,  8944.42  ,  8230.3   ,
  7560.25  ,  6933.92  ,  6350.34  ,  5808.06  ,  5305.3   ,  4840.01  ,
  4410.    ,  4013.03  ,  3646.82  ,  3309.16  ,  2997.94  ,  2711.1   ,
  2446.75  ,  2203.11  ,  1978.55  ,  1771.56  ,  1580.82  ,  1405.11  ,
  1243.38  ,  1094.75  ,   958.464 ,   833.955 ,   720.828 ,   618.887 ,
   528.154 ,   448.906 ,   381.706 ,   327.46  }
,
{   71.3352,   979.018 ,  3511.94  ,  7386.5   , 11846.8   , 16295.5   ,
 20417.2   , 24079.2   , 27234.6   , 29881.9   , 32049.1   , 33792.3   ,
 35191.4   , 36316.2   , 37215.    , 37921.1   , 38460.8   , 38857.1   ,
 39135.6   , 39326.3   , 39454.2   , 39536.1   , 39584.    , 39604.9   ,
 39601.4   , 39574.2   , 39525.9   , 39461.1   , 39382.9   , 39291.5   ,
 39185.1   , 39061.4   , 38919.1   , 38759.7   , 38585.5   , 38397.    ,
 38192.2   , 37968.    , 37720.6   , 37446.7   , 37144.6   , 36813.    ,
 36450.    , 36051.6   , 35613.1   , 35129.2   , 34594.9   , 34006.5   ,
 33361.3   , 32656.6   , 31889.8   , 31058.7   , 30162.3   , 29200.8   ,
 28176.8   , 27094.7   , 25960.7   , 24782.1   , 23567.9   , 22327.8   ,
 21072.6   , 19813.6   , 18562.1   , 17328.8   , 16584.1   , 15422.1   ,
 14302.    , 13229.5   , 12209.2   , 11244.    , 10335.6   ,  9484.41  ,
  8689.96  ,  7950.94  ,  7265.4   ,  6630.93  ,  6044.83  ,  5504.2   ,
  5006.08  ,  4547.47  ,  4125.48  ,  3737.31  ,  3380.32  ,  3051.98  ,
  2749.99  ,  2472.19  ,  2216.62  ,  1981.49  ,  1765.2   ,  1566.32  ,
  1383.59  ,  1215.93  ,  1062.46  ,   922.48  ,   795.498 ,   681.247 ,
   579.716 ,   491.177 ,   416.236 ,   355.887 }
,
{   95.1781,  1295.03  ,  4605.4   ,  9614.58  , 15328.8   , 20987.7   ,
 26201.3   , 30809.6   , 34758.7   , 38052.4   , 40732.    , 42877.9   ,
 44595.5   , 45971.4   , 47064.3   , 47915.6   , 48558.3   , 49022.8   ,
 49344.7   , 49562.8   , 49706.7   , 49796.4   , 49845.6   , 49861.6   ,
 49846.1   , 49800.7   , 49730.3   , 49640.5   , 49533.8   , 49409.1   ,
 49263.8   , 49094.9   , 48902.5   , 48689.4   , 48457.9   , 48206.8   ,
 47932.7   , 47630.8   , 47296.3   , 46925.9   , 46518.1   , 46070.9   ,
 45580.1   , 45039.7   , 44442.8   , 43782.9   , 43054.2   , 42253.    ,
 41375.8   , 40419.1   , 39379.9   , 38256.1   , 37047.8   , 35757.4   ,
 34390.5   , 32954.5   , 31459.    , 29915.2   , 28335.9   , 26735.1   ,
 25127.6   , 23528.1   , 21951.1   , 20409.8   , 19502.9   , 18070.7   ,
 16700.1   , 15397.1   , 14165.5   , 13007.6   , 11924.1   , 10914.1   ,
  9976.    ,  9107.15  ,  8304.36  ,  7564.05  ,  6882.4   ,  6255.51  ,
  5679.45  ,  5150.39  ,  4664.73  ,  4218.96  ,  3809.81  ,  3434.26  ,
  3089.5   ,  2772.96  ,  2482.28  ,  2215.35  ,  1970.24  ,  1745.27  ,
  1538.93  ,  1349.95  ,  1177.25  ,  1019.99  ,   877.564 ,   749.617 ,
   636.09  ,   537.247 ,   453.735 ,   386.639 }
,
{  126.848,  1711.46 ,  6033.72 , 12504.1  , 19819.3  , 27012.6  ,
 33604.1  , 39399.7  , 44339.4  , 48434.6  , 51745.9  , 54387.1  ,
 56495.2  , 58177.4  , 59505.2  , 60529.8  , 61293.   , 61835.8  ,
 62207.2  , 62456.1  , 62617.3  , 62714.4  , 62763.   , 62769.8  ,
 62736.2  , 62665.7  , 62565.6  , 62442.3  , 62297.   , 62127.2  ,
 61928.8  , 61699.3  , 61440.7  , 61157.2  , 60849.6  , 60514.8  ,
 60147.   , 59739.8  , 59287.7  , 58787.9  , 58238.5  , 57635.1  ,
 56970.8  , 56236.8  , 55424.3  , 54525.1  , 53533.4  , 52444.8  ,
 51254.7  , 49958.7  , 48553.7  , 47039.1  , 45417.   , 43693.8  ,
 41878.8  , 39983.9  , 38023.5  , 36014.1  , 33973.6  , 31921.5  ,
 29877.4  , 27860.1  , 25887.3  , 24713.6  , 22880.3  , 21126.4  ,
 19459.6  , 17885.5  , 16406.8  , 15024.6  , 13737.8  , 12544.1  ,
 11440.2  , 10421.8  ,  9484.23 ,  8622.38 ,  7831.13 ,  7105.35 ,
  6440.07 ,  5830.49 ,  5272.08 ,  4760.57 ,  4292.   ,  3862.73 ,
  3469.39 ,  3108.91 ,  2778.5  ,  2475.63 ,  2198.05 ,  1943.72 ,
  1710.88 ,  1498.01 ,  1303.82 ,  1127.28 ,   967.66 ,   824.492,
   697.656,   587.401,   494.409,   419.868}
,
{  168.915,  2259.69 ,  7897.9  , 16248.6  , 25606.3  , 34744.8  ,
 43073.6  , 50358.8  , 56533.9  , 61622.2  , 65712.2  , 68962.4  ,
 71549.5  , 73604.9  , 75216.   , 76446.8  , 77350.8  , 77983.4  ,
 78411.4  , 78694.7  , 78874.1  , 78977.7  , 79022.3  , 79013.7  ,
 78953.7  , 78848.9  , 78709.4  , 78541.3  , 78343.7  , 78112.3  ,
 77842.   , 77531.8  , 77186.6  , 76810.3  , 76401.4  , 75953.8  ,
 75459.3  , 74909.8  , 74299.7  , 73626.7  , 72886.8  , 72072.1  ,
 71172.   , 70174.6  , 69068.7  , 67845.6  , 66498.9  , 65022.8  ,
 63411.4  , 61659.9  , 59766.3  , 57732.4  , 55565.   , 53275.3  ,
 50878.4  , 48392.3  , 45838.2  , 43239.3  , 40620.8  , 38008.5  ,
 35427.4  , 32901.   , 31379.8  , 29030.7  , 26783.3  , 24648.2  ,
 22632.8  , 20741.   , 18974.1  , 17331.   , 15808.8  , 14402.8  ,
 13107.6  , 11917.   , 10824.3  ,  9822.81 ,  8905.78 ,  8066.62 ,
  7299.15 ,  6597.41 ,  5955.86 ,  5369.33 ,  4833.05 ,  4342.66 ,
  3894.15 ,  3483.87 ,  3108.51 ,  2765.08 ,  2450.9  ,  2163.58 ,
  1901.03 ,  1661.42 ,  1443.22 ,  1245.21 ,  1066.46 ,   906.4  ,
   764.818,   641.939,   538.48 ,   455.731}
,
{  224.785,  2980.76 , 10329.   , 21097.6  , 33059.5  , 44662.9  ,
 55181.5  , 64334.2  , 72049.   , 78367.3  , 83416.8  , 87416.1  ,
 90590.3  , 93100.1  , 95052.5  , 96528.1  , 97595.6  , 98331.3  ,
 98823.8  , 99145.2  , 99343.5  , 99451.7  , 99487.   , 99454.1  ,
 99356.6  , 99205.7  , 99013.8  , 98785.2  , 98516.7  , 98201.6  ,
 97834.5  , 97418.   , 96959.1  , 96460.1  , 95915.6  , 95316.   ,
 94650.3  , 93908.9  , 93087.5  , 92182.4  , 91185.5  , 90084.4  ,
 88863.8  , 87508.3  , 86005.   , 84344.7  , 82519.6  , 80522.   ,
 78344.9  , 75984.2  , 73440.7  , 70721.2  , 67839.   , 64812.6  ,
 61664.8  , 58422.1  , 55114.9  , 51775.5  , 48437.7  , 45134.9  ,
 41898.1  , 39924.2  , 36911.4  , 34028.2  , 31289.4  , 28704.7  ,
 26279.9  , 24016.9  , 21914.5  , 19968.7  , 18173.8  , 16522.5  ,
 15006.7  , 13617.6  , 12346.4  , 11184.4  , 10122.9  ,  9153.69 ,
  8269.11 ,  7461.9  ,  6725.32 ,  6053.18 ,  5439.76 ,  4879.85 ,
  4368.72 ,  3902.02 ,  3475.84 ,  3086.66 ,  2731.3  ,  2406.93 ,
  2111.08 ,  1841.58 ,  1596.62 ,  1374.7  ,  1174.71 ,   995.911,
   838.009,   701.184,   586.179,   494.396}
,
{   298.915,   3928.39 ,  13497.   ,  27372.5  ,  42653.4  ,  57378.2  ,
  70655.7  ,  82148.6  ,  91781.5  ,  99622.1  , 105854.   , 110775.   ,
 114668.   , 117730.   , 120093.   , 121858.   , 123115.   , 123970.   ,
 124535.   , 124898.   , 125116.   , 125225.   , 125243.   , 125173.   ,
 125024.   , 124812.   , 124550.   , 124239.   , 123875.   , 123446.   ,
 122950.   , 122394.   , 121786.   , 121124.   , 120397.   , 119592.   ,
 118695.   , 117697.   , 116593.   , 115376.   , 114032.   , 112542.   ,
 110886.   , 109045.   , 107006.   , 104756.   , 102288.   ,  99589.6  ,
  96655.4  ,  93483.6  ,  90080.4  ,  86460.9  ,  82647.4  ,  78668.4  ,
  74557.5  ,  70353.1  ,  66097.4  ,  61834.4  ,  57608.1  ,  53460.   ,
  50896.4  ,  47028.9  ,  43326.1  ,  39807.9  ,  36488.   ,  33374.6  ,
  30470.7  ,  27774.8  ,  25282.2  ,  22985.4  ,  20874.9  ,  18940.1  ,
  17169.7  ,  15551.9  ,  14075.3  ,  12728.6  ,  11501.1  ,  10382.7  ,
   9363.86 ,   8435.92 ,   7590.74 ,   6820.9  ,   6119.62 ,   5480.7  ,
   4898.51 ,   4367.94 ,   3884.37 ,   3443.62 ,   3041.95 ,   2676.03 ,
   2342.9  ,   2040.03 ,   1765.23 ,   1516.73 ,   1293.17 ,   1093.63 ,
    917.691,    765.477,    637.755,    536.041}
,
{   397.176,   5172.98 ,  17622.2  ,  35487.5  ,  54995.1  ,  73671.7  ,
  90423.5  , 104848.   , 116868.   , 126592.   , 134281.   , 140335.   ,
 145109.   , 148842.   , 151698.   , 153804.   , 155281.   , 156271.   ,
 156920.   , 157328.   , 157563.   , 157667.   , 157656.   , 157533.   ,
 157313.   , 157019.   , 156663.   , 156243.   , 155747.   , 155165.   ,
 154499.   , 153761.   , 152955.   , 152075.   , 151104.   , 150022.   ,
 148815.   , 147473.   , 145991.   , 144354.   , 142540.   , 140523.   ,
 138276.   , 135779.   , 133017.   , 129976.   , 126643.   , 123007.   ,
 119063.   , 114817.   , 110283.   , 105488.   , 100468.   ,  95265.   ,
  89927.   ,  84508.4  ,  79066.7  ,  73659.7  ,  68343.   ,  65011.   ,
  60042.8  ,  55282.6  ,  50757.5  ,  46487.   ,  42482.7  ,  38749.2  ,
  35285.4  ,  32085.4  ,  29139.6  ,  26435.8  ,  23960.1  ,  21697.7  ,
  19633.4  ,  17751.9  ,  16038.6  ,  14479.5  ,  13061.2  ,  11771.5  ,
  10598.9  ,   9532.75 ,   8563.49 ,   7682.23 ,   6880.92 ,   6152.23 ,
   5489.49 ,   4886.67 ,   4338.32 ,   3839.5  ,   3385.81 ,   2973.3  ,
   2598.51 ,   2258.41 ,   1950.41 ,   1672.39 ,   1422.7  ,   1200.22 ,
   1004.36 ,    835.184,    693.471,    580.853}
,
{   527.299,   6806.23 ,  22989.9  ,  45974.8  ,  70863.   ,  94540.6  ,
 115665.   , 133759.   , 148751.   , 160804.   , 170289.   , 177735.   ,
 183586.   , 188133.   , 191579.   , 194087.   , 195817.   , 196964.   ,
 197706.   , 198161.   , 198412.   , 198502.   , 198444.   , 198245.   ,
 197931.   , 197528.   , 197046.   , 196476.   , 195803.   , 195017.   ,
 194128.   , 193150.   , 192083.   , 190910.   , 189610.   , 188155.   ,
 186532.   , 184732.   , 182742.   , 180539.   , 178088.   , 175357.   ,
 172312.   , 168931.   , 165198.   , 161093.   , 156602.   , 151714.   ,
 146431.   , 140768.   , 134755.   , 128435.   , 121861.   , 115093.   ,
 108202.   , 101261.   ,  94346.1  ,  87531.6  ,  83199.   ,  76813.1  ,
  70687.8  ,  64861.1  ,  59360.   ,  54201.4  ,  49392.8  ,  44933.6  ,
  40816.7  ,  37030.1  ,  33558.1  ,  30382.6  ,  27484.3  ,  24843.2  ,
  22439.5  ,  20253.8  ,  18267.8  ,  16464.2  ,  14826.7  ,  13340.4  ,
  11991.4  ,  10767.2  ,   9656.17 ,   8647.89 ,   7732.79 ,   6902.18 ,
   6148.19 ,   5463.71 ,   4842.3  ,   4278.16 ,   3766.09 ,   3301.43 ,
   2880.09 ,   2498.5  ,   2153.58 ,   1842.81 ,   1564.2  ,   1316.37 ,
   1098.54 ,    910.694,    753.607,    629.031}
,
{   699.447,   8947.74 ,  29969.3  ,  59519.9  ,  91253.9  , 121256.   ,
 147884.   , 170570.   , 189257.   , 204189.   , 215886.   , 225045.   ,
 232212.   , 237745.   , 241897.   , 244875.   , 246898.   , 248224.   ,
 249070.   , 249576.   , 249836.   , 249897.   , 249768.   , 249464.   ,
 249024.   , 248476.   , 247824.   , 247051.   , 246139.   , 245083.   ,
 243902.   , 242608.   , 241193.   , 239629.   , 237884.   , 235930.   ,
 233752.   , 231339.   , 228667.   , 225698.   , 222386.   , 218687.   ,
 214565.   , 209998.   , 204960.   , 199431.   , 193392.   , 186840.   ,
 179788.   , 172268.   , 164331.   , 156041.   , 147476.   , 138723.   ,
 129878.   , 121041.   , 112309.   , 103773.   ,  98461.7  ,  90574.2  ,
  83063.5  ,  75968.1  ,  69312.4  ,  63108.3  ,  57356.6  ,  52049.2  ,
  47171.2  ,  42702.4  ,  38619.5  ,  34897.3  ,  31509.7  ,  28430.7  ,
  25635.1  ,  23098.4  ,  20798.2  ,  18713.2  ,  16823.6  ,  15111.6  ,
  13560.6  ,  12155.6  ,  10882.8  ,   9729.77 ,   8685.28 ,   7739.04 ,
   6881.78 ,   6105.09 ,   5401.38 ,   4763.82 ,   4186.28 ,   3663.29 ,
   3190.01 ,   2762.22 ,   2376.3  ,   2029.24 ,   1718.65 ,   1442.83 ,
   1200.81 ,    992.423,    818.458,    680.784}
,
{   926.973,  11753.4  ,  39038.4  ,  77003.9  , 117443.   , 155442.   ,
 188991.   , 217420.   , 240701.   , 259189.   , 273615.   , 284877.   ,
 293652.   , 300379.   , 305371.   , 308899.   , 311260.   , 312792.   ,
 313752.   , 314309.   , 314570.   , 314579.   , 314346.   , 313900.   ,
 313292.   , 312550.   , 311668.   , 310622.   , 309388.   , 307977.   ,
 306413.   , 304703.   , 302823.   , 300732.   , 298391.   , 295768.   ,
 292850.   , 289617.   , 286026.   , 282021.   , 277543.   , 272539.   ,
 266972.   , 260810.   , 254025.   , 246591.   , 238493.   , 229738.   ,
 220361.   , 210419.   , 199992.   , 189173.   , 178074.   , 166817.   ,
 155531.   , 144346.   , 133384.   , 126455.   , 116292.   , 106602.   ,
  97439.1  ,  88839.5  ,  80821.7  ,  73389.3  ,  66533.6  ,  60236.   ,
  54471.4  ,  49209.5  ,  44417.6  ,  40061.7  ,  36107.6  ,  32522.1  ,
  29273.4  ,  26331.8  ,  23669.4  ,  21260.4  ,  19081.3  ,  17110.3  ,
  15327.9  ,  13716.1  ,  12258.7  ,  10941.   ,   9749.49 ,   8672.2  ,
   7698.13 ,   6817.39 ,   6021.05 ,   5301.05 ,   4650.19 ,   4062.01 ,
   3530.84 ,   3051.68 ,   2620.26 ,   2233.01 ,   1887.08 ,   1580.41 ,
   1311.76 ,   1080.81 ,    888.342,    736.336}
,
{  1227.43 ,  15427.   ,  50814.8  ,  99558.6  , 151062.   , 199169.   ,
 241417.   , 277027.   , 306016.   , 328898.   , 346685.   , 360532.   ,
 371270.   , 379437.   , 385430.   , 389599.   , 392350.   , 394117.   ,
 395202.   , 395809.   , 396054.   , 395979.   , 395597.   , 394959.   ,
 394129.   , 393127.   , 391935.   , 390518.   , 388859.   , 386982.   ,
 384916.   , 382653.   , 380150.   , 377352.   , 374210.   , 370696.   ,
 366791.   , 362457.   , 357626.   , 352223.   , 346171.   , 339411.   ,
 331903.   , 323606.   , 314484.   , 304509.   , 293680.   , 282025.   ,
 269609.   , 256525.   , 242890.   , 228842.   , 214536.   , 200140.   ,
 185823.   , 171750.   , 162709.   , 149608.   , 137097.   , 125252.   ,
 114127.   , 103749.   ,  94127.8  ,  85254.8  ,  77107.9  ,  69655.2  ,
  62858.3  ,  56674.5  ,  51059.6  ,  45968.8  ,  41358.2  ,  37186.7  ,
  33414.8  ,  30005.8  ,  26926.   ,  24144.3  ,  21632.3  ,  19364.4  ,
  17317.1  ,  15469.1  ,  13801.2  ,  12296.   ,  10937.7  ,   9711.92 ,
   8605.88 ,   7607.86 ,   6707.35 ,   5894.87 ,   5161.95 ,   4501.01 ,
   3905.35 ,   3369.11 ,   2887.26 ,   2455.56 ,   2070.63 ,   1729.97 ,
   1432.04 ,   1176.34 ,    963.593,    795.921}
,
{  1624.24 ,  20233.7  ,  66097.1  , 128638.   , 194200.   , 255073.   ,
 308255.   , 352838.   , 388915.   , 417224.   , 439154.   , 456177.   ,
 469308.   , 479212.   , 486391.   , 491305.   , 494509.   , 496541.   ,
 497762.   , 498412.   , 498616.   , 498410.   , 497822.   , 496929.   ,
 495803.   , 494451.   , 492839.   , 490925.   , 488703.   , 486218.   ,
 483491.   , 480491.   , 477153.   , 473407.   , 469195.   , 464494.   ,
 459271.   , 453455.   , 446952.   , 439659.   , 431487.   , 422373.   ,
 412264.   , 401110.   , 388869.   , 375521.   , 361086.   , 345629.   ,
 329260.   , 312119.   , 294377.   , 276229.   , 257890.   , 239583.   ,
 221526.   , 203919.   , 192839.   , 176677.   , 161351.   , 146940.   ,
 133488.   , 121013.   , 109508.   ,  98947.5  ,  89291.9  ,  80492.3  ,
  72493.6  ,  65238.3  ,  58667.6  ,  52724.1  ,  47353.6  ,  42504.1  ,
  38127.4  ,  34178.9  ,  30618.   ,  27407.4  ,  24513.3  ,  21904.9  ,
  19554.5  ,  17436.8  ,  15529.1  ,  13810.8  ,  12263.2  ,  10869.5  ,
   9614.51 ,   8484.41 ,   7466.86 ,   6550.73 ,   5726.06 ,   4983.96 ,
   4316.55 ,   3716.96 ,   3179.25 ,   2698.43 ,   2270.5  ,   1892.44 ,
   1562.34 ,   1279.5  ,   1044.57 ,    859.788}
,
{  2148.05 ,  26518.5  ,  85916.2  , 166110.   , 249524.   , 326518.   ,
 393435.   , 449227.   , 494101.   , 529115.   , 556151.   , 577069.   ,
 593115.   , 605112.   , 613692.   , 619474.   , 623200.   , 625531.   ,
 626897.   , 627577.   , 627702.   , 627302.   , 626430.   , 625199.   ,
 623677.   , 621854.   , 619676.   , 617097.   , 614138.   , 610857.   ,
 607256.   , 603272.   , 598816.   , 593797.   , 588162.   , 581881.   ,
 574890.   , 567081.   , 558322.   , 548482.   , 537463.   , 525194.   ,
 511606.   , 496637.   , 480246.   , 462434.   , 443261.   , 422846.   ,
 401359.   , 379006.   , 356033.   , 332711.   , 309330.   , 286179.   ,
 263528.   , 249022.   , 228134.   , 208290.   , 189604.   , 172145.   ,
 155944.   , 141000.   , 127284.   , 114748.   , 103331.   ,  92960.6  ,
  83563.   ,  75061.4  ,  67380.9  ,  60448.7  ,  54197.5  ,  48563.3  ,
  43487.7  ,  38916.8  ,  34801.7  ,  31097.9  ,  27765.   ,  24766.5  ,
  22069.6  ,  19644.2  ,  17463.5  ,  15503.1  ,  13741.1  ,  12157.5  ,
  10734.4  ,   9455.67 ,   8306.76 ,   7274.57 ,   6347.42 ,   5514.87 ,
   4767.71 ,   4097.86 ,   3498.34 ,   2963.3  ,   2487.98 ,   2068.8  ,
   1703.41 ,   1390.84 ,   1131.64 ,    928.201}
,
{  2838.97,  34730.1 , 111603.  , 214370.  , 320442.  , 417788.  ,
 501953.  , 571739.  , 627529.  , 670822.  , 704151.  , 729848.  ,
 749441.  , 763951.  , 774186.  , 780976.  , 785305.  , 787971.  ,
 789487.  , 790174.  , 790162.  , 789481.  , 788228.  , 786546.  ,
 784495.  , 782037.  , 779098.  , 775637.  , 771715.  , 767389.  ,
 762627.  , 757329.  , 751373.  , 744655.  , 737127.  , 728739.  ,
 719377.  , 708883.  , 697081.  , 683818.  , 668985.  , 652495.  ,
 634260.  , 614209.  , 592316.  , 568622.  , 543252.  , 516400.  ,
 488317.  , 459305.  , 429706.  , 399892.  , 370243.  , 341124.  ,
 322138.  , 295139.  , 269433.  , 245183.  , 222496.  , 201427.  ,
 181983.  , 164135.  , 147827.  , 132981.  , 119506.  , 107305.  ,
  96279.  ,  86328.4 ,  77358.2 ,  69279.3 ,  62007.6 ,  55465.5 ,
  49582.3 ,  44293.4 ,  39540.  ,  35269.2 ,  31432.9 ,  27987.9 ,
  24895.  ,  22118.8 ,  19627.6 ,  17392.5 ,  15387.5 ,  13589.4 ,
  11977.  ,  10531.1 ,   9234.89,   8072.87,   7031.34,   6098.1 ,
   5262.36,   4514.64,   3846.8 ,   3251.94,   2724.47,   2260.12,
   1856.04,   1510.92,   1225.22,   1001.44}
,
{  3749.59,  45451.9 , 144877.  , 276491.  , 411313.  , 534340.  ,
 640156.  , 727409.  , 796734.  , 850254.  , 891334.  , 922890.  ,
 946795.  , 964320.  , 976501.  , 984464.  , 989485.  , 992523.  ,
 994190.  , 994846.  , 994613.  , 993536.  , 991773.  , 989494.  ,
 986733.  , 983420.  , 979458.  , 974838.  , 969658.  , 963954.  ,
 957649.  , 950593.  , 942629.  , 933650.  , 923606.  , 912399.  ,
 899852.  , 885742.  , 869846.  , 851993.  , 832058.  , 809929.  ,
 785497.  , 758696.  , 729535.  , 698126.  , 664688.  , 629516.  ,
 592977.  , 555499.  , 517555.  , 479640.  , 442242.  , 417413.  ,
 382520.  , 349208.  , 317717.  , 288207.  , 260770.  , 235433.  ,
 212169.  , 190912.  , 171567.  , 154019.  , 138143.  , 123808.  ,
 110885.  ,  99248.3 ,  88781.  ,  79371.4 ,  70917.2 ,  63324.8 ,
  56508.8 ,  50391.7 ,  44903.7 ,  39981.5 ,  35568.  ,  31612.  ,
  28067.  ,  24891.2 ,  22046.9 ,  19500.3 ,  17220.6 ,  15180.4 ,
  13354.7 ,  11721.2 ,  10259.8 ,   8952.66,   7783.6 ,   6738.35,
   5804.3 ,   4970.39,   4227.08,   3566.3 ,   2981.47,   2467.53,
   2021.05,   1640.35,   1325.73,   1079.79}
,
{4.94883e+03, 5.94438e+04, 1.87952e+05, 3.56415e+05, 5.27700e+05,
 6.83121e+05, 8.16107e+05, 9.25149e+05, 1.01126e+06, 1.07740e+06,
 1.12803e+06, 1.16677e+06, 1.19591e+06, 1.21704e+06, 1.23151e+06,
 1.24083e+06, 1.24665e+06, 1.25009e+06, 1.25190e+06, 1.25247e+06,
 1.25189e+06, 1.25027e+06, 1.24783e+06, 1.24476e+06, 1.24104e+06,
 1.23658e+06, 1.23125e+06, 1.22512e+06, 1.21829e+06, 1.21076e+06,
 1.20240e+06, 1.19299e+06, 1.18235e+06, 1.17037e+06, 1.15697e+06,
 1.14199e+06, 1.12516e+06, 1.10619e+06, 1.08480e+06, 1.06080e+06,
 1.03405e+06, 1.00440e+06, 9.71723e+05, 9.35984e+05, 8.97263e+05,
 8.55781e+05, 8.11883e+05, 7.66008e+05, 7.18682e+05, 6.70501e+05,
 6.22103e+05, 5.74135e+05, 5.27205e+05, 4.96624e+05, 4.53455e+05,
 4.12541e+05, 3.74126e+05, 3.38357e+05, 3.05293e+05, 2.74918e+05,
 2.47160e+05, 2.21902e+05, 1.99000e+05, 1.78294e+05, 1.59613e+05,
 1.42790e+05, 1.27658e+05, 1.14062e+05, 1.01855e+05, 9.09013e+04,
 8.10774e+04, 7.22700e+04, 6.43768e+04, 5.73052e+04, 5.09720e+04,
 4.53018e+04, 4.02270e+04, 3.56867e+04, 3.16259e+04, 2.79951e+04,
 2.47500e+04, 2.18504e+04, 1.92601e+04, 1.69468e+04, 1.48812e+04,
 1.30371e+04, 1.13909e+04, 9.92164e+03, 8.61048e+03, 7.44074e+03,
 6.39768e+03, 5.46841e+03, 4.64180e+03, 3.90842e+03, 3.26056e+03,
 2.69225e+03, 2.19937e+03, 1.77979e+03, 1.43362e+03, 1.16357e+03}
,
{6.52695e+03, 7.76919e+04, 2.43683e+05, 4.59197e+05, 6.76704e+05,
 8.72979e+05, 1.04005e+06, 1.17626e+06, 1.28316e+06, 1.36490e+06,
 1.42729e+06, 1.47482e+06, 1.51030e+06, 1.53574e+06, 1.55289e+06,
 1.56380e+06, 1.57052e+06, 1.57442e+06, 1.57634e+06, 1.57672e+06,
 1.57564e+06, 1.57328e+06, 1.56994e+06, 1.56580e+06, 1.56081e+06,
 1.55480e+06, 1.54767e+06, 1.53955e+06, 1.53056e+06, 1.52063e+06,
 1.50952e+06, 1.49696e+06, 1.48275e+06, 1.46678e+06, 1.44892e+06,
 1.42888e+06, 1.40630e+06, 1.38078e+06, 1.35203e+06, 1.31983e+06,
 1.28398e+06, 1.24431e+06, 1.20070e+06, 1.15318e+06, 1.10193e+06,
 1.04735e+06, 9.89955e+05, 9.30376e+05, 8.69358e+05, 8.07716e+05,
 7.46295e+05, 6.85913e+05, 6.45801e+05, 5.89872e+05, 5.36706e+05,
 4.86668e+05, 4.39992e+05, 3.96790e+05, 3.57070e+05, 3.20757e+05,
 2.87715e+05, 2.57765e+05, 2.30699e+05, 2.06301e+05, 1.84347e+05,
 1.64622e+05, 1.46917e+05, 1.31041e+05, 1.16814e+05, 1.04069e+05,
 9.26588e+04, 8.24465e+04, 7.33100e+04, 6.51388e+04, 5.78336e+04,
 5.13052e+04, 4.54732e+04, 4.02652e+04, 3.56164e+04, 3.14683e+04,
 2.77682e+04, 2.44689e+04, 2.15278e+04, 1.89068e+04, 1.65716e+04,
 1.44913e+04, 1.26383e+04, 1.09882e+04, 9.51880e+03, 8.21079e+03,
 7.04696e+03, 6.01229e+03, 5.09382e+03, 4.28055e+03, 3.56348e+03,
 2.93558e+03, 2.39194e+03, 1.92991e+03, 1.54937e+03, 1.25310e+03}
,
{8.60203e+03, 1.01476e+05, 3.15752e+05, 5.91306e+05, 8.67392e+05,
 1.11517e+06, 1.32497e+06, 1.49505e+06, 1.62771e+06, 1.72871e+06,
 1.80559e+06, 1.86387e+06, 1.90704e+06, 1.93761e+06, 1.95789e+06,
 1.97065e+06, 1.97840e+06, 1.98277e+06, 1.98477e+06, 1.98482e+06,
 1.98302e+06, 1.97965e+06, 1.97512e+06, 1.96956e+06, 1.96285e+06,
 1.95477e+06, 1.94526e+06, 1.93456e+06, 1.92273e+06, 1.90959e+06,
 1.89482e+06, 1.87806e+06, 1.85911e+06, 1.83785e+06, 1.81402e+06,
 1.78720e+06, 1.75688e+06, 1.72259e+06, 1.68400e+06, 1.64085e+06,
 1.59289e+06, 1.53991e+06, 1.48184e+06, 1.41883e+06, 1.35125e+06,
 1.27971e+06, 1.20496e+06, 1.12792e+06, 1.04962e+06, 9.71134e+05,
 8.93567e+05, 8.17931e+05, 7.68609e+05, 6.99529e+05, 6.34329e+05,
 5.73375e+05, 5.16865e+05, 4.64852e+05, 4.17272e+05, 3.73967e+05,
 3.34718e+05, 2.99265e+05, 2.67326e+05, 2.38610e+05, 2.12836e+05,
 1.89726e+05, 1.69026e+05, 1.50498e+05, 1.33923e+05, 1.19102e+05,
 1.05855e+05, 9.40185e+04, 8.34475e+04, 7.40101e+04, 6.55882e+04,
 5.80756e+04, 5.13770e+04, 4.54069e+04, 4.00883e+04, 3.53520e+04,
 3.11361e+04, 2.73847e+04, 2.40478e+04, 2.10804e+04, 1.84422e+04,
 1.60972e+04, 1.40132e+04, 1.21613e+04, 1.05160e+04, 9.05451e+03,
 7.75698e+03, 6.60589e+03, 5.58618e+03, 4.68507e+03, 3.89206e+03,
 3.19891e+03, 2.59980e+03, 2.09146e+03, 1.67348e+03, 1.34874e+03}
,
{1.13287e+04, 1.32456e+05, 4.08897e+05, 7.61035e+05, 1.11133e+06,
 1.42402e+06, 1.68739e+06, 1.89966e+06, 2.06421e+06, 2.18901e+06,
 2.28371e+06, 2.35515e+06, 2.40760e+06, 2.44428e+06, 2.46823e+06,
 2.48312e+06, 2.49203e+06, 2.49690e+06, 2.49889e+06, 2.49841e+06,
 2.49559e+06, 2.49089e+06, 2.48478e+06, 2.47733e+06, 2.46830e+06,
 2.45746e+06, 2.44485e+06, 2.43076e+06, 2.41518e+06, 2.39778e+06,
 2.37811e+06, 2.35576e+06, 2.33054e+06, 2.30223e+06, 2.27043e+06,
 2.23450e+06, 2.19379e+06, 2.14777e+06, 2.09605e+06, 2.03831e+06,
 1.97424e+06, 1.90362e+06, 1.82650e+06, 1.74322e+06, 1.65442e+06,
 1.56101e+06, 1.46408e+06, 1.36490e+06, 1.26487e+06, 1.16542e+06,
 1.06793e+06, 1.00305e+06, 9.13329e+05, 8.28367e+05, 7.48728e+05,
 6.74745e+05, 6.06553e+05, 5.44114e+05, 4.87260e+05, 4.35727e+05,
 3.89190e+05, 3.47287e+05, 3.09642e+05, 2.75879e+05, 2.45642e+05,
 2.18587e+05, 1.94399e+05, 1.72787e+05, 1.53486e+05, 1.36256e+05,
 1.20883e+05, 1.07171e+05, 9.49459e+04, 8.40514e+04, 7.43470e+04,
 6.57066e+04, 5.80173e+04, 5.11776e+04, 4.50966e+04, 3.96925e+04,
 3.48921e+04, 3.06297e+04, 2.68463e+04, 2.34892e+04, 2.05111e+04,
 1.78698e+04, 1.55276e+04, 1.34509e+04, 1.16100e+04, 9.97840e+03,
 8.53295e+03, 7.25337e+03, 6.12218e+03, 5.12455e+03, 4.24827e+03,
 3.48373e+03, 2.82403e+03, 2.26521e+03, 1.80650e+03, 1.45084e+03}
,
{1.49118e+04, 1.72786e+05, 5.29220e+05, 9.79002e+05, 1.42329e+06,
 1.81774e+06, 2.14823e+06, 2.41304e+06, 2.61710e+06, 2.77127e+06,
 2.88792e+06, 2.97542e+06, 3.03909e+06, 3.08301e+06, 3.11124e+06,
 3.12861e+06, 3.13883e+06, 3.14420e+06, 3.14605e+06, 3.14474e+06,
 3.14052e+06, 3.13405e+06, 3.12584e+06, 3.11584e+06, 3.10372e+06,
 3.08921e+06, 3.07255e+06, 3.05403e+06, 3.03349e+06, 3.01042e+06,
 2.98422e+06, 2.95444e+06, 2.92089e+06, 2.88321e+06, 2.84072e+06,
 2.79257e+06, 2.73796e+06, 2.67626e+06, 2.60706e+06, 2.52990e+06,
 2.44443e+06, 2.35051e+06, 2.24838e+06, 2.13868e+06, 2.02243e+06,
 1.90094e+06, 1.77575e+06, 1.64864e+06, 1.52145e+06, 1.39603e+06,
 1.31084e+06, 1.19439e+06, 1.08371e+06, 9.79629e+05, 8.82708e+05,
 7.93210e+05, 7.11163e+05, 6.36400e+05, 5.68616e+05, 5.07406e+05,
 4.52313e+05, 4.02848e+05, 3.58524e+05, 3.18864e+05, 2.83415e+05,
 2.51759e+05, 2.23508e+05, 1.98309e+05, 1.75844e+05, 1.55824e+05,
 1.37990e+05, 1.22112e+05, 1.07981e+05, 9.54109e+04, 8.42347e+04,
 7.43029e+04, 6.54816e+04, 5.76507e+04, 5.07025e+04, 4.45405e+04,
 3.90785e+04, 3.42388e+04, 2.99524e+04, 2.61572e+04, 2.27979e+04,
 1.98251e+04, 1.71948e+04, 1.48678e+04, 1.28096e+04, 1.09895e+04,
 9.38052e+03, 7.95922e+03, 6.70535e+03, 5.60175e+03, 4.63424e+03,
 3.79162e+03, 3.06581e+03, 2.45199e+03, 1.94900e+03, 1.55979e+03}
,
{1.96177e+04, 2.25264e+05, 6.84570e+05, 1.25880e+06, 1.82206e+06,
 2.31951e+06, 2.73406e+06, 3.06428e+06, 3.31724e+06, 3.50770e+06,
 3.65133e+06, 3.75844e+06, 3.83564e+06, 3.88812e+06, 3.92137e+06,
 3.94161e+06, 3.95327e+06, 3.95913e+06, 3.96061e+06, 3.95808e+06,
 3.95196e+06, 3.94314e+06, 3.93213e+06, 3.91872e+06, 3.90245e+06,
 3.88313e+06, 3.86119e+06, 3.83685e+06, 3.80973e+06, 3.77910e+06,
 3.74419e+06, 3.70459e+06, 3.65999e+06, 3.60979e+06, 3.55299e+06,
 3.48846e+06, 3.41525e+06, 3.33268e+06, 3.24018e+06, 3.13722e+06,
 3.02343e+06, 2.89883e+06, 2.76398e+06, 2.61999e+06, 2.46836e+06,
 2.31096e+06, 2.14998e+06, 1.98778e+06, 1.82680e+06, 1.66936e+06,
 1.56424e+06, 1.42012e+06, 1.28412e+06, 1.15710e+06, 1.03955e+06,
 9.31611e+05, 8.33154e+05, 7.43839e+05, 6.63177e+05, 5.90591e+05,
 5.25455e+05, 4.67126e+05, 4.14983e+05, 3.68426e+05, 3.26895e+05,
 2.89874e+05, 2.56892e+05, 2.27524e+05, 2.01386e+05, 1.78133e+05,
 1.57455e+05, 1.39077e+05, 1.22751e+05, 1.08255e+05, 9.53909e+04,
 8.39813e+04, 7.38676e+04, 6.49075e+04, 5.69737e+04, 4.99525e+04,
 4.37419e+04, 3.82508e+04, 3.33980e+04, 2.91107e+04, 2.53241e+04,
 2.19807e+04, 1.90291e+04, 1.64237e+04, 1.41243e+04, 1.20954e+04,
 1.03058e+04, 8.72827e+03, 7.33950e+03, 6.11962e+03, 5.05222e+03,
 4.12429e+03, 3.32637e+03, 2.65269e+03, 2.10157e+03, 1.67600e+03}
,
{2.57945e+04, 2.93509e+05, 8.85049e+05, 1.61780e+06, 2.33167e+06,
 2.95876e+06, 3.47857e+06, 3.89019e+06, 4.20370e+06, 4.43896e+06,
 4.61576e+06, 4.74678e+06, 4.84026e+06, 4.90286e+06, 4.94198e+06,
 4.96551e+06, 4.97877e+06, 4.98504e+06, 4.98586e+06, 4.98155e+06,
 4.97286e+06, 4.96094e+06, 4.94619e+06, 4.92822e+06, 4.90642e+06,
 4.88079e+06, 4.85195e+06, 4.81995e+06, 4.78409e+06, 4.74339e+06,
 4.69693e+06, 4.64431e+06, 4.58504e+06, 4.51812e+06, 4.44214e+06,
 4.35570e+06, 4.25768e+06, 4.14730e+06, 4.02383e+06, 3.88665e+06,
 3.73546e+06, 3.57060e+06, 3.39314e+06, 3.20478e+06, 3.00774e+06,
 2.80465e+06, 2.59851e+06, 2.39247e+06, 2.18965e+06, 2.05128e+06,
 1.86383e+06, 1.68619e+06, 1.51971e+06, 1.36523e+06, 1.22309e+06,
 1.09326e+06, 9.75391e+05, 8.68903e+05, 7.73079e+05, 6.87120e+05,
 6.10197e+05, 5.41480e+05, 4.80185e+05, 4.25565e+05, 3.76931e+05,
 3.33655e+05, 2.95167e+05, 2.60953e+05, 2.30554e+05, 2.03557e+05,
 1.79593e+05, 1.58331e+05, 1.39478e+05, 1.22770e+05, 1.07972e+05,
 9.48724e+04, 8.32841e+04, 7.30386e+04, 6.39856e+04, 5.59907e+04,
 4.89339e+04, 4.27082e+04, 3.72180e+04, 3.23784e+04, 2.81134e+04,
 2.43560e+04, 2.10462e+04, 1.81312e+04, 1.55643e+04, 1.33044e+04,
 1.13153e+04, 9.56575e+03, 8.02873e+03, 6.68134e+03, 5.50464e+03,
 4.48356e+03, 3.60705e+03, 2.86824e+03, 2.26486e+03, 1.79988e+03}
,
{3.38966e+04, 3.82212e+05, 1.14364e+06, 2.07824e+06, 2.98267e+06,
 3.77294e+06, 4.42449e+06, 4.93737e+06, 5.32581e+06, 5.61640e+06,
 5.83397e+06, 5.99412e+06, 6.10715e+06, 6.18169e+06, 6.22768e+06,
 6.25498e+06, 6.26998e+06, 6.27653e+06, 6.27620e+06, 6.26939e+06,
 6.25727e+06, 6.24124e+06, 6.22151e+06, 6.19742e+06, 6.16828e+06,
 6.13443e+06, 6.09657e+06, 6.05445e+06, 6.00699e+06, 5.95286e+06,
 5.89109e+06, 5.82124e+06, 5.74245e+06, 5.65318e+06, 5.55154e+06,
 5.43581e+06, 5.30474e+06, 5.15739e+06, 4.99281e+06, 4.81034e+06,
 4.60992e+06, 4.39242e+06, 4.15964e+06, 3.91413e+06, 3.65904e+06,
 3.39806e+06, 3.13521e+06, 2.87463e+06, 2.62019e+06, 2.44954e+06,
 2.21770e+06, 1.99956e+06, 1.79649e+06, 1.60919e+06, 1.43781e+06,
 1.28203e+06, 1.14121e+06, 1.01447e+06, 9.00799e+05, 7.99123e+05,
 7.08365e+05, 6.27474e+05, 5.55466e+05, 4.91419e+05, 4.34494e+05,
 3.83927e+05, 3.39030e+05, 2.99188e+05, 2.63848e+05, 2.32518e+05,
 2.04756e+05, 1.80171e+05, 1.58412e+05, 1.39165e+05, 1.22152e+05,
 1.07121e+05, 9.38521e+04, 8.21446e+04, 7.18213e+04, 6.27240e+04,
 5.47114e+04, 4.76577e+04, 4.14510e+04, 3.59918e+04, 3.11915e+04,
 2.69718e+04, 2.32632e+04, 2.00042e+04, 1.71408e+04, 1.46253e+04,
 1.24162e+04, 1.04773e+04, 8.77743e+03, 7.29032e+03, 5.99409e+03,
 4.87136e+03, 3.90924e+03, 3.09962e+03, 2.43954e+03, 1.93190e+03}
,
{4.45175e+04, 4.97441e+05, 1.47704e+06, 2.66857e+06, 3.81403e+06,
 4.80959e+06, 5.62600e+06, 6.26480e+06, 6.74598e+06, 7.10487e+06,
 7.37253e+06, 7.56813e+06, 7.70461e+06, 7.79321e+06, 7.84722e+06,
 7.87884e+06, 7.89569e+06, 7.90227e+06, 7.90012e+06, 7.88983e+06,
 7.87317e+06, 7.85169e+06, 7.82529e+06, 7.79301e+06, 7.75420e+06,
 7.70963e+06, 7.65995e+06, 7.60446e+06, 7.54157e+06, 7.46960e+06,
 7.38758e+06, 7.29490e+06, 7.19009e+06, 7.07094e+06, 6.93498e+06,
 6.78019e+06, 6.60518e+06, 6.40870e+06, 6.18963e+06, 5.94739e+06,
 5.68238e+06, 5.39631e+06, 5.09199e+06, 4.77311e+06, 4.44414e+06,
 4.11012e+06, 3.77641e+06, 3.44826e+06, 3.22316e+06, 2.92097e+06,
 2.63533e+06, 2.36841e+06, 2.12150e+06, 1.89507e+06, 1.68894e+06,
 1.50244e+06, 1.33451e+06, 1.18389e+06, 1.04921e+06, 9.29069e+05,
 8.22074e+05, 7.26911e+05, 6.42363e+05, 5.67298e+05, 5.00695e+05,
 4.41632e+05, 3.89280e+05, 3.42902e+05, 3.01835e+05, 2.65492e+05,
 2.33347e+05, 2.04934e+05, 1.79833e+05, 1.57675e+05, 1.38126e+05,
 1.20891e+05, 1.05706e+05, 9.23370e+04, 8.05733e+04, 7.02286e+04,
 6.11370e+04, 5.31510e+04, 4.61392e+04, 3.99855e+04, 3.45866e+04,
 2.98512e+04, 2.56986e+04, 2.20576e+04, 1.88657e+04, 1.60679e+04,
 1.36161e+04, 1.14689e+04, 9.59032e+03, 7.95020e+03, 6.52336e+03,
 5.28975e+03, 4.23446e+03, 3.34791e+03, 2.62633e+03, 2.07252e+03}
,
{5.84313e+04, 6.47055e+05, 1.90669e+06, 3.42513e+06, 4.87535e+06,
 6.12916e+06, 7.15176e+06, 7.94708e+06, 8.54307e+06, 8.98628e+06,
 9.31542e+06, 9.55411e+06, 9.71866e+06, 9.82382e+06, 9.88719e+06,
 9.92370e+06, 9.94250e+06, 9.94869e+06, 9.94377e+06, 9.92872e+06,
 9.90605e+06, 9.87732e+06, 9.84202e+06, 9.79882e+06, 9.74733e+06,
 9.68879e+06, 9.62359e+06, 9.55037e+06, 9.46695e+06, 9.37132e+06,
 9.26256e+06, 9.13957e+06, 9.00007e+06, 8.84097e+06, 8.65918e+06,
 8.45241e+06, 8.21900e+06, 7.95735e+06, 7.66621e+06, 7.34529e+06,
 6.99583e+06, 6.62075e+06, 6.22424e+06, 5.81157e+06, 5.38896e+06,
 4.96322e+06, 4.54130e+06, 4.12978e+06, 3.85215e+06, 3.47852e+06,
 3.12785e+06, 2.80232e+06, 2.50299e+06, 2.22997e+06, 1.98262e+06,
 1.75975e+06, 1.55980e+06, 1.38105e+06, 1.22165e+06, 1.07980e+06,
 9.53751e+05, 8.41868e+05, 7.42642e+05, 6.54701e+05, 5.76805e+05,
 5.07844e+05, 4.46823e+05, 3.92857e+05, 3.45156e+05, 3.03018e+05,
 2.65817e+05, 2.32995e+05, 2.04057e+05, 1.78561e+05, 1.56113e+05,
 1.36362e+05, 1.18997e+05, 1.03740e+05, 9.03437e+04, 7.85888e+04,
 6.82801e+04, 5.92447e+04, 5.13290e+04, 4.43973e+04, 3.83294e+04,
 3.30190e+04, 2.83726e+04, 2.43078e+04, 2.07522e+04, 1.76424e+04,
 1.49233e+04, 1.25470e+04, 1.04725e+04, 8.66490e+03, 7.09540e+03,
 5.74095e+03, 4.58429e+03, 3.61420e+03, 2.82597e+03, 2.22224e+03}
,
{7.66474e+04, 8.41229e+05, 2.46011e+06, 4.39435e+06, 6.22984e+06,
 7.80838e+06, 9.08882e+06, 1.00787e+07, 1.08167e+07, 1.13640e+07,
 1.17686e+07, 1.20596e+07, 1.22577e+07, 1.23823e+07, 1.24566e+07,
 1.24986e+07, 1.25194e+07, 1.25245e+07, 1.25155e+07, 1.24941e+07,
 1.24635e+07, 1.24251e+07, 1.23779e+07, 1.23202e+07, 1.22521e+07,
 1.21753e+07, 1.20897e+07, 1.19930e+07, 1.18823e+07, 1.17553e+07,
 1.16112e+07, 1.14480e+07, 1.12622e+07, 1.10497e+07, 1.08068e+07,
 1.05310e+07, 1.02201e+07, 9.87208e+06, 9.48581e+06, 9.06165e+06,
 8.60217e+06, 8.11194e+06, 7.59705e+06, 7.06497e+06, 6.52418e+06,
 5.98373e+06, 5.45250e+06, 5.08563e+06, 4.59768e+06, 4.13740e+06,
 3.70835e+06, 3.31254e+06, 2.95065e+06, 2.62223e+06, 2.32599e+06,
 2.06010e+06, 1.82238e+06, 1.61047e+06, 1.42198e+06, 1.25463e+06,
 1.10622e+06, 9.74735e+05, 8.58333e+05, 7.55345e+05, 6.64276e+05,
 5.83788e+05, 5.12691e+05, 4.49922e+05, 3.94540e+05, 3.45706e+05,
 3.02674e+05, 2.64781e+05, 2.31437e+05, 2.02117e+05, 1.76355e+05,
 1.53736e+05, 1.33891e+05, 1.16491e+05, 1.01246e+05, 8.78974e+04,
 7.62168e+04, 6.60012e+04, 5.70713e+04, 4.92687e+04, 4.24536e+04,
 3.65026e+04, 3.13072e+04, 2.67723e+04, 2.28143e+04, 1.93603e+04,
 1.63468e+04, 1.37188e+04, 1.14294e+04, 9.43860e+03, 7.71340e+03,
 6.22731e+03, 4.96045e+03, 3.89969e+03, 3.03926e+03, 2.38158e+03}
,
{1.00483e+05, 1.09311e+06, 3.17269e+06, 5.63557e+06, 7.95797e+06,
 9.94469e+06, 1.15475e+07, 1.27789e+07, 1.36928e+07, 1.43685e+07,
 1.48656e+07, 1.52201e+07, 1.54582e+07, 1.56057e+07, 1.56927e+07,
 1.57409e+07, 1.57635e+07, 1.57666e+07, 1.57518e+07, 1.57217e+07,
 1.56806e+07, 1.56294e+07, 1.55663e+07, 1.54894e+07, 1.53997e+07,
 1.52991e+07, 1.51865e+07, 1.50586e+07, 1.49117e+07, 1.47435e+07,
 1.45525e+07, 1.43358e+07, 1.40882e+07, 1.38045e+07, 1.34803e+07,
 1.31128e+07, 1.26991e+07, 1.22369e+07, 1.17254e+07, 1.11663e+07,
 1.05639e+07, 9.92521e+06, 9.25892e+06, 8.57538e+06, 7.88608e+06,
 7.20278e+06, 6.53657e+06, 6.08388e+06, 5.48057e+06, 4.91548e+06,
 4.39217e+06, 3.91226e+06, 3.47581e+06, 3.08156e+06, 2.72742e+06,
 2.41068e+06, 2.12837e+06, 1.87738e+06, 1.65468e+06, 1.45736e+06,
 1.28271e+06, 1.12826e+06, 9.91763e+05, 8.71199e+05, 7.64767e+05,
 6.70862e+05, 5.88055e+05, 5.15080e+05, 4.50809e+05, 3.94242e+05,
 3.44491e+05, 3.00767e+05, 2.62369e+05, 2.28673e+05, 1.99127e+05,
 1.73239e+05, 1.50573e+05, 1.30742e+05, 1.13405e+05, 9.82574e+04,
 8.50312e+04, 7.34891e+04, 6.34220e+04, 5.46451e+04, 4.69959e+04,
 4.03315e+04, 3.45263e+04, 2.94704e+04, 2.50674e+04, 2.12336e+04,
 1.78960e+04, 1.49917e+04, 1.24669e+04, 1.02758e+04, 8.38073e+03,
 6.75134e+03, 5.36472e+03, 4.20563e+03, 3.26705e+03, 2.55108e+03}
,
{1.31669e+05, 1.41969e+06, 4.08979e+06, 7.22459e+06, 1.01621e+07,
 1.26618e+07, 1.46674e+07, 1.61990e+07, 1.73305e+07, 1.81646e+07,
 1.87750e+07, 1.92064e+07, 1.94921e+07, 1.96666e+07, 1.97683e+07,
 1.98234e+07, 1.98475e+07, 1.98472e+07, 1.98241e+07, 1.97826e+07,
 1.97275e+07, 1.96592e+07, 1.95749e+07, 1.94728e+07, 1.93550e+07,
 1.92232e+07, 1.90750e+07, 1.89057e+07, 1.87108e+07, 1.84880e+07,
 1.82351e+07, 1.79470e+07, 1.76171e+07, 1.72384e+07, 1.68063e+07,
 1.63171e+07, 1.57673e+07, 1.51545e+07, 1.44787e+07, 1.37435e+07,
 1.29562e+07, 1.21268e+07, 1.12676e+07, 1.03927e+07, 9.51756e+06,
 8.65705e+06, 8.05800e+06, 7.26871e+06, 6.52535e+06, 5.83380e+06,
 5.19736e+06, 4.61698e+06, 4.09175e+06, 3.61938e+06, 3.19666e+06,
 2.81983e+06, 2.48491e+06, 2.18789e+06, 1.92493e+06, 1.69240e+06,
 1.48697e+06, 1.30561e+06, 1.14560e+06, 1.00451e+06, 8.80172e+05,
 7.70655e+05, 6.74252e+05, 5.89447e+05, 5.14895e+05, 4.49404e+05,
 3.91916e+05, 3.41492e+05, 2.97298e+05, 2.58596e+05, 2.24731e+05,
 1.95120e+05, 1.69249e+05, 1.46664e+05, 1.26960e+05, 1.09782e+05,
 9.48158e+04, 8.17839e+04, 7.04422e+04, 6.05760e+04, 5.19965e+04,
 4.45382e+04, 3.80559e+04, 3.24228e+04, 2.75281e+04, 2.32755e+04,
 1.95814e+04, 1.63739e+04, 1.35912e+04, 1.11813e+04, 9.10103e+03,
 7.31570e+03, 5.79902e+03, 4.53335e+03, 3.51020e+03, 2.73131e+03}
,
{1.72457e+05, 1.84292e+06, 5.26961e+06, 9.25815e+06, 1.29725e+07,
 1.61169e+07, 1.86257e+07, 2.05298e+07, 2.19306e+07, 2.29601e+07,
 2.37093e+07, 2.42338e+07, 2.45760e+07, 2.47822e+07, 2.49009e+07,
 2.49636e+07, 2.49886e+07, 2.49827e+07, 2.49483e+07, 2.48916e+07,
 2.48182e+07, 2.47270e+07, 2.46145e+07, 2.44793e+07, 2.43249e+07,
 2.41522e+07, 2.39569e+07, 2.37326e+07, 2.34743e+07, 2.31796e+07,
 2.28445e+07, 2.24615e+07, 2.20216e+07, 2.15167e+07, 2.09413e+07,
 2.02909e+07, 1.95612e+07, 1.87501e+07, 1.78592e+07, 1.68953e+07,
 1.58694e+07, 1.47958e+07, 1.36917e+07, 1.25762e+07, 1.14693e+07,
 1.03898e+07, 9.65001e+06, 8.67382e+06, 7.76088e+06, 6.91710e+06,
 6.14513e+06, 5.44485e+06, 4.81404e+06, 4.24900e+06, 3.74511e+06,
 3.29729e+06, 2.90031e+06, 2.54907e+06, 2.23873e+06, 1.96484e+06,
 1.72329e+06, 1.51041e+06, 1.32292e+06, 1.15787e+06, 1.01266e+06,
 8.84981e+05, 7.72795e+05, 6.74287e+05, 5.87852e+05, 5.12069e+05,
 4.45676e+05, 3.87558e+05, 3.36724e+05, 2.92299e+05, 2.53506e+05,
 2.19659e+05, 1.90150e+05, 1.64443e+05, 1.42064e+05, 1.22597e+05,
 1.05673e+05, 9.09683e+04, 7.81992e+04, 6.71158e+04, 5.74992e+04,
 4.91578e+04, 4.19241e+04, 3.56520e+04, 3.02142e+04, 2.55002e+04,
 2.14142e+04, 1.78739e+04, 1.48091e+04, 1.21602e+04, 9.87815e+03,
 7.92323e+03, 6.26540e+03, 4.88425e+03, 3.76963e+03, 2.92285e+03}
,
{2.25775e+05, 2.39116e+06, 6.78682e+06, 1.18597e+07, 1.65551e+07,
 2.05091e+07, 2.36463e+07, 2.60130e+07, 2.77470e+07, 2.90175e+07,
 2.99365e+07, 3.05734e+07, 3.09827e+07, 3.12262e+07, 3.13645e+07,
 3.14354e+07, 3.14602e+07, 3.14459e+07, 3.13959e+07, 3.13192e+07,
 3.12213e+07, 3.10998e+07, 3.09498e+07, 3.07715e+07, 3.05694e+07,
 3.03428e+07, 3.00851e+07, 2.97881e+07, 2.94462e+07, 2.90563e+07,
 2.86121e+07, 2.81026e+07, 2.75163e+07, 2.68437e+07, 2.60786e+07,
 2.52148e+07, 2.42477e+07, 2.31760e+07, 2.20046e+07, 2.07444e+07,
 1.94117e+07, 1.80267e+07, 1.66129e+07, 1.51959e+07, 1.38012e+07,
 1.28212e+07, 1.15423e+07, 1.03389e+07, 9.22115e+06, 8.19448e+06,
 7.26038e+06, 6.41720e+06, 5.66092e+06, 4.98601e+06, 4.38608e+06,
 3.85439e+06, 3.38421e+06, 2.96908e+06, 2.60303e+06, 2.28055e+06,
 1.99664e+06, 1.74685e+06, 1.52722e+06, 1.33420e+06, 1.16469e+06,
 1.01590e+06, 8.85408e+05, 7.71036e+05, 6.70874e+05, 5.83225e+05,
 5.06590e+05, 4.39642e+05, 3.81205e+05, 3.30241e+05, 2.85832e+05,
 2.47166e+05, 2.13528e+05, 1.84287e+05, 1.58888e+05, 1.36840e+05,
 1.17714e+05, 1.01134e+05, 8.67667e+04, 7.43239e+04, 6.35517e+04,
 5.42287e+04, 4.61617e+04, 3.91826e+04, 3.31452e+04, 2.79229e+04,
 2.34063e+04, 1.95013e+04, 1.61278e+04, 1.32181e+04, 1.07162e+04,
 8.57696e+03, 6.76599e+03, 5.25978e+03, 4.04632e+03, 3.12630e+03}
,
{2.95435e+05, 3.10103e+06, 8.73716e+06, 1.51870e+07, 2.11207e+07,
 2.60915e+07, 3.00133e+07, 3.29539e+07, 3.51004e+07, 3.66678e+07,
 3.77945e+07, 3.85669e+07, 3.90558e+07, 3.93431e+07, 3.95038e+07,
 3.95834e+07, 3.96065e+07, 3.95796e+07, 3.95086e+07, 3.94056e+07,
 3.92752e+07, 3.91131e+07, 3.89136e+07, 3.86792e+07, 3.84148e+07,
 3.81173e+07, 3.77770e+07, 3.73836e+07, 3.69314e+07, 3.64159e+07,
 3.58266e+07, 3.51487e+07, 3.43677e+07, 3.34728e+07, 3.24562e+07,
 3.13105e+07, 3.00306e+07, 2.86178e+07, 2.70815e+07, 2.54388e+07,
 2.37129e+07, 2.19320e+07, 2.01281e+07, 1.83348e+07, 1.65839e+07,
 1.53724e+07, 1.37896e+07, 1.23108e+07, 1.09462e+07, 9.70017e+06,
 8.57240e+06, 7.55904e+06, 6.65375e+06, 5.84864e+06, 5.13511e+06,
 4.50433e+06, 3.94779e+06, 3.45745e+06, 3.02586e+06, 2.64630e+06,
 2.31272e+06, 2.01972e+06, 1.76253e+06, 1.53689e+06, 1.33908e+06,
 1.16577e+06, 1.01405e+06, 8.81319e+05, 7.65307e+05, 6.63990e+05,
 5.75582e+05, 4.98506e+05, 4.31368e+05, 3.72938e+05, 3.22130e+05,
 2.77988e+05, 2.39668e+05, 2.06428e+05, 1.77618e+05, 1.52664e+05,
 1.31064e+05, 1.12379e+05, 9.62252e+04, 8.22652e+04, 7.02062e+04,
 5.97927e+04, 5.08020e+04, 4.30410e+04, 3.63421e+04, 3.05603e+04,
 2.55706e+04, 2.12660e+04, 1.75550e+04, 1.43608e+04, 1.16196e+04,
 9.28009e+03, 7.30306e+03, 5.66150e+03, 4.34124e+03, 3.34229e+03}
,
{3.86398e+05, 4.01977e+06, 1.12433e+07, 1.94409e+07, 2.69374e+07,
 3.31848e+07, 3.80857e+07, 4.17387e+07, 4.43955e+07, 4.63288e+07,
 4.77091e+07, 4.86449e+07, 4.92281e+07, 4.95668e+07, 4.97531e+07,
 4.98417e+07, 4.98602e+07, 4.98151e+07, 4.97161e+07, 4.95783e+07,
 4.94048e+07, 4.91887e+07, 4.89242e+07, 4.86167e+07, 4.82709e+07,
 4.78798e+07, 4.74301e+07, 4.69094e+07, 4.63120e+07, 4.56302e+07,
 4.48480e+07, 4.39460e+07, 4.29063e+07, 4.17168e+07, 4.03677e+07,
 3.88498e+07, 3.71591e+07, 3.53007e+07, 3.32913e+07, 3.11561e+07,
 2.89280e+07, 2.66459e+07, 2.43526e+07, 2.20911e+07, 2.04853e+07,
 1.84092e+07, 1.64567e+07, 1.46449e+07, 1.29833e+07, 1.14745e+07,
 1.01156e+07, 8.89973e+06, 7.81755e+06, 6.85819e+06, 6.01026e+06,
 5.26248e+06, 4.60412e+06, 4.02516e+06, 3.51650e+06, 3.06993e+06,
 2.67811e+06, 2.33454e+06, 2.03346e+06, 1.76979e+06, 1.53905e+06,
 1.33726e+06, 1.16093e+06, 1.00698e+06, 8.72676e+05, 7.55621e+05,
 6.53688e+05, 5.65003e+05, 4.87915e+05, 4.20966e+05, 3.62873e+05,
 3.12510e+05, 2.68883e+05, 2.31121e+05, 1.98462e+05, 1.70236e+05,
 1.45858e+05, 1.24816e+05, 1.06663e+05, 9.10109e+04, 7.75197e+04,
 6.58951e+04, 5.58811e+04, 4.72559e+04, 3.98274e+04, 3.34300e+04,
 2.79212e+04, 2.31788e+04, 1.90990e+04, 1.55946e+04, 1.25930e+04,
 1.00360e+04, 7.87900e+03, 6.09102e+03, 4.65543e+03, 3.57141e+03}
,
{5.05118e+05, 5.20834e+06, 1.44625e+07, 2.48780e+07, 3.43462e+07,
 4.21961e+07, 4.83185e+07, 5.28552e+07, 5.61435e+07, 5.85275e+07,
 6.02175e+07, 6.13497e+07, 6.20444e+07, 6.24434e+07, 6.26588e+07,
 6.27563e+07, 6.27661e+07, 6.26954e+07, 6.25592e+07, 6.23753e+07,
 6.21445e+07, 6.18567e+07, 6.15070e+07, 6.11046e+07, 6.06520e+07,
 6.01374e+07, 5.95428e+07, 5.88543e+07, 5.80655e+07, 5.71632e+07,
 5.61247e+07, 5.49245e+07, 5.35418e+07, 5.19626e+07, 5.01740e+07,
 4.81658e+07, 4.59364e+07, 4.34981e+07, 4.08769e+07, 3.81097e+07,
 3.52424e+07, 3.23280e+07, 2.94226e+07, 2.65809e+07, 2.45928e+07,
 2.20213e+07, 1.96199e+07, 1.74061e+07, 1.53879e+07, 1.35648e+07,
 1.19303e+07, 1.04737e+07, 9.18161e+06, 8.03954e+06, 7.03269e+06,
 6.14674e+06, 5.36828e+06, 4.68498e+06, 4.08568e+06, 3.56042e+06,
 3.10035e+06, 2.69761e+06, 2.34530e+06, 2.03730e+06, 1.76825e+06,
 1.53340e+06, 1.32858e+06, 1.15009e+06, 9.94703e+05, 8.59539e+05,
 7.42077e+05, 6.40094e+05, 5.51631e+05, 4.74967e+05, 4.08586e+05,
 3.51159e+05, 3.01521e+05, 2.58649e+05, 2.21651e+05, 1.89744e+05,
 1.62246e+05, 1.38564e+05, 1.18178e+05, 1.00638e+05, 8.55542e+04,
 7.25856e+04, 6.14384e+04, 5.18584e+04, 4.36257e+04, 3.65514e+04,
 3.04728e+04, 2.52512e+04, 2.07687e+04, 1.69261e+04, 1.36413e+04,
 1.08483e+04, 8.49631e+03, 6.54999e+03, 4.98992e+03, 3.81431e+03}
,
{6.59982e+05, 6.74532e+06, 1.85959e+07, 3.18251e+07, 4.37806e+07,
 5.36413e+07, 6.12872e+07, 6.69203e+07, 7.09899e+07, 7.39288e+07,
 7.59965e+07, 7.73645e+07, 7.81913e+07, 7.86608e+07, 7.89090e+07,
 7.90144e+07, 7.90097e+07, 7.89035e+07, 7.87179e+07, 7.84732e+07,
 7.81662e+07, 7.77833e+07, 7.73225e+07, 7.67965e+07, 7.62037e+07,
 7.55259e+07, 7.47396e+07, 7.38303e+07, 7.27888e+07, 7.15942e+07,
 7.02150e+07, 6.86187e+07, 6.67820e+07, 6.46874e+07, 6.23187e+07,
 5.96658e+07, 5.67323e+07, 5.35409e+07, 5.01312e+07, 4.65555e+07,
 4.28775e+07, 3.91682e+07, 3.55003e+07, 3.28655e+07, 2.94899e+07,
 2.63145e+07, 2.33694e+07, 2.06715e+07, 1.82255e+07, 1.60268e+07,
 1.40640e+07, 1.23212e+07, 1.07802e+07, 9.42177e+06, 8.22701e+06,
 7.17787e+06, 6.25781e+06, 5.45164e+06, 4.74579e+06, 4.12819e+06,
 3.58814e+06, 3.11620e+06, 2.70408e+06, 2.34445e+06, 2.03086e+06,
 1.75766e+06, 1.51985e+06, 1.31303e+06, 1.13333e+06, 9.77342e+05,
 8.42062e+05, 7.24854e+05, 6.23399e+05, 5.35660e+05, 4.59853e+05,
 3.94413e+05, 3.37969e+05, 2.89325e+05, 2.47436e+05, 2.11390e+05,
 1.80393e+05, 1.53755e+05, 1.30875e+05, 1.11233e+05, 9.43773e+04,
 7.99177e+04, 6.75165e+04, 5.68821e+04, 4.77635e+04, 3.99450e+04,
 3.32417e+04, 2.74958e+04, 2.25735e+04, 1.83624e+04, 1.47698e+04,
 1.17207e+04, 9.15760e+03, 7.04013e+03, 5.34579e+03, 4.07157e+03}
,
{8.61893e+05, 8.73202e+06, 2.39016e+07, 4.06990e+07, 5.57916e+07,
 6.81746e+07, 7.77202e+07, 8.47133e+07, 8.97497e+07, 9.33713e+07,
 9.58994e+07, 9.75501e+07, 9.85331e+07, 9.90848e+07, 9.93698e+07,
 9.94811e+07, 9.94534e+07, 9.92985e+07, 9.90479e+07, 9.87225e+07,
 9.83142e+07, 9.78057e+07, 9.72003e+07, 9.65132e+07, 9.57362e+07,
 9.48425e+07, 9.38032e+07, 9.26033e+07, 9.12283e+07, 8.96459e+07,
 8.78137e+07, 8.56923e+07, 8.32548e+07, 8.04793e+07, 7.73462e+07,
 7.38474e+07, 6.99959e+07, 6.58297e+07, 6.14065e+07, 5.68000e+07,
 5.20972e+07, 4.73922e+07, 4.27775e+07, 3.95096e+07, 3.53237e+07,
 3.14141e+07, 2.78120e+07, 2.45317e+07, 2.15733e+07, 1.89262e+07,
 1.65725e+07, 1.44898e+07, 1.26535e+07, 1.10388e+07, 9.62183e+06,
 8.38007e+06, 7.29304e+06, 6.34223e+06, 5.51115e+06, 4.78519e+06,
 4.15147e+06, 3.59864e+06, 3.11673e+06, 2.69697e+06, 2.33165e+06,
 2.01398e+06, 1.73800e+06, 1.49846e+06, 1.29076e+06, 1.11084e+06,
 9.55121e+05, 8.20491e+05, 7.04202e+05, 6.03849e+05, 5.17329e+05,
 4.42800e+05, 3.78657e+05, 3.23497e+05, 2.76099e+05, 2.35401e+05,
 2.00480e+05, 1.70534e+05, 1.44870e+05, 1.22886e+05, 1.04063e+05,
 8.79501e+04, 7.41615e+04, 6.23634e+04, 5.22693e+04, 4.36332e+04,
 3.62450e+04, 2.99256e+04, 2.45234e+04, 1.99112e+04, 1.59840e+04,
 1.26572e+04, 9.86556e+03, 7.56320e+03, 5.72408e+03, 4.34376e+03}
,
{1.12511e+06, 1.12990e+07, 3.07096e+07, 5.20310e+07, 7.10790e+07,
 8.66253e+07, 9.85391e+07, 1.07219e+08, 1.13451e+08, 1.17913e+08,
 1.21001e+08, 1.22990e+08, 1.24158e+08, 1.24806e+08, 1.25131e+08,
 1.25245e+08, 1.25183e+08, 1.24962e+08, 1.24625e+08, 1.24193e+08,
 1.23650e+08, 1.22976e+08, 1.22183e+08, 1.21286e+08, 1.20266e+08,
 1.19087e+08, 1.17714e+08, 1.16132e+08, 1.14316e+08, 1.12219e+08,
 1.09785e+08, 1.06968e+08, 1.03737e+08, 1.00063e+08, 9.59241e+07,
 9.13180e+07, 8.62730e+07, 8.08482e+07, 7.51263e+07, 6.92100e+07,
 6.32164e+07, 5.72682e+07, 5.14817e+07, 4.74436e+07, 4.22685e+07,
 3.74683e+07, 3.30734e+07, 2.90936e+07, 2.55222e+07, 2.23402e+07,
 1.95213e+07, 1.70347e+07, 1.48483e+07, 1.29303e+07, 1.12506e+07,
 9.78141e+06, 8.49756e+06, 7.37651e+06, 6.39827e+06, 5.54521e+06,
 4.80182e+06, 4.15446e+06, 3.59117e+06, 3.10143e+06, 2.67601e+06,
 2.30681e+06, 1.98669e+06, 1.70941e+06, 1.46947e+06, 1.26205e+06,
 1.08291e+06, 9.28358e+05, 7.95143e+05, 6.80430e+05, 5.81740e+05,
 4.96911e+05, 4.24060e+05, 3.61547e+05, 3.07947e+05, 2.62024e+05,
 2.22705e+05, 1.89062e+05, 1.60292e+05, 1.35701e+05, 1.14691e+05,
 9.67462e+04, 8.14237e+04, 6.83418e+04, 5.71739e+04, 4.76400e+04,
 3.95014e+04, 3.25550e+04, 2.66292e+04, 2.15803e+04, 1.72897e+04,
 1.36618e+04, 1.06230e+04, 8.12098e+03, 6.12581e+03, 4.63137e+03}
,
{1.46813e+06, 1.46146e+07, 3.94422e+07, 6.64981e+07, 9.05323e+07,
 1.10045e+08, 1.24910e+08, 1.35682e+08, 1.43393e+08, 1.48887e+08,
 1.52657e+08, 1.55051e+08, 1.56437e+08, 1.57196e+08, 1.57566e+08,
 1.57676e+08, 1.57562e+08, 1.57253e+08, 1.56803e+08, 1.56230e+08,
 1.55508e+08, 1.54618e+08, 1.53580e+08, 1.52408e+08, 1.51069e+08,
 1.49512e+08, 1.47701e+08, 1.45616e+08, 1.43216e+08, 1.40436e+08,
 1.37204e+08, 1.33468e+08, 1.29188e+08, 1.24329e+08, 1.18870e+08,
 1.12818e+08, 1.06226e+08, 9.91803e+07, 9.17994e+07, 8.42239e+07,
 7.66099e+07, 6.91149e+07, 6.37360e+07, 5.69107e+07, 5.05306e+07,
 4.46522e+07, 3.93024e+07, 3.44836e+07, 3.01792e+07, 2.63595e+07,
 2.29871e+07, 2.00210e+07, 1.74195e+07, 1.51424e+07, 1.31522e+07,
 1.14145e+07, 9.89872e+06, 8.57733e+06, 7.42622e+06, 6.42413e+06,
 5.55238e+06, 4.79460e+06, 4.13644e+06, 3.56530e+06, 3.07013e+06,
 2.64123e+06, 2.27011e+06, 1.94930e+06, 1.67226e+06, 1.43327e+06,
 1.22730e+06, 1.04997e+06, 8.97457e+05, 7.66403e+05, 6.53896e+05,
 5.57400e+05, 4.74707e+05, 4.03902e+05, 3.43324e+05, 2.91534e+05,
 2.47288e+05, 2.09512e+05, 1.77278e+05, 1.49786e+05, 1.26349e+05,
 1.06375e+05, 8.93573e+04, 7.48599e+04, 6.25106e+04, 5.19911e+04,
 4.30306e+04, 3.53990e+04, 2.89023e+04, 2.33783e+04, 1.86931e+04,
 1.47389e+04, 1.14327e+04, 8.71522e+03, 6.55191e+03, 4.93480e+03}
,
{1.91498e+06, 1.88953e+07, 5.06398e+07, 8.49622e+07, 1.15281e+08,
 1.39765e+08, 1.58307e+08, 1.71674e+08, 1.81214e+08, 1.87977e+08,
 1.92575e+08, 1.95452e+08, 1.97097e+08, 1.97984e+08, 1.98402e+08,
 1.98499e+08, 1.98311e+08, 1.97883e+08, 1.97285e+08, 1.96524e+08,
 1.95565e+08, 1.94392e+08, 1.93037e+08, 1.91504e+08, 1.89744e+08,
 1.87690e+08, 1.85302e+08, 1.82553e+08, 1.79381e+08, 1.75695e+08,
 1.71406e+08, 1.66454e+08, 1.60791e+08, 1.54374e+08, 1.47183e+08,
 1.39249e+08, 1.30655e+08, 1.21530e+08, 1.12036e+08, 1.02366e+08,
 9.27242e+07, 8.33105e+07, 7.66496e+07, 6.81989e+07, 6.03546e+07,
 5.31731e+07, 4.66747e+07, 4.08505e+07, 3.56705e+07, 3.10908e+07,
 2.70603e+07, 2.35249e+07, 2.04313e+07, 1.77292e+07, 1.53719e+07,
 1.33174e+07, 1.15282e+07, 9.97113e+06, 8.61701e+06, 7.44021e+06,
 6.41830e+06, 5.53161e+06, 4.76291e+06, 4.09712e+06, 3.52102e+06,
 3.02301e+06, 2.59297e+06, 2.22198e+06, 1.90229e+06, 1.62707e+06,
 1.39038e+06, 1.18704e+06, 1.01252e+06, 8.62885e+05, 7.34700e+05,
 6.24993e+05, 5.31182e+05, 4.51030e+05, 3.82604e+05, 3.24231e+05,
 2.74470e+05, 2.32076e+05, 1.95981e+05, 1.65263e+05, 1.39132e+05,
 1.16912e+05, 9.80213e+04, 8.19637e+04, 6.83151e+04, 5.67143e+04,
 4.68539e+04, 3.84738e+04, 3.13548e+04, 2.53139e+04, 2.02004e+04,
 1.58929e+04, 1.22976e+04, 9.34757e+03, 7.00322e+03, 5.25432e+03}
,
{2.49680e+06, 2.44199e+07, 6.49937e+07, 1.08522e+08, 1.46760e+08,
 1.77474e+08, 2.00595e+08, 2.17181e+08, 2.28983e+08, 2.37304e+08,
 2.42905e+08, 2.46360e+08, 2.48309e+08, 2.49345e+08, 2.49813e+08,
 2.49882e+08, 2.49590e+08, 2.49006e+08, 2.48211e+08, 2.47202e+08,
 2.45929e+08, 2.44387e+08, 2.42620e+08, 2.40615e+08, 2.38298e+08,
 2.35588e+08, 2.32443e+08, 2.28820e+08, 2.24624e+08, 2.19736e+08,
 2.14049e+08, 2.07493e+08, 2.00007e+08, 1.91540e+08, 1.82086e+08,
 1.71707e+08, 1.60532e+08, 1.48743e+08, 1.36567e+08, 1.24261e+08,
 1.12091e+08, 1.03229e+08, 9.20842e+07, 8.16501e+07, 7.20299e+07,
 6.32762e+07, 5.53978e+07, 4.83699e+07, 4.21445e+07, 3.66596e+07,
 3.18466e+07, 2.76354e+07, 2.39587e+07, 2.07534e+07, 1.79623e+07,
 1.55339e+07, 1.34227e+07, 1.15884e+07, 9.99599e+06, 8.61450e+06,
 7.41698e+06, 6.37984e+06, 5.48240e+06, 4.70662e+06, 4.03667e+06,
 3.45871e+06, 2.96063e+06, 2.53185e+06, 2.16311e+06, 1.84635e+06,
 1.57451e+06, 1.34147e+06, 1.14189e+06, 9.71123e+05, 8.25156e+05,
 7.00499e+05, 5.94134e+05, 5.03453e+05, 4.26204e+05, 3.60448e+05,
 3.04514e+05, 2.56964e+05, 2.16567e+05, 1.82262e+05, 1.53145e+05,
 1.28438e+05, 1.07479e+05, 8.97029e+04, 7.46262e+04, 6.18391e+04,
 5.09939e+04, 4.17964e+04, 3.39993e+04, 2.73964e+04, 2.18181e+04,
 1.71280e+04, 1.32204e+04, 1.00196e+04, 7.48040e+03, 5.59002e+03}
,
{3.25405e+06, 3.15473e+07, 8.33880e+07, 1.38576e+08, 1.86791e+08,
 2.25309e+08, 2.54134e+08, 2.74711e+08, 2.89308e+08, 2.99542e+08,
 3.06361e+08, 3.10502e+08, 3.12812e+08, 3.14017e+08, 3.14537e+08,
 3.14555e+08, 3.14119e+08, 3.13328e+08, 3.12274e+08, 3.10935e+08,
 3.09250e+08, 3.07229e+08, 3.04925e+08, 3.02298e+08, 2.99248e+08,
 2.95676e+08, 2.91535e+08, 2.86757e+08, 2.81205e+08, 2.74725e+08,
 2.67191e+08, 2.58519e+08, 2.48632e+08, 2.37477e+08, 2.25070e+08,
 2.11523e+08, 1.97027e+08, 1.81839e+08, 1.66268e+08, 1.50656e+08,
 1.35341e+08, 1.24341e+08, 1.10519e+08, 9.76697e+07, 8.58995e+07,
 7.52516e+07, 6.57170e+07, 5.72492e+07, 4.97764e+07, 4.32135e+07,
 3.74702e+07, 3.24570e+07, 2.80891e+07, 2.42885e+07, 2.09848e+07,
 1.81152e+07, 1.56247e+07, 1.34645e+07, 1.15924e+07, 9.97117e+06,
 8.56839e+06, 7.35573e+06, 6.30845e+06, 5.40491e+06, 4.62618e+06,
 3.95575e+06, 3.37916e+06, 2.88383e+06, 2.45876e+06, 2.09437e+06,
 1.78233e+06, 1.51539e+06, 1.28727e+06, 1.09251e+06, 9.26381e+05,
 7.84815e+05, 6.64282e+05, 5.61744e+05, 4.74583e+05, 4.00550e+05,
 3.37710e+05, 2.84407e+05, 2.39218e+05, 2.00929e+05, 1.68499e+05,
 1.41042e+05, 1.17801e+05, 9.81312e+04, 8.14851e+04, 6.73975e+04,
 5.54749e+04, 4.53850e+04, 3.68492e+04, 2.96354e+04, 2.35531e+04,
 1.84488e+04, 1.42037e+04, 1.07326e+04, 7.98392e+03, 5.94172e+03}
,
{4.23919e+06, 4.07393e+07, 1.06953e+08, 1.76904e+08, 2.37684e+08,
 2.85979e+08, 3.21905e+08, 3.47432e+08, 3.65484e+08, 3.78064e+08,
 3.86356e+08, 3.91317e+08, 3.94051e+08, 3.95450e+08, 3.96018e+08,
 3.95955e+08, 3.95320e+08, 3.94258e+08, 3.92861e+08, 3.91085e+08,
 3.88857e+08, 3.86215e+08, 3.83209e+08, 3.79767e+08, 3.75749e+08,
 3.71043e+08, 3.65595e+08, 3.59291e+08, 3.51943e+08, 3.43355e+08,
 3.33384e+08, 3.21923e+08, 3.08878e+08, 2.94203e+08, 2.77954e+08,
 2.60312e+08, 2.41555e+08, 2.22041e+08, 2.02188e+08, 1.82441e+08,
 1.63228e+08, 1.49619e+08, 1.32523e+08, 1.16739e+08, 1.02370e+08,
 8.94423e+07, 7.79220e+07, 6.77325e+07, 5.87719e+07, 5.09259e+07,
 4.40770e+07, 3.81118e+07, 3.29249e+07, 2.84198e+07, 2.45104e+07,
 2.11206e+07, 1.81834e+07, 1.56402e+07, 1.34400e+07, 1.15380e+07,
 9.89543e+06, 8.47814e+06, 7.25651e+06, 6.20463e+06, 5.29989e+06,
 4.52256e+06, 3.85544e+06, 3.28352e+06, 2.79376e+06, 2.37481e+06,
 2.01680e+06, 1.71121e+06, 1.45060e+06, 1.22858e+06, 1.03962e+06,
 8.78938e+05, 7.42423e+05, 6.26539e+05, 5.28247e+05, 4.44938e+05,
 3.74378e+05, 3.14655e+05, 2.64133e+05, 2.21418e+05, 1.85318e+05,
 1.54820e+05, 1.29060e+05, 1.07306e+05, 8.89364e+04, 7.34234e+04,
 6.03223e+04, 4.92586e+04, 3.99184e+04, 3.20409e+04, 2.54120e+04,
 1.98594e+04, 1.52499e+04, 1.14877e+04, 8.51385e+03, 6.30884e+03}
,
{5.52022e+06, 5.25896e+07, 1.37132e+08, 2.25775e+08, 3.02377e+08,
 3.62915e+08, 4.07677e+08, 4.39343e+08, 4.61664e+08, 4.77121e+08,
 4.87195e+08, 4.93130e+08, 4.96364e+08, 4.97984e+08, 4.98591e+08,
 4.98403e+08, 4.97500e+08, 4.96079e+08, 4.94229e+08, 4.91875e+08,
 4.88936e+08, 4.85488e+08, 4.81566e+08, 4.77050e+08, 4.71757e+08,
 4.65564e+08, 4.58395e+08, 4.50075e+08, 4.40349e+08, 4.28975e+08,
 4.15789e+08, 4.00656e+08, 3.83464e+08, 3.64188e+08, 3.42951e+08,
 3.20031e+08, 2.95823e+08, 2.70819e+08, 2.45579e+08, 2.20678e+08,
 2.02501e+08, 1.79863e+08, 1.58771e+08, 1.39427e+08, 1.21922e+08,
 1.06254e+08, 9.23550e+07, 8.01083e+07, 6.93736e+07, 6.00001e+07,
 5.18375e+07, 4.47429e+07, 3.85855e+07, 3.32469e+07, 2.86222e+07,
 2.46187e+07, 2.11558e+07, 1.81626e+07, 1.55776e+07, 1.33471e+07,
 1.14244e+07, 9.76861e+06, 8.34422e+06, 7.12021e+06, 6.06956e+06,
 5.16873e+06, 4.39723e+06, 3.73722e+06, 3.17322e+06, 2.69178e+06,
 2.28127e+06, 1.93159e+06, 1.63404e+06, 1.38108e+06, 1.16626e+06,
 9.83972e+05, 8.29439e+05, 6.98541e+05, 5.87752e+05, 4.94054e+05,
 4.14866e+05, 3.47984e+05, 2.91529e+05, 2.43900e+05, 2.03735e+05,
 1.69875e+05, 1.41338e+05, 1.17291e+05, 9.70279e+04, 7.99529e+04,
 6.55634e+04, 5.34373e+04, 4.32215e+04, 3.46229e+04, 2.74013e+04,
 2.13638e+04, 1.63612e+04, 1.22854e+04, 9.06976e+03, 6.69042e+03}
,
{7.18531e+06, 6.78618e+07, 1.75770e+08, 2.88071e+08, 3.84593e+08,
 4.60459e+08, 5.16219e+08, 5.55497e+08, 5.83092e+08, 6.02073e+08,
 6.14298e+08, 6.21393e+08, 6.25214e+08, 6.27083e+08, 6.27714e+08,
 6.27337e+08, 6.26075e+08, 6.24182e+08, 6.21734e+08, 6.18614e+08,
 6.14749e+08, 6.10254e+08, 6.05134e+08, 5.99204e+08, 5.92233e+08,
 5.84089e+08, 5.74654e+08, 5.63668e+08, 5.50795e+08, 5.35744e+08,
 5.18321e+08, 4.98357e+08, 4.75728e+08, 4.50453e+08, 4.22756e+08,
 3.93048e+08, 3.61884e+08, 3.29934e+08, 2.97939e+08, 2.66630e+08,
 2.44081e+08, 2.16025e+08, 1.90068e+08, 1.66412e+08, 1.45126e+08,
 1.26168e+08, 1.09420e+08, 9.47162e+07, 8.18670e+07, 7.06756e+07,
 6.09517e+07, 5.25173e+07, 4.52103e+07, 3.88858e+07, 3.34162e+07,
 2.86894e+07, 2.46077e+07, 2.10859e+07, 1.80499e+07, 1.54351e+07,
 1.31854e+07, 1.12518e+07, 9.59173e+06, 8.16807e+06, 6.94856e+06,
 5.90512e+06, 5.01334e+06, 4.25205e+06, 3.60289e+06, 3.04994e+06,
 2.57945e+06, 2.17954e+06, 1.83998e+06, 1.55194e+06, 1.30783e+06,
 1.10115e+06, 9.26305e+05, 7.78524e+05, 6.53715e+05, 5.48386e+05,
 4.59559e+05, 3.84698e+05, 3.21644e+05, 2.68562e+05, 2.23894e+05,
 1.86320e+05, 1.54722e+05, 1.28151e+05, 1.05810e+05, 8.70245e+04,
 7.12268e+04, 5.79420e+04, 4.67731e+04, 3.73912e+04, 2.95274e+04,
 2.29657e+04, 1.75389e+04, 1.31258e+04, 9.65071e+03, 7.08505e+03}
,
{9.34899e+06, 8.75371e+07, 2.25225e+08, 3.67464e+08, 4.89058e+08,
 5.84111e+08, 6.53553e+08, 7.02271e+08, 7.36379e+08, 7.59674e+08,
 7.74495e+08, 7.82969e+08, 7.87478e+08, 7.89626e+08, 7.90253e+08,
 7.89603e+08, 7.87860e+08, 7.85348e+08, 7.82109e+08, 7.77977e+08,
 7.72906e+08, 7.67051e+08, 7.60362e+08, 7.52572e+08, 7.43395e+08,
 7.32690e+08, 7.20270e+08, 7.05759e+08, 6.88724e+08, 6.68823e+08,
 6.45823e+08, 6.19510e+08, 5.89765e+08, 5.56686e+08, 5.20642e+08,
 4.82227e+08, 4.42211e+08, 4.01500e+08, 3.61059e+08, 3.31027e+08,
 2.93919e+08, 2.59237e+08, 2.27365e+08, 1.98496e+08, 1.72657e+08,
 1.49751e+08, 1.29594e+08, 1.11957e+08, 9.65875e+07, 8.32331e+07,
 7.16548e+07, 6.16307e+07, 5.29618e+07, 4.54714e+07, 3.90042e+07,
 3.34249e+07, 2.86154e+07, 2.44730e+07, 2.09085e+07, 1.78444e+07,
 1.52131e+07, 1.29560e+07, 1.10221e+07, 9.36694e+06, 7.95209e+06,
 6.74403e+06, 5.71375e+06, 4.83608e+06, 4.08926e+06, 3.45449e+06,
 2.91554e+06, 2.45843e+06, 2.07112e+06, 1.74328e+06, 1.46605e+06,
 1.23182e+06, 1.03410e+06, 8.67346e+05, 7.26812e+05, 6.08467e+05,
 5.08878e+05, 4.25126e+05, 3.54736e+05, 2.95605e+05, 2.45954e+05,
 2.04278e+05, 1.69305e+05, 1.39960e+05, 1.15338e+05, 9.46790e+04,
 7.73426e+04, 6.27943e+04, 5.05882e+04, 4.03558e+04, 3.17961e+04,
 2.46678e+04, 1.87837e+04, 1.40080e+04, 1.02551e+04, 7.49078e+03}
,
{1.21601e+07, 1.12877e+08, 2.88509e+08, 4.68623e+08, 6.21768e+08,
 7.40832e+08, 8.27294e+08, 8.87718e+08, 9.29867e+08, 9.58440e+08,
 9.76387e+08, 9.86502e+08, 9.91816e+08, 9.94272e+08, 9.94852e+08,
 9.93811e+08, 9.91432e+08, 9.88103e+08, 9.83818e+08, 9.78354e+08,
 9.71718e+08, 9.64093e+08, 9.55347e+08, 9.45106e+08, 9.33035e+08,
 9.18971e+08, 9.02614e+08, 8.83443e+08, 8.60909e+08, 8.34619e+08,
 8.04281e+08, 7.69636e+08, 7.30594e+08, 6.87384e+08, 6.40581e+08,
 5.91025e+08, 5.39777e+08, 4.88045e+08, 4.37073e+08, 3.99705e+08,
 3.53615e+08, 3.10845e+08, 2.71796e+08, 2.36631e+08, 2.05316e+08,
 1.77675e+08, 1.53442e+08, 1.32302e+08, 1.13930e+08, 9.80028e+07,
 8.42213e+07, 7.23117e+07, 6.20299e+07, 5.31608e+07, 4.55163e+07,
 3.89325e+07, 3.32670e+07, 2.83962e+07, 2.42127e+07, 2.06233e+07,
 1.75470e+07, 1.49134e+07, 1.26614e+07, 1.07381e+07, 9.09741e+06,
 7.69944e+06, 6.50971e+06, 5.49836e+06, 4.63964e+06, 3.91131e+06,
 3.29425e+06, 2.77201e+06, 2.33047e+06, 1.95752e+06, 1.64282e+06,
 1.37751e+06, 1.15403e+06, 9.65953e+05, 8.07790e+05, 6.74885e+05,
 5.63283e+05, 4.69631e+05, 3.91087e+05, 3.25249e+05, 2.70084e+05,
 2.23879e+05, 1.85188e+05, 1.52793e+05, 1.25669e+05, 1.02959e+05,
 8.39420e+04, 6.80160e+04, 5.46814e+04, 4.35258e+04, 3.42126e+04,
 2.64720e+04, 2.00952e+04, 1.49303e+04, 1.08806e+04, 7.90491e+03}
,
{1.58109e+07, 1.45500e+08, 3.69464e+08, 5.97488e+08, 7.90327e+08,
 9.39433e+08, 1.04706e+09, 1.12200e+09, 1.17408e+09, 1.20910e+09,
 1.23081e+09, 1.24288e+09, 1.24913e+09, 1.25192e+09, 1.25238e+09,
 1.25080e+09, 1.24758e+09, 1.24317e+09, 1.23751e+09, 1.23029e+09,
 1.22162e+09, 1.21170e+09, 1.20025e+09, 1.18678e+09, 1.17092e+09,
 1.15244e+09, 1.13089e+09, 1.10556e+09, 1.07577e+09, 1.04107e+09,
 1.00109e+09, 9.55522e+08, 9.04359e+08, 8.48029e+08, 7.87389e+08,
 7.23616e+08, 6.58155e+08, 5.92601e+08, 5.28534e+08, 4.82179e+08,
 4.25077e+08, 3.72452e+08, 3.24707e+08, 2.81947e+08, 2.44051e+08,
 2.10735e+08, 1.81627e+08, 1.56310e+08, 1.34360e+08, 1.15372e+08,
 9.89733e+07, 8.48274e+07, 7.26357e+07, 6.21369e+07, 5.31030e+07,
 4.53361e+07, 3.86644e+07, 3.29391e+07, 2.80309e+07, 2.38277e+07,
 2.02325e+07, 1.71610e+07, 1.45398e+07, 1.23059e+07, 1.04041e+07,
 8.78717e+06, 7.41398e+06, 6.24917e+06, 5.26225e+06, 4.42698e+06,
 3.72084e+06, 3.12448e+06, 2.62136e+06, 2.19731e+06, 1.84026e+06,
 1.53988e+06, 1.28741e+06, 1.07539e+06, 8.97472e+05, 7.48287e+05,
 6.23283e+05, 5.18607e+05, 4.31007e+05, 3.57733e+05, 2.96470e+05,
 2.45266e+05, 2.02480e+05, 1.66732e+05, 1.36865e+05, 1.11910e+05,
 9.10568e+04, 7.36291e+04, 5.90672e+04, 4.69097e+04, 3.67805e+04,
 2.83787e+04, 2.14717e+04, 1.58899e+04, 1.15238e+04, 8.32405e+03}
,
{2.05507e+07, 1.87489e+08, 4.72997e+08, 7.61609e+08, 1.00438e+09,
 1.19107e+09, 1.32502e+09, 1.41796e+09, 1.48228e+09, 1.52519e+09,
 1.55141e+09, 1.56580e+09, 1.57314e+09, 1.57629e+09, 1.57654e+09,
 1.57420e+09, 1.56987e+09, 1.56405e+09, 1.55655e+09, 1.54705e+09,
 1.53575e+09, 1.52281e+09, 1.50782e+09, 1.49012e+09, 1.46928e+09,
 1.44501e+09, 1.41661e+09, 1.38314e+09, 1.34379e+09, 1.29802e+09,
 1.24537e+09, 1.18551e+09, 1.11858e+09, 1.04529e+09, 9.66900e+08,
 8.85032e+08, 8.01635e+08, 7.18793e+08, 6.56907e+08, 5.81152e+08,
 5.10573e+08, 4.45964e+08, 3.87696e+08, 3.35784e+08, 2.89983e+08,
 2.49871e+08, 2.14937e+08, 1.84633e+08, 1.58421e+08, 1.35794e+08,
 1.16288e+08, 9.94899e+07, 8.50373e+07, 7.26124e+07, 6.19395e+07,
 5.27795e+07, 4.49254e+07, 3.81978e+07, 3.24414e+07, 2.75216e+07,
 2.33218e+07, 1.97409e+07, 1.66914e+07, 1.40978e+07, 1.18945e+07,
 1.00252e+07, 8.44098e+06, 7.10006e+06, 5.96635e+06, 5.00892e+06,
 4.20121e+06, 3.52055e+06, 2.94754e+06, 2.46562e+06, 2.06071e+06,
 1.72080e+06, 1.43571e+06, 1.19681e+06, 9.96764e+05, 8.29382e+05,
 6.89430e+05, 5.72488e+05, 4.74830e+05, 3.93318e+05, 3.25312e+05,
 2.68592e+05, 2.21297e+05, 1.81865e+05, 1.48990e+05, 1.21579e+05,
 9.87196e+04, 7.96554e+04, 6.37589e+04, 5.05143e+04, 3.95018e+04,
 3.03867e+04, 2.29103e+04, 1.68828e+04, 1.21804e+04, 8.74432e+03}
,
{2.67017e+07, 2.41513e+08, 6.05371e+08, 9.70590e+08, 1.27616e+09,
 1.50984e+09, 1.67654e+09, 1.79178e+09, 1.87120e+09, 1.92373e+09,
 1.95538e+09, 1.97252e+09, 1.98114e+09, 1.98466e+09, 1.98454e+09,
 1.98116e+09, 1.97538e+09, 1.96769e+09, 1.95778e+09, 1.94529e+09,
 1.93057e+09, 1.91372e+09, 1.89407e+09, 1.87080e+09, 1.84345e+09,
 1.81155e+09, 1.77410e+09, 1.72989e+09, 1.67795e+09, 1.61764e+09,
 1.54836e+09, 1.46984e+09, 1.38243e+09, 1.28729e+09, 1.18617e+09,
 1.08133e+09, 9.75366e+08, 8.70957e+08, 7.93935e+08, 6.99849e+08,
 6.12811e+08, 5.33648e+08, 4.62661e+08, 3.99732e+08, 3.44442e+08,
 2.96192e+08, 2.54296e+08, 2.18046e+08, 1.86759e+08, 1.59802e+08,
 1.36606e+08, 1.16664e+08, 9.95354e+07, 8.48348e+07, 7.22289e+07,
 6.14291e+07, 5.21860e+07, 4.42835e+07, 3.75348e+07, 3.17784e+07,
 2.68742e+07, 2.27014e+07, 1.91552e+07, 1.61453e+07, 1.35939e+07,
 1.14337e+07, 9.60700e+06, 8.06408e+06, 6.76238e+06, 5.66542e+06,
 4.74200e+06, 3.96549e+06, 3.31319e+06, 2.76576e+06, 2.30678e+06,
 1.92232e+06, 1.60055e+06, 1.33148e+06, 1.10666e+06, 9.18950e+05,
 7.62334e+05, 6.31746e+05, 5.22924e+05, 4.32285e+05, 3.56825e+05,
 2.94020e+05, 2.41762e+05, 1.98284e+05, 1.62111e+05, 1.32012e+05,
 1.06963e+05, 8.61158e+04, 6.87682e+04, 5.43441e+04, 4.23763e+04,
 3.24929e+04, 2.44059e+04, 1.79032e+04, 1.28451e+04, 9.16152e+03}
,
{3.46814e+07, 3.11002e+08, 7.74578e+08, 1.23664e+09, 1.62118e+09,
 1.91362e+09, 2.12101e+09, 2.26391e+09, 2.36195e+09, 2.42621e+09,
 2.46438e+09, 2.48479e+09, 2.49486e+09, 2.49875e+09, 2.49805e+09,
 2.49328e+09, 2.48559e+09, 2.47544e+09, 2.46234e+09, 2.44595e+09,
 2.42681e+09, 2.40483e+09, 2.37906e+09, 2.34849e+09, 2.31261e+09,
 2.27068e+09, 2.22129e+09, 2.16291e+09, 2.09441e+09, 2.01499e+09,
 1.92394e+09, 1.82107e+09, 1.70713e+09, 1.58387e+09, 1.45374e+09,
 1.31981e+09, 1.18552e+09, 1.05428e+09, 9.58695e+08, 8.42117e+08,
 7.35013e+08, 6.38201e+08, 5.51860e+08, 4.75675e+08, 4.09002e+08,
 3.51013e+08, 3.00801e+08, 2.57457e+08, 2.20126e+08, 1.88022e+08,
 1.60444e+08, 1.36776e+08, 1.16480e+08, 9.90915e+07, 8.42067e+07,
 7.14776e+07, 6.06033e+07, 5.13240e+07, 4.34151e+07, 3.66824e+07,
 3.09582e+07, 2.60975e+07, 2.19755e+07, 1.84843e+07, 1.55310e+07,
 1.30359e+07, 1.09305e+07, 9.15595e+06, 7.66206e+06, 6.40583e+06,
 5.35061e+06, 4.46517e+06, 3.72295e+06, 3.10140e+06, 2.58138e+06,
 2.14672e+06, 1.78372e+06, 1.48082e+06, 1.22826e+06, 1.01785e+06,
 8.42659e+05, 6.96896e+05, 5.75684e+05, 4.74940e+05, 3.91242e+05,
 3.21728e+05, 2.64008e+05, 2.16086e+05, 1.76297e+05, 1.43258e+05,
 1.15819e+05, 9.30293e+04, 7.41039e+04, 5.84010e+04, 4.54014e+04,
 3.46918e+04, 2.59514e+04, 1.89441e+04, 1.35120e+04, 9.57126e+03}
,
{4.50295e+07, 4.00355e+08, 9.90814e+08, 1.57527e+09, 2.05909e+09,
 2.42497e+09, 2.68296e+09, 2.86016e+09, 2.98113e+09, 3.05969e+09,
 3.10566e+09, 3.12995e+09, 3.14171e+09, 3.14592e+09, 3.14435e+09,
 3.13771e+09, 3.12751e+09, 3.11412e+09, 3.09681e+09, 3.07537e+09,
 3.05049e+09, 3.02179e+09, 2.98798e+09, 2.94785e+09, 2.90079e+09,
 2.84566e+09, 2.78051e+09, 2.70346e+09, 2.61319e+09, 2.50869e+09,
 2.38914e+09, 2.25458e+09, 2.10636e+09, 1.94699e+09, 1.77991e+09,
 1.60926e+09, 1.43951e+09, 1.31170e+09, 1.15667e+09, 1.01255e+09,
 8.81018e+08, 7.62833e+08, 6.57971e+08, 5.65850e+08, 4.85529e+08,
 4.15887e+08, 3.55740e+08, 3.03938e+08, 2.59410e+08, 2.21185e+08,
 1.88406e+08, 1.60322e+08, 1.36280e+08, 1.15717e+08, 9.81465e+07,
 8.31478e+07, 7.03589e+07, 5.94668e+07, 5.02017e+07, 4.23303e+07,
 3.56517e+07, 2.99924e+07, 2.52030e+07, 2.11552e+07, 1.77383e+07,
 1.48577e+07, 1.24322e+07, 1.03923e+07, 8.67859e+06, 7.24064e+06,
 6.03536e+06, 5.02617e+06, 4.18202e+06, 3.47663e+06, 2.88773e+06,
 2.39654e+06, 1.98720e+06, 1.64636e+06, 1.36278e+06, 1.12701e+06,
 9.31134e+05, 7.68500e+05, 6.33545e+05, 5.21613e+05, 4.28815e+05,
 3.51904e+05, 2.88175e+05, 2.35372e+05, 1.91621e+05, 1.55365e+05,
 1.25318e+05, 1.00412e+05, 7.97717e+04, 6.26839e+04, 4.85714e+04,
 3.69746e+04, 2.75375e+04, 1.99974e+04, 1.41749e+04, 9.96895e+03}
,
{5.84439e+07, 5.15217e+08, 1.26708e+09, 2.00620e+09, 2.61481e+09,
 3.07248e+09, 3.39337e+09, 3.61306e+09, 3.76230e+09, 3.85826e+09,
 3.91359e+09, 3.94247e+09, 3.95616e+09, 3.96061e+09, 3.95776e+09,
 3.94863e+09, 3.93513e+09, 3.91746e+09, 3.89463e+09, 3.86664e+09,
 3.83429e+09, 3.79681e+09, 3.75243e+09, 3.69978e+09, 3.63807e+09,
 3.56553e+09, 3.47961e+09, 3.37798e+09, 3.25912e+09, 3.12172e+09,
 2.96494e+09, 2.78923e+09, 2.59677e+09, 2.39116e+09, 2.17713e+09,
 1.96021e+09, 1.74619e+09, 1.58702e+09, 1.39441e+09, 1.21662e+09,
 1.05540e+09, 9.11359e+08, 7.84178e+08, 6.72909e+08, 5.76229e+08,
 4.92646e+08, 4.20635e+08, 3.58748e+08, 3.05651e+08, 2.60152e+08,
 2.21200e+08, 1.87883e+08, 1.59410e+08, 1.35100e+08, 1.14365e+08,
 9.66979e+07, 8.16623e+07, 6.88818e+07, 5.80320e+07, 4.88331e+07,
 4.10441e+07, 3.44577e+07, 2.88955e+07, 2.42044e+07, 2.02529e+07,
 1.69288e+07, 1.41357e+07, 1.17917e+07, 9.82682e+06, 8.18161e+06,
 6.80555e+06, 5.65583e+06, 4.69620e+06, 3.89601e+06, 3.22940e+06,
 2.67457e+06, 2.21318e+06, 1.82982e+06, 1.51153e+06, 1.24747e+06,
 1.02855e+06, 8.47172e+05, 6.96975e+05, 5.72661e+05, 4.69813e+05,
 3.84749e+05, 3.14409e+05, 2.56247e+05, 2.08154e+05, 1.68382e+05,
 1.35486e+05, 1.08275e+05, 8.57731e+04, 6.71873e+04, 5.18760e+04,
 3.93294e+04, 2.91535e+04, 2.10543e+04, 1.48272e+04, 1.03503e+04}
,
{7.58275e+07, 6.62827e+08, 1.61995e+09, 2.55447e+09, 3.31994e+09,
 3.89228e+09, 4.29136e+09, 4.56371e+09, 4.74775e+09, 4.86488e+09,
 4.93140e+09, 4.96571e+09, 4.98161e+09, 4.98616e+09, 4.98145e+09,
 4.96902e+09, 4.95119e+09, 4.92788e+09, 4.89781e+09, 4.86133e+09,
 4.81926e+09, 4.77027e+09, 4.71203e+09, 4.64301e+09, 4.56206e+09,
 4.46661e+09, 4.35329e+09, 4.21936e+09, 4.06296e+09, 3.88247e+09,
 3.67711e+09, 3.44805e+09, 3.19863e+09, 2.93393e+09, 2.66040e+09,
 2.38536e+09, 2.11620e+09, 1.91851e+09, 1.67975e+09, 1.46087e+09,
 1.26361e+09, 1.08832e+09, 9.34260e+08, 7.99996e+08, 6.83715e+08,
 5.83459e+08, 4.97282e+08, 4.23372e+08, 3.60075e+08, 3.05928e+08,
 2.59651e+08, 2.20136e+08, 1.86424e+08, 1.57692e+08, 1.33230e+08,
 1.12426e+08, 9.47555e+07, 7.97647e+07, 6.70640e+07, 5.63179e+07,
 4.72378e+07, 3.95756e+07, 3.31186e+07, 2.76844e+07, 2.31167e+07,
 1.92824e+07, 1.60676e+07, 1.33754e+07, 1.11235e+07, 9.24194e+06,
 7.67161e+06, 6.36237e+06, 5.27193e+06, 4.36460e+06, 3.61035e+06,
 2.98391e+06, 2.46408e+06, 2.03307e+06, 1.67599e+06, 1.38036e+06,
 1.13579e+06, 9.33579e+05, 7.66482e+05, 6.28469e+05, 5.14523e+05,
 4.20475e+05, 3.42862e+05, 2.78818e+05, 2.25967e+05, 1.82350e+05,
 1.46345e+05, 1.16625e+05, 9.21046e+04, 7.19005e+04, 5.53009e+04,
 4.17422e+04, 3.07870e+04, 2.21052e+04, 1.54622e+04, 1.07117e+04}
,
{9.83515e+07, 8.52467e+08, 2.07056e+09, 3.25192e+09, 4.21448e+09,
 4.93007e+09, 5.42633e+09, 5.76394e+09, 5.99080e+09, 6.13366e+09,
 6.21359e+09, 6.25432e+09, 6.27270e+09, 6.27710e+09, 6.26978e+09,
 6.25299e+09, 6.22947e+09, 6.19871e+09, 6.15918e+09, 6.11171e+09,
 6.05698e+09, 5.99290e+09, 5.91649e+09, 5.82606e+09, 5.71986e+09,
 5.59421e+09, 5.44481e+09, 5.26843e+09, 5.06278e+09, 4.82589e+09,
 4.55729e+09, 4.25920e+09, 3.93660e+09, 3.59656e+09, 3.24780e+09,
 2.89993e+09, 2.63546e+09, 2.31737e+09, 2.02203e+09, 1.75308e+09,
 1.51214e+09, 1.29912e+09, 1.11271e+09, 9.50841e+08, 8.11082e+08,
 6.90883e+08, 5.87798e+08, 4.99554e+08, 4.24116e+08, 3.59693e+08,
 3.04727e+08, 2.57871e+08, 2.17967e+08, 1.84018e+08, 1.55167e+08,
 1.30678e+08, 1.09917e+08, 9.23406e+07, 7.74791e+07, 6.49307e+07,
 5.43497e+07, 4.54399e+07, 3.79473e+07, 3.16549e+07, 2.63773e+07,
 2.19564e+07, 1.82578e+07, 1.51670e+07, 1.25873e+07, 1.04365e+07,
 8.64520e+06, 7.15496e+06, 5.91641e+06, 4.88804e+06, 4.03499e+06,
 3.32800e+06, 2.74256e+06, 2.25819e+06, 1.85774e+06, 1.52691e+06,
 1.25379e+06, 1.02844e+06, 8.42616e+05, 6.89450e+05, 5.63253e+05,
 4.59304e+05, 3.73694e+05, 3.03192e+05, 2.45131e+05, 1.97307e+05,
 1.57911e+05, 1.25464e+05, 9.87560e+04, 7.68065e+04, 5.88279e+04,
 4.41965e+04, 3.24246e+04, 2.31402e+04, 1.60742e+04, 1.10506e+04}
,
{1.27528e+08, 1.09604e+09, 2.64587e+09, 4.13897e+09, 5.34915e+09,
 6.24363e+09, 6.86068e+09, 7.27915e+09, 7.55870e+09, 7.73277e+09,
 7.82873e+09, 7.87703e+09, 7.89821e+09, 7.90207e+09, 7.89111e+09,
 7.86859e+09, 7.83758e+09, 7.79702e+09, 7.74514e+09, 7.68344e+09,
 7.61221e+09, 7.52834e+09, 7.42813e+09, 7.30969e+09, 7.17031e+09,
 7.00489e+09, 6.80801e+09, 6.57591e+09, 6.30569e+09, 5.99511e+09,
 5.64428e+09, 5.25706e+09, 4.84063e+09, 4.40476e+09, 3.96114e+09,
 3.52221e+09, 3.19248e+09, 2.79702e+09, 2.43244e+09, 2.10257e+09,
 1.80872e+09, 1.55018e+09, 1.32485e+09, 1.12986e+09, 9.61985e+08,
 8.17948e+08, 6.94676e+08, 5.89348e+08, 4.99461e+08, 4.22829e+08,
 3.57556e+08, 3.02009e+08, 2.54788e+08, 2.14686e+08, 1.80670e+08,
 1.51852e+08, 1.27470e+08, 1.06869e+08, 8.94858e+07, 7.48386e+07,
 6.25138e+07, 5.21574e+07, 4.34669e+07, 3.61840e+07, 3.00886e+07,
 2.49937e+07, 2.07402e+07, 1.71934e+07, 1.42394e+07, 1.17818e+07,
 9.73938e+06, 8.04384e+06, 6.63766e+06, 5.47260e+06, 4.50820e+06,
 3.71063e+06, 3.05159e+06, 2.50746e+06, 2.05856e+06, 1.68848e+06,
 1.38359e+06, 1.13255e+06, 9.25971e+05, 7.56048e+05, 6.16327e+05,
 5.01469e+05, 4.07065e+05, 3.29478e+05, 2.65706e+05, 2.13284e+05,
 1.70193e+05, 1.34783e+05, 1.05708e+05, 8.18830e+04, 6.24357e+04,
 4.66741e+04, 3.40521e+04, 2.41502e+04, 1.66584e+04, 1.13653e+04}
 ,
{1.65311e+08, 1.40879e+09, 3.38022e+09, 5.26695e+09, 6.78817e+09,
 7.90603e+09, 8.67321e+09, 9.19183e+09, 9.53616e+09, 9.74810e+09,
 9.86323e+09, 9.92045e+09, 9.94471e+09, 9.94745e+09, 9.93149e+09,
 9.90143e+09, 9.86060e+09, 9.80710e+09, 9.73917e+09, 9.65904e+09,
 9.56627e+09, 9.45644e+09, 9.32510e+09, 9.17002e+09, 8.98703e+09,
 8.76922e+09, 8.50992e+09, 8.20471e+09, 7.84992e+09, 7.44315e+09,
 6.98564e+09, 6.48355e+09, 5.94709e+09, 5.38960e+09, 4.82662e+09,
 4.27412e+09, 3.86410e+09, 3.37351e+09, 2.92433e+09, 2.52043e+09,
 2.16257e+09, 1.84914e+09, 1.57703e+09, 1.34231e+09, 1.14076e+09,
 9.68224e+08, 8.20856e+08, 6.95168e+08, 5.88089e+08, 4.96954e+08,
 4.19458e+08, 3.53626e+08, 2.97759e+08, 2.50403e+08, 2.10310e+08,
 1.76410e+08, 1.47786e+08, 1.23648e+08, 1.03323e+08, 8.62333e+07,
 7.18830e+07, 5.98502e+07, 4.97744e+07, 4.13486e+07, 3.43118e+07,
 2.84425e+07, 2.35530e+07, 1.94847e+07, 1.61035e+07, 1.32965e+07,
 1.09688e+07, 9.04044e+06, 7.44461e+06, 6.12522e+06, 5.03540e+06,
 4.13601e+06, 3.39440e+06, 2.78339e+06, 2.28037e+06, 1.86655e+06,
 1.52632e+06, 1.24676e+06, 1.01719e+06, 8.28732e+05, 6.74085e+05,
 5.47212e+05, 4.43141e+05, 3.57775e+05, 2.87749e+05, 2.30304e+05,
 1.83188e+05, 1.44563e+05, 1.12936e+05, 8.71028e+04, 6.61001e+04,
 4.91548e+04, 3.56556e+04, 2.51274e+04, 1.72114e+04, 1.16546e+04}
};

const std::vector< std::vector<double> > PROPOSAL::y_nubar_n = {
{0.0523654, 0.053949 , 0.0555805, 0.0572613, 0.0589929, 0.060777 ,
 0.0626149, 0.0645085, 0.0664593, 0.0684691, 0.0705397, 0.0726729,
 0.0748707, 0.0771348, 0.0794675, 0.0818707, 0.0843466, 0.0868973,
 0.0895252, 0.0922326, 0.0950218, 0.0978954, 0.100856 , 0.103906 ,
 0.107048 , 0.110285 , 0.113621 , 0.117057 , 0.120597 , 0.124244 ,
 0.128001 , 0.131872 , 0.13586  , 0.139968 , 0.144201 , 0.148562 ,
 0.153055 , 0.157683 , 0.162452 , 0.167364 , 0.172426 , 0.17764  ,
 0.183012 , 0.188547 , 0.194249 , 0.200123 , 0.206175 , 0.21241  ,
 0.218833 , 0.225451 , 0.232269 , 0.239293 , 0.24653  , 0.253985 ,
 0.261666 , 0.269579 , 0.277732 , 0.286131 , 0.294784 , 0.303698 ,
 0.312882 , 0.322344 , 0.332092 , 0.342135 , 0.352482 , 0.363141 ,
 0.374123 , 0.385437 , 0.397093 , 0.409102 , 0.421474 , 0.43422  ,
 0.447351 , 0.460879 , 0.474817 , 0.489176 , 0.503969 , 0.51921  ,
 0.534912 , 0.551088 , 0.567754 , 0.584923 , 0.602612 , 0.620836 ,
 0.639611 , 0.658953 , 0.678881 , 0.699411 , 0.720562 , 0.742353 ,
 0.764803 , 0.787931 , 0.811759 , 0.836308 , 0.861599 , 0.887655 ,
 0.914499 , 0.942154 , 0.970646 , 1.       }
,
{0.0420756, 0.0434439, 0.0448568, 0.0463155, 0.0478217, 0.0493769,
 0.0509827, 0.0526407, 0.0543526, 0.0561201, 0.0579452, 0.0598296,
 0.0617753, 0.0637842, 0.0658585, 0.0680003, 0.0702117, 0.072495 ,
 0.0748526, 0.0772868, 0.0798002, 0.0823954, 0.0850749, 0.0878416,
 0.0906982, 0.0936478, 0.0966933, 0.0998378, 0.103085 , 0.106437 ,
 0.109898 , 0.113472 , 0.117162 , 0.120973 , 0.124907 , 0.128969 ,
 0.133163 , 0.137493 , 0.141965 , 0.146581 , 0.151348 , 0.15627  ,
 0.161352 , 0.1666   , 0.172017 , 0.177612 , 0.183388 , 0.189351 ,
 0.195509 , 0.201867 , 0.208432 , 0.21521  , 0.222209 , 0.229436 ,
 0.236897 , 0.244601 , 0.252555 , 0.260769 , 0.269249 , 0.278005 ,
 0.287046 , 0.296381 , 0.306019 , 0.315971 , 0.326247 , 0.336856 ,
 0.347811 , 0.359122 , 0.370801 , 0.38286  , 0.39531  , 0.408166 ,
 0.42144  , 0.435145 , 0.449296 , 0.463908 , 0.478994 , 0.494571 ,
 0.510655 , 0.527262 , 0.544409 , 0.562113 , 0.580393 , 0.599268 ,
 0.618757 , 0.638879 , 0.659655 , 0.681108 , 0.703258 , 0.726128 ,
 0.749742 , 0.774124 , 0.799299 , 0.825293 , 0.852131 , 0.879843 ,
 0.908456 , 0.938    , 0.968504 , 1.       }
,
{0.0337461, 0.0349213, 0.0361374, 0.0373958, 0.0386981, 0.0400457,
 0.0414402, 0.0428833, 0.0443767, 0.0459221, 0.0475212, 0.0491761,
 0.0508886, 0.0526608, 0.0544946, 0.0563923, 0.0583561, 0.0603883,
 0.0624913, 0.0646674, 0.0669194, 0.0692498, 0.0716613, 0.0741569,
 0.0767393, 0.0794117, 0.0821771, 0.0850388, 0.0880002, 0.0910647,
 0.0942359, 0.0975176, 0.100913 , 0.104428 , 0.108064 , 0.111827 ,
 0.115722 , 0.119752 , 0.123922 , 0.128237 , 0.132703 , 0.137324 ,
 0.142106 , 0.147055 , 0.152176 , 0.157475 , 0.162959 , 0.168634 ,
 0.174507 , 0.180584 , 0.186872 , 0.19338  , 0.200114 , 0.207083 ,
 0.214294 , 0.221757 , 0.229479 , 0.237471 , 0.24574  , 0.254298 ,
 0.263154 , 0.272318 , 0.281801 , 0.291614 , 0.301769 , 0.312278 ,
 0.323153 , 0.334406 , 0.346051 , 0.358102 , 0.370573 , 0.383478 ,
 0.396832 , 0.410651 , 0.424951 , 0.43975  , 0.455064 , 0.470911 ,
 0.48731  , 0.50428  , 0.521841 , 0.540013 , 0.558818 , 0.578279 ,
 0.598417 , 0.619256 , 0.640821 , 0.663136 , 0.686229 , 0.710126 ,
 0.734856 , 0.760446 , 0.786928 , 0.814332 , 0.84269  , 0.872036 ,
 0.902403 , 0.933829 , 0.966348 , 1.       }
,
{0.0270257, 0.0280296, 0.0290709, 0.0301508, 0.0312708, 0.0324325,
 0.0336373, 0.0348868, 0.0361828, 0.0375269, 0.0389209, 0.0403667,
 0.0418663, 0.0434215, 0.0450345, 0.0467075, 0.0484425, 0.0502421,
 0.0521085, 0.0540442, 0.0560518, 0.058134 , 0.0602935, 0.0625333,
 0.0648563, 0.0672656, 0.0697643, 0.0723559, 0.0750438, 0.0778315,
 0.0807227, 0.0837214, 0.0868315, 0.0900571, 0.0934025, 0.0968722,
 0.100471 , 0.104203 , 0.108074 , 0.112089 , 0.116253 , 0.120571 ,
 0.12505  , 0.129695 , 0.134513 , 0.13951  , 0.144693 , 0.150068 ,
 0.155642 , 0.161424 , 0.167421 , 0.17364  , 0.18009  , 0.18678  ,
 0.193719 , 0.200915 , 0.208378 , 0.216119 , 0.224147 , 0.232474 ,
 0.24111  , 0.250067 , 0.259356 , 0.268991 , 0.278983 , 0.289347 ,
 0.300095 , 0.311243 , 0.322805 , 0.334796 , 0.347233 , 0.360132 ,
 0.37351  , 0.387386 , 0.401776 , 0.416701 , 0.432181 , 0.448235 ,
 0.464886 , 0.482156 , 0.500067 , 0.518643 , 0.537909 , 0.557892 ,
 0.578616 , 0.60011  , 0.622403 , 0.645524 , 0.669504 , 0.694374 ,
 0.720169 , 0.746921 , 0.774668 , 0.803445 , 0.833291 , 0.864246 ,
 0.896351 , 0.929648 , 0.964183 , 1.       }
,
{0.021618 , 0.0224717, 0.0233591, 0.0242815, 0.0252404, 0.0262371,
 0.0272732, 0.0283502, 0.0294697, 0.0306335, 0.0318432, 0.0331006,
 0.0344077, 0.0357665, 0.0371789, 0.0386471, 0.0401732, 0.0417596,
 0.0434087, 0.0451229, 0.0469047, 0.048757 , 0.0506823, 0.0526838,
 0.0547642, 0.0569268, 0.0591748, 0.0615116, 0.0639406, 0.0664656,
 0.0690903, 0.0718186, 0.0746547, 0.0776028, 0.0806672, 0.0838527,
 0.087164 , 0.0906061, 0.0941841, 0.0979033, 0.101769 , 0.105788 ,
 0.109966 , 0.114308 , 0.118822 , 0.123514 , 0.128392 , 0.133462 ,
 0.138732 , 0.144211 , 0.149906 , 0.155825 , 0.161979 , 0.168375 ,
 0.175024 , 0.181936 , 0.18912  , 0.196589 , 0.204352 , 0.212421 ,
 0.22081  , 0.229529 , 0.238593 , 0.248015 , 0.257809 , 0.26799  ,
 0.278573 , 0.289573 , 0.301008 , 0.312895 , 0.325251 , 0.338095 ,
 0.351446 , 0.365325 , 0.379751 , 0.394747 , 0.410335 , 0.426539 ,
 0.443383 , 0.460892 , 0.479092 , 0.498011 , 0.517677 , 0.53812  ,
 0.55937  , 0.581459 , 0.604421 , 0.628289 , 0.6531   , 0.67889  ,
 0.705699 , 0.733567 , 0.762535 , 0.792647 , 0.823948 , 0.856485 ,
 0.890307 , 0.925465 , 0.962011 , 1.       }
,
{0.017276 , 0.0179989, 0.0187521, 0.0195368, 0.0203543, 0.0212061,
 0.0220935, 0.023018 , 0.0239812, 0.0249847, 0.0260303, 0.0271195,
 0.0282544, 0.0294367, 0.0306685, 0.0319519, 0.0332889, 0.034682 ,
 0.0361333, 0.0376453, 0.0392206, 0.0408619, 0.0425718, 0.0443532,
 0.0462093, 0.0481429, 0.0501575, 0.0522564, 0.0544432, 0.0567214,
 0.059095 , 0.0615679, 0.0641443, 0.0668285, 0.069625 , 0.0725385,
 0.075574 , 0.0787365, 0.0820313, 0.085464 , 0.0890403, 0.0927663,
 0.0966483, 0.100693 , 0.104906 , 0.109296 , 0.11387  , 0.118635 ,
 0.123599 , 0.128771 , 0.13416  , 0.139774 , 0.145623 , 0.151717 ,
 0.158066 , 0.16468  , 0.171571 , 0.178751 , 0.186231 , 0.194024 ,
 0.202143 , 0.210602 , 0.219415 , 0.228597 , 0.238163 , 0.248129 ,
 0.258512 , 0.26933  , 0.2806   , 0.292342 , 0.304576 , 0.317321 ,
 0.3306   , 0.344434 , 0.358847 , 0.373864 , 0.389508 , 0.405808 ,
 0.422789 , 0.440482 , 0.458914 , 0.478118 , 0.498125 , 0.51897  ,
 0.540687 , 0.563313 , 0.586885 , 0.611444 , 0.637031 , 0.663688 ,
 0.691461 , 0.720396 , 0.750541 , 0.781949 , 0.81467  , 0.848761 ,
 0.884279 , 0.921282 , 0.959835 , 1.       }
,
{0.0137955, 0.0144055, 0.0150425, 0.0157076, 0.0164021, 0.0171274,
 0.0178847, 0.0186755, 0.0195013, 0.0203635, 0.0212639, 0.0222042,
 0.023186 , 0.0242112, 0.0252817, 0.0263995, 0.0275668, 0.0287857,
 0.0300585, 0.0313876, 0.0327755, 0.0342247, 0.035738 , 0.0373182,
 0.0389683, 0.0406913, 0.0424905, 0.0443693, 0.0463312, 0.0483798,
 0.0505189, 0.0527527, 0.0550852, 0.0575209, 0.0600643, 0.0627201,
 0.0654934, 0.0683893, 0.0714132, 0.0745708, 0.0778681, 0.0813111,
 0.0849064, 0.0886607, 0.0925809, 0.0966745, 0.100949 , 0.105413 ,
 0.110074 , 0.114941 , 0.120023 , 0.12533  , 0.130872 , 0.136658 ,
 0.142701 , 0.149011 , 0.155599 , 0.162479 , 0.169664 , 0.177166 ,
 0.184999 , 0.193179 , 0.201721 , 0.21064  , 0.219954 , 0.22968  ,
 0.239835 , 0.25044  , 0.261513 , 0.273077 , 0.285151 , 0.297759 ,
 0.310925 , 0.324673 , 0.339029 , 0.35402  , 0.369673 , 0.386019 ,
 0.403087 , 0.42091  , 0.439522 , 0.458956 , 0.479249 , 0.50044  ,
 0.522567 , 0.545673 , 0.569801 , 0.594996 , 0.621304 , 0.648776 ,
 0.677463 , 0.707418 , 0.738697 , 0.77136  , 0.805466 , 0.841081 ,
 0.878271 , 0.917105 , 0.957656 , 1.       }
,
{0.0110096, 0.0115226, 0.0120596, 0.0126215, 0.0132097, 0.0138252,
 0.0144694, 0.0151437, 0.0158494, 0.0165879, 0.0173609, 0.0181699,
 0.0190166, 0.0199027, 0.0208302, 0.0218008, 0.0228167, 0.0238799,
 0.0249927, 0.0261573, 0.0273762, 0.0286519, 0.029987 , 0.0313844,
 0.0328468, 0.0343774, 0.0359794, 0.037656 , 0.0394107, 0.0412471,
 0.0431692, 0.0451808, 0.0472862, 0.0494896, 0.0517958, 0.0542094,
 0.0567354, 0.0593792, 0.0621462, 0.0650421, 0.068073 , 0.0712451,
 0.074565 , 0.0780396, 0.0816761, 0.0854821, 0.0894654, 0.0936344,
 0.0979976, 0.102564 , 0.107343 , 0.112346 , 0.117581 , 0.12306  ,
 0.128794 , 0.134796 , 0.141077 , 0.147651 , 0.154531 , 0.161732 ,
 0.169269 , 0.177156 , 0.185412 , 0.194051 , 0.203094 , 0.212558 ,
 0.222463 , 0.232829 , 0.243679 , 0.255034 , 0.266918 , 0.279356 ,
 0.292373 , 0.305997 , 0.320256 , 0.33518  , 0.350799 , 0.367145 ,
 0.384254 , 0.402159 , 0.420899 , 0.440513 , 0.46104  , 0.482524 ,
 0.505008 , 0.528541 , 0.55317  , 0.578947 , 0.605925 , 0.63416  ,
 0.663711 , 0.694639 , 0.727008 , 0.760886 , 0.796342 , 0.83345  ,
 0.872288 , 0.912935 , 0.955476 , 1.       }
,
{0.008782  , 0.00921223, 0.00966355, 0.010137  , 0.0106336 , 0.0111546 ,
 0.011701  , 0.0122743 , 0.0128756 , 0.0135064 , 0.0141681 , 0.0148622 ,
 0.0155903 , 0.0163541 , 0.0171553 , 0.0179958 , 0.0188774 , 0.0198022 ,
 0.0207723 , 0.02179   , 0.0228575 , 0.0239773 , 0.025152  , 0.0263842 ,
 0.0276768 , 0.0290327 , 0.0304551 , 0.0319471 , 0.0335122 , 0.035154  ,
 0.0368763 , 0.0386829 , 0.040578  , 0.0425659 , 0.0446513 , 0.0468388 ,
 0.0491335 , 0.0515406 , 0.0540656 , 0.0567143 , 0.0594928 , 0.0624074 ,
 0.0654649 , 0.068672  , 0.0720364 , 0.0755655 , 0.0792675 , 0.0831509 ,
 0.0872246 , 0.0914978 , 0.0959804 , 0.100683  , 0.105615  , 0.110789  ,
 0.116217  , 0.121911  , 0.127883  , 0.134148  , 0.14072   , 0.147614  ,
 0.154846  , 0.162432  , 0.17039   , 0.178738  , 0.187494  , 0.19668   ,
 0.206315  , 0.216423  , 0.227026  , 0.238148  , 0.249815  , 0.262054  ,
 0.274892  , 0.288359  , 0.302486  , 0.317305  , 0.33285   , 0.349157  ,
 0.366263  , 0.384206  , 0.403029  , 0.422774  , 0.443486  , 0.465213  ,
 0.488004  , 0.511912  , 0.536991  , 0.563298  , 0.590895  , 0.619844  ,
 0.65021   , 0.682065  , 0.71548   , 0.750532  , 0.787301  , 0.825872  ,
 0.866333  , 0.908775  , 0.953297  , 1.        }
,
{0.00700241, 0.00736228, 0.00774065, 0.00813847, 0.00855673, 0.00899649,
 0.00945885, 0.00994497, 0.0104561 , 0.0109934 , 0.0115584 , 0.0121525 ,
 0.012777  , 0.0134337 , 0.0141241 , 0.0148499 , 0.0156131 , 0.0164155 ,
 0.0172592 , 0.0181462 , 0.0190788 , 0.0200593 , 0.0210902 , 0.0221741 ,
 0.0233137 , 0.0245119 , 0.0257716 , 0.0270961 , 0.0284887 , 0.0299528 ,
 0.0314922 , 0.0331107 , 0.0348123 , 0.0366014 , 0.0384825 , 0.0404602 ,
 0.0425396 , 0.0447259 , 0.0470245 , 0.0494412 , 0.0519822 , 0.0546537 ,
 0.0574625 , 0.0604157 , 0.0635207 , 0.0667852 , 0.0702175 , 0.0738262 ,
 0.0776204 , 0.0816096 , 0.0858037 , 0.0902135 , 0.0948498 , 0.0997245 ,
 0.10485   , 0.110238  , 0.115904  , 0.12186   , 0.128123  , 0.134708  ,
 0.141631  , 0.14891   , 0.156563  , 0.164609  , 0.173069  , 0.181963  ,
 0.191315  , 0.201147  , 0.211485  , 0.222354  , 0.233781  , 0.245796  ,
 0.258428  , 0.27171   , 0.285674  , 0.300356  , 0.315792  , 0.332021  ,
 0.349085  , 0.367026  , 0.385888  , 0.40572   , 0.426572  , 0.448495  ,
 0.471544  , 0.495778  , 0.521258  , 0.548047  , 0.576213  , 0.605826  ,
 0.636962  , 0.669697  , 0.704115  , 0.740302  , 0.778349  , 0.81835   ,
 0.860408  , 0.904627  , 0.951119  , 1.        }
,
{0.00558171, 0.00588203, 0.00619851, 0.00653202, 0.00688347, 0.00725383,
 0.00764411, 0.0080554 , 0.00848881, 0.00894554, 0.00942685, 0.00993406,
 0.0104686 , 0.0110318 , 0.0116254 , 0.0122509 , 0.01291   , 0.0136046 ,
 0.0143366 , 0.015108  , 0.0159208 , 0.0167774 , 0.0176801 , 0.0186314 ,
 0.0196339 , 0.0206902 , 0.0218035 , 0.0229766 , 0.0242128 , 0.0255156 ,
 0.0268884 , 0.0283351 , 0.0298597 , 0.0314662 , 0.0331593 , 0.0349434 ,
 0.0368235 , 0.0388047 , 0.0408926 , 0.0430928 , 0.0454114 , 0.0478547 ,
 0.0504295 , 0.0531428 , 0.0560021 , 0.0590152 , 0.0621905 , 0.0655366 ,
 0.0690627 , 0.0727786 , 0.0766944 , 0.0808209 , 0.0851694 , 0.0897519 ,
 0.0945809 , 0.0996697 , 0.105032  , 0.110684  , 0.116639  , 0.122914  ,
 0.129528  , 0.136497  , 0.143841  , 0.15158   , 0.159736  , 0.16833   ,
 0.177387  , 0.186931  , 0.196989  , 0.207588  , 0.218757  , 0.230527  ,
 0.24293   , 0.256001  , 0.269775  , 0.28429   , 0.299586  , 0.315705  ,
 0.332691  , 0.350592  , 0.369455  , 0.389333  , 0.410281  , 0.432356  ,
 0.455618  , 0.480132  , 0.505966  , 0.533189  , 0.561876  , 0.592108  ,
 0.623966  , 0.657538  , 0.692916  , 0.730198  , 0.769485  , 0.810887  ,
 0.854516  , 0.900493  , 0.948943  , 1.        }
,
{0.00444817, 0.00469826, 0.00496241, 0.00524141, 0.0055361 , 0.00584736,
 0.00617612, 0.00652336, 0.00689013, 0.00727751, 0.00768668, 0.00811885,
 0.00857532, 0.00905745, 0.00956669, 0.0101046 , 0.0106727 , 0.0112727 ,
 0.0119065 , 0.0125759 , 0.013283  , 0.0140298 , 0.0148186 , 0.0156518 ,
 0.0165318 , 0.0174612 , 0.018443  , 0.0194799 , 0.0205751 , 0.0217319 ,
 0.0229537 , 0.0242443 , 0.0256074 , 0.0270471 , 0.0285678 , 0.030174  ,
 0.0318704 , 0.0336623 , 0.0355549 , 0.0375539 , 0.0396653 , 0.0418954 ,
 0.0442509 , 0.0467389 , 0.0493667 , 0.0521422 , 0.0550739 , 0.0581703 ,
 0.0614408 , 0.0648952 , 0.0685438 , 0.0723976 , 0.076468  , 0.0807673 ,
 0.0853083 , 0.0901046 , 0.0951706 , 0.100521  , 0.106173  , 0.112142  ,
 0.118448  , 0.125107  , 0.132141  , 0.13957   , 0.147417  , 0.155706  ,
 0.16446   , 0.173707  , 0.183473  , 0.193788  , 0.204684  , 0.216192  ,
 0.228347  , 0.241185  , 0.254745  , 0.269068  , 0.284196  , 0.300174  ,
 0.317051  , 0.334877  , 0.353705  , 0.373591  , 0.394596  , 0.416781  ,
 0.440214  , 0.464964  , 0.491106  , 0.518718  , 0.547882  , 0.578685  ,
 0.611221  , 0.645586  , 0.681883  , 0.720221  , 0.760714  , 0.803484  ,
 0.848658  , 0.896372  , 0.946769  , 1.        }
,
{0.00354413, 0.003752  , 0.00397205, 0.00420501, 0.00445164, 0.00471273,
 0.00498913, 0.00528174, 0.00559151, 0.00591946, 0.00626663, 0.00663417,
 0.00702327, 0.00743518, 0.00787125, 0.0083329 , 0.00882163, 0.00933902,
 0.00988675, 0.0104666 , 0.0110805 , 0.0117303 , 0.0124183 , 0.0131467 ,
 0.0139177 , 0.014734  , 0.0155981 , 0.016513  , 0.0174815 , 0.0185068 ,
 0.0195922 , 0.0207413 , 0.0219577 , 0.0232456 , 0.0246089 , 0.0260522 ,
 0.0275802 , 0.0291978 , 0.0309102 , 0.0327231 , 0.0346423 , 0.0366741 ,
 0.038825  , 0.0411021 , 0.0435128 , 0.0460648 , 0.0487665 , 0.0516267 ,
 0.0546546 , 0.0578601 , 0.0612535 , 0.0648461 , 0.0686493 , 0.0726756 ,
 0.076938  , 0.0814504 , 0.0862275 , 0.0912847 , 0.0966386 , 0.102306  ,
 0.108307  , 0.114659  , 0.121384  , 0.128503  , 0.13604   , 0.144018  ,
 0.152465  , 0.161407  , 0.170874  , 0.180895  , 0.191505  , 0.202737  ,
 0.214627  , 0.227215  , 0.240541  , 0.254649  , 0.269584  , 0.285395  ,
 0.302134  , 0.319854  , 0.338613  , 0.358473  , 0.379497  , 0.401755  ,
 0.425318  , 0.450263  , 0.476671  , 0.504627  , 0.534224  , 0.565556  ,
 0.598726  , 0.633841  , 0.671016  , 0.710371  , 0.752035  , 0.796142  ,
 0.842835  , 0.892268  , 0.944599  , 1.        }
,
{0.00282339, 0.00299586, 0.00317886, 0.00337303, 0.00357907, 0.0037977 ,
 0.00402968, 0.00427583, 0.00453701, 0.00481415, 0.00510822, 0.00542025,
 0.00575134, 0.00610265, 0.00647543, 0.00687097, 0.00729068, 0.00773602,
 0.00820857, 0.00870998, 0.00924202, 0.00980656, 0.0104056 , 0.0110412 ,
 0.0117156 , 0.0124313 , 0.0131906 , 0.0139964 , 0.0148513 , 0.0157585 ,
 0.0167211 , 0.0177425 , 0.0188263 , 0.0199763 , 0.0211965 , 0.0224913 ,
 0.0238651 , 0.0253229 , 0.0268697 , 0.028511  , 0.0302526 , 0.0321006 ,
 0.0340614 , 0.036142  , 0.0383497 , 0.0406922 , 0.0431779 , 0.0458154 ,
 0.048614  , 0.0515835 , 0.0547344 , 0.0580778 , 0.0616255 , 0.0653898 ,
 0.0693841 , 0.0736223 , 0.0781195 , 0.0828913 , 0.0879547 , 0.0933273 ,
 0.0990281 , 0.105077  , 0.111496  , 0.118306  , 0.125533  , 0.133201  ,
 0.141337  , 0.149971  , 0.159132  , 0.168852  , 0.179166  , 0.19011   ,
 0.201723  , 0.214045  , 0.22712   , 0.240993  , 0.255714  , 0.271334  ,
 0.287909  , 0.305495  , 0.324156  , 0.343957  , 0.364967  , 0.387261  ,
 0.410916  , 0.436017  , 0.46265   , 0.490911  , 0.520898  , 0.552716  ,
 0.586478  , 0.622303  , 0.660316  , 0.70065   , 0.743449  , 0.788862  ,
 0.837049  , 0.888179  , 0.942432  , 1.        }
,
{0.00224895, 0.00239181, 0.00254375, 0.00270534, 0.0028772 , 0.00305997,
 0.00325436, 0.00346109, 0.00368096, 0.00391479, 0.00416348, 0.00442796,
 0.00470925, 0.0050084 , 0.00532656, 0.00566493, 0.00602479, 0.00640752,
 0.00681456, 0.00724745, 0.00770784, 0.00819748, 0.00871823, 0.00927205,
 0.00986106, 0.0104875 , 0.0111537 , 0.0118622 , 0.0126158 , 0.0134172 ,
 0.0142695 , 0.015176  , 0.0161401 , 0.0171654 , 0.0182558 , 0.0194155 ,
 0.0206488 , 0.0219606 , 0.0233556 , 0.0248393 , 0.0264172 , 0.0280953 ,
 0.0298801 , 0.0317782 , 0.0337969 , 0.0359439 , 0.0382272 , 0.0406556 ,
 0.0432382 , 0.045985  , 0.0489061 , 0.0520129 , 0.055317  , 0.058831  ,
 0.0625683 , 0.0665429 , 0.0707701 , 0.0752657 , 0.080047  , 0.085132  ,
 0.09054   , 0.0962915 , 0.102408  , 0.108914  , 0.115833  , 0.123191  ,
 0.131017  , 0.139339  , 0.148191  , 0.157605  , 0.167617  , 0.178264  ,
 0.189589  , 0.201632  , 0.214441  , 0.228063  , 0.242551  , 0.257959  ,
 0.274346  , 0.291774  , 0.310309  , 0.330021  , 0.350986  , 0.373282  ,
 0.396995  , 0.422214  , 0.449035  , 0.47756   , 0.507897  , 0.540161  ,
 0.574475  , 0.610968  , 0.64978   , 0.691057  , 0.734956  , 0.781644  ,
 0.831298  , 0.884107  , 0.940269  , 1.        }
,
{0.0017912 , 0.00190937, 0.00203534, 0.00216961, 0.00231275, 0.00246533,
 0.00262797, 0.00280134, 0.00298616, 0.00318316, 0.00339316, 0.00361702,
 0.00385564, 0.00411001, 0.00438115, 0.00467019, 0.00497829, 0.00530673,
 0.00565682, 0.00603002, 0.00642783, 0.00685189, 0.00730393, 0.00778579,
 0.00829944, 0.00884697, 0.00943063, 0.0100528 , 0.010716  , 0.011423  ,
 0.0121766 , 0.0129799 , 0.0138362 , 0.014749  , 0.015722  , 0.0167593 ,
 0.0178649 , 0.0190435 , 0.0202999 , 0.0216391 , 0.0230667 , 0.0245884 ,
 0.0262106 , 0.0279398 , 0.029783  , 0.0317479 , 0.0338424 , 0.0360751 ,
 0.038455  , 0.040992  , 0.0436964 , 0.0465791 , 0.0496521 , 0.0529277 ,
 0.0564195 , 0.0601416 , 0.0641093 , 0.0683388 , 0.0728473 , 0.0776532 ,
 0.0827762 , 0.0882371 , 0.0940584 , 0.100264  , 0.106878  , 0.113929  ,
 0.121446  , 0.129458  , 0.137998  , 0.147102  , 0.156807  , 0.167152  ,
 0.178179  , 0.189934  , 0.202465  , 0.215822  , 0.23006   , 0.245238  ,
 0.261417  , 0.278663  , 0.297047  , 0.316644  , 0.337534  , 0.359802  ,
 0.383539  , 0.408842  , 0.435815  , 0.464566  , 0.495215  , 0.527886  ,
 0.562712  , 0.599835  , 0.639408  , 0.681591  , 0.726557  , 0.77449   ,
 0.825585  , 0.880051  , 0.93811   , 1.        }
,
{0.00142651, 0.00152412, 0.00162841, 0.00173984, 0.00185889, 0.00198609,
 0.00212199, 0.00226719, 0.00242233, 0.00258808, 0.00276517, 0.00295439,
 0.00315654, 0.00337254, 0.00360331, 0.00384987, 0.0041133 , 0.00439476,
 0.00469548, 0.00501678, 0.00536006, 0.00572683, 0.00611869, 0.00653738,
 0.00698471, 0.00746265, 0.00797329, 0.00851887, 0.00910179, 0.0097246 ,
 0.01039   , 0.011101  , 0.0118606 , 0.0126722 , 0.0135393 , 0.0144657 ,
 0.0154555 , 0.0165131 , 0.0176431 , 0.0188503 , 0.0201402 , 0.0215183 ,
 0.0229907 , 0.0245639 , 0.0262447 , 0.0280406 , 0.0299593 , 0.0320093 ,
 0.0341996 , 0.0365397 , 0.03904   , 0.0417114 , 0.0445656 , 0.047615  ,
 0.0508732 , 0.0543543 , 0.0580735 , 0.0620473 , 0.066293  , 0.0708292 ,
 0.0756758 , 0.080854  , 0.0863866 , 0.0922977 , 0.0986134 , 0.105361  ,
 0.112571  , 0.120273  , 0.128503  , 0.137296  , 0.146691  , 0.156729  ,
 0.167453  , 0.178911  , 0.191154  , 0.204234  , 0.218209  , 0.23314   ,
 0.249093  , 0.266138  , 0.284348  , 0.303805  , 0.324594  , 0.346805  ,
 0.370535  , 0.39589   , 0.422979  , 0.451922  , 0.482846  , 0.515885  ,
 0.551185  , 0.588901  , 0.629198  , 0.672252  , 0.718251  , 0.767399  ,
 0.81991   , 0.876013  , 0.935956  , 1.        }
,
{0.001136  , 0.00121653, 0.00130277, 0.00139512, 0.00149401, 0.00159992,
 0.00171333, 0.00183479, 0.00196485, 0.00210413, 0.00225329, 0.00241301,
 0.00258406, 0.00276724, 0.0029634 , 0.00317347, 0.00339843, 0.00363933,
 0.00389731, 0.00417358, 0.00446943, 0.00478626, 0.00512554, 0.00548888,
 0.00587797, 0.00629464, 0.00674085, 0.00721868, 0.00773039, 0.00827838,
 0.00886521, 0.00949364, 0.0101666 , 0.0108873 , 0.0116591 , 0.0124855 ,
 0.0133706 , 0.0143184 , 0.0153334 , 0.0164203 , 0.0175843 , 0.0188308 ,
 0.0201657 , 0.0215952 , 0.023126  , 0.0247653 , 0.0265208 , 0.0284008 ,
 0.0304141 , 0.03257   , 0.0348788 , 0.0373513 , 0.039999  , 0.0428344 ,
 0.0458708 , 0.0491224 , 0.0526046 , 0.0563336 , 0.0603269 , 0.0646033 ,
 0.0691828 , 0.074087  , 0.0793388 , 0.0849628 , 0.0909856 , 0.0974353 ,
 0.104342  , 0.111739  , 0.11966   , 0.128142  , 0.137225  , 0.146953  ,
 0.15737   , 0.168525  , 0.180472  , 0.193265  , 0.206965  , 0.221636  ,
 0.237347  , 0.254172  , 0.272189  , 0.291484  , 0.312146  , 0.334273  ,
 0.357969  , 0.383344  , 0.410518  , 0.439619  , 0.470782  , 0.504154  ,
 0.539892  , 0.578164  , 0.619148  , 0.663038  , 0.710038  , 0.760371  ,
 0.814271  , 0.871992  , 0.933805  , 1.        }
,
{9.04612e-04, 9.70969e-04, 1.04219e-03, 1.11864e-03, 1.20070e-03,
 1.28877e-03, 1.38331e-03, 1.48478e-03, 1.59369e-03, 1.71060e-03,
 1.83608e-03, 1.97076e-03, 2.11532e-03, 2.27049e-03, 2.43704e-03,
 2.61580e-03, 2.80768e-03, 3.01363e-03, 3.23469e-03, 3.47197e-03,
 3.72665e-03, 4.00001e-03, 4.29343e-03, 4.60837e-03, 4.94641e-03,
 5.30924e-03, 5.69870e-03, 6.11671e-03, 6.56540e-03, 7.04699e-03,
 7.56392e-03, 8.11876e-03, 8.71429e-03, 9.35352e-03, 1.00396e-02,
 1.07761e-02, 1.15665e-02, 1.24150e-02, 1.33257e-02, 1.43032e-02,
 1.53523e-02, 1.64785e-02, 1.76872e-02, 1.89847e-02, 2.03773e-02,
 2.18720e-02, 2.34764e-02, 2.51985e-02, 2.70469e-02, 2.90309e-02,
 3.11604e-02, 3.34461e-02, 3.58995e-02, 3.85328e-02, 4.13594e-02,
 4.43932e-02, 4.76496e-02, 5.11449e-02, 5.48966e-02, 5.89234e-02,
 6.32457e-02, 6.78850e-02, 7.28646e-02, 7.82094e-02, 8.39464e-02,
 9.01041e-02, 9.67136e-02, 1.03808e-01, 1.11423e-01, 1.19596e-01,
 1.28369e-01, 1.37785e-01, 1.47892e-01, 1.58740e-01, 1.70384e-01,
 1.82883e-01, 1.96298e-01, 2.10697e-01, 2.26152e-01, 2.42741e-01,
 2.60547e-01, 2.79659e-01, 3.00174e-01, 3.22192e-01, 3.45826e-01,
 3.71194e-01, 3.98422e-01, 4.27648e-01, 4.59017e-01, 4.92688e-01,
 5.28828e-01, 5.67620e-01, 6.09257e-01, 6.53948e-01, 7.01917e-01,
 7.53406e-01, 8.08670e-01, 8.67989e-01, 9.31659e-01, 1.00000e+00}
,
{7.20325e-04, 7.74944e-04, 8.33705e-04, 8.96922e-04, 9.64932e-04,
 1.03810e-03, 1.11681e-03, 1.20150e-03, 1.29260e-03, 1.39062e-03,
 1.49606e-03, 1.60950e-03, 1.73155e-03, 1.86284e-03, 2.00409e-03,
 2.15606e-03, 2.31954e-03, 2.49543e-03, 2.68464e-03, 2.88821e-03,
 3.10721e-03, 3.34282e-03, 3.59630e-03, 3.86899e-03, 4.16236e-03,
 4.47798e-03, 4.81752e-03, 5.18282e-03, 5.57581e-03, 5.99861e-03,
 6.45346e-03, 6.94280e-03, 7.46925e-03, 8.03561e-03, 8.64492e-03,
 9.30043e-03, 1.00057e-02, 1.07643e-02, 1.15806e-02, 1.24587e-02,
 1.34034e-02, 1.44197e-02, 1.55131e-02, 1.66894e-02, 1.79549e-02,
 1.93163e-02, 2.07810e-02, 2.23568e-02, 2.40520e-02, 2.58758e-02,
 2.78378e-02, 2.99487e-02, 3.22196e-02, 3.46626e-02, 3.72910e-02,
 4.01186e-02, 4.31607e-02, 4.64334e-02, 4.99542e-02, 5.37421e-02,
 5.78171e-02, 6.22012e-02, 6.69177e-02, 7.19918e-02, 7.74507e-02,
 8.33235e-02, 8.96416e-02, 9.64388e-02, 1.03751e-01, 1.11618e-01,
 1.20082e-01, 1.29187e-01, 1.38983e-01, 1.49522e-01, 1.60859e-01,
 1.73057e-01, 1.86179e-01, 2.00296e-01, 2.15484e-01, 2.31823e-01,
 2.49402e-01, 2.68313e-01, 2.88658e-01, 3.10546e-01, 3.34093e-01,
 3.59426e-01, 3.86680e-01, 4.16001e-01, 4.47545e-01, 4.81480e-01,
 5.17989e-01, 5.57266e-01, 5.99522e-01, 6.44981e-01, 6.93888e-01,
 7.46503e-01, 8.03107e-01, 8.64004e-01, 9.29518e-01, 1.00000e+00}
,
{5.73562e-04, 6.18475e-04, 6.66905e-04, 7.19127e-04, 7.75438e-04,
 8.36159e-04, 9.01634e-04, 9.72236e-04, 1.04837e-03, 1.13046e-03,
 1.21898e-03, 1.31443e-03, 1.41736e-03, 1.52835e-03, 1.64802e-03,
 1.77707e-03, 1.91622e-03, 2.06627e-03, 2.22807e-03, 2.40254e-03,
 2.59067e-03, 2.79354e-03, 3.01229e-03, 3.24816e-03, 3.50251e-03,
 3.77677e-03, 4.07251e-03, 4.39141e-03, 4.73528e-03, 5.10608e-03,
 5.50591e-03, 5.93705e-03, 6.40195e-03, 6.90325e-03, 7.44381e-03,
 8.02670e-03, 8.65523e-03, 9.33298e-03, 1.00638e-02, 1.08518e-02,
 1.17016e-02, 1.26179e-02, 1.36059e-02, 1.46713e-02, 1.58202e-02,
 1.70590e-02, 1.83948e-02, 1.98352e-02, 2.13884e-02, 2.30632e-02,
 2.48692e-02, 2.68165e-02, 2.89164e-02, 3.11807e-02, 3.36223e-02,
 3.62551e-02, 3.90941e-02, 4.21553e-02, 4.54563e-02, 4.90157e-02,
 5.28539e-02, 5.69926e-02, 6.14555e-02, 6.62677e-02, 7.14568e-02,
 7.70522e-02, 8.30858e-02, 8.95918e-02, 9.66073e-02, 1.04172e-01,
 1.12329e-01, 1.21125e-01, 1.30610e-01, 1.40837e-01, 1.51866e-01,
 1.63758e-01, 1.76581e-01, 1.90408e-01, 2.05318e-01, 2.21395e-01,
 2.38731e-01, 2.57425e-01, 2.77583e-01, 2.99319e-01, 3.22757e-01,
 3.48031e-01, 3.75283e-01, 4.04670e-01, 4.36357e-01, 4.70526e-01,
 5.07371e-01, 5.47101e-01, 5.89941e-01, 6.36137e-01, 6.85949e-01,
 7.39662e-01, 7.97582e-01, 8.60036e-01, 9.27381e-01, 1.00000e+00}
,
{4.56691e-04, 4.93587e-04, 5.33463e-04, 5.76562e-04, 6.23142e-04,
 6.73485e-04, 7.27896e-04, 7.86702e-04, 8.50260e-04, 9.18952e-04,
 9.93194e-04, 1.07343e-03, 1.16016e-03, 1.25388e-03, 1.35519e-03,
 1.46467e-03, 1.58300e-03, 1.71089e-03, 1.84911e-03, 1.99850e-03,
 2.15996e-03, 2.33446e-03, 2.52306e-03, 2.72690e-03, 2.94721e-03,
 3.18531e-03, 3.44265e-03, 3.72078e-03, 4.02138e-03, 4.34627e-03,
 4.69740e-03, 5.07691e-03, 5.48707e-03, 5.93037e-03, 6.40948e-03,
 6.92730e-03, 7.48695e-03, 8.09182e-03, 8.74556e-03, 9.45211e-03,
 1.02157e-02, 1.10411e-02, 1.19331e-02, 1.28971e-02, 1.39391e-02,
 1.50652e-02, 1.62823e-02, 1.75978e-02, 1.90195e-02, 2.05561e-02,
 2.22168e-02, 2.40117e-02, 2.59516e-02, 2.80482e-02, 3.03142e-02,
 3.27633e-02, 3.54102e-02, 3.82710e-02, 4.13629e-02, 4.47046e-02,
 4.83163e-02, 5.22197e-02, 5.64386e-02, 6.09982e-02, 6.59262e-02,
 7.12524e-02, 7.70089e-02, 8.32304e-02, 8.99545e-02, 9.72219e-02,
 1.05076e-01, 1.13566e-01, 1.22740e-01, 1.32657e-01, 1.43374e-01,
 1.54957e-01, 1.67476e-01, 1.81006e-01, 1.95630e-01, 2.11435e-01,
 2.28516e-01, 2.46978e-01, 2.66931e-01, 2.88497e-01, 3.11804e-01,
 3.36995e-01, 3.64221e-01, 3.93646e-01, 4.25448e-01, 4.59820e-01,
 4.96969e-01, 5.37119e-01, 5.80513e-01, 6.27412e-01, 6.78100e-01,
 7.32884e-01, 7.92093e-01, 8.56086e-01, 9.25249e-01, 1.00000e+00}
,
{3.63626e-04, 3.93909e-04, 4.26714e-04, 4.62251e-04, 5.00747e-04,
 5.42450e-04, 5.87625e-04, 6.36563e-04, 6.89576e-04, 7.47004e-04,
 8.09215e-04, 8.76606e-04, 9.49610e-04, 1.02869e-03, 1.11436e-03,
 1.20717e-03, 1.30770e-03, 1.41661e-03, 1.53458e-03, 1.66238e-03,
 1.80083e-03, 1.95080e-03, 2.11327e-03, 2.28926e-03, 2.47991e-03,
 2.68644e-03, 2.91016e-03, 3.15252e-03, 3.41507e-03, 3.69947e-03,
 4.00757e-03, 4.34132e-03, 4.70287e-03, 5.09452e-03, 5.51880e-03,
 5.97840e-03, 6.47629e-03, 7.01563e-03, 7.59990e-03, 8.23282e-03,
 8.91845e-03, 9.66118e-03, 1.04658e-02, 1.13374e-02, 1.22815e-02,
 1.33044e-02, 1.44123e-02, 1.56126e-02, 1.69128e-02, 1.83213e-02,
 1.98471e-02, 2.15000e-02, 2.32905e-02, 2.52302e-02, 2.73314e-02,
 2.96075e-02, 3.20733e-02, 3.47443e-02, 3.76379e-02, 4.07723e-02,
 4.41679e-02, 4.78462e-02, 5.18308e-02, 5.61473e-02, 6.08233e-02,
 6.58887e-02, 7.13759e-02, 7.73201e-02, 8.37594e-02, 9.07349e-02,
 9.82913e-02, 1.06477e-01, 1.15344e-01, 1.24950e-01, 1.35356e-01,
 1.46629e-01, 1.58840e-01, 1.72068e-01, 1.86398e-01, 2.01922e-01,
 2.18738e-01, 2.36954e-01, 2.56688e-01, 2.78065e-01, 3.01222e-01,
 3.26308e-01, 3.53483e-01, 3.82921e-01, 4.14811e-01, 4.49357e-01,
 4.86780e-01, 5.27319e-01, 5.71234e-01, 6.18806e-01, 6.70341e-01,
 7.26167e-01, 7.86643e-01, 8.52154e-01, 9.23122e-01, 1.00000e+00}
,
{2.89522e-04, 3.14356e-04, 3.41321e-04, 3.70598e-04, 4.02387e-04,
 4.36902e-04, 4.74378e-04, 5.15069e-04, 5.59250e-04, 6.07221e-04,
 6.59306e-04, 7.15860e-04, 7.77264e-04, 8.43935e-04, 9.16325e-04,
 9.94925e-04, 1.08027e-03, 1.17293e-03, 1.27354e-03, 1.38278e-03,
 1.50139e-03, 1.63017e-03, 1.77000e-03, 1.92183e-03, 2.08668e-03,
 2.26567e-03, 2.46001e-03, 2.67102e-03, 2.90013e-03, 3.14890e-03,
 3.41900e-03, 3.71227e-03, 4.03070e-03, 4.37644e-03, 4.75184e-03,
 5.15943e-03, 5.60199e-03, 6.08252e-03, 6.60426e-03, 7.17075e-03,
 7.78583e-03, 8.45368e-03, 9.17881e-03, 9.96614e-03, 1.08210e-02,
 1.17492e-02, 1.27570e-02, 1.38513e-02, 1.50394e-02, 1.63294e-02,
 1.77301e-02, 1.92509e-02, 2.09022e-02, 2.26951e-02, 2.46419e-02,
 2.67556e-02, 2.90506e-02, 3.15424e-02, 3.42480e-02, 3.71857e-02,
 4.03754e-02, 4.38387e-02, 4.75990e-02, 5.16819e-02, 5.61150e-02,
 6.09284e-02, 6.61547e-02, 7.18292e-02, 7.79905e-02, 8.46803e-02,
 9.19439e-02, 9.98305e-02, 1.08394e-01, 1.17691e-01, 1.27787e-01,
 1.38748e-01, 1.50649e-01, 1.63571e-01, 1.77602e-01, 1.92836e-01,
 2.09377e-01, 2.27337e-01, 2.46837e-01, 2.68010e-01, 2.90999e-01,
 3.15960e-01, 3.43062e-01, 3.72489e-01, 4.04439e-01, 4.39131e-01,
 4.76798e-01, 5.17697e-01, 5.62103e-01, 6.10318e-01, 6.62670e-01,
 7.19511e-01, 7.81229e-01, 8.48240e-01, 9.21000e-01, 1.00000e+00}
,
{2.30517e-04, 2.50866e-04, 2.73013e-04, 2.97114e-04, 3.23343e-04,
 3.51888e-04, 3.82952e-04, 4.16759e-04, 4.53550e-04, 4.93589e-04,
 5.37163e-04, 5.84583e-04, 6.36190e-04, 6.92352e-04, 7.53473e-04,
 8.19989e-04, 8.92377e-04, 9.71155e-04, 1.05689e-03, 1.15019e-03,
 1.25173e-03, 1.36223e-03, 1.48249e-03, 1.61336e-03, 1.75579e-03,
 1.91078e-03, 2.07947e-03, 2.26304e-03, 2.46282e-03, 2.68024e-03,
 2.91685e-03, 3.17434e-03, 3.45457e-03, 3.75954e-03, 4.09143e-03,
 4.45262e-03, 4.84569e-03, 5.27347e-03, 5.73901e-03, 6.24564e-03,
 6.79700e-03, 7.39704e-03, 8.05004e-03, 8.76070e-03, 9.53408e-03,
 1.03757e-02, 1.12917e-02, 1.22885e-02, 1.33734e-02, 1.45540e-02,
 1.58388e-02, 1.72370e-02, 1.87587e-02, 2.04147e-02, 2.22169e-02,
 2.41782e-02, 2.63126e-02, 2.86354e-02, 3.11634e-02, 3.39144e-02,
 3.69084e-02, 4.01666e-02, 4.37125e-02, 4.75714e-02, 5.17710e-02,
 5.63413e-02, 6.13151e-02, 6.67279e-02, 7.26186e-02, 7.90294e-02,
 8.60060e-02, 9.35986e-02, 1.01861e-01, 1.10854e-01, 1.20640e-01,
 1.31290e-01, 1.42880e-01, 1.55493e-01, 1.69220e-01, 1.84159e-01,
 2.00416e-01, 2.18109e-01, 2.37363e-01, 2.58318e-01, 2.81122e-01,
 3.05939e-01, 3.32947e-01, 3.62339e-01, 3.94326e-01, 4.29137e-01,
 4.67021e-01, 5.08249e-01, 5.53117e-01, 6.01946e-01, 6.55086e-01,
 7.12916e-01, 7.75852e-01, 8.44344e-01, 9.18882e-01, 1.00000e+00}
,
{1.83535e-04, 2.00198e-04, 2.18373e-04, 2.38199e-04, 2.59824e-04,
 2.83413e-04, 3.09143e-04, 3.37210e-04, 3.67824e-04, 4.01218e-04,
 4.37644e-04, 4.77377e-04, 5.20716e-04, 5.67991e-04, 6.19558e-04,
 6.75806e-04, 7.37161e-04, 8.04086e-04, 8.77087e-04, 9.56715e-04,
 1.04357e-03, 1.13832e-03, 1.24166e-03, 1.35439e-03, 1.47735e-03,
 1.61148e-03, 1.75778e-03, 1.91736e-03, 2.09144e-03, 2.28131e-03,
 2.48843e-03, 2.71435e-03, 2.96078e-03, 3.22958e-03, 3.52278e-03,
 3.84261e-03, 4.19147e-03, 4.57200e-03, 4.98709e-03, 5.43985e-03,
 5.93372e-03, 6.47243e-03, 7.06005e-03, 7.70101e-03, 8.40017e-03,
 9.16280e-03, 9.99467e-03, 1.09021e-02, 1.18918e-02, 1.29715e-02,
 1.41491e-02, 1.54337e-02, 1.68349e-02, 1.83633e-02, 2.00304e-02,
 2.18489e-02, 2.38326e-02, 2.59963e-02, 2.83564e-02, 3.09308e-02,
 3.37390e-02, 3.68020e-02, 4.01432e-02, 4.37877e-02, 4.77631e-02,
 5.20994e-02, 5.68294e-02, 6.19888e-02, 6.76166e-02, 7.37554e-02,
 8.04514e-02, 8.77554e-02, 9.57225e-02, 1.04413e-01, 1.13892e-01,
 1.24232e-01, 1.35511e-01, 1.47814e-01, 1.61234e-01, 1.75872e-01,
 1.91839e-01, 2.09255e-01, 2.28253e-01, 2.48975e-01, 2.71579e-01,
 2.96235e-01, 3.23130e-01, 3.52466e-01, 3.84466e-01, 4.19370e-01,
 4.57444e-01, 4.98974e-01, 5.44275e-01, 5.93689e-01, 6.47588e-01,
 7.06381e-01, 7.70512e-01, 8.40465e-01, 9.16769e-01, 1.00000e+00}
,
{1.46127e-04, 1.59761e-04, 1.74667e-04, 1.90964e-04, 2.08782e-04,
 2.28261e-04, 2.49558e-04, 2.72843e-04, 2.98299e-04, 3.26131e-04,
 3.56560e-04, 3.89828e-04, 4.26199e-04, 4.65965e-04, 5.09440e-04,
 5.56972e-04, 6.08938e-04, 6.65753e-04, 7.27869e-04, 7.95781e-04,
 8.70029e-04, 9.51204e-04, 1.03995e-03, 1.13698e-03, 1.24306e-03,
 1.35905e-03, 1.48585e-03, 1.62448e-03, 1.77605e-03, 1.94175e-03,
 2.12292e-03, 2.32100e-03, 2.53755e-03, 2.77431e-03, 3.03316e-03,
 3.31615e-03, 3.62556e-03, 3.96383e-03, 4.33366e-03, 4.73800e-03,
 5.18006e-03, 5.66337e-03, 6.19178e-03, 6.76948e-03, 7.40109e-03,
 8.09162e-03, 8.84658e-03, 9.67199e-03, 1.05744e-02, 1.15610e-02,
 1.26397e-02, 1.38190e-02, 1.51083e-02, 1.65180e-02, 1.80591e-02,
 1.97441e-02, 2.15862e-02, 2.36002e-02, 2.58022e-02, 2.82096e-02,
 3.08416e-02, 3.37192e-02, 3.68652e-02, 4.03048e-02, 4.40653e-02,
 4.81767e-02, 5.26717e-02, 5.75861e-02, 6.29589e-02, 6.88331e-02,
 7.52554e-02, 8.22769e-02, 8.99534e-02, 9.83463e-02, 1.07522e-01,
 1.17554e-01, 1.28522e-01, 1.40514e-01, 1.53624e-01, 1.67957e-01,
 1.83628e-01, 2.00761e-01, 2.19492e-01, 2.39971e-01, 2.62361e-01,
 2.86839e-01, 3.13602e-01, 3.42862e-01, 3.74851e-01, 4.09826e-01,
 4.48063e-01, 4.89868e-01, 5.35574e-01, 5.85544e-01, 6.40176e-01,
 6.99906e-01, 7.65208e-01, 8.36604e-01, 9.14660e-01, 1.00000e+00}
,
{1.16344e-04, 1.27492e-04, 1.39708e-04, 1.53095e-04, 1.67765e-04,
 1.83841e-04, 2.01457e-04, 2.20761e-04, 2.41915e-04, 2.65095e-04,
 2.90497e-04, 3.18333e-04, 3.48837e-04, 3.82263e-04, 4.18892e-04,
 4.59031e-04, 5.03016e-04, 5.51216e-04, 6.04035e-04, 6.61914e-04,
 7.25340e-04, 7.94844e-04, 8.71007e-04, 9.54469e-04, 1.04593e-03,
 1.14615e-03, 1.25598e-03, 1.37633e-03, 1.50821e-03, 1.65273e-03,
 1.81110e-03, 1.98464e-03, 2.17481e-03, 2.38321e-03, 2.61157e-03,
 2.86181e-03, 3.13604e-03, 3.43654e-03, 3.76584e-03, 4.12669e-03,
 4.52211e-03, 4.95543e-03, 5.43027e-03, 5.95061e-03, 6.52081e-03,
 7.14564e-03, 7.83035e-03, 8.58067e-03, 9.40289e-03, 1.03039e-02,
 1.12912e-02, 1.23732e-02, 1.35588e-02, 1.48580e-02, 1.62817e-02,
 1.78419e-02, 1.95515e-02, 2.14250e-02, 2.34780e-02, 2.57277e-02,
 2.81930e-02, 3.08945e-02, 3.38548e-02, 3.70989e-02, 4.06538e-02,
 4.45493e-02, 4.88181e-02, 5.34959e-02, 5.86220e-02, 6.42393e-02,
 7.03948e-02, 7.71402e-02, 8.45319e-02, 9.26319e-02, 1.01508e-01,
 1.11235e-01, 1.21893e-01, 1.33574e-01, 1.46373e-01, 1.60399e-01,
 1.75768e-01, 1.92611e-01, 2.11067e-01, 2.31292e-01, 2.53455e-01,
 2.77741e-01, 3.04355e-01, 3.33519e-01, 3.65477e-01, 4.00498e-01,
 4.38874e-01, 4.80928e-01, 5.27012e-01, 5.77511e-01, 6.32849e-01,
 6.93490e-01, 7.59941e-01, 8.32760e-01, 9.12557e-01, 1.00000e+00}
,
{9.26298e-05, 1.01740e-04, 1.11746e-04, 1.22736e-04, 1.34806e-04,
 1.48064e-04, 1.62626e-04, 1.78620e-04, 1.96187e-04, 2.15481e-04,
 2.36673e-04, 2.59950e-04, 2.85515e-04, 3.13595e-04, 3.44436e-04,
 3.78311e-04, 4.15517e-04, 4.56382e-04, 5.01266e-04, 5.50565e-04,
 6.04712e-04, 6.64184e-04, 7.29505e-04, 8.01250e-04, 8.80051e-04,
 9.66602e-04, 1.06167e-03, 1.16608e-03, 1.28076e-03, 1.40672e-03,
 1.54507e-03, 1.69702e-03, 1.86392e-03, 2.04723e-03, 2.24857e-03,
 2.46971e-03, 2.71261e-03, 2.97938e-03, 3.27240e-03, 3.59423e-03,
 3.94772e-03, 4.33597e-03, 4.76240e-03, 5.23077e-03, 5.74521e-03,
 6.31024e-03, 6.93084e-03, 7.61247e-03, 8.36114e-03, 9.18344e-03,
 1.00866e-02, 1.10786e-02, 1.21682e-02, 1.33649e-02, 1.46793e-02,
 1.61230e-02, 1.77086e-02, 1.94502e-02, 2.13631e-02, 2.34641e-02,
 2.57718e-02, 2.83064e-02, 3.10902e-02, 3.41479e-02, 3.75063e-02,
 4.11949e-02, 4.52463e-02, 4.96962e-02, 5.45837e-02, 5.99519e-02,
 6.58481e-02, 7.23241e-02, 7.94370e-02, 8.72495e-02, 9.58303e-02,
 1.05255e-01, 1.15607e-01, 1.26976e-01, 1.39464e-01, 1.53180e-01,
 1.68245e-01, 1.84791e-01, 2.02965e-01, 2.22927e-01, 2.44851e-01,
 2.68931e-01, 2.95380e-01, 3.24430e-01, 3.56337e-01, 3.91382e-01,
 4.29874e-01, 4.72151e-01, 5.18586e-01, 5.69588e-01, 6.25605e-01,
 6.87132e-01, 7.54710e-01, 8.28934e-01, 9.10458e-01, 1.00000e+00}
,
{7.37492e-05, 8.11890e-05, 8.93793e-05, 9.83958e-05, 1.08322e-04,
 1.19249e-04, 1.31279e-04, 1.44523e-04, 1.59102e-04, 1.75152e-04,
 1.92821e-04, 2.12273e-04, 2.33687e-04, 2.57262e-04, 2.83214e-04,
 3.11785e-04, 3.43237e-04, 3.77863e-04, 4.15982e-04, 4.57946e-04,
 5.04143e-04, 5.55001e-04, 6.10989e-04, 6.72625e-04, 7.40479e-04,
 8.15179e-04, 8.97414e-04, 9.87944e-04, 1.08761e-03, 1.19733e-03,
 1.31811e-03, 1.45108e-03, 1.59747e-03, 1.75862e-03, 1.93603e-03,
 2.13133e-03, 2.34634e-03, 2.58304e-03, 2.84361e-03, 3.13048e-03,
 3.44628e-03, 3.79394e-03, 4.17667e-03, 4.59801e-03, 5.06185e-03,
 5.57249e-03, 6.13464e-03, 6.75350e-03, 7.43479e-03, 8.18481e-03,
 9.01049e-03, 9.91947e-03, 1.09201e-02, 1.20218e-02, 1.32345e-02,
 1.45696e-02, 1.60394e-02, 1.76574e-02, 1.94387e-02, 2.13997e-02,
 2.35585e-02, 2.59350e-02, 2.85513e-02, 3.14316e-02, 3.46024e-02,
 3.80931e-02, 4.19359e-02, 4.61664e-02, 5.08236e-02, 5.59507e-02,
 6.15949e-02, 6.78086e-02, 7.46491e-02, 8.21797e-02, 9.04699e-02,
 9.95965e-02, 1.09644e-01, 1.20705e-01, 1.32881e-01, 1.46286e-01,
 1.61044e-01, 1.77290e-01, 1.95174e-01, 2.14864e-01, 2.36539e-01,
 2.60401e-01, 2.86670e-01, 3.15589e-01, 3.47426e-01, 3.82474e-01,
 4.21058e-01, 4.63534e-01, 5.10295e-01, 5.61773e-01, 6.18445e-01,
 6.80833e-01, 7.49515e-01, 8.25126e-01, 9.08365e-01, 1.00000e+00}
,
{5.87168e-05, 6.47891e-05, 7.14894e-05, 7.88827e-05, 8.70405e-05,
 9.60420e-05, 1.05974e-04, 1.16934e-04, 1.29027e-04, 1.42371e-04,
 1.57094e-04, 1.73340e-04, 1.91267e-04, 2.11047e-04, 2.32873e-04,
 2.56956e-04, 2.83530e-04, 3.12852e-04, 3.45206e-04, 3.80906e-04,
 4.20299e-04, 4.63765e-04, 5.11726e-04, 5.64647e-04, 6.23041e-04,
 6.87475e-04, 7.58571e-04, 8.37021e-04, 9.23583e-04, 1.01910e-03,
 1.12449e-03, 1.24078e-03, 1.36910e-03, 1.51069e-03, 1.66692e-03,
 1.83931e-03, 2.02952e-03, 2.23941e-03, 2.47101e-03, 2.72655e-03,
 3.00852e-03, 3.31966e-03, 3.66297e-03, 4.04178e-03, 4.45977e-03,
 4.92099e-03, 5.42990e-03, 5.99145e-03, 6.61107e-03, 7.29477e-03,
 8.04917e-03, 8.88159e-03, 9.80010e-03, 1.08136e-02, 1.19319e-02,
 1.31659e-02, 1.45275e-02, 1.60299e-02, 1.76876e-02, 1.95168e-02,
 2.15352e-02, 2.37623e-02, 2.62197e-02, 2.89313e-02, 3.19233e-02,
 3.52247e-02, 3.88676e-02, 4.28872e-02, 4.73224e-02, 5.22164e-02,
 5.76165e-02, 6.35750e-02, 7.01497e-02, 7.74044e-02, 8.54094e-02,
 9.42422e-02, 1.03988e-01, 1.14743e-01, 1.26609e-01, 1.39703e-01,
 1.54150e-01, 1.70092e-01, 1.87683e-01, 2.07092e-01, 2.28509e-01,
 2.52141e-01, 2.78217e-01, 3.06989e-01, 3.38737e-01, 3.73768e-01,
 4.12422e-01, 4.55074e-01, 5.02136e-01, 5.54066e-01, 6.11366e-01,
 6.74592e-01, 7.44356e-01, 8.21335e-01, 9.06275e-01, 1.00000e+00}
,
{4.67484e-05, 5.17019e-05, 5.71802e-05, 6.32391e-05, 6.99400e-05,
 7.73509e-05, 8.55470e-05, 9.46117e-05, 1.04637e-04, 1.15724e-04,
 1.27986e-04, 1.41548e-04, 1.56546e-04, 1.73134e-04, 1.91480e-04,
 2.11769e-04, 2.34208e-04, 2.59025e-04, 2.86472e-04, 3.16826e-04,
 3.50398e-04, 3.87526e-04, 4.28589e-04, 4.74002e-04, 5.24228e-04,
 5.79775e-04, 6.41209e-04, 7.09152e-04, 7.84294e-04, 8.67399e-04,
 9.59309e-04, 1.06096e-03, 1.17338e-03, 1.29771e-03, 1.43522e-03,
 1.58729e-03, 1.75548e-03, 1.94150e-03, 2.14722e-03, 2.37474e-03,
 2.62637e-03, 2.90466e-03, 3.21244e-03, 3.55283e-03, 3.92930e-03,
 4.34565e-03, 4.80612e-03, 5.31538e-03, 5.87860e-03, 6.50150e-03,
 7.19040e-03, 7.95230e-03, 8.79493e-03, 9.72685e-03, 1.07575e-02,
 1.18974e-02, 1.31580e-02, 1.45523e-02, 1.60943e-02, 1.77996e-02,
 1.96857e-02, 2.17716e-02, 2.40785e-02, 2.66299e-02, 2.94516e-02,
 3.25724e-02, 3.60237e-02, 3.98408e-02, 4.40624e-02, 4.87313e-02,
 5.38949e-02, 5.96057e-02, 6.59215e-02, 7.29066e-02, 8.06319e-02,
 8.91757e-02, 9.86248e-02, 1.09075e-01, 1.20633e-01, 1.33415e-01,
 1.47552e-01, 1.63187e-01, 1.80478e-01, 1.99602e-01, 2.20752e-01,
 2.44143e-01, 2.70012e-01, 2.98623e-01, 3.30265e-01, 3.65260e-01,
 4.03964e-01, 4.46768e-01, 4.94108e-01, 5.46464e-01, 6.04368e-01,
 6.68407e-01, 7.39232e-01, 8.17562e-01, 9.04191e-01, 1.00000e+00}
,
{3.72194e-05, 4.12581e-05, 4.57351e-05, 5.06978e-05, 5.61990e-05,
 6.22972e-05, 6.90571e-05, 7.65504e-05, 8.48570e-05, 9.40648e-05,
 1.04272e-04, 1.15586e-04, 1.28129e-04, 1.42032e-04, 1.57444e-04,
 1.74528e-04, 1.93466e-04, 2.14459e-04, 2.37730e-04, 2.63526e-04,
 2.92122e-04, 3.23820e-04, 3.58958e-04, 3.97908e-04, 4.41085e-04,
 4.88948e-04, 5.42003e-04, 6.00816e-04, 6.66011e-04, 7.38280e-04,
 8.18391e-04, 9.07195e-04, 1.00563e-03, 1.11476e-03, 1.23572e-03,
 1.36981e-03, 1.51844e-03, 1.68321e-03, 1.86586e-03, 2.06832e-03,
 2.29276e-03, 2.54154e-03, 2.81733e-03, 3.12304e-03, 3.46192e-03,
 3.83757e-03, 4.25399e-03, 4.71559e-03, 5.22728e-03, 5.79449e-03,
 6.42325e-03, 7.12024e-03, 7.89286e-03, 8.74931e-03, 9.69870e-03,
 1.07511e-02, 1.19177e-02, 1.32109e-02, 1.46444e-02, 1.62335e-02,
 1.79950e-02, 1.99476e-02, 2.21122e-02, 2.45116e-02, 2.71713e-02,
 3.01197e-02, 3.33880e-02, 3.70109e-02, 4.10270e-02, 4.54788e-02,
 5.04137e-02, 5.58841e-02, 6.19481e-02, 6.86701e-02, 7.61215e-02,
 8.43815e-02, 9.35378e-02, 1.03688e-01, 1.14939e-01, 1.27411e-01,
 1.41236e-01, 1.56562e-01, 1.73550e-01, 1.92382e-01, 2.13258e-01,
 2.36398e-01, 2.62050e-01, 2.90485e-01, 3.22006e-01, 3.56946e-01,
 3.95679e-01, 4.38614e-01, 4.86208e-01, 5.38967e-01, 5.97450e-01,
 6.62279e-01, 7.34143e-01, 8.13805e-01, 9.02112e-01, 1.00000e+00}
,
{2.96328e-05, 3.29240e-05, 3.65807e-05, 4.06435e-05, 4.51576e-05,
 5.01731e-05, 5.57456e-05, 6.19370e-05, 6.88161e-05, 7.64592e-05,
 8.49511e-05, 9.43863e-05, 1.04869e-04, 1.16517e-04, 1.29458e-04,
 1.43836e-04, 1.59811e-04, 1.77561e-04, 1.97282e-04, 2.19193e-04,
 2.43538e-04, 2.70586e-04, 3.00639e-04, 3.34030e-04, 3.71129e-04,
 4.12348e-04, 4.58146e-04, 5.09030e-04, 5.65566e-04, 6.28381e-04,
 6.98172e-04, 7.75715e-04, 8.61870e-04, 9.57594e-04, 1.06395e-03,
 1.18212e-03, 1.31341e-03, 1.45929e-03, 1.62136e-03, 1.80144e-03,
 2.00152e-03, 2.22382e-03, 2.47081e-03, 2.74523e-03, 3.05013e-03,
 3.38889e-03, 3.76528e-03, 4.18347e-03, 4.64811e-03, 5.16436e-03,
 5.73794e-03, 6.37523e-03, 7.08330e-03, 7.87001e-03, 8.74409e-03,
 9.71526e-03, 1.07943e-02, 1.19932e-02, 1.33252e-02, 1.48052e-02,
 1.64495e-02, 1.82765e-02, 2.03064e-02, 2.25617e-02, 2.50675e-02,
 2.78517e-02, 3.09450e-02, 3.43819e-02, 3.82006e-02, 4.24434e-02,
 4.71574e-02, 5.23949e-02, 5.82142e-02, 6.46798e-02, 7.18635e-02,
 7.98450e-02, 8.87131e-02, 9.85660e-02, 1.09513e-01, 1.21676e-01,
 1.35191e-01, 1.50206e-01, 1.66888e-01, 1.85424e-01, 2.06018e-01,
 2.28899e-01, 2.54322e-01, 2.82569e-01, 3.13952e-01, 3.48822e-01,
 3.87564e-01, 4.30609e-01, 4.78434e-01, 5.31572e-01, 5.90611e-01,
 6.56208e-01, 7.29090e-01, 8.10066e-01, 9.00037e-01, 1.00000e+00}
,
{2.35925e-05, 2.62733e-05, 2.92586e-05, 3.25832e-05, 3.62855e-05,
 4.04085e-05, 4.50000e-05, 5.01132e-05, 5.58074e-05, 6.21486e-05,
 6.92104e-05, 7.70745e-05, 8.58322e-05, 9.55851e-05, 1.06446e-04,
 1.18541e-04, 1.32011e-04, 1.47011e-04, 1.63715e-04, 1.82317e-04,
 2.03033e-04, 2.26103e-04, 2.51795e-04, 2.80405e-04, 3.12267e-04,
 3.47749e-04, 3.87263e-04, 4.31266e-04, 4.80269e-04, 5.34841e-04,
 5.95613e-04, 6.63290e-04, 7.38658e-04, 8.22589e-04, 9.16057e-04,
 1.02015e-03, 1.13606e-03, 1.26515e-03, 1.40890e-03, 1.56899e-03,
 1.74727e-03, 1.94581e-03, 2.16691e-03, 2.41312e-03, 2.68732e-03,
 2.99267e-03, 3.33272e-03, 3.71140e-03, 4.13312e-03, 4.60275e-03,
 5.12575e-03, 5.70817e-03, 6.35677e-03, 7.07907e-03, 7.88344e-03,
 8.77921e-03, 9.77676e-03, 1.08877e-02, 1.21248e-02, 1.35025e-02,
 1.50367e-02, 1.67453e-02, 1.86480e-02, 2.07669e-02, 2.31266e-02,
 2.57544e-02, 2.86808e-02, 3.19397e-02, 3.55689e-02, 3.96105e-02,
 4.41113e-02, 4.91236e-02, 5.47053e-02, 6.09213e-02, 6.78436e-02,
 7.55524e-02, 8.41372e-02, 9.36974e-02, 1.04344e-01, 1.16200e-01,
 1.29404e-01, 1.44107e-01, 1.60482e-01, 1.78717e-01, 1.99024e-01,
 2.21638e-01, 2.46822e-01, 2.74868e-01, 3.06100e-01, 3.40882e-01,
 3.79615e-01, 4.22749e-01, 4.70785e-01, 5.24279e-01, 5.83851e-01,
 6.50192e-01, 7.24071e-01, 8.06345e-01, 8.97967e-01, 1.00000e+00}
,
{1.87835e-05, 2.09660e-05, 2.34021e-05, 2.61213e-05, 2.91565e-05,
 3.25443e-05, 3.63257e-05, 4.05465e-05, 4.52578e-05, 5.05165e-05,
 5.63862e-05, 6.29379e-05, 7.02509e-05, 7.84136e-05, 8.75248e-05,
 9.76946e-05, 1.09046e-04, 1.21717e-04, 1.35859e-04, 1.51645e-04,
 1.69266e-04, 1.88933e-04, 2.10886e-04, 2.35390e-04, 2.62741e-04,
 2.93270e-04, 3.27346e-04, 3.65381e-04, 4.07836e-04, 4.55224e-04,
 5.08119e-04, 5.67159e-04, 6.33059e-04, 7.06617e-04, 7.88722e-04,
 8.80366e-04, 9.82659e-04, 1.09684e-03, 1.22428e-03, 1.36654e-03,
 1.52532e-03, 1.70256e-03, 1.90038e-03, 2.12119e-03, 2.36766e-03,
 2.64277e-03, 2.94985e-03, 3.29260e-03, 3.67518e-03, 4.10221e-03,
 4.57887e-03, 5.11090e-03, 5.70476e-03, 6.36762e-03, 7.10749e-03,
 7.93334e-03, 8.85515e-03, 9.88406e-03, 1.10325e-02, 1.23144e-02,
 1.37453e-02, 1.53424e-02, 1.71251e-02, 1.91149e-02, 2.13360e-02,
 2.38151e-02, 2.65823e-02, 2.96710e-02, 3.31186e-02, 3.69667e-02,
 4.12620e-02, 4.60564e-02, 5.14079e-02, 5.73812e-02, 6.40485e-02,
 7.14906e-02, 7.97973e-02, 8.90693e-02, 9.94186e-02, 1.10970e-01,
 1.23865e-01, 1.38257e-01, 1.54321e-01, 1.72253e-01, 1.92267e-01,
 2.14608e-01, 2.39544e-01, 2.67377e-01, 2.98445e-01, 3.33122e-01,
 3.71829e-01, 4.15033e-01, 4.63258e-01, 5.17085e-01, 5.77167e-01,
 6.44231e-01, 7.19086e-01, 8.02640e-01, 8.95902e-01, 1.00000e+00}
,
{1.49547e-05, 1.67308e-05, 1.87179e-05, 2.09409e-05, 2.34280e-05,
 2.62105e-05, 2.93235e-05, 3.28061e-05, 3.67024e-05, 4.10614e-05,
 4.59382e-05, 5.13941e-05, 5.74980e-05, 6.43269e-05, 7.19668e-05,
 8.05141e-05, 9.00765e-05, 1.00775e-04, 1.12743e-04, 1.26133e-04,
 1.41114e-04, 1.57874e-04, 1.76624e-04, 1.97601e-04, 2.21069e-04,
 2.47325e-04, 2.76699e-04, 3.09562e-04, 3.46327e-04, 3.87460e-04,
 4.33477e-04, 4.84960e-04, 5.42557e-04, 6.06995e-04, 6.79086e-04,
 7.59739e-04, 8.49971e-04, 9.50919e-04, 1.06386e-03, 1.19021e-03,
 1.33156e-03, 1.48971e-03, 1.66664e-03, 1.86458e-03, 2.08603e-03,
 2.33378e-03, 2.61096e-03, 2.92105e-03, 3.26798e-03, 3.65611e-03,
 4.09033e-03, 4.57613e-03, 5.11962e-03, 5.72766e-03, 6.40792e-03,
 7.16897e-03, 8.02040e-03, 8.97296e-03, 1.00387e-02, 1.12309e-02,
 1.25648e-02, 1.40571e-02, 1.57266e-02, 1.75944e-02, 1.96840e-02,
 2.20218e-02, 2.46373e-02, 2.75634e-02, 3.08370e-02, 3.44994e-02,
 3.85968e-02, 4.31808e-02, 4.83092e-02, 5.40468e-02, 6.04658e-02,
 6.76471e-02, 7.56813e-02, 8.46698e-02, 9.47257e-02, 1.05976e-01,
 1.18562e-01, 1.32644e-01, 1.48397e-01, 1.66022e-01, 1.85740e-01,
 2.07800e-01, 2.32480e-01, 2.60091e-01, 2.90981e-01, 3.25540e-01,
 3.64203e-01, 4.07458e-01, 4.55851e-01, 5.09991e-01, 5.70561e-01,
 6.38325e-01, 7.14136e-01, 7.98952e-01, 8.93841e-01, 1.00000e+00}
,
{1.19063e-05, 1.33511e-05, 1.49712e-05, 1.67879e-05, 1.88251e-05,
 2.11094e-05, 2.36710e-05, 2.65434e-05, 2.97643e-05, 3.33761e-05,
 3.74261e-05, 4.19676e-05, 4.70602e-05, 5.27708e-05, 5.91743e-05,
 6.63549e-05, 7.44067e-05, 8.34357e-05, 9.35603e-05, 1.04913e-04,
 1.17644e-04, 1.31920e-04, 1.47928e-04, 1.65878e-04, 1.86007e-04,
 2.08578e-04, 2.33888e-04, 2.62270e-04, 2.94095e-04, 3.29782e-04,
 3.69800e-04, 4.14674e-04, 4.64993e-04, 5.21418e-04, 5.84690e-04,
 6.55639e-04, 7.35198e-04, 8.24412e-04, 9.24451e-04, 1.03663e-03,
 1.16242e-03, 1.30347e-03, 1.46165e-03, 1.63901e-03, 1.83790e-03,
 2.06092e-03, 2.31100e-03, 2.59143e-03, 2.90589e-03, 3.25851e-03,
 3.65392e-03, 4.09731e-03, 4.59450e-03, 5.15202e-03, 5.77720e-03,
 6.47824e-03, 7.26435e-03, 8.14585e-03, 9.13431e-03, 1.02427e-02,
 1.14856e-02, 1.28794e-02, 1.44422e-02, 1.61947e-02, 1.81599e-02,
 2.03635e-02, 2.28346e-02, 2.56055e-02, 2.87126e-02, 3.21967e-02,
 3.61037e-02, 4.04847e-02, 4.53974e-02, 5.09061e-02, 5.70834e-02,
 6.40102e-02, 7.17776e-02, 8.04875e-02, 9.02544e-02, 1.01206e-01,
 1.13487e-01, 1.27259e-01, 1.42701e-01, 1.60017e-01, 1.79434e-01,
 2.01208e-01, 2.25624e-01, 2.53002e-01, 2.83703e-01, 3.18129e-01,
 3.56733e-01, 4.00021e-01, 4.48562e-01, 5.02993e-01, 5.64030e-01,
 6.32472e-01, 7.09220e-01, 7.95281e-01, 8.91785e-01, 1.00000e+00}
,
{9.47937e-06, 1.06542e-05, 1.19745e-05, 1.34585e-05, 1.51265e-05,
 1.70011e-05, 1.91081e-05, 2.14762e-05, 2.41377e-05, 2.71291e-05,
 3.04913e-05, 3.42701e-05, 3.85172e-05, 4.32907e-05, 4.86557e-05,
 5.46857e-05, 6.14629e-05, 6.90800e-05, 7.76412e-05, 8.72633e-05,
 9.80780e-05, 1.10233e-04, 1.23894e-04, 1.39248e-04, 1.56506e-04,
 1.75901e-04, 1.97701e-04, 2.22202e-04, 2.49740e-04, 2.80691e-04,
 3.15477e-04, 3.54574e-04, 3.98517e-04, 4.47905e-04, 5.03415e-04,
 5.65803e-04, 6.35924e-04, 7.14734e-04, 8.03312e-04, 9.02867e-04,
 1.01476e-03, 1.14052e-03, 1.28187e-03, 1.44073e-03, 1.61928e-03,
 1.81996e-03, 2.04551e-03, 2.29901e-03, 2.58393e-03, 2.90416e-03,
 3.26407e-03, 3.66859e-03, 4.12324e-03, 4.63424e-03, 5.20856e-03,
 5.85406e-03, 6.57956e-03, 7.39497e-03, 8.31144e-03, 9.34148e-03,
 1.04992e-02, 1.18004e-02, 1.32628e-02, 1.49065e-02, 1.67538e-02,
 1.88301e-02, 2.11638e-02, 2.37866e-02, 2.67345e-02, 3.00477e-02,
 3.37716e-02, 3.79569e-02, 4.26610e-02, 4.79480e-02, 5.38902e-02,
 6.05689e-02, 6.80752e-02, 7.65119e-02, 8.59940e-02, 9.66514e-02,
 1.08629e-01, 1.22092e-01, 1.37223e-01, 1.54229e-01, 1.73343e-01,
 1.94825e-01, 2.18970e-01, 2.46107e-01, 2.76608e-01, 3.10888e-01,
 3.49417e-01, 3.92720e-01, 4.41390e-01, 4.96092e-01, 5.57573e-01,
 6.26674e-01, 7.04338e-01, 7.91627e-01, 8.89734e-01, 1.00000e+00}
,
{7.54710e-06, 8.50197e-06, 9.57766e-06, 1.07894e-05, 1.21545e-05,
 1.36924e-05, 1.54247e-05, 1.73763e-05, 1.95748e-05, 2.20514e-05,
 2.48414e-05, 2.79844e-05, 3.15250e-05, 3.55136e-05, 4.00069e-05,
 4.50686e-05, 5.07707e-05, 5.71944e-05, 6.44307e-05, 7.25826e-05,
 8.17658e-05, 9.21110e-05, 1.03765e-04, 1.16894e-04, 1.31683e-04,
 1.48344e-04, 1.67113e-04, 1.88256e-04, 2.12075e-04, 2.38907e-04,
 2.69134e-04, 3.03185e-04, 3.41544e-04, 3.84757e-04, 4.33437e-04,
 4.88277e-04, 5.50054e-04, 6.19648e-04, 6.98047e-04, 7.86365e-04,
 8.85857e-04, 9.97938e-04, 1.12420e-03, 1.26643e-03, 1.42667e-03,
 1.60717e-03, 1.81051e-03, 2.03958e-03, 2.29763e-03, 2.58833e-03,
 2.91581e-03, 3.28473e-03, 3.70032e-03, 4.16849e-03, 4.69589e-03,
 5.29003e-03, 5.95933e-03, 6.71331e-03, 7.56269e-03, 8.51954e-03,
 9.59745e-03, 1.08117e-02, 1.21797e-02, 1.37206e-02, 1.54566e-02,
 1.74122e-02, 1.96152e-02, 2.20970e-02, 2.48927e-02, 2.80422e-02,
 3.15902e-02, 3.55870e-02, 4.00895e-02, 4.51617e-02, 5.08757e-02,
 5.73125e-02, 6.45638e-02, 7.27326e-02, 8.19348e-02, 9.23014e-02,
 1.03979e-01, 1.17135e-01, 1.31955e-01, 1.48651e-01, 1.67458e-01,
 1.88645e-01, 2.12513e-01, 2.39400e-01, 2.69690e-01, 3.03811e-01,
 3.42250e-01, 3.85552e-01, 4.34333e-01, 4.89286e-01, 5.51191e-01,
 6.20929e-01, 6.99490e-01, 7.87990e-01, 8.87688e-01, 1.00000e+00}
,
{6.00870e-06, 6.78454e-06, 7.66055e-06, 8.64967e-06, 9.76650e-06,
 1.10275e-05, 1.24514e-05, 1.40591e-05, 1.58744e-05, 1.79241e-05,
 2.02384e-05, 2.28516e-05, 2.58021e-05, 2.91337e-05, 3.28954e-05,
 3.71428e-05, 4.19386e-05, 4.73537e-05, 5.34679e-05, 6.03716e-05,
 6.81667e-05, 7.69683e-05, 8.69064e-05, 9.81276e-05, 1.10798e-04,
 1.25104e-04, 1.41257e-04, 1.59496e-04, 1.80090e-04, 2.03343e-04,
 2.29598e-04, 2.59243e-04, 2.92717e-04, 3.30512e-04, 3.73187e-04,
 4.21373e-04, 4.75780e-04, 5.37212e-04, 6.06576e-04, 6.84896e-04,
 7.73329e-04, 8.73180e-04, 9.85924e-04, 1.11322e-03, 1.25696e-03,
 1.41926e-03, 1.60251e-03, 1.80943e-03, 2.04306e-03, 2.30686e-03,
 2.60471e-03, 2.94103e-03, 3.32077e-03, 3.74955e-03, 4.23368e-03,
 4.78033e-03, 5.39756e-03, 6.09449e-03, 6.88140e-03, 7.76992e-03,
 8.77316e-03, 9.90594e-03, 1.11850e-02, 1.26292e-02, 1.42598e-02,
 1.61010e-02, 1.81800e-02, 2.05274e-02, 2.31778e-02, 2.61705e-02,
 2.95496e-02, 3.33650e-02, 3.76731e-02, 4.25374e-02, 4.80297e-02,
 5.42313e-02, 6.12335e-02, 6.91399e-02, 7.80672e-02, 8.81471e-02,
 9.95286e-02, 1.12380e-01, 1.26890e-01, 1.43274e-01, 1.61773e-01,
 1.82661e-01, 2.06246e-01, 2.32876e-01, 2.62945e-01, 2.96896e-01,
 3.35231e-01, 3.78515e-01, 4.27389e-01, 4.82572e-01, 5.44881e-01,
 6.15236e-01, 6.94674e-01, 7.84370e-01, 8.85646e-01, 1.00000e+00}
,
{4.78389e-06, 5.41403e-06, 6.12717e-06, 6.93425e-06, 7.84764e-06,
 8.88135e-06, 1.00512e-05, 1.13752e-05, 1.28735e-05, 1.45693e-05,
 1.64883e-05, 1.86602e-05, 2.11182e-05, 2.38999e-05, 2.70480e-05,
 3.06108e-05, 3.46429e-05, 3.92061e-05, 4.43704e-05, 5.02150e-05,
 5.68294e-05, 6.43150e-05, 7.27867e-05, 8.23742e-05, 9.32247e-05,
 1.05504e-04, 1.19402e-04, 1.35129e-04, 1.52929e-04, 1.73073e-04,
 1.95870e-04, 2.21671e-04, 2.50869e-04, 2.83914e-04, 3.21312e-04,
 3.63636e-04, 4.11534e-04, 4.65742e-04, 5.27091e-04, 5.96520e-04,
 6.75094e-04, 7.64019e-04, 8.64656e-04, 9.78550e-04, 1.10745e-03,
 1.25332e-03, 1.41841e-03, 1.60525e-03, 1.81669e-03, 2.05599e-03,
 2.32681e-03, 2.63330e-03, 2.98016e-03, 3.37271e-03, 3.81697e-03,
 4.31975e-03, 4.88875e-03, 5.53270e-03, 6.26148e-03, 7.08625e-03,
 8.01966e-03, 9.07603e-03, 1.02715e-02, 1.16245e-02, 1.31557e-02,
 1.48886e-02, 1.68498e-02, 1.90692e-02, 2.15811e-02, 2.44238e-02,
 2.76409e-02, 3.12818e-02, 3.54023e-02, 4.00655e-02, 4.53430e-02,
 5.13157e-02, 5.80750e-02, 6.57248e-02, 7.43821e-02, 8.41799e-02,
 9.52682e-02, 1.07817e-01, 1.22019e-01, 1.38091e-01, 1.56281e-01,
 1.76867e-01, 2.00164e-01, 2.26530e-01, 2.56368e-01, 2.90138e-01,
 3.28355e-01, 3.71607e-01, 4.20555e-01, 4.75951e-01, 5.38644e-01,
 6.09595e-01, 6.89892e-01, 7.80766e-01, 8.83610e-01, 1.00000e+00}
,
{3.80874e-06, 4.32037e-06, 4.90073e-06, 5.55904e-06, 6.30579e-06,
 7.15285e-06, 8.11370e-06, 9.20361e-06, 1.04399e-05, 1.18423e-05,
 1.34331e-05, 1.52376e-05, 1.72845e-05, 1.96063e-05, 2.22400e-05,
 2.52275e-05, 2.86164e-05, 3.24604e-05, 3.68208e-05, 4.17670e-05,
 4.73776e-05, 5.37418e-05, 6.09610e-05, 6.91499e-05, 7.84389e-05,
 8.89756e-05, 1.00928e-04, 1.14485e-04, 1.29864e-04, 1.47309e-04,
 1.67097e-04, 1.89543e-04, 2.15005e-04, 2.43886e-04, 2.76648e-04,
 3.13810e-04, 3.55964e-04, 4.03781e-04, 4.58021e-04, 5.19547e-04,
 5.89338e-04, 6.68504e-04, 7.58305e-04, 8.60168e-04, 9.75715e-04,
 1.10678e-03, 1.25546e-03, 1.42410e-03, 1.61540e-03, 1.83240e-03,
 2.07855e-03, 2.35776e-03, 2.67448e-03, 3.03375e-03, 3.44127e-03,
 3.90354e-03, 4.42790e-03, 5.02270e-03, 5.69741e-03, 6.46274e-03,
 7.33088e-03, 8.31564e-03, 9.43269e-03, 1.06998e-02, 1.21371e-02,
 1.37675e-02, 1.56169e-02, 1.77147e-02, 2.00943e-02, 2.27936e-02,
 2.58554e-02, 2.93286e-02, 3.32684e-02, 3.77373e-02, 4.28066e-02,
 4.85568e-02, 5.50795e-02, 6.24783e-02, 7.08710e-02, 8.03912e-02,
 9.11901e-02, 1.03440e-01, 1.17335e-01, 1.33097e-01, 1.50975e-01,
 1.71256e-01, 1.94261e-01, 2.20356e-01, 2.49957e-01, 2.83533e-01,
 3.21621e-01, 3.64824e-01, 4.13831e-01, 4.69421e-01, 5.32479e-01,
 6.04007e-01, 6.85143e-01, 7.77179e-01, 8.81577e-01, 1.00000e+00}
,
{3.03237e-06, 3.44763e-06, 3.91977e-06, 4.45657e-06, 5.06687e-06,
 5.76076e-06, 6.54966e-06, 7.44661e-06, 8.46639e-06, 9.62582e-06,
 1.09440e-05, 1.24428e-05, 1.41467e-05, 1.60841e-05, 1.82867e-05,
 2.07910e-05, 2.36382e-05, 2.68754e-05, 3.05558e-05, 3.47403e-05,
 3.94978e-05, 4.49069e-05, 5.10567e-05, 5.80486e-05, 6.59981e-05,
 7.50362e-05, 8.53121e-05, 9.69952e-05, 1.10278e-04, 1.25380e-04,
 1.42551e-04, 1.62072e-04, 1.84267e-04, 2.09502e-04, 2.38192e-04,
 2.70811e-04, 3.07898e-04, 3.50063e-04, 3.98002e-04, 4.52507e-04,
 5.14476e-04, 5.84931e-04, 6.65034e-04, 7.56107e-04, 8.59653e-04,
 9.77378e-04, 1.11123e-03, 1.26340e-03, 1.43642e-03, 1.63313e-03,
 1.85678e-03, 2.11106e-03, 2.40016e-03, 2.72885e-03, 3.10255e-03,
 3.52743e-03, 4.01050e-03, 4.55971e-03, 5.18415e-03, 5.89409e-03,
 6.70126e-03, 7.61896e-03, 8.66235e-03, 9.84861e-03, 1.11973e-02,
 1.27308e-02, 1.44742e-02, 1.64563e-02, 1.87100e-02, 2.12722e-02,
 2.41853e-02, 2.74974e-02, 3.12630e-02, 3.55444e-02, 4.04120e-02,
 4.59463e-02, 5.22384e-02, 5.93922e-02, 6.75257e-02, 7.67730e-02,
 8.72867e-02, 9.92402e-02, 1.12831e-01, 1.28282e-01, 1.45850e-01,
 1.65823e-01, 1.88532e-01, 2.14351e-01, 2.43705e-01, 2.77079e-01,
 3.15024e-01, 3.58165e-01, 4.07214e-01, 4.62980e-01, 5.26383e-01,
 5.98469e-01, 6.80427e-01, 7.73608e-01, 8.79550e-01, 1.00000e+00}
,
{2.41425e-06, 2.75119e-06, 3.13517e-06, 3.57273e-06, 4.07137e-06,
 4.63959e-06, 5.28712e-06, 6.02502e-06, 6.86591e-06, 7.82416e-06,
 8.91615e-06, 1.01605e-05, 1.15786e-05, 1.31946e-05, 1.50361e-05,
 1.71347e-05, 1.95261e-05, 2.22513e-05, 2.53568e-05, 2.88957e-05,
 3.29286e-05, 3.75243e-05, 4.27615e-05, 4.87295e-05, 5.55305e-05,
 6.32807e-05, 7.21125e-05, 8.21770e-05, 9.36462e-05, 1.06716e-04,
 1.21610e-04, 1.38583e-04, 1.57924e-04, 1.79965e-04, 2.05082e-04,
 2.33704e-04, 2.66322e-04, 3.03491e-04, 3.45848e-04, 3.94117e-04,
 4.49123e-04, 5.11805e-04, 5.83236e-04, 6.64636e-04, 7.57396e-04,
 8.63103e-04, 9.83563e-04, 1.12084e-03, 1.27727e-03, 1.45553e-03,
 1.65867e-03, 1.89017e-03, 2.15397e-03, 2.45459e-03, 2.79717e-03,
 3.18756e-03, 3.63244e-03, 4.13940e-03, 4.71712e-03, 5.37548e-03,
 6.12571e-03, 6.98065e-03, 7.95492e-03, 9.06515e-03, 1.03303e-02,
 1.17721e-02, 1.34151e-02, 1.52874e-02, 1.74210e-02, 1.98524e-02,
 2.26231e-02, 2.57805e-02, 2.93786e-02, 3.34789e-02, 3.81514e-02,
 4.34761e-02, 4.95438e-02, 5.64585e-02, 6.43382e-02, 7.33176e-02,
 8.35503e-02, 9.52111e-02, 1.08499e-01, 1.23642e-01, 1.40898e-01,
 1.60563e-01, 1.82972e-01, 2.08509e-01, 2.37610e-01, 2.70772e-01,
 3.08563e-01, 3.51628e-01, 4.00703e-01, 4.56628e-01, 5.20358e-01,
 5.92982e-01, 6.75743e-01, 7.70053e-01, 8.77527e-01, 1.00000e+00}
,
{1.92213e-06, 2.19544e-06, 2.50762e-06, 2.86418e-06, 3.27145e-06,
 3.73663e-06, 4.26795e-06, 4.87482e-06, 5.56799e-06, 6.35972e-06,
 7.26403e-06, 8.29693e-06, 9.47669e-06, 1.08242e-05, 1.23633e-05,
 1.41213e-05, 1.61293e-05, 1.84228e-05, 2.10424e-05, 2.40344e-05,
 2.74520e-05, 3.13555e-05, 3.58140e-05, 4.09065e-05, 4.67231e-05,
 5.33668e-05, 6.09552e-05, 6.96226e-05, 7.95225e-05, 9.08301e-05,
 1.03745e-04, 1.18497e-04, 1.35347e-04, 1.54592e-04, 1.76574e-04,
 2.01682e-04, 2.30360e-04, 2.63115e-04, 3.00529e-04, 3.43262e-04,
 3.92071e-04, 4.47821e-04, 5.11498e-04, 5.84230e-04, 6.67303e-04,
 7.62189e-04, 8.70568e-04, 9.94356e-04, 1.13575e-03, 1.29724e-03,
 1.48170e-03, 1.69239e-03, 1.93304e-03, 2.20790e-03, 2.52185e-03,
 2.88044e-03, 3.29002e-03, 3.75784e-03, 4.29217e-03, 4.90249e-03,
 5.59959e-03, 6.39582e-03, 7.30526e-03, 8.34402e-03, 9.53048e-03,
 1.08857e-02, 1.24335e-02, 1.42015e-02, 1.62208e-02, 1.85273e-02,
 2.11618e-02, 2.41708e-02, 2.76078e-02, 3.15334e-02, 3.60173e-02,
 4.11387e-02, 4.69883e-02, 5.36697e-02, 6.13012e-02, 7.00178e-02,
 7.99739e-02, 9.13456e-02, 1.04334e-01, 1.19170e-01, 1.36115e-01,
 1.55470e-01, 1.77577e-01, 2.02827e-01, 2.31667e-01, 2.64609e-01,
 3.02234e-01, 3.45210e-01, 3.94297e-01, 4.50363e-01, 5.14401e-01,
 5.87546e-01, 6.71091e-01, 7.66515e-01, 8.75509e-01, 1.00000e+00}
,
{1.53032e-06, 1.75195e-06, 2.00568e-06, 2.29615e-06, 2.62870e-06,
 3.00940e-06, 3.44524e-06, 3.94420e-06, 4.51543e-06, 5.16938e-06,
 5.91804e-06, 6.77513e-06, 7.75634e-06, 8.87966e-06, 1.01657e-05,
 1.16379e-05, 1.33234e-05, 1.52530e-05, 1.74620e-05, 1.99910e-05,
 2.28862e-05, 2.62007e-05, 2.99953e-05, 3.43394e-05, 3.93126e-05,
 4.50061e-05, 5.15242e-05, 5.89862e-05, 6.75290e-05, 7.73089e-05,
 8.85053e-05, 1.01323e-04, 1.15997e-04, 1.32797e-04, 1.52029e-04,
 1.74047e-04, 1.99254e-04, 2.28111e-04, 2.61148e-04, 2.98969e-04,
 3.42267e-04, 3.91836e-04, 4.48584e-04, 5.13551e-04, 5.87927e-04,
 6.73074e-04, 7.70553e-04, 8.82149e-04, 1.00991e-03, 1.15617e-03,
 1.32361e-03, 1.51531e-03, 1.73476e-03, 1.98600e-03, 2.27363e-03,
 2.60291e-03, 2.97988e-03, 3.41144e-03, 3.90551e-03, 4.47113e-03,
 5.11866e-03, 5.85998e-03, 6.70866e-03, 7.68025e-03, 8.79255e-03,
 1.00659e-02, 1.15238e-02, 1.31927e-02, 1.51033e-02, 1.72907e-02,
 1.97949e-02, 2.26617e-02, 2.59437e-02, 2.97010e-02, 3.40025e-02,
 3.89269e-02, 4.45646e-02, 5.10187e-02, 5.84075e-02, 6.68665e-02,
 7.65505e-02, 8.76370e-02, 1.00329e-01, 1.14859e-01, 1.31494e-01,
 1.50538e-01, 1.72340e-01, 1.97299e-01, 2.25873e-01, 2.58586e-01,
 2.96036e-01, 3.38909e-01, 3.87992e-01, 4.44184e-01, 5.08513e-01,
 5.82159e-01, 6.66471e-01, 7.62994e-01, 8.73495e-01, 1.00000e+00}
,
{1.21838e-06, 1.39805e-06, 1.60421e-06, 1.84078e-06, 2.11223e-06,
 2.42371e-06, 2.78112e-06, 3.19124e-06, 3.66184e-06, 4.20183e-06,
 4.82145e-06, 5.53245e-06, 6.34829e-06, 7.28445e-06, 8.35865e-06,
 9.59126e-06, 1.10056e-05, 1.26286e-05, 1.44909e-05, 1.66278e-05,
 1.90798e-05, 2.18934e-05, 2.51219e-05, 2.88265e-05, 3.30774e-05,
 3.79552e-05, 4.35523e-05, 4.99748e-05, 5.73443e-05, 6.58006e-05,
 7.55039e-05, 8.66381e-05, 9.94142e-05, 1.14074e-04, 1.30896e-04,
 1.50199e-04, 1.72348e-04, 1.97764e-04, 2.26927e-04, 2.60391e-04,
 2.98789e-04, 3.42850e-04, 3.93409e-04, 4.51423e-04, 5.17992e-04,
 5.94378e-04, 6.82029e-04, 7.82604e-04, 8.98011e-04, 1.03044e-03,
 1.18239e-03, 1.35675e-03, 1.55683e-03, 1.78640e-03, 2.04984e-03,
 2.35212e-03, 2.69897e-03, 3.09698e-03, 3.55367e-03, 4.07772e-03,
 4.67904e-03, 5.36903e-03, 6.16078e-03, 7.06928e-03, 8.11176e-03,
 9.30796e-03, 1.06806e-02, 1.22556e-02, 1.40628e-02, 1.61366e-02,
 1.85162e-02, 2.12467e-02, 2.43799e-02, 2.79751e-02, 3.21004e-02,
 3.68341e-02, 4.22659e-02, 4.84986e-02, 5.56505e-02, 6.38570e-02,
 7.32737e-02, 8.40790e-02, 9.64778e-02, 1.10705e-01, 1.27030e-01,
 1.45763e-01, 1.67257e-01, 1.91922e-01, 2.20224e-01, 2.52699e-01,
 2.89964e-01, 3.32723e-01, 3.81789e-01, 4.38089e-01, 5.02692e-01,
 5.76822e-01, 6.61883e-01, 7.59488e-01, 8.71486e-01, 1.00000e+00}
,
{9.70024e-07, 1.11563e-06, 1.28310e-06, 1.47571e-06, 1.69723e-06,
 1.95200e-06, 2.24502e-06, 2.58202e-06, 2.96961e-06, 3.41538e-06,
 3.92806e-06, 4.51770e-06, 5.19586e-06, 5.97581e-06, 6.87284e-06,
 7.90453e-06, 9.09108e-06, 1.04557e-05, 1.20253e-05, 1.38304e-05,
 1.59065e-05, 1.82942e-05, 2.10403e-05, 2.41987e-05, 2.78312e-05,
 3.20090e-05, 3.68138e-05, 4.23400e-05, 4.86957e-05, 5.60054e-05,
 6.44124e-05, 7.40814e-05, 8.52018e-05, 9.79914e-05, 1.12701e-04,
 1.29619e-04, 1.49076e-04, 1.71454e-04, 1.97191e-04, 2.26791e-04,
 2.60835e-04, 2.99989e-04, 3.45020e-04, 3.96811e-04, 4.56377e-04,
 5.24884e-04, 6.03674e-04, 6.94292e-04, 7.98513e-04, 9.18378e-04,
 1.05624e-03, 1.21479e-03, 1.39714e-03, 1.60687e-03, 1.84807e-03,
 2.12549e-03, 2.44455e-03, 2.81150e-03, 3.23353e-03, 3.71892e-03,
 4.27717e-03, 4.91922e-03, 5.65765e-03, 6.50692e-03, 7.48368e-03,
 8.60705e-03, 9.89906e-03, 1.13850e-02, 1.30940e-02, 1.50596e-02,
 1.73202e-02, 1.99201e-02, 2.29103e-02, 2.63494e-02, 3.03047e-02,
 3.48538e-02, 4.00857e-02, 4.61030e-02, 5.30236e-02, 6.09830e-02,
 7.01371e-02, 8.06655e-02, 9.27742e-02, 1.06701e-01, 1.22717e-01,
 1.41139e-01, 1.62325e-01, 1.86692e-01, 2.14716e-01, 2.46947e-01,
 2.84017e-01, 3.26651e-01, 3.75684e-01, 4.32078e-01, 4.96938e-01,
 5.71534e-01, 6.57327e-01, 7.55998e-01, 8.69482e-01, 1.00000e+00}
,
{7.72293e-07, 8.90270e-07, 1.02627e-06, 1.18304e-06, 1.36377e-06,
 1.57210e-06, 1.81226e-06, 2.08910e-06, 2.40824e-06, 2.77612e-06,
 3.20021e-06, 3.68908e-06, 4.25263e-06, 4.90226e-06, 5.65114e-06,
 6.51442e-06, 7.50958e-06, 8.65675e-06, 9.97917e-06, 1.15036e-05,
 1.32609e-05, 1.52867e-05, 1.76219e-05, 2.03139e-05, 2.34170e-05,
 2.69943e-05, 3.11180e-05, 3.58716e-05, 4.13514e-05, 4.76683e-05,
 5.49502e-05, 6.33445e-05, 7.30211e-05, 8.41760e-05, 9.70349e-05,
 1.11858e-04, 1.28946e-04, 1.48644e-04, 1.71351e-04, 1.97527e-04,
 2.27701e-04, 2.62485e-04, 3.02583e-04, 3.48806e-04, 4.02090e-04,
 4.63514e-04, 5.34322e-04, 6.15945e-04, 7.10038e-04, 8.18505e-04,
 9.43541e-04, 1.08768e-03, 1.25383e-03, 1.44537e-03, 1.66617e-03,
 1.92070e-03, 2.21411e-03, 2.55234e-03, 2.94224e-03, 3.39170e-03,
 3.90982e-03, 4.50709e-03, 5.19560e-03, 5.98929e-03, 6.90423e-03,
 7.95893e-03, 9.17475e-03, 1.05763e-02, 1.21920e-02, 1.40544e-02,
 1.62014e-02, 1.86763e-02, 2.15294e-02, 2.48182e-02, 2.86095e-02,
 3.29800e-02, 3.80180e-02, 4.38258e-02, 5.05207e-02, 5.82383e-02,
 6.71349e-02, 7.73905e-02, 8.92128e-02, 1.02841e-01, 1.18551e-01,
 1.36661e-01, 1.57538e-01, 1.81604e-01, 2.09346e-01, 2.41326e-01,
 2.78191e-01, 3.20689e-01, 3.69677e-01, 4.26150e-01, 4.91250e-01,
 5.66294e-01, 6.52802e-01, 7.52525e-01, 8.67482e-01, 1.00000e+00}
,
{6.14869e-07, 7.10431e-07, 8.20846e-07, 9.48421e-07, 1.09582e-06,
 1.26614e-06, 1.46292e-06, 1.69028e-06, 1.95299e-06, 2.25652e-06,
 2.60722e-06, 3.01243e-06, 3.48063e-06, 4.02158e-06, 4.64661e-06,
 5.36878e-06, 6.20320e-06, 7.16729e-06, 8.28123e-06, 9.56829e-06,
 1.10554e-05, 1.27736e-05, 1.47589e-05, 1.70527e-05, 1.97030e-05,
 2.27652e-05, 2.63034e-05, 3.03914e-05, 3.51148e-05, 4.05723e-05,
 4.68781e-05, 5.41638e-05, 6.25819e-05, 7.23083e-05, 8.35464e-05,
 9.65311e-05, 1.11534e-04, 1.28868e-04, 1.48897e-04, 1.72039e-04,
 1.98777e-04, 2.29670e-04, 2.65365e-04, 3.06608e-04, 3.54261e-04,
 4.09320e-04, 4.72936e-04, 5.46440e-04, 6.31367e-04, 7.29493e-04,
 8.42871e-04, 9.73869e-04, 1.12523e-03, 1.30011e-03, 1.50217e-03,
 1.73564e-03, 2.00539e-03, 2.31706e-03, 2.67718e-03, 3.09326e-03,
 3.57402e-03, 4.12949e-03, 4.77129e-03, 5.51284e-03, 6.36964e-03,
 7.35961e-03, 8.50343e-03, 9.82503e-03, 1.13520e-02, 1.31163e-02,
 1.51549e-02, 1.75102e-02, 2.02317e-02, 2.33761e-02, 2.70091e-02,
 3.12069e-02, 3.60570e-02, 4.16610e-02, 4.81359e-02, 5.56171e-02,
 6.42611e-02, 7.42485e-02, 8.57881e-02, 9.91213e-02, 1.14527e-01,
 1.32326e-01, 1.52892e-01, 1.76655e-01, 2.04110e-01, 2.35833e-01,
 2.72486e-01, 3.14835e-01, 3.63767e-01, 4.20303e-01, 4.85626e-01,
 5.61102e-01, 6.48308e-01, 7.49067e-01, 8.65487e-01, 1.00000e+00}
,
{4.89534e-07, 5.66920e-07, 6.56541e-07, 7.60328e-07, 8.80523e-07,
 1.01972e-06, 1.18092e-06, 1.36760e-06, 1.58380e-06, 1.83417e-06,
 2.12412e-06, 2.45990e-06, 2.84877e-06, 3.29911e-06, 3.82064e-06,
 4.42462e-06, 5.12408e-06, 5.93410e-06, 6.87218e-06, 7.95856e-06,
 9.21667e-06, 1.06737e-05, 1.23610e-05, 1.43150e-05, 1.65780e-05,
 1.91987e-05, 2.22337e-05, 2.57484e-05, 2.98188e-05, 3.45327e-05,
 3.99917e-05, 4.63137e-05, 5.36351e-05, 6.21138e-05, 7.19329e-05,
 8.33043e-05, 9.64733e-05, 1.11724e-04, 1.29386e-04, 1.49839e-04,
 1.73526e-04, 2.00958e-04, 2.32726e-04, 2.69516e-04, 3.12121e-04,
 3.61462e-04, 4.18603e-04, 4.84777e-04, 5.61412e-04, 6.50162e-04,
 7.52941e-04, 8.71968e-04, 1.00981e-03, 1.16944e-03, 1.35431e-03,
 1.56841e-03, 1.81635e-03, 2.10348e-03, 2.43600e-03, 2.82109e-03,
 3.26706e-03, 3.78352e-03, 4.38163e-03, 5.07429e-03, 5.87645e-03,
 6.80541e-03, 7.88123e-03, 9.12712e-03, 1.05700e-02, 1.22409e-02,
 1.41760e-02, 1.64169e-02, 1.90122e-02, 2.20177e-02, 2.54983e-02,
 2.95291e-02, 3.41971e-02, 3.96031e-02, 4.58637e-02, 5.31139e-02,
 6.15103e-02, 7.12341e-02, 8.24949e-02, 9.55360e-02, 1.10639e-01,
 1.28129e-01, 1.48383e-01, 1.71840e-01, 1.99005e-01, 2.30465e-01,
 2.66897e-01, 3.09089e-01, 3.57951e-01, 4.14536e-01, 4.80067e-01,
 5.55958e-01, 6.43845e-01, 7.45626e-01, 8.63496e-01, 1.00000e+00}
,
{3.89747e-07, 4.52399e-07, 5.25124e-07, 6.09539e-07, 7.07523e-07,
 8.21259e-07, 9.53279e-07, 1.10652e-06, 1.28440e-06, 1.49087e-06,
 1.73053e-06, 2.00871e-06, 2.33162e-06, 2.70643e-06, 3.14150e-06,
 3.64650e-06, 4.23268e-06, 4.91310e-06, 5.70289e-06, 6.61964e-06,
 7.68376e-06, 8.91894e-06, 1.03527e-05, 1.20169e-05, 1.39486e-05,
 1.61909e-05, 1.87937e-05, 2.18148e-05, 2.53216e-05, 2.93921e-05,
 3.41169e-05, 3.96013e-05, 4.59673e-05, 5.33566e-05, 6.19338e-05,
 7.18898e-05, 8.34463e-05, 9.68605e-05, 1.12431e-04, 1.30505e-04,
 1.51483e-04, 1.75835e-04, 2.04101e-04, 2.36910e-04, 2.74994e-04,
 3.19200e-04, 3.70512e-04, 4.30073e-04, 4.99208e-04, 5.79457e-04,
 6.72606e-04, 7.80729e-04, 9.06234e-04, 1.05191e-03, 1.22101e-03,
 1.41729e-03, 1.64512e-03, 1.90958e-03, 2.21655e-03, 2.57287e-03,
 2.98646e-03, 3.46654e-03, 4.02380e-03, 4.67063e-03, 5.42144e-03,
 6.29295e-03, 7.30456e-03, 8.47879e-03, 9.84177e-03, 1.14239e-02,
 1.32603e-02, 1.53919e-02, 1.78662e-02, 2.07382e-02, 2.40719e-02,
 2.79415e-02, 3.24332e-02, 3.76469e-02, 4.36987e-02, 5.07234e-02,
 5.88773e-02, 6.83420e-02, 7.93281e-02, 9.20803e-02, 1.06882e-01,
 1.24064e-01, 1.44008e-01, 1.67157e-01, 1.94028e-01, 2.25219e-01,
 2.61423e-01, 3.03447e-01, 3.52227e-01, 4.08849e-01, 4.74572e-01,
 5.50861e-01, 6.39413e-01, 7.42200e-01, 8.61510e-01, 1.00000e+00}
,
{3.10301e-07, 3.61012e-07, 4.20012e-07, 4.88654e-07, 5.68513e-07,
 6.61425e-07, 7.69520e-07, 8.95281e-07, 1.04160e-06, 1.21182e-06,
 1.40987e-06, 1.64028e-06, 1.90835e-06, 2.22022e-06, 2.58307e-06,
 3.00522e-06, 3.49636e-06, 4.06776e-06, 4.73255e-06, 5.50598e-06,
 6.40581e-06, 7.45270e-06, 8.67068e-06, 1.00877e-05, 1.17363e-05,
 1.36544e-05, 1.58859e-05, 1.84821e-05, 2.15026e-05, 2.50167e-05,
 2.91051e-05, 3.38617e-05, 3.93957e-05, 4.58341e-05, 5.33246e-05,
 6.20394e-05, 7.21784e-05, 8.39743e-05, 9.76981e-05, 1.13665e-04,
 1.32241e-04, 1.53853e-04, 1.78996e-04, 2.08250e-04, 2.42283e-04,
 2.81879e-04, 3.27946e-04, 3.81542e-04, 4.43897e-04, 5.16442e-04,
 6.00843e-04, 6.99038e-04, 8.13280e-04, 9.46193e-04, 1.10083e-03,
 1.28073e-03, 1.49004e-03, 1.73356e-03, 2.01687e-03, 2.34648e-03,
 2.72996e-03, 3.17612e-03, 3.69518e-03, 4.29908e-03, 5.00167e-03,
 5.81908e-03, 6.77009e-03, 7.87651e-03, 9.16375e-03, 1.06614e-02,
 1.24037e-02, 1.44309e-02, 1.67893e-02, 1.95331e-02, 2.27254e-02,
 2.64393e-02, 3.07603e-02, 3.57873e-02, 4.16360e-02, 4.84405e-02,
 5.63570e-02, 6.55674e-02, 7.62829e-02, 8.87497e-02, 1.03254e-01,
 1.20128e-01, 1.39761e-01, 1.62602e-01, 1.89175e-01, 2.20092e-01,
 2.56061e-01, 2.97909e-01, 3.46596e-01, 4.03239e-01, 4.69140e-01,
 5.45810e-01, 6.35011e-01, 7.38790e-01, 8.59529e-01, 1.00000e+00}
,
{2.47049e-07, 2.88086e-07, 3.35940e-07, 3.91743e-07, 4.56815e-07,
 5.32697e-07, 6.21184e-07, 7.24368e-07, 8.44693e-07, 9.85005e-07,
 1.14862e-06, 1.33942e-06, 1.56191e-06, 1.82136e-06, 2.12391e-06,
 2.47672e-06, 2.88812e-06, 3.36787e-06, 3.92731e-06, 4.57967e-06,
 5.34040e-06, 6.22750e-06, 7.26195e-06, 8.46823e-06, 9.87489e-06,
 1.15152e-05, 1.34280e-05, 1.56585e-05, 1.82596e-05, 2.12927e-05,
 2.48296e-05, 2.89540e-05, 3.37636e-05, 3.93721e-05, 4.59122e-05,
 5.35387e-05, 6.24320e-05, 7.28026e-05, 8.48958e-05, 9.89978e-05,
 1.15442e-04, 1.34619e-04, 1.56980e-04, 1.83056e-04, 2.13463e-04,
 2.48922e-04, 2.90270e-04, 3.38487e-04, 3.94713e-04, 4.60279e-04,
 5.36736e-04, 6.25894e-04, 7.29861e-04, 8.51098e-04, 9.92474e-04,
 1.15733e-03, 1.34958e-03, 1.57376e-03, 1.83518e-03, 2.14002e-03,
 2.49550e-03, 2.91002e-03, 3.39341e-03, 3.95709e-03, 4.61440e-03,
 5.38090e-03, 6.27472e-03, 7.31701e-03, 8.53244e-03, 9.94977e-03,
 1.16025e-02, 1.35298e-02, 1.57773e-02, 1.83980e-02, 2.14541e-02,
 2.50179e-02, 2.91736e-02, 3.40196e-02, 3.96706e-02, 4.62603e-02,
 5.39446e-02, 6.29054e-02, 7.33546e-02, 8.55395e-02, 9.97485e-02,
 1.16318e-01, 1.35639e-01, 1.58170e-01, 1.84444e-01, 2.15082e-01,
 2.50809e-01, 2.92471e-01, 3.41054e-01, 3.97706e-01, 4.63769e-01,
 5.40806e-01, 6.30640e-01, 7.35395e-01, 8.57552e-01, 1.00000e+00}
,
{1.96690e-07, 2.29891e-07, 2.68696e-07, 3.14052e-07, 3.67063e-07,
 4.29023e-07, 5.01441e-07, 5.86084e-07, 6.85013e-07, 8.00643e-07,
 9.35790e-07, 1.09375e-06, 1.27837e-06, 1.49416e-06, 1.74637e-06,
 2.04116e-06, 2.38570e-06, 2.78840e-06, 3.25908e-06, 3.80921e-06,
 4.45219e-06, 5.20371e-06, 6.08209e-06, 7.10874e-06, 8.30868e-06,
 9.71118e-06, 1.13504e-05, 1.32663e-05, 1.55057e-05, 1.81230e-05,
 2.11821e-05, 2.47576e-05, 2.89367e-05, 3.38211e-05, 3.95301e-05,
 4.62027e-05, 5.40017e-05, 6.31170e-05, 7.37711e-05, 8.62235e-05,
 1.00778e-04, 1.17789e-04, 1.37672e-04, 1.60910e-04, 1.88072e-04,
 2.19818e-04, 2.56923e-04, 3.00291e-04, 3.50980e-04, 4.10224e-04,
 4.79470e-04, 5.60403e-04, 6.54998e-04, 7.65561e-04, 8.94786e-04,
 1.04582e-03, 1.22236e-03, 1.42869e-03, 1.66985e-03, 1.95172e-03,
 2.28117e-03, 2.66622e-03, 3.11628e-03, 3.64230e-03, 4.25711e-03,
 4.97570e-03, 5.81560e-03, 6.79726e-03, 7.94462e-03, 9.28566e-03,
 1.08531e-02, 1.26850e-02, 1.48263e-02, 1.73289e-02, 2.02540e-02,
 2.36728e-02, 2.76688e-02, 3.23392e-02, 3.77980e-02, 4.41783e-02,
 5.16355e-02, 6.03515e-02, 7.05387e-02, 8.24455e-02, 9.63621e-02,
 1.12628e-01, 1.31639e-01, 1.53860e-01, 1.79831e-01, 2.10186e-01,
 2.45665e-01, 2.87133e-01, 3.35601e-01, 3.92250e-01, 4.58461e-01,
 5.35848e-01, 6.26298e-01, 7.32016e-01, 8.55580e-01, 1.00000e+00}
,
{1.56597e-07, 1.83452e-07, 2.14912e-07, 2.51768e-07, 2.94945e-07,
 3.45526e-07, 4.04781e-07, 4.74198e-07, 5.55519e-07, 6.50787e-07,
 7.62392e-07, 8.93136e-07, 1.04630e-06, 1.22574e-06, 1.43594e-06,
 1.68219e-06, 1.97068e-06, 2.30863e-06, 2.70455e-06, 3.16836e-06,
 3.71171e-06, 4.34824e-06, 5.09393e-06, 5.96750e-06, 6.99089e-06,
 8.18977e-06, 9.59426e-06, 1.12396e-05, 1.31671e-05, 1.54252e-05,
 1.80705e-05, 2.11694e-05, 2.47998e-05, 2.90528e-05, 3.40352e-05,
 3.98720e-05, 4.67097e-05, 5.47201e-05, 6.41042e-05, 7.50976e-05,
 8.79762e-05, 1.03064e-04, 1.20738e-04, 1.41444e-04, 1.65700e-04,
 1.94117e-04, 2.27406e-04, 2.66405e-04, 3.12091e-04, 3.65613e-04,
 4.28313e-04, 5.01765e-04, 5.87814e-04, 6.88620e-04, 8.06714e-04,
 9.45059e-04, 1.10713e-03, 1.29699e-03, 1.51942e-03, 1.77999e-03,
 2.08524e-03, 2.44285e-03, 2.86178e-03, 3.35255e-03, 3.92749e-03,
 4.60103e-03, 5.39007e-03, 6.31442e-03, 7.39730e-03, 8.66588e-03,
 1.01520e-02, 1.18930e-02, 1.39326e-02, 1.63219e-02, 1.91210e-02,
 2.24001e-02, 2.62416e-02, 3.07418e-02, 3.60138e-02, 4.21899e-02,
 4.94252e-02, 5.79012e-02, 6.78309e-02, 7.94634e-02, 9.30907e-02,
 1.09055e-01, 1.27757e-01, 1.49667e-01, 1.75333e-01, 2.05402e-01,
 2.40627e-01, 2.81892e-01, 3.30235e-01, 3.86868e-01, 4.53213e-01,
 5.30935e-01, 6.21987e-01, 7.28653e-01, 8.53612e-01, 1.00000e+00}
,
{1.24676e-07, 1.46394e-07, 1.71894e-07, 2.01837e-07, 2.36996e-07,
 2.78279e-07, 3.26753e-07, 3.83671e-07, 4.50504e-07, 5.28979e-07,
 6.21124e-07, 7.29319e-07, 8.56362e-07, 1.00553e-06, 1.18069e-06,
 1.38636e-06, 1.62785e-06, 1.91142e-06, 2.24437e-06, 2.63533e-06,
 3.09438e-06, 3.63340e-06, 4.26632e-06, 5.00948e-06, 5.88210e-06,
 6.90672e-06, 8.10982e-06, 9.52250e-06, 1.11813e-05, 1.31290e-05,
 1.54159e-05, 1.81013e-05, 2.12544e-05, 2.49568e-05, 2.93041e-05,
 3.44086e-05, 4.04024e-05, 4.74402e-05, 5.57040e-05, 6.54072e-05,
 7.68007e-05, 9.01789e-05, 1.05887e-04, 1.24332e-04, 1.45990e-04,
 1.71421e-04, 2.01281e-04, 2.36343e-04, 2.77512e-04, 3.25853e-04,
 3.82614e-04, 4.49263e-04, 5.27522e-04, 6.19412e-04, 7.27310e-04,
 8.54002e-04, 1.00276e-03, 1.17744e-03, 1.38254e-03, 1.62337e-03,
 1.90615e-03, 2.23819e-03, 2.62806e-03, 3.08585e-03, 3.62339e-03,
 4.25456e-03, 4.99568e-03, 5.86589e-03, 6.88769e-03, 8.08747e-03,
 9.49626e-03, 1.11504e-02, 1.30928e-02, 1.53734e-02, 1.80514e-02,
 2.11958e-02, 2.48880e-02, 2.92233e-02, 3.43138e-02, 4.02911e-02,
 4.73095e-02, 5.55505e-02, 6.52270e-02, 7.65891e-02, 8.99304e-02,
 1.05596e-01, 1.23990e-01, 1.45588e-01, 1.70948e-01, 2.00726e-01,
 2.35691e-01, 2.76747e-01, 3.24955e-01, 3.81560e-01, 4.48025e-01,
 5.26068e-01, 6.17705e-01, 7.25305e-01, 8.51649e-01, 1.00000e+00}
,
{9.92619e-08, 1.16821e-07, 1.37487e-07, 1.61808e-07, 1.90432e-07,
 2.24120e-07, 2.63767e-07, 3.10427e-07, 3.65342e-07, 4.29971e-07,
 5.06032e-07, 5.95549e-07, 7.00902e-07, 8.24892e-07, 9.70815e-07,
 1.14255e-06, 1.34467e-06, 1.58254e-06, 1.86249e-06, 2.19197e-06,
 2.57973e-06, 3.03608e-06, 3.57317e-06, 4.20526e-06, 4.94917e-06,
 5.82468e-06, 6.85506e-06, 8.06772e-06, 9.49490e-06, 1.11746e-05,
 1.31513e-05, 1.54778e-05, 1.82158e-05, 2.14382e-05, 2.52306e-05,
 2.96939e-05, 3.49468e-05, 4.11289e-05, 4.84046e-05, 5.69673e-05,
 6.70448e-05, 7.89051e-05, 9.28634e-05, 1.09291e-04, 1.28624e-04,
 1.51378e-04, 1.78157e-04, 2.09673e-04, 2.46764e-04, 2.90417e-04,
 3.41791e-04, 4.02254e-04, 4.73413e-04, 5.57160e-04, 6.55721e-04,
 7.71719e-04, 9.08236e-04, 1.06890e-03, 1.25799e-03, 1.48053e-03,
 1.74244e-03, 2.05067e-03, 2.41344e-03, 2.84037e-03, 3.34284e-03,
 3.93418e-03, 4.63014e-03, 5.44921e-03, 6.41318e-03, 7.54767e-03,
 8.88285e-03, 1.04542e-02, 1.23036e-02, 1.44801e-02, 1.70416e-02,
 2.00563e-02, 2.36042e-02, 2.77798e-02, 3.26941e-02, 3.84777e-02,
 4.52844e-02, 5.32952e-02, 6.27231e-02, 7.38188e-02, 8.68773e-02,
 1.02246e-01, 1.20333e-01, 1.41620e-01, 1.66673e-01, 1.96157e-01,
 2.30857e-01, 2.71696e-01, 3.19759e-01, 3.76325e-01, 4.42896e-01,
 5.21245e-01, 6.13453e-01, 7.21973e-01, 8.49690e-01, 1.00000e+00}
,
{7.90283e-08, 9.32228e-08, 1.09967e-07, 1.29718e-07, 1.53017e-07,
 1.80501e-07, 2.12922e-07, 2.51165e-07, 2.96278e-07, 3.49493e-07,
 4.12267e-07, 4.86315e-07, 5.73664e-07, 6.76701e-07, 7.98246e-07,
 9.41621e-07, 1.11075e-06, 1.31025e-06, 1.54559e-06, 1.82320e-06,
 2.15067e-06, 2.53696e-06, 2.99263e-06, 3.53015e-06, 4.16421e-06,
 4.91215e-06, 5.79444e-06, 6.83520e-06, 8.06289e-06, 9.51109e-06,
 1.12194e-05, 1.32346e-05, 1.56116e-05, 1.84157e-05, 2.17234e-05,
 2.56252e-05, 3.02278e-05, 3.56572e-05, 4.20616e-05, 4.96165e-05,
 5.85282e-05, 6.90407e-05, 8.14413e-05, 9.60692e-05, 1.13324e-04,
 1.33679e-04, 1.57690e-04, 1.86013e-04, 2.19423e-04, 2.58834e-04,
 3.05324e-04, 3.60164e-04, 4.24854e-04, 5.01164e-04, 5.91179e-04,
 6.97363e-04, 8.22619e-04, 9.70372e-04, 1.14466e-03, 1.35026e-03,
 1.59278e-03, 1.87887e-03, 2.21634e-03, 2.61442e-03, 3.08400e-03,
 3.63793e-03, 4.29135e-03, 5.06214e-03, 5.97136e-03, 7.04390e-03,
 8.30907e-03, 9.80149e-03, 1.15620e-02, 1.36386e-02, 1.60883e-02,
 1.89780e-02, 2.23867e-02, 2.64076e-02, 3.11508e-02, 3.67459e-02,
 4.33459e-02, 5.11314e-02, 6.03153e-02, 7.11487e-02, 8.39279e-02,
 9.90025e-02, 1.16785e-01, 1.37761e-01, 1.62504e-01, 1.91692e-01,
 2.26123e-01, 2.66737e-01, 3.14647e-01, 3.71161e-01, 4.37827e-01,
 5.16466e-01, 6.09230e-01, 7.18656e-01, 8.47736e-01, 1.00000e+00}
,
{6.29191e-08, 7.43913e-08, 8.79552e-08, 1.03992e-07, 1.22953e-07,
 1.45372e-07, 1.71878e-07, 2.03217e-07, 2.40270e-07, 2.84079e-07,
 3.35875e-07, 3.97116e-07, 4.69524e-07, 5.55133e-07, 6.56352e-07,
 7.76026e-07, 9.17520e-07, 1.08481e-06, 1.28261e-06, 1.51647e-06,
 1.79297e-06, 2.11989e-06, 2.50642e-06, 2.96342e-06, 3.50374e-06,
 4.14259e-06, 4.89792e-06, 5.79097e-06, 6.84685e-06, 8.09525e-06,
 9.57127e-06, 1.13164e-05, 1.33798e-05, 1.58193e-05, 1.87037e-05,
 2.21140e-05, 2.61461e-05, 3.09134e-05, 3.65499e-05, 4.32141e-05,
 5.10935e-05, 6.04095e-05, 7.14241e-05, 8.44470e-05, 9.98444e-05,
 1.18049e-04, 1.39573e-04, 1.65022e-04, 1.95111e-04, 2.30686e-04,
 2.72748e-04, 3.22478e-04, 3.81277e-04, 4.50796e-04, 5.32990e-04,
 6.30172e-04, 7.45072e-04, 8.80923e-04, 1.04154e-03, 1.23145e-03,
 1.45598e-03, 1.72146e-03, 2.03534e-03, 2.40644e-03, 2.84521e-03,
 3.36399e-03, 3.97735e-03, 4.70255e-03, 5.55998e-03, 6.57375e-03,
 7.77235e-03, 9.18950e-03, 1.08650e-02, 1.28461e-02, 1.51884e-02,
 1.79577e-02, 2.12320e-02, 2.51032e-02, 2.96804e-02, 3.50920e-02,
 4.14905e-02, 4.90555e-02, 5.79999e-02, 6.85752e-02, 8.10786e-02,
 9.58619e-02, 1.13341e-01, 1.34006e-01, 1.58440e-01, 1.87329e-01,
 2.21485e-01, 2.61869e-01, 3.09616e-01, 3.66069e-01, 4.32815e-01,
 5.11731e-01, 6.05036e-01, 7.15354e-01, 8.45786e-01, 1.00000e+00}
,
{5.00936e-08, 5.93639e-08, 7.03496e-08, 8.33684e-08, 9.87963e-08,
 1.17079e-07, 1.38746e-07, 1.64422e-07, 1.94849e-07, 2.30908e-07,
 2.73639e-07, 3.24278e-07, 3.84289e-07, 4.55404e-07, 5.39680e-07,
 6.39552e-07, 7.57907e-07, 8.98163e-07, 1.06438e-06, 1.26135e-06,
 1.49477e-06, 1.77139e-06, 2.09920e-06, 2.48767e-06, 2.94803e-06,
 3.49359e-06, 4.14011e-06, 4.90626e-06, 5.81421e-06, 6.89017e-06,
 8.16525e-06, 9.67630e-06, 1.14670e-05, 1.35890e-05, 1.61038e-05,
 1.90839e-05, 2.26155e-05, 2.68007e-05, 3.17604e-05, 3.76379e-05,
 4.46031e-05, 5.28573e-05, 6.26390e-05, 7.42308e-05, 8.79678e-05,
 1.04247e-04, 1.23539e-04, 1.46400e-04, 1.73493e-04, 2.05599e-04,
 2.43647e-04, 2.88736e-04, 3.42169e-04, 4.05490e-04, 4.80529e-04,
 5.69454e-04, 6.74836e-04, 7.99720e-04, 9.47715e-04, 1.12310e-03,
 1.33093e-03, 1.57723e-03, 1.86911e-03, 2.21501e-03, 2.62491e-03,
 3.11067e-03, 3.68633e-03, 4.36851e-03, 5.17694e-03, 6.13498e-03,
 7.27030e-03, 8.61573e-03, 1.02101e-02, 1.20996e-02, 1.43387e-02,
 1.69922e-02, 2.01368e-02, 2.38632e-02, 2.82793e-02, 3.35126e-02,
 3.97144e-02, 4.70639e-02, 5.57734e-02, 6.60947e-02, 7.83261e-02,
 9.28210e-02, 1.09998e-01, 1.30354e-01, 1.54477e-01, 1.83065e-01,
 2.16942e-01, 2.57089e-01, 3.04665e-01, 3.61046e-01, 4.27860e-01,
 5.07039e-01, 6.00871e-01, 7.12067e-01, 8.43841e-01, 1.00000e+00}
,
{3.98825e-08, 4.73720e-08, 5.62680e-08, 6.68346e-08, 7.93854e-08,
 9.42932e-08, 1.12001e-07, 1.33033e-07, 1.58015e-07, 1.87689e-07,
 2.22935e-07, 2.64800e-07, 3.14527e-07, 3.73591e-07, 4.43748e-07,
 5.27079e-07, 6.26060e-07, 7.43627e-07, 8.83273e-07, 1.04914e-06,
 1.24616e-06, 1.48018e-06, 1.75814e-06, 2.08830e-06, 2.48046e-06,
 2.94627e-06, 3.49954e-06, 4.15672e-06, 4.93731e-06, 5.86449e-06,
 6.96578e-06, 8.27388e-06, 9.82763e-06, 1.16732e-05, 1.38653e-05,
 1.64690e-05, 1.95617e-05, 2.32352e-05, 2.75985e-05, 3.27813e-05,
 3.89373e-05, 4.62493e-05, 5.49344e-05, 6.52505e-05, 7.75039e-05,
 9.20584e-05, 1.09346e-04, 1.29880e-04, 1.54270e-04, 1.83241e-04,
 2.17651e-04, 2.58524e-04, 3.07072e-04, 3.64737e-04, 4.33231e-04,
 5.14587e-04, 6.11221e-04, 7.26002e-04, 8.62338e-04, 1.02428e-03,
 1.21663e-03, 1.44509e-03, 1.71647e-03, 2.03880e-03, 2.42167e-03,
 2.87644e-03, 3.41660e-03, 4.05820e-03, 4.82029e-03, 5.72549e-03,
 6.80068e-03, 8.07778e-03, 9.59470e-03, 1.13965e-02, 1.35366e-02,
 1.60787e-02, 1.90981e-02, 2.26845e-02, 2.69444e-02, 3.20043e-02,
 3.80144e-02, 4.51531e-02, 5.36324e-02, 6.37040e-02, 7.56670e-02,
 8.98765e-02, 1.06754e-01, 1.26802e-01, 1.50614e-01, 1.78898e-01,
 2.12493e-01, 2.52397e-01, 2.99794e-01, 3.56092e-01, 4.22963e-01,
 5.02391e-01, 5.96735e-01, 7.08795e-01, 8.41900e-01, 1.00000e+00}
,
{3.17528e-08, 3.78026e-08, 4.50051e-08, 5.35798e-08, 6.37883e-08,
 7.59417e-08, 9.04107e-08, 1.07636e-07, 1.28144e-07, 1.52559e-07,
 1.81626e-07, 2.16231e-07, 2.57429e-07, 3.06476e-07, 3.64869e-07,
 4.34386e-07, 5.17149e-07, 6.15680e-07, 7.32985e-07, 8.72639e-07,
 1.03890e-06, 1.23684e-06, 1.47249e-06, 1.75304e-06, 2.08705e-06,
 2.48469e-06, 2.95809e-06, 3.52169e-06, 4.19267e-06, 4.99149e-06,
 5.94251e-06, 7.07472e-06, 8.42265e-06, 1.00274e-05, 1.19379e-05,
 1.42124e-05, 1.69203e-05, 2.01440e-05, 2.39820e-05, 2.85513e-05,
 3.39911e-05, 4.04674e-05, 4.81775e-05, 5.73567e-05, 6.82847e-05,
 8.12949e-05, 9.67838e-05, 1.15224e-04, 1.37177e-04, 1.63313e-04,
 1.94429e-04, 2.31473e-04, 2.75575e-04, 3.28080e-04, 3.90588e-04,
 4.65006e-04, 5.53603e-04, 6.59080e-04, 7.84653e-04, 9.34151e-04,
 1.11213e-03, 1.32403e-03, 1.57629e-03, 1.87662e-03, 2.23416e-03,
 2.65983e-03, 3.16661e-03, 3.76993e-03, 4.48821e-03, 5.34334e-03,
 6.36140e-03, 7.57342e-03, 9.01637e-03, 1.07342e-02, 1.27794e-02,
 1.52142e-02, 1.81130e-02, 2.15640e-02, 2.56726e-02, 3.05639e-02,
 3.63872e-02, 4.33199e-02, 5.15736e-02, 6.13998e-02, 7.30982e-02,
 8.70254e-02, 1.03606e-01, 1.23346e-01, 1.46847e-01, 1.74825e-01,
 2.08134e-01, 2.47790e-01, 2.95001e-01, 3.51207e-01, 4.18121e-01,
 4.97785e-01, 5.92627e-01, 7.05539e-01, 8.39964e-01, 1.00000e+00}
,
{2.52803e-08, 3.01663e-08, 3.59966e-08, 4.29538e-08, 5.12555e-08,
 6.11618e-08, 7.29827e-08, 8.70883e-08, 1.03920e-07, 1.24005e-07,
 1.47972e-07, 1.76570e-07, 2.10697e-07, 2.51418e-07, 3.00011e-07,
 3.57994e-07, 4.27185e-07, 5.09748e-07, 6.08268e-07, 7.25829e-07,
 8.66112e-07, 1.03351e-06, 1.23326e-06, 1.47161e-06, 1.75603e-06,
 2.09542e-06, 2.50041e-06, 2.98367e-06, 3.56033e-06, 4.24845e-06,
 5.06955e-06, 6.04936e-06, 7.21853e-06, 8.61367e-06, 1.02785e-05,
 1.22650e-05, 1.46355e-05, 1.74641e-05, 2.08394e-05, 2.48671e-05,
 2.96733e-05, 3.54083e-05, 4.22517e-05, 5.04178e-05, 6.01622e-05,
 7.17899e-05, 8.56649e-05, 1.02222e-04, 1.21978e-04, 1.45553e-04,
 1.73685e-04, 2.07253e-04, 2.47309e-04, 2.95107e-04, 3.52143e-04,
 4.20203e-04, 5.01416e-04, 5.98326e-04, 7.13966e-04, 8.51956e-04,
 1.01662e-03, 1.21310e-03, 1.44756e-03, 1.72733e-03, 2.06118e-03,
 2.45954e-03, 2.93491e-03, 3.50214e-03, 4.17901e-03, 4.98670e-03,
 5.95049e-03, 7.10055e-03, 8.47289e-03, 1.01105e-02, 1.20645e-02,
 1.43963e-02, 1.71787e-02, 2.04988e-02, 2.44607e-02, 2.91883e-02,
 3.48296e-02, 4.15612e-02, 4.95938e-02, 5.91789e-02, 7.06165e-02,
 8.42648e-02, 1.00551e-01, 1.19985e-01, 1.43174e-01, 1.70846e-01,
 2.03866e-01, 2.43267e-01, 2.90284e-01, 3.46388e-01, 4.13335e-01,
 4.93221e-01, 5.88547e-01, 7.02297e-01, 8.38032e-01, 1.00000e+00}
,
{2.01272e-08, 2.40726e-08, 2.87913e-08, 3.44351e-08, 4.11852e-08,
 4.92584e-08, 5.89142e-08, 7.04627e-08, 8.42751e-08, 1.00795e-07,
 1.20553e-07, 1.44184e-07, 1.72448e-07, 2.06251e-07, 2.46681e-07,
 2.95037e-07, 3.52871e-07, 4.22042e-07, 5.04772e-07, 6.03718e-07,
 7.22061e-07, 8.63602e-07, 1.03289e-06, 1.23536e-06, 1.47752e-06,
 1.76714e-06, 2.11354e-06, 2.52785e-06, 3.02336e-06, 3.61601e-06,
 4.32484e-06, 5.17260e-06, 6.18655e-06, 7.39926e-06, 8.84969e-06,
 1.05844e-05, 1.26592e-05, 1.51407e-05, 1.81087e-05, 2.16584e-05,
 2.59039e-05, 3.09817e-05, 3.70548e-05, 4.43184e-05, 5.30058e-05,
 6.33962e-05, 7.58233e-05, 9.06864e-05, 1.08463e-04, 1.29724e-04,
 1.55153e-04, 1.85567e-04, 2.21942e-04, 2.65448e-04, 3.17482e-04,
 3.79716e-04, 4.54149e-04, 5.43173e-04, 6.49647e-04, 7.76993e-04,
 9.29302e-04, 1.11147e-03, 1.32934e-03, 1.58992e-03, 1.90158e-03,
 2.27434e-03, 2.72016e-03, 3.25337e-03, 3.89111e-03, 4.65386e-03,
 5.56612e-03, 6.65721e-03, 7.96217e-03, 9.52294e-03, 1.13897e-02,
 1.36223e-02, 1.62926e-02, 1.94863e-02, 2.33061e-02, 2.78746e-02,
 3.33387e-02, 3.98738e-02, 4.76900e-02, 5.70383e-02, 6.82192e-02,
 8.15917e-02, 9.75856e-02, 1.16715e-01, 1.39593e-01, 1.66957e-01,
 1.99684e-01, 2.38827e-01, 2.85643e-01, 3.41635e-01, 4.08604e-01,
 4.88699e-01, 5.84496e-01, 6.99070e-01, 8.36104e-01, 1.00000e+00}
,
{1.60244e-08, 1.92098e-08, 2.30283e-08, 2.76059e-08, 3.30934e-08,
 3.96717e-08, 4.75576e-08, 5.70111e-08, 6.83438e-08, 8.19292e-08,
 9.82151e-08, 1.17738e-07, 1.41142e-07, 1.69199e-07, 2.02832e-07,
 2.43151e-07, 2.91485e-07, 3.49426e-07, 4.18885e-07, 5.02151e-07,
 6.01969e-07, 7.21628e-07, 8.65074e-07, 1.03703e-06, 1.24317e-06,
 1.49029e-06, 1.78653e-06, 2.14166e-06, 2.56738e-06, 3.07773e-06,
 3.68952e-06, 4.42292e-06, 5.30211e-06, 6.35607e-06, 7.61953e-06,
 9.13414e-06, 1.09498e-05, 1.31264e-05, 1.57357e-05, 1.88637e-05,
 2.26134e-05, 2.71085e-05, 3.24971e-05, 3.89569e-05, 4.67007e-05,
 5.59839e-05, 6.71124e-05, 8.04530e-05, 9.64455e-05, 1.15617e-04,
 1.38599e-04, 1.66150e-04, 1.99177e-04, 2.38770e-04, 2.86233e-04,
 3.43130e-04, 4.11338e-04, 4.93103e-04, 5.91123e-04, 7.08626e-04,
 8.49487e-04, 1.01835e-03, 1.22078e-03, 1.46344e-03, 1.75435e-03,
 2.10307e-03, 2.52112e-03, 3.02227e-03, 3.62304e-03, 4.34323e-03,
 5.20658e-03, 6.24154e-03, 7.48224e-03, 8.96956e-03, 1.07525e-02,
 1.28899e-02, 1.54522e-02, 1.85238e-02, 2.22059e-02, 2.66200e-02,
 3.19116e-02, 3.82550e-02, 4.58593e-02, 5.49752e-02, 6.59032e-02,
 7.90034e-02, 9.47078e-02, 1.13534e-01, 1.36102e-01, 1.63156e-01,
 1.95589e-01, 2.34468e-01, 2.81076e-01, 3.36948e-01, 4.03926e-01,
 4.84219e-01, 5.80472e-01, 6.95858e-01, 8.34181e-01, 1.00000e+00}
,
{1.27580e-08, 1.53293e-08, 1.84188e-08, 2.21310e-08, 2.65914e-08,
 3.19507e-08, 3.83902e-08, 4.61275e-08, 5.54242e-08, 6.65946e-08,
 8.00163e-08, 9.61430e-08, 1.15520e-07, 1.38802e-07, 1.66777e-07,
 2.00390e-07, 2.40777e-07, 2.89305e-07, 3.47612e-07, 4.17671e-07,
 5.01850e-07, 6.02995e-07, 7.24525e-07, 8.70548e-07, 1.04600e-06,
 1.25682e-06, 1.51012e-06, 1.81447e-06, 2.18017e-06, 2.61957e-06,
 3.14753e-06, 3.78189e-06, 4.54411e-06, 5.45995e-06, 6.56036e-06,
 7.88256e-06, 9.47125e-06, 1.13801e-05, 1.36737e-05, 1.64296e-05,
 1.97408e-05, 2.37195e-05, 2.85000e-05, 3.42440e-05, 4.11456e-05,
 4.94383e-05, 5.94022e-05, 7.13744e-05, 8.57594e-05, 1.03044e-04,
 1.23812e-04, 1.48765e-04, 1.78748e-04, 2.14773e-04, 2.58059e-04,
 3.10069e-04, 3.72562e-04, 4.47649e-04, 5.37870e-04, 6.46275e-04,
 7.76527e-04, 9.33032e-04, 1.12108e-03, 1.34702e-03, 1.61851e-03,
 1.94471e-03, 2.33665e-03, 2.80759e-03, 3.37344e-03, 4.05334e-03,
 4.87026e-03, 5.85183e-03, 7.03123e-03, 8.44834e-03, 1.01510e-02,
 1.21969e-02, 1.46551e-02, 1.76088e-02, 2.11577e-02, 2.54219e-02,
 3.05456e-02, 3.67018e-02, 4.40989e-02, 5.29867e-02, 6.36658e-02,
 7.64973e-02, 9.19148e-02, 1.10440e-01, 1.32698e-01, 1.59443e-01,
 1.91577e-01, 2.30188e-01, 2.76581e-01, 3.32325e-01, 3.99303e-01,
 4.79780e-01, 5.76476e-01, 6.92661e-01, 8.32263e-01, 1.00000e+00}
,
{1.01574e-08, 1.22327e-08, 1.47320e-08, 1.77419e-08, 2.13669e-08,
 2.57324e-08, 3.09899e-08, 3.73215e-08, 4.49468e-08, 5.41301e-08,
 6.51896e-08, 7.85087e-08, 9.45491e-08, 1.13867e-07, 1.37131e-07,
 1.65149e-07, 1.98891e-07, 2.39527e-07, 2.88466e-07, 3.47404e-07,
 4.18383e-07, 5.03864e-07, 6.06811e-07, 7.30790e-07, 8.80100e-07,
 1.05992e-06, 1.27647e-06, 1.53727e-06, 1.85136e-06, 2.22962e-06,
 2.68516e-06, 3.23377e-06, 3.89447e-06, 4.69017e-06, 5.64843e-06,
 6.80248e-06, 8.19232e-06, 9.86613e-06, 1.18819e-05, 1.43095e-05,
 1.72332e-05, 2.07541e-05, 2.49945e-05, 3.01012e-05, 3.62513e-05,
 4.36579e-05, 5.25778e-05, 6.33202e-05, 7.62574e-05, 9.18378e-05,
 1.10602e-04, 1.33199e-04, 1.60413e-04, 1.93188e-04, 2.32659e-04,
 2.80194e-04, 3.37442e-04, 4.06385e-04, 4.89415e-04, 5.89410e-04,
 7.09834e-04, 8.54863e-04, 1.02952e-03, 1.23987e-03, 1.49319e-03,
 1.79827e-03, 2.16568e-03, 2.60816e-03, 3.14104e-03, 3.78280e-03,
 4.55567e-03, 5.48646e-03, 6.60742e-03, 7.95740e-03, 9.58320e-03,
 1.15412e-02, 1.38992e-02, 1.67390e-02, 2.01590e-02, 2.42778e-02,
 2.92380e-02, 3.52118e-02, 4.24060e-02, 5.10701e-02, 6.15044e-02,
 7.40706e-02, 8.92043e-02, 1.07430e-01, 1.29379e-01, 1.55813e-01,
 1.87648e-01, 2.25987e-01, 2.72159e-01, 3.27765e-01, 3.94732e-01,
 4.75381e-01, 5.72508e-01, 6.89479e-01, 8.30349e-01, 1.00000e+00}
,
{8.08691e-09, 9.76163e-09, 1.17832e-08, 1.42233e-08, 1.71688e-08,
 2.07243e-08, 2.50161e-08, 3.01967e-08, 3.64501e-08, 4.39986e-08,
 5.31102e-08, 6.41088e-08, 7.73851e-08, 9.34108e-08, 1.12755e-07,
 1.36106e-07, 1.64292e-07, 1.98315e-07, 2.39384e-07, 2.88958e-07,
 3.48798e-07, 4.21030e-07, 5.08222e-07, 6.13469e-07, 7.40512e-07,
 8.93865e-07, 1.07898e-06, 1.30242e-06, 1.57214e-06, 1.89771e-06,
 2.29071e-06, 2.76509e-06, 3.33771e-06, 4.02892e-06, 4.86327e-06,
 5.87040e-06, 7.08610e-06, 8.55356e-06, 1.03249e-05, 1.24631e-05,
 1.50441e-05, 1.81595e-05, 2.19202e-05, 2.64596e-05, 3.19392e-05,
 3.85534e-05, 4.65375e-05, 5.61749e-05, 6.78082e-05, 8.18505e-05,
 9.88009e-05, 1.19262e-04, 1.43959e-04, 1.73772e-04, 2.09758e-04,
 2.53197e-04, 3.05632e-04, 3.68925e-04, 4.45326e-04, 5.37548e-04,
 6.48869e-04, 7.83243e-04, 9.45444e-04, 1.14124e-03, 1.37757e-03,
 1.66286e-03, 2.00722e-03, 2.42289e-03, 2.92465e-03, 3.53031e-03,
 4.26140e-03, 5.14389e-03, 6.20914e-03, 7.49499e-03, 9.04713e-03,
 1.09207e-02, 1.31823e-02, 1.59122e-02, 1.92074e-02, 2.31851e-02,
 2.79865e-02, 3.37822e-02, 4.07781e-02, 4.92229e-02, 5.94164e-02,
 7.17209e-02, 8.65736e-02, 1.04502e-01, 1.26143e-01, 1.52266e-01,
 1.83799e-01, 2.21862e-01, 2.67808e-01, 3.23268e-01, 3.90213e-01,
 4.71023e-01, 5.68567e-01, 6.86311e-01, 8.28439e-01, 1.00000e+00}
,
{6.43847e-09, 7.78973e-09, 9.42457e-09, 1.14025e-08, 1.37956e-08,
 1.66909e-08, 2.01939e-08, 2.44320e-08, 2.95596e-08, 3.57634e-08,
 4.32691e-08, 5.23501e-08, 6.33370e-08, 7.66297e-08, 9.27121e-08,
 1.12170e-07, 1.35711e-07, 1.64193e-07, 1.98653e-07, 2.40345e-07,
 2.90786e-07, 3.51814e-07, 4.25650e-07, 5.14983e-07, 6.23063e-07,
 7.53827e-07, 9.12035e-07, 1.10345e-06, 1.33503e-06, 1.61521e-06,
 1.95420e-06, 2.36434e-06, 2.86055e-06, 3.46089e-06, 4.18724e-06,
 5.06603e-06, 6.12925e-06, 7.41561e-06, 8.97194e-06, 1.08549e-05,
 1.31330e-05, 1.58893e-05, 1.92240e-05, 2.32586e-05, 2.81400e-05,
 3.40458e-05, 4.11910e-05, 4.98359e-05, 6.02951e-05, 7.29494e-05,
 8.82594e-05, 1.06783e-04, 1.29193e-04, 1.56307e-04, 1.89112e-04,
 2.28802e-04, 2.76821e-04, 3.34918e-04, 4.05208e-04, 4.90250e-04,
 5.93139e-04, 7.17623e-04, 8.68232e-04, 1.05045e-03, 1.27091e-03,
 1.53764e-03, 1.86035e-03, 2.25078e-03, 2.72316e-03, 3.29468e-03,
 3.98614e-03, 4.82272e-03, 5.83488e-03, 7.05946e-03, 8.54104e-03,
 1.03336e-02, 1.25023e-02, 1.51262e-02, 1.83008e-02, 2.21416e-02,
 2.67885e-02, 3.24107e-02, 3.92128e-02, 4.74424e-02, 5.73993e-02,
 6.94458e-02, 8.40206e-02, 1.01654e-01, 1.22989e-01, 1.48800e-01,
 1.80030e-01, 2.17813e-01, 2.63526e-01, 3.18832e-01, 3.85747e-01,
 4.66704e-01, 5.64653e-01, 6.83158e-01, 8.26533e-01, 1.00000e+00}
,
{5.12605e-09, 6.21616e-09, 7.53810e-09, 9.14116e-09, 1.10851e-08,
 1.34425e-08, 1.63012e-08, 1.97679e-08, 2.39717e-08, 2.90696e-08,
 3.52516e-08, 4.27482e-08, 5.18391e-08, 6.28633e-08, 7.62319e-08,
 9.24434e-08, 1.12103e-07, 1.35943e-07, 1.64852e-07, 1.99910e-07,
 2.42423e-07, 2.93977e-07, 3.56495e-07, 4.32307e-07, 5.24243e-07,
 6.35729e-07, 7.70924e-07, 9.34869e-07, 1.13368e-06, 1.37477e-06,
 1.66713e-06, 2.02167e-06, 2.45160e-06, 2.97296e-06, 3.60519e-06,
 4.37187e-06, 5.30160e-06, 6.42905e-06, 7.79626e-06, 9.45422e-06,
 1.14648e-05, 1.39029e-05, 1.68595e-05, 2.04449e-05, 2.47927e-05,
 3.00651e-05, 3.64588e-05, 4.42122e-05, 5.36145e-05, 6.50162e-05,
 7.88426e-05, 9.56094e-05, 1.15942e-04, 1.40598e-04, 1.70498e-04,
 2.06756e-04, 2.50725e-04, 3.04045e-04, 3.68704e-04, 4.47113e-04,
 5.42197e-04, 6.57501e-04, 7.97326e-04, 9.66886e-04, 1.17251e-03,
 1.42185e-03, 1.72423e-03, 2.09090e-03, 2.53556e-03, 3.07477e-03,
 3.72866e-03, 4.52160e-03, 5.48317e-03, 6.64923e-03, 8.06326e-03,
 9.77801e-03, 1.18574e-02, 1.43790e-02, 1.74369e-02, 2.11450e-02,
 2.56418e-02, 3.10948e-02, 3.77075e-02, 4.57264e-02, 5.54506e-02,
 6.72428e-02, 8.15428e-02, 9.88838e-02, 1.19913e-01, 1.45413e-01,
 1.76337e-01, 2.13837e-01, 2.59312e-01, 3.14458e-01, 3.81331e-01,
 4.62425e-01, 5.60766e-01, 6.80019e-01, 8.24632e-01, 1.00000e+00}
,
{4.08115e-09, 4.96046e-09, 6.02923e-09, 7.32827e-09, 8.90719e-09,
 1.08263e-08, 1.31589e-08, 1.59941e-08, 1.94401e-08, 2.36286e-08,
 2.87196e-08, 3.49074e-08, 4.24285e-08, 5.15700e-08, 6.26811e-08,
 7.61862e-08, 9.26010e-08, 1.12553e-07, 1.36803e-07, 1.66278e-07,
 2.02104e-07, 2.45648e-07, 2.98575e-07, 3.62905e-07, 4.41095e-07,
 5.36132e-07, 6.51645e-07, 7.92047e-07, 9.62699e-07, 1.17012e-06,
 1.42223e-06, 1.72866e-06, 2.10111e-06, 2.55381e-06, 3.10404e-06,
 3.77283e-06, 4.58572e-06, 5.57374e-06, 6.77464e-06, 8.23428e-06,
 1.00084e-05, 1.21648e-05, 1.47858e-05, 1.79715e-05, 2.18436e-05,
 2.65499e-05, 3.22703e-05, 3.92231e-05, 4.76740e-05, 5.79457e-05,
 7.04305e-05, 8.56053e-05, 1.04050e-04, 1.26468e-04, 1.53716e-04,
 1.86835e-04, 2.27090e-04, 2.76018e-04, 3.35488e-04, 4.07772e-04,
 4.95629e-04, 6.02416e-04, 7.32210e-04, 8.89970e-04, 1.08172e-03,
 1.31478e-03, 1.59806e-03, 1.94238e-03, 2.36088e-03, 2.86954e-03,
 3.48781e-03, 4.23928e-03, 5.15266e-03, 6.26284e-03, 7.61221e-03,
 9.25231e-03, 1.12458e-02, 1.36688e-02, 1.66138e-02, 2.01934e-02,
 2.45442e-02, 2.98324e-02, 3.62600e-02, 4.40724e-02, 5.35681e-02,
 6.51097e-02, 7.91381e-02, 9.61889e-02, 1.16914e-01, 1.42103e-01,
 1.72720e-01, 2.09934e-01, 2.55166e-01, 3.10143e-01, 3.76966e-01,
 4.58186e-01, 5.56905e-01, 6.76894e-01, 8.22736e-01, 1.00000e+00}
,
{3.24925e-09, 3.95842e-09, 4.82238e-09, 5.87491e-09, 7.15716e-09,
 8.71928e-09, 1.06223e-08, 1.29408e-08, 1.57652e-08, 1.92061e-08,
 2.33980e-08, 2.85048e-08, 3.47262e-08, 4.23055e-08, 5.15391e-08,
 6.27879e-08, 7.64919e-08, 9.31870e-08, 1.13526e-07, 1.38304e-07,
 1.68490e-07, 2.05264e-07, 2.50065e-07, 3.04644e-07, 3.71135e-07,
 4.52139e-07, 5.50822e-07, 6.71044e-07, 8.17505e-07, 9.95933e-07,
 1.21330e-06, 1.47812e-06, 1.80073e-06, 2.19376e-06, 2.67256e-06,
 3.25587e-06, 3.96650e-06, 4.83222e-06, 5.88689e-06, 7.17176e-06,
 8.73706e-06, 1.06440e-05, 1.29671e-05, 1.57973e-05, 1.92453e-05,
 2.34457e-05, 2.85629e-05, 3.47970e-05, 4.23918e-05, 5.16442e-05,
 6.29160e-05, 7.66480e-05, 9.33771e-05, 1.13757e-04, 1.38586e-04,
 1.68834e-04, 2.05683e-04, 2.50575e-04, 3.05265e-04, 3.71892e-04,
 4.53061e-04, 5.51946e-04, 6.72413e-04, 8.19173e-04, 9.97964e-04,
 1.21578e-03, 1.48113e-03, 1.80440e-03, 2.19823e-03, 2.67801e-03,
 3.26251e-03, 3.97459e-03, 4.84208e-03, 5.89890e-03, 7.18639e-03,
 8.75488e-03, 1.06657e-02, 1.29936e-02, 1.58296e-02, 1.92845e-02,
 2.34935e-02, 2.86212e-02, 3.48680e-02, 4.24783e-02, 5.17495e-02,
 6.30443e-02, 7.68043e-02, 9.35675e-02, 1.13989e-01, 1.38869e-01,
 1.69178e-01, 2.06103e-01, 2.51086e-01, 3.05888e-01, 3.72651e-01,
 4.53985e-01, 5.53072e-01, 6.73784e-01, 8.20844e-01, 1.00000e+00}
,
{2.58692e-09, 3.15880e-09, 3.85711e-09, 4.70979e-09, 5.75097e-09,
 7.02232e-09, 8.57472e-09, 1.04703e-08, 1.27850e-08, 1.56113e-08,
 1.90624e-08, 2.32765e-08, 2.84222e-08, 3.47054e-08, 4.23776e-08,
 5.17459e-08, 6.31852e-08, 7.71534e-08, 9.42095e-08, 1.15036e-07,
 1.40467e-07, 1.71520e-07, 2.09437e-07, 2.55736e-07, 3.12271e-07,
 3.81304e-07, 4.65598e-07, 5.68527e-07, 6.94209e-07, 8.47676e-07,
 1.03507e-06, 1.26389e-06, 1.54329e-06, 1.88447e-06, 2.30106e-06,
 2.80975e-06, 3.43089e-06, 4.18935e-06, 5.11548e-06, 6.24634e-06,
 7.62720e-06, 9.31333e-06, 1.13722e-05, 1.38862e-05, 1.69560e-05,
 2.07044e-05, 2.52815e-05, 3.08704e-05, 3.76948e-05, 4.60279e-05,
 5.62032e-05, 6.86279e-05, 8.37993e-05, 1.02325e-04, 1.24945e-04,
 1.52566e-04, 1.86294e-04, 2.27477e-04, 2.77765e-04, 3.39170e-04,
 4.14149e-04, 5.05704e-04, 6.17499e-04, 7.54007e-04, 9.20693e-04,
 1.12423e-03, 1.37276e-03, 1.67623e-03, 2.04679e-03, 2.49927e-03,
 3.05177e-03, 3.72642e-03, 4.55021e-03, 5.55611e-03, 6.78439e-03,
 8.28420e-03, 1.01156e-02, 1.23518e-02, 1.50824e-02, 1.84166e-02,
 2.24879e-02, 2.74592e-02, 3.35295e-02, 4.09418e-02, 4.99927e-02,
 6.10444e-02, 7.45393e-02, 9.10176e-02, 1.11139e-01, 1.35708e-01,
 1.65708e-01, 2.02341e-01, 2.47072e-01, 3.01691e-01, 3.68385e-01,
 4.49823e-01, 5.49264e-01, 6.70689e-01, 8.18956e-01, 1.00000e+00}
,
{2.05960e-09, 2.52071e-09, 3.08505e-09, 3.77573e-09, 4.62105e-09,
 5.65562e-09, 6.92182e-09, 8.47149e-09, 1.03681e-08, 1.26893e-08,
 1.55302e-08, 1.90072e-08, 2.32626e-08, 2.84706e-08, 3.48447e-08,
 4.26458e-08, 5.21934e-08, 6.38786e-08, 7.81799e-08, 9.56829e-08,
 1.17105e-07, 1.43322e-07, 1.75410e-07, 2.14681e-07, 2.62744e-07,
 3.21567e-07, 3.93560e-07, 4.81672e-07, 5.89509e-07, 7.21490e-07,
 8.83018e-07, 1.08071e-06, 1.32266e-06, 1.61878e-06, 1.98120e-06,
 2.42475e-06, 2.96761e-06, 3.63201e-06, 4.44515e-06, 5.44034e-06,
 6.65833e-06, 8.14901e-06, 9.97343e-06, 1.22063e-05, 1.49391e-05,
 1.82837e-05, 2.23770e-05, 2.73869e-05, 3.35183e-05, 4.10224e-05,
 5.02066e-05, 6.14470e-05, 7.52039e-05, 9.20407e-05, 1.12647e-04,
 1.37867e-04, 1.68732e-04, 2.06509e-04, 2.52742e-04, 3.09327e-04,
 3.78579e-04, 4.63336e-04, 5.67069e-04, 6.94026e-04, 8.49405e-04,
 1.03957e-03, 1.27231e-03, 1.55716e-03, 1.90578e-03, 2.33245e-03,
 2.85465e-03, 3.49375e-03, 4.27594e-03, 5.23325e-03, 6.40488e-03,
 7.83881e-03, 9.59378e-03, 1.17417e-02, 1.43704e-02, 1.75877e-02,
 2.15252e-02, 2.63444e-02, 3.22424e-02, 3.94609e-02, 4.82955e-02,
 5.91080e-02, 7.23412e-02, 8.85371e-02, 1.08359e-01, 1.32619e-01,
 1.62309e-01, 1.98648e-01, 2.43121e-01, 2.97552e-01, 3.64168e-01,
 4.45699e-01, 5.45483e-01, 6.67607e-01, 8.17072e-01, 1.00000e+00}
,
{1.63977e-09, 2.01151e-09, 2.46753e-09, 3.02692e-09, 3.71314e-09,
 4.55492e-09, 5.58753e-09, 6.85424e-09, 8.40812e-09, 1.03143e-08,
 1.26526e-08, 1.55209e-08, 1.90396e-08, 2.33559e-08, 2.86508e-08,
 3.51460e-08, 4.31137e-08, 5.28878e-08, 6.48776e-08, 7.95856e-08,
 9.76279e-08, 1.19760e-07, 1.46911e-07, 1.80216e-07, 2.21071e-07,
 2.71189e-07, 3.32668e-07, 4.08085e-07, 5.00600e-07, 6.14087e-07,
 7.53303e-07, 9.24079e-07, 1.13357e-06, 1.39056e-06, 1.70580e-06,
 2.09251e-06, 2.56689e-06, 3.14881e-06, 3.86266e-06, 4.73834e-06,
 5.81253e-06, 7.13025e-06, 8.74671e-06, 1.07296e-05, 1.31621e-05,
 1.61459e-05, 1.98063e-05, 2.42964e-05, 2.98045e-05, 3.65613e-05,
 4.48499e-05, 5.50175e-05, 6.74901e-05, 8.27904e-05, 1.01559e-04,
 1.24583e-04, 1.52826e-04, 1.87473e-04, 2.29973e-04, 2.82109e-04,
 3.46064e-04, 4.24518e-04, 5.20758e-04, 6.38816e-04, 7.83637e-04,
 9.61290e-04, 1.17922e-03, 1.44655e-03, 1.77449e-03, 2.17677e-03,
 2.67025e-03, 3.27561e-03, 4.01820e-03, 4.92914e-03, 6.04659e-03,
 7.41738e-03, 9.09892e-03, 1.11617e-02, 1.36921e-02, 1.67961e-02,
 2.06038e-02, 2.52748e-02, 3.10047e-02, 3.80336e-02, 4.66559e-02,
 5.72329e-02, 7.02078e-02, 8.61242e-02, 1.05649e-01, 1.29600e-01,
 1.58981e-01, 1.95022e-01, 2.39234e-01, 2.93469e-01, 3.60000e-01,
 4.41613e-01, 5.41728e-01, 6.64540e-01, 8.15193e-01, 1.00000e+00}
,
{1.30552e-09, 1.60517e-09, 1.97361e-09, 2.42662e-09, 2.98360e-09,
 3.66843e-09, 4.51045e-09, 5.54574e-09, 6.81866e-09, 8.38376e-09,
 1.03081e-08, 1.26741e-08, 1.55832e-08, 1.91601e-08, 2.35579e-08,
 2.89652e-08, 3.56136e-08, 4.37880e-08, 5.38387e-08, 6.61964e-08,
 8.13905e-08, 1.00072e-07, 1.23042e-07, 1.51284e-07, 1.86008e-07,
 2.28703e-07, 2.81197e-07, 3.45741e-07, 4.25099e-07, 5.22673e-07,
 6.42643e-07, 7.90149e-07, 9.71513e-07, 1.19451e-06, 1.46868e-06,
 1.80579e-06, 2.22028e-06, 2.72990e-06, 3.35650e-06, 4.12692e-06,
 5.07417e-06, 6.23886e-06, 7.67087e-06, 9.43157e-06, 1.15964e-05,
 1.42582e-05, 1.75308e-05, 2.15547e-05, 2.65022e-05, 3.25853e-05,
 4.00646e-05, 4.92607e-05, 6.05676e-05, 7.44697e-05, 9.15629e-05,
 1.12579e-04, 1.38420e-04, 1.70192e-04, 2.09256e-04, 2.57287e-04,
 3.16342e-04, 3.88952e-04, 4.78229e-04, 5.87998e-04, 7.22961e-04,
 8.88904e-04, 1.09293e-03, 1.34380e-03, 1.65224e-03, 2.03148e-03,
 2.49777e-03, 3.07109e-03, 3.77600e-03, 4.64271e-03, 5.70835e-03,
 7.01860e-03, 8.62958e-03, 1.06103e-02, 1.30457e-02, 1.60402e-02,
 1.97219e-02, 2.42487e-02, 2.98145e-02, 3.66578e-02, 4.50720e-02,
 5.54174e-02, 6.81374e-02, 8.37771e-02, 1.03007e-01, 1.26650e-01,
 1.55720e-01, 1.91462e-01, 2.35409e-01, 2.89443e-01, 3.55879e-01,
 4.37564e-01, 5.37999e-01, 6.61486e-01, 8.13318e-01, 1.00000e+00}
,
{1.03940e-09, 1.28092e-09, 1.57856e-09, 1.94537e-09, 2.39740e-09,
 2.95448e-09, 3.64099e-09, 4.48704e-09, 5.52967e-09, 6.81457e-09,
 8.39805e-09, 1.03495e-08, 1.27543e-08, 1.57180e-08, 1.93703e-08,
 2.38713e-08, 2.94182e-08, 3.62539e-08, 4.46781e-08, 5.50598e-08,
 6.78538e-08, 8.36207e-08, 1.03051e-07, 1.26997e-07, 1.56506e-07,
 1.92873e-07, 2.37690e-07, 2.92921e-07, 3.60986e-07, 4.44867e-07,
 5.48239e-07, 6.75631e-07, 8.32624e-07, 1.02610e-06, 1.26453e-06,
 1.55836e-06, 1.92047e-06, 2.36672e-06, 2.91666e-06, 3.59440e-06,
 4.42961e-06, 5.45890e-06, 6.72736e-06, 8.29056e-06, 1.02170e-05,
 1.25911e-05, 1.55168e-05, 1.91224e-05, 2.35658e-05, 2.90417e-05,
 3.57899e-05, 4.41063e-05, 5.43551e-05, 6.69853e-05, 8.25504e-05,
 1.01732e-04, 1.25371e-04, 1.54503e-04, 1.90405e-04, 2.34648e-04,
 2.89172e-04, 3.56366e-04, 4.39173e-04, 5.41222e-04, 6.66983e-04,
 8.21967e-04, 1.01296e-03, 1.24834e-03, 1.53841e-03, 1.89589e-03,
 2.33643e-03, 2.87933e-03, 3.54839e-03, 4.37292e-03, 5.38903e-03,
 6.64126e-03, 8.18446e-03, 1.00862e-02, 1.24299e-02, 1.53182e-02,
 1.88777e-02, 2.32642e-02, 2.86700e-02, 3.53319e-02, 4.35418e-02,
 5.36594e-02, 6.61280e-02, 8.14939e-02, 1.00430e-01, 1.23767e-01,
 1.52526e-01, 1.87968e-01, 2.31645e-01, 2.85471e-01, 3.51805e-01,
 4.33553e-01, 5.34295e-01, 6.58447e-01, 8.11448e-01, 1.00000e+00}
,
{8.27528e-10, 1.02217e-09, 1.26259e-09, 1.55956e-09, 1.92638e-09,
 2.37947e-09, 2.93914e-09, 3.63044e-09, 4.48435e-09, 5.53909e-09,
 6.84192e-09, 8.45119e-09, 1.04390e-08, 1.28943e-08, 1.59271e-08,
 1.96733e-08, 2.43005e-08, 3.00162e-08, 3.70762e-08, 4.57967e-08,
 5.65684e-08, 6.98737e-08, 8.63084e-08, 1.06609e-07, 1.31684e-07,
 1.62657e-07, 2.00915e-07, 2.48171e-07, 3.06542e-07, 3.78643e-07,
 4.67702e-07, 5.77709e-07, 7.13590e-07, 8.81431e-07, 1.08875e-06,
 1.34483e-06, 1.66114e-06, 2.05186e-06, 2.53446e-06, 3.13059e-06,
 3.86692e-06, 4.77645e-06, 5.89990e-06, 7.28759e-06, 9.00168e-06,
 1.11189e-05, 1.37342e-05, 1.69646e-05, 2.09547e-05, 2.58834e-05,
 3.19714e-05, 3.94912e-05, 4.87798e-05, 6.02532e-05, 7.44251e-05,
 9.19304e-05, 1.13553e-04, 1.40261e-04, 1.73252e-04, 2.14002e-04,
 2.64336e-04, 3.26510e-04, 4.03307e-04, 4.98168e-04, 6.15340e-04,
 7.60072e-04, 9.38846e-04, 1.15967e-03, 1.43243e-03, 1.76935e-03,
 2.18551e-03, 2.69955e-03, 3.33451e-03, 4.11880e-03, 5.08757e-03,
 6.28420e-03, 7.76229e-03, 9.58803e-03, 1.18432e-02, 1.46288e-02,
 1.80696e-02, 2.23197e-02, 2.75694e-02, 3.40539e-02, 4.20636e-02,
 5.19572e-02, 6.41779e-02, 7.92730e-02, 9.79185e-02, 1.20950e-01,
 1.49398e-01, 1.84537e-01, 2.27941e-01, 2.81555e-01, 3.47778e-01,
 4.29578e-01, 5.30617e-01, 6.55422e-01, 8.09581e-01, 1.00000e+00}
,
{6.58844e-10, 8.15684e-10, 1.00986e-09, 1.25026e-09, 1.54789e-09,
 1.91637e-09, 2.37258e-09, 2.93738e-09, 3.63663e-09, 4.50234e-09,
 5.57415e-09, 6.90109e-09, 8.54392e-09, 1.05778e-08, 1.30959e-08,
 1.62135e-08, 2.00732e-08, 2.48517e-08, 3.07677e-08, 3.80921e-08,
 4.71600e-08, 5.83866e-08, 7.22858e-08, 8.94937e-08, 1.10798e-07,
 1.37174e-07, 1.69829e-07, 2.10257e-07, 2.60310e-07, 3.22278e-07,
 3.98997e-07, 4.93980e-07, 6.11574e-07, 7.57161e-07, 9.37406e-07,
 1.16056e-06, 1.43684e-06, 1.77888e-06, 2.20235e-06, 2.72663e-06,
 3.37571e-06, 4.17931e-06, 5.17422e-06, 6.40596e-06, 7.93092e-06,
 9.81891e-06, 1.21563e-05, 1.50502e-05, 1.86330e-05, 2.30686e-05,
 2.85602e-05, 3.53591e-05, 4.37764e-05, 5.41976e-05, 6.70995e-05,
 8.30728e-05, 1.02849e-04, 1.27332e-04, 1.57644e-04, 1.95172e-04,
 2.41633e-04, 2.99155e-04, 3.70370e-04, 4.58538e-04, 5.67695e-04,
 7.02837e-04, 8.70150e-04, 1.07729e-03, 1.33375e-03, 1.65125e-03,
 2.04434e-03, 2.53100e-03, 3.13351e-03, 3.87946e-03, 4.80298e-03,
 5.94635e-03, 7.36190e-03, 9.11443e-03, 1.12842e-02, 1.39704e-02,
 1.72961e-02, 2.14135e-02, 2.65111e-02, 3.28221e-02, 4.06356e-02,
 5.03090e-02, 6.22853e-02, 7.71126e-02, 9.54695e-02, 1.18196e-01,
 1.46334e-01, 1.81169e-01, 2.24297e-01, 2.77691e-01, 3.43797e-01,
 4.25639e-01, 5.26964e-01, 6.52410e-01, 8.07719e-01, 1.00000e+00}
,
{5.24545e-10, 6.50912e-10, 8.07722e-10, 1.00231e-09, 1.24377e-09,
 1.54341e-09, 1.91523e-09, 2.37662e-09, 2.94917e-09, 3.65964e-09,
 4.54128e-09, 5.63531e-09, 6.99290e-09, 8.67755e-09, 1.07680e-08,
 1.33621e-08, 1.65812e-08, 2.05757e-08, 2.55326e-08, 3.16836e-08,
 3.93164e-08, 4.87881e-08, 6.05415e-08, 7.51264e-08, 9.32250e-08,
 1.15684e-07, 1.43553e-07, 1.78136e-07, 2.21050e-07, 2.74303e-07,
 3.40384e-07, 4.22386e-07, 5.24142e-07, 6.50412e-07, 8.07101e-07,
 1.00154e-06, 1.24282e-06, 1.54222e-06, 1.91375e-06, 2.37479e-06,
 2.94690e-06, 3.65683e-06, 4.53779e-06, 5.63098e-06, 6.98753e-06,
 8.67088e-06, 1.07598e-05, 1.33519e-05, 1.65685e-05, 2.05599e-05,
 2.55130e-05, 3.16593e-05, 3.92862e-05, 4.87506e-05, 6.04950e-05,
 7.50687e-05, 9.31534e-05, 1.15595e-04, 1.43442e-04, 1.77999e-04,
 2.20880e-04, 2.74092e-04, 3.40123e-04, 4.22061e-04, 5.23739e-04,
 6.49912e-04, 8.06481e-04, 1.00077e-03, 1.24186e-03, 1.54104e-03,
 1.91228e-03, 2.37297e-03, 2.94464e-03, 3.65402e-03, 4.53431e-03,
 5.62666e-03, 6.98216e-03, 8.66422e-03, 1.07515e-02, 1.33416e-02,
 1.65557e-02, 2.05441e-02, 2.54934e-02, 3.16349e-02, 3.92560e-02,
 4.87131e-02, 6.04485e-02, 7.50110e-02, 9.30818e-02, 1.15506e-01,
 1.43332e-01, 1.77862e-01, 2.20711e-01, 2.73881e-01, 3.39862e-01,
 4.21737e-01, 5.23337e-01, 6.49413e-01, 8.05862e-01, 1.00000e+00}
,
{4.17621e-10, 5.19424e-10, 6.46043e-10, 8.03529e-10, 9.99403e-10,
 1.24303e-09, 1.54604e-09, 1.92291e-09, 2.39166e-09, 2.97467e-09,
 3.69980e-09, 4.60170e-09, 5.72344e-09, 7.11864e-09, 8.85394e-09,
 1.10123e-08, 1.36967e-08, 1.70355e-08, 2.11882e-08, 2.63533e-08,
 3.27774e-08, 4.07675e-08, 5.07053e-08, 6.30656e-08, 7.84390e-08,
 9.75600e-08, 1.21342e-07, 1.50921e-07, 1.87711e-07, 2.33469e-07,
 2.90382e-07, 3.61168e-07, 4.49209e-07, 5.58713e-07, 6.94909e-07,
 8.64306e-07, 1.07500e-06, 1.33705e-06, 1.66298e-06, 2.06836e-06,
 2.57256e-06, 3.19967e-06, 3.97965e-06, 4.94976e-06, 6.15636e-06,
 7.65708e-06, 9.52364e-06, 1.18452e-05, 1.47327e-05, 1.83241e-05,
 2.27909e-05, 2.83466e-05, 3.52566e-05, 4.38510e-05, 5.45405e-05,
 6.78358e-05, 8.43720e-05, 1.04939e-04, 1.30520e-04, 1.62337e-04,
 2.01910e-04, 2.51129e-04, 3.12346e-04, 3.88486e-04, 4.83187e-04,
 6.00973e-04, 7.47471e-04, 9.29681e-04, 1.15631e-03, 1.43818e-03,
 1.78876e-03, 2.22481e-03, 2.76714e-03, 3.44169e-03, 4.28066e-03,
 5.32415e-03, 6.62201e-03, 8.23625e-03, 1.02440e-02, 1.27411e-02,
 1.58470e-02, 1.97101e-02, 2.45147e-02, 3.04907e-02, 3.79233e-02,
 4.71678e-02, 5.86659e-02, 7.29668e-02, 9.07538e-02, 1.12877e-01,
 1.40392e-01, 1.74616e-01, 2.17182e-01, 2.70124e-01, 3.35971e-01,
 4.17871e-01, 5.19734e-01, 6.46429e-01, 8.04008e-01, 1.00000e+00}
,
{3.32493e-10, 4.14498e-10, 5.16728e-10, 6.44171e-10, 8.03047e-10,
 1.00111e-09, 1.24802e-09, 1.55582e-09, 1.93954e-09, 2.41790e-09,
 3.01424e-09, 3.75766e-09, 4.68444e-09, 5.83979e-09, 7.28009e-09,
 9.07562e-09, 1.13140e-08, 1.41044e-08, 1.75831e-08, 2.19197e-08,
 2.73259e-08, 3.40654e-08, 4.24672e-08, 5.29411e-08, 6.59982e-08,
 8.22757e-08, 1.02568e-07, 1.27865e-07, 1.59401e-07, 1.98715e-07,
 2.47725e-07, 3.08823e-07, 3.84989e-07, 4.79942e-07, 5.98312e-07,
 7.45878e-07, 9.29838e-07, 1.15917e-06, 1.44506e-06, 1.80146e-06,
 2.24577e-06, 2.79966e-06, 3.49015e-06, 4.35095e-06, 5.42405e-06,
 6.76181e-06, 8.42952e-06, 1.05085e-05, 1.31003e-05, 1.63313e-05,
 2.03592e-05, 2.53805e-05, 3.16403e-05, 3.94439e-05, 4.91722e-05,
 6.12998e-05, 7.64185e-05, 9.52660e-05, 1.18762e-04, 1.48053e-04,
 1.84568e-04, 2.30089e-04, 2.86837e-04, 3.57582e-04, 4.45774e-04,
 5.55718e-04, 6.92778e-04, 8.63642e-04, 1.07665e-03, 1.34219e-03,
 1.67322e-03, 2.08589e-03, 2.60035e-03, 3.24169e-03, 4.04120e-03,
 5.03791e-03, 6.28044e-03, 7.82942e-03, 9.76043e-03, 1.21677e-02,
 1.51687e-02, 1.89098e-02, 2.35737e-02, 2.93878e-02, 3.66359e-02,
 4.56716e-02, 5.69358e-02, 7.09782e-02, 8.84840e-02, 1.10307e-01,
 1.37513e-01, 1.71429e-01, 2.13709e-01, 2.66417e-01, 3.32125e-01,
 4.14039e-01, 5.16156e-01, 6.43459e-01, 8.02159e-01, 1.00000e+00}
,
{2.64717e-10, 3.30767e-10, 4.13296e-10, 5.16418e-10, 6.45269e-10,
 8.06270e-10, 1.00744e-09, 1.25881e-09, 1.57289e-09, 1.96534e-09,
 2.45572e-09, 3.06844e-09, 3.83405e-09, 4.79068e-09, 5.98600e-09,
 7.47956e-09, 9.34578e-09, 1.16776e-08, 1.45913e-08, 1.82320e-08,
 2.27811e-08, 2.84652e-08, 3.55675e-08, 4.44419e-08, 5.55306e-08,
 6.93860e-08, 8.66985e-08, 1.08331e-07, 1.35360e-07, 1.69134e-07,
 2.11334e-07, 2.64064e-07, 3.29951e-07, 4.12276e-07, 5.15143e-07,
 6.43676e-07, 8.04280e-07, 1.00496e-06, 1.25570e-06, 1.56901e-06,
 1.96049e-06, 2.44966e-06, 3.06087e-06, 3.82458e-06, 4.77885e-06,
 5.97122e-06, 7.46110e-06, 9.32271e-06, 1.16488e-05, 1.45553e-05,
 1.81870e-05, 2.27248e-05, 2.83949e-05, 3.54797e-05, 4.43322e-05,
 5.53935e-05, 6.92147e-05, 8.64845e-05, 1.08063e-04, 1.35026e-04,
 1.68716e-04, 2.10812e-04, 2.63412e-04, 3.29136e-04, 4.11259e-04,
 5.13872e-04, 6.42087e-04, 8.02294e-04, 1.00247e-03, 1.25260e-03,
 1.56514e-03, 1.95565e-03, 2.44361e-03, 3.05331e-03, 3.81514e-03,
 4.76706e-03, 5.95648e-03, 7.44268e-03, 9.29970e-03, 1.16201e-02,
 1.45194e-02, 1.81421e-02, 2.26687e-02, 2.83248e-02, 3.53921e-02,
 4.42228e-02, 5.52568e-02, 6.90439e-02, 8.62710e-02, 1.07796e-01,
 1.34693e-01, 1.68300e-01, 2.10292e-01, 2.62762e-01, 3.28324e-01,
 4.10244e-01, 5.12603e-01, 6.40503e-01, 8.00314e-01, 1.00000e+00}
,
{2.10757e-10, 2.63950e-10, 3.30569e-10, 4.14001e-10, 5.18491e-10,
 6.49352e-10, 8.13242e-10, 1.01850e-09, 1.27555e-09, 1.59749e-09,
 2.00068e-09, 2.50564e-09, 3.13803e-09, 3.93004e-09, 4.92194e-09,
 6.16419e-09, 7.71997e-09, 9.66841e-09, 1.21086e-08, 1.51647e-08,
 1.89921e-08, 2.37856e-08, 2.97888e-08, 3.73072e-08, 4.67232e-08,
 5.85156e-08, 7.32844e-08, 9.17806e-08, 1.14945e-07, 1.43956e-07,
 1.80289e-07, 2.25792e-07, 2.82780e-07, 3.54151e-07, 4.43535e-07,
 5.55479e-07, 6.95676e-07, 8.71258e-07, 1.09115e-06, 1.36655e-06,
 1.71145e-06, 2.14341e-06, 2.68438e-06, 3.36189e-06, 4.21040e-06,
 5.27307e-06, 6.60394e-06, 8.27070e-06, 1.03581e-05, 1.29724e-05,
 1.62465e-05, 2.03470e-05, 2.54824e-05, 3.19139e-05, 3.99686e-05,
 5.00563e-05, 6.26900e-05, 7.85124e-05, 9.83281e-05, 1.23145e-04,
 1.54226e-04, 1.93151e-04, 2.41900e-04, 3.02953e-04, 3.79415e-04,
 4.75176e-04, 5.95106e-04, 7.45305e-04, 9.33412e-04, 1.16900e-03,
 1.46404e-03, 1.83355e-03, 2.29632e-03, 2.87588e-03, 3.60173e-03,
 4.51077e-03, 5.64924e-03, 7.07505e-03, 8.86072e-03, 1.10971e-02,
 1.38979e-02, 1.74055e-02, 2.17985e-02, 2.73003e-02, 3.41906e-02,
 4.28199e-02, 5.36273e-02, 6.71622e-02, 8.41133e-02, 1.05343e-01,
 1.31930e-01, 1.65228e-01, 2.06930e-01, 2.59157e-01, 3.24565e-01,
 4.06482e-01, 5.09074e-01, 6.37560e-01, 7.98473e-01, 1.00000e+00}
,
{1.67796e-10, 2.10631e-10, 2.64400e-10, 3.31895e-10, 4.16621e-10,
 5.22974e-10, 6.56478e-10, 8.24061e-10, 1.03443e-09, 1.29849e-09,
 1.62997e-09, 2.04606e-09, 2.56837e-09, 3.22401e-09, 4.04703e-09,
 5.08015e-09, 6.37699e-09, 8.00489e-09, 1.00484e-08, 1.26135e-08,
 1.58334e-08, 1.98753e-08, 2.49490e-08, 3.13179e-08, 3.93126e-08,
 4.93483e-08, 6.19457e-08, 7.77591e-08, 9.76092e-08, 1.22527e-07,
 1.53805e-07, 1.93068e-07, 2.42353e-07, 3.04220e-07, 3.81881e-07,
 4.79366e-07, 6.01738e-07, 7.55347e-07, 9.48170e-07, 1.19022e-06,
 1.49405e-06, 1.87545e-06, 2.35421e-06, 2.95518e-06, 3.70957e-06,
 4.65654e-06, 5.84525e-06, 7.33740e-06, 9.21047e-06, 1.15617e-05,
 1.45131e-05, 1.82180e-05, 2.28686e-05, 2.87065e-05, 3.60346e-05,
 4.52334e-05, 5.67804e-05, 7.12751e-05, 8.94700e-05, 1.12310e-04,
 1.40980e-04, 1.76969e-04, 2.22145e-04, 2.78853e-04, 3.50038e-04,
 4.39395e-04, 5.51562e-04, 6.92363e-04, 8.69107e-04, 1.09097e-03,
 1.36947e-03, 1.71906e-03, 2.15790e-03, 2.70876e-03, 3.40025e-03,
 4.26825e-03, 5.35784e-03, 6.72558e-03, 8.44246e-03, 1.05976e-02,
 1.33030e-02, 1.66989e-02, 2.09617e-02, 2.63128e-02, 3.30298e-02,
 4.14616e-02, 5.20458e-02, 6.53319e-02, 8.20096e-02, 1.02945e-01,
 1.29224e-01, 1.62212e-01, 2.03621e-01, 2.55601e-01, 3.20850e-01,
 4.02756e-01, 5.05570e-01, 6.34630e-01, 7.96637e-01, 1.00000e+00}
,
{1.33593e-10, 1.68082e-10, 2.11476e-10, 2.66073e-10, 3.34766e-10,
 4.21192e-10, 5.29932e-10, 6.66745e-10, 8.38879e-10, 1.05545e-09,
 1.32794e-09, 1.67077e-09, 2.10212e-09, 2.64483e-09, 3.32764e-09,
 4.18674e-09, 5.26764e-09, 6.62758e-09, 8.33863e-09, 1.04914e-08,
 1.32000e-08, 1.66079e-08, 2.08955e-08, 2.62901e-08, 3.30775e-08,
 4.16171e-08, 5.23614e-08, 6.58796e-08, 8.28878e-08, 1.04287e-07,
 1.31211e-07, 1.65086e-07, 2.07706e-07, 2.61329e-07, 3.28797e-07,
 4.13683e-07, 5.20484e-07, 6.54857e-07, 8.23922e-07, 1.03663e-06,
 1.30426e-06, 1.64099e-06, 2.06464e-06, 2.59767e-06, 3.26831e-06,
 4.11210e-06, 5.17372e-06, 6.50942e-06, 8.18996e-06, 1.03044e-05,
 1.29647e-05, 1.63118e-05, 2.05230e-05, 2.58214e-05, 3.24877e-05,
 4.08751e-05, 5.14279e-05, 6.47050e-05, 8.14100e-05, 1.02428e-04,
 1.28871e-04, 1.62142e-04, 2.04003e-04, 2.56670e-04, 3.22935e-04,
 4.06307e-04, 5.11204e-04, 6.43182e-04, 8.09233e-04, 1.01815e-03,
 1.28101e-03, 1.61173e-03, 2.02783e-03, 2.55136e-03, 3.21004e-03,
 4.03878e-03, 5.08148e-03, 6.39336e-03, 8.04394e-03, 1.01207e-02,
 1.27335e-02, 1.60209e-02, 2.01571e-02, 2.53610e-02, 3.19085e-02,
 4.01463e-02, 5.05110e-02, 6.35514e-02, 7.99585e-02, 1.00601e-01,
 1.26574e-01, 1.59251e-01, 2.00366e-01, 2.52094e-01, 3.17177e-01,
 3.99063e-01, 5.02090e-01, 6.31715e-01, 7.94805e-01, 1.00000e+00}
,
{1.06361e-10, 1.34129e-10, 1.69146e-10, 2.13305e-10, 2.68993e-10,
 3.39219e-10, 4.27780e-10, 5.39460e-10, 6.80298e-10, 8.57904e-10,
 1.08188e-09, 1.36433e-09, 1.72051e-09, 2.16969e-09, 2.73613e-09,
 3.45045e-09, 4.35127e-09, 5.48726e-09, 6.91982e-09, 8.72639e-09,
 1.10046e-08, 1.38776e-08, 1.75006e-08, 2.20695e-08, 2.78312e-08,
 3.50971e-08, 4.42600e-08, 5.58150e-08, 7.03867e-08, 8.87626e-08,
 1.11936e-07, 1.41159e-07, 1.78012e-07, 2.24486e-07, 2.83092e-07,
 3.56999e-07, 4.50202e-07, 5.67736e-07, 7.15956e-07, 9.02871e-07,
 1.13858e-06, 1.43584e-06, 1.81069e-06, 2.28341e-06, 2.87954e-06,
 3.63131e-06, 4.57934e-06, 5.77487e-06, 7.28252e-06, 9.18378e-06,
 1.15814e-05, 1.46050e-05, 1.84179e-05, 2.32263e-05, 2.92900e-05,
 3.69368e-05, 4.65799e-05, 5.87406e-05, 7.40760e-05, 9.34151e-05,
 1.17803e-04, 1.48558e-04, 1.87342e-04, 2.36252e-04, 2.97931e-04,
 3.75712e-04, 4.73799e-04, 5.97494e-04, 7.53483e-04, 9.50195e-04,
 1.19826e-03, 1.51110e-03, 1.90560e-03, 2.40310e-03, 3.03048e-03,
 3.82164e-03, 4.81937e-03, 6.07756e-03, 7.66424e-03, 9.66515e-03,
 1.21884e-02, 1.53705e-02, 1.93833e-02, 2.44437e-02, 3.08252e-02,
 3.88728e-02, 4.90214e-02, 6.18195e-02, 7.79587e-02, 9.83115e-02,
 1.23978e-01, 1.56345e-01, 1.97162e-01, 2.48635e-01, 3.13547e-01,
 3.95405e-01, 4.98633e-01, 6.28812e-01, 7.92977e-01, 1.00000e+00}
,
{8.46803e-11, 1.07034e-10, 1.35289e-10, 1.71002e-10, 2.16143e-10,
 2.73200e-10, 3.45319e-10, 4.36475e-10, 5.51695e-10, 6.97331e-10,
 8.81411e-10, 1.11408e-09, 1.40818e-09, 1.77991e-09, 2.24976e-09,
 2.84365e-09, 3.59431e-09, 4.54313e-09, 5.74242e-09, 7.25829e-09,
 9.17432e-09, 1.15961e-08, 1.46573e-08, 1.85265e-08, 2.34171e-08,
 2.95986e-08, 3.74120e-08, 4.72880e-08, 5.97710e-08, 7.55492e-08,
 9.54926e-08, 1.20701e-07, 1.52563e-07, 1.92836e-07, 2.43741e-07,
 3.08083e-07, 3.89410e-07, 4.92206e-07, 6.22137e-07, 7.86368e-07,
 9.93952e-07, 1.25633e-06, 1.58798e-06, 2.00717e-06, 2.53702e-06,
 3.20674e-06, 4.05324e-06, 5.12321e-06, 6.47563e-06, 8.18505e-06,
 1.03457e-05, 1.30768e-05, 1.65288e-05, 2.08920e-05, 2.64070e-05,
 3.33779e-05, 4.21889e-05, 5.33259e-05, 6.74028e-05, 8.51956e-05,
 1.07685e-04, 1.36112e-04, 1.72043e-04, 2.17458e-04, 2.74862e-04,
 3.47420e-04, 4.39131e-04, 5.55052e-04, 7.01574e-04, 8.86774e-04,
 1.12086e-03, 1.41675e-03, 1.79074e-03, 2.26345e-03, 2.86095e-03,
 3.61618e-03, 4.57078e-03, 5.77736e-03, 7.30246e-03, 9.23015e-03,
 1.16667e-02, 1.47465e-02, 1.86392e-02, 2.35595e-02, 2.97787e-02,
 3.76397e-02, 4.75757e-02, 6.01347e-02, 7.60089e-02, 9.60737e-02,
 1.21435e-01, 1.53491e-01, 1.94010e-01, 2.45224e-01, 3.09958e-01,
 3.91780e-01, 4.95201e-01, 6.25923e-01, 7.91153e-01, 1.00000e+00}
,
{6.74190e-11, 8.54126e-11, 1.08209e-10, 1.37089e-10, 1.73676e-10,
 2.20029e-10, 2.78753e-10, 3.53150e-10, 4.47403e-10, 5.66812e-10,
 7.18089e-10, 9.09741e-10, 1.15254e-09, 1.46015e-09, 1.84985e-09,
 2.34356e-09, 2.96904e-09, 3.76145e-09, 4.76535e-09, 6.03718e-09,
 7.64846e-09, 9.68977e-09, 1.22759e-08, 1.55522e-08, 1.97030e-08,
 2.49616e-08, 3.16236e-08, 4.00637e-08, 5.07564e-08, 6.43028e-08,
 8.14647e-08, 1.03207e-07, 1.30752e-07, 1.65649e-07, 2.09859e-07,
 2.65869e-07, 3.36827e-07, 4.26724e-07, 5.40613e-07, 6.84898e-07,
 8.67692e-07, 1.09927e-06, 1.39266e-06, 1.76435e-06, 2.23524e-06,
 2.83180e-06, 3.58759e-06, 4.54509e-06, 5.75814e-06, 7.29494e-06,
 9.24190e-06, 1.17085e-05, 1.48334e-05, 1.87923e-05, 2.38078e-05,
 3.01619e-05, 3.82119e-05, 4.84103e-05, 6.13307e-05, 7.76993e-05,
 9.84366e-05, 1.24709e-04, 1.57992e-04, 2.00159e-04, 2.53580e-04,
 3.21258e-04, 4.07000e-04, 5.15625e-04, 6.53241e-04, 8.27586e-04,
 1.04846e-03, 1.32829e-03, 1.68280e-03, 2.13192e-03, 2.70091e-03,
 3.42177e-03, 4.33501e-03, 5.49199e-03, 6.95775e-03, 8.81472e-03,
 1.11673e-02, 1.41478e-02, 1.79237e-02, 2.27074e-02, 2.87678e-02,
 3.64457e-02, 4.61727e-02, 5.84959e-02, 7.41079e-02, 9.38867e-02,
 1.18944e-01, 1.50690e-01, 1.90908e-01, 2.41859e-01, 3.06409e-01,
 3.88188e-01, 4.91792e-01, 6.23047e-01, 7.89333e-01, 1.00000e+00}
,
{5.36763e-11, 6.81588e-11, 8.65489e-11, 1.09901e-10, 1.39554e-10,
 1.77207e-10, 2.25019e-10, 2.85732e-10, 3.62827e-10, 4.60722e-10,
 5.85030e-10, 7.42879e-10, 9.43316e-10, 1.19783e-09, 1.52103e-09,
 1.93142e-09, 2.45254e-09, 3.11426e-09, 3.95453e-09, 5.02151e-09,
 6.37638e-09, 8.09680e-09, 1.02814e-08, 1.30555e-08, 1.65780e-08,
 2.10510e-08, 2.67308e-08, 3.39431e-08, 4.31013e-08, 5.47306e-08,
 6.94976e-08, 8.82489e-08, 1.12060e-07, 1.42295e-07, 1.80687e-07,
 2.29439e-07, 2.91345e-07, 3.69953e-07, 4.69771e-07, 5.96521e-07,
 7.57470e-07, 9.61845e-07, 1.22136e-06, 1.55090e-06, 1.96935e-06,
 2.50071e-06, 3.17543e-06, 4.03220e-06, 5.12014e-06, 6.50162e-06,
 8.25584e-06, 1.04834e-05, 1.33119e-05, 1.69036e-05, 2.14644e-05,
 2.72558e-05, 3.46098e-05, 4.39479e-05, 5.58056e-05, 7.08626e-05,
 8.99822e-05, 1.14261e-04, 1.45089e-04, 1.84236e-04, 2.33946e-04,
 2.97067e-04, 3.77220e-04, 4.78998e-04, 6.08238e-04, 7.72348e-04,
 9.80737e-04, 1.24535e-03, 1.58136e-03, 2.00803e-03, 2.54983e-03,
 3.23780e-03, 4.11140e-03, 5.22071e-03, 6.62932e-03, 8.41799e-03,
 1.06893e-02, 1.35734e-02, 1.72356e-02, 2.18860e-02, 2.77911e-02,
 3.52895e-02, 4.48111e-02, 5.69017e-02, 7.22545e-02, 9.17496e-02,
 1.16505e-01, 1.47939e-01, 1.87855e-01, 2.38541e-01, 3.02902e-01,
 3.84629e-01, 4.88406e-01, 6.20184e-01, 7.87518e-01, 1.00000e+00}
,
{4.27349e-11, 5.43904e-11, 6.92248e-11, 8.81051e-11, 1.12135e-10,
 1.42719e-10, 1.81644e-10, 2.31185e-10, 2.94238e-10, 3.74489e-10,
 4.76627e-10, 6.06622e-10, 7.72071e-10, 9.82646e-10, 1.25065e-09,
 1.59175e-09, 2.02589e-09, 2.57843e-09, 3.28167e-09, 4.17671e-09,
 5.31587e-09, 6.76571e-09, 8.61099e-09, 1.09595e-08, 1.39487e-08,
 1.77530e-08, 2.25950e-08, 2.87575e-08, 3.66008e-08, 4.65833e-08,
 5.92884e-08, 7.54587e-08, 9.60393e-08, 1.22233e-07, 1.55571e-07,
 1.98001e-07, 2.52004e-07, 3.20735e-07, 4.08212e-07, 5.19548e-07,
 6.61250e-07, 8.41598e-07, 1.07114e-06, 1.36328e-06, 1.73510e-06,
 2.20833e-06, 2.81062e-06, 3.57719e-06, 4.55284e-06, 5.79457e-06,
 7.37498e-06, 9.38643e-06, 1.19465e-05, 1.52048e-05, 1.93517e-05,
 2.46297e-05, 3.13472e-05, 3.98968e-05, 5.07782e-05, 6.46275e-05,
 8.22540e-05, 1.04688e-04, 1.33240e-04, 1.69580e-04, 2.15832e-04,
 2.74697e-04, 3.49618e-04, 4.44973e-04, 5.66335e-04, 7.20797e-04,
 9.17387e-04, 1.16759e-03, 1.48604e-03, 1.89135e-03, 2.40719e-03,
 3.06373e-03, 3.89933e-03, 4.96283e-03, 6.31639e-03, 8.03912e-03,
 1.02317e-02, 1.30223e-02, 1.65740e-02, 2.10944e-02, 2.68477e-02,
 3.41701e-02, 4.34896e-02, 5.53510e-02, 7.04474e-02, 8.96611e-02,
 1.14115e-01, 1.45239e-01, 1.84852e-01, 2.35268e-01, 2.99435e-01,
 3.81102e-01, 4.85044e-01, 6.17335e-01, 7.85707e-01, 1.00000e+00}
,
{3.40238e-11, 4.34032e-11, 5.53684e-11, 7.06320e-11, 9.01033e-11,
 1.14942e-10, 1.46629e-10, 1.87051e-10, 2.38616e-10, 3.04396e-10,
 3.88310e-10, 4.95356e-10, 6.31913e-10, 8.06115e-10, 1.02834e-09,
 1.31183e-09, 1.67346e-09, 2.13479e-09, 2.72330e-09, 3.47404e-09,
 4.43174e-09, 5.65345e-09, 7.21196e-09, 9.20010e-09, 1.17363e-08,
 1.49717e-08, 1.90990e-08, 2.43641e-08, 3.10807e-08, 3.96488e-08,
 5.05789e-08, 6.45222e-08, 8.23093e-08, 1.05000e-07, 1.33945e-07,
 1.70871e-07, 2.17975e-07, 2.78065e-07, 3.54720e-07, 4.52508e-07,
 5.77252e-07, 7.36385e-07, 9.39387e-07, 1.19835e-06, 1.52870e-06,
 1.95013e-06, 2.48773e-06, 3.17353e-06, 4.04839e-06, 5.16442e-06,
 6.58811e-06, 8.40428e-06, 1.07211e-05, 1.36767e-05, 1.74469e-05,
 2.22566e-05, 2.83922e-05, 3.62191e-05, 4.62038e-05, 5.89410e-05,
 7.51894e-05, 9.59172e-05, 1.22359e-04, 1.56090e-04, 1.99120e-04,
 2.54012e-04, 3.24037e-04, 4.13365e-04, 5.27319e-04, 6.72687e-04,
 8.58129e-04, 1.09469e-03, 1.39647e-03, 1.78144e-03, 2.27254e-03,
 2.89901e-03, 3.69820e-03, 4.71769e-03, 6.01823e-03, 7.67730e-03,
 9.79373e-03, 1.24936e-02, 1.59378e-02, 2.03314e-02, 2.59362e-02,
 3.30861e-02, 4.22071e-02, 5.38425e-02, 6.86854e-02, 8.76202e-02,
 1.11775e-01, 1.42588e-01, 1.81896e-01, 2.32040e-01, 2.96007e-01,
 3.77608e-01, 4.81705e-01, 6.14499e-01, 7.83900e-01, 1.00000e+00}
,
{2.70884e-11, 3.46356e-11, 4.42855e-11, 5.66241e-11, 7.24004e-11,
 9.25722e-11, 1.18364e-10, 1.51342e-10, 1.93508e-10, 2.47422e-10,
 3.16358e-10, 4.04499e-10, 5.17199e-10, 6.61298e-10, 8.45545e-10,
 1.08113e-09, 1.38234e-09, 1.76748e-09, 2.25993e-09, 2.88958e-09,
 3.69466e-09, 4.72404e-09, 6.04023e-09, 7.72312e-09, 9.87489e-09,
 1.26262e-08, 1.61440e-08, 2.06420e-08, 2.63931e-08, 3.37466e-08,
 4.31489e-08, 5.51708e-08, 7.05422e-08, 9.01962e-08, 1.15326e-07,
 1.47458e-07, 1.88542e-07, 2.41072e-07, 3.08238e-07, 3.94118e-07,
 5.03924e-07, 6.44325e-07, 8.23843e-07, 1.05338e-06, 1.34686e-06,
 1.72212e-06, 2.20193e-06, 2.81541e-06, 3.59983e-06, 4.60279e-06,
 5.88520e-06, 7.52490e-06, 9.62144e-06, 1.23021e-05, 1.57297e-05,
 2.01122e-05, 2.57157e-05, 3.28805e-05, 4.20414e-05, 5.37548e-05,
 6.87317e-05, 8.78813e-05, 1.12366e-04, 1.43673e-04, 1.83702e-04,
 2.34885e-04, 3.00327e-04, 3.84002e-04, 4.90991e-04, 6.27788e-04,
 8.02699e-04, 1.02634e-03, 1.31230e-03, 1.67792e-03, 2.14541e-03,
 2.74315e-03, 3.50744e-03, 4.48466e-03, 5.73415e-03, 7.33177e-03,
 9.37450e-03, 1.19864e-02, 1.53259e-02, 1.95960e-02, 2.50557e-02,
 3.20366e-02, 4.09624e-02, 5.23751e-02, 6.69676e-02, 8.56257e-02,
 1.09482e-01, 1.39986e-01, 1.78988e-01, 2.28856e-01, 2.92619e-01,
 3.74147e-01, 4.78389e-01, 6.11675e-01, 7.82097e-01, 1.00000e+00}
,
{2.15666e-11, 2.76390e-11, 3.54211e-11, 4.53943e-11, 5.81756e-11,
 7.45556e-11, 9.55476e-11, 1.22450e-10, 1.56928e-10, 2.01112e-10,
 2.57738e-10, 3.30307e-10, 4.23309e-10, 5.42497e-10, 6.95243e-10,
 8.90997e-10, 1.14187e-09, 1.46337e-09, 1.87540e-09, 2.40345e-09,
 3.08016e-09, 3.94742e-09, 5.05887e-09, 6.48325e-09, 8.30868e-09,
 1.06481e-08, 1.36462e-08, 1.74884e-08, 2.24125e-08, 2.87230e-08,
 3.68103e-08, 4.71747e-08, 6.04573e-08, 7.74798e-08, 9.92951e-08,
 1.27253e-07, 1.63082e-07, 2.09000e-07, 2.67847e-07, 3.43262e-07,
 4.39912e-07, 5.63774e-07, 7.22511e-07, 9.25943e-07, 1.18665e-06,
 1.52077e-06, 1.94896e-06, 2.49771e-06, 3.20097e-06, 4.10224e-06,
 5.25728e-06, 6.73753e-06, 8.63456e-06, 1.10657e-05, 1.41814e-05,
 1.81744e-05, 2.32916e-05, 2.98496e-05, 3.82541e-05, 4.90250e-05,
 6.28285e-05, 8.05186e-05, 1.03190e-04, 1.32244e-04, 1.69479e-04,
 2.17197e-04, 2.78352e-04, 3.56725e-04, 4.57165e-04, 5.85886e-04,
 7.50849e-04, 9.62259e-04, 1.23319e-03, 1.58042e-03, 2.02540e-03,
 2.59568e-03, 3.32652e-03, 4.26314e-03, 5.46348e-03, 7.00178e-03,
 8.97322e-03, 1.14997e-02, 1.47376e-02, 1.88872e-02, 2.42051e-02,
 3.10203e-02, 3.97544e-02, 5.09478e-02, 6.52927e-02, 8.36767e-02,
 1.07237e-01, 1.37431e-01, 1.76126e-01, 2.25716e-01, 2.89269e-01,
 3.70716e-01, 4.75096e-01, 6.08865e-01, 7.80298e-01, 1.00000e+00}
,
{1.71705e-11, 2.20558e-11, 2.83310e-11, 3.63916e-11, 4.67456e-11,
 6.00455e-11, 7.71294e-11, 9.90740e-11, 1.27262e-10, 1.63470e-10,
 2.09980e-10, 2.69723e-10, 3.46463e-10, 4.45038e-10, 5.71658e-10,
 7.34304e-10, 9.43226e-10, 1.21159e-09, 1.55631e-09, 1.99910e-09,
 2.56788e-09, 3.29848e-09, 4.23695e-09, 5.44243e-09, 6.99089e-09,
 8.97991e-09, 1.15348e-08, 1.48167e-08, 1.90323e-08, 2.44473e-08,
 3.14029e-08, 4.03375e-08, 5.18142e-08, 6.65562e-08, 8.54925e-08,
 1.09816e-07, 1.41061e-07, 1.81195e-07, 2.32748e-07, 2.98969e-07,
 3.84030e-07, 4.93293e-07, 6.33643e-07, 8.13924e-07, 1.04550e-06,
 1.34296e-06, 1.72505e-06, 2.21586e-06, 2.84631e-06, 3.65613e-06,
 4.69636e-06, 6.03255e-06, 7.74890e-06, 9.95359e-06, 1.27855e-05,
 1.64232e-05, 2.10959e-05, 2.70981e-05, 3.48079e-05, 4.47113e-05,
 5.74324e-05, 7.37728e-05, 9.47624e-05, 1.21724e-04, 1.56356e-04,
 2.00842e-04, 2.57985e-04, 3.31386e-04, 4.25670e-04, 5.46780e-04,
 7.02348e-04, 9.02178e-04, 1.15886e-03, 1.48858e-03, 1.91210e-03,
 2.45612e-03, 3.15493e-03, 4.05256e-03, 5.20558e-03, 6.68665e-03,
 8.58911e-03, 1.10329e-02, 1.41719e-02, 1.82040e-02, 2.33833e-02,
 3.00363e-02, 3.85821e-02, 4.95593e-02, 6.36597e-02, 8.17719e-02,
 1.05037e-01, 1.34922e-01, 1.73310e-01, 2.22619e-01, 2.85958e-01,
 3.67318e-01, 4.71825e-01, 6.06067e-01, 7.78503e-01, 1.00000e+00}
,
{1.36704e-11, 1.76004e-11, 2.26601e-11, 2.91744e-11, 3.75613e-11,
 4.83593e-11, 6.22616e-11, 8.01603e-11, 1.03205e-10, 1.32874e-10,
 1.71072e-10, 2.20251e-10, 2.83568e-10, 3.65088e-10, 4.70042e-10,
 6.05168e-10, 7.79140e-10, 1.00313e-09, 1.29150e-09, 1.66278e-09,
 2.14079e-09, 2.75622e-09, 3.54857e-09, 4.56870e-09, 5.88210e-09,
 7.57307e-09, 9.75015e-09, 1.25531e-08, 1.61618e-08, 2.08080e-08,
 2.67898e-08, 3.44913e-08, 4.44067e-08, 5.71727e-08, 7.36085e-08,
 9.47693e-08, 1.22013e-07, 1.57089e-07, 2.02249e-07, 2.60391e-07,
 3.35247e-07, 4.31623e-07, 5.55705e-07, 7.15458e-07, 9.21136e-07,
 1.18594e-06, 1.52687e-06, 1.96581e-06, 2.53094e-06, 3.25853e-06,
 4.19528e-06, 5.40133e-06, 6.95409e-06, 8.95323e-06, 1.15271e-05,
 1.48409e-05, 1.91073e-05, 2.46002e-05, 3.16722e-05, 4.07772e-05,
 5.24997e-05, 6.75922e-05, 8.70234e-05, 1.12041e-04, 1.44250e-04,
 1.85718e-04, 2.39108e-04, 3.07846e-04, 3.96345e-04, 5.10285e-04,
 6.56980e-04, 8.45847e-04, 1.08901e-03, 1.40207e-03, 1.80514e-03,
 2.32408e-03, 2.99220e-03, 3.85238e-03, 4.95986e-03, 6.38570e-03,
 8.22145e-03, 1.05849e-02, 1.36278e-02, 1.75455e-02, 2.25895e-02,
 2.90835e-02, 3.74443e-02, 4.82087e-02, 6.20676e-02, 7.99106e-02,
 1.02883e-01, 1.32460e-01, 1.70539e-01, 2.19565e-01, 2.82685e-01,
 3.63950e-01, 4.68577e-01, 6.03283e-01, 7.76713e-01, 1.00000e+00}
,
{1.08839e-11, 1.40450e-11, 1.81243e-11, 2.33884e-11, 3.01815e-11,
 3.89476e-11, 5.02597e-11, 6.48574e-11, 8.36949e-11, 1.08004e-10,
 1.39373e-10, 1.79853e-10, 2.32091e-10, 2.99500e-10, 3.86488e-10,
 4.98742e-10, 6.43600e-10, 8.30530e-10, 1.07175e-09, 1.38304e-09,
 1.78474e-09, 2.30310e-09, 2.97203e-09, 3.83524e-09, 4.94917e-09,
 6.38663e-09, 8.24160e-09, 1.06353e-08, 1.37243e-08, 1.77105e-08,
 2.28544e-08, 2.94923e-08, 3.80583e-08, 4.91121e-08, 6.33765e-08,
 8.17838e-08, 1.05538e-07, 1.36190e-07, 1.75746e-07, 2.26791e-07,
 2.92661e-07, 3.77663e-07, 4.87354e-07, 6.28904e-07, 8.11566e-07,
 1.04728e-06, 1.35146e-06, 1.74398e-06, 2.25052e-06, 2.90417e-06,
 3.74767e-06, 4.83616e-06, 6.24080e-06, 8.05341e-06, 1.03925e-05,
 1.34109e-05, 1.73061e-05, 2.23325e-05, 2.88189e-05, 3.71892e-05,
 4.79907e-05, 6.19293e-05, 7.99164e-05, 1.03128e-04, 1.33081e-04,
 1.71733e-04, 2.21612e-04, 2.85979e-04, 3.69040e-04, 4.76226e-04,
 6.14543e-04, 7.93034e-04, 1.02337e-03, 1.32060e-03, 1.70416e-03,
 2.19913e-03, 2.83785e-03, 3.66209e-03, 4.72573e-03, 6.09830e-03,
 7.86952e-03, 1.01552e-02, 1.31047e-02, 1.69109e-02, 2.18226e-02,
 2.81609e-02, 3.63401e-02, 4.68949e-02, 6.05152e-02, 7.80916e-02,
 1.00773e-01, 1.30042e-01, 1.67812e-01, 2.16552e-01, 2.79449e-01,
 3.60613e-01, 4.65352e-01, 6.00511e-01, 7.74926e-01, 1.00000e+00}
,
{8.66528e-12, 1.12078e-11, 1.44965e-11, 1.87500e-11, 2.42516e-11,
 3.13675e-11, 4.05714e-11, 5.24759e-11, 6.78733e-11, 8.77887e-11,
 1.13548e-10, 1.46865e-10, 1.89958e-10, 2.45695e-10, 3.17787e-10,
 4.11032e-10, 5.31638e-10, 6.87631e-10, 8.89395e-10, 1.15036e-09,
 1.48790e-09, 1.92448e-09, 2.48916e-09, 3.21953e-09, 4.16421e-09,
 5.38607e-09, 6.96645e-09, 9.01054e-09, 1.16544e-08, 1.50741e-08,
 1.94971e-08, 2.52179e-08, 3.26174e-08, 4.21879e-08, 5.45667e-08,
 7.05777e-08, 9.12866e-08, 1.18072e-07, 1.52717e-07, 1.97527e-07,
 2.55485e-07, 3.30449e-07, 4.27410e-07, 5.52820e-07, 7.15029e-07,
 9.24833e-07, 1.19620e-06, 1.54719e-06, 2.00116e-06, 2.58834e-06,
 3.34781e-06, 4.33013e-06, 5.60067e-06, 7.24402e-06, 9.36956e-06,
 1.21188e-05, 1.56747e-05, 2.02739e-05, 2.62227e-05, 3.39170e-05,
 4.38689e-05, 5.67409e-05, 7.33898e-05, 9.49239e-05, 1.22776e-04,
 1.58802e-04, 2.05397e-04, 2.65665e-04, 3.43616e-04, 4.44440e-04,
 5.74847e-04, 7.43519e-04, 9.61682e-04, 1.24386e-03, 1.60883e-03,
 2.08090e-03, 2.69147e-03, 3.48120e-03, 4.50266e-03, 5.82383e-03,
 7.53266e-03, 9.74289e-03, 1.26016e-02, 1.62992e-02, 2.10817e-02,
 2.72675e-02, 3.52684e-02, 4.56168e-02, 5.90017e-02, 7.63140e-02,
 9.87061e-02, 1.27668e-01, 1.65129e-01, 2.13581e-01, 2.76250e-01,
 3.57307e-01, 4.62148e-01, 5.97752e-01, 7.73144e-01, 1.00000e+00}
,
{6.89894e-12, 8.94380e-12, 1.15948e-11, 1.50315e-11, 1.94868e-11,
 2.52627e-11, 3.27507e-11, 4.24580e-11, 5.50426e-11, 7.13573e-11,
 9.25078e-11, 1.19927e-10, 1.55474e-10, 2.01557e-10, 2.61298e-10,
 3.38748e-10, 4.39153e-10, 5.69318e-10, 7.38065e-10, 9.56829e-10,
 1.24043e-09, 1.60810e-09, 2.08475e-09, 2.70267e-09, 3.50374e-09,
 4.54226e-09, 5.88859e-09, 7.63398e-09, 9.89670e-09, 1.28301e-08,
 1.66330e-08, 2.15630e-08, 2.79543e-08, 3.62400e-08, 4.69816e-08,
 6.09070e-08, 7.89600e-08, 1.02364e-07, 1.32705e-07, 1.72039e-07,
 2.23031e-07, 2.89138e-07, 3.74839e-07, 4.85942e-07, 6.29975e-07,
 8.16701e-07, 1.05877e-06, 1.37259e-06, 1.77943e-06, 2.30686e-06,
 2.99062e-06, 3.87704e-06, 5.02621e-06, 6.51598e-06, 8.44733e-06,
 1.09511e-05, 1.41971e-05, 1.84051e-05, 2.38604e-05, 3.09327e-05,
 4.01011e-05, 5.19872e-05, 6.73963e-05, 8.73726e-05, 1.13270e-04,
 1.46843e-04, 1.90368e-04, 2.46794e-04, 3.19944e-04, 4.14775e-04,
 5.37715e-04, 6.97095e-04, 9.03715e-04, 1.17158e-03, 1.51884e-03,
 1.96902e-03, 2.55264e-03, 3.30925e-03, 4.29012e-03, 5.56171e-03,
 7.21021e-03, 9.34733e-03, 1.21179e-02, 1.57097e-02, 2.03660e-02,
 2.64026e-02, 3.42283e-02, 4.43737e-02, 5.75261e-02, 7.45769e-02,
 9.66816e-02, 1.25338e-01, 1.62489e-01, 2.10651e-01, 2.73088e-01,
 3.54031e-01, 4.58967e-01, 5.95005e-01, 7.71366e-01, 1.00000e+00}
,
{5.49266e-12, 7.13711e-12, 9.27389e-12, 1.20504e-11, 1.56582e-11,
 2.03461e-11, 2.64375e-11, 3.43526e-11, 4.46374e-11, 5.80014e-11,
 7.53665e-11, 9.79305e-11, 1.27250e-10, 1.65347e-10, 2.14851e-10,
 2.79175e-10, 3.62757e-10, 4.71363e-10, 6.12484e-10, 7.95856e-10,
 1.03413e-09, 1.34373e-09, 1.74604e-09, 2.26878e-09, 2.94803e-09,
 3.83064e-09, 4.97750e-09, 6.46772e-09, 8.40409e-09, 1.09202e-08,
 1.41896e-08, 1.84378e-08, 2.39579e-08, 3.11307e-08, 4.04509e-08,
 5.25615e-08, 6.82979e-08, 8.87456e-08, 1.15315e-07, 1.49839e-07,
 1.94700e-07, 2.52991e-07, 3.28734e-07, 4.27154e-07, 5.55039e-07,
 7.21212e-07, 9.37136e-07, 1.21771e-06, 1.58227e-06, 2.05599e-06,
 2.67154e-06, 3.47137e-06, 4.51066e-06, 5.86111e-06, 7.61587e-06,
 9.89598e-06, 1.28587e-05, 1.67085e-05, 2.17109e-05, 2.82109e-05,
 3.66570e-05, 4.76317e-05, 6.18922e-05, 8.04221e-05, 1.04500e-04,
 1.35786e-04, 1.76439e-04, 2.29263e-04, 2.97902e-04, 3.87091e-04,
 5.02982e-04, 6.53570e-04, 8.49242e-04, 1.10350e-03, 1.43387e-03,
 1.86316e-03, 2.42097e-03, 3.14579e-03, 4.08761e-03, 5.31140e-03,
 6.90157e-03, 8.96784e-03, 1.16527e-02, 1.51414e-02, 1.96746e-02,
 2.55650e-02, 3.32189e-02, 4.31643e-02, 5.60873e-02, 7.28793e-02,
 9.46987e-02, 1.23051e-01, 1.59891e-01, 2.07760e-01, 2.69962e-01,
 3.50786e-01, 4.55807e-01, 5.92272e-01, 7.69592e-01, 1.00000e+00}
,
{4.37303e-12, 5.69537e-12, 7.41757e-12, 9.66054e-12, 1.25817e-11,
 1.63863e-11, 2.13413e-11, 2.77945e-11, 3.61992e-11, 4.71453e-11,
 6.14014e-11, 7.99683e-11, 1.04150e-10, 1.35643e-10, 1.76659e-10,
 2.30079e-10, 2.99651e-10, 3.90261e-10, 5.08270e-10, 6.61964e-10,
 8.62132e-10, 1.12283e-09, 1.46236e-09, 1.90455e-09, 2.48046e-09,
 3.23052e-09, 4.20738e-09, 5.47963e-09, 7.13659e-09, 9.29459e-09,
 1.21051e-08, 1.57656e-08, 2.05328e-08, 2.67417e-08, 3.48280e-08,
 4.53594e-08, 5.90755e-08, 7.69390e-08, 1.00204e-07, 1.30505e-07,
 1.69967e-07, 2.21363e-07, 2.88300e-07, 3.75478e-07, 4.89017e-07,
 6.36888e-07, 8.29474e-07, 1.08030e-06, 1.40696e-06, 1.83241e-06,
 2.38650e-06, 3.10814e-06, 4.04800e-06, 5.27205e-06, 6.86625e-06,
 8.94250e-06, 1.16466e-05, 1.51683e-05, 1.97550e-05, 2.57287e-05,
 3.35086e-05, 4.36412e-05, 5.68376e-05, 7.40245e-05, 9.64084e-05,
 1.25561e-04, 1.63529e-04, 2.12978e-04, 2.77379e-04, 3.61254e-04,
 4.70492e-04, 6.12762e-04, 7.98053e-04, 1.03937e-03, 1.35366e-03,
 1.76299e-03, 2.29610e-03, 2.99040e-03, 3.89466e-03, 5.07234e-03,
 6.60615e-03, 8.60375e-03, 1.12054e-02, 1.45937e-02, 1.90067e-02,
 2.47540e-02, 3.22393e-02, 4.19880e-02, 5.46846e-02, 7.12204e-02,
 9.27564e-02, 1.20805e-01, 1.57334e-01, 2.04910e-01, 2.66871e-01,
 3.47570e-01, 4.52670e-01, 5.89550e-01, 7.67822e-01, 1.00000e+00}
,
{3.48163e-12, 4.54488e-12, 5.93283e-12, 7.74464e-12, 1.01098e-11,
 1.31972e-11, 1.72274e-11, 2.24885e-11, 2.93562e-11, 3.83212e-11,
 5.00240e-11, 6.53007e-11, 8.52427e-11, 1.11275e-10, 1.45257e-10,
 1.89617e-10, 2.47523e-10, 3.23114e-10, 4.21789e-10, 5.50598e-10,
 7