# coding: utf-8

"""
    Messente API

    [Messente](https://messente.com) is a global provider of messaging and user verification services.  * Send and receive SMS, Viber, WhatsApp and Telegram messages. * Manage contacts and groups. * Fetch detailed info about phone numbers. * Blacklist phone numbers to make sure you're not sending any unwanted messages.  Messente builds [tools](https://messente.com/documentation) to help organizations connect their services to people anywhere in the world.  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Contact: messente@messente.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from messente_api.configuration import Configuration


class SyncNumberLookupResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'number': 'str',
        'roaming': 'bool',
        'ported': 'bool',
        'roaming_network': 'MobileNetwork',
        'current_network': 'MobileNetwork',
        'original_network': 'MobileNetwork',
        'ported_network': 'MobileNetwork',
        'status': 'str',
        'error': 'object'
    }

    attribute_map = {
        'number': 'number',
        'roaming': 'roaming',
        'ported': 'ported',
        'roaming_network': 'roamingNetwork',
        'current_network': 'currentNetwork',
        'original_network': 'originalNetwork',
        'ported_network': 'portedNetwork',
        'status': 'status',
        'error': 'error'
    }

    def __init__(self, number=None, roaming=None, ported=None, roaming_network=None, current_network=None, original_network=None, ported_network=None, status=None, error=None, local_vars_configuration=None):  # noqa: E501
        """SyncNumberLookupResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._number = None
        self._roaming = None
        self._ported = None
        self._roaming_network = None
        self._current_network = None
        self._original_network = None
        self._ported_network = None
        self._status = None
        self._error = None
        self.discriminator = None

        self.number = number
        self.roaming = roaming
        self.ported = ported
        self.roaming_network = roaming_network
        self.current_network = current_network
        self.original_network = original_network
        self.ported_network = ported_network
        if status is not None:
            self.status = status
        if error is not None:
            self.error = error

    @property
    def number(self):
        """Gets the number of this SyncNumberLookupResult.  # noqa: E501

        Phone number in e.164 format  # noqa: E501

        :return: The number of this SyncNumberLookupResult.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this SyncNumberLookupResult.

        Phone number in e.164 format  # noqa: E501

        :param number: The number of this SyncNumberLookupResult.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and number is None:  # noqa: E501
            raise ValueError("Invalid value for `number`, must not be `None`")  # noqa: E501

        self._number = number

    @property
    def roaming(self):
        """Gets the roaming of this SyncNumberLookupResult.  # noqa: E501

        Indicates if a number is roaming  # noqa: E501

        :return: The roaming of this SyncNumberLookupResult.  # noqa: E501
        :rtype: bool
        """
        return self._roaming

    @roaming.setter
    def roaming(self, roaming):
        """Sets the roaming of this SyncNumberLookupResult.

        Indicates if a number is roaming  # noqa: E501

        :param roaming: The roaming of this SyncNumberLookupResult.  # noqa: E501
        :type: bool
        """

        self._roaming = roaming

    @property
    def ported(self):
        """Gets the ported of this SyncNumberLookupResult.  # noqa: E501

        Indicates if a number is ported  # noqa: E501

        :return: The ported of this SyncNumberLookupResult.  # noqa: E501
        :rtype: bool
        """
        return self._ported

    @ported.setter
    def ported(self, ported):
        """Sets the ported of this SyncNumberLookupResult.

        Indicates if a number is ported  # noqa: E501

        :param ported: The ported of this SyncNumberLookupResult.  # noqa: E501
        :type: bool
        """

        self._ported = ported

    @property
    def roaming_network(self):
        """Gets the roaming_network of this SyncNumberLookupResult.  # noqa: E501


        :return: The roaming_network of this SyncNumberLookupResult.  # noqa: E501
        :rtype: MobileNetwork
        """
        return self._roaming_network

    @roaming_network.setter
    def roaming_network(self, roaming_network):
        """Sets the roaming_network of this SyncNumberLookupResult.


        :param roaming_network: The roaming_network of this SyncNumberLookupResult.  # noqa: E501
        :type: MobileNetwork
        """

        self._roaming_network = roaming_network

    @property
    def current_network(self):
        """Gets the current_network of this SyncNumberLookupResult.  # noqa: E501


        :return: The current_network of this SyncNumberLookupResult.  # noqa: E501
        :rtype: MobileNetwork
        """
        return self._current_network

    @current_network.setter
    def current_network(self, current_network):
        """Sets the current_network of this SyncNumberLookupResult.


        :param current_network: The current_network of this SyncNumberLookupResult.  # noqa: E501
        :type: MobileNetwork
        """

        self._current_network = current_network

    @property
    def original_network(self):
        """Gets the original_network of this SyncNumberLookupResult.  # noqa: E501


        :return: The original_network of this SyncNumberLookupResult.  # noqa: E501
        :rtype: MobileNetwork
        """
        return self._original_network

    @original_network.setter
    def original_network(self, original_network):
        """Sets the original_network of this SyncNumberLookupResult.


        :param original_network: The original_network of this SyncNumberLookupResult.  # noqa: E501
        :type: MobileNetwork
        """

        self._original_network = original_network

    @property
    def ported_network(self):
        """Gets the ported_network of this SyncNumberLookupResult.  # noqa: E501


        :return: The ported_network of this SyncNumberLookupResult.  # noqa: E501
        :rtype: MobileNetwork
        """
        return self._ported_network

    @ported_network.setter
    def ported_network(self, ported_network):
        """Sets the ported_network of this SyncNumberLookupResult.


        :param ported_network: The ported_network of this SyncNumberLookupResult.  # noqa: E501
        :type: MobileNetwork
        """

        self._ported_network = ported_network

    @property
    def status(self):
        """Gets the status of this SyncNumberLookupResult.  # noqa: E501

        Status of the phone number  # noqa: E501

        :return: The status of this SyncNumberLookupResult.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SyncNumberLookupResult.

        Status of the phone number  # noqa: E501

        :param status: The status of this SyncNumberLookupResult.  # noqa: E501
        :type: str
        """
        allowed_values = ["ON", "OFF", "INVALID", "UNKNOWN"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def error(self):
        """Gets the error of this SyncNumberLookupResult.  # noqa: E501

        Indicates if any error occurred while handling the request  # noqa: E501

        :return: The error of this SyncNumberLookupResult.  # noqa: E501
        :rtype: object
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this SyncNumberLookupResult.

        Indicates if any error occurred while handling the request  # noqa: E501

        :param error: The error of this SyncNumberLookupResult.  # noqa: E501
        :type: object
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SyncNumberLookupResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SyncNumberLookupResult):
            return True

        return self.to_dict() != other.to_dict()
