# coding: utf-8

"""
    Messente API

    [Messente](https://messente.com) is a global provider of messaging and user verification services.  * Send and receive SMS, Viber, WhatsApp and Telegram messages. * Manage contacts and groups. * Fetch detailed info about phone numbers. * Blacklist phone numbers to make sure you're not sending any unwanted messages.  Messente builds [tools](https://messente.com/documentation) to help organizations connect their services to people anywhere in the world.  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Contact: messente@messente.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from messente_api.configuration import Configuration


class StatisticsReportSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'start_date': 'date',
        'end_date': 'date',
        'message_types': 'list[str]'
    }

    attribute_map = {
        'start_date': 'start_date',
        'end_date': 'end_date',
        'message_types': 'message_types'
    }

    def __init__(self, start_date=None, end_date=None, message_types=None, local_vars_configuration=None):  # noqa: E501
        """StatisticsReportSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._start_date = None
        self._end_date = None
        self._message_types = None
        self.discriminator = None

        self.start_date = start_date
        self.end_date = end_date
        if message_types is not None:
            self.message_types = message_types

    @property
    def start_date(self):
        """Gets the start_date of this StatisticsReportSettings.  # noqa: E501

        Start date for the report  # noqa: E501

        :return: The start_date of this StatisticsReportSettings.  # noqa: E501
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this StatisticsReportSettings.

        Start date for the report  # noqa: E501

        :param start_date: The start_date of this StatisticsReportSettings.  # noqa: E501
        :type: date
        """
        if self.local_vars_configuration.client_side_validation and start_date is None:  # noqa: E501
            raise ValueError("Invalid value for `start_date`, must not be `None`")  # noqa: E501

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this StatisticsReportSettings.  # noqa: E501

        End date for the report  # noqa: E501

        :return: The end_date of this StatisticsReportSettings.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this StatisticsReportSettings.

        End date for the report  # noqa: E501

        :param end_date: The end_date of this StatisticsReportSettings.  # noqa: E501
        :type: date
        """
        if self.local_vars_configuration.client_side_validation and end_date is None:  # noqa: E501
            raise ValueError("Invalid value for `end_date`, must not be `None`")  # noqa: E501

        self._end_date = end_date

    @property
    def message_types(self):
        """Gets the message_types of this StatisticsReportSettings.  # noqa: E501

        Optional list of message types (sms, viber, whatsapp, hlr)  # noqa: E501

        :return: The message_types of this StatisticsReportSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._message_types

    @message_types.setter
    def message_types(self, message_types):
        """Sets the message_types of this StatisticsReportSettings.

        Optional list of message types (sms, viber, whatsapp, hlr)  # noqa: E501

        :param message_types: The message_types of this StatisticsReportSettings.  # noqa: E501
        :type: list[str]
        """

        self._message_types = message_types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatisticsReportSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatisticsReportSettings):
            return True

        return self.to_dict() != other.to_dict()
