# coding: utf-8

"""
    Messente API

    [Messente](https://messente.com) is a global provider of messaging and user verification services.  * Send and receive SMS, Viber, WhatsApp and Telegram messages. * Manage contacts and groups. * Fetch detailed info about phone numbers. * Blacklist phone numbers to make sure you're not sending any unwanted messages.  Messente builds [tools](https://messente.com/documentation) to help organizations connect their services to people anywhere in the world.  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Contact: messente@messente.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from messente_api.configuration import Configuration


class MobileNetwork(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'mccmnc': 'str',
        'network_name': 'str',
        'country_name': 'str',
        'country_prefix': 'str',
        'country_code': 'str'
    }

    attribute_map = {
        'mccmnc': 'mccmnc',
        'network_name': 'networkName',
        'country_name': 'countryName',
        'country_prefix': 'countryPrefix',
        'country_code': 'countryCode'
    }

    def __init__(self, mccmnc=None, network_name=None, country_name=None, country_prefix=None, country_code=None, local_vars_configuration=None):  # noqa: E501
        """MobileNetwork - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._mccmnc = None
        self._network_name = None
        self._country_name = None
        self._country_prefix = None
        self._country_code = None
        self.discriminator = None

        if mccmnc is not None:
            self.mccmnc = mccmnc
        if network_name is not None:
            self.network_name = network_name
        if country_name is not None:
            self.country_name = country_name
        if country_prefix is not None:
            self.country_prefix = country_prefix
        if country_code is not None:
            self.country_code = country_code

    @property
    def mccmnc(self):
        """Gets the mccmnc of this MobileNetwork.  # noqa: E501

        Mobile country and mobile network code  # noqa: E501

        :return: The mccmnc of this MobileNetwork.  # noqa: E501
        :rtype: str
        """
        return self._mccmnc

    @mccmnc.setter
    def mccmnc(self, mccmnc):
        """Sets the mccmnc of this MobileNetwork.

        Mobile country and mobile network code  # noqa: E501

        :param mccmnc: The mccmnc of this MobileNetwork.  # noqa: E501
        :type: str
        """

        self._mccmnc = mccmnc

    @property
    def network_name(self):
        """Gets the network_name of this MobileNetwork.  # noqa: E501

        Mobile network name  # noqa: E501

        :return: The network_name of this MobileNetwork.  # noqa: E501
        :rtype: str
        """
        return self._network_name

    @network_name.setter
    def network_name(self, network_name):
        """Sets the network_name of this MobileNetwork.

        Mobile network name  # noqa: E501

        :param network_name: The network_name of this MobileNetwork.  # noqa: E501
        :type: str
        """

        self._network_name = network_name

    @property
    def country_name(self):
        """Gets the country_name of this MobileNetwork.  # noqa: E501

        Country name  # noqa: E501

        :return: The country_name of this MobileNetwork.  # noqa: E501
        :rtype: str
        """
        return self._country_name

    @country_name.setter
    def country_name(self, country_name):
        """Sets the country_name of this MobileNetwork.

        Country name  # noqa: E501

        :param country_name: The country_name of this MobileNetwork.  # noqa: E501
        :type: str
        """

        self._country_name = country_name

    @property
    def country_prefix(self):
        """Gets the country_prefix of this MobileNetwork.  # noqa: E501

        Country prefix  # noqa: E501

        :return: The country_prefix of this MobileNetwork.  # noqa: E501
        :rtype: str
        """
        return self._country_prefix

    @country_prefix.setter
    def country_prefix(self, country_prefix):
        """Sets the country_prefix of this MobileNetwork.

        Country prefix  # noqa: E501

        :param country_prefix: The country_prefix of this MobileNetwork.  # noqa: E501
        :type: str
        """

        self._country_prefix = country_prefix

    @property
    def country_code(self):
        """Gets the country_code of this MobileNetwork.  # noqa: E501

        Country code  # noqa: E501

        :return: The country_code of this MobileNetwork.  # noqa: E501
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """Sets the country_code of this MobileNetwork.

        Country code  # noqa: E501

        :param country_code: The country_code of this MobileNetwork.  # noqa: E501
        :type: str
        """

        self._country_code = country_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MobileNetwork):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MobileNetwork):
            return True

        return self.to_dict() != other.to_dict()
