# coding: utf-8

"""
    Messente API

    [Messente](https://messente.com) is a global provider of messaging and user verification services.  * Send and receive SMS, Viber, WhatsApp and Telegram messages. * Manage contacts and groups. * Fetch detailed info about phone numbers. * Blacklist phone numbers to make sure you're not sending any unwanted messages.  Messente builds [tools](https://messente.com/documentation) to help organizations connect their services to people anywhere in the world.  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Contact: messente@messente.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from messente_api.configuration import Configuration


class DeliveryResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'status': 'Status',
        'channel': 'Channel',
        'message_id': 'str',
        'error': 'str',
        'err': 'ErrorCodeOmnichannelMachine',
        'timestamp': 'datetime'
    }

    attribute_map = {
        'status': 'status',
        'channel': 'channel',
        'message_id': 'message_id',
        'error': 'error',
        'err': 'err',
        'timestamp': 'timestamp'
    }

    def __init__(self, status=None, channel=None, message_id=None, error=None, err=None, timestamp=None, local_vars_configuration=None):  # noqa: E501
        """DeliveryResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._status = None
        self._channel = None
        self._message_id = None
        self._error = None
        self._err = None
        self._timestamp = None
        self.discriminator = None

        if status is not None:
            self.status = status
        if channel is not None:
            self.channel = channel
        if message_id is not None:
            self.message_id = message_id
        if error is not None:
            self.error = error
        if err is not None:
            self.err = err
        if timestamp is not None:
            self.timestamp = timestamp

    @property
    def status(self):
        """Gets the status of this DeliveryResult.  # noqa: E501


        :return: The status of this DeliveryResult.  # noqa: E501
        :rtype: Status
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DeliveryResult.


        :param status: The status of this DeliveryResult.  # noqa: E501
        :type: Status
        """

        self._status = status

    @property
    def channel(self):
        """Gets the channel of this DeliveryResult.  # noqa: E501


        :return: The channel of this DeliveryResult.  # noqa: E501
        :rtype: Channel
        """
        return self._channel

    @channel.setter
    def channel(self, channel):
        """Sets the channel of this DeliveryResult.


        :param channel: The channel of this DeliveryResult.  # noqa: E501
        :type: Channel
        """

        self._channel = channel

    @property
    def message_id(self):
        """Gets the message_id of this DeliveryResult.  # noqa: E501

        Unique identifier for the message  # noqa: E501

        :return: The message_id of this DeliveryResult.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this DeliveryResult.

        Unique identifier for the message  # noqa: E501

        :param message_id: The message_id of this DeliveryResult.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def error(self):
        """Gets the error of this DeliveryResult.  # noqa: E501

        Human-readable description of what went wrong, *null* in case of success or if the message has not been processed yet  # noqa: E501

        :return: The error of this DeliveryResult.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this DeliveryResult.

        Human-readable description of what went wrong, *null* in case of success or if the message has not been processed yet  # noqa: E501

        :param error: The error of this DeliveryResult.  # noqa: E501
        :type: str
        """

        self._error = error

    @property
    def err(self):
        """Gets the err of this DeliveryResult.  # noqa: E501


        :return: The err of this DeliveryResult.  # noqa: E501
        :rtype: ErrorCodeOmnichannelMachine
        """
        return self._err

    @err.setter
    def err(self, err):
        """Sets the err of this DeliveryResult.


        :param err: The err of this DeliveryResult.  # noqa: E501
        :type: ErrorCodeOmnichannelMachine
        """

        self._err = err

    @property
    def timestamp(self):
        """Gets the timestamp of this DeliveryResult.  # noqa: E501

        When this status was received by Omnichannel API  # noqa: E501

        :return: The timestamp of this DeliveryResult.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this DeliveryResult.

        When this status was received by Omnichannel API  # noqa: E501

        :param timestamp: The timestamp of this DeliveryResult.  # noqa: E501
        :type: datetime
        """

        self._timestamp = timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeliveryResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeliveryResult):
            return True

        return self.to_dict() != other.to_dict()
