# Generated by Django 3.0.8 on 2020-09-29 06:27

import argus.incident.fields
import argus.incident.validators
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]
    # fmt:off
    operations = [
        migrations.CreateModel(
            name="Event",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("timestamp", models.DateTimeField()),
                ("received", models.DateTimeField(default=django.utils.timezone.now)),
                ("type", models.CharField(choices=[("STA", "Incident start"), ("END", "Incident end"), ("CLO", "Close"), ("REO", "Reopen"), ("ACK", "Acknowledge"), ("OTH", "Other")], max_length=3)),
                ("description", models.TextField(blank=True)),
            ],
            options={
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="Incident",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("start_time", models.DateTimeField(help_text="The time the incident was created.")),
                ("end_time", argus.incident.fields.DateTimeInfinityField(blank=True, help_text="The time the incident was resolved or closed. If not set, the incident is stateless; if 'infinity' is checked, the incident is stateful, but has not yet been resolved or closed - i.e. open.", null=True)),
                ("source_incident_id", models.TextField(verbose_name="source incident ID")),
                ("details_url", models.TextField(blank=True, validators=[django.core.validators.URLValidator], verbose_name="details URL")),
                ("description", models.TextField(blank=True)),
                ("ticket_url", models.TextField(blank=True, help_text="URL to existing ticket in a ticketing system.", validators=[django.core.validators.URLValidator], verbose_name="ticket URL")),
            ],
            options={
                "ordering": ["-start_time"],
            },
        ),
        migrations.CreateModel(
            name="IncidentRelation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("description", models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name="IncidentRelationType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.TextField()),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="IncidentTagRelation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("added_time", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="SourceSystem",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.TextField()),
                ("base_url", models.TextField(blank=True, help_text="Base url to combine with an incident's relative url to point to more info in the source system.")),
            ],
        ),
        migrations.CreateModel(
            name="SourceSystemType",
            fields=[
                ("name", models.TextField(primary_key=True, serialize=False, validators=[argus.incident.validators.validate_lowercase])),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("key", models.TextField(validators=[argus.incident.validators.validate_key])),
                ("value", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Acknowledgement",
            fields=[
                ("event", models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, primary_key=True, related_name="ack", serialize=False, to="argus_incident.Event")),
                ("expiration", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "ordering": ["-event__timestamp"],
            },
        ),
        migrations.AddConstraint(
            model_name="tag",
            constraint=models.UniqueConstraint(fields=("key", "value"), name="tag_unique_key_and_value"),
        ),
        migrations.AddField(
            model_name="sourcesystem",
            name="type",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="instances", to="argus_incident.SourceSystemType"),
        ),
        migrations.AddField(
            model_name="sourcesystem",
            name="user",
            field=models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name="source_system", to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="incidenttagrelation",
            name="added_by",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="tags_added", to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="incidenttagrelation",
            name="incident",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="incident_tag_relations", to="argus_incident.Incident"),
        ),
        migrations.AddField(
            model_name="incidenttagrelation",
            name="tag",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="incident_tag_relations", to="argus_incident.Tag"),
        ),
        migrations.AddField(
            model_name="incidentrelation",
            name="incident1",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="+", to="argus_incident.Incident"),
        ),
        migrations.AddField(
            model_name="incidentrelation",
            name="incident2",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="+", to="argus_incident.Incident"),
        ),
        migrations.AddField(
            model_name="incidentrelation",
            name="type",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="incident_relations", to="argus_incident.IncidentRelationType"),
        ),
        migrations.AddField(
            model_name="incident",
            name="source",
            field=models.ForeignKey(help_text="The source system that the incident originated in.", on_delete=django.db.models.deletion.PROTECT, related_name="incidents", to="argus_incident.SourceSystem"),
        ),
        migrations.AddField(
            model_name="event",
            name="actor",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="caused_events", to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="event",
            name="incident",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name="events", to="argus_incident.Incident"),
        ),
        migrations.AddConstraint(
            model_name="sourcesystem",
            constraint=models.UniqueConstraint(fields=("name", "type"), name="sourcesystem_unique_name_per_type"),
        ),
        migrations.AddConstraint(
            model_name="incidenttagrelation",
            constraint=models.UniqueConstraint(fields=("tag", "incident"), name="incidenttagrelation_unique_tags_per_incident"),
        ),
        migrations.AddConstraint(
            model_name="incident",
            constraint=models.UniqueConstraint(fields=("source_incident_id", "source"), name="incident_unique_source_incident_id_per_source"),
        ),
    ]
    # fmt:on
