from typing import Optional

from pydantic import Field, constr, Extra

from pydtk.db.schemas import BaseSchema, register_schema


@register_schema
class Record(BaseSchema):
    """Schema for records."""

    _api_version = "dataware-tools.com/v1alpha2"
    _kind = "Record"
    description: Optional[constr()] = Field(None, description="")
    record_id: constr(min_length=1) = Field(..., description="")

    # Allow additional properties
    class Config:
        """Config."""

        extra = Extra.allow
        schema_extra = {
            "additionalProperties": {}
        }
