# arlas-api-python
Explore the content of ARLAS collections

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 15.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_api_python
from arlas_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_api_python.CollectionsApi()
collection = 'collection_example' # str | collection
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # Delete a collection reference
    api_response = api_instance.delete(collection, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CollectionsApi->delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CollectionsApi* | [**delete**](docs/CollectionsApi.md#delete) | **DELETE** /collections/{collection} | Delete a collection reference
*CollectionsApi* | [**export_collections**](docs/CollectionsApi.md#export_collections) | **GET** /collections/_export | Get all collection references as a json file
*CollectionsApi* | [**get**](docs/CollectionsApi.md#get) | **GET** /collections/{collection} | Get a collection reference
*CollectionsApi* | [**get_all**](docs/CollectionsApi.md#get_all) | **GET** /collections | Get all collection references
*CollectionsApi* | [**import_collections**](docs/CollectionsApi.md#import_collections) | **POST** /collections/_import | Add collection references from a json file
*CollectionsApi* | [**put**](docs/CollectionsApi.md#put) | **PUT** /collections/{collection} | Add a collection reference
*ExploreApi* | [**aggregate**](docs/ExploreApi.md#aggregate) | **GET** /explore/{collection}/_aggregate | Aggregate
*ExploreApi* | [**aggregate_post**](docs/ExploreApi.md#aggregate_post) | **POST** /explore/{collection}/_aggregate | Aggregate
*ExploreApi* | [**compute**](docs/ExploreApi.md#compute) | **GET** /explore/{collection}/_compute | Compute
*ExploreApi* | [**compute_post**](docs/ExploreApi.md#compute_post) | **POST** /explore/{collection}/_compute | Compute
*ExploreApi* | [**count**](docs/ExploreApi.md#count) | **GET** /explore/{collection}/_count | Count
*ExploreApi* | [**count_post**](docs/ExploreApi.md#count_post) | **POST** /explore/{collection}/_count | Count
*ExploreApi* | [**describe**](docs/ExploreApi.md#describe) | **GET** /explore/{collection}/_describe | Describe
*ExploreApi* | [**geoaggregate**](docs/ExploreApi.md#geoaggregate) | **GET** /explore/{collection}/_geoaggregate | GeoAggregate
*ExploreApi* | [**geoaggregate_post**](docs/ExploreApi.md#geoaggregate_post) | **POST** /explore/{collection}/_geoaggregate | GeoAggregate
*ExploreApi* | [**geohashgeoaggregate**](docs/ExploreApi.md#geohashgeoaggregate) | **GET** /explore/{collection}/_geoaggregate/{geohash} | GeoAggregate on a geohash
*ExploreApi* | [**geosearch**](docs/ExploreApi.md#geosearch) | **GET** /explore/{collection}/_geosearch | GeoSearch
*ExploreApi* | [**geosearch_post**](docs/ExploreApi.md#geosearch_post) | **POST** /explore/{collection}/_geosearch | GeoSearch
*ExploreApi* | [**get_arlas_hit**](docs/ExploreApi.md#get_arlas_hit) | **GET** /explore/{collection}/{identifier} | Get an Arlas document
*ExploreApi* | [**list**](docs/ExploreApi.md#list) | **GET** /explore/_list | List
*ExploreApi* | [**opensearch**](docs/ExploreApi.md#opensearch) | **GET** /explore/ogc/opensearch/{collection} | OpenSearch Description Document
*ExploreApi* | [**search**](docs/ExploreApi.md#search) | **GET** /explore/{collection}/_search | Search
*ExploreApi* | [**search_post**](docs/ExploreApi.md#search_post) | **POST** /explore/{collection}/_search | Search
*ExploreApi* | [**shapeaggregate**](docs/ExploreApi.md#shapeaggregate) | **GET** /explore/{collection}/_shapeaggregate | ShapeAggregate
*ExploreApi* | [**shapeaggregate_post**](docs/ExploreApi.md#shapeaggregate_post) | **POST** /explore/{collection}/_shapeaggregate | ShapeAggregate
*ExploreApi* | [**shapesearch**](docs/ExploreApi.md#shapesearch) | **GET** /explore/{collection}/_shapesearch | ShapeSearch
*ExploreApi* | [**shapesearch_post**](docs/ExploreApi.md#shapesearch_post) | **POST** /explore/{collection}/_shapesearch | ShapeSearch
*ExploreApi* | [**suggest**](docs/ExploreApi.md#suggest) | **GET** /explore/{collections}/_suggest | Suggest
*ExploreApi* | [**tiledgeosearch**](docs/ExploreApi.md#tiledgeosearch) | **GET** /explore/{collection}/_geosearch/{z}/{x}/{y} | Tiled GeoSearch
*ExploreApi* | [**tiledgeosearch1**](docs/ExploreApi.md#tiledgeosearch1) | **GET** /explore/{collection}/_tile/{z}/{x}/{y}.png | Tiled GeoSearch


## Documentation For Models

 - [Aggregation](docs/Aggregation.md)
 - [AggregationMetric](docs/AggregationMetric.md)
 - [AggregationResponse](docs/AggregationResponse.md)
 - [AggregationsRequest](docs/AggregationsRequest.md)
 - [Bbox](docs/Bbox.md)
 - [CollectionReference](docs/CollectionReference.md)
 - [CollectionReferenceDescription](docs/CollectionReferenceDescription.md)
 - [CollectionReferenceDescriptionProperty](docs/CollectionReferenceDescriptionProperty.md)
 - [CollectionReferenceParameters](docs/CollectionReferenceParameters.md)
 - [ComputationRequest](docs/ComputationRequest.md)
 - [ComputationResponse](docs/ComputationResponse.md)
 - [Count](docs/Count.md)
 - [Crs](docs/Crs.md)
 - [DublinCoreElementName](docs/DublinCoreElementName.md)
 - [Error](docs/Error.md)
 - [Expression](docs/Expression.md)
 - [Feature](docs/Feature.md)
 - [FeatureCollection](docs/FeatureCollection.md)
 - [Feed](docs/Feed.md)
 - [Filter](docs/Filter.md)
 - [Form](docs/Form.md)
 - [Generator](docs/Generator.md)
 - [Geo](docs/Geo.md)
 - [GeoJsonObject](docs/GeoJsonObject.md)
 - [Hit](docs/Hit.md)
 - [Hits](docs/Hits.md)
 - [HitsFetcher](docs/HitsFetcher.md)
 - [Inspire](docs/Inspire.md)
 - [InspireLimitationAccess](docs/InspireLimitationAccess.md)
 - [InspireSpatialResolution](docs/InspireSpatialResolution.md)
 - [InspireURI](docs/InspireURI.md)
 - [Interval](docs/Interval.md)
 - [Keyword](docs/Keyword.md)
 - [Link](docs/Link.md)
 - [LngLatAlt](docs/LngLatAlt.md)
 - [MD](docs/MD.md)
 - [Metric](docs/Metric.md)
 - [Number](docs/Number.md)
 - [OpenSearch](docs/OpenSearch.md)
 - [Page](docs/Page.md)
 - [Person](docs/Person.md)
 - [Projection](docs/Projection.md)
 - [RasterTileURL](docs/RasterTileURL.md)
 - [RawGeometry](docs/RawGeometry.md)
 - [ReturnedGeometry](docs/ReturnedGeometry.md)
 - [Search](docs/Search.md)
 - [Success](docs/Success.md)
 - [GeometryCollection](docs/GeometryCollection.md)
 - [LineString](docs/LineString.md)
 - [MultiLineString](docs/MultiLineString.md)
 - [MultiPoint](docs/MultiPoint.md)
 - [MultiPolygon](docs/MultiPolygon.md)
 - [Point](docs/Point.md)
 - [Polygon](docs/Polygon.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

