# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_core.ipynb.

# %% auto 0
__all__ = ['write_to_file', 'isNotEmpty', 'Stdf', 'Content']

# %% ../00_core.ipynb 1
from pathlib import Path
import tempfile

import pandas as pd
from Semi_ATE import STDF

from fastcore.basics import *

# %% ../00_core.ipynb 3
def write_to_file(content, mode='wb', filename='tmp'):
    dest = Path(tempfile.mkdtemp())
    with open(dest / filename, mode) as f:
        f.write(content)

    return dest / filename

def isNotEmpty(r):
    return len(r) != 0

# %% ../00_core.ipynb 5
@patch(as_prop=True)
def test_type(self: STDF.PTR):
    return self.fields['TEST_TXT']['Value']

@patch(as_prop=True)
def test_res(self: STDF.PTR):
    return self.fields['RESULT']['Value']

@patch(as_prop=True)
def test_fail_u(self: STDF.PTR):
    return self.fields['RESULT']['Value'] > self.fields['HI_LIMIT']['Value']

@patch(as_prop=True)
def test(self: STDF.PTR):
    return {k: v['Value'] for k, v in self.fields.items()}

@patch(as_prop=True)
def isEfuse(self: STDF.PTR):
    return 'eFuse' in self.test_type

@patch(as_prop=True)
def isX(self: STDF.PTR):
    return self.isEfuse and ('X_coord' in self.test_type)

@patch(as_prop=True)
def isW(self: STDF.PTR):
    return self.isEfuse and ('Wafer_number' in self.test_type)

@patch(as_prop=True)
def isY(self: STDF.PTR):
    return self.isEfuse and ('Y_coord' in self.test_type)

@patch(as_prop=True)
def isFT_checksum(self: STDF.PTR):
    return self.isEfuse and ('FT_checksum'  in self.test_type)



# %% ../00_core.ipynb 7
class Stdf:
    "Stdf content struct"
    def __init__(self, 
    file_content=None, #binary file content of stdf file
    file_name=None): #binary file name of stdf file
        self._file_content = file_content
        self._file_name = file_name

    @property
    def file_content(self):
        return self._file_content

    @property
    def file_name(self):
        return self._file_name

    




# %% ../00_core.ipynb 8
class Content:
    "for extracting wxy"
    def __init__(self, 
        stdf=None, # stdf data as Stdf class
        csv=None): # csv data as Csv class (todo)
        self._stdf = stdf
        self._csv = csv

    @property
    def wxy(self) -> pd.DataFrame:
        self._f = write_to_file(self._stdf.file_content, filename=self._stdf.file_name)
        self._parse_records()
        self._extract_wxy()
        self._add_cols()
        return self._dfs

    @property
    def csv(self):
        pass

    def _parse_records(self, record_type=STDF.PTR):
        self._recs = [r for r in STDF.records_from_file(str(self._f)) if isinstance(r, record_type)]

    def _extract_wxy(self):
        res,N,isHydrated = [],len(self._recs),[]
        cache,m ={},0
        dfs = []

        def updateCache():
            if r.isW: cache['w'] = int(r.test_res)
            if r.isX: cache['x'] = int(r.test_res)
            if r.isY: cache['y'] = int(r.test_res)

        for indx,r in enumerate(self._recs[::-1]): #begin from the end
            res.append((self._f.stem, indx, r.test_type, r.test['RESULT'], r.test['LO_LIMIT'], r.test['HI_LIMIT']))
            updateCache()
            if (r.isFT_checksum or indx == N-1) and isNotEmpty(cache):
                s = slice(m, indx + 1) if indx == N-1 else slice(m, indx) #if last item (reading backwards)
                wxy = cache['w'], cache['x'], cache['y']
                res[s] = [_r + wxy for _r in res[s]]
                cache,m = {},indx
                isHydrated.append(True)

        if any(isHydrated):
            columns = ['filename', 'indx', 'test_name','test_value',
                    'test_lo_limit', 'test_hi_limit', 'wafer_number', 'x_coord', 'y_coord']
            dfs.append(pd.DataFrame(res, columns=columns) )

        self._dfs = pd.concat(dfs)


    def _add_cols(self):
        def extract():
            qs_smt = r'.+(SMT\d).+'  # '\d' matches only single digit
            qs_lot = r'.*(K4.+GF).+' # '*' means could be nothing
            qs_date = r'.+_(220[5-7][0-9]{2}).+' ##very specific date search 2205... or 2206...
            qs_time = r'.+_220[5-7][0-9]{2}_?([0-9]{6}).+' #'?'=='optional'

            self._dfs['test_insertion'] = self._dfs.filename.str.extract(qs_smt).values
            self._dfs['lot'] = self._dfs.filename.str.extract(qs_lot).values
            self._dfs['date'] = self._dfs.filename.str.extract(qs_date).values
            self._dfs['time'] = self._dfs.filename.str.extract(qs_time).values

        def gen_cols():
            self._dfs['test_value_minus_test_hi_limit'] = self._dfs['test_value'] - self._dfs['test_hi_limit']
            self._dfs['test_lo_limit_minus_test_value'] = self._dfs['test_lo_limit'] - self._dfs['test_value']
            self._dfs['wxy'] = self._dfs['wafer_number'].astype('str') + \
                    '/' + self._dfs['x_coord'].astype('str') + '/' + self._dfs['y_coord'].astype('str')

        extract()
        gen_cols()
