from ccxt.base.types import Entry


class ImplicitAPI:
    kline_public_get_public_json = klinePublicGetPublicJson = Entry('public.json', ['kline', 'public'], 'GET', {'cost': 1})
    kline_public_get_public_currency_json = klinePublicGetPublicCurrencyJson = Entry('public{currency}.json', ['kline', 'public'], 'GET', {'cost': 1})
    v1_public_get_ping = v1PublicGetPing = Entry('ping', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_time = v1PublicGetTime = Entry('time', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_exchangeinfo = v1PublicGetExchangeInfo = Entry('exchangeInfo', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_depth = v1PublicGetDepth = Entry('depth', ['v1', 'public'], 'GET', {'cost': 1, 'byLimit': [[100, 1], [500, 5], [1000, 10]]})
    v1_public_get_trades = v1PublicGetTrades = Entry('trades', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_historicaltrades = v1PublicGetHistoricalTrades = Entry('historicalTrades', ['v1', 'public'], 'GET', {'cost': 5})
    v1_public_get_aggtrades = v1PublicGetAggTrades = Entry('aggTrades', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_ticker_24hr = v1PublicGetTicker24hr = Entry('ticker/24hr', ['v1', 'public'], 'GET', {'cost': 1, 'noSymbol': 40})
    v1_public_get_ticker_price = v1PublicGetTickerPrice = Entry('ticker/price', ['v1', 'public'], 'GET', {'cost': 1, 'noSymbol': 2})
    v1_public_get_ticker_bookticker = v1PublicGetTickerBookTicker = Entry('ticker/bookTicker', ['v1', 'public'], 'GET', {'cost': 1, 'noSymbol': 2})
    v1_public_get_market_kline = v1PublicGetMarketKline = Entry('market/kline', ['v1', 'public'], 'GET', {'cost': 1})
    v1_private_get_order = v1PrivateGetOrder = Entry('order', ['v1', 'private'], 'GET', {'cost': 1})
    v1_private_get_openorders = v1PrivateGetOpenOrders = Entry('openOrders', ['v1', 'private'], 'GET', {'cost': 1})
    v1_private_get_allorders = v1PrivateGetAllOrders = Entry('allOrders', ['v1', 'private'], 'GET', {'cost': 5})
    v1_private_get_account = v1PrivateGetAccount = Entry('account', ['v1', 'private'], 'GET', {'cost': 5})
    v1_private_get_mytrades = v1PrivateGetMyTrades = Entry('myTrades', ['v1', 'private'], 'GET', {'cost': 5, 'noSymbol': 40})
    v1_private_get_etf_net_value_symbol = v1PrivateGetEtfNetValueSymbol = Entry('etf/net-value/{symbol}', ['v1', 'private'], 'GET', {'cost': 1})
    v1_private_get_withdraw_history = v1PrivateGetWithdrawHistory = Entry('withdraw/history', ['v1', 'private'], 'GET', {'cost': 1})
    v1_private_get_deposit_history = v1PrivateGetDepositHistory = Entry('deposit/history', ['v1', 'private'], 'GET', {'cost': 1})
    v1_private_post_order = v1PrivatePostOrder = Entry('order', ['v1', 'private'], 'POST', {'cost': 4})
    v1_private_post_withdraw_commit = v1PrivatePostWithdrawCommit = Entry('withdraw/commit', ['v1', 'private'], 'POST', {'cost': 1})
    v1_private_delete_order = v1PrivateDeleteOrder = Entry('order', ['v1', 'private'], 'DELETE', {'cost': 1})
    v2_private_get_mytrades = v2PrivateGetMyTrades = Entry('myTrades', ['v2', 'private'], 'GET', {'cost': 5})
    open_private_post_poseidon_api_v1_listenkey = openPrivatePostPoseidonApiV1ListenKey = Entry('poseidon/api/v1/listenKey', ['open', 'private'], 'POST', {'cost': 1})
    open_private_put_poseidon_api_v1_listenkey_listenkey = openPrivatePutPoseidonApiV1ListenKeyListenKey = Entry('poseidon/api/v1/listenKey/{listenKey}', ['open', 'private'], 'PUT', {'cost': 1})
    open_private_delete_poseidon_api_v1_listenkey_listenkey = openPrivateDeletePoseidonApiV1ListenKeyListenKey = Entry('poseidon/api/v1/listenKey/{listenKey}', ['open', 'private'], 'DELETE', {'cost': 1})
