#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['csr', 'csr.kernels', 'csr.kernels.mkl', 'csr.kernels.numba']

package_data = \
{'': ['*']}

install_requires = \
['numba >=0.51,<0.54', 'numpy >=1.17', 'scipy ==1.*']

extras_require = \
{'dev': ['flake8', 'rstcheck', 'sphinx-autobuild >=2021'],
 'doc': ['sphinx >=4', 'furo'],
 'mkl': ['cffi'],
 'profile': ['notebook', 'seaborn', 'jupytext', 'pandas >=1.0'],
 'test': ['pytest >=6',
          'pytest-doctestplus >=0.9',
          'pytest-benchmark >=3',
          'pytest-cov >=2.12',
          'hypothesis >=6',
          'psutil >=5']}

setup(name='csr',
      version='0.4.0',
      description='Compressed Sparse Row matrices for Python, with Numba API.',
      author='Michael Ekstrand <michaelekstrand@boisestate.edu>',
      author_email='michaelekstrand@boisestate.edu',
      url='https://csr.lenskit.org',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.7',
     )
