# Generated by Django 3.2.5 on 2021-07-21 04:57

from django.db import migrations

def gen(apps, schema_editor):
    from data.models.models import AccessoryType, HardwareChannelTypes, Category

    categories = [('Other', 1), ('Bridge', 2), ('Fan', 3), ('Garage Door Opener', 4), ('Lightbulb', 5),
                  ('Door Lock', 6), ('Outlet', 7), ('Switch', 8), ('Thermostat', 9), ('Sensor', 10),
                  ('Alarm system', 11), ('Door', 12), ('Window', 13), ('Window Covering', 14),
                  ('Programmable Switch', 15), ('Range Extender', 16), ('Camera', 17), ('Video Door Bell', 18),
                  ('Air Purifier', 19), ('Heater', 20), ('Air Conditioner', 21), ('Humidifier', 22),
                  ('Dehumidifier', 23), ('Speaker', 26), ('Sprinkler', 28), ('Faucet', 29), ('Shower head', 30),
                  ('Television', 31), ('Target Controller', 32)]

    for (name, enum) in categories:
        print(name)
        print(str(enum))
        cat = Category.objects.create()
        cat.name = name
        cat.enum = enum
        cat.save()

    types = ['AirTemperatureSensor',
             'ETapeSensor',
             'HumiditySensor',
             'LiquidLevelSensor',
             'PressureSensor',
             'Pump',
             'SoilMoistureSensor',
             'SoilTemperatureSensor']

    for type in types:
        cat = AccessoryType.objects.create()
        cat.type = type
        cat.save()

    hardware_channel_types = [('PiPico', 'PiPicoAnalog'), ('PiPico', 'PiPicoPump')]

    for (hard, channel) in hardware_channel_types:
        cat = HardwareChannelTypes.objects.create()
        cat.hardware_type = hard
        cat.channel_type = channel
        cat.save()


class Migration(migrations.Migration):

    dependencies = [
        ('data', '0013_auto_20210713_1524'),
    ]

    operations = [
        migrations.RunPython(gen, reverse_code=migrations.RunPython.noop),
    ]
