#!/usr/bin/python
# coding = utf-8
import numpy as np
import pandas as pd
from WindPy import w
w.start(waitTime=60)
def convertInputSecurityType(func):
    def convertedFunc(*args):
        args = tuple((i.strftime("%Y-%m-%d") if hasattr(i,"strftime") else i for i in args))
        if type(args[0])==type(''):
            return func(*args)[1].fillna(np.nan)
        else:
            security = args[0]
            args = args[1:]
            return func(",".join(security),*args)[1].fillna(np.nan)
    return convertedFunc
@convertInputSecurityType
def getMmAvgPtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期末投资组合平均剩余期限时间序列
    return w.wsd(security,"mmavgptm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgPtM(security:list,*args,**kwargs):
    # 获取报告期末投资组合平均剩余期限
    return w.wss(security,"mmavgptm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgPtMMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内投资组合平均剩余期限最高值时间序列
    return w.wsd(security,"mmavgptm_max",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgPtMMax(security:list,*args,**kwargs):
    # 获取报告期内投资组合平均剩余期限最高值
    return w.wss(security,"mmavgptm_max",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgPtMMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内投资组合平均剩余期限最低值时间序列
    return w.wsd(security,"mmavgptm_min",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgPtMMin(security:list,*args,**kwargs):
    # 获取报告期内投资组合平均剩余期限最低值
    return w.wss(security,"mmavgptm_min",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondByCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的债券投资市值时间序列
    return w.wsd(security,"prt_bondbycreditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondByCreditRating(security:list,*args,**kwargs):
    # 获取按信用评级的债券投资市值
    return w.wss(security,"prt_bondbycreditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsByCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的资产支持证券投资市值时间序列
    return w.wsd(security,"prt_absbycreditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsByCreditRating(security:list,*args,**kwargs):
    # 获取按信用评级的资产支持证券投资市值
    return w.wss(security,"prt_absbycreditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdByCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的同业存单投资市值时间序列
    return w.wsd(security,"prt_ncdbycreditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdByCreditRating(security:list,*args,**kwargs):
    # 获取按信用评级的同业存单投资市值
    return w.wss(security,"prt_ncdbycreditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondByCreditRatingToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的债券投资占基金资产净值比时间序列
    return w.wsd(security,"prt_bondbycreditratingtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondByCreditRatingToNav(security:list,*args,**kwargs):
    # 获取按信用评级的债券投资占基金资产净值比
    return w.wss(security,"prt_bondbycreditratingtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsByCreditRatingToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的资产支持证券投资占基金资产净值比时间序列
    return w.wsd(security,"prt_absbycreditratingtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsByCreditRatingToNav(security:list,*args,**kwargs):
    # 获取按信用评级的资产支持证券投资占基金资产净值比
    return w.wss(security,"prt_absbycreditratingtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdByCreditRatingToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取按信用评级的同业存单投资占基金资产净值比时间序列
    return w.wsd(security,"prt_ncdbycreditratingtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdByCreditRatingToNav(security:list,*args,**kwargs):
    # 获取按信用评级的同业存单投资占基金资产净值比
    return w.wss(security,"prt_ncdbycreditratingtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondValSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券估值(YY)时间序列
    return w.wsd(security,"inst_yybondval",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondVal(security:list,*args,**kwargs):
    # 获取债券估值(YY)
    return w.wss(security,"inst_yybondval",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondValHisSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券估值历史(YY)时间序列
    return w.wsd(security,"inst_yybondvalhis",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondValHis(security:list,*args,**kwargs):
    # 获取债券估值历史(YY)
    return w.wss(security,"inst_yybondvalhis",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgBalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融资融券余额时间序列
    return w.wsd(security,"mrg_bal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgBal(security:list,*args,**kwargs):
    # 获取融资融券余额
    return w.wss(security,"mrg_bal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginGuaranteedStocksMarketValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融资融券担保股票市值时间序列
    return w.wsd(security,"margin_guaranteedstocksmarketvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginGuaranteedStocksMarketValue(security:list,*args,**kwargs):
    # 获取融资融券担保股票市值
    return w.wss(security,"margin_guaranteedstocksmarketvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否融资融券标的时间序列
    return w.wsd(security,"marginornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginOrNot(security:list,*args,**kwargs):
    # 获取是否融资融券标的
    return w.wss(security,"marginornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgBalIntAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融资融券余额均值时间序列
    return w.wsd(security,"mrg_bal_int_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgBalIntAvg(security:list,*args,**kwargs):
    # 获取区间融资融券余额均值
    return w.wss(security,"mrg_bal_int_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1511Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取利息收入:融资融券业务时间序列
    return w.wsd(security,"stmnote_sec_1511",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1511(security:list,*args,**kwargs):
    # 获取利息收入:融资融券业务
    return w.wss(security,"stmnote_sec_1511",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1531Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取利息净收入:融资融券业务时间序列
    return w.wsd(security,"stmnote_sec_1531",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1531(security:list,*args,**kwargs):
    # 获取利息净收入:融资融券业务
    return w.wss(security,"stmnote_sec_1531",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌_期货历史同月时间序列
    return w.wsd(security,"His_change",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisChange(security:list,*args,**kwargs):
    # 获取涨跌_期货历史同月
    return w.wss(security,"His_change",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisSwingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取振幅_期货历史同月时间序列
    return w.wsd(security,"His_swing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisSwing(security:list,*args,**kwargs):
    # 获取振幅_期货历史同月
    return w.wss(security,"His_swing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价_期货历史同月时间序列
    return w.wsd(security,"His_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisClose(security:list,*args,**kwargs):
    # 获取收盘价_期货历史同月
    return w.wss(security,"His_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘价_期货历史同月时间序列
    return w.wsd(security,"His_open",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOpen(security:list,*args,**kwargs):
    # 获取开盘价_期货历史同月
    return w.wss(security,"His_open",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisHighSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最高价_期货历史同月时间序列
    return w.wsd(security,"His_high",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisHigh(security:list,*args,**kwargs):
    # 获取最高价_期货历史同月
    return w.wss(security,"His_high",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisLowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最低价_期货历史同月时间序列
    return w.wsd(security,"His_low",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisLow(security:list,*args,**kwargs):
    # 获取最低价_期货历史同月
    return w.wss(security,"His_low",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisSettleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取结算价_期货历史同月时间序列
    return w.wsd(security,"His_settle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisSettle(security:list,*args,**kwargs):
    # 获取结算价_期货历史同月
    return w.wss(security,"His_settle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅_期货历史同月时间序列
    return w.wsd(security,"His_pctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPctChange(security:list,*args,**kwargs):
    # 获取涨跌幅_期货历史同月
    return w.wss(security,"His_pctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量_期货历史同月时间序列
    return w.wsd(security,"His_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisVolume(security:list,*args,**kwargs):
    # 获取成交量_期货历史同月
    return w.wss(security,"His_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisTurnoverSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交额_期货历史同月时间序列
    return w.wsd(security,"His_turnover",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisTurnover(security:list,*args,**kwargs):
    # 获取成交额_期货历史同月
    return w.wss(security,"His_turnover",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量_期货历史同月时间序列
    return w.wsd(security,"His_oi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOi(security:list,*args,**kwargs):
    # 获取持仓量_期货历史同月
    return w.wss(security,"His_oi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPreSettleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前结算价_期货历史同月时间序列
    return w.wsd(security,"His_preSettle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPreSettle(security:list,*args,**kwargs):
    # 获取前结算价_期货历史同月
    return w.wss(security,"His_preSettle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisAvgPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交均价_期货历史同月时间序列
    return w.wsd(security,"His_avgprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisAvgPrice(security:list,*args,**kwargs):
    # 获取成交均价_期货历史同月
    return w.wss(security,"His_avgprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOiChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓变化_期货历史同月时间序列
    return w.wsd(security,"His_oichange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisOiChange(security:list,*args,**kwargs):
    # 获取持仓变化_期货历史同月
    return w.wss(security,"His_oichange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisCloseNightSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(夜盘)_期货历史同月时间序列
    return w.wsd(security,"His_close_night",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisCloseNight(security:list,*args,**kwargs):
    # 获取收盘价(夜盘)_期货历史同月
    return w.wss(security,"His_close_night",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisChangeSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌(结算价)_期货历史同月时间序列
    return w.wsd(security,"His_change_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisChangeSettlement(security:list,*args,**kwargs):
    # 获取涨跌(结算价)_期货历史同月
    return w.wss(security,"His_change_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPctChangeSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅(结算价)_期货历史同月时间序列
    return w.wsd(security,"His_pctchange_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHisPctChangeSettlement(security:list,*args,**kwargs):
    # 获取涨跌幅(结算价)_期货历史同月
    return w.wss(security,"His_pctchange_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeAbstractSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩预告摘要时间序列
    return w.wsd(security,"profitnotice_abstract",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeAbstract(security:list,*args,**kwargs):
    # 获取业绩预告摘要
    return w.wss(security,"profitnotice_abstract",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeReasonSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩预告变动原因时间序列
    return w.wsd(security,"profitnotice_reason",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeReason(security:list,*args,**kwargs):
    # 获取业绩预告变动原因
    return w.wss(security,"profitnotice_reason",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩预告类型时间序列
    return w.wsd(security,"profitnotice_style",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeStyle(security:list,*args,**kwargs):
    # 获取业绩预告类型
    return w.wss(security,"profitnotice_style",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩预告最新披露日期时间序列
    return w.wsd(security,"profitnotice_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDate(security:list,*args,**kwargs):
    # 获取业绩预告最新披露日期
    return w.wss(security,"profitnotice_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeFirstDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩预告首次披露日期时间序列
    return w.wsd(security,"profitnotice_firstdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeFirstDate(security:list,*args,**kwargs):
    # 获取业绩预告首次披露日期
    return w.wss(security,"profitnotice_firstdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastRpTDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新业绩预告报告期时间序列
    return w.wsd(security,"profitnotice_lastrptdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastRpTDate(security:list,*args,**kwargs):
    # 获取最新业绩预告报告期
    return w.wss(security,"profitnotice_lastrptdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeAbstractSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.业绩预告摘要(海外)时间序列
    return w.wsd(security,"qprofitnotice_abstract",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeAbstract(security:list,*args,**kwargs):
    # 获取单季度.业绩预告摘要(海外)
    return w.wss(security,"qprofitnotice_abstract",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.业绩预告类型(海外)时间序列
    return w.wsd(security,"qprofitnotice_style",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeStyle(security:list,*args,**kwargs):
    # 获取单季度.业绩预告类型(海外)
    return w.wss(security,"qprofitnotice_style",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.业绩预告日期(海外)时间序列
    return w.wsd(security,"qprofitnotice_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeDate(security:list,*args,**kwargs):
    # 获取单季度.业绩预告日期(海外)
    return w.wss(security,"qprofitnotice_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressLastDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报最新披露日期时间序列
    return w.wsd(security,"performanceexpress_lastdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressLastDate(security:list,*args,**kwargs):
    # 获取业绩快报最新披露日期
    return w.wss(security,"performanceexpress_lastdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报首次披露日期时间序列
    return w.wsd(security,"performanceexpress_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressDate(security:list,*args,**kwargs):
    # 获取业绩快报首次披露日期
    return w.wss(security,"performanceexpress_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.营业收入时间序列
    return w.wsd(security,"performanceexpress_perfexincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExIncome(security:list,*args,**kwargs):
    # 获取业绩快报.营业收入
    return w.wss(security,"performanceexpress_perfexincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExprOfItSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.营业利润时间序列
    return w.wsd(security,"performanceexpress_perfexprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExprOfIt(security:list,*args,**kwargs):
    # 获取业绩快报.营业利润
    return w.wss(security,"performanceexpress_perfexprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExTotalProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.利润总额时间序列
    return w.wsd(security,"performanceexpress_perfextotalprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExTotalProfit(security:list,*args,**kwargs):
    # 获取业绩快报.利润总额
    return w.wss(security,"performanceexpress_perfextotalprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExNetProfitToShareholderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.归属母公司股东的净利润时间序列
    return w.wsd(security,"performanceexpress_perfexnetprofittoshareholder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExNetProfitToShareholder(security:list,*args,**kwargs):
    # 获取业绩快报.归属母公司股东的净利润
    return w.wss(security,"performanceexpress_perfexnetprofittoshareholder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdToShareholderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.归属于上市公司股东的扣除非经常性损益的净利润时间序列
    return w.wsd(security,"performanceexpress_npdedtoshareholder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdToShareholder(security:list,*args,**kwargs):
    # 获取业绩快报.归属于上市公司股东的扣除非经常性损益的净利润
    return w.wss(security,"performanceexpress_npdedtoshareholder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExEpsDilutedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.每股收益EPS-基本时间序列
    return w.wsd(security,"performanceexpress_perfexepsdiluted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExEpsDiluted(security:list,*args,**kwargs):
    # 获取业绩快报.每股收益EPS-基本
    return w.wss(security,"performanceexpress_perfexepsdiluted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExRoeDilutedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.净资产收益率ROE-加权时间序列
    return w.wsd(security,"performanceexpress_perfexroediluted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExRoeDiluted(security:list,*args,**kwargs):
    # 获取业绩快报.净资产收益率ROE-加权
    return w.wss(security,"performanceexpress_perfexroediluted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExTotalAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.总资产时间序列
    return w.wsd(security,"performanceexpress_perfextotalassets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExTotalAssets(security:list,*args,**kwargs):
    # 获取业绩快报.总资产
    return w.wss(security,"performanceexpress_perfextotalassets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExNetAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.净资产时间序列
    return w.wsd(security,"performanceexpress_perfexnetassets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressPerFExNetAssets(security:list,*args,**kwargs):
    # 获取业绩快报.净资产
    return w.wss(security,"performanceexpress_perfexnetassets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressOrYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:营业收入时间序列
    return w.wsd(security,"performanceexpress_or_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressOrYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:营业收入
    return w.wss(security,"performanceexpress_or_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressOpYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:营业利润时间序列
    return w.wsd(security,"performanceexpress_op_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressOpYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:营业利润
    return w.wss(security,"performanceexpress_op_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEBtYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:利润总额时间序列
    return w.wsd(security,"performanceexpress_ebt_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEBtYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:利润总额
    return w.wss(security,"performanceexpress_ebt_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:归属母公司股东的净利润时间序列
    return w.wsd(security,"performanceexpress_np_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:归属母公司股东的净利润
    return w.wss(security,"performanceexpress_np_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:归属于上市公司股东的扣除非经常性损益的净利润时间序列
    return w.wsd(security,"performanceexpress_npded_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:归属于上市公司股东的扣除非经常性损益的净利润
    return w.wss(security,"performanceexpress_npded_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEpsYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增长率:基本每股收益时间序列
    return w.wsd(security,"performanceexpress_eps_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEpsYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增长率:基本每股收益
    return w.wss(security,"performanceexpress_eps_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressRoeYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.同比增减:加权平均净资产收益率时间序列
    return w.wsd(security,"performanceexpress_roe_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressRoeYoY(security:list,*args,**kwargs):
    # 获取业绩快报.同比增减:加权平均净资产收益率
    return w.wss(security,"performanceexpress_roe_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressIncomeYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.去年同期营业收入时间序列
    return w.wsd(security,"performanceexpress_income_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressIncomeYa(security:list,*args,**kwargs):
    # 获取业绩快报.去年同期营业收入
    return w.wss(security,"performanceexpress_income_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressProfitYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.去年同期营业利润时间序列
    return w.wsd(security,"performanceexpress_profit_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressProfitYa(security:list,*args,**kwargs):
    # 获取业绩快报.去年同期营业利润
    return w.wss(security,"performanceexpress_profit_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressToTProfitYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.去年同期利润总额时间序列
    return w.wsd(security,"performanceexpress_totprofit_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressToTProfitYa(security:list,*args,**kwargs):
    # 获取业绩快报.去年同期利润总额
    return w.wss(security,"performanceexpress_totprofit_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNetProfitYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.去年同期净利润时间序列
    return w.wsd(security,"performanceexpress_netprofit_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNetProfitYa(security:list,*args,**kwargs):
    # 获取业绩快报.去年同期净利润
    return w.wss(security,"performanceexpress_netprofit_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.上年同期归属于上市公司股东的扣除非经常性损益的净利润时间序列
    return w.wsd(security,"performanceexpress_npded_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNpdEdYa(security:list,*args,**kwargs):
    # 获取业绩快报.上年同期归属于上市公司股东的扣除非经常性损益的净利润
    return w.wss(security,"performanceexpress_npded_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEpsYaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.去年同期每股收益时间序列
    return w.wsd(security,"performanceexpress_eps_ya",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEpsYa(security:list,*args,**kwargs):
    # 获取业绩快报.去年同期每股收益
    return w.wss(security,"performanceexpress_eps_ya",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.每股净资产时间序列
    return w.wsd(security,"performanceexpress_bps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpS(security:list,*args,**kwargs):
    # 获取业绩快报.每股净资产
    return w.wss(security,"performanceexpress_bps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNetAssetsBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.期初净资产时间序列
    return w.wsd(security,"performanceexpress_netassets_b",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressNetAssetsB(security:list,*args,**kwargs):
    # 获取业绩快报.期初净资产
    return w.wss(security,"performanceexpress_netassets_b",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpSBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.期初每股净资产时间序列
    return w.wsd(security,"performanceexpress_bps_b",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpSB(security:list,*args,**kwargs):
    # 获取业绩快报.期初每股净资产
    return w.wss(security,"performanceexpress_bps_b",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEqYGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.比年初增长率:归属母公司的股东权益时间序列
    return w.wsd(security,"performanceexpress_eqy_growth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressEqYGrowth(security:list,*args,**kwargs):
    # 获取业绩快报.比年初增长率:归属母公司的股东权益
    return w.wss(security,"performanceexpress_eqy_growth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpSGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.比年初增长率:归属于母公司股东的每股净资产时间序列
    return w.wsd(security,"performanceexpress_bps_growth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressBpSGrowth(security:list,*args,**kwargs):
    # 获取业绩快报.比年初增长率:归属于母公司股东的每股净资产
    return w.wss(security,"performanceexpress_bps_growth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressToTAssetsGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩快报.比年初增长率:总资产时间序列
    return w.wsd(security,"performanceexpress_totassets_growth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressToTAssetsGrowth(security:list,*args,**kwargs):
    # 获取业绩快报.比年初增长率:总资产
    return w.wss(security,"performanceexpress_totassets_growth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressLastRpTDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新业绩快报报告期时间序列
    return w.wsd(security,"performanceexpress_lastrptdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceExpressLastRpTDate(security:list,*args,**kwargs):
    # 获取最新业绩快报报告期
    return w.wss(security,"performanceexpress_lastrptdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelatedCbYearlyAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度可转债发行量时间序列
    return w.wsd(security,"relatedcb_yearlyamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelatedCbYearlyAmount(security:list,*args,**kwargs):
    # 获取年度可转债发行量
    return w.wss(security,"relatedcb_yearlyamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCoordinatorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金发行协调人时间序列
    return w.wsd(security,"issue_coordinator",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCoordinator(security:list,*args,**kwargs):
    # 获取基金发行协调人
    return w.wss(security,"issue_coordinator",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuePriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市基金发行价格时间序列
    return w.wsd(security,"issue_price",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuePrice(security:list,*args,**kwargs):
    # 获取上市基金发行价格
    return w.wss(security,"issue_price",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs82Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金分红收益_FUND时间序列
    return w.wsd(security,"stm_is_82",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs82(security:list,*args,**kwargs):
    # 获取基金分红收益_FUND
    return w.wss(security,"stm_is_82",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundScaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金规模时间序列
    return w.wsd(security,"fund_fundscale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundScale(security:list,*args,**kwargs):
    # 获取基金规模
    return w.wss(security,"fund_fundscale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetAssetTotalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金规模(合计)时间序列
    return w.wsd(security,"netasset_total",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetAssetTotal(security:list,*args,**kwargs):
    # 获取基金规模(合计)
    return w.wss(security,"netasset_total",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国民经济行业分类时间序列
    return w.wsd(security,"industry_nc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNc(security:list,*args,**kwargs):
    # 获取所属国民经济行业分类
    return w.wss(security,"industry_nc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理层年度薪酬总额时间序列
    return w.wsd(security,"stmnote_mgmt_ben",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBen(security:list,*args,**kwargs):
    # 获取管理层年度薪酬总额
    return w.wss(security,"stmnote_mgmt_ben",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceMhSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理层增持价格时间序列
    return w.wsd(security,"holder_price_mh",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceMh(security:list,*args,**kwargs):
    # 获取管理层增持价格
    return w.wss(security,"holder_price_mh",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中资中介机构持股数量时间序列
    return w.wsd(security,"share_CN",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareCn(security:list,*args,**kwargs):
    # 获取中资中介机构持股数量
    return w.wss(security,"share_CN",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国际中介机构持股数量时间序列
    return w.wsd(security,"share_OS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOs(security:list,*args,**kwargs):
    # 获取国际中介机构持股数量
    return w.wss(security,"share_OS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中资中介机构持股占比时间序列
    return w.wsd(security,"share_pct_CN",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctCn(security:list,*args,**kwargs):
    # 获取中资中介机构持股占比
    return w.wss(security,"share_pct_CN",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctOsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国际中介机构持股占比时间序列
    return w.wsd(security,"share_pct_OS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctOs(security:list,*args,**kwargs):
    # 获取国际中介机构持股占比
    return w.wss(security,"share_pct_OS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取香港本地中介机构持股数量时间序列
    return w.wsd(security,"share_HK",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHk(security:list,*args,**kwargs):
    # 获取香港本地中介机构持股数量
    return w.wss(security,"share_HK",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取香港本地中介机构持股占比时间序列
    return w.wsd(security,"share_pct_HK",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHk(security:list,*args,**kwargs):
    # 获取香港本地中介机构持股占比
    return w.wss(security,"share_pct_HK",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构调研家数时间序列
    return w.wsd(security,"ir_noii",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIi(security:list,*args,**kwargs):
    # 获取机构调研家数
    return w.wss(security,"ir_noii",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrIRfdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构调研首日时间序列
    return w.wsd(security,"ir_irfd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrIRfd(security:list,*args,**kwargs):
    # 获取机构调研首日
    return w.wss(security,"ir_irfd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrIrlDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构调研最新日时间序列
    return w.wsd(security,"ir_irld",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrIrlD(security:list,*args,**kwargs):
    # 获取机构调研最新日
    return w.wss(security,"ir_irld",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoSoIiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资机构调研次数时间序列
    return w.wsd(security,"ir_nosoii",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoSoIi(security:list,*args,**kwargs):
    # 获取投资机构调研次数
    return w.wss(security,"ir_nosoii",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIiiiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资机构调研家数时间序列
    return w.wsd(security,"ir_noiiii",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIiii(security:list,*args,**kwargs):
    # 获取投资机构调研家数
    return w.wss(security,"ir_noiiii",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNosOfISeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资机构调研次数时间序列
    return w.wsd(security,"ir_nosofi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNosOfI(security:list,*args,**kwargs):
    # 获取外资机构调研次数
    return w.wss(security,"ir_nosofi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIiFiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资机构调研家数时间序列
    return w.wsd(security,"ir_noiifi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoIiFi(security:list,*args,**kwargs):
    # 获取外资机构调研家数
    return w.wss(security,"ir_noiifi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通A股占总股本比例时间序列
    return w.wsd(security,"share_liqa_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPct(security:list,*args,**kwargs):
    # 获取流通A股占总股本比例
    return w.wss(security,"share_liqa_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售A股占总股本比例时间序列
    return w.wsd(security,"share_restricteda_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPct(security:list,*args,**kwargs):
    # 获取限售A股占总股本比例
    return w.wss(security,"share_restricteda_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalAPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取A股合计占总股本比例时间序列
    return w.wsd(security,"share_totala_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalAPct(security:list,*args,**kwargs):
    # 获取A股合计占总股本比例
    return w.wss(security,"share_totala_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqBPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通B股占总股本比例时间序列
    return w.wsd(security,"share_liqb_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqBPct(security:list,*args,**kwargs):
    # 获取流通B股占总股本比例
    return w.wss(security,"share_liqb_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedBPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售B股占总股本比例时间序列
    return w.wsd(security,"share_restrictedb_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedBPct(security:list,*args,**kwargs):
    # 获取限售B股占总股本比例
    return w.wss(security,"share_restrictedb_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalBPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取B股合计占总股本比例时间序列
    return w.wsd(security,"share_totalb_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalBPct(security:list,*args,**kwargs):
    # 获取B股合计占总股本比例
    return w.wss(security,"share_totalb_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcAPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取三板A股占总股本比例时间序列
    return w.wsd(security,"share_otca_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcAPct(security:list,*args,**kwargs):
    # 获取三板A股占总股本比例
    return w.wss(security,"share_otca_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcBPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取三板B股占总股本比例时间序列
    return w.wsd(security,"share_otcb_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcBPct(security:list,*args,**kwargs):
    # 获取三板B股占总股本比例
    return w.wss(security,"share_otcb_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalOtcPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取三板合计占总股本比例时间序列
    return w.wsd(security,"share_totalotc_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalOtcPct(security:list,*args,**kwargs):
    # 获取三板合计占总股本比例
    return w.wss(security,"share_totalotc_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqHPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取香港上市股占总股本比例时间序列
    return w.wsd(security,"share_liqh_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqHPct(security:list,*args,**kwargs):
    # 获取香港上市股占总股本比例
    return w.wss(security,"share_liqh_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOverSeaPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取海外上市股占总股本比例时间序列
    return w.wsd(security,"share_oversea_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOverSeaPct(security:list,*args,**kwargs):
    # 获取海外上市股占总股本比例
    return w.wss(security,"share_oversea_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradablePctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股合计占总股本比例时间序列
    return w.wsd(security,"share_tradable_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradablePct(security:list,*args,**kwargs):
    # 获取流通股合计占总股本比例
    return w.wss(security,"share_tradable_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股合计占总股本比例时间序列
    return w.wsd(security,"share_restricted_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedPct(security:list,*args,**kwargs):
    # 获取限售股合计占总股本比例
    return w.wss(security,"share_restricted_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFreeFloatsHrPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自由流通股占总股本比例时间序列
    return w.wsd(security,"share_freefloatshr_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFreeFloatsHrPct(security:list,*args,**kwargs):
    # 获取自由流通股占总股本比例
    return w.wss(security,"share_freefloatshr_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellShortIntRestPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未平仓卖空数占总股本比例时间序列
    return w.wsd(security,"shortsell_shortintrestpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellShortIntRestPct(security:list,*args,**kwargs):
    # 获取未平仓卖空数占总股本比例
    return w.wss(security,"shortsell_shortintrestpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradablePctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股改前非流通股占总股本比例时间序列
    return w.wsd(security,"share_nontradable_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradablePct(security:list,*args,**kwargs):
    # 获取股改前非流通股占总股本比例
    return w.wss(security,"share_nontradable_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押股份数量合计时间序列
    return w.wsd(security,"share_pledgeda",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedA(security:list,*args,**kwargs):
    # 获取质押股份数量合计
    return w.wss(security,"share_pledgeda",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitTotalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额时间序列
    return w.wsd(security,"unit_total",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitTotal(security:list,*args,**kwargs):
    # 获取基金份额
    return w.wss(security,"unit_total",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFundShareTotalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额(合计)时间序列
    return w.wsd(security,"unit_fundshare_total",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFundShareTotal(security:list,*args,**kwargs):
    # 获取基金份额(合计)
    return w.wss(security,"unit_fundshare_total",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额变化时间序列
    return w.wsd(security,"unit_change",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChange(security:list,*args,**kwargs):
    # 获取基金份额变化
    return w.wss(security,"unit_change",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChangeRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额变化率时间序列
    return w.wsd(security,"unit_changerate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChangeRate(security:list,*args,**kwargs):
    # 获取基金份额变化率
    return w.wss(security,"unit_changerate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额持有人户数时间序列
    return w.wsd(security,"holder_number",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumber(security:list,*args,**kwargs):
    # 获取基金份额持有人户数
    return w.wss(security,"holder_number",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTotalNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额持有人户数(合计)时间序列
    return w.wsd(security,"fund_holder_totalnumber",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTotalNumber(security:list,*args,**kwargs):
    # 获取基金份额持有人户数(合计)
    return w.wss(security,"fund_holder_totalnumber",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChangeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金份额变动日期时间序列
    return w.wsd(security,"unit_changedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitChangeDate(security:list,*args,**kwargs):
    # 获取基金份额变动日期
    return w.wss(security,"unit_changedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNavChange9Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取本期基金份额交易产生的基金净值变动数时间序列
    return w.wsd(security,"stm_navchange_9",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNavChange9(security:list,*args,**kwargs):
    # 获取本期基金份额交易产生的基金净值变动数
    return w.wss(security,"stm_navchange_9",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundShareTranslationDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取ETF基金份额折算日时间序列
    return w.wsd(security,"fund_fundsharetranslationdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundShareTranslationDate(security:list,*args,**kwargs):
    # 获取ETF基金份额折算日
    return w.wss(security,"fund_fundsharetranslationdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundShareTranslationRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取ETF基金份额折算比例时间序列
    return w.wsd(security,"fund_fundsharetranslationratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundShareTranslationRatio(security:list,*args,**kwargs):
    # 获取ETF基金份额折算比例
    return w.wss(security,"fund_fundsharetranslationratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNavChange10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取本期向基金份额持有人分配利润产生的基金净值变动数时间序列
    return w.wsd(security,"stm_navchange_10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNavChange10(security:list,*args,**kwargs):
    # 获取本期向基金份额持有人分配利润产生的基金净值变动数
    return w.wss(security,"stm_navchange_10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNavReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.基金份额净值增长率时间序列
    return w.wsd(security,"qanal_navreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNavReturn(security:list,*args,**kwargs):
    # 获取单季度.基金份额净值增长率
    return w.wss(security,"qanal_navreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalStdNavReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.基金份额净值增长率标准差时间序列
    return w.wsd(security,"qanal_stdnavreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalStdNavReturn(security:list,*args,**kwargs):
    # 获取单季度.基金份额净值增长率标准差
    return w.wss(security,"qanal_stdnavreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取平均每户持有基金份额时间序列
    return w.wsd(security,"holder_avgholding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgHolding(security:list,*args,**kwargs):
    # 获取平均每户持有基金份额
    return w.wss(security,"holder_avgholding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAccumulatedNavReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.累计基金份额净值增长率时间序列
    return w.wsd(security,"qanal_accumulatednavreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAccumulatedNavReturn(security:list,*args,**kwargs):
    # 获取单季度.累计基金份额净值增长率
    return w.wss(security,"qanal_accumulatednavreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAvgNetIncomePerUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.加权平均基金份额本期利润时间序列
    return w.wsd(security,"qanal_avgnetincomeperunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAvgNetIncomePerUnit(security:list,*args,**kwargs):
    # 获取单季度.加权平均基金份额本期利润
    return w.wss(security,"qanal_avgnetincomeperunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAvgUnitIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.加权平均基金份额本期净收益时间序列
    return w.wsd(security,"qanal_avgunitincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalAvgUnitIncome(security:list,*args,**kwargs):
    # 获取单季度.加权平均基金份额本期净收益
    return w.wss(security,"qanal_avgunitincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnalDIsTriButAblePerUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期末可供分配基金份额利润时间序列
    return w.wsd(security,"anal_distributableperunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnalDIsTriButAblePerUnit(security:list,*args,**kwargs):
    # 获取报告期末可供分配基金份额利润
    return w.wss(security,"anal_distributableperunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.报告期期末基金份额净值时间序列
    return w.wsd(security,"qanal_nav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNav(security:list,*args,**kwargs):
    # 获取单季度.报告期期末基金份额净值
    return w.wss(security,"qanal_nav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股东户数时间序列
    return w.wsd(security,"holder_num",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNum(security:list,*args,**kwargs):
    # 获取股东户数
    return w.wss(security,"holder_num",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构持股数量合计时间序列
    return w.wsd(security,"holder_totalbyinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByInSt(security:list,*args,**kwargs):
    # 获取机构持股数量合计
    return w.wss(security,"holder_totalbyinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构持股比例合计时间序列
    return w.wsd(security,"holder_pctbyinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByInSt(security:list,*args,**kwargs):
    # 获取机构持股比例合计
    return w.wss(security,"holder_pctbyinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSHClearL1TypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上清所债券分类时间序列
    return w.wsd(security,"shclearl1type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSHClearL1Type(security:list,*args,**kwargs):
    # 获取上清所债券分类
    return w.wss(security,"shclearl1type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateOfStdBndSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标准券折算比例时间序列
    return w.wsd(security,"rateofstdbnd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateOfStdBnd(security:list,*args,**kwargs):
    # 获取标准券折算比例
    return w.wss(security,"rateofstdbnd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ToSharePriceAdjustItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转股条款时间序列
    return w.wsd(security,"clause_conversion2_tosharepriceadjustitem",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ToSharePriceAdjustItem(security:list,*args,**kwargs):
    # 获取转股条款
    return w.wss(security,"clause_conversion2_tosharepriceadjustitem",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回条款时间序列
    return w.wsd(security,"clause_calloption_redeemitem",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemItem(security:list,*args,**kwargs):
    # 获取赎回条款
    return w.wss(security,"clause_calloption_redeemitem",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时点赎回条款全文时间序列
    return w.wsd(security,"clause_calloption_redeemclause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemClause(security:list,*args,**kwargs):
    # 获取时点赎回条款全文
    return w.wss(security,"clause_calloption_redeemclause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMassRedemptionProvisionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取巨额赎回条款时间序列
    return w.wsd(security,"massredemptionprovision",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMassRedemptionProvision(security:list,*args,**kwargs):
    # 获取巨额赎回条款
    return w.wss(security,"massredemptionprovision",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionIsWithTimeRedemptionClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否有时点赎回条款时间序列
    return w.wsd(security,"clause_calloption_iswithtimeredemptionclause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionIsWithTimeRedemptionClause(security:list,*args,**kwargs):
    # 获取是否有时点赎回条款
    return w.wss(security,"clause_calloption_iswithtimeredemptionclause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionSellBackItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取条件回售条款全文时间序列
    return w.wsd(security,"clause_putoption_sellbackitem",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionSellBackItem(security:list,*args,**kwargs):
    # 获取条件回售条款全文
    return w.wss(security,"clause_putoption_sellbackitem",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTimePutBackClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时点回售条款全文时间序列
    return w.wsd(security,"clause_putoption_timeputbackclause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTimePutBackClause(security:list,*args,**kwargs):
    # 获取时点回售条款全文
    return w.wss(security,"clause_putoption_timeputbackclause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无条件回售条款时间序列
    return w.wsd(security,"clause_putoption_putbackclause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackClause(security:list,*args,**kwargs):
    # 获取无条件回售条款
    return w.wss(security,"clause_putoption_putbackclause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingLatestMonthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新评级月份时间序列
    return w.wsd(security,"rating_latestmonth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingLatestMonth(security:list,*args,**kwargs):
    # 获取最新评级月份
    return w.wss(security,"rating_latestmonth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级时间序列
    return w.wsd(security,"latestissurercreditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRating(security:list,*args,**kwargs):
    # 获取发行人最新评级
    return w.wss(security,"latestissurercreditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingOutlooksSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级展望时间序列
    return w.wsd(security,"ratingoutlooks",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingOutlooks(security:list,*args,**kwargs):
    # 获取发行人最新评级展望
    return w.wss(security,"ratingoutlooks",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRatingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级日期时间序列
    return w.wsd(security,"latestissurercreditratingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRatingDate(security:list,*args,**kwargs):
    # 获取发行人最新评级日期
    return w.wss(security,"latestissurercreditratingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestRatingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级日期(指定机构)时间序列
    return w.wsd(security,"latestratingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestRatingDate(security:list,*args,**kwargs):
    # 获取发行人最新评级日期(指定机构)
    return w.wss(security,"latestratingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateIssuerChNgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级变动方向时间序列
    return w.wsd(security,"rate_lateissuerchng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateIssuerChNg(security:list,*args,**kwargs):
    # 获取发行人最新评级变动方向
    return w.wss(security,"rate_lateissuerchng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRatingTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新评级评级类型时间序列
    return w.wsd(security,"latestissurercreditratingtype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRatingType(security:list,*args,**kwargs):
    # 获取发行人最新评级评级类型
    return w.wss(security,"latestissurercreditratingtype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestRatingOfGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人最新评级时间序列
    return w.wsd(security,"latestratingofguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestRatingOfGuarantor(security:list,*args,**kwargs):
    # 获取担保人最新评级
    return w.wss(security,"latestratingofguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuarantorFwdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人最新评级展望时间序列
    return w.wsd(security,"rate_lateguarantorfwd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuarantorFwd(security:list,*args,**kwargs):
    # 获取担保人最新评级展望
    return w.wss(security,"rate_lateguarantorfwd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuarantorDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人最新评级日期时间序列
    return w.wsd(security,"rate_lateguarantordate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuarantorDate(security:list,*args,**kwargs):
    # 获取担保人最新评级日期
    return w.wss(security,"rate_lateguarantordate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuaranTorchNgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人最新评级变动方向时间序列
    return w.wsd(security,"rate_lateguarantorchng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLateGuaranTorchNg(security:list,*args,**kwargs):
    # 获取担保人最新评级变动方向
    return w.wss(security,"rate_lateguarantorchng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateBond2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券国际评级时间序列
    return w.wsd(security,"ratebond2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateBond2(security:list,*args,**kwargs):
    # 获取债券国际评级
    return w.wss(security,"ratebond2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuer2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人国际评级时间序列
    return w.wsd(security,"issuer2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuer2(security:list,*args,**kwargs):
    # 获取发行人国际评级
    return w.wss(security,"issuer2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回购代码时间序列
    return w.wsd(security,"repo_code",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoCode(security:list,*args,**kwargs):
    # 获取回购代码
    return w.wss(security,"repo_code",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoUBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的债券时间序列
    return w.wsd(security,"repo_ubond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoUBond(security:list,*args,**kwargs):
    # 获取标的债券
    return w.wss(security,"repo_ubond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmUbonDouStandingAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时标的债券余额时间序列
    return w.wsd(security,"crm_ubondoustandingamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmUbonDouStandingAmount(security:list,*args,**kwargs):
    # 获取发行时标的债券余额
    return w.wss(security,"crm_ubondoustandingamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回购类型时间序列
    return w.wsd(security,"repo_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoType(security:list,*args,**kwargs):
    # 获取回购类型
    return w.wss(security,"repo_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回购天数时间序列
    return w.wsd(security,"repo_days",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoDays(security:list,*args,**kwargs):
    # 获取回购天数
    return w.wss(security,"repo_days",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmCarryDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取凭证起始日时间序列
    return w.wsd(security,"crm_carrydate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmCarryDate(security:list,*args,**kwargs):
    # 获取凭证起始日
    return w.wss(security,"crm_carrydate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmSubjectCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的实体交易代码时间序列
    return w.wsd(security,"crm_subjectcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmSubjectCode(security:list,*args,**kwargs):
    # 获取标的实体交易代码
    return w.wss(security,"crm_subjectcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPerformGuaranteeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取履约保障机制时间序列
    return w.wsd(security,"crm_performguarantee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPerformGuarantee(security:list,*args,**kwargs):
    # 获取履约保障机制
    return w.wss(security,"crm_performguarantee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmCreditEventSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信用事件时间序列
    return w.wsd(security,"crm_creditevent",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmCreditEvent(security:list,*args,**kwargs):
    # 获取信用事件
    return w.wss(security,"crm_creditevent",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditBondCreditStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券信用状态时间序列
    return w.wsd(security,"credit_bondcreditstatus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditBondCreditStatus(security:list,*args,**kwargs):
    # 获取债券信用状态
    return w.wss(security,"credit_bondcreditstatus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerFirstDefaultDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人首次违约日时间序列
    return w.wsd(security,"issuerfirstdefaultdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerFirstDefaultDate(security:list,*args,**kwargs):
    # 获取发行人首次违约日
    return w.wss(security,"issuerfirstdefaultdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmRegisterAgencySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取登记机构时间序列
    return w.wsd(security,"crm_registeragency",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmRegisterAgency(security:list,*args,**kwargs):
    # 获取登记机构
    return w.wss(security,"crm_registeragency",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmSubjectSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的实体时间序列
    return w.wsd(security,"crm_subject",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmSubject(security:list,*args,**kwargs):
    # 获取标的实体
    return w.wss(security,"crm_subject",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发布机构时间序列
    return w.wsd(security,"crm_issuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmIssuer(security:list,*args,**kwargs):
    # 获取发布机构
    return w.wss(security,"crm_issuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmBookkeepingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取簿记建档日时间序列
    return w.wsd(security,"crm_bookkeepingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmBookkeepingDate(security:list,*args,**kwargs):
    # 获取簿记建档日
    return w.wss(security,"crm_bookkeepingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPaymentTermsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取付费方式时间序列
    return w.wsd(security,"crm_paymentterms",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPaymentTerms(security:list,*args,**kwargs):
    # 获取付费方式
    return w.wss(security,"crm_paymentterms",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmStartingPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取创设价格时间序列
    return w.wsd(security,"crm_startingprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmStartingPrice(security:list,*args,**kwargs):
    # 获取创设价格
    return w.wss(security,"crm_startingprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPermissionNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取创设批准文件编号时间序列
    return w.wsd(security,"crm_permissionnumber",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmPermissionNumber(security:list,*args,**kwargs):
    # 获取创设批准文件编号
    return w.wss(security,"crm_permissionnumber",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmDateOfRecordSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取凭证登记日时间序列
    return w.wsd(security,"crm_dateofrecord",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrmDateOfRecord(security:list,*args,**kwargs):
    # 获取凭证登记日
    return w.wss(security,"crm_dateofrecord",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThirdPartyFundTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第三方基金分类时间序列
    return w.wsd(security,"fund_thirdpartyfundtype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThirdPartyFundType(security:list,*args,**kwargs):
    # 获取第三方基金分类
    return w.wss(security,"fund_thirdpartyfundtype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundProdTypeOcWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Wind封闭式开放式基金分类时间序列
    return w.wsd(security,"fund_prodtypeoc_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundProdTypeOcWind(security:list,*args,**kwargs):
    # 获取Wind封闭式开放式基金分类
    return w.wss(security,"fund_prodtypeoc_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundManagerOfTradeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理时间序列
    return w.wsd(security,"fund_fundmanageroftradedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundManagerOfTradeDate(security:list,*args,**kwargs):
    # 获取基金经理
    return w.wss(security,"fund_fundmanageroftradedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理(现任)时间序列
    return w.wsd(security,"fund_fundmanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundManager(security:list,*args,**kwargs):
    # 获取基金经理(现任)
    return w.wss(security,"fund_fundmanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPRedFundManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理(历任)时间序列
    return w.wsd(security,"fund_predfundmanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPRedFundManager(security:list,*args,**kwargs):
    # 获取基金经理(历任)
    return w.wss(security,"fund_predfundmanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInceptionFundManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理(成立)时间序列
    return w.wsd(security,"fund_inceptionfundmanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInceptionFundManager(security:list,*args,**kwargs):
    # 获取基金经理(成立)
    return w.wss(security,"fund_inceptionfundmanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerManagerWorkingYearsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理年限时间序列
    return w.wsd(security,"fund_manager_managerworkingyears",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerManagerWorkingYears(security:list,*args,**kwargs):
    # 获取基金经理年限
    return w.wss(security,"fund_manager_managerworkingyears",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAverageWorkingYearsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理平均年限时间序列
    return w.wsd(security,"fund_averageworkingyears",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAverageWorkingYears(security:list,*args,**kwargs):
    # 获取基金经理平均年限
    return w.wss(security,"fund_averageworkingyears",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaxWorkingYearsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理最大年限时间序列
    return w.wsd(security,"fund_maxworkingyears",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaxWorkingYears(security:list,*args,**kwargs):
    # 获取基金经理最大年限
    return w.wss(security,"fund_maxworkingyears",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数区间回报(算术平均)时间序列
    return w.wsd(security,"fund_managerindex_return",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexReturn(security:list,*args,**kwargs):
    # 获取基金经理指数区间回报(算术平均)
    return w.wss(security,"fund_managerindex_return",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexStDevSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数收益标准差(算术平均)时间序列
    return w.wsd(security,"fund_managerindex_stdev",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexStDev(security:list,*args,**kwargs):
    # 获取基金经理指数收益标准差(算术平均)
    return w.wss(security,"fund_managerindex_stdev",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexStDevYearlySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数年化波动率(算术平均)时间序列
    return w.wsd(security,"fund_managerindex_stdevyearly",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexStDevYearly(security:list,*args,**kwargs):
    # 获取基金经理指数年化波动率(算术平均)
    return w.wss(security,"fund_managerindex_stdevyearly",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexMaxDownsideSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数最大回撤(算术平均)时间序列
    return w.wsd(security,"fund_managerindex_maxdownside",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexMaxDownside(security:list,*args,**kwargs):
    # 获取基金经理指数最大回撤(算术平均)
    return w.wss(security,"fund_managerindex_maxdownside",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数区间回报(规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_return",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightReturn(security:list,*args,**kwargs):
    # 获取基金经理指数区间回报(规模加权)
    return w.wss(security,"fund_managerindex_weight_return",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightStDevSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数收益标准差(规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_stdev",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightStDev(security:list,*args,**kwargs):
    # 获取基金经理指数收益标准差(规模加权)
    return w.wss(security,"fund_managerindex_weight_stdev",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightStDevYearlySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数年化波动率(规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_stdevyearly",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightStDevYearly(security:list,*args,**kwargs):
    # 获取基金经理指数年化波动率(规模加权)
    return w.wss(security,"fund_managerindex_weight_stdevyearly",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightMaxDownsideSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理指数最大回撤(规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_maxdownside",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightMaxDownside(security:list,*args,**kwargs):
    # 获取基金经理指数最大回撤(规模加权)
    return w.wss(security,"fund_managerindex_weight_maxdownside",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagersNoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理数时间序列
    return w.wsd(security,"fund_corp_fundmanagersno",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagersNo(security:list,*args,**kwargs):
    # 获取基金经理数
    return w.wss(security,"fund_corp_fundmanagersno",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagerMaturitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金经理成熟度时间序列
    return w.wsd(security,"fund_corp_fundmanagermaturity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagerMaturity(security:list,*args,**kwargs):
    # 获取基金经理成熟度
    return w.wss(security,"fund_corp_fundmanagermaturity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerProxyForManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取代管基金经理说明时间序列
    return w.wsd(security,"fund_manager_proxyformanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerProxyForManager(security:list,*args,**kwargs):
    # 获取代管基金经理说明
    return w.wss(security,"fund_manager_proxyformanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexBetaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Beta(基金经理指数,算术平均)时间序列
    return w.wsd(security,"fund_managerindex_beta",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexBeta(security:list,*args,**kwargs):
    # 获取Beta(基金经理指数,算术平均)
    return w.wss(security,"fund_managerindex_beta",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightBetaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Beta(基金经理指数,规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_beta",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightBeta(security:list,*args,**kwargs):
    # 获取Beta(基金经理指数,规模加权)
    return w.wss(security,"fund_managerindex_weight_beta",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexAlphaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Alpha(基金经理指数,算术平均)时间序列
    return w.wsd(security,"fund_managerindex_alpha",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexAlpha(security:list,*args,**kwargs):
    # 获取Alpha(基金经理指数,算术平均)
    return w.wss(security,"fund_managerindex_alpha",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightAlphaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Alpha(基金经理指数,规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_alpha",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightAlpha(security:list,*args,**kwargs):
    # 获取Alpha(基金经理指数,规模加权)
    return w.wss(security,"fund_managerindex_weight_alpha",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexSharpeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Sharpe(基金经理指数,算术平均)时间序列
    return w.wsd(security,"fund_managerindex_sharpe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexSharpe(security:list,*args,**kwargs):
    # 获取Sharpe(基金经理指数,算术平均)
    return w.wss(security,"fund_managerindex_sharpe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightSharpeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Sharpe(基金经理指数,规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_sharpe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightSharpe(security:list,*args,**kwargs):
    # 获取Sharpe(基金经理指数,规模加权)
    return w.wss(security,"fund_managerindex_weight_sharpe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexTreyNorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Treynor(基金经理指数,算术平均)时间序列
    return w.wsd(security,"fund_managerindex_treynor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexTreyNor(security:list,*args,**kwargs):
    # 获取Treynor(基金经理指数,算术平均)
    return w.wss(security,"fund_managerindex_treynor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightTreyNorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Treynor(基金经理指数,规模加权)时间序列
    return w.wsd(security,"fund_managerindex_weight_treynor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerIndexWeightTreyNor(security:list,*args,**kwargs):
    # 获取Treynor(基金经理指数,规模加权)
    return w.wss(security,"fund_managerindex_weight_treynor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerLongestFundManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取任职期限最长的现任基金经理时间序列
    return w.wsd(security,"fund_manager_longestfundmanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerLongestFundManager(security:list,*args,**kwargs):
    # 获取任职期限最长的现任基金经理
    return w.wss(security,"fund_manager_longestfundmanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrFcsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金公司调研次数时间序列
    return w.wsd(security,"ir_fcs",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrFcs(security:list,*args,**kwargs):
    # 获取基金公司调研次数
    return w.wss(security,"ir_fcs",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoFciSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金公司调研家数时间序列
    return w.wsd(security,"ir_nofci",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrNoFci(security:list,*args,**kwargs):
    # 获取基金公司调研家数
    return w.wss(security,"ir_nofci",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售数量时间序列
    return w.wsd(security,"fund__reitsfms",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmS(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售数量
    return w.wss(security,"fund__reitsfms",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售金额时间序列
    return w.wsd(security,"fund__reitsfmm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMm(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售金额
    return w.wss(security,"fund__reitsfmm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售份额占比时间序列
    return w.wsd(security,"fund__reitsfmr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMr(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管子公司配售份额占比
    return w.wss(security,"fund__reitsfmr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmAsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管计划配售数量时间序列
    return w.wsd(security,"fund__reitsfmas",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmAs(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管计划配售数量
    return w.wss(security,"fund__reitsfmas",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmAmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管机构配售金额时间序列
    return w.wsd(security,"fund__reitsfmam",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFmAm(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管机构配售金额
    return w.wss(security,"fund__reitsfmam",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMarSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下基金公司或其资管计划配售份额占比时间序列
    return w.wsd(security,"fund__reitsfmar",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsFMar(security:list,*args,**kwargs):
    # 获取网下基金公司或其资管计划配售份额占比
    return w.wss(security,"fund__reitsfmar",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueHoldingIndustryMktValue2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属基金公司重仓行业市值时间序列
    return w.wsd(security,"prt_stockvalue_holdingindustrymktvalue2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueHoldingIndustryMktValue2(security:list,*args,**kwargs):
    # 获取所属基金公司重仓行业市值
    return w.wss(security,"prt_stockvalue_holdingindustrymktvalue2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrTmRfcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取调研最多的基金公司时间序列
    return w.wsd(security,"ir_tmrfc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIrTmRfc(security:list,*args,**kwargs):
    # 获取调研最多的基金公司
    return w.wss(security,"ir_tmrfc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开始交易日时间序列
    return w.wsd(security,"ftdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtDate(security:list,*args,**kwargs):
    # 获取开始交易日
    return w.wss(security,"ftdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtDateNewSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开始交易日(支持历史)时间序列
    return w.wsd(security,"ftdate_new",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtDateNew(security:list,*args,**kwargs):
    # 获取开始交易日(支持历史)
    return w.wss(security,"ftdate_new",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交易日时间序列
    return w.wsd(security,"lasttrade_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradeDate(security:list,*args,**kwargs):
    # 获取最后交易日
    return w.wss(security,"lasttrade_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtDateNewSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交易日(支持历史)时间序列
    return w.wsd(security,"ltdate_new",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtDateNew(security:list,*args,**kwargs):
    # 获取最后交易日(支持历史)
    return w.wss(security,"ltdate_new",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtDatedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交易日说明时间序列
    return w.wsd(security,"ltdated",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtDated(security:list,*args,**kwargs):
    # 获取最后交易日说明
    return w.wss(security,"ltdated",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交易日期时间序列
    return w.wsd(security,"lasttradingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradingDate(security:list,*args,**kwargs):
    # 获取最后交易日期
    return w.wss(security,"lasttradingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivLastTrDDateShareBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取B股最后交易日时间序列
    return w.wsd(security,"div_lasttrddateshareb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivLastTrDDateShareB(security:list,*args,**kwargs):
    # 获取B股最后交易日
    return w.wss(security,"div_lasttrddateshareb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradingDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)最后交易日时间序列
    return w.wsd(security,"lasttradingday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradingDay(security:list,*args,**kwargs):
    # 获取(废弃)最后交易日
    return w.wss(security,"lasttradingday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRightsIssueRegDateShareBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股权登记日(B股最后交易日)时间序列
    return w.wsd(security,"rightsissue_regdateshareb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRightsIssueRegDateShareB(security:list,*args,**kwargs):
    # 获取股权登记日(B股最后交易日)
    return w.wss(security,"rightsissue_regdateshareb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastDeliveryDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交割日时间序列
    return w.wsd(security,"lastdelivery_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastDeliveryDate(security:list,*args,**kwargs):
    # 获取最后交割日
    return w.wss(security,"lastdelivery_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLdDateNewSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后交割日(支持历史)时间序列
    return w.wsd(security,"lddate_new",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLdDateNew(security:list,*args,**kwargs):
    # 获取最后交割日(支持历史)
    return w.wss(security,"lddate_new",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDlMonthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交割月份时间序列
    return w.wsd(security,"dlmonth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDlMonth(security:list,*args,**kwargs):
    # 获取交割月份
    return w.wss(security,"dlmonth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌基准价时间序列
    return w.wsd(security,"lprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLPrice(security:list,*args,**kwargs):
    # 获取挂牌基准价
    return w.wss(security,"lprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTransactionFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货交易手续费时间序列
    return w.wsd(security,"transactionfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTransactionFee(security:list,*args,**kwargs):
    # 获取期货交易手续费
    return w.wss(security,"transactionfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeliveryFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货交割手续费时间序列
    return w.wsd(security,"deliveryfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeliveryFee(security:list,*args,**kwargs):
    # 获取期货交割手续费
    return w.wss(security,"deliveryfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTodayPositionFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货平今手续费时间序列
    return w.wsd(security,"todaypositionfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTodayPositionFee(security:list,*args,**kwargs):
    # 获取期货平今手续费
    return w.wss(security,"todaypositionfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getScCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易品种时间序列
    return w.wsd(security,"sccode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getScCode(security:list,*args,**kwargs):
    # 获取交易品种
    return w.wss(security,"sccode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易保证金时间序列
    return w.wsd(security,"margin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMargin(security:list,*args,**kwargs):
    # 获取交易保证金
    return w.wss(security,"margin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtMarginsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最初交易保证金时间序列
    return w.wsd(security,"ftmargins",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFtMargins(security:list,*args,**kwargs):
    # 获取最初交易保证金
    return w.wss(security,"ftmargins",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1853Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取权益乘数(剔除客户交易保证金)时间序列
    return w.wsd(security,"stmnote_sec_1853",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1853(security:list,*args,**kwargs):
    # 获取权益乘数(剔除客户交易保证金)
    return w.wss(security,"stmnote_sec_1853",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLongMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货多头保证金(支持历史)时间序列
    return w.wsd(security,"long_margin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLongMargin(security:list,*args,**kwargs):
    # 获取期货多头保证金(支持历史)
    return w.wss(security,"long_margin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货空头保证金(支持历史)时间序列
    return w.wsd(security,"short_margin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortMargin(security:list,*args,**kwargs):
    # 获取期货空头保证金(支持历史)
    return w.wss(security,"short_margin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPunItSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报价单位时间序列
    return w.wsd(security,"punit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPunIt(security:list,*args,**kwargs):
    # 获取报价单位
    return w.wss(security,"punit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChangeLtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅限制时间序列
    return w.wsd(security,"changelt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChangeLt(security:list,*args,**kwargs):
    # 获取涨跌幅限制
    return w.wss(security,"changelt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChangeLtNewSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅限制(支持历史)时间序列
    return w.wsd(security,"changelt_new",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChangeLtNew(security:list,*args,**kwargs):
    # 获取涨跌幅限制(支持历史)
    return w.wss(security,"changelt_new",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最小变动价位时间序列
    return w.wsd(security,"mfprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfPrice(security:list,*args,**kwargs):
    # 获取最小变动价位
    return w.wss(security,"mfprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfPrice1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取最小变动价位(支持历史)时间序列
    return w.wsd(security,"mfprice1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfPrice1(security:list,*args,**kwargs):
    # 获取最小变动价位(支持历史)
    return w.wss(security,"mfprice1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getContractIssueDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标准合约上市日时间序列
    return w.wsd(security,"contract_issuedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getContractIssueDate(security:list,*args,**kwargs):
    # 获取标准合约上市日
    return w.wss(security,"contract_issuedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取合约乘数时间序列
    return w.wsd(security,"exe_ratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeRatio(security:list,*args,**kwargs):
    # 获取合约乘数
    return w.wss(security,"exe_ratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCdMonthsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取合约月份说明时间序列
    return w.wsd(security,"cdmonths",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCdMonths(security:list,*args,**kwargs):
    # 获取合约月份说明
    return w.wss(security,"cdmonths",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTHoursSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新交易时间说明时间序列
    return w.wsd(security,"thours",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTHours(security:list,*args,**kwargs):
    # 获取最新交易时间说明
    return w.wss(security,"thours",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交割日期说明时间序列
    return w.wsd(security,"ddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDDate(security:list,*args,**kwargs):
    # 获取交割日期说明
    return w.wss(security,"ddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeHisCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取月合约代码时间序列
    return w.wsd(security,"trade_hiscode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeHisCode(security:list,*args,**kwargs):
    # 获取月合约代码
    return w.wss(security,"trade_hiscode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryFuSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期货合约所属行业时间序列
    return w.wsd(security,"industry_fu",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryFu(security:list,*args,**kwargs):
    # 获取期货合约所属行业
    return w.wss(security,"industry_fu",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionsTradeCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期权代码(指定行权价)时间序列
    return w.wsd(security,"options_tradecode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionsTradeCode(security:list,*args,**kwargs):
    # 获取期权代码(指定行权价)
    return w.wss(security,"options_tradecode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAtmCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取平值期权代码时间序列
    return w.wsd(security,"atmcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAtmCode(security:list,*args,**kwargs):
    # 获取平值期权代码
    return w.wss(security,"atmcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期权交易代码时间序列
    return w.wsd(security,"tradecode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeCode(security:list,*args,**kwargs):
    # 获取期权交易代码
    return w.wss(security,"tradecode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的代码时间序列
    return w.wsd(security,"us_code",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsCode(security:list,*args,**kwargs):
    # 获取标的代码
    return w.wss(security,"us_code",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的简称时间序列
    return w.wsd(security,"us_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsName(security:list,*args,**kwargs):
    # 获取标的简称
    return w.wss(security,"us_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基础资产/标的类型时间序列
    return w.wsd(security,"us_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsType(security:list,*args,**kwargs):
    # 获取基础资产/标的类型
    return w.wss(security,"us_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeModeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权方式时间序列
    return w.wsd(security,"exe_mode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeMode(security:list,*args,**kwargs):
    # 获取行权方式
    return w.wss(security,"exe_mode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权类型时间序列
    return w.wsd(security,"exe_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeType(security:list,*args,**kwargs):
    # 获取行权类型
    return w.wss(security,"exe_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExePriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权价格时间序列
    return w.wsd(security,"exe_price",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExePrice(security:list,*args,**kwargs):
    # 获取行权价格
    return w.wss(security,"exe_price",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceStockBasedCompensationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股权激励行权价格时间序列
    return w.wsd(security,"holder_price_stockbasedcompensation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceStockBasedCompensation(security:list,*args,**kwargs):
    # 获取股权激励行权价格
    return w.wss(security,"holder_price_stockbasedcompensation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMainTMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期权维持保证金(支持历史)时间序列
    return w.wsd(security,"maint_margin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMainTMargin(security:list,*args,**kwargs):
    # 获取期权维持保证金(支持历史)
    return w.wss(security,"maint_margin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTotalTmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总存续期时间序列
    return w.wsd(security,"totaltm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTotalTm(security:list,*args,**kwargs):
    # 获取总存续期
    return w.wss(security,"totaltm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取起始交易日期时间序列
    return w.wsd(security,"startdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStartDate(security:list,*args,**kwargs):
    # 获取起始交易日期
    return w.wss(security,"startdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取起始行权日期时间序列
    return w.wsd(security,"exe_startdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeStartDate(security:list,*args,**kwargs):
    # 获取起始行权日期
    return w.wss(security,"exe_startdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最后行权日期时间序列
    return w.wsd(security,"exe_enddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExeEnddate(security:list,*args,**kwargs):
    # 获取最后行权日期
    return w.wss(security,"exe_enddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettlementMethodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交割方式时间序列
    return w.wsd(security,"settlementmethod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettlementMethod(security:list,*args,**kwargs):
    # 获取交割方式
    return w.wss(security,"settlementmethod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前收盘价时间序列
    return w.wsd(security,"pre_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreClose(security:list,*args,**kwargs):
    # 获取前收盘价
    return w.wss(security,"pre_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间前收盘价时间序列
    return w.wsd(security,"pre_close_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreClosePer(security:list,*args,**kwargs):
    # 获取区间前收盘价
    return w.wss(security,"pre_close_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsPreCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的前收盘价时间序列
    return w.wsd(security,"us_preclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsPreClose(security:list,*args,**kwargs):
    # 获取标的前收盘价
    return w.wss(security,"us_preclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockPreCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间前收盘价时间序列
    return w.wsd(security,"cb_pq_stockpreclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockPreClose(security:list,*args,**kwargs):
    # 获取正股区间前收盘价
    return w.wss(security,"cb_pq_stockpreclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘价时间序列
    return w.wsd(security,"open",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpen(security:list,*args,**kwargs):
    # 获取开盘价
    return w.wss(security,"open",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpen3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘价(不前推)时间序列
    return w.wsd(security,"open3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpen3(security:list,*args,**kwargs):
    # 获取开盘价(不前推)
    return w.wss(security,"open3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间开盘价时间序列
    return w.wsd(security,"open_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenPer(security:list,*args,**kwargs):
    # 获取区间开盘价
    return w.wss(security,"open_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的开盘价时间序列
    return w.wsd(security,"us_open",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsOpen(security:list,*args,**kwargs):
    # 获取标的开盘价
    return w.wss(security,"us_open",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间开盘价时间序列
    return w.wsd(security,"cb_pq_stockopen",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockOpen(security:list,*args,**kwargs):
    # 获取正股区间开盘价
    return w.wss(security,"cb_pq_stockopen",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日开盘价时间序列
    return w.wsd(security,"ipo_open",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoOpen(security:list,*args,**kwargs):
    # 获取上市首日开盘价
    return w.wss(security,"ipo_open",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最高价时间序列
    return w.wsd(security,"high",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHigh(security:list,*args,**kwargs):
    # 获取最高价
    return w.wss(security,"high",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHigh3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取最高价(不前推)时间序列
    return w.wsd(security,"high3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHigh3(security:list,*args,**kwargs):
    # 获取最高价(不前推)
    return w.wss(security,"high3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高价时间序列
    return w.wsd(security,"high_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighPer(security:list,*args,**kwargs):
    # 获取区间最高价
    return w.wss(security,"high_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighDatePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高价日时间序列
    return w.wsd(security,"high_date_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighDatePer(security:list,*args,**kwargs):
    # 获取区间最高价日
    return w.wss(security,"high_date_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsHighSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的最高价时间序列
    return w.wsd(security,"us_high",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsHigh(security:list,*args,**kwargs):
    # 获取标的最高价
    return w.wss(security,"us_high",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgLowestPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间自最高价的最大跌幅时间序列
    return w.wsd(security,"pct_chg_lowest_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgLowestPer(security:list,*args,**kwargs):
    # 获取区间自最高价的最大跌幅
    return w.wss(security,"pct_chg_lowest_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockHighSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间最高价时间序列
    return w.wsd(security,"cb_pq_stockhigh",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockHigh(security:list,*args,**kwargs):
    # 获取正股区间最高价
    return w.wss(security,"cb_pq_stockhigh",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoHighSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日最高价时间序列
    return w.wsd(security,"ipo_high",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoHigh(security:list,*args,**kwargs):
    # 获取上市首日最高价
    return w.wss(security,"ipo_high",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPohQeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取被剔除的最高价申报量占比时间序列
    return w.wsd(security,"pohqe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPohQe(security:list,*args,**kwargs):
    # 获取被剔除的最高价申报量占比
    return w.wss(security,"pohqe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgLowPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新价较区间最高价跌幅(回撤)时间序列
    return w.wsd(security,"pct_chg_low_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgLowPer(security:list,*args,**kwargs):
    # 获取最新价较区间最高价跌幅(回撤)
    return w.wss(security,"pct_chg_low_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechLnHighLow20DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取LN(最近一个月最高价/最近一个月最低价)_PIT时间序列
    return w.wsd(security,"tech_lnhighlow20d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechLnHighLow20D(security:list,*args,**kwargs):
    # 获取LN(最近一个月最高价/最近一个月最低价)_PIT
    return w.wss(security,"tech_lnhighlow20d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最低价时间序列
    return w.wsd(security,"low",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLow(security:list,*args,**kwargs):
    # 获取最低价
    return w.wss(security,"low",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLow3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取最低价(不前推)时间序列
    return w.wsd(security,"low3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLow3(security:list,*args,**kwargs):
    # 获取最低价(不前推)
    return w.wss(security,"low3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低价时间序列
    return w.wsd(security,"low_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowPer(security:list,*args,**kwargs):
    # 获取区间最低价
    return w.wss(security,"low_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowDatePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低价日时间序列
    return w.wsd(security,"low_date_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowDatePer(security:list,*args,**kwargs):
    # 获取区间最低价日
    return w.wss(security,"low_date_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsLowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的最低价时间序列
    return w.wsd(security,"us_low",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsLow(security:list,*args,**kwargs):
    # 获取标的最低价
    return w.wss(security,"us_low",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgHighestPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间自最低价的最大涨幅时间序列
    return w.wsd(security,"pct_chg_highest_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgHighestPer(security:list,*args,**kwargs):
    # 获取区间自最低价的最大涨幅
    return w.wss(security,"pct_chg_highest_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockLowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间最低价时间序列
    return w.wsd(security,"cb_pq_stocklow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockLow(security:list,*args,**kwargs):
    # 获取正股区间最低价
    return w.wss(security,"cb_pq_stocklow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日最低价时间序列
    return w.wsd(security,"ipo_low",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLow(security:list,*args,**kwargs):
    # 获取上市首日最低价
    return w.wss(security,"ipo_low",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测涨跌幅(评级日,最低价)时间序列
    return w.wsd(security,"est_pctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPctChange(security:list,*args,**kwargs):
    # 获取预测涨跌幅(评级日,最低价)
    return w.wss(security,"est_pctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价时间序列
    return w.wsd(security,"close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClose(security:list,*args,**kwargs):
    # 获取收盘价
    return w.wss(security,"close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClose2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(支持定点复权)时间序列
    return w.wsd(security,"close2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClose2(security:list,*args,**kwargs):
    # 获取收盘价(支持定点复权)
    return w.wss(security,"close2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClose3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(不前推)时间序列
    return w.wsd(security,"close3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClose3(security:list,*args,**kwargs):
    # 获取收盘价(不前推)
    return w.wss(security,"close3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseFxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(23:30)时间序列
    return w.wsd(security,"close_FX",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseFx(security:list,*args,**kwargs):
    # 获取收盘价(23:30)
    return w.wss(security,"close_FX",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseUsdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(美元)时间序列
    return w.wsd(security,"close_usd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseUsd(security:list,*args,**kwargs):
    # 获取收盘价(美元)
    return w.wss(security,"close_usd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseNightSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(夜盘)时间序列
    return w.wsd(security,"close_night",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseNight(security:list,*args,**kwargs):
    # 获取收盘价(夜盘)
    return w.wss(security,"close_night",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskStDevCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价标准差时间序列
    return w.wsd(security,"risk_stdevclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskStDevClose(security:list,*args,**kwargs):
    # 获取收盘价标准差
    return w.wss(security,"risk_stdevclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirtyPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(全价)时间序列
    return w.wsd(security,"dirtyprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirtyPrice(security:list,*args,**kwargs):
    # 获取收盘价(全价)
    return w.wss(security,"dirtyprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCleanPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价(净价)时间序列
    return w.wsd(security,"cleanprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCleanPrice(security:list,*args,**kwargs):
    # 获取收盘价(净价)
    return w.wss(security,"cleanprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDurationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价久期时间序列
    return w.wsd(security,"duration",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDuration(security:list,*args,**kwargs):
    # 获取收盘价久期
    return w.wss(security,"duration",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getModifiedDurationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价修正久期时间序列
    return w.wsd(security,"modifiedduration",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getModifiedDuration(security:list,*args,**kwargs):
    # 获取收盘价修正久期
    return w.wss(security,"modifiedduration",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConvexitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取收盘价凸性时间序列
    return w.wsd(security,"convexity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConvexity(security:list,*args,**kwargs):
    # 获取收盘价凸性
    return w.wss(security,"convexity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间收盘价时间序列
    return w.wsd(security,"close_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClosePer(security:list,*args,**kwargs):
    # 获取区间收盘价
    return w.wss(security,"close_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def get1StQuartIleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日收盘价1/4分位数时间序列
    return w.wsd(security,"1stquartile",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def get1StQuartIle(security:list,*args,**kwargs):
    # 获取N日收盘价1/4分位数
    return w.wss(security,"1stquartile",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMedianSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日收盘价中位数时间序列
    return w.wsd(security,"median",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMedian(security:list,*args,**kwargs):
    # 获取N日收盘价中位数
    return w.wss(security,"median",*args,**kwargs,usedf=True)
@convertInputSecurityType
def get3RdQuartIleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日收盘价3/4分位数时间序列
    return w.wsd(security,"3rdquartile",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def get3RdQuartIle(security:list,*args,**kwargs):
    # 获取N日收盘价3/4分位数
    return w.wss(security,"3rdquartile",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的收盘价时间序列
    return w.wsd(security,"us_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsClose(security:list,*args,**kwargs):
    # 获取标的收盘价
    return w.wss(security,"us_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTrix5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取5日收盘价三重指数平滑移动平均指标_PIT时间序列
    return w.wsd(security,"tech_trix5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTrix5(security:list,*args,**kwargs):
    # 获取5日收盘价三重指数平滑移动平均指标_PIT
    return w.wss(security,"tech_trix5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQOriginCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取推N日收盘价(债券)时间序列
    return w.wsd(security,"nq_originclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQOriginClose(security:list,*args,**kwargs):
    # 获取推N日收盘价(债券)
    return w.wss(security,"nq_originclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取推N日收盘价(当日结算价)时间序列
    return w.wsd(security,"nq_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQClose(security:list,*args,**kwargs):
    # 获取推N日收盘价(当日结算价)
    return w.wss(security,"nq_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTrix10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取10日收盘价三重指数平滑移动平均指标_PIT时间序列
    return w.wsd(security,"tech_trix10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTrix10(security:list,*args,**kwargs):
    # 获取10日收盘价三重指数平滑移动平均指标_PIT
    return w.wss(security,"tech_trix10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChangeCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅(收盘价)时间序列
    return w.wsd(security,"pctchange_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChangeClose(security:list,*args,**kwargs):
    # 获取涨跌幅(收盘价)
    return w.wss(security,"pctchange_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间收盘价时间序列
    return w.wsd(security,"cb_pq_stockclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockClose(security:list,*args,**kwargs):
    # 获取正股区间收盘价
    return w.wss(security,"cb_pq_stockclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高收盘价时间序列
    return w.wsd(security,"max_close_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxClosePer(security:list,*args,**kwargs):
    # 获取区间最高收盘价
    return w.wss(security,"max_close_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMinClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低收盘价时间序列
    return w.wsd(security,"min_close_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMinClosePer(security:list,*args,**kwargs):
    # 获取区间最低收盘价
    return w.wss(security,"min_close_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxCloseDatePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高收盘价日时间序列
    return w.wsd(security,"max_close_date_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxCloseDatePer(security:list,*args,**kwargs):
    # 获取区间最高收盘价日
    return w.wss(security,"max_close_date_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMinCloseDatePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低收盘价日时间序列
    return w.wsd(security,"min_close_date_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMinCloseDatePer(security:list,*args,**kwargs):
    # 获取区间最低收盘价日
    return w.wss(security,"min_close_date_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日日均收盘价(算术平均)时间序列
    return w.wsd(security,"avgclose_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgClosePer(security:list,*args,**kwargs):
    # 获取N日日均收盘价(算术平均)
    return w.wss(security,"avgclose_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日收盘价时间序列
    return w.wsd(security,"ipo_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoClose(security:list,*args,**kwargs):
    # 获取上市首日收盘价
    return w.wss(security,"ipo_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDateCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取新股开板日收盘价时间序列
    return w.wsd(security,"ipo_limitupopendate_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDateClose(security:list,*args,**kwargs):
    # 获取新股开板日收盘价
    return w.wss(security,"ipo_limitupopendate_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechBBicSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取BBI除以收盘价_PIT时间序列
    return w.wsd(security,"tech_bbic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechBBic(security:list,*args,**kwargs):
    # 获取BBI除以收盘价_PIT
    return w.wss(security,"tech_bbic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseFixedIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上证固收平台收盘价时间序列
    return w.wsd(security,"close_fixedincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloseFixedIncome(security:list,*args,**kwargs):
    # 获取上证固收平台收盘价
    return w.wss(security,"close_fixedincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockHighCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间最高收盘价时间序列
    return w.wsd(security,"cb_pq_stockhighclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockHighClose(security:list,*args,**kwargs):
    # 获取正股区间最高收盘价
    return w.wss(security,"cb_pq_stockhighclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockLowCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间最低收盘价时间序列
    return w.wsd(security,"cb_pq_stocklowclose",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockLowClose(security:list,*args,**kwargs):
    # 获取正股区间最低收盘价
    return w.wss(security,"cb_pq_stocklowclose",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量时间序列
    return w.wsd(security,"volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolume(security:list,*args,**kwargs):
    # 获取成交量
    return w.wss(security,"volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumEBTInSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量(含大宗交易)时间序列
    return w.wsd(security,"volume_btin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumEBTIn(security:list,*args,**kwargs):
    # 获取成交量(含大宗交易)
    return w.wss(security,"volume_btin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVolumeCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量比上交易日增减时间序列
    return w.wsd(security,"oi_volumec",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVolumeC(security:list,*args,**kwargs):
    # 获取成交量比上交易日增减
    return w.wss(security,"oi_volumec",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量进榜会员名称时间序列
    return w.wsd(security,"oi_vname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVName(security:list,*args,**kwargs):
    # 获取成交量进榜会员名称
    return w.wss(security,"oi_vname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量认沽认购比率时间序列
    return w.wsd(security,"volumeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeRatio(security:list,*args,**kwargs):
    # 获取成交量认沽认购比率
    return w.wss(security,"volumeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量的5日指数移动平均_PIT时间序列
    return w.wsd(security,"tech_vema5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA5(security:list,*args,**kwargs):
    # 获取成交量的5日指数移动平均_PIT
    return w.wss(security,"tech_vema5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量的10日指数移动平均_PIT时间序列
    return w.wsd(security,"tech_vema10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA10(security:list,*args,**kwargs):
    # 获取成交量的10日指数移动平均_PIT
    return w.wss(security,"tech_vema10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA12Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量的12日指数移动平均_PIT时间序列
    return w.wsd(security,"tech_vema12",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA12(security:list,*args,**kwargs):
    # 获取成交量的12日指数移动平均_PIT
    return w.wss(security,"tech_vema12",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA26Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量的26日指数移动平均_PIT时间序列
    return w.wsd(security,"tech_vema26",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVemA26(security:list,*args,**kwargs):
    # 获取成交量的26日指数移动平均_PIT
    return w.wss(security,"tech_vema26",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVmaCdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量量指数平滑异同移动平均线_PIT时间序列
    return w.wsd(security,"tech_vmacd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVmaCd(security:list,*args,**kwargs):
    # 获取成交量量指数平滑异同移动平均线_PIT
    return w.wss(security,"tech_vmacd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量比率_PIT时间序列
    return w.wsd(security,"tech_vr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVr(security:list,*args,**kwargs):
    # 获取成交量比率_PIT
    return w.wss(security,"tech_vr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVosCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交量震荡_PIT时间序列
    return w.wsd(security,"tech_vosc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVosC(security:list,*args,**kwargs):
    # 获取成交量震荡_PIT
    return w.wss(security,"tech_vosc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechPvISeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正成交量指标_PIT时间序列
    return w.wsd(security,"tech_pvi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechPvI(security:list,*args,**kwargs):
    # 获取正成交量指标_PIT
    return w.wss(security,"tech_pvi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechNViSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取负成交量指标_PIT时间序列
    return w.wsd(security,"tech_nvi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechNVi(security:list,*args,**kwargs):
    # 获取负成交量指标_PIT
    return w.wss(security,"tech_nvi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeAHtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取盘后成交量时间序列
    return w.wsd(security,"volume_aht",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeAHt(security:list,*args,**kwargs):
    # 获取盘后成交量
    return w.wss(security,"volume_aht",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交量时间序列
    return w.wsd(security,"vol_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolPer(security:list,*args,**kwargs):
    # 获取区间成交量
    return w.wss(security,"vol_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交量(含大宗交易)时间序列
    return w.wsd(security,"pq_blocktradevolume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeVolume(security:list,*args,**kwargs):
    # 获取区间成交量(含大宗交易)
    return w.wss(security,"pq_blocktradevolume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日成交量时间序列
    return w.wsd(security,"vol_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolNd(security:list,*args,**kwargs):
    # 获取N日成交量
    return w.wss(security,"vol_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的成交量时间序列
    return w.wsd(security,"us_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsVolume(security:list,*args,**kwargs):
    # 获取标的成交量
    return w.wss(security,"us_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取会员成交量时间序列
    return w.wsd(security,"oi_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiVolume(security:list,*args,**kwargs):
    # 获取会员成交量
    return w.wss(security,"oi_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取品种成交量时间序列
    return w.wsd(security,"optionvolume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionVolume(security:list,*args,**kwargs):
    # 获取品种成交量
    return w.wss(security,"optionvolume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购成交量时间序列
    return w.wsd(security,"callvolume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallVolume(security:list,*args,**kwargs):
    # 获取认购成交量
    return w.wss(security,"callvolume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认沽成交量时间序列
    return w.wsd(security,"putvolume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutVolume(security:list,*args,**kwargs):
    # 获取认沽成交量
    return w.wss(security,"putvolume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVsTd10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取10日成交量标准差_PIT时间序列
    return w.wsd(security,"tech_vstd10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVsTd10(security:list,*args,**kwargs):
    # 获取10日成交量标准差_PIT
    return w.wss(security,"tech_vstd10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVsTd20Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取20日成交量标准差_PIT时间序列
    return w.wsd(security,"tech_vstd20",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechVsTd20(security:list,*args,**kwargs):
    # 获取20日成交量标准差_PIT
    return w.wss(security,"tech_vstd20",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间成交量时间序列
    return w.wsd(security,"cb_pq_stockvol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockVol(security:list,*args,**kwargs):
    # 获取正股区间成交量
    return w.wss(security,"cb_pq_stockvol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgVolPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均成交量时间序列
    return w.wsd(security,"avg_vol_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgVolPer(security:list,*args,**kwargs):
    # 获取区间日均成交量
    return w.wss(security,"avg_vol_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqVolumeAHtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间盘后成交量时间序列
    return w.wsd(security,"pq_volume_aht",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqVolumeAHt(security:list,*args,**kwargs):
    # 获取区间盘后成交量
    return w.wss(security,"pq_volume_aht",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolumePctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取卖空量占成交量比率时间序列
    return w.wsd(security,"shortsell_VolumePct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolumePct(security:list,*args,**kwargs):
    # 获取卖空量占成交量比率
    return w.wss(security,"shortsell_VolumePct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVsTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取VSTD成交量标准差时间序列
    return w.wsd(security,"VSTD",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVsTd(security:list,*args,**kwargs):
    # 获取VSTD成交量标准差
    return w.wss(security,"VSTD",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoListDayVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日成交量时间序列
    return w.wsd(security,"ipo_listdayvolume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoListDayVolume(security:list,*args,**kwargs):
    # 获取上市首日成交量
    return w.wss(security,"ipo_listdayvolume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘集合竞价成交量时间序列
    return w.wsd(security,"open_auction_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionVolume(security:list,*args,**kwargs):
    # 获取开盘集合竞价成交量
    return w.wss(security,"open_auction_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeFixedIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上证固收平台成交量时间序列
    return w.wsd(security,"volume_fixedincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolumeFixedIncome(security:list,*args,**kwargs):
    # 获取上证固收平台成交量
    return w.wss(security,"volume_fixedincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交额时间序列
    return w.wsd(security,"amt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmt(security:list,*args,**kwargs):
    # 获取成交额
    return w.wss(security,"amt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmountBtInSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交额(含大宗交易)时间序列
    return w.wsd(security,"amount_btin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmountBtIn(security:list,*args,**kwargs):
    # 获取成交额(含大宗交易)
    return w.wss(security,"amount_btin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechAmount1M60Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交额惯性_PIT时间序列
    return w.wsd(security,"tech_amount1m60",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechAmount1M60(security:list,*args,**kwargs):
    # 获取成交额惯性_PIT
    return w.wss(security,"tech_amount1m60",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmountAHtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取盘后成交额时间序列
    return w.wsd(security,"amount_aht",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmountAHt(security:list,*args,**kwargs):
    # 获取盘后成交额
    return w.wss(security,"amount_aht",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmtPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交额时间序列
    return w.wsd(security,"amt_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmtPer(security:list,*args,**kwargs):
    # 获取区间成交额
    return w.wss(security,"amt_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeAmountsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交额(含大宗交易)时间序列
    return w.wsd(security,"pq_blocktradeamounts",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeAmounts(security:list,*args,**kwargs):
    # 获取区间成交额(含大宗交易)
    return w.wss(security,"pq_blocktradeamounts",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmtNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日成交额时间序列
    return w.wsd(security,"amt_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmtNd(security:list,*args,**kwargs):
    # 获取N日成交额
    return w.wss(security,"amt_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的成交额时间序列
    return w.wsd(security,"us_amount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsAmount(security:list,*args,**kwargs):
    # 获取标的成交额
    return w.wss(security,"us_amount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取品种成交额时间序列
    return w.wsd(security,"optionamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionAmount(security:list,*args,**kwargs):
    # 获取品种成交额
    return w.wss(security,"optionamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购成交额时间序列
    return w.wsd(security,"callamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallAmount(security:list,*args,**kwargs):
    # 获取认购成交额
    return w.wss(security,"callamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认沽成交额时间序列
    return w.wsd(security,"putamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutAmount(security:list,*args,**kwargs):
    # 获取认沽成交额
    return w.wss(security,"putamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAmNtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间成交额时间序列
    return w.wsd(security,"cb_pq_stockamnt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAmNt(security:list,*args,**kwargs):
    # 获取正股区间成交额
    return w.wss(security,"cb_pq_stockamnt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgAmtPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均成交额时间序列
    return w.wsd(security,"avg_amt_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgAmtPer(security:list,*args,**kwargs):
    # 获取区间日均成交额
    return w.wss(security,"avg_amt_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAmountAHtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间盘后成交额时间序列
    return w.wsd(security,"pq_amount_aht",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAmountAHt(security:list,*args,**kwargs):
    # 获取区间盘后成交额
    return w.wss(security,"pq_amount_aht",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日成交额时间序列
    return w.wsd(security,"ipo_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoVolume(security:list,*args,**kwargs):
    # 获取上市首日成交额
    return w.wss(security,"ipo_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘集合竞价成交额时间序列
    return w.wsd(security,"open_auction_amount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionAmount(security:list,*args,**kwargs):
    # 获取开盘集合竞价成交额
    return w.wss(security,"open_auction_amount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDealNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成交笔数时间序列
    return w.wsd(security,"dealnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDealNum(security:list,*args,**kwargs):
    # 获取成交笔数
    return w.wss(security,"dealnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDealNumFixedIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上证固收平台成交笔数时间序列
    return w.wsd(security,"dealnum_fixedincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDealNumFixedIncome(security:list,*args,**kwargs):
    # 获取上证固收平台成交笔数
    return w.wss(security,"dealnum_fixedincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌时间序列
    return w.wsd(security,"chg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChg(security:list,*args,**kwargs):
    # 获取涨跌
    return w.wss(security,"chg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅时间序列
    return w.wsd(security,"pct_chg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg(security:list,*args,**kwargs):
    # 获取涨跌幅
    return w.wss(security,"pct_chg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅(债券)时间序列
    return w.wsd(security,"pct_chg_b",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgB(security:list,*args,**kwargs):
    # 获取涨跌幅(债券)
    return w.wss(security,"pct_chg_b",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChgSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌(结算价)时间序列
    return w.wsd(security,"chg_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChgSettlement(security:list,*args,**kwargs):
    # 获取涨跌(结算价)
    return w.wss(security,"chg_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅(结算价)时间序列
    return w.wsd(security,"pct_chg_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgSettlement(security:list,*args,**kwargs):
    # 获取涨跌幅(结算价)
    return w.wss(security,"pct_chg_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxUpOrDownSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌停状态时间序列
    return w.wsd(security,"maxupordown",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxUpOrDown(security:list,*args,**kwargs):
    # 获取涨跌停状态
    return w.wss(security,"maxupordown",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQChangeCnBdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌(中债)时间序列
    return w.wsd(security,"dq_change_cnbd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQChangeCnBd(security:list,*args,**kwargs):
    # 获取涨跌(中债)
    return w.wss(security,"dq_change_cnbd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQPctChangeCnBdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨跌幅(中债)时间序列
    return w.wsd(security,"dq_pctchange_cnbd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQPctChangeCnBd(security:list,*args,**kwargs):
    # 获取涨跌幅(中债)
    return w.wss(security,"dq_pctchange_cnbd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChgPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨跌时间序列
    return w.wsd(security,"chg_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChgPer(security:list,*args,**kwargs):
    # 获取区间涨跌
    return w.wss(security,"chg_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨跌幅时间序列
    return w.wsd(security,"pct_chg_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgPer(security:list,*args,**kwargs):
    # 获取区间涨跌幅
    return w.wss(security,"pct_chg_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgPer2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨跌幅(包含上市首日涨跌幅)时间序列
    return w.wsd(security,"pct_chg_per2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgPer2(security:list,*args,**kwargs):
    # 获取区间涨跌幅(包含上市首日涨跌幅)
    return w.wss(security,"pct_chg_per2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日涨跌幅时间序列
    return w.wsd(security,"pct_chg_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgNd(security:list,*args,**kwargs):
    # 获取N日涨跌幅
    return w.wss(security,"pct_chg_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqChangeSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨跌(结算价)时间序列
    return w.wsd(security,"fs_pq_change_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqChangeSettlement(security:list,*args,**kwargs):
    # 获取区间涨跌(结算价)
    return w.wss(security,"fs_pq_change_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqPctChangeSettlementSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨跌幅(结算价)时间序列
    return w.wsd(security,"fs_pq_pctchange_settlement",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqPctChangeSettlement(security:list,*args,**kwargs):
    # 获取区间涨跌幅(结算价)
    return w.wss(security,"fs_pq_pctchange_settlement",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估算涨跌幅时间序列
    return w.wsd(security,"west_return",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestReturn(security:list,*args,**kwargs):
    # 获取估算涨跌幅
    return w.wss(security,"west_return",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestReturnErrorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估算涨跌幅误差时间序列
    return w.wsd(security,"west_return_error",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestReturnError(security:list,*args,**kwargs):
    # 获取估算涨跌幅误差
    return w.wss(security,"west_return_error",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的涨跌时间序列
    return w.wsd(security,"us_change",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsChange(security:list,*args,**kwargs):
    # 获取标的涨跌
    return w.wss(security,"us_change",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的涨跌幅时间序列
    return w.wsd(security,"us_pctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsPctChange(security:list,*args,**kwargs):
    # 获取标的涨跌幅
    return w.wss(security,"us_pctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg5DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近5日涨跌幅时间序列
    return w.wsd(security,"pct_chg_5d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg5D(security:list,*args,**kwargs):
    # 获取近5日涨跌幅
    return w.wss(security,"pct_chg_5d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近1月涨跌幅时间序列
    return w.wsd(security,"pct_chg_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg1M(security:list,*args,**kwargs):
    # 获取近1月涨跌幅
    return w.wss(security,"pct_chg_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近3月涨跌幅时间序列
    return w.wsd(security,"pct_chg_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg3M(security:list,*args,**kwargs):
    # 获取近3月涨跌幅
    return w.wss(security,"pct_chg_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近6月涨跌幅时间序列
    return w.wsd(security,"pct_chg_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg6M(security:list,*args,**kwargs):
    # 获取近6月涨跌幅
    return w.wss(security,"pct_chg_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg1YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近1年涨跌幅时间序列
    return w.wsd(security,"pct_chg_1y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg1Y(security:list,*args,**kwargs):
    # 获取近1年涨跌幅
    return w.wss(security,"pct_chg_1y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStocksPerChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股涨跌幅时间序列
    return w.wsd(security,"prt_heavilyheldstocksperchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStocksPerChange(security:list,*args,**kwargs):
    # 获取重仓股涨跌幅
    return w.wss(security,"prt_heavilyheldstocksperchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAbnormalNavFluctuationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净值异常涨跌幅说明时间序列
    return w.wsd(security,"fund_abnormalnavfluctuation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAbnormalNavFluctuation(security:list,*args,**kwargs):
    # 获取净值异常涨跌幅说明
    return w.wss(security,"fund_abnormalnavfluctuation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间涨跌时间序列
    return w.wsd(security,"cb_pq_stockchg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockChg(security:list,*args,**kwargs):
    # 获取正股区间涨跌
    return w.wss(security,"cb_pq_stockchg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockPctChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间涨跌幅时间序列
    return w.wsd(security,"cb_pq_stockpctchg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockPctChg(security:list,*args,**kwargs):
    # 获取正股区间涨跌幅
    return w.wss(security,"cb_pq_stockpctchg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgPctChgNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日日均涨跌幅时间序列
    return w.wsd(security,"avg_pct_chg_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgPctChgNd(security:list,*args,**kwargs):
    # 获取N日日均涨跌幅
    return w.wss(security,"avg_pct_chg_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg10DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近10日涨跌幅时间序列
    return w.wsd(security,"pct_chg_10d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChg10D(security:list,*args,**kwargs):
    # 获取近10日涨跌幅
    return w.wss(security,"pct_chg_10d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日涨跌幅时间序列
    return w.wsd(security,"ipo_pctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPctChange(security:list,*args,**kwargs):
    # 获取上市首日涨跌幅
    return w.wss(security,"ipo_pctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondsPerChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券涨跌幅时间序列
    return w.wsd(security,"prt_heavilyheldbondsperchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondsPerChange(security:list,*args,**kwargs):
    # 获取重仓债券涨跌幅
    return w.wss(security,"prt_heavilyheldbondsperchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundPerChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金涨跌幅时间序列
    return w.wsd(security,"prt_heavilyheldfundperchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundPerChange(security:list,*args,**kwargs):
    # 获取重仓基金涨跌幅
    return w.wss(security,"prt_heavilyheldfundperchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelIpoChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对发行价涨跌时间序列
    return w.wsd(security,"rel_ipo_chg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelIpoChg(security:list,*args,**kwargs):
    # 获取相对发行价涨跌
    return w.wss(security,"rel_ipo_chg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelIpoPctChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对发行价涨跌幅时间序列
    return w.wsd(security,"rel_ipo_pct_chg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelIpoPctChg(security:list,*args,**kwargs):
    # 获取相对发行价涨跌幅
    return w.wss(security,"rel_ipo_pct_chg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNpcTChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市后N日涨跌幅时间序列
    return w.wsd(security,"ipo_npctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNpcTChange(security:list,*args,**kwargs):
    # 获取上市后N日涨跌幅
    return w.wss(security,"ipo_npctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDatePctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取新股开板日涨跌幅时间序列
    return w.wsd(security,"ipo_limitupopendate_pctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDatePctChange(security:list,*args,**kwargs):
    # 获取新股开板日涨跌幅
    return w.wss(security,"ipo_limitupopendate_pctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间相对指数涨跌幅时间序列
    return w.wsd(security,"relpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelPctChange(security:list,*args,**kwargs):
    # 获取区间相对指数涨跌幅
    return w.wss(security,"relpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对大盘区间涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange(security:list,*args,**kwargs):
    # 获取相对大盘区间涨跌幅
    return w.wss(security,"pq_relpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQRelPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对大盘N日涨跌幅时间序列
    return w.wsd(security,"nq_relpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQRelPctChange(security:list,*args,**kwargs):
    # 获取相对大盘N日涨跌幅
    return w.wss(security,"nq_relpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChangeYTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年迄今相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_ytd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChangeYTd(security:list,*args,**kwargs):
    # 获取年迄今相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_ytd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange5DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近5日相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_5d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange5D(security:list,*args,**kwargs):
    # 获取近5日相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_5d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近1月相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange1M(security:list,*args,**kwargs):
    # 获取近1月相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近3月相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange3M(security:list,*args,**kwargs):
    # 获取近3月相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近6月相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange6M(security:list,*args,**kwargs):
    # 获取近6月相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange1YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近1年相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_1y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange1Y(security:list,*args,**kwargs):
    # 获取近1年相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_1y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChangeMTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本月至今相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_mtd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChangeMTd(security:list,*args,**kwargs):
    # 获取本月至今相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_mtd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelRelPctChangeMTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取季度至今相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relrelpctchange_mtd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelRelPctChangeMTd(security:list,*args,**kwargs):
    # 获取季度至今相对指数涨跌幅
    return w.wss(security,"pq_relrelpctchange_mtd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange10DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取近10日相对指数涨跌幅时间序列
    return w.wsd(security,"pq_relpctchange_10d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqRelPctChange10D(security:list,*args,**kwargs):
    # 获取近10日相对指数涨跌幅
    return w.wss(security,"pq_relpctchange_10d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取振幅时间序列
    return w.wsd(security,"swing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwing(security:list,*args,**kwargs):
    # 获取振幅
    return w.wss(security,"swing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwingPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间振幅时间序列
    return w.wsd(security,"swing_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwingPer(security:list,*args,**kwargs):
    # 获取区间振幅
    return w.wss(security,"swing_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwingNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日振幅时间序列
    return w.wsd(security,"swing_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSwingNd(security:list,*args,**kwargs):
    # 获取N日振幅
    return w.wss(security,"swing_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsSwingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的振幅时间序列
    return w.wsd(security,"us_swing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsSwing(security:list,*args,**kwargs):
    # 获取标的振幅
    return w.wss(security,"us_swing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockSwingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间振幅时间序列
    return w.wsd(security,"cb_pq_stockswing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockSwing(security:list,*args,**kwargs):
    # 获取正股区间振幅
    return w.wss(security,"cb_pq_stockswing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgSwingPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均振幅时间序列
    return w.wsd(security,"avg_swing_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgSwingPer(security:list,*args,**kwargs):
    # 获取区间日均振幅
    return w.wss(security,"avg_swing_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVWapSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取均价时间序列
    return w.wsd(security,"vwap",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVWap(security:list,*args,**kwargs):
    # 获取均价
    return w.wss(security,"vwap",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsAvgPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的均价时间序列
    return w.wsd(security,"us_avgprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsAvgPrice(security:list,*args,**kwargs):
    # 获取标的均价
    return w.wss(security,"us_avgprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPrePriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行前均价时间序列
    return w.wsd(security,"ipo_preprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPrePrice(security:list,*args,**kwargs):
    # 获取发行前均价
    return w.wss(security,"ipo_preprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间均价时间序列
    return w.wsd(security,"cb_pq_stockavg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAvg(security:list,*args,**kwargs):
    # 获取正股区间均价
    return w.wss(security,"cb_pq_stockavg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVWapPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交均价时间序列
    return w.wsd(security,"vwap_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVWapPer(security:list,*args,**kwargs):
    # 获取区间成交均价
    return w.wss(security,"vwap_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgPrice2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间成交均价(可复权)时间序列
    return w.wsd(security,"pq_avgprice2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgPrice2(security:list,*args,**kwargs):
    # 获取区间成交均价(可复权)
    return w.wss(security,"pq_avgprice2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQAvgPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日成交均价时间序列
    return w.wsd(security,"nq_avgprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNQAvgPrice(security:list,*args,**kwargs):
    # 获取N日成交均价
    return w.wss(security,"nq_avgprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetReferencePriceIsAnVerAgeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否为算术平均价时间序列
    return w.wsd(security,"clause_reset_referencepriceisanverage",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetReferencePriceIsAnVerAge(security:list,*args,**kwargs):
    # 获取是否为算术平均价
    return w.wss(security,"clause_reset_referencepriceisanverage",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoAvgPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日成交均价时间序列
    return w.wsd(security,"ipo_avgprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoAvgPrice(security:list,*args,**kwargs):
    # 获取上市首日成交均价
    return w.wss(security,"ipo_avgprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgPriceFixedIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上证固收平台平均价时间序列
    return w.wsd(security,"avgprice_fixedincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgPriceFixedIncome(security:list,*args,**kwargs):
    # 获取上证固收平台平均价
    return w.wss(security,"avgprice_fixedincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDateAvgPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取新股开板日成交均价时间序列
    return w.wsd(security,"ipo_limitupopendate_avgprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLimitUpOpenDateAvgPrice(security:list,*args,**kwargs):
    # 获取新股开板日成交均价
    return w.wss(security,"ipo_limitupopendate_avgprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdjFactorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取复权因子时间序列
    return w.wsd(security,"adjfactor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdjFactor(security:list,*args,**kwargs):
    # 获取复权因子
    return w.wss(security,"adjfactor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavAdjFactorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金净值复权因子时间序列
    return w.wsd(security,"NAV_adjfactor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavAdjFactor(security:list,*args,**kwargs):
    # 获取基金净值复权因子
    return w.wss(security,"NAV_adjfactor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取换手率时间序列
    return w.wsd(security,"turn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurn(security:list,*args,**kwargs):
    # 获取换手率
    return w.wss(security,"turn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFreeTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取换手率(基准.自由流通股本)时间序列
    return w.wsd(security,"free_turn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFreeTurn(security:list,*args,**kwargs):
    # 获取换手率(基准.自由流通股本)
    return w.wss(security,"free_turn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRateVolatility20Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取换手率相对波动率_PIT时间序列
    return w.wsd(security,"tech_turnoverratevolatility20",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRateVolatility20(security:list,*args,**kwargs):
    # 获取换手率相对波动率_PIT
    return w.wss(security,"tech_turnoverratevolatility20",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间换手率时间序列
    return w.wsd(security,"turn_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnPer(security:list,*args,**kwargs):
    # 获取区间换手率
    return w.wss(security,"turn_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnFreePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间换手率(基准.自由流通股本)时间序列
    return w.wsd(security,"turn_free_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnFreePer(security:list,*args,**kwargs):
    # 获取区间换手率(基准.自由流通股本)
    return w.wss(security,"turn_free_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日换手率时间序列
    return w.wsd(security,"turn_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTurnNd(security:list,*args,**kwargs):
    # 获取N日换手率
    return w.wss(security,"turn_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的换手率时间序列
    return w.wsd(security,"us_turn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsTurn(security:list,*args,**kwargs):
    # 获取标的换手率
    return w.wss(security,"us_turn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechSToQSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月换手率对数平均_PIT时间序列
    return w.wsd(security,"tech_stoq",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechSToQ(security:list,*args,**kwargs):
    # 获取3个月换手率对数平均_PIT
    return w.wss(security,"tech_stoq",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockTurnoverSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间换手率时间序列
    return w.wsd(security,"cb_pq_stockturnover",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockTurnover(security:list,*args,**kwargs):
    # 获取正股区间换手率
    return w.wss(security,"cb_pq_stockturnover",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgTurn2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均换手率时间序列
    return w.wsd(security,"pq_avgturn2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgTurn2(security:list,*args,**kwargs):
    # 获取区间日均换手率
    return w.wss(security,"pq_avgturn2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均换手率(剔除无成交日期)时间序列
    return w.wsd(security,"avg_turn_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnPer(security:list,*args,**kwargs):
    # 获取区间日均换手率(剔除无成交日期)
    return w.wss(security,"avg_turn_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnFreePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均换手率(基准.自由流通股本)时间序列
    return w.wsd(security,"avg_turn_free_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnFreePer(security:list,*args,**kwargs):
    # 获取区间日均换手率(基准.自由流通股本)
    return w.wss(security,"avg_turn_free_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnNdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取N日日均换手率时间序列
    return w.wsd(security,"avg_turn_nd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgTurnNd(security:list,*args,**kwargs):
    # 获取N日日均换手率
    return w.wss(security,"avg_turn_nd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市首日换手率时间序列
    return w.wsd(security,"ipo_turn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTurn(security:list,*args,**kwargs):
    # 获取上市首日换手率
    return w.wss(security,"ipo_turn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取5日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate5(security:list,*args,**kwargs):
    # 获取5日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechSToASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取12个月换手率对数平均_PIT时间序列
    return w.wsd(security,"tech_stoa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechSToA(security:list,*args,**kwargs):
    # 获取12个月换手率对数平均_PIT
    return w.wss(security,"tech_stoa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn5DTurn120Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取5日平均换手率/120日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turn5dturn120",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn5DTurn120(security:list,*args,**kwargs):
    # 获取5日平均换手率/120日平均换手率_PIT
    return w.wss(security,"tech_turn5dturn120",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市后N日换手率时间序列
    return w.wsd(security,"ipo_nturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNTurn(security:list,*args,**kwargs):
    # 获取上市后N日换手率
    return w.wss(security,"ipo_nturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取10日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate10(security:list,*args,**kwargs):
    # 获取10日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate20Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取20日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate20",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate20(security:list,*args,**kwargs):
    # 获取20日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate20",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate60Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取60日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate60",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate60(security:list,*args,**kwargs):
    # 获取60日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate60",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn10DTurn120Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取10日平均换手率/120日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turn10dturn120",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn10DTurn120(security:list,*args,**kwargs):
    # 获取10日平均换手率/120日平均换手率_PIT
    return w.wss(security,"tech_turn10dturn120",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn20DTurn120Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取20日平均换手率/120日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turn20dturn120",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurn20DTurn120(security:list,*args,**kwargs):
    # 获取20日平均换手率/120日平均换手率_PIT
    return w.wss(security,"tech_turn20dturn120",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAveTurnoverSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股区间平均换手率时间序列
    return w.wsd(security,"cb_pq_stockaveturnover",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbPqStockAveTurnover(security:list,*args,**kwargs):
    # 获取正股区间平均换手率
    return w.wss(security,"cb_pq_stockaveturnover",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate120Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取120日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate120",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate120(security:list,*args,**kwargs):
    # 获取120日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate120",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate240Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取240日平均换手率_PIT时间序列
    return w.wsd(security,"tech_turnoverrate240",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechTurnoverRate240(security:list,*args,**kwargs):
    # 获取240日平均换手率_PIT
    return w.wss(security,"tech_turnoverrate240",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStyleRpTTurnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金报告期持仓换手率时间序列
    return w.wsd(security,"style_rpt_turn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStyleRpTTurn(security:list,*args,**kwargs):
    # 获取基金报告期持仓换手率
    return w.wss(security,"style_rpt_turn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量时间序列
    return w.wsd(security,"oi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOi(security:list,*args,**kwargs):
    # 获取持仓量
    return w.wss(security,"oi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量变化时间序列
    return w.wsd(security,"oi_chg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChg(security:list,*args,**kwargs):
    # 获取持仓量变化
    return w.wss(security,"oi_chg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiIndexSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量(商品指数)时间序列
    return w.wsd(security,"oi_index",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiIndex(security:list,*args,**kwargs):
    # 获取持仓量(商品指数)
    return w.wss(security,"oi_index",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量变化(商品指数)时间序列
    return w.wsd(security,"oichange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChange(security:list,*args,**kwargs):
    # 获取持仓量变化(商品指数)
    return w.wss(security,"oichange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOi3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量(不前推)时间序列
    return w.wsd(security,"oi3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOi3(security:list,*args,**kwargs):
    # 获取持仓量(不前推)
    return w.wss(security,"oi3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓量认沽认购比率时间序列
    return w.wsd(security,"oiratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiRatio(security:list,*args,**kwargs):
    # 获取持仓量认沽认购比率
    return w.wss(security,"oiratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间持仓量时间序列
    return w.wsd(security,"oi_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiPer(security:list,*args,**kwargs):
    # 获取区间持仓量
    return w.wss(security,"oi_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionOiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取品种持仓量时间序列
    return w.wsd(security,"optionoi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOptionOi(security:list,*args,**kwargs):
    # 获取品种持仓量
    return w.wss(security,"optionoi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallOiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购持仓量时间序列
    return w.wsd(security,"calloi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCallOi(security:list,*args,**kwargs):
    # 获取认购持仓量
    return w.wss(security,"calloi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutOiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认沽持仓量时间序列
    return w.wsd(security,"putoi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutOi(security:list,*args,**kwargs):
    # 获取认沽持仓量
    return w.wss(security,"putoi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgOiPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均持仓量时间序列
    return w.wsd(security,"avg_oi_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgOiPer(security:list,*args,**kwargs):
    # 获取区间日均持仓量
    return w.wss(security,"avg_oi_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiAmountNoMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓额(不计保证金)时间序列
    return w.wsd(security,"oiamount_nomargin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiAmountNoMargin(security:list,*args,**kwargs):
    # 获取持仓额(不计保证金)
    return w.wss(security,"oiamount_nomargin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持仓额时间序列
    return w.wsd(security,"oiamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiAmount(security:list,*args,**kwargs):
    # 获取持仓额
    return w.wss(security,"oiamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreSettleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前结算价时间序列
    return w.wsd(security,"pre_settle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreSettle(security:list,*args,**kwargs):
    # 获取前结算价
    return w.wss(security,"pre_settle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreSettlePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间前结算价时间序列
    return w.wsd(security,"pre_settle_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreSettlePer(security:list,*args,**kwargs):
    # 获取区间前结算价
    return w.wss(security,"pre_settle_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取结算价时间序列
    return w.wsd(security,"settle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettle(security:list,*args,**kwargs):
    # 获取结算价
    return w.wss(security,"settle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettle3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取结算价(不前推)时间序列
    return w.wsd(security,"settle3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettle3(security:list,*args,**kwargs):
    # 获取结算价(不前推)
    return w.wss(security,"settle3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettlePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间结算价时间序列
    return w.wsd(security,"settle_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSettlePer(security:list,*args,**kwargs):
    # 获取区间结算价
    return w.wss(security,"settle_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightModiDuraSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价修正久期(中债)时间序列
    return w.wsd(security,"weight_modidura",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightModiDura(security:list,*args,**kwargs):
    # 获取加权平均结算价修正久期(中债)
    return w.wss(security,"weight_modidura",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightSprDuraSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价利差久期(中债)时间序列
    return w.wsd(security,"weight_sprdura",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightSprDura(security:list,*args,**kwargs):
    # 获取加权平均结算价利差久期(中债)
    return w.wss(security,"weight_sprdura",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightInterestDurationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价利率久期(中债)时间序列
    return w.wsd(security,"weight_interestduration",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightInterestDuration(security:list,*args,**kwargs):
    # 获取加权平均结算价利率久期(中债)
    return w.wss(security,"weight_interestduration",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightVoBpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价基点价值(中债)时间序列
    return w.wsd(security,"weight_vobp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightVoBp(security:list,*args,**kwargs):
    # 获取加权平均结算价基点价值(中债)
    return w.wss(security,"weight_vobp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightCNvXTySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价凸性(中债)时间序列
    return w.wsd(security,"weight_cnvxty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightCNvXTy(security:list,*args,**kwargs):
    # 获取加权平均结算价凸性(中债)
    return w.wss(security,"weight_cnvxty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightSPrcNxtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价利差凸性(中债)时间序列
    return w.wsd(security,"weight_sprcnxt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightSPrcNxt(security:list,*args,**kwargs):
    # 获取加权平均结算价利差凸性(中债)
    return w.wss(security,"weight_sprcnxt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightInterestCNvXTySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均结算价利率凸性(中债)时间序列
    return w.wsd(security,"weight_interestcnvxty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWeightInterestCNvXTy(security:list,*args,**kwargs):
    # 获取加权平均结算价利率凸性(中债)
    return w.wss(security,"weight_interestcnvxty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowSettlePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低结算价时间序列
    return w.wsd(security,"low_settle_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowSettlePer(security:list,*args,**kwargs):
    # 获取区间最低结算价
    return w.wss(security,"low_settle_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighSettlePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高结算价时间序列
    return w.wsd(security,"high_settle_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHighSettlePer(security:list,*args,**kwargs):
    # 获取区间最高结算价
    return w.wss(security,"high_settle_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqHighSwingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最高结算价日时间序列
    return w.wsd(security,"fs_pq_highswing_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqHighSwingDate(security:list,*args,**kwargs):
    # 获取区间最高结算价日
    return w.wss(security,"fs_pq_highswing_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqLowSwingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间最低结算价日时间序列
    return w.wsd(security,"fs_pq_lowswing_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFsPqLowSwingDate(security:list,*args,**kwargs):
    # 获取区间最低结算价日
    return w.wss(security,"fs_pq_lowswing_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLasTradeDaySSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最近交易日期时间序列
    return w.wsd(security,"lastradeday_s",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLasTradeDayS(security:list,*args,**kwargs):
    # 获取最近交易日期
    return w.wss(security,"lastradeday_s",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFirsTradeDaySSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最早交易日期时间序列
    return w.wsd(security,"firstradeday_s",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFirsTradeDayS(security:list,*args,**kwargs):
    # 获取最早交易日期
    return w.wss(security,"firstradeday_s",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradeDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市场最近交易日时间序列
    return w.wsd(security,"last_trade_day",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLastTradeDay(security:list,*args,**kwargs):
    # 获取市场最近交易日
    return w.wss(security,"last_trade_day",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易状态时间序列
    return w.wsd(security,"trade_status",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeStatus(security:list,*args,**kwargs):
    # 获取交易状态
    return w.wss(security,"trade_status",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvArdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值时间序列
    return w.wsd(security,"val_mv_ARD",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvArd(security:list,*args,**kwargs):
    # 获取总市值
    return w.wss(security,"val_mv_ARD",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值1时间序列
    return w.wsd(security,"ev",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv(security:list,*args,**kwargs):
    # 获取总市值1
    return w.wss(security,"ev",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapArdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值2时间序列
    return w.wsd(security,"mkt_cap_ard",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapArd(security:list,*args,**kwargs):
    # 获取总市值2
    return w.wss(security,"mkt_cap_ard",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值1(币种可选)时间序列
    return w.wsd(security,"ev3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv3(security:list,*args,**kwargs):
    # 获取总市值1(币种可选)
    return w.wss(security,"ev3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值(不可回测)时间序列
    return w.wsd(security,"mkt_cap",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCap(security:list,*args,**kwargs):
    # 获取总市值(不可回测)
    return w.wss(security,"mkt_cap",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapCsrCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值(证监会算法)时间序列
    return w.wsd(security,"mkt_cap_CSRC",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapCsrC(security:list,*args,**kwargs):
    # 获取总市值(证监会算法)
    return w.wss(security,"mkt_cap_CSRC",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvToeBitDaTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值/EBITDA(TTM反推法)_PIT时间序列
    return w.wsd(security,"val_mvtoebitda_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvToeBitDaTtM(security:list,*args,**kwargs):
    # 获取总市值/EBITDA(TTM反推法)_PIT
    return w.wss(security,"val_mvtoebitda_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPeBitDaInDuSwTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总市值/息税折旧及摊销前利润TTM行业相对值_PIT时间序列
    return w.wsd(security,"val_pebitdaindu_sw_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPeBitDaInDuSwTtM(security:list,*args,**kwargs):
    # 获取总市值/息税折旧及摊销前利润TTM行业相对值_PIT
    return w.wss(security,"val_pebitdaindu_sw_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMvRefSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取参考总市值时间序列
    return w.wsd(security,"mv_ref",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMvRef(security:list,*args,**kwargs):
    # 获取参考总市值
    return w.wss(security,"mv_ref",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指数总市值时间序列
    return w.wsd(security,"val_mv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMv(security:list,*args,**kwargs):
    # 获取指数总市值
    return w.wss(security,"val_mv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMamVSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取备考总市值(并购后)时间序列
    return w.wsd(security,"mamv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMamV(security:list,*args,**kwargs):
    # 获取备考总市值(并购后)
    return w.wss(security,"mamv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEquityToDebt2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取当日总市值/负债总计时间序列
    return w.wsd(security,"equitytodebt2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEquityToDebt2(security:list,*args,**kwargs):
    # 获取当日总市值/负债总计
    return w.wss(security,"equitytodebt2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgMvPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均总市值时间序列
    return w.wsd(security,"avg_MV_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgMvPer(security:list,*args,**kwargs):
    # 获取区间日均总市值
    return w.wss(security,"avg_MV_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValAvgPeBitDaSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万一级行业的总市值/息税折旧及摊销前利润TTM均值_PIT时间序列
    return w.wsd(security,"val_avgpebitda_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValAvgPeBitDaSw(security:list,*args,**kwargs):
    # 获取所属申万一级行业的总市值/息税折旧及摊销前利润TTM均值_PIT
    return w.wss(security,"val_avgpebitda_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValStdPeBitDaSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万一级行业的总市值/息税折旧及摊销前利润TTM标准差_PIT时间序列
    return w.wsd(security,"val_stdpebitda_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValStdPeBitDaSw(security:list,*args,**kwargs):
    # 获取所属申万一级行业的总市值/息税折旧及摊销前利润TTM标准差_PIT
    return w.wss(security,"val_stdpebitda_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginMarketValueRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保证券市值占该证券总市值比重时间序列
    return w.wsd(security,"margin_marketvalueratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginMarketValueRatio(security:list,*args,**kwargs):
    # 获取担保证券市值占该证券总市值比重
    return w.wss(security,"margin_marketvalueratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通市值时间序列
    return w.wsd(security,"val_mvc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValMvC(security:list,*args,**kwargs):
    # 获取流通市值
    return w.wss(security,"val_mvc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapFloatSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通市值(含限售股)时间序列
    return w.wsd(security,"mkt_cap_float",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktCapFloat(security:list,*args,**kwargs):
    # 获取流通市值(含限售股)
    return w.wss(security,"mkt_cap_float",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktFreeSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自由流通市值时间序列
    return w.wsd(security,"mkt_freeshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktFreeShares(security:list,*args,**kwargs):
    # 获取自由流通市值
    return w.wss(security,"mkt_freeshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValFloatMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自由流通市值_PIT时间序列
    return w.wsd(security,"val_floatmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValFloatMv(security:list,*args,**kwargs):
    # 获取自由流通市值_PIT
    return w.wss(security,"val_floatmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValLnFloatMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取对数流通市值_PIT时间序列
    return w.wsd(security,"val_lnfloatmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValLnFloatMv(security:list,*args,**kwargs):
    # 获取对数流通市值_PIT
    return w.wss(security,"val_lnfloatmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgMvNonRestrictedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间日均流通市值时间序列
    return w.wsd(security,"pq_avgmv_nonrestricted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAvgMvNonRestricted(security:list,*args,**kwargs):
    # 获取区间日均流通市值
    return w.wss(security,"pq_avgmv_nonrestricted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUspDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取连续停牌天数时间序列
    return w.wsd(security,"susp_days",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUspDays(security:list,*args,**kwargs):
    # 获取连续停牌天数
    return w.wss(security,"susp_days",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUspReasonSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取停牌原因时间序列
    return w.wsd(security,"susp_reason",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUspReason(security:list,*args,**kwargs):
    # 获取停牌原因
    return w.wss(security,"susp_reason",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxUpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取涨停价时间序列
    return w.wsd(security,"maxup",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxUp(security:list,*args,**kwargs):
    # 获取涨停价
    return w.wss(security,"maxup",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxDownSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取跌停价时间序列
    return w.wsd(security,"maxdown",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaxDown(security:list,*args,**kwargs):
    # 获取跌停价
    return w.wss(security,"maxdown",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDiscountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取贴水时间序列
    return w.wsd(security,"discount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDiscount(security:list,*args,**kwargs):
    # 获取贴水
    return w.wss(security,"discount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDiscountRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取贴水率时间序列
    return w.wsd(security,"discount_ratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDiscountRatio(security:list,*args,**kwargs):
    # 获取贴水率
    return w.wss(security,"discount_ratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgDiscountPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间均贴水时间序列
    return w.wsd(security,"avg_discount_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgDiscountPer(security:list,*args,**kwargs):
    # 获取区间均贴水
    return w.wss(security,"avg_discount_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgDiscountRatioPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间均贴水率时间序列
    return w.wsd(security,"avg_discount_ratio_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAvgDiscountRatioPer(security:list,*args,**kwargs):
    # 获取区间均贴水率
    return w.wss(security,"avg_discount_ratio_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexWeightSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属指数权重时间序列
    return w.wsd(security,"indexweight",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexWeight(security:list,*args,**kwargs):
    # 获取所属指数权重
    return w.wss(security,"indexweight",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirectionGoldSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交收方向(黄金现货)时间序列
    return w.wsd(security,"direction_gold",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirectionGold(security:list,*args,**kwargs):
    # 获取交收方向(黄金现货)
    return w.wss(security,"direction_gold",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQuantityGoldSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交收量(黄金现货)时间序列
    return w.wsd(security,"dquantity_gold",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDQuantityGold(security:list,*args,**kwargs):
    # 获取交收量(黄金现货)
    return w.wss(security,"dquantity_gold",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘集合竞价成交价时间序列
    return w.wsd(security,"open_auction_price",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOpenAuctionPrice(security:list,*args,**kwargs):
    # 获取开盘集合竞价成交价
    return w.wss(security,"open_auction_price",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgHighPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间收盘最大涨幅时间序列
    return w.wsd(security,"pct_chg_high_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPctChgHighPer(security:list,*args,**kwargs):
    # 获取区间收盘最大涨幅
    return w.wss(security,"pct_chg_high_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间交易天数时间序列
    return w.wsd(security,"trade_days_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeDaysPer(security:list,*args,**kwargs):
    # 获取区间交易天数
    return w.wss(security,"trade_days_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLimitUpDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间涨停天数时间序列
    return w.wsd(security,"limitupdays_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLimitUpDaysPer(security:list,*args,**kwargs):
    # 获取区间涨停天数
    return w.wss(security,"limitupdays_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLimitDownDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间跌停天数时间序列
    return w.wsd(security,"limitdowndays_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLimitDownDaysPer(security:list,*args,**kwargs):
    # 获取区间跌停天数
    return w.wss(security,"limitdowndays_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqUpDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间上涨天数时间序列
    return w.wsd(security,"pq_updays_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqUpDaysPer(security:list,*args,**kwargs):
    # 获取区间上涨天数
    return w.wss(security,"pq_updays_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqDownDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间下跌天数时间序列
    return w.wsd(security,"pq_downdays_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqDownDaysPer(security:list,*args,**kwargs):
    # 获取区间下跌天数
    return w.wss(security,"pq_downdays_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQuoteDaysPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间报价天数时间序列
    return w.wsd(security,"quote_days_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQuoteDaysPer(security:list,*args,**kwargs):
    # 获取区间报价天数
    return w.wss(security,"quote_days_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChgPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间持仓变化时间序列
    return w.wsd(security,"oi_chg_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOiChgPer(security:list,*args,**kwargs):
    # 获取区间持仓变化
    return w.wss(security,"oi_chg_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtOpenPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间开盘净主动买入额时间序列
    return w.wsd(security,"mf_amt_open_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtOpenPer(security:list,*args,**kwargs):
    # 获取区间开盘净主动买入额
    return w.wss(security,"mf_amt_open_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtClosePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间尾盘净主动买入额时间序列
    return w.wsd(security,"mf_amt_close_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtClosePer(security:list,*args,**kwargs):
    # 获取区间尾盘净主动买入额
    return w.wss(security,"mf_amt_close_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间净主动买入量时间序列
    return w.wsd(security,"mf_vol_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolPer(security:list,*args,**kwargs):
    # 获取区间净主动买入量
    return w.wss(security,"mf_vol_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolRatioPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间净主动买入量占比时间序列
    return w.wsd(security,"mf_vol_ratio_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolRatioPer(security:list,*args,**kwargs):
    # 获取区间净主动买入量占比
    return w.wss(security,"mf_vol_ratio_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间净主动买入额时间序列
    return w.wsd(security,"mf_amt_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtPer(security:list,*args,**kwargs):
    # 获取区间净主动买入额
    return w.wss(security,"mf_amt_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtRatioPerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间净主动买入率(金额)时间序列
    return w.wsd(security,"mf_amt_ratio_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtRatioPer(security:list,*args,**kwargs):
    # 获取区间净主动买入率(金额)
    return w.wss(security,"mf_amt_ratio_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间主力净流入天数时间序列
    return w.wsd(security,"mfd_inflowdays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowDays(security:list,*args,**kwargs):
    # 获取区间主力净流入天数
    return w.wss(security,"mfd_inflowdays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfBuyAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间流入额时间序列
    return w.wsd(security,"mf_buy_amt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfBuyAmt(security:list,*args,**kwargs):
    # 获取区间流入额
    return w.wss(security,"mf_buy_amt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfBuyVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间流入量时间序列
    return w.wsd(security,"mf_buy_vol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfBuyVol(security:list,*args,**kwargs):
    # 获取区间流入量
    return w.wss(security,"mf_buy_vol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfSellAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间流出额时间序列
    return w.wsd(security,"mf_sell_amt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfSellAmt(security:list,*args,**kwargs):
    # 获取区间流出额
    return w.wss(security,"mf_sell_amt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfSellVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间流出量时间序列
    return w.wsd(security,"mf_sell_vol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfSellVol(security:list,*args,**kwargs):
    # 获取区间流出量
    return w.wss(security,"mf_sell_vol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间大宗交易上榜次数时间序列
    return w.wsd(security,"pq_blocktradenum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeNum(security:list,*args,**kwargs):
    # 获取区间大宗交易上榜次数
    return w.wss(security,"pq_blocktradenum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间大宗交易成交总量时间序列
    return w.wsd(security,"pq_blocktrade_volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeVolume(security:list,*args,**kwargs):
    # 获取区间大宗交易成交总量
    return w.wss(security,"pq_blocktrade_volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间大宗交易成交总额时间序列
    return w.wsd(security,"pq_blocktradeamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqBlockTradeAmount(security:list,*args,**kwargs):
    # 获取区间大宗交易成交总额
    return w.wss(security,"pq_blocktradeamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAbnormalTradeNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间龙虎榜上榜次数时间序列
    return w.wsd(security,"pq_abnormaltradenum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAbnormalTradeNum(security:list,*args,**kwargs):
    # 获取区间龙虎榜上榜次数
    return w.wss(security,"pq_abnormaltradenum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAbnormalTradeLpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间龙虎榜买入额时间序列
    return w.wsd(security,"pq_abnormaltrade_lp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPqAbnormalTradeLp(security:list,*args,**kwargs):
    # 获取区间龙虎榜买入额
    return w.wss(security,"pq_abnormaltrade_lp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日相近交易日期时间序列
    return w.wsd(security,"tradeday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeDay(security:list,*args,**kwargs):
    # 获取指定日相近交易日期
    return w.wss(security,"tradeday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPeriodMfNetInFlowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间净流入额时间序列
    return w.wsd(security,"periodmf_netinflow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPeriodMfNetInFlow(security:list,*args,**kwargs):
    # 获取区间净流入额
    return w.wss(security,"periodmf_netinflow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融资买入额时间序列
    return w.wsd(security,"mrg_long_amt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongAmt(security:list,*args,**kwargs):
    # 获取融资买入额
    return w.wss(security,"mrg_long_amt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongAmtIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融资买入额时间序列
    return w.wsd(security,"mrg_long_amt_int",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongAmtInt(security:list,*args,**kwargs):
    # 获取区间融资买入额
    return w.wss(security,"mrg_long_amt_int",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongRepaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融资偿还额时间序列
    return w.wsd(security,"mrg_long_repay",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongRepay(security:list,*args,**kwargs):
    # 获取融资偿还额
    return w.wss(security,"mrg_long_repay",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongRepayIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融资偿还额时间序列
    return w.wsd(security,"mrg_long_repay_int",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongRepayInt(security:list,*args,**kwargs):
    # 获取区间融资偿还额
    return w.wss(security,"mrg_long_repay_int",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongBalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融资余额时间序列
    return w.wsd(security,"mrg_long_bal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongBal(security:list,*args,**kwargs):
    # 获取融资余额
    return w.wss(security,"mrg_long_bal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongBalIntAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融资余额均值时间序列
    return w.wsd(security,"mrg_long_bal_int_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgLongBalIntAvg(security:list,*args,**kwargs):
    # 获取区间融资余额均值
    return w.wss(security,"mrg_long_bal_int_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内债券回购融资余额时间序列
    return w.wsd(security,"mmrepurchase1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase1(security:list,*args,**kwargs):
    # 获取报告期内债券回购融资余额
    return w.wss(security,"mmrepurchase1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期末债券回购融资余额时间序列
    return w.wsd(security,"mmrepurchase2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase2(security:list,*args,**kwargs):
    # 获取报告期末债券回购融资余额
    return w.wss(security,"mmrepurchase2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase1ToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内债券回购融资余额占基金资产净值比例时间序列
    return w.wsd(security,"mmrepurchase1tonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase1ToNav(security:list,*args,**kwargs):
    # 获取报告期内债券回购融资余额占基金资产净值比例
    return w.wss(security,"mmrepurchase1tonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase2ToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期末债券回购融资余额占基金资产净值比例时间序列
    return w.wsd(security,"mmrepurchase2tonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmRepurchase2ToNav(security:list,*args,**kwargs):
    # 获取报告期末债券回购融资余额占基金资产净值比例
    return w.wss(security,"mmrepurchase2tonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券卖出量时间序列
    return w.wsd(security,"mrg_short_vol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVol(security:list,*args,**kwargs):
    # 获取融券卖出量
    return w.wss(security,"mrg_short_vol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券卖出量时间序列
    return w.wsd(security,"mrg_short_vol_int",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolInt(security:list,*args,**kwargs):
    # 获取区间融券卖出量
    return w.wss(security,"mrg_short_vol_int",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolRepaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券偿还量时间序列
    return w.wsd(security,"mrg_short_vol_repay",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolRepay(security:list,*args,**kwargs):
    # 获取融券偿还量
    return w.wss(security,"mrg_short_vol_repay",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolRepayIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券偿还量时间序列
    return w.wsd(security,"mrg_short_vol_repay_int",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolRepayInt(security:list,*args,**kwargs):
    # 获取区间融券偿还量
    return w.wss(security,"mrg_short_vol_repay_int",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginSaleTradingAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券卖出额时间序列
    return w.wsd(security,"margin_saletradingamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginSaleTradingAmount(security:list,*args,**kwargs):
    # 获取融券卖出额
    return w.wss(security,"margin_saletradingamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginShortAmountIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券卖出额时间序列
    return w.wsd(security,"margin_shortamountint",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginShortAmountInt(security:list,*args,**kwargs):
    # 获取区间融券卖出额
    return w.wss(security,"margin_shortamountint",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginSaleRepayAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券偿还额时间序列
    return w.wsd(security,"margin_salerepayamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginSaleRepayAmount(security:list,*args,**kwargs):
    # 获取融券偿还额
    return w.wss(security,"margin_salerepayamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginShortAmountRepayIntSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券偿还额时间序列
    return w.wsd(security,"margin_shortamountrepayint",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarginShortAmountRepayInt(security:list,*args,**kwargs):
    # 获取区间融券偿还额
    return w.wss(security,"margin_shortamountrepayint",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolBalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券余量时间序列
    return w.wsd(security,"mrg_short_vol_bal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolBal(security:list,*args,**kwargs):
    # 获取融券余量
    return w.wss(security,"mrg_short_vol_bal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolBalIntAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券余量均值时间序列
    return w.wsd(security,"mrg_short_vol_bal_int_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortVolBalIntAvg(security:list,*args,**kwargs):
    # 获取区间融券余量均值
    return w.wss(security,"mrg_short_vol_bal_int_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortBalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取融券余额时间序列
    return w.wsd(security,"mrg_short_bal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortBal(security:list,*args,**kwargs):
    # 获取融券余额
    return w.wss(security,"mrg_short_bal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortBalIntAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间融券余额均值时间序列
    return w.wsd(security,"mrg_short_bal_int_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMrgShortBalIntAvg(security:list,*args,**kwargs):
    # 获取区间融券余额均值
    return w.wss(security,"mrg_short_bal_int_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellTurnoverSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取全日卖空金额时间序列
    return w.wsd(security,"shortsell_Turnover",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellTurnover(security:list,*args,**kwargs):
    # 获取全日卖空金额
    return w.wss(security,"shortsell_Turnover",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellTurnoverPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取卖空金额占市场卖空总额比率时间序列
    return w.wsd(security,"shortsell_TurnoverPct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellTurnoverPct(security:list,*args,**kwargs):
    # 获取卖空金额占市场卖空总额比率
    return w.wss(security,"shortsell_TurnoverPct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolumeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取全日卖空股数时间序列
    return w.wsd(security,"shortsell_Volume",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolume(security:list,*args,**kwargs):
    # 获取全日卖空股数
    return w.wss(security,"shortsell_Volume",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolumeToHSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取卖空量占香港流通股百分比时间序列
    return w.wsd(security,"shortsell_VolumeToHshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellVolumeToHShares(security:list,*args,**kwargs):
    # 获取卖空量占香港流通股百分比
    return w.wss(security,"shortsell_VolumeToHshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareShortSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未平仓卖空数时间序列
    return w.wsd(security,"share_shortshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareShortShares(security:list,*args,**kwargs):
    # 获取未平仓卖空数
    return w.wss(security,"share_shortshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareShortAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未平仓卖空金额时间序列
    return w.wsd(security,"share_shortamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareShortAmount(security:list,*args,**kwargs):
    # 获取未平仓卖空金额
    return w.wss(security,"share_shortamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellDaysToCoverSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取空头回补天数时间序列
    return w.wsd(security,"shortsell_daystocover",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShortSellDaysToCover(security:list,*args,**kwargs):
    # 获取空头回补天数
    return w.wss(security,"shortsell_daystocover",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流入额时间序列
    return w.wsd(security,"mfd_buyamt_d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtD(security:list,*args,**kwargs):
    # 获取流入额
    return w.wss(security,"mfd_buyamt_d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfNetInFlowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净流入额时间序列
    return w.wsd(security,"mf_netinflow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfNetInFlow(security:list,*args,**kwargs):
    # 获取净流入额
    return w.wss(security,"mf_netinflow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入额时间序列
    return w.wsd(security,"mfd_inflow_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowM(security:list,*args,**kwargs):
    # 获取主力净流入额
    return w.wss(security,"mfd_inflow_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionM(security:list,*args,**kwargs):
    # 获取主力净流入额占比
    return w.wss(security,"mfd_inflowproportion_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入额时间序列
    return w.wsd(security,"mfd_inflow_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入额
    return w.wss(security,"mfd_inflow_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入额时间序列
    return w.wsd(security,"mfd_inflow_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入额
    return w.wss(security,"mfd_inflow_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入额占比
    return w.wss(security,"mfd_inflowproportion_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入额占比
    return w.wss(security,"mfd_inflowproportion_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流出额时间序列
    return w.wsd(security,"mfd_sellamt_d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtD(security:list,*args,**kwargs):
    # 获取流出额
    return w.wss(security,"mfd_sellamt_d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流入量时间序列
    return w.wsd(security,"mfd_buyvol_d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolD(security:list,*args,**kwargs):
    # 获取流入量
    return w.wss(security,"mfd_buyvol_d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入量时间序列
    return w.wsd(security,"mfd_buyvol_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolM(security:list,*args,**kwargs):
    # 获取主力净流入量
    return w.wss(security,"mfd_buyvol_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入量占比时间序列
    return w.wsd(security,"mfd_volinflowproportion_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionM(security:list,*args,**kwargs):
    # 获取主力净流入量占比
    return w.wss(security,"mfd_volinflowproportion_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入量时间序列
    return w.wsd(security,"mfd_buyvol_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入量
    return w.wss(security,"mfd_buyvol_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入量时间序列
    return w.wsd(security,"mfd_buyvol_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入量
    return w.wss(security,"mfd_buyvol_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入量占比时间序列
    return w.wsd(security,"mfd_volinflowproportion_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入量占比
    return w.wss(security,"mfd_volinflowproportion_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入量占比时间序列
    return w.wsd(security,"mfd_volinflowproportion_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入量占比
    return w.wss(security,"mfd_volinflowproportion_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流出量时间序列
    return w.wsd(security,"mfd_sellvol_d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolD(security:list,*args,**kwargs):
    # 获取流出量
    return w.wss(security,"mfd_sellvol_d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净买入额时间序列
    return w.wsd(security,"mfd_netbuyamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyAmt(security:list,*args,**kwargs):
    # 获取净买入额
    return w.wss(security,"mfd_netbuyamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通区间净买入额时间序列
    return w.wsd(security,"mfp_sn_inflow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlow(security:list,*args,**kwargs):
    # 获取沪深港股通区间净买入额
    return w.wss(security,"mfp_sn_inflow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净买入量时间序列
    return w.wsd(security,"mfd_netbuyvol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyVol(security:list,*args,**kwargs):
    # 获取净买入量
    return w.wss(security,"mfd_netbuyvol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通区间净买入量时间序列
    return w.wsd(security,"mfp_sn_inflowamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowAmt(security:list,*args,**kwargs):
    # 获取沪深港股通区间净买入量
    return w.wss(security,"mfp_sn_inflowamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowAmt2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通区间净买入量(调整)时间序列
    return w.wsd(security,"mfp_sn_inflowamt2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowAmt2(security:list,*args,**kwargs):
    # 获取沪深港股通区间净买入量(调整)
    return w.wss(security,"mfp_sn_inflowamt2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyOrDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流入单数时间序列
    return w.wsd(security,"mfd_buyord",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyOrD(security:list,*args,**kwargs):
    # 获取流入单数
    return w.wss(security,"mfd_buyord",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSelLordSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流出单数时间序列
    return w.wsd(security,"mfd_sellord",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSelLord(security:list,*args,**kwargs):
    # 获取流出单数
    return w.wss(security,"mfd_sellord",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动买入额时间序列
    return w.wsd(security,"mfd_buyamt_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtA(security:list,*args,**kwargs):
    # 获取主动买入额
    return w.wss(security,"mfd_buyamt_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtAtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动买入额(全单)时间序列
    return w.wsd(security,"mfd_buyamt_at",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyAmtAt(security:list,*args,**kwargs):
    # 获取主动买入额(全单)
    return w.wss(security,"mfd_buyamt_at",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyAmtASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入额时间序列
    return w.wsd(security,"mfd_netbuyamt_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyAmtA(security:list,*args,**kwargs):
    # 获取净主动买入额
    return w.wss(security,"mfd_netbuyamt_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入额(全单)时间序列
    return w.wsd(security,"mf_amt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmt(security:list,*args,**kwargs):
    # 获取净主动买入额(全单)
    return w.wss(security,"mf_amt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionA(security:list,*args,**kwargs):
    # 获取净主动买入额占比
    return w.wss(security,"mfd_inflowproportion_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtOpenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘净主动买入额时间序列
    return w.wsd(security,"mf_amt_open",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtOpen(security:list,*args,**kwargs):
    # 获取开盘净主动买入额
    return w.wss(security,"mf_amt_open",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtCloseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘净主动买入额时间序列
    return w.wsd(security,"mf_amt_close",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtClose(security:list,*args,**kwargs):
    # 获取尾盘净主动买入额
    return w.wss(security,"mf_amt_close",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionOpenASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘净主动买入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_open_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionOpenA(security:list,*args,**kwargs):
    # 获取开盘净主动买入额占比
    return w.wss(security,"mfd_inflowproportion_open_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionCloseASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘净主动买入额占比时间序列
    return w.wsd(security,"mfd_inflowproportion_close_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowProportionCloseA(security:list,*args,**kwargs):
    # 获取尾盘净主动买入额占比
    return w.wss(security,"mfd_inflowproportion_close_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动卖出额时间序列
    return w.wsd(security,"mfd_sellamt_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtA(security:list,*args,**kwargs):
    # 获取主动卖出额
    return w.wss(security,"mfd_sellamt_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtAtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动卖出额(全单)时间序列
    return w.wsd(security,"mfd_sellamt_at",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellAmtAt(security:list,*args,**kwargs):
    # 获取主动卖出额(全单)
    return w.wss(security,"mfd_sellamt_at",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动买入量时间序列
    return w.wsd(security,"mfd_buyvol_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolA(security:list,*args,**kwargs):
    # 获取主动买入量
    return w.wss(security,"mfd_buyvol_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolAtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动买入量(全单)时间序列
    return w.wsd(security,"mfd_buyvol_at",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdBuyVolAt(security:list,*args,**kwargs):
    # 获取主动买入量(全单)
    return w.wss(security,"mfd_buyvol_at",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyVolASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入量时间序列
    return w.wsd(security,"mfd_netbuyvol_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdNetBuyVolA(security:list,*args,**kwargs):
    # 获取净主动买入量
    return w.wss(security,"mfd_netbuyvol_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入量(全单)时间序列
    return w.wsd(security,"mf_vol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVol(security:list,*args,**kwargs):
    # 获取净主动买入量(全单)
    return w.wss(security,"mf_vol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入量占比时间序列
    return w.wsd(security,"mf_vol_ratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfVolRatio(security:list,*args,**kwargs):
    # 获取净主动买入量占比
    return w.wss(security,"mf_vol_ratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionOpenASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘净主动买入量占比时间序列
    return w.wsd(security,"mfd_volinflowproportion_open_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionOpenA(security:list,*args,**kwargs):
    # 获取开盘净主动买入量占比
    return w.wss(security,"mfd_volinflowproportion_open_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionCloseASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘净主动买入量占比时间序列
    return w.wsd(security,"mfd_volinflowproportion_close_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowProportionCloseA(security:list,*args,**kwargs):
    # 获取尾盘净主动买入量占比
    return w.wss(security,"mfd_volinflowproportion_close_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowVolumeOpenASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘资金净主动买入量时间序列
    return w.wsd(security,"mfd_inflowvolume_open_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowVolumeOpenA(security:list,*args,**kwargs):
    # 获取开盘资金净主动买入量
    return w.wss(security,"mfd_inflowvolume_open_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowVolumeCloseASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘资金净主动买入量时间序列
    return w.wsd(security,"mfd_inflowvolume_close_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowVolumeCloseA(security:list,*args,**kwargs):
    # 获取尾盘资金净主动买入量
    return w.wss(security,"mfd_inflowvolume_close_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动卖出量时间序列
    return w.wsd(security,"mfd_sellvol_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolA(security:list,*args,**kwargs):
    # 获取主动卖出量
    return w.wss(security,"mfd_sellvol_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolAtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主动卖出量(全单)时间序列
    return w.wsd(security,"mfd_sellvol_at",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSellVolAt(security:list,*args,**kwargs):
    # 获取主动卖出量(全单)
    return w.wss(security,"mfd_sellvol_at",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入率(金额)时间序列
    return w.wsd(security,"mf_amt_ratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfAmtRatio(security:list,*args,**kwargs):
    # 获取净主动买入率(金额)
    return w.wss(security,"mf_amt_ratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateOpenASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘净主动买入率(金额)时间序列
    return w.wsd(security,"mfd_inflowrate_open_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateOpenA(security:list,*args,**kwargs):
    # 获取开盘净主动买入率(金额)
    return w.wss(security,"mfd_inflowrate_open_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateCloseASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘净主动买入率(金额)时间序列
    return w.wsd(security,"mfd_inflowrate_close_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateCloseA(security:list,*args,**kwargs):
    # 获取尾盘净主动买入率(金额)
    return w.wss(security,"mfd_inflowrate_close_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净主动买入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateA(security:list,*args,**kwargs):
    # 获取净主动买入率(量)
    return w.wss(security,"mfd_volinflowrate_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateOpenASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘净主动买入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_open_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateOpenA(security:list,*args,**kwargs):
    # 获取开盘净主动买入率(量)
    return w.wss(security,"mfd_volinflowrate_open_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateCloseASeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘净主动买入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_close_a",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateCloseA(security:list,*args,**kwargs):
    # 获取尾盘净主动买入率(量)
    return w.wss(security,"mfd_volinflowrate_close_a",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入率(金额)时间序列
    return w.wsd(security,"mfd_inflowrate_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateM(security:list,*args,**kwargs):
    # 获取主力净流入率(金额)
    return w.wss(security,"mfd_inflowrate_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入率(金额)时间序列
    return w.wsd(security,"mfd_inflowrate_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入率(金额)
    return w.wss(security,"mfd_inflowrate_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入率(金额)时间序列
    return w.wsd(security,"mfd_inflowrate_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdInFlowRateCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入率(金额)
    return w.wss(security,"mfd_inflowrate_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主力净流入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateM(security:list,*args,**kwargs):
    # 获取主力净流入率(量)
    return w.wss(security,"mfd_volinflowrate_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateOpenMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开盘主力净流入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_open_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateOpenM(security:list,*args,**kwargs):
    # 获取开盘主力净流入率(量)
    return w.wss(security,"mfd_volinflowrate_open_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateCloseMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取尾盘主力净流入率(量)时间序列
    return w.wsd(security,"mfd_volinflowrate_close_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdVolInFlowRateCloseM(security:list,*args,**kwargs):
    # 获取尾盘主力净流入率(量)
    return w.wss(security,"mfd_volinflowrate_close_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnBuyAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通买入金额时间序列
    return w.wsd(security,"mfd_sn_buyamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnBuyAmt(security:list,*args,**kwargs):
    # 获取沪深港股通买入金额
    return w.wss(security,"mfd_sn_buyamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnSellAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通卖出金额时间序列
    return w.wsd(security,"mfd_sn_sellamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnSellAmt(security:list,*args,**kwargs):
    # 获取沪深港股通卖出金额
    return w.wss(security,"mfd_sn_sellamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnInFlowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通净买入金额时间序列
    return w.wsd(security,"mfd_sn_inflow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfdSnInFlow(security:list,*args,**kwargs):
    # 获取沪深港股通净买入金额
    return w.wss(security,"mfd_sn_inflow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通区间净流入天数时间序列
    return w.wsd(security,"mfp_sn_inflowdays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnInFlowDays(security:list,*args,**kwargs):
    # 获取沪深港股通区间净流入天数
    return w.wss(security,"mfp_sn_inflowdays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnOutflowDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通区间净流出天数时间序列
    return w.wsd(security,"mfp_sn_outflowdays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfpSnOutflowDays(security:list,*args,**kwargs):
    # 获取沪深港股通区间净流出天数
    return w.wss(security,"mfp_sn_outflowdays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfnSnInFlowDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通持续净流入天数时间序列
    return w.wsd(security,"mfn_sn_inflowdays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfnSnInFlowDays(security:list,*args,**kwargs):
    # 获取沪深港股通持续净流入天数
    return w.wss(security,"mfn_sn_inflowdays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfnSnOutflowDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪深港股通持续净卖出天数时间序列
    return w.wsd(security,"mfn_sn_outflowdays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMfnSnOutflowDays(security:list,*args,**kwargs):
    # 获取沪深港股通持续净卖出天数
    return w.wss(security,"mfn_sn_outflowdays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiExSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资买卖超时间序列
    return w.wsd(security,"inshd_qfii_ex",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiEx(security:list,*args,**kwargs):
    # 获取外资买卖超
    return w.wss(security,"inshd_qfii_ex",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiExMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资买卖超市值时间序列
    return w.wsd(security,"inshd_qfii_exmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiExMv(security:list,*args,**kwargs):
    # 获取外资买卖超市值
    return w.wss(security,"inshd_qfii_exmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundExSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投信买卖超时间序列
    return w.wsd(security,"inshd_fund_ex",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundEx(security:list,*args,**kwargs):
    # 获取投信买卖超
    return w.wss(security,"inshd_fund_ex",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundExMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投信买卖超市值时间序列
    return w.wsd(security,"inshd_fund_exmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundExMv(security:list,*args,**kwargs):
    # 获取投信买卖超市值
    return w.wss(security,"inshd_fund_exmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrExSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自营买卖超时间序列
    return w.wsd(security,"inshd_dlr_ex",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrEx(security:list,*args,**kwargs):
    # 获取自营买卖超
    return w.wss(security,"inshd_dlr_ex",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrExMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自营买卖超市值时间序列
    return w.wsd(security,"inshd_dlr_exmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrExMv(security:list,*args,**kwargs):
    # 获取自营买卖超市值
    return w.wss(security,"inshd_dlr_exmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdTtlExSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取合计买卖超时间序列
    return w.wsd(security,"inshd_ttl_ex",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdTtlEx(security:list,*args,**kwargs):
    # 获取合计买卖超
    return w.wss(security,"inshd_ttl_ex",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdTtlExMvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取合计买卖超市值时间序列
    return w.wsd(security,"inshd_ttl_exmv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdTtlExMv(security:list,*args,**kwargs):
    # 获取合计买卖超市值
    return w.wss(security,"inshd_ttl_exmv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiBuySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资买进数量时间序列
    return w.wsd(security,"inshd_qfii_buy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiBuy(security:list,*args,**kwargs):
    # 获取外资买进数量
    return w.wss(security,"inshd_qfii_buy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiSellSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取外资卖出数量时间序列
    return w.wsd(security,"inshd_qfii_sell",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdQFIiSell(security:list,*args,**kwargs):
    # 获取外资卖出数量
    return w.wss(security,"inshd_qfii_sell",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundBuySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投信买进数量时间序列
    return w.wsd(security,"inshd_fund_buy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundBuy(security:list,*args,**kwargs):
    # 获取投信买进数量
    return w.wss(security,"inshd_fund_buy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundSellSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投信卖出数量时间序列
    return w.wsd(security,"inshd_fund_sell",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdFundSell(security:list,*args,**kwargs):
    # 获取投信卖出数量
    return w.wss(security,"inshd_fund_sell",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrBuySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自营商买进数量时间序列
    return w.wsd(security,"inshd_dlr_buy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrBuy(security:list,*args,**kwargs):
    # 获取自营商买进数量
    return w.wss(security,"inshd_dlr_buy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrSellSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自营商卖出数量时间序列
    return w.wsd(security,"inshd_dlr_sell",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInSHdDlrSell(security:list,*args,**kwargs):
    # 获取自营商卖出数量
    return w.wss(security,"inshd_dlr_sell",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间回报时间序列
    return w.wsd(security,"return",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getReturn(security:list,*args,**kwargs):
    # 获取区间回报
    return w.wss(security,"return",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundQSimilarProductSimilarRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取规模同类排名(券商集合理财)时间序列
    return w.wsd(security,"fund_qsimilarproductsimilarranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundQSimilarProductSimilarRanking(security:list,*args,**kwargs):
    # 获取规模同类排名(券商集合理财)
    return w.wss(security,"fund_qsimilarproductsimilarranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundScaleRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取规模同类排名时间序列
    return w.wsd(security,"fund_scaleranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundScaleRanking(security:list,*args,**kwargs):
    # 获取规模同类排名
    return w.wss(security,"fund_scaleranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskDownsideRiskRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取下行风险同类排名时间序列
    return w.wsd(security,"risk_downsideriskranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskDownsideRiskRanking(security:list,*args,**kwargs):
    # 获取下行风险同类排名
    return w.wss(security,"risk_downsideriskranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskTimeRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取选时能力同类排名时间序列
    return w.wsd(security,"risk_timeranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskTimeRanking(security:list,*args,**kwargs):
    # 获取选时能力同类排名
    return w.wss(security,"risk_timeranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskStockRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取选股能力同类排名时间序列
    return w.wsd(security,"risk_stockranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskStockRanking(security:list,*args,**kwargs):
    # 获取选股能力同类排名
    return w.wss(security,"risk_stockranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskInfoRatioRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信息比率同类排名时间序列
    return w.wsd(security,"risk_inforatioranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskInfoRatioRanking(security:list,*args,**kwargs):
    # 获取信息比率同类排名
    return w.wss(security,"risk_inforatioranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskTrackErrorRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取跟踪误差同类排名时间序列
    return w.wsd(security,"risk_trackerrorranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskTrackErrorRanking(security:list,*args,**kwargs):
    # 获取跟踪误差同类排名
    return w.wss(security,"risk_trackerrorranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskAnnualVolRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年化波动率同类排名时间序列
    return w.wsd(security,"risk_annualvolranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskAnnualVolRanking(security:list,*args,**kwargs):
    # 获取年化波动率同类排名
    return w.wss(security,"risk_annualvolranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStyleAvgPositionTimeRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取平均持仓时间同类排名时间序列
    return w.wsd(security,"style_avgpositiontimeranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStyleAvgPositionTimeRanking(security:list,*args,**kwargs):
    # 获取平均持仓时间同类排名
    return w.wss(security,"style_avgpositiontimeranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStStockSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取注册仓单数量时间序列
    return w.wsd(security,"st_stock",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStStock(security:list,*args,**kwargs):
    # 获取注册仓单数量
    return w.wss(security,"st_stock",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业价值(含货币资金)时间序列
    return w.wsd(security,"ev1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv1(security:list,*args,**kwargs):
    # 获取企业价值(含货币资金)
    return w.wss(security,"ev1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业价值(剔除货币资金)时间序列
    return w.wsd(security,"ev2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEv2(security:list,*args,**kwargs):
    # 获取企业价值(剔除货币资金)
    return w.wss(security,"ev2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValTaToEvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产总计/企业价值_PIT时间序列
    return w.wsd(security,"val_tatoev",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValTaToEv(security:list,*args,**kwargs):
    # 获取资产总计/企业价值_PIT
    return w.wss(security,"val_tatoev",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValOrToEvTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入(TTM)/企业价值_PIT时间序列
    return w.wsd(security,"val_ortoev_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValOrToEvTtM(security:list,*args,**kwargs):
    # 获取营业收入(TTM)/企业价值_PIT
    return w.wss(security,"val_ortoev_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcAccruedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应计利息(债券计算器)时间序列
    return w.wsd(security,"calc_accrued",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcAccrued(security:list,*args,**kwargs):
    # 获取应计利息(债券计算器)
    return w.wss(security,"calc_accrued",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPtMTradeDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取剩余存续期(交易日)时间序列
    return w.wsd(security,"ptmtradeday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPtMTradeDay(security:list,*args,**kwargs):
    # 获取剩余存续期(交易日)
    return w.wss(security,"ptmtradeday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPtMDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取剩余存续期(日历日)时间序列
    return w.wsd(security,"ptmday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPtMDay(security:list,*args,**kwargs):
    # 获取剩余存续期(日历日)
    return w.wss(security,"ptmday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTheoryValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取理论价格时间序列
    return w.wsd(security,"theoryvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTheoryValue(security:list,*args,**kwargs):
    # 获取理论价格
    return w.wss(security,"theoryvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIntrInCtValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取内在价值时间序列
    return w.wsd(security,"intrinctvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIntrInCtValue(security:list,*args,**kwargs):
    # 获取内在价值
    return w.wss(security,"intrinctvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTimeValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时间价值时间序列
    return w.wsd(security,"timevalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTimeValue(security:list,*args,**kwargs):
    # 获取时间价值
    return w.wss(security,"timevalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingHisVol30DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的30日历史波动率时间序列
    return w.wsd(security,"underlyinghisvol_30d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingHisVol30D(security:list,*args,**kwargs):
    # 获取标的30日历史波动率
    return w.wss(security,"underlyinghisvol_30d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsHisVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的60日历史波动率时间序列
    return w.wsd(security,"us_hisvol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsHisVol(security:list,*args,**kwargs):
    # 获取标的60日历史波动率
    return w.wss(security,"us_hisvol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingHisVol90DSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标的90日历史波动率时间序列
    return w.wsd(security,"underlyinghisvol_90d",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingHisVol90D(security:list,*args,**kwargs):
    # 获取标的90日历史波动率
    return w.wss(security,"underlyinghisvol_90d",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsImpliedVolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取期权隐含波动率时间序列
    return w.wsd(security,"us_impliedvol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsImpliedVol(security:list,*args,**kwargs):
    # 获取期权隐含波动率
    return w.wss(security,"us_impliedvol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolatilityRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史波动率时间序列
    return w.wsd(security,"volatilityratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVolatilityRatio(security:list,*args,**kwargs):
    # 获取历史波动率
    return w.wss(security,"volatilityratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1300(security:list,*args,**kwargs):
    # 获取1个月130%价值状态隐含波动率
    return w.wss(security,"iv_1m1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1200(security:list,*args,**kwargs):
    # 获取1个月120%价值状态隐含波动率
    return w.wss(security,"iv_1m1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1100(security:list,*args,**kwargs):
    # 获取1个月110%价值状态隐含波动率
    return w.wss(security,"iv_1m1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1050(security:list,*args,**kwargs):
    # 获取1个月105%价值状态隐含波动率
    return w.wss(security,"iv_1m1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1025(security:list,*args,**kwargs):
    # 获取1个月102.5%价值状态隐含波动率
    return w.wss(security,"iv_1m1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M1000(security:list,*args,**kwargs):
    # 获取1个月100%价值状态隐含波动率
    return w.wss(security,"iv_1m1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M975(security:list,*args,**kwargs):
    # 获取1个月97.5%价值状态隐含波动率
    return w.wss(security,"iv_1m975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M950(security:list,*args,**kwargs):
    # 获取1个月95%价值状态隐含波动率
    return w.wss(security,"iv_1m950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M900(security:list,*args,**kwargs):
    # 获取1个月90%价值状态隐含波动率
    return w.wss(security,"iv_1m900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M800(security:list,*args,**kwargs):
    # 获取1个月80%价值状态隐含波动率
    return w.wss(security,"iv_1m800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1个月60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1m600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1M600(security:list,*args,**kwargs):
    # 获取1个月60%价值状态隐含波动率
    return w.wss(security,"iv_1m600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1300(security:list,*args,**kwargs):
    # 获取2个月130%价值状态隐含波动率
    return w.wss(security,"iv_2m1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1200(security:list,*args,**kwargs):
    # 获取2个月120%价值状态隐含波动率
    return w.wss(security,"iv_2m1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1100(security:list,*args,**kwargs):
    # 获取2个月110%价值状态隐含波动率
    return w.wss(security,"iv_2m1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1050(security:list,*args,**kwargs):
    # 获取2个月105%价值状态隐含波动率
    return w.wss(security,"iv_2m1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1025(security:list,*args,**kwargs):
    # 获取2个月102.5%价值状态隐含波动率
    return w.wss(security,"iv_2m1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M1000(security:list,*args,**kwargs):
    # 获取2个月100%价值状态隐含波动率
    return w.wss(security,"iv_2m1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M975(security:list,*args,**kwargs):
    # 获取2个月97.5%价值状态隐含波动率
    return w.wss(security,"iv_2m975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M950(security:list,*args,**kwargs):
    # 获取2个月95%价值状态隐含波动率
    return w.wss(security,"iv_2m950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M900(security:list,*args,**kwargs):
    # 获取2个月90%价值状态隐含波动率
    return w.wss(security,"iv_2m900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M800(security:list,*args,**kwargs):
    # 获取2个月80%价值状态隐含波动率
    return w.wss(security,"iv_2m800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取2个月60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_2m600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv2M600(security:list,*args,**kwargs):
    # 获取2个月60%价值状态隐含波动率
    return w.wss(security,"iv_2m600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1300(security:list,*args,**kwargs):
    # 获取3个月130%价值状态隐含波动率
    return w.wss(security,"iv_3m1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1200(security:list,*args,**kwargs):
    # 获取3个月120%价值状态隐含波动率
    return w.wss(security,"iv_3m1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1100(security:list,*args,**kwargs):
    # 获取3个月110%价值状态隐含波动率
    return w.wss(security,"iv_3m1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1050(security:list,*args,**kwargs):
    # 获取3个月105%价值状态隐含波动率
    return w.wss(security,"iv_3m1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1025(security:list,*args,**kwargs):
    # 获取3个月102.5%价值状态隐含波动率
    return w.wss(security,"iv_3m1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M1000(security:list,*args,**kwargs):
    # 获取3个月100%价值状态隐含波动率
    return w.wss(security,"iv_3m1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M975(security:list,*args,**kwargs):
    # 获取3个月97.5%价值状态隐含波动率
    return w.wss(security,"iv_3m975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M950(security:list,*args,**kwargs):
    # 获取3个月95%价值状态隐含波动率
    return w.wss(security,"iv_3m950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M900(security:list,*args,**kwargs):
    # 获取3个月90%价值状态隐含波动率
    return w.wss(security,"iv_3m900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M800(security:list,*args,**kwargs):
    # 获取3个月80%价值状态隐含波动率
    return w.wss(security,"iv_3m800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取3个月60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_3m600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv3M600(security:list,*args,**kwargs):
    # 获取3个月60%价值状态隐含波动率
    return w.wss(security,"iv_3m600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1300(security:list,*args,**kwargs):
    # 获取6个月130%价值状态隐含波动率
    return w.wss(security,"iv_6m1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1200(security:list,*args,**kwargs):
    # 获取6个月120%价值状态隐含波动率
    return w.wss(security,"iv_6m1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1100(security:list,*args,**kwargs):
    # 获取6个月110%价值状态隐含波动率
    return w.wss(security,"iv_6m1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1050(security:list,*args,**kwargs):
    # 获取6个月105%价值状态隐含波动率
    return w.wss(security,"iv_6m1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1025(security:list,*args,**kwargs):
    # 获取6个月102.5%价值状态隐含波动率
    return w.wss(security,"iv_6m1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M1000(security:list,*args,**kwargs):
    # 获取6个月100%价值状态隐含波动率
    return w.wss(security,"iv_6m1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M975(security:list,*args,**kwargs):
    # 获取6个月97.5%价值状态隐含波动率
    return w.wss(security,"iv_6m975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M950(security:list,*args,**kwargs):
    # 获取6个月95%价值状态隐含波动率
    return w.wss(security,"iv_6m950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M900(security:list,*args,**kwargs):
    # 获取6个月90%价值状态隐含波动率
    return w.wss(security,"iv_6m900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M800(security:list,*args,**kwargs):
    # 获取6个月80%价值状态隐含波动率
    return w.wss(security,"iv_6m800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取6个月60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_6m600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv6M600(security:list,*args,**kwargs):
    # 获取6个月60%价值状态隐含波动率
    return w.wss(security,"iv_6m600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1300(security:list,*args,**kwargs):
    # 获取9个月130%价值状态隐含波动率
    return w.wss(security,"iv_9m1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1200(security:list,*args,**kwargs):
    # 获取9个月120%价值状态隐含波动率
    return w.wss(security,"iv_9m1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1100(security:list,*args,**kwargs):
    # 获取9个月110%价值状态隐含波动率
    return w.wss(security,"iv_9m1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1050(security:list,*args,**kwargs):
    # 获取9个月105%价值状态隐含波动率
    return w.wss(security,"iv_9m1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1025(security:list,*args,**kwargs):
    # 获取9个月102.5%价值状态隐含波动率
    return w.wss(security,"iv_9m1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M1000(security:list,*args,**kwargs):
    # 获取9个月100%价值状态隐含波动率
    return w.wss(security,"iv_9m1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M975(security:list,*args,**kwargs):
    # 获取9个月97.5%价值状态隐含波动率
    return w.wss(security,"iv_9m975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M950(security:list,*args,**kwargs):
    # 获取9个月95%价值状态隐含波动率
    return w.wss(security,"iv_9m950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M900(security:list,*args,**kwargs):
    # 获取9个月90%价值状态隐含波动率
    return w.wss(security,"iv_9m900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M800(security:list,*args,**kwargs):
    # 获取9个月80%价值状态隐含波动率
    return w.wss(security,"iv_9m800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取9个月60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_9m600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv9M600(security:list,*args,**kwargs):
    # 获取9个月60%价值状态隐含波动率
    return w.wss(security,"iv_9m600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1300Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年130%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1300",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1300(security:list,*args,**kwargs):
    # 获取1年130%价值状态隐含波动率
    return w.wss(security,"iv_1y1300",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1200Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年120%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1200",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1200(security:list,*args,**kwargs):
    # 获取1年120%价值状态隐含波动率
    return w.wss(security,"iv_1y1200",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1100Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年110%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1100",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1100(security:list,*args,**kwargs):
    # 获取1年110%价值状态隐含波动率
    return w.wss(security,"iv_1y1100",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1050Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年105%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1050",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1050(security:list,*args,**kwargs):
    # 获取1年105%价值状态隐含波动率
    return w.wss(security,"iv_1y1050",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1025Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年102.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1025",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1025(security:list,*args,**kwargs):
    # 获取1年102.5%价值状态隐含波动率
    return w.wss(security,"iv_1y1025",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1000Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年100%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y1000",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y1000(security:list,*args,**kwargs):
    # 获取1年100%价值状态隐含波动率
    return w.wss(security,"iv_1y1000",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y975Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年97.5%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y975",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y975(security:list,*args,**kwargs):
    # 获取1年97.5%价值状态隐含波动率
    return w.wss(security,"iv_1y975",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y950Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年95%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y950",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y950(security:list,*args,**kwargs):
    # 获取1年95%价值状态隐含波动率
    return w.wss(security,"iv_1y950",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y900Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年90%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y900",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y900(security:list,*args,**kwargs):
    # 获取1年90%价值状态隐含波动率
    return w.wss(security,"iv_1y900",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y800Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年80%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y800",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y800(security:list,*args,**kwargs):
    # 获取1年80%价值状态隐含波动率
    return w.wss(security,"iv_1y800",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y600Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取1年60%价值状态隐含波动率时间序列
    return w.wsd(security,"iv_1y600",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIv1Y600(security:list,*args,**kwargs):
    # 获取1年60%价值状态隐含波动率
    return w.wss(security,"iv_1y600",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)时间序列
    return w.wsd(security,"west_netprofit_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)
    return w.wss(security,"west_netprofit_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_1M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_chg_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg1M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_1M_PIT
    return w.wss(security,"west_netprofit_ftm_chg_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_3M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_chg_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg3M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_3M_PIT
    return w.wss(security,"west_netprofit_ftm_chg_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_6M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_chg_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtmChg6M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化_6M_PIT
    return w.wss(security,"west_netprofit_ftm_chg_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_1M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm1M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_1M_PIT
    return w.wss(security,"west_netprofit_ftm_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_3M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm3M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_3M_PIT
    return w.wss(security,"west_netprofit_ftm_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_6M_PIT时间序列
    return w.wsd(security,"west_netprofit_ftm_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitFtm6M(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)的变化率_6M_PIT
    return w.wss(security,"west_netprofit_ftm_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitDiffSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)与归属于母公司净利润(TTM)的差_PIT时间序列
    return w.wsd(security,"west_netprofitdiff",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitDiff(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)与归属于母公司净利润(TTM)的差_PIT
    return w.wss(security,"west_netprofitdiff",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestRoeFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)/归属于母公司的股东权益_PIT时间序列
    return w.wsd(security,"west_roe_ftm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestRoeFtm(security:list,*args,**kwargs):
    # 获取一致预测净利润(未来12个月)/归属于母公司的股东权益_PIT
    return w.wss(security,"west_roe_ftm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润同比时间序列
    return w.wsd(security,"west_netprofit_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitYoY(security:list,*args,**kwargs):
    # 获取一致预测净利润同比
    return w.wss(security,"west_netprofit_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgNpYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润同比(FY2比FY1)时间序列
    return w.wsd(security,"west_avgnp_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgNpYoY(security:list,*args,**kwargs):
    # 获取一致预测净利润同比(FY2比FY1)
    return w.wss(security,"west_avgnp_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润2年复合增长率时间序列
    return w.wsd(security,"west_netprofit_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitCAgr(security:list,*args,**kwargs):
    # 获取一致预测净利润2年复合增长率
    return w.wss(security,"west_netprofit_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc1WSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润1周变化率时间序列
    return w.wsd(security,"west_nproc_1w",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc1W(security:list,*args,**kwargs):
    # 获取一致预测净利润1周变化率
    return w.wss(security,"west_nproc_1w",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc4WSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润4周变化率时间序列
    return w.wsd(security,"west_nproc_4w",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc4W(security:list,*args,**kwargs):
    # 获取一致预测净利润4周变化率
    return w.wss(security,"west_nproc_4w",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc13WSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润13周变化率时间序列
    return w.wsd(security,"west_nproc_13w",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc13W(security:list,*args,**kwargs):
    # 获取一致预测净利润13周变化率
    return w.wss(security,"west_nproc_13w",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc26WSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测净利润26周变化率时间序列
    return w.wsd(security,"west_nproc_26w",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNProc26W(security:list,*args,**kwargs):
    # 获取一致预测净利润26周变化率
    return w.wss(security,"west_nproc_26w",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)时间序列
    return w.wsd(security,"west_eps_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)
    return w.wss(security,"west_eps_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_1M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_chg_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg1M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_1M_PIT
    return w.wss(security,"west_eps_ftm_chg_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_3M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_chg_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg3M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_3M_PIT
    return w.wss(security,"west_eps_ftm_chg_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_6M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_chg_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmChg6M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化_6M_PIT
    return w.wss(security,"west_eps_ftm_chg_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_1M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm1M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_1M_PIT
    return w.wss(security,"west_eps_ftm_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_3M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm3M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_3M_PIT
    return w.wss(security,"west_eps_ftm_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_6M_PIT时间序列
    return w.wsd(security,"west_eps_ftm_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtm6M(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)的变化率_6M_PIT
    return w.wss(security,"west_eps_ftm_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)与EPS(TTM)的变化率_PIT时间序列
    return w.wsd(security,"west_eps_ftmgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsFtmGrowth(security:list,*args,**kwargs):
    # 获取一致预测每股收益(未来12个月)与EPS(TTM)的变化率_PIT
    return w.wss(security,"west_eps_ftmgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)时间序列
    return w.wsd(security,"west_sales_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)
    return w.wss(security,"west_sales_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_1M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_chg_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg1M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_1M_PIT
    return w.wss(security,"west_sales_ftm_chg_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_3M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_chg_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg3M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_3M_PIT
    return w.wss(security,"west_sales_ftm_chg_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_6M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_chg_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtmChg6M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化_6M_PIT
    return w.wss(security,"west_sales_ftm_chg_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm1MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_1M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_1m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm1M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_1M_PIT
    return w.wss(security,"west_sales_ftm_1m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_3M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm3M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_3M_PIT
    return w.wss(security,"west_sales_ftm_3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm6MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_6M_PIT时间序列
    return w.wsd(security,"west_sales_ftm_6m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesFtm6M(security:list,*args,**kwargs):
    # 获取一致预测营业收入(未来12个月)的变化率_6M_PIT
    return w.wss(security,"west_sales_ftm_6m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入同比时间序列
    return w.wsd(security,"west_sales_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesYoY(security:list,*args,**kwargs):
    # 获取一致预测营业收入同比
    return w.wss(security,"west_sales_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业收入2年复合增长率时间序列
    return w.wsd(security,"west_sales_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesCAgr(security:list,*args,**kwargs):
    # 获取一致预测营业收入2年复合增长率
    return w.wss(security,"west_sales_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgCpSFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测每股现金流(未来12个月)时间序列
    return w.wsd(security,"west_avgcps_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgCpSFtm(security:list,*args,**kwargs):
    # 获取一致预测每股现金流(未来12个月)
    return w.wss(security,"west_avgcps_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税前利润(未来12个月)时间序列
    return w.wsd(security,"west_avgebit_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItFtm(security:list,*args,**kwargs):
    # 获取一致预测息税前利润(未来12个月)
    return w.wss(security,"west_avgebit_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税前利润同比时间序列
    return w.wsd(security,"west_avgebit_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItYoY(security:list,*args,**kwargs):
    # 获取一致预测息税前利润同比
    return w.wss(security,"west_avgebit_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税前利润年复合增长率时间序列
    return w.wsd(security,"west_avgebit_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItCAgr(security:list,*args,**kwargs):
    # 获取一致预测息税前利润年复合增长率
    return w.wss(security,"west_avgebit_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润(未来12个月)时间序列
    return w.wsd(security,"west_avgebitda_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaFtm(security:list,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润(未来12个月)
    return w.wss(security,"west_avgebitda_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润同比时间序列
    return w.wsd(security,"west_avgebitda_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaYoY(security:list,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润同比
    return w.wss(security,"west_avgebitda_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润2年复合增长率时间序列
    return w.wsd(security,"west_avgebitda_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebItDaCAgr(security:list,*args,**kwargs):
    # 获取一致预测息税折旧摊销前利润2年复合增长率
    return w.wss(security,"west_avgebitda_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测利润总额(未来12个月)时间序列
    return w.wsd(security,"west_avgebt_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTFtm(security:list,*args,**kwargs):
    # 获取一致预测利润总额(未来12个月)
    return w.wss(security,"west_avgebt_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测利润总额同比时间序列
    return w.wsd(security,"west_avgebt_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTYoY(security:list,*args,**kwargs):
    # 获取一致预测利润总额同比
    return w.wss(security,"west_avgebt_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测利润总额2年复合增长率时间序列
    return w.wsd(security,"west_avgebt_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTCAgr(security:list,*args,**kwargs):
    # 获取一致预测利润总额2年复合增长率
    return w.wss(security,"west_avgebt_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业利润(未来12个月)时间序列
    return w.wsd(security,"west_avgoperatingprofit_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitFtm(security:list,*args,**kwargs):
    # 获取一致预测营业利润(未来12个月)
    return w.wss(security,"west_avgoperatingprofit_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业利润同比时间序列
    return w.wsd(security,"west_avgoperatingprofit_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitYoY(security:list,*args,**kwargs):
    # 获取一致预测营业利润同比
    return w.wss(security,"west_avgoperatingprofit_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业利润2年复合增长率时间序列
    return w.wsd(security,"west_avgoperatingprofit_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitCAgr(security:list,*args,**kwargs):
    # 获取一致预测营业利润2年复合增长率
    return w.wss(security,"west_avgoperatingprofit_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcFtmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业成本(未来12个月)时间序列
    return w.wsd(security,"west_avgoc_FTM",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcFtm(security:list,*args,**kwargs):
    # 获取一致预测营业成本(未来12个月)
    return w.wss(security,"west_avgoc_FTM",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业成本同比时间序列
    return w.wsd(security,"west_avgoc_YOY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcYoY(security:list,*args,**kwargs):
    # 获取一致预测营业成本同比
    return w.wss(security,"west_avgoc_YOY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcCAgrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测营业成本2年复合增长率时间序列
    return w.wsd(security,"west_avgoc_CAGR",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcCAgr(security:list,*args,**kwargs):
    # 获取一致预测营业成本2年复合增长率
    return w.wss(security,"west_avgoc_CAGR",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstInStNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股收益预测机构家数时间序列
    return w.wsd(security,"est_instnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstInStNum(security:list,*args,**kwargs):
    # 获取每股收益预测机构家数
    return w.wss(security,"est_instnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股收益预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNum(security:list,*args,**kwargs):
    # 获取每股收益预测机构家数(可选类型)
    return w.wss(security,"west_instnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益平均值时间序列
    return w.wsd(security,"est_eps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEps(security:list,*args,**kwargs):
    # 获取预测每股收益平均值
    return w.wss(security,"est_eps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益平均值(币种转换)时间序列
    return w.wsd(security,"est_eps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEps1(security:list,*args,**kwargs):
    # 获取预测每股收益平均值(币种转换)
    return w.wss(security,"est_eps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益平均值(可选类型)时间序列
    return w.wsd(security,"west_eps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEps(security:list,*args,**kwargs):
    # 获取预测每股收益平均值(可选类型)
    return w.wss(security,"west_eps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_eps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestEps1(security:list,*args,**kwargs):
    # 获取预测每股收益平均值(可选类型,币种转换)
    return w.wss(security,"west_eps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最大值时间序列
    return w.wsd(security,"est_maxeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEps(security:list,*args,**kwargs):
    # 获取预测每股收益最大值
    return w.wss(security,"est_maxeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最大值(币种转换)时间序列
    return w.wsd(security,"est_maxeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEps1(security:list,*args,**kwargs):
    # 获取预测每股收益最大值(币种转换)
    return w.wss(security,"est_maxeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最大值(可选类型)时间序列
    return w.wsd(security,"west_maxeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEps(security:list,*args,**kwargs):
    # 获取预测每股收益最大值(可选类型)
    return w.wss(security,"west_maxeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEps1(security:list,*args,**kwargs):
    # 获取预测每股收益最大值(可选类型,币种转换)
    return w.wss(security,"west_maxeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinePsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最小值时间序列
    return w.wsd(security,"est_mineps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinePs(security:list,*args,**kwargs):
    # 获取预测每股收益最小值
    return w.wss(security,"est_mineps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinePs1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最小值(币种转换)时间序列
    return w.wsd(security,"est_mineps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinePs1(security:list,*args,**kwargs):
    # 获取预测每股收益最小值(币种转换)
    return w.wss(security,"est_mineps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinePsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最小值(可选类型)时间序列
    return w.wsd(security,"west_mineps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinePs(security:list,*args,**kwargs):
    # 获取预测每股收益最小值(可选类型)
    return w.wss(security,"west_mineps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinePs1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_mineps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinePs1(security:list,*args,**kwargs):
    # 获取预测每股收益最小值(可选类型,币种转换)
    return w.wss(security,"west_mineps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益中值时间序列
    return w.wsd(security,"est_medianeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEps(security:list,*args,**kwargs):
    # 获取预测每股收益中值
    return w.wss(security,"est_medianeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益中值(币种转换)时间序列
    return w.wsd(security,"est_medianeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEps1(security:list,*args,**kwargs):
    # 获取预测每股收益中值(币种转换)
    return w.wss(security,"est_medianeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益中值(可选类型)时间序列
    return w.wsd(security,"west_medianeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEps(security:list,*args,**kwargs):
    # 获取预测每股收益中值(可选类型)
    return w.wss(security,"west_medianeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_medianeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEps1(security:list,*args,**kwargs):
    # 获取预测每股收益中值(可选类型,币种转换)
    return w.wss(security,"west_medianeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益标准差时间序列
    return w.wsd(security,"est_stdeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdEps(security:list,*args,**kwargs):
    # 获取预测每股收益标准差
    return w.wss(security,"est_stdeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益标准差(币种转换)时间序列
    return w.wsd(security,"est_stdeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdEps1(security:list,*args,**kwargs):
    # 获取预测每股收益标准差(币种转换)
    return w.wss(security,"est_stdeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益标准差(可选类型)时间序列
    return w.wsd(security,"west_stdeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdEps(security:list,*args,**kwargs):
    # 获取预测每股收益标准差(可选类型)
    return w.wss(security,"west_stdeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdEps1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测每股收益标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stdeps1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdEps1(security:list,*args,**kwargs):
    # 获取预测每股收益标准差(可选类型,币种转换)
    return w.wss(security,"west_stdeps1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入平均值时间序列
    return w.wsd(security,"est_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSales(security:list,*args,**kwargs):
    # 获取预测营业收入平均值
    return w.wss(security,"est_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入平均值(币种转换)时间序列
    return w.wsd(security,"est_sales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSales1(security:list,*args,**kwargs):
    # 获取预测营业收入平均值(币种转换)
    return w.wss(security,"est_sales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入平均值(可选类型)时间序列
    return w.wsd(security,"west_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSales(security:list,*args,**kwargs):
    # 获取预测营业收入平均值(可选类型)
    return w.wss(security,"west_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_sales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSales1(security:list,*args,**kwargs):
    # 获取预测营业收入平均值(可选类型,币种转换)
    return w.wss(security,"west_sales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最大值时间序列
    return w.wsd(security,"est_maxsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxSales(security:list,*args,**kwargs):
    # 获取预测营业收入最大值
    return w.wss(security,"est_maxsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最大值(币种转换)时间序列
    return w.wsd(security,"est_maxsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxSales1(security:list,*args,**kwargs):
    # 获取预测营业收入最大值(币种转换)
    return w.wss(security,"est_maxsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最大值(可选类型)时间序列
    return w.wsd(security,"west_maxsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxSales(security:list,*args,**kwargs):
    # 获取预测营业收入最大值(可选类型)
    return w.wss(security,"west_maxsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxSales1(security:list,*args,**kwargs):
    # 获取预测营业收入最大值(可选类型,币种转换)
    return w.wss(security,"west_maxsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最小值时间序列
    return w.wsd(security,"est_minsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinSales(security:list,*args,**kwargs):
    # 获取预测营业收入最小值
    return w.wss(security,"est_minsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最小值(币种转换)时间序列
    return w.wsd(security,"est_minsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinSales1(security:list,*args,**kwargs):
    # 获取预测营业收入最小值(币种转换)
    return w.wss(security,"est_minsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最小值(可选类型)时间序列
    return w.wsd(security,"west_minsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinSales(security:list,*args,**kwargs):
    # 获取预测营业收入最小值(可选类型)
    return w.wss(security,"west_minsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_minsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinSales1(security:list,*args,**kwargs):
    # 获取预测营业收入最小值(可选类型,币种转换)
    return w.wss(security,"west_minsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入中值时间序列
    return w.wsd(security,"est_mediansales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianSales(security:list,*args,**kwargs):
    # 获取预测营业收入中值
    return w.wss(security,"est_mediansales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入中值(币种转换)时间序列
    return w.wsd(security,"est_mediansales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianSales1(security:list,*args,**kwargs):
    # 获取预测营业收入中值(币种转换)
    return w.wss(security,"est_mediansales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入中值(可选类型)时间序列
    return w.wsd(security,"west_mediansales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianSales(security:list,*args,**kwargs):
    # 获取预测营业收入中值(可选类型)
    return w.wss(security,"west_mediansales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_mediansales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianSales1(security:list,*args,**kwargs):
    # 获取预测营业收入中值(可选类型,币种转换)
    return w.wss(security,"west_mediansales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入标准差时间序列
    return w.wsd(security,"est_stdsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdSales(security:list,*args,**kwargs):
    # 获取预测营业收入标准差
    return w.wss(security,"est_stdsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入标准差(币种转换)时间序列
    return w.wsd(security,"est_stdsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdSales1(security:list,*args,**kwargs):
    # 获取预测营业收入标准差(币种转换)
    return w.wss(security,"est_stdsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入标准差(可选类型)时间序列
    return w.wsd(security,"west_stdsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdSales(security:list,*args,**kwargs):
    # 获取预测营业收入标准差(可选类型)
    return w.wss(security,"west_stdsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stdsales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdSales1(security:list,*args,**kwargs):
    # 获取预测营业收入标准差(可选类型,币种转换)
    return w.wss(security,"west_stdsales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润平均值时间序列
    return w.wsd(security,"est_netprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润平均值
    return w.wss(security,"est_netprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润平均值(币种转换)时间序列
    return w.wsd(security,"est_netprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润平均值(币种转换)
    return w.wss(security,"est_netprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润平均值(可选类型)时间序列
    return w.wsd(security,"west_netprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润平均值(可选类型)
    return w.wss(security,"west_netprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_netprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润平均值(可选类型,币种转换)
    return w.wss(security,"west_netprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最大值时间序列
    return w.wsd(security,"est_maxnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润最大值
    return w.wss(security,"est_maxnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最大值(币种转换)时间序列
    return w.wsd(security,"est_maxnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润最大值(币种转换)
    return w.wss(security,"est_maxnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最大值(可选类型)时间序列
    return w.wsd(security,"west_maxnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润最大值(可选类型)
    return w.wss(security,"west_maxnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润最大值(可选类型,币种转换)
    return w.wss(security,"west_maxnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最小值时间序列
    return w.wsd(security,"est_minnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润最小值
    return w.wss(security,"est_minnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最小值(币种转换)时间序列
    return w.wsd(security,"est_minnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润最小值(币种转换)
    return w.wss(security,"est_minnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最小值(可选类型)时间序列
    return w.wsd(security,"west_minnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润最小值(可选类型)
    return w.wss(security,"west_minnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_minnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润最小值(可选类型,币种转换)
    return w.wss(security,"west_minnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润中值时间序列
    return w.wsd(security,"est_mediannetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润中值
    return w.wss(security,"est_mediannetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润中值(币种转换)时间序列
    return w.wsd(security,"est_mediannetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润中值(币种转换)
    return w.wss(security,"est_mediannetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润中值(可选类型)时间序列
    return w.wsd(security,"west_mediannetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润中值(可选类型)
    return w.wss(security,"west_mediannetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_mediannetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润中值(可选类型,币种转换)
    return w.wss(security,"west_mediannetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润标准差时间序列
    return w.wsd(security,"est_stdnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润标准差
    return w.wss(security,"est_stdnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润标准差(币种转换)时间序列
    return w.wsd(security,"est_stdnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润标准差(币种转换)
    return w.wss(security,"est_stdnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润标准差(可选类型)时间序列
    return w.wsd(security,"west_stdnetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润标准差(可选类型)
    return w.wss(security,"west_stdnetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdNetProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stdnetprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdNetProfit1(security:list,*args,**kwargs):
    # 获取预测净利润标准差(可选类型,币种转换)
    return w.wss(security,"west_stdnetprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvGebTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额平均值时间序列
    return w.wsd(security,"est_avgebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvGebT(security:list,*args,**kwargs):
    # 获取预测利润总额平均值
    return w.wss(security,"est_avgebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvGebT1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额平均值(币种转换)时间序列
    return w.wsd(security,"est_avgebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvGebT1(security:list,*args,**kwargs):
    # 获取预测利润总额平均值(币种转换)
    return w.wss(security,"est_avgebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额平均值(可选类型)时间序列
    return w.wsd(security,"west_avgebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebT(security:list,*args,**kwargs):
    # 获取预测利润总额平均值(可选类型)
    return w.wss(security,"west_avgebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebT1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_avgebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvGebT1(security:list,*args,**kwargs):
    # 获取预测利润总额平均值(可选类型,币种转换)
    return w.wss(security,"west_avgebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最大值时间序列
    return w.wsd(security,"est_maxebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEBt(security:list,*args,**kwargs):
    # 获取预测利润总额最大值
    return w.wss(security,"est_maxebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEBt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最大值(币种转换)时间序列
    return w.wsd(security,"est_maxebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxEBt1(security:list,*args,**kwargs):
    # 获取预测利润总额最大值(币种转换)
    return w.wss(security,"est_maxebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最大值(可选类型)时间序列
    return w.wsd(security,"west_maxebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEBt(security:list,*args,**kwargs):
    # 获取预测利润总额最大值(可选类型)
    return w.wss(security,"west_maxebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEBt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxEBt1(security:list,*args,**kwargs):
    # 获取预测利润总额最大值(可选类型,币种转换)
    return w.wss(security,"west_maxebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinEBTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最小值时间序列
    return w.wsd(security,"est_minebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinEBT(security:list,*args,**kwargs):
    # 获取预测利润总额最小值
    return w.wss(security,"est_minebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinEBT1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最小值(币种转换)时间序列
    return w.wsd(security,"est_minebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinEBT1(security:list,*args,**kwargs):
    # 获取预测利润总额最小值(币种转换)
    return w.wss(security,"est_minebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinEBTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最小值(可选类型)时间序列
    return w.wsd(security,"west_minebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinEBT(security:list,*args,**kwargs):
    # 获取预测利润总额最小值(可选类型)
    return w.wss(security,"west_minebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinEBT1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_minebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinEBT1(security:list,*args,**kwargs):
    # 获取预测利润总额最小值(可选类型,币种转换)
    return w.wss(security,"west_minebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额中值时间序列
    return w.wsd(security,"est_medianebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEBt(security:list,*args,**kwargs):
    # 获取预测利润总额中值
    return w.wss(security,"est_medianebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEBt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额中值(币种转换)时间序列
    return w.wsd(security,"est_medianebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianEBt1(security:list,*args,**kwargs):
    # 获取预测利润总额中值(币种转换)
    return w.wss(security,"est_medianebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额中值(可选类型)时间序列
    return w.wsd(security,"west_medianebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEBt(security:list,*args,**kwargs):
    # 获取预测利润总额中值(可选类型)
    return w.wss(security,"west_medianebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEBt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_medianebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianEBt1(security:list,*args,**kwargs):
    # 获取预测利润总额中值(可选类型,币种转换)
    return w.wss(security,"west_medianebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额标准差时间序列
    return w.wsd(security,"est_stdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStDebt(security:list,*args,**kwargs):
    # 获取预测利润总额标准差
    return w.wss(security,"est_stdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStDebt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额标准差(币种转换)时间序列
    return w.wsd(security,"est_stdebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStDebt1(security:list,*args,**kwargs):
    # 获取预测利润总额标准差(币种转换)
    return w.wss(security,"est_stdebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额标准差(可选类型)时间序列
    return w.wsd(security,"west_stdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStDebt(security:list,*args,**kwargs):
    # 获取预测利润总额标准差(可选类型)
    return w.wss(security,"west_stdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStDebt1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测利润总额标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stdebt1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStDebt1(security:list,*args,**kwargs):
    # 获取预测利润总额标准差(可选类型,币种转换)
    return w.wss(security,"west_stdebt1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvgOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润平均值时间序列
    return w.wsd(security,"est_avgoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvgOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润平均值
    return w.wss(security,"est_avgoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvgOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润平均值(币种转换)时间序列
    return w.wsd(security,"est_avgoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstAvgOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润平均值(币种转换)
    return w.wss(security,"est_avgoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润平均值(可选类型)时间序列
    return w.wsd(security,"west_avgoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润平均值(可选类型)
    return w.wss(security,"west_avgoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_avgoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润平均值(可选类型,币种转换)
    return w.wss(security,"west_avgoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最大值时间序列
    return w.wsd(security,"est_maxoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润最大值
    return w.wss(security,"est_maxoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最大值(币种转换)时间序列
    return w.wsd(security,"est_maxoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMaxOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润最大值(币种转换)
    return w.wss(security,"est_maxoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最大值(可选类型)时间序列
    return w.wsd(security,"west_maxoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润最大值(可选类型)
    return w.wss(security,"west_maxoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润最大值(可选类型,币种转换)
    return w.wss(security,"west_maxoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最小值时间序列
    return w.wsd(security,"est_minoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润最小值
    return w.wss(security,"est_minoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最小值(币种转换)时间序列
    return w.wsd(security,"est_minoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMinOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润最小值(币种转换)
    return w.wss(security,"est_minoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最小值(可选类型)时间序列
    return w.wsd(security,"west_minoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润最小值(可选类型)
    return w.wss(security,"west_minoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_minoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润最小值(可选类型,币种转换)
    return w.wss(security,"west_minoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润中值时间序列
    return w.wsd(security,"est_medianoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润中值
    return w.wss(security,"est_medianoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润中值(币种转换)时间序列
    return w.wsd(security,"est_medianoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstMedianOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润中值(币种转换)
    return w.wss(security,"est_medianoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润中值(可选类型)时间序列
    return w.wsd(security,"west_medianoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润中值(可选类型)
    return w.wss(security,"west_medianoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_medianoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMedianOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润中值(可选类型,币种转换)
    return w.wss(security,"west_medianoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润标准差时间序列
    return w.wsd(security,"est_stdoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润标准差
    return w.wss(security,"est_stdoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润标准差(币种转换)时间序列
    return w.wsd(security,"est_stdoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润标准差(币种转换)
    return w.wss(security,"est_stdoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdOperatingProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润标准差(可选类型)时间序列
    return w.wsd(security,"west_stdoperatingprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdOperatingProfit(security:list,*args,**kwargs):
    # 获取预测营业利润标准差(可选类型)
    return w.wss(security,"west_stdoperatingprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdOperatingProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业利润标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stdoperatingprofit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestStdOperatingProfit1(security:list,*args,**kwargs):
    # 获取预测营业利润标准差(可选类型,币种转换)
    return w.wss(security,"west_stdoperatingprofit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入调高家数时间序列
    return w.wsd(security,"est_sales_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesUpgrade(security:list,*args,**kwargs):
    # 获取营业收入调高家数
    return w.wss(security,"est_sales_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入调高家数(可选类型)时间序列
    return w.wsd(security,"west_sales_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesUpgrade(security:list,*args,**kwargs):
    # 获取营业收入调高家数(可选类型)
    return w.wss(security,"west_sales_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入调低家数时间序列
    return w.wsd(security,"est_sales_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesDowngrade(security:list,*args,**kwargs):
    # 获取营业收入调低家数
    return w.wss(security,"est_sales_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入调低家数(可选类型)时间序列
    return w.wsd(security,"west_sales_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesDowngrade(security:list,*args,**kwargs):
    # 获取营业收入调低家数(可选类型)
    return w.wss(security,"west_sales_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入维持家数时间序列
    return w.wsd(security,"est_sales_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesMaintain(security:list,*args,**kwargs):
    # 获取营业收入维持家数
    return w.wss(security,"est_sales_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入维持家数(可选类型)时间序列
    return w.wsd(security,"west_sales_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSalesMaintain(security:list,*args,**kwargs):
    # 获取营业收入维持家数(可选类型)
    return w.wss(security,"west_sales_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润调高家数时间序列
    return w.wsd(security,"est_netprofit_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitUpgrade(security:list,*args,**kwargs):
    # 获取净利润调高家数
    return w.wss(security,"est_netprofit_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润调高家数(可选类型)时间序列
    return w.wsd(security,"west_netprofit_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitUpgrade(security:list,*args,**kwargs):
    # 获取净利润调高家数(可选类型)
    return w.wss(security,"west_netprofit_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润调低家数时间序列
    return w.wsd(security,"est_netprofit_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitDowngrade(security:list,*args,**kwargs):
    # 获取净利润调低家数
    return w.wss(security,"est_netprofit_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润调低家数(可选类型)时间序列
    return w.wsd(security,"west_netprofit_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitDowngrade(security:list,*args,**kwargs):
    # 获取净利润调低家数(可选类型)
    return w.wss(security,"west_netprofit_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润维持家数时间序列
    return w.wsd(security,"est_netprofit_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitMaintain(security:list,*args,**kwargs):
    # 获取净利润维持家数
    return w.wss(security,"est_netprofit_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润维持家数(可选类型)时间序列
    return w.wsd(security,"west_netprofit_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestNetProfitMaintain(security:list,*args,**kwargs):
    # 获取净利润维持家数(可选类型)
    return w.wss(security,"west_netprofit_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstYoYNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润增长率时间序列
    return w.wsd(security,"est_yoynetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstYoYNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润增长率
    return w.wss(security,"est_yoynetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestYoYNetProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测净利润增长率(可选类型)时间序列
    return w.wsd(security,"west_yoynetprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestYoYNetProfit(security:list,*args,**kwargs):
    # 获取预测净利润增长率(可选类型)
    return w.wss(security,"west_yoynetprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstYoYSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入增长率时间序列
    return w.wsd(security,"est_yoysales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstYoYSales(security:list,*args,**kwargs):
    # 获取预测营业收入增长率
    return w.wss(security,"est_yoysales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestYoYSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业收入增长率(可选类型)时间序列
    return w.wsd(security,"west_yoysales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestYoYSales(security:list,*args,**kwargs):
    # 获取预测营业收入增长率(可选类型)
    return w.wss(security,"west_yoysales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(数值)时间序列
    return w.wsd(security,"rating_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvg(security:list,*args,**kwargs):
    # 获取综合评级(数值)
    return w.wss(security,"rating_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgDataSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(数值)(可选类型)时间序列
    return w.wsd(security,"wrating_avg_data",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgData(security:list,*args,**kwargs):
    # 获取综合评级(数值)(可选类型)
    return w.wss(security,"wrating_avg_data",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvgChNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(中文)时间序列
    return w.wsd(security,"rating_avgchn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvgChN(security:list,*args,**kwargs):
    # 获取综合评级(中文)
    return w.wss(security,"rating_avgchn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(中文)(可选类型)时间序列
    return w.wsd(security,"wrating_avg_cn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgCn(security:list,*args,**kwargs):
    # 获取综合评级(中文)(可选类型)
    return w.wss(security,"wrating_avg_cn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvGengSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(英文)时间序列
    return w.wsd(security,"rating_avgeng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingAvGeng(security:list,*args,**kwargs):
    # 获取综合评级(英文)
    return w.wss(security,"rating_avgeng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgEnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合评级(英文)(可选类型)时间序列
    return w.wsd(security,"wrating_avg_en",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingAvgEn(security:list,*args,**kwargs):
    # 获取综合评级(英文)(可选类型)
    return w.wss(security,"wrating_avg_en",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingInStNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级机构家数时间序列
    return w.wsd(security,"rating_instnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingInStNum(security:list,*args,**kwargs):
    # 获取评级机构家数
    return w.wss(security,"rating_instnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingInStNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级机构家数(可选类型)时间序列
    return w.wsd(security,"wrating_instnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingInStNum(security:list,*args,**kwargs):
    # 获取评级机构家数(可选类型)
    return w.wss(security,"wrating_instnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级调高家数时间序列
    return w.wsd(security,"rating_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingUpgrade(security:list,*args,**kwargs):
    # 获取评级调高家数
    return w.wss(security,"rating_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingUpgradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级调高家数(可选类型)时间序列
    return w.wsd(security,"wrating_upgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingUpgrade(security:list,*args,**kwargs):
    # 获取评级调高家数(可选类型)
    return w.wss(security,"wrating_upgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级调低家数时间序列
    return w.wsd(security,"rating_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingDowngrade(security:list,*args,**kwargs):
    # 获取评级调低家数
    return w.wss(security,"rating_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingDowngradeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级调低家数(可选类型)时间序列
    return w.wsd(security,"wrating_downgrade",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingDowngrade(security:list,*args,**kwargs):
    # 获取评级调低家数(可选类型)
    return w.wss(security,"wrating_downgrade",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级维持家数时间序列
    return w.wsd(security,"rating_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingMaintain(security:list,*args,**kwargs):
    # 获取评级维持家数
    return w.wss(security,"rating_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingMaintainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级维持家数(可选类型)时间序列
    return w.wsd(security,"wrating_maintain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingMaintain(security:list,*args,**kwargs):
    # 获取评级维持家数(可选类型)
    return w.wss(security,"wrating_maintain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfBuySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级买入家数时间序列
    return w.wsd(security,"rating_numofbuy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfBuy(security:list,*args,**kwargs):
    # 获取评级买入家数
    return w.wss(security,"rating_numofbuy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfBuySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级买入家数(可选类型)时间序列
    return w.wsd(security,"wrating_numofbuy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfBuy(security:list,*args,**kwargs):
    # 获取评级买入家数(可选类型)
    return w.wss(security,"wrating_numofbuy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfOutperformSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级增持家数时间序列
    return w.wsd(security,"rating_numofoutperform",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfOutperform(security:list,*args,**kwargs):
    # 获取评级增持家数
    return w.wss(security,"rating_numofoutperform",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfOutperformSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级增持家数(可选类型)时间序列
    return w.wsd(security,"wrating_numofoutperform",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfOutperform(security:list,*args,**kwargs):
    # 获取评级增持家数(可选类型)
    return w.wss(security,"wrating_numofoutperform",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfHoldSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级中性家数时间序列
    return w.wsd(security,"rating_numofhold",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfHold(security:list,*args,**kwargs):
    # 获取评级中性家数
    return w.wss(security,"rating_numofhold",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfHoldSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级中性家数(可选类型)时间序列
    return w.wsd(security,"wrating_numofhold",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfHold(security:list,*args,**kwargs):
    # 获取评级中性家数(可选类型)
    return w.wss(security,"wrating_numofhold",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfUnderPerformSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级减持家数时间序列
    return w.wsd(security,"rating_numofunderperform",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfUnderPerform(security:list,*args,**kwargs):
    # 获取评级减持家数
    return w.wss(security,"rating_numofunderperform",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfUnderPerformSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级减持家数(可选类型)时间序列
    return w.wsd(security,"wrating_numofunderperform",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfUnderPerform(security:list,*args,**kwargs):
    # 获取评级减持家数(可选类型)
    return w.wss(security,"wrating_numofunderperform",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfSellSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级卖出家数时间序列
    return w.wsd(security,"rating_numofsell",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingNumOfSell(security:list,*args,**kwargs):
    # 获取评级卖出家数
    return w.wss(security,"rating_numofsell",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfSellSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级卖出家数(可选类型)时间序列
    return w.wsd(security,"wrating_numofsell",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingNumOfSell(security:list,*args,**kwargs):
    # 获取评级卖出家数(可选类型)
    return w.wss(security,"wrating_numofsell",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingTargetPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测目标价时间序列
    return w.wsd(security,"wrating_targetprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWRatingTargetPrice(security:list,*args,**kwargs):
    # 获取一致预测目标价
    return w.wss(security,"wrating_targetprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTargetPriceAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测目标价(可选类型)时间序列
    return w.wsd(security,"targetprice_avg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTargetPriceAvg(security:list,*args,**kwargs):
    # 获取一致预测目标价(可选类型)
    return w.wss(security,"targetprice_avg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestFReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一致预测目标价上升空间_PIT时间序列
    return w.wsd(security,"west_freturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestFReturn(security:list,*args,**kwargs):
    # 获取一致预测目标价上升空间_PIT
    return w.wss(security,"west_freturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEventDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大事日期(大事后预测)时间序列
    return w.wsd(security,"est_event_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEventDate(security:list,*args,**kwargs):
    # 获取大事日期(大事后预测)
    return w.wss(security,"est_event_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业收入预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumSales(security:list,*args,**kwargs):
    # 获取营业收入预测机构家数(可选类型)
    return w.wss(security,"west_instnum_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumNpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净利润预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_np",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumNp(security:list,*args,**kwargs):
    # 获取净利润预测机构家数(可选类型)
    return w.wss(security,"west_instnum_np",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumCpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股现金流预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_cps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumCpS(security:list,*args,**kwargs):
    # 获取每股现金流预测机构家数(可选类型)
    return w.wss(security,"west_instnum_cps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumDpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股股利预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_dps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumDps(security:list,*args,**kwargs):
    # 获取每股股利预测机构家数(可选类型)
    return w.wss(security,"west_instnum_dps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEbItSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取息税前利润预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_ebit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEbIt(security:list,*args,**kwargs):
    # 获取息税前利润预测机构家数(可选类型)
    return w.wss(security,"west_instnum_ebit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEbItDaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取息税折旧摊销前利润预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_ebitda",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEbItDa(security:list,*args,**kwargs):
    # 获取息税折旧摊销前利润预测机构家数(可选类型)
    return w.wss(security,"west_instnum_ebitda",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumBpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股净资产预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_bps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumBpS(security:list,*args,**kwargs):
    # 获取每股净资产预测机构家数(可选类型)
    return w.wss(security,"west_instnum_bps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取利润总额预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_ebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumEBt(security:list,*args,**kwargs):
    # 获取利润总额预测机构家数(可选类型)
    return w.wss(security,"west_instnum_ebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumRoaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总资产收益率预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_roa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumRoa(security:list,*args,**kwargs):
    # 获取总资产收益率预测机构家数(可选类型)
    return w.wss(security,"west_instnum_roa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumRoeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取净资产收益率预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_roe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumRoe(security:list,*args,**kwargs):
    # 获取净资产收益率预测机构家数(可选类型)
    return w.wss(security,"west_instnum_roe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumOpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业利润预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_op",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumOp(security:list,*args,**kwargs):
    # 获取营业利润预测机构家数(可选类型)
    return w.wss(security,"west_instnum_op",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本平均值(可选类型)时间序列
    return w.wsd(security,"west_avgoc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOc(security:list,*args,**kwargs):
    # 获取预测营业成本平均值(可选类型)
    return w.wss(security,"west_avgoc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本最大值(可选类型)时间序列
    return w.wsd(security,"west_maxoc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOc(security:list,*args,**kwargs):
    # 获取预测营业成本最大值(可选类型)
    return w.wss(security,"west_maxoc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinoCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本最小值(可选类型)时间序列
    return w.wsd(security,"west_minoc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinoC(security:list,*args,**kwargs):
    # 获取预测营业成本最小值(可选类型)
    return w.wss(security,"west_minoc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMediaOcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本中值(可选类型)时间序列
    return w.wsd(security,"west_mediaoc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMediaOc(security:list,*args,**kwargs):
    # 获取预测营业成本中值(可选类型)
    return w.wss(security,"west_mediaoc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSToCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本标准差(可选类型)时间序列
    return w.wsd(security,"west_stoc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSToC(security:list,*args,**kwargs):
    # 获取预测营业成本标准差(可选类型)
    return w.wss(security,"west_stoc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测基准股本综合值(可选类型)时间序列
    return w.wsd(security,"west_avgshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgShares(security:list,*args,**kwargs):
    # 获取预测基准股本综合值(可选类型)
    return w.wss(security,"west_avgshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getErrWiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取盈利修正比例(可选类型)时间序列
    return w.wsd(security,"err_wi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getErrWi(security:list,*args,**kwargs):
    # 获取盈利修正比例(可选类型)
    return w.wss(security,"err_wi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstCAgrNpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未来3年净利润复合年增长率时间序列
    return w.wsd(security,"est_cagr_np",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstCAgrNp(security:list,*args,**kwargs):
    # 获取未来3年净利润复合年增长率
    return w.wss(security,"est_cagr_np",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstCAgrSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未来3年营业总收入复合年增长率时间序列
    return w.wsd(security,"est_cagr_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstCAgrSales(security:list,*args,**kwargs):
    # 获取未来3年营业总收入复合年增长率
    return w.wss(security,"est_cagr_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumGmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取销售毛利率预测机构家数(可选类型)时间序列
    return w.wsd(security,"west_instnum_gm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestInStNumGm(security:list,*args,**kwargs):
    # 获取销售毛利率预测机构家数(可选类型)
    return w.wss(security,"west_instnum_gm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOc1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本平均值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_avgoc1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestAvgOc1(security:list,*args,**kwargs):
    # 获取预测营业成本平均值(可选类型,币种转换)
    return w.wss(security,"west_avgoc1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOc1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本最大值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_maxoc1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMaxOc1(security:list,*args,**kwargs):
    # 获取预测营业成本最大值(可选类型,币种转换)
    return w.wss(security,"west_maxoc1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinoC1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本最小值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_minoc1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMinoC1(security:list,*args,**kwargs):
    # 获取预测营业成本最小值(可选类型,币种转换)
    return w.wss(security,"west_minoc1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMediaOc1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本中值(可选类型,币种转换)时间序列
    return w.wsd(security,"west_mediaoc1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestMediaOc1(security:list,*args,**kwargs):
    # 获取预测营业成本中值(可选类型,币种转换)
    return w.wss(security,"west_mediaoc1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSToC1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测营业成本标准差(可选类型,币种转换)时间序列
    return w.wsd(security,"west_stoc1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWestSToC1(security:list,*args,**kwargs):
    # 获取预测营业成本标准差(可选类型,币种转换)
    return w.wss(security,"west_stoc1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPreLowPriceInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前次最低目标价时间序列
    return w.wsd(security,"est_prelowprice_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPreLowPriceInSt(security:list,*args,**kwargs):
    # 获取前次最低目标价
    return w.wss(security,"est_prelowprice_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPreHighPriceInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前次最高目标价时间序列
    return w.wsd(security,"est_prehighprice_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstPreHighPriceInSt(security:list,*args,**kwargs):
    # 获取前次最高目标价
    return w.wss(security,"est_prehighprice_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstLowPriceInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本次最低目标价时间序列
    return w.wsd(security,"est_lowprice_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstLowPriceInSt(security:list,*args,**kwargs):
    # 获取本次最低目标价
    return w.wss(security,"est_lowprice_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstHighPriceInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本次最高目标价时间序列
    return w.wsd(security,"est_highprice_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstHighPriceInSt(security:list,*args,**kwargs):
    # 获取本次最高目标价
    return w.wss(security,"est_highprice_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstOrGratingInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资评级(原始)时间序列
    return w.wsd(security,"est_orgrating_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstOrGratingInSt(security:list,*args,**kwargs):
    # 获取机构投资评级(原始)
    return w.wss(security,"est_orgrating_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstScoreRatingInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资评级(标准化得分)时间序列
    return w.wsd(security,"est_scorerating_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstScoreRatingInSt(security:list,*args,**kwargs):
    # 获取机构投资评级(标准化得分)
    return w.wss(security,"est_scorerating_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdRatingInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资评级(标准化评级)时间序列
    return w.wsd(security,"est_stdrating_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstStdRatingInSt(security:list,*args,**kwargs):
    # 获取机构投资评级(标准化评级)
    return w.wss(security,"est_stdrating_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNewRatingTimeInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构最近评级时间时间序列
    return w.wsd(security,"est_newratingtime_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNewRatingTimeInSt(security:list,*args,**kwargs):
    # 获取机构最近评级时间
    return w.wss(security,"est_newratingtime_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEstNewTimeInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构最近预测时间时间序列
    return w.wsd(security,"est_estnewtime_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEstNewTimeInSt(security:list,*args,**kwargs):
    # 获取机构最近预测时间
    return w.wss(security,"est_estnewtime_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构预测营业收入时间序列
    return w.wsd(security,"est_sales_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstSalesInSt(security:list,*args,**kwargs):
    # 获取机构预测营业收入
    return w.wss(security,"est_sales_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构预测净利润时间序列
    return w.wsd(security,"est_netprofit_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstNetProfitInSt(security:list,*args,**kwargs):
    # 获取机构预测净利润
    return w.wss(security,"est_netprofit_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEpsInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构预测每股收益时间序列
    return w.wsd(security,"est_eps_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEpsInSt(security:list,*args,**kwargs):
    # 获取机构预测每股收益
    return w.wss(security,"est_eps_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstFrStRatingTimeInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构首次评级时间时间序列
    return w.wsd(security,"est_frstratingtime_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstFrStRatingTimeInSt(security:list,*args,**kwargs):
    # 获取机构首次评级时间
    return w.wss(security,"est_frstratingtime_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRatingAnalystSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取评级研究员时间序列
    return w.wsd(security,"est_ratinganalyst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRatingAnalyst(security:list,*args,**kwargs):
    # 获取评级研究员
    return w.wss(security,"est_ratinganalyst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEstAnalystSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预测研究员时间序列
    return w.wsd(security,"est_estanalyst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstEstAnalyst(security:list,*args,**kwargs):
    # 获取预测研究员
    return w.wss(security,"est_estanalyst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRpTAbstractInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取内容时间序列
    return w.wsd(security,"est_rptabstract_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRpTAbstractInSt(security:list,*args,**kwargs):
    # 获取内容
    return w.wss(security,"est_rptabstract_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRpTTitleInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告标题时间序列
    return w.wsd(security,"est_rpttitle_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEstRpTTitleInSt(security:list,*args,**kwargs):
    # 获取报告标题
    return w.wss(security,"est_rpttitle_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净利润变动幅度(%)时间序列
    return w.wsd(security,"profitnotice_change",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChange(security:list,*args,**kwargs):
    # 获取预告净利润变动幅度(%)
    return w.wss(security,"profitnotice_change",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLaStepsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取去年同期每股收益时间序列
    return w.wsd(security,"profitnotice_lasteps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLaSteps(security:list,*args,**kwargs):
    # 获取去年同期每股收益
    return w.wss(security,"profitnotice_lasteps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteProfitApr3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可分配利润时间序列
    return w.wsd(security,"stmnote_profitapr_3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteProfitApr3(security:list,*args,**kwargs):
    # 获取可分配利润
    return w.wss(security,"stmnote_profitapr_3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上年同期扣非净利润时间序列
    return w.wsd(security,"profitnotice_lastyeardeductedprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedProfit(security:list,*args,**kwargs):
    # 获取上年同期扣非净利润
    return w.wss(security,"profitnotice_lastyeardeductedprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上年同期营业收入时间序列
    return w.wsd(security,"profitnotice_lastyearincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearIncome(security:list,*args,**kwargs):
    # 获取上年同期营业收入
    return w.wss(security,"profitnotice_lastyearincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上年同期扣除后营业收入时间序列
    return w.wsd(security,"profitnotice_lastyeardeductedsales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedSales(security:list,*args,**kwargs):
    # 获取上年同期扣除后营业收入
    return w.wss(security,"profitnotice_lastyeardeductedsales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeBasicEarnMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告基本每股收益下限时间序列
    return w.wsd(security,"profitnotice_basicearnmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeBasicEarnMax(security:list,*args,**kwargs):
    # 获取预告基本每股收益下限
    return w.wss(security,"profitnotice_basicearnmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeBasicEarnMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告基本每股收益上限时间序列
    return w.wsd(security,"profitnotice_basicearnmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeBasicEarnMin(security:list,*args,**kwargs):
    # 获取预告基本每股收益上限
    return w.wss(security,"profitnotice_basicearnmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedEarnMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非后基本每股收益下限时间序列
    return w.wsd(security,"profitnotice_deductedearnmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedEarnMin(security:list,*args,**kwargs):
    # 获取预告扣非后基本每股收益下限
    return w.wss(security,"profitnotice_deductedearnmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedEarnMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非后基本每股收益上限时间序列
    return w.wsd(security,"profitnotice_deductedearnmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedEarnMax(security:list,*args,**kwargs):
    # 获取预告扣非后基本每股收益上限
    return w.wss(security,"profitnotice_deductedearnmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedEarnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上年同期扣非后基本每股收益时间序列
    return w.wsd(security,"profitnotice_lastyeardeductedearn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeLastYearDeductedEarn(security:list,*args,**kwargs):
    # 获取上年同期扣非后基本每股收益
    return w.wss(security,"profitnotice_lastyeardeductedearn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetProfitMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净利润上限时间序列
    return w.wsd(security,"profitnotice_netprofitmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetProfitMax(security:list,*args,**kwargs):
    # 获取预告净利润上限
    return w.wss(security,"profitnotice_netprofitmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetProfitMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净利润上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netprofitmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetProfitMax(security:list,*args,**kwargs):
    # 获取单季度.预告净利润上限(海外)
    return w.wss(security,"qprofitnotice_netprofitmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetProfitMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净利润下限时间序列
    return w.wsd(security,"profitnotice_netprofitmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetProfitMin(security:list,*args,**kwargs):
    # 获取预告净利润下限
    return w.wss(security,"profitnotice_netprofitmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetProfitMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净利润下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netprofitmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetProfitMin(security:list,*args,**kwargs):
    # 获取单季度.预告净利润下限(海外)
    return w.wss(security,"qprofitnotice_netprofitmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChangeMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净利润同比增长上限时间序列
    return w.wsd(security,"profitnotice_changemax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChangeMax(security:list,*args,**kwargs):
    # 获取预告净利润同比增长上限
    return w.wss(security,"profitnotice_changemax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeChangeMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净利润同比增长上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_changemax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeChangeMax(security:list,*args,**kwargs):
    # 获取单季度.预告净利润同比增长上限(海外)
    return w.wss(security,"qprofitnotice_changemax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChangeMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净利润同比增长下限时间序列
    return w.wsd(security,"profitnotice_changemin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeChangeMin(security:list,*args,**kwargs):
    # 获取预告净利润同比增长下限
    return w.wss(security,"profitnotice_changemin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeChangeMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净利润同比增长下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_changemin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeChangeMin(security:list,*args,**kwargs):
    # 获取单季度.预告净利润同比增长下限(海外)
    return w.wss(security,"qprofitnotice_changemin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非净利润上限时间序列
    return w.wsd(security,"profitnotice_deductedprofitmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitMax(security:list,*args,**kwargs):
    # 获取预告扣非净利润上限
    return w.wss(security,"profitnotice_deductedprofitmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非净利润下限时间序列
    return w.wsd(security,"profitnotice_deductedprofitmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitMin(security:list,*args,**kwargs):
    # 获取预告扣非净利润下限
    return w.wss(security,"profitnotice_deductedprofitmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitYoYMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非净利润同比增长上限时间序列
    return w.wsd(security,"profitnotice_deductedprofityoymax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitYoYMax(security:list,*args,**kwargs):
    # 获取预告扣非净利润同比增长上限
    return w.wss(security,"profitnotice_deductedprofityoymax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitYoYMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣非净利润同比增长下限时间序列
    return w.wsd(security,"profitnotice_deductedprofityoymin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedProfitYoYMin(security:list,*args,**kwargs):
    # 获取预告扣非净利润同比增长下限
    return w.wss(security,"profitnotice_deductedprofityoymin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeIncomeMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告营业收入上限时间序列
    return w.wsd(security,"profitnotice_incomemax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeIncomeMax(security:list,*args,**kwargs):
    # 获取预告营业收入上限
    return w.wss(security,"profitnotice_incomemax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeIncomeMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告营业收入下限时间序列
    return w.wsd(security,"profitnotice_incomemin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeIncomeMin(security:list,*args,**kwargs):
    # 获取预告营业收入下限
    return w.wss(security,"profitnotice_incomemin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedSalesMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣除后营业收入上限时间序列
    return w.wsd(security,"profitnotice_deductedsalesmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedSalesMax(security:list,*args,**kwargs):
    # 获取预告扣除后营业收入上限
    return w.wss(security,"profitnotice_deductedsalesmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedSalesMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告扣除后营业收入下限时间序列
    return w.wsd(security,"profitnotice_deductedsalesmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeDeductedSalesMin(security:list,*args,**kwargs):
    # 获取预告扣除后营业收入下限
    return w.wss(security,"profitnotice_deductedsalesmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净营收上限(海外)时间序列
    return w.wsd(security,"profitnotice_netsalesmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesMax(security:list,*args,**kwargs):
    # 获取预告净营收上限(海外)
    return w.wss(security,"profitnotice_netsalesmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净营收上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netsalesmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesMax(security:list,*args,**kwargs):
    # 获取单季度.预告净营收上限(海外)
    return w.wss(security,"qprofitnotice_netsalesmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净营收下限(海外)时间序列
    return w.wsd(security,"profitnotice_netsalesmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesMin(security:list,*args,**kwargs):
    # 获取预告净营收下限(海外)
    return w.wss(security,"profitnotice_netsalesmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净营收下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netsalesmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesMin(security:list,*args,**kwargs):
    # 获取单季度.预告净营收下限(海外)
    return w.wss(security,"qprofitnotice_netsalesmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesYoYMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净营收同比增长上限(海外)时间序列
    return w.wsd(security,"profitnotice_netsalesyoymax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesYoYMax(security:list,*args,**kwargs):
    # 获取预告净营收同比增长上限(海外)
    return w.wss(security,"profitnotice_netsalesyoymax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesYoYMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净营收同比增长上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netsalesyoymax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesYoYMax(security:list,*args,**kwargs):
    # 获取单季度.预告净营收同比增长上限(海外)
    return w.wss(security,"qprofitnotice_netsalesyoymax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesYoYMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告净营收同比增长下限(海外)时间序列
    return w.wsd(security,"profitnotice_netsalesyoymin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeNetSalesYoYMin(security:list,*args,**kwargs):
    # 获取预告净营收同比增长下限(海外)
    return w.wss(security,"profitnotice_netsalesyoymin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesYoYMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告净营收同比增长下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_netsalesyoymin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeNetSalesYoYMin(security:list,*args,**kwargs):
    # 获取单季度.预告净营收同比增长下限(海外)
    return w.wss(security,"qprofitnotice_netsalesyoymin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告总营收上限(海外)时间序列
    return w.wsd(security,"profitnotice_salesmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesMax(security:list,*args,**kwargs):
    # 获取预告总营收上限(海外)
    return w.wss(security,"profitnotice_salesmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告总营收上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_salesmax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesMax(security:list,*args,**kwargs):
    # 获取单季度.预告总营收上限(海外)
    return w.wss(security,"qprofitnotice_salesmax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告总营收下限(海外)时间序列
    return w.wsd(security,"profitnotice_salesmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesMin(security:list,*args,**kwargs):
    # 获取预告总营收下限(海外)
    return w.wss(security,"profitnotice_salesmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告总营收下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_salesmin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesMin(security:list,*args,**kwargs):
    # 获取单季度.预告总营收下限(海外)
    return w.wss(security,"qprofitnotice_salesmin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesYoYMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告总营收同比增长上限(海外)时间序列
    return w.wsd(security,"profitnotice_salesyoymax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesYoYMax(security:list,*args,**kwargs):
    # 获取预告总营收同比增长上限(海外)
    return w.wss(security,"profitnotice_salesyoymax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesYoYMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告总营收同比增长上限(海外)时间序列
    return w.wsd(security,"qprofitnotice_salesyoymax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesYoYMax(security:list,*args,**kwargs):
    # 获取单季度.预告总营收同比增长上限(海外)
    return w.wss(security,"qprofitnotice_salesyoymax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesYoYMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预告总营收同比增长下限(海外)时间序列
    return w.wsd(security,"profitnotice_salesyoymin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProfitNoticeSalesYoYMin(security:list,*args,**kwargs):
    # 获取预告总营收同比增长下限(海外)
    return w.wss(security,"profitnotice_salesyoymin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesYoYMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.预告总营收同比增长下限(海外)时间序列
    return w.wsd(security,"qprofitnotice_salesyoymin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQProfitNoticeSalesYoYMin(security:list,*args,**kwargs):
    # 获取单季度.预告总营收同比增长下限(海外)
    return w.wss(security,"qprofitnotice_salesyoymin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToInterestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取现金流量利息保障倍数时间序列
    return w.wsd(security,"ocftointerest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToInterest(security:list,*args,**kwargs):
    # 获取现金流量利息保障倍数
    return w.wss(security,"ocftointerest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCfpSTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股现金流量净额(TTM)_PIT时间序列
    return w.wsd(security,"fa_cfps_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCfpSTtM(security:list,*args,**kwargs):
    # 获取每股现金流量净额(TTM)_PIT
    return w.wss(security,"fa_cfps_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股现金流量净额时间序列
    return w.wsd(security,"cfps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfpS(security:list,*args,**kwargs):
    # 获取每股现金流量净额
    return w.wss(security,"cfps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCfpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_cfps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCfpS(security:list,*args,**kwargs):
    # 获取每股现金流量净额_GSD
    return w.wss(security,"wgsd_cfps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCashBalChgCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他现金流量调整_GSD时间序列
    return w.wsd(security,"wgsd_cash_bal_chg_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCashBalChgCf(security:list,*args,**kwargs):
    # 获取其他现金流量调整_GSD
    return w.wss(security,"wgsd_cash_bal_chg_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业自由现金流量FCFF时间序列
    return w.wsd(security,"fcff",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFf(security:list,*args,**kwargs):
    # 获取企业自由现金流量FCFF
    return w.wss(security,"fcff",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股权自由现金流量FCFE时间序列
    return w.wsd(security,"fcfe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFe(security:list,*args,**kwargs):
    # 获取股权自由现金流量FCFE
    return w.wss(security,"fcfe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFe2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取股权自由现金流量FCFE_GSD时间序列
    return w.wsd(security,"wgsd_fcfe2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFe2(security:list,*args,**kwargs):
    # 获取股权自由现金流量FCFE_GSD
    return w.wss(security,"wgsd_fcfe2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFf2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业自由现金流量_GSD时间序列
    return w.wsd(security,"wgsd_fcff2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFf2(security:list,*args,**kwargs):
    # 获取企业自由现金流量_GSD
    return w.wss(security,"wgsd_fcff2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业自由现金流量_PIT时间序列
    return w.wsd(security,"fa_fcff",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFf(security:list,*args,**kwargs):
    # 获取企业自由现金流量_PIT
    return w.wss(security,"fa_fcff",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股权自由现金流量_PIT时间序列
    return w.wsd(security,"fa_fcfe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFe(security:list,*args,**kwargs):
    # 获取股权自由现金流量_PIT
    return w.wss(security,"fa_fcfe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaNcGrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增长率-净现金流量(TTM)_PIT时间序列
    return w.wsd(security,"fa_ncgr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaNcGrTtM(security:list,*args,**kwargs):
    # 获取增长率-净现金流量(TTM)_PIT
    return w.wss(security,"fa_ncgr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFFpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股企业自由现金流量时间序列
    return w.wsd(security,"fcffps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFFps(security:list,*args,**kwargs):
    # 获取每股企业自由现金流量
    return w.wss(security,"fcffps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股股东自由现金流量时间序列
    return w.wsd(security,"fcfeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFEps(security:list,*args,**kwargs):
    # 获取每股股东自由现金流量
    return w.wss(security,"fcfeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFFps2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股企业自由现金流量_GSD时间序列
    return w.wsd(security,"wgsd_fcffps2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFFps2(security:list,*args,**kwargs):
    # 获取每股企业自由现金流量_GSD
    return w.wss(security,"wgsd_fcffps2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFEps2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股股东自由现金流量_GSD时间序列
    return w.wsd(security,"wgsd_fcfeps2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFcFEps2(security:list,*args,**kwargs):
    # 获取每股股东自由现金流量_GSD
    return w.wss(security,"wgsd_fcfeps2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaCashBalChgCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.其他现金流量调整_GSD时间序列
    return w.wsd(security,"wgsd_qfa_cash_bal_chg_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaCashBalChgCf(security:list,*args,**kwargs):
    # 获取单季度.其他现金流量调整_GSD
    return w.wss(security,"wgsd_qfa_cash_bal_chg_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFFpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股企业自由现金流量_PIT时间序列
    return w.wsd(security,"fa_fcffps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFFps(security:list,*args,**kwargs):
    # 获取每股企业自由现金流量_PIT
    return w.wss(security,"fa_fcffps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFEpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股股东自由现金流量_PIT时间序列
    return w.wsd(security,"fa_fcfeps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaFcFEps(security:list,*args,**kwargs):
    # 获取每股股东自由现金流量_PIT
    return w.wss(security,"fa_fcfeps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToInterestDebtTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生现金流量净额/带息债务(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocftointerestdebt_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToInterestDebtTtM(security:list,*args,**kwargs):
    # 获取经营活动产生现金流量净额/带息债务(TTM)_PIT
    return w.wss(security,"fa_ocftointerestdebt_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToNetDebtTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生现金流量净额/净债务(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocftonetdebt_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToNetDebtTtM(security:list,*args,**kwargs):
    # 获取经营活动产生现金流量净额/净债务(TTM)_PIT
    return w.wss(security,"fa_ocftonetdebt_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入时间序列
    return w.wsd(security,"ocftoor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOr(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入
    return w.wss(security,"ocftoor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益时间序列
    return w.wsd(security,"ocftooperateincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncome(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益
    return w.wss(security,"ocftooperateincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFTOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额占比时间序列
    return w.wsd(security,"ocftocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFTOCF(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额占比
    return w.wss(security,"ocftocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getICfTOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资活动产生的现金流量净额占比时间序列
    return w.wsd(security,"icftocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getICfTOCF(security:list,*args,**kwargs):
    # 获取投资活动产生的现金流量净额占比
    return w.wss(security,"icftocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFTOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额占比时间序列
    return w.wsd(security,"fcftocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFTOCF(security:list,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额占比
    return w.wss(security,"fcftocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计时间序列
    return w.wsd(security,"ocftodebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计
    return w.wss(security,"ocftodebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToInterestDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/带息债务时间序列
    return w.wsd(security,"ocftointerestdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToInterestDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/带息债务
    return w.wss(security,"ocftointerestdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToShortDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/流动负债时间序列
    return w.wsd(security,"ocftoshortdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToShortDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/流动负债
    return w.wss(security,"ocftoshortdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToLongDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/非流动负债时间序列
    return w.wsd(security,"ocftolongdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToLongDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/非流动负债
    return w.wss(security,"ocftolongdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToNetDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/净债务时间序列
    return w.wsd(security,"ocftonetdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToNetDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/净债务
    return w.wss(security,"ocftonetdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoyOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(同比增长率)时间序列
    return w.wsd(security,"yoyocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoyOCF(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(同比增长率)
    return w.wss(security,"yoyocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGrowthOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(N年,增长率)时间序列
    return w.wsd(security,"growth_ocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGrowthOCF(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(N年,增长率)
    return w.wss(security,"growth_ocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOrTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)时间序列
    return w.wsd(security,"ocftoor_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOrTtM2(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)
    return w.wss(security,"ocftoor_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)时间序列
    return w.wsd(security,"ocftooperateincome_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtM2(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)
    return w.wss(security,"ocftooperateincome_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOperateCashFlowToOpTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)时间序列
    return w.wsd(security,"operatecashflowtoop_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOperateCashFlowToOpTtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)
    return w.wss(security,"operatecashflowtoop_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入_GSD时间序列
    return w.wsd(security,"wgsd_ocftosales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToSales(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入_GSD
    return w.wss(security,"wgsd_ocftosales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToOperateIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益_GSD时间序列
    return w.wsd(security,"wgsd_ocftooperateincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToOperateIncome(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益_GSD
    return w.wss(security,"wgsd_ocftooperateincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToLiqDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/流动负债_GSD时间序列
    return w.wsd(security,"wgsd_ocftoliqdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToLiqDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/流动负债_GSD
    return w.wss(security,"wgsd_ocftoliqdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计_GSD时间序列
    return w.wsd(security,"wgsd_ocftodebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计_GSD
    return w.wss(security,"wgsd_ocftodebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToInterestDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/带息债务_GSD时间序列
    return w.wsd(security,"wgsd_ocftointerestdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToInterestDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/带息债务_GSD
    return w.wss(security,"wgsd_ocftointerestdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToNetDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/净债务_GSD时间序列
    return w.wsd(security,"wgsd_ocftonetdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOCFToNetDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/净债务_GSD
    return w.wss(security,"wgsd_ocftonetdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDYoyOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(同比增长率)_GSD时间序列
    return w.wsd(security,"wgsd_yoyocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDYoyOCF(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(同比增长率)_GSD
    return w.wss(security,"wgsd_yoyocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDGrowthOCFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(N年,增长率)_GSD时间序列
    return w.wsd(security,"wgsd_growth_ocf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDGrowthOCF(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额(N年,增长率)_GSD
    return w.wss(security,"wgsd_growth_ocf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtM3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)_GSD时间序列
    return w.wsd(security,"ocftooperateincome_ttm3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtM3(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)_GSD
    return w.wss(security,"ocftooperateincome_ttm3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOperateCashFlowToOpTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)_GSD时间序列
    return w.wsd(security,"operatecashflowtoop_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOperateCashFlowToOpTtM2(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)_GSD
    return w.wss(security,"operatecashflowtoop_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToSalesTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)_GSD时间序列
    return w.wsd(security,"ocftosales_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToSalesTtM2(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)_GSD
    return w.wss(security,"ocftosales_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOperCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_oper_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDOperCf(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_oper_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDInvestCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_invest_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDInvestCf(security:list,*args,**kwargs):
    # 获取投资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_invest_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFinCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_fin_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFinCf(security:list,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_fin_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfOperActNettingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额差额(合计平衡项目)时间序列
    return w.wsd(security,"cf_oper_act_netting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfOperActNetting(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额差额(合计平衡项目)
    return w.wss(security,"cf_oper_act_netting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsOperNetCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额时间序列
    return w.wsd(security,"stm07_cs_reits_opernetcash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsOperNetCash(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额
    return w.wss(security,"stm07_cs_reits_opernetcash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfInvActNettingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资活动产生的现金流量净额差额(合计平衡项目)时间序列
    return w.wsd(security,"cf_inv_act_netting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfInvActNetting(security:list,*args,**kwargs):
    # 获取投资活动产生的现金流量净额差额(合计平衡项目)
    return w.wss(security,"cf_inv_act_netting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsInvestNetCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资活动产生的现金流量净额时间序列
    return w.wsd(security,"stm07_cs_reits_investnetcash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsInvestNetCash(security:list,*args,**kwargs):
    # 获取投资活动产生的现金流量净额
    return w.wss(security,"stm07_cs_reits_investnetcash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfFncActNettingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额差额(合计平衡项目)时间序列
    return w.wsd(security,"cf_fnc_act_netting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfFncActNetting(security:list,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额差额(合计平衡项目)
    return w.wss(security,"cf_fnc_act_netting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsFinanceNetCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额时间序列
    return w.wsd(security,"stm07_cs_reits_financenetcash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07CsReItsFinanceNetCash(security:list,*args,**kwargs):
    # 获取筹资活动产生的现金流量净额
    return w.wss(security,"stm07_cs_reits_financenetcash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入_PIT时间序列
    return w.wsd(security,"fa_ocftoor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOr(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入_PIT
    return w.wss(security,"fa_ocftoor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocftoor_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOrTtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM)_PIT
    return w.wss(security,"fa_ocftoor_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFTooAITtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocftooai_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFTooAITtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM)_PIT
    return w.wss(security,"fa_ocftooai_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOpTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocftoop_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToOpTtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业利润(TTM)_PIT
    return w.wss(security,"fa_ocftoop_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计_PIT时间序列
    return w.wsd(security,"fa_ocftodebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOCFToDebt(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/负债合计_PIT
    return w.wss(security,"fa_ocftodebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM,只有最新数据)时间序列
    return w.wsd(security,"ocftoor_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOrTtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/营业收入(TTM,只有最新数据)
    return w.wss(security,"ocftoor_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM,只有最新数据)时间序列
    return w.wsd(security,"ocftooperateincome_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFToOperateIncomeTtM(security:list,*args,**kwargs):
    # 获取经营活动产生的现金流量净额/经营活动净收益(TTM,只有最新数据)
    return w.wss(security,"ocftooperateincome_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActGapSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额(特殊报表科目)时间序列
    return w.wsd(security,"im_net_cash_flows_oper_act_gap",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActGap(security:list,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额(特殊报表科目)
    return w.wss(security,"im_net_cash_flows_oper_act_gap",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActGapDetailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额说明(特殊报表科目)时间序列
    return w.wsd(security,"im_net_cash_flows_oper_act_gap_detail",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActGapDetail(security:list,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额说明(特殊报表科目)
    return w.wss(security,"im_net_cash_flows_oper_act_gap_detail",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActNettingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额(合计平衡项目)时间序列
    return w.wsd(security,"im_net_cash_flows_oper_act_netting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActNetting(security:list,*args,**kwargs):
    # 获取间接法-经营活动现金流量净额差额(合计平衡项目)
    return w.wss(security,"im_net_cash_flows_oper_act_netting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOcFpsTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(TTM)_PIT时间序列
    return w.wsd(security,"fa_ocfps_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOcFpsTtM(security:list,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(TTM)_PIT
    return w.wss(security,"fa_ocfps_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOcFpsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额时间序列
    return w.wsd(security,"ocfps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOcFps(security:list,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额
    return w.wss(security,"ocfps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoyOCFpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(同比增长率)时间序列
    return w.wsd(security,"yoyocfps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoyOCFpS(security:list,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(同比增长率)
    return w.wss(security,"yoyocfps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDYoyOCFpSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(同比增长率)_GSD时间序列
    return w.wsd(security,"wgsd_yoyocfps",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDYoyOCFpS(security:list,*args,**kwargs):
    # 获取每股经营活动产生的现金流量净额(同比增长率)_GSD
    return w.wss(security,"wgsd_yoyocfps",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDInvestOThCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他投资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_invest_oth_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDInvestOThCf(security:list,*args,**kwargs):
    # 获取其他投资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_invest_oth_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFinOThCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他筹资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_fin_oth_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDFinOThCf(security:list,*args,**kwargs):
    # 获取其他筹资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_fin_oth_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOCFToSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额/营业收入时间序列
    return w.wsd(security,"qfa_ocftosales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOCFToSales(security:list,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额/营业收入
    return w.wss(security,"qfa_ocftosales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOCFToOrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额/经营活动净收益时间序列
    return w.wsd(security,"qfa_ocftoor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOCFToOr(security:list,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额/经营活动净收益
    return w.wss(security,"qfa_ocftoor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFTOCFQfaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额占比时间序列
    return w.wsd(security,"ocftocf_qfa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOCFTOCFQfa(security:list,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额占比
    return w.wss(security,"ocftocf_qfa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getICfTOCFQfaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额占比时间序列
    return w.wsd(security,"icftocf_qfa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getICfTOCFQfa(security:list,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额占比
    return w.wss(security,"icftocf_qfa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFTOCFQfaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额占比时间序列
    return w.wsd(security,"fcftocf_qfa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFcFTOCFQfa(security:list,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额占比
    return w.wss(security,"fcftocf_qfa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaOperCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_qfa_oper_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaOperCf(security:list,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_qfa_oper_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaInvestCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_qfa_invest_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaInvestCf(security:list,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_qfa_invest_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaFinCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_qfa_fin_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaFinCf(security:list,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_qfa_fin_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取间接法-经营活动产生的现金流量净额时间序列
    return w.wsd(security,"im_net_cash_flows_oper_act",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImNetCashFlowsOperAct(security:list,*args,**kwargs):
    # 获取间接法-经营活动产生的现金流量净额
    return w.wss(security,"im_net_cash_flows_oper_act",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsOperActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额时间序列
    return w.wsd(security,"qfa_net_cash_flows_oper_act",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsOperAct(security:list,*args,**kwargs):
    # 获取单季度.经营活动产生的现金流量净额
    return w.wss(security,"qfa_net_cash_flows_oper_act",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsInvActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额时间序列
    return w.wsd(security,"qfa_net_cash_flows_inv_act",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsInvAct(security:list,*args,**kwargs):
    # 获取单季度.投资活动产生的现金流量净额
    return w.wss(security,"qfa_net_cash_flows_inv_act",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsFncActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额时间序列
    return w.wsd(security,"qfa_net_cash_flows_fnc_act",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetCashFlowsFncAct(security:list,*args,**kwargs):
    # 获取单季度.筹资活动产生的现金流量净额
    return w.wss(security,"qfa_net_cash_flows_fnc_act",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCFogRTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增长率-经营活动产生的现金流量净额(TTM)_PIT时间序列
    return w.wsd(security,"fa_cfogr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCFogRTtM(security:list,*args,**kwargs):
    # 获取增长率-经营活动产生的现金流量净额(TTM)_PIT
    return w.wss(security,"fa_cfogr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCffGrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增长率-筹资活动产生的现金流量净额(TTM)_PIT时间序列
    return w.wsd(security,"fa_cffgr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCffGrTtM(security:list,*args,**kwargs):
    # 获取增长率-筹资活动产生的现金流量净额(TTM)_PIT
    return w.wss(security,"fa_cffgr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCFigRTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增长率-投资活动产生的现金流量净额(TTM)_PIT时间序列
    return w.wsd(security,"fa_cfigr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaCFigRTtM(security:list,*args,**kwargs):
    # 获取增长率-投资活动产生的现金流量净额(TTM)_PIT
    return w.wss(security,"fa_cfigr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaInvestOThCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.其他投资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_qfa_invest_oth_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaInvestOThCf(security:list,*args,**kwargs):
    # 获取单季度.其他投资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_qfa_invest_oth_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaFinOThCfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.其他筹资活动产生的现金流量净额_GSD时间序列
    return w.wsd(security,"wgsd_qfa_fin_oth_cf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaFinOThCf(security:list,*args,**kwargs):
    # 获取单季度.其他筹资活动产生的现金流量净额_GSD
    return w.wss(security,"wgsd_qfa_fin_oth_cf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaImNetCashFlowsOperActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.间接法-经营活动产生的现金流量净额时间序列
    return w.wsd(security,"qfa_im_net_cash_flows_oper_act",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaImNetCashFlowsOperAct(security:list,*args,**kwargs):
    # 获取单季度.间接法-经营活动产生的现金流量净额
    return w.wss(security,"qfa_im_net_cash_flows_oper_act",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDupontAssetsToEquitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权益乘数(杜邦分析)时间序列
    return w.wsd(security,"dupont_assetstoequity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDupontAssetsToEquity(security:list,*args,**kwargs):
    # 获取权益乘数(杜邦分析)
    return w.wss(security,"dupont_assetstoequity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDDupontAssetsToEquitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权益乘数(杜邦分析)_GSD时间序列
    return w.wsd(security,"wgsd_dupont_assetstoequity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDDupontAssetsToEquity(security:list,*args,**kwargs):
    # 获取权益乘数(杜邦分析)_GSD
    return w.wss(security,"wgsd_dupont_assetstoequity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目名称时间序列
    return w.wsd(security,"segment_industry_item",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryItem(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目名称
    return w.wss(security,"segment_industry_item",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustrySales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目收入时间序列
    return w.wsd(security,"segment_industry_sales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustrySales1(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目收入
    return w.wss(security,"segment_industry_sales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryCost1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目成本时间序列
    return w.wsd(security,"segment_industry_cost1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryCost1(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目成本
    return w.wss(security,"segment_industry_cost1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利时间序列
    return w.wsd(security,"segment_industry_profit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryProfit1(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利
    return w.wss(security,"segment_industry_profit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryGpMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利率时间序列
    return w.wsd(security,"segment_industry_gpmargin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryGpMargin(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利率
    return w.wss(security,"segment_industry_gpmargin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目名称时间序列
    return w.wsd(security,"segment_product_item",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductItem(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目名称
    return w.wss(security,"segment_product_item",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目收入时间序列
    return w.wsd(security,"segment_product_sales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductSales1(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目收入
    return w.wss(security,"segment_product_sales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductCost1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目成本时间序列
    return w.wsd(security,"segment_product_cost1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductCost1(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目成本
    return w.wss(security,"segment_product_cost1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利时间序列
    return w.wsd(security,"segment_product_profit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductProfit1(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利
    return w.wss(security,"segment_product_profit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductGpMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利率时间序列
    return w.wsd(security,"segment_product_gpmargin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductGpMargin(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利率
    return w.wss(security,"segment_product_gpmargin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目名称时间序列
    return w.wsd(security,"segment_region_item",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionItem(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目名称
    return w.wss(security,"segment_region_item",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionSales1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目收入时间序列
    return w.wsd(security,"segment_region_sales1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionSales1(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目收入
    return w.wss(security,"segment_region_sales1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionCost1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目成本时间序列
    return w.wsd(security,"segment_region_cost1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionCost1(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目成本
    return w.wss(security,"segment_region_cost1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionProfit1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利时间序列
    return w.wsd(security,"segment_region_profit1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionProfit1(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利
    return w.wss(security,"segment_region_profit1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionGpMarginSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利率时间序列
    return w.wsd(security,"segment_region_gpmargin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionGpMargin(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利率
    return w.wss(security,"segment_region_gpmargin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustrySalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目收入(旧)时间序列
    return w.wsd(security,"segment_industry_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustrySales(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目收入(旧)
    return w.wss(security,"segment_industry_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryCostSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目成本(旧)时间序列
    return w.wsd(security,"segment_industry_cost",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryCost(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目成本(旧)
    return w.wss(security,"segment_industry_cost",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利(旧)时间序列
    return w.wsd(security,"segment_industry_profit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentIndustryProfit(security:list,*args,**kwargs):
    # 获取主营构成(按行业)-项目毛利(旧)
    return w.wss(security,"segment_industry_profit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目收入(旧)时间序列
    return w.wsd(security,"segment_product_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductSales(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目收入(旧)
    return w.wss(security,"segment_product_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductCostSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目成本(旧)时间序列
    return w.wsd(security,"segment_product_cost",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductCost(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目成本(旧)
    return w.wss(security,"segment_product_cost",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利(旧)时间序列
    return w.wsd(security,"segment_product_profit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentProductProfit(security:list,*args,**kwargs):
    # 获取主营构成(按产品)-项目毛利(旧)
    return w.wss(security,"segment_product_profit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目收入(旧)时间序列
    return w.wsd(security,"segment_region_sales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionSales(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目收入(旧)
    return w.wss(security,"segment_region_sales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionCostSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目成本(旧)时间序列
    return w.wsd(security,"segment_region_cost",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionCost(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目成本(旧)
    return w.wss(security,"segment_region_cost",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利(旧)时间序列
    return w.wsd(security,"segment_region_profit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSegmentRegionProfit(security:list,*args,**kwargs):
    # 获取主营构成(按地区)-项目毛利(旧)
    return w.wss(security,"segment_region_profit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteAuditCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取审计意见类别时间序列
    return w.wsd(security,"stmnote_audit_category",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteAuditCategory(security:list,*args,**kwargs):
    # 获取审计意见类别
    return w.wss(security,"stmnote_audit_category",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInAuditCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取内控_审计意见类别时间序列
    return w.wsd(security,"stmnote_InAudit_category",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInAuditCategory(security:list,*args,**kwargs):
    # 获取内控_审计意见类别
    return w.wss(security,"stmnote_InAudit_category",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProvDePrAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值准备时间序列
    return w.wsd(security,"prov_depr_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProvDePrAssets(security:list,*args,**kwargs):
    # 获取资产减值准备
    return w.wss(security,"prov_depr_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems13Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值准备(非经常性损益)时间序列
    return w.wsd(security,"stmnote_Eoitems_13",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems13(security:list,*args,**kwargs):
    # 获取资产减值准备(非经常性损益)
    return w.wss(security,"stmnote_Eoitems_13",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve21Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备合计时间序列
    return w.wsd(security,"stmnote_reserve_21",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve21(security:list,*args,**kwargs):
    # 获取固定资产减值准备合计
    return w.wss(security,"stmnote_reserve_21",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve22Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-房屋、建筑物时间序列
    return w.wsd(security,"stmnote_reserve_22",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve22(security:list,*args,**kwargs):
    # 获取固定资产减值准备-房屋、建筑物
    return w.wss(security,"stmnote_reserve_22",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve23Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-机器设备时间序列
    return w.wsd(security,"stmnote_reserve_23",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve23(security:list,*args,**kwargs):
    # 获取固定资产减值准备-机器设备
    return w.wss(security,"stmnote_reserve_23",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve24Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-专用设备时间序列
    return w.wsd(security,"stmnote_reserve_24",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve24(security:list,*args,**kwargs):
    # 获取固定资产减值准备-专用设备
    return w.wss(security,"stmnote_reserve_24",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve25Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-运输工具时间序列
    return w.wsd(security,"stmnote_reserve_25",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve25(security:list,*args,**kwargs):
    # 获取固定资产减值准备-运输工具
    return w.wss(security,"stmnote_reserve_25",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve26Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-通讯设备时间序列
    return w.wsd(security,"stmnote_reserve_26",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve26(security:list,*args,**kwargs):
    # 获取固定资产减值准备-通讯设备
    return w.wss(security,"stmnote_reserve_26",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve27Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-电子设备时间序列
    return w.wsd(security,"stmnote_reserve_27",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve27(security:list,*args,**kwargs):
    # 获取固定资产减值准备-电子设备
    return w.wss(security,"stmnote_reserve_27",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve28Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-办公及其它设备时间序列
    return w.wsd(security,"stmnote_reserve_28",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve28(security:list,*args,**kwargs):
    # 获取固定资产减值准备-办公及其它设备
    return w.wss(security,"stmnote_reserve_28",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve29Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值准备-其它设备时间序列
    return w.wsd(security,"stmnote_reserve_29",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve29(security:list,*args,**kwargs):
    # 获取固定资产减值准备-其它设备
    return w.wss(security,"stmnote_reserve_29",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve30Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取无形资产减值准备时间序列
    return w.wsd(security,"stmnote_reserve_30",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve30(security:list,*args,**kwargs):
    # 获取无形资产减值准备
    return w.wss(security,"stmnote_reserve_30",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve31Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取无形资产减值准备-专利权时间序列
    return w.wsd(security,"stmnote_reserve_31",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve31(security:list,*args,**kwargs):
    # 获取无形资产减值准备-专利权
    return w.wss(security,"stmnote_reserve_31",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve32Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取无形资产减值准备-商标权时间序列
    return w.wsd(security,"stmnote_reserve_32",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve32(security:list,*args,**kwargs):
    # 获取无形资产减值准备-商标权
    return w.wss(security,"stmnote_reserve_32",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve33Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取无形资产减值准备-职工住房使用权时间序列
    return w.wsd(security,"stmnote_reserve_33",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve33(security:list,*args,**kwargs):
    # 获取无形资产减值准备-职工住房使用权
    return w.wss(security,"stmnote_reserve_33",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve34Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取无形资产减值准备-土地使用权时间序列
    return w.wsd(security,"stmnote_reserve_34",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteReserve34(security:list,*args,**kwargs):
    # 获取无形资产减值准备-土地使用权
    return w.wss(security,"stmnote_reserve_34",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInvestmentIncome0007Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取计提投资资产减值准备时间序列
    return w.wsd(security,"stmnote_InvestmentIncome_0007",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInvestmentIncome0007(security:list,*args,**kwargs):
    # 获取计提投资资产减值准备
    return w.wss(security,"stmnote_InvestmentIncome_0007",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaProvDePrAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.资产减值准备时间序列
    return w.wsd(security,"qfa_prov_depr_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaProvDePrAssets(security:list,*args,**kwargs):
    # 获取单季度.资产减值准备
    return w.wss(security,"qfa_prov_depr_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDLandUseRightsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取土地使用权_GSD时间序列
    return w.wsd(security,"wgsd_land_use_rights",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDLandUseRights(security:list,*args,**kwargs):
    # 获取土地使用权_GSD
    return w.wss(security,"wgsd_land_use_rights",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights19Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取土地使用权_原值时间序列
    return w.wsd(security,"stmnote_LandUseRights_19",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights19(security:list,*args,**kwargs):
    # 获取土地使用权_原值
    return w.wss(security,"stmnote_LandUseRights_19",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights20Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取土地使用权_累计摊销时间序列
    return w.wsd(security,"stmnote_LandUseRights_20",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights20(security:list,*args,**kwargs):
    # 获取土地使用权_累计摊销
    return w.wss(security,"stmnote_LandUseRights_20",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights21Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取土地使用权_减值准备时间序列
    return w.wsd(security,"stmnote_LandUseRights_21",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights21(security:list,*args,**kwargs):
    # 获取土地使用权_减值准备
    return w.wss(security,"stmnote_LandUseRights_21",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights22Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取土地使用权_账面价值时间序列
    return w.wsd(security,"stmnote_LandUseRights_22",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLandUseRights22(security:list,*args,**kwargs):
    # 获取土地使用权_账面价值
    return w.wss(security,"stmnote_LandUseRights_22",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtReverseRepoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产时间序列
    return w.wsd(security,"prt_reverserepo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtReverseRepo(security:list,*args,**kwargs):
    # 获取买入返售金融资产
    return w.wss(security,"prt_reverserepo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0001Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:证券时间序列
    return w.wsd(security,"stmnote_SPUAR_0001",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0001(security:list,*args,**kwargs):
    # 获取买入返售金融资产:证券
    return w.wss(security,"stmnote_SPUAR_0001",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0002Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:票据时间序列
    return w.wsd(security,"stmnote_SPUAR_0002",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0002(security:list,*args,**kwargs):
    # 获取买入返售金融资产:票据
    return w.wss(security,"stmnote_SPUAR_0002",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0003Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:贷款时间序列
    return w.wsd(security,"stmnote_SPUAR_0003",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0003(security:list,*args,**kwargs):
    # 获取买入返售金融资产:贷款
    return w.wss(security,"stmnote_SPUAR_0003",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0004Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:信托及其他受益权时间序列
    return w.wsd(security,"stmnote_SPUAR_0004",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0004(security:list,*args,**kwargs):
    # 获取买入返售金融资产:信托及其他受益权
    return w.wss(security,"stmnote_SPUAR_0004",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0005Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:长期应收款时间序列
    return w.wsd(security,"stmnote_SPUAR_0005",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0005(security:list,*args,**kwargs):
    # 获取买入返售金融资产:长期应收款
    return w.wss(security,"stmnote_SPUAR_0005",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0006Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:其他担保物时间序列
    return w.wsd(security,"stmnote_SPUAR_0006",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0006(security:list,*args,**kwargs):
    # 获取买入返售金融资产:其他担保物
    return w.wss(security,"stmnote_SPUAR_0006",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0007Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:减值准备时间序列
    return w.wsd(security,"stmnote_SPUAR_0007",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr0007(security:list,*args,**kwargs):
    # 获取买入返售金融资产:减值准备
    return w.wss(security,"stmnote_SPUAR_0007",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10001Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:股票质押式回购时间序列
    return w.wsd(security,"stmnote_SPUAR_10001",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10001(security:list,*args,**kwargs):
    # 获取买入返售金融资产:股票质押式回购
    return w.wss(security,"stmnote_SPUAR_10001",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10002Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:约定购回式证券时间序列
    return w.wsd(security,"stmnote_SPUAR_10002",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10002(security:list,*args,**kwargs):
    # 获取买入返售金融资产:约定购回式证券
    return w.wss(security,"stmnote_SPUAR_10002",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10003Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:债券买断式回购时间序列
    return w.wsd(security,"stmnote_SPUAR_10003",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10003(security:list,*args,**kwargs):
    # 获取买入返售金融资产:债券买断式回购
    return w.wss(security,"stmnote_SPUAR_10003",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10004Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:债券质押式回购时间序列
    return w.wsd(security,"stmnote_SPUAR_10004",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10004(security:list,*args,**kwargs):
    # 获取买入返售金融资产:债券质押式回购
    return w.wss(security,"stmnote_SPUAR_10004",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10007Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:债券回购时间序列
    return w.wsd(security,"stmnote_SPUAR_10007",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10007(security:list,*args,**kwargs):
    # 获取买入返售金融资产:债券回购
    return w.wss(security,"stmnote_SPUAR_10007",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10005Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产:其他时间序列
    return w.wsd(security,"stmnote_SPUAR_10005",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10005(security:list,*args,**kwargs):
    # 获取买入返售金融资产:其他
    return w.wss(security,"stmnote_SPUAR_10005",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10006Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产合计时间序列
    return w.wsd(security,"stmnote_SPUAR_10006",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSPuAr10006(security:list,*args,**kwargs):
    # 获取买入返售金融资产合计
    return w.wss(security,"stmnote_SPUAR_10006",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs17Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产_FUND时间序列
    return w.wsd(security,"stm_bs_17",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs17(security:list,*args,**kwargs):
    # 获取买入返售金融资产_FUND
    return w.wss(security,"stm_bs_17",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBsRepoInExChMktSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产(交易所市场)_FUND时间序列
    return w.wsd(security,"stm_bs_repoin_exchmkt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBsRepoInExChMkt(security:list,*args,**kwargs):
    # 获取买入返售金融资产(交易所市场)_FUND
    return w.wss(security,"stm_bs_repoin_exchmkt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBsRepoInInterBmkTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产(银行间市场)_FUND时间序列
    return w.wsd(security,"stm_bs_repoin_interbmkt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBsRepoInInterBmkT(security:list,*args,**kwargs):
    # 获取买入返售金融资产(银行间市场)_FUND
    return w.wss(security,"stm_bs_repoin_interbmkt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售金融资产收入_FUND时间序列
    return w.wsd(security,"stm_is_3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs3(security:list,*args,**kwargs):
    # 获取买入返售金融资产收入_FUND
    return w.wss(security,"stm_is_3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinAssetsAvailForSaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产时间序列
    return w.wsd(security,"fin_assets_avail_for_sale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinAssetsAvailForSale(security:list,*args,**kwargs):
    # 获取可供出售金融资产
    return w.wss(security,"fin_assets_avail_for_sale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0001Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产:产生的利得/(损失)时间序列
    return w.wsd(security,"stmnote_FAAviableForSale_0001",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0001(security:list,*args,**kwargs):
    # 获取可供出售金融资产:产生的利得/(损失)
    return w.wss(security,"stmnote_FAAviableForSale_0001",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0002Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产:产生的所得税影响时间序列
    return w.wsd(security,"stmnote_FAAviableForSale_0002",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0002(security:list,*args,**kwargs):
    # 获取可供出售金融资产:产生的所得税影响
    return w.wss(security,"stmnote_FAAviableForSale_0002",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0003Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产:前期计入其他综合收益当期转入损益的金额时间序列
    return w.wsd(security,"stmnote_FAAviableForSale_0003",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0003(security:list,*args,**kwargs):
    # 获取可供出售金融资产:前期计入其他综合收益当期转入损益的金额
    return w.wss(security,"stmnote_FAAviableForSale_0003",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0004Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产公允价值变动时间序列
    return w.wsd(security,"stmnote_FAAviableForSale_0004",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFaaViableForSale0004(security:list,*args,**kwargs):
    # 获取可供出售金融资产公允价值变动
    return w.wss(security,"stmnote_FAAviableForSale_0004",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss8Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供出售金融资产减值损失时间序列
    return w.wsd(security,"stmnote_ImpairmentLoss_8",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss8(security:list,*args,**kwargs):
    # 获取可供出售金融资产减值损失
    return w.wss(security,"stmnote_ImpairmentLoss_8",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetInCrDispFinAssetsAvailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取处置可供出售金融资产净增加额时间序列
    return w.wsd(security,"net_incr_disp_fin_assets_avail",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetInCrDispFinAssetsAvail(security:list,*args,**kwargs):
    # 获取处置可供出售金融资产净增加额
    return w.wss(security,"net_incr_disp_fin_assets_avail",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券:可供出售金融资产时间序列
    return w.wsd(security,"stmnote_securitieslending_3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending3(security:list,*args,**kwargs):
    # 获取融出证券:可供出售金融资产
    return w.wss(security,"stmnote_securitieslending_3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetInCrDispFinAssetsAvailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.处置可供出售金融资产净增加额时间序列
    return w.wsd(security,"qfa_net_incr_disp_fin_assets_avail",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetInCrDispFinAssetsAvail(security:list,*args,**kwargs):
    # 获取单季度.处置可供出售金融资产净增加额
    return w.wss(security,"qfa_net_incr_disp_fin_assets_avail",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券合计时间序列
    return w.wsd(security,"stmnote_securitieslending_1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending1(security:list,*args,**kwargs):
    # 获取融出证券合计
    return w.wss(security,"stmnote_securitieslending_1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券:交易性金融资产时间序列
    return w.wsd(security,"stmnote_securitieslending_2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending2(security:list,*args,**kwargs):
    # 获取融出证券:交易性金融资产
    return w.wss(security,"stmnote_securitieslending_2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending4Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券:转融通融入证券时间序列
    return w.wsd(security,"stmnote_securitieslending_4",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending4(security:list,*args,**kwargs):
    # 获取融出证券:转融通融入证券
    return w.wss(security,"stmnote_securitieslending_4",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券:转融通融入证券余额时间序列
    return w.wsd(security,"stmnote_securitieslending_5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending5(security:list,*args,**kwargs):
    # 获取融出证券:转融通融入证券余额
    return w.wss(security,"stmnote_securitieslending_5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending6Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取融出证券:减值准备时间序列
    return w.wsd(security,"stmnote_securitieslending_6",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSecuritiesLending6(security:list,*args,**kwargs):
    # 获取融出证券:减值准备
    return w.wss(security,"stmnote_securitieslending_6",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashDepositsCentralBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取现金及存放中央银行款项时间序列
    return w.wsd(security,"cash_deposits_central_bank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashDepositsCentralBank(security:list,*args,**kwargs):
    # 获取现金及存放中央银行款项
    return w.wss(security,"cash_deposits_central_bank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款_FUND时间序列
    return w.wsd(security,"stm_bs_1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs1(security:list,*args,**kwargs):
    # 获取银行存款_FUND
    return w.wss(security,"stm_bs_1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款时间序列
    return w.wsd(security,"prt_cash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCash(security:list,*args,**kwargs):
    # 获取银行存款
    return w.wss(security,"prt_cash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款占基金资产净值比时间序列
    return w.wsd(security,"prt_cashtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToNav(security:list,*args,**kwargs):
    # 获取银行存款占基金资产净值比
    return w.wss(security,"prt_cashtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款占基金资产总值比时间序列
    return w.wsd(security,"prt_cashtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToAsset(security:list,*args,**kwargs):
    # 获取银行存款占基金资产总值比
    return w.wss(security,"prt_cashtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款市值增长率时间序列
    return w.wsd(security,"prt_cashvaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashValueGrowth(security:list,*args,**kwargs):
    # 获取银行存款市值增长率
    return w.wss(security,"prt_cashvaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行存款市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_cashtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCashToNavGrowth(security:list,*args,**kwargs):
    # 获取银行存款市值占基金资产净值比例增长
    return w.wss(security,"prt_cashtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteBankDepositSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金-银行存款时间序列
    return w.wsd(security,"stmnote_bankdeposit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteBankDeposit(security:list,*args,**kwargs):
    # 获取货币资金-银行存款
    return w.wss(security,"stmnote_bankdeposit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashToStDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金/短期债务时间序列
    return w.wsd(security,"cashtostdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashToStDebt(security:list,*args,**kwargs):
    # 获取货币资金/短期债务
    return w.wss(security,"cashtostdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoYCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金增长率时间序列
    return w.wsd(security,"yoy_cash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYoYCash(security:list,*args,**kwargs):
    # 获取货币资金增长率
    return w.wss(security,"yoy_cash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCashToLiqDebtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金/流动负债_GSD时间序列
    return w.wsd(security,"wgsd_cashtoliqdebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCashToLiqDebt(security:list,*args,**kwargs):
    # 获取货币资金/流动负债_GSD
    return w.wss(security,"wgsd_cashtoliqdebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07BsReItsCashSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金时间序列
    return w.wsd(security,"stm07_bs_reits_cash",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07BsReItsCash(security:list,*args,**kwargs):
    # 获取货币资金
    return w.wss(security,"stm07_bs_reits_cash",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteDpsT4412Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金合计时间序列
    return w.wsd(security,"stmnote_DPST_4412",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteDpsT4412(security:list,*args,**kwargs):
    # 获取货币资金合计
    return w.wss(security,"stmnote_DPST_4412",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteCashInvaultSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币资金-库存现金时间序列
    return w.wsd(security,"stmnote_cashinvault",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteCashInvault(security:list,*args,**kwargs):
    # 获取货币资金-库存现金
    return w.wss(security,"stmnote_cashinvault",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteBorrow4512Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取借款合计时间序列
    return w.wsd(security,"stmnote_Borrow_4512",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteBorrow4512(security:list,*args,**kwargs):
    # 获取借款合计
    return w.wss(security,"stmnote_Borrow_4512",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStBorrowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取短期借款时间序列
    return w.wsd(security,"st_borrow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStBorrow(security:list,*args,**kwargs):
    # 获取短期借款
    return w.wss(security,"st_borrow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtBorrowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取长期借款时间序列
    return w.wsd(security,"lt_borrow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtBorrow(security:list,*args,**kwargs):
    # 获取长期借款
    return w.wss(security,"lt_borrow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPledgeLoanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押借款时间序列
    return w.wsd(security,"pledge_loan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPledgeLoan(security:list,*args,**kwargs):
    # 获取质押借款
    return w.wss(security,"pledge_loan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashRecpBorrowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取取得借款收到的现金时间序列
    return w.wsd(security,"cash_recp_borrow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCashRecpBorrow(security:list,*args,**kwargs):
    # 获取取得借款收到的现金
    return w.wss(security,"cash_recp_borrow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4512Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取短期借款小计时间序列
    return w.wsd(security,"stmnote_STBorrow_4512",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4512(security:list,*args,**kwargs):
    # 获取短期借款小计
    return w.wss(security,"stmnote_STBorrow_4512",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4512Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取长期借款小计时间序列
    return w.wsd(security,"stmnote_LTBorrow_4512",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4512(security:list,*args,**kwargs):
    # 获取长期借款小计
    return w.wss(security,"stmnote_LTBorrow_4512",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs70Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取短期借款_FUND时间序列
    return w.wsd(security,"stm_bs_70",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs70(security:list,*args,**kwargs):
    # 获取短期借款_FUND
    return w.wss(security,"stm_bs_70",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaLtBorrowToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取长期借款/资产总计_PIT时间序列
    return w.wsd(security,"fa_ltborrowtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaLtBorrowToAsset(security:list,*args,**kwargs):
    # 获取长期借款/资产总计_PIT
    return w.wss(security,"fa_ltborrowtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusLoanRatioNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国际商业借款比率时间序列
    return w.wsd(security,"busloanratio_n",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusLoanRatioN(security:list,*args,**kwargs):
    # 获取国际商业借款比率
    return w.wss(security,"busloanratio_n",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusLoanRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国际商业借款比率(旧)时间序列
    return w.wsd(security,"busloanratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusLoanRatio(security:list,*args,**kwargs):
    # 获取国际商业借款比率(旧)
    return w.wss(security,"busloanratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4506Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取美元短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4506",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4506(security:list,*args,**kwargs):
    # 获取美元短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4506",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4507Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取日元短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4507",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4507(security:list,*args,**kwargs):
    # 获取日元短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4507",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4508Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取欧元短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4508",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4508(security:list,*args,**kwargs):
    # 获取欧元短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4508",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4509Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取港币短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4509",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4509(security:list,*args,**kwargs):
    # 获取港币短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4509",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4510Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取英镑短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4510",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4510(security:list,*args,**kwargs):
    # 获取英镑短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4510",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4506Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取美元长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4506",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4506(security:list,*args,**kwargs):
    # 获取美元长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4506",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4507Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取日元长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4507",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4507(security:list,*args,**kwargs):
    # 获取日元长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4507",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4508Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取欧元长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4508",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4508(security:list,*args,**kwargs):
    # 获取欧元长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4508",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4509Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取港币长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4509",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4509(security:list,*args,**kwargs):
    # 获取港币长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4509",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4510Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取英镑长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4510",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4510(security:list,*args,**kwargs):
    # 获取英镑长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4510",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBorrowCentralBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取向中央银行借款时间序列
    return w.wsd(security,"borrow_central_bank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBorrowCentralBank(security:list,*args,**kwargs):
    # 获取向中央银行借款
    return w.wss(security,"borrow_central_bank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetInCrLoansCentralBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取向中央银行借款净增加额时间序列
    return w.wsd(security,"net_incr_loans_central_bank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetInCrLoansCentralBank(security:list,*args,**kwargs):
    # 获取向中央银行借款净增加额
    return w.wss(security,"net_incr_loans_central_bank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4505Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取人民币短期借款时间序列
    return w.wsd(security,"stmnote_STBorrow_4505",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4505(security:list,*args,**kwargs):
    # 获取人民币短期借款
    return w.wss(security,"stmnote_STBorrow_4505",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4505Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取人民币长期借款时间序列
    return w.wsd(security,"stmnote_LTBorrow_4505",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4505(security:list,*args,**kwargs):
    # 获取人民币长期借款
    return w.wss(security,"stmnote_LTBorrow_4505",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaCashRecpBorrowSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.取得借款收到的现金时间序列
    return w.wsd(security,"qfa_cash_recp_borrow",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaCashRecpBorrow(security:list,*args,**kwargs):
    # 获取单季度.取得借款收到的现金
    return w.wss(security,"qfa_cash_recp_borrow",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4511Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他货币短期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_STBorrow_4511",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteStBorrow4511(security:list,*args,**kwargs):
    # 获取其他货币短期借款(折算人民币)
    return w.wss(security,"stmnote_STBorrow_4511",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4511Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他货币长期借款(折算人民币)时间序列
    return w.wsd(security,"stmnote_LTBorrow_4511",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteLtBorrow4511(security:list,*args,**kwargs):
    # 获取其他货币长期借款(折算人民币)
    return w.wss(security,"stmnote_LTBorrow_4511",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteOthers7636Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取一年内到期的长期借款时间序列
    return w.wsd(security,"stmnote_others_7636",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteOthers7636(security:list,*args,**kwargs):
    # 获取一年内到期的长期借款
    return w.wss(security,"stmnote_others_7636",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetInCrLoansCentralBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.向中央银行借款净增加额时间序列
    return w.wsd(security,"qfa_net_incr_loans_central_bank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaNetInCrLoansCentralBank(security:list,*args,**kwargs):
    # 获取单季度.向中央银行借款净增加额
    return w.wss(security,"qfa_net_incr_loans_central_bank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExtraordinarySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非经常性损益时间序列
    return w.wsd(security,"extraordinary",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExtraordinary(security:list,*args,**kwargs):
    # 获取非经常性损益
    return w.wss(security,"extraordinary",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems21Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取非经常性损益项目小计时间序列
    return w.wsd(security,"stmnote_Eoitems_21",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems21(security:list,*args,**kwargs):
    # 获取非经常性损益项目小计
    return w.wss(security,"stmnote_Eoitems_21",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems24Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取非经常性损益项目合计时间序列
    return w.wsd(security,"stmnote_Eoitems_24",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems24(security:list,*args,**kwargs):
    # 获取非经常性损益项目合计
    return w.wss(security,"stmnote_Eoitems_24",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaNRglSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非经常性损益_PIT时间序列
    return w.wsd(security,"fa_nrgl",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaNRgl(security:list,*args,**kwargs):
    # 获取非经常性损益_PIT
    return w.wss(security,"fa_nrgl",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaDeductProfitTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)_PIT时间序列
    return w.wsd(security,"fa_deductprofit_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaDeductProfitTtM(security:list,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)_PIT
    return w.wss(security,"fa_deductprofit_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDpYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(同比增长率)时间序列
    return w.wsd(security,"dp_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDpYoY(security:list,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(同比增长率)
    return w.wss(security,"dp_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)时间序列
    return w.wsd(security,"deductedprofit_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitTtM2(security:list,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)
    return w.wss(security,"deductedprofit_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润时间序列
    return w.wsd(security,"deductedprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfit(security:list,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润
    return w.wss(security,"deductedprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitTtM3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)_GSD时间序列
    return w.wsd(security,"deductedprofit_ttm3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitTtM3(security:list,*args,**kwargs):
    # 获取扣除非经常性损益后的净利润(TTM)_GSD
    return w.wss(security,"deductedprofit_ttm3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.扣除非经常性损益后的净利润同比增长率时间序列
    return w.wsd(security,"deductedprofit_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeductedProfitYoY(security:list,*args,**kwargs):
    # 获取单季度.扣除非经常性损益后的净利润同比增长率
    return w.wss(security,"deductedprofit_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPeDeductedTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市盈率PE(TTM,扣除非经常性损益)时间序列
    return w.wsd(security,"val_pe_deducted_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPeDeductedTtM(security:list,*args,**kwargs):
    # 获取市盈率PE(TTM,扣除非经常性损益)
    return w.wss(security,"val_pe_deducted_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失/营业总收入时间序列
    return w.wsd(security,"impairtogr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGr(security:list,*args,**kwargs):
    # 获取资产减值损失/营业总收入
    return w.wss(security,"impairtogr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToOpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失/营业利润时间序列
    return w.wsd(security,"impairtoOP",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToOp(security:list,*args,**kwargs):
    # 获取资产减值损失/营业利润
    return w.wss(security,"impairtoOP",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGrTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM)时间序列
    return w.wsd(security,"impairtogr_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGrTtM2(security:list,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM)
    return w.wss(security,"impairtogr_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairmentTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失(TTM)时间序列
    return w.wsd(security,"impairment_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairmentTtM2(security:list,*args,**kwargs):
    # 获取资产减值损失(TTM)
    return w.wss(security,"impairment_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairLossAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失时间序列
    return w.wsd(security,"impair_loss_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairLossAssets(security:list,*args,**kwargs):
    # 获取资产减值损失
    return w.wss(security,"impair_loss_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaImpairToGrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM)_PIT时间序列
    return w.wsd(security,"fa_impairtogr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaImpairToGrTtM(security:list,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM)_PIT
    return w.wss(security,"fa_impairtogr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaImpairLossTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失(TTM)_PIT时间序列
    return w.wsd(security,"fa_impairloss_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaImpairLossTtM(security:list,*args,**kwargs):
    # 获取资产减值损失(TTM)_PIT
    return w.wss(security,"fa_impairloss_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGrTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM,只有最新数据)时间序列
    return w.wsd(security,"impairtogr_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToGrTtM(security:list,*args,**kwargs):
    # 获取资产减值损失/营业总收入(TTM,只有最新数据)
    return w.wss(security,"impairtogr_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairmentTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产减值损失(TTM,只有最新数据)时间序列
    return w.wsd(security,"impairment_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairmentTtM(security:list,*args,**kwargs):
    # 获取资产减值损失(TTM,只有最新数据)
    return w.wss(security,"impairment_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherAssetsImpairLossSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产减值损失时间序列
    return w.wsd(security,"other_assets_impair_loss",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherAssetsImpairLoss(security:list,*args,**kwargs):
    # 获取其他资产减值损失
    return w.wss(security,"other_assets_impair_loss",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资产减值损失时间序列
    return w.wsd(security,"stmnote_ImpairmentLoss_10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss10(security:list,*args,**kwargs):
    # 获取固定资产减值损失
    return w.wss(security,"stmnote_ImpairmentLoss_10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToOpQfaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.资产减值损失/营业利润时间序列
    return w.wsd(security,"impairtoop_qfa",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getImpairToOpQfa(security:list,*args,**kwargs):
    # 获取单季度.资产减值损失/营业利润
    return w.wss(security,"impairtoop_qfa",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaImpairLossAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.资产减值损失时间序列
    return w.wsd(security,"qfa_impair_loss_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaImpairLossAssets(security:list,*args,**kwargs):
    # 获取单季度.资产减值损失
    return w.wss(security,"qfa_impair_loss_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOtherImpairSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.其他资产减值损失时间序列
    return w.wsd(security,"qfa_other_impair",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOtherImpair(security:list,*args,**kwargs):
    # 获取单季度.其他资产减值损失
    return w.wss(security,"qfa_other_impair",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp4Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-利息支出时间序列
    return w.wsd(security,"stmnote_finexp_4",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp4(security:list,*args,**kwargs):
    # 获取财务费用明细-利息支出
    return w.wss(security,"stmnote_finexp_4",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-利息收入时间序列
    return w.wsd(security,"stmnote_finexp_5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp5(security:list,*args,**kwargs):
    # 获取财务费用明细-利息收入
    return w.wss(security,"stmnote_finexp_5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp13Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-利息资本化金额时间序列
    return w.wsd(security,"stmnote_finexp_13",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp13(security:list,*args,**kwargs):
    # 获取财务费用明细-利息资本化金额
    return w.wss(security,"stmnote_finexp_13",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp6Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-汇兑损益时间序列
    return w.wsd(security,"stmnote_finexp_6",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp6(security:list,*args,**kwargs):
    # 获取财务费用明细-汇兑损益
    return w.wss(security,"stmnote_finexp_6",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp7Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-手续费时间序列
    return w.wsd(security,"stmnote_finexp_7",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp7(security:list,*args,**kwargs):
    # 获取财务费用明细-手续费
    return w.wss(security,"stmnote_finexp_7",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp8Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务费用明细-其他时间序列
    return w.wsd(security,"stmnote_finexp_8",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteFineXp8(security:list,*args,**kwargs):
    # 获取财务费用明细-其他
    return w.wss(security,"stmnote_finexp_8",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaRdExpYoYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用同比增长时间序列
    return w.wsd(security,"fa_rdexp_yoy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaRdExpYoY(security:list,*args,**kwargs):
    # 获取研发费用同比增长
    return w.wss(security,"fa_rdexp_yoy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDRdExpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用_GSD时间序列
    return w.wsd(security,"wgsd_rd_exp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDRdExp(security:list,*args,**kwargs):
    # 获取研发费用_GSD
    return w.wss(security,"wgsd_rd_exp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07IsReItsRdFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用时间序列
    return w.wsd(security,"stm07_is_reits_rdfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07IsReItsRdFee(security:list,*args,**kwargs):
    # 获取研发费用
    return w.wss(security,"stm07_is_reits_rdfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdSalarySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用-工资薪酬时间序列
    return w.wsd(security,"stmnote_rdsalary",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdSalary(security:list,*args,**kwargs):
    # 获取研发费用-工资薪酬
    return w.wss(security,"stmnote_rdsalary",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdDaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用-折旧摊销时间序列
    return w.wsd(security,"stmnote_rdda",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdDa(security:list,*args,**kwargs):
    # 获取研发费用-折旧摊销
    return w.wss(security,"stmnote_rdda",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdLeaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用-租赁费时间序列
    return w.wsd(security,"stmnote_rdlease",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdLease(security:list,*args,**kwargs):
    # 获取研发费用-租赁费
    return w.wss(security,"stmnote_rdlease",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdInvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用-直接投入时间序列
    return w.wsd(security,"stmnote_rdinv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdInv(security:list,*args,**kwargs):
    # 获取研发费用-直接投入
    return w.wss(security,"stmnote_rdinv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdOthersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用-其他时间序列
    return w.wsd(security,"stmnote_rdothers",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdOthers(security:list,*args,**kwargs):
    # 获取研发费用-其他
    return w.wss(security,"stmnote_rdothers",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdExpCostToSalesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取研发费用占营业收入比例时间序列
    return w.wsd(security,"stmnote_Rdexp_costtosales",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteRdExpCostToSales(security:list,*args,**kwargs):
    # 获取研发费用占营业收入比例
    return w.wss(security,"stmnote_Rdexp_costtosales",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaRdExpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.研发费用_GSD时间序列
    return w.wsd(security,"wgsd_qfa_rd_exp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaRdExp(security:list,*args,**kwargs):
    # 获取单季度.研发费用_GSD
    return w.wss(security,"wgsd_qfa_rd_exp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaRdExpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.研发费用时间序列
    return w.wsd(security,"qfa_rd_exp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaRdExp(security:list,*args,**kwargs):
    # 获取单季度.研发费用
    return w.wss(security,"qfa_rd_exp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxToEBTSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税/利润总额时间序列
    return w.wsd(security,"taxtoebt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxToEBT(security:list,*args,**kwargs):
    # 获取所得税/利润总额
    return w.wss(security,"taxtoebt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税(TTM)时间序列
    return w.wsd(security,"tax_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxTtM(security:list,*args,**kwargs):
    # 获取所得税(TTM)
    return w.wss(security,"tax_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxTtM2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税(TTM)_GSD时间序列
    return w.wsd(security,"tax_ttm2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxTtM2(security:list,*args,**kwargs):
    # 获取所得税(TTM)_GSD
    return w.wss(security,"tax_ttm2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDIncTaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税_GSD时间序列
    return w.wsd(security,"wgsd_inc_tax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDIncTax(security:list,*args,**kwargs):
    # 获取所得税_GSD
    return w.wss(security,"wgsd_inc_tax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税时间序列
    return w.wsd(security,"tax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTax(security:list,*args,**kwargs):
    # 获取所得税
    return w.wss(security,"tax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems22Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税影响数时间序列
    return w.wsd(security,"stmnote_Eoitems_22",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEoItems22(security:list,*args,**kwargs):
    # 获取所得税影响数
    return w.wss(security,"stmnote_Eoitems_22",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax6Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税费用合计时间序列
    return w.wsd(security,"stmnote_incometax_6",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax6(security:list,*args,**kwargs):
    # 获取所得税费用合计
    return w.wss(security,"stmnote_incometax_6",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs78Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税费用_FUND时间序列
    return w.wsd(security,"stm_is_78",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs78(security:list,*args,**kwargs):
    # 获取所得税费用_FUND
    return w.wss(security,"stm_is_78",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaTaxTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所得税(TTM)_PIT时间序列
    return w.wsd(security,"fa_tax_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaTaxTtM(security:list,*args,**kwargs):
    # 获取所得税(TTM)_PIT
    return w.wss(security,"fa_tax_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeferredTaxAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取递延所得税资产时间序列
    return w.wsd(security,"deferred_tax_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeferredTaxAssets(security:list,*args,**kwargs):
    # 获取递延所得税资产
    return w.wss(security,"deferred_tax_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeferredTaxLiaBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取递延所得税负债时间序列
    return w.wsd(security,"deferred_tax_liab",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeferredTaxLiaB(security:list,*args,**kwargs):
    # 获取递延所得税负债
    return w.wss(security,"deferred_tax_liab",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDecrDeferredIncTaxAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取递延所得税资产减少时间序列
    return w.wsd(security,"decr_deferred_inc_tax_assets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDecrDeferredIncTaxAssets(security:list,*args,**kwargs):
    # 获取递延所得税资产减少
    return w.wss(security,"decr_deferred_inc_tax_assets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInCrDeferredIncTaxLiaBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取递延所得税负债增加时间序列
    return w.wsd(security,"incr_deferred_inc_tax_liab",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInCrDeferredIncTaxLiaB(security:list,*args,**kwargs):
    # 获取递延所得税负债增加
    return w.wss(security,"incr_deferred_inc_tax_liab",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年末所得税率时间序列
    return w.wsd(security,"stmnote_tax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTax(security:list,*args,**kwargs):
    # 获取年末所得税率
    return w.wss(security,"stmnote_tax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取当期所得税:中国大陆时间序列
    return w.wsd(security,"stmnote_incometax_1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax1(security:list,*args,**kwargs):
    # 获取当期所得税:中国大陆
    return w.wss(security,"stmnote_incometax_1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取当期所得税:中国香港时间序列
    return w.wsd(security,"stmnote_incometax_2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax2(security:list,*args,**kwargs):
    # 获取当期所得税:中国香港
    return w.wss(security,"stmnote_incometax_2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取当期所得税:其他境外时间序列
    return w.wsd(security,"stmnote_incometax_3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax3(security:list,*args,**kwargs):
    # 获取当期所得税:其他境外
    return w.wss(security,"stmnote_incometax_3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取递延所得税时间序列
    return w.wsd(security,"stmnote_incometax_5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax5(security:list,*args,**kwargs):
    # 获取递延所得税
    return w.wss(security,"stmnote_incometax_5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaIncTaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.所得税_GSD时间序列
    return w.wsd(security,"wgsd_qfa_inc_tax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaIncTax(security:list,*args,**kwargs):
    # 获取单季度.所得税_GSD
    return w.wss(security,"wgsd_qfa_inc_tax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaTaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.所得税时间序列
    return w.wsd(security,"qfa_tax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaTax(security:list,*args,**kwargs):
    # 获取单季度.所得税
    return w.wss(security,"qfa_tax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax4Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取以前年度所得税调整时间序列
    return w.wsd(security,"stmnote_incometax_4",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteIncomeTax4(security:list,*args,**kwargs):
    # 获取以前年度所得税调整
    return w.wss(security,"stmnote_incometax_4",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaDeferredTaxAssetsDecrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.递延所得税资产减少时间序列
    return w.wsd(security,"qfa_deferred_tax_assets_decr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaDeferredTaxAssetsDecr(security:list,*args,**kwargs):
    # 获取单季度.递延所得税资产减少
    return w.wss(security,"qfa_deferred_tax_assets_decr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaInCrDeferredIncTaxLiaBSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.递延所得税负债增加时间序列
    return w.wsd(security,"qfa_incr_deferred_inc_tax_liab",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaInCrDeferredIncTaxLiaB(security:list,*args,**kwargs):
    # 获取单季度.递延所得税负债增加
    return w.wss(security,"qfa_incr_deferred_inc_tax_liab",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskBetaUnIncomeTaxRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Beta(剔除所得税率)时间序列
    return w.wsd(security,"risk_betaunincometaxrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskBetaUnIncomeTaxRate(security:list,*args,**kwargs):
    # 获取Beta(剔除所得税率)
    return w.wss(security,"risk_betaunincometaxrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDGwIntangSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取商誉及无形资产_GSD时间序列
    return w.wsd(security,"wgsd_gw_intang",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDGwIntang(security:list,*args,**kwargs):
    # 获取商誉及无形资产_GSD
    return w.wss(security,"wgsd_gw_intang",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGoodwillSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取商誉时间序列
    return w.wsd(security,"goodwill",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGoodwill(security:list,*args,**kwargs):
    # 获取商誉
    return w.wss(security,"goodwill",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss6Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取商誉减值损失时间序列
    return w.wsd(security,"stmnote_ImpairmentLoss_6",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteImpairmentLoss6(security:list,*args,**kwargs):
    # 获取商誉减值损失
    return w.wss(security,"stmnote_ImpairmentLoss_6",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteGoodwillDetailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取商誉-账面价值时间序列
    return w.wsd(security,"stmnote_goodwilldetail",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteGoodwillDetail(security:list,*args,**kwargs):
    # 获取商誉-账面价值
    return w.wss(security,"stmnote_goodwilldetail",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteGoodwillImpairmentSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取商誉-减值准备时间序列
    return w.wsd(security,"stmnote_goodwillimpairment",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteGoodwillImpairment(security:list,*args,**kwargs):
    # 获取商誉-减值准备
    return w.wss(security,"stmnote_goodwillimpairment",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEMplBenPayableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应付职工薪酬时间序列
    return w.wsd(security,"empl_ben_payable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEMplBenPayable(security:list,*args,**kwargs):
    # 获取应付职工薪酬
    return w.wss(security,"empl_ben_payable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableAddSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应付职工薪酬合计:本期增加时间序列
    return w.wsd(security,"stmnote_emplpayable_add",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableAdd(security:list,*args,**kwargs):
    # 获取应付职工薪酬合计:本期增加
    return w.wss(security,"stmnote_emplpayable_add",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableSbSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应付职工薪酬合计:期初余额时间序列
    return w.wsd(security,"stmnote_emplpayable_sb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableSb(security:list,*args,**kwargs):
    # 获取应付职工薪酬合计:期初余额
    return w.wss(security,"stmnote_emplpayable_sb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableEbSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应付职工薪酬合计:期末余额时间序列
    return w.wsd(security,"stmnote_emplpayable_eb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableEb(security:list,*args,**kwargs):
    # 获取应付职工薪酬合计:期末余额
    return w.wss(security,"stmnote_emplpayable_eb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableDeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取应付职工薪酬合计:本期减少时间序列
    return w.wsd(security,"stmnote_emplpayable_de",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteEMplPayableDe(security:list,*args,**kwargs):
    # 获取应付职工薪酬合计:本期减少
    return w.wss(security,"stmnote_emplpayable_de",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtEMplBenPayableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取长期应付职工薪酬时间序列
    return w.wsd(security,"lt_empl_ben_payable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLtEMplBenPayable(security:list,*args,**kwargs):
    # 获取长期应付职工薪酬
    return w.wss(security,"lt_empl_ben_payable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTaxBusinessSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业税金及附加合计时间序列
    return w.wsd(security,"stmnote_tax_business",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTaxBusiness(security:list,*args,**kwargs):
    # 获取营业税金及附加合计
    return w.wss(security,"stmnote_tax_business",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOperTaxTtMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取营业税金及附加(TTM)_PIT时间序列
    return w.wsd(security,"fa_opertax_ttm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaOperTaxTtM(security:list,*args,**kwargs):
    # 获取营业税金及附加(TTM)_PIT
    return w.wss(security,"fa_opertax_ttm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTaxOThSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他营业税金及附加时间序列
    return w.wsd(security,"stmnote_tax_oth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteTaxOTh(security:list,*args,**kwargs):
    # 获取其他营业税金及附加
    return w.wss(security,"stmnote_tax_oth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIssuingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定期报告披露日期时间序列
    return w.wsd(security,"stm_issuingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIssuingDate(security:list,*args,**kwargs):
    # 获取定期报告披露日期
    return w.wss(security,"stm_issuingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIssuingDateFsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定期报告正报披露日期时间序列
    return w.wsd(security,"stm_issuingdate_fs",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIssuingDateFs(security:list,*args,**kwargs):
    # 获取定期报告正报披露日期
    return w.wss(security,"stm_issuingdate_fs",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmPredictIssuingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定期报告预计披露日期时间序列
    return w.wsd(security,"stm_predict_issuingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmPredictIssuingDate(security:list,*args,**kwargs):
    # 获取定期报告预计披露日期
    return w.wss(security,"stm_predict_issuingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmRpTSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告起始日期时间序列
    return w.wsd(security,"stm_rpt_s",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmRpTS(security:list,*args,**kwargs):
    # 获取报告起始日期
    return w.wss(security,"stm_rpt_s",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmRpTESeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告截止日期时间序列
    return w.wsd(security,"stm_rpt_e",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmRpTE(security:list,*args,**kwargs):
    # 获取报告截止日期
    return w.wss(security,"stm_rpt_e",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatelyRdBtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新报告期时间序列
    return w.wsd(security,"latelyrd_bt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatelyRdBt(security:list,*args,**kwargs):
    # 获取最新报告期
    return w.wss(security,"latelyrd_bt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaErrorCorrectionDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取会计差错更正披露日期时间序列
    return w.wsd(security,"fa_errorcorrectiondate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaErrorCorrectionDate(security:list,*args,**kwargs):
    # 获取会计差错更正披露日期
    return w.wss(security,"fa_errorcorrectiondate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaErrorCorrectionOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否存在会计差错更正时间序列
    return w.wsd(security,"fa_errorcorrectionornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaErrorCorrectionOrNot(security:list,*args,**kwargs):
    # 获取是否存在会计差错更正
    return w.wss(security,"fa_errorcorrectionornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteAuditAmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取会计准则类型时间序列
    return w.wsd(security,"stmnote_audit_am",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteAuditAm(security:list,*args,**kwargs):
    # 获取会计准则类型
    return w.wss(security,"stmnote_audit_am",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceTimeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩说明会时间时间序列
    return w.wsd(security,"performancetime",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceTime(security:list,*args,**kwargs):
    # 获取业绩说明会时间
    return w.wss(security,"performancetime",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩说明会日期时间序列
    return w.wsd(security,"performancedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerformanceDate(security:list,*args,**kwargs):
    # 获取业绩说明会日期
    return w.wss(security,"performancedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGEScoreWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取环境维度得分时间序列
    return w.wsd(security,"esg_escore_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGEScoreWind(security:list,*args,**kwargs):
    # 获取环境维度得分
    return w.wss(security,"esg_escore_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGSScoreWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会维度得分时间序列
    return w.wsd(security,"esg_sscore_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGSScoreWind(security:list,*args,**kwargs):
    # 获取社会维度得分
    return w.wss(security,"esg_sscore_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGGScoreWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取治理维度得分时间序列
    return w.wsd(security,"esg_gscore_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGGScoreWind(security:list,*args,**kwargs):
    # 获取治理维度得分
    return w.wss(security,"esg_gscore_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFeeFeeSumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行费用合计时间序列
    return w.wsd(security,"issuefee_feesum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFeeFeeSum(security:list,*args,**kwargs):
    # 获取发行费用合计
    return w.wss(security,"issuefee_feesum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpense2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发发行费用时间序列
    return w.wsd(security,"ipo_expense2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpense2(security:list,*args,**kwargs):
    # 获取首发发行费用
    return w.wss(security,"ipo_expense2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpenseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发发行费用(旧)时间序列
    return w.wsd(security,"ipo_expense",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpense(security:list,*args,**kwargs):
    # 获取首发发行费用(旧)
    return w.wss(security,"ipo_expense",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListAnnoCeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行结果公告日时间序列
    return w.wsd(security,"cb_list_annocedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListAnnoCeDate(security:list,*args,**kwargs):
    # 获取发行结果公告日
    return w.wss(security,"cb_list_annocedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundApprovedDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金获批注册日期时间序列
    return w.wsd(security,"fund_approveddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundApprovedDate(security:list,*args,**kwargs):
    # 获取基金获批注册日期
    return w.wss(security,"fund_approveddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAnnouncedAteSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行公告日时间序列
    return w.wsd(security,"issue_announcedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAnnouncedAte(security:list,*args,**kwargs):
    # 获取发行公告日
    return w.wss(security,"issue_announcedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTenderAnceDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行公告日期时间序列
    return w.wsd(security,"tender_ancedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTenderAnceDate(security:list,*args,**kwargs):
    # 获取发行公告日期
    return w.wss(security,"tender_ancedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowAnnCeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上网发行公告日时间序列
    return w.wsd(security,"fellow_anncedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowAnnCeDate(security:list,*args,**kwargs):
    # 获取上网发行公告日
    return w.wss(security,"fellow_anncedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行日期时间序列
    return w.wsd(security,"issue_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueDate(security:list,*args,**kwargs):
    # 获取发行日期
    return w.wss(security,"issue_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoIssueDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发发行日期时间序列
    return w.wsd(security,"ipo_issuedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoIssueDate(security:list,*args,**kwargs):
    # 获取首发发行日期
    return w.wss(security,"ipo_issuedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowIssueDatePpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定增发行日期时间序列
    return w.wsd(security,"fellow_issuedate_pp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowIssueDatePp(security:list,*args,**kwargs):
    # 获取定增发行日期
    return w.wss(security,"fellow_issuedate_pp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListDToNlSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网上发行日期时间序列
    return w.wsd(security,"cb_list_dtonl",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListDToNl(security:list,*args,**kwargs):
    # 获取网上发行日期
    return w.wss(security,"cb_list_dtonl",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListDateInStOffSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下向机构投资者发行日期时间序列
    return w.wsd(security,"cb_list_dateinstoff",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbListDateInStOff(security:list,*args,**kwargs):
    # 获取网下向机构投资者发行日期
    return w.wss(security,"cb_list_dateinstoff",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行方式时间序列
    return w.wsd(security,"issue_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueType(security:list,*args,**kwargs):
    # 获取发行方式
    return w.wss(security,"issue_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发发行方式时间序列
    return w.wsd(security,"ipo_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoType(security:list,*args,**kwargs):
    # 获取首发发行方式
    return w.wss(security,"ipo_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowIssueTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增发发行方式时间序列
    return w.wsd(security,"fellow_issuetype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowIssueType(security:list,*args,**kwargs):
    # 获取增发发行方式
    return w.wss(security,"fellow_issuetype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueObjectSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行对象时间序列
    return w.wsd(security,"issue_object",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueObject(security:list,*args,**kwargs):
    # 获取发行对象
    return w.wss(security,"issue_object",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowShareholdersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增发发行对象时间序列
    return w.wsd(security,"fellow_shareholders",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowShareholders(security:list,*args,**kwargs):
    # 获取增发发行对象
    return w.wss(security,"fellow_shareholders",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行份额时间序列
    return w.wsd(security,"issue_unit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueUnit(security:list,*args,**kwargs):
    # 获取发行份额
    return w.wss(security,"issue_unit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueTotalUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行总份额时间序列
    return w.wsd(security,"issue_totalunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueTotalUnit(security:list,*args,**kwargs):
    # 获取发行总份额
    return w.wss(security,"issue_totalunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsIssueSizeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行规模时间序列
    return w.wsd(security,"fund_reitsissuesize",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsIssueSize(security:list,*args,**kwargs):
    # 获取发行规模
    return w.wss(security,"fund_reitsissuesize",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundActualScaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际发行规模时间序列
    return w.wsd(security,"fund_actualscale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundActualScale(security:list,*args,**kwargs):
    # 获取实际发行规模
    return w.wss(security,"fund_actualscale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueTotalSizeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行总规模时间序列
    return w.wsd(security,"issue_totalsize",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueTotalSize(security:list,*args,**kwargs):
    # 获取发行总规模
    return w.wss(security,"issue_totalsize",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueInitiatorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金发起人时间序列
    return w.wsd(security,"issue_initiator",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueInitiator(security:list,*args,**kwargs):
    # 获取基金发起人
    return w.wss(security,"issue_initiator",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueLeadUnderwriterSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金主承销商时间序列
    return w.wsd(security,"issue_leadunderwriter",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueLeadUnderwriter(security:list,*args,**kwargs):
    # 获取基金主承销商
    return w.wss(security,"issue_leadunderwriter",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueDeputySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金销售代理人时间序列
    return w.wsd(security,"issue_deputy",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueDeputy(security:list,*args,**kwargs):
    # 获取基金销售代理人
    return w.wss(security,"issue_deputy",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueNominatorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金上市推荐人时间序列
    return w.wsd(security,"issue_nominator",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueNominator(security:list,*args,**kwargs):
    # 获取基金上市推荐人
    return w.wss(security,"issue_nominator",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeClsPeriodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行封闭期时间序列
    return w.wsd(security,"issue_oeclsperiod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeClsPeriod(security:list,*args,**kwargs):
    # 获取发行封闭期
    return w.wss(security,"issue_oeclsperiod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeCNdNetPurchaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成立条件-净认购份额时间序列
    return w.wsd(security,"issue_oecndnetpurchase",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeCNdNetPurchase(security:list,*args,**kwargs):
    # 获取成立条件-净认购份额
    return w.wss(security,"issue_oecndnetpurchase",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeCNdPurchasersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成立条件-认购户数时间序列
    return w.wsd(security,"issue_oecndpurchasers",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOeCNdPurchasers(security:list,*args,**kwargs):
    # 获取成立条件-认购户数
    return w.wss(security,"issue_oecndpurchasers",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxCollectionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取募集份额上限时间序列
    return w.wsd(security,"issue_oef_maxcollection",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxCollection(security:list,*args,**kwargs):
    # 获取募集份额上限
    return w.wss(security,"issue_oef_maxcollection",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfConfirmRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购份额确认比例时间序列
    return w.wsd(security,"issue_oef_confirmratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfConfirmRatio(security:list,*args,**kwargs):
    # 获取认购份额确认比例
    return w.wss(security,"issue_oef_confirmratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfNumPurchasersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开放式基金认购户数时间序列
    return w.wsd(security,"issue_oef_numpurchasers",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfNumPurchasers(security:list,*args,**kwargs):
    # 获取开放式基金认购户数
    return w.wss(security,"issue_oef_numpurchasers",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueEtFDealShareOnMarketSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市交易份额时间序列
    return w.wsd(security,"issue_etfdealshareonmarket",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueEtFDealShareOnMarket(security:list,*args,**kwargs):
    # 获取上市交易份额
    return w.wss(security,"issue_etfdealshareonmarket",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOnlineCashOfferingSymbolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网上现金发售代码时间序列
    return w.wsd(security,"issue_onlinecashofferingsymbol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOnlineCashOfferingSymbol(security:list,*args,**kwargs):
    # 获取网上现金发售代码
    return w.wss(security,"issue_onlinecashofferingsymbol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFirstMarketFundCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一级市场基金代码时间序列
    return w.wsd(security,"issue_firstmarketfundcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFirstMarketFundCode(security:list,*args,**kwargs):
    # 获取一级市场基金代码
    return w.wss(security,"issue_firstmarketfundcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMThDInDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者认购方式时间序列
    return w.wsd(security,"issue_oef_mthdind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMThDInD(security:list,*args,**kwargs):
    # 获取个人投资者认购方式
    return w.wss(security,"issue_oef_mthdind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMinamTinDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者认购金额下限时间序列
    return w.wsd(security,"issue_oef_minamtind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMinamTinD(security:list,*args,**kwargs):
    # 获取个人投资者认购金额下限
    return w.wss(security,"issue_oef_minamtind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxAmtInDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者认购金额上限时间序列
    return w.wsd(security,"issue_oef_maxamtind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxAmtInD(security:list,*args,**kwargs):
    # 获取个人投资者认购金额上限
    return w.wss(security,"issue_oef_maxamtind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfStartDateInDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者认购起始日时间序列
    return w.wsd(security,"issue_oef_startdateind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfStartDateInD(security:list,*args,**kwargs):
    # 获取个人投资者认购起始日
    return w.wss(security,"issue_oef_startdateind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfEnddateInDSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者认购终止日时间序列
    return w.wsd(security,"issue_oef_enddateind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfEnddateInD(security:list,*args,**kwargs):
    # 获取个人投资者认购终止日
    return w.wss(security,"issue_oef_enddateind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMThDInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭期机构投资者认购方式时间序列
    return w.wsd(security,"issue_oef_mthdinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMThDInSt(security:list,*args,**kwargs):
    # 获取封闭期机构投资者认购方式
    return w.wss(security,"issue_oef_mthdinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfStartDateInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者设立认购起始日时间序列
    return w.wsd(security,"issue_oef_startdateinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfStartDateInSt(security:list,*args,**kwargs):
    # 获取机构投资者设立认购起始日
    return w.wss(security,"issue_oef_startdateinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfDndDateInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者设立认购终止日时间序列
    return w.wsd(security,"issue_oef_dnddateinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfDndDateInSt(security:list,*args,**kwargs):
    # 获取机构投资者设立认购终止日
    return w.wss(security,"issue_oef_dnddateinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMinamTinStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭期机构投资者认购下限时间序列
    return w.wsd(security,"issue_oef_minamtinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMinamTinSt(security:list,*args,**kwargs):
    # 获取封闭期机构投资者认购下限
    return w.wss(security,"issue_oef_minamtinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxAmtInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭期机构投资者认购上限时间序列
    return w.wsd(security,"issue_oef_maxamtinst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfMaxAmtInSt(security:list,*args,**kwargs):
    # 获取封闭期机构投资者认购上限
    return w.wss(security,"issue_oef_maxamtinst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefInIPurchaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭式基金认购数量时间序列
    return w.wsd(security,"issue_cef_inipurchase",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefInIPurchase(security:list,*args,**kwargs):
    # 获取封闭式基金认购数量
    return w.wss(security,"issue_cef_inipurchase",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefOverSubSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭式基金超额认购倍数时间序列
    return w.wsd(security,"issue_cef_oversub",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefOverSub(security:list,*args,**kwargs):
    # 获取封闭式基金超额认购倍数
    return w.wss(security,"issue_cef_oversub",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefSuccRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭式基金中签率时间序列
    return w.wsd(security,"issue_cef_succratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCefSuccRatio(security:list,*args,**kwargs):
    # 获取封闭式基金中签率
    return w.wss(security,"issue_cef_succratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsStartEarlySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否提前开始募集时间序列
    return w.wsd(security,"issue_rasing_isstartearly",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsStartEarly(security:list,*args,**kwargs):
    # 获取是否提前开始募集
    return w.wss(security,"issue_rasing_isstartearly",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsStartDeferredSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否延期募集时间序列
    return w.wsd(security,"issue_rasing_isstartdeferred",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsStartDeferred(security:list,*args,**kwargs):
    # 获取是否延期募集
    return w.wss(security,"issue_rasing_isstartdeferred",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsEndEarlySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否提前结束募集时间序列
    return w.wsd(security,"issue_rasing_isendearly",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsEndEarly(security:list,*args,**kwargs):
    # 获取是否提前结束募集
    return w.wss(security,"issue_rasing_isendearly",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsEndDeferredSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否延长募集期时间序列
    return w.wsd(security,"issue_rasing_isenddeferred",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRaSingIsEndDeferred(security:list,*args,**kwargs):
    # 获取是否延长募集期
    return w.wss(security,"issue_rasing_isenddeferred",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购天数时间序列
    return w.wsd(security,"issue_oef_days",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueOEfDays(security:list,*args,**kwargs):
    # 获取认购天数
    return w.wss(security,"issue_oef_days",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPerUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单位年度分红时间序列
    return w.wsd(security,"div_perunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPerUnit(security:list,*args,**kwargs):
    # 获取单位年度分红
    return w.wss(security,"div_perunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedPerUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单位累计分红时间序列
    return w.wsd(security,"div_accumulatedperunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedPerUnit(security:list,*args,**kwargs):
    # 获取单位累计分红
    return w.wss(security,"div_accumulatedperunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPayOutSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度分红总额时间序列
    return w.wsd(security,"div_payout",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPayOut(security:list,*args,**kwargs):
    # 获取年度分红总额
    return w.wss(security,"div_payout",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivTimesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度分红次数时间序列
    return w.wsd(security,"div_times",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivTimes(security:list,*args,**kwargs):
    # 获取年度分红次数
    return w.wss(security,"div_times",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedPayOutSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取累计分红总额时间序列
    return w.wsd(security,"div_accumulatedpayout",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedPayOut(security:list,*args,**kwargs):
    # 获取累计分红总额
    return w.wss(security,"div_accumulatedpayout",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDiv3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度累计分红总额时间序列
    return w.wsd(security,"div_aualaccmdiv3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDiv3(security:list,*args,**kwargs):
    # 获取年度累计分红总额
    return w.wss(security,"div_aualaccmdiv3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDivArdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度累计分红总额(已宣告)时间序列
    return w.wsd(security,"div_aualaccmdiv_ard",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDivArd(security:list,*args,**kwargs):
    # 获取年度累计分红总额(已宣告)
    return w.wss(security,"div_aualaccmdiv_ard",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDivSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度累计分红总额(沪深)时间序列
    return w.wsd(security,"div_aualaccmdiv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAuALaCcmDiv(security:list,*args,**kwargs):
    # 获取年度累计分红总额(沪深)
    return w.wss(security,"div_aualaccmdiv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedTimesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取累计分红次数时间序列
    return w.wsd(security,"div_accumulatedtimes",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivAccumulatedTimes(security:list,*args,**kwargs):
    # 获取累计分红次数
    return w.wss(security,"div_accumulatedtimes",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodPerUnitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间单位分红时间序列
    return w.wsd(security,"div_periodperunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodPerUnit(security:list,*args,**kwargs):
    # 获取区间单位分红
    return w.wss(security,"div_periodperunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodPayOutSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间分红总额时间序列
    return w.wsd(security,"div_periodpayout",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodPayOut(security:list,*args,**kwargs):
    # 获取区间分红总额
    return w.wss(security,"div_periodpayout",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodTimesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间分红次数时间序列
    return w.wsd(security,"div_periodtimes",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPeriodTimes(security:list,*args,**kwargs):
    # 获取区间分红次数
    return w.wss(security,"div_periodtimes",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分红条款时间序列
    return w.wsd(security,"div_clause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivClause(security:list,*args,**kwargs):
    # 获取分红条款
    return w.wss(security,"div_clause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacLawsuitNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间诉讼次数时间序列
    return w.wsd(security,"cac_lawsuitnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacLawsuitNum(security:list,*args,**kwargs):
    # 获取区间诉讼次数
    return w.wss(security,"cac_lawsuitnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacLawsuitAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间诉讼涉案金额时间序列
    return w.wsd(security,"cac_lawsuitamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacLawsuitAmount(security:list,*args,**kwargs):
    # 获取区间诉讼涉案金额
    return w.wss(security,"cac_lawsuitamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacIllegalityNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间违规处罚次数时间序列
    return w.wsd(security,"cac_illegalitynum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacIllegalityNum(security:list,*args,**kwargs):
    # 获取区间违规处罚次数
    return w.wss(security,"cac_illegalitynum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacIllegalityAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间违规处罚金额时间序列
    return w.wsd(security,"cac_illegalityamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCacIllegalityAmount(security:list,*args,**kwargs):
    # 获取区间违规处罚金额
    return w.wss(security,"cac_illegalityamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNonTradableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未上市流通基金份数(封闭式)时间序列
    return w.wsd(security,"unit_nontradable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNonTradable(security:list,*args,**kwargs):
    # 获取未上市流通基金份数(封闭式)
    return w.wss(security,"unit_nontradable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitTradableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取已上市流通基金份数(封闭式)时间序列
    return w.wsd(security,"unit_tradable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitTradable(security:list,*args,**kwargs):
    # 获取已上市流通基金份数(封闭式)
    return w.wss(security,"unit_tradable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产总值时间序列
    return w.wsd(security,"prt_totalasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAsset(security:list,*args,**kwargs):
    # 获取基金资产总值
    return w.wss(security,"prt_totalasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAssetChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产总值变动时间序列
    return w.wsd(security,"prt_totalassetchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAssetChange(security:list,*args,**kwargs):
    # 获取基金资产总值变动
    return w.wss(security,"prt_totalassetchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAssetChangeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产总值变动率时间序列
    return w.wsd(security,"prt_totalassetchangeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTotalAssetChangeRatio(security:list,*args,**kwargs):
    # 获取基金资产总值变动率
    return w.wss(security,"prt_totalassetchangeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNavToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金净值占基金资产总值比时间序列
    return w.wsd(security,"prt_navtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNavToAsset(security:list,*args,**kwargs):
    # 获取基金净值占基金资产总值比
    return w.wss(security,"prt_navtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票市值占基金资产总值比时间序列
    return w.wsd(security,"prt_stocktoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockToAsset(security:list,*args,**kwargs):
    # 获取股票市值占基金资产总值比
    return w.wss(security,"prt_stocktoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券市值占基金资产总值比时间序列
    return w.wsd(security,"prt_bondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToAsset(security:list,*args,**kwargs):
    # 获取债券市值占基金资产总值比
    return w.wss(security,"prt_bondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金市值占基金资产总值比时间序列
    return w.wsd(security,"prt_fundtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToAsset(security:list,*args,**kwargs):
    # 获取基金市值占基金资产总值比
    return w.wss(security,"prt_fundtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权证市值占基金资产总值比时间序列
    return w.wsd(security,"prt_warranttoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToAsset(security:list,*args,**kwargs):
    # 获取权证市值占基金资产总值比
    return w.wss(security,"prt_warranttoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产占基金资产总值比时间序列
    return w.wsd(security,"prt_othertoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToAsset(security:list,*args,**kwargs):
    # 获取其他资产占基金资产总值比
    return w.wss(security,"prt_othertoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值占基金资产总值比时间序列
    return w.wsd(security,"prt_governmentbondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToAsset(security:list,*args,**kwargs):
    # 获取国债市值占基金资产总值比
    return w.wss(security,"prt_governmentbondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值占基金资产总值比时间序列
    return w.wsd(security,"prt_financialbondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToAsset(security:list,*args,**kwargs):
    # 获取金融债市值占基金资产总值比
    return w.wss(security,"prt_financialbondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值占基金资产总值比时间序列
    return w.wsd(security,"prt_corporatebondstoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToAsset(security:list,*args,**kwargs):
    # 获取企业债市值占基金资产总值比
    return w.wss(security,"prt_corporatebondstoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值占基金资产总值比时间序列
    return w.wsd(security,"prt_convertiblebondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToAsset(security:list,*args,**kwargs):
    # 获取可转债市值占基金资产总值比
    return w.wss(security,"prt_convertiblebondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToAsset2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产总值比时间序列
    return w.wsd(security,"prt_stockvalue_industrytoasset2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToAsset2(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产总值比
    return w.wss(security,"prt_stockvalue_industrytoasset2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStockToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股市值占基金资产总值比时间序列
    return w.wsd(security,"prt_heavilyheldstocktoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStockToAsset(security:list,*args,**kwargs):
    # 获取重仓股市值占基金资产总值比
    return w.wss(security,"prt_heavilyheldstocktoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStockToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股投资市值占基金资产总值比时间序列
    return w.wsd(security,"prt_hkstocktoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStockToAsset(security:list,*args,**kwargs):
    # 获取港股投资市值占基金资产总值比
    return w.wss(security,"prt_hkstocktoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFReverseRepoToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售证券占基金资产总值比例时间序列
    return w.wsd(security,"mmf_reverserepotoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFReverseRepoToAsset(security:list,*args,**kwargs):
    # 获取买入返售证券占基金资产总值比例
    return w.wss(security,"mmf_reverserepotoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值占基金资产总值比时间序列
    return w.wsd(security,"prt_centralbankbilltoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToAsset(security:list,*args,**kwargs):
    # 获取央行票据市值占基金资产总值比
    return w.wss(security,"prt_centralbankbilltoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryToAsset2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业市值占基金资产总值比时间序列
    return w.wsd(security,"prt_stockvalue_topindustrytoasset2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryToAsset2(security:list,*args,**kwargs):
    # 获取重仓行业市值占基金资产总值比
    return w.wss(security,"prt_stockvalue_topindustrytoasset2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券市值占基金资产总值比时间序列
    return w.wsd(security,"prt_heavilyheldbondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToAsset(security:list,*args,**kwargs):
    # 获取重仓债券市值占基金资产总值比
    return w.wss(security,"prt_heavilyheldbondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金市值占基金资产总值比时间序列
    return w.wsd(security,"prt_heavilyheldfundtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToAsset(security:list,*args,**kwargs):
    # 获取重仓基金市值占基金资产总值比
    return w.wss(security,"prt_heavilyheldfundtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取政策性金融债市值占基金资产总值比时间序列
    return w.wsd(security,"prt_pfbtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToAsset(security:list,*args,**kwargs):
    # 获取政策性金融债市值占基金资产总值比
    return w.wss(security,"prt_pfbtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值占基金资产总值比时间序列
    return w.wsd(security,"prt_corporatebondtoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToAsset(security:list,*args,**kwargs):
    # 获取企业发行债券市值占基金资产总值比
    return w.wss(security,"prt_corporatebondtoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldAbsToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券市值占基金资产总值比时间序列
    return w.wsd(security,"prt_heavilyheldabstoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldAbsToAsset(security:list,*args,**kwargs):
    # 获取重仓资产支持证券市值占基金资产总值比
    return w.wss(security,"prt_heavilyheldabstoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValueToAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转融通证券出借业务市值占基金资产总值比时间序列
    return w.wsd(security,"prt_seclendingvaluetoasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValueToAsset(security:list,*args,**kwargs):
    # 获取转融通证券出借业务市值占基金资产总值比
    return w.wss(security,"prt_seclendingvaluetoasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产净值时间序列
    return w.wsd(security,"prt_netasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAsset(security:list,*args,**kwargs):
    # 获取基金资产净值
    return w.wss(security,"prt_netasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAssetChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产净值变动时间序列
    return w.wsd(security,"prt_netassetchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAssetChange(security:list,*args,**kwargs):
    # 获取基金资产净值变动
    return w.wss(security,"prt_netassetchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAssetChangeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金资产净值变动率时间序列
    return w.wsd(security,"prt_netassetchangeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNetAssetChangeRatio(security:list,*args,**kwargs):
    # 获取基金资产净值变动率
    return w.wss(security,"prt_netassetchangeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCurrencySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期基金资产净值币种时间序列
    return w.wsd(security,"prt_currency",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCurrency(security:list,*args,**kwargs):
    # 获取报告期基金资产净值币种
    return w.wss(security,"prt_currency",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票市值占基金资产净值比时间序列
    return w.wsd(security,"prt_stocktonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAv(security:list,*args,**kwargs):
    # 获取股票市值占基金资产净值比
    return w.wss(security,"prt_stocktonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_bondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToNav(security:list,*args,**kwargs):
    # 获取债券市值占基金资产净值比
    return w.wss(security,"prt_bondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金市值占基金资产净值比时间序列
    return w.wsd(security,"prt_fundtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToNav(security:list,*args,**kwargs):
    # 获取基金市值占基金资产净值比
    return w.wss(security,"prt_fundtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权证市值占基金资产净值比时间序列
    return w.wsd(security,"prt_warranttonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToNav(security:list,*args,**kwargs):
    # 获取权证市值占基金资产净值比
    return w.wss(security,"prt_warranttonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产占基金资产净值比时间序列
    return w.wsd(security,"prt_othertonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToNav(security:list,*args,**kwargs):
    # 获取其他资产占基金资产净值比
    return w.wss(security,"prt_othertonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_stocktonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvGrowth(security:list,*args,**kwargs):
    # 获取股票市值占基金资产净值比例增长
    return w.wss(security,"prt_stocktonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_bondtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondToNavGrowth(security:list,*args,**kwargs):
    # 获取债券市值占基金资产净值比例增长
    return w.wss(security,"prt_bondtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_fundtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundToNavGrowth(security:list,*args,**kwargs):
    # 获取基金市值占基金资产净值比例增长
    return w.wss(security,"prt_fundtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权证市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_warranttonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantToNavGrowth(security:list,*args,**kwargs):
    # 获取权证市值占基金资产净值比例增长
    return w.wss(security,"prt_warranttonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值占基金资产净值比时间序列
    return w.wsd(security,"prt_governmentbondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToNav(security:list,*args,**kwargs):
    # 获取国债市值占基金资产净值比
    return w.wss(security,"prt_governmentbondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_governmentbondtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToNavGrowth(security:list,*args,**kwargs):
    # 获取国债市值占基金资产净值比例增长
    return w.wss(security,"prt_governmentbondtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值占基金资产净值比时间序列
    return w.wsd(security,"prt_financialbondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToNav(security:list,*args,**kwargs):
    # 获取金融债市值占基金资产净值比
    return w.wss(security,"prt_financialbondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值占基金资产净值比时间序列
    return w.wsd(security,"prt_corporatebondstonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToNav(security:list,*args,**kwargs):
    # 获取企业债市值占基金资产净值比
    return w.wss(security,"prt_corporatebondstonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值占基金资产净值比时间序列
    return w.wsd(security,"prt_convertiblebondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToNav(security:list,*args,**kwargs):
    # 获取可转债市值占基金资产净值比
    return w.wss(security,"prt_convertiblebondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_financialbondtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToNavGrowth(security:list,*args,**kwargs):
    # 获取金融债市值占基金资产净值比例增长
    return w.wss(security,"prt_financialbondtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_corporatebondstonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToNavGrowth(security:list,*args,**kwargs):
    # 获取企业债市值占基金资产净值比例增长
    return w.wss(security,"prt_corporatebondstonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_convertiblebondtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToNavGrowth(security:list,*args,**kwargs):
    # 获取可转债市值占基金资产净值比例增长
    return w.wss(security,"prt_convertiblebondtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToNav2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产净值比时间序列
    return w.wsd(security,"prt_stockvalue_industrytonav2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToNav2(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产净值比
    return w.wss(security,"prt_stockvalue_industrytonav2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToNavGrowth2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长时间序列
    return w.wsd(security,"prt_stockvalue_industrytonavgrowth2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryToNavGrowth2(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长
    return w.wss(security,"prt_stockvalue_industrytonavgrowth2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(Wind)时间序列
    return w.wsd(security,"prt_industrytonavgrowth_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthWind(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(Wind)
    return w.wss(security,"prt_industrytonavgrowth_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(中信)时间序列
    return w.wsd(security,"prt_industrytonavgrowth_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthCitiC(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(中信)
    return w.wss(security,"prt_industrytonavgrowth_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(申万)时间序列
    return w.wsd(security,"prt_industrytonavgrowth_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryToNavGrowthSw(security:list,*args,**kwargs):
    # 获取分行业市值占基金资产净值比增长(申万)
    return w.wss(security,"prt_industrytonavgrowth_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStocktonAvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股市值占基金资产净值比时间序列
    return w.wsd(security,"prt_heavilyheldstocktonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStocktonAv(security:list,*args,**kwargs):
    # 获取重仓股市值占基金资产净值比
    return w.wss(security,"prt_heavilyheldstocktonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFDifferentPtMToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取各期限资产占基金资产净值比例时间序列
    return w.wsd(security,"mmf_differentptmtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFDifferentPtMToNav(security:list,*args,**kwargs):
    # 获取各期限资产占基金资产净值比例
    return w.wss(security,"mmf_differentptmtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStocktonAvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股投资市值占基金资产净值比时间序列
    return w.wsd(security,"prt_hkstocktonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStocktonAv(security:list,*args,**kwargs):
    # 获取港股投资市值占基金资产净值比
    return w.wss(security,"prt_hkstocktonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtReverseRepoToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取买入返售证券占基金资产净值比例时间序列
    return w.wsd(security,"prt_reverserepotonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtReverseRepoToNav(security:list,*args,**kwargs):
    # 获取买入返售证券占基金资产净值比例
    return w.wss(security,"prt_reverserepotonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_othertonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherToNavGrowth(security:list,*args,**kwargs):
    # 获取其他资产市值占基金资产净值比例增长
    return w.wss(security,"prt_othertonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCdsToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同业存单市值占基金资产净值比时间序列
    return w.wsd(security,"prt_CDstonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCdsToNav(security:list,*args,**kwargs):
    # 获取同业存单市值占基金资产净值比
    return w.wss(security,"prt_CDstonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值占基金资产净值比时间序列
    return w.wsd(security,"prt_centralbankbilltonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToNav(security:list,*args,**kwargs):
    # 获取央行票据市值占基金资产净值比
    return w.wss(security,"prt_centralbankbilltonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMtnToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中期票据市值占基金资产净值比时间序列
    return w.wsd(security,"prt_mtntonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMtnToNav(security:list,*args,**kwargs):
    # 获取中期票据市值占基金资产净值比
    return w.wss(security,"prt_mtntonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他债券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_otherbondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherBondToNav(security:list,*args,**kwargs):
    # 获取其他债券市值占基金资产净值比
    return w.wss(security,"prt_otherbondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_centralbankbilltonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToNavGrowth(security:list,*args,**kwargs):
    # 获取央行票据市值占基金资产净值比例增长
    return w.wss(security,"prt_centralbankbilltonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryToNav2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业市值占基金资产净值比时间序列
    return w.wsd(security,"prt_stockvalue_topindustrytonav2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryToNav2(security:list,*args,**kwargs):
    # 获取重仓行业市值占基金资产净值比
    return w.wss(security,"prt_stockvalue_topindustrytonav2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_heavilyheldbondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToNav(security:list,*args,**kwargs):
    # 获取重仓债券市值占基金资产净值比
    return w.wss(security,"prt_heavilyheldbondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金市值占基金资产净值比时间序列
    return w.wsd(security,"prt_heavilyheldfundtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToNav(security:list,*args,**kwargs):
    # 获取重仓基金市值占基金资产净值比
    return w.wss(security,"prt_heavilyheldfundtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCpToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取短期融资券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_cptonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCpToNav(security:list,*args,**kwargs):
    # 获取短期融资券市值占基金资产净值比
    return w.wss(security,"prt_cptonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGicSIndustryValueToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比例(Wind全球行业)时间序列
    return w.wsd(security,"prt_gicsindustryvaluetonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGicSIndustryValueToNav(security:list,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比例(Wind全球行业)
    return w.wss(security,"prt_gicsindustryvaluetonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(Wind)时间序列
    return w.wsd(security,"prt_industryvaluetonav_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavWind(security:list,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(Wind)
    return w.wss(security,"prt_industryvaluetonav_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(中信)时间序列
    return w.wsd(security,"prt_industryvaluetonav_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavCitiC(security:list,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(中信)
    return w.wss(security,"prt_industryvaluetonav_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(申万)时间序列
    return w.wsd(security,"prt_industryvaluetonav_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueToNavSw(security:list,*args,**kwargs):
    # 获取分行业投资市值占基金资产净值比(申万)
    return w.wss(security,"prt_industryvaluetonav_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNetAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.报告期期末基金资产净值时间序列
    return w.wsd(security,"qanal_netasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalNetAsset(security:list,*args,**kwargs):
    # 获取单季度.报告期期末基金资产净值
    return w.wss(security,"qanal_netasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvPassiveInvestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指数投资股票市值占基金资产净值比时间序列
    return w.wsd(security,"prt_stocktonav_passiveinvest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvPassiveInvest(security:list,*args,**kwargs):
    # 获取指数投资股票市值占基金资产净值比
    return w.wss(security,"prt_stocktonav_passiveinvest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvActiveInvestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取积极投资股票市值占基金资产净值比时间序列
    return w.wsd(security,"prt_stocktonav_activeinvest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStocktonAvActiveInvest(security:list,*args,**kwargs):
    # 获取积极投资股票市值占基金资产净值比
    return w.wss(security,"prt_stocktonav_activeinvest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取政策性金融债市值占基金资产净值比时间序列
    return w.wsd(security,"prt_pfbtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToNav(security:list,*args,**kwargs):
    # 获取政策性金融债市值占基金资产净值比
    return w.wss(security,"prt_pfbtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_corporatebondtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToNav(security:list,*args,**kwargs):
    # 获取企业发行债券市值占基金资产净值比
    return w.wss(security,"prt_corporatebondtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产支持证券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_abstonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsToNav(security:list,*args,**kwargs):
    # 获取资产支持证券市值占基金资产净值比
    return w.wss(security,"prt_abstonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMMitoNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币市场工具市值占基金资产净值比时间序列
    return w.wsd(security,"prt_mmitonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMMitoNav(security:list,*args,**kwargs):
    # 获取货币市场工具市值占基金资产净值比
    return w.wss(security,"prt_mmitonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToNavGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值占基金资产净值比例增长时间序列
    return w.wsd(security,"prt_corporatebondtonavgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToNavGrowth(security:list,*args,**kwargs):
    # 获取企业发行债券市值占基金资产净值比例增长
    return w.wss(security,"prt_corporatebondtonavgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopGicSIndustryValueToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比例(Wind全球行业)时间序列
    return w.wsd(security,"prt_topgicsindustryvaluetonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopGicSIndustryValueToNav(security:list,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比例(Wind全球行业)
    return w.wss(security,"prt_topgicsindustryvaluetonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(Wind)时间序列
    return w.wsd(security,"prt_topindustryvaluetonav_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavWind(security:list,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(Wind)
    return w.wss(security,"prt_topindustryvaluetonav_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(中信)时间序列
    return w.wsd(security,"prt_topindustryvaluetonav_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavCitiC(security:list,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(中信)
    return w.wss(security,"prt_topindustryvaluetonav_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(申万)时间序列
    return w.wsd(security,"prt_topindustryvaluetonav_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryValueToNavSw(security:list,*args,**kwargs):
    # 获取重仓行业投资市值占基金资产净值比(申万)
    return w.wss(security,"prt_topindustryvaluetonav_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtQdIiCountryRegionInvestmentToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国家/地区投资市值占基金资产净值比例(QDII)时间序列
    return w.wsd(security,"prt_qdii_countryregioninvestmenttonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtQdIiCountryRegionInvestmentToNav(security:list,*args,**kwargs):
    # 获取国家/地区投资市值占基金资产净值比例(QDII)
    return w.wss(security,"prt_qdii_countryregioninvestmenttonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldAbsToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券市值占基金资产净值比时间序列
    return w.wsd(security,"prt_heavilyheldabstonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldAbsToNav(security:list,*args,**kwargs):
    # 获取重仓资产支持证券市值占基金资产净值比
    return w.wss(security,"prt_heavilyheldabstonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValueToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转融通证券出借业务市值占基金资产净值比时间序列
    return w.wsd(security,"prt_seclendingvaluetonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValueToNav(security:list,*args,**kwargs):
    # 获取转融通证券出借业务市值占基金资产净值比
    return w.wss(security,"prt_seclendingvaluetonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNStocktonAvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓股票市值合计占基金资产净值比时间序列
    return w.wsd(security,"prt_topnstocktonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNStocktonAv(security:list,*args,**kwargs):
    # 获取前N名重仓股票市值合计占基金资产净值比
    return w.wss(security,"prt_topnstocktonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTop5ToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓债券市值合计占基金资产净值比时间序列
    return w.wsd(security,"prt_top5tonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTop5ToNav(security:list,*args,**kwargs):
    # 获取前N名重仓债券市值合计占基金资产净值比
    return w.wss(security,"prt_top5tonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNFundToNavSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓基金市值合计占基金资产净值比时间序列
    return w.wsd(security,"prt_topnfundtonav",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNFundToNav(security:list,*args,**kwargs):
    # 获取前N名重仓基金市值合计占基金资产净值比
    return w.wss(security,"prt_topnfundtonav",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAvgNetAssetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期基金日均资产净值时间序列
    return w.wsd(security,"prt_avgnetasset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAvgNetAsset(security:list,*args,**kwargs):
    # 获取报告期基金日均资产净值
    return w.wss(security,"prt_avgnetasset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNetAssetTotalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产净值(合计)时间序列
    return w.wsd(security,"prt_fundnetasset_total",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNetAssetTotal(security:list,*args,**kwargs):
    # 获取资产净值(合计)
    return w.wss(security,"prt_fundnetasset_total",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMergedNavOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产净值是否为合并数据(最新)时间序列
    return w.wsd(security,"prt_mergednavornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMergedNavOrNot(security:list,*args,**kwargs):
    # 获取资产净值是否为合并数据(最新)
    return w.wss(security,"prt_mergednavornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMergedNavOrNot1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产净值是否为合并数据(报告期)时间序列
    return w.wsd(security,"prt_mergednavornot1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMergedNavOrNot1(security:list,*args,**kwargs):
    # 获取资产净值是否为合并数据(报告期)
    return w.wss(security,"prt_mergednavornot1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAvgFundScaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同类基金平均规模时间序列
    return w.wsd(security,"fund_avgfundscale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAvgFundScale(security:list,*args,**kwargs):
    # 获取同类基金平均规模
    return w.wss(security,"fund_avgfundscale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMarketOutlookSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市场展望时间序列
    return w.wsd(security,"fund_marketoutlook",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMarketOutlook(security:list,*args,**kwargs):
    # 获取市场展望
    return w.wss(security,"fund_marketoutlook",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMarketAnalysisSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市场分析时间序列
    return w.wsd(security,"fund_marketanalysis",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMarketAnalysis(security:list,*args,**kwargs):
    # 获取市场分析
    return w.wss(security,"fund_marketanalysis",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票投资市值时间序列
    return w.wsd(security,"prt_stockvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValue(security:list,*args,**kwargs):
    # 获取股票投资市值
    return w.wss(security,"prt_stockvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryTostock2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值占股票投资市值比时间序列
    return w.wsd(security,"prt_stockvalue_industrytostock2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryTostock2(security:list,*args,**kwargs):
    # 获取分行业市值占股票投资市值比
    return w.wss(security,"prt_stockvalue_industrytostock2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStockTostockSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股市值占股票投资市值比时间序列
    return w.wsd(security,"prt_heavilyheldstocktostock",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldStockTostock(security:list,*args,**kwargs):
    # 获取重仓股市值占股票投资市值比
    return w.wss(security,"prt_heavilyheldstocktostock",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryTostock2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业市值占股票投资市值比时间序列
    return w.wsd(security,"prt_stockvalue_topindustrytostock2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryTostock2(security:list,*args,**kwargs):
    # 获取重仓行业市值占股票投资市值比
    return w.wss(security,"prt_stockvalue_topindustrytostock2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNStockTostockSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓股票市值合计占股票投资市值比时间序列
    return w.wsd(security,"prt_topnstocktostock",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopNStockTostock(security:list,*args,**kwargs):
    # 获取前N名重仓股票市值合计占股票投资市值比
    return w.wss(security,"prt_topnstocktostock",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValuePassiveInvestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指数投资股票市值时间序列
    return w.wsd(security,"prt_stockvalue_passiveinvest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValuePassiveInvest(security:list,*args,**kwargs):
    # 获取指数投资股票市值
    return w.wss(security,"prt_stockvalue_passiveinvest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueActiveInvestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取积极投资股票市值时间序列
    return w.wsd(security,"prt_stockvalue_activeinvest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueActiveInvest(security:list,*args,**kwargs):
    # 获取积极投资股票市值
    return w.wss(security,"prt_stockvalue_activeinvest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStockValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股投资市值时间序列
    return w.wsd(security,"prt_hkstockvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHkStockValue(security:list,*args,**kwargs):
    # 获取港股投资市值
    return w.wss(security,"prt_hkstockvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券投资市值时间序列
    return w.wsd(security,"prt_bondvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondValue(security:list,*args,**kwargs):
    # 获取债券投资市值
    return w.wss(security,"prt_bondvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值占债券投资市值比时间序列
    return w.wsd(security,"prt_governmentbondtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondToBond(security:list,*args,**kwargs):
    # 获取国债市值占债券投资市值比
    return w.wss(security,"prt_governmentbondtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值占债券投资市值比时间序列
    return w.wsd(security,"prt_financialbondtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondToBond(security:list,*args,**kwargs):
    # 获取金融债市值占债券投资市值比
    return w.wss(security,"prt_financialbondtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值占债券投资市值比时间序列
    return w.wsd(security,"prt_corporatebondstobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsToBond(security:list,*args,**kwargs):
    # 获取企业债市值占债券投资市值比
    return w.wss(security,"prt_corporatebondstobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值占债券投资市值比时间序列
    return w.wsd(security,"prt_convertiblebondtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondToBond(security:list,*args,**kwargs):
    # 获取可转债市值占债券投资市值比
    return w.wss(security,"prt_convertiblebondtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值占债券投资市值比时间序列
    return w.wsd(security,"prt_centralbankbilltobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillToBond(security:list,*args,**kwargs):
    # 获取央行票据市值占债券投资市值比
    return w.wss(security,"prt_centralbankbilltobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取政策性金融债占债券投资市值比时间序列
    return w.wsd(security,"prt_pfbtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbToBond(security:list,*args,**kwargs):
    # 获取政策性金融债占债券投资市值比
    return w.wss(security,"prt_pfbtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同业存单市值占债券投资市值比时间序列
    return w.wsd(security,"prt_NCDtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNcdToBond(security:list,*args,**kwargs):
    # 获取同业存单市值占债券投资市值比
    return w.wss(security,"prt_NCDtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券市值占债券投资市值比时间序列
    return w.wsd(security,"prt_heavilyheldbondtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldBondToBond(security:list,*args,**kwargs):
    # 获取重仓债券市值占债券投资市值比
    return w.wss(security,"prt_heavilyheldbondtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值占债券投资市值比时间序列
    return w.wsd(security,"prt_corporatebondtobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondToBond(security:list,*args,**kwargs):
    # 获取企业发行债券市值占债券投资市值比
    return w.wss(security,"prt_corporatebondtobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTop5ToBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓债券市值合计占债券投资市值比时间序列
    return w.wsd(security,"prt_top5tobond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTop5ToBond(security:list,*args,**kwargs):
    # 获取前N名重仓债券市值合计占债券投资市值比
    return w.wss(security,"prt_top5tobond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金投资市值时间序列
    return w.wsd(security,"prt_fundvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundValue(security:list,*args,**kwargs):
    # 获取基金投资市值
    return w.wss(security,"prt_fundvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金市值占基金投资市值比时间序列
    return w.wsd(security,"prt_heavilyheldfundtofund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtHeavilyHeldFundToFund(security:list,*args,**kwargs):
    # 获取重仓基金市值占基金投资市值比
    return w.wss(security,"prt_heavilyheldfundtofund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundToFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前N名重仓基金市值合计占基金投资市值比时间序列
    return w.wsd(security,"prt_topfundtofund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundToFund(security:list,*args,**kwargs):
    # 获取前N名重仓基金市值合计占基金投资市值比
    return w.wss(security,"prt_topfundtofund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSiFuturesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股指期货投资市值时间序列
    return w.wsd(security,"prt_SIfutures",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSiFutures(security:list,*args,**kwargs):
    # 获取股指期货投资市值
    return w.wss(security,"prt_SIfutures",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGbFuturesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债期货投资市值时间序列
    return w.wsd(security,"prt_gbfutures",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGbFutures(security:list,*args,**kwargs):
    # 获取国债期货投资市值
    return w.wss(security,"prt_gbfutures",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权证投资市值时间序列
    return w.wsd(security,"prt_warrantvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantValue(security:list,*args,**kwargs):
    # 获取权证投资市值
    return w.wss(security,"prt_warrantvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转融通证券出借业务市值时间序列
    return w.wsd(security,"prt_seclendingvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSecLendingValue(security:list,*args,**kwargs):
    # 获取转融通证券出借业务市值
    return w.wss(security,"prt_seclendingvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDAssetsOThSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产_GSD时间序列
    return w.wsd(security,"wgsd_assets_oth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDAssetsOTh(security:list,*args,**kwargs):
    # 获取其他资产_GSD
    return w.wss(security,"wgsd_assets_oth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产时间序列
    return w.wsd(security,"prt_other",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOther(security:list,*args,**kwargs):
    # 获取其他资产
    return w.wss(security,"prt_other",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs18Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产_FUND时间序列
    return w.wsd(security,"stm_bs_18",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmBs18(security:list,*args,**kwargs):
    # 获取其他资产_FUND
    return w.wss(security,"stm_bs_18",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他资产市值增长率时间序列
    return w.wsd(security,"prt_othervaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherValueGrowth(security:list,*args,**kwargs):
    # 获取其他资产市值增长率
    return w.wss(security,"prt_othervaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票市值增长率时间序列
    return w.wsd(security,"prt_stockvaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueGrowth(security:list,*args,**kwargs):
    # 获取股票市值增长率
    return w.wss(security,"prt_stockvaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券市值增长率时间序列
    return w.wsd(security,"prt_bondvaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBondValueGrowth(security:list,*args,**kwargs):
    # 获取债券市值增长率
    return w.wss(security,"prt_bondvaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值增长率时间序列
    return w.wsd(security,"prt_corporatebondgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondGrowth(security:list,*args,**kwargs):
    # 获取企业发行债券市值增长率
    return w.wss(security,"prt_corporatebondgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金市值增长率时间序列
    return w.wsd(security,"prt_fundvaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundValueGrowth(security:list,*args,**kwargs):
    # 获取基金市值增长率
    return w.wss(security,"prt_fundvaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantValueGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取权证市值增长率时间序列
    return w.wsd(security,"prt_warrantvaluegrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtWarrantValueGrowth(security:list,*args,**kwargs):
    # 获取权证市值增长率
    return w.wss(security,"prt_warrantvaluegrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFoundLeverageSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金杠杆率时间序列
    return w.wsd(security,"prt_foundleverage",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFoundLeverage(security:list,*args,**kwargs):
    # 获取基金杠杆率
    return w.wss(security,"prt_foundleverage",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值时间序列
    return w.wsd(security,"prt_governmentbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBond(security:list,*args,**kwargs):
    # 获取国债市值
    return w.wss(security,"prt_governmentbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债市值增长率时间序列
    return w.wsd(security,"prt_governmentbondgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGovernmentBondGrowth(security:list,*args,**kwargs):
    # 获取国债市值增长率
    return w.wss(security,"prt_governmentbondgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCdsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同业存单市值时间序列
    return w.wsd(security,"prt_CDs",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCds(security:list,*args,**kwargs):
    # 获取同业存单市值
    return w.wss(security,"prt_CDs",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值时间序列
    return w.wsd(security,"prt_centralbankbill",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBill(security:list,*args,**kwargs):
    # 获取央行票据市值
    return w.wss(security,"prt_centralbankbill",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取央行票据市值增长率时间序列
    return w.wsd(security,"prt_centralbankbillgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCentralBankBillGrowth(security:list,*args,**kwargs):
    # 获取央行票据市值增长率
    return w.wss(security,"prt_centralbankbillgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值时间序列
    return w.wsd(security,"prt_financialbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBond(security:list,*args,**kwargs):
    # 获取金融债市值
    return w.wss(security,"prt_financialbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融债市值增长率时间序列
    return w.wsd(security,"prt_financialbondgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFinancialBondGrowth(security:list,*args,**kwargs):
    # 获取金融债市值增长率
    return w.wss(security,"prt_financialbondgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取政策性金融债市值时间序列
    return w.wsd(security,"prt_pfbvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtPFbValue(security:list,*args,**kwargs):
    # 获取政策性金融债市值
    return w.wss(security,"prt_pfbvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业发行债券市值时间序列
    return w.wsd(security,"prt_corporatebond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBond(security:list,*args,**kwargs):
    # 获取企业发行债券市值
    return w.wss(security,"prt_corporatebond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值时间序列
    return w.wsd(security,"prt_corporatebonds",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBonds(security:list,*args,**kwargs):
    # 获取企业债市值
    return w.wss(security,"prt_corporatebonds",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业债市值增长率时间序列
    return w.wsd(security,"prt_corporatebondsgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCorporateBondsGrowth(security:list,*args,**kwargs):
    # 获取企业债市值增长率
    return w.wss(security,"prt_corporatebondsgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCpValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取短期融资券市值时间序列
    return w.wsd(security,"prt_cpvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtCpValue(security:list,*args,**kwargs):
    # 获取短期融资券市值
    return w.wss(security,"prt_cpvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMtnValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中期票据市值时间序列
    return w.wsd(security,"prt_mtnvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMtnValue(security:list,*args,**kwargs):
    # 获取中期票据市值
    return w.wss(security,"prt_mtnvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值时间序列
    return w.wsd(security,"prt_convertiblebond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBond(security:list,*args,**kwargs):
    # 获取可转债市值
    return w.wss(security,"prt_convertiblebond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondGrowthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可转债市值增长率时间序列
    return w.wsd(security,"prt_convertiblebondgrowth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtConvertibleBondGrowth(security:list,*args,**kwargs):
    # 获取可转债市值增长率
    return w.wss(security,"prt_convertiblebondgrowth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产支持证券市值时间序列
    return w.wsd(security,"prt_absvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtAbsValue(security:list,*args,**kwargs):
    # 获取资产支持证券市值
    return w.wss(security,"prt_absvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMmIValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取货币市场工具市值时间序列
    return w.wsd(security,"prt_mmivalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtMmIValue(security:list,*args,**kwargs):
    # 获取货币市场工具市值
    return w.wss(security,"prt_mmivalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他债券市值时间序列
    return w.wsd(security,"prt_otherbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtOtherBond(security:list,*args,**kwargs):
    # 获取其他债券市值
    return w.wss(security,"prt_otherbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustry2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值时间序列
    return w.wsd(security,"prt_stockvalue_industry2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustry2(security:list,*args,**kwargs):
    # 获取分行业投资市值
    return w.wss(security,"prt_stockvalue_industry2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGicSIndustryValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值(Wind全球行业)时间序列
    return w.wsd(security,"prt_gicsindustryvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtGicSIndustryValue(security:list,*args,**kwargs):
    # 获取分行业投资市值(Wind全球行业)
    return w.wss(security,"prt_gicsindustryvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值(Wind)时间序列
    return w.wsd(security,"prt_industryvalue_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueWind(security:list,*args,**kwargs):
    # 获取分行业投资市值(Wind)
    return w.wss(security,"prt_industryvalue_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值(中信)时间序列
    return w.wsd(security,"prt_industryvalue_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueCitiC(security:list,*args,**kwargs):
    # 获取分行业投资市值(中信)
    return w.wss(security,"prt_industryvalue_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业投资市值(申万)时间序列
    return w.wsd(security,"prt_industryvalue_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueSw(security:list,*args,**kwargs):
    # 获取分行业投资市值(申万)
    return w.wss(security,"prt_industryvalue_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryValueGrowth2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值增长率时间序列
    return w.wsd(security,"prt_stockvalue_industryvaluegrowth2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueIndustryValueGrowth2(security:list,*args,**kwargs):
    # 获取分行业市值增长率
    return w.wss(security,"prt_stockvalue_industryvaluegrowth2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值增长率(Wind)时间序列
    return w.wsd(security,"prt_industryvaluegrowth_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthWind(security:list,*args,**kwargs):
    # 获取分行业市值增长率(Wind)
    return w.wss(security,"prt_industryvaluegrowth_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值增长率(中信)时间序列
    return w.wsd(security,"prt_industryvaluegrowth_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthCitiC(security:list,*args,**kwargs):
    # 获取分行业市值增长率(中信)
    return w.wss(security,"prt_industryvaluegrowth_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取分行业市值增长率(申万)时间序列
    return w.wsd(security,"prt_industryvaluegrowth_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtIndustryValueGrowthSw(security:list,*args,**kwargs):
    # 获取分行业市值增长率(申万)
    return w.wss(security,"prt_industryvaluegrowth_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryName2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业名称时间序列
    return w.wsd(security,"prt_stockvalue_topindustryname2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryName2(security:list,*args,**kwargs):
    # 获取重仓行业名称
    return w.wss(security,"prt_stockvalue_topindustryname2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopGicSIndustryNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业名称(Wind全球行业)时间序列
    return w.wsd(security,"prt_topgicsindustryname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopGicSIndustryName(security:list,*args,**kwargs):
    # 获取重仓行业名称(Wind全球行业)
    return w.wss(security,"prt_topgicsindustryname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业名称(Wind)时间序列
    return w.wsd(security,"prt_topindustryname_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameWind(security:list,*args,**kwargs):
    # 获取重仓行业名称(Wind)
    return w.wss(security,"prt_topindustryname_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业名称(中信)时间序列
    return w.wsd(security,"prt_topindustryname_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameCitiC(security:list,*args,**kwargs):
    # 获取重仓行业名称(中信)
    return w.wss(security,"prt_topindustryname_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业名称(申万)时间序列
    return w.wsd(security,"prt_topindustryname_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopIndustryNameSw(security:list,*args,**kwargs):
    # 获取重仓行业名称(申万)
    return w.wss(security,"prt_topindustryname_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustrySymbol2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业代码时间序列
    return w.wsd(security,"prt_stockvalue_topindustrysymbol2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustrySymbol2(security:list,*args,**kwargs):
    # 获取重仓行业代码
    return w.wss(security,"prt_stockvalue_topindustrysymbol2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryValue2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓行业市值时间序列
    return w.wsd(security,"prt_stockvalue_topindustryvalue2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockValueTopIndustryValue2(security:list,*args,**kwargs):
    # 获取重仓行业市值
    return w.wss(security,"prt_stockvalue_topindustryvalue2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期末持有股票个数(中报、年报)时间序列
    return w.wsd(security,"prt_stockholding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockHolding(security:list,*args,**kwargs):
    # 获取报告期末持有股票个数(中报、年报)
    return w.wss(security,"prt_stockholding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtShareNumStKhlDGStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期不同持仓风格股票只数时间序列
    return w.wsd(security,"prt_sharenum_stkhldgstyle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtShareNumStKhlDGStyle(security:list,*args,**kwargs):
    # 获取报告期不同持仓风格股票只数
    return w.wss(security,"prt_sharenum_stkhldgstyle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股股票名称时间序列
    return w.wsd(security,"prt_topstockname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockName(security:list,*args,**kwargs):
    # 获取重仓股股票名称
    return w.wss(security,"prt_topstockname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股股票代码时间序列
    return w.wsd(security,"prt_topstockcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockCode(security:list,*args,**kwargs):
    # 获取重仓股股票代码
    return w.wss(security,"prt_topstockcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最早重仓时间时间序列
    return w.wsd(security,"prt_topstockdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockDate(security:list,*args,**kwargs):
    # 获取最早重仓时间
    return w.wss(security,"prt_topstockdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股持股数量时间序列
    return w.wsd(security,"prt_topstockquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockQuantity(security:list,*args,**kwargs):
    # 获取重仓股持股数量
    return w.wss(security,"prt_topstockquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股持股市值时间序列
    return w.wsd(security,"prt_topstockvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockValue(security:list,*args,**kwargs):
    # 获取重仓股持股市值
    return w.wss(security,"prt_topstockvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockHoldingChangingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股持仓变动时间序列
    return w.wsd(security,"prt_topstockholdingchanging",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockHoldingChanging(security:list,*args,**kwargs):
    # 获取重仓股持仓变动
    return w.wss(security,"prt_topstockholdingchanging",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopProportionToFloatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股持仓占流通股比例时间序列
    return w.wsd(security,"prt_topproportiontofloating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopProportionToFloating(security:list,*args,**kwargs):
    # 获取重仓股持仓占流通股比例
    return w.wss(security,"prt_topproportiontofloating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfStocksSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股票持有基金数时间序列
    return w.wsd(security,"prt_fundnoofstocks",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfStocks(security:list,*args,**kwargs):
    # 获取重仓股票持有基金数
    return w.wss(security,"prt_fundnoofstocks",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockHeldNoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓股报告期重仓次数时间序列
    return w.wsd(security,"prt_topstockheldno",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopStockHeldNo(security:list,*args,**kwargs):
    # 获取重仓股报告期重仓次数
    return w.wss(security,"prt_topstockheldno",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBuyStockCostSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期买入股票总成本时间序列
    return w.wsd(security,"prt_buystockcost",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtBuyStockCost(security:list,*args,**kwargs):
    # 获取报告期买入股票总成本
    return w.wss(security,"prt_buystockcost",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSellStockIncomeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期卖出股票总收入时间序列
    return w.wsd(security,"prt_sellstockincome",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtSellStockIncome(security:list,*args,**kwargs):
    # 获取报告期卖出股票总收入
    return w.wss(security,"prt_sellstockincome",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockVolumeByBrokerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票成交金额(分券商明细)时间序列
    return w.wsd(security,"prt_stockvolumebybroker",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtStockVolumeByBroker(security:list,*args,**kwargs):
    # 获取股票成交金额(分券商明细)
    return w.wss(security,"prt_stockvolumebybroker",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券名称时间序列
    return w.wsd(security,"prt_topbondname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondName(security:list,*args,**kwargs):
    # 获取重仓债券名称
    return w.wss(security,"prt_topbondname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondSymbolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券代码时间序列
    return w.wsd(security,"prt_topbondsymbol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondSymbol(security:list,*args,**kwargs):
    # 获取重仓债券代码
    return w.wss(security,"prt_topbondsymbol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券持仓数量时间序列
    return w.wsd(security,"prt_topbondquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondQuantity(security:list,*args,**kwargs):
    # 获取重仓债券持仓数量
    return w.wss(security,"prt_topbondquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券持仓市值时间序列
    return w.wsd(security,"prt_topbondvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondValue(security:list,*args,**kwargs):
    # 获取重仓债券持仓市值
    return w.wss(security,"prt_topbondvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondHoldingChangingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券持仓变动时间序列
    return w.wsd(security,"prt_topbondholdingchanging",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopBondHoldingChanging(security:list,*args,**kwargs):
    # 获取重仓债券持仓变动
    return w.wss(security,"prt_topbondholdingchanging",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfBondsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓债券持有基金数时间序列
    return w.wsd(security,"prt_fundnoofbonds",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfBonds(security:list,*args,**kwargs):
    # 获取重仓债券持有基金数
    return w.wss(security,"prt_fundnoofbonds",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券名称时间序列
    return w.wsd(security,"prt_topabsname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsName(security:list,*args,**kwargs):
    # 获取重仓资产支持证券名称
    return w.wss(security,"prt_topabsname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsSymbolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券代码时间序列
    return w.wsd(security,"prt_topabssymbol",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsSymbol(security:list,*args,**kwargs):
    # 获取重仓资产支持证券代码
    return w.wss(security,"prt_topabssymbol",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券持仓数量时间序列
    return w.wsd(security,"prt_topabsquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsQuantity(security:list,*args,**kwargs):
    # 获取重仓资产支持证券持仓数量
    return w.wss(security,"prt_topabsquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券持有市值时间序列
    return w.wsd(security,"prt_topabsvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsValue(security:list,*args,**kwargs):
    # 获取重仓资产支持证券持有市值
    return w.wss(security,"prt_topabsvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsHoldingChangingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓资产支持证券持仓变动时间序列
    return w.wsd(security,"prt_topabsholdingchanging",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopAbsHoldingChanging(security:list,*args,**kwargs):
    # 获取重仓资产支持证券持仓变动
    return w.wss(security,"prt_topabsholdingchanging",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金名称时间序列
    return w.wsd(security,"prt_topfundname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundName(security:list,*args,**kwargs):
    # 获取重仓基金名称
    return w.wss(security,"prt_topfundname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金代码时间序列
    return w.wsd(security,"prt_topfundcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundCode(security:list,*args,**kwargs):
    # 获取重仓基金代码
    return w.wss(security,"prt_topfundcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金持仓数量时间序列
    return w.wsd(security,"prt_topfundquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundQuantity(security:list,*args,**kwargs):
    # 获取重仓基金持仓数量
    return w.wss(security,"prt_topfundquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金持有市值时间序列
    return w.wsd(security,"prt_topfundvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundValue(security:list,*args,**kwargs):
    # 获取重仓基金持有市值
    return w.wss(security,"prt_topfundvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundHoldingChangingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金持仓变动时间序列
    return w.wsd(security,"prt_topfundholdingchanging",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtTopFundHoldingChanging(security:list,*args,**kwargs):
    # 获取重仓基金持仓变动
    return w.wss(security,"prt_topfundholdingchanging",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfFundsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重仓基金持有基金数时间序列
    return w.wsd(security,"prt_fundnooffunds",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundNoOfFunds(security:list,*args,**kwargs):
    # 获取重仓基金持有基金数
    return w.wss(security,"prt_fundnooffunds",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFrequencyOfDeviationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内偏离度的绝对值在0.25%(含)-0.5%间的次数时间序列
    return w.wsd(security,"mmfrequencyofdeviation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmFrequencyOfDeviation(security:list,*args,**kwargs):
    # 获取报告期内偏离度的绝对值在0.25%(含)-0.5%间的次数
    return w.wss(security,"mmfrequencyofdeviation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmMaxDeviationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内偏离度的最高值时间序列
    return w.wsd(security,"mmmaxdeviation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmMaxDeviation(security:list,*args,**kwargs):
    # 获取报告期内偏离度的最高值
    return w.wss(security,"mmmaxdeviation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmmInDeviationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内偏离度的最低值时间序列
    return w.wsd(security,"mmmindeviation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmmInDeviation(security:list,*args,**kwargs):
    # 获取报告期内偏离度的最低值
    return w.wss(security,"mmmindeviation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgDeviationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期内每个工作日偏离度的绝对值的简单平均值时间序列
    return w.wsd(security,"mmavgdeviation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMmAvgDeviation(security:list,*args,**kwargs):
    # 获取报告期内每个工作日偏离度的绝对值的简单平均值
    return w.wss(security,"mmavgdeviation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsEValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产估值时间序列
    return w.wsd(security,"fund_reitsevalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsEValue(security:list,*args,**kwargs):
    # 获取资产估值
    return w.wss(security,"fund_reitsevalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsDIsTrAmountFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取可供分配金额(预测)时间序列
    return w.wsd(security,"fund_reitsdistramountf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsDIsTrAmountF(security:list,*args,**kwargs):
    # 获取可供分配金额(预测)
    return w.wss(security,"fund_reitsdistramountf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsDprFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取派息率(预测)时间序列
    return w.wsd(security,"fund_reitsdprf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsDprF(security:list,*args,**kwargs):
    # 获取派息率(预测)
    return w.wss(security,"fund_reitsdprf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeAdminSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合管理人员人数时间序列
    return w.wsd(security,"employee_admin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeAdmin(security:list,*args,**kwargs):
    # 获取综合管理人员人数
    return w.wss(security,"employee_admin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeAdminPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合管理人员人数占比时间序列
    return w.wsd(security,"employee_admin_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeAdminPct(security:list,*args,**kwargs):
    # 获取综合管理人员人数占比
    return w.wss(security,"employee_admin_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInSur9Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合成本率(产险)时间序列
    return w.wsd(security,"stmnote_insur_9",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteInSur9(security:list,*args,**kwargs):
    # 获取综合成本率(产险)
    return w.wss(security,"stmnote_insur_9",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212507Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合偿付能力溢额时间序列
    return w.wsd(security,"qstmnote_insur_212507",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212507(security:list,*args,**kwargs):
    # 获取综合偿付能力溢额
    return w.wss(security,"qstmnote_insur_212507",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212508Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合偿付能力充足率时间序列
    return w.wsd(security,"qstmnote_insur_212508",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212508(security:list,*args,**kwargs):
    # 获取综合偿付能力充足率
    return w.wss(security,"qstmnote_insur_212508",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212534Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:3个月内时间序列
    return w.wsd(security,"qstmnote_insur_212534",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212534(security:list,*args,**kwargs):
    # 获取综合流动比率:3个月内
    return w.wss(security,"qstmnote_insur_212534",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212535Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:1年内时间序列
    return w.wsd(security,"qstmnote_insur_212535",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212535(security:list,*args,**kwargs):
    # 获取综合流动比率:1年内
    return w.wss(security,"qstmnote_insur_212535",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212536Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:1年以上时间序列
    return w.wsd(security,"qstmnote_insur_212536",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212536(security:list,*args,**kwargs):
    # 获取综合流动比率:1年以上
    return w.wss(security,"qstmnote_insur_212536",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212537Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:1-3年内时间序列
    return w.wsd(security,"qstmnote_insur_212537",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212537(security:list,*args,**kwargs):
    # 获取综合流动比率:1-3年内
    return w.wss(security,"qstmnote_insur_212537",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212538Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:3-5年内时间序列
    return w.wsd(security,"qstmnote_insur_212538",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212538(security:list,*args,**kwargs):
    # 获取综合流动比率:3-5年内
    return w.wss(security,"qstmnote_insur_212538",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212539Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合流动比率:5年以上时间序列
    return w.wsd(security,"qstmnote_insur_212539",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212539(security:list,*args,**kwargs):
    # 获取综合流动比率:5年以上
    return w.wss(security,"qstmnote_insur_212539",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDComPrIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合收益_GSD时间序列
    return w.wsd(security,"wgsd_compr_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDComPrInc(security:list,*args,**kwargs):
    # 获取综合收益_GSD
    return w.wss(security,"wgsd_compr_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07IsReItsGeneralProfitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取综合收益总额时间序列
    return w.wsd(security,"stm07_is_reits_generalprofit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStm07IsReItsGeneralProfit(security:list,*args,**kwargs):
    # 获取综合收益总额
    return w.wss(security,"stm07_is_reits_generalprofit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingMarketAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市场综合3年评级时间序列
    return w.wsd(security,"rating_marketavg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingMarketAvg(security:list,*args,**kwargs):
    # 获取市场综合3年评级
    return w.wss(security,"rating_marketavg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDComEqForExChSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他综合性收益_GSD时间序列
    return w.wsd(security,"wgsd_com_eq_for_exch",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDComEqForExCh(security:list,*args,**kwargs):
    # 获取其他综合性收益_GSD
    return w.wss(security,"wgsd_com_eq_for_exch",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherCompRehIncBsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他综合收益_BS时间序列
    return w.wsd(security,"other_compreh_inc_bs",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherCompRehIncBs(security:list,*args,**kwargs):
    # 获取其他综合收益_BS
    return w.wss(security,"other_compreh_inc_bs",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherCompRehIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他综合收益时间序列
    return w.wsd(security,"other_compreh_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherCompRehInc(security:list,*args,**kwargs):
    # 获取其他综合收益
    return w.wss(security,"other_compreh_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGEwa01004Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取废水综合利用率时间序列
    return w.wsd(security,"esg_ewa01004",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGEwa01004(security:list,*args,**kwargs):
    # 获取废水综合利用率
    return w.wss(security,"esg_ewa01004",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingWindAvgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Wind综合评级时间序列
    return w.wsd(security,"rating_windavg",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingWindAvg(security:list,*args,**kwargs):
    # 获取Wind综合评级
    return w.wss(security,"rating_windavg",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaComPrIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.综合收益_GSD时间序列
    return w.wsd(security,"wgsd_qfa_compr_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaComPrInc(security:list,*args,**kwargs):
    # 获取单季度.综合收益_GSD
    return w.wss(security,"wgsd_qfa_compr_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.综合收益总额时间序列
    return w.wsd(security,"qfa_tot_compreh_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehInc(security:list,*args,**kwargs):
    # 获取单季度.综合收益总额
    return w.wss(security,"qfa_tot_compreh_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212529Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取最近一次风险综合评级类别时间序列
    return w.wsd(security,"qstmnote_insur_212529",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQStmNoteInSur212529(security:list,*args,**kwargs):
    # 获取最近一次风险综合评级类别
    return w.wss(security,"qstmnote_insur_212529",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCompRehIncParentCompSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取归属普通股东综合收益_GSD时间序列
    return w.wsd(security,"wgsd_compreh_inc_parent_comp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDCompRehIncParentComp(security:list,*args,**kwargs):
    # 获取归属普通股东综合收益_GSD
    return w.wss(security,"wgsd_compreh_inc_parent_comp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOtherCompRehIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.其他综合收益时间序列
    return w.wsd(security,"qfa_other_compreh_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaOtherCompRehInc(security:list,*args,**kwargs):
    # 获取单季度.其他综合收益
    return w.wss(security,"qfa_other_compreh_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDTenantReImExpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取租户认缴物业维护综合费_GSD时间序列
    return w.wsd(security,"wgsd_tenant_reim_exp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDTenantReImExp(security:list,*args,**kwargs):
    # 获取租户认缴物业维护综合费_GSD
    return w.wss(security,"wgsd_tenant_reim_exp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getToTCompRehIncMinSHrhLDrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取归属于少数股东的综合收益总额时间序列
    return w.wsd(security,"tot_compreh_inc_min_shrhldr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getToTCompRehIncMinSHrhLDr(security:list,*args,**kwargs):
    # 获取归属于少数股东的综合收益总额
    return w.wss(security,"tot_compreh_inc_min_shrhldr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGScoreWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取Wind ESG综合得分时间序列
    return w.wsd(security,"esg_score_wind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGScoreWind(security:list,*args,**kwargs):
    # 获取Wind ESG综合得分
    return w.wss(security,"esg_score_wind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingShanghaiOverall3YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上海证券3年评级(综合评级)时间序列
    return w.wsd(security,"rating_shanghaioverall3y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingShanghaiOverall3Y(security:list,*args,**kwargs):
    # 获取上海证券3年评级(综合评级)
    return w.wss(security,"rating_shanghaioverall3y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingShanghaiOverall5YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上海证券5年评级(综合评级)时间序列
    return w.wsd(security,"rating_shanghaioverall5y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingShanghaiOverall5Y(security:list,*args,**kwargs):
    # 获取上海证券5年评级(综合评级)
    return w.wss(security,"rating_shanghaioverall5y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaCompRehIncParentCompSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.归属普通股东综合收益_GSD时间序列
    return w.wsd(security,"wgsd_qfa_compreh_inc_parent_comp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaCompRehIncParentComp(security:list,*args,**kwargs):
    # 获取单季度.归属普通股东综合收益_GSD
    return w.wss(security,"wgsd_qfa_compreh_inc_parent_comp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getToTCompRehIncParentCompSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取归属于母公司普通股东综合收益总额时间序列
    return w.wsd(security,"tot_compreh_inc_parent_comp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getToTCompRehIncParentComp(security:list,*args,**kwargs):
    # 获取归属于母公司普通股东综合收益总额
    return w.wss(security,"tot_compreh_inc_parent_comp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaTenantReImExpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.租户认缴物业维护综合费_GSD时间序列
    return w.wsd(security,"wgsd_qfa_tenant_reim_exp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaTenantReImExp(security:list,*args,**kwargs):
    # 获取单季度.租户认缴物业维护综合费_GSD
    return w.wss(security,"wgsd_qfa_tenant_reim_exp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehIncMinSHrhLDrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.归属于少数股东的综合收益总额时间序列
    return w.wsd(security,"qfa_tot_compreh_inc_min_shrhldr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehIncMinSHrhLDr(security:list,*args,**kwargs):
    # 获取单季度.归属于少数股东的综合收益总额
    return w.wss(security,"qfa_tot_compreh_inc_min_shrhldr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehIncParentCompSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.归属于母公司普通股东综合收益总额时间序列
    return w.wsd(security,"qfa_tot_compreh_inc_parent_comp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQfaToTCompRehIncParentComp(security:list,*args,**kwargs):
    # 获取单季度.归属于母公司普通股东综合收益总额
    return w.wss(security,"qfa_tot_compreh_inc_parent_comp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinAssetsChgCompRehIncSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取以公允价值计量且其变动计入其他综合收益的金融资产时间序列
    return w.wsd(security,"fin_assets_chg_compreh_inc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinAssetsChgCompRehInc(security:list,*args,**kwargs):
    # 获取以公允价值计量且其变动计入其他综合收益的金融资产
    return w.wss(security,"fin_assets_chg_compreh_inc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityAddSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会保险费:本期增加时间序列
    return w.wsd(security,"stmnote_socialsecurity_add",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityAdd(security:list,*args,**kwargs):
    # 获取社会保险费:本期增加
    return w.wss(security,"stmnote_socialsecurity_add",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecuritySbSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会保险费:期初余额时间序列
    return w.wsd(security,"stmnote_socialsecurity_sb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecuritySb(security:list,*args,**kwargs):
    # 获取社会保险费:期初余额
    return w.wss(security,"stmnote_socialsecurity_sb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityEbSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会保险费:期末余额时间序列
    return w.wsd(security,"stmnote_socialsecurity_eb",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityEb(security:list,*args,**kwargs):
    # 获取社会保险费:期末余额
    return w.wss(security,"stmnote_socialsecurity_eb",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityDeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会保险费:本期减少时间序列
    return w.wsd(security,"stmnote_socialsecurity_de",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSocialSecurityDe(security:list,*args,**kwargs):
    # 获取社会保险费:本期减少
    return w.wss(security,"stmnote_socialsecurity_de",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGRatingCasViSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社会价值投资联盟ESG评级时间序列
    return w.wsd(security,"esg_rating_casvi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGRatingCasVi(security:list,*args,**kwargs):
    # 获取社会价值投资联盟ESG评级
    return w.wss(security,"esg_rating_casvi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegisterNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取统一社会信用代码时间序列
    return w.wsd(security,"registernumber",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegisterNumber(security:list,*args,**kwargs):
    # 获取统一社会信用代码
    return w.wss(security,"registernumber",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGMdc01002Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司是否有独立的公司社会责任报告时间序列
    return w.wsd(security,"esg_mdc01002",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGMdc01002(security:list,*args,**kwargs):
    # 获取公司是否有独立的公司社会责任报告
    return w.wss(security,"esg_mdc01002",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingYinHe1YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)银河1年评级时间序列
    return w.wsd(security,"rating_yinhe1y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingYinHe1Y(security:list,*args,**kwargs):
    # 获取(停止)银河1年评级
    return w.wss(security,"rating_yinhe1y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingYinHe2YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)银河2年评级时间序列
    return w.wsd(security,"rating_yinhe2y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingYinHe2Y(security:list,*args,**kwargs):
    # 获取(停止)银河2年评级
    return w.wss(security,"rating_yinhe2y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingZhaoShang3YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)招商3年评级时间序列
    return w.wsd(security,"rating_zhaoshang3y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingZhaoShang3Y(security:list,*args,**kwargs):
    # 获取(停止)招商3年评级
    return w.wss(security,"rating_zhaoshang3y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingHaiTong3YSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)海通3年评级时间序列
    return w.wsd(security,"rating_haitong3y",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRatingHaiTong3Y(security:list,*args,**kwargs):
    # 获取(停止)海通3年评级
    return w.wss(security,"rating_haitong3y",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)投资风格时间序列
    return w.wsd(security,"fund_investstyle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestStyle(security:list,*args,**kwargs):
    # 获取(停止)投资风格
    return w.wss(security,"fund_investstyle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryGxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)所属国信行业名称时间序列
    return w.wsd(security,"industry_gx",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryGx(security:list,*args,**kwargs):
    # 获取(停止)所属国信行业名称
    return w.wss(security,"industry_gx",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondScoreSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)债券评分时间序列
    return w.wsd(security,"bondscore",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondScore(security:list,*args,**kwargs):
    # 获取(停止)债券评分
    return w.wss(security,"bondscore",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuersCoreSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)发行人评分时间序列
    return w.wsd(security,"issuerscore",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuersCore(security:list,*args,**kwargs):
    # 获取(停止)发行人评分
    return w.wss(security,"issuerscore",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbstractSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(停止)公司一句话介绍时间序列
    return w.wsd(security,"abstract",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbstract(security:list,*args,**kwargs):
    # 获取(停止)公司一句话介绍
    return w.wss(security,"abstract",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerTotalGeometricReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)任职基金几何总回报时间序列
    return w.wsd(security,"fund_manager_totalgeometricreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagerTotalGeometricReturn(security:list,*args,**kwargs):
    # 获取(废弃)任职基金几何总回报
    return w.wss(security,"fund_manager_totalgeometricreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowNetPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)净值价格时间序列
    return w.wsd(security,"fellow_netprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowNetPrice(security:list,*args,**kwargs):
    # 获取(废弃)净值价格
    return w.wss(security,"fellow_netprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDefaultSourceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)估值来源时间序列
    return w.wsd(security,"defaultsource",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDefaultSource(security:list,*args,**kwargs):
    # 获取(废弃)估值来源
    return w.wss(security,"defaultsource",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTheOPricePerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)区间理论价时间序列
    return w.wsd(security,"theo_price_per",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTheOPricePer(security:list,*args,**kwargs):
    # 获取(废弃)区间理论价
    return w.wss(security,"theo_price_per",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs83Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)基金投资收益时间序列
    return w.wsd(security,"stm_is_83",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmIs83(security:list,*args,**kwargs):
    # 获取(废弃)基金投资收益
    return w.wss(security,"stm_is_83",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmFocusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)累计关注人数_雪球时间序列
    return w.wsd(security,"xq_accmfocus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmFocus(security:list,*args,**kwargs):
    # 获取(废弃)累计关注人数_雪球
    return w.wss(security,"xq_accmfocus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmCommentsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)累计讨论次数_雪球时间序列
    return w.wsd(security,"xq_accmcomments",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmComments(security:list,*args,**kwargs):
    # 获取(废弃)累计讨论次数_雪球
    return w.wss(security,"xq_accmcomments",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)累计交易分享数_雪球时间序列
    return w.wsd(security,"xq_accmshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQACcmShares(security:list,*args,**kwargs):
    # 获取(废弃)累计交易分享数_雪球
    return w.wss(security,"xq_accmshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQFocusAddedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周新增关注_雪球时间序列
    return w.wsd(security,"xq_focusadded",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQFocusAdded(security:list,*args,**kwargs):
    # 获取(废弃)一周新增关注_雪球
    return w.wss(security,"xq_focusadded",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQCommentsAddedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周新增讨论数_雪球时间序列
    return w.wsd(security,"xq_commentsadded",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQCommentsAdded(security:list,*args,**kwargs):
    # 获取(废弃)一周新增讨论数_雪球
    return w.wss(security,"xq_commentsadded",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQSharesAddedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周新增交易分享数_雪球时间序列
    return w.wsd(security,"xq_sharesadded",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQSharesAdded(security:list,*args,**kwargs):
    # 获取(废弃)一周新增交易分享数_雪球
    return w.wss(security,"xq_sharesadded",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowFocusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周关注增长率_雪球时间序列
    return w.wsd(security,"xq_WOW_focus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowFocus(security:list,*args,**kwargs):
    # 获取(废弃)一周关注增长率_雪球
    return w.wss(security,"xq_WOW_focus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowCommentsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周讨论增长率_雪球时间序列
    return w.wsd(security,"xq_WOW_comments",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowComments(security:list,*args,**kwargs):
    # 获取(废弃)一周讨论增长率_雪球
    return w.wss(security,"xq_WOW_comments",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)一周交易分享增长率_雪球时间序列
    return w.wsd(security,"xq_WOW_shares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getXQWowShares(security:list,*args,**kwargs):
    # 获取(废弃)一周交易分享增长率_雪球
    return w.wss(security,"xq_WOW_shares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)大股东类型时间序列
    return w.wsd(security,"sharecategory",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareCategory(security:list,*args,**kwargs):
    # 获取(废弃)大股东类型
    return w.wss(security,"sharecategory",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrC12Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)所属证监会行业名称时间序列
    return w.wsd(security,"industry_CSRC12",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrC12(security:list,*args,**kwargs):
    # 获取(废弃)所属证监会行业名称
    return w.wss(security,"industry_CSRC12",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPayOutRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年度现金分红比例(沪深)时间序列
    return w.wsd(security,"div_payoutratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDivPayOutRatio(security:list,*args,**kwargs):
    # 获取年度现金分红比例(沪深)
    return w.wss(security,"div_payoutratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非流通股(沪深)时间序列
    return w.wsd(security,"share_nontradable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradable(security:list,*args,**kwargs):
    # 获取非流通股(沪深)
    return w.wss(security,"share_nontradable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYieldCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价收益率(中证指数)(旧)时间序列
    return w.wsd(security,"yield_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getYieldCsi(security:list,*args,**kwargs):
    # 获取估价收益率(中证指数)(旧)
    return w.wss(security,"yield_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价净价(中证指数)(旧)时间序列
    return w.wsd(security,"net_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNetCsi(security:list,*args,**kwargs):
    # 获取估价净价(中证指数)(旧)
    return w.wss(security,"net_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirtyCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价全价(中证指数)(旧)时间序列
    return w.wsd(security,"dirty_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirtyCsi(security:list,*args,**kwargs):
    # 获取估价全价(中证指数)(旧)
    return w.wss(security,"dirty_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getModiDuraCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价修正久期(中证指数)(旧)时间序列
    return w.wsd(security,"modidura_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getModiDuraCsi(security:list,*args,**kwargs):
    # 获取估价修正久期(中证指数)(旧)
    return w.wss(security,"modidura_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCNvXTyCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价凸性(中证指数)(旧)时间序列
    return w.wsd(security,"cnvxty_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCNvXTyCsi(security:list,*args,**kwargs):
    # 获取估价凸性(中证指数)(旧)
    return w.wss(security,"cnvxty_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNetCollectionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发募集资金净额(旧)时间序列
    return w.wsd(security,"ipo_netcollection",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoNetCollection(security:list,*args,**kwargs):
    # 获取首发募集资金净额(旧)
    return w.wss(security,"ipo_netcollection",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发价格(旧)时间序列
    return w.wsd(security,"ipo_price",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPrice(security:list,*args,**kwargs):
    # 获取首发价格(旧)
    return w.wss(security,"ipo_price",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpectedCollectionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发预计募集资金(旧)时间序列
    return w.wsd(security,"ipo_expectedcollection",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoExpectedCollection(security:list,*args,**kwargs):
    # 获取首发预计募集资金(旧)
    return w.wss(security,"ipo_expectedcollection",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoCollectionOldSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股东售股金额(旧)时间序列
    return w.wsd(security,"ipo_collection_oldshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoCollectionOldShares(security:list,*args,**kwargs):
    # 获取股东售股金额(旧)
    return w.wss(security,"ipo_collection_oldshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoUsFeesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发承销保荐费用(旧)时间序列
    return w.wsd(security,"ipo_usfees",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoUsFees(security:list,*args,**kwargs):
    # 获取首发承销保荐费用(旧)
    return w.wss(security,"ipo_usfees",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFeeDiscountOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)是否费率优惠时间序列
    return w.wsd(security,"fund_feediscountornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFeeDiscountOrNot(security:list,*args,**kwargs):
    # 获取(废弃)是否费率优惠
    return w.wss(security,"fund_feediscountornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinPurchaseDiscountsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)最低申购折扣费率时间序列
    return w.wsd(security,"fund_minpurchasediscounts",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinPurchaseDiscounts(security:list,*args,**kwargs):
    # 获取(废弃)最低申购折扣费率
    return w.wss(security,"fund_minpurchasediscounts",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinaIpDiscountsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)最低定投折扣率时间序列
    return w.wsd(security,"fund_minaipdiscounts",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinaIpDiscounts(security:list,*args,**kwargs):
    # 获取(废弃)最低定投折扣率
    return w.wss(security,"fund_minaipdiscounts",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGSem01003Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)兼职人员比例时间序列
    return w.wsd(security,"esg_sem01003",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEsGSem01003(security:list,*args,**kwargs):
    # 获取(废弃)兼职人员比例
    return w.wss(security,"esg_sem01003",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPepSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)市盈率百分位时间序列
    return w.wsd(security,"val_pep",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValPep(security:list,*args,**kwargs):
    # 获取(废弃)市盈率百分位
    return w.wss(security,"val_pep",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavWinLossRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)基金盈利概率时间序列
    return w.wsd(security,"NAV_winlossratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavWinLossRatio(security:list,*args,**kwargs):
    # 获取(废弃)基金盈利概率
    return w.wss(security,"NAV_winlossratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaturityDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)基金到期日时间序列
    return w.wsd(security,"fund_maturitydate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaturityDate(security:list,*args,**kwargs):
    # 获取(废弃)基金到期日
    return w.wss(security,"fund_maturitydate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFoundDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)成立日期时间序列
    return w.wsd(security,"founddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFoundDate(security:list,*args,**kwargs):
    # 获取(废弃)成立日期
    return w.wss(security,"founddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLeadUndRNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)主办券商(持续督导)时间序列
    return w.wsd(security,"ipo_leadundr_n",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLeadUndRN(security:list,*args,**kwargs):
    # 获取(废弃)主办券商(持续督导)
    return w.wss(security,"ipo_leadundr_n",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFrMindPDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)公司独立董事(历任)时间序列
    return w.wsd(security,"frmindpdirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFrMindPDirector(security:list,*args,**kwargs):
    # 获取(废弃)公司独立董事(历任)
    return w.wss(security,"frmindpdirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券简称时间序列
    return w.wsd(security,"sec_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecName(security:list,*args,**kwargs):
    # 获取证券简称
    return w.wss(security,"sec_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecName1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券简称(支持历史)时间序列
    return w.wsd(security,"sec_name1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecName1(security:list,*args,**kwargs):
    # 获取证券简称(支持历史)
    return w.wss(security,"sec_name1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecEnglishnameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券英文简称时间序列
    return w.wsd(security,"sec_englishname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecEnglishname(security:list,*args,**kwargs):
    # 获取证券英文简称
    return w.wss(security,"sec_englishname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市日期时间序列
    return w.wsd(security,"ipo_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoDate(security:list,*args,**kwargs):
    # 获取上市日期
    return w.wss(security,"ipo_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBackdoorDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取借壳上市日期时间序列
    return w.wsd(security,"backdoordate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBackdoorDate(security:list,*args,**kwargs):
    # 获取借壳上市日期
    return w.wss(security,"backdoordate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundEtFListedDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取ETF上市日期时间序列
    return w.wsd(security,"fund_etflisteddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundEtFListedDate(security:list,*args,**kwargs):
    # 获取ETF上市日期
    return w.wss(security,"fund_etflisteddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsListedDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取REITs上市日期时间序列
    return w.wsd(security,"fund__reitslisteddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsListedDate(security:list,*args,**kwargs):
    # 获取REITs上市日期
    return w.wss(security,"fund__reitslisteddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoJurisDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下配售部分上市日期时间序列
    return w.wsd(security,"ipo_jurisdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoJurisDate(security:list,*args,**kwargs):
    # 获取网下配售部分上市日期
    return w.wss(security,"ipo_jurisdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoInStIsDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取向战略投资者配售部分上市日期时间序列
    return w.wsd(security,"ipo_instisdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoInStIsDate(security:list,*args,**kwargs):
    # 获取向战略投资者配售部分上市日期
    return w.wss(security,"ipo_instisdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowInStListDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取向机构投资者增发部分上市日期时间序列
    return w.wsd(security,"fellow_instlistdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFellowInStListDate(security:list,*args,**kwargs):
    # 获取向机构投资者增发部分上市日期
    return w.wss(security,"fellow_instlistdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExchangeCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易所中文名称时间序列
    return w.wsd(security,"exchange_cn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExchangeCn(security:list,*args,**kwargs):
    # 获取交易所中文名称
    return w.wss(security,"exchange_cn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExChEngSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易所英文简称时间序列
    return w.wsd(security,"exch_eng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExChEng(security:list,*args,**kwargs):
    # 获取交易所英文简称
    return w.wss(security,"exch_eng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市板时间序列
    return w.wsd(security,"mkt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMkt(security:list,*args,**kwargs):
    # 获取上市板
    return w.wss(security,"mkt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券存续状态时间序列
    return w.wsd(security,"sec_status",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecStatus(security:list,*args,**kwargs):
    # 获取证券存续状态
    return w.wss(security,"sec_status",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskAdmonitionDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取戴帽摘帽时间时间序列
    return w.wsd(security,"riskadmonition_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskAdmonitionDate(security:list,*args,**kwargs):
    # 获取戴帽摘帽时间
    return w.wss(security,"riskadmonition_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeListDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取摘牌日期时间序列
    return w.wsd(security,"delist_date",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDeListDate(security:list,*args,**kwargs):
    # 获取摘牌日期
    return w.wss(security,"delist_date",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCurrencyCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行币种时间序列
    return w.wsd(security,"issuecurrencycode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueCurrencyCode(security:list,*args,**kwargs):
    # 获取发行币种
    return w.wss(security,"issuecurrencycode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCurRSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易币种时间序列
    return w.wsd(security,"curr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCurR(security:list,*args,**kwargs):
    # 获取交易币种
    return w.wss(security,"curr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValBsHrMarketValue4Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取B股市值(含限售股,交易币种)时间序列
    return w.wsd(security,"val_bshrmarketvalue4",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValBsHrMarketValue4(security:list,*args,**kwargs):
    # 获取B股市值(含限售股,交易币种)
    return w.wss(security,"val_bshrmarketvalue4",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValBsHrMarketValue2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取B股市值(不含限售股,交易币种)时间序列
    return w.wsd(security,"val_bshrmarketvalue2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getValBsHrMarketValue2(security:list,*args,**kwargs):
    # 获取B股市值(不含限售股,交易币种)
    return w.wss(security,"val_bshrmarketvalue2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSettlementModeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易结算模式时间序列
    return w.wsd(security,"fund_settlementmode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSettlementMode(security:list,*args,**kwargs):
    # 获取交易结算模式
    return w.wss(security,"fund_settlementmode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getParValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每股面值时间序列
    return w.wsd(security,"parvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getParValue(security:list,*args,**kwargs):
    # 获取每股面值
    return w.wss(security,"parvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoParSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时每股面值时间序列
    return w.wsd(security,"ipo_par",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoPar(security:list,*args,**kwargs):
    # 获取发行时每股面值
    return w.wss(security,"ipo_par",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLotSizeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每手股数时间序列
    return w.wsd(security,"lotsize",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLotSize(security:list,*args,**kwargs):
    # 获取每手股数
    return w.wss(security,"lotsize",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTunItSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易单位时间序列
    return w.wsd(security,"tunit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTunIt(security:list,*args,**kwargs):
    # 获取交易单位
    return w.wss(security,"tunit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCountrySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国家或地区代码时间序列
    return w.wsd(security,"country",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCountry(security:list,*args,**kwargs):
    # 获取所属国家或地区代码
    return w.wss(security,"country",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基期时间序列
    return w.wsd(security,"basedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseDate(security:list,*args,**kwargs):
    # 获取基期
    return w.wss(security,"basedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基点时间序列
    return w.wsd(security,"basevalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseValue(security:list,*args,**kwargs):
    # 获取基点
    return w.wss(security,"basevalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcPvbPSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基点价值时间序列
    return w.wsd(security,"calc_pvbp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcPvbP(security:list,*args,**kwargs):
    # 获取基点价值
    return w.wss(security,"calc_pvbp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVoBpCnBdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价基点价值(中债)时间序列
    return w.wsd(security,"vobp_cnbd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVoBpCnBd(security:list,*args,**kwargs):
    # 获取估价基点价值(中债)
    return w.wss(security,"vobp_cnbd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVoBpShcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取估价基点价值(上清所)时间序列
    return w.wsd(security,"vobp_shc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVoBpShc(security:list,*args,**kwargs):
    # 获取估价基点价值(上清所)
    return w.wss(security,"vobp_shc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnalBasePointValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取平均基点价值时间序列
    return w.wsd(security,"anal_basepointvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnalBasePointValue(security:list,*args,**kwargs):
    # 获取平均基点价值
    return w.wss(security,"anal_basepointvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseValueIfExeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权基点价值时间序列
    return w.wsd(security,"basevalue_ifexe",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseValueIfExe(security:list,*args,**kwargs):
    # 获取行权基点价值
    return w.wss(security,"basevalue_ifexe",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcFloatAddBpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计算浮息债隐含加息基点时间序列
    return w.wsd(security,"calc_floataddbp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcFloatAddBp(security:list,*args,**kwargs):
    # 获取计算浮息债隐含加息基点
    return w.wss(security,"calc_floataddbp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNumberOfConstituentsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成份个数时间序列
    return w.wsd(security,"numberofconstituents",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNumberOfConstituents(security:list,*args,**kwargs):
    # 获取成份个数
    return w.wss(security,"numberofconstituents",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNumberOfConstituents2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成份个数(支持历史)时间序列
    return w.wsd(security,"numberofconstituents2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNumberOfConstituents2(security:list,*args,**kwargs):
    # 获取成份个数(支持历史)
    return w.wss(security,"numberofconstituents2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFirstDayOfConstituentsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最早成份日期时间序列
    return w.wsd(security,"firstdayofconstituents",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFirstDayOfConstituents(security:list,*args,**kwargs):
    # 获取最早成份日期
    return w.wss(security,"firstdayofconstituents",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMethodologySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权方式时间序列
    return w.wsd(security,"methodology",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMethodology(security:list,*args,**kwargs):
    # 获取加权方式
    return w.wss(security,"methodology",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoBriefingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券简介时间序列
    return w.wsd(security,"repo_briefing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoBriefing(security:list,*args,**kwargs):
    # 获取证券简介
    return w.wss(security,"repo_briefing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLaunchDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发布日期时间序列
    return w.wsd(security,"launchdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLaunchDate(security:list,*args,**kwargs):
    # 获取发布日期
    return w.wss(security,"launchdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券曾用名时间序列
    return w.wsd(security,"prename",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPreName(security:list,*args,**kwargs):
    # 获取证券曾用名
    return w.wss(security,"prename",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExChCitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市地点时间序列
    return w.wsd(security,"exch_city",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExChCity(security:list,*args,**kwargs):
    # 获取上市地点
    return w.wss(security,"exch_city",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTrackedByFundsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取跟踪标的基金代码时间序列
    return w.wsd(security,"trackedbyfunds",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTrackedByFunds(security:list,*args,**kwargs):
    # 获取跟踪标的基金代码
    return w.wss(security,"trackedbyfunds",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSuperiorCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上级行业指数代码时间序列
    return w.wsd(security,"superiorcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSuperiorCode(security:list,*args,**kwargs):
    # 获取上级行业指数代码
    return w.wss(security,"superiorcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券代码时间序列
    return w.wsd(security,"trade_code",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTradeCode(security:list,*args,**kwargs):
    # 获取证券代码
    return w.wss(security,"trade_code",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCodeChangeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券代码变更日期时间序列
    return w.wsd(security,"codechangedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCodeChangeDate(security:list,*args,**kwargs):
    # 获取证券代码变更日期
    return w.wss(security,"codechangedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnchorBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主证券代码时间序列
    return w.wsd(security,"anchorbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAnchorBond(security:list,*args,**kwargs):
    # 获取主证券代码
    return w.wss(security,"anchorbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorIndexCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主指数代码时间序列
    return w.wsd(security,"majorindexcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorIndexCode(security:list,*args,**kwargs):
    # 获取主指数代码
    return w.wss(security,"majorindexcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSubIndexCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取副指数代码时间序列
    return w.wsd(security,"subindexcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSubIndexCode(security:list,*args,**kwargs):
    # 获取副指数代码
    return w.wss(security,"subindexcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelationCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取跨市场代码时间序列
    return w.wsd(security,"relationCode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRelationCode(security:list,*args,**kwargs):
    # 获取跨市场代码
    return w.wss(security,"relationCode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBcLcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司债对应上市公司代码时间序列
    return w.wsd(security,"bclc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBcLc(security:list,*args,**kwargs):
    # 获取公司债对应上市公司代码
    return w.wss(security,"bclc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTendRstCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中债招标发行代码时间序列
    return w.wsd(security,"tendrst_code",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTendRstCode(security:list,*args,**kwargs):
    # 获取中债招标发行代码
    return w.wss(security,"tendrst_code",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSzSeDistRibCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取深交所分销代码时间序列
    return w.wsd(security,"szse_distribcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSzSeDistRibCode(security:list,*args,**kwargs):
    # 获取深交所分销代码
    return w.wss(security,"szse_distribcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同公司可转债简称时间序列
    return w.wsd(security,"cbname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbName(security:list,*args,**kwargs):
    # 获取同公司可转债简称
    return w.wss(security,"cbname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsShareNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同公司美股简称时间序列
    return w.wsd(security,"ussharename",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUsShareName(security:list,*args,**kwargs):
    # 获取同公司美股简称
    return w.wss(security,"ussharename",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStockClassSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股票种类时间序列
    return w.wsd(security,"stockclass",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStockClass(security:list,*args,**kwargs):
    # 获取股票种类
    return w.wss(security,"stockclass",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoIssuingSystemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行制度时间序列
    return w.wsd(security,"ipo_issuingsystem",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoIssuingSystem(security:list,*args,**kwargs):
    # 获取发行制度
    return w.wss(security,"ipo_issuingsystem",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListsTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属上市标准时间序列
    return w.wsd(security,"liststd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListsTd(security:list,*args,**kwargs):
    # 获取所属上市标准
    return w.wss(security,"liststd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFeaturedListsTdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取北交所准入标准时间序列
    return w.wsd(security,"featuredliststd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFeaturedListsTd(security:list,*args,**kwargs):
    # 获取北交所准入标准
    return w.wss(security,"featuredliststd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompIndex2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否属于重要指数成份时间序列
    return w.wsd(security,"compindex2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompIndex2(security:list,*args,**kwargs):
    # 获取是否属于重要指数成份
    return w.wss(security,"compindex2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConceptSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属概念板块时间序列
    return w.wsd(security,"concept",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConcept(security:list,*args,**kwargs):
    # 获取所属概念板块
    return w.wss(security,"concept",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getScaleStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属规模风格类型时间序列
    return w.wsd(security,"scalestyle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getScaleStyle(security:list,*args,**kwargs):
    # 获取所属规模风格类型
    return w.wss(security,"scalestyle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShScSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否沪港通买入标的时间序列
    return w.wsd(security,"SHSC",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShSc(security:list,*args,**kwargs):
    # 获取是否沪港通买入标的
    return w.wss(security,"SHSC",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShSc2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否深港通买入标的时间序列
    return w.wsd(security,"SHSC2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShSc2(security:list,*args,**kwargs):
    # 获取是否深港通买入标的
    return w.wss(security,"SHSC2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getParallelCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否并行代码时间序列
    return w.wsd(security,"parallelcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getParallelCode(security:list,*args,**kwargs):
    # 获取是否并行代码
    return w.wss(security,"parallelcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券类型时间序列
    return w.wsd(security,"sec_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSecType(security:list,*args,**kwargs):
    # 获取证券类型
    return w.wss(security,"sec_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBackdoorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否借壳上市时间序列
    return w.wsd(security,"backdoor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBackdoor(security:list,*args,**kwargs):
    # 获取是否借壳上市
    return w.wss(security,"backdoor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否上市时间序列
    return w.wsd(security,"list",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getList(security:list,*args,**kwargs):
    # 获取是否上市
    return w.wss(security,"list",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListingOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否上市公司时间序列
    return w.wsd(security,"listingornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListingOrNot(security:list,*args,**kwargs):
    # 获取是否上市公司
    return w.wss(security,"listingornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskWarningSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否属于风险警示板时间序列
    return w.wsd(security,"riskwarning",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRiskWarning(security:list,*args,**kwargs):
    # 获取是否属于风险警示板
    return w.wss(security,"riskwarning",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOfficialStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指数风格时间序列
    return w.wsd(security,"officialstyle",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOfficialStyle(security:list,*args,**kwargs):
    # 获取指数风格
    return w.wss(security,"officialstyle",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChainSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属产业链板块时间序列
    return w.wsd(security,"chain",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChain(security:list,*args,**kwargs):
    # 获取所属产业链板块
    return w.wss(security,"chain",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLargeCommoditySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属大宗商品概念板块时间序列
    return w.wsd(security,"largecommodity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLargeCommodity(security:list,*args,**kwargs):
    # 获取所属大宗商品概念板块
    return w.wss(security,"largecommodity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDepositAryBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取存托机构时间序列
    return w.wsd(security,"depositarybank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDepositAryBank(security:list,*args,**kwargs):
    # 获取存托机构
    return w.wss(security,"depositarybank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLeadUndRN1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主办券商(持续督导)时间序列
    return w.wsd(security,"ipo_leadundr_n1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLeadUndRN1(security:list,*args,**kwargs):
    # 获取主办券商(持续督导)
    return w.wss(security,"ipo_leadundr_n1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoMarketMakerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取做市商名称时间序列
    return w.wsd(security,"ipo_marketMaker",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoMarketMaker(security:list,*args,**kwargs):
    # 获取做市商名称
    return w.wss(security,"ipo_marketMaker",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarketMakeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取做市首日时间序列
    return w.wsd(security,"marketmakedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarketMakeDate(security:list,*args,**kwargs):
    # 获取做市首日
    return w.wss(security,"marketmakedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTransferTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取交易类型时间序列
    return w.wsd(security,"transfertype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTransferType(security:list,*args,**kwargs):
    # 获取交易类型
    return w.wss(security,"transfertype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqMarketMakerNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取做市商家数时间序列
    return w.wsd(security,"neeq_marketmakernum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqMarketMakerNum(security:list,*args,**kwargs):
    # 获取做市商家数
    return w.wss(security,"neeq_marketmakernum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqParkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌园区时间序列
    return w.wsd(security,"neeq_park",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqPark(security:list,*args,**kwargs):
    # 获取挂牌园区
    return w.wss(security,"neeq_park",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListAnnDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌公告日时间序列
    return w.wsd(security,"neeq_listanndate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListAnnDate(security:list,*args,**kwargs):
    # 获取挂牌公告日
    return w.wss(security,"neeq_listanndate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqMarketMakeAnnDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转做市公告日时间序列
    return w.wsd(security,"neeq_marketmakeanndate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqMarketMakeAnnDate(security:list,*args,**kwargs):
    # 获取转做市公告日
    return w.wss(security,"neeq_marketmakeanndate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属挂牌公司投资型行业名称时间序列
    return w.wsd(security,"industry_neeqgics",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcs(security:list,*args,**kwargs):
    # 获取所属挂牌公司投资型行业名称
    return w.wss(security,"industry_neeqgics",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcsCodeInvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属挂牌公司投资型行业代码时间序列
    return w.wsd(security,"industry_neeqgicscode_inv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcsCodeInv(security:list,*args,**kwargs):
    # 获取所属挂牌公司投资型行业代码
    return w.wss(security,"industry_neeqgicscode_inv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcsCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属挂牌公司投资型行业板块代码时间序列
    return w.wsd(security,"industry_neeqgicscode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeeQgIcsCode(security:list,*args,**kwargs):
    # 获取所属挂牌公司投资型行业板块代码
    return w.wss(security,"industry_neeqgicscode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeEqConceptSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属新三板概念类板块时间序列
    return w.wsd(security,"industry_neeqconcept",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNeEqConcept(security:list,*args,**kwargs):
    # 获取所属新三板概念类板块
    return w.wss(security,"industry_neeqconcept",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqLevelSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属分层时间序列
    return w.wsd(security,"neeq_level",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqLevel(security:list,*args,**kwargs):
    # 获取所属分层
    return w.wss(security,"neeq_level",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqStandardSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属创新层标准时间序列
    return w.wsd(security,"neeq_standard",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqStandard(security:list,*args,**kwargs):
    # 获取所属创新层标准
    return w.wss(security,"neeq_standard",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌企业上市辅导券商时间序列
    return w.wsd(security,"ipo_tutor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutor(security:list,*args,**kwargs):
    # 获取挂牌企业上市辅导券商
    return w.wss(security,"ipo_tutor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutoringStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌企业上市辅导开始日期时间序列
    return w.wsd(security,"ipo_tutoring_startdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutoringStartDate(security:list,*args,**kwargs):
    # 获取挂牌企业上市辅导开始日期
    return w.wss(security,"ipo_tutoring_startdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutoringEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌企业上市辅导结束日期时间序列
    return w.wsd(security,"ipo_tutoring_enddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoTutoringEnddate(security:list,*args,**kwargs):
    # 获取挂牌企业上市辅导结束日期
    return w.wss(security,"ipo_tutoring_enddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌日时间序列
    return w.wsd(security,"neeq_listingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListingDate(security:list,*args,**kwargs):
    # 获取挂牌日
    return w.wss(security,"neeq_listingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListDateInnovationLevelSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取创新层挂牌日时间序列
    return w.wsd(security,"neeq_listdate_innovationlevel",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqListDateInnovationLevel(security:list,*args,**kwargs):
    # 获取创新层挂牌日
    return w.wss(security,"neeq_listdate_innovationlevel",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqSuspensionDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取挂牌公司转板北交所前停牌日时间序列
    return w.wsd(security,"neeq_suspensionday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNeEqSuspensionDay(security:list,*args,**kwargs):
    # 获取挂牌公司转板北交所前停牌日
    return w.wss(security,"neeq_suspensionday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司中文名称时间序列
    return w.wsd(security,"comp_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompName(security:list,*args,**kwargs):
    # 获取公司中文名称
    return w.wss(security,"comp_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompNameEngSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司英文名称时间序列
    return w.wsd(security,"comp_name_eng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompNameEng(security:list,*args,**kwargs):
    # 获取公司英文名称
    return w.wss(security,"comp_name_eng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNature1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司属性时间序列
    return w.wsd(security,"nature1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNature1(security:list,*args,**kwargs):
    # 获取公司属性
    return w.wss(security,"nature1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNatureSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司属性(旧)时间序列
    return w.wsd(security,"nature",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNature(security:list,*args,**kwargs):
    # 获取公司属性(旧)
    return w.wss(security,"nature",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareholderNatureSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股东公司属性时间序列
    return w.wsd(security,"shareholdernature",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareholderNature(security:list,*args,**kwargs):
    # 获取股东公司属性
    return w.wss(security,"shareholdernature",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantorNatureSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人公司属性时间序列
    return w.wsd(security,"agency_guarantornature",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantorNature(security:list,*args,**kwargs):
    # 获取担保人公司属性
    return w.wss(security,"agency_guarantornature",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInstitutionTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金融机构类型时间序列
    return w.wsd(security,"institutiontype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInstitutionType(security:list,*args,**kwargs):
    # 获取金融机构类型
    return w.wss(security,"institutiontype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCorpScaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业规模时间序列
    return w.wsd(security,"corpscale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCorpScale(security:list,*args,**kwargs):
    # 获取企业规模
    return w.wss(security,"corpscale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBankTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市公司(银行)类型时间序列
    return w.wsd(security,"banktype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBankType(security:list,*args,**kwargs):
    # 获取上市公司(银行)类型
    return w.wss(security,"banktype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFoundDate1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取成立日期时间序列
    return w.wsd(security,"founddate1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFoundDate1(security:list,*args,**kwargs):
    # 获取成立日期
    return w.wss(security,"founddate1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpEstablishmentDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人成立日期时间序列
    return w.wsd(security,"fund_corpestablishmentdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpEstablishmentDate(security:list,*args,**kwargs):
    # 获取基金管理人成立日期
    return w.wss(security,"fund_corpestablishmentdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegCapitalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取注册资本时间序列
    return w.wsd(security,"regcapital",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegCapital(security:list,*args,**kwargs):
    # 获取注册资本
    return w.wss(security,"regcapital",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegCapitalCurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取注册资本币种时间序列
    return w.wsd(security,"regcapitalcur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRegCapitalCur(security:list,*args,**kwargs):
    # 获取注册资本币种
    return w.wss(security,"regcapitalcur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpRegisteredCapitalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人注册资本时间序列
    return w.wsd(security,"fund_corpregisteredcapital",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpRegisteredCapital(security:list,*args,**kwargs):
    # 获取基金管理人注册资本
    return w.wss(security,"fund_corpregisteredcapital",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChairmanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取法定代表人时间序列
    return w.wsd(security,"chairman",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChairman(security:list,*args,**kwargs):
    # 获取法定代表人
    return w.wss(security,"chairman",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLegalRepresentativeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取法定代表人(支持历史)时间序列
    return w.wsd(security,"legalrepresentative",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLegalRepresentative(security:list,*args,**kwargs):
    # 获取法定代表人(支持历史)
    return w.wss(security,"legalrepresentative",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFiscalDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取会计年结日时间序列
    return w.wsd(security,"fiscaldate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFiscalDate(security:list,*args,**kwargs):
    # 获取会计年结日
    return w.wss(security,"fiscaldate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusinessSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经营范围时间序列
    return w.wsd(security,"business",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBusiness(security:list,*args,**kwargs):
    # 获取经营范围
    return w.wss(security,"business",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBriefingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司简介时间序列
    return w.wsd(security,"briefing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBriefing(security:list,*args,**kwargs):
    # 获取公司简介
    return w.wss(security,"briefing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareholderBriefingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取股东公司简介时间序列
    return w.wsd(security,"shareholderbriefing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareholderBriefing(security:list,*args,**kwargs):
    # 获取股东公司简介
    return w.wss(security,"shareholderbriefing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantorBriefingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人公司简介时间序列
    return w.wsd(security,"agency_guarantorbriefing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantorBriefing(security:list,*args,**kwargs):
    # 获取担保人公司简介
    return w.wss(security,"agency_guarantorbriefing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorProductTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营产品类型时间序列
    return w.wsd(security,"majorproducttype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorProductType(security:list,*args,**kwargs):
    # 获取主营产品类型
    return w.wss(security,"majorproducttype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorProductNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主营产品名称时间序列
    return w.wsd(security,"majorproductname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMajorProductName(security:list,*args,**kwargs):
    # 获取主营产品名称
    return w.wss(security,"majorproductname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取员工总数时间序列
    return w.wsd(security,"employee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployee(security:list,*args,**kwargs):
    # 获取员工总数
    return w.wss(security,"employee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取母公司员工人数时间序列
    return w.wsd(security,"employee_pc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePc(security:list,*args,**kwargs):
    # 获取母公司员工人数
    return w.wss(security,"employee_pc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdministrativeDivisionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属行政区划时间序列
    return w.wsd(security,"administrativedivision",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdministrativeDivision(security:list,*args,**kwargs):
    # 获取所属行政区划
    return w.wss(security,"administrativedivision",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdminCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属行政区划代码时间序列
    return w.wsd(security,"admincode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdminCode(security:list,*args,**kwargs):
    # 获取所属行政区划代码
    return w.wss(security,"admincode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCsrCJurisdictionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属证监会辖区时间序列
    return w.wsd(security,"csrcjurisdiction",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCsrCJurisdiction(security:list,*args,**kwargs):
    # 获取所属证监会辖区
    return w.wss(security,"csrcjurisdiction",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProvinceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取省份时间序列
    return w.wsd(security,"province",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getProvince(security:list,*args,**kwargs):
    # 获取省份
    return w.wss(security,"province",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取城市时间序列
    return w.wsd(security,"city",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCity(security:list,*args,**kwargs):
    # 获取城市
    return w.wss(security,"city",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpCitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人注册城市时间序列
    return w.wsd(security,"fund_corpcity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpCity(security:list,*args,**kwargs):
    # 获取基金管理人注册城市
    return w.wss(security,"fund_corpcity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAddressSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取注册地址时间序列
    return w.wsd(security,"address",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAddress(security:list,*args,**kwargs):
    # 获取注册地址
    return w.wss(security,"address",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpAddressSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人注册地址时间序列
    return w.wsd(security,"fund_corpaddress",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpAddress(security:list,*args,**kwargs):
    # 获取基金管理人注册地址
    return w.wss(security,"fund_corpaddress",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOfficeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取办公地址时间序列
    return w.wsd(security,"office",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOffice(security:list,*args,**kwargs):
    # 获取办公地址
    return w.wss(security,"office",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpOfficeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人办公地址时间序列
    return w.wsd(security,"fund_corpoffice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpOffice(security:list,*args,**kwargs):
    # 获取基金管理人办公地址
    return w.wss(security,"fund_corpoffice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getZipCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取邮编时间序列
    return w.wsd(security,"zipcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getZipCode(security:list,*args,**kwargs):
    # 获取邮编
    return w.wss(security,"zipcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpZipSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人邮编时间序列
    return w.wsd(security,"fund_corpzip",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpZip(security:list,*args,**kwargs):
    # 获取基金管理人邮编
    return w.wss(security,"fund_corpzip",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPhoneSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司电话时间序列
    return w.wsd(security,"phone",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPhone(security:list,*args,**kwargs):
    # 获取公司电话
    return w.wss(security,"phone",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司传真时间序列
    return w.wsd(security,"fax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFax(security:list,*args,**kwargs):
    # 获取公司传真
    return w.wss(security,"fax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司电子邮件地址时间序列
    return w.wsd(security,"email",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmail(security:list,*args,**kwargs):
    # 获取公司电子邮件地址
    return w.wss(security,"email",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWebsiteSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司网站时间序列
    return w.wsd(security,"website",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWebsite(security:list,*args,**kwargs):
    # 获取公司网站
    return w.wss(security,"website",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDIsCloserSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信息披露人时间序列
    return w.wsd(security,"discloser",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDIsCloser(security:list,*args,**kwargs):
    # 获取信息披露人
    return w.wss(security,"discloser",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMediaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信息指定披露媒体时间序列
    return w.wsd(security,"media",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMedia(security:list,*args,**kwargs):
    # 获取信息指定披露媒体
    return w.wss(security,"media",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOrganizationCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取组织机构代码时间序列
    return w.wsd(security,"organizationcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOrganizationCode(security:list,*args,**kwargs):
    # 获取组织机构代码
    return w.wss(security,"organizationcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getReportCurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取记账本位币时间序列
    return w.wsd(security,"report_cur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getReportCur(security:list,*args,**kwargs):
    # 获取记账本位币
    return w.wss(security,"report_cur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerShortenedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人中文简称时间序列
    return w.wsd(security,"issuershortened",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerShortened(security:list,*args,**kwargs):
    # 获取发行人中文简称
    return w.wss(security,"issuershortened",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMainProductSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主要产品及业务时间序列
    return w.wsd(security,"mainproduct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMainProduct(security:list,*args,**kwargs):
    # 获取主要产品及业务
    return w.wss(security,"mainproduct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompPreNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司曾用名时间序列
    return w.wsd(security,"compprename",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCompPreName(security:list,*args,**kwargs):
    # 获取公司曾用名
    return w.wss(security,"compprename",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbIssueOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否发行可转债时间序列
    return w.wsd(security,"cbissueornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbIssueOrNot(security:list,*args,**kwargs):
    # 获取是否发行可转债
    return w.wss(security,"cbissueornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVoteSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否存在投票权差异时间序列
    return w.wsd(security,"vote",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVote(security:list,*args,**kwargs):
    # 获取是否存在投票权差异
    return w.wss(security,"vote",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSeiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属战略性新兴产业分类时间序列
    return w.wsd(security,"sei",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSei(security:list,*args,**kwargs):
    # 获取所属战略性新兴产业分类
    return w.wss(security,"sei",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getZJtXorNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否专精特新企业时间序列
    return w.wsd(security,"zjtxornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getZJtXorNot(security:list,*args,**kwargs):
    # 获取是否专精特新企业
    return w.wss(security,"zjtxornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrC12NSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属证监会行业名称时间序列
    return w.wsd(security,"industry_csrc12_n",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrC12N(security:list,*args,**kwargs):
    # 获取所属证监会行业名称
    return w.wss(security,"industry_csrc12_n",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属证监会行业名称(旧)时间序列
    return w.wsd(security,"industry_CSRC",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrC(security:list,*args,**kwargs):
    # 获取所属证监会行业名称(旧)
    return w.wss(security,"industry_CSRC",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrCCode12Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属证监会行业代码时间序列
    return w.wsd(security,"industry_CSRCcode12",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrCCode12(security:list,*args,**kwargs):
    # 获取所属证监会行业代码
    return w.wss(security,"industry_CSRCcode12",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrCCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属证监会行业代码(旧)时间序列
    return w.wsd(security,"industry_CSRCcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsrCCode(security:list,*args,**kwargs):
    # 获取所属证监会行业代码(旧)
    return w.wss(security,"industry_CSRCcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业名称时间序列
    return w.wsd(security,"industry_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySw(security:list,*args,**kwargs):
    # 获取所属申万行业名称
    return w.wss(security,"industry_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySw2021Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业名称(2021)时间序列
    return w.wsd(security,"industry_sw_2021",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySw2021(security:list,*args,**kwargs):
    # 获取所属申万行业名称(2021)
    return w.wss(security,"industry_sw_2021",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业名称(港股)时间序列
    return w.wsd(security,"industry_sw_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwHk(security:list,*args,**kwargs):
    # 获取所属申万行业名称(港股)
    return w.wss(security,"industry_sw_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySw2021HkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业名称(港股)(2021)时间序列
    return w.wsd(security,"industry_sw_2021_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySw2021Hk(security:list,*args,**kwargs):
    # 获取所属申万行业名称(港股)(2021)
    return w.wss(security,"industry_sw_2021_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业代码时间序列
    return w.wsd(security,"industry_swcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCode(security:list,*args,**kwargs):
    # 获取所属申万行业代码
    return w.wss(security,"industry_swcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCode2021Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业代码(2021)时间序列
    return w.wsd(security,"industry_swcode_2021",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCode2021(security:list,*args,**kwargs):
    # 获取所属申万行业代码(2021)
    return w.wss(security,"industry_swcode_2021",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCodeHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业代码(港股)时间序列
    return w.wsd(security,"industry_swcode_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCodeHk(security:list,*args,**kwargs):
    # 获取所属申万行业代码(港股)
    return w.wss(security,"industry_swcode_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCode2021HkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业代码(港股)(2021)时间序列
    return w.wsd(security,"industry_swcode_2021_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwCode2021Hk(security:list,*args,**kwargs):
    # 获取所属申万行业代码(港股)(2021)
    return w.wss(security,"industry_swcode_2021_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwOriginCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业原始代码时间序列
    return w.wsd(security,"industry_sworigincode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwOriginCode(security:list,*args,**kwargs):
    # 获取所属申万行业原始代码
    return w.wss(security,"industry_sworigincode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwOriginCode2021Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业原始代码(2021)时间序列
    return w.wsd(security,"industry_sworigincode_2021",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustrySwOriginCode2021(security:list,*args,**kwargs):
    # 获取所属申万行业原始代码(2021)
    return w.wss(security,"industry_sworigincode_2021",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeSwSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属申万行业指数代码时间序列
    return w.wsd(security,"indexcode_sw",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeSw(security:list,*args,**kwargs):
    # 获取所属申万行业指数代码
    return w.wss(security,"indexcode_sw",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信行业名称时间序列
    return w.wsd(security,"industry_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiC(security:list,*args,**kwargs):
    # 获取所属中信行业名称
    return w.wss(security,"industry_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信行业名称(港股)时间序列
    return w.wsd(security,"industry_citic_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCHk(security:list,*args,**kwargs):
    # 获取所属中信行业名称(港股)
    return w.wss(security,"industry_citic_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信行业代码时间序列
    return w.wsd(security,"industry_citiccode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCCode(security:list,*args,**kwargs):
    # 获取所属中信行业代码
    return w.wss(security,"industry_citiccode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCCodeHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信行业代码(港股)时间序列
    return w.wsd(security,"industry_citiccode_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCitiCCodeHk(security:list,*args,**kwargs):
    # 获取所属中信行业代码(港股)
    return w.wss(security,"industry_citiccode_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCitiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信行业指数代码时间序列
    return w.wsd(security,"indexcode_citic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCitiC(security:list,*args,**kwargs):
    # 获取所属中信行业指数代码
    return w.wss(security,"indexcode_citic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCitiCHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信证券港股通指数代码(港股)时间序列
    return w.wsd(security,"indexcode_citic_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCitiCHk(security:list,*args,**kwargs):
    # 获取所属中信证券港股通指数代码(港股)
    return w.wss(security,"indexcode_citic_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexNameCitiCHkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中信证券港股通指数名称(港股)时间序列
    return w.wsd(security,"indexname_citic_hk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexNameCitiCHk(security:list,*args,**kwargs):
    # 获取所属中信证券港股通指数名称(港股)
    return w.wss(security,"indexname_citic_hk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerIndustryCcXiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中诚信行业名称时间序列
    return w.wsd(security,"issuer_industry_ccxi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerIndustryCcXi(security:list,*args,**kwargs):
    # 获取所属中诚信行业名称
    return w.wss(security,"issuer_industry_ccxi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryGicS2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取废弃行业时间序列
    return w.wsd(security,"industry_gics2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryGicS2(security:list,*args,**kwargs):
    # 获取废弃行业
    return w.wss(security,"industry_gics2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryHsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属恒生行业名称时间序列
    return w.wsd(security,"industry_HS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryHs(security:list,*args,**kwargs):
    # 获取所属恒生行业名称
    return w.wss(security,"industry_HS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustry2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属行业名称(支持历史)时间序列
    return w.wsd(security,"industry2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustry2(security:list,*args,**kwargs):
    # 获取所属行业名称(支持历史)
    return w.wss(security,"industry2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属行业代码(支持历史)时间序列
    return w.wsd(security,"industrycode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCode(security:list,*args,**kwargs):
    # 获取所属行业代码(支持历史)
    return w.wss(security,"industrycode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属行业板块名称(支持历史)时间序列
    return w.wsd(security,"industryname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryName(security:list,*args,**kwargs):
    # 获取所属行业板块名称(支持历史)
    return w.wss(security,"industryname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中证行业名称时间序列
    return w.wsd(security,"industry_csi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsi(security:list,*args,**kwargs):
    # 获取所属中证行业名称
    return w.wss(security,"industry_csi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsiCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属中证行业代码时间序列
    return w.wsd(security,"industry_csicode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCsiCode(security:list,*args,**kwargs):
    # 获取所属中证行业代码
    return w.wss(security,"industry_csicode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNcCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国民经济行业代码时间序列
    return w.wsd(security,"industry_nccode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryNcCode(security:list,*args,**kwargs):
    # 获取所属国民经济行业代码
    return w.wss(security,"industry_nccode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCJscSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属长江行业名称时间序列
    return w.wsd(security,"industry_cjsc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCJsc(security:list,*args,**kwargs):
    # 获取所属长江行业名称
    return w.wss(security,"industry_cjsc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCJscSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属长江行业指数代码时间序列
    return w.wsd(security,"indexcode_cjsc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCJsc(security:list,*args,**kwargs):
    # 获取所属长江行业指数代码
    return w.wss(security,"indexcode_cjsc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国证行业名称时间序列
    return w.wsd(security,"industry_cn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCn(security:list,*args,**kwargs):
    # 获取所属国证行业名称
    return w.wss(security,"industry_cn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCnCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国证行业代码时间序列
    return w.wsd(security,"industry_cncode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndustryCnCode(security:list,*args,**kwargs):
    # 获取所属国证行业代码
    return w.wss(security,"industry_cncode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属国证行业指数代码时间序列
    return w.wsd(security,"indexcode_cn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIndexCodeCn(security:list,*args,**kwargs):
    # 获取所属国证行业指数代码
    return w.wss(security,"indexcode_cn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getThematicIndustrySibSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属科创板主题行业时间序列
    return w.wsd(security,"thematicindustry_sib",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getThematicIndustrySib(security:list,*args,**kwargs):
    # 获取所属科创板主题行业
    return w.wss(security,"thematicindustry_sib",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBoardChairmenSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取董事长时间序列
    return w.wsd(security,"boardchairmen",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBoardChairmen(security:list,*args,**kwargs):
    # 获取董事长
    return w.wss(security,"boardchairmen",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenBcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取董事长薪酬时间序列
    return w.wsd(security,"stmnote_mgmt_ben_bc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenBc(security:list,*args,**kwargs):
    # 获取董事长薪酬
    return w.wss(security,"stmnote_mgmt_ben_bc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCeoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总经理时间序列
    return w.wsd(security,"ceo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCeo(security:list,*args,**kwargs):
    # 获取总经理
    return w.wss(security,"ceo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenCeoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总经理薪酬时间序列
    return w.wsd(security,"stmnote_mgmt_ben_ceo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenCeo(security:list,*args,**kwargs):
    # 获取总经理薪酬
    return w.wss(security,"stmnote_mgmt_ben_ceo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpManagerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人总经理时间序列
    return w.wsd(security,"fund_corpmanager",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpManager(security:list,*args,**kwargs):
    # 获取基金管理人总经理
    return w.wss(security,"fund_corpmanager",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDIsCloser1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取董事会秘书时间序列
    return w.wsd(security,"discloser1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDIsCloser1(security:list,*args,**kwargs):
    # 获取董事会秘书
    return w.wss(security,"discloser1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenDIsCloserSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取董事会秘书薪酬时间序列
    return w.wsd(security,"stmnote_mgmt_ben_discloser",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenDIsCloser(security:list,*args,**kwargs):
    # 获取董事会秘书薪酬
    return w.wss(security,"stmnote_mgmt_ben_discloser",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSar1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券事务代表时间序列
    return w.wsd(security,"sar1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSar1(security:list,*args,**kwargs):
    # 获取证券事务代表
    return w.wss(security,"sar1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenSarSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券事务代表薪酬时间序列
    return w.wsd(security,"stmnote_mgmt_ben_sar",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenSar(security:list,*args,**kwargs):
    # 获取证券事务代表薪酬
    return w.wss(security,"stmnote_mgmt_ben_sar",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfOSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务总监时间序列
    return w.wsd(security,"cfo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCfO(security:list,*args,**kwargs):
    # 获取财务总监
    return w.wss(security,"cfo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenCfOSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务总监薪酬时间序列
    return w.wsd(security,"stmnote_mgmt_ben_cfo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenCfO(security:list,*args,**kwargs):
    # 获取财务总监薪酬
    return w.wss(security,"stmnote_mgmt_ben_cfo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrtInDpDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司独立董事(现任)时间序列
    return w.wsd(security,"crtindpdirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCrtInDpDirector(security:list,*args,**kwargs):
    # 获取公司独立董事(现任)
    return w.wss(security,"crtindpdirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUciNdpDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司独立董事(历任)时间序列
    return w.wsd(security,"sucindpdirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUciNdpDirector(security:list,*args,**kwargs):
    # 获取公司独立董事(历任)
    return w.wss(security,"sucindpdirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司董事时间序列
    return w.wsd(security,"director",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDirector(security:list,*args,**kwargs):
    # 获取公司董事
    return w.wss(security,"director",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司董事(历任)时间序列
    return w.wsd(security,"sucdirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcDirector(security:list,*args,**kwargs):
    # 获取公司董事(历任)
    return w.wss(security,"sucdirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSupervisorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司监事时间序列
    return w.wsd(security,"supervisor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSupervisor(security:list,*args,**kwargs):
    # 获取公司监事
    return w.wss(security,"supervisor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcSupervisorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司监事(历任)时间序列
    return w.wsd(security,"sucsupervisor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcSupervisor(security:list,*args,**kwargs):
    # 获取公司监事(历任)
    return w.wss(security,"sucsupervisor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExecutivesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司高管时间序列
    return w.wsd(security,"executives",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExecutives(security:list,*args,**kwargs):
    # 获取公司高管
    return w.wss(security,"executives",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcExecutivesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公司高管(历任)时间序列
    return w.wsd(security,"sucexecutives",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSUcExecutives(security:list,*args,**kwargs):
    # 获取公司高管(历任)
    return w.wss(security,"sucexecutives",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenTop3BSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金额前三的董事薪酬合计时间序列
    return w.wsd(security,"stmnote_mgmt_ben_top3b",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenTop3B(security:list,*args,**kwargs):
    # 获取金额前三的董事薪酬合计
    return w.wss(security,"stmnote_mgmt_ben_top3b",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenTop3MSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取金额前三的高管薪酬合计时间序列
    return w.wsd(security,"stmnote_mgmt_ben_top3m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteMGmtBenTop3M(security:list,*args,**kwargs):
    # 获取金额前三的高管薪酬合计
    return w.wss(security,"stmnote_mgmt_ben_top3m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBoardSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取董事会人数时间序列
    return w.wsd(security,"employee_board",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBoard(security:list,*args,**kwargs):
    # 获取董事会人数
    return w.wss(security,"employee_board",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExecutiveDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非独立董事人数时间序列
    return w.wsd(security,"employee_executivedirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExecutiveDirector(security:list,*args,**kwargs):
    # 获取非独立董事人数
    return w.wss(security,"employee_executivedirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeInDpDirectorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取独立董事人数时间序列
    return w.wsd(security,"employee_indpdirector",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeInDpDirector(security:list,*args,**kwargs):
    # 获取独立董事人数
    return w.wss(security,"employee_indpdirector",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMGmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取高管人数时间序列
    return w.wsd(security,"employee_mgmt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMGmt(security:list,*args,**kwargs):
    # 获取高管人数
    return w.wss(security,"employee_mgmt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTechCoreSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取核心技术人员人数时间序列
    return w.wsd(security,"employee_techcore",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTechCore(security:list,*args,**kwargs):
    # 获取核心技术人员人数
    return w.wss(security,"employee_techcore",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAuditorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取审计机构时间序列
    return w.wsd(security,"auditor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAuditor(security:list,*args,**kwargs):
    # 获取审计机构
    return w.wss(security,"auditor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAuditor2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取审计机构(支持历史)时间序列
    return w.wsd(security,"auditor2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAuditor2(security:list,*args,**kwargs):
    # 获取审计机构(支持历史)
    return w.wss(security,"auditor2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoAuditorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发审计机构时间序列
    return w.wsd(security,"ipo_auditor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoAuditor(security:list,*args,**kwargs):
    # 获取首发审计机构
    return w.wss(security,"ipo_auditor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCloSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取法律顾问时间序列
    return w.wsd(security,"clo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClo(security:list,*args,**kwargs):
    # 获取法律顾问
    return w.wss(security,"clo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLiCSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经办律师时间序列
    return w.wsd(security,"lic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLiC(security:list,*args,**kwargs):
    # 获取经办律师
    return w.wss(security,"lic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLawErSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发经办律师时间序列
    return w.wsd(security,"ipo_lawer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoLawEr(security:list,*args,**kwargs):
    # 获取首发经办律师
    return w.wss(security,"ipo_lawer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItSvaAgSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产评估机构时间序列
    return w.wsd(security,"fund__reitsvaag",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItSvaAg(security:list,*args,**kwargs):
    # 获取资产评估机构
    return w.wss(security,"fund__reitsvaag",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVicSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取经办评估人员时间序列
    return w.wsd(security,"vic",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getVic(security:list,*args,**kwargs):
    # 获取经办评估人员
    return w.wss(security,"vic",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBanksSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主要往来银行时间序列
    return w.wsd(security,"banks",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBanks(security:list,*args,**kwargs):
    # 获取主要往来银行
    return w.wss(security,"banks",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeProducerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取生产人员人数时间序列
    return w.wsd(security,"employee_producer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeProducer(security:list,*args,**kwargs):
    # 获取生产人员人数
    return w.wss(security,"employee_producer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeProducerPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取生产人员人数占比时间序列
    return w.wsd(security,"employee_producer_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeProducerPct(security:list,*args,**kwargs):
    # 获取生产人员人数占比
    return w.wss(security,"employee_producer_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeSaleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取销售人员人数时间序列
    return w.wsd(security,"employee_sale",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeSale(security:list,*args,**kwargs):
    # 获取销售人员人数
    return w.wss(security,"employee_sale",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeSalePctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取销售人员人数占比时间序列
    return w.wsd(security,"employee_sale_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeSalePct(security:list,*args,**kwargs):
    # 获取销售人员人数占比
    return w.wss(security,"employee_sale_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeServerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取客服人员人数时间序列
    return w.wsd(security,"employee_server",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeServer(security:list,*args,**kwargs):
    # 获取客服人员人数
    return w.wss(security,"employee_server",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeServerPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取客服人员人数占比时间序列
    return w.wsd(security,"employee_server_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeServerPct(security:list,*args,**kwargs):
    # 获取客服人员人数占比
    return w.wss(security,"employee_server_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTechSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取技术人员人数时间序列
    return w.wsd(security,"employee_tech",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTech(security:list,*args,**kwargs):
    # 获取技术人员人数
    return w.wss(security,"employee_tech",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTechPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取技术人员人数占比时间序列
    return w.wsd(security,"employee_tech_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeTechPct(security:list,*args,**kwargs):
    # 获取技术人员人数占比
    return w.wss(security,"employee_tech_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeFinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务人员人数时间序列
    return w.wsd(security,"employee_fin",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeFin(security:list,*args,**kwargs):
    # 获取财务人员人数
    return w.wss(security,"employee_fin",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeFinPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务人员人数占比时间序列
    return w.wsd(security,"employee_fin_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeFinPct(security:list,*args,**kwargs):
    # 获取财务人员人数占比
    return w.wss(security,"employee_fin_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取人事人员人数时间序列
    return w.wsd(security,"employee_hr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHr(security:list,*args,**kwargs):
    # 获取人事人员人数
    return w.wss(security,"employee_hr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHrPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取人事人员人数占比时间序列
    return w.wsd(security,"employee_hr_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHrPct(security:list,*args,**kwargs):
    # 获取人事人员人数占比
    return w.wss(security,"employee_hr_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExCuSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行政人员人数时间序列
    return w.wsd(security,"employee_excu",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExCu(security:list,*args,**kwargs):
    # 获取行政人员人数
    return w.wss(security,"employee_excu",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExCuPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行政人员人数占比时间序列
    return w.wsd(security,"employee_excu_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeExCuPct(security:list,*args,**kwargs):
    # 获取行政人员人数占比
    return w.wss(security,"employee_excu_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeRcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取风控稽核人员人数时间序列
    return w.wsd(security,"employee_rc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeRc(security:list,*args,**kwargs):
    # 获取风控稽核人员人数
    return w.wss(security,"employee_rc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeRcPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取风控稽核人员人数占比时间序列
    return w.wsd(security,"employee_rc_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeRcPct(security:list,*args,**kwargs):
    # 获取风控稽核人员人数占比
    return w.wss(security,"employee_rc_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取采购仓储人员人数时间序列
    return w.wsd(security,"employee_pur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePur(security:list,*args,**kwargs):
    # 获取采购仓储人员人数
    return w.wss(security,"employee_pur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePurPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取采购仓储人员人数占比时间序列
    return w.wsd(security,"employee_pur_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePurPct(security:list,*args,**kwargs):
    # 获取采购仓储人员人数占比
    return w.wss(security,"employee_pur_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDeptSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他人员人数时间序列
    return w.wsd(security,"employee_othdept",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDept(security:list,*args,**kwargs):
    # 获取其他人员人数
    return w.wss(security,"employee_othdept",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePhdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取博士人数时间序列
    return w.wsd(security,"employee_PHD",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePhd(security:list,*args,**kwargs):
    # 获取博士人数
    return w.wss(security,"employee_PHD",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePhdPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取博士人数占比时间序列
    return w.wsd(security,"employee_PHD_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeePhdPct(security:list,*args,**kwargs):
    # 获取博士人数占比
    return w.wss(security,"employee_PHD_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取硕士人数时间序列
    return w.wsd(security,"employee_MS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMs(security:list,*args,**kwargs):
    # 获取硕士人数
    return w.wss(security,"employee_MS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMsPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取硕士人数占比时间序列
    return w.wsd(security,"employee_MS_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeMsPct(security:list,*args,**kwargs):
    # 获取硕士人数占比
    return w.wss(security,"employee_MS_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本科人数时间序列
    return w.wsd(security,"employee_BA",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBa(security:list,*args,**kwargs):
    # 获取本科人数
    return w.wss(security,"employee_BA",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBaPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本科人数占比时间序列
    return w.wsd(security,"employee_BA_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeBaPct(security:list,*args,**kwargs):
    # 获取本科人数占比
    return w.wss(security,"employee_BA_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeCollSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取专科人数时间序列
    return w.wsd(security,"employee_coll",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeColl(security:list,*args,**kwargs):
    # 获取专科人数
    return w.wss(security,"employee_coll",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeCollPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取专科人数占比时间序列
    return w.wsd(security,"employee_coll_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeCollPct(security:list,*args,**kwargs):
    # 获取专科人数占比
    return w.wss(security,"employee_coll_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHighschoolSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取高中及以下人数时间序列
    return w.wsd(security,"employee_highschool",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHighschool(security:list,*args,**kwargs):
    # 获取高中及以下人数
    return w.wss(security,"employee_highschool",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHighschoolPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取高中及以下人数占比时间序列
    return w.wsd(security,"employee_highschool_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeHighschoolPct(security:list,*args,**kwargs):
    # 获取高中及以下人数占比
    return w.wss(security,"employee_highschool_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDegreeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他学历人数时间序列
    return w.wsd(security,"employee_othdegree",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDegree(security:list,*args,**kwargs):
    # 获取其他学历人数
    return w.wss(security,"employee_othdegree",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDegreePctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他学历人数占比时间序列
    return w.wsd(security,"employee_othdegree_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDegreePct(security:list,*args,**kwargs):
    # 获取其他学历人数占比
    return w.wss(security,"employee_othdegree_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDeptPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他专业人员人数占比时间序列
    return w.wsd(security,"employee_othdept_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmployeeOThDeptPct(security:list,*args,**kwargs):
    # 获取其他专业人员人数占比
    return w.wss(security,"employee_othdept_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTotalSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取总股本时间序列
    return w.wsd(security,"total_shares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTotalShares(security:list,*args,**kwargs):
    # 获取总股本
    return w.wss(security,"total_shares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaTotalSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取备考总股本(并购后)时间序列
    return w.wsd(security,"matotalshares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaTotalShares(security:list,*args,**kwargs):
    # 获取备考总股本(并购后)
    return w.wss(security,"matotalshares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareToTSharesPreSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市前总股本时间序列
    return w.wsd(security,"share_totshares_pre",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareToTSharesPre(security:list,*args,**kwargs):
    # 获取上市前总股本
    return w.wss(security,"share_totshares_pre",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapAfterIssueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发后总股本(上市日)时间序列
    return w.wsd(security,"ipo_totcapafterissue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapAfterIssue(security:list,*args,**kwargs):
    # 获取首发后总股本(上市日)
    return w.wss(security,"ipo_totcapafterissue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapBeforeIssueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首发前总股本时间序列
    return w.wsd(security,"ipo_totcapbeforeissue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapBeforeIssue(security:list,*args,**kwargs):
    # 获取首发前总股本
    return w.wss(security,"ipo_totcapbeforeissue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapAfterIssueEstSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预计发行后总股本时间序列
    return w.wsd(security,"ipo_totcapafterissue_est",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoToTCapAfterIssueEst(security:list,*args,**kwargs):
    # 获取预计发行后总股本
    return w.wss(security,"ipo_totcapafterissue_est",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctLiqSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股东持股比例(相对总股本)时间序列
    return w.wsd(security,"holder_pct_liq",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctLiq(security:list,*args,**kwargs):
    # 获取流通股东持股比例(相对总股本)
    return w.wss(security,"holder_pct_liq",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFreeFloatSharesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自由流通股本时间序列
    return w.wsd(security,"free_float_shares",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFreeFloatShares(security:list,*args,**kwargs):
    # 获取自由流通股本
    return w.wss(security,"free_float_shares",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalOtcSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取三板合计时间序列
    return w.wsd(security,"share_totalotc",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalOtc(security:list,*args,**kwargs):
    # 获取三板合计
    return w.wss(security,"share_totalotc",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取香港上市股时间序列
    return w.wsd(security,"share_h",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareH(security:list,*args,**kwargs):
    # 获取香港上市股
    return w.wss(security,"share_h",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOverSeaSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取海外上市股时间序列
    return w.wsd(security,"share_oversea",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOverSea(security:list,*args,**kwargs):
    # 获取海外上市股
    return w.wss(security,"share_oversea",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalTradableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股合计时间序列
    return w.wsd(security,"share_totaltradable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalTradable(security:list,*args,**kwargs):
    # 获取流通股合计
    return w.wss(security,"share_totaltradable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalRestrictedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股合计时间序列
    return w.wsd(security,"share_totalrestricted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTotalRestricted(security:list,*args,**kwargs):
    # 获取限售股合计
    return w.wss(security,"share_totalrestricted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradable2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取非流通股时间序列
    return w.wsd(security,"share_nontradable2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNonTradable2(security:list,*args,**kwargs):
    # 获取非流通股
    return w.wss(security,"share_nontradable2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultEfInvestorNonTrAdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取原非流通股股东有效申购户数时间序列
    return w.wsd(security,"cb_result_efinvestornontrad",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultEfInvestorNonTrAd(security:list,*args,**kwargs):
    # 获取原非流通股股东有效申购户数
    return w.wss(security,"cb_result_efinvestornontrad",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultEfAmNtNonTrAdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取原非流通股股东有效申购金额时间序列
    return w.wsd(security,"cb_result_efamntnontrad",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultEfAmNtNonTrAd(security:list,*args,**kwargs):
    # 获取原非流通股股东有效申购金额
    return w.wss(security,"cb_result_efamntnontrad",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultRationAmtNonTrAdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取原非流通股股东获配金额时间序列
    return w.wsd(security,"cb_result_rationamtnontrad",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbResultRationAmtNonTrAd(security:list,*args,**kwargs):
    # 获取原非流通股股东获配金额
    return w.wss(security,"cb_result_rationamtnontrad",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNtrDPrFShareSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取优先股时间序列
    return w.wsd(security,"share_ntrd_prfshare",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNtrDPrFShare(security:list,*args,**kwargs):
    # 获取优先股
    return w.wss(security,"share_ntrd_prfshare",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDPfDStKSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取优先股_GSD时间序列
    return w.wsd(security,"wgsd_pfd_stk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDPfDStK(security:list,*args,**kwargs):
    # 获取优先股_GSD
    return w.wss(security,"wgsd_pfd_stk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDDvdPfDAdjSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取优先股利及其他调整项_GSD时间序列
    return w.wsd(security,"wgsd_dvd_pfd_adj",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDDvdPfDAdj(security:list,*args,**kwargs):
    # 获取优先股利及其他调整项_GSD
    return w.wss(security,"wgsd_dvd_pfd_adj",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaDvdPfDAdjSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.优先股利及其他调整项_GSD时间序列
    return w.wsd(security,"wgsd_qfa_dvd_pfd_adj",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getWgsDQfaDvdPfDAdj(security:list,*args,**kwargs):
    # 获取单季度.优先股利及其他调整项_GSD
    return w.wss(security,"wgsd_qfa_dvd_pfd_adj",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherEquityInstrumentsPreSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他权益工具:优先股时间序列
    return w.wsd(security,"other_equity_instruments_PRE",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherEquityInstrumentsPre(security:list,*args,**kwargs):
    # 获取其他权益工具:优先股
    return w.wss(security,"other_equity_instruments_PRE",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareIssuingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取已发行数量时间序列
    return w.wsd(security,"share_issuing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareIssuing(security:list,*args,**kwargs):
    # 获取已发行数量
    return w.wss(security,"share_issuing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareIssuingMktSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股本时间序列
    return w.wsd(security,"share_issuing_mkt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareIssuingMkt(security:list,*args,**kwargs):
    # 获取流通股本
    return w.wss(security,"share_issuing_mkt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdStateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(国家持股)时间序列
    return w.wsd(security,"share_rtd_state",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdState(security:list,*args,**kwargs):
    # 获取限售股份(国家持股)
    return w.wss(security,"share_rtd_state",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdStateJurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(国有法人持股)时间序列
    return w.wsd(security,"share_rtd_statejur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdStateJur(security:list,*args,**kwargs):
    # 获取限售股份(国有法人持股)
    return w.wss(security,"share_rtd_statejur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdSubOtherDomesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(其他内资持股合计)时间序列
    return w.wsd(security,"share_rtd_subotherdomes",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdSubOtherDomes(security:list,*args,**kwargs):
    # 获取限售股份(其他内资持股合计)
    return w.wss(security,"share_rtd_subotherdomes",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDomesJurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(境内法人持股)时间序列
    return w.wsd(security,"share_rtd_domesjur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDomesJur(security:list,*args,**kwargs):
    # 获取限售股份(境内法人持股)
    return w.wss(security,"share_rtd_domesjur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdInStSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(机构配售股份)时间序列
    return w.wsd(security,"share_rtd_inst",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdInSt(security:list,*args,**kwargs):
    # 获取限售股份(机构配售股份)
    return w.wss(security,"share_rtd_inst",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDomeSnpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(境内自然人持股)时间序列
    return w.wsd(security,"share_rtd_domesnp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDomeSnp(security:list,*args,**kwargs):
    # 获取限售股份(境内自然人持股)
    return w.wss(security,"share_rtd_domesnp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdSubFrgNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(外资持股合计)时间序列
    return w.wsd(security,"share_rtd_subfrgn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdSubFrgN(security:list,*args,**kwargs):
    # 获取限售股份(外资持股合计)
    return w.wss(security,"share_rtd_subfrgn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdFrgNJurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(境外法人持股)时间序列
    return w.wsd(security,"share_rtd_frgnjur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdFrgNJur(security:list,*args,**kwargs):
    # 获取限售股份(境外法人持股)
    return w.wss(security,"share_rtd_frgnjur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdFrgNNpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(境外自然人持股)时间序列
    return w.wsd(security,"share_rtd_frgnnp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdFrgNNp(security:list,*args,**kwargs):
    # 获取限售股份(境外自然人持股)
    return w.wss(security,"share_rtd_frgnnp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押比例时间序列
    return w.wsd(security,"share_pledgeda_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPct(security:list,*args,**kwargs):
    # 获取质押比例
    return w.wss(security,"share_pledgeda_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPledgedPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无限售股份质押比例时间序列
    return w.wsd(security,"share_liqa_pledgedpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPledgedPct(security:list,*args,**kwargs):
    # 获取无限售股份质押比例
    return w.wss(security,"share_liqa_pledgedpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPledgedPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取有限售股份质押比例时间序列
    return w.wsd(security,"share_restricteda_pledgedpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPledgedPct(security:list,*args,**kwargs):
    # 获取有限售股份质押比例
    return w.wss(security,"share_restricteda_pledgedpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPledgedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无限售股份质押数量时间序列
    return w.wsd(security,"share_liqa_pledged",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareLiqAPledged(security:list,*args,**kwargs):
    # 获取无限售股份质押数量
    return w.wss(security,"share_liqa_pledged",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPledgedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取有限售股份质押数量时间序列
    return w.wsd(security,"share_restricteda_pledged",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedAPledged(security:list,*args,**kwargs):
    # 获取有限售股份质押数量
    return w.wss(security,"share_restricteda_pledged",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedRepurchaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押待购回余量时间序列
    return w.wsd(security,"share_pledged_repurchase",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedRepurchase(security:list,*args,**kwargs):
    # 获取质押待购回余量
    return w.wss(security,"share_pledged_repurchase",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdUnlockingDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售解禁日期时间序列
    return w.wsd(security,"share_rtd_unlockingdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdUnlockingDate(security:list,*args,**kwargs):
    # 获取限售解禁日期
    return w.wss(security,"share_rtd_unlockingdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableCurrentSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取本期解禁数量时间序列
    return w.wsd(security,"share_tradable_current",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableCurrent(security:list,*args,**kwargs):
    # 获取本期解禁数量
    return w.wss(security,"share_tradable_current",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdBAnceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未流通数量时间序列
    return w.wsd(security,"share_rtd_bance",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdBAnce(security:list,*args,**kwargs):
    # 获取未流通数量
    return w.wss(security,"share_rtd_bance",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDataTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取解禁数据类型时间序列
    return w.wsd(security,"share_rtd_datatype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDataType(security:list,*args,**kwargs):
    # 获取解禁数据类型
    return w.wss(security,"share_rtd_datatype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDataTypeFwdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日之后最近一次解禁数据类型时间序列
    return w.wsd(security,"share_rtd_datatype_fwd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdDataTypeFwd(security:list,*args,**kwargs):
    # 获取指定日之后最近一次解禁数据类型
    return w.wss(security,"share_rtd_datatype_fwd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableShareTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取解禁股份性质时间序列
    return w.wsd(security,"share_tradable_sharetype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableShareType(security:list,*args,**kwargs):
    # 获取解禁股份性质
    return w.wss(security,"share_tradable_sharetype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableShareTypeFwdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日之后最近一次解禁股份性质时间序列
    return w.wsd(security,"share_tradable_sharetype_fwd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableShareTypeFwd(security:list,*args,**kwargs):
    # 获取指定日之后最近一次解禁股份性质
    return w.wss(security,"share_tradable_sharetype_fwd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdUnlockingDateFwdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日之后最近一次解禁日期时间序列
    return w.wsd(security,"share_rtd_unlockingdate_fwd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRTdUnlockingDateFwd(security:list,*args,**kwargs):
    # 获取指定日之后最近一次解禁日期
    return w.wss(security,"share_rtd_unlockingdate_fwd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableCurrentFwdSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日之后最近一次解禁数量时间序列
    return w.wsd(security,"share_tradable_current_fwd",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareTradableCurrentFwd(security:list,*args,**kwargs):
    # 获取指定日之后最近一次解禁数量
    return w.wss(security,"share_tradable_current_fwd",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通三板股时间序列
    return w.wsd(security,"share_otctradable",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradable(security:list,*args,**kwargs):
    # 获取流通三板股
    return w.wss(security,"share_otctradable",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableControllerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股(控股股东或实际控制人)时间序列
    return w.wsd(security,"share_otctradable_controller",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableController(security:list,*args,**kwargs):
    # 获取流通股(控股股东或实际控制人)
    return w.wss(security,"share_otctradable_controller",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableBackboneSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股(核心员工)时间序列
    return w.wsd(security,"share_otctradable_backbone",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableBackbone(security:list,*args,**kwargs):
    # 获取流通股(核心员工)
    return w.wss(security,"share_otctradable_backbone",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableOthersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股(其他)时间序列
    return w.wsd(security,"share_otctradable_others",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcTradableOthers(security:list,*args,**kwargs):
    # 获取流通股(其他)
    return w.wss(security,"share_otctradable_others",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售三板股时间序列
    return w.wsd(security,"share_otcrestricted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestricted(security:list,*args,**kwargs):
    # 获取限售三板股
    return w.wss(security,"share_otcrestricted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedControllerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(控股股东或实际控制人)时间序列
    return w.wsd(security,"share_otcrestricted_controller",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedController(security:list,*args,**kwargs):
    # 获取限售股份(控股股东或实际控制人)
    return w.wss(security,"share_otcrestricted_controller",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedMSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(高管持股)时间序列
    return w.wsd(security,"share_restricted_m",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareRestrictedM(security:list,*args,**kwargs):
    # 获取限售股份(高管持股)
    return w.wss(security,"share_restricted_m",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedBackboneSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(核心员工)时间序列
    return w.wsd(security,"share_otcrestricted_backbone",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedBackbone(security:list,*args,**kwargs):
    # 获取限售股份(核心员工)
    return w.wss(security,"share_otcrestricted_backbone",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedOthersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取限售股份(其他)时间序列
    return w.wsd(security,"share_otcrestricted_others",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareOtcRestrictedOthers(security:list,*args,**kwargs):
    # 获取限售股份(其他)
    return w.wss(security,"share_otcrestricted_others",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitMergedSharesOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取份额是否为合并数据时间序列
    return w.wsd(security,"unit_mergedsharesornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitMergedSharesOrNot(security:list,*args,**kwargs):
    # 获取份额是否为合并数据
    return w.wss(security,"unit_mergedsharesornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMergedHoldingOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有份额是否为合并数据时间序列
    return w.wsd(security,"holder_mergedholdingornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMergedHoldingOrNot(security:list,*args,**kwargs):
    # 获取持有份额是否为合并数据
    return w.wss(security,"holder_mergedholdingornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFloorTradingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取场内流通份额时间序列
    return w.wsd(security,"unit_floortrading",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFloorTrading(security:list,*args,**kwargs):
    # 获取场内流通份额
    return w.wss(security,"unit_floortrading",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFloorTradingChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取当期场内流通份额变化时间序列
    return w.wsd(security,"unit_floortradingchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitFloorTradingChange(security:list,*args,**kwargs):
    # 获取当期场内流通份额变化
    return w.wss(security,"unit_floortradingchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitPurchaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期总申购份额时间序列
    return w.wsd(security,"unit_purchase",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitPurchase(security:list,*args,**kwargs):
    # 获取报告期总申购份额
    return w.wss(security,"unit_purchase",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitRedemptionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期总赎回份额时间序列
    return w.wsd(security,"unit_redemption",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitRedemption(security:list,*args,**kwargs):
    # 获取报告期总赎回份额
    return w.wss(security,"unit_redemption",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetPurchaseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期申购赎回净额时间序列
    return w.wsd(security,"unit_netpurchase",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetPurchase(security:list,*args,**kwargs):
    # 获取报告期申购赎回净额
    return w.wss(security,"unit_netpurchase",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitPurchaseQTySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度总申购份额时间序列
    return w.wsd(security,"unit_purchase_qty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitPurchaseQTy(security:list,*args,**kwargs):
    # 获取单季度总申购份额
    return w.wss(security,"unit_purchase_qty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitRedemptionQTySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度总赎回份额时间序列
    return w.wsd(security,"unit_redemption_qty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitRedemptionQTy(security:list,*args,**kwargs):
    # 获取单季度总赎回份额
    return w.wss(security,"unit_redemption_qty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetQuarterlyRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度净申购赎回率时间序列
    return w.wsd(security,"unit_netquarterlyratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetQuarterlyRatio(security:list,*args,**kwargs):
    # 获取单季度净申购赎回率
    return w.wss(security,"unit_netquarterlyratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetPurchaseQTySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度申购赎回净额时间序列
    return w.wsd(security,"unit_netpurchase_qty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnitNetPurchaseQTy(security:list,*args,**kwargs):
    # 获取单季度申购赎回净额
    return w.wss(security,"unit_netpurchase_qty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10PctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大股东持股比例合计时间序列
    return w.wsd(security,"holder_top10pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10Pct(security:list,*args,**kwargs):
    # 获取前十大股东持股比例合计
    return w.wss(security,"holder_top10pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10QuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大股东持股数量合计时间序列
    return w.wsd(security,"holder_top10quantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10Quantity(security:list,*args,**kwargs):
    # 获取前十大股东持股数量合计
    return w.wss(security,"holder_top10quantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10LiqQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大流通股东持股数量合计时间序列
    return w.wsd(security,"holder_top10liqquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTop10LiqQuantity(security:list,*args,**kwargs):
    # 获取前十大流通股东持股数量合计
    return w.wss(security,"holder_top10liqquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计质押数量时间序列
    return w.wsd(security,"share_pledgeda_holder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAHolder(security:list,*args,**kwargs):
    # 获取大股东累计质押数量
    return w.wss(security,"share_pledgeda_holder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedALargestHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计质押数量(旧)时间序列
    return w.wsd(security,"share_pledgeda_largestholder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedALargestHolder(security:list,*args,**kwargs):
    # 获取大股东累计质押数量(旧)
    return w.wss(security,"share_pledgeda_largestholder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPctHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计质押数占持股数比例时间序列
    return w.wsd(security,"share_pledgeda_pct_holder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPctHolder(security:list,*args,**kwargs):
    # 获取大股东累计质押数占持股数比例
    return w.wss(security,"share_pledgeda_pct_holder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPctLargestHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计质押数占持股数比例(旧)时间序列
    return w.wsd(security,"share_pledgeda_pct_largestholder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePledgedAPctLargestHolder(security:list,*args,**kwargs):
    # 获取大股东累计质押数占持股数比例(旧)
    return w.wss(security,"share_pledgeda_pct_largestholder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFrozenAHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计冻结数量时间序列
    return w.wsd(security,"share_frozena_holder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFrozenAHolder(security:list,*args,**kwargs):
    # 获取大股东累计冻结数量
    return w.wss(security,"share_frozena_holder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFrozenAPctHolderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东累计冻结数占持股数比例时间序列
    return w.wsd(security,"share_frozena_pct_holder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareFrozenAPctHolder(security:list,*args,**kwargs):
    # 获取大股东累计冻结数占持股数比例
    return w.wss(security,"share_frozena_pct_holder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderRpTControllerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取公布实际控制人名称时间序列
    return w.wsd(security,"holder_rptController",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderRpTController(security:list,*args,**kwargs):
    # 获取公布实际控制人名称
    return w.wss(security,"holder_rptController",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderControllerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际控制人名称时间序列
    return w.wsd(security,"holder_controller",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderController(security:list,*args,**kwargs):
    # 获取实际控制人名称
    return w.wss(security,"holder_controller",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderControllerAtTrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际控制人属性时间序列
    return w.wsd(security,"holder_controllerattr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderControllerAtTr(security:list,*args,**kwargs):
    # 获取实际控制人属性
    return w.wss(security,"holder_controllerattr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstituteSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构股东名称时间序列
    return w.wsd(security,"holder_institute",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitute(security:list,*args,**kwargs):
    # 获取机构股东名称
    return w.wss(security,"holder_institute",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东名称时间序列
    return w.wsd(security,"holder_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderName(security:list,*args,**kwargs):
    # 获取大股东名称
    return w.wss(security,"holder_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东持股数量时间序列
    return w.wsd(security,"holder_quantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQuantity(security:list,*args,**kwargs):
    # 获取大股东持股数量
    return w.wss(security,"holder_quantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东持股比例时间序列
    return w.wsd(security,"holder_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPct(security:list,*args,**kwargs):
    # 获取大股东持股比例
    return w.wss(security,"holder_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumPctTop5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取前5大股东持股比例之和_PIT时间序列
    return w.wsd(security,"holder_sumpcttop5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumPctTop5(security:list,*args,**kwargs):
    # 获取前5大股东持股比例之和_PIT
    return w.wss(security,"holder_sumpcttop5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumsQuPctTop5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取前5大股东持股比例平方之和_PIT时间序列
    return w.wsd(security,"holder_sumsqupcttop5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumsQuPctTop5(security:list,*args,**kwargs):
    # 获取前5大股东持股比例平方之和_PIT
    return w.wss(security,"holder_sumsqupcttop5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumsQuPctTop10Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取前10大股东持股比例平方之和_PIT时间序列
    return w.wsd(security,"holder_sumsqupcttop10",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSumsQuPctTop10(security:list,*args,**kwargs):
    # 获取前10大股东持股比例平方之和_PIT
    return w.wss(security,"holder_sumsqupcttop10",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderShareCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东持股股本性质时间序列
    return w.wsd(security,"holder_sharecategory",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderShareCategory(security:list,*args,**kwargs):
    # 获取大股东持股股本性质
    return w.wss(security,"holder_sharecategory",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQuantityRestrictedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东持有的限售股份数时间序列
    return w.wsd(security,"holder_quantity_restricted",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQuantityRestricted(security:list,*args,**kwargs):
    # 获取大股东持有的限售股份数
    return w.wss(security,"holder_quantity_restricted",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNatureSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东性质时间序列
    return w.wsd(security,"holder_nature",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNature(security:list,*args,**kwargs):
    # 获取大股东性质
    return w.wss(security,"holder_nature",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构股东类型时间序列
    return w.wsd(security,"holder_category",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCategory(security:list,*args,**kwargs):
    # 获取机构股东类型
    return w.wss(security,"holder_category",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股东名称时间序列
    return w.wsd(security,"holder_liqname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqName(security:list,*args,**kwargs):
    # 获取流通股东名称
    return w.wss(security,"holder_liqname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股东持股数量时间序列
    return w.wsd(security,"holder_liqquantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqQuantity(security:list,*args,**kwargs):
    # 获取流通股东持股数量
    return w.wss(security,"holder_liqquantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股东持股比例时间序列
    return w.wsd(security,"holder_liqpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqPct(security:list,*args,**kwargs):
    # 获取流通股东持股比例
    return w.wss(security,"holder_liqpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqShareCategorySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取流通股东持股股本性质时间序列
    return w.wsd(security,"holder_liqsharecategory",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderLiqShareCategory(security:list,*args,**kwargs):
    # 获取流通股东持股股本性质
    return w.wss(security,"holder_liqsharecategory",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgNumSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股数量时间序列
    return w.wsd(security,"holder_avgnum",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgNum(security:list,*args,**kwargs):
    # 获取户均持股数量
    return w.wss(security,"holder_avgnum",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股比例时间序列
    return w.wsd(security,"holder_avgpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgPct(security:list,*args,**kwargs):
    # 获取户均持股比例
    return w.wss(security,"holder_avgpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderHAvgPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股比例半年增长率时间序列
    return w.wsd(security,"holder_havgpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderHAvgPctChange(security:list,*args,**kwargs):
    # 获取户均持股比例半年增长率
    return w.wss(security,"holder_havgpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQAvgPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股比例季度增长率时间序列
    return w.wsd(security,"holder_qavgpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQAvgPctChange(security:list,*args,**kwargs):
    # 获取户均持股比例季度增长率
    return w.wss(security,"holder_qavgpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgPctChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对上一报告期户均持股比例差时间序列
    return w.wsd(security,"holder_avgpctchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderAvgPctChange(security:list,*args,**kwargs):
    # 获取相对上一报告期户均持股比例差
    return w.wss(security,"holder_avgpctchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderHAvgChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股数半年增长率时间序列
    return w.wsd(security,"holder_havgchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderHAvgChange(security:list,*args,**kwargs):
    # 获取户均持股数半年增长率
    return w.wss(security,"holder_havgchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQAvgChangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取户均持股数季度增长率时间序列
    return w.wsd(security,"holder_qavgchange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderQAvgChange(security:list,*args,**kwargs):
    # 获取户均持股数季度增长率
    return w.wss(security,"holder_qavgchange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持股数量时间序列
    return w.wsd(security,"holder_totalbyfund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByFund(security:list,*args,**kwargs):
    # 获取基金持股数量
    return w.wss(security,"holder_totalbyfund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalBySSFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社保基金持股数量时间序列
    return w.wsd(security,"holder_totalbyssfund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalBySSFund(security:list,*args,**kwargs):
    # 获取社保基金持股数量
    return w.wss(security,"holder_totalbyssfund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByBySecSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取券商持股数量时间序列
    return w.wsd(security,"holder_totalbybysec",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByBySec(security:list,*args,**kwargs):
    # 获取券商持股数量
    return w.wss(security,"holder_totalbybysec",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByByWMpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取券商理财产品持股数量时间序列
    return w.wsd(security,"holder_totalbybywmp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByByWMp(security:list,*args,**kwargs):
    # 获取券商理财产品持股数量
    return w.wss(security,"holder_totalbybywmp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByHfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取阳光私募持股数量时间序列
    return w.wsd(security,"holder_totalbyhf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByHf(security:list,*args,**kwargs):
    # 获取阳光私募持股数量
    return w.wss(security,"holder_totalbyhf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByInSurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取保险公司持股数量时间序列
    return w.wsd(security,"holder_totalbyinsur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByInSur(security:list,*args,**kwargs):
    # 获取保险公司持股数量
    return w.wss(security,"holder_totalbyinsur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByCorpPensionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业年金持股数量时间序列
    return w.wsd(security,"holder_totalbycorppension",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByCorpPension(security:list,*args,**kwargs):
    # 获取企业年金持股数量
    return w.wss(security,"holder_totalbycorppension",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByTrustCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信托公司持股数量时间序列
    return w.wsd(security,"holder_totalbytrustcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByTrustCorp(security:list,*args,**kwargs):
    # 获取信托公司持股数量
    return w.wss(security,"holder_totalbytrustcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByFinanceCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务公司持股数量时间序列
    return w.wsd(security,"holder_totalbyfinancecorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByFinanceCorp(security:list,*args,**kwargs):
    # 获取财务公司持股数量
    return w.wss(security,"holder_totalbyfinancecorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行持股数量时间序列
    return w.wsd(security,"holder_totalbybank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByBank(security:list,*args,**kwargs):
    # 获取银行持股数量
    return w.wss(security,"holder_totalbybank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByGeneralCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一般法人持股数量时间序列
    return w.wsd(security,"holder_totalbygeneralcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByGeneralCorp(security:list,*args,**kwargs):
    # 获取一般法人持股数量
    return w.wss(security,"holder_totalbygeneralcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByLnFCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非金融类上市公司持股数量时间序列
    return w.wsd(security,"holder_totalbylnfcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderTotalByLnFCorp(security:list,*args,**kwargs):
    # 获取非金融类上市公司持股数量
    return w.wss(security,"holder_totalbylnfcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持股比例时间序列
    return w.wsd(security,"holder_pctbyfund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByFund(security:list,*args,**kwargs):
    # 获取基金持股比例
    return w.wss(security,"holder_pctbyfund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctBySSFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取社保基金持股比例时间序列
    return w.wsd(security,"holder_pctbyssfund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctBySSFund(security:list,*args,**kwargs):
    # 获取社保基金持股比例
    return w.wss(security,"holder_pctbyssfund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctBySecSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取券商持股比例时间序列
    return w.wsd(security,"holder_pctbysec",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctBySec(security:list,*args,**kwargs):
    # 获取券商持股比例
    return w.wss(security,"holder_pctbysec",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByByWMpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取券商理财产品持股比例时间序列
    return w.wsd(security,"holder_pctbybywmp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByByWMp(security:list,*args,**kwargs):
    # 获取券商理财产品持股比例
    return w.wss(security,"holder_pctbybywmp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByHfSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取阳光私募持股比例时间序列
    return w.wsd(security,"holder_pctbyhf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByHf(security:list,*args,**kwargs):
    # 获取阳光私募持股比例
    return w.wss(security,"holder_pctbyhf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByInSurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取保险公司持股比例时间序列
    return w.wsd(security,"holder_pctbyinsur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByInSur(security:list,*args,**kwargs):
    # 获取保险公司持股比例
    return w.wss(security,"holder_pctbyinsur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByCorpPensionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取企业年金持股比例时间序列
    return w.wsd(security,"holder_pctbycorppension",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByCorpPension(security:list,*args,**kwargs):
    # 获取企业年金持股比例
    return w.wss(security,"holder_pctbycorppension",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByTrustCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信托公司持股比例时间序列
    return w.wsd(security,"holder_pctbytrustcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByTrustCorp(security:list,*args,**kwargs):
    # 获取信托公司持股比例
    return w.wss(security,"holder_pctbytrustcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByFinanceCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务公司持股比例时间序列
    return w.wsd(security,"holder_pctbyfinancecorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByFinanceCorp(security:list,*args,**kwargs):
    # 获取财务公司持股比例
    return w.wss(security,"holder_pctbyfinancecorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行持股比例时间序列
    return w.wsd(security,"holder_pctbybank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByBank(security:list,*args,**kwargs):
    # 获取银行持股比例
    return w.wss(security,"holder_pctbybank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByGeneralCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一般法人持股比例时间序列
    return w.wsd(security,"holder_pctbygeneralcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByGeneralCorp(security:list,*args,**kwargs):
    # 获取一般法人持股比例
    return w.wss(security,"holder_pctbygeneralcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByLnFCorpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取非金融类上市公司持股比例时间序列
    return w.wsd(security,"holder_pctbylnfcorp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPctByLnFCorp(security:list,*args,**kwargs):
    # 获取非金融类上市公司持股比例
    return w.wss(security,"holder_pctbylnfcorp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumISeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持股机构数时间序列
    return w.wsd(security,"holder_num_i",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumI(security:list,*args,**kwargs):
    # 获取持股机构数
    return w.wss(security,"holder_num_i",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持股基金数时间序列
    return w.wsd(security,"holder_num_fund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumFund(security:list,*args,**kwargs):
    # 获取持股基金数
    return w.wss(security,"holder_num_fund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumSSFundSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持股社保基金数时间序列
    return w.wsd(security,"holder_num_ssfund",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumSSFund(security:list,*args,**kwargs):
    # 获取持股社保基金数
    return w.wss(security,"holder_num_ssfund",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumInSurSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持股保险公司数时间序列
    return w.wsd(security,"holder_num_insur",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderNumInSur(security:list,*args,**kwargs):
    # 获取持股保险公司数
    return w.wss(security,"holder_num_insur",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceFellowOnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定向增发价格时间序列
    return w.wsd(security,"holder_price_fellowon",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceFellowOn(security:list,*args,**kwargs):
    # 获取定向增发价格
    return w.wss(security,"holder_price_fellowon",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceMajorShareholdersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取大股东增持价格时间序列
    return w.wsd(security,"holder_price_Majorshareholders",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceMajorShareholders(security:list,*args,**kwargs):
    # 获取大股东增持价格
    return w.wss(security,"holder_price_Majorshareholders",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceEsOpSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取员工持股计划买入价格时间序列
    return w.wsd(security,"holder_price_ESOP",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPriceEsOp(security:list,*args,**kwargs):
    # 获取员工持股计划买入价格
    return w.wss(security,"holder_price_ESOP",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMergedNumberOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有人户数是否为合并数据时间序列
    return w.wsd(security,"holder_mergednumberornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMergedNumberOrNot(security:list,*args,**kwargs):
    # 获取持有人户数是否为合并数据
    return w.wss(security,"holder_mergednumberornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者持有份额时间序列
    return w.wsd(security,"holder_institution_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionHolding(security:list,*args,**kwargs):
    # 获取机构投资者持有份额
    return w.wss(security,"holder_institution_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionTotalHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者持有份额(合计)时间序列
    return w.wsd(security,"holder_institution_totalholding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionTotalHolding(security:list,*args,**kwargs):
    # 获取机构投资者持有份额(合计)
    return w.wss(security,"holder_institution_totalholding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者持有比例时间序列
    return w.wsd(security,"holder_institution_holdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionHoldingPct(security:list,*args,**kwargs):
    # 获取机构投资者持有比例
    return w.wss(security,"holder_institution_holdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionTotalHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构投资者持有比例(合计)时间序列
    return w.wsd(security,"holder_institution_totalholdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderInstitutionTotalHoldingPct(security:list,*args,**kwargs):
    # 获取机构投资者持有比例(合计)
    return w.wss(security,"holder_institution_totalholdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMNgEmpHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理人员工持有份额时间序列
    return w.wsd(security,"holder_mngemp_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMNgEmpHolding(security:list,*args,**kwargs):
    # 获取管理人员工持有份额
    return w.wss(security,"holder_mngemp_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMNgEmpHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理人员工持有比例时间序列
    return w.wsd(security,"holder_mngemp_holdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderMNgEmpHoldingPct(security:list,*args,**kwargs):
    # 获取管理人员工持有比例
    return w.wss(security,"holder_mngemp_holdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCorpHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理公司持有份额时间序列
    return w.wsd(security,"holder_corp_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCorpHolding(security:list,*args,**kwargs):
    # 获取基金管理公司持有份额
    return w.wss(security,"holder_corp_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCorpHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理公司持有比例时间序列
    return w.wsd(security,"holder_corp_holdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderCorpHoldingPct(security:list,*args,**kwargs):
    # 获取基金管理公司持有比例
    return w.wss(security,"holder_corp_holdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者持有份额时间序列
    return w.wsd(security,"holder_personal_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalHolding(security:list,*args,**kwargs):
    # 获取个人投资者持有份额
    return w.wss(security,"holder_personal_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalTotalHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者持有份额(合计)时间序列
    return w.wsd(security,"holder_personal_totalholding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalTotalHolding(security:list,*args,**kwargs):
    # 获取个人投资者持有份额(合计)
    return w.wss(security,"holder_personal_totalholding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者持有比例时间序列
    return w.wsd(security,"holder_personal_holdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalHoldingPct(security:list,*args,**kwargs):
    # 获取个人投资者持有比例
    return w.wss(security,"holder_personal_holdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalTotalHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取个人投资者持有比例(合计)时间序列
    return w.wsd(security,"holder_personal_totalholdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderPersonalTotalHoldingPct(security:list,*args,**kwargs):
    # 获取个人投资者持有比例(合计)
    return w.wss(security,"holder_personal_totalholdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10HoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大持有人持有份额合计时间序列
    return w.wsd(security,"fund_holder_top10_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10Holding(security:list,*args,**kwargs):
    # 获取前十大持有人持有份额合计
    return w.wss(security,"fund_holder_top10_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10HoldingMmFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大持有人持有份额合计(货币)时间序列
    return w.wsd(security,"fund_holder_top10_holdingmmf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10HoldingMmF(security:list,*args,**kwargs):
    # 获取前十大持有人持有份额合计(货币)
    return w.wss(security,"fund_holder_top10_holdingmmf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10PctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大持有人持有比例合计时间序列
    return w.wsd(security,"fund_holder_top10_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10Pct(security:list,*args,**kwargs):
    # 获取前十大持有人持有比例合计
    return w.wss(security,"fund_holder_top10_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10PctMmFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取前十大持有人持有比例合计(货币)时间序列
    return w.wsd(security,"fund_holder_top10_pctmmf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderTop10PctMmF(security:list,*args,**kwargs):
    # 获取前十大持有人持有比例合计(货币)
    return w.wss(security,"fund_holder_top10_pctmmf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单一投资者报告期末持有份额时间序列
    return w.wsd(security,"holder_single_holding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleHolding(security:list,*args,**kwargs):
    # 获取单一投资者报告期末持有份额
    return w.wss(security,"holder_single_holding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleTotalHoldingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单一投资者报告期末持有份额合计时间序列
    return w.wsd(security,"holder_single_totalholding",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleTotalHolding(security:list,*args,**kwargs):
    # 获取单一投资者报告期末持有份额合计
    return w.wss(security,"holder_single_totalholding",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单一投资者报告期末持有比例时间序列
    return w.wsd(security,"holder_single_holdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleHoldingPct(security:list,*args,**kwargs):
    # 获取单一投资者报告期末持有比例
    return w.wss(security,"holder_single_holdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleTotalHoldingPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单一投资者报告期末持有比例合计时间序列
    return w.wsd(security,"holder_single_totalholdingpct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getHolderSingleTotalHoldingPct(security:list,*args,**kwargs):
    # 获取单一投资者报告期末持有比例合计
    return w.wss(security,"holder_single_totalholdingpct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondQualifiedInvestorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取合格投资者类型时间序列
    return w.wsd(security,"bond_qualified_investor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondQualifiedInvestor(security:list,*args,**kwargs):
    # 获取合格投资者类型
    return w.wss(security,"bond_qualified_investor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldFundsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有基金家数时间序列
    return w.wsd(security,"fundhold_funds",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldFunds(security:list,*args,**kwargs):
    # 获取持有基金家数
    return w.wss(security,"fundhold_funds",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldRatioOfPositionToAmNtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持有数量合计占存量比时间序列
    return w.wsd(security,"fundhold_ratioofpositiontoamnt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldRatioOfPositionToAmNt(security:list,*args,**kwargs):
    # 获取基金持有数量合计占存量比
    return w.wss(security,"fundhold_ratioofpositiontoamnt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldPositionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持有数量合计时间序列
    return w.wsd(security,"fundhold_position",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldPosition(security:list,*args,**kwargs):
    # 获取基金持有数量合计
    return w.wss(security,"fundhold_position",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有人名称时间序列
    return w.wsd(security,"bondholder_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderName(security:list,*args,**kwargs):
    # 获取持有人名称
    return w.wss(security,"bondholder_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第N名持有人名称时间序列
    return w.wsd(security,"fund_holder_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderName(security:list,*args,**kwargs):
    # 获取第N名持有人名称
    return w.wss(security,"fund_holder_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderNameListingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第N名持有人名称(上市公告)时间序列
    return w.wsd(security,"fund_holder_namelisting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderNameListing(security:list,*args,**kwargs):
    # 获取第N名持有人名称(上市公告)
    return w.wss(security,"fund_holder_namelisting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有人持有比例时间序列
    return w.wsd(security,"bondholder_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderPct(security:list,*args,**kwargs):
    # 获取持有人持有比例
    return w.wss(security,"bondholder_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPctSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第N名持有人持有比例时间序列
    return w.wsd(security,"fund_holder_pct",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPct(security:list,*args,**kwargs):
    # 获取第N名持有人持有比例
    return w.wss(security,"fund_holder_pct",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPctListingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第N名持有人持有比例(上市公告)时间序列
    return w.wsd(security,"fund_holder_pctlisting",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPctListing(security:list,*args,**kwargs):
    # 获取第N名持有人持有比例(上市公告)
    return w.wss(security,"fund_holder_pctlisting",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPctMmFSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取第N名持有人持有比例(货币)时间序列
    return w.wsd(security,"fund_holder_pctmmf",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHolderPctMmF(security:list,*args,**kwargs):
    # 获取第N名持有人持有比例(货币)
    return w.wss(security,"fund_holder_pctmmf",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderQuantitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有人持有数量时间序列
    return w.wsd(security,"bondholder_quantity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBondHolderQuantity(security:list,*args,**kwargs):
    # 获取持有人持有数量
    return w.wss(security,"bondholder_quantity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondNamesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取持有基金名称时间序列
    return w.wsd(security,"fundholdbond_names",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondNames(security:list,*args,**kwargs):
    # 获取持有基金名称
    return w.wss(security,"fundholdbond_names",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持债市值时间序列
    return w.wsd(security,"fundholdbond_value",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondValue(security:list,*args,**kwargs):
    # 获取基金持债市值
    return w.wss(security,"fundholdbond_value",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金持债市值占发行量比时间序列
    return w.wsd(security,"fundholdbond_ratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHoldBondRatio(security:list,*args,**kwargs):
    # 获取基金持债市值占发行量比
    return w.wss(security,"fundholdbond_ratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪(深)股通持股数量时间序列
    return w.wsd(security,"share_N",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareN(security:list,*args,**kwargs):
    # 获取沪(深)股通持股数量
    return w.wss(security,"share_N",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股通持股数量时间序列
    return w.wsd(security,"share_HKS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkS(security:list,*args,**kwargs):
    # 获取港股通持股数量
    return w.wss(security,"share_HKS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkShSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪市港股通持股数量时间序列
    return w.wsd(security,"share_HKSH",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkSh(security:list,*args,**kwargs):
    # 获取沪市港股通持股数量
    return w.wss(security,"share_HKSH",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkSzSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取深市港股通持股数量时间序列
    return w.wsd(security,"share_HKSZ",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getShareHkSz(security:list,*args,**kwargs):
    # 获取深市港股通持股数量
    return w.wss(security,"share_HKSZ",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctNSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪(深)股通持股占比时间序列
    return w.wsd(security,"share_pct_N",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctN(security:list,*args,**kwargs):
    # 获取沪(深)股通持股占比
    return w.wss(security,"share_pct_N",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctNToFreeFloatSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪(深)股通持股占自由流通股比例时间序列
    return w.wsd(security,"share_pct_Ntofreefloat",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctNToFreeFloat(security:list,*args,**kwargs):
    # 获取沪(深)股通持股占自由流通股比例
    return w.wss(security,"share_pct_Ntofreefloat",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股通持股占比时间序列
    return w.wsd(security,"share_pct_HKS",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkS(security:list,*args,**kwargs):
    # 获取港股通持股占比
    return w.wss(security,"share_pct_HKS",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkShSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取沪市港股通持股占比时间序列
    return w.wsd(security,"share_pct_HKSH",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkSh(security:list,*args,**kwargs):
    # 获取沪市港股通持股占比
    return w.wss(security,"share_pct_HKSH",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkSzSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取深市港股通持股占比时间序列
    return w.wsd(security,"share_pct_HKSZ",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSharePctHkSz(security:list,*args,**kwargs):
    # 获取深市港股通持股占比
    return w.wss(security,"share_pct_HKSZ",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFullNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取证券全称时间序列
    return w.wsd(security,"fullname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFullName(security:list,*args,**kwargs):
    # 获取证券全称
    return w.wss(security,"fullname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerUpdatedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债务主体时间序列
    return w.wsd(security,"issuerupdated",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerUpdated(security:list,*args,**kwargs):
    # 获取债务主体
    return w.wss(security,"issuerupdated",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerActualSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际发行人时间序列
    return w.wsd(security,"issuer_actual",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerActual(security:list,*args,**kwargs):
    # 获取实际发行人
    return w.wss(security,"issuer_actual",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getParSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券初始面值时间序列
    return w.wsd(security,"par",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPar(security:list,*args,**kwargs):
    # 获取债券初始面值
    return w.wss(security,"par",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestParSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券最新面值时间序列
    return w.wsd(security,"latestpar",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestPar(security:list,*args,**kwargs):
    # 获取债券最新面值
    return w.wss(security,"latestpar",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行总额时间序列
    return w.wsd(security,"issueamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAmount(security:list,*args,**kwargs):
    # 获取发行总额
    return w.wss(security,"issueamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTrancheSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取各级发行总额时间序列
    return w.wsd(security,"tranche",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTranche(security:list,*args,**kwargs):
    # 获取各级发行总额
    return w.wss(security,"tranche",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbIssueAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转债发行总额时间序列
    return w.wsd(security,"cb_issueamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCbIssueAmount(security:list,*args,**kwargs):
    # 获取转债发行总额
    return w.wss(security,"cb_issueamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAmountPlanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计划发行总额时间序列
    return w.wsd(security,"issue_amountplan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAmountPlan(security:list,*args,**kwargs):
    # 获取计划发行总额
    return w.wss(security,"issue_amountplan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTenderAmountPlanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计划发行总额(文字)时间序列
    return w.wsd(security,"tender_amountplan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTenderAmountPlan(security:list,*args,**kwargs):
    # 获取计划发行总额(文字)
    return w.wss(security,"tender_amountplan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTendRstAmountActSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际发行总额时间序列
    return w.wsd(security,"tendrst_amountact",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTendRstAmountAct(security:list,*args,**kwargs):
    # 获取实际发行总额
    return w.wss(security,"tendrst_amountact",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTrancheRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取各级占比时间序列
    return w.wsd(security,"trancheratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTrancheRatio(security:list,*args,**kwargs):
    # 获取各级占比
    return w.wss(security,"trancheratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOutstandingBalanceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券余额时间序列
    return w.wsd(security,"outstandingbalance",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOutstandingBalance(security:list,*args,**kwargs):
    # 获取债券余额
    return w.wss(security,"outstandingbalance",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取存量债券余额时间序列
    return w.wsd(security,"fina_totalamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalAmount(security:list,*args,**kwargs):
    # 获取存量债券余额
    return w.wss(security,"fina_totalamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinalTotalAmOutAnytimeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取存量债券余额(支持历史)时间序列
    return w.wsd(security,"final_totalamout_anytime",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinalTotalAmOutAnytime(security:list,*args,**kwargs):
    # 获取存量债券余额(支持历史)
    return w.wss(security,"final_totalamout_anytime",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaMatSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取存量债券余额(按期限)时间序列
    return w.wsd(security,"fina_mat",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaMat(security:list,*args,**kwargs):
    # 获取存量债券余额(按期限)
    return w.wss(security,"fina_mat",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTBondBalanceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取国债余额(做市后)时间序列
    return w.wsd(security,"tbondbalance",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTBondBalance(security:list,*args,**kwargs):
    # 获取国债余额(做市后)
    return w.wss(security,"tbondbalance",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCarryDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取起息日期时间序列
    return w.wsd(security,"carrydate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCarryDate(security:list,*args,**kwargs):
    # 获取起息日期
    return w.wss(security,"carrydate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCarryEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计息截止日时间序列
    return w.wsd(security,"carryenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCarryEnddate(security:list,*args,**kwargs):
    # 获取计息截止日
    return w.wss(security,"carryenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaturityDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取到期日期时间序列
    return w.wsd(security,"maturitydate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaturityDate(security:list,*args,**kwargs):
    # 获取到期日期
    return w.wss(security,"maturitydate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTermSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券期限(年)时间序列
    return w.wsd(security,"term",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTerm(security:list,*args,**kwargs):
    # 获取债券期限(年)
    return w.wss(security,"term",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTerm2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取债券期限(文字)时间序列
    return w.wsd(security,"term2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTerm2(security:list,*args,**kwargs):
    # 获取债券期限(文字)
    return w.wss(security,"term2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取利率类型时间序列
    return w.wsd(security,"interesttype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestType(security:list,*args,**kwargs):
    # 获取利率类型
    return w.wss(security,"interesttype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取票面利率(发行时)时间序列
    return w.wsd(security,"couponrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRate(security:list,*args,**kwargs):
    # 获取票面利率(发行时)
    return w.wss(security,"couponrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponTxtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取利率说明时间序列
    return w.wsd(security,"coupontxt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponTxt(security:list,*args,**kwargs):
    # 获取利率说明
    return w.wss(security,"coupontxt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest6Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取补偿利率说明时间序列
    return w.wsd(security,"clause_interest_6",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest6(security:list,*args,**kwargs):
    # 获取补偿利率说明
    return w.wss(security,"clause_interest_6",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计息方式时间序列
    return w.wsd(security,"paymenttype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentType(security:list,*args,**kwargs):
    # 获取计息方式
    return w.wss(security,"paymenttype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getActualBenchmarkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计息基准时间序列
    return w.wsd(security,"actualbenchmark",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getActualBenchmark(security:list,*args,**kwargs):
    # 获取计息基准
    return w.wss(security,"actualbenchmark",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取息票品种时间序列
    return w.wsd(security,"coupon",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCoupon(security:list,*args,**kwargs):
    # 获取息票品种
    return w.wss(security,"coupon",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFormSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取凭证类别时间序列
    return w.wsd(security,"form",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getForm(security:list,*args,**kwargs):
    # 获取凭证类别
    return w.wss(security,"form",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestFrequencySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每年付息次数时间序列
    return w.wsd(security,"interestfrequency",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestFrequency(security:list,*args,**kwargs):
    # 获取每年付息次数
    return w.wss(security,"interestfrequency",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取年付息日时间序列
    return w.wsd(security,"paymentdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentDate(security:list,*args,**kwargs):
    # 获取年付息日
    return w.wss(security,"paymentdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponDateTxtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取付息日说明时间序列
    return w.wsd(security,"coupondatetxt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponDateTxt(security:list,*args,**kwargs):
    # 获取付息日说明
    return w.wss(security,"coupondatetxt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxFreeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否免税时间序列
    return w.wsd(security,"taxfree",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxFree(security:list,*args,**kwargs):
    # 获取是否免税
    return w.wss(security,"taxfree",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取税率时间序列
    return w.wsd(security,"taxrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTaxRate(security:list,*args,**kwargs):
    # 获取税率
    return w.wss(security,"taxrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktPriceTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市价类型时间序列
    return w.wsd(security,"mktpricetype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMktPriceType(security:list,*args,**kwargs):
    # 获取市价类型
    return w.wss(security,"mktpricetype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionBeginningSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取兑付日时间序列
    return w.wsd(security,"redemption_beginning",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionBeginning(security:list,*args,**kwargs):
    # 获取兑付日
    return w.wss(security,"redemption_beginning",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionRegBeginningSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取兑付登记日时间序列
    return w.wsd(security,"redemption_regbeginning",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionRegBeginning(security:list,*args,**kwargs):
    # 获取兑付登记日
    return w.wss(security,"redemption_regbeginning",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionFeeRationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取兑付费率时间序列
    return w.wsd(security,"redemption_feeration",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionFeeRation(security:list,*args,**kwargs):
    # 获取兑付费率
    return w.wss(security,"redemption_feeration",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepaymentMethodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取偿还方式时间序列
    return w.wsd(security,"repaymentmethod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepaymentMethod(security:list,*args,**kwargs):
    # 获取偿还方式
    return w.wss(security,"repaymentmethod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentOrderSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取偿付顺序时间序列
    return w.wsd(security,"paymentorder",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPaymentOrder(security:list,*args,**kwargs):
    # 获取偿付顺序
    return w.wss(security,"paymentorder",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIsAssetOutSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产是否出表时间序列
    return w.wsd(security,"isassetout",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIsAssetOut(security:list,*args,**kwargs):
    # 获取资产是否出表
    return w.wss(security,"isassetout",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsSPvSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计划管理人时间序列
    return w.wsd(security,"abs_spv",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsSPv(security:list,*args,**kwargs):
    # 获取计划管理人
    return w.wss(security,"abs_spv",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsOriginalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取原始权益人时间序列
    return w.wsd(security,"fund__reitsoriginal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsOriginal(security:list,*args,**kwargs):
    # 获取原始权益人
    return w.wss(security,"fund__reitsoriginal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsOrComSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取原始权益人企业性质时间序列
    return w.wsd(security,"fund__reitsorcom",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReItsOrCom(security:list,*args,**kwargs):
    # 获取原始权益人企业性质
    return w.wss(security,"fund__reitsorcom",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPenetrateActRuAlDebtorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取穿透信用主体时间序列
    return w.wsd(security,"abs_penetrateactrualdebtor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPenetrateActRuAlDebtor(security:list,*args,**kwargs):
    # 获取穿透信用主体
    return w.wss(security,"abs_penetrateactrualdebtor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerBankTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人(银行)类型时间序列
    return w.wsd(security,"issuer_banktype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerBankType(security:list,*args,**kwargs):
    # 获取发行人(银行)类型
    return w.wss(security,"issuer_banktype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoLastEstDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新交易日期时间序列
    return w.wsd(security,"repo_lastestdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepoLastEstDate(security:list,*args,**kwargs):
    # 获取最新交易日期
    return w.wss(security,"repo_lastestdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentLoanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取当前贷款笔数时间序列
    return w.wsd(security,"abs_currentloan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentLoan(security:list,*args,**kwargs):
    # 获取当前贷款笔数
    return w.wss(security,"abs_currentloan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentLoansSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取当前贷款余额时间序列
    return w.wsd(security,"abs_currentloans",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentLoans(security:list,*args,**kwargs):
    # 获取当前贷款余额
    return w.wss(security,"abs_currentloans",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentWarmSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取当前加权平均贷款剩余期限时间序列
    return w.wsd(security,"abs_currentwarm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentWarm(security:list,*args,**kwargs):
    # 获取当前加权平均贷款剩余期限
    return w.wss(security,"abs_currentwarm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentWtGAvgRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取当前加权平均贷款利率时间序列
    return w.wsd(security,"abs_currentwtgavgrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCurrentWtGAvgRate(security:list,*args,**kwargs):
    # 获取当前加权平均贷款利率
    return w.wss(security,"abs_currentwtgavgrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCumulativeDefaultRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取累计违约率时间序列
    return w.wsd(security,"abs_cumulativedefaultrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCumulativeDefaultRate(security:list,*args,**kwargs):
    # 获取累计违约率
    return w.wss(security,"abs_cumulativedefaultrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDelinquencyRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取严重拖欠率时间序列
    return w.wsd(security,"abs_delinquencyrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDelinquencyRate(security:list,*args,**kwargs):
    # 获取严重拖欠率
    return w.wss(security,"abs_delinquencyrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCreditNormalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取承销团成员时间序列
    return w.wsd(security,"abs_creditnormal",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCreditNormal(security:list,*args,**kwargs):
    # 获取承销团成员
    return w.wss(security,"abs_creditnormal",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsIndustrySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体行业时间序列
    return w.wsd(security,"abs_industry",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsIndustry(security:list,*args,**kwargs):
    # 获取主体行业
    return w.wss(security,"abs_industry",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsIndustry1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体性质时间序列
    return w.wsd(security,"abs_industry1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsIndustry1(security:list,*args,**kwargs):
    # 获取主体性质
    return w.wss(security,"abs_industry1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsProvinceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体地区时间序列
    return w.wsd(security,"abs_province",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsProvince(security:list,*args,**kwargs):
    # 获取主体地区
    return w.wss(security,"abs_province",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsAgencyTrustee1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取受托机构时间序列
    return w.wsd(security,"abs_agency_trustee1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsAgencyTrustee1(security:list,*args,**kwargs):
    # 获取受托机构
    return w.wss(security,"abs_agency_trustee1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFullNameProSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取项目名称时间序列
    return w.wsd(security,"abs_fullnamepro",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFullNamePro(security:list,*args,**kwargs):
    # 获取项目名称
    return w.wss(security,"abs_fullnamepro",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsNameProSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取项目简称时间序列
    return w.wsd(security,"abs_namepro",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsNamePro(security:list,*args,**kwargs):
    # 获取项目简称
    return w.wss(security,"abs_namepro",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsProjectCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取项目代码时间序列
    return w.wsd(security,"abs_projectcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsProjectCode(security:list,*args,**kwargs):
    # 获取项目代码
    return w.wss(security,"abs_projectcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPayBackSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取还本方式时间序列
    return w.wsd(security,"abs_payback",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPayBack(security:list,*args,**kwargs):
    # 获取还本方式
    return w.wss(security,"abs_payback",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepayMethodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取提前还本方式时间序列
    return w.wsd(security,"prepaymethod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepayMethod(security:list,*args,**kwargs):
    # 获取提前还本方式
    return w.wss(security,"prepaymethod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsBorrowerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基础债务人时间序列
    return w.wsd(security,"abs_borrower",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsBorrower(security:list,*args,**kwargs):
    # 获取基础债务人
    return w.wss(security,"abs_borrower",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCoreIndustrySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基础债务人行业时间序列
    return w.wsd(security,"abs_coreindustry",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCoreIndustry(security:list,*args,**kwargs):
    # 获取基础债务人行业
    return w.wss(security,"abs_coreindustry",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCoreProvinceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基础债务人地区时间序列
    return w.wsd(security,"abs_coreprovince",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCoreProvince(security:list,*args,**kwargs):
    # 获取基础债务人地区
    return w.wss(security,"abs_coreprovince",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCorePropertySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基础债务人性质时间序列
    return w.wsd(security,"abs_coreproperty",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCoreProperty(security:list,*args,**kwargs):
    # 获取基础债务人性质
    return w.wss(security,"abs_coreproperty",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsRecommendCprSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取早偿率时间序列
    return w.wsd(security,"abs_recommendcpr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsRecommendCpr(security:list,*args,**kwargs):
    # 获取早偿率
    return w.wss(security,"abs_recommendcpr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsWeightedAverageMaturityWithPrepaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取加权平均期限时间序列
    return w.wsd(security,"abs_weightedaveragematuritywithprepay",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsWeightedAverageMaturityWithPrepay(security:list,*args,**kwargs):
    # 获取加权平均期限
    return w.wss(security,"abs_weightedaveragematuritywithprepay",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCreditSupportSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取信用支持时间序列
    return w.wsd(security,"abs_creditsupport",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCreditSupport(security:list,*args,**kwargs):
    # 获取信用支持
    return w.wss(security,"abs_creditsupport",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDealOutStStandingAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取项目余额时间序列
    return w.wsd(security,"abs_dealoutststandingamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDealOutStStandingAmount(security:list,*args,**kwargs):
    # 获取项目余额
    return w.wss(security,"abs_dealoutststandingamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFiExdCapitalCostRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定资金成本时间序列
    return w.wsd(security,"abs_fiexdcapitalcostrate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFiExdCapitalCostRate(security:list,*args,**kwargs):
    # 获取固定资金成本
    return w.wss(security,"abs_fiexdcapitalcostrate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCapYieldPerTermOfSubSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取次级每期收益率上限时间序列
    return w.wsd(security,"abs_capyieldpertermofSUB",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCapYieldPerTermOfSub(security:list,*args,**kwargs):
    # 获取次级每期收益率上限
    return w.wss(security,"abs_capyieldpertermofSUB",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsSelfSustainingProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自持比例时间序列
    return w.wsd(security,"abs_selfsustainingproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsSelfSustainingProportion(security:list,*args,**kwargs):
    # 获取自持比例
    return w.wss(security,"abs_selfsustainingproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsLegalMaturitySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取法定到期日时间序列
    return w.wsd(security,"abs_legalmaturity",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsLegalMaturity(security:list,*args,**kwargs):
    # 获取法定到期日
    return w.wss(security,"abs_legalmaturity",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPaymentDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取支付日时间序列
    return w.wsd(security,"abs_paymentdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsPaymentDate(security:list,*args,**kwargs):
    # 获取支付日
    return w.wss(security,"abs_paymentdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFirstPaymentDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首次支付日时间序列
    return w.wsd(security,"abs_firstpaymentdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsFirstPaymentDate(security:list,*args,**kwargs):
    # 获取首次支付日
    return w.wss(security,"abs_firstpaymentdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsExpectedMaturityWithPrepaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取早偿预期到期日时间序列
    return w.wsd(security,"abs_expectedmaturitywithprepay",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsExpectedMaturityWithPrepay(security:list,*args,**kwargs):
    # 获取早偿预期到期日
    return w.wss(security,"abs_expectedmaturitywithprepay",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCutoffDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取初始起算日时间序列
    return w.wsd(security,"abs_cutoffdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsCutoffDate(security:list,*args,**kwargs):
    # 获取初始起算日
    return w.wss(security,"abs_cutoffdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsStartDateOfAssetClearingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取清算起始日时间序列
    return w.wsd(security,"abs_startdateofassetclearing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsStartDateOfAssetClearing(security:list,*args,**kwargs):
    # 获取清算起始日
    return w.wss(security,"abs_startdateofassetclearing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsEnddateOfAssetClearingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取清算结束日时间序列
    return w.wsd(security,"abs_enddateofassetclearing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsEnddateOfAssetClearing(security:list,*args,**kwargs):
    # 获取清算结束日
    return w.wss(security,"abs_enddateofassetclearing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDefIGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取差额支付承诺人时间序列
    return w.wsd(security,"abs_defiguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsDefIGuarantor(security:list,*args,**kwargs):
    # 获取差额支付承诺人
    return w.wss(security,"abs_defiguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsTrusteeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取专项计划托管人时间序列
    return w.wsd(security,"abs_trustee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsTrustee(security:list,*args,**kwargs):
    # 获取专项计划托管人
    return w.wss(security,"abs_trustee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsAssetServiceAgencySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取资产服务机构时间序列
    return w.wsd(security,"abs_assetserviceagency",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAbsAssetServiceAgency(security:list,*args,**kwargs):
    # 获取资产服务机构
    return w.wss(security,"abs_assetserviceagency",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAccountTreatmentSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取会计处理时间序列
    return w.wsd(security,"accounttreatment",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAccountTreatment(security:list,*args,**kwargs):
    # 获取会计处理
    return w.wss(security,"accounttreatment",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChinaBondL1TypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中债债券一级分类时间序列
    return w.wsd(security,"chinabondl1type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChinaBondL1Type(security:list,*args,**kwargs):
    # 获取中债债券一级分类
    return w.wss(security,"chinabondl1type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChinaBondL2TypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取中债债券二级分类时间序列
    return w.wsd(security,"chinabondl2type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getChinaBondL2Type(security:list,*args,**kwargs):
    # 获取中债债券二级分类
    return w.wss(security,"chinabondl2type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBondWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否城投债(Wind)时间序列
    return w.wsd(security,"municipalbondWind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBondWind(security:list,*args,**kwargs):
    # 获取是否城投债(Wind)
    return w.wss(security,"municipalbondWind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否城投债时间序列
    return w.wsd(security,"municipalbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBond(security:list,*args,**kwargs):
    # 获取是否城投债
    return w.wss(security,"municipalbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBondyYSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否城投债(YY)时间序列
    return w.wsd(security,"municipalbondYY",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMunicipalBondyY(security:list,*args,**kwargs):
    # 获取是否城投债(YY)
    return w.wss(security,"municipalbondYY",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCityInvestmentBondGeoWindSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取城投行政级别(Wind)时间序列
    return w.wsd(security,"cityinvestmentbondgeoWind",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCityInvestmentBondGeoWind(security:list,*args,**kwargs):
    # 获取城投行政级别(Wind)
    return w.wss(security,"cityinvestmentbondgeoWind",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCityInvestmentBondGeoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取城投行政级别时间序列
    return w.wsd(security,"cityinvestmentbondgeo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCityInvestmentBondGeo(security:list,*args,**kwargs):
    # 获取城投行政级别
    return w.wss(security,"cityinvestmentbondgeo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMultiMktOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否跨市场交易时间序列
    return w.wsd(security,"multimktornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMultiMktOrNot(security:list,*args,**kwargs):
    # 获取是否跨市场交易
    return w.wss(security,"multimktornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSubordinateOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否次级债时间序列
    return w.wsd(security,"subordinateornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSubordinateOrNot(security:list,*args,**kwargs):
    # 获取是否次级债
    return w.wss(security,"subordinateornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMixCapitalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否混合资本债券时间序列
    return w.wsd(security,"mixcapital",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMixCapital(security:list,*args,**kwargs):
    # 获取是否混合资本债券
    return w.wss(security,"mixcapital",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAdditionalSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否增发时间序列
    return w.wsd(security,"issueadditional",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueAdditional(security:list,*args,**kwargs):
    # 获取是否增发
    return w.wss(security,"issueadditional",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdditionalToSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取增发债对应原债券时间序列
    return w.wsd(security,"additionalto",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAdditionalTo(security:list,*args,**kwargs):
    # 获取增发债对应原债券
    return w.wss(security,"additionalto",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerpetualOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否永续债时间序列
    return w.wsd(security,"perpetualornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPerpetualOrNot(security:list,*args,**kwargs):
    # 获取是否永续债
    return w.wss(security,"perpetualornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基准利率时间序列
    return w.wsd(security,"baserate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRate(security:list,*args,**kwargs):
    # 获取基准利率
    return w.wss(security,"baserate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCmBirSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基准利率确定方式时间序列
    return w.wsd(security,"cmbir",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCmBir(security:list,*args,**kwargs):
    # 获取基准利率确定方式
    return w.wss(security,"cmbir",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRate2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取基准利率(发行时)时间序列
    return w.wsd(security,"baserate2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRate2(security:list,*args,**kwargs):
    # 获取基准利率(发行时)
    return w.wss(security,"baserate2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRate3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取基准利率(指定日期)时间序列
    return w.wsd(security,"baserate3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBaseRate3(security:list,*args,**kwargs):
    # 获取基准利率(指定日期)
    return w.wss(security,"baserate3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcFloatBenchSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取计算浮息债隐含基准利率时间序列
    return w.wsd(security,"calc_floatbench",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCalcFloatBench(security:list,*args,**kwargs):
    # 获取计算浮息债隐含基准利率
    return w.wss(security,"calc_floatbench",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSpreadSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取固定利差时间序列
    return w.wsd(security,"spread",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSpread(security:list,*args,**kwargs):
    # 获取固定利差
    return w.wss(security,"spread",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFirstPriceDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首个定价日时间序列
    return w.wsd(security,"issue_firstpricedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueFirstPriceDate(security:list,*args,**kwargs):
    # 获取首个定价日
    return w.wss(security,"issue_firstpricedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRate2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取票面利率(当期)时间序列
    return w.wsd(security,"couponrate2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRate2(security:list,*args,**kwargs):
    # 获取票面利率(当期)
    return w.wss(security,"couponrate2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRate3Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取票面利率(指定日期)时间序列
    return w.wsd(security,"couponrate3",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponRate3(security:list,*args,**kwargs):
    # 获取票面利率(指定日期)
    return w.wss(security,"couponrate3",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSpread2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权后利差时间序列
    return w.wsd(security,"spread2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getSpread2(security:list,*args,**kwargs):
    # 获取行权后利差
    return w.wss(security,"spread2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestFloorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取保底利率时间序列
    return w.wsd(security,"interestfloor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInterestFloor(security:list,*args,**kwargs):
    # 获取保底利率
    return w.wss(security,"interestfloor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmbeddedOptSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否含权债时间序列
    return w.wsd(security,"embeddedopt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEmbeddedOpt(security:list,*args,**kwargs):
    # 获取是否含权债
    return w.wss(security,"embeddedopt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特殊条款时间序列
    return w.wsd(security,"clause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClause(security:list,*args,**kwargs):
    # 获取特殊条款
    return w.wss(security,"clause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseAbbrSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特殊条款(缩写)时间序列
    return w.wsd(security,"clauseabbr",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseAbbr(security:list,*args,**kwargs):
    # 获取特殊条款(缩写)
    return w.wss(security,"clauseabbr",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定条款文字时间序列
    return w.wsd(security,"clauseitem",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseItem(security:list,*args,**kwargs):
    # 获取指定条款文字
    return w.wss(security,"clauseitem",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExecMaturityEmbeddedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取含权债行权期限时间序列
    return w.wsd(security,"execmaturityembedded",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExecMaturityEmbedded(security:list,*args,**kwargs):
    # 获取含权债行权期限
    return w.wss(security,"execmaturityembedded",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEObSpecialInStrutIonsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取含权债期限特殊说明时间序列
    return w.wsd(security,"eobspecialinstrutions",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getEObSpecialInStrutIons(security:list,*args,**kwargs):
    # 获取含权债期限特殊说明
    return w.wss(security,"eobspecialinstrutions",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepaymentDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取提前还本日时间序列
    return w.wsd(security,"prepaymentdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepaymentDate(security:list,*args,**kwargs):
    # 获取提前还本日
    return w.wss(security,"prepaymentdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepayPortionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取提前还本比例时间序列
    return w.wsd(security,"prepayportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrepayPortion(security:list,*args,**kwargs):
    # 获取提前还本比例
    return w.wss(security,"prepayportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回日时间序列
    return w.wsd(security,"redemptiondate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionDate(security:list,*args,**kwargs):
    # 获取赎回日
    return w.wss(security,"redemptiondate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售日时间序列
    return w.wsd(security,"repurchasedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseDate(security:list,*args,**kwargs):
    # 获取回售日
    return w.wss(security,"repurchasedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回价格时间序列
    return w.wsd(security,"clause_calloption_redemptionprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionPrice(security:list,*args,**kwargs):
    # 获取赎回价格
    return w.wss(security,"clause_calloption_redemptionprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionMemoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回价格说明时间序列
    return w.wsd(security,"clause_calloption_redemptionmemo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionMemo(security:list,*args,**kwargs):
    # 获取赎回价格说明
    return w.wss(security,"clause_calloption_redemptionmemo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionResellingPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售价格时间序列
    return w.wsd(security,"clause_putoption_resellingprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionResellingPrice(security:list,*args,**kwargs):
    # 获取回售价格
    return w.wss(security,"clause_putoption_resellingprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionResellingPriceExplainAtionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售价格说明时间序列
    return w.wsd(security,"clause_putoption_resellingpriceexplaination",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionResellingPriceExplainAtion(security:list,*args,**kwargs):
    # 获取回售价格说明
    return w.wss(security,"clause_putoption_resellingpriceexplaination",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionAdditionalPriceMemoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取附加回售价格说明时间序列
    return w.wsd(security,"clause_putoption_additionalpricememo",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionAdditionalPriceMemo(security:list,*args,**kwargs):
    # 获取附加回售价格说明
    return w.wss(security,"clause_putoption_additionalpricememo",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售代码时间序列
    return w.wsd(security,"putcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPutCode(security:list,*args,**kwargs):
    # 获取回售代码
    return w.wss(security,"putcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseBeginDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售登记起始日时间序列
    return w.wsd(security,"repurchasebegindate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseBeginDate(security:list,*args,**kwargs):
    # 获取回售登记起始日
    return w.wss(security,"repurchasebegindate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售登记截止日时间序列
    return w.wsd(security,"repurchaseenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRepurchaseEnddate(security:list,*args,**kwargs):
    # 获取回售登记截止日
    return w.wss(security,"repurchaseenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFunDarRialDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取行权资金到账日时间序列
    return w.wsd(security,"fundarrialdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFunDarRialDate(security:list,*args,**kwargs):
    # 获取行权资金到账日
    return w.wss(security,"fundarrialdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponAdjMaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取票面利率调整上限时间序列
    return w.wsd(security,"couponadj_max",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponAdjMax(security:list,*args,**kwargs):
    # 获取票面利率调整上限
    return w.wss(security,"couponadj_max",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponAdjMinSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取票面利率调整下限时间序列
    return w.wsd(security,"couponadj_min",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCouponAdjMin(security:list,*args,**kwargs):
    # 获取票面利率调整下限
    return w.wss(security,"couponadj_min",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRecordDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回登记日时间序列
    return w.wsd(security,"clause_calloption_recorddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRecordDate(security:list,*args,**kwargs):
    # 获取赎回登记日
    return w.wss(security,"clause_calloption_recorddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人时间序列
    return w.wsd(security,"agency_guarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGuarantor(security:list,*args,**kwargs):
    # 获取担保人
    return w.wss(security,"agency_guarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateRateGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人评级时间序列
    return w.wsd(security,"rate_rateguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateRateGuarantor(security:list,*args,**kwargs):
    # 获取担保人评级
    return w.wss(security,"rate_rateguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFwdGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人评级展望时间序列
    return w.wsd(security,"rate_fwdguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFwdGuarantor(security:list,*args,**kwargs):
    # 获取担保人评级展望
    return w.wss(security,"rate_fwdguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人评级变动方向时间序列
    return w.wsd(security,"rate_chngguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgGuarantor(security:list,*args,**kwargs):
    # 获取担保人评级变动方向
    return w.wss(security,"rate_chngguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保人评级评级机构时间序列
    return w.wsd(security,"rate_agencyguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyGuarantor(security:list,*args,**kwargs):
    # 获取担保人评级评级机构
    return w.wss(security,"rate_agencyguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyReGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取再担保人时间序列
    return w.wsd(security,"agency_reguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyReGuarantor(security:list,*args,**kwargs):
    # 获取再担保人
    return w.wss(security,"agency_reguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateBeginGuarantorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时担保人评级时间序列
    return w.wsd(security,"rate_beginguarantor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateBeginGuarantor(security:list,*args,**kwargs):
    # 获取发行时担保人评级
    return w.wss(security,"rate_beginguarantor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGrNtTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保方式时间序列
    return w.wsd(security,"agency_grnttype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGrNtType(security:list,*args,**kwargs):
    # 获取担保方式
    return w.wss(security,"agency_grnttype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarTermSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保期限时间序列
    return w.wsd(security,"guarterm",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarTerm(security:list,*args,**kwargs):
    # 获取担保期限
    return w.wss(security,"guarterm",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarRangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保范围时间序列
    return w.wsd(security,"guarrange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarRange(security:list,*args,**kwargs):
    # 获取担保范围
    return w.wss(security,"guarrange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGrNtRangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取担保条款文字时间序列
    return w.wsd(security,"agency_grntrange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyGrNtRange(security:list,*args,**kwargs):
    # 获取担保条款文字
    return w.wss(security,"agency_grntrange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCounterGuarSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取反担保情况时间序列
    return w.wsd(security,"counterguar",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCounterGuar(security:list,*args,**kwargs):
    # 获取反担保情况
    return w.wss(security,"counterguar",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCvnTPerHundredSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取标准券折算金额(每百元面值)时间序列
    return w.wsd(security,"cvntperhundred",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCvnTPerHundred(security:list,*args,**kwargs):
    # 获取标准券折算金额(每百元面值)
    return w.wss(security,"cvntperhundred",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCollateralCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押券代码时间序列
    return w.wsd(security,"collateralcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCollateralCode(security:list,*args,**kwargs):
    # 获取质押券代码
    return w.wss(security,"collateralcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCollateralNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取质押券简称时间序列
    return w.wsd(security,"collateralname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCollateralName(security:list,*args,**kwargs):
    # 获取质押券简称
    return w.wss(security,"collateralname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPledGableOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否可质押时间序列
    return w.wsd(security,"fund_pledgableornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPledGableOrNot(security:list,*args,**kwargs):
    # 获取是否可质押
    return w.wss(security,"fund_pledgableornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateOfStdBndCsiSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报价式回购折算率(中证指数)时间序列
    return w.wsd(security,"rateofstdbndcsi",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateOfStdBndCsi(security:list,*args,**kwargs):
    # 获取报价式回购折算率(中证指数)
    return w.wss(security,"rateofstdbndcsi",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest5Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否随存款利率调整时间序列
    return w.wsd(security,"clause_interest_5",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest5(security:list,*args,**kwargs):
    # 获取是否随存款利率调整
    return w.wss(security,"clause_interest_5",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest8Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否有利息补偿时间序列
    return w.wsd(security,"clause_interest_8",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterest8(security:list,*args,**kwargs):
    # 获取是否有利息补偿
    return w.wss(security,"clause_interest_8",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterestCompensationInterestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取补偿利率时间序列
    return w.wsd(security,"clause_interest_compensationinterest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseInterestCompensationInterest(security:list,*args,**kwargs):
    # 获取补偿利率
    return w.wss(security,"clause_interest_compensationinterest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCompensationInterestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取补偿利率(公布)时间序列
    return w.wsd(security,"clause_compensationinterest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCompensationInterest(security:list,*args,**kwargs):
    # 获取补偿利率(公布)
    return w.wss(security,"clause_compensationinterest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseProcessModeInterestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取利息处理方式时间序列
    return w.wsd(security,"clause_processmodeinterest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseProcessModeInterest(security:list,*args,**kwargs):
    # 获取利息处理方式
    return w.wss(security,"clause_processmodeinterest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股代码时间序列
    return w.wsd(security,"underlyingcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingCode(security:list,*args,**kwargs):
    # 获取正股代码
    return w.wss(security,"underlyingcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取正股简称时间序列
    return w.wsd(security,"underlyingname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getUnderlyingName(security:list,*args,**kwargs):
    # 获取正股简称
    return w.wss(security,"underlyingname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2RelativeSwapShareMonthSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对转股期时间序列
    return w.wsd(security,"clause_conversion_2_relativeswapsharemonth",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2RelativeSwapShareMonth(security:list,*args,**kwargs):
    # 获取相对转股期
    return w.wss(security,"clause_conversion_2_relativeswapsharemonth",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapShareStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自愿转股起始日期时间序列
    return w.wsd(security,"clause_conversion_2_swapsharestartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapShareStartDate(security:list,*args,**kwargs):
    # 获取自愿转股起始日期
    return w.wss(security,"clause_conversion_2_swapsharestartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapShareEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取自愿转股终止日期时间序列
    return w.wsd(security,"clause_conversion_2_swapshareenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapShareEnddate(security:list,*args,**kwargs):
    # 获取自愿转股终止日期
    return w.wss(security,"clause_conversion_2_swapshareenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2IsForcedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否强制转股时间序列
    return w.wsd(security,"clause_conversion_2_isforced",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2IsForced(security:list,*args,**kwargs):
    # 获取是否强制转股
    return w.wss(security,"clause_conversion_2_isforced",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ForceConvertDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取强制转股日时间序列
    return w.wsd(security,"clause_conversion_2_forceconvertdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ForceConvertDate(security:list,*args,**kwargs):
    # 获取强制转股日
    return w.wss(security,"clause_conversion_2_forceconvertdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ForceConvertPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取强制转股价格时间序列
    return w.wsd(security,"clause_conversion_2_forceconvertprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ForceConvertPrice(security:list,*args,**kwargs):
    # 获取强制转股价格
    return w.wss(security,"clause_conversion_2_forceconvertprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapSharePriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转股价格时间序列
    return w.wsd(security,"clause_conversion2_swapshareprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2SwapSharePrice(security:list,*args,**kwargs):
    # 获取转股价格
    return w.wss(security,"clause_conversion2_swapshareprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversionCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转股代码时间序列
    return w.wsd(security,"clause_conversion_code",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversionCode(security:list,*args,**kwargs):
    # 获取转股代码
    return w.wss(security,"clause_conversion_code",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ConversionProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转换比例时间序列
    return w.wsd(security,"clause_conversion2_conversionproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ConversionProportion(security:list,*args,**kwargs):
    # 获取转换比例
    return w.wss(security,"clause_conversion2_conversionproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2BondLotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未转股余额时间序列
    return w.wsd(security,"clause_conversion2_bondlot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2BondLot(security:list,*args,**kwargs):
    # 获取未转股余额
    return w.wss(security,"clause_conversion2_bondlot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2BondProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未转股比例时间序列
    return w.wsd(security,"clause_conversion2_bondproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2BondProportion(security:list,*args,**kwargs):
    # 获取未转股比例
    return w.wss(security,"clause_conversion2_bondproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ConversionProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取转股价随派息调整时间序列
    return w.wsd(security,"clause_conversion_2_conversionproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseConversion2ConversionProportion(security:list,*args,**kwargs):
    # 获取转股价随派息调整
    return w.wss(security,"clause_conversion_2_conversionproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetItemSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特别向下修正条款全文时间序列
    return w.wsd(security,"clause_reset_item",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetItem(security:list,*args,**kwargs):
    # 获取特别向下修正条款全文
    return w.wss(security,"clause_reset_item",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetIsExitResetSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否有特别向下修正条款时间序列
    return w.wsd(security,"clause_reset_isexitreset",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetIsExitReset(security:list,*args,**kwargs):
    # 获取是否有特别向下修正条款
    return w.wss(security,"clause_reset_isexitreset",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特别修正起始时间时间序列
    return w.wsd(security,"clause_reset_resetstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetStartDate(security:list,*args,**kwargs):
    # 获取特别修正起始时间
    return w.wss(security,"clause_reset_resetstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetPeriodEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特别修正结束时间时间序列
    return w.wsd(security,"clause_reset_resetperiodenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetPeriodEnddate(security:list,*args,**kwargs):
    # 获取特别修正结束时间
    return w.wss(security,"clause_reset_resetperiodenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetMaxTimespanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重设触发计算最大时间区间时间序列
    return w.wsd(security,"clause_reset_resetmaxtimespan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetMaxTimespan(security:list,*args,**kwargs):
    # 获取重设触发计算最大时间区间
    return w.wss(security,"clause_reset_resetmaxtimespan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTimespanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取重设触发计算时间区间时间序列
    return w.wsd(security,"clause_reset_resettimespan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTimespan(security:list,*args,**kwargs):
    # 获取重设触发计算时间区间
    return w.wss(security,"clause_reset_resettimespan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTriggerRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取触发比例时间序列
    return w.wsd(security,"clause_reset_resettriggerratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTriggerRatio(security:list,*args,**kwargs):
    # 获取触发比例
    return w.wss(security,"clause_reset_resettriggerratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTriggerProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回触发比例时间序列
    return w.wsd(security,"clause_calloption_triggerproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTriggerProportion(security:list,*args,**kwargs):
    # 获取赎回触发比例
    return w.wss(security,"clause_calloption_triggerproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionRedeemTriggerProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售触发比例时间序列
    return w.wsd(security,"clause_putoption_redeem_triggerproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionRedeemTriggerProportion(security:list,*args,**kwargs):
    # 获取回售触发比例
    return w.wss(security,"clause_putoption_redeem_triggerproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetRangeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取特别修正幅度时间序列
    return w.wsd(security,"clause_reset_resetrange",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetRange(security:list,*args,**kwargs):
    # 获取特别修正幅度
    return w.wss(security,"clause_reset_resetrange",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetStockPriceLowestLimitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取修正价格底线说明时间序列
    return w.wsd(security,"clause_reset_stockpricelowestlimit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetStockPriceLowestLimit(security:list,*args,**kwargs):
    # 获取修正价格底线说明
    return w.wss(security,"clause_reset_stockpricelowestlimit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTimesLimitSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取修正次数限制时间序列
    return w.wsd(security,"clause_reset_resettimeslimit",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetResetTimesLimit(security:list,*args,**kwargs):
    # 获取修正次数限制
    return w.wss(security,"clause_reset_resettimeslimit",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetTimePointClauseSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时点修正条款全文时间序列
    return w.wsd(security,"clause_reset_timepointclause",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseResetTimePointClause(security:list,*args,**kwargs):
    # 获取时点修正条款全文
    return w.wss(security,"clause_reset_timepointclause",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRelativeCallOptionPeriodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对赎回期时间序列
    return w.wsd(security,"clause_calloption_relativecalloptionperiod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRelativeCallOptionPeriod(security:list,*args,**kwargs):
    # 获取相对赎回期
    return w.wss(security,"clause_calloption_relativecalloptionperiod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionTimesPerYearSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每年可赎回次数时间序列
    return w.wsd(security,"clause_calloption_redemptiontimesperyear",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedemptionTimesPerYear(security:list,*args,**kwargs):
    # 获取每年可赎回次数
    return w.wss(security,"clause_calloption_redemptiontimesperyear",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionConditionalRedeemStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取条件赎回起始日期时间序列
    return w.wsd(security,"clause_calloption_conditionalredeemstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionConditionalRedeemStartDate(security:list,*args,**kwargs):
    # 获取条件赎回起始日期
    return w.wss(security,"clause_calloption_conditionalredeemstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionConditionalRedeemEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取条件赎回截止日期时间序列
    return w.wsd(security,"clause_calloption_conditionalredeemenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionConditionalRedeemEnddate(security:list,*args,**kwargs):
    # 获取条件赎回截止日期
    return w.wss(security,"clause_calloption_conditionalredeemenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemMaxSpanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回触发计算最大时间区间时间序列
    return w.wsd(security,"clause_calloption_redeemmaxspan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemMaxSpan(security:list,*args,**kwargs):
    # 获取赎回触发计算最大时间区间
    return w.wss(security,"clause_calloption_redeemmaxspan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemSpanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回触发计算时间区间时间序列
    return w.wsd(security,"clause_calloption_redeemspan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionRedeemSpan(security:list,*args,**kwargs):
    # 获取赎回触发计算时间区间
    return w.wss(security,"clause_calloption_redeemspan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionInterestDisposingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取利息处理时间序列
    return w.wsd(security,"clause_putoption_interestdisposing",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionInterestDisposing(security:list,*args,**kwargs):
    # 获取利息处理
    return w.wss(security,"clause_putoption_interestdisposing",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTimeRedemptionTimesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时点赎回数时间序列
    return w.wsd(security,"clause_calloption_timeredemptiontimes",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTimeRedemptionTimes(security:list,*args,**kwargs):
    # 获取时点赎回数
    return w.wss(security,"clause_calloption_timeredemptiontimes",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConditionalCallPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取有条件赎回价时间序列
    return w.wsd(security,"conditionalcallprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConditionalCallPrice(security:list,*args,**kwargs):
    # 获取有条件赎回价
    return w.wss(security,"conditionalcallprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaturityCallPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取到期赎回价时间序列
    return w.wsd(security,"maturitycallprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMaturityCallPrice(security:list,*args,**kwargs):
    # 获取到期赎回价
    return w.wss(security,"maturitycallprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTriggerPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回触发价时间序列
    return w.wsd(security,"clause_calloption_triggerprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionTriggerPrice(security:list,*args,**kwargs):
    # 获取赎回触发价
    return w.wss(security,"clause_calloption_triggerprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionNoticeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回公告日时间序列
    return w.wsd(security,"clause_calloption_noticedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClauseCallOptionNoticeDate(security:list,*args,**kwargs):
    # 获取赎回公告日
    return w.wss(security,"clause_calloption_noticedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPeriodObSSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取相对回售期时间序列
    return w.wsd(security,"clause_putoption_putbackperiodobs",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPeriodObS(security:list,*args,**kwargs):
    # 获取相对回售期
    return w.wss(security,"clause_putoption_putbackperiodobs",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionConditionalPutBackStartEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取条件回售起始日期时间序列
    return w.wsd(security,"clause_putoption_conditionalputbackstartenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionConditionalPutBackStartEnddate(security:list,*args,**kwargs):
    # 获取条件回售起始日期
    return w.wss(security,"clause_putoption_conditionalputbackstartenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无条件回售起始日期时间序列
    return w.wsd(security,"clause_putoption_putbackstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackStartDate(security:list,*args,**kwargs):
    # 获取无条件回售起始日期
    return w.wss(security,"clause_putoption_putbackstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionConditionalPutBackEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取条件回售截止日期时间序列
    return w.wsd(security,"clause_putoption_conditionalputbackenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionConditionalPutBackEnddate(security:list,*args,**kwargs):
    # 获取条件回售截止日期
    return w.wss(security,"clause_putoption_conditionalputbackenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTriggerMaxSpanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售触发计算最大时间区间时间序列
    return w.wsd(security,"clause_putoption_putbacktriggermaxspan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTriggerMaxSpan(security:list,*args,**kwargs):
    # 获取回售触发计算最大时间区间
    return w.wss(security,"clause_putoption_putbacktriggermaxspan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTriggerSpanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售触发计算时间区间时间序列
    return w.wsd(security,"clause_putoption_putbacktriggerspan",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTriggerSpan(security:list,*args,**kwargs):
    # 获取回售触发计算时间区间
    return w.wss(security,"clause_putoption_putbacktriggerspan",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTimesPerYearSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取每年回售次数时间序列
    return w.wsd(security,"clause_putoption_putbacktimesperyear",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackTimesPerYear(security:list,*args,**kwargs):
    # 获取每年回售次数
    return w.wss(security,"clause_putoption_putbacktimesperyear",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPeriodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无条件回售期时间序列
    return w.wsd(security,"clause_putoption_putbackperiod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPeriod(security:list,*args,**kwargs):
    # 获取无条件回售期
    return w.wss(security,"clause_putoption_putbackperiod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无条件回售结束日期时间序列
    return w.wsd(security,"clause_putoption_putbackenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackEnddate(security:list,*args,**kwargs):
    # 获取无条件回售结束日期
    return w.wss(security,"clause_putoption_putbackenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取无条件回售价时间序列
    return w.wsd(security,"clause_putoption_putbackprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackPrice(security:list,*args,**kwargs):
    # 获取无条件回售价
    return w.wss(security,"clause_putoption_putbackprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTimePutBackTimesSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取时点回售数时间序列
    return w.wsd(security,"clause_putoption_timeputbacktimes",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTimePutBackTimes(security:list,*args,**kwargs):
    # 获取时点回售数
    return w.wss(security,"clause_putoption_timeputbacktimes",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackAdditionalConditionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取附加回售条件时间序列
    return w.wsd(security,"clause_putoption_putbackadditionalcondition",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionPutBackAdditionalCondition(security:list,*args,**kwargs):
    # 获取附加回售条件
    return w.wss(security,"clause_putoption_putbackadditionalcondition",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConditionalPutPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取有条件回售价时间序列
    return w.wsd(security,"conditionalputprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getConditionalPutPrice(security:list,*args,**kwargs):
    # 获取有条件回售价
    return w.wss(security,"conditionalputprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTriggerPriceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售触发价时间序列
    return w.wsd(security,"clause_putoption_triggerprice",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionTriggerPrice(security:list,*args,**kwargs):
    # 获取回售触发价
    return w.wss(security,"clause_putoption_triggerprice",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionNoticeDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取回售公告日时间序列
    return w.wsd(security,"clause_putoption_noticedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getClausePutOptionNoticeDate(security:list,*args,**kwargs):
    # 获取回售公告日
    return w.wss(security,"clause_putoption_noticedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时债项评级时间序列
    return w.wsd(security,"creditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditRating(security:list,*args,**kwargs):
    # 获取发行时债项评级
    return w.wss(security,"creditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时主体评级时间序列
    return w.wsd(security,"issuer_rating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerRating(security:list,*args,**kwargs):
    # 获取发行时主体评级
    return w.wss(security,"issuer_rating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerRatingOutlookSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行时主体评级展望时间序列
    return w.wsd(security,"issuerratingoutlook",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssuerRatingOutlook(security:list,*args,**kwargs):
    # 获取发行时主体评级展望
    return w.wss(security,"issuerratingoutlook",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateCreditRatingAgencySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人委托评级机构时间序列
    return w.wsd(security,"rate_creditratingagency",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateCreditRatingAgency(security:list,*args,**kwargs):
    # 获取发行人委托评级机构
    return w.wss(security,"rate_creditratingagency",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIsSurerCreditRatingCompanySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发债主体评级机构时间序列
    return w.wsd(security,"issurercreditratingcompany",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIsSurerCreditRatingCompany(security:list,*args,**kwargs):
    # 获取发债主体评级机构
    return w.wss(security,"issurercreditratingcompany",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新债项评级时间序列
    return w.wsd(security,"amount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAmount(security:list,*args,**kwargs):
    # 获取最新债项评级
    return w.wss(security,"amount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLatestSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新债项评级日期时间序列
    return w.wsd(security,"rate_latest",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLatest(security:list,*args,**kwargs):
    # 获取最新债项评级日期
    return w.wss(security,"rate_latest",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLatest1Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新债项评级日期(指定机构)时间序列
    return w.wsd(security,"rate_latest1",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateLatest1(security:list,*args,**kwargs):
    # 获取最新债项评级日期(指定机构)
    return w.wss(security,"rate_latest1",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChangesOfRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新债项评级变动方向时间序列
    return w.wsd(security,"rate_changesofrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChangesOfRating(security:list,*args,**kwargs):
    # 获取最新债项评级变动方向
    return w.wss(security,"rate_changesofrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateStyleSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新债项评级评级类型时间序列
    return w.wsd(security,"rate_style",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateStyle(security:list,*args,**kwargs):
    # 获取最新债项评级评级类型
    return w.wss(security,"rate_style",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowestIsSurerCreditRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行人最新最低评级时间序列
    return w.wsd(security,"lowestissurercreditrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLowestIsSurerCreditRating(security:list,*args,**kwargs):
    # 获取发行人最新最低评级
    return w.wss(security,"lowestissurercreditrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateRateBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债项评级时间序列
    return w.wsd(security,"rate_ratebond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateRateBond(security:list,*args,**kwargs):
    # 获取债项评级
    return w.wss(security,"rate_ratebond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债项评级变动方向时间序列
    return w.wsd(security,"rate_chngbond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgBond(security:list,*args,**kwargs):
    # 获取债项评级变动方向
    return w.wss(security,"rate_chngbond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyBondSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取债项评级机构时间序列
    return w.wsd(security,"rate_agencybond",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyBond(security:list,*args,**kwargs):
    # 获取债项评级机构
    return w.wss(security,"rate_agencybond",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFormerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史债项评级时间序列
    return w.wsd(security,"rate_former",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFormer(security:list,*args,**kwargs):
    # 获取历史债项评级
    return w.wss(security,"rate_former",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取(废弃)债项评级(YY)时间序列
    return w.wsd(security,"inst_yybondrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyBondRating(security:list,*args,**kwargs):
    # 获取(废弃)债项评级(YY)
    return w.wss(security,"inst_yybondrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRating2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级时间序列
    return w.wsd(security,"latestissurercreditrating2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getLatestIsSurerCreditRating2(security:list,*args,**kwargs):
    # 获取主体评级
    return w.wss(security,"latestissurercreditrating2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFwdIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级展望时间序列
    return w.wsd(security,"rate_fwdissuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateFwdIssuer(security:list,*args,**kwargs):
    # 获取主体评级展望
    return w.wss(security,"rate_fwdissuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级变动方向时间序列
    return w.wsd(security,"rate_chngissuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateChNgIssuer(security:list,*args,**kwargs):
    # 获取主体评级变动方向
    return w.wss(security,"rate_chngissuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级评级机构时间序列
    return w.wsd(security,"rate_agencyissuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateAgencyIssuer(security:list,*args,**kwargs):
    # 获取主体评级评级机构
    return w.wss(security,"rate_agencyissuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyIssuerRatingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级(YY)时间序列
    return w.wsd(security,"inst_yyissuerrating",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyIssuerRating(security:list,*args,**kwargs):
    # 获取主体评级(YY)
    return w.wss(security,"inst_yyissuerrating",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyIssuerRatingHisSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主体评级历史(YY)时间序列
    return w.wsd(security,"inst_yyissuerratinghis",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getInStYyIssuerRatingHis(security:list,*args,**kwargs):
    # 获取主体评级历史(YY)
    return w.wss(security,"inst_yyissuerratinghis",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指定日主体评级时间序列
    return w.wsd(security,"rate_issuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateIssuer(security:list,*args,**kwargs):
    # 获取指定日主体评级
    return w.wss(security,"rate_issuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateIssuerFormerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发债主体历史信用等级时间序列
    return w.wsd(security,"rate_issuerformer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRateIssuerFormer(security:list,*args,**kwargs):
    # 获取发债主体历史信用等级
    return w.wss(security,"rate_issuerformer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新授信额度时间序列
    return w.wsd(security,"credit_line",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLine(security:list,*args,**kwargs):
    # 获取最新授信额度
    return w.wss(security,"credit_line",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUsedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新已使用授信额度时间序列
    return w.wsd(security,"credit_lineused",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUsed(security:list,*args,**kwargs):
    # 获取最新已使用授信额度
    return w.wss(security,"credit_lineused",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUnusedSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新未使用授信额度时间序列
    return w.wsd(security,"credit_lineunused",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUnused(security:list,*args,**kwargs):
    # 获取最新未使用授信额度
    return w.wss(security,"credit_lineunused",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUsed2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史已使用授信额度时间序列
    return w.wsd(security,"credit_lineused2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineUsed2(security:list,*args,**kwargs):
    # 获取历史已使用授信额度
    return w.wss(security,"credit_lineused2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditFormerLineSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史授信额度时间序列
    return w.wsd(security,"credit_formerline",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditFormerLine(security:list,*args,**kwargs):
    # 获取历史授信额度
    return w.wss(security,"credit_formerline",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新授信日期时间序列
    return w.wsd(security,"credit_linedate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getCreditLineDate(security:list,*args,**kwargs):
    # 获取最新授信日期
    return w.wss(security,"credit_linedate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestBalanceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新担保余额时间序列
    return w.wsd(security,"guar_latestbalance",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestBalance(security:list,*args,**kwargs):
    # 获取最新担保余额
    return w.wss(security,"guar_latestbalance",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestInwardsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新对内担保余额时间序列
    return w.wsd(security,"guar_latestinwards",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestInwards(security:list,*args,**kwargs):
    # 获取最新对内担保余额
    return w.wss(security,"guar_latestinwards",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestOutwardsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新对外担保余额时间序列
    return w.wsd(security,"guar_latestoutwards",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarLatestOutwards(security:list,*args,**kwargs):
    # 获取最新对外担保余额
    return w.wss(security,"guar_latestoutwards",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerBalanceSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史担保余额时间序列
    return w.wsd(security,"guar_formerbalance",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerBalance(security:list,*args,**kwargs):
    # 获取历史担保余额
    return w.wss(security,"guar_formerbalance",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerInwardsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取对内担保余额时间序列
    return w.wsd(security,"guar_formerinwards",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerInwards(security:list,*args,**kwargs):
    # 获取对内担保余额
    return w.wss(security,"guar_formerinwards",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerOutwardsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取对外担保余额时间序列
    return w.wsd(security,"guar_formeroutwards",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getGuarFormerOutwards(security:list,*args,**kwargs):
    # 获取对外担保余额
    return w.wss(security,"guar_formeroutwards",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUnuEsDAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取实际可用剩余额度时间序列
    return w.wsd(security,"dcm_unuesdamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUnuEsDAmount(security:list,*args,**kwargs):
    # 获取实际可用剩余额度
    return w.wss(security,"dcm_unuesdamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUeSdAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取已使用注册额度时间序列
    return w.wsd(security,"dcm_uesdamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUeSdAmount(security:list,*args,**kwargs):
    # 获取已使用注册额度
    return w.wss(security,"dcm_uesdamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmFirstIssueEnddateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取首期发行截止日时间序列
    return w.wsd(security,"dcm_firstissueenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmFirstIssueEnddate(security:list,*args,**kwargs):
    # 获取首期发行截止日
    return w.wss(security,"dcm_firstissueenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmMeetingDataSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未使用注册会议日期时间序列
    return w.wsd(security,"dcm_meetingdata",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmMeetingData(security:list,*args,**kwargs):
    # 获取未使用注册会议日期
    return w.wss(security,"dcm_meetingdata",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmExpirationDataSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未使用额度有效期时间序列
    return w.wsd(security,"dcm_expirationdata",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmExpirationData(security:list,*args,**kwargs):
    # 获取未使用额度有效期
    return w.wss(security,"dcm_expirationdata",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最新注册文件编号时间序列
    return w.wsd(security,"dcm_number",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmNumber(security:list,*args,**kwargs):
    # 获取最新注册文件编号
    return w.wss(security,"dcm_number",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUnderwriterSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取未使用额度主承销商时间序列
    return w.wsd(security,"dcm_underwriter",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmUnderwriter(security:list,*args,**kwargs):
    # 获取未使用额度主承销商
    return w.wss(security,"dcm_underwriter",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmAcCumAmountSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取历史累计注册额度时间序列
    return w.wsd(security,"dcm_accumamount",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getDCmAcCumAmount(security:list,*args,**kwargs):
    # 获取历史累计注册额度
    return w.wss(security,"dcm_accumamount",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalAmount2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间发行债券总额时间序列
    return w.wsd(security,"fina_totalamount2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalAmount2(security:list,*args,**kwargs):
    # 获取区间发行债券总额
    return w.wss(security,"fina_totalamount2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取区间发行债券数目时间序列
    return w.wsd(security,"fina_totalnumber",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaTotalNumber(security:list,*args,**kwargs):
    # 获取区间发行债券数目
    return w.wss(security,"fina_totalnumber",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaRemainingNumberSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取存量债券数目时间序列
    return w.wsd(security,"fina_remainingnumber",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFinaRemainingNumber(security:list,*args,**kwargs):
    # 获取存量债券数目
    return w.wss(security,"fina_remainingnumber",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInfoNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金简称时间序列
    return w.wsd(security,"fund_info_name",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInfoName(security:list,*args,**kwargs):
    # 获取基金简称
    return w.wss(security,"fund_info_name",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNameOfficialSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金简称(官方)时间序列
    return w.wsd(security,"name_official",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNameOfficial(security:list,*args,**kwargs):
    # 获取基金简称(官方)
    return w.wss(security,"name_official",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFullNameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金全称时间序列
    return w.wsd(security,"fund_fullname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFullName(security:list,*args,**kwargs):
    # 获取基金全称
    return w.wss(security,"fund_fullname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFullNameEnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金全称(英文)时间序列
    return w.wsd(security,"fund_fullnameen",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFullNameEn(security:list,*args,**kwargs):
    # 获取基金全称(英文)
    return w.wss(security,"fund_fullnameen",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeShortnameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金场内简称时间序列
    return w.wsd(security,"fund_exchangeshortname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeShortname(security:list,*args,**kwargs):
    # 获取基金场内简称
    return w.wss(security,"fund_exchangeshortname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeShortnameExtendSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金扩位场内简称时间序列
    return w.wsd(security,"fund_exchangeshortnameextend",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeShortnameExtend(security:list,*args,**kwargs):
    # 获取基金扩位场内简称
    return w.wss(security,"fund_exchangeshortnameextend",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIssuerShortnameSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行机构自编简称时间序列
    return w.wsd(security,"fund_issuershortname",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIssuerShortname(security:list,*args,**kwargs):
    # 获取发行机构自编简称
    return w.wss(security,"fund_issuershortname",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExistingYearSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取成立年限时间序列
    return w.wsd(security,"fund_existingyear",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExistingYear(security:list,*args,**kwargs):
    # 获取成立年限
    return w.wss(security,"fund_existingyear",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinHoldingPeriodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金最短持有期时间序列
    return w.wsd(security,"fund_minholdingperiod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMinHoldingPeriod(security:list,*args,**kwargs):
    # 获取基金最短持有期
    return w.wss(security,"fund_minholdingperiod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPtMYearSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金存续期时间序列
    return w.wsd(security,"fund_ptmyear",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPtMYear(security:list,*args,**kwargs):
    # 获取基金存续期
    return w.wss(security,"fund_ptmyear",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPtMDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取剩余存续期时间序列
    return w.wsd(security,"fund_ptmday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPtMDay(security:list,*args,**kwargs):
    # 获取剩余存续期
    return w.wss(security,"fund_ptmday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBenchmarkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩比较基准时间序列
    return w.wsd(security,"fund_benchmark",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBenchmark(security:list,*args,**kwargs):
    # 获取业绩比较基准
    return w.wss(security,"fund_benchmark",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundChangeOfBenchmarkSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩比较基准变更说明时间序列
    return w.wsd(security,"fund_changeofbenchmark",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundChangeOfBenchmark(security:list,*args,**kwargs):
    # 获取业绩比较基准变更说明
    return w.wss(security,"fund_changeofbenchmark",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBenchReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取业绩比较基准增长率时间序列
    return w.wsd(security,"bench_return",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getBenchReturn(security:list,*args,**kwargs):
    # 获取业绩比较基准增长率
    return w.wss(security,"bench_return",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavBenchReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期业绩比较基准增长率时间序列
    return w.wsd(security,"NAV_benchreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavBenchReturn(security:list,*args,**kwargs):
    # 获取报告期业绩比较基准增长率
    return w.wss(security,"NAV_benchreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavBenchStdDevSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取报告期业绩比较基准增长率标准差时间序列
    return w.wsd(security,"NAV_benchstddev",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getNavBenchStdDev(security:list,*args,**kwargs):
    # 获取报告期业绩比较基准增长率标准差
    return w.wss(security,"NAV_benchstddev",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalBenchReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.业绩比较基准收益率时间序列
    return w.wsd(security,"qanal_benchreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalBenchReturn(security:list,*args,**kwargs):
    # 获取单季度.业绩比较基准收益率
    return w.wss(security,"qanal_benchreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalStdBenchReturnSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单季度.业绩比较基准收益率标准差时间序列
    return w.wsd(security,"qanal_stdbenchreturn",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getQAnalStdBenchReturn(security:list,*args,**kwargs):
    # 获取单季度.业绩比较基准收益率标准差
    return w.wss(security,"qanal_stdbenchreturn",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBenchIndexCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基准指数代码时间序列
    return w.wsd(security,"fund_benchindexcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBenchIndexCode(security:list,*args,**kwargs):
    # 获取基准指数代码
    return w.wss(security,"fund_benchindexcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestObjectSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资目标时间序列
    return w.wsd(security,"fund_investobject",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestObject(security:list,*args,**kwargs):
    # 获取投资目标
    return w.wss(security,"fund_investobject",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestScopeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资范围时间序列
    return w.wsd(security,"fund_investscope",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestScope(security:list,*args,**kwargs):
    # 获取投资范围
    return w.wss(security,"fund_investscope",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestmentProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资品种比例限制时间序列
    return w.wsd(security,"fund_investmentproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestmentProportion(security:list,*args,**kwargs):
    # 获取投资品种比例限制
    return w.wss(security,"fund_investmentproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHkScInvestmentProportionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取港股通股票投资比例说明时间序列
    return w.wsd(security,"fund_hkscinvestmentproportion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundHkScInvestmentProportion(security:list,*args,**kwargs):
    # 获取港股通股票投资比例说明
    return w.wss(security,"fund_hkscinvestmentproportion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestConceptionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资理念时间序列
    return w.wsd(security,"fund_investconception",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestConception(security:list,*args,**kwargs):
    # 获取投资理念
    return w.wss(security,"fund_investconception",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestmentRegionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资区域时间序列
    return w.wsd(security,"fund_investmentregion",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestmentRegion(security:list,*args,**kwargs):
    # 获取投资区域
    return w.wss(security,"fund_investmentregion",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestingRegionDescriptionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取主要投资区域说明时间序列
    return w.wsd(security,"fund_investingregiondescription",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestingRegionDescription(security:list,*args,**kwargs):
    # 获取主要投资区域说明
    return w.wss(security,"fund_investingregiondescription",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundParValueSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取面值时间序列
    return w.wsd(security,"fund_parvalue",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundParValue(security:list,*args,**kwargs):
    # 获取面值
    return w.wss(security,"fund_parvalue",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInitialSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否初始基金时间序列
    return w.wsd(security,"fund_initial",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInitial(security:list,*args,**kwargs):
    # 获取是否初始基金
    return w.wss(security,"fund_initial",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundStructuredFundOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否分级基金时间序列
    return w.wsd(security,"fund_structuredfundornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundStructuredFundOrNot(security:list,*args,**kwargs):
    # 获取是否分级基金
    return w.wss(security,"fund_structuredfundornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReGulOpenFundOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否定期开放基金时间序列
    return w.wsd(security,"fund_regulopenfundornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundReGulOpenFundOrNot(security:list,*args,**kwargs):
    # 获取是否定期开放基金
    return w.wss(security,"fund_regulopenfundornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSidePocketFundOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否使用侧袋机制时间序列
    return w.wsd(security,"fund_sidepocketfundornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSidePocketFundOrNot(security:list,*args,**kwargs):
    # 获取是否使用侧袋机制
    return w.wss(security,"fund_sidepocketfundornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExceptionStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取产品异常状态时间序列
    return w.wsd(security,"fund_exceptionstatus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExceptionStatus(security:list,*args,**kwargs):
    # 获取产品异常状态
    return w.wss(security,"fund_exceptionstatus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundOperatePeriodClsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取封闭运作期时间序列
    return w.wsd(security,"fund_operateperiod_cls",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundOperatePeriodCls(security:list,*args,**kwargs):
    # 获取封闭运作期
    return w.wss(security,"fund_operateperiod_cls",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExpectedYieldSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预期收益率(文字)时间序列
    return w.wsd(security,"expectedyield",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getExpectedYield(security:list,*args,**kwargs):
    # 获取预期收益率(文字)
    return w.wss(security,"expectedyield",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundTransitionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金转型说明时间序列
    return w.wsd(security,"fund_fundtransition",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFundTransition(security:list,*args,**kwargs):
    # 获取基金转型说明
    return w.wss(security,"fund_fundtransition",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundValuationMethodSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金估值方法时间序列
    return w.wsd(security,"fund_valuationmethod",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundValuationMethod(security:list,*args,**kwargs):
    # 获取基金估值方法
    return w.wss(security,"fund_valuationmethod",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskReturnCharactersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取风险收益特征时间序列
    return w.wsd(security,"fund_riskreturn_characters",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskReturnCharacters(security:list,*args,**kwargs):
    # 获取风险收益特征
    return w.wss(security,"fund_riskreturn_characters",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarketRiskSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取市场风险提示时间序列
    return w.wsd(security,"marketrisk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getMarketRisk(security:list,*args,**kwargs):
    # 获取市场风险提示
    return w.wss(security,"marketrisk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getManagementRiskSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理风险提示时间序列
    return w.wsd(security,"managementrisk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getManagementRisk(security:list,*args,**kwargs):
    # 获取管理风险提示
    return w.wss(security,"managementrisk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechnicalRiskSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取技术风险提示时间序列
    return w.wsd(security,"technicalrisk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getTechnicalRisk(security:list,*args,**kwargs):
    # 获取技术风险提示
    return w.wss(security,"technicalrisk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionRiskSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回风险提示时间序列
    return w.wsd(security,"redemptionrisk",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getRedemptionRisk(security:list,*args,**kwargs):
    # 获取赎回风险提示
    return w.wss(security,"redemptionrisk",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherRisksSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取其他风险提示时间序列
    return w.wsd(security,"otherrisks",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getOtherRisks(security:list,*args,**kwargs):
    # 获取其他风险提示
    return w.wss(security,"otherrisks",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFrontendCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金前端代码时间序列
    return w.wsd(security,"fund_frontendcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFrontendCode(security:list,*args,**kwargs):
    # 获取基金前端代码
    return w.wss(security,"fund_frontendcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBackendCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金后端代码时间序列
    return w.wsd(security,"fund_backendcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBackendCode(security:list,*args,**kwargs):
    # 获取基金后端代码
    return w.wss(security,"fund_backendcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInitialCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金初始代码时间序列
    return w.wsd(security,"fund_initialcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInitialCode(security:list,*args,**kwargs):
    # 获取基金初始代码
    return w.wss(security,"fund_initialcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRelatedCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取关联基金代码时间序列
    return w.wsd(security,"fund_relatedcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRelatedCode(security:list,*args,**kwargs):
    # 获取关联基金代码
    return w.wss(security,"fund_relatedcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAMacCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金业协会编码时间序列
    return w.wsd(security,"fund_AMACcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundAMacCode(security:list,*args,**kwargs):
    # 获取基金业协会编码
    return w.wss(security,"fund_AMACcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBWMpRecordCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取理财产品登记编码时间序列
    return w.wsd(security,"fund_bwmp_recordcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundBWMpRecordCode(security:list,*args,**kwargs):
    # 获取理财产品登记编码
    return w.wss(security,"fund_bwmp_recordcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIssuerCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取发行机构自编代码时间序列
    return w.wsd(security,"fund_issuercode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIssuerCode(security:list,*args,**kwargs):
    # 获取发行机构自编代码
    return w.wss(security,"fund_issuercode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取理财产品交易所代码时间序列
    return w.wsd(security,"fund_exchangecode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExchangeCode(security:list,*args,**kwargs):
    # 获取理财产品交易所代码
    return w.wss(security,"fund_exchangecode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPeQuotationCodeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取机构间私募产品报价系统编码时间序列
    return w.wsd(security,"fund_pequotationcode",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPeQuotationCode(security:list,*args,**kwargs):
    # 获取机构间私募产品报价系统编码
    return w.wss(security,"fund_pequotationcode",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSetUpdateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金成立日时间序列
    return w.wsd(security,"fund_setupdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSetUpdate(security:list,*args,**kwargs):
    # 获取基金成立日
    return w.wss(security,"fund_setupdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaturityDate2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金到期日时间序列
    return w.wsd(security,"fund_maturitydate_2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMaturityDate2(security:list,*args,**kwargs):
    # 获取基金到期日
    return w.wss(security,"fund_maturitydate_2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDateSuspensionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金暂停运作日时间序列
    return w.wsd(security,"fund_date_suspension",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDateSuspension(security:list,*args,**kwargs):
    # 获取基金暂停运作日
    return w.wss(security,"fund_date_suspension",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDateResumptionSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金恢复运作日时间序列
    return w.wsd(security,"fund_date_resumption",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDateResumption(security:list,*args,**kwargs):
    # 获取基金恢复运作日
    return w.wss(security,"fund_date_resumption",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCuStStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取开始托管日期时间序列
    return w.wsd(security,"fund_custstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCuStStartDate(security:list,*args,**kwargs):
    # 获取开始托管日期
    return w.wss(security,"fund_custstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCusTendDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取托管结束日期时间序列
    return w.wsd(security,"fund_custenddate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCusTendDate(security:list,*args,**kwargs):
    # 获取托管结束日期
    return w.wss(security,"fund_custenddate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRecognitionDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取互认基金批复日期时间序列
    return w.wsd(security,"fund_recognitiondate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRecognitionDate(security:list,*args,**kwargs):
    # 获取互认基金批复日期
    return w.wss(security,"fund_recognitiondate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExpectedEndingDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预计封闭期结束日时间序列
    return w.wsd(security,"fund_expectedendingday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExpectedEndingDay(security:list,*args,**kwargs):
    # 获取预计封闭期结束日
    return w.wss(security,"fund_expectedendingday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExpectedOpenDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取预计下期开放日时间序列
    return w.wsd(security,"fund_expectedopenday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundExpectedOpenDay(security:list,*args,**kwargs):
    # 获取预计下期开放日
    return w.wss(security,"fund_expectedopenday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundStartDateOfClosureSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定开基金封闭起始日时间序列
    return w.wsd(security,"fund_startdateofclosure",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundStartDateOfClosure(security:list,*args,**kwargs):
    # 获取定开基金封闭起始日
    return w.wss(security,"fund_startdateofclosure",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundLastOpenDaySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定开基金上一开放日时间序列
    return w.wsd(security,"fund_lastopenday",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundLastOpenDay(security:list,*args,**kwargs):
    # 获取定开基金上一开放日
    return w.wss(security,"fund_lastopenday",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundOpenDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定开基金开放日(支持历史)时间序列
    return w.wsd(security,"fund_opendays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundOpenDays(security:list,*args,**kwargs):
    # 获取定开基金开放日(支持历史)
    return w.wss(security,"fund_opendays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundNumOfOpenDaysSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取定开基金已开放次数时间序列
    return w.wsd(security,"fund_numofopendays",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundNumOfOpenDays(security:list,*args,**kwargs):
    # 获取定开基金已开放次数
    return w.wss(security,"fund_numofopendays",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListDataDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取上市公告数据截止日期时间序列
    return w.wsd(security,"listdatadate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getListDataDate(security:list,*args,**kwargs):
    # 获取上市公告数据截止日期
    return w.wss(security,"listdatadate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMGrCompSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人时间序列
    return w.wsd(security,"fund_mgrcomp",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundMGrComp(security:list,*args,**kwargs):
    # 获取基金管理人
    return w.wss(security,"fund_mgrcomp",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagementCompanySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人简称时间序列
    return w.wsd(security,"fund_corp_fundmanagementcompany",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundManagementCompany(security:list,*args,**kwargs):
    # 获取基金管理人简称
    return w.wss(security,"fund_corp_fundmanagementcompany",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpNameEngSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人英文名称时间序列
    return w.wsd(security,"fund_corpnameeng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpNameEng(security:list,*args,**kwargs):
    # 获取基金管理人英文名称
    return w.wss(security,"fund_corpnameeng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpChairmanSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人法人代表时间序列
    return w.wsd(security,"fund_corpchairman",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpChairman(security:list,*args,**kwargs):
    # 获取基金管理人法人代表
    return w.wss(security,"fund_corpchairman",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpPhoneSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人电话时间序列
    return w.wsd(security,"fund_corpphone",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpPhone(security:list,*args,**kwargs):
    # 获取基金管理人电话
    return w.wss(security,"fund_corpphone",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFaxSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人传真时间序列
    return w.wsd(security,"fund_corpfax",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFax(security:list,*args,**kwargs):
    # 获取基金管理人传真
    return w.wss(security,"fund_corpfax",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpEmailSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人电子邮箱时间序列
    return w.wsd(security,"fund_corpemail",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpEmail(security:list,*args,**kwargs):
    # 获取基金管理人电子邮箱
    return w.wss(security,"fund_corpemail",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpWebsiteSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人主页时间序列
    return w.wsd(security,"fund_corpwebsite",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpWebsite(security:list,*args,**kwargs):
    # 获取基金管理人主页
    return w.wss(security,"fund_corpwebsite",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNonMoneyNetAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人资产净值合计(非货币)时间序列
    return w.wsd(security,"prt_nonmoneynetassets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtNonMoneyNetAssets(security:list,*args,**kwargs):
    # 获取基金管理人资产净值合计(非货币)
    return w.wss(security,"prt_nonmoneynetassets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTotalNetAssetsSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人资产净值合计时间序列
    return w.wsd(security,"prt_fundcototalnetassets",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTotalNetAssets(security:list,*args,**kwargs):
    # 获取基金管理人资产净值合计
    return w.wss(security,"prt_fundcototalnetassets",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTotalNetAssetsRankingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人资产净值合计排名时间序列
    return w.wsd(security,"prt_fundcototalnetassetsranking",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTotalNetAssetsRanking(security:list,*args,**kwargs):
    # 获取基金管理人资产净值合计排名
    return w.wss(security,"prt_fundcototalnetassetsranking",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTnaChangeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金管理人资产净值合计变动率时间序列
    return w.wsd(security,"prt_fundcotnachangeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getPrtFundCoTnaChangeRatio(security:list,*args,**kwargs):
    # 获取基金管理人资产净值合计变动率
    return w.wss(security,"prt_fundcotnachangeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianBankSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金托管人时间序列
    return w.wsd(security,"fund_custodianbank",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianBank(security:list,*args,**kwargs):
    # 获取基金托管人
    return w.wss(security,"fund_custodianbank",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRegistrarSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金注册与过户登记人时间序列
    return w.wsd(security,"issue_registrar",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIssueRegistrar(security:list,*args,**kwargs):
    # 获取基金注册与过户登记人
    return w.wss(security,"issue_registrar",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyFAdvisorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取财务顾问时间序列
    return w.wsd(security,"agency_fadvisor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getAgencyFAdvisor(security:list,*args,**kwargs):
    # 获取财务顾问
    return w.wss(security,"agency_fadvisor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1504Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取手续费及佣金收入:财务顾问业务时间序列
    return w.wsd(security,"stmnote_sec_1504",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1504(security:list,*args,**kwargs):
    # 获取手续费及佣金收入:财务顾问业务
    return w.wss(security,"stmnote_sec_1504",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1524Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取手续费及佣金净收入:财务顾问业务时间序列
    return w.wsd(security,"stmnote_sec_1524",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getStmNoteSec1524(security:list,*args,**kwargs):
    # 获取手续费及佣金净收入:财务顾问业务
    return w.wss(security,"stmnote_sec_1524",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundWmIssuerSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取银行理财发行人时间序列
    return w.wsd(security,"fund_wmissuer",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundWmIssuer(security:list,*args,**kwargs):
    # 获取银行理财发行人
    return w.wss(security,"fund_wmissuer",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundForeignInvestmentAdvisorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取境外投资顾问时间序列
    return w.wsd(security,"fund_foreigninvestmentadvisor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundForeignInvestmentAdvisor(security:list,*args,**kwargs):
    # 获取境外投资顾问
    return w.wss(security,"fund_foreigninvestmentadvisor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundForeignCustodianSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取境外托管人时间序列
    return w.wsd(security,"fund_foreigncustodian",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundForeignCustodian(security:list,*args,**kwargs):
    # 获取境外托管人
    return w.wss(security,"fund_foreigncustodian",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCounselorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取律师事务所时间序列
    return w.wsd(security,"fund_counselor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCounselor(security:list,*args,**kwargs):
    # 获取律师事务所
    return w.wss(security,"fund_counselor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPrimaryDealersSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取一级交易商时间序列
    return w.wsd(security,"fund_primarydealers",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPrimaryDealers(security:list,*args,**kwargs):
    # 获取一级交易商
    return w.wss(security,"fund_primarydealers",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金类型时间序列
    return w.wsd(security,"fund_type",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundType(security:list,*args,**kwargs):
    # 获取基金类型
    return w.wss(security,"fund_type",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFirstInvestTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资类型(一级分类)时间序列
    return w.wsd(security,"fund_firstinvesttype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFirstInvestType(security:list,*args,**kwargs):
    # 获取投资类型(一级分类)
    return w.wss(security,"fund_firstinvesttype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资类型(二级分类)时间序列
    return w.wsd(security,"fund_investtype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestType(security:list,*args,**kwargs):
    # 获取投资类型(二级分类)
    return w.wss(security,"fund_investtype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestType2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资类型时间序列
    return w.wsd(security,"fund_investtype2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestType2(security:list,*args,**kwargs):
    # 获取投资类型
    return w.wss(security,"fund_investtype2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestTypeAnytimeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资类型(支持历史)时间序列
    return w.wsd(security,"fund_investtype_anytime",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestTypeAnytime(security:list,*args,**kwargs):
    # 获取投资类型(支持历史)
    return w.wss(security,"fund_investtype_anytime",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestTypeEngSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资类型(英文)时间序列
    return w.wsd(security,"fund_investtypeeng",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvestTypeEng(security:list,*args,**kwargs):
    # 获取投资类型(英文)
    return w.wss(security,"fund_investtypeeng",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskLevelSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金风险等级时间序列
    return w.wsd(security,"fund_risklevel",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskLevel(security:list,*args,**kwargs):
    # 获取基金风险等级
    return w.wss(security,"fund_risklevel",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskLevelFilingSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金风险等级(公告口径)时间序列
    return w.wsd(security,"fund_risklevelfiling",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRiskLevelFiling(security:list,*args,**kwargs):
    # 获取基金风险等级(公告口径)
    return w.wss(security,"fund_risklevelfiling",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSMfType2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取基金分级类型时间序列
    return w.wsd(security,"fund_smftype2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSMfType2(security:list,*args,**kwargs):
    # 获取基金分级类型
    return w.wss(security,"fund_smftype2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSimilarFundNoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取同类基金数量时间序列
    return w.wsd(security,"fund_similarfundno",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSimilarFundNo(security:list,*args,**kwargs):
    # 获取同类基金数量
    return w.wss(security,"fund_similarfundno",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属主题基金类别时间序列
    return w.wsd(security,"fund_themetype",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeType(security:list,*args,**kwargs):
    # 获取所属主题基金类别
    return w.wss(security,"fund_themetype",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeConceptSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属主题基金类别(Wind概念)时间序列
    return w.wsd(security,"fund_themetype_concept",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeConcept(security:list,*args,**kwargs):
    # 获取所属主题基金类别(Wind概念)
    return w.wss(security,"fund_themetype_concept",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeIndustrySeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属主题基金类别(Wind行业)时间序列
    return w.wsd(security,"fund_themetype_industry",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeIndustry(security:list,*args,**kwargs):
    # 获取所属主题基金类别(Wind行业)
    return w.wss(security,"fund_themetype_industry",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeIndexSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取所属主题基金类别(Wind股票指数)时间序列
    return w.wsd(security,"fund_themetype_index",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundThemeTypeIndex(security:list,*args,**kwargs):
    # 获取所属主题基金类别(Wind股票指数)
    return w.wss(security,"fund_themetype_index",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagementFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理费率时间序列
    return w.wsd(security,"fund_managementfeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagementFeeRatio(security:list,*args,**kwargs):
    # 获取管理费率
    return w.wss(security,"fund_managementfeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagementFeeRatio2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取管理费率(支持历史)时间序列
    return w.wsd(security,"fund_managementfeeratio2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundManagementFeeRatio2(security:list,*args,**kwargs):
    # 获取管理费率(支持历史)
    return w.wss(security,"fund_managementfeeratio2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFloatingMgNtFeedEScripSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取浮动管理费率说明时间序列
    return w.wsd(security,"fund_floatingmgntfeedescrip",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFloatingMgNtFeedEScrip(security:list,*args,**kwargs):
    # 获取浮动管理费率说明
    return w.wss(security,"fund_floatingmgntfeedescrip",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundTrusteeMgNtFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取受托人固定管理费率(信托)时间序列
    return w.wsd(security,"fund_trusteemgntfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundTrusteeMgNtFee(security:list,*args,**kwargs):
    # 获取受托人固定管理费率(信托)
    return w.wss(security,"fund_trusteemgntfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvAdviserMgNtFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取投资顾问固定管理费率(信托)时间序列
    return w.wsd(security,"fund_invadvisermgntfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundInvAdviserMgNtFee(security:list,*args,**kwargs):
    # 获取投资顾问固定管理费率(信托)
    return w.wss(security,"fund_invadvisermgntfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFloatingMgNtFeeOrNotSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取是否收取浮动管理费时间序列
    return w.wsd(security,"fund_floatingmgntfeeornot",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundFloatingMgNtFeeOrNot(security:list,*args,**kwargs):
    # 获取是否收取浮动管理费
    return w.wss(security,"fund_floatingmgntfeeornot",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取托管费率时间序列
    return w.wsd(security,"fund_custodianfeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianFeeRatio(security:list,*args,**kwargs):
    # 获取托管费率
    return w.wss(security,"fund_custodianfeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianFeeRatio2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取托管费率(支持历史)时间序列
    return w.wsd(security,"fund_custodianfeeratio2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCustodianFeeRatio2(security:list,*args,**kwargs):
    # 获取托管费率(支持历史)
    return w.wss(security,"fund_custodianfeeratio2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSaleFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取销售服务费率时间序列
    return w.wsd(security,"fund_salefeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSaleFeeRatio(security:list,*args,**kwargs):
    # 获取销售服务费率
    return w.wss(security,"fund_salefeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSaleFeeRatio2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取销售服务费率(支持历史)时间序列
    return w.wsd(security,"fund_salefeeratio2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSaleFeeRatio2(security:list,*args,**kwargs):
    # 获取销售服务费率(支持历史)
    return w.wss(security,"fund_salefeeratio2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最高申购费率时间序列
    return w.wsd(security,"fund_purchasefeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFeeRatio(security:list,*args,**kwargs):
    # 获取最高申购费率
    return w.wss(security,"fund_purchasefeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取最高赎回费率时间序列
    return w.wsd(security,"fund_redemptionfeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFeeRatio(security:list,*args,**kwargs):
    # 获取最高赎回费率
    return w.wss(security,"fund_redemptionfeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSubscriptionFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购费率时间序列
    return w.wsd(security,"fund_subscriptionfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSubscriptionFee(security:list,*args,**kwargs):
    # 获取认购费率
    return w.wss(security,"fund_subscriptionfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSubscriptionFee2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取认购费率(支持历史)时间序列
    return w.wsd(security,"fund_subscriptionfee2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundSubscriptionFee2(security:list,*args,**kwargs):
    # 获取认购费率(支持历史)
    return w.wss(security,"fund_subscriptionfee2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购费率时间序列
    return w.wsd(security,"fund_purchasefee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFee(security:list,*args,**kwargs):
    # 获取申购费率
    return w.wss(security,"fund_purchasefee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFee2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购费率(支持历史)时间序列
    return w.wsd(security,"fund_purchasefee2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseFee2(security:list,*args,**kwargs):
    # 获取申购费率(支持历史)
    return w.wss(security,"fund_purchasefee2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPChMaxFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购费率上限时间序列
    return w.wsd(security,"fund_pchredm_pchmaxfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPChMaxFee(security:list,*args,**kwargs):
    # 获取申购费率上限
    return w.wss(security,"fund_pchredm_pchmaxfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回费率时间序列
    return w.wsd(security,"fund_redemptionfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFee(security:list,*args,**kwargs):
    # 获取赎回费率
    return w.wss(security,"fund_redemptionfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFee2Series(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回费率(支持历史)时间序列
    return w.wsd(security,"fund_redemptionfee2",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedemptionFee2(security:list,*args,**kwargs):
    # 获取赎回费率(支持历史)
    return w.wss(security,"fund_redemptionfee2",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMMaxRedMFeeSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回费率上限时间序列
    return w.wsd(security,"fund_pchredm_maxredmfee",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMMaxRedMFee(security:list,*args,**kwargs):
    # 获取赎回费率上限
    return w.wss(security,"fund_pchredm_maxredmfee",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIndexUsageFeeRatioSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取指数使用费率时间序列
    return w.wsd(security,"fund_indexusagefeeratio",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundIndexUsageFeeRatio(security:list,*args,**kwargs):
    # 获取指数使用费率
    return w.wss(security,"fund_indexusagefeeratio",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseAndRedemptionAbbreviationSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购赎回简称时间序列
    return w.wsd(security,"fund_purchaseandredemptionabbreviation",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPurchaseAndRedemptionAbbreviation(security:list,*args,**kwargs):
    # 获取申购赎回简称
    return w.wss(security,"fund_purchaseandredemptionabbreviation",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDQStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购赎回状态时间序列
    return w.wsd(security,"fund_dq_status",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundDQStatus(security:list,*args,**kwargs):
    # 获取申购赎回状态
    return w.wss(security,"fund_dq_status",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPcHmStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购状态时间序列
    return w.wsd(security,"fund_pchmstatus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPcHmStatus(security:list,*args,**kwargs):
    # 获取申购状态
    return w.wss(security,"fund_pchmstatus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMStatusSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回状态时间序列
    return w.wsd(security,"fund_redmstatus",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMStatus(security:list,*args,**kwargs):
    # 获取赎回状态
    return w.wss(security,"fund_redmstatus",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPChStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购起始日时间序列
    return w.wsd(security,"fund_pchredm_pchstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPChStartDate(security:list,*args,**kwargs):
    # 获取申购起始日
    return w.wss(security,"fund_pchredm_pchstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoOpStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取网下申购起始日期时间序列
    return w.wsd(security,"ipo_op_startdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getIpoOpStartDate(security:list,*args,**kwargs):
    # 获取网下申购起始日期
    return w.wss(security,"ipo_op_startdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMLargePChMaxAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单日大额申购限额时间序列
    return w.wsd(security,"fund_pchredm_largepchmaxamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMLargePChMaxAmt(security:list,*args,**kwargs):
    # 获取单日大额申购限额
    return w.wss(security,"fund_pchredm_largepchmaxamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPcHmInAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购金额下限(场外)时间序列
    return w.wsd(security,"fund_pchredm_pchminamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPcHmInAmt(security:list,*args,**kwargs):
    # 获取申购金额下限(场外)
    return w.wss(security,"fund_pchredm_pchminamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPcHmInAmtFloorSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购金额下限(场内)时间序列
    return w.wsd(security,"fund_pchredm_pchminamt_floor",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMPcHmInAmtFloor(security:list,*args,**kwargs):
    # 获取申购金额下限(场内)
    return w.wss(security,"fund_pchredm_pchminamt_floor",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMStartDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回起始日时间序列
    return w.wsd(security,"fund_redmstartdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMStartDate(security:list,*args,**kwargs):
    # 获取赎回起始日
    return w.wss(security,"fund_redmstartdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMRedMmInAmtSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取单笔赎回份额下限时间序列
    return w.wsd(security,"fund_pchredm_redmminamt",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChRedMRedMmInAmt(security:list,*args,**kwargs):
    # 获取单笔赎回份额下限
    return w.wss(security,"fund_pchredm_redmminamt",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChConfirmDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取申购确认日时间序列
    return w.wsd(security,"fund_pchconfirmdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundPChConfirmDate(security:list,*args,**kwargs):
    # 获取申购确认日
    return w.wss(security,"fund_pchconfirmdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMConfirmDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回确认日时间序列
    return w.wsd(security,"fund_redmconfirmdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMConfirmDate(security:list,*args,**kwargs):
    # 获取赎回确认日
    return w.wss(security,"fund_redmconfirmdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMarriAlDateSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取赎回划款日时间序列
    return w.wsd(security,"fund_redmarrialdate",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundRedMarriAlDate(security:list,*args,**kwargs):
    # 获取赎回划款日
    return w.wss(security,"fund_redmarrialdate",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundNoSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取旗下基金数时间序列
    return w.wsd(security,"fund_corp_fundno",startDate,endDate,*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFundNo(security:list,*args,**kwargs):
    # 获取旗下基金数
    return w.wss(security,"fund_corp_fundno",*args,**kwargs,usedf=True)
@convertInputSecurityType
def getFundCorpFiveStarFundsPropSeries(security:list, startDate,endDate,*args,**kwargs):
    # 获取五星基金