# Generated by Django 3.1.5 on 2021-03-08 22:59

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


def add_review_details(apps, schema_editor):
    TransmitterEntry = apps.get_model('base', 'TransmitterEntry')
    orphans = TransmitterEntry.objects.filter(created_by__isnull=True, is_reviewed=True)
    for entry in orphans:
        entry.reviewed = entry.created
        entry.save()
    ids = []
    non_orphans = TransmitterEntry.objects.filter(created_by__isnull=False, is_reviewed=True).order_by('created')
    for entry in non_orphans:
        if entry.id in ids:
            entry.delete()
            continue
        next_entries = TransmitterEntry.objects.filter(created_by__isnull=False, is_reviewed=True).filter(uuid=entry.uuid).filter(created__gt=entry.created).order_by('created')
        for next_entry in next_entries:
            if (entry.uuid == next_entry.uuid and entry.description == next_entry.description and
                entry.status == next_entry.status and entry.type == next_entry.type and entry.uplink_low == next_entry.uplink_low and
                entry.uplink_high == next_entry.uplink_high and entry.uplink_drift == next_entry.uplink_drift and
                entry.downlink_low == next_entry.downlink_low and entry.downlink_high == next_entry.downlink_high and
                entry.downlink_drift == next_entry.downlink_drift and entry.downlink_mode == next_entry.downlink_mode and
                entry.uplink_mode == next_entry.uplink_mode and entry.invert == next_entry.invert and entry.baud == next_entry.baud and
                entry.satellite == next_entry.satellite and entry.reviewed == next_entry.reviewed and entry.approved == next_entry.approved and
                entry.citation == next_entry.citation and entry.service == next_entry.service and entry.coordination == next_entry.coordination and
                entry.coordination_url == next_entry.coordination_url):
                    ids.append(next_entry.id)
                    entry.reviewed = next_entry.created
                    entry.reviewer = next_entry.created_by
                    entry.save()
                    break
        else:
            entry.reviewed = entry.created
            entry.reviewer = entry.created_by
            entry.save()


def remove_review_details(apps, schema_editor):
    TransmitterEntry = apps.get_model('base', 'TransmitterEntry')
    non_orphans = TransmitterEntry.objects.filter(created_by__isnull=False, is_reviewed=True).order_by('created')
    for entry in non_orphans:
        entry.pk = None
        entry.created = entry.reviewed
        entry.created_by = entry.reviewer
        entry.save()


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('base', '0036_rename_reviewed_field_on_transmitter_entry_model'),
    ]

    operations = [
        migrations.AddField(
            model_name='transmitterentry',
            name='reviewed',
            field=models.DateTimeField(blank=True, help_text='Timestamp of review', null=True),
        ),
        migrations.AddField(
            model_name='transmitterentry',
            name='reviewer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reviewed_transmitters', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='created',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Timestamp of creation/edit'),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_transmitters', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='transmitterentry',
            unique_together={('uuid', 'reviewed')},
        ),
        migrations.RunPython(add_review_details, remove_review_details),
    ]
