
Currently, the Screener class allows the user to retrieve predefined screeners.  Future versions will eventually allow for users to create screeners on the fly as well as utilize their own screeners they've created on Yahoo Finance.

## Import

```python
from yahooquery import Screener
```

## Create Instance

```python
s = Screener()
```

## Screener

### available_screeners

=== "Details"

    - *Description*:  Return list of predefined screeners available to pass to [get_screeners](#get_screeners)
    - *Return*:  `dict`

=== "Example"

    ```python hl_lines="2"
    s = Screener()
    s.available_screeners
    ```

=== "Data"

    ```python
    [
        'accident_health_insurance',
        'advertising_agencies',
        'aerospace_defense_major_diversified',
        'aerospace_defense_products_services',
        'aggressive_small_caps',
        'agricultural_chemicals',
        'air_delivery_freight_services',
        'air_services_other',
        'all_cryptocurrencies_au',
        'all_cryptocurrencies_ca',
        'all_cryptocurrencies_eu',
        'all_cryptocurrencies_gb',
        'all_cryptocurrencies_in',
        'all_cryptocurrencies_us',
        'aluminum',
        'apparel_stores',
        'appliances',
        'application_software',
        'asset_management',
        'auto_dealerships',
        'auto_manufacturers_major',
        'auto_parts',
        'auto_parts_stores',
        'auto_parts_wholesale',
        'basic_materials',
        'basic_materials_wholesale',
        'beverages_brewers',
        'beverages_soft_drinks',
        'beverages_wineries_distillers',
        'biotechnology',
        'broadcasting_radio',
        'broadcasting_tv',
        'building_materials_wholesale',
        'business_equipment',
        'business_services',
        'business_software_services',
        'catalog_mail_order_houses',
        'catv_systems',
        'cement',
        'chemicals_major_diversified',
        'cigarettes',
        'cleaning_products',
        'closedend_fund_debt',
        'closedend_fund_equity',
        'closedend_fund_foreign',
        'communication_equipment',
        'computer_based_systems',
        'computer_peripherals',
        'computers_wholesale',
        'confectioners',
        'conglomerates',
        'conservative_foreign_funds',
        'consumer_defensive',
        'consumer_goods',
        'consumer_services',
        'copper',
        'credit_services',
        'dairy_products',
        'data_storage_devices',
        'day_gainers',
        'day_gainers_americas',
        'day_gainers_asia',
        'day_gainers_au',
        'day_gainers_br',
        'day_gainers_ca',
        'day_gainers_de',
        'day_gainers_dji',
        'day_gainers_es',
        'day_gainers_europe',
        'day_gainers_fr',
        'day_gainers_gb',
        'day_gainers_hk',
        'day_gainers_in',
        'day_gainers_it',
        'day_gainers_ndx',
        'day_gainers_nz',
        'day_gainers_sg',
        'day_losers',
        'day_losers_americas',
        'day_losers_asia',
        'day_losers_au',
        'day_losers_br',
        'day_losers_ca',
        'day_losers_de',
        'day_losers_dji',
        'day_losers_es',
        'day_losers_europe',
        'day_losers_fr',
        'day_losers_gb',
        'day_losers_hk',
        'day_losers_in',
        'day_losers_it',
        'day_losers_ndx',
        'day_losers_nz',
        'day_losers_sg',
        'department_stores',
        'diagnostic_substances',
        'discount_variety_stores',
        'diversified_communication_services',
        'diversified_computer_systems',
        'diversified_electronics',
        'diversified_investments',
        'diversified_machinery',
        'diversified_utilities',
        'drug_delivery',
        'drug_manufacturers_major',
        'drug_manufacturers_other',
        'drug_related_products',
        'drug_stores',
        'drugs_generic',
        'drugs_wholesale',
        'education_training_services',
        'electric_utilities',
        'electronic_equipment',
        'electronics_stores',
        'electronics_wholesale',
        'entertainment_diversified',
        'fair_value_screener',
        'farm_construction_machinery',
        'farm_products',
        'financial',
        'food_major_diversified',
        'food_wholesale',
        'foreign_money_center_banks',
        'foreign_regional_banks',
        'foreign_utilities',
        'gaming_activities',
        'gas_utilities',
        'general_building_materials',
        'general_contractors',
        'general_entertainment',
        'gold',
        'grocery_stores',
        'growth_technology_stocks',
        'health_care_plans',
        'healthcare',
        'healthcare_information_services',
        'heavy_construction',
        'high_yield_bond',
        'home_furnishing_stores',
        'home_furnishings_fixtures',
        'home_health_care',
        'home_improvement_stores',
        'hospitals',
        'housewares_accessories',
        'independent_oil_gas',
        'industrial_electrical_equipment',
        'industrial_equipment_components',
        'industrial_equipment_wholesale',
        'industrial_goods',
        'industrial_metals_minerals',
        'information_delivery_services',
        'information_technology_services',
        'insurance_brokers',
        'internet_information_providers',
        'internet_service_providers',
        'internet_software_services',
        'investment_brokerage_national',
        'investment_brokerage_regional',
        'jewelry_stores',
        'life_insurance',
        'lodging',
        'long_distance_carriers',
        'longterm_care_facilities',
        'lumber_wood_production',
        'machine_tools_accessories',
        'major_airlines',
        'major_integrated_oil_gas',
        'management_services',
        'marketing_services',
        'meat_products',
        'medical_appliances_equipment',
        'medical_equipment_wholesale',
        'medical_instruments_supplies',
        'medical_laboratories_research',
        'mega_cap_hc',
        'metal_fabrication',
        'money_center_banks',
        'mortgage_investment',
        'most_actives',
        'most_actives_americas',
        'most_actives_asia',
        'most_actives_au',
        'most_actives_br',
        'most_actives_ca',
        'most_actives_de',
        'most_actives_dji',
        'most_actives_es',
        'most_actives_europe',
        'most_actives_fr',
        'most_actives_gb',
        'most_actives_hk',
        'most_actives_in',
        'most_actives_it',
        'most_actives_ndx',
        'most_actives_nz',
        'most_actives_sg',
        'most_watched_tickers',
        'movie_production_theaters',
        'ms_basic_materials',
        'ms_communication_services',
        'ms_consumer_cyclical',
        'ms_consumer_defensive',
        'ms_energy',
        'ms_financial_services',
        'ms_healthcare',
        'ms_industrials',
        'ms_real_estate',
        'ms_technology',
        'ms_utilities',
        'multimedia_graphics_software',
        'networking_communication_devices',
        'nonmetallic_mineral_mining',
        'office_supplies',
        'oil_gas_drilling_exploration',
        'oil_gas_equipment_services',
        'oil_gas_pipelines',
        'oil_gas_refining_marketing',
        'packaging_containers',
        'paper_paper_products',
        'personal_products',
        'personal_services',
        'photographic_equipment_supplies',
        'pollution_treatment_controls',
        'portfolio_anchors',
        'printed_circuit_boards',
        'processed_packaged_goods',
        'processing_systems_products',
        'property_casualty_insurance',
        'property_management',
        'publishing_books',
        'publishing_newspapers',
        'publishing_periodicals',
        'railroads',
        'real_estate_development',
        'recreational_goods_other',
        'recreational_vehicles',
        'regional_airlines',
        'regional_midatlantic_banks',
        'regional_midwest_banks',
        'regional_northeast_banks',
        'regional_pacific_banks',
        'regional_southeast_banks',
        'regional_southwest_banks',
        'reit_diversified',
        'reit_healthcare_facilities',
        'reit_hotel_motel',
        'reit_industrial',
        'reit_office',
        'reit_residential',
        'reit_retail',
        'rental_leasing_services',
        'research_services',
        'residential_construction',
        'resorts_casinos',
        'restaurants',
        'rubber_plastics',
        'savings_loans',
        'scientific_technical_instruments',
        'security_protection_services',
        'security_software_services',
        'semiconductor_broad_line',
        'semiconductor_equipment_materials',
        'semiconductor_integrated_circuits',
        'semiconductor_memory_chips',
        'semiconductor_specialized',
        'services',
        'shipping',
        'silver',
        'small_cap_gainers',
        'small_tools_accessories',
        'solid_large_growth_funds',
        'solid_midcap_growth_funds',
        'specialized_health_services',
        'specialty_chemicals',
        'specialty_eateries',
        'specialty_retail_other',
        'sporting_activities',
        'sporting_goods',
        'sporting_goods_stores',
        'staffing_outsourcing_services',
        'steel_iron',
        'surety_title_insurance',
        'synthetics',
        'technical_services',
        'technical_system_software',
        'technology',
        'telecom_services_domestic',
        'telecom_services_foreign',
        'textile_apparel_clothing',
        'textile_apparel_footwear_accessories',
        'textile_industrial',
        'tobacco_products_other',
        'top_energy_us',
        'top_etfs',
        'top_etfs_hk',
        'top_etfs_in',
        'top_etfs_us',
        'top_iv_options_us',
        'top_mutual_funds',
        'top_mutual_funds_au',
        'top_mutual_funds_br',
        'top_mutual_funds_ca',
        'top_mutual_funds_de',
        'top_mutual_funds_es',
        'top_mutual_funds_fr',
        'top_mutual_funds_gb',
        'top_mutual_funds_hk',
        'top_mutual_funds_in',
        'top_mutual_funds_it',
        'top_mutual_funds_nz',
        'top_mutual_funds_sg',
        'top_mutual_funds_us',
        'top_options_implied_volatality',
        'top_options_open_interest',
        'toy_hobby_stores',
        'toys_games',
        'trucking',
        'trucks_other_vehicles',
        'undervalued_growth_stocks',
        'undervalued_large_caps',
        'utilities',
        'waste_management',
        'water_utilities',
        'wireless_communications'
    ]
    ```

### get_screeners


=== "Details"

    - *Description*:  List of securities from a predefined screener(s)
    - *Return*:  `pandas.DataFrame`
    - *Arguments*

    | Argument   | Type   | Default   | Required   | Options                       |
    |:-----------|:-------|:----------|:-----------|:------------------------------|
    | screen_ids  | `str` or `list`  | None       | **Required**   | See [available screeners](#available_screeners) |
    | count   | `int` | `25`    | optional   |            |

=== "Example"

    ```python hl_lines="2"
    s = Screener()
    s.get_screeners(['most_actives', 'day_gainers'], 5)
    ```    

=== "Data"

    ```python hl_lines="2 394" 
    {
        'most_actives': {
            'id': '437465ef-980e-4d8c-a860-de7cbfbab373',
            'title': 'Most Actives - US',
            'description': 'Stocks ordered in descending order by intraday trade volume',
            'canonicalName': 'MOST_ACTIVES',
            'criteriaMeta': {
                'size': 5,
                'offset': 0,
                'sortField': 'dayvolume',
                'sortType': 'DESC',
                'quoteType': 'EQUITY',
                'topOperator': 'AND',
                'criteria': [{
                    'field': 'region',
                    'operators': ['EQ'],
                    'values': [],
                    'labelsSelected': [53]
                }, {
                    'field': 'intradaymarketcap',
                    'operators': ['EQ'],
                    'values': [],
                    'labelsSelected': [1, 2, 3]
                }, {
                    'field': 'dayvolume',
                    'operators': ['GT'],
                    'values': [5000000],
                    'labelsSelected': []
                }]
            },
            'rawCriteria': '{"offset":0,"size":5,"sortField":"dayvolume","sortType":"DESC","quoteType":"EQUITY","query":{"operator":"AND","operands":[{"operator":"eq","operands":["region","us"]},{"operator":"or","operands":[{"operator":"BTWN","operands":["intradaymarketcap",2000000000,10000000000]},{"operator":"BTWN","operands":["intradaymarketcap",10000000000,100000000000]},{"operator":"GT","operands":["intradaymarketcap",100000000000]}]},{"operator":"gt","operands":["dayvolume",5000000]}]}}',
            'start': 0,
            'count': 5,
            'total': 203,
            'quotes': [{
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Nasdaq Real Time Price',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': -252322200000,
                'priceHint': 2,
                'postMarketChangePercent': 0.0,
                'postMarketTime': 1596234164,
                'postMarketPrice': 6.08,
                'postMarketChange': 0.0,
                'regularMarketChange': -0.19000006,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 6.07,
                'regularMarketDayHigh': 6.29,
                'regularMarketDayRange': '6.0 - 6.29',
                'regularMarketDayLow': 6.0,
                'regularMarketVolume': 142268197,
                'regularMarketPreviousClose': 6.26,
                'bid': 6.07,
                'ask': 6.08,
                'bidSize': 473,
                'askSize': 280,
                'exchange': 'NYQ',
                'market': 'us_market',
                'messageBoardId': 'finmb_177031',
                'fullExchangeName': 'NYSE',
                'shortName': 'General Electric Company',
                'longName': 'General Electric Company',
                'financialCurrency': 'USD',
                'regularMarketOpen': 6.25,
                'averageDailyVolume3Month': 103055092,
                'averageDailyVolume10Day': 86456425,
                'fiftyTwoWeekLowChange': 0.59000015,
                'fiftyTwoWeekLowChangePercent': 0.107664265,
                'fiftyTwoWeekRange': '5.48 - 13.26',
                'fiftyTwoWeekHighChange': -7.19,
                'fiftyTwoWeekHighChangePercent': -0.5422323,
                'fiftyTwoWeekLow': 5.48,
                'fiftyTwoWeekHigh': 13.26,
                'dividendDate': 1595808000,
                'earningsTimestamp': 1603873800,
                'earningsTimestampStart': 1603873800,
                'earningsTimestampEnd': 1603873800,
                'trailingAnnualDividendRate': 0.04,
                'trailingAnnualDividendYield': 0.006389776,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': -0.561,
                'epsForward': 0.38,
                'sharesOutstanding': 8747089920,
                'bookValue': 3.846,
                'fiftyDayAverage': 6.9014287,
                'fiftyDayAverageChange': -0.8314285,
                'fiftyDayAverageChangePercent': -0.12047195,
                'twoHundredDayAverage': 8.269568,
                'twoHundredDayAverageChange': -2.1995683,
                'twoHundredDayAverageChangePercent': -0.26598343,
                'marketCap': 53094838272,
                'forwardPE': 15.973685,
                'priceToBook': 1.5782632,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': -3.0351446,
                'displayName': 'General Electric',
                'symbol': 'GE'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Nasdaq Real Time Price',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 757607400000,
                'priceHint': 4,
                'postMarketChangePercent': -0.7314493,
                'postMarketTime': 1596234026,
                'postMarketPrice': 4.75,
                'postMarketChange': -0.034999847,
                'regularMarketChange': 0.3300004,
                'regularMarketTime': 1596225601,
                'regularMarketPrice': 4.78,
                'regularMarketDayHigh': 4.95,
                'regularMarketDayRange': '4.635 - 4.95',
                'regularMarketDayLow': 4.635,
                'regularMarketVolume': 117123629,
                'regularMarketPreviousClose': 4.45,
                'bid': 4.73,
                'ask': 4.76,
                'bidSize': 369,
                'askSize': 400,
                'exchange': 'NYQ',
                'market': 'us_market',
                'messageBoardId': 'finmb_205573',
                'fullExchangeName': 'NYSE',
                'shortName': 'Nokia Corporation Sponsored',
                'longName': 'Nokia Corporation',
                'financialCurrency': 'EUR',
                'regularMarketOpen': 4.86,
                'averageDailyVolume3Month': 30349318,
                'averageDailyVolume10Day': 27909325,
                'fiftyTwoWeekLowChange': 2.4400003,
                'fiftyTwoWeekLowChangePercent': 1.0427352,
                'fiftyTwoWeekRange': '2.34 - 5.45',
                'fiftyTwoWeekHighChange': -0.6699996,
                'fiftyTwoWeekHighChangePercent': -0.12293571,
                'fiftyTwoWeekLow': 2.34,
                'fiftyTwoWeekHigh': 5.45,
                'dividendDate': 1565654400,
                'trailingAnnualDividendRate': 0.221,
                'trailingAnnualDividendYield': 0.049662925,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': -0.192,
                'epsForward': 0.31,
                'sharesOutstanding': 5618930176,
                'bookValue': 3.119,
                'fiftyDayAverage': 4.3285713,
                'fiftyDayAverageChange': 0.4514289,
                'fiftyDayAverageChangePercent': 0.10429051,
                'twoHundredDayAverage': 3.8270504,
                'twoHundredDayAverageChange': 0.95294976,
                'twoHundredDayAverageChangePercent': 0.24900371,
                'marketCap': 25653735424,
                'forwardPE': 15.419355,
                'priceToBook': 1.5325426,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 7.4157395,
                'displayName': 'Nokia',
                'symbol': 'NOK'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 76253400000,
                'priceHint': 2,
                'postMarketChangePercent': -0.30257156,
                'postMarketTime': 1596234024,
                'postMarketPrice': 6.59,
                'postMarketChange': -0.01999998,
                'regularMarketChange': -0.12999964,
                'regularMarketTime': 1596225883,
                'regularMarketPrice': 6.61,
                'regularMarketDayHigh': 6.9,
                'regularMarketDayRange': '6.52 - 6.9',
                'regularMarketDayLow': 6.52,
                'regularMarketVolume': 115075556,
                'regularMarketPreviousClose': 6.74,
                'bid': 6.6,
                'ask': 6.6,
                'bidSize': 292,
                'askSize': 18,
                'exchange': 'NYQ',
                'market': 'us_market',
                'messageBoardId': 'finmb_106335',
                'fullExchangeName': 'NYSE',
                'shortName': 'Ford Motor Company',
                'longName': 'Ford Motor Company',
                'financialCurrency': 'USD',
                'regularMarketOpen': 6.89,
                'averageDailyVolume3Month': 87287634,
                'averageDailyVolume10Day': 65583212,
                'fiftyTwoWeekLowChange': 2.65,
                'fiftyTwoWeekLowChangePercent': 0.66919196,
                'fiftyTwoWeekRange': '3.96 - 9.65',
                'fiftyTwoWeekHighChange': -3.0399995,
                'fiftyTwoWeekHighChangePercent': -0.31502587,
                'fiftyTwoWeekLow': 3.96,
                'fiftyTwoWeekHigh': 9.65,
                'dividendDate': 1583107200,
                'earningsTimestamp': 1603814400,
                'earningsTimestampStart': 1603814400,
                'earningsTimestampEnd': 1603814400,
                'trailingAnnualDividendRate': 0.6,
                'trailingAnnualDividendYield': 0.08902078,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': -0.781,
                'epsForward': 0.52,
                'sharesOutstanding': 3906190080,
                'bookValue': 7.455,
                'fiftyDayAverage': 6.393429,
                'fiftyDayAverageChange': 0.21657133,
                'fiftyDayAverageChangePercent': 0.03387405,
                'twoHundredDayAverage': 6.3716545,
                'twoHundredDayAverageChange': 0.23834562,
                'twoHundredDayAverageChangePercent': 0.03740718,
                'marketCap': 26288234496,
                'forwardPE': 12.711539,
                'priceToBook': 0.8866533,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': -1.9287779,
                'displayName': 'Ford Motor',
                'symbol': 'F'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 1555594200000,
                'priceHint': 2,
                'postMarketChangePercent': 1.6622913,
                'postMarketTime': 1596234159,
                'postMarketPrice': 34.86,
                'postMarketChange': 0.5699997,
                'regularMarketChange': 9.1,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 34.29,
                'regularMarketDayHigh': 34.5,
                'regularMarketDayRange': '31.0 - 34.5',
                'regularMarketDayLow': 31.0,
                'regularMarketVolume': 111167386,
                'regularMarketPreviousClose': 25.19,
                'bid': 34.69,
                'ask': 34.7,
                'bidSize': 13,
                'askSize': 18,
                'exchange': 'NYQ',
                'market': 'us_market',
                'messageBoardId': 'finmb_139264388',
                'fullExchangeName': 'NYSE',
                'shortName': 'Pinterest, Inc.',
                'longName': 'Pinterest, Inc.',
                'financialCurrency': 'USD',
                'regularMarketOpen': 33.56,
                'averageDailyVolume3Month': 13862671,
                'averageDailyVolume10Day': 9896450,
                'fiftyTwoWeekLowChange': 24.19,
                'fiftyTwoWeekLowChangePercent': 2.3950496,
                'fiftyTwoWeekRange': '10.1 - 36.83',
                'fiftyTwoWeekHighChange': -2.540001,
                'fiftyTwoWeekHighChangePercent': -0.06896554,
                'fiftyTwoWeekLow': 10.1,
                'fiftyTwoWeekHigh': 36.83,
                'earningsTimestamp': 1596184200,
                'earningsTimestampStart': 1603987200,
                'earningsTimestampEnd': 1604332800,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': -2.743,
                'epsForward': 0.05,
                'sharesOutstanding': 403489984,
                'bookValue': 3.332,
                'fiftyDayAverage': 24.036858,
                'fiftyDayAverageChange': 10.253143,
                'fiftyDayAverageChangePercent': 0.4265592,
                'twoHundredDayAverage': 20.366547,
                'twoHundredDayAverageChange': 13.923454,
                'twoHundredDayAverageChangePercent': 0.68364334,
                'marketCap': 20109576192,
                'forwardPE': 685.8,
                'priceToBook': 10.291117,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 36.12545,
                'displayName': 'Pinterest',
                'symbol': 'PINS'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': True,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 345479400000,
                'priceHint': 2,
                'postMarketChangePercent': 0.55289054,
                'postMarketTime': 1596234080,
                'postMarketPrice': 427.39,
                'postMarketChange': 2.350006,
                'regularMarketChange': 40.28,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 425.04,
                'regularMarketDayHigh': 425.66,
                'regularMarketDayRange': '403.36 - 425.66',
                'regularMarketDayLow': 403.36,
                'regularMarketVolume': 91201476,
                'regularMarketPreviousClose': 384.76,
                'bid': 427.26,
                'ask': 426.2,
                'bidSize': 30,
                'askSize': 31,
                'exchange': 'NMS',
                'market': 'us_market',
                'messageBoardId': 'finmb_24937',
                'fullExchangeName': 'NasdaqGS',
                'shortName': 'Apple Inc.',
                'longName': 'Apple Inc.',
                'financialCurrency': 'USD',
                'regularMarketOpen': 411.535,
                'averageDailyVolume3Month': 34664412,
                'averageDailyVolume10Day': 32670312,
                'fiftyTwoWeekLowChange': 232.46,
                'fiftyTwoWeekLowChangePercent': 1.2070827,
                'fiftyTwoWeekRange': '192.58 - 425.66',
                'fiftyTwoWeekHighChange': -0.6199951,
                'fiftyTwoWeekHighChangePercent': -0.0014565501,
                'fiftyTwoWeekLow': 192.58,
                'fiftyTwoWeekHigh': 425.66,
                'dividendDate': 1589414400,
                'earningsTimestamp': 1596124800,
                'earningsTimestampStart': 1603868340,
                'earningsTimestampEnd': 1604304000,
                'trailingAnnualDividendRate': 3.08,
                'trailingPE': 32.236633,
                'trailingAnnualDividendYield': 0.0080049895,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': 13.185,
                'epsForward': 14.97,
                'sharesOutstanding': 4334329856,
                'bookValue': 16.761,
                'fiftyDayAverage': 369.66028,
                'fiftyDayAverageChange': 55.37973,
                'fiftyDayAverageChangePercent': 0.1498125,
                'twoHundredDayAverage': 313.8948,
                'twoHundredDayAverageChange': 111.1452,
                'twoHundredDayAverageChangePercent': 0.35408422,
                'marketCap': 1842263621632,
                'forwardPE': 28.392786,
                'priceToBook': 25.35887,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 10.468863,
                'displayName': 'Apple',
                'symbol': 'AAPL'
            }],
            'predefinedScr': True,
            'versionId': 6
        },
        'day_gainers': {
            'id': 'ec5bebb9-b7b2-4474-9e5c-3e258b61cbe6',
            'title': 'Day Gainers - US',
            'description': 'Stocks ordered in descending order by price percent change greater than 3% with respect to the previous close',
            'canonicalName': 'DAY_GAINERS',
            'criteriaMeta': {
                'size': 5,
                'offset': 0,
                'sortField': 'percentchange',
                'sortType': 'DESC',
                'quoteType': 'EQUITY',
                'topOperator': 'AND',
                'criteria': [{
                    'field': 'percentchange',
                    'operators': ['GT'],
                    'values': [3.0],
                    'labelsSelected': []
                }, {
                    'field': 'region',
                    'operators': ['EQ'],
                    'values': [],
                    'labelsSelected': [53]
                }, {
                    'field': 'intradaymarketcap',
                    'operators': ['EQ'],
                    'values': [],
                    'labelsSelected': [1, 2, 3]
                }, {
                    'field': 'dayvolume',
                    'operators': ['GT'],
                    'values': [15000],
                    'labelsSelected': []
                }]
            },
            'rawCriteria': '{"offset":0,"size":5,"sortField":"percentchange","sortType":"DESC","quoteType":"EQUITY","query":{"operator":"AND","operands":[{"operator":"GT","operands":["percentchange",3.0]},{"operator":"eq","operands":["region","us"]},{"operator":"or","operands":[{"operator":"BTWN","operands":["intradaymarketcap",2000000000,10000000000]},{"operator":"BTWN","operands":["intradaymarketcap",10000000000,100000000000]},{"operator":"GT","operands":["intradaymarketcap",100000000000]}]},{"operator":"gt","operands":["dayvolume",15000]}]}}',
            'start': 0,
            'count': 5,
            'total': 107,
            'quotes': [{
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 1555594200000,
                'priceHint': 2,
                'postMarketChangePercent': 1.6622913,
                'postMarketTime': 1596234159,
                'postMarketPrice': 34.86,
                'postMarketChange': 0.5699997,
                'regularMarketChange': 9.1,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 34.29,
                'regularMarketDayHigh': 34.5,
                'regularMarketDayRange': '31.0 - 34.5',
                'regularMarketDayLow': 31.0,
                'regularMarketVolume': 111167386,
                'regularMarketPreviousClose': 25.19,
                'bid': 34.69,
                'ask': 34.7,
                'bidSize': 13,
                'askSize': 18,
                'exchange': 'NYQ',
                'market': 'us_market',
                'messageBoardId': 'finmb_139264388',
                'fullExchangeName': 'NYSE',
                'shortName': 'Pinterest, Inc.',
                'longName': 'Pinterest, Inc.',
                'financialCurrency': 'USD',
                'regularMarketOpen': 33.56,
                'averageDailyVolume3Month': 13862671,
                'averageDailyVolume10Day': 9896450,
                'fiftyTwoWeekLowChange': 24.19,
                'fiftyTwoWeekLowChangePercent': 2.3950496,
                'fiftyTwoWeekRange': '10.1 - 36.83',
                'fiftyTwoWeekHighChange': -2.540001,
                'fiftyTwoWeekHighChangePercent': -0.06896554,
                'fiftyTwoWeekLow': 10.1,
                'fiftyTwoWeekHigh': 36.83,
                'earningsTimestamp': 1596184200,
                'earningsTimestampStart': 1603987200,
                'earningsTimestampEnd': 1604332800,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': -2.743,
                'epsForward': 0.05,
                'sharesOutstanding': 403489984,
                'bookValue': 3.332,
                'fiftyDayAverage': 24.036858,
                'fiftyDayAverageChange': 10.253143,
                'fiftyDayAverageChangePercent': 0.4265592,
                'twoHundredDayAverage': 20.366547,
                'twoHundredDayAverageChange': 13.923454,
                'twoHundredDayAverageChangePercent': 0.68364334,
                'marketCap': 20109576192,
                'forwardPE': 685.8,
                'priceToBook': 10.291117,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 36.12545,
                'displayName': 'Pinterest',
                'symbol': 'PINS'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': False,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 1234535400000,
                'priceHint': 4,
                'regularMarketChange': 0.1509,
                'regularMarketTime': 1596222445,
                'regularMarketPrice': 0.7009,
                'regularMarketDayHigh': 1.5,
                'regularMarketDayRange': '0.7009 - 1.5',
                'regularMarketDayLow': 0.7009,
                'regularMarketVolume': 885738,
                'regularMarketPreviousClose': 0.55,
                'bid': 0.0,
                'ask': 0.0,
                'bidSize': 0,
                'askSize': 0,
                'exchange': 'PNK',
                'market': 'us_market',
                'messageBoardId': 'finmb_92126',
                'fullExchangeName': 'Other OTC',
                'shortName': 'GRUPO FINANCIERO INBURSA SAB DE',
                'longName': 'Grupo Financiero Inbursa, S.A.B. de C.V.',
                'financialCurrency': 'MXN',
                'regularMarketOpen': 0.7144,
                'averageDailyVolume3Month': 9864,
                'averageDailyVolume10Day': 28712,
                'fiftyTwoWeekLowChange': 0.20090002,
                'fiftyTwoWeekLowChangePercent': 0.40180004,
                'fiftyTwoWeekRange': '0.5 - 1.5',
                'fiftyTwoWeekHighChange': -0.7991,
                'fiftyTwoWeekHighChangePercent': -0.5327333,
                'fiftyTwoWeekLow': 0.5,
                'fiftyTwoWeekHigh': 1.5,
                'trailingAnnualDividendRate': 0.024,
                'trailingPE': 4.8673615,
                'trailingAnnualDividendYield': 0.043636363,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': 0.144,
                'sharesOutstanding': 6594800128,
                'bookValue': 1.078,
                'fiftyDayAverage': 0.7088571,
                'fiftyDayAverageChange': -0.007957101,
                'fiftyDayAverageChangePercent': -0.011225253,
                'twoHundredDayAverage': 0.83330935,
                'twoHundredDayAverageChange': -0.13240933,
                'twoHundredDayAverageChangePercent': -0.15889578,
                'marketCap': 6064775680,
                'priceToBook': 0.6501856,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 27.436363,
                'displayName': 'Grupo Financiero Inbursa',
                'symbol': 'GPFOF'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Nasdaq Real Time Price',
                'triggerable': True,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 1524835800000,
                'priceHint': 2,
                'postMarketChangePercent': 0.000967242,
                'postMarketTime': 1596225642,
                'postMarketPrice': 103.331,
                'postMarketChange': 0.000999451,
                'regularMarketChange': 19.440002,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 103.33,
                'regularMarketDayHigh': 105.98,
                'regularMarketDayRange': '94.75 - 105.98',
                'regularMarketDayLow': 94.75,
                'regularMarketVolume': 739795,
                'regularMarketPreviousClose': 83.89,
                'bid': 96.0,
                'ask': 103.23,
                'bidSize': 8,
                'askSize': 9,
                'exchange': 'NMS',
                'market': 'us_market',
                'messageBoardId': 'finmb_557929974',
                'fullExchangeName': 'NasdaqGS',
                'shortName': 'Goosehead Insurance, Inc.',
                'longName': 'Goosehead Insurance, Inc',
                'financialCurrency': 'USD',
                'regularMarketOpen': 96.6,
                'averageDailyVolume3Month': 182756,
                'averageDailyVolume10Day': 100200,
                'fiftyTwoWeekLowChange': 66.07001,
                'fiftyTwoWeekLowChangePercent': 1.7732155,
                'fiftyTwoWeekRange': '37.26 - 105.98',
                'fiftyTwoWeekHighChange': -2.6500015,
                'fiftyTwoWeekHighChangePercent': -0.025004731,
                'fiftyTwoWeekLow': 37.26,
                'fiftyTwoWeekHigh': 105.98,
                'dividendDate': 1554076800,
                'earningsTimestamp': 1596124800,
                'earningsTimestampStart': 1604041140,
                'earningsTimestampEnd': 1604390400,
                'trailingAnnualDividendRate': 0.0,
                'trailingPE': 543.8421,
                'trailingAnnualDividendYield': 0.0,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': 0.19,
                'epsForward': 0.75,
                'sharesOutstanding': 17135800,
                'bookValue': 0.072,
                'fiftyDayAverage': 77.440285,
                'fiftyDayAverageChange': 25.889717,
                'fiftyDayAverageChangePercent': 0.33431846,
                'twoHundredDayAverage': 58.403347,
                'twoHundredDayAverageChange': 44.926655,
                'twoHundredDayAverageChangePercent': 0.76924795,
                'marketCap': 3862465024,
                'forwardPE': 137.77333,
                'priceToBook': 1435.1389,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 23.173206,
                'displayName': 'Goosehead Insurance',
                'symbol': 'GSHD'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Delayed Quote',
                'triggerable': True,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 1469712600000,
                'priceHint': 2,
                'postMarketChangePercent': -2.832169,
                'postMarketTime': 1596225980,
                'postMarketPrice': 189.3801,
                'postMarketChange': -5.5198975,
                'regularMarketChange': 28.98999,
                'regularMarketTime': 1596225601,
                'regularMarketPrice': 194.9,
                'regularMarketDayHigh': 194.94,
                'regularMarketDayRange': '169.0 - 194.94',
                'regularMarketDayLow': 169.0,
                'regularMarketVolume': 337089,
                'regularMarketPreviousClose': 165.91,
                'bid': 192.0,
                'ask': 199.11,
                'bidSize': 10,
                'askSize': 10,
                'exchange': 'NMS',
                'market': 'us_market',
                'messageBoardId': 'finmb_216477057',
                'fullExchangeName': 'NasdaqGS',
                'shortName': 'Kinsale Capital Group, Inc.',
                'longName': 'Kinsale Capital Group, Inc.',
                'financialCurrency': 'USD',
                'regularMarketOpen': 169.0,
                'averageDailyVolume3Month': 157907,
                'averageDailyVolume10Day': 95400,
                'fiftyTwoWeekLowChange': 113.96999,
                'fiftyTwoWeekLowChangePercent': 1.4082539,
                'fiftyTwoWeekRange': '80.93 - 194.94',
                'fiftyTwoWeekHighChange': -0.040008545,
                'fiftyTwoWeekHighChangePercent': -0.00020523518,
                'fiftyTwoWeekLow': 80.93,
                'fiftyTwoWeekHigh': 194.94,
                'dividendDate': 1591920000,
                'earningsTimestamp': 1596124800,
                'earningsTimestampStart': 1603987200,
                'earningsTimestampEnd': 1604332800,
                'trailingAnnualDividendRate': 0.33,
                'trailingPE': 87.91159,
                'trailingAnnualDividendYield': 0.0019890303,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': 2.217,
                'epsForward': 3.22,
                'sharesOutstanding': 22254600,
                'bookValue': 18.034,
                'fiftyDayAverage': 157.56015,
                'fiftyDayAverageChange': 37.339844,
                'fiftyDayAverageChangePercent': 0.23698786,
                'twoHundredDayAverage': 129.625,
                'twoHundredDayAverageChange': 65.274994,
                'twoHundredDayAverageChangePercent': 0.50356793,
                'marketCap': 4337421312,
                'forwardPE': 60.527946,
                'priceToBook': 10.8073635,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 17.473322,
                'displayName': 'Kinsale Capital',
                'symbol': 'KNSL'
            }, {
                'language': 'en-US',
                'region': 'US',
                'quoteType': 'EQUITY',
                'quoteSourceName': 'Nasdaq Real Time Price',
                'triggerable': True,
                'currency': 'USD',
                'firstTradeDateMilliseconds': 791735400000,
                'priceHint': 2,
                'postMarketChangePercent': 2.8466468,
                'postMarketTime': 1596230968,
                'postMarketPrice': 56.0,
                'postMarketChange': 1.5499992,
                'regularMarketChange': 7.1399994,
                'regularMarketTime': 1596225602,
                'regularMarketPrice': 54.45,
                'regularMarketDayHigh': 54.53,
                'regularMarketDayRange': '49.02 - 54.53',
                'regularMarketDayLow': 49.02,
                'regularMarketVolume': 1196752,
                'regularMarketPreviousClose': 47.31,
                'bid': 54.41,
                'ask': 54.42,
                'bidSize': 8,
                'askSize': 8,
                'exchange': 'NMS',
                'market': 'us_market',
                'messageBoardId': 'finmb_336648',
                'fullExchangeName': 'NasdaqGS',
                'shortName': 'Brooks Automation, Inc.',
                'longName': 'Brooks Automation, Inc.',
                'financialCurrency': 'USD',
                'regularMarketOpen': 50.0,
                'averageDailyVolume3Month': 505335,
                'averageDailyVolume10Day': 407887,
                'fiftyTwoWeekLowChange': 33.260002,
                'fiftyTwoWeekLowChangePercent': 1.5696083,
                'fiftyTwoWeekRange': '21.19 - 54.53',
                'fiftyTwoWeekHighChange': -0.07999802,
                'fiftyTwoWeekHighChangePercent': -0.001467046,
                'fiftyTwoWeekLow': 21.19,
                'fiftyTwoWeekHigh': 54.53,
                'dividendDate': 1593129600,
                'earningsTimestamp': 1596124800,
                'earningsTimestampStart': 1596124800,
                'earningsTimestampEnd': 1596124800,
                'trailingAnnualDividendRate': 0.4,
                'trailingPE': 8.9262295,
                'trailingAnnualDividendYield': 0.008454872,
                'marketState': 'POST',
                'epsTrailingTwelveMonths': 6.1,
                'epsForward': 1.21,
                'sharesOutstanding': 73759000,
                'bookValue': 15.928,
                'fiftyDayAverage': 44.00857,
                'fiftyDayAverageChange': 10.441429,
                'fiftyDayAverageChangePercent': 0.23725899,
                'twoHundredDayAverage': 38.295036,
                'twoHundredDayAverageChange': 16.154964,
                'twoHundredDayAverageChangePercent': 0.4218553,
                'marketCap': 4016177664,
                'forwardPE': 45.0,
                'priceToBook': 3.4185083,
                'sourceInterval': 15,
                'exchangeDataDelayedBy': 0,
                'exchangeTimezoneName': 'America/New_York',
                'exchangeTimezoneShortName': 'EDT',
                'gmtOffSetMilliseconds': -14400000,
                'esgPopulated': False,
                'tradeable': True,
                'regularMarketChangePercent': 15.091946,
                'displayName': 'Brooks Automation',
                'symbol': 'BRKS'
            }],
            'predefinedScr': True,
            'versionId': 6
        }
    }
    ```