import unittest

from roseta import trans_weight


class TestWeightConvert(unittest.TestCase):
    def setUp(self) -> None:
        self.weight_data = {
            # pattern1
            "负零点八": [(-0.8, "g"), (-0.8, "kg")],
            "负零点八斤": [(-400, "g"), (-0.4, "kg")],
            "零点八斤": [(400, "g"), (0.4, "kg")],
            "零点八公斤": [(800, "g"), (0.8, "kg")],
            "零点八克": [(0.8, "g"), (0.0008, "kg")],
            "零点八千克": [(800, "g"), (0.8, "kg")],
            "八十斤": [(40000, "g"), (40, "kg")],
            "八十公斤": [(80000, "g"), (80, "kg")],
            "八十克": [(80, "g"), (0.08, "kg")],
            "八十千克": [(80000, "g"), (80, "kg")],
            "八十八斤": [(44000, "g"), (44, "kg")],
            "八十八公斤": [(88000, "g"), (88, "kg")],
            "八十八克": [(88, "g"), (0.088, "kg")],
            "八十八千克": [(88000, "g"), (88, "kg")],
            "八十八g": [(88, "g"), (0.088, "kg")],
            "八十八kg": [(88000, "g"), (88, "kg")],
            # pattern2
            "-0.8": [(-0.8, "g"), (-0.8, "kg")],
            "-0.8斤": [(-400, "g"), (-0.4, "kg")],
            "0.8斤": [(400, "g"), (0.4, "kg")],
            "0.8公斤": [(800, "g"), (0.8, "kg")],
            "0.8克": [(0.8, "g"), (0.0008, "kg")],
            "0.8千克": [(800, "g"), (0.8, "kg")],
            "80斤": [(40000, "g"), (40, "kg")],
            "80公斤": [(80000, "g"), (80, "kg")],
            "80克": [(80, "g"), (0.08, "kg")],
            "80千克": [(80000, "g"), (80, "kg")],
            "88斤": [(44000, "g"), (44, "kg")],
            "88公斤": [(88000, "g"), (88, "kg")],
            "88克": [(88, "g"), (0.088, "kg")],
            "88千克": [(88000, "g"), (88, "kg")],
            "88g": [(88, "g"), (0.088, "kg")],
            "88kg": [(88000, "g"), (88, "kg")],
            "88G": [(88, "g"), (0.088, "kg")],
            "88KG": [(88000, "g"), (88, "kg")],
            "88Kg": [(88000, "g"), (88, "kg")],
            "88kG": [(88000, "g"), (88, "kg")],
            # # pattern3
            "负一斤八": [(-900, "g"), (-0.9, "kg")],
            "一斤八": [(900, "g"), (0.9, "kg")],
            "一斤8": [(900, "g"), (0.9, "kg")],
            "1斤八": [(900, "g"), (0.9, "kg")],
            "1斤8": [(900, "g"), (0.9, "kg")],
            # pattern4
            "八十几斤": [(42500, "g"), (42.5, "kg")],
            "八十多斤": [(41000, "g"), (41, "kg")],
            "八十几公斤": [(85000, "g"), (85, "kg")],
            "八十多公斤": [(82000, "g"), (82, "kg")],
            # pattern5
            "80几": [(85, "g"), (85, "kg")],
            "80多": [(82, "g"), (82, "kg")],
            "80几斤": [(42500, "g"), (42.5, "kg")],
            "80多斤": [(41000, "g"), (41, "kg")],
            "80几公斤": [(85000, "g"), (85, "kg")],
            "80多公斤": [(82000, "g"), (82, "kg")],
            "80几kg": [(85000, "g"), (85, "kg")],
            "80多kg": [(82000, "g"), (82, "kg")],
            "80几g": [(85, "g"), (0.085, "kg")],
            "80多g": [(82, "g"), (0.082, "kg")],
        }

    def test_trans(self) -> None:
        for key, value in self.weight_data.items():
            self.assertEqual(trans_weight(key), value[1])  # default unit: kg
            self.assertEqual(trans_weight(key, unit="g"), value[0])
            self.assertEqual(trans_weight(key, unit="kg"), value[1])


if __name__ == '__main__':
    unittest.main()
