import unittest

from roseta import trans_length


class TestLengthConvert(unittest.TestCase):
    def setUp(self) -> None:
        self.length_data = {
            # pattern1
            "二尺": [(66.67, "cm"), (0.6667, "m")],
            "两尺": [(66.67, "cm"), (0.6667, "m")],
            "2尺": [(66.67, "cm"), (0.6667, "m")],
            "2.1尺": [(70, "cm"), (0.7, "m")],
            "2点1尺": [(70, "cm"), (0.7, "m")],
            "一尺八": [(60, "cm"), (0.6, "m")],
            "1尺一五": [(38.33, "cm"), (0.3833, "m")],
            "二尺五": [(83.33, "cm"), (0.8333, "m")],
            "2尺3": [(76.67, "cm"), (0.7667, "m")],
            "2尺四": [(80, "cm"), (0.8, "m")],
            "2尺2寸": [(73.33, "cm"), (0.7333, "m")],
            "2尺多": [(73.33, "cm"), (0.7333, "m")],
            "两尺一寸": [(70, "cm"), (0.7, "m")],
            "两尺几": [(83.33, "cm"), (0.8333, "m")],
            # pattern2
            "负零点八": [(-0.8, "cm"), (-0.8, "m")],
            "负零点八厘米": [(-0.8, "cm"), (-0.008, "m")],
            "零点八米": [(80, "cm"), (0.8, "m")],
            "零点八厘米": [(0.8, "cm"), (0.008, "m")],
            "八米": [(800, "cm"), (8, "m")],
            "八厘米": [(8, "cm"), (0.08, "m")],
            "八十米": [(8000, "cm"), (80, "m")],
            "八十厘米": [(80, "cm"), (0.8, "m")],
            "八十七米": [(8700, "cm"), (87, "m")],
            "八十七厘米": [(87, "cm"), (0.87, "m")],
            # pattern3
            "-0.8米": [(-80, "cm"), (-0.8, "m")],
            "0.8米": [(80, "cm"), (0.8, "m")],
            "0.8厘米": [(0.8, "cm"), (0.008, "m")],
            "1米": [(100, "cm"), (1, "m")],
            "1厘米": [(1, "cm"), (0.01, "m")],
            "1.8米": [(180, "cm"), (1.8, "m")],
            "1.8厘米": [(1.8, "cm"), (0.018, "m")],
            "18米": [(1800, "cm"), (18, "m")],
            "18厘米": [(18, "cm"), (0.18, "m")],
            "180米": [(18000, "cm"), (180, "m")],
            "180厘米": [(180, "cm"), (1.8, "m")],
            # pattern4
            "负一米八": [(-180, "cm"), (-1.8, "m")],
            "一米八": [(180, "cm"), (1.8, "m")],
            "一米八七": [(187, "cm"), (1.87, "m")],
            "一米8": [(180, "cm"), (1.8, "m")],
            "一米87": [(187, "cm"), (1.87, "m")],
            "1米八": [(180, "cm"), (1.8, "m")],
            "1米八七": [(187, "cm"), (1.87, "m")],
            "1米8": [(180, "cm"), (1.8, "m")],
            "1米87": [(187, "cm"), (1.87, "m")],
            # pattern5
            "八十几厘米": [(85, "cm"), (0.85, "m")],
            "八十多厘米": [(82, "cm"), (0.82, "m")],
            "一米八几": [(185, "cm"), (1.85, "m")],
            "一米八多": [(182, "cm"), (1.82, "m")],
            # pattern6
            "80几": [(85, "cm"), (85, "m")],
            "80几米": [(8500, "cm"), (85, "m")],
            "80几厘米": [(85, "cm"), (0.85, "m")],
            "80多": [(82, "cm"), (82, "m")],
            "80多米": [(8200, "cm"), (82, "m")],
            "80多厘米": [(82, "cm"), (0.82, "m")],
        }

    def test_trans_length(self) -> None:
        for key, value in self.length_data.items():
            self.assertEqual(trans_length(key), value[0])  # default unit: cm
            self.assertEqual(trans_length(key, unit="cm"), value[0])
            self.assertEqual(trans_length(key, unit="m"), value[1])


if __name__ == '__main__':
    unittest.main()
