import unittest

from roseta import trans_cup


class TestCup(unittest.TestCase):
    def setUp(self) -> None:
        self.cup_data = {
            "32a": [([82, 70], "cm"), ([0.82, 0.7], "m")],
            "c36": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "40c": [([106, 90], "cm"), ([1.06, 0.9], "m")],
            "c42": [([111, 95], "cm"), ([1.11, 0.95], "m")],
            "E48": [([130, 110], "cm"), ([1.3, 1.1], "m")],
            "85B": [([99, 85], "cm"), ([0.99, 0.85], "m")],
            "95F": [([117, 95], "cm"), ([1.17, 0.95], "m")],
            "c80": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "H110": [([136, 110], "cm"), ([1.36, 1.1], "m")],
            "105g": [([129, 105], "cm"), ([1.29, 1.05], "m")],
            "三十二a": [([82, 70], "cm"), ([0.82, 0.7], "m")],
            "c三十六": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "四十c": [([106, 90], "cm"), ([1.06, 0.9], "m")],
            "c四十二": [([111, 95], "cm"), ([1.11, 0.95], "m")],
            "E四十八": [([130, 110], "cm"), ([1.3, 1.1], "m")],
            "八十五B": [([99, 85], "cm"), ([0.99, 0.85], "m")],
            "九十五F": [([117, 95], "cm"), ([1.17, 0.95], "m")],
            "c八十": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "H一百一十": [([136, 110], "cm"), ([1.36, 1.1], "m")],
            "一百零五g": [([129, 105], "cm"), ([1.29, 1.05], "m")],
            "三二a": [([82, 70], "cm"), ([0.82, 0.7], "m")],
            "c三六": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "四零c": [([106, 90], "cm"), ([1.06, 0.9], "m")],
            "c四二": [([111, 95], "cm"), ([1.11, 0.95], "m")],
            "E四八": [([130, 110], "cm"), ([1.3, 1.1], "m")],
            "八五B": [([99, 85], "cm"), ([0.99, 0.85], "m")],
            "九五F": [([117, 95], "cm"), ([1.17, 0.95], "m")],
            "c八零": [([96, 80], "cm"), ([0.96, 0.8], "m")],
            "H一一零": [([136, 110], "cm"), ([1.36, 1.1], "m")],
            "一零五g": [([129, 105], "cm"), ([1.29, 1.05], "m")]
        }

    def test_trans_cup(self) -> None:
        for key, value in self.cup_data.items():
            self.assertEqual(trans_cup(key),  value[0])  # default unit: cm
            self.assertEqual(trans_cup(key, unit="cm"), value[0])
            self.assertEqual(trans_cup(key, unit="m"), value[1])


if __name__ == "__main__":
    unittest.main()
