"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const codestar = require("aws-cdk-lib/aws-codestar");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codestar_alpha_GitHubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.unsafeUnwrap(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_b = props.enableIssues) !== null && _b !== void 0 ? _b : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
_a = JSII_RTTI_SYMBOL_1;
GitHubRepository[_a] = { fqn: "@aws-cdk/aws-codestar-alpha.GitHubRepository", version: "2.21.0-alpha.0" };
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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