/* eslint-disable class-methods-use-this, import/prefer-default-export */
import { DestEventTypes } from '../../eventTypes'
import { BaseTracker } from '../base'

class TNSTracker extends BaseTracker {
	constructor(sensors, logger) {
		super(logger)
		this.sensors = sensors
	}

	log(e) {
		this.logger.log(`recieving event ${e.type}`)

		switch (e.type) {
			case DestEventTypes.PLAY:
			case DestEventTypes.AUTOPLAY:
				this.trackTNS(e.data)
				break
			default:
				// do nothing
				break
		}
	}

	// we don't have author yet
	trackTNS({ author, title, videoId }) {
		author = 'seher'

		const springDesc = {
			stream: `youtube_testing/${author}/${videoId}(${title})`,
		}

		const springAdapter = {
			getMeta() {
				return {
					pl: 'youtube',
					pv: 'version1',
					sx: window.screen.width,
					sy: window.screen.height,
				}
			},
			getDuration() {
				return Math.floor(window.target.getDuration())
			},
			getPosition() {
				return Math.floor(window.target.getCurrentTime())
			},
		}

		this.sensors.track(videoId, springDesc, springAdapter)
	}
}

export { TNSTracker }
