/* eslint-disable import/prefer-default-export */
import { JWEventSource } from './jwEventSource'
import { JWEventSubscriber } from './jwEventSubscriber'
import { Dispatcher } from '../../trackingDispatcher'
import { jwTrackingConfig } from './jwTrackingConfig'

/**
 * @class Class representing an entry point for
 * JWPlayer tracking
 * It aggregates all tracking functionality
 */
class JWTracking {
	/**
	 * @param {*} playerInstance - JW Player instance (got as a result of setup() method)
	 * @param {*} options
	 */
	constructor(playerInstance, options) {
		this.playerInstance = playerInstance

		this.options = options
		this.config = jwTrackingConfig(playerInstance)
	}

	init() {
		const { factories, eventsToListen } = this.config

		const eSource = new JWEventSource(this.playerInstance, this.options)
		const dispatcher = new Dispatcher(eSource, factories, this.options)
		const subscriber = new JWEventSubscriber(this.playerInstance, dispatcher, eventsToListen)

		subscriber.connect()
	}
}

export { JWTracking }
