/* eslint-disable import/prefer-default-export */
/**
 * Class representing mechanism of subscribing
 * to JW Player events
 */
class JWEventSubscriber {
	/**
	 * @param {*} player - JW Player instance (got from jwplayer.setup() method)
	 * @param {Dispatcher} dispatcher - Dispatcher instance
	 * @param {string[]} eventsToListen - array of events, to which dispatcher will be subscribed
	 */
	constructor(player, dispatcher, eventsToListen) {
		this.player = player
		this.dispatcher = dispatcher

		this.eventsToListen = eventsToListen
	}

	/**
	 * Subscribes to JW events
	 */
	connect() {
		this.eventsToListen.forEach(eventName => {
			this.player.on(eventName, e => {
				this.dispatcher.dispatch(e)
			})
		})
	}
}

export { JWEventSubscriber }
