export const DEFAULT_AUTOPLAYTIMER = 2
/**
 * @function parseCustom
 * parses JSON stringified object of
 * custom params for video
 * @param {string} customStringified - JSON stringified custom params
 * @returns {*} - custom params object
 */
export function parseCustom(customStringified) {
	if (!customStringified) return {}
	try {
		const { startfrom, repeat, autoplaytimer = DEFAULT_AUTOPLAYTIMER, plussproductid } = JSON.parse(
			customStringified,
		)

		// here will be custom params
		return {
			starttime: parseStartTime(startfrom),
			repeat,
			autoplaytimer: parseStartTime(autoplaytimer),
			plussproductid,
		}
	} catch (e) {
		// eslint-disable-next-line no-console
		console.error('caught error while parsing custom parameters')
		// eslint-disable-next-line no-console
		console.error(e)
		return {}
	}
}

export function parseStartTime(time) {
	const res = Number(time)

	return res > 0 ? res : 0
}
