import { JWTracking } from './sources'
import triggerEvent from '../event-polyfill'

const isLandscapeDeviceOrientation = () => {
	if (!process.browser) {
		return false
	}
	const width = window.innerWidth || document.documentElement.clientWidth
	const height = window.innerHeight || document.documentElement.clientHeight
	return width > height
}

let isLandscape = isLandscapeDeviceOrientation()

export function initTracking(playerInstance) {
	try {
		const videoType = 'clip' // TODO: receive from W-API

		const tracking = new JWTracking(playerInstance, { videoType })
		tracking.init()
	} catch (e) {
		// eslint-disable-next-line no-console
		console.error('got error while intializing tracking')
		// eslint-disable-next-line no-console
		console.error(e)
	}
}

/*
	dispatches 'playerLoaded-ID' event,
	which will be caught in blink-labrador for
	tracking to initialize
*/
export function notifyPlayerLoaded(playerInstance, id) {
	playerInstance.on('ready', () => {
		triggerEvent(`playerLoaded-${id}`)
	})
}

export function onResize(playerInstance) {
	if (!process.browser) {
		return
	}
	window.addEventListener('resize', () => {
		if (playerInstance.getState() === 'idle' || !playerInstance.getViewable()) {
			return
		}
		if (isLandscapeDeviceOrientation() && !isLandscape) {
			isLandscape = true
			playerInstance.setFullscreen(true)
		} else if (!isLandscapeDeviceOrientation() && isLandscape) {
			isLandscape = false
			playerInstance.setFullscreen(false)
		}
	})
}

/**
 * @function
 * event that is emitted, specifies
 * that functions from video-assets.js
 * are safe to call (script is loaded)
 */
export function notifyVideoAssetsLoaded() {
	triggerEvent('videoAssetsLoaded')
}

// sometimes editors want first video on the page
// to be autoplayable
// and because we can not set multiple players on the page
// (jw will pick first to work with, anyways)
// others videos on the page will also autoplay
// so, for such case we force other videos 'Click to play'
export const forceClickToPlay = config => {
	config.autostart = false
}

export const isFirstPlayer = id => {
	const queryAttr = 'data-videoid'
	const playerNodes = [...document.querySelectorAll(`[${queryAttr}]`)]
	const currentPlayerNode = document.querySelector(`[${queryAttr}="${id}"]`)

	return playerNodes.indexOf(currentPlayerNode) === 0
}

/**
 * @function
 * triggers ad manually (needed for prebids)
 */
export function initAdEvent(player, adUrl) {
	// setup ad event
	player.on('beforePlay', e => {
		if (player.getPosition() === 0 && adUrl) {
			player.playAd(adUrl)
		}
	})
}

/** Detects if current browser is Internet Explorer 11 */
export function isIE11() {
	return !!window.MSInputMethodContext && !!document.documentMode
}
