import React from 'react'
import { ShinyThemeProvider } from '@aller/shiny/src/atoms/ShinyThemeProvider'
import { render } from '@testing-library/react'
import kkTheme from '../themes/kk'

const KKThemeProvider = ({ children }: any) => {
	return <ShinyThemeProvider theme={kkTheme}>{children}</ShinyThemeProvider>
}

const kkRender = (ui: React.ReactElement, options?: any) =>
	render(ui, { wrapper: KKThemeProvider, ...options })

// re-export everything
export * from '@testing-library/react'

// override render method
export { kkRender }
