import fillEmptyGridSizes from '../../components/SolPlug/Plug/get-grid-sizes'
import { StandardizedArticlePreviewFormat } from './types'
import { Labrador_ArticlePreview, Labrador_Image, Labrador_Metadata } from '../../graphql/types'
import { Column } from '../../components/FlexCol/types'

interface Extended_Labrador_ArticlePreview extends Labrador_ArticlePreview {
	column?: Column
	parentWidth: any
	identifier: string
}

export function standardizeArticleFromLabrador({
	contentMarketingPublisher,
	id,
	label,
	image = {} as Labrador_Image,
	metadata = {} as Labrador_Metadata,
	column: columnUnsecured,
	publishedURL,
	subtitle,
	tags,
	textOverlayBackground,
	title,
	width,
	parentWidth,
	identifier,
}: Extended_Labrador_ArticlePreview): StandardizedArticlePreviewFormat {
	const column = fillEmptyGridSizes(columnUnsecured)

	const { hideImage = false, showSubtitle = false } = metadata as Labrador_Metadata

	let imageUrl: string | undefined
	let imageRatio: number | undefined
	if (!hideImage && image.url) {
		imageUrl = image.url ? `https:${image.url}` : ''
		imageRatio = Math.floor((image.whRatio || 0.5) * 10000) / 10000
	}

	return {
		articleSource: 'Labrador',
		imageUrl,
		imageRatio,
		dataLabel: label,
		title,
		subtitle: showSubtitle ? subtitle : undefined,
		url: publishedURL,
		tag: tags[0] ? tags[0] : '',
		column,
		labrador: {
			contentMarketingPublisher,
			id,
			image,
			metadata,
			textOverlayBackground,
			width,
			parentWidth,
			identifier,
		},
	}
}

export default function standardizeArticlesFromLabrador(
	articles: Extended_Labrador_ArticlePreview[],
): StandardizedArticlePreviewFormat[] {
	return articles.map((article: Extended_Labrador_ArticlePreview) =>
		standardizeArticleFromLabrador(article),
	)
}
