import { createSelector } from 'reselect'

const summarize = articles => {
	const mapObj = {}
	articles.map(({ tags }) => {
		if (tags && tags.map) {
			tags.map(tag => {
				if (!mapObj[tag]) {
					mapObj[tag] = 1
				} else {
					mapObj[tag] += 1
				}
				return mapObj
			})
		}
		return mapObj
	})
	return mapObj
}

const summarizeToCoords = tagSummarize =>
	Object.keys(tagSummarize).map(x => ({ x, y: tagSummarize[x] }))

const tagSummarizeSorter = createSelector(
	[
		({ tagSummarize }) =>
			Object.keys(tagSummarize).sort((a, b) => tagSummarize[b] - tagSummarize[a]),
	],
	sortedKeys => ({ sortedKeys }),
)
const tagSummarizeCoordsSelector = createSelector(
	[({ tagSummarize }) => summarizeToCoords(tagSummarize)],
	coords => ({ coords }),
)
export const getTagSummarizePercent = createSelector(
	[
		({ tagSummarize, visible }) => {
			let sum = 0
			Object.keys(tagSummarize)
				.slice(0, visible)
				.map(key => {
					sum += tagSummarize[key]
					return sum
				})
			const tagSummarizePercent = {}
			Object.keys(tagSummarize)
				.slice(0, visible)
				.map(key => {
					tagSummarizePercent[key] = Math.floor((tagSummarize[key] / sum) * 100)
					return tagSummarizePercent
				})
			return tagSummarizePercent
		},
	],
	tagSummarizePercent => ({ tagSummarizePercent }),
)
export const tagSummarizeSelector = createSelector(
	[({ articles, visible }) => ({ tagSummarize: summarize(articles), visible })],
	({ tagSummarize, visible }) => ({
		...tagSummarizeSorter({ tagSummarize }),
		...tagSummarizeCoordsSelector({ tagSummarize }),
		...getTagSummarizePercent({ tagSummarize, visible }),
		tagSummarize,
	}),
)
