import { stripUnit } from 'polished'
import { cssReset } from '../../utils/css-reset'

import colors from './colors'

const horizontalBase = 1
const verticalBase = 2.4

const variables = {
	mainFont: '"Open Sans", Helvetica, Arial, sans-serif',
	headingsFont: '"Playfair Display", Georgia, serif',
	uiFont: '"Open Sans", Helvetica, Arial, sans-serif',

	headingsWeight: 300,

	uiWeight: 300,
	uiRegularSize: '1.6rem',
	uiRegularLineHeight: '2.4rem',

	horizontalBase: `${horizontalBase}rem`,
	unitlessHorizontalBase: horizontalBase,

	verticalBase: `${verticalBase}rem`,
	unitlessVerticalBase: verticalBase,
}

const flexboxgrid = {
	gridSize: 12,
	gutterWidth: stripUnit(horizontalBase), // rem
	outerMargin: 1.5, // rem
	mediaQuery: 'only screen',
	container: {
		sm: 49.0, // rem
		md: 101.0, // rem
		lg: 101.0, // rem
	},
	breakpoints: {
		xs: 0, // em
		sm: 48, // em
		md: 64, // em
		lg: 75, // em
	},
}

const globalStyles = `
	@import url('https://fonts.googleapis.com/css?family=Playfair+Display:400,400i,700,700i&display=fallback');
	@import url('https://fonts.googleapis.com/css?family=Open+Sans:300,400,700,800&display=fallback');
	${cssReset}
`

const theme = {
	name: 'KK',
	colors,
	global: globalStyles,
	flexboxgrid,
	variables,
}

export default theme
