import React from 'react'
import { storiesOf } from '@storybook/react'

import vi from '@aller/shiny/src/themes/vi'

import themeDecorator from './theme-decorator'
import ViHeader from '../components/header/ViHeader'
import ViFooter from '../components/footer/ViFooter'

export default () => {
	storiesOf('Vi', module)
		.addDecorator(themeDecorator(vi))
		.add('ViHeader', () => <ViHeader />)
		.add('ViFooter', () => <ViFooter />)
}
