import React from 'react'
import styled from 'styled-components'
import { ShinyThemeProvider } from '../components/LoganThemeProvider' // eslint-disable-line
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { getColor } from '@aller/shiny/src/utils/get-color'

const Styles = styled.div`
	background: ${getColor('background')};
	color: ${getColor('type')};
	font-family: ${getVariable('mainFont')};
	font-size: ${getVariable('uiRegularSize')};
	line-height: ${getVariable('uiRegularLineHeight')};
	font-weight: ${getVariable('uiWeight')};
`

export default theme => stories => (
	<ShinyThemeProvider theme={theme}>
		<Styles>{stories()}</Styles>
	</ShinyThemeProvider>
)
