import React from 'react'
import styled from 'styled-components'

import { XLargeHeading } from '@aller/shiny/src/atoms/Heading'

import BrandBar from '../../components/header/SOLComponents/BrandBar'
import CategoryBar from '../../components/header/SOLComponents/CategoryBar'

const Header = styled.header`
	margin-bottom: ${({ theme }) => theme.variables.horizontalBase};
`

const SOLHeaderStory = () => (
	<>
		<XLargeHeading>SOL header</XLargeHeading>
		<Header>
			<BrandBar preventClockUpdate preventWeatherUpdate />
			<CategoryBar />
		</Header>
	</>
)

export default SOLHeaderStory
