import React from 'react'
import { Col, Grid, Row } from '@aller/shiny/src'
import Carousel from '../../components/video/carousel'
import ArticlePreview from '../../components/ArticlePreview'
import { videos, label, props, carouselProps } from './video-data'

export default () => (
	<Grid>
		<Row>
			<Col xs={12} md={9}>
				<ArticlePreview {...props} />
			</Col>
			<Col xs={false} md={3}>
				<Carousel
					hostname="seher"
					headingComponent=""
					themeName="SeHer"
					hideButtons
					{...carouselProps}
					label={label}
					vertical
					videos={videos}
				/>
			</Col>
		</Row>
		<Row>
			<Col xs={12}>
				<Carousel
					hostname="seher"
					{...carouselProps}
					label={label}
					headingComponent="frontSmall"
					videos={videos}
				/>
			</Col>
		</Row>
		<Row>
			<Col xs={12}>
				<Carousel
					hostname="seher"
					{...carouselProps}
					label={label}
					headingComponent="frontSmall"
					videos={videos}
				/>
			</Col>
		</Row>
		<Row>
			<Col xs={12} md={false}>
				<Carousel
					hostname="seher"
					{...carouselProps}
					label={label}
					headingComponent="frontSmall"
					videos={videos}
				/>
			</Col>
		</Row>
	</Grid>
)
