import React from 'react'
import { storiesOf } from '@storybook/react'

import seher from '@aller/shiny/src/themes/seher'

import themeDecorator from '../theme-decorator'
import SeherHeader from '../../components/header/SeherHeader'
import SeherFooter from '../../components/footer/SeherFooter'
import SeherVideoStory from './seherVideo'
import SeherVideosStory from './seherVideos'
import CtaPopupStory from './ctaPopupStory'

export default () => {
	storiesOf('Seher', module)
		.addDecorator(themeDecorator(seher))
		.add('SeherHeader', () => <SeherHeader displayDropdownsInitially />)
		.add('SeherFooter', () => <SeherFooter />, {
			chromatic: { delay: 1000 },
		})
		.add('SeherVideo', () => <SeherVideoStory />)
		.add('SeherVideos', () => <SeherVideosStory />, {
			chromatic: { delay: 300 },
		})
		.add('CtaPopup', () => <CtaPopupStory />, {
			chromatic: { delay: 1000 },
		})
}
