import React from 'react'
import { storiesOf } from '@storybook/react' // eslint-disable-line import/no-extraneous-dependencies

import dagbladet from '@aller/shiny/lib/themes/dagbladet'

import themeDecorator from '../theme-decorator'
import LatestBlock from './latestBlock'
import TopBlock from './topBlock'
import PlussBar from './plussBar'
import Search from './search'

export default () => {
	storiesOf('Eavis', module)
		.addDecorator(themeDecorator(dagbladet))
		.add('latestBlock', () => <LatestBlock />, {
			chromatic: { delay: 500 },
		})
		.add('topBlock', () => <TopBlock />, {
			chromatic: { delay: 500 },
		})
		.add('plussBar', () => <PlussBar />, {
			chromatic: { delay: 500 },
		})
		.add('search', () => <Search />, {})
}
