/* eslint-disable react/state-in-constructor */
import React, { Component } from 'react'
import propTypes from 'prop-types'
import request from 'axios'
import BlinkLabrador from '@aller/blink-labrador' // eslint-disable-line no-unused-vars
import fetchXavierCookieValue from '../utils/fetch-xavier-cookie-value'

const defaultState = {
	requestSent: {
		contentAds: false,
		righLane: false,
		mostRead: false,
	},
	xavierarticles: [],
	mostRead: [],
	contentAds: [],
	columnLengths: {},
}

export const XavierContext = React.createContext(defaultState)

class XavierStore extends Component {
	state = defaultState

	setColumnLength = (len, counter) => {
		const { columnLengths } = this.state
		const updatedLengths = columnLengths

		updatedLengths[counter] = len
		this.setState({ columnLengths: updatedLengths })
	}

	updateAdCounter = () => {
		const { adCounter } = this.state
		this.setState({
			adCounter: adCounter + 1,
		})
	}

	fetchRightLane = async () => {
		const { requestSent, xavierarticles } = this.state
		if (!requestSent.rightLane || xavierarticles.length !== 0) {
			try {
				const updatedRequestSent = requestSent
				updatedRequestSent.rightLane = true
				this.setState({
					requestSent: updatedRequestSent,
				})
				const cookie = fetchXavierCookieValue()
				const response = await request.get(
					`https://sol.no/app/xavier-cerebro-api/api/v1/www.sol.no/users/${
						cookie ? cookie : ''
					}?pipeline=sol&offset=2`,
				)
				if (window && window.blinkLabrador) {
					window.blinkLabrador.trackArticleImpressions(
						'article.preview,article.preview-blink,.article-list>li',
					)
				}
				this.setState({ xavierarticles: response.data.response.items })
				return null
			} catch (error) {
				return error
			}
		}
		return null
	}

	fetchMostRead = async () => {
		const { requestSent, mostRead } = this.state
		if (!requestSent.mostRead || mostRead.length !== 0) {
			try {
				const updatedRequestSent = requestSent
				updatedRequestSent.mostRead = true
				this.setState({
					requestSent: updatedRequestSent,
				})

				// Xavier requires a fromDate and toDate formatted like so: fullyear-month-day:hour
				const toDate = new Date()
				const toDateObj = {
					year: toDate.getFullYear(),
					month: toDate.getMonth() + 1,
					day: toDate.getDate(),
					hour: toDate.getHours(),
					minute: toDate.getMinutes(),
				}

				Object.keys(toDateObj).forEach(key => {
					toDateObj[key] = toDateObj[key] < 10 ? `0${toDateObj[key]}` : toDateObj[key]
				})

				const toDateString = `${toDateObj.year}-${toDateObj.month}-${toDateObj.day}:${toDateObj.hour}`

				// Date 12 hours ago
				const fromDate = new Date(new Date().getTime() - 12 * 60 * 60 * 1000)
				const fromDateObj = {
					year: fromDate.getFullYear(),
					month: fromDate.getMonth() + 1,
					day: fromDate.getDate(),
					hour: fromDate.getHours(),
					minute: fromDate.getMinutes(),
				}

				Object.keys(fromDateObj).forEach(key => {
					fromDateObj[key] = fromDateObj[key] < 10 ? `0${fromDateObj[key]}` : fromDateObj[key]
				})

				const fromDateString = `${fromDateObj.year}-${fromDateObj.month}-${fromDateObj.day}:${fromDateObj.hour}`

				const response = await request.get(
					`https://sol.no/app/xavier-cerebro-api/api/v1/www.sol.no/users/?pipeline=performanceData&sort=clicks&fromDate=${fromDateString}&toDate=${toDateString}`, // eslint-disable-line max-len
				)

				const filteredResponse = []
				response.data.response.items.forEach(item => {
					if (filteredResponse.length < 6 && item.title && item.url) {
						filteredResponse.push(item)
					}
				})

				this.setState({ mostRead: filteredResponse })
				return null
			} catch (error) {
				return error
			}
		}
		return null
	}

	fetchXavierArticles = () => {
		this.fetchRightLane()
		this.fetchMostRead()
	}

	fetchContentAds = async () => {
		const { requestSent, contentAds } = this.state
		if (!requestSent.contentAds || contentAds.length !== 0) {
			try {
				const updatedRequestSent = requestSent
				updatedRequestSent.contentAds = true
				this.setState({
					requestSent: updatedRequestSent,
				})
				const cookie = fetchXavierCookieValue()
				const response = await request.get(
					`https://sol.no/app/xavier-cerebro-api/api/v1/www.sol.no/users/${
						cookie ? cookie : ''
					}?pipeline=contentMarketing`,
				)
				if (window && window.blinkLabrador) {
					window.blinkLabrador.trackArticleImpressions(
						'article.preview,article.preview-blink,.article-list>li',
					)
				}
				this.setState({ contentAds: response.data.response.items })
				return null
			} catch (error) {
				this.setState({ contentAds: undefined })
				return error
			}
		}
		return null
	}

	render() {
		const { children } = this.props
		const { xavierarticles, columnLengths, contentAds, mostRead } = this.state

		return (
			<XavierContext.Provider
				value={{
					fetchRightLane: this.fetchRightLane,
					fetchContentAds: this.fetchContentAds,
					setColumnLength: this.setColumnLength,
					fetchXavierArticles: this.fetchXavierArticles,
					columnLengths,
					updateAdCounter: this.updateAdCounter,
					xavierarticles,
					contentAds,
					mostRead,
				}}
			>
				{children}
			</XavierContext.Provider>
		)
	}
}
XavierStore.propTypes = {
	children: propTypes.node,
}
XavierStore.defaultProps = {
	children: null,
}

export default XavierStore
