/* eslint-disable react/state-in-constructor */
import React, { Component } from 'react'
import propTypes from 'prop-types'

const defaultState = {
	showSkyscraper: false,
	showModal: false,
}

export const AdsContext = React.createContext(defaultState)

class AdsStore extends Component {
	state = defaultState

	updateShowSkyscraper = () => {
		this.setState({
			showSkyscraper: true,
		})
	}

	closeModal = () => {
		this.setState({
			showModal: false,
		})
	}

	openModal = () => {
		this.setState({
			showModal: true,
		})
	}

	render() {
		const { children } = this.props
		const { showSkyscraper, showModal } = this.state

		return (
			<AdsContext.Provider
				value={{
					updateShowSkyscraper: this.updateShowSkyscraper,
					closeModal: this.closeModal,
					openModal: this.openModal,

					showModal,
					showSkyscraper,
				}}
			>
				{children}
			</AdsContext.Provider>
		)
	}
}
AdsStore.propTypes = {
	children: propTypes.node,
}
AdsStore.defaultProps = {
	children: null,
}

export default AdsStore
