import qs from 'query-string'
import { HarvesterSearchParams } from './index'

function unifyExcludePaywallValue(params: HarvesterSearchParams) {
	if (params.excludePaywall && params.excludePaywall !== 'false') {
		params.excludePaywall = 'true'
	}
}

function validateExcludeDupes(params: HarvesterSearchParams) {
	if (!params.excludeDupes) {
		return
	}

	const i = +params.excludeDupes

	if (!Number.isInteger(i) || i < 0 || i > 100) {
		delete params.excludeDupes
	}
}

export default function buildQueryString(params: HarvesterSearchParams) {
	unifyExcludePaywallValue(params)
	validateExcludeDupes(params)

	return `?${qs.stringify(params)}`
}
