import axios from 'axios'
import { getEnvValueForBrowser } from '../utils/functions'

/**
 * @param id {String} -- JW Video id
 * @param cookieToPass {string} cookie for JW API proxy
 * @param host {?string}
 * @param cache {?boolean} if info should go from cached endpoint
 * @returns {Promise<boolean>}
 */
async function getVideoInfo(id, host) {
	const jwproxyUrl = getEnvValueForBrowser('JWApiProxyEndpoint')

	let url = `${jwproxyUrl}/api/videos/${id}?simple=true`

	// for prod we use jwproxyUrl relative url
	// but axios requires absolute url for
	// server-to-server, so appending current host
	if (host && !url.startsWith('http')) {
		url = `${host}${url}`
	}

	try {
		let res = await axios(url)

		res = res.data
		return res.video
	} catch (e) {
		// eslint-disable-next-line no-console
		console.log('error while doing fetch to jw-api-proxy', e)
		throw e
	}
}

export default getVideoInfo
