/* eslint-disable no-console */
const path = require('path')
const fse = require('fs-extra') // eslint-disable-line import/no-extraneous-dependencies
const glob = require('glob') // eslint-disable-line import/no-extraneous-dependencies

const packagePath = process.cwd()
const srcPath = path.join(packagePath, './src')

/**
 * Puts a package.json into every immediate child directory of rootDir.
 * That package.json contains information about esm for bundlers so that imports
 * like import Typography from '@material-ui/core/Typography' are tree-shakeable.
 *
 * It also tests that an this import can be used in typescript by checking
 * if an index.d.ts is present at that path.
 *
 * @param {string} rootDir
 */
async function createModulePackages({ from, to }) {
	const directoryPackages = glob.sync('src/**/index.js', { cwd: from }).map(path.dirname)

	await Promise.all(
		directoryPackages.map(async directoryPackage => {
			const packageJson = {
				sideEffects: false,
				module: './index.js',
			}
			const packageJsonPath = path.join(to, directoryPackage, 'package.json')

			fse.writeFile(packageJsonPath, JSON.stringify(packageJson, null, 2))

			return packageJsonPath
		}),
	)
}

async function createPackageFile() {
	const packageData = await fse.readFile(path.resolve(packagePath, './package.json'), 'utf8')
	const { nyc, scripts, devDependencies, workspaces, ...packageDataOther } = JSON.parse(packageData) // eslint-disable-line no-unused-vars
	const newPackageData = {
		...packageDataOther,
		name: '@aller/components',
		private: true,
		main: './index.js',
		module: './index.js',
	}
	const targetPath = path.resolve(srcPath, './package.json')

	await fse.writeFile(targetPath, JSON.stringify(newPackageData, null, 2), 'utf8')
	console.log(`Created package.json in ${targetPath}`)

	return newPackageData
}

async function run() {
	try {
		const packageData = await createPackageFile() // eslint-disable-line no-unused-vars

		await createModulePackages({ from: srcPath, to: srcPath })
	} catch (err) {
		console.error(err)
		process.exit(1)
	}
}

run()
