import React, { useState, useEffect, createContext, useContext } from 'react'
import PropTypes from 'prop-types'

const UserContext = createContext({ name: null, user_id: null })

const parseDugStateCookie = cookieString => {
	if (!cookieString) {
		return null
	}
	switch (cookieString.charAt(0)) {
		case '{':
			return JSON.parse(cookieString)
		case 'e':
			return JSON.parse(atob(cookieString))
		case 'J':
			return JSON.parse(decodeURIComponent(atob(cookieString)))
		default:
			return null
	}
}
const getCookie = name => {
	const match = document.cookie.match(new RegExp(`(^| )${name}=([^;]+)`))
	if (match) return match[2]
	return null
}

const UserProvider = ({ children }) => {
	const [state, setState] = useState({ name: null, user_id: null })

	useEffect(() => {
		const dugStateCookie = getCookie('dug-state')

		if (dugStateCookie) {
			const user = parseDugStateCookie(dugStateCookie)
			if (user && user.name) {
				const name = user.name.replace('+', ' ')

				setState({ name, user_id: user.user_id })
			}
		}
	}, [])

	return <UserContext.Provider value={state}>{children}</UserContext.Provider>
}
UserProvider.propTypes = {
	children: PropTypes.node,
}
UserProvider.defaultProps = {
	children: null,
}

export const useUserProvider = () => useContext(UserContext)

export default UserProvider
