import React, { createContext, useContext, useState } from 'react'
import PropTypes from 'prop-types'

const IsMetarefreshContext = createContext(true)

const IsMetarefreshProvider = ({ children, initialState = false }) => {
	const [isMetarefresh] = useState(initialState)

	return (
		<IsMetarefreshContext.Provider value={isMetarefresh}>{children}</IsMetarefreshContext.Provider>
	)
}

IsMetarefreshProvider.propTypes = {
	initialState: PropTypes.bool,
	children: PropTypes.node.isRequired,
}

IsMetarefreshProvider.defaultProps = {
	initialState: false,
}

export const useIsMetarefresh = () => useContext(IsMetarefreshContext)

export default IsMetarefreshProvider
