import gql from 'graphql-tag';
import * as ApolloReactCommon from '@apollo/react-common';
import * as ApolloReactHooks from '@apollo/react-hooks';
export type Maybe<T> = T | null;
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string,
  String: string,
  Boolean: boolean,
  Int: number,
  Float: number,
  Time: any,
};

export type Article = {
   __typename?: 'Article',
  dataLabel: Scalars['String'],
  cerebroScore: Scalars['Float'],
  preset: Scalars['String'],
  url: Scalars['String'],
  cleanImage: Scalars['String'],
  isLabradorImage: Scalars['Boolean'],
  title: Scalars['String'],
  subtitle: Scalars['String'],
  secondaryTitle: Scalars['String'],
  sectionTag: Scalars['String'],
  backgroundColor: Scalars['String'],
  harvesterID: Scalars['String'],
  imageData?: Maybe<Image>,
  fromFront: Scalars['Boolean'],
  debug?: Maybe<Debug>,
};

export type Campaign = {
   __typename?: 'Campaign',
  cerebroScore: Scalars['Float'],
  harvesterID: Scalars['String'],
  backgroundColor?: Maybe<Scalars['String']>,
  fontColor: Scalars['String'],
  title: Scalars['String'],
  url: Scalars['String'],
};

export type ContentMarketing = {
   __typename?: 'ContentMarketing',
  cerebroScore: Scalars['Float'],
  preset: Scalars['String'],
  url: Scalars['String'],
  cleanImage: Scalars['String'],
  isLabradorImage: Scalars['Boolean'],
  title: Scalars['String'],
  secondaryTitle: Scalars['String'],
  commercialPartner: Scalars['String'],
  logoURL: Scalars['String'],
  serveAd: Scalars['Boolean'],
  harvesterID: Scalars['String'],
};

export type ContentPicking = Article | Video;

export enum ContentType {
  Free = 'free',
  Video = 'video',
  Pluss = 'pluss'
}

export type Debug = {
   __typename?: 'Debug',
  read: Scalars['Boolean'],
  ageScore: Scalars['Float'],
  cFScore: Scalars['Float'],
  iFScore: Scalars['Float'],
  impScore: Scalars['Float'],
  salesScore: Scalars['Float'],
  popularityScore: Scalars['Float'],
  cTAScore: Scalars['Float'],
};

export type Epages = {
   __typename?: 'Epages',
  latest?: Maybe<Array<Maybe<Epages_Paper>>>,
  issue?: Maybe<Array<Epages_Paper>>,
  search?: Maybe<Epages_Search>,
};


export type EpagesLatestArgs = {
  catalog?: Maybe<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};


export type EpagesIssueArgs = {
  catalog?: Maybe<Scalars['String']>,
  from: Scalars['String'],
  to: Scalars['String']
};


export type EpagesSearchArgs = {
  query: Scalars['String'],
  catalog?: Maybe<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>,
  from?: Maybe<Scalars['String']>,
  to?: Maybe<Scalars['String']>
};

export type Epages_Paper = {
   __typename?: 'Epages_Paper',
  title: Scalars['String'],
  date: Scalars['String'],
  expires: Scalars['String'],
  catalog: Scalars['Int'],
  foldername: Scalars['String'],
  folder: Scalars['Int'],
  pages: Scalars['Int'],
  sectionstarts: Scalars['String'],
  sectioncount: Scalars['Int'],
  thumb: Scalars['String'],
  thumb_medium: Scalars['String'],
  type: Scalars['String'],
};

export type Epages_Search = {
   __typename?: 'Epages_Search',
  total: Scalars['Int'],
  results: Array<Epages_SearchResults>,
};

export type Epages_SearchResults = {
   __typename?: 'Epages_SearchResults',
  title: Scalars['String'],
  page: Scalars['Int'],
  date: Scalars['String'],
  snippet: Scalars['String'],
  thumb: Scalars['String'],
  catalog: Scalars['Int'],
};

export type Harvester = {
   __typename?: 'Harvester',
  search?: Maybe<Array<Maybe<Harvester_Article>>>,
};


export type HarvesterSearchArgs = {
  q?: Maybe<Scalars['String']>,
  all_tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  any_tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  exclude_tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  tags_field?: Maybe<Array<Maybe<Scalars['String']>>>,
  include_hosts?: Maybe<Array<Maybe<Scalars['String']>>>,
  exclude_hosts?: Maybe<Array<Maybe<Scalars['String']>>>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};

export type Harvester_Article = {
   __typename?: 'Harvester_Article',
  title?: Maybe<Scalars['String']>,
  url?: Maybe<Scalars['String']>,
  host?: Maybe<Scalars['String']>,
  externalId?: Maybe<Scalars['String']>,
  paywall?: Maybe<Scalars['Int']>,
  posted?: Maybe<Scalars['String']>,
  fields?: Maybe<HarvesterFields>,
};

export type HarvesterData = {
   __typename?: 'HarvesterData',
  id: Scalars['String'],
  publishedDate: Scalars['String'],
};

export type HarvesterFields = {
   __typename?: 'HarvesterFields',
  image?: Maybe<Scalars['String']>,
  description?: Maybe<Scalars['String']>,
  canonical_url?: Maybe<Scalars['String']>,
  og_url?: Maybe<Scalars['String']>,
  secondary_data?: Maybe<HarvesterSecondaryData>,
};

export type HarvesterReadingStats = {
   __typename?: 'HarvesterReadingStats',
  readingTime?: Maybe<Scalars['String']>,
};

export type HarvesterSecondaryData = {
   __typename?: 'HarvesterSecondaryData',
  article_tags?: Maybe<HarvesterTagFields>,
  reading_stats?: Maybe<HarvesterReadingStats>,
};

export type HarvesterTagFields = {
   __typename?: 'HarvesterTagFields',
  harvesterTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  jrocTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  labelmakerTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  unfuffTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  unfluffKeywords?: Maybe<Array<Maybe<Scalars['String']>>>,
  urlTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  labradorTags?: Maybe<Array<Maybe<Scalars['String']>>>,
};

export type Image = {
   __typename?: 'Image',
  x: Scalars['Float'],
  y: Scalars['Float'],
  cropW: Scalars['Float'],
  cropH: Scalars['Float'],
  wHRatio: Scalars['Float'],
};

export type JwPlayer = {
   __typename?: 'JWPlayer',
  video?: Maybe<JwPlayer_VideoResponse>,
  videos?: Maybe<Array<Maybe<JwPlayer_Video>>>,
  listByDate?: Maybe<Array<Maybe<JwPlayer_Video>>>,
  latest?: Maybe<Array<Maybe<JwPlayer_Video>>>,
  playlist?: Maybe<JwPlayer_PlaylistResponse>,
  playlists?: Maybe<Array<Maybe<JwPlayer_PlaylistResponse>>>,
  related?: Maybe<JwPlayer_PlaylistResponse>,
  promoted?: Maybe<Array<Maybe<JwPlayer_Video>>>,
  channels?: Maybe<Array<Maybe<JwPlayer_Channel>>>,
};


export type JwPlayerVideoArgs = {
  id: Scalars['String'],
  related?: Maybe<Scalars['Boolean']>,
  videoProperty?: Maybe<VideoProperty>
};


export type JwPlayerVideosArgs = {
  ids: Array<Scalars['String']>,
  videoProperty?: Maybe<VideoProperty>
};


export type JwPlayerListByDateArgs = {
  startDate: Scalars['Int'],
  endDate: Scalars['Int'],
  limit?: Maybe<Scalars['Int']>,
  channel: Website
};


export type JwPlayerLatestArgs = {
  channelID: Scalars['String'],
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};


export type JwPlayerPlaylistArgs = {
  id: Scalars['String'],
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};


export type JwPlayerPlaylistsArgs = {
  ids: Array<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>
};


export type JwPlayerRelatedArgs = {
  mediaID: Scalars['String'],
  feedID: Scalars['String'],
  limit?: Maybe<Scalars['Int']>
};


export type JwPlayerPromotedArgs = {
  mediaID: Scalars['String'],
  feedID: Scalars['String'],
  videoProperty?: Maybe<VideoProperty>
};


export type JwPlayerChannelsArgs = {
  search?: Maybe<Scalars['String']>,
  videoProperty?: Maybe<VideoProperty>
};

export type JwPlayer_Channel = {
   __typename?: 'JWPlayer_Channel',
  id: Scalars['String'],
  title: Scalars['String'],
  custom?: Maybe<JwPlayer_Channel_Custom>,
};

export type JwPlayer_Channel_Custom = {
   __typename?: 'JWPlayer_Channel_Custom',
  showname?: Maybe<Scalars['String']>,
  icon?: Maybe<Scalars['String']>,
};

export type JwPlayer_MarketingClient = {
   __typename?: 'JWPlayer_MarketingClient',
  playlistId: Scalars['String'],
  name?: Maybe<Scalars['String']>,
  icon?: Maybe<Scalars['String']>,
};

export type JwPlayer_PlaylistMeta = {
   __typename?: 'JWPlayer_PlaylistMeta',
  image: JwPlayer_VideoImage,
  id: Scalars['String'],
  publishedAt: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  count: Scalars['Int'],
};

export type JwPlayer_PlaylistResponse = {
   __typename?: 'JWPlayer_PlaylistResponse',
  data?: Maybe<Array<JwPlayer_Video>>,
  meta: JwPlayer_PlaylistMeta,
};

export type JwPlayer_Show = {
   __typename?: 'JWPlayer_Show',
  id: Scalars['String'],
  name?: Maybe<Scalars['String']>,
  icon?: Maybe<Scalars['String']>,
  color?: Maybe<Scalars['String']>,
  textColor?: Maybe<Scalars['String']>,
};

export type JwPlayer_Video = {
   __typename?: 'JWPlayer_Video',
  id: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  tags?: Maybe<Array<Scalars['String']>>,
  image: JwPlayer_VideoImage,
  originalSlug: Scalars['String'],
  categoryID: Scalars['String'],
  publishedAt: Scalars['String'],
  updatedAt: Scalars['String'],
  live: Scalars['Boolean'],
  own: Scalars['Boolean'],
  channelID: Scalars['String'],
  channelTitle: Scalars['String'],
  duration: Scalars['Float'],
  slug: Scalars['String'],
  harvesterData?: Maybe<HarvesterData>,
  custom: Scalars['String'],
  show?: Maybe<JwPlayer_Show>,
  marketingClient?: Maybe<JwPlayer_MarketingClient>,
};

export type JwPlayer_VideoImage = {
   __typename?: 'JWPlayer_VideoImage',
  low: Scalars['String'],
  medium: Scalars['String'],
  high: Scalars['String'],
  placeholder: Scalars['String'],
};

export type JwPlayer_VideoResponse = {
   __typename?: 'JWPlayer_VideoResponse',
  data?: Maybe<JwPlayer_Video>,
  relatedVideos: Array<Maybe<JwPlayer_Video>>,
};

export type Labrador = {
   __typename?: 'Labrador',
  front?: Maybe<Labrador_Front>,
  articles?: Maybe<Array<Maybe<Labrador_ArticlePreview>>>,
  fragments?: Maybe<Array<Maybe<Labrador_Child>>>,
  htmlFragment?: Maybe<Labrador_HtmlFragment>,
  htmlFragments?: Maybe<Array<Maybe<Labrador_HtmlFragment>>>,
  article?: Maybe<Labrador_Article>,
};


export type LabradorFrontArgs = {
  id?: Maybe<Scalars['Int']>,
  path?: Maybe<Scalars['String']>,
  siteId?: Maybe<Scalars['Int']>
};


export type LabradorArticlesArgs = {
  tags?: Maybe<Array<Scalars['String']>>,
  tagsExclude?: Maybe<Array<Scalars['String']>>,
  ids?: Maybe<Array<Scalars['String']>>,
  or?: Maybe<Scalars['Boolean']>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>,
  orderby?: Maybe<Scalars['String']>,
  siteId?: Maybe<Scalars['Int']>,
  published_from?: Maybe<Scalars['String']>,
  published_to?: Maybe<Scalars['String']>,
  html?: Maybe<Scalars['Boolean']>,
  order?: Maybe<Scalars['String']>,
  public?: Maybe<Scalars['Boolean']>,
  rawQuery?: Maybe<Scalars['String']>
};


export type LabradorFragmentsArgs = {
  offset?: Maybe<Scalars['Int']>,
  limit?: Maybe<Scalars['Int']>,
  pageId: Scalars['Int'],
  structureType: Scalars['String'],
  dropZone?: Maybe<Scalars['String']>
};


export type LabradorHtmlFragmentArgs = {
  offset?: Maybe<Scalars['Int']>,
  pageId: Scalars['Int'],
  structureType: Scalars['String'],
  allCssGridClasses?: Maybe<Scalars['Boolean']>,
  device: Labrador_Device,
  useVarnishedProxy?: Maybe<Scalars['Boolean']>
};


export type LabradorHtmlFragmentsArgs = {
  offset?: Maybe<Scalars['Int']>,
  pageId: Scalars['Int'],
  structureType: Scalars['String'],
  allCssGridClasses?: Maybe<Scalars['Boolean']>,
  device: Labrador_Device,
  removeEmptyESIs?: Maybe<Scalars['Boolean']>
};


export type LabradorArticleArgs = {
  id?: Maybe<Scalars['Int']>,
  path?: Maybe<Scalars['String']>,
  siteId?: Maybe<Scalars['Int']>
};

export type Labrador_Ad = {
   __typename?: 'Labrador_Ad',
  elementId: Scalars['String'],
  width: Scalars['Float'],
  metadata?: Maybe<Labrador_Metadata>,
};

export type Labrador_Article = {
   __typename?: 'Labrador_Article',
  id: Scalars['Int'],
  title: Scalars['String'],
  intro: Scalars['String'],
  byline: Array<Labrador_Byline>,
  publishedURL: Scalars['String'],
  publishedAt: Scalars['String'],
  modifiedAt: Scalars['String'],
  sectionTag: Scalars['String'],
  teaserTitle?: Maybe<Scalars['String']>,
  imageId: Scalars['Int'],
  subtitle: Scalars['String'],
  tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  contentboxes?: Maybe<Array<Labrador_Child>>,
  siteDomain: Scalars['String'],
  bodytext: Scalars['String'],
  bodytextHTML: Scalars['String'],
  bodytextStructured?: Maybe<Array<Labrador_Content>>,
  hideAds: Scalars['Boolean'],
  isContentMarketing: Scalars['Boolean'],
  product: Scalars['String'],
  customArticleClass: Scalars['String'],
  top?: Maybe<Labrador_Child>,
};

export type Labrador_ArticlePreview = {
   __typename?: 'Labrador_ArticlePreview',
  id: Scalars['Int'],
  title: Scalars['String'],
  structuredTitle?: Maybe<Labrador_HtmlElement>,
  tags: Array<Scalars['String']>,
  subtitle: Scalars['String'],
  sectionTag: Scalars['String'],
  publishedURL: Scalars['String'],
  publishedFullURL: Scalars['String'],
  published: Scalars['String'],
  imageURL: Scalars['String'],
  bylines: Array<Labrador_Byline>,
  contentMarketing: Scalars['Boolean'],
  contentMarketingPublisher: Scalars['String'],
  commercialPartner: Scalars['String'],
  logoURL: Scalars['String'],
  width: Scalars['Float'],
  subscription: Scalars['Boolean'],
  product: Array<Scalars['String']>,
  textOverlayBackground?: Maybe<Scalars['String']>,
  teaserTitle?: Maybe<Scalars['String']>,
  teaserSubtitle?: Maybe<Scalars['String']>,
  teaserSecondaryTitle?: Maybe<Scalars['String']>,
  image: Labrador_Image,
  metadata?: Maybe<Labrador_Metadata>,
  siteId: Scalars['Int'],
  bodytext: Scalars['String'],
  bodytextHTML: Scalars['String'],
  bodytextIndex: Scalars['Int'],
  float: Labrador_Float,
  visibilityStatus: Scalars['String'],
  secondaryTitle: Scalars['String'],
  displayRequirements: Labrador_DisplayRequirements,
  harvesterData?: Maybe<HarvesterData>,
  label: Scalars['String'],
  reviewScore: Scalars['Int'],
  teaserReviewScore: Scalars['Int'],
  abVersions: Array<Labrador_ArticlePreview>,
};


export type Labrador_ArticlePreviewAbVersionsArgs = {
  siteId?: Maybe<Scalars['Int']>,
  limit?: Maybe<Scalars['Int']>,
  reverseOrder?: Maybe<Scalars['Boolean']>
};

export type Labrador_AutoArticlePlaceholder = {
   __typename?: 'Labrador_AutoArticlePlaceholder',
  feedId?: Maybe<Scalars['String']>,
  width: Scalars['Float'],
  imageAspectRatio: Scalars['Float'],
  textOverlayBackground?: Maybe<Scalars['String']>,
  label: Scalars['String'],
};

export type Labrador_BoxBackground = {
   __typename?: 'Labrador_BoxBackground',
  desktop: Scalars['String'],
};

export type Labrador_Byline = {
   __typename?: 'Labrador_Byline',
  firstName: Scalars['String'],
  lastName: Scalars['String'],
  email: Scalars['String'],
  publicEmail: Scalars['String'],
  bio: Scalars['String'],
  imageURL?: Maybe<Scalars['String']>,
};

export type Labrador_Child = Labrador_ArticlePreview | Labrador_Column | Labrador_Ad | Labrador_AutoArticlePlaceholder | Labrador_PersonalizedArticlePlaceholder | Labrador_FrontRows | Labrador_ContentMarketing | Labrador_Row | Labrador_Markup | Labrador_CustomElement | Labrador_JwVideo | Labrador_WolverineAd | Labrador_PersonalizedCampaign | Labrador_Image | Labrador_Instagram;

export type Labrador_Column = {
   __typename?: 'Labrador_Column',
  id: Scalars['String'],
  width: Scalars['Float'],
  children?: Maybe<Array<Labrador_Child>>,
};

export type Labrador_Content = Labrador_HtmlElement | Labrador_Text;

export type Labrador_ContentMarketing = {
   __typename?: 'Labrador_ContentMarketing',
  site?: Maybe<Scalars['String']>,
  index: Scalars['Int'],
  width: Scalars['Float'],
};

export type Labrador_CustomElement = {
   __typename?: 'Labrador_CustomElement',
  elementType: Scalars['String'],
};

export enum Labrador_Device {
  Mobile = 'mobile',
  Tablet = 'tablet',
  Desktop = 'desktop',
  Amp = 'amp'
}

export type Labrador_DisplayRequirements = {
   __typename?: 'Labrador_DisplayRequirements',
  type: Scalars['String'],
  amount: Scalars['Int'],
  startDate: Scalars['String'],
  endDate: Scalars['String'],
  interval: Scalars['String'],
  location: Scalars['String'],
  city: Array<Scalars['String']>,
  county: Array<Scalars['String']>,
  order: Scalars['String'],
  paused: Scalars['Boolean'],
  titles: Array<Scalars['String']>,
  overrideMode: Scalars['String'],
  platform: Scalars['String'],
};

export type Labrador_Float = {
   __typename?: 'Labrador_Float',
  desktop: Scalars['String'],
};

export type Labrador_Front = {
   __typename?: 'Labrador_Front',
  id: Scalars['Int'],
  siteId: Scalars['Int'],
  layoutId: Scalars['Int'],
  hostPath: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  name: Scalars['String'],
  noIndex: Scalars['Boolean'],
  noFollow: Scalars['Boolean'],
  publishedURL: Scalars['String'],
  published: Scalars['String'],
  userName: Scalars['String'],
  userEmail: Scalars['String'],
  updated: Scalars['String'],
  automatic: Scalars['Boolean'],
  visibility?: Maybe<Scalars['String']>,
  tags?: Maybe<Array<Scalars['String']>>,
  tagsExclude?: Maybe<Array<Scalars['String']>>,
  rows?: Maybe<Array<Maybe<Labrador_Row>>>,
};


export type Labrador_FrontRowsArgs = {
  dropzone?: Maybe<Scalars['String']>,
  offset?: Maybe<Scalars['Int']>,
  limit?: Maybe<Scalars['Int']>
};

export type Labrador_FrontRows = {
   __typename?: 'Labrador_FrontRows',
  start: Scalars['Int'],
  count: Scalars['Int'],
  type: Scalars['String'],
  pageId: Scalars['Int'],
};

export type Labrador_HtmlElement = {
   __typename?: 'Labrador_HTMLElement',
  name: Scalars['String'],
  attributes?: Maybe<Array<Labrador_KeyValue>>,
  children?: Maybe<Array<Labrador_Content>>,
};

export type Labrador_HtmlFragment = {
   __typename?: 'Labrador_HTMLFragment',
  HTML: Scalars['String'],
  structuredContent?: Maybe<Array<Labrador_Content>>,
};

export type Labrador_Image = {
   __typename?: 'Labrador_Image',
  type: Scalars['String'],
  id: Scalars['Int'],
  y: Scalars['Float'],
  x: Scalars['Float'],
  heightY: Scalars['Float'],
  heightX: Scalars['Float'],
  heightW: Scalars['Float'],
  heightH: Scalars['Float'],
  float: Scalars['String'],
  cropW: Scalars['Float'],
  cropH: Scalars['Float'],
  bbRatio: Scalars['Float'],
  whRatio: Scalars['Float'],
  url: Scalars['String'],
  ratio: Scalars['Float'],
  width: Scalars['Int'],
  height: Scalars['Int'],
  bodytextIndex: Scalars['Int'],
};

export type Labrador_Instagram = {
   __typename?: 'Labrador_Instagram',
  url: Scalars['String'],
  bodytextIndex: Scalars['Int'],
};

export type Labrador_JwVideo = {
   __typename?: 'Labrador_JWVideo',
  videoID: Scalars['String'],
  title: Scalars['String'],
  playerID: Scalars['String'],
  imageURL: Scalars['String'],
  width: Scalars['Float'],
  bodytextIndex: Scalars['Int'],
};

export type Labrador_KeyValue = {
   __typename?: 'Labrador_KeyValue',
  key?: Maybe<Scalars['String']>,
  value?: Maybe<Scalars['String']>,
};

export type Labrador_Markup = {
   __typename?: 'Labrador_Markup',
  Markup?: Maybe<Scalars['String']>,
  Width?: Maybe<Scalars['Float']>,
  bodytextIndex: Scalars['Int'],
};

export type Labrador_Metadata = {
   __typename?: 'Labrador_Metadata',
  width?: Maybe<Labrador_MetadataWidth>,
  isMeninger: Scalars['Boolean'],
  isRecommended: Scalars['Boolean'],
  hideImage: Scalars['Boolean'],
  showSubtitle: Scalars['Boolean'],
  boxBackground?: Maybe<Labrador_BoxBackground>,
  showHeroPreview: Scalars['Boolean'],
};

export type Labrador_MetadataWidth = {
   __typename?: 'Labrador_MetadataWidth',
  desktop: Scalars['Int'],
  tablet: Scalars['Int'],
  mobile: Scalars['Int'],
};

export type Labrador_PersonalizedArticlePlaceholder = {
   __typename?: 'Labrador_PersonalizedArticlePlaceholder',
  number: Scalars['Int'],
  width: Scalars['Float'],
  tags: Scalars['String'],
  preset: Scalars['String'],
  append: Scalars['String'],
  template: Scalars['String'],
};

export type Labrador_PersonalizedCampaign = {
   __typename?: 'Labrador_PersonalizedCampaign',
  targetedTag: Scalars['String'],
  startDate?: Maybe<Scalars['Time']>,
  endDate?: Maybe<Scalars['Time']>,
  backgroundColor: Scalars['String'],
  fontColor: Scalars['String'],
  title: Scalars['String'],
  url: Scalars['String'],
  name: Scalars['String'],
  platform: Scalars['String'],
  format: Scalars['String'],
  image: Labrador_Image,
};

export type Labrador_Row = {
   __typename?: 'Labrador_Row',
  id: Scalars['String'],
  width: Scalars['Float'],
  viewportVisibility?: Maybe<Scalars['String']>,
  children?: Maybe<Array<Labrador_Child>>,
  metadata?: Maybe<Labrador_Metadata>,
  bodytextIndex: Scalars['Int'],
};

export type Labrador_Text = {
   __typename?: 'Labrador_Text',
  text?: Maybe<Scalars['String']>,
};

export type Labrador_WolverineAd = {
   __typename?: 'Labrador_WolverineAd',
  type: Scalars['String'],
};

export type Mat = {
   __typename?: 'Mat',
  recipe?: Maybe<Mat_Recipe>,
  recipeSearch?: Maybe<Mat_PaginatedResponse>,
  front?: Maybe<Mat_Front>,
  ingredient?: Maybe<Mat_SingleIngredient>,
  ingredients?: Maybe<Mat_PaginatedResponse>,
  popular?: Maybe<Array<Maybe<Mat_RecipePreview>>>,
};


export type MatRecipeArgs = {
  slug: Scalars['String']
};


export type MatRecipeSearchArgs = {
  tagSlugs?: Maybe<Array<Scalars['String']>>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};


export type MatFrontArgs = {
  limit?: Maybe<Scalars['Int']>
};


export type MatIngredientArgs = {
  slug: Scalars['String']
};


export type MatIngredientsArgs = {
  tags?: Maybe<Array<Scalars['String']>>,
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};

export type Mat_Allergy = {
   __typename?: 'Mat_Allergy',
  slug: Scalars['String'],
  title: Scalars['String'],
};

export type Mat_ArticlePreview = {
   __typename?: 'Mat_ArticlePreview',
  slug: Scalars['String'],
  title: Scalars['String'],
  image: Scalars['String'],
  url: Scalars['String'],
};

export type Mat_Author = {
   __typename?: 'Mat_Author',
  email: Scalars['String'],
  name: Scalars['String'],
  profileImage?: Maybe<Mat_Image>,
};

export type Mat_Category = {
   __typename?: 'Mat_Category',
  title: Scalars['String'],
  url: Scalars['String'],
};

export type Mat_Front = {
   __typename?: 'Mat_Front',
  latestArticles?: Maybe<Array<Mat_ArticlePreview>>,
  latestRecipes?: Maybe<Array<Mat_RecipePreview>>,
};

export type Mat_Image = {
   __typename?: 'Mat_Image',
  seoFilename: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  smallLandscape: Scalars['String'],
  mediumLandscape: Scalars['String'],
  largeLandscape: Scalars['String'],
  xlargeLandscape: Scalars['String'],
  smallPortrait: Scalars['String'],
  mediumPortrait: Scalars['String'],
  largePortrait: Scalars['String'],
  smallProfile: Scalars['String'],
  mediumProfile: Scalars['String'],
  largeProfile: Scalars['String'],
  byline: Scalars['String'],
};

export type Mat_IngredientPreview = {
   __typename?: 'Mat_IngredientPreview',
  ID: Scalars['Int'],
  slug: Scalars['String'],
  title: Scalars['String'],
  image: Scalars['String'],
  imagePlaceholder: Scalars['String'],
  lazyImageSources: Array<Mat_LazyImageSource>,
};

export type Mat_LazyImageSource = {
   __typename?: 'Mat_LazyImageSource',
  source: Scalars['String'],
  media: Scalars['String'],
};

export type Mat_PaginatedResponse = {
   __typename?: 'Mat_PaginatedResponse',
  total: Scalars['Int'],
  hasMore: Scalars['Boolean'],
  result?: Maybe<Array<Mat_PaginatedResponseResult>>,
};

export type Mat_PaginatedResponseResult = Mat_RecipePreview | Mat_IngredientPreview;

export type Mat_Preference = {
   __typename?: 'Mat_Preference',
  slug: Scalars['String'],
  title: Scalars['String'],
};

export type Mat_Recipe = {
   __typename?: 'Mat_Recipe',
  id: Scalars['Int'],
  views: Scalars['Int'],
  title: Scalars['String'],
  slug?: Maybe<Scalars['String']>,
  descriptionShort: Scalars['String'],
  description: Scalars['String'],
  timeTotal: Scalars['Int'],
  timeCooking: Scalars['Int'],
  difficulty?: Maybe<Scalars['Int']>,
  servings?: Maybe<Scalars['Int']>,
  rating: Scalars['Float'],
  numVotes: Scalars['Int'],
  categories?: Maybe<Array<Mat_Category>>,
  images?: Maybe<Array<Maybe<Mat_Image>>>,
  authors?: Maybe<Array<Mat_Author>>,
  steps?: Maybe<Array<Mat_Step>>,
  parts: Array<Mat_RecipePart>,
  tags?: Maybe<Array<Maybe<Mat_Tag>>>,
  preferences: Array<Mat_Preference>,
  allergies?: Maybe<Array<Maybe<Mat_Allergy>>>,
  relatedRecipes?: Maybe<Mat_PaginatedResponse>,
};


export type Mat_RecipeRelatedRecipesArgs = {
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};

export type Mat_RecipeIngredient = {
   __typename?: 'Mat_RecipeIngredient',
  slug: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  amount: Scalars['Float'],
  type: Scalars['String'],
  variant?: Maybe<Scalars['String']>,
};

export type Mat_RecipePart = {
   __typename?: 'Mat_RecipePart',
  title: Scalars['String'],
  ingredients?: Maybe<Array<Mat_RecipeIngredient>>,
};

export type Mat_RecipePreview = {
   __typename?: 'Mat_RecipePreview',
  id: Scalars['Int'],
  slug: Scalars['String'],
  title: Scalars['String'],
  images?: Maybe<Array<Mat_Image>>,
  image: Scalars['String'],
  imagePlaceholder: Scalars['String'],
  lazyImageSources: Array<Mat_LazyImageSource>,
  difficulty: Scalars['Int'],
  timeCooking: Scalars['Int'],
  timeTotal: Scalars['Int'],
};

export type Mat_SingleIngredient = {
   __typename?: 'Mat_SingleIngredient',
  ID: Scalars['Int'],
  slug: Scalars['String'],
  title: Scalars['String'],
  description: Scalars['String'],
  descriptionShort: Scalars['String'],
  storage: Scalars['String'],
  lifetime?: Maybe<Scalars['String']>,
  origin: Scalars['String'],
  calories: Scalars['Float'],
  images?: Maybe<Array<Mat_Image>>,
  fat: Scalars['Float'],
  carbohydrates: Scalars['Float'],
  protein: Scalars['Float'],
  seasons?: Maybe<Scalars['String']>,
  relatedRecipes?: Maybe<Array<Mat_RecipePreview>>,
};


export type Mat_SingleIngredientRelatedRecipesArgs = {
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>
};

export type Mat_Step = {
   __typename?: 'Mat_Step',
  videoId?: Maybe<Scalars['String']>,
  description: Scalars['String'],
  sortOrder: Scalars['Int'],
  images?: Maybe<Array<Maybe<Mat_Image>>>,
};

export type Mat_Tag = {
   __typename?: 'Mat_Tag',
  title: Scalars['String'],
  url: Scalars['String'],
  slug: Scalars['String'],
  labradorSlug: Scalars['String'],
};

export type Offers = {
   __typename?: 'Offers',
  campaigns: Array<Maybe<Campaign>>,
};


export type OffersCampaignsArgs = {
  limit?: Maybe<Scalars['Int']>
};

export type Player = {
   __typename?: 'Player',
  video?: Maybe<Player_Video>,
  latest?: Maybe<Player_LatestResponse>,
  playlist?: Maybe<Player_LatestResponse>,
};


export type PlayerVideoArgs = {
  videoId: Scalars['String'],
  withRelated?: Maybe<Scalars['Boolean']>
};


export type PlayerLatestArgs = {
  channel: Scalars['String'],
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>,
  pageToken?: Maybe<Scalars['String']>,
  query?: Maybe<Array<Scalars['String']>>
};


export type PlayerPlaylistArgs = {
  id: Scalars['String'],
  limit?: Maybe<Scalars['Int']>,
  pageToken?: Maybe<Scalars['String']>
};

export type Player_LatestResponse = {
   __typename?: 'Player_LatestResponse',
  meta: Player_Meta,
  videos: Array<Maybe<Player_Video>>,
};

export type Player_Meta = {
   __typename?: 'Player_Meta',
  pageToken?: Maybe<Scalars['String']>,
  count: Scalars['Int'],
  total: Scalars['Int'],
};

export type Player_RelatedVideo = {
   __typename?: 'Player_RelatedVideo',
  id: Scalars['String'],
  title: Scalars['String'],
  image: Player_VideoImage,
  publishedAt: Scalars['String'],
  channelTitle: Scalars['String'],
  description: Scalars['String'],
};

export type Player_Video = {
   __typename?: 'Player_Video',
  id: Scalars['String'],
  title: Scalars['String'],
  tags?: Maybe<Array<Scalars['String']>>,
  description: Scalars['String'],
  channelID: Scalars['String'],
  channelTitle: Scalars['String'],
  live: Scalars['Boolean'],
  publishedAt: Scalars['String'],
  videoPublishedAt: Scalars['String'],
  image: Player_VideoImage,
  relatedVideos?: Maybe<Array<Maybe<Player_RelatedVideo>>>,
  harvesterData?: Maybe<HarvesterData>,
};

export type Player_VideoImage = {
   __typename?: 'Player_VideoImage',
  default: Scalars['String'],
  sDDefault: Scalars['String'],
  mqdefault: Scalars['String'],
  hqdefault: Scalars['String'],
  maxResDefault: Scalars['String'],
};

export type Query = {
   __typename?: 'Query',
  labrador?: Maybe<Labrador>,
  mat?: Maybe<Mat>,
  player?: Maybe<Player>,
  wolverine_ads?: Maybe<WolverineAds>,
  jwplayer?: Maybe<JwPlayer>,
  harvester?: Maybe<Harvester>,
  epages?: Maybe<Epages>,
  recommendations?: Maybe<Recommendations>,
  offers?: Maybe<Offers>,
};

export type Recommendations = {
   __typename?: 'Recommendations',
  articles?: Maybe<Array<Maybe<Article>>>,
  videos?: Maybe<Array<Maybe<Video>>>,
  contentMarketing?: Maybe<Array<Maybe<ContentMarketing>>>,
  contentPicking?: Maybe<Array<Maybe<ContentPicking>>>,
  sol?: Maybe<Array<Maybe<Article>>>,
};


export type RecommendationsArticlesArgs = {
  frontID?: Maybe<Scalars['String']>,
  checkFront?: Maybe<Scalars['Boolean']>,
  domain?: Maybe<Scalars['String']>,
  preset?: Maybe<Scalars['String']>,
  excludeIDs?: Maybe<Array<Maybe<Scalars['String']>>>,
  excludeTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  maxID?: Maybe<Scalars['Int']>,
  limit?: Maybe<Scalars['Int']>
};


export type RecommendationsVideosArgs = {
  frontID?: Maybe<Scalars['String']>,
  playslistID?: Maybe<Scalars['String']>,
  checkFront?: Maybe<Scalars['Boolean']>,
  domain?: Maybe<Scalars['String']>,
  preset?: Maybe<Scalars['String']>,
  excludeIDs?: Maybe<Array<Maybe<Scalars['String']>>>,
  tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  limit?: Maybe<Scalars['Int']>
};


export type RecommendationsContentMarketingArgs = {
  domain?: Maybe<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>,
  removeAds?: Maybe<Scalars['Boolean']>
};


export type RecommendationsContentPickingArgs = {
  domain?: Maybe<Scalars['String']>,
  contentTypes: Array<ContentType>,
  checkFront?: Maybe<Scalars['Boolean']>,
  limit?: Maybe<Scalars['Int']>
};


export type RecommendationsSolArgs = {
  domain?: Maybe<Scalars['String']>,
  frontID?: Maybe<Scalars['String']>,
  preset?: Maybe<Scalars['String']>,
  excludeIDs?: Maybe<Array<Maybe<Scalars['String']>>>,
  limit?: Maybe<Scalars['Int']>
};


export type Video = {
   __typename?: 'Video',
  dataLabel: Scalars['String'],
  cerebroScore: Scalars['Float'],
  preset: Scalars['String'],
  url: Scalars['String'],
  cleanImage: Scalars['String'],
  isLabradorImage: Scalars['Boolean'],
  title: Scalars['String'],
  subtitle: Scalars['String'],
  secondaryTitle: Scalars['String'],
  harvesterID: Scalars['String'],
};

export enum VideoProperty {
  Dagbladet = 'Dagbladet',
  Dinside = 'Dinside',
  Kk = 'KK',
  Seher = 'Seher',
  Sol = 'Sol',
  Topp = 'Topp',
  Se = 'Se',
  Lommelegen = 'Lommelegen',
  Vi = 'Vi',
  Oppskrift = 'Oppskrift',
  Medialaben = 'Medialaben',
  Stoekk = 'Stoekk',
  Kode = 'Kode',
  Elbil24 = 'Elbil24',
  PlussDagbladet = 'PlussDagbladet',
  Aller = 'Aller'
}

export enum Website {
  Dagbladet = 'Dagbladet',
  Dinside = 'Dinside',
  Kk = 'KK',
  Seher = 'Seher',
  Sol = 'Sol',
  Topp = 'Topp',
  Se = 'Se',
  Lommelegen = 'Lommelegen',
  Vi = 'Vi',
  Oppskrift = 'Oppskrift',
  Medialaben = 'Medialaben',
  Stoekk = 'Stoekk',
  Kode = 'Kode',
  Elbil24 = 'Elbil24'
}

export type WolverineAds = {
   __typename?: 'WolverineAds',
  by_id?: Maybe<WolverineAds_Ad>,
  by_ids?: Maybe<Array<Maybe<WolverineAds_Ad>>>,
};


export type WolverineAdsBy_IdArgs = {
  id: Scalars['String'],
  domain: Scalars['String'],
  path: Scalars['String']
};


export type WolverineAdsBy_IdsArgs = {
  id: Array<Scalars['String']>,
  domain: Scalars['String'],
  path: Scalars['String']
};

export type WolverineAds_Ad = {
   __typename?: 'WolverineAds_Ad',
  id: Scalars['String'],
  sizes: Scalars['String'],
  sizeMapping: Array<WolverineAds_Sizemapping>,
  adunit: Scalars['String'],
  targeting: Scalars['String'],
  collapse: Scalars['Boolean'],
  outOfPage: Scalars['Boolean'],
  lazyload: Scalars['Boolean'],
  width: Scalars['String'],
  height: Scalars['String'],
};

export type WolverineAds_Sizemapping = {
   __typename?: 'WolverineAds_Sizemapping',
  viewport: Scalars['String'],
  slot: Scalars['String'],
};
export type ArticlePreviewFragment = (
  { __typename?: 'Labrador_ArticlePreview' }
  & Pick<Labrador_ArticlePreview, 'id' | 'title' | 'subtitle' | 'publishedURL' | 'width'>
  & { metadata: Maybe<(
    { __typename?: 'Labrador_Metadata' }
    & Pick<Labrador_Metadata, 'showSubtitle'>
  )>, image: (
    { __typename?: 'Labrador_Image' }
    & Pick<Labrador_Image, 'id' | 'y' | 'x' | 'cropW' | 'cropH' | 'ratio'>
  ) }
);

export type FrontArticlesQueryVariables = {
  limit?: Maybe<Scalars['Int']>,
  offset?: Maybe<Scalars['Int']>,
  id: Scalars['Int'],
  dropzone?: Maybe<Scalars['String']>
};


export type FrontArticlesQuery = (
  { __typename?: 'Query' }
  & { labrador: Maybe<(
    { __typename?: 'Labrador' }
    & { front: Maybe<(
      { __typename?: 'Labrador_Front' }
      & { rows: Maybe<Array<Maybe<(
        { __typename?: 'Labrador_Row' }
        & { children: Maybe<Array<(
          { __typename: 'Labrador_ArticlePreview' }
          & Pick<Labrador_ArticlePreview, 'id' | 'title' | 'subtitle' | 'publishedURL' | 'width'>
          & { metadata: Maybe<(
            { __typename?: 'Labrador_Metadata' }
            & Pick<Labrador_Metadata, 'showSubtitle'>
          )>, image: (
            { __typename?: 'Labrador_Image' }
            & Pick<Labrador_Image, 'id' | 'y' | 'x' | 'cropW' | 'cropH' | 'ratio'>
          ) }
        ) | { __typename?: 'Labrador_Column' } | { __typename?: 'Labrador_Ad' } | { __typename?: 'Labrador_AutoArticlePlaceholder' } | { __typename?: 'Labrador_PersonalizedArticlePlaceholder' } | { __typename?: 'Labrador_FrontRows' } | { __typename?: 'Labrador_ContentMarketing' } | { __typename?: 'Labrador_Row' } | { __typename?: 'Labrador_Markup' } | { __typename?: 'Labrador_CustomElement' } | { __typename?: 'Labrador_JWVideo' } | { __typename?: 'Labrador_WolverineAd' } | { __typename?: 'Labrador_PersonalizedCampaign' } | { __typename?: 'Labrador_Image' } | { __typename?: 'Labrador_Instagram' }>> }
      )>>> }
    )> }
  )> }
);

export type FrontMetadataQueryVariables = {
  id?: Maybe<Scalars['Int']>,
  path?: Maybe<Scalars['String']>,
  siteId?: Maybe<Scalars['Int']>
};


export type FrontMetadataQuery = (
  { __typename?: 'Query' }
  & { labrador: Maybe<(
    { __typename?: 'Labrador' }
    & { front: Maybe<(
      { __typename?: 'Labrador_Front' }
      & Pick<Labrador_Front, 'id' | 'title' | 'published' | 'userName' | 'userEmail'>
    )> }
  )> }
);

export type SolXavierArticlesQueryVariables = {
  domain?: Maybe<Scalars['String']>,
  excludeIDs?: Maybe<Array<Maybe<Scalars['String']>>>,
  frontID?: Maybe<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>,
  preset?: Maybe<Scalars['String']>
};


export type SolXavierArticlesQuery = (
  { __typename?: 'Query' }
  & { recommendations: Maybe<(
    { __typename?: 'Recommendations' }
    & { articles: Maybe<Array<Maybe<(
      { __typename?: 'Article' }
      & Pick<Article, 'url' | 'cleanImage' | 'title' | 'preset' | 'subtitle' | 'secondaryTitle' | 'cerebroScore' | 'backgroundColor' | 'sectionTag' | 'fromFront' | 'dataLabel'>
    )>>> }
  )> }
);

export type XavierArticlesQueryVariables = {
  checkFront?: Maybe<Scalars['Boolean']>,
  contentLimit?: Maybe<Scalars['Int']>,
  videoLimit?: Maybe<Scalars['Int']>,
  domain?: Maybe<Scalars['String']>,
  excludeIDs?: Maybe<Array<Maybe<Scalars['String']>>>,
  excludeTags?: Maybe<Array<Maybe<Scalars['String']>>>,
  frontID?: Maybe<Scalars['String']>,
  limit?: Maybe<Scalars['Int']>,
  maxID?: Maybe<Scalars['Int']>,
  preset?: Maybe<Scalars['String']>,
  videoPreset?: Maybe<Scalars['String']>,
  tags?: Maybe<Array<Maybe<Scalars['String']>>>,
  playlistID?: Maybe<Scalars['String']>
};


export type XavierArticlesQuery = (
  { __typename?: 'Query' }
  & { recommendations: Maybe<(
    { __typename?: 'Recommendations' }
    & { contentMarketing: Maybe<Array<Maybe<(
      { __typename?: 'ContentMarketing' }
      & Pick<ContentMarketing, 'url' | 'cleanImage' | 'title' | 'preset' | 'secondaryTitle' | 'serveAd' | 'logoURL' | 'commercialPartner'>
    )>>>, articles: Maybe<Array<Maybe<(
      { __typename?: 'Article' }
      & Pick<Article, 'url' | 'cleanImage' | 'title' | 'preset' | 'subtitle' | 'secondaryTitle' | 'cerebroScore' | 'backgroundColor' | 'sectionTag' | 'fromFront'>
    )>>>, videos: Maybe<Array<Maybe<(
      { __typename?: 'Video' }
      & Pick<Video, 'url' | 'cleanImage' | 'title' | 'preset' | 'subtitle' | 'secondaryTitle' | 'cerebroScore'>
    )>>> }
  )> }
);
export const ArticlePreviewFragmentDoc = gql`
    fragment ArticlePreview on Labrador_ArticlePreview {
  id
  title
  subtitle
  publishedURL
  metadata {
    showSubtitle
  }
  width
  image {
    id
    y
    x
    cropW
    cropH
    ratio
  }
}
    `;
export const FrontArticlesDocument = gql`
    query frontArticles($limit: Int, $offset: Int, $id: Int!, $dropzone: String) {
  labrador {
    front(id: $id) {
      rows(limit: $limit, offset: $offset, dropzone: $dropzone) {
        children {
          __typename
          ... on Labrador_ArticlePreview {
            id
            title
            subtitle
            publishedURL
            metadata {
              showSubtitle
            }
            width
            image {
              id
              y
              x
              cropW
              cropH
              ratio
            }
          }
        }
      }
    }
  }
}
    `;

    export function useFrontArticlesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<FrontArticlesQuery, FrontArticlesQueryVariables>) {
      return ApolloReactHooks.useQuery<FrontArticlesQuery, FrontArticlesQueryVariables>(FrontArticlesDocument, baseOptions);
    }
      export function useFrontArticlesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<FrontArticlesQuery, FrontArticlesQueryVariables>) {
        return ApolloReactHooks.useLazyQuery<FrontArticlesQuery, FrontArticlesQueryVariables>(FrontArticlesDocument, baseOptions);
      }
      
export type FrontArticlesQueryHookResult = ReturnType<typeof useFrontArticlesQuery>;
export type FrontArticlesQueryResult = ApolloReactCommon.QueryResult<FrontArticlesQuery, FrontArticlesQueryVariables>;
export const FrontMetadataDocument = gql`
    query frontMetadata($id: Int, $path: String, $siteId: Int) {
  labrador {
    front(id: $id, path: $path, siteId: $siteId) {
      id
      title
      published
      userName
      userEmail
    }
  }
}
    `;

    export function useFrontMetadataQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<FrontMetadataQuery, FrontMetadataQueryVariables>) {
      return ApolloReactHooks.useQuery<FrontMetadataQuery, FrontMetadataQueryVariables>(FrontMetadataDocument, baseOptions);
    }
      export function useFrontMetadataLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<FrontMetadataQuery, FrontMetadataQueryVariables>) {
        return ApolloReactHooks.useLazyQuery<FrontMetadataQuery, FrontMetadataQueryVariables>(FrontMetadataDocument, baseOptions);
      }
      
export type FrontMetadataQueryHookResult = ReturnType<typeof useFrontMetadataQuery>;
export type FrontMetadataQueryResult = ApolloReactCommon.QueryResult<FrontMetadataQuery, FrontMetadataQueryVariables>;
export const SolXavierArticlesDocument = gql`
    query solXavierArticles($domain: String, $excludeIDs: [String], $frontID: String, $limit: Int, $preset: String) {
  recommendations {
    articles: sol(domain: $domain, preset: $preset, excludeIDs: $excludeIDs, limit: $limit, frontID: $frontID) {
      url
      cleanImage
      title
      preset
      subtitle
      secondaryTitle
      cerebroScore
      backgroundColor
      sectionTag
      fromFront
      dataLabel
    }
  }
}
    `;

    export function useSolXavierArticlesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<SolXavierArticlesQuery, SolXavierArticlesQueryVariables>) {
      return ApolloReactHooks.useQuery<SolXavierArticlesQuery, SolXavierArticlesQueryVariables>(SolXavierArticlesDocument, baseOptions);
    }
      export function useSolXavierArticlesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<SolXavierArticlesQuery, SolXavierArticlesQueryVariables>) {
        return ApolloReactHooks.useLazyQuery<SolXavierArticlesQuery, SolXavierArticlesQueryVariables>(SolXavierArticlesDocument, baseOptions);
      }
      
export type SolXavierArticlesQueryHookResult = ReturnType<typeof useSolXavierArticlesQuery>;
export type SolXavierArticlesQueryResult = ApolloReactCommon.QueryResult<SolXavierArticlesQuery, SolXavierArticlesQueryVariables>;
export const XavierArticlesDocument = gql`
    query xavierArticles($checkFront: Boolean, $contentLimit: Int, $videoLimit: Int, $domain: String, $excludeIDs: [String], $excludeTags: [String], $frontID: String, $limit: Int, $maxID: Int, $preset: String, $videoPreset: String, $tags: [String], $playlistID: String) {
  recommendations {
    contentMarketing(domain: $domain, limit: $contentLimit) {
      url
      cleanImage
      title
      preset
      secondaryTitle
      serveAd
      logoURL
      commercialPartner
    }
    articles(domain: $domain, preset: $preset, excludeIDs: $excludeIDs, excludeTags: $excludeTags, tags: $tags, limit: $limit, checkFront: $checkFront, frontID: $frontID, maxID: $maxID) {
      url
      cleanImage
      title
      preset
      subtitle
      secondaryTitle
      cerebroScore
      backgroundColor
      sectionTag
      fromFront
    }
    videos(domain: $domain, limit: $videoLimit, playslistID: $playlistID, preset: $videoPreset) {
      url
      cleanImage
      title
      preset
      subtitle
      secondaryTitle
      cerebroScore
    }
  }
}
    `;

    export function useXavierArticlesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<XavierArticlesQuery, XavierArticlesQueryVariables>) {
      return ApolloReactHooks.useQuery<XavierArticlesQuery, XavierArticlesQueryVariables>(XavierArticlesDocument, baseOptions);
    }
      export function useXavierArticlesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<XavierArticlesQuery, XavierArticlesQueryVariables>) {
        return ApolloReactHooks.useLazyQuery<XavierArticlesQuery, XavierArticlesQueryVariables>(XavierArticlesDocument, baseOptions);
      }
      
export type XavierArticlesQueryHookResult = ReturnType<typeof useXavierArticlesQuery>;
export type XavierArticlesQueryResult = ApolloReactCommon.QueryResult<XavierArticlesQuery, XavierArticlesQueryVariables>;