import gql from 'graphql-tag'

export default gql`
	query xavierArticles(
		$checkFront: Boolean
		$contentLimit: Int
		$videoLimit: Int
		$domain: String
		$excludeIDs: [String]
		$excludeTags: [String]
		$frontID: String
		$limit: Int
		$maxID: Int
		$preset: String
		$videoPreset: String
		$tags: [String]
		$playlistID: String
	) {
		recommendations {
			contentMarketing(domain: $domain, limit: $contentLimit) {
				url
				cleanImage
				title
				preset
				secondaryTitle
				serveAd
				logoURL
				commercialPartner
			}
			articles(
				domain: $domain
				preset: $preset
				excludeIDs: $excludeIDs
				excludeTags: $excludeTags
				tags: $tags
				limit: $limit
				checkFront: $checkFront
				frontID: $frontID
				maxID: $maxID
			) {
				url
				cleanImage
				title
				preset
				subtitle
				secondaryTitle
				cerebroScore
				backgroundColor
				sectionTag
				fromFront
			}
			videos(domain: $domain, limit: $videoLimit, playslistID: $playlistID, preset: $videoPreset) {
				url
				cleanImage
				title
				preset
				subtitle
				secondaryTitle
				cerebroScore
			}
		}
	}
`
