import gql from 'graphql-tag'

export default gql`
	query frontArticles($limit: Int, $offset: Int, $id: Int!, $dropzone: String) {
		labrador {
			front(id: $id) {
				rows(limit: $limit, offset: $offset, dropzone: $dropzone) {
					children {
						__typename
						... on Labrador_ArticlePreview {
							id
							title
							subtitle
							publishedURL
							metadata {
								showSubtitle
							}
							width
							image {
								id
								y
								x
								cropW
								cropH
								ratio
							}
						}
					}
				}
			}
		}
	}
`
