import React from 'react'
import PropTypes from 'prop-types'

import JW from './JW'
import Youtube from './Youtube'

const VideoTypes = {
	JW: 'JW',
	Youtube: 'Youtube',
}

const VideoWidget = ({ type, ...props }) => {
	return type === VideoTypes.Youtube ? <Youtube {...props} /> : <JW {...props} />
}

VideoWidget.propTypes = {
	type: PropTypes.oneOf(Object.values(VideoTypes)),
}

VideoWidget.defaultProps = {
	type: VideoTypes.JW,
}

export default VideoWidget
